console.log(`loading translations`);
var es_MX, en_US, pt_BR;

window.addEventListener('load', async function () {
    // Code to execute after all resources are loaded
    console.log('Page and all resources fully loaded');

    await loadlanguages();

    var fieldListen = setInterval(() => {
        var fields = document.querySelectorAll('.field[data-name] div.selectize-input')
        if (fields.length !== 0) {
            fields.forEach(ele => {
                if (ele.nextElementSibling.children[0].children.length == 0) {
                    ele.click();

                    setTimeout(() => {
                        ele.nextElementSibling.style.display = 'none'
                        this.clearInterval(fieldListen)
                    }, 50);
                }
            })
        } else {
            console.log('not rendered, retrying')
        }
    }, 500);

    var btnListen = setInterval(() => {
        var btns = document.querySelectorAll('button[id^="lang-"]')
        if (btns.length !== 0) {
            btns.forEach(langBTN => {
                langBTN.addEventListener('click', function () {
                    var selectedLingo = this.id.split('lang-')[1];

                    switch (selectedLingo) {
                        case "es_MX":
                            translate(es_MX)
                            document.querySelector('#subtitle').textContent = `Visibilidad Total y Gobernanza Inteligente`
                            document.querySelector('#textBody').textContent = `Obtenga control total sobre el consumo en la nube con información en tiempo real, previsiones de presupuesto y automatización inteligente. Con total transparencia sobre dónde se están realizando las inversiones, puede evitar sorpresas, reducir costos y simplificar la gestión de la infraestructura. `
                            document.querySelector('#ending').textContent = `Solicite acceso para su distribuidor o cliente final.`
                            document.querySelector('#decision').textContent = `Tome decisiones estratégicas y proactivas incluso antes de que llegue la factura.`
                            break;

                        case "en_US":
                            translate(en_US)
                            document.querySelector('#subtitle').textContent = `Complete Visibility and Smart Governance`
                            document.querySelector('#textBody').textContent = `Gain full control over cloud consumption with real-time insights, budget forecasts, and intelligent automation. With total transparency into where investments are being made, you can avoid surprises, reduce costs, and simplify infrastructure management.`
                            document.querySelector('#ending').textContent = `Request access for your reseller or end customer`
                            document.querySelector('#decision').textContent = `Make strategic and proactive decisions before the bill even arrives.`
                            document.querySelector('#btn-submit-ebla-form').textContent = "Send"
                            break;


                        case "pt_BR":
                            translate(pt_BR)
                            document.querySelector('#subtitle').textContent = `Visibilidade Total e Governança Inteligente`
                            document.querySelector('#textBody').textContent = `Tenha controle completo sobre o consumo em nuvem com insights em tempo real, previsões de orçamento e automação inteligente. Com total transparência sobre onde os investimentos estão sendo feitos, você evita surpresas, reduz custos e simplifica a gestão da infraestrutura. `
                            document.querySelector('#ending').textContent = `Solicite acesso para a sua revenda ou cliente final`
                            document.querySelector('#decision').textContent = `Tome decisões estratégicas e proativas antes mesmo da fatura chegar.`
                            document.querySelector('#btn-submit-ebla-form').textContent = "Enviar"
                            break;

                        default:
                            translate(es_MX)
                            document.querySelector('#subtitle').textContent = `Visibilidad Total y Gobernanza Inteligente`
                            document.querySelector('#textBody').textContent = `Obtenga control total sobre el consumo en la nube con información en tiempo real, previsiones de presupuesto y automatización inteligente. Con total transparencia sobre dónde se están realizando las inversiones, puede evitar sorpresas, reducir costos y simplificar la gestión de la infraestructura.`
                            document.querySelector('#ending').textContent = `Solicite acceso para su distribuidor o cliente final`
                            document.querySelector('#decision').textContent = `Tome decisiones estratégicas y proactivas incluso antes de que llegue la factura.`
                            document.querySelector('#btn-submit-ebla-form').textContent = "Enviar"
                            break;
                    }
                })
            })

            this.clearInterval(btnListen)
        } else {
            console.log('button not rendered, retrying')
        }
    }, 500)
});


async function loadlanguages() {
    try {
        const languages = ["es_MX", "en_US", "pt_BR"];
        const scopeDataPromises = languages.map(language =>
            make(`${window.location.origin}/api/v1/LabelManager/action/getScopeData`, "POST", JSON.stringify({ "scope": "CRegistration", "language": language }))
        );

        const [scopeDataES, scopeDataEN, scopeDataPT] = await Promise.all(scopeDataPromises);

        es_MX = scopeDataES;
        en_US = scopeDataEN;
        pt_BR = scopeDataPT;

        return true;
    } catch (error) {
        console.error("Erro:", error);
        throw error;
    }
}

function getFormParamValue(url, param) {
    return new Promise((resolve, reject) => {
        const urlSearchParams = new URLSearchParams(new URL(url).search);
        const formParamValue = urlSearchParams.get(param);

        if (formParamValue !== null) {
            resolve(formParamValue);
        } else {
            resolve(undefined);
        }
    });
}

function updateParamValue(url, param, newValue) {
    var urlparams = new URLSearchParams(new URL(url).search);
    urlparams.set(param, newValue)
    Cookies.set(param, newValue)

    const newURL = window.location.origin + window.location.pathname + '?' + urlparams.toString()
    history.pushState(null, '', newURL)
}

function make(url, method, data) {
    return fetch(url, {
        method: method,
        headers: {
            "Content-Type": "application/json",
            "Authorization": "Basic bHVjYXMuY2FtcG9zOlR1YmFyQDAx"
        },
        body: data
    })
        .then(response => {
            if (response.ok) {
                return response.json();
            } else if (response.status == 409) {
                return response.json().then(rsp => {
                    console.log('Conflict payload: ', rsp[0].id, rsp[0].name);
                    return rsp;
                });
            } else {
                return response.json().then(error => Promise.reject(error));
            }
        });
}

function translate(data) {
    return new Promise(function (resolve, reject) {
        var labels = document.querySelectorAll('label[data-name]')
        labels.forEach(function (element) {
            var translate = data.fields["fields[.]" + element.dataset.name];
            if (translate == undefined) {
                return
            }

            element.textContent = translate;

        })

        var options = document.querySelectorAll('div.option[data-value]')
        options.forEach(function (element) {
            var ancestor = [...Array(4)].reduce(e => e?.parentElement, element)
            // var translate = data.options[`options[.]${element.dataset.value}[.]${element.getAttribute('data-value')}`];
            var translate = data.options[`options[.]${ancestor.getAttribute('data-name')}[.]${element.dataset.value}`];
            if (translate == undefined) {
                return
            }
            element.textContent = translate;
            element.label = translate;
        })

        resolve(true)
    })
}