<!doctype html>
<html lang="en">

<head>
  <title>Fortinet</title>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" name="viewport" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
  <!--     Fonts and icons     -->
  <link rel="stylesheet" type="text/css"
    href="https://fonts.googleapis.com/css?family=Roboto:300,400,500,700|Roboto+Slab:400,700|Material+Icons" />
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/latest/css/font-awesome.min.css">
  <!-- Material Kit CSS -->
  <link href="assets/css/material-dashboard.css?v=2.1.0" rel="stylesheet" />
  <link href="assets/css/main.css" rel="stylesheet" />
</head>

<body>

  <div class="wrapper wrapper-full-page ">

    <div id="fortinet_conf" tabindex="-1" role="dialog">


      <div class="modal-header">
        <h5 class="modal-title">Configurador Fortinet</h5>
      </div>
      <div class="modal-body">

        <div class="container-fluid">
          <div class="row">
            <div class="col-md-4">
              <div class="card">
                <div class="card-header card-header-azure card-header-icon">
                  <div class="card-icon">
                    <img src="assets/img/azure_.png">
                  </div>
                  <h4 class="card-title">Quais produtos Azure?</h4>
                </div>
                <div class="card-body filtros">
                  <div id="accordion" role="tablist">
                    <div class="card-collapse">
                      <div class="card-header" role="tab" id="headingOne">
                        <h5 class="mb-0">
                          <a data-toggle="collapse" href="#collapseOne" aria-expanded="true" aria-controls="collapseOne"
                            class="collapsed">
                            Computação
                            <i class="material-icons">keyboard_arrow_down</i>
                          </a>
                        </h5>
                      </div>
                      <div id="collapseOne" class="collapse show" role="tabpanel" aria-labelledby="headingOne"
                        data-parent="#accordion">
                        <div class="card-body">
                          <table class="table">
                            <tbody>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                  <a href="#" class="filtro" data-filter=".seg, .visib, .webprot"></a>
                                </td>
                                <td> <span class="service-heading product" data-name="vm"><span class="icon"
                                      style="margin-right: 4px;"><svg id="virtual-machines" viewBox="0 0 51 47"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#7A7A7A"
                                          d="M32.9,36.9h-1.2H19.9h-0.6c1.6,5.7-0.6,6.6-10.2,6.6v3h12.2h8.9h11.5v-3 C32.2,43.5,31.3,42.7,32.9,36.9z">
                                        </path>
                                        <path fill="#3E3E3E"
                                          d="M47.5,0.5H3.2c-1.5,0-2.7,1.3-2.7,2.8v30.8c0,1.5,1.2,2.8,2.7,2.8h44.3c1.5,0,3-1.3,3-2.8V3.3 C50.5,1.8,49,0.5,47.5,0.5z M46.7,4.3v28.7H4.3V4.3l42.4-0.1L46.7,4.3z">
                                        </path>
                                        <polygon fill="#00BBF1" points="46.6,4.3 46.6,33.1 4.3,33.1 4.3,4.3 46.7,4.3">
                                        </polygon>
                                        <path fill="#7A7A7A"
                                          d="M4.3,33.1L4.3,33.1L4.3,4.3L43,4.3l4.5-3.8c0,0,0,0,0,0H3.2c-1.5,0-2.7,1.3-2.7,2.8v30.8 c0,1.5,1.2,2.8,2.7,2.8h1.1l4.6-3.8H4.3z">
                                        </path>
                                        <polygon fill="#59B4D9"
                                          points="4.3,33.1 4.3,33.1 4.3,4.3 43,4.3 43,4.3 4.3,4.3">
                                        </polygon>
                                        <rect x="9.2" y="43.5" fill="#B0B0B0" width="32.7" height="3"></rect>
                                        <circle fill="#BAC84A" cx="25.3" cy="2.6" r="0.7"></circle>
                                        <path opacity="0.9" fill="#FFFFFF"
                                          d="M25.5,18.2c0,0-0.1,0-0.1,0l-8.8-5.1c-0.1,0-0.1-0.1-0.1-0.2c0-0.1,0.1-0.2,0.1-0.2l8.7-5 c0.1,0,0.2,0,0.3,0l8.8,5.1c0.1,0,0.1,0.1,0.1,0.2c0,0.1,0,0.2-0.1,0.2l-8.7,5C25.6,18.2,25.5,18.2,25.5,18.2z">
                                        </path>
                                        <path opacity="0.8" fill="#FFFFFF"
                                          d="M24.2,30.5c0,0-0.1,0-0.1,0l-8.8-5c-0.1,0-0.1-0.1-0.1-0.2V15.1c0-0.1,0-0.2,0.1-0.2 c0.1,0,0.2,0,0.3,0l8.8,5c0.1,0,0.1,0.1,0.1,0.2v10.1c0,0.1-0.1,0.2-0.1,0.2C24.3,30.5,24.3,30.5,24.2,30.5z">
                                        </path>
                                        <path opacity="0.5" fill="#FFFFFF"
                                          d="M26.7,30.5c0,0-0.1,0-0.1,0c-0.1,0-0.1-0.1-0.1-0.2V20.2c0-0.1,0.1-0.2,0.1-0.2l8.8-5 c0.1,0,0.2,0,0.3,0c0.1,0,0.1,0.1,0.1,0.2v10.1c0,0.1-0.1,0.2-0.1,0.2l-8.8,5C26.8,30.5,26.7,30.5,26.7,30.5z">
                                        </path>
                                      </svg></span><!-- react-text: 180 -->Máquinas
                                    virtuais
                                    <!-- /react-text --></span></td>

                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                  <a href="#" class="filtro" data-filter=".seg, .contain, .webprot"></a>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="ic"><span class="icon"
                                      style="margin-right: 4px;"><svg id="container-instances" viewBox="0 0 160 160"
                                        role="presentation" aria-hidden="true">
                                        <path
                                          d="M114.978,31.772A32.577,32.577,0,0,0,56.009,14.548,25.789,25.789,0,0,0,15.231,41.306,24.494,24.494,0,0,0,25.314,88.116h82.96a28.573,28.573,0,0,0,6.7-56.344Z"
                                          transform="translate(-0.834 -1)" fill="#fff"></path>
                                        <path
                                          d="M114.978,31.772A32.577,32.577,0,0,0,56.009,14.548,25.789,25.789,0,0,0,15.231,41.306,24.494,24.494,0,0,0,25.314,88.116h82.96a28.573,28.573,0,0,0,6.7-56.344Z"
                                          transform="translate(-0.834 -1)" fill="#25a8e0 " opacity="0.6"
                                          style="isolation: isolate;"></path>
                                        <path
                                          d="M36.063,60.807a2.732,2.732,0,0,0-2.731,2.731v71a2.732,2.732,0,0,0,2.731,2.731H101.6a2.732,2.732,0,0,0,2.731-2.731v-71a2.732,2.732,0,0,0-2.731-2.731Z"
                                          transform="translate(-0.834 -1)" fill="#672a7b "></path>
                                        <path
                                          d="M36.063,60.807a2.732,2.732,0,0,0-2.731,2.731v71a2.732,2.732,0,0,0,2.731,2.731h8.193L93.412,60.807Z"
                                          transform="translate(-0.834 -1)" fill="#fff" opacity="0.15"
                                          style="isolation: isolate;"></path>
                                        <path d="M74.159,44.422" transform="translate(-0.834 -1)" fill="none">
                                        </path>
                                        <path d="M96.006,55.345" transform="translate(-0.834 -1)" fill="none">
                                        </path>
                                        <polygon
                                          points="62.538 59.807 62.538 40.691 54.345 40.691 68 21.574 81.655 40.691 73.462 40.691 73.462 59.807 62.538 59.807"
                                          fill="#fff"></polygon>
                                        <path d="M74.159,44.422" transform="translate(-0.834 -1)" fill="#804997 ">
                                        </path>
                                        <path
                                          d="M90.681,69H41.524v60.08H96.143V69ZM57.91,123.618H46.986V74.462H57.91Zm16.386,0H63.372V74.462H74.3Zm16.386,0H79.757V74.462H90.681Z"
                                          transform="translate(-0.834 -1)" fill="#b92025 " opacity="0.3"
                                          style="isolation: isolate;"></path>
                                        <path
                                          d="M90.681,69H41.524v60.08H96.143V69ZM57.91,123.618H46.986V74.462H57.91Zm16.386,0H63.372V74.462H74.3Zm16.386,0H79.757V74.462H90.681Z"
                                          transform="translate(-0.834 -1)" fill="#fff" style="isolation: isolate;">
                                        </path>
                                      </svg></span><!-- react-text: 458 -->Instâncias de contêiner
                                    <!-- /react-text --></span></td>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                    <div class="card-collapse">
                      <div class="card-header" role="tab" id="headingTwo">
                        <h5 class="mb-0">
                          <a class="collapsed" data-toggle="collapse" href="#collapseTwo" aria-expanded="false"
                            aria-controls="collapseTwo">
                            Databases
                            <i class="material-icons">keyboard_arrow_down</i>
                          </a>
                        </h5>
                      </div>
                      <div id="collapseTwo" class="collapse" role="tabpanel" aria-labelledby="headingTwo"
                        data-parent="#accordion">
                        <div class="card-body">
                          <table class="table" data-filter=".bdprot, .webprot">
                            <tbody>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="ca"><span class="icon"
                                      style="margin-right: 4px;"><svg id="storage" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#A0A1A2"
                                          d="M0,44.4c0,1,0.7,1.9,1.9,1.9h46.2c1,0,1.9-0.7,1.9-1.9V11.3H0V44.4z">
                                        </path>
                                        <path fill="#7A7A7A"
                                          d="M48.1,3.7H1.9C0.7,3.7,0,4.6,0,5.6v5.7h50V5.6C50,4.6,49.3,3.7,48.1,3.7">
                                        </path>
                                        <rect x="18.8" y="14.6" fill="#FFFFFF" width="12.6" height="7.6"></rect>
                                        <rect x="18.8" y="24.9" fill="#FCD116" width="12.6" height="7.6"></rect>
                                        <rect x="33.8" y="24.9" fill="#FCD116" width="12.6" height="7.6"></rect>
                                        <rect x="33.8" y="14.6" fill="#FFFFFF" width="12.6" height="7.6"></rect>
                                        <rect x="3.8" y="14.6" fill="#FFFFFF" width="12.6" height="7.6"></rect>
                                        <rect x="3.8" y="24.9" fill="#FFFFFF" width="12.6" height="7.6"></rect>
                                        <rect x="3.8" y="35.1" fill="#FCD116" width="12.6" height="7.6"></rect>
                                        <rect x="18.8" y="35.1" fill="#FCD116" width="12.6" height="7.6"></rect>
                                        <rect x="33.8" y="35.1" fill="#FCD116" width="12.6" height="7.6"></rect>
                                        <path opacity="0.2" fill="#FFFFFF" d="M1.9,3.7C1,3.7,0,4.6,0,5.6V13v3.3v28.1c0,1,1,1.9,1.9,1.9H4
                                               L43.6,3.7H1.9z"></path>
                                      </svg></span><!-- react-text: 201 -->Contas de
                                    armazenamento

                                    <!-- /react-text --></span>

                                </td>
                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="bdmysql"><span class="icon"
                                      style="margin-right: 4px;"><svg id="mysql" viewBox="0 0 84.08 111.43"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#005f87" d="M18,19.25v80.94c0,8.52,18.83,15.25,41.93,15.25V19.25Z"
                                          transform="translate(-18 -4)"></path>
                                        <path fill="#0f80b0"
                                          d="M59.48,115.43h.67c23.32,0,41.85-6.91,41.85-15.43V19l-42.52.25Z"
                                          transform="translate(-18 -4)"></path>
                                        <path fill="#fff"
                                          d="M102.08,19.25c0,8.3-18.83,15.25-41.93,15.25S18,27.54,18,19.25,36.83,4,59.93,4s42.15,7,42.15,15.25"
                                          transform="translate(-18 -4)"></path>
                                        <path fill="#7fb900"
                                          d="M93.56,18.35c0,5.61-15,10.09-33.41,10.09S26.52,24,26.52,18.35s15-10.09,33.41-10.09,33.63,4.48,33.63,10.09"
                                          transform="translate(-18 -4)"></path>
                                        <path fill="#b7d332"
                                          d="M86.38,24.4c4.48-1.79,7-3.81,7-6.05C93.34,12.74,78.39,8,60,8S26.52,12.74,26.52,18.35c0,2.24,2.69,4.48,7,6.05C39.53,21.94,49.24,21,60,21s20.33,1.16,26.39,3.4"
                                          transform="translate(-18 -4)"></path>
                                        <path fill="#fff"
                                          d="M93,77.05c0,4.78-3.26,8.87-8,8.95H67V79H83c1-.08,1.83-2.9,1.83-2.9L83,77H73c-4,0-7-2.35-7-6V70c0-6.14,0-8.93,0-10l-3-1V78H55l0-14.52L50.42,73.61C49.26,76.3,48.06,78,45,78a7.16,7.16,0,0,1-6.74-4.39L34,63V78H26l0-22.24c0-2.58.5-4.16,2.86-4.9a11.71,11.71,0,0,1,3.4-.58,6.3,6.3,0,0,1,6.11,3.91L45,67l5.34-12.81a6.32,6.32,0,0,1,6.1-3.91,12.7,12.7,0,0,1,3.36.54c2.37.75,3.2,2.6,3.2,5.18v2.77c0,.13-.13.23,0,.23H75V69a3,3,0,0,0,2,1h7V59h9V77.05Z"
                                          transform="translate(-18 -4)"></path>
                                      </svg></span><!-- react-text: 4355 -->Banco de Dados do Azure para MySQL
                                    <!-- /react-text --></span>

                                </td>
                              </tr>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="bdsa"><span class="icon"
                                      style="margin-right: 4px;"><svg id="sql-database" viewBox="0 0 49 49"
                                        role="presentation" aria-hidden="true">
                                        <path
                                          d="M6.89062 7.13281V41.3286C6.89062 44.8529 14.7966 47.8058 24.6076 47.8058V7.13281H6.89062Z"
                                          fill="#0072C5"></path>
                                        <path
                                          d="M24.418 47.8058H24.7037C34.5148 47.8058 42.4207 44.9482 42.4207 41.3286V7.13281H24.418V47.8058Z"
                                          fill="#0072C5"></path>
                                        <path
                                          d="M24.2266 47.8053H24.5123C34.4186 47.8053 42.5151 44.9477 42.5151 41.3281V7.03711H24.3218L24.2266 47.8053Z"
                                          fill="#3A93CE"></path>
                                        <path
                                          d="M42.4184 7.13344C42.4184 10.6578 34.5124 13.6106 24.7014 13.6106C14.8904 13.6106 6.98438 10.753 6.98438 7.13344C6.98438 3.51383 14.8904 0.65625 24.7014 0.65625C34.5124 0.65625 42.4184 3.60909 42.4184 7.13344Z"
                                          fill="#fff"></path>
                                        <path
                                          d="M38.8003 6.75122C38.8003 9.13254 32.5136 11.0376 24.7029 11.0376C16.8922 11.0376 10.6055 9.13254 10.6055 6.75122C10.6055 4.3699 16.8922 2.46484 24.7029 2.46484C32.5136 2.46484 38.8003 4.3699 38.8003 6.75122Z"
                                          fill="#7FB900"></path>
                                        <path
                                          d="M35.8475 9.32305C37.6573 8.56102 38.8003 7.70375 38.8003 6.75122C38.8003 4.3699 32.5136 2.46484 24.7029 2.46484C16.8922 2.46484 10.6055 4.3699 10.6055 6.75122C10.6055 7.70375 11.7485 8.65628 13.5583 9.32305C16.1301 8.27526 20.226 7.70375 24.7029 7.70375C29.1798 7.70375 33.2756 8.37052 35.8475 9.32305Z"
                                          fill="#B7D332"></path>
                                        <path
                                          d="M18.9868 30.8499C18.9868 31.8977 18.6058 32.755 17.8438 33.3265C17.0818 33.898 16.034 34.1838 14.6052 34.1838C13.4621 34.1838 12.5096 33.9933 11.7476 33.517V31.0404C12.6049 31.8025 13.6527 32.1835 14.7004 32.1835C15.1767 32.1835 15.653 32.0882 15.9387 31.8977C16.2245 31.7072 16.3197 31.4215 16.3197 31.0404C16.3197 30.6594 16.2245 30.3737 15.9387 30.1832C15.653 29.8974 15.0814 29.6117 14.2242 29.2306C12.5096 28.4686 11.6523 27.3256 11.6523 25.9921C11.6523 24.9443 12.0334 24.1822 12.7954 23.6107C13.5574 23.0392 14.5099 22.6582 15.7482 22.6582C16.796 22.6582 17.7485 22.8487 18.5105 23.1345V25.5158C17.7485 25.0395 16.8912 24.7538 15.9387 24.7538C15.4625 24.7538 15.0814 24.849 14.7957 25.0395C14.5099 25.23 14.4147 25.5158 14.4147 25.8968C14.4147 26.2778 14.5099 26.5636 14.7957 26.7541C14.9862 26.9446 15.4625 27.2303 16.2245 27.6113C17.2723 28.0876 18.0343 28.5639 18.5105 29.1354C18.7963 29.5164 18.9868 30.0879 18.9868 30.8499Z"
                                          fill="#fff"></path>
                                        <path
                                          d="M28.4183 28.4686C28.4183 27.3256 28.1325 26.4683 27.6563 25.8015C27.18 25.1348 26.5132 24.849 25.656 24.849C24.7987 24.849 24.0367 25.1348 23.5604 25.8015C22.9889 26.4683 22.7984 27.3256 22.7984 28.4686C22.7984 29.5164 23.0841 30.4689 23.5604 31.1357C24.0367 31.8025 24.7987 32.0882 25.656 32.0882C26.5132 32.0882 27.18 31.8025 27.7515 31.1357C28.1325 30.4689 28.4183 29.6117 28.4183 28.4686ZM31.0854 28.3734C31.0854 29.7069 30.7996 30.8499 30.2281 31.8025C29.6566 32.755 28.7993 33.4218 27.6563 33.8028L30.8949 36.8509H27.6563L25.3702 34.279C24.4177 34.279 23.4652 33.9933 22.7031 33.517C21.9411 33.0408 21.2743 32.374 20.8933 31.5167C20.4171 30.6594 20.2266 29.7069 20.2266 28.6591C20.2266 27.5161 20.4171 26.4683 20.8933 25.5158C21.3696 24.5633 22.0364 23.8965 22.8936 23.4202C23.7509 22.944 24.7034 22.6582 25.8465 22.6582C26.8943 22.6582 27.8468 22.8487 28.6088 23.325C29.4661 23.8012 30.0376 24.468 30.5139 25.3253C30.8949 26.2778 31.0854 27.2303 31.0854 28.3734Z"
                                          fill="#fff"></path>
                                        <path d="M39.6575 33.9922H32.8945V22.8477H35.4664V31.9919H39.6575V33.9922Z"
                                          fill="#fff"></path>
                                      </svg></span><!-- react-text: 219 -->Banco
                                    de dados SQL do Azure
                                    <!-- /react-text --></span>


                                </td>
                              </tr>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="acdb"><span class="icon"
                                      style="margin-right: 4px;"><svg id="cosmos-db" viewBox="0 0 50.035 46.007"
                                        role="presentation" aria-hidden="true">
                                        <path
                                          d="M41.545,20.885A16.527,16.527,0,1,1,21.625,8.7,16.457,16.457,0,0,1,41.545,20.885Z"
                                          transform="translate(-0.178 -0.234)" fill="#59b4d9"></path>
                                        <path
                                          d="M23.143,31.381A4.391,4.391,0,0,0,18.742,27h-.665a4.365,4.365,0,0,0-4.28-5.386H9.234A16.352,16.352,0,0,0,13.21,35.761h5.531A4.391,4.391,0,0,0,23.143,31.381Z"
                                          transform="translate(-0.178 -0.234)" fill="#fff" opacity="0.5"
                                          style="isolation: isolate;"></path>
                                        <path
                                          d="M28.594,13.218a2.942,2.942,0,0,0,.1.761h-1.9a4.561,4.561,0,1,0,0,9.122H41.9a16.165,16.165,0,0,0-8.546-12.835h-1.8A2.959,2.959,0,0,0,28.594,13.218Z"
                                          transform="translate(-0.178 -0.234)" fill="#fff" opacity="0.5"
                                          style="isolation: isolate;"></path>
                                        <path
                                          d="M41.9,26.491H32.888A3.724,3.724,0,0,0,29.155,30.2a3.686,3.686,0,0,0,.449,1.767,3.711,3.711,0,0,0,1.125,7.253h2.512A16.47,16.47,0,0,0,41.9,26.491Z"
                                          transform="translate(-0.178 -0.234)" fill="#fff" opacity="0.5"
                                          style="isolation: isolate;"></path>
                                        <path
                                          d="M6.974,13.767a.506.506,0,0,1-.508-.505A5.776,5.776,0,0,0,.685,7.5a.5.5,0,1,1,0-1.009A5.775,5.775,0,0,0,6.466.739a.508.508,0,0,1,1.015,0A5.776,5.776,0,0,0,13.263,6.5a.505.505,0,1,1,0,1.01,5.776,5.776,0,0,0-5.782,5.757A.507.507,0,0,1,6.974,13.767Z"
                                          transform="translate(-0.178 -0.234)" fill="#b8d432"></path>
                                        <path
                                          d="M42.628,46.241a.3.3,0,0,1-.3-.3A3.454,3.454,0,0,0,38.867,42.5a.3.3,0,1,1,0-.6,3.454,3.454,0,0,0,3.457-3.442.3.3,0,0,1,.607,0,3.454,3.454,0,0,0,3.457,3.442.3.3,0,1,1,0,.6,3.454,3.454,0,0,0-3.457,3.443A.3.3,0,0,1,42.628,46.241Z"
                                          transform="translate(-0.178 -0.234)" fill="#0072c6"></path>
                                        <path
                                          d="M49.555,9.9C47.978,7.316,44.014,6.719,38.1,8.168A47.134,47.134,0,0,0,32.669,9.9a16.666,16.666,0,0,1,3.2,2.045c1.007-.331,1.995-.629,2.937-.859a20.669,20.669,0,0,1,4.821-.683c1.938,0,3.007.479,3.364,1.062.585.957.047,3.484-3.393,7.458-.612.707-1.3,1.423-2.024,2.143A68.883,68.883,0,0,1,29.127,30.61a68.516,68.516,0,0,1-14.2,6.76c-5.987,1.95-10.075,1.911-10.991.414s.915-5.157,5.385-9.6a16.355,16.355,0,0,1-.367-3.847c-7.115,6.43-9.417,12-7.578,15.011.962,1.574,3.066,2.461,6.138,2.461a31.252,31.252,0,0,0,10.626-2.345A75.746,75.746,0,0,0,30.691,33.17a75.624,75.624,0,0,0,11.29-8.357,46.623,46.623,0,0,0,3.888-3.929C49.859,16.278,51.133,12.479,49.555,9.9Z"
                                          transform="translate(-0.178 -0.234)"></path>
                                      </svg></span><!-- react-text: 250 -->Azure
                                    Cosmos DB
                                    <!-- /react-text --></span>

                                </td>
                              </tr>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="bdap"><span class="icon"
                                      style="margin-right: 4px;"><svg id="postgresql" viewBox="0 0 37.727 50"
                                        role="presentation" aria-hidden="true">
                                        <path d="M0,6.841V43.159C0,46.982,8.451,50,18.813,50V6.841Z" fill="#3998c5">
                                        </path>
                                        <path d="M18.612,50h.3c10.463,0,18.813-3.018,18.813-6.841V6.841H18.612Z"
                                          fill="#59b3d8"></path>
                                        <path
                                          d="M37.727,6.841c0,3.724-8.451,6.841-18.813,6.841S0,10.563,0,6.841,8.451,0,18.813,0,37.727,3.119,37.727,6.841"
                                          fill="#fff"></path>
                                        <path
                                          d="M33.9,6.438c0,2.515-6.74,4.527-14.99,4.527S3.823,8.954,3.823,6.438s6.74-4.527,14.99-4.527S33.9,3.923,33.9,6.438"
                                          fill="#7fb900"></path>
                                        <path
                                          d="M30.684,9.154c2.012-.8,3.119-1.71,3.119-2.716,0-2.515-6.74-4.527-14.99-4.527S3.823,3.923,3.823,6.438c0,1.006,1.207,2.012,3.119,2.716,2.716-1.107,7.042-1.71,11.871-1.71a36.668,36.668,0,0,1,11.871,1.71"
                                          fill="#b7d332"></path>
                                        <path
                                          d="M29.465,33.817c-2.994.617-3.2-.4-3.2-.4,3.161-4.691,4.483-10.645,3.342-12.1-3.111-3.975-8.5-2.095-8.586-2.046l-.029.005a10.679,10.679,0,0,0-2-.208,4.936,4.936,0,0,0-3.162.946s-9.608-3.958-9.161,4.976c.1,1.9,2.725,14.384,5.861,10.613,1.146-1.379,2.254-2.544,2.254-2.544a2.908,2.908,0,0,0,1.9.485l.054-.045a2.093,2.093,0,0,0,.022.538c-.808.9-.571,1.061-2.186,1.394-1.634.337-.673.936-.048,1.093a3.32,3.32,0,0,0,3.706-1.2l-.048.19a5.4,5.4,0,0,1,.5,2.917,8.044,8.044,0,0,0,.187,2.812c.249.678.5,2.205,2.621,1.75a3.132,3.132,0,0,0,2.821-3.009c.09-1.167.3-1,.309-2.04l.165-.494c.19-1.584.03-2.095,1.122-1.857l.266.023a6.053,6.053,0,0,0,2.476-.417c1.331-.617,2.12-1.649.808-1.378Z"
                                          fill="#336790"></path>
                                        <path
                                          d="M16.826,25.98a1.274,1.274,0,0,0-.433-.135.928.928,0,0,0-.638.09.232.232,0,0,0-.1.155c-.028.2.269.576.641.628a.684.684,0,0,0,.09.006.7.7,0,0,0,.634-.407l.01-.035C17.043,26.218,17.029,26.091,16.826,25.98Z"
                                          fill="#fff"></path>
                                        <path
                                          d="M25.1,25.668a1.189,1.189,0,0,0-.43-.009c-.311.045-.612.184-.587.368l.005.018a.634.634,0,0,0,.578.371.649.649,0,0,0,.082-.005.758.758,0,0,0,.426-.234.487.487,0,0,0,.161-.325C25.32,25.766,25.236,25.7,25.1,25.668Z"
                                          fill="#fff"></path>
                                        <path
                                          d="M30.37,33.778c-.144-.442-.774-.31-.981-.267-2.109.435-2.7.006-2.823-.115a24.589,24.589,0,0,0,3.263-7.336c.583-2.333.572-4.184-.025-4.947a6.82,6.82,0,0,0-5.3-2.62,10.256,10.256,0,0,0-3.545.473l-.025.006-.04.014h0L20.858,19a8.253,8.253,0,0,0-1.877-.244,5.326,5.326,0,0,0-3.174.9,13.884,13.884,0,0,0-3.035-.763,6.277,6.277,0,0,0-4.487.808c-1.391.987-2.036,2.76-1.911,5.268.061,1.183,1.792,10.606,4.509,11.513a1.66,1.66,0,0,0,1.84-.732c.968-1.164,1.872-2.13,2.1-2.37A3.314,3.314,0,0,0,16.4,33.8a1.42,1.42,0,0,0,.013.167c-.1.113-.19.227-.285.348-.363.462-.449.571-1.626.814-.477.1-1.112.284-1.122.757s.654.77,1.046.867a3.574,3.574,0,0,0,3.643-.882,24.271,24.271,0,0,0,.351,5.6A2.607,2.607,0,0,0,20.924,43.4a4.022,4.022,0,0,0,.836-.095,3.167,3.167,0,0,0,2.913-2.961c.173-1,.473-3.431.6-4.654a3.085,3.085,0,0,0,1.122.17,6.206,6.206,0,0,0,2.356-.444C29.5,35.058,30.554,34.336,30.37,33.778Zm-5.588,1.3c-.052.683-.446,3.974-.652,5.167a2.646,2.646,0,0,1-2.487,2.519,2.105,2.105,0,0,1-2.717-1.5,29.554,29.554,0,0,1-.29-6.526.261.261,0,0,0-.028-.122,1.41,1.41,0,0,0-.051-.25,1.375,1.375,0,0,0-.675-.818l-.033-.017a1,1,0,0,0-.871-.052,7.083,7.083,0,0,1,.359-1.142l.056-.15c.064-.172.141-.343.224-.532.441-.98,1.044-2.32.387-5.356a1.847,1.847,0,0,0-2.233-1.5,5.445,5.445,0,0,0-2.112.753,8.094,8.094,0,0,1,1.855-4.94,4.581,4.581,0,0,1,3.455-1.3,7.126,7.126,0,0,1,5.2,2.271,8.431,8.431,0,0,1,1.9,3.12c-1.427-.171-2.386.085-2.858.759-1,1.436.583,4.281,1.346,5.649.13.233.265.474.307.576a5.055,5.055,0,0,0,.805,1.293,2.731,2.731,0,0,1,.269.372l-.065.018C25.469,33.479,24.714,33.691,24.782,35.076Zm-13.725.881c-.91-.3-1.92-2.128-2.844-5.137a32.865,32.865,0,0,1-1.288-5.878c-.115-2.309.449-3.921,1.679-4.792a4.988,4.988,0,0,1,2.906-.782,12.57,12.57,0,0,1,3.792.689h0c-.058.051-.118.1-.175.161-2.113,2.132-2.038,5.794-2.034,5.948v.018a17.6,17.6,0,0,1-.062,3.425,3.766,3.766,0,0,0,.992,3.153,3.283,3.283,0,0,0,.337.3c-.346.368-1.17,1.261-2.06,2.333h0C11.872,35.909,11.464,36.092,11.057,35.957Zm2.519-6.279a18,18,0,0,0,.07-3.455,4.21,4.21,0,0,1,2.8-.873,1.212,1.212,0,0,1,1.019,1.06c.618,2.859.081,4.054-.352,5.015-.083.185-.169.376-.24.565l-.056.15a8.794,8.794,0,0,0-.361,1.109,2.717,2.717,0,0,1-2.041-.868A3.226,3.226,0,0,1,13.576,29.678Zm3.368,4.508a.269.269,0,0,0,.026-.033.459.459,0,0,1,.61-.148l.045.023a.841.841,0,0,1,.365,1.1,3.051,3.051,0,0,1-3.414,1.1h0a1.468,1.468,0,0,1-.639-.314,1.531,1.531,0,0,1,.673-.242c1.314-.269,1.5-.446,1.947-1.012.1-.128.224-.285.39-.47Zm8.43-2.713c-.052-.127-.168-.334-.328-.622l-.007-.012c-.653-1.171-2.182-3.913-1.375-5.067a1.829,1.829,0,0,1,1.585-.575,6.573,6.573,0,0,1,.866.065,7.15,7.15,0,0,1-.109,1.149,9.552,9.552,0,0,0-.13,1.216,9.135,9.135,0,0,0,.1,1.378,4.869,4.869,0,0,1-.309,3.027A3.671,3.671,0,0,1,25.375,31.473Zm3.756-4.986a27.62,27.62,0,0,1-2.865,6.361c-.045-.064-.1-.135-.17-.22l-.064-.082-.018-.022a5.11,5.11,0,0,0,.5-3.595,8.686,8.686,0,0,1-.092-1.287,9.194,9.194,0,0,1,.125-1.154,6.974,6.974,0,0,0,.114-1.407.459.459,0,0,0,.015-.179,8.566,8.566,0,0,0-4.906-5.609c4.478-1.094,6.8,1.136,7.6,2.154.6.763.511,2.553-.239,5.039Zm-3.1,7.4a1.611,1.611,0,0,0,.2-.066,1.354,1.354,0,0,0,.14.107,4.469,4.469,0,0,0,3.136.114,1.71,1.71,0,0,1,.288-.038,3.572,3.572,0,0,1-1.266.9,4.911,4.911,0,0,1-3.123.231c-.054-.032-.066-.055-.067-.061-.056-.972.325-1.079.7-1.183Z"
                                          fill="#fff"></path>
                                      </svg></span><!-- react-text: 3815 -->Banco de Dados do
                                    Azure para PostgreSQL
                                    <!-- /react-text --></span>

                                </td>
                              </tr>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                    <div class="card-collapse">
                      <div class="card-header" role="tab" id="headingThree">
                        <h5 class="mb-0">
                          <a class="collapsed" data-toggle="collapse" href="#collapseThree" aria-expanded="false"
                            aria-controls="collapseThree">
                            Rede
                            <i class="material-icons">keyboard_arrow_down</i>
                          </a>
                        </h5>
                      </div>
                      <div id="collapseThree" class="collapse" role="tabpanel" aria-labelledby="headingThree"
                        data-parent="#accordion">
                        <div class="card-body">
                          <table class="table">
                            <tbody>
                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="faz"><span class="icon"
                                      style="margin-right: 4px;"><svg id="azure-firewall" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#59B4D9"
                                          d="M19.55,10.14C20.476,4.448,25.381,0.1,31.311,0.1c6.589,0,11.931,5.364,11.931,11.981
                                              c0,0.768-0.079,1.516-0.216,2.244c3.86,0.43,6.874,3.975,6.874,8.293c0,4.608-3.452,8.383-7.683,8.383c-0.942,0-21.95,0-21.95,0
                                              C14.673,31,10.1,26.182,10.1,20.401C10.1,14.983,14.264,10.564,19.55,10.14z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#DD5900" d="M15,28c-0.552,0-1-0.447-1-1v-5c0-0.552,0.448-1,1-1h11
                                              c0.552,0,1,0.448,1,1v5c0,0.553-0.448,1-1,1H15z"></path>
                                        <path fill="#A0A1A2" d="M26,22v5H15v-5H26 M26,20H15c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C28,20.895,27.105,20,26,20L26,20z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M28,28c-0.553,0-1-0.447-1-1v-5c0-0.552,0.447-1,1-1h11
                                              c0.553,0,1,0.448,1,1v5c0,0.553-0.447,1-1,1H28z"></path>
                                        <path fill="#A0A1A2" d="M39,22v5H28v-5H39 M39,20H28c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C41,20.895,40.105,20,39,20L39,20z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M2,28c-0.552,0-1-0.447-1-1v-5c0-0.552,0.448-1,1-1h11
                                              c0.552,0,1,0.448,1,1v5c0,0.553-0.448,1-1,1H2z"></path>
                                        <path fill="#A0A1A2" d="M13,22v5H2v-5H13 M13,20H2c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C15,20.895,14.105,20,13,20L13,20z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M15,35c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H15z"></path>
                                        <path fill="#A0A1A2" d="M26,29v5H15v-5H26 M26,27H15c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C28,27.895,27.105,27,26,27L26,27z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#DD5900" d="M2,42c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H2z"></path>
                                        <path fill="#A0A1A2" d="M13,36v5H2v-5H13 M13,34H2c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C15,34.895,14.105,34,13,34L13,34z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M2,35c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H2z"></path>
                                        <path fill="#A0A1A2" d="M13,29v5H2v-5H13 M13,27H2c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C15,27.895,14.105,27,13,27L13,27z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M15,49c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H15z"></path>
                                        <path fill="#A0A1A2" d="M26,43v5H15v-5H26 M26,41H15c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C28,41.895,27.105,41,26,41L26,41z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M28,42c-0.553,0-1-0.447-1-1v-5c0-0.553,0.447-1,1-1h11
                                              c0.553,0,1,0.447,1,1v5c0,0.553-0.447,1-1,1H28z"></path>
                                        <path fill="#A0A1A2" d="M39,36v5H28v-5H39 M39,34H28c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C41,34.895,40.105,34,39,34L39,34z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M28,35c-0.553,0-1-0.447-1-1v-5c0-0.553,0.447-1,1-1h11
                                              c0.553,0,1,0.447,1,1v5c0,0.553-0.447,1-1,1H28z"></path>
                                        <path fill="#A0A1A2" d="M39,29v5H28v-5H39 M39,27H28c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C41,27.895,40.105,27,39,27L39,27z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M15,42c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H15z"></path>
                                        <path fill="#A0A1A2" d="M26,36v5H15v-5H26 M26,34H15c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C28,34.895,27.105,34,26,34L26,34z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#DD5900" d="M28,49c-0.553,0-1-0.447-1-1v-5c0-0.553,0.447-1,1-1h11
                                              c0.553,0,1,0.447,1,1v5c0,0.553-0.447,1-1,1H28z"></path>
                                        <path fill="#A0A1A2" d="M39,43v5H28v-5H39 M39,41H28c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C41,41.895,40.105,41,39,41L39,41z"></path>
                                        <path fill-rule="evenodd" clip-rule="evenodd" fill="#BA141A" d="M2,49c-0.552,0-1-0.447-1-1v-5c0-0.553,0.448-1,1-1h11
                                              c0.552,0,1,0.447,1,1v5c0,0.553-0.448,1-1,1H2z"></path>
                                        <path fill="#A0A1A2" d="M13,43v5H2v-5H13 M13,41H2c-1.105,0-2,0.895-2,2v5c0,1.105,0.895,2,2,2h11c1.105,0,2-0.895,2-2v-5
                                              C15,41.895,14.105,41,13,41L13,41z"></path>
                                      </svg></span><!-- react-text: 49470 -->Firewall do Azure
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="epr"><span class="icon"
                                      style="margin-right: 4px;"><svg id="expressroute" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <rect x="9.8" y="32.8" fill="#68217A" width="31" height="3.8"></rect>
                                        <rect x="4.4" y="23.4"
                                          transform="matrix(0.7071 -0.7071 0.7071 0.7071 -13.5374 18.0172)"
                                          fill="#68217A" width="21.2" height="3.8"></rect>
                                        <rect x="24.5" y="23.4"
                                          transform="matrix(0.7071 0.7071 -0.7071 0.7071 28.2012 -17.3844)"
                                          fill="#68217A" width="21.2" height="3.8"></rect>
                                        <path fill="#7FBA00"
                                          d="M25,9.7c-3.1,0-5.6,2.5-5.6,5.6c0,3.1,2.5,5.6,5.6,5.6s5.6-2.5,5.6-5.6C30.6,12.2,28.1,9.7,25,9.7z M25,17.1 c-1,0-1.8-0.8-1.8-1.8s0.8-1.8,1.8-1.8s1.8,0.8,1.8,1.8S26,17.1,25,17.1z">
                                        </path>
                                        <path fill="#7FBA00"
                                          d="M5.6,29.1c-3.1,0-5.6,2.5-5.6,5.6c0,3.1,2.5,5.6,5.6,5.6s5.6-2.5,5.6-5.6C11.2,31.6,8.7,29.1,5.6,29.1z M5.6,36.5c-1,0-1.8-0.8-1.8-1.8s0.8-1.8,1.8-1.8s1.8,0.8,1.8,1.8S6.6,36.5,5.6,36.5z">
                                        </path>
                                        <path fill="#7FBA00"
                                          d="M44.4,29.1c-3.1,0-5.6,2.5-5.6,5.6c0,3.1,2.5,5.6,5.6,5.6s5.6-2.5,5.6-5.6C50,31.6,47.5,29.1,44.4,29.1z M44.4,36.5c-1,0-1.8-0.8-1.8-1.8s0.8-1.8,1.8-1.8s1.8,0.8,1.8,1.8S45.4,36.5,44.4,36.5z">
                                        </path>
                                      </svg></span><!-- react-text: 17814 -->ExpressRoute
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="vn"><span class="icon"
                                      style="margin-right: 4px;"><svg id="virtual-network" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#3999C6"
                                          d="M49.7,25.7c0.5-0.5,0.4-1.3,0-1.8l-2.4-2.4L36.5,11c-0.5-0.5-1.2-0.5-1.7,0l0,0c-0.5,0.5-0.6,1.3,0,1.8 l11.3,11.1c0.5,0.5,0.5,1.3,0,1.8L34.6,37.2c-0.5,0.5-0.5,1.3,0,1.8l0,0c0.5,0.5,1.3,0.4,1.7,0l10.7-10.6c0,0,0,0,0.1-0.1L49.7,25.7 z">
                                        </path>
                                        <path fill="#3999C6"
                                          d="M0.3,25.7c-0.5-0.5-0.4-1.3,0-1.8l2.4-2.4L13.5,11c0.5-0.5,1.2-0.5,1.7,0l0,0c0.5,0.5,0.6,1.3,0,1.8 L4.1,23.9c-0.5,0.5-0.5,1.3,0,1.8l11.3,11.5c0.5,0.5,0.5,1.3,0,1.8l0,0c-0.5,0.5-1.3,0.4-1.7,0L2.8,28.5c0,0,0,0-0.1-0.1L0.3,25.7z">
                                        </path>
                                        <path fill="#7FBA00"
                                          d="M18.2,24.8c0,1.9-1.6,3.3-3.3,3.3s-3.5-1.6-3.5-3.3s1.4-3.3,3.5-3.3C16.9,21.5,18.2,23.1,18.2,24.8z">
                                        </path>
                                        <path fill="#7FBA00"
                                          d="M28.3,24.8c0,1.9-1.6,3.3-3.3,3.3s-3.5-1.6-3.5-3.3s1.6-3.3,3.5-3.3S28.3,23.1,28.3,24.8z">
                                        </path>
                                        <circle fill="#7FBA00" cx="35.2" cy="24.8" r="3.3"></circle>
                                      </svg></span><!-- react-text: 519 -->Rede Virtual
                                    <!-- /react-text --></span>

                                </td>

                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="adns"><span class="icon"
                                      style="margin-right: 4px;"><svg id="azure" viewBox="0 0 16 16" role="presentation"
                                        aria-hidden="true">
                                        <polygon points="3.65 14.2 16 14.2 9.35 2.68 7.33 8.24 11.21 12.87 3.65 14.2">
                                        </polygon>
                                        <polygon points="8.82 1.8 4.07 5.79 0 12.84 3.67 12.84 3.67 12.85 8.82 1.8">
                                        </polygon>
                                      </svg></span><!-- react-text: 28969 -->Azure DNS
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="lb"><span class="icon"
                                      style="margin-right: 4px;"><svg id="load-balancer" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#7FBA00"
                                          d="M25.001,50c-1.232,0-2.392-0.48-3.261-1.352L1.351,28.26C0.492,27.401,0,26.214,0,24.999 c0-1.214,0.492-2.402,1.351-3.26L21.74,1.351c0.871-0.872,2.029-1.352,3.261-1.352c1.231,0,2.39,0.48,3.261,1.352l20.386,20.388 C49.521,22.607,50,23.766,50,24.999c0,1.233-0.479,2.392-1.353,3.263L28.262,48.648C27.392,49.52,26.232,50,25.001,50">
                                        </path>
                                        <path fill="#FFFFFF"
                                          d="M45.613,24.66L39,18.048v4.668l-7.016-0.006c-0.677-2.418-2.573-4.328-4.984-5.02V11h4.613L25,4.387 L18.388,11H23v6.689c-2.407,0.692-4.301,2.596-4.981,5.008L11,22.691v-4.618l-6.613,6.613L11,31.298V26.63l7.022,0.006 c0.683,2.407,2.574,4.305,4.978,4.996v4.636c-1,0.728-2.528,2.258-2.528,4.04c0,2.481,2.033,4.5,4.514,4.5s4.51-2.019,4.51-4.5 c0-1.762-1.496-3.274-2.496-4.013v-4.663c2.399-0.689,4.289-2.583,4.975-4.983L39,26.655v4.618L45.613,24.66z">
                                        </path>
                                        <path fill="#59B4D9"
                                          d="M25,19.402c-2.899,0-5.258,2.359-5.258,5.258s2.359,5.258,5.258,5.258s5.258-2.358,5.258-5.258 S27.899,19.402,25,19.402z">
                                        </path>
                                        <path opacity="0.15" fill="#FFFFFF"
                                          d="M28.262,1.351c-0.871-0.872-2.029-1.352-3.261-1.352c-1.231,0-2.389,0.48-3.26,1.352 L1.352,21.739C0.492,22.597,0,23.785,0,24.999c0,1.215,0.492,2.403,1.352,3.261l11.543,11.544L34.61,7.698L28.262,1.351z">
                                        </path>
                                      </svg></span><!-- react-text: 28935 -->Load Balancer
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                    <div class="card-collapse">
                      <div class="card-header" role="tab" id="headingFour">
                        <h5 class="mb-0">
                          <a class="collapsed" data-toggle="collapse" href="#collapseFour" aria-expanded="false"
                            aria-controls="collapseFour">
                            Segurança
                            <i class="material-icons">keyboard_arrow_down</i>
                          </a>
                        </h5>
                      </div>
                      <div id="collapseFour" class="collapse" role="tabpanel" aria-labelledby="headingFour"
                        data-parent="#accordion">
                        <div class="card-body">
                          <table class="table">
                            <tbody>



                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="cds"><span class="icon"
                                      style="margin-right: 4px;"><svg id="security-center" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#7FBA00"
                                          d="M38.185,5.96L38.185,5.96C27.169,4.745,25.326,0,25.326,0S22.847,6.242,7,6.242v25.611 c0,3.097,1.721,5.997,4.104,8.532l0,0c5.402,5.748,14.223,9.616,14.223,9.616s18.327-8.029,18.327-18.149V6.242 C41.616,6.242,39.803,6.139,38.185,5.96z">
                                        </path>
                                        <path opacity="0.4" fill="#B8D432"
                                          d="M29.86,16.543L38.185,5.96C27.169,4.745,25.326,0,25.326,0S22.847,6.242,7,6.242v25.611 c0,3.097,1.721,5.997,4.104,8.532l6.154-7.822L29.86,16.543z">
                                        </path>
                                        <path fill="#FFFFFF"
                                          d="M32.595,24.46h-1.066v-3.552c0-1.709-0.629-3.276-1.669-4.45l0,0c-0.039-0.043-0.074-0.09-0.112-0.133 c-1.107-1.186-2.683-1.948-4.422-1.947c-1.736-0.001-3.312,0.761-4.419,1.947c-1.11,1.187-1.783,2.811-1.783,4.582v3.553h-1.065 c-0.443,0-0.801,0.359-0.801,0.801v7.217l0,0.001v2.174c0,0.442,0.359,0.801,0.801,0.801h14.536c0.442,0,0.801-0.359,0.801-0.801 v-9.391C33.396,24.818,33.037,24.46,32.595,24.46z M28.584,24.461h-5.02l0.001-0.001H22.07v-3.552c0-1.022,0.386-1.927,0.988-2.57 c0.605-0.643,1.395-1.013,2.268-1.013c0.874,0,1.665,0.37,2.27,1.013c0.143,0.153,0.271,0.323,0.389,0.504l-0.001,0.001 c0.373,0.579,0.6,1.288,0.6,2.064V24.461z">
                                        </path>
                                      </svg></span><!-- react-text: 36198 -->Central de Segurança
                                    <!-- /react-text --></span>
                                </td>
                              </tr>


                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="gvpn"><span class="icon"
                                      style="margin-right: 4px;"><svg id="vpn-gateway" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#A0A1A2"
                                          d="M42.1,18.5L42.1,18.5v-2.2c0-4.4-1.6-8.5-4.4-11.4C35.1,1.9,29.3,0,25,0S14.9,1.9,12.3,4.9 c-2.7,2.9-4.4,7-4.4,11.4v2.2l0,0l7.9,0.9v-2c0-2.6,0.9-5.9,2.4-7.6s4.7-2.5,6.8-2.6c2.1,0,5.3,0.9,6.8,2.6s2.4,3.9,2.4,6.4v3.2 L42.1,18.5z">
                                        </path>
                                        <path fill="#59B4D9"
                                          d="M7.9,18.5L7.9,18.5c-3.9,0-5.3,2.3-5.3,5.3v20.9c0,2.6,1.6,5.3,4.6,5.3h35.6c3.4,0,4.6-2.7,4.6-5.3V23.8 c0-2.7-1.1-5.3-5.3-5.3l0,0H7.9z">
                                        </path>
                                        <path opacity="0.15" fill="#FFFFFF"
                                          d="M34.1,18.5L34.1,18.5H7.9l0,0c-3.9,0-5.3,2.3-5.3,5.3v20.9c0,2.6,1.6,5.3,4.6,5.3h6.7 L34.1,18.5z">
                                        </path>
                                        <path fill="#FFFFFF"
                                          d="M19,27.1l5.8-5.8l5.8,5.8h-4.1v4.2H23v-4.2C23,27.1,19,27.1,19,27.1z M8.3,35.9v-3.4h6v-4l5.6,5.6l-5.6,5.6 v-3.9h-6V35.9z M24.8,47.2l-5.9-5.9H23v-4.1h3.5v4.1h4.2L24.8,47.2z M41.3,35.9h-6v4l-5.7-5.7l5.7-5.7v4h6V35.9z">
                                        </path>
                                      </svg></span><!-- react-text: 15361 -->Gateway VPN
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                              <tr>
                                <td>
                                  <div class="form-check">
                                    <a href="#" class="product">
                                      <label class="form-check-label">
                                        <input class="form-check-input" type="checkbox" value="">
                                        <span class="form-check-sign">
                                          <span class="check"></span>
                                        </span>
                                      </label>
                                    </a>
                                  </div>
                                </td>
                                <td>
                                  <span class="service-heading product" data-name="gapp"><span class="icon"
                                      style="margin-right: 4px;"><svg id="application-gateway" viewBox="0 0 50 50"
                                        role="presentation" aria-hidden="true">
                                        <path fill="#0072c6"
                                          d="M48.6,21.7L28.3,1.4C27.4,0.5,26.2,0,25,0c-1.2,0-2.4,0.5-3.3,1.4L1.4,21.7C0.5,22.6,0,23.8,0,25 c0,1.2,0.5,2.4,1.4,3.3l20.4,20.4c0.9,0.9,2,1.4,3.3,1.4c1.2,0,2.4-0.5,3.3-1.4l20.4-20.4c0.9-0.9,1.4-2,1.4-3.3 C50,23.8,49.5,22.6,48.6,21.7z M25,4.8l6.6,6.6H27V21h-3.9v-9.6h-4.7L25,4.8z M6.4,27.4v-3.9h9v-4.7l6.6,6.6L15.4,32v-4.6H6.4z M25,46l-6.6-6.6H23V30h3.9v9.4h4.7L25,46z M43.6,27.4h-8.9v4.7l-6.6-6.6l6.6-6.6v4.6h8.9V27.4z">
                                        </path>
                                      </svg></span><!-- react-text: 28945 -->Gateway de Aplicativo
                                    <!-- /react-text --></span>
                                </td>
                              </tr>

                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-8">
              <div class="card ">
                <div class="card-header card-header-azure card-header-icon">
                  <div class="card-icon">
                    <i class="material-icons">cloud_queue</i>
                  </div>
                  <h4 class="card-title">Sua infraestrutura</h4>
                </div>
                <div class="card-body ">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="table-responsive">
                        <table class="table">
                          <tbody>
                            <tr>
                              <td id="estrutura">

                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </div>
                    </div>

                  </div>
                  <div class="row">
                    <div class="grid">
                      <span class="text-primary seg" data-category="green">
                        Segmentação, Isolamento da Rede
                      </span>
                      <span class="text-info visib" data-category="yellow">
                        Visibilidade
                      </span>
                      <span class="text-success webprot" data-category="red">
                        Proteção da aplicação Web
                      </span>
                      <span class="text-muted bdprot" data-category="brown">
                        Proteção do Banco de Dados
                      </span>
                      <span class="text-warning vpn" data-category="blue">
                        VPN com proteção de tráfego
                      </span>
                      <span class="text-danger contain" data-category="gray">
                        Proteção avançada para Container
                      </span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-md-12">
              <div class="card hide" id="solutions">
                <div class="card-header card-header-fortinet card-header-icon">
                  <div class="card-icon">
                    <img src="assets/img/fortinetlogo.png">
                  </div>
                  <h4 class="card-title">Saiba mais sobre as soluções Fortinet</h4>
                </div>
                <div class="card-body">
                  <div class="row">
                    <div class="page-categories">
                      <ul class="nav nav-pills nav-pills-warning nav-pills-icons justify-content-center" role="tablist">
                        <li class="nav-item hide">
                          <a class="nav-link" data-toggle="tab" href="#fortigate" role="tablist">
                            <img src="assets/img/fortinetlogo.png"><br>
                            FortiGate
                          </a>
                        </li>
                        <li class="nav-item hide">
                          <a class="nav-link" data-toggle="tab" href="#fortiweb" role="tablist">
                            <img src="assets/img/fortinetlogo.png"><br> FortiWeb
                          </a>
                        </li>
                        <li class="nav-item hide">
                          <a class="nav-link" data-toggle="tab" href="#fortianalyzer" role="tablist">
                            <img src="assets/img/fortinetlogo.png"><br> FortiAnalyzer
                          </a>
                        </li>
                        <li class="nav-item hide">
                          <a class="nav-link" data-toggle="tab" href="#fortimanager" role="tablist">
                            <img src="assets/img/fortinetlogo.png"><br> FortiManager
                          </a>
                        </li>
                      </ul>
                      <div class="tab-content tab-space tab-subcategories">
                        <div class="tab-pane" id="fortigate">
                          <div class="">
                            <div class="card-header">
                              <h4 class="card-title">FortiGate: </h4>
                              <p class="card-category">
                                Visão geral da Next-Generation Firewall
                              </p>
                            </div>
                            <div class="card-body">
                              <div class="texto">
                                <p>À medida que os arquitetos de segurança refletem em como
                                  fornecer proteção abrangente
                                  contra ameaças para suas empresas, incluindo prevenção de
                                  intrusões, web filtering,
                                  antimalware e application control, eles enfrentam um grande
                                  obstáculo à complexidade ao
                                  gerenciar esses produtos pontuais sem integração e falta de
                                  visibilidade. A Gartner estima
                                  que, até 2019, 80% do tráfego empresarial será criptografado
                                  e 50% dos ataques
                                  direcionados às empresas serão ocultados no tráfego
                                  criptografado.</p>
                                <p>O firewall de próxima geração do FortiGate utiliza
                                  processadores de segurança para fins
                                  específicos e serviços de segurança de inteligência contra
                                  ameaças do FortiGuard Labs para
                                  fornecer proteção de alto nível e alto desempenho, incluindo
                                  tráfego criptografado. O
                                  FortiGate reduz a complexidade com visibilidade automatizada
                                  de aplicativos, usuários e
                                  rede e fornece classificações de segurança para adotar as
                                  melhores práticas de
                                  segurança.&nbsp;</p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="tab-pane" id="fortiweb">
                          <div class="">
                            <div class="card-header">
                              <h4 class="card-title">FortiWeb: </h4>
                              <p class="card-category">
                                Firewall de Aplicações Web (WAF)
                              </p>
                            </div>
                            <div class="card-body">
                              <div class="texto">
                                <p>Os aplicativos web não protegidos são o ponto de entrada mais
                                  fácil para os hackers e são vulneráveis a diversos tipos de
                                  ataques. A abordagem aprimorada de inteligência artificial e
                                  multicamada do FortiWeb protege seus aplicativos web contra
                                  as dez principais ameaças do OWASP e de muitas outras.
                                  Quando combinada com nosso Serviço de segurança de
                                  aplicativos web do FortiGuard Labs, você fica protegido
                                  contra as mais recentes vulnerabilidades dos aplicativos,
                                  bots e URL suspeitos. Além disso, com o mecanismo duplo de
                                  detecção de aprendizado de máquina, seus aplicativos ficam
                                  protegidos contra ameaças sofisticadas, como injeção de SQL,
                                  script entre sites, estouros de buffer, envenenamento de
                                  cookies, fontes maliciosas e ataques de DoS.</p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="tab-pane" id="fortianalyzer">
                          <div class="">
                            <div class="card-header">
                              <h4 class="card-title">FortiAnalyzer: </h4>
                              <p class="card-category">
                                Gerenciamento de segurança orientado por análises
                              </p>
                            </div>
                            <div class="card-body">
                              <div class="texto">
                                <p>A falta de visibilidade continua aumentando a violação e
                                  comprometendo uma média de mais de 100 dias. Para cada dia
                                  que uma organização é exposta, significa outra oportunidade
                                  para os invasores obterem informações confidenciais e de
                                  clientes confidenciais.</p>
                                <p> O FortiAnalyzer é a ferramenta de análise de segurança
                                  orientada por dados de análise desenvolvida com perspectiva
                                  de operações. Com visões orientadas para a ação e
                                  capacidades de aprofundamento intensas, o FortiAnalyzer não
                                  fornece às organizações apenas uma percepção crítica das
                                  ameaças, mas também os escopos com precisão de risco em toda
                                  a superfície de ataque, identificando onde é necessária uma
                                  resposta imediata e permitindo ações de resposta
                                  automatizadas.</p>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="tab-pane" id="fortimanager">
                          <div class="">
                            <div class="card-header">
                              <h4 class="card-title">FortiManager: </h4>
                              <p class="card-category">
                                Gerenciamento centralizado controlado por automação
                              </p>
                            </div>
                            <div class="card-body">
                              <div class="texto">
                                <p>A transformação digital é o principal fator para muitas
                                  organizações adotarem rapidamente a nuvem. Até 2020, a
                                  maioria das cargas de trabalho estará na nuvem, seja
                                  pública, privada ou híbrida.</p>

                                <p> Como muitas organizações sofrem essa transformação, elas se
                                  veem lutando para acompanhar um ambiente mais complexo e que
                                  precisa de menos lacunas para permitir a automação no
                                  gerenciamento de segurança.
                                </p>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-md-12">
                      <h4 class="card-title text-center">Preencha seus dados para entrarmos em contato</h4>
                      <script type="text/javascript" src="https://westcon.enube.me/form/generate.js?id=170"></script>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>



      </div>

    </div>



  </div>

  <!--   Core JS Files   -->
  <script src="assets/js/core/jquery.min.js"></script>
  <script src="assets/js/core/popper.min.js"></script>
  <script src="assets/js/core/bootstrap-material-design.min.js"></script>
  <script src="assets/js/plugins/perfect-scrollbar.jquery.min.js"></script>
  <script src="assets/js/plugins/isotope.pkgd.min.js" type="text/javascript"></script>

  <!-- Control Center for Material Dashboard: parallax effects, scripts for the example pages etc -->
  <script src="assets/js/material-dashboard.js?v=2.1.0" type="text/javascript"></script>
  <script src="assets/js/main.js" type="text/javascript"></script>
</body>

</html>