/************************************************************************
 * This file is part of Partners.
 *
 * Partners - Open Source CRM application.
 * Copyright (C) 2014-2019 Yuri Kuznetsov, Taras Machyshyn, Oleksiy Avramenko
 * Website: https://www.espocrm.com
 *
 * Partners is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Partners is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Partners. If not, see http://www.gnu.org/licenses/.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Partners" word.
 ************************************************************************/

define('controllers/base', 'controller', function (Dep) {

    return Dep.extend({

        login: function () {
            var viewName = this.getConfig().get('loginView') || 'views/login';

            this.entire(viewName, {}, function (loginView) {
                loginView.render();

                loginView.on('login', function (userName, data) {
                    this.trigger('login', this.normalizeLoginData(userName, data));
                }, this);

                loginView.once('redirect', function (viewName, userName, password, data) {
                    loginView.remove();
                    this.entire(viewName, {
                        loginData: data,
                        userName: userName,
                        password: password,
                    }, function (secondStepView) {
                        secondStepView.render();

                        secondStepView.once('login', function (userName, data) {
                            this.trigger('login', this.normalizeLoginData(userName, data));
                        }, this);

                        secondStepView.once('back', function () {
                            secondStepView.remove();

                            this.login();
                        }, this);
                    }.bind(this));
                }, this);
            }.bind(this));
        },

        normalizeLoginData: function (userName, data) {
            return {
                auth: {
                    userName: userName,
                    token: data.token,
                },
                user: data.user,
                preferences: data.preferences,
                acl: data.acl,
                settings: data.settings,
                appParams: data.appParams,
            };
        },

        actionLogin: function () {
            this.login();
        },

        logout: function () {
            var title = this.getConfig().get('applicationName') || 'Partners';
            $('head title').text(title);
            this.trigger('logout');
        },

        actionLogout: function () {
            this.logout();
        },

        actionClearCache: function () {
            this.clearCache();
        },

        clearCache: function () {
            this.entire('views/clear-cache', {
                cache: this.getCache()
            }, function (view) {
                view.render();
            });
        },

        error404: function () {
            this.entire('views/base', {template: 'errors/404'}, function (view) {
                view.render();
            });
        },

        error403: function () {
            this.entire('views/base', {template: 'errors/403'}, function (view) {
                view.render();
            });
        },

    });
});
