<?php
return [
  0 => [
    'route' => 'EblaForm/Attachment/:eblaFormId',
    'method' => 'post',
    'params' => [
      'controller' => 'EblaForm',
      'action' => 'upload',
      'eblaFormId' => ':eblaFormId'
    ],
    'adjustedRoute' => '/EblaForm/Attachment/{eblaFormId}',
    'noAuth' => true
  ],
  1 => [
    'route' => 'EblaForm/save/:eblaFormId',
    'method' => 'post',
    'params' => [
      'controller' => 'EblaForm',
      'action' => 'submit',
      'eblaFormId' => ':eblaFormId'
    ],
    'adjustedRoute' => '/EblaForm/save/{eblaFormId}',
    'noAuth' => true
  ],
  2 => [
    'route' => 'EblaForm/defs',
    'method' => 'post',
    'params' => [
      'controller' => 'EblaForm',
      'action' => 'defs'
    ],
    'adjustedRoute' => '/EblaForm/defs',
    'noAuth' => true
  ],
  3 => [
    'route' => 'Product/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/Product/{id}/warehousesQuantity'
  ],
  4 => [
    'route' => 'InventoryNumber/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/InventoryNumber/{id}/warehousesQuantity'
  ],
  5 => [
    'route' => 'InventoryNumber/:id/history',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetHistory',
    'adjustedRoute' => '/InventoryNumber/{id}/history'
  ],
  6 => [
    'route' => 'Warehouse/:id/products',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetProducts',
    'adjustedRoute' => '/Warehouse/{id}/products'
  ],
  7 => [
    'route' => 'Warehouse/:id/inventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetInventoryNumbers',
    'adjustedRoute' => '/Warehouse/{id}/inventoryNumbers'
  ],
  8 => [
    'route' => 'ReceiptOrder/:id/importSerialNumbers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ReceiptOrder\\Api\\PostImportSerialNumbers',
    'adjustedRoute' => '/ReceiptOrder/{id}/importSerialNumbers'
  ],
  9 => [
    'route' => 'ProductAttribute/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMove',
    'adjustedRoute' => '/ProductAttribute/{id}/move/{type}'
  ],
  10 => [
    'route' => 'ProductAttributeOption/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMoveOption',
    'adjustedRoute' => '/ProductAttributeOption/{id}/move/{type}'
  ],
  11 => [
    'route' => 'ProductAttribute/options',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\GetOptions',
    'adjustedRoute' => '/ProductAttribute/options'
  ],
  12 => [
    'route' => 'Product/:id/generateVariants',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\PostGenerateVariants',
    'adjustedRoute' => '/Product/{id}/generateVariants'
  ],
  13 => [
    'route' => 'Product/:id/variantInventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetVariantInventoryNumbers',
    'adjustedRoute' => '/Product/{id}/variantInventoryNumbers'
  ],
  14 => [
    'route' => 'Product/:id/orderItems',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetOrderItems',
    'adjustedRoute' => '/Product/{id}/orderItems'
  ],
  15 => [
    'route' => 'DeliveryOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/lock'
  ],
  16 => [
    'route' => 'DeliveryOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/unlock'
  ],
  17 => [
    'route' => 'Invoice/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/lock'
  ],
  18 => [
    'route' => 'Invoice/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/unlock'
  ],
  19 => [
    'route' => 'Quote/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/lock'
  ],
  20 => [
    'route' => 'Quote/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/unlock'
  ],
  21 => [
    'route' => 'ReceiptOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/lock'
  ],
  22 => [
    'route' => 'ReceiptOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/unlock'
  ],
  23 => [
    'route' => 'ReturnOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/lock'
  ],
  24 => [
    'route' => 'ReturnOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/unlock'
  ],
  25 => [
    'route' => 'SalesOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/lock'
  ],
  26 => [
    'route' => 'SalesOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/unlock'
  ],
  27 => [
    'route' => 'TransferOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/lock'
  ],
  28 => [
    'route' => 'TransferOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/unlock'
  ],
  29 => [
    'route' => 'PurchaseOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/lock'
  ],
  30 => [
    'route' => 'PurchaseOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/unlock'
  ],
  31 => [
    'route' => 'InventoryAdjustment/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/lock'
  ],
  32 => [
    'route' => 'InventoryAdjustment/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/unlock'
  ],
  33 => [
    'route' => 'PriceRuleCondition/list',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\GetPriceRuleConditionList',
    'adjustedRoute' => '/PriceRuleCondition/list'
  ],
  34 => [
    'route' => 'ProductPrice/getSalesPrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetSalesPrice',
    'adjustedRoute' => '/ProductPrice/getSalesPrice'
  ],
  35 => [
    'route' => 'ProductPrice/getPurchasePrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetPurchasePrice',
    'adjustedRoute' => '/ProductPrice/getPurchasePrice'
  ],
  36 => [
    'route' => 'Invoice/:id/exportEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostExportEInvoice',
    'adjustedRoute' => '/Invoice/{id}/exportEInvoice'
  ],
  37 => [
    'route' => 'Invoice/:id/validateEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostValidateEInvoice',
    'adjustedRoute' => '/Invoice/{id}/validateEInvoice'
  ],
  38 => [
    'route' => 'Report/runGridPreview',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Advanced\\Tools\\Report\\Api\\PostRunGridPreview',
    'adjustedRoute' => '/Report/runGridPreview'
  ],
  39 => [
    'route' => 'Report/runListPreview',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Advanced\\Tools\\Report\\Api\\GetRunListPreview',
    'adjustedRoute' => '/Report/runListPreview'
  ],
  40 => [
    'route' => '/Activities/:parentType/:id/composeEmailAddressList',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetComposeAddressList',
    'adjustedRoute' => '/Activities/{parentType}/{id}/composeEmailAddressList'
  ],
  41 => [
    'route' => '/Activities/:parentType/:id/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\Get',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}'
  ],
  42 => [
    'route' => '/Activities/:parentType/:id/:type/list/:targetType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetListTyped',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}/list/{targetType}'
  ],
  43 => [
    'route' => '/Activities/upcoming',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetUpcoming',
    'adjustedRoute' => '/Activities/upcoming'
  ],
  44 => [
    'route' => '/Activities',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetCalendar',
    'adjustedRoute' => '/Activities'
  ],
  45 => [
    'route' => '/Timeline',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetTimeline',
    'adjustedRoute' => '/Timeline'
  ],
  46 => [
    'route' => '/Timeline/busyRanges',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetBusyRanges',
    'adjustedRoute' => '/Timeline/busyRanges'
  ],
  47 => [
    'route' => '/Meeting/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Meeting',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Meeting/{id}/attendees'
  ],
  48 => [
    'route' => '/Call/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Call',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Call/{id}/attendees'
  ],
  49 => [
    'route' => '/Campaign/:id/generateMailMerge',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Campaign\\Api\\PostGenerateMailMerge',
    'adjustedRoute' => '/Campaign/{id}/generateMailMerge'
  ],
  50 => [
    'route' => '/TargetList/:id/optedOut',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\TargetList\\Api\\GetOptedOut',
    'adjustedRoute' => '/TargetList/{id}/optedOut'
  ],
  51 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  52 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  53 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  54 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  55 => [
    'route' => '/',
    'method' => 'get',
    'params' => [
      'controller' => 'ApiIndex',
      'action' => 'index'
    ],
    'adjustedRoute' => '/'
  ],
  56 => [
    'route' => '/App/user',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetUser',
    'adjustedRoute' => '/App/user'
  ],
  57 => [
    'route' => '/App/destroyAuthToken',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\PostDestroyAuthToken',
    'adjustedRoute' => '/App/destroyAuthToken'
  ],
  58 => [
    'route' => '/App/about',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetAbout',
    'adjustedRoute' => '/App/about'
  ],
  59 => [
    'route' => '/Metadata',
    'method' => 'get',
    'params' => [
      'controller' => 'Metadata'
    ],
    'adjustedRoute' => '/Metadata'
  ],
  60 => [
    'route' => '/I18n',
    'method' => 'get',
    'params' => [
      'controller' => 'I18n'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/I18n'
  ],
  61 => [
    'route' => '/Settings',
    'method' => 'get',
    'params' => [
      'controller' => 'Settings'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Settings'
  ],
  62 => [
    'route' => '/Settings',
    'method' => 'patch',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  63 => [
    'route' => '/Settings',
    'method' => 'put',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  64 => [
    'route' => '/Stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'scope' => 'User'
    ],
    'adjustedRoute' => '/Stream'
  ],
  65 => [
    'route' => '/GlobalStream',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetGlobal',
    'adjustedRoute' => '/GlobalStream'
  ],
  66 => [
    'route' => '/GlobalSearch',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\GlobalSearch\\Api\\Get',
    'adjustedRoute' => '/GlobalSearch'
  ],
  67 => [
    'route' => '/LeadCapture/form/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\LeadCapture\\Api\\PostForm',
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/form/{id}'
  ],
  68 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'post',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  69 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'options',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  70 => [
    'route' => '/:controller/action/:action',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  71 => [
    'route' => '/:controller/action/:action',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  72 => [
    'route' => '/:controller/action/:action',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  73 => [
    'route' => '/:controller/layout/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  74 => [
    'route' => '/:controller/layout/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  75 => [
    'route' => '/:controller/layout/:name/:setId',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}/{setId}'
  ],
  76 => [
    'route' => '/Admin/rebuild',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'rebuild'
    ],
    'adjustedRoute' => '/Admin/rebuild'
  ],
  77 => [
    'route' => '/Admin/clearCache',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'clearCache'
    ],
    'adjustedRoute' => '/Admin/clearCache'
  ],
  78 => [
    'route' => '/Admin/jobs',
    'method' => 'get',
    'params' => [
      'controller' => 'Admin',
      'action' => 'jobs'
    ],
    'adjustedRoute' => '/Admin/jobs'
  ],
  79 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'read',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  80 => [
    'route' => '/Admin/fieldManager/:scope',
    'method' => 'post',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'create',
      'scope' => ':scope'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}'
  ],
  81 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  82 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'patch',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  83 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'delete',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'delete',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  84 => [
    'route' => '/CurrencyRate',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\Get',
    'adjustedRoute' => '/CurrencyRate'
  ],
  85 => [
    'route' => '/CurrencyRate',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\PutUpdate',
    'adjustedRoute' => '/CurrencyRate'
  ],
  86 => [
    'route' => '/Action',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\Action\\Api\\PostProcess',
    'adjustedRoute' => '/Action'
  ],
  87 => [
    'route' => '/MassAction',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostProcess',
    'adjustedRoute' => '/MassAction'
  ],
  88 => [
    'route' => '/MassAction/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\GetStatus',
    'adjustedRoute' => '/MassAction/{id}/status'
  ],
  89 => [
    'route' => '/MassAction/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostSubscribe',
    'adjustedRoute' => '/MassAction/{id}/subscribe'
  ],
  90 => [
    'route' => '/Export',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostProcess',
    'adjustedRoute' => '/Export'
  ],
  91 => [
    'route' => '/Export/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\GetStatus',
    'adjustedRoute' => '/Export/{id}/status'
  ],
  92 => [
    'route' => '/Export/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostSubscribe',
    'adjustedRoute' => '/Export/{id}/subscribe'
  ],
  93 => [
    'route' => '/Import',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\Post',
    'adjustedRoute' => '/Import'
  ],
  94 => [
    'route' => '/Import/file',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostFile',
    'adjustedRoute' => '/Import/file'
  ],
  95 => [
    'route' => '/Import/:id/revert',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRevert',
    'adjustedRoute' => '/Import/{id}/revert'
  ],
  96 => [
    'route' => '/Import/:id/removeDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRemoveDuplicates',
    'adjustedRoute' => '/Import/{id}/removeDuplicates'
  ],
  97 => [
    'route' => '/Import/:id/unmarkDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostUnmarkDuplicates',
    'adjustedRoute' => '/Import/{id}/unmarkDuplicates'
  ],
  98 => [
    'route' => '/Import/:id/exportErrors',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostExportErrors',
    'adjustedRoute' => '/Import/{id}/exportErrors'
  ],
  99 => [
    'route' => '/Kanban/order',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\PutOrder',
    'adjustedRoute' => '/Kanban/order'
  ],
  100 => [
    'route' => '/Kanban/:entityType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\GetData',
    'adjustedRoute' => '/Kanban/{entityType}'
  ],
  101 => [
    'route' => '/Attachment/file/:id',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\GetFile',
    'adjustedRoute' => '/Attachment/file/{id}'
  ],
  102 => [
    'route' => '/Attachment/chunk/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostChunk',
    'adjustedRoute' => '/Attachment/chunk/{id}'
  ],
  103 => [
    'route' => '/Attachment/fromImageUrl',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostFromImageUrl',
    'adjustedRoute' => '/Attachment/fromImageUrl'
  ],
  104 => [
    'route' => '/Attachment/copy/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostCopy',
    'adjustedRoute' => '/Attachment/copy/{id}'
  ],
  105 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  106 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  107 => [
    'route' => '/Note/:id/reactors/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetNoteReactors',
    'adjustedRoute' => '/Note/{id}/reactors/{type}'
  ],
  108 => [
    'route' => '/EmailTemplate/:id/prepare',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\EmailTemplate\\Api\\PostPrepare',
    'adjustedRoute' => '/EmailTemplate/{id}/prepare'
  ],
  109 => [
    'route' => '/Email/:id/attachments/copy',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostAttachmentsCopy',
    'adjustedRoute' => '/Email/{id}/attachments/copy'
  ],
  110 => [
    'route' => '/Email/importEml',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostImportEml',
    'adjustedRoute' => '/Email/importEml'
  ],
  111 => [
    'route' => '/Email/sendTest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostSendTest',
    'adjustedRoute' => '/Email/sendTest'
  ],
  112 => [
    'route' => '/Email/inbox/read',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  113 => [
    'route' => '/Email/inbox/read',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  114 => [
    'route' => '/Email/inbox/important',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  115 => [
    'route' => '/Email/inbox/important',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  116 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  117 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  118 => [
    'route' => '/Email/inbox/folders/:folderId',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostFolder',
    'adjustedRoute' => '/Email/inbox/folders/{folderId}'
  ],
  119 => [
    'route' => '/Email/inbox/notReadCounts',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetNotReadCounts',
    'adjustedRoute' => '/Email/inbox/notReadCounts'
  ],
  120 => [
    'route' => '/Email/insertFieldData',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetInsertFieldData',
    'adjustedRoute' => '/Email/insertFieldData'
  ],
  121 => [
    'route' => '/Email/:id/users',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostUsers',
    'adjustedRoute' => '/Email/{id}/users'
  ],
  122 => [
    'route' => '/EmailAddress/search',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\EmailAddress\\Api\\GetSearch',
    'adjustedRoute' => '/EmailAddress/search'
  ],
  123 => [
    'route' => '/User/:id/stream/own',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetOwn',
    'adjustedRoute' => '/User/{id}/stream/own'
  ],
  124 => [
    'route' => '/User/:id/acl',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\GetUserAcl',
    'adjustedRoute' => '/User/{id}/acl'
  ],
  125 => [
    'route' => '/UserSecurity/apiKey/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostApiKeyGenerate',
    'adjustedRoute' => '/UserSecurity/apiKey/generate'
  ],
  126 => [
    'route' => '/UserSecurity/password',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PutPassword',
    'adjustedRoute' => '/UserSecurity/password'
  ],
  127 => [
    'route' => '/UserSecurity/password/recovery',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordRecovery',
    'adjustedRoute' => '/UserSecurity/password/recovery'
  ],
  128 => [
    'route' => '/UserSecurity/password/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordGenerate',
    'adjustedRoute' => '/UserSecurity/password/generate'
  ],
  129 => [
    'route' => '/User/passwordChangeRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordChangeRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/passwordChangeRequest'
  ],
  130 => [
    'route' => '/User/changePasswordByRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostChangePasswordByRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/changePasswordByRequest'
  ],
  131 => [
    'route' => '/Team/:id/userPosition',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PutTeamUserPosition',
    'adjustedRoute' => '/Team/{id}/userPosition'
  ],
  132 => [
    'route' => '/Oidc/authorizationData',
    'method' => 'get',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'authorizationData'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/authorizationData'
  ],
  133 => [
    'route' => '/Oidc/backchannelLogout',
    'method' => 'post',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'backchannelLogout'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/backchannelLogout'
  ],
  134 => [
    'route' => '/:controller/:id',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'read',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  135 => [
    'route' => '/:controller',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'index'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  136 => [
    'route' => '/:controller',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'create'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  137 => [
    'route' => '/:controller/:id',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  138 => [
    'route' => '/:controller/:id',
    'method' => 'patch',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  139 => [
    'route' => '/:controller/:id',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'delete',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  140 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  141 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  142 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  143 => [
    'route' => '/:controller/:id/stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/stream'
  ],
  144 => [
    'route' => '/:controller/:id/posts',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listPosts',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/posts'
  ],
  145 => [
    'route' => '/:controller/:id/updateStream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listUpdates',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/updateStream'
  ],
  146 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'follow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  147 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'unfollow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  148 => [
    'route' => '/:Note/:id/pin',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  149 => [
    'route' => '/:Note/:id/pin',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  150 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\PutStar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  151 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\DeleteUnstar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  152 => [
    'route' => '/:entityType/:id/usersAccess',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PostRecordUsersAccess',
    'adjustedRoute' => '/{entityType}/{id}/usersAccess'
  ],
  153 => [
    'route' => '/:controller/:id/:link',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'listLinked',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  154 => [
    'route' => '/:controller/:id/:link',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'createLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  155 => [
    'route' => '/:controller/:id/:link',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'removeLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ]
];
