<?php
return (object) [
  'aclDefs' => (object) [
    'ActionHistoryRecord' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\ActionHistoryRecord\\OwnershipChecker'
    ],
    'Attachment' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\OwnershipChecker'
    ],
    'AuthToken' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\AuthToken\\AccessChecker'
    ],
    'Email' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\OwnershipChecker',
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'linkCheckerClassNameMap' => (object) [
        'parent' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\ParentLinkChecker',
        'teams' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\TeamsLinkChecker'
      ]
    ],
    'EmailFilter' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\EmailFilter\\OwnershipChecker'
    ],
    'Import' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Import\\AccessChecker'
    ],
    'ImportEml' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ImportEml\\AccessChecker'
    ],
    'ImportError' => (object) [
      'accessCheckerClassName' => 'Espo\\Core\\Acl\\AccessChecker\\AccessCheckers\\Foreign',
      'link' => 'import'
    ],
    'Note' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\OwnershipChecker'
    ],
    'Notification' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Notification\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Notification\\OwnershipChecker'
    ],
    'Portal' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Portal\\AccessChecker'
    ],
    'ScheduledJob' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ScheduledJob\\AccessChecker'
    ],
    'Team' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Team\\OwnershipChecker'
    ],
    'User' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\User\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\User\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\User\\OwnershipChecker'
    ],
    'Webhook' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\OwnershipChecker'
    ],
    'WorkingTimeRange' => (object) [
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\WorkingTimeRange\\AssignmentChecker'
    ],
    'Account' => (object) [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Account\\OwnershipChecker'
    ],
    'Call' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Call\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'CampaignLogRecord' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignLogRecord\\OwnershipChecker'
    ],
    'CampaignTrackingUrl' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignTrackingUrl\\OwnershipChecker'
    ],
    'Case' => (object) [
      'linkCheckerClassNameMap' => (object) [
        'lead' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\LeadLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\AccountLinkChecker',
        'contact' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker',
        'contacts' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker'
      ],
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Case\\OwnershipChecker',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Contact' => (object) [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Contact\\OwnershipChecker',
      'accountLink' => 'accounts'
    ],
    'Document' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'accounts'
    ],
    'KnowledgeBaseArticle' => (object) [
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\KnowledgeBaseArticle\\AccessChecker'
    ],
    'MassEmail' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\OwnershipChecker',
      'linkCheckerClassNameMap' => (object) [
        'inboundEmail' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\LinkCheckers\\InboundEmailLinkChecker'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\AccessChecker'
    ],
    'Meeting' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Opportunity' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Task' => (object) [
      'linkCheckerClassNameMap' => (object) [
        'parent' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\ParentLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\AccountLinkChecker'
      ],
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'BpmnFlowNode' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnFlowNode\\AccessChecker'
    ],
    'BpmnProcess' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnProcess\\OwnershipChecker'
    ],
    'Report' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\Report\\AccessChecker',
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\AclPortal\\Report\\AccessChecker'
    ],
    'DeliveryOrder' => (object) [
      'accountLink' => 'account'
    ],
    'DeliveryOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryAdjustmentItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryNumber' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\InventoryNumber\\AccessChecker'
    ],
    'Invoice' => (object) [
      'accountLink' => 'account'
    ],
    'InvoiceItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'OpportunityItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'PriceBook' => (object) [
      'accountLink' => 'accounts'
    ],
    'PriceRule' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\PriceRule\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\AccessChecker'
    ],
    'ProductPrice' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\ProductPrice\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\AccessChecker'
    ],
    'PurchaseOrder' => (object) [
      'accountLink' => 'account'
    ],
    'PurchaseOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Quote' => (object) [
      'accountLink' => 'account'
    ],
    'QuoteItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReceiptOrder' => (object) [
      'accountLink' => 'account'
    ],
    'ReceiptOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReturnOrder' => (object) [
      'accountLink' => 'account'
    ],
    'ReturnOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SalesOrder' => (object) [
      'accountLink' => 'account'
    ],
    'SalesOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SupplierProductPrice' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\SupplierProductPrice\\OwnershipChecker'
    ],
    'TransferOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Analytics' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'Api' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Assessment' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CDashboardAccess' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CImporter' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CPatchNotes' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CRecommendations' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CRecommendationsConfig' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CspUsage' => (object) [
      'contactLink' => 'contact',
      'accountLink' => NULL
    ],
    'Monitoring' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'OrderManager' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PartnerID' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'QnA' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Recommendation' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'ResourceCategory' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'ResourceGroup' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Rocket' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Subscriptions' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Tags' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'Tutorial' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ]
  ],
  'app' => (object) [
    'acl' => (object) [
      'mandatory' => (object) [
        'scopeLevel' => (object) [
          'Note' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Portal' => (object) [
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Attachment' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailAccount' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFilter' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFolder' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'GroupEmailFolder' => (object) [
            'read' => 'team',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Preferences' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Notification' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'ActionHistoryRecord' => (object) [
            'read' => 'own'
          ],
          'Role' => false,
          'PortalRole' => false,
          'ImportError' => 'Import',
          'ImportEml' => 'Import',
          'WorkingTimeRange' => 'WorkingTimeCalendar',
          'Stream' => true,
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => 'Campaign',
          'Workflow' => false,
          'WorkflowLogRecord' => false,
          'ReportPanel' => false,
          'BpmnFlowNode' => 'BpmnProcess',
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'InventoryAdjustmentItem' => 'InventoryAdjustment',
          'ProductPrice' => 'PriceBook',
          'PriceRule' => 'PriceBook',
          'SupplierProductPrice' => 'Supplier',
          'ProductAttributeOption' => 'ProductAttribute'
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'EmailAccount' => (object) [
            'assignedUser' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'EmailFolder' => (object) [
            'assignedUser' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Email' => (object) [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => (object) [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'password' => false,
            'passwordConfirm' => false,
            'auth2FA' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false
          ],
          'ActionHistoryRecord' => (object) [
            'authToken' => false,
            'authLogRecord' => false
          ]
        ]
      ],
      'strictDefault' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'read' => 'own',
            'edit' => 'no'
          ],
          'Team' => (object) [
            'read' => 'team'
          ],
          'Import' => false,
          'Webhook' => false
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'User' => (object) [
            'gender' => false,
            'avatarColor' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Meeting' => (object) [
            'uid' => false
          ],
          'Call' => (object) [
            'uid' => false
          ]
        ]
      ],
      'adminMandatory' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Team' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Job' => (object) [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Extension' => (object) [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Stream' => true,
          'ImportEml' => 'Import',
          'BpmnFlowchart' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all',
            'stream' => 'all'
          ],
          'InventoryTransaction' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'PriceRuleCondition' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'assignmentPermission',
        1 => 'messagePermission',
        2 => 'mentionPermission',
        3 => 'userCalendarPermission',
        4 => 'auditPermission',
        5 => 'exportPermission',
        6 => 'massUpdatePermission',
        7 => 'userPermission',
        8 => 'portalPermission',
        9 => 'groupEmailAccountPermission',
        10 => 'followerManagementPermission',
        11 => 'dataPrivacyPermission'
      ],
      'valuePermissionHighestLevels' => (object) [
        'assignmentPermission' => 'all',
        'userPermission' => 'all',
        'messagePermission' => 'all',
        'portalPermission' => 'yes',
        'groupEmailAccountPermission' => 'all',
        'exportPermission' => 'yes',
        'massUpdatePermission' => 'yes',
        'followerManagementPermission' => 'all',
        'dataPrivacyPermission' => 'yes',
        'auditPermission' => 'yes',
        'mentionPermission' => 'yes',
        'userCalendarPermission' => 'all'
      ],
      'permissionsStrictDefaults' => (object) [
        'assignmentPermission' => 'no',
        'userPermission' => 'no',
        'messagePermission' => 'no',
        'portalPermission' => 'no',
        'groupEmailAccountPermission' => 'no',
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no',
        'followerManagementPermission' => 'no',
        'dataPrivacyPermission' => 'no',
        'auditPermission' => 'no',
        'mentionPermission' => 'no',
        'userCalendarPermission' => 'no'
      ]
    ],
    'aclPortal' => (object) [
      'mandatory' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'no',
            'stream' => 'no',
            'create' => 'no'
          ],
          'Team' => false,
          'Note' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Notification' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'Portal' => false,
          'Attachment' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'ExternalAccount' => false,
          'Role' => false,
          'PortalRole' => false,
          'EmailFilter' => false,
          'EmailFolder' => false,
          'EmailAccount' => false,
          'EmailTemplate' => false,
          'ActionHistoryRecord' => (object) [
            'read' => 'own'
          ],
          'Preferences' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => false,
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'ProductPrice' => 'PriceBook'
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'Preferences' => (object) [
            'smtpServer' => false,
            'smtpPort' => false,
            'smtpSecurity' => false,
            'smtpUsername' => false,
            'smtpPassword' => false,
            'smtpAuth' => false,
            'receiveAssignmentEmailNotifications' => false,
            'receiveMentionEmailNotifications' => false,
            'defaultReminders' => false,
            'autoFollowEntityTypeList' => false,
            'emailReplyForceHtml' => false,
            'emailReplyToAllByDefault' => false,
            'signature' => false,
            'followCreatedEntities' => false,
            'followEntityOnStreamPost' => false,
            'doNotFillAssignedUserIfNotRequired' => false,
            'useCustomTabList' => false,
            'addCustomTabs' => false,
            'tabList' => false,
            'emailUseExternalClient' => false,
            'assignmentNotificationsIgnoreEntityTypeList' => false,
            'assignmentEmailNotificationsIgnoreEntityTypeList' => false,
            'dashletsOptions' => false,
            'dashboardLayout' => false
          ],
          'Call' => (object) [
            'reminders' => false,
            'uid' => false
          ],
          'Meeting' => (object) [
            'reminders' => false,
            'uid' => false
          ],
          'Note' => (object) [
            'isInternal' => false,
            'isGlobal' => false
          ],
          'Email' => (object) [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => (object) [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => false,
            'password' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false,
            'isAdmin' => false,
            'type' => false,
            'contact' => false,
            'accounts' => false,
            'account' => false,
            'portalRoles' => false,
            'portals' => false,
            'roles' => false,
            'defaultTeam' => false,
            'auth2FA' => false,
            'isActive' => false
          ],
          'ActionHistoryRecord' => (object) [
            'authToken' => false,
            'authLogRecord' => false
          ],
          'Case' => (object) [
            'isInternal' => false
          ],
          'Report' => (object) [
            'portals' => false,
            'assignedUser' => false,
            'teams' => false,
            'emailSendingInterval' => false,
            'emailSendingSettingMonth' => false,
            'emailSendingSettingDay' => false,
            'emailSendingSettingWeekdays' => false,
            'emailSendingTime' => false,
            'emailSendingUsers' => false,
            'emailSendingLastDateSent' => false,
            'emailSendingDoNotSendEmptyReport' => false,
            'applyAcl' => false
          ]
        ]
      ],
      'strictDefault' => (object) [
        'scopeLevel' => (object) [],
        'fieldLevel' => (object) [
          'assignedUser' => (object) [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'assignedUsers' => (object) [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'collaborators' => false,
          'teams' => false
        ],
        'scopeFieldLevel' => (object) [
          'User' => (object) [
            'gender' => false
          ],
          'KnowledgeBaseArticle' => (object) [
            'portals' => false,
            'order' => false,
            'status' => false,
            'assignedUser' => false
          ],
          'Call' => (object) [
            'users' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Meeting' => (object) [
            'users' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Case' => (object) [
            'status' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Report' => (object) [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'exportPermission',
        1 => 'massUpdatePermission'
      ],
      'permissionsStrictDefaults' => (object) [
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no'
      ],
      'default' => (object) [
        'scopeFieldLevel' => (object) [
          'Report' => (object) [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ]
    ],
    'actions' => (object) [
      'convertCurrency' => (object) [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\ConvertCurrency'
      ],
      'merge' => (object) [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\Merge'
      ]
    ],
    'addressFormats' => (object) [
      1 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter1'
      ],
      2 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter2'
      ],
      3 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter3'
      ],
      4 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter4'
      ]
    ],
    'adminPanel' => (object) [
      'system' => (object) [
        'label' => 'System',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/settings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'settings',
            'recordView' => 'views/admin/settings'
          ],
          1 => (object) [
            'url' => '#Admin/userInterface',
            'label' => 'User Interface',
            'iconClass' => 'fas fa-desktop',
            'description' => 'userInterface',
            'recordView' => 'views/admin/user-interface'
          ],
          2 => (object) [
            'url' => '#Admin/authentication',
            'label' => 'Authentication',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authentication',
            'recordView' => 'views/admin/authentication'
          ],
          3 => (object) [
            'url' => '#ScheduledJob',
            'label' => 'Scheduled Jobs',
            'iconClass' => 'fas fa-clock',
            'description' => 'scheduledJob'
          ],
          4 => (object) [
            'url' => '#Admin/currency',
            'label' => 'Currency',
            'iconClass' => 'fas fa-euro-sign',
            'description' => 'currency',
            'recordView' => 'views/admin/currency'
          ],
          5 => (object) [
            'url' => '#Admin/notifications',
            'label' => 'Notifications',
            'iconClass' => 'fas fa-bell',
            'description' => 'notifications',
            'recordView' => 'views/admin/notifications'
          ],
          6 => (object) [
            'url' => '#Admin/integrations',
            'label' => 'Integrations',
            'iconClass' => 'fas fa-network-wired',
            'description' => 'integrations'
          ],
          7 => (object) [
            'url' => '#Admin/extensions',
            'label' => 'Extensions',
            'iconClass' => 'fas fa-upload',
            'description' => 'extensions'
          ],
          8 => (object) [
            'url' => '#Admin/systemRequirements',
            'label' => 'System Requirements',
            'iconClass' => 'fas fa-server',
            'description' => 'systemRequirements'
          ],
          9 => (object) [
            'url' => '#Admin/jobsSettings',
            'label' => 'Job Settings',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobsSettings',
            'recordView' => 'views/admin/jobs-settings'
          ],
          10 => (object) [
            'url' => '#Admin/upgrade',
            'label' => 'Upgrade',
            'iconClass' => 'fas fa-arrow-alt-circle-up',
            'description' => 'upgrade',
            'view' => 'views/admin/upgrade/index'
          ],
          11 => (object) [
            'action' => 'clearCache',
            'label' => 'Clear Cache',
            'iconClass' => 'fas fa-broom',
            'description' => 'clearCache'
          ],
          12 => (object) [
            'action' => 'rebuild',
            'label' => 'Rebuild',
            'iconClass' => 'fas fa-database',
            'description' => 'rebuild'
          ]
        ],
        'order' => 0
      ],
      'users' => (object) [
        'label' => 'Users',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/users',
            'label' => 'Users',
            'iconClass' => 'fas fa-user',
            'description' => 'users',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/teams',
            'label' => 'Teams',
            'iconClass' => 'fas fa-users',
            'description' => 'teams',
            'tabQuickSearch' => true
          ],
          2 => (object) [
            'url' => '#Admin/roles',
            'label' => 'Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'roles',
            'tabQuickSearch' => true
          ],
          3 => (object) [
            'url' => '#Admin/authLog',
            'label' => 'Auth Log',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authLog'
          ],
          4 => (object) [
            'url' => '#Admin/authTokens',
            'label' => 'Auth Tokens',
            'iconClass' => 'fas fa-shield-alt',
            'description' => 'authTokens'
          ],
          5 => (object) [
            'url' => '#Admin/actionHistory',
            'label' => 'Action History',
            'iconClass' => 'fas fa-history',
            'description' => 'actionHistory'
          ],
          6 => (object) [
            'url' => '#Admin/apiUsers',
            'label' => 'API Users',
            'iconClass' => 'fas fa-user-cog',
            'description' => 'apiUsers'
          ]
        ],
        'order' => 5
      ],
      'customization' => (object) [
        'label' => 'Customization',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/entityManager',
            'label' => 'Entity Manager',
            'iconClass' => 'fas fa-tools',
            'description' => 'entityManager',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/layouts',
            'label' => 'Layout Manager',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutManager'
          ],
          2 => (object) [
            'url' => '#Admin/labelManager',
            'label' => 'Label Manager',
            'iconClass' => 'fas fa-language',
            'description' => 'labelManager'
          ],
          3 => (object) [
            'url' => '#Admin/templateManager',
            'label' => 'Template Manager',
            'iconClass' => 'fas fa-envelope-open-text',
            'description' => 'templateManager'
          ],
          4 => (object) [
            'url' => '#ReportFilter',
            'label' => 'Report Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'reportFilters'
          ],
          5 => (object) [
            'url' => '#ReportPanel',
            'label' => 'Report Panels',
            'iconClass' => 'fas fa-chart-area',
            'description' => 'reportPanels'
          ]
        ],
        'order' => 10
      ],
      'email' => (object) [
        'label' => 'Messaging',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/outboundEmails',
            'label' => 'Outbound Emails',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'outboundEmails',
            'recordView' => 'views/admin/outbound-emails'
          ],
          1 => (object) [
            'url' => '#Admin/inboundEmails',
            'label' => 'Inbound Emails',
            'iconClass' => 'fas fa-envelope',
            'description' => 'inboundEmails',
            'recordView' => 'views/admin/inbound-emails'
          ],
          2 => (object) [
            'url' => '#Admin/groupEmailAccounts',
            'label' => 'Group Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'groupEmailAccounts'
          ],
          3 => (object) [
            'url' => '#Admin/personalEmailAccounts',
            'label' => 'Personal Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'personalEmailAccounts'
          ],
          4 => (object) [
            'url' => '#Admin/emailFilters',
            'label' => 'Email Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'emailFilters'
          ],
          5 => (object) [
            'url' => '#Admin/groupEmailFolders',
            'label' => 'Group Email Folders',
            'iconClass' => 'fas fa-folder',
            'description' => 'groupEmailFolders'
          ],
          6 => (object) [
            'url' => '#Admin/emailTemplates',
            'label' => 'Email Templates',
            'iconClass' => 'fas fa-envelope-square',
            'description' => 'emailTemplates'
          ],
          7 => (object) [
            'url' => '#Admin/sms',
            'label' => 'SMS',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'sms',
            'recordView' => 'views/admin/sms'
          ]
        ],
        'order' => 15
      ],
      'portal' => (object) [
        'label' => 'Portal',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/portals',
            'label' => 'Portals',
            'iconClass' => 'fas fa-parking',
            'description' => 'portals'
          ],
          1 => (object) [
            'url' => '#Admin/portalUsers',
            'label' => 'Portal Users',
            'iconClass' => 'fas fa-user',
            'description' => 'portalUsers',
            'tabQuickSearch' => true
          ],
          2 => (object) [
            'url' => '#Admin/portalRoles',
            'label' => 'Portal Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'portalRoles'
          ]
        ],
        'order' => 20
      ],
      'setup' => (object) [
        'label' => 'Setup',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/workingTimeCalendar',
            'label' => 'Working Time Calendars',
            'iconClass' => 'far fa-calendar-alt',
            'description' => 'workingTimeCalendars',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/layoutSets',
            'label' => 'Layout Sets',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutSets'
          ],
          2 => (object) [
            'url' => '#Admin/dashboardTemplates',
            'label' => 'Dashboard Templates',
            'iconClass' => 'fas fa-th-large',
            'description' => 'dashboardTemplates'
          ],
          3 => (object) [
            'url' => '#Admin/leadCapture',
            'label' => 'Lead Capture',
            'iconClass' => 'fas fa-id-card',
            'description' => 'leadCapture'
          ],
          4 => (object) [
            'url' => '#Admin/pdfTemplates',
            'label' => 'PDF Templates',
            'iconClass' => 'fas fa-file-pdf',
            'description' => 'pdfTemplates'
          ],
          5 => (object) [
            'url' => '#Admin/webhooks',
            'label' => 'Webhooks',
            'iconClass' => 'fas fa-share-alt icon-rotate-90',
            'description' => 'webhooks'
          ],
          6 => (object) [
            'url' => '#Admin/addressCountries',
            'label' => 'Address Countries',
            'iconClass' => 'far fa-flag',
            'description' => 'addressCountries'
          ],
          7 => (object) [
            'url' => '#Admin/authenticationProviders',
            'label' => 'Authentication Providers',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authenticationProviders'
          ]
        ],
        'order' => 24
      ],
      'data' => (object) [
        'label' => 'Data',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/import',
            'label' => 'Import',
            'iconClass' => 'fas fa-file-import',
            'description' => 'import'
          ],
          1 => (object) [
            'url' => '#Admin/attachments',
            'label' => 'Attachments',
            'iconClass' => 'fas fa-paperclip',
            'description' => 'attachments'
          ],
          2 => (object) [
            'url' => '#Admin/jobs',
            'label' => 'Jobs',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobs'
          ],
          3 => (object) [
            'url' => '#Admin/emailAddresses',
            'label' => 'Email Addresses',
            'iconClass' => 'fas fa-envelope',
            'description' => 'emailAddresses'
          ],
          4 => (object) [
            'url' => '#Admin/phoneNumbers',
            'label' => 'Phone Numbers',
            'iconClass' => 'fas fa-phone',
            'description' => 'phoneNumbers'
          ],
          5 => (object) [
            'url' => '#Admin/appSecrets',
            'label' => 'App Secrets',
            'iconClass' => 'fas fa-key',
            'description' => 'appSecrets'
          ],
          6 => (object) [
            'url' => '#Admin/appLog',
            'label' => 'App Log',
            'iconClass' => 'fas fa-list',
            'description' => 'appLog'
          ]
        ],
        'order' => 25
      ],
      'misc' => (object) [
        'label' => 'Misc',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/formulaSandbox',
            'label' => 'Formula Sandbox',
            'iconClass' => 'fas fa-code',
            'description' => 'formulaSandbox',
            'view' => 'views/admin/formula-sandbox/index'
          ]
        ],
        'order' => 26
      ],
      'workflows' => (object) [
        'label' => 'Workflow Manager',
        'itemList' => [
          0 => (object) [
            'url' => '#Workflow',
            'label' => 'Workflow Manager',
            'iconClass' => 'fas fa-code-branch icon-rotate-180',
            'description' => 'workflowManager',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 99
      ],
      'bpmn' => (object) [
        'label' => 'Business Process Management',
        'itemList' => [
          0 => (object) [
            'url' => '#BpmnFlowchart',
            'label' => 'Flowcharts',
            'iconClass' => 'fas fa-project-diagram',
            'description' => 'bpmnFlowcharts',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#BpmnProcess',
            'label' => 'Processes',
            'iconClass' => 'fas fa-cogs',
            'description' => 'bpmnProcesses',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 100
      ],
      'salesPack' => (object) [
        'label' => 'Sales Pack',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/salesPackSettings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'salesPackSettings',
            'recordView' => 'sales:views/settings/record/settings'
          ],
          1 => (object) [
            'url' => '#PriceRuleCondition',
            'label' => 'Price Rule Conditions',
            'iconClass' => 'fas fa-code',
            'description' => 'priceRuleConditions'
          ]
        ]
      ],
      'ebla' => (object) [
        'label' => 'Ebla Extensions',
        'itemList' => [
          0 => (object) [
            'url' => '#EblaForm',
            'iconClass' => 'fas fa-link',
            'keywords' => [
              0 => 'ebla-form',
              1 => 'ebla'
            ],
            'label' => 'Ebla Public Forms',
            'description' => 'eblaFormDescription'
          ]
        ]
      ]
    ],
    'api' => (object) [
      'globalMiddlewareClassNameList' => [],
      'routeMiddlewareClassNameListMap' => (object) [],
      'controllerMiddlewareClassNameListMap' => (object) [],
      'controllerActionMiddlewareClassNameListMap' => (object) []
    ],
    'appParams' => (object) [
      'templateEntityTypeList' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\TemplateEntityTypeList'
      ],
      'extensions' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\Extensions'
      ],
      'addressCountryData' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\AddressCountryData'
      ],
      'flowchartEntityTypeList' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\AppParams\\FlowchartEntityTypeList'
      ],
      'manualWorkflows' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Classes\\AppParams\\ManualWorkflows'
      ],
      'defaultTaxRateQuote' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateQuote'
      ],
      'defaultTaxRateSalesOrder' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateSalesOrder'
      ],
      'defaultTaxRateInvoice' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateInvoice'
      ],
      'defaultTaxRatePurchaseOrder' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRatePurchaseOrder'
      ]
    ],
    'authentication' => (object) [
      'beforeLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedAttemptsLimit',
        1 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedCodeAttemptsLimit'
      ],
      'onLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\IpAddressWhitelist'
      ],
      'onFailHookClassNameList' => [],
      'onSuccessHookClassNameList' => [],
      'onSuccessByTokenHookClassNameList' => [],
      'onSecondStepRequiredHookClassNameList' => []
    ],
    'authentication2FAMethods' => (object) [
      'Totp' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/totp',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpUserSetup'
      ],
      'Email' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-email',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailUserSetup'
      ],
      'Sms' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-sms',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsUserSetup'
      ]
    ],
    'cleanup' => (object) [
      'reminders' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Reminders',
        'order' => 10
      ],
      'webhookQueue' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\WebhookQueue',
        'order' => 11
      ],
      'twoFactorCodes' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\TwoFactorCodes'
      ],
      'massActions' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\MassActions'
      ],
      'exports' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Exports'
      ],
      'passwordChangeRequests' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\PasswordChangeRequests'
      ],
      'subscribers' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Subscribers'
      ],
      'audit' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Audit'
      ],
      'stars' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Stars'
      ],
      'appLog' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\AppLog'
      ],
      'workflowLog' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\WorkflowLog',
        'order' => 20
      ],
      'advancedPack' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\Integrity'
      ],
      'salesIntegrity' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\Cleanup\\Integrity'
      ]
    ],
    'client' => (object) [
      'scriptList' => [
        0 => 'client/lib/espo.js',
        1 => 'client/lib/espo-main.js',
        2 => 'client/custom/modules/ebla-form/src/ebla-form-script.js',
        3 => 'client/custom/modules/enube/patchNotes.js'
      ],
      'developerModeScriptList' => [
        0 => 'client/src/loader.js',
        1 => 'client/custom/modules/ebla-form/src/ebla-form-script.js'
      ],
      'linkList' => [
        0 => (object) [
          'href' => 'client/fonts/inter/Inter-Regular.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        1 => (object) [
          'href' => 'client/fonts/inter/Inter-Medium.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        2 => (object) [
          'href' => 'client/fonts/inter/Inter-SemiBold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        3 => (object) [
          'href' => 'client/fonts/inter/Inter-Bold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        4 => (object) [
          'href' => 'client/fonts/fa-solid-900.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        5 => (object) [
          'href' => 'client/fonts/fa-regular-400.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ]
      ],
      'cssList' => [
        0 => 'client/custom/css/style.css'
      ]
    ],
    'clientNavbar' => (object) [
      'items' => (object) [
        'globalSearch' => (object) [
          'view' => 'views/global-search/global-search',
          'class' => 'navbar-form global-search-container',
          'order' => 5,
          'disabled' => false
        ],
        'quickCreate' => (object) [
          'view' => 'views/site/navbar/quick-create',
          'class' => 'dropdown hidden-xs quick-create-container',
          'order' => 10,
          'disabled' => false
        ],
        'notificationBadge' => (object) [
          'view' => 'views/notification/badge',
          'class' => 'dropdown notifications-badge-container',
          'order' => 15,
          'disabled' => false
        ]
      ],
      'menuItems' => (object) [
        'admin' => (object) [
          'order' => 0,
          'groupIndex' => 1,
          'link' => '#Admin',
          'labelTranslation' => 'Global.labels.Administration',
          'accessDataList' => [
            0 => (object) [
              'isAdminOnly' => true
            ]
          ]
        ],
        'preferences' => (object) [
          'order' => 1,
          'groupIndex' => 1,
          'link' => '#Preferences',
          'labelTranslation' => 'Global.labels.Preferences'
        ],
        'lastViewed' => (object) [
          'order' => 0,
          'groupIndex' => 5,
          'link' => '#LastViewed',
          'labelTranslation' => 'Global.scopeNamesPlural.LastViewed',
          'configCheck' => '!actionHistoryDisabled',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'lastViewed'
        ],
        'about' => (object) [
          'order' => 0,
          'groupIndex' => 10,
          'link' => '#About',
          'labelTranslation' => 'Global.labels.About'
        ],
        'logout' => (object) [
          'order' => 1,
          'groupIndex' => 10,
          'labelTranslation' => 'Global.labels.Log Out',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'logout'
        ]
      ]
    ],
    'clientRecord' => (object) [
      'panels' => (object) [
        'activities' => (object) [
          'name' => 'activities',
          'label' => 'Activities',
          'view' => 'crm:views/record/panels/activities',
          'aclScope' => 'Activities'
        ],
        'history' => (object) [
          'name' => 'history',
          'label' => 'History',
          'view' => 'crm:views/record/panels/history',
          'aclScope' => 'Activities'
        ],
        'tasks' => (object) [
          'name' => 'tasks',
          'label' => 'Tasks',
          'view' => 'crm:views/record/panels/tasks',
          'aclScope' => 'Task'
        ]
      ]
    ],
    'clientRoutes' => (object) [
      'AddressMap/view/:entityType/:id/:field' => (object) [
        'params' => (object) [
          'controller' => 'AddressMap',
          'action' => 'view'
        ]
      ],
      'Admin/:page' => (object) [
        'params' => (object) [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      'Admin/:page/:options' => (object) [
        'params' => (object) [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      ':entityType/activities/:id/:targetEntityType' => (object) [
        'params' => (object) [
          'controller' => 'Activities',
          'action' => 'activities'
        ],
        'order' => 1
      ],
      ':entityType/history/:id/:targetEntityType' => (object) [
        'params' => (object) [
          'controller' => 'Activities',
          'action' => 'history'
        ],
        'order' => 1
      ],
      'Report/show/:id' => (object) [
        'params' => (object) [
          'controller' => 'Report',
          'action' => 'show'
        ]
      ]
    ],
    'complexExpression' => (object) [
      'functionList' => [
        0 => (object) [
          'name' => 'EQUAL',
          'insertText' => 'EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        1 => (object) [
          'name' => 'NOT_EQUAL',
          'insertText' => 'NOT_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        2 => (object) [
          'name' => 'OR',
          'insertText' => 'OR:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        3 => (object) [
          'name' => 'AND',
          'insertText' => 'AND:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        4 => (object) [
          'name' => 'NOT',
          'insertText' => 'NOT:(EXPR)',
          'returnType' => 'bool'
        ],
        5 => (object) [
          'name' => 'LIKE',
          'insertText' => 'LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        6 => (object) [
          'name' => 'NOT_LIKE',
          'insertText' => 'NOT_LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        7 => (object) [
          'name' => 'GREATER_THAN',
          'insertText' => 'GREATER_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        8 => (object) [
          'name' => 'LESS_THAN',
          'insertText' => 'LESS_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        9 => (object) [
          'name' => 'GREATER_THAN_OR_EQUAL',
          'insertText' => 'GREATER_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        10 => (object) [
          'name' => 'LESS_THAN_OR_EQUAL',
          'insertText' => 'LESS_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        11 => (object) [
          'name' => 'IS_NULL',
          'insertText' => 'IS_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        12 => (object) [
          'name' => 'IS_NOT_NULL',
          'insertText' => 'IS_NOT_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        13 => (object) [
          'name' => 'IN',
          'insertText' => 'IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        14 => (object) [
          'name' => 'NOT_IN',
          'insertText' => 'NOT_IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        15 => (object) [
          'name' => 'IF',
          'insertText' => 'IF:(CONDITION, THEN_VALUE, ELSE_VALUE)'
        ],
        16 => (object) [
          'name' => 'SWITCH',
          'insertText' => 'SWITCH:(CONDITION1, VALUE1, CONDITION2, VALUE2, ELSE_VALUE)'
        ],
        17 => (object) [
          'name' => 'MAP',
          'insertText' => 'MAP:(EXPR, WHEN_VALUE1, THEN_VALUE1, WHEN_VALUE2, THEN_VALUE2, ELSE_VALUE)'
        ],
        18 => (object) [
          'name' => 'MONTH_NUMBER',
          'insertText' => 'MONTH_NUMBER:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        19 => (object) [
          'name' => 'WEEK_NUMBER_0',
          'insertText' => 'WEEK_NUMBER_0:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        20 => (object) [
          'name' => 'WEEK_NUMBER_1',
          'insertText' => 'WEEK_NUMBER_1:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        21 => (object) [
          'name' => 'DAYOFWEEK',
          'insertText' => 'DAYOFWEEK:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        22 => (object) [
          'name' => 'DAYOFMONTH',
          'insertText' => 'DAYOFMONTH:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        23 => (object) [
          'name' => 'YEAR',
          'insertText' => 'YEAR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        24 => (object) [
          'name' => 'HOUR',
          'insertText' => 'HOUR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        25 => (object) [
          'name' => 'MINUTE',
          'insertText' => 'MINUTE:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        26 => (object) [
          'name' => 'MONTH',
          'insertText' => 'MONTH:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        27 => (object) [
          'name' => 'QUARTER',
          'insertText' => 'QUARTER:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        28 => (object) [
          'name' => 'WEEK',
          'insertText' => 'WEEK:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        29 => (object) [
          'name' => 'NOW',
          'insertText' => 'NOW:()',
          'returnType' => 'string'
        ],
        30 => (object) [
          'name' => 'TZ',
          'insertText' => 'TZ:(DATE_VALUE, OFFSET)',
          'returnType' => 'string'
        ],
        31 => (object) [
          'name' => 'UNIX_TIMESTAMP',
          'insertText' => 'UNIX_TIMESTAMP:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        32 => (object) [
          'name' => 'TIMESTAMPDIFF_YEAR',
          'insertText' => 'TIMESTAMPDIFF_YEAR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        33 => (object) [
          'name' => 'TIMESTAMPDIFF_MONTH',
          'insertText' => 'TIMESTAMPDIFF_MONTH:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        34 => (object) [
          'name' => 'TIMESTAMPDIFF_WEEK',
          'insertText' => 'TIMESTAMPDIFF_WEEK:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        35 => (object) [
          'name' => 'TIMESTAMPDIFF_DAY',
          'insertText' => 'TIMESTAMPDIFF_DAY:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        36 => (object) [
          'name' => 'TIMESTAMPDIFF_HOUR',
          'insertText' => 'TIMESTAMPDIFF_HOUR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        37 => (object) [
          'name' => 'TIMESTAMPDIFF_MINUTE',
          'insertText' => 'TIMESTAMPDIFF_MINUTE:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        38 => (object) [
          'name' => 'TIMESTAMPDIFF_SECOND',
          'insertText' => 'TIMESTAMPDIFF_SECOND:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        39 => (object) [
          'name' => 'CONCAT',
          'insertText' => 'CONCAT:(STRING1, STRING2)',
          'returnType' => 'string'
        ],
        40 => (object) [
          'name' => 'LEFT',
          'insertText' => 'LEFT:(STRING, NUMBER_OF_CHARACTERS)',
          'returnType' => 'string'
        ],
        41 => (object) [
          'name' => 'LOWER',
          'insertText' => 'LOWER:(STRING)',
          'returnType' => 'string'
        ],
        42 => (object) [
          'name' => 'UPPER',
          'insertText' => 'UPPER:(STRING)',
          'returnType' => 'string'
        ],
        43 => (object) [
          'name' => 'TRIM',
          'insertText' => 'TRIM:(STRING)',
          'returnType' => 'string'
        ],
        44 => (object) [
          'name' => 'CHAR_LENGTH',
          'insertText' => 'CHAR_LENGTH:(STRING)',
          'returnType' => 'int'
        ],
        45 => (object) [
          'name' => 'BINARY',
          'insertText' => 'BINARY:(STRING)',
          'returnType' => 'string'
        ],
        46 => (object) [
          'name' => 'REPLACE',
          'insertText' => 'REPLACE:(HAYSTACK, NEEDLE, REPLACE_WITH)',
          'returnType' => 'string'
        ],
        47 => (object) [
          'name' => 'ADD',
          'insertText' => 'ADD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        48 => (object) [
          'name' => 'SUB',
          'insertText' => 'SUB:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        49 => (object) [
          'name' => 'MUL',
          'insertText' => 'MUL:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        50 => (object) [
          'name' => 'DIV',
          'insertText' => 'DIV:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        51 => (object) [
          'name' => 'MOD',
          'insertText' => 'MOD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        52 => (object) [
          'name' => 'FLOOR',
          'insertText' => 'FLOOR:(VALUE)',
          'returnType' => 'int'
        ],
        53 => (object) [
          'name' => 'CEIL',
          'insertText' => 'CEIL:(VALUE)',
          'returnType' => 'int'
        ],
        54 => (object) [
          'name' => 'ROUND',
          'insertText' => 'ROUND:(VALUE, PRECISION)',
          'returnType' => 'float'
        ],
        55 => (object) [
          'name' => 'COUNT',
          'insertText' => 'COUNT:(EXPR)',
          'returnType' => 'int'
        ],
        56 => (object) [
          'name' => 'SUM',
          'insertText' => 'SUM:(EXPR)',
          'returnType' => 'int|float'
        ],
        57 => (object) [
          'name' => 'AVG',
          'insertText' => 'AVG:(EXPR)',
          'returnType' => 'float'
        ],
        58 => (object) [
          'name' => 'MAX',
          'insertText' => 'MAX:(EXPR)',
          'returnType' => 'int|float'
        ],
        59 => (object) [
          'name' => 'MIN',
          'insertText' => 'MIN:(EXPR)',
          'returnType' => 'int|float'
        ]
      ]
    ],
    'config' => (object) [
      'entityTypeListParamList' => [
        0 => 'tabList',
        1 => 'quickCreateList',
        2 => 'globalSearchEntityList',
        3 => 'assignmentEmailNotificationsEntityList',
        4 => 'assignmentNotificationsEntityList',
        5 => 'calendarEntityList',
        6 => 'streamEmailNotificationsEntityList',
        7 => 'activitiesEntityList',
        8 => 'historyEntityList',
        9 => 'streamEmailNotificationsTypeList',
        10 => 'emailKeepParentTeamsEntityList'
      ],
      'params' => (object) [
        'isDeveloperMode' => (object) [
          'readOnly' => true
        ],
        'clientSecurityHeadersDisabled' => (object) [
          'readOnly' => true
        ],
        'clientCspDisabled' => (object) [
          'readOnly' => true
        ],
        'clientCspScriptSourceList' => (object) [
          'readOnly' => true
        ],
        'clientStrictTransportSecurityHeaderDisabled' => (object) [
          'readOnly' => true
        ],
        'clientXFrameOptionsHeaderDisabled' => (object) [
          'readOnly' => true
        ],
        'systemUserId' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smtpPassword' => (object) [
          'level' => 'internal'
        ],
        'awsS3Storage' => (object) [
          'level' => 'system'
        ],
        'defaultFileStorage' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smsProvider' => (object) [
          'level' => 'admin'
        ],
        'authAnotherUserDisabled' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'userNameRegularExpression' => (object) [
          'readOnly' => true
        ],
        'workingTimeCalendar' => (object) [
          'level' => 'admin'
        ],
        'ldapPassword' => (object) [
          'level' => 'internal'
        ],
        'oidcClientId' => (object) [
          'level' => 'admin'
        ],
        'oidcClientSecret' => (object) [
          'level' => 'internal'
        ],
        'oidcAuthorizationEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcTokenEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcJwksEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcJwksCachePeriod' => (object) [
          'level' => 'admin'
        ],
        'oidcJwtSignatureAlgorithmList' => (object) [
          'level' => 'admin'
        ],
        'oidcScopes' => (object) [
          'level' => 'admin'
        ],
        'oidcGroupClaim' => (object) [
          'level' => 'admin'
        ],
        'oidcCreateUser' => (object) [
          'level' => 'admin'
        ],
        'oidcUsernameClaim' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsIds' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsNames' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsColumns' => (object) [
          'level' => 'admin'
        ],
        'oidcSync' => (object) [
          'level' => 'admin'
        ],
        'oidcSyncTeams' => (object) [
          'level' => 'admin'
        ],
        'oidcFallback' => (object) [
          'level' => 'admin'
        ],
        'oidcAllowRegularUserFallback' => (object) [
          'level' => 'admin'
        ],
        'oidcAllowAdminUser' => (object) [
          'level' => 'admin'
        ],
        'oidcAuthorizationPrompt' => (object) [
          'level' => 'admin'
        ],
        'oidcAuthorizationMaxAge' => (object) [
          'level' => 'admin'
        ],
        'oidcLogoutUrl' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedMethodList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedHeaderList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedOriginList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsMaxAge' => (object) [
          'level' => 'admin'
        ],
        'customExportManifest' => (object) [
          'level' => 'admin'
        ],
        'starsLimit' => (object) [
          'level' => 'admin'
        ],
        'authIpAddressCheck' => (object) [
          'level' => 'superAdmin'
        ],
        'authIpAddressWhitelist' => (object) [
          'level' => 'superAdmin'
        ],
        'authIpAddressCheckExcludedUsers' => (object) [
          'level' => 'superAdmin'
        ],
        'availableReactions' => (object) [
          'level' => 'default'
        ],
        'emailScheduledBatchCount' => (object) [
          'level' => 'admin'
        ],
        'streamEmailWithContentEntityTypeList' => (object) [
          'level' => 'admin'
        ],
        'defaultPriceBook' => (object) [],
        'priceBooksEnabled' => (object) [],
        'inventoryTransactionsEnabled' => (object) [],
        'warehousesEnabled' => (object) [],
        'deliveryOrdersEnabled' => (object) [],
        'receiptOrdersEnabled' => (object) [],
        'inventoryCompressJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'inventoryDetachJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'notActualOrderLockingJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'productVariantMaxCount' => (object) [],
        'salesForbidOrderUnlock' => (object) [
          'level' => 'default'
        ],
        'eInvoiceFormat' => (object) [
          'level' => 'default'
        ],
        'sellerCompanyName' => (object) [
          'level' => 'admin'
        ],
        'sellerElectronicAddressScheme' => (object) [
          'level' => 'admin'
        ],
        'sellerElectronicAddressIdentifier' => (object) [
          'level' => 'admin'
        ],
        'sellerVatNumber' => (object) [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationScheme' => (object) [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationIdentifier' => (object) [
          'level' => 'admin'
        ],
        'sellerAddress' => (object) [
          'level' => 'admin'
        ],
        'sellerContactName' => (object) [
          'level' => 'admin'
        ],
        'sellerContactEmailAddress' => (object) [
          'level' => 'admin'
        ],
        'sellerContactPhoneNumber' => (object) [
          'level' => 'admin'
        ]
      ]
    ],
    'consoleCommands' => (object) [
      'import' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\Import',
        'listed' => true
      ],
      'clearCache' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'rebuild' => (object) [
        'listed' => true,
        'noSystemUser' => true,
        'allowedFlags' => [
          0 => 'hard',
          1 => 'y'
        ]
      ],
      'updateAppTimestamp' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'appInfo' => (object) [
        'listed' => true
      ],
      'setPassword' => (object) [
        'listed' => true
      ],
      'upgrade' => (object) [
        'listed' => true
      ],
      'extension' => (object) [
        'listed' => true
      ],
      'runJob' => (object) [
        'listed' => true,
        'allowedOptions' => [
          0 => 'job',
          1 => 'targetId',
          2 => 'targetType'
        ]
      ],
      'version' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'createAdminUser' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CreateAdminUser',
        'listed' => true
      ],
      'rebuildCategoryPaths' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\RebuildCategoryPaths',
        'listed' => true
      ],
      'populateArrayValues' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateArrayValues',
        'listed' => true
      ],
      'populateNumbers' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateNumbers',
        'listed' => false
      ],
      'checkFilePermissions' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CheckFilePermissions',
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrate' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrationVersionStep' => (object) [
        'listed' => false,
        'noSystemUser' => true
      ],
      'inventoryAclCheck' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryAclCheck',
        'listed' => false
      ],
      'inventoryCompress' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryCompress',
        'listed' => true
      ],
      'inventoryDetach' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryDetach',
        'listed' => true
      ]
    ],
    'containerServices' => (object) [
      'authTokenManager' => (object) [
        'className' => 'Espo\\Core\\Authentication\\AuthToken\\EspoManager'
      ],
      'ormMetadataData' => (object) [
        'className' => 'Espo\\Core\\Utils\\Metadata\\OrmMetadataData'
      ],
      'classFinder' => (object) [
        'className' => 'Espo\\Core\\Utils\\ClassFinder'
      ],
      'fileStorageManager' => (object) [
        'className' => 'Espo\\Core\\FileStorage\\Manager'
      ],
      'jobManager' => (object) [
        'className' => 'Espo\\Core\\Job\\JobManager'
      ],
      'webSocketSubmission' => (object) [
        'className' => 'Espo\\Core\\WebSocket\\Submission'
      ],
      'crypt' => (object) [
        'className' => 'Espo\\Core\\Utils\\Crypt'
      ],
      'passwordHash' => (object) [
        'className' => 'Espo\\Core\\Utils\\PasswordHash'
      ],
      'number' => (object) [
        'loaderClassName' => 'Espo\\Core\\Loaders\\NumberUtil'
      ],
      'selectBuilderFactory' => (object) [
        'className' => 'Espo\\Core\\Select\\SelectBuilderFactory'
      ],
      'selectManagerFactory' => (object) [
        'className' => 'Espo\\Core\\Select\\SelectManagerFactory'
      ],
      'serviceFactory' => (object) [
        'className' => 'Espo\\Core\\ServiceFactory'
      ],
      'recordServiceContainer' => (object) [
        'className' => 'Espo\\Core\\Record\\ServiceContainer'
      ],
      'templateFileManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\TemplateFileManager'
      ],
      'webhookManager' => (object) [
        'className' => 'Espo\\Core\\Webhook\\Manager'
      ],
      'hookManager' => (object) [
        'className' => 'Espo\\Core\\HookManager'
      ],
      'clientManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\ClientManager'
      ],
      'themeManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\ThemeManager'
      ],
      'fieldUtil' => (object) [
        'className' => 'Espo\\Core\\Utils\\FieldUtil'
      ],
      'emailSender' => (object) [
        'className' => 'Espo\\Core\\Mail\\EmailSender'
      ],
      'mailSender' => (object) [
        'className' => 'Espo\\Core\\Mail\\Sender'
      ],
      'htmlizerFactory' => (object) [
        'className' => 'Espo\\Core\\Htmlizer\\HtmlizerFactory'
      ],
      'fieldValidationManager' => (object) [
        'className' => 'Espo\\Core\\FieldValidation\\FieldValidationManager'
      ],
      'assignmentCheckerManager' => (object) [
        'className' => 'Espo\\Core\\Acl\\AssignmentChecker\\AssignmentCheckerManager'
      ],
      'hasher' => (object) [
        'className' => 'Espo\\Core\\Utils\\Hasher'
      ],
      'emailFilterManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\EmailFilterManager'
      ],
      'externalAccountClientManager' => (object) [
        'className' => 'Espo\\Core\\ExternalAccount\\ClientManager'
      ],
      'formulaManager' => (object) [
        'className' => 'Espo\\Core\\Formula\\Manager'
      ],
      'user' => (object) [
        'settable' => true
      ],
      'streamService' => (object) [
        'className' => 'Espo\\Tools\\Stream\\Service'
      ],
      'workflowManager' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowManager'
      ],
      'workflowHelper' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowHelper'
      ],
      'signalManager' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\SignalManager'
      ]
    ],
    'currency' => (object) [
      'symbolMap' => (object) [
        'AED' => 'د.إ',
        'AFN' => '؋',
        'ALL' => 'L',
        'ANG' => 'ƒ',
        'AOA' => 'Kz',
        'ARS' => '$',
        'AUD' => '$',
        'AWG' => 'ƒ',
        'AZN' => '₼',
        'BAM' => 'KM',
        'BBD' => '$',
        'BDT' => '৳',
        'BGN' => 'лв',
        'BHD' => '.د.ب',
        'BIF' => 'FBu',
        'BMD' => '$',
        'BND' => '$',
        'BOB' => 'Bs.',
        'BRL' => 'R$',
        'BSD' => '$',
        'BTN' => 'Nu.',
        'BWP' => 'P',
        'BYN' => 'Br',
        'BYR' => 'p.',
        'BZD' => 'BZ$',
        'CAD' => '$',
        'CDF' => 'FC',
        'CHF' => 'Fr.',
        'CLP' => '$',
        'CNY' => '¥',
        'COP' => '$',
        'CRC' => '₡',
        'CUC' => '$',
        'CUP' => '₱',
        'CVE' => '$',
        'CZK' => 'Kč',
        'DJF' => 'Fdj',
        'DKK' => 'kr',
        'DOP' => 'RD$',
        'DZD' => 'دج',
        'EEK' => 'kr',
        'EGP' => '£',
        'ERN' => 'Nfk',
        'ETB' => 'Br',
        'EUR' => '€',
        'FJD' => '$',
        'FKP' => '£',
        'GBP' => '£',
        'GEL' => '₾',
        'GGP' => '£',
        'GHC' => '₵',
        'GHS' => 'GH₵',
        'GIP' => '£',
        'GMD' => 'D',
        'GNF' => 'FG',
        'GTQ' => 'Q',
        'GYD' => '$',
        'HKD' => '$',
        'HNL' => 'L',
        'HRK' => 'kn',
        'HTG' => 'G',
        'HUF' => 'Ft',
        'IDR' => 'Rp',
        'ILS' => '₪',
        'IMP' => '£',
        'INR' => '₹',
        'IQD' => 'ع.د',
        'IRR' => '﷼',
        'ISK' => 'kr',
        'JEP' => '£',
        'JMD' => 'J$',
        'JPY' => '¥',
        'KES' => 'KSh',
        'KGS' => 'лв',
        'KHR' => '៛',
        'KMF' => 'CF',
        'KPW' => '₩',
        'KRW' => '₩',
        'KYD' => '$',
        'KZT' => '₸',
        'LAK' => '₭',
        'LBP' => '£',
        'LKR' => '₨',
        'LRD' => '$',
        'LSL' => 'M',
        'LTL' => 'Lt',
        'LVL' => 'Ls',
        'MAD' => 'MAD',
        'MDL' => 'lei',
        'MGA' => 'Ar',
        'MKD' => 'ден',
        'MMK' => 'K',
        'MNT' => '₮',
        'MOP' => 'MOP$',
        'MUR' => '₨',
        'MVR' => 'Rf',
        'MWK' => 'MK',
        'MXN' => '$',
        'MYR' => 'RM',
        'MZN' => 'MT',
        'NAD' => '$',
        'NGN' => '₦',
        'NIO' => 'C$',
        'NOK' => 'kr',
        'NPR' => '₨',
        'NZD' => '$',
        'OMR' => '﷼',
        'PAB' => 'B/.',
        'PEN' => 'S/.',
        'PGK' => 'K',
        'PHP' => '₱',
        'PKR' => '₨',
        'PLN' => 'zł',
        'PYG' => 'Gs',
        'QAR' => '﷼',
        'RMB' => '￥',
        'RON' => 'lei',
        'RSD' => 'Дин.',
        'RUB' => '₽',
        'RWF' => 'R₣',
        'SAR' => '﷼',
        'SBD' => '$',
        'SCR' => '₨',
        'SDG' => 'ج.س.',
        'SEK' => 'kr',
        'SGD' => '$',
        'SHP' => '£',
        'SLL' => 'Le',
        'SOS' => 'S',
        'SRD' => '$',
        'SSP' => '£',
        'STD' => 'Db',
        'SVC' => '$',
        'SYP' => '£',
        'SZL' => 'E',
        'THB' => '฿',
        'TJS' => 'SM',
        'TMT' => 'T',
        'TND' => 'د.ت',
        'TOP' => 'T$',
        'TRL' => '₤',
        'TRY' => '₺',
        'TTD' => 'TT$',
        'TVD' => '$',
        'TWD' => 'NT$',
        'TZS' => 'TSh',
        'UAH' => '₴',
        'UGX' => 'USh',
        'USD' => '$',
        'UYU' => '$U',
        'UZS' => 'лв',
        'VEF' => 'Bs',
        'VND' => '₫',
        'VUV' => 'VT',
        'WST' => 'WS$',
        'XAF' => 'FCFA',
        'XBT' => 'Ƀ',
        'XCD' => '$',
        'XOF' => 'CFA',
        'XPF' => '₣',
        'YER' => '﷼',
        'ZAR' => 'R',
        'ZWD' => 'Z$',
        'BTC' => '฿'
      ],
      'list' => [
        0 => 'AFN',
        1 => 'AED',
        2 => 'ALL',
        3 => 'ANG',
        4 => 'AOA',
        5 => 'ARS',
        6 => 'AUD',
        7 => 'BAM',
        8 => 'BDT',
        9 => 'BGN',
        10 => 'BHD',
        11 => 'BND',
        12 => 'BOB',
        13 => 'BRL',
        14 => 'BWP',
        15 => 'BYN',
        16 => 'CAD',
        17 => 'CHF',
        18 => 'CLP',
        19 => 'CNY',
        20 => 'COP',
        21 => 'CRC',
        22 => 'CVE',
        23 => 'CZK',
        24 => 'DKK',
        25 => 'DOP',
        26 => 'DZD',
        27 => 'EGP',
        28 => 'EUR',
        29 => 'FJD',
        30 => 'GBP',
        31 => 'GNF',
        32 => 'GTQ',
        33 => 'HKD',
        34 => 'HNL',
        35 => 'HRK',
        36 => 'HUF',
        37 => 'IDR',
        38 => 'ILS',
        39 => 'INR',
        40 => 'IRR',
        41 => 'JMD',
        42 => 'JOD',
        43 => 'JPY',
        44 => 'KES',
        45 => 'KRW',
        46 => 'KWD',
        47 => 'KYD',
        48 => 'KZT',
        49 => 'LBP',
        50 => 'LKR',
        51 => 'MAD',
        52 => 'MDL',
        53 => 'MKD',
        54 => 'MMK',
        55 => 'MUR',
        56 => 'MXN',
        57 => 'MYR',
        58 => 'MZN',
        59 => 'NAD',
        60 => 'NGN',
        61 => 'NIO',
        62 => 'NOK',
        63 => 'NPR',
        64 => 'NZD',
        65 => 'OMR',
        66 => 'PEN',
        67 => 'PGK',
        68 => 'PHP',
        69 => 'PKR',
        70 => 'PLN',
        71 => 'PYG',
        72 => 'QAR',
        73 => 'RON',
        74 => 'RSD',
        75 => 'RUB',
        76 => 'SAR',
        77 => 'SCR',
        78 => 'SEK',
        79 => 'SGD',
        80 => 'SLL',
        81 => 'SVC',
        82 => 'THB',
        83 => 'TND',
        84 => 'TRY',
        85 => 'TTD',
        86 => 'TWD',
        87 => 'TZS',
        88 => 'UAH',
        89 => 'UGX',
        90 => 'USD',
        91 => 'UYU',
        92 => 'UZS',
        93 => 'VND',
        94 => 'XAF',
        95 => 'YER',
        96 => 'ZAR',
        97 => 'ZMW',
        98 => 'ZWL'
      ]
    ],
    'currencyConversion' => (object) [
      'entityConverterClassNameMap' => (object) [
        'Quote' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'SalesOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Invoice' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'PurchaseOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'DeliveryOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReceiptOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'TransferOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReturnOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Opportunity' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter'
      ]
    ],
    'databasePlatforms' => (object) [
      'Mysql' => (object) [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\MysqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\MysqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\MysqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\MysqlColumnPreparator',
        'preRebuildActionClassNameList' => [
          0 => 'Espo\\Core\\Utils\\Database\\Schema\\RebuildActions\\PrepareForFulltextIndex'
        ],
        'postRebuildActionClassNameList' => [],
        'dbalTypeClassNameMap' => (object) [
          'mediumtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\MediumtextType',
          'longtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\LongtextType',
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ],
      'Postgresql' => (object) [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\PostgresqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\PostgresqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\PostgresqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\PostgresqlColumnPreparator',
        'dbalTypeClassNameMap' => (object) [
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ]
    ],
    'dateTime' => (object) [
      'dateFormatList' => [
        0 => 'DD.MM.YYYY',
        1 => 'MM/DD/YYYY',
        2 => 'DD/MM/YYYY',
        3 => 'YYYY-MM-DD',
        4 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm',
        1 => 'hh:mma',
        2 => 'hh:mmA',
        3 => 'hh:mm A',
        4 => 'hh:mm a'
      ]
    ],
    'defaultDashboardLayouts' => (object) [
      'Standard' => [
        0 => (object) [
          'name' => 'My Espo',
          'layout' => [
            0 => (object) [
              'id' => 'defaultActivities',
              'name' => 'Activities',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'defaultStream',
              'name' => 'Stream',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 4
            ],
            2 => (object) [
              'id' => 'defaultTasks',
              'name' => 'Tasks',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ]
          ]
        ]
      ]
    ],
    'defaultDashboardOptions' => (object) [
      'Standard' => (object) [
        'defaultStream' => (object) [
          'displayRecords' => 10
        ]
      ]
    ],
    'emailTemplate' => (object) [
      'placeholders' => (object) [
        'today' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Today',
          'order' => 0
        ],
        'now' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Now',
          'order' => 1
        ],
        'currentYear' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\CurrentYear',
          'order' => 2
        ]
      ]
    ],
    'entityManager' => (object) [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusCreateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventCreateHook'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusDeleteHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventDeleteHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\DeleteHasChildrenLinks'
      ],
      'updateHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\AssignedUsersUpdateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\CollaboratorsUpdateHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\StreamUpdateHook'
      ]
    ],
    'entityManagerParams' => (object) [
      'Global' => (object) [
        'stars' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'optimisticConcurrencyControl' => (object) [
          'location' => 'entityDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'preserveAuditLog' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Company' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@Person' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true
          ],
          'view' => 'views/admin/entity-manager/fields/acl-account-link'
        ]
      ],
      '@Base' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@BasePlus' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Account' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Contact' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Lead' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Opportunity' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Document' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Case' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'KnowledgeBaseArticle' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Meeting' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Call' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Task' => (object) [
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'TargetList' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Event' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Product' => (object) [
        'variantSyncFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/product-variant-sync-field-list',
            'tooltip' => 'productVariantSyncFieldList'
          ]
        ]
      ],
      'SalesOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderSoftReserveStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderCanceledStatusList'
          ]
        ],
        'deliveryRequiredStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'deliveryRequiredStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'DeliveryOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'TransferOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'PurchaseOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReceiptOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Quote' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Invoice' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReturnOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'InventoryAdjustment' => (object) [
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ]
    ],
    'entityTemplateList' => [
      0 => 'Base',
      1 => 'BasePlus',
      2 => 'Event',
      3 => 'Person',
      4 => 'Company'
    ],
    'entityTemplates' => (object) [
      'Base' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Base',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Base'
      ],
      'BasePlus' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\BasePlus',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\BasePlus'
      ],
      'Event' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Event',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Event'
      ],
      'Company' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Company',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Company'
      ],
      'Person' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Person',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Person'
      ]
    ],
    'export' => (object) [
      'formatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ],
      'formatDefs' => (object) [
        'csv' => (object) [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\Processor',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\AdditionalFieldsLoader',
          'mimeType' => 'text/csv',
          'fileExtension' => 'csv'
        ],
        'xlsx' => (object) [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\Processor',
          'processorParamsHandler' => 'Espo\\Tools\\Export\\Format\\Xlsx\\ParamsHandler',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\AdditionalFieldsLoader',
          'mimeType' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
          'fileExtension' => 'xlsx',
          'cellValuePreparatorClassNameMap' => (object) [
            'link' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkOne' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkParent' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'file' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'bool' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Boolean',
            'int' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Integer',
            'float' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Floating',
            'currency' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Currency',
            'currencyConverted' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\CurrencyConverted',
            'personName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\PersonName',
            'date' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Date',
            'datetime' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTime',
            'datetimeOptional' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTimeOptional',
            'linkMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'attachmentMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'address' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Address',
            'duration' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Duration',
            'enum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Enumeration',
            'multiEnum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'array' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'checklist' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'urlMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum'
          ],
          'params' => (object) [
            'fields' => (object) [
              'lite' => (object) [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ],
              'recordLinks' => (object) [
                'type' => 'bool',
                'default' => false
              ],
              'title' => (object) [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ]
            ],
            'layout' => [
              0 => [
                0 => (object) [
                  'name' => 'lite'
                ],
                1 => (object) [
                  'name' => 'recordLinks'
                ],
                2 => (object) [
                  'name' => 'title'
                ]
              ]
            ],
            'dynamicLogic' => (object) [
              'recordLinks' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ],
              'title' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'gridReportFormatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ]
    ],
    'fieldProcessing' => (object) [
      'readLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\Link\\HasOneLoader',
        1 => 'Espo\\Core\\FieldProcessing\\Link\\NotJoinedLoader',
        2 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\Loader',
        3 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        4 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Loader',
        5 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Loader',
        6 => 'Espo\\Core\\FieldProcessing\\Stream\\FollowersLoader',
        7 => 'Espo\\Core\\FieldProcessing\\Stars\\StarLoader'
      ],
      'listLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        1 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'saverClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Saver',
        1 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Saver',
        2 => 'Espo\\Core\\FieldProcessing\\Relation\\Saver',
        3 => 'Espo\\Core\\FieldProcessing\\MultiEnum\\Saver',
        4 => 'Espo\\Core\\FieldProcessing\\File\\Saver',
        5 => 'Espo\\Core\\FieldProcessing\\Wysiwyg\\Saver'
      ]
    ],
    'file' => (object) [
      'extensionMimeTypeMap' => (object) [
        'aac' => [
          0 => 'audio/aac'
        ],
        'abw' => [
          0 => 'application/x-abiword'
        ],
        'arc' => [
          0 => 'application/x-freearc'
        ],
        'avif' => [
          0 => 'image/avif'
        ],
        'avi' => [
          0 => 'video/x-msvideo'
        ],
        'azw' => [
          0 => 'application/vnd.amazon.ebook'
        ],
        'bin' => [
          0 => 'application/octet-stream'
        ],
        'bmp' => [
          0 => 'image/bmp'
        ],
        'bz' => [
          0 => 'application/x-bzip'
        ],
        'bz2' => [
          0 => 'application/x-bzip2'
        ],
        'cda' => [
          0 => 'application/x-cdf'
        ],
        'csh' => [
          0 => 'application/x-csh'
        ],
        'css' => [
          0 => 'text/css'
        ],
        'csv' => [
          0 => 'text/csv'
        ],
        'doc' => [
          0 => 'application/msword'
        ],
        'docx' => [
          0 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        ],
        'eot' => [
          0 => 'application/vnd.ms-fontobject'
        ],
        'epub' => [
          0 => 'application/epub+zip'
        ],
        'gz' => [
          0 => 'application/gzip'
        ],
        'gif' => [
          0 => 'image/gif'
        ],
        'htm' => [
          0 => 'text/html'
        ],
        'html' => [
          0 => 'text/html'
        ],
        'ico' => [
          0 => 'image/vnd.microsoft.icon'
        ],
        'ics' => [
          0 => 'text/calendar'
        ],
        'jar' => [
          0 => 'application/java-archive'
        ],
        'jpeg' => [
          0 => 'image/jpeg'
        ],
        'jpg' => [
          0 => 'image/jpeg'
        ],
        'js' => [
          0 => 'text/javascript'
        ],
        'json' => [
          0 => 'application/json'
        ],
        'jsonld' => [
          0 => 'application/ld+json'
        ],
        'mid' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'midi' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'mjs' => [
          0 => 'text/javascript'
        ],
        'mp3' => [
          0 => 'audio/mpeg'
        ],
        'mp4' => [
          0 => 'video/mp4'
        ],
        'mpeg' => [
          0 => 'video/mpeg'
        ],
        'mpkg' => [
          0 => 'application/vnd.apple.installer+xml'
        ],
        'odp' => [
          0 => 'application/vnd.oasis.opendocument.presentation'
        ],
        'ods' => [
          0 => 'application/vnd.oasis.opendocument.spreadsheet'
        ],
        'odt' => [
          0 => 'application/vnd.oasis.opendocument.text'
        ],
        'oga' => [
          0 => 'audio/ogg'
        ],
        'ogv' => [
          0 => 'video/ogg'
        ],
        'ogx' => [
          0 => 'application/ogg'
        ],
        'opus' => [
          0 => 'audio/opus'
        ],
        'otf' => [
          0 => 'font/otf'
        ],
        'png' => [
          0 => 'image/png'
        ],
        'pdf' => [
          0 => 'application/pdf'
        ],
        'php' => [
          0 => 'application/x-httpd-php'
        ],
        'ppt' => [
          0 => 'application/vnd.ms-powerpoint'
        ],
        'pptx' => [
          0 => 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
        ],
        'rar' => [
          0 => 'application/vnd.rar'
        ],
        'rtf' => [
          0 => 'application/rtf'
        ],
        'sh' => [
          0 => 'application/x-sh'
        ],
        'svg' => [
          0 => 'image/svg+xml'
        ],
        'swf' => [
          0 => 'application/x-shockwave-flash'
        ],
        'tar' => [
          0 => 'application/x-tar'
        ],
        'tif' => [
          0 => 'image/tiff'
        ],
        'tiff' => [
          0 => 'image/tiff'
        ],
        'ts' => [
          0 => 'video/mp2t'
        ],
        'ttf' => [
          0 => 'font/ttf'
        ],
        'txt' => [
          0 => 'text/plain'
        ],
        'vsd' => [
          0 => 'application/vnd.visio'
        ],
        'wav' => [
          0 => 'audio/wav'
        ],
        'weba' => [
          0 => 'audio/webm'
        ],
        'webm' => [
          0 => 'video/webm'
        ],
        'webp' => [
          0 => 'image/webp'
        ],
        'woff' => [
          0 => 'font/woff'
        ],
        'woff2' => [
          0 => 'font/woff2'
        ],
        'xhtml' => [
          0 => 'application/xhtml+xml'
        ],
        'xls' => [
          0 => 'application/vnd.ms-excel'
        ],
        'xlsx' => [
          0 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ],
        'xml' => [
          0 => 'application/xml'
        ],
        'xul' => [
          0 => 'application/vnd.mozilla.xul+xml'
        ],
        'zip' => [
          0 => 'application/zip'
        ],
        '3gp' => [
          0 => 'video/3gpp',
          1 => 'audio/3gpp'
        ],
        '3g2' => [
          0 => 'video/3gpp2',
          1 => 'audio/3gpp2'
        ],
        '7z' => [
          0 => 'application/x-7z-compressed'
        ],
        'md' => [
          0 => 'text/markdown'
        ]
      ],
      'inlineMimeTypeList' => [
        0 => 'application/pdf',
        1 => 'text/plain',
        2 => 'audio/wav',
        3 => 'audio/mpeg',
        4 => 'audio/ogg',
        5 => 'audio/webm',
        6 => 'video/mpeg',
        7 => 'video/mp4',
        8 => 'video/ogg',
        9 => 'video/webm',
        10 => 'image/jpeg',
        11 => 'image/png',
        12 => 'image/gif',
        13 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        14 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        15 => 'application/vnd.ms-word',
        16 => 'application/vnd.ms-excel',
        17 => 'application/vnd.oasis.opendocument.text',
        18 => 'application/vnd.oasis.opendocument.spreadsheet',
        19 => 'application/msword',
        20 => 'application/msexcel'
      ]
    ],
    'fileStorage' => (object) [
      'implementationClassNameMap' => (object) [
        'EspoUploadDir' => 'Espo\\Core\\FileStorage\\Storages\\EspoUploadDir',
        'AwsS3' => 'Espo\\Core\\FileStorage\\Storages\\AwsS3'
      ]
    ],
    'formula' => (object) [
      'functionList' => [
        0 => (object) [
          'name' => 'ifThenElse',
          'insertText' => 'ifThenElse(CONDITION, CONSEQUENT, ALTERNATIVE)'
        ],
        1 => (object) [
          'name' => 'ifThen',
          'insertText' => 'ifThen(CONDITION, CONSEQUENT)'
        ],
        2 => (object) [
          'name' => 'list',
          'insertText' => 'list(ITEM_1, ITEM_2)',
          'returnType' => 'array'
        ],
        3 => (object) [
          'name' => 'string\\concatenate',
          'insertText' => 'string\\concatenate(STRING_1, STRING_2)',
          'returnType' => 'string'
        ],
        4 => (object) [
          'name' => 'string\\substring',
          'insertText' => 'string\\substring(STRING, START, LENGTH)',
          'returnType' => 'string'
        ],
        5 => (object) [
          'name' => 'string\\contains',
          'insertText' => 'string\\contains(STRING, NEEDLE)',
          'returnType' => 'bool'
        ],
        6 => (object) [
          'name' => 'string\\pos',
          'insertText' => 'string\\pos(STRING, NEEDLE)',
          'returnType' => 'int'
        ],
        7 => (object) [
          'name' => 'string\\pad',
          'insertText' => 'string\\pad(STRING, LENGTH, PAD_STRING)',
          'returnType' => 'string'
        ],
        8 => (object) [
          'name' => 'string\\test',
          'insertText' => 'string\\test(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'bool'
        ],
        9 => (object) [
          'name' => 'string\\length',
          'insertText' => 'string\\length(STRING)',
          'returnType' => 'int'
        ],
        10 => (object) [
          'name' => 'string\\trim',
          'insertText' => 'string\\trim(STRING)',
          'returnType' => 'string'
        ],
        11 => (object) [
          'name' => 'string\\lowerCase',
          'insertText' => 'string\\lowerCase(STRING)',
          'returnType' => 'string'
        ],
        12 => (object) [
          'name' => 'string\\upperCase',
          'insertText' => 'string\\upperCase(STRING)',
          'returnType' => 'string'
        ],
        13 => (object) [
          'name' => 'string\\match',
          'insertText' => 'string\\match(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string|null'
        ],
        14 => (object) [
          'name' => 'string\\matchAll',
          'insertText' => 'string\\matchAll(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        15 => (object) [
          'name' => 'string\\matchExtract',
          'insertText' => 'string\\matchExtract(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        16 => (object) [
          'name' => 'string\\replace',
          'insertText' => 'string\\replace(STRING, SEARCH, REPLACE)',
          'returnType' => 'string'
        ],
        17 => (object) [
          'name' => 'string\\split',
          'insertText' => 'string\\split(STRING, SEPARATOR)',
          'returnType' => 'string[]'
        ],
        18 => (object) [
          'name' => 'datetime\\today',
          'insertText' => 'datetime\\today()',
          'returnType' => 'string'
        ],
        19 => (object) [
          'name' => 'datetime\\now',
          'insertText' => 'datetime\\now()',
          'returnType' => 'string'
        ],
        20 => (object) [
          'name' => 'datetime\\format',
          'insertText' => 'datetime\\format(VALUE)',
          'returnType' => 'string'
        ],
        21 => (object) [
          'name' => 'datetime\\date',
          'insertText' => 'datetime\\date(VALUE)',
          'returnType' => 'int'
        ],
        22 => (object) [
          'name' => 'datetime\\month',
          'insertText' => 'datetime\\month(VALUE)',
          'returnType' => 'int'
        ],
        23 => (object) [
          'name' => 'datetime\\year',
          'insertText' => 'datetime\\year(VALUE)',
          'returnType' => 'int'
        ],
        24 => (object) [
          'name' => 'datetime\\hour',
          'insertText' => 'datetime\\hour(VALUE)',
          'returnType' => 'int'
        ],
        25 => (object) [
          'name' => 'datetime\\minute',
          'insertText' => 'datetime\\minute(VALUE)',
          'returnType' => 'int'
        ],
        26 => (object) [
          'name' => 'datetime\\dayOfWeek',
          'insertText' => 'datetime\\dayOfWeek(VALUE)',
          'returnType' => 'int'
        ],
        27 => (object) [
          'name' => 'datetime\\addMinutes',
          'insertText' => 'datetime\\addMinutes(VALUE, MINUTES)',
          'returnType' => 'string'
        ],
        28 => (object) [
          'name' => 'datetime\\addHours',
          'insertText' => 'datetime\\addHours(VALUE, HOURS)',
          'returnType' => 'string'
        ],
        29 => (object) [
          'name' => 'datetime\\addDays',
          'insertText' => 'datetime\\addDays(VALUE, DAYS)',
          'returnType' => 'string'
        ],
        30 => (object) [
          'name' => 'datetime\\addWeeks',
          'insertText' => 'datetime\\addWeeks(VALUE, WEEKS)',
          'returnType' => 'string'
        ],
        31 => (object) [
          'name' => 'datetime\\addMonths',
          'insertText' => 'datetime\\addMonths(VALUE, MONTHS)',
          'returnType' => 'string'
        ],
        32 => (object) [
          'name' => 'datetime\\addYears',
          'insertText' => 'datetime\\addYears(VALUE, YEARS)',
          'returnType' => 'string'
        ],
        33 => (object) [
          'name' => 'datetime\\diff',
          'insertText' => 'datetime\\diff(VALUE_1, VALUE_2, INTERVAL_TYPE)',
          'returnType' => 'int'
        ],
        34 => (object) [
          'name' => 'datetime\\closest',
          'insertText' => 'datetime\\closest(VALUE, TYPE, TARGET, IS_PAST, TIMEZONE)',
          'returnType' => 'string'
        ],
        35 => (object) [
          'name' => 'number\\format',
          'insertText' => 'number\\format(VALUE)',
          'returnType' => 'string'
        ],
        36 => (object) [
          'name' => 'number\\abs',
          'insertText' => 'number\\abs(VALUE)'
        ],
        37 => (object) [
          'name' => 'number\\power',
          'insertText' => 'number\\power(VALUE, EXP)',
          'returnType' => 'int|float'
        ],
        38 => (object) [
          'name' => 'number\\round',
          'insertText' => 'number\\round(VALUE, PRECISION)',
          'returnType' => 'int|float'
        ],
        39 => (object) [
          'name' => 'number\\floor',
          'insertText' => 'number\\floor(VALUE)',
          'returnType' => 'int'
        ],
        40 => (object) [
          'name' => 'number\\ceil',
          'insertText' => 'number\\ceil(VALUE)',
          'returnType' => 'int'
        ],
        41 => (object) [
          'name' => 'number\\randomInt',
          'insertText' => 'number\\randomInt(MIN, MAX)',
          'returnType' => 'int'
        ],
        42 => (object) [
          'name' => 'number\\parseInt',
          'insertText' => 'number\\parseInt(STRING)',
          'returnType' => 'int'
        ],
        43 => (object) [
          'name' => 'number\\parseFloat',
          'insertText' => 'number\\parseFloat(STRING)',
          'returnType' => 'float'
        ],
        44 => (object) [
          'name' => 'entity\\isNew',
          'insertText' => 'entity\\isNew()',
          'returnType' => 'bool'
        ],
        45 => (object) [
          'name' => 'entity\\isAttributeChanged',
          'insertText' => 'entity\\isAttributeChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        46 => (object) [
          'name' => 'entity\\isAttributeNotChanged',
          'insertText' => 'entity\\isAttributeNotChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        47 => (object) [
          'name' => 'entity\\attribute',
          'insertText' => 'entity\\attribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        48 => (object) [
          'name' => 'entity\\attributeFetched',
          'insertText' => 'entity\\attributeFetched(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        49 => (object) [
          'name' => 'entity\\setAttribute',
          'insertText' => 'entity\\setAttribute(ATTRIBUTE, VALUE)',
          'unsafe' => true
        ],
        50 => (object) [
          'name' => 'entity\\clearAttribute',
          'insertText' => 'entity\\clearAttribute(ATTRIBUTE)',
          'unsafe' => true
        ],
        51 => (object) [
          'name' => 'entity\\addLinkMultipleId',
          'insertText' => 'entity\\addLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        52 => (object) [
          'name' => 'entity\\hasLinkMultipleId',
          'insertText' => 'entity\\hasLinkMultipleId(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        53 => (object) [
          'name' => 'entity\\removeLinkMultipleId',
          'insertText' => 'entity\\removeLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        54 => (object) [
          'name' => 'entity\\getLinkColumn',
          'insertText' => 'entity\\getLinkColumn(LINK, ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        55 => (object) [
          'name' => 'entity\\setLinkMultipleColumn',
          'insertText' => 'entity\\setLinkMultipleColumn(LINK, ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        56 => (object) [
          'name' => 'entity\\isRelated',
          'insertText' => 'entity\\isRelated(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        57 => (object) [
          'name' => 'entity\\sumRelated',
          'insertText' => 'entity\\sumRelated(LINK, FIELD, FILTER)',
          'returnType' => 'int|float',
          'unsafe' => true
        ],
        58 => (object) [
          'name' => 'entity\\countRelated',
          'insertText' => 'entity\\countRelated(LINK, FILTER)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        59 => (object) [
          'name' => 'record\\exists',
          'insertText' => 'record\\exists(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        60 => (object) [
          'name' => 'record\\count',
          'insertText' => 'record\\count(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        61 => (object) [
          'name' => 'record\\attribute',
          'insertText' => 'record\\attribute(ENTITY_TYPE, ID, ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        62 => (object) [
          'name' => 'record\\findOne',
          'insertText' => 'record\\findOne(ENTITY_TYPE, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        63 => (object) [
          'name' => 'record\\findMany',
          'insertText' => 'record\\findMany(ENTITY_TYPE, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        64 => (object) [
          'name' => 'record\\findRelatedOne',
          'insertText' => 'record\\findRelatedOne(ENTITY_TYPE, ID, LINK, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        65 => (object) [
          'name' => 'record\\findRelatedMany',
          'insertText' => 'record\\findRelatedMany(ENTITY_TYPE, ID, LINK, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string[]',
          'unsafe' => true
        ],
        66 => (object) [
          'name' => 'record\\fetch',
          'insertText' => 'record\\fetch(ENTITY_TYPE, ID)',
          'returnType' => '?object',
          'unsafe' => true
        ],
        67 => (object) [
          'name' => 'record\\relate',
          'insertText' => 'record\\relate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        68 => (object) [
          'name' => 'record\\unrelate',
          'insertText' => 'record\\unrelate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        69 => (object) [
          'name' => 'record\\create',
          'insertText' => 'record\\create(ENTITY_TYPE, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        70 => (object) [
          'name' => 'record\\update',
          'insertText' => 'record\\update(ENTITY_TYPE, ID, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'unsafe' => true
        ],
        71 => (object) [
          'name' => 'record\\delete',
          'insertText' => 'record\\delete(ENTITY_TYPE, ID)',
          'unsafe' => true
        ],
        72 => (object) [
          'name' => 'record\\relationColumn',
          'insertText' => 'record\\relationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        73 => (object) [
          'name' => 'record\\updateRelationColumn',
          'insertText' => 'record\\updateRelationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        74 => (object) [
          'name' => 'env\\userAttribute',
          'insertText' => 'env\\userAttribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        75 => (object) [
          'name' => 'util\\generateId',
          'insertText' => 'util\\generateId()',
          'returnType' => 'string'
        ],
        76 => (object) [
          'name' => 'util\\generateRecordId',
          'insertText' => 'util\\generateRecordId()',
          'returnType' => 'string'
        ],
        77 => (object) [
          'name' => 'util\\base64Encode',
          'insertText' => 'util\\base64Encode(STRING)',
          'returnType' => 'string'
        ],
        78 => (object) [
          'name' => 'util\\base64Decode',
          'insertText' => 'util\\base64Decode(STRING)',
          'returnType' => 'string'
        ],
        79 => (object) [
          'name' => 'object\\create',
          'insertText' => 'object\\create()',
          'returnType' => 'object'
        ],
        80 => (object) [
          'name' => 'object\\get',
          'insertText' => 'object\\get(OBJECT, KEY)',
          'returnType' => 'mixed'
        ],
        81 => (object) [
          'name' => 'object\\has',
          'insertText' => 'object\\has(OBJECT, KEY)',
          'returnType' => 'bool'
        ],
        82 => (object) [
          'name' => 'object\\set',
          'insertText' => 'object\\set(OBJECT, KEY, VALUE)'
        ],
        83 => (object) [
          'name' => 'object\\clear',
          'insertText' => 'object\\clear(OBJECT, KEY)',
          'returnType' => 'object'
        ],
        84 => (object) [
          'name' => 'object\\cloneDeep',
          'insertText' => 'object\\cloneDeep(OBJECT)',
          'returnType' => 'object'
        ],
        85 => (object) [
          'name' => 'password\\generate',
          'insertText' => 'password\\generate()',
          'returnType' => 'string'
        ],
        86 => (object) [
          'name' => 'password\\hash',
          'insertText' => 'password\\hash(PASSWORD)',
          'returnType' => 'string'
        ],
        87 => (object) [
          'name' => 'array\\includes',
          'insertText' => 'array\\includes(LIST, VALUE)',
          'returnType' => 'bool'
        ],
        88 => (object) [
          'name' => 'array\\push',
          'insertText' => 'array\\push(LIST, VALUE)'
        ],
        89 => (object) [
          'name' => 'array\\length',
          'insertText' => 'array\\length(LIST)',
          'returnType' => 'int'
        ],
        90 => (object) [
          'name' => 'array\\at',
          'insertText' => 'array\\at(LIST, INDEX)',
          'returnType' => 'mixed'
        ],
        91 => (object) [
          'name' => 'array\\join',
          'insertText' => 'array\\join(LIST, SEPARATOR)',
          'returnType' => 'string'
        ],
        92 => (object) [
          'name' => 'array\\indexOf',
          'insertText' => 'array\\indexOf(LIST, ELEMENT)',
          'returnType' => '?int'
        ],
        93 => (object) [
          'name' => 'array\\removeAt',
          'insertText' => 'array\\removeAt(LIST, INDEX)',
          'returnType' => 'array'
        ],
        94 => (object) [
          'name' => 'array\\unique',
          'insertText' => 'array\\unique(LIST)',
          'returnType' => 'array'
        ],
        95 => (object) [
          'name' => 'language\\translate',
          'insertText' => 'language\\translate(LABEL, CATEGORY, SCOPE)',
          'returnType' => 'string'
        ],
        96 => (object) [
          'name' => 'language\\translateOption',
          'insertText' => 'language\\translateOption(OPTION, FIELD, SCOPE)',
          'returnType' => 'string'
        ],
        97 => (object) [
          'name' => 'log\\info',
          'insertText' => 'log\\info(MESSAGE)',
          'unsafe' => true
        ],
        98 => (object) [
          'name' => 'log\\notice',
          'insertText' => 'log\\notice(MESSAGE)',
          'unsafe' => true
        ],
        99 => (object) [
          'name' => 'log\\warning',
          'insertText' => 'log\\warning(MESSAGE)',
          'unsafe' => true
        ],
        100 => (object) [
          'name' => 'log\\error',
          'insertText' => 'log\\error(MESSAGE)',
          'unsafe' => true
        ],
        101 => (object) [
          'name' => 'json\\retrieve',
          'insertText' => 'json\\retrieve(JSON, PATH)',
          'returnType' => 'mixed'
        ],
        102 => (object) [
          'name' => 'json\\encode',
          'insertText' => 'json\\encode(VALUE)',
          'returnType' => 'string'
        ],
        103 => (object) [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        104 => (object) [
          'name' => 'ext\\sms\\send',
          'insertText' => 'ext\\sms\\send(SMS_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        105 => (object) [
          'name' => 'ext\\email\\applyTemplate',
          'insertText' => 'ext\\email\\applyTemplate(EMAIL_ID, EMAIL_TEMPLATE_ID)',
          'unsafe' => true
        ],
        106 => (object) [
          'name' => 'ext\\markdown\\transform',
          'insertText' => 'ext\\markdown\\transform(STRING)',
          'returnType' => 'string'
        ],
        107 => (object) [
          'name' => 'ext\\pdf\\generate',
          'insertText' => 'ext\\pdf\\generate(ENTITY_TYPE, ENTITY_ID, TEMPLATE_ID, FILENAME)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        108 => (object) [
          'name' => 'ext\\workingTime\\addWorkingDays',
          'insertText' => 'ext\\workingTime\\addWorkingDays(DATE, DAYS)',
          'returnType' => 'string|null'
        ],
        109 => (object) [
          'name' => 'ext\\workingTime\\findClosestWorkingTime',
          'insertText' => 'ext\\workingTime\\findClosestWorkingTime(DATE)',
          'returnType' => 'string|null'
        ],
        110 => (object) [
          'name' => 'ext\\workingTime\\getSummedWorkingHours',
          'insertText' => 'ext\\workingTime\\getSummedWorkingHours(FROM, TO)',
          'returnType' => 'float'
        ],
        111 => (object) [
          'name' => 'ext\\workingTime\\getWorkingDays',
          'insertText' => 'ext\\workingTime\\getWorkingDays(FROM, TO)',
          'returnType' => 'int'
        ],
        112 => (object) [
          'name' => 'ext\\workingTime\\hasWorkingTime',
          'insertText' => 'ext\\workingTime\\hasWorkingTime(FROM, TO)',
          'returnType' => 'bool'
        ],
        113 => (object) [
          'name' => 'ext\\workingTime\\isWorkingDay',
          'insertText' => 'ext\\workingTime\\isWorkingDay(DATE)',
          'returnType' => 'bool'
        ],
        114 => (object) [
          'name' => 'ext\\user\\sendAccessInfo',
          'insertText' => 'ext\\user\\sendAccessInfo(USER_ID)',
          'unsafe' => true
        ],
        115 => (object) [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        116 => (object) [
          'name' => 'ext\\currency\\convert',
          'insertText' => 'ext\\currency\\convert(AMOUNT, FROM_CODE)',
          'returnType' => 'string'
        ],
        117 => (object) [
          'name' => 'ext\\acl\\checkEntity',
          'insertText' => 'ext\\acl\\checkEntity(USER_ID, ENTITY_TYPE, ID, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        118 => (object) [
          'name' => 'ext\\acl\\checkScope',
          'insertText' => 'ext\\acl\\checkScope(USER_ID, SCOPE, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        119 => (object) [
          'name' => 'ext\\acl\\getLevel',
          'insertText' => 'ext\\acl\\getLevel(USER_ID, SCOPE, ACTION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        120 => (object) [
          'name' => 'ext\\acl\\getPermissionLevel',
          'insertText' => 'ext\\acl\\getPermissionLevel(USER_ID, PERMISSION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        121 => (object) [
          'name' => 'ext\\account\\findByEmailAddress',
          'insertText' => 'ext\\account\\findByEmailAddress(EMAIL_ADDRESS)',
          'returnType' => 'string'
        ],
        122 => (object) [
          'name' => 'ext\\calendar\\userIsBusy',
          'insertText' => 'ext\\calendar\\userIsBusy(USER_ID, FROM, TO)',
          'returnType' => 'bool'
        ],
        123 => (object) [
          'name' => 'report\\export',
          'insertText' => 'report\\export(\'REPORT_ID\')',
          'returnType' => 'string',
          'unsafe' => true
        ],
        124 => (object) [
          'name' => 'report\\recordAttribute',
          'unsafe' => true
        ],
        125 => (object) [
          'name' => 'bpm\\processEntity\\attribute',
          'insertText' => 'bpm\\processEntity\\attribute(\'ATTRIBUTE_NAME\')',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        126 => (object) [
          'name' => 'bpm\\targetEntity\\attribute',
          'insertText' => 'bpm\\targetEntity\\attribute(\'ATTRIBUTE_NAME)\'',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        127 => (object) [
          'name' => 'bpm\\createdEntity\\attribute',
          'insertText' => 'bpm\\createdEntity\\attribute(\'ALIAS_ID\', \'ATTRIBUTE_NAME\')',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        128 => (object) [
          'name' => 'bpm\\broadcastSignal',
          'insertText' => 'bpm\\broadcastSignal(SIGNAL_NAME, [ENTITY_TYPE], [ENTITY_ID])',
          'unsafe' => true
        ],
        129 => (object) [
          'name' => 'bpm\\startProcess',
          'insertText' => 'bpm\\startProcess(FLOWCHART_ID, TARGET_TYPE, TARGET_ID)',
          'unsafe' => true
        ],
        130 => (object) [
          'name' => 'bpm\\caughtErrorCode',
          'insertText' => 'bpm\\caughtErrorCode()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        131 => (object) [
          'name' => 'bpm\\caughtErrorMessage',
          'insertText' => 'bpm\\caughtErrorMessage()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        132 => (object) [
          'name' => 'workflow\\targetEntity\\attribute',
          'insertText' => 'workflow\\targetEntity\\attribute(\'ATTRIBUTE_NAME\')',
          'unsafe' => true
        ],
        133 => (object) [
          'name' => 'workflow\\targetEntity\\attributeFetched',
          'insertText' => 'workflow\\targetEntity\\attributeFetched(\'ATTRIBUTE_NAME\')',
          'unsafe' => true
        ],
        134 => (object) [
          'name' => 'workflow\\trigger',
          'insertText' => 'workflow\\trigger(ENTITY_TYPE, ID, WORKFLOW_ID)',
          'unsafe' => true
        ],
        135 => (object) [
          'name' => 'workflow\\lastHttpResponseBody',
          'insertText' => 'workflow\\lastHttpResponseBody()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        136 => (object) [
          'name' => 'workflow\\lastHttpResponseCode',
          'insertText' => 'workflow\\lastHttpResponseCode()',
          'returnType' => 'int|null',
          'unsafe' => true
        ],
        137 => (object) [
          'name' => 'workflow\\signalParam',
          'insertText' => 'workflow\\signalParam(NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        138 => (object) [
          'name' => 'workflow\\lastCreatedEntityId',
          'insertText' => 'workflow\\lastCreatedEntityId()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        139 => (object) [
          'name' => 'workflow\\alert',
          'insertText' => 'workflow\\alert(MESSAGE)',
          'unsafe' => true
        ]
      ],
      'functionClassNameMap' => (object) [
        'log\\info' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\InfoType',
        'log\\notice' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\NoticeType',
        'log\\warning' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\WarningType',
        'log\\error' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\ErrorType',
        'ext\\acl\\checkEntity' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckEntityType',
        'ext\\acl\\checkScope' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckScopeType',
        'ext\\acl\\getLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetLevelType',
        'ext\\acl\\getPermissionLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetPermissionLevelType',
        'util\\base64Encode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64EncodeType',
        'util\\base64Decode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64DecodeType',
        'ext\\account\\findByEmailAddress' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\AccountGroup\\FindByEmailAddressType',
        'ext\\calendar\\userIsBusy' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\CalendarGroup\\UserIsBusyType',
        'processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\broadcastSignal' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\BroadcastSignalType',
        'bpm\\processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\createdEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CreatedEntityGroup\\AttributeType',
        'bpm\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'bpm\\startProcess' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\StartProcessType',
        'bpm\\caughtErrorMessage' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorMessage',
        'bpm\\caughtErrorCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorCode',
        'targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'targetEntity\\isNew' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsNewType',
        'targetEntity\\isRelated' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsRelatedType',
        'targetEntity\\hasLinkMultipleId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\HasLinkMultipleIdType',
        'workflow\\lastHttpResponseBody' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseBodyType',
        'workflow\\lastHttpResponseCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseCodeType',
        'workflow\\trigger' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\TriggerType',
        'workflow\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'workflow\\targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'workflow\\targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'workflow\\targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'workflow\\signalParam' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\SignalParamType',
        'workflow\\lastCreatedEntityId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastCreatedEntityIdType',
        'workflow\\alert' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\AlertType',
        'report\\recordAttribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\RecordAttribute',
        'report\\export' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\Export',
        'ext\\priceRule\\productAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\ProductAttribute',
        'ext\\priceRule\\accountAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\AccountAttribute'
      ]
    ],
    'hook' => (object) [
      'suppressClassNameList' => []
    ],
    'image' => (object) [
      'allowedFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'resizableFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp'
      ],
      'fixOrientationFileTypeList' => [
        0 => 'image/jpeg'
      ],
      'previewFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'sizes' => (object) [
        'xxx-small' => [
          0 => 18,
          1 => 18
        ],
        'xx-small' => [
          0 => 32,
          1 => 32
        ],
        'x-small' => [
          0 => 64,
          1 => 64
        ],
        'small' => [
          0 => 128,
          1 => 128
        ],
        'medium' => [
          0 => 256,
          1 => 256
        ],
        'large' => [
          0 => 512,
          1 => 512
        ],
        'x-large' => [
          0 => 864,
          1 => 864
        ],
        'xx-large' => [
          0 => 1024,
          1 => 1024
        ],
        'small-logo' => [
          0 => 181,
          1 => 44
        ]
      ]
    ],
    'jsLibs' => (object) [
      'jquery' => (object) [
        'exposeAs' => '$'
      ],
      'backbone' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'Backbone'
      ],
      'bullbone' => (object) [
        'exposeAs' => 'Bull'
      ],
      'handlebars' => (object) [
        'exposeAs' => 'Handlebars'
      ],
      'underscore' => (object) [
        'exposeAs' => '_'
      ],
      'marked' => (object) [],
      'dompurify' => (object) [
        'exposeAs' => 'DOMPurify'
      ],
      'js-base64' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'Base64'
      ],
      'moment' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'moment'
      ],
      'flotr2' => (object) [
        'path' => 'client/lib/flotr2.js',
        'devPath' => 'client/lib/original/flotr2.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Flotr',
        'sourceMap' => true,
        'aliases' => [
          0 => 'lib!Flotr'
        ]
      ],
      'espo-funnel-chart' => (object) [
        'path' => 'client/lib/espo-funnel-chart.js',
        'exportsTo' => 'window',
        'exportsAs' => 'EspoFunnel'
      ],
      'summernote' => (object) [
        'path' => 'client/lib/summernote.js',
        'devPath' => 'client/lib/original/summernote.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'summernote',
        'sourceMap' => true
      ],
      'jquery-ui' => (object) [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-ui-touch-punch' => (object) [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-textcomplete' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'textcomplete'
      ],
      'autocomplete' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'autocomplete'
      ],
      'timepicker' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'timepicker'
      ],
      'bootstrap-datepicker' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'datepicker'
      ],
      'selectize' => (object) [
        'path' => 'client/lib/selectize.js',
        'devPath' => 'client/lib/original/selectize.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Selectize'
      ],
      'autonumeric' => (object) [],
      'intl-tel-input' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInput'
      ],
      'intl-tel-input-utils' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputUtils'
      ],
      'intl-tel-input-globals' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputGlobals'
      ],
      'cronstrue' => (object) [
        'path' => 'client/lib/cronstrue-i18n.js',
        'devPath' => 'client/lib/original/cronstrue-i18n.js',
        'sourceMap' => true
      ],
      'cropper' => (object) [
        'path' => 'client/lib/cropper.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'cropper',
        'sourceMap' => true
      ],
      'gridstack' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'GridStack'
      ],
      'bootstrap-colorpicker' => (object) [
        'path' => 'client/lib/bootstrap-colorpicker.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'colorpicker',
        'aliases' => [
          0 => 'lib!Colorpicker'
        ]
      ],
      'exif-js' => (object) [
        'path' => 'client/lib/exif.js',
        'devPath' => 'client/lib/original/exif.js',
        'sourceMap' => true
      ],
      'jsbarcode' => (object) [
        'path' => 'client/lib/JsBarcode.all.js',
        'devPath' => 'client/lib/original/JsBarcode.all.js',
        'exportsTo' => 'window',
        'exportsAs' => 'JsBarcode',
        'sourceMap' => true
      ],
      'qrcodejs' => (object) [
        'path' => 'client/lib/qrcode.js',
        'exportsTo' => 'window',
        'exportsAs' => 'QRCode'
      ],
      'turndown' => (object) [
        'path' => 'client/lib/turndown.browser.umd.js',
        'devPath' => 'client/lib/turndown.browser.umd.js',
        'sourceMap' => true
      ],
      'ace' => (object) [
        'path' => 'client/lib/ace.js',
        'exportsTo' => 'window',
        'exportsAs' => 'ace'
      ],
      'ace-mode-css' => (object) [
        'path' => 'client/lib/ace-mode-css.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/css'
      ],
      'ace-mode-html' => (object) [
        'path' => 'client/lib/ace-mode-html.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/html'
      ],
      'ace-mode-handlebars' => (object) [
        'path' => 'client/lib/ace-mode-handlebars.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/handlebars'
      ],
      'ace-mode-javascript' => (object) [
        'path' => 'client/lib/ace-mode-javascript.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/javascript'
      ],
      'ace-ext-language_tools' => (object) [
        'path' => 'client/lib/ace-ext-language_tools.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/ext/language_tools'
      ],
      'ace-theme-tomorrow_night' => (object) [
        'path' => 'client/lib/ace-theme-tomorrow_night.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/theme/tomorrow_night'
      ],
      'fullcalendar' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar.js',
        'exportsTo' => 'window',
        'exportsAs' => 'FullCalendar',
        'sourceMap' => true
      ],
      '@fullcalendar/moment' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar-moment.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'Moment',
        'sourceMap' => true
      ],
      '@fullcalendar/moment-timezone' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar-moment-timezone.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment-timezone.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'MomentTimezone',
        'sourceMap' => true
      ],
      'vis-timeline' => (object) [
        'path' => 'client/modules/crm/lib/vis-timeline.js',
        'devPath' => 'client/modules/crm/lib/original/vis-timeline.js',
        'sourceMap' => true
      ],
      'vis-data' => (object) [
        'path' => 'client/modules/crm/lib/vis-data.js',
        'devPath' => 'client/modules/crm/lib/original/vis-data.js',
        'aliases' => [
          0 => 'vis-data/peer/umd/vis-data.js'
        ],
        'sourceMap' => true
      ],
      'swal' => (object) [
        'path' => 'client/custom/src/js/swal.js',
        'exportsTo' => 'window',
        'exportsAs' => 'swal',
        'sourceMap' => false
      ]
    ],
    'language' => (object) [
      'list' => [
        0 => 'en_US',
        1 => 'ar_AR',
        2 => 'bg_BG',
        3 => 'en_GB',
        4 => 'es_MX',
        5 => 'cs_CZ',
        6 => 'da_DK',
        7 => 'de_DE',
        8 => 'es_ES',
        9 => 'hr_HR',
        10 => 'hu_HU',
        11 => 'fa_IR',
        12 => 'fr_FR',
        13 => 'id_ID',
        14 => 'it_IT',
        15 => 'lt_LT',
        16 => 'lv_LV',
        17 => 'nb_NO',
        18 => 'nl_NL',
        19 => 'th_TH',
        20 => 'tr_TR',
        21 => 'sk_SK',
        22 => 'sl_SI',
        23 => 'sr_RS',
        24 => 'sv_SE',
        25 => 'ro_RO',
        26 => 'ru_RU',
        27 => 'pl_PL',
        28 => 'pt_BR',
        29 => 'pt_PT',
        30 => 'uk_UA',
        31 => 'vi_VN',
        32 => 'zh_CN',
        33 => 'zh_TW'
      ],
      'aclDependencies' => (object) [
        'Meeting' => (object) [
          'anyScopeList' => [
            0 => 'Call'
          ]
        ],
        'Workflow' => (object) [
          'anyScopeList' => [
            0 => 'BpmnProcess',
            1 => 'BpmnFlowchart'
          ]
        ],
        'BpmnFlowchart' => (object) [
          'anyScopeList' => [
            0 => 'BpmnProcess'
          ]
        ],
        'Opportunity' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder'
          ]
        ],
        'Quote' => (object) [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'Invoice',
            2 => 'Opportunity',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder',
            8 => 'InventoryAdjustment',
            9 => 'Product'
          ]
        ],
        'QuoteItem' => (object) [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'Opportunity',
            4 => 'PurchaseOrder',
            5 => 'DeliveryOrder',
            6 => 'ReceiptOrder',
            7 => 'TransferOrder',
            8 => 'ReturnOrder',
            9 => 'InventoryAdjustment'
          ]
        ],
        'SalesOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice'
          ]
        ],
        'Invoice' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'PurchaseOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'SalesOrder',
            3 => 'ReturnOrder'
          ]
        ],
        'ReturnOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'DeliveryOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'TransferOrder'
          ]
        ],
        'DeliveryOrderItem' => (object) [
          'anyScopeList' => [
            0 => 'ReceiptOrder'
          ]
        ],
        'ReceiptOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'PurchaseOrder'
          ]
        ],
        'Account' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'Warehouse' => (object) [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'DeliveryOrder',
            2 => 'ReceiptOrder',
            3 => 'PurchaseOrder',
            4 => 'TransferOrder',
            5 => 'InventoryAdjustment',
            6 => 'InventoryTransaction'
          ]
        ],
        'Product' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'PurchaseOrder',
            3 => 'SalesOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'InventoryTransaction',
            8 => 'InventoryAdjustment',
            9 => 'ReturnOrder',
            10 => 'Warehouse',
            11 => 'PriceBook',
            12 => 'Supplier'
          ]
        ],
        'PriceRule' => (object) [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'ProductPrice',
            2 => 'SupplierProductPrice'
          ]
        ]
      ]
    ],
    'layouts' => (object) [],
    'linkManager' => (object) [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListCreate'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListDelete',
        1 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\ForeignFieldDelete'
      ]
    ],
    'mapProviders' => (object) [
      'Google' => (object) [
        'renderer' => 'handlers/map/google-maps-renderer'
      ]
    ],
    'massActions' => (object) [
      'convertCurrency' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassConvertCurrency'
      ],
      'follow' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassFollow'
      ],
      'unfollow' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUnfollow'
      ],
      'recalculateFormula' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassRecalculateFormula'
      ],
      'update' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUpdate'
      ],
      'delete' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassDelete'
      ]
    ],
    'metadata' => (object) [
      'frontendHiddenPathList' => [
        0 => [
          0 => 'app',
          1 => 'metadata'
        ],
        1 => [
          0 => 'app',
          1 => 'containerServices'
        ],
        2 => [
          0 => 'app',
          1 => 'portalContainerServices'
        ],
        3 => [
          0 => 'app',
          1 => 'consoleCommands'
        ],
        4 => [
          0 => 'app',
          1 => 'formula',
          2 => 'functionClassNameMap'
        ],
        5 => [
          0 => 'app',
          1 => 'fileStorage',
          2 => 'implementationClassNameMap'
        ],
        6 => [
          0 => 'app',
          1 => 'client'
        ],
        7 => [
          0 => 'app',
          1 => 'language',
          2 => 'aclDependencies'
        ],
        8 => [
          0 => 'app',
          1 => 'templateHelpers'
        ],
        9 => [
          0 => 'app',
          1 => 'appParams'
        ],
        10 => [
          0 => 'app',
          1 => 'cleanup'
        ],
        11 => [
          0 => 'app',
          1 => 'authentication'
        ],
        12 => [
          0 => 'app',
          1 => 'pdfEngines',
          2 => '__ANY__',
          3 => 'implementationClassNameMap'
        ],
        13 => [
          0 => 'app',
          1 => 'addressFormats',
          2 => '__ANY__',
          3 => 'formatterClassName'
        ],
        14 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'loginClassName'
        ],
        15 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'userSetupClassName'
        ],
        16 => [
          0 => 'app',
          1 => 'select'
        ],
        17 => [
          0 => 'app',
          1 => 'massActions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        18 => [
          0 => 'app',
          1 => 'actions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        19 => [
          0 => 'app',
          1 => 'fieldProcessing'
        ],
        20 => [
          0 => 'app',
          1 => 'scheduledJobs'
        ],
        21 => [
          0 => 'app',
          1 => 'webSocket',
          2 => 'messagers'
        ],
        22 => [
          0 => 'app',
          1 => 'config'
        ],
        23 => [
          0 => 'app',
          1 => 'rebuild'
        ],
        24 => [
          0 => 'app',
          1 => 'smsProviders',
          2 => '__ANY__',
          3 => 'senderClassName'
        ],
        25 => [
          0 => 'app',
          1 => 'orm'
        ],
        26 => [
          0 => 'app',
          1 => 'relationships'
        ],
        27 => [
          0 => 'app',
          1 => 'linkManager'
        ],
        28 => [
          0 => 'app',
          1 => 'hook'
        ],
        29 => [
          0 => 'app',
          1 => 'api'
        ],
        30 => [
          0 => 'app',
          1 => 'databasePlatforms'
        ],
        31 => [
          0 => 'app',
          1 => 'recordId'
        ],
        32 => [
          0 => 'app',
          1 => 'currencyConversion'
        ],
        33 => [
          0 => 'selectDefs'
        ],
        34 => [
          0 => 'pdfDefs'
        ],
        35 => [
          0 => 'notificationDefs',
          1 => '__ANY__',
          2 => 'assignmentNotificatorClassName'
        ],
        36 => [
          0 => 'authenticationMethods',
          1 => '__ANY__',
          2 => 'implementationClassName'
        ],
        37 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'accessCheckerClassName'
        ],
        38 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalAccessCheckerClassName'
        ],
        39 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'ownershipCheckerClassName'
        ],
        40 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalOwnershipCheckerClassName'
        ],
        41 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'assignmentCheckerClassName'
        ],
        42 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'linkCheckerClassNameMap'
        ],
        43 => [
          0 => 'app',
          1 => 'calendar',
          2 => 'additionalAttributeList'
        ]
      ],
      'frontendNonAdminHiddenPathList' => [
        0 => [
          0 => 'recordDefs'
        ]
      ],
      'additionalBuilderClassNameList' => [
        0 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\Fields',
        1 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\FilterFields',
        2 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\DeleteIdField',
        3 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\StreamUpdatedAtField'
      ],
      'aclDependencies' => (object) []
    ],
    'orm' => (object) [
      'platforms' => (object) [
        'Mysql' => (object) [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\MysqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\MysqlPDOFactory',
          'functionConverterClassNameMap' => (object) [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ],
        'Postgresql' => (object) [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\PostgresqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\PostgresqlPDOFactory',
          'functionConverterClassNameMap' => (object) [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ]
      ]
    ],
    'pdfEngines' => (object) [
      'Dompdf' => (object) [
        'implementationClassNameMap' => (object) [
          'entity' => 'Espo\\Tools\\Pdf\\Dompdf\\EntityPrinter'
        ],
        'fontFaceList' => [
          0 => 'Courier',
          1 => 'Helvetica',
          2 => 'Times',
          3 => 'Symbol',
          4 => 'ZapfDingbats',
          5 => 'DejaVu Sans',
          6 => 'DejaVu Serif',
          7 => 'DejaVu Sans Mono'
        ]
      ]
    ],
    'portalContainerServices' => (object) [
      'layoutProvider' => (object) [
        'className' => 'Espo\\Tools\\Layout\\PortalLayoutProvider'
      ],
      'themeManager' => (object) [
        'className' => 'Espo\\Core\\Portal\\Utils\\ThemeManager'
      ]
    ],
    'reactions' => (object) [
      'list' => [
        0 => (object) [
          'type' => 'Smile',
          'iconClass' => 'far fa-face-smile'
        ],
        1 => (object) [
          'type' => 'Surprise',
          'iconClass' => 'far fa-face-surprise'
        ],
        2 => (object) [
          'type' => 'Laugh',
          'iconClass' => 'far fa-face-laugh'
        ],
        3 => (object) [
          'type' => 'Meh',
          'iconClass' => 'far fa-face-meh'
        ],
        4 => (object) [
          'type' => 'Sad',
          'iconClass' => 'far fa-face-frown'
        ],
        5 => (object) [
          'type' => 'Love',
          'iconClass' => 'far fa-heart'
        ],
        6 => (object) [
          'type' => 'Like',
          'iconClass' => 'far fa-thumbs-up'
        ],
        7 => (object) [
          'type' => 'Dislike',
          'iconClass' => 'far fa-thumbs-down'
        ]
      ]
    ],
    'rebuild' => (object) [
      'actionClassNameList' => [
        0 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemUser',
        1 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemData',
        2 => 'Espo\\Core\\Rebuild\\Actions\\CurrencyRates',
        3 => 'Espo\\Core\\Rebuild\\Actions\\ScheduledJobs',
        4 => 'Espo\\Core\\Rebuild\\Actions\\ConfigMetadataCheck',
        5 => 'Espo\\Core\\Rebuild\\Actions\\GenerateInstanceId'
      ]
    ],
    'record' => (object) [
      'selectApplierClassNameList' => [
        0 => 'Espo\\Core\\Select\\Applier\\AdditionalAppliers\\IsStarred'
      ]
    ],
    'recordId' => (object) [
      'length' => 24
    ],
    'regExpPatterns' => (object) [
      'noBadCharacters' => (object) [
        'pattern' => '[^<>=]+'
      ],
      'noAsciiSpecialCharacters' => (object) [
        'pattern' => '[^`~!@#$%^&*()_+={}\\[\\]|\\\\:;"\'<,>.?]+'
      ],
      'latinLetters' => (object) [
        'pattern' => '[A-Za-z]+'
      ],
      'latinLettersDigits' => (object) [
        'pattern' => '[A-Za-z0-9]+'
      ],
      'latinLettersDigitsWhitespace' => (object) [
        'pattern' => '[A-Za-z0-9 ]+'
      ],
      'latinLettersWhitespace' => (object) [
        'pattern' => '[A-Za-z ]+'
      ],
      'digits' => (object) [
        'pattern' => '[0-9]+'
      ],
      'id' => (object) [
        'pattern' => '[A-Za-z0-9_=\\-\\.]+',
        'isSystem' => true
      ],
      'phoneNumberLoose' => (object) [
        'pattern' => '[0-9A-Za-z_@:#\\+\\(\\)\\-\\. ]+',
        'isSystem' => true
      ],
      'uriOptionalProtocol' => (object) [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/)?[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ],
      'uri' => (object) [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/){1}[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ]
    ],
    'relationships' => (object) [
      'attachments' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\Attachments'
      ],
      'emailEmailAddress' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EmailEmailAddress'
      ],
      'entityTeam' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityTeam'
      ],
      'entityUser' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityUser'
      ],
      'entityCollaborator' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityCollaborator'
      ],
      'smsPhoneNumber' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\SmsPhoneNumber'
      ]
    ],
    'scheduledJobs' => (object) [
      'ProcessJobGroup' => (object) [
        'name' => 'Process Job Group',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobGroup',
        'preparatorClassName' => 'Espo\\Core\\Job\\Preparator\\Preparators\\ProcessJobGroupPreparator'
      ],
      'ProcessJobQueueQ0' => (object) [
        'name' => 'Process Job Queue q0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ0'
      ],
      'ProcessJobQueueQ1' => (object) [
        'name' => 'Process Job Queue q1',
        'isSystem' => true,
        'scheduling' => '*/1 * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ1'
      ],
      'ProcessJobQueueE0' => (object) [
        'name' => 'Process Job Queue e0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueE0'
      ],
      'Dummy' => (object) [
        'isSystem' => true,
        'scheduling' => '1 */12 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\Dummy'
      ],
      'CheckNewVersion' => (object) [
        'name' => 'Check for New Version',
        'isSystem' => true,
        'scheduling' => '15 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewVersion'
      ],
      'CheckNewExtensionVersion' => (object) [
        'name' => 'Check for New Versions of Installed Extensions',
        'isSystem' => true,
        'scheduling' => '25 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewExtensionVersion'
      ],
      'Cleanup' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\Cleanup'
      ],
      'AuthTokenControl' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\AuthTokenControl'
      ],
      'SendEmailNotifications' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendEmailNotifications'
      ],
      'ProcessWebhookQueue' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\ProcessWebhookQueue'
      ],
      'CheckEmailAccounts' => (object) [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckEmailAccounts',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckEmailAccounts'
      ],
      'CheckInboundEmails' => (object) [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckInboundEmails',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckInboundEmails'
      ],
      'SendScheduledEmails' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendScheduledEmails'
      ],
      'AdvancedPack' => (object) [
        'isSystem' => true,
        'scheduling' => '3 3 * * *',
        'jobClassName' => 'Espo\\Modules\\Advanced\\Core\\App\\Job'
      ],
      'SalesJob' => (object) [
        'isSystem' => true,
        'scheduling' => '3 5 * * *',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\App\\Job'
      ],
      'InventoryCompress' => (object) [
        'scheduling' => '10 0 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryCompress'
      ],
      'NotActualOrderLocking' => (object) [
        'scheduling' => '10 1 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\NotActualOrderLocking'
      ],
      'InventoryDetach' => (object) [
        'scheduling' => '10 2 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryDetach'
      ]
    ],
    'select' => (object) [
      'whereItemConverterClassNameMap' => (object) [
        'inCategory' => 'Espo\\Core\\Select\\Where\\ItemConverters\\InCategory',
        'isUserFromTeams' => 'Espo\\Core\\Select\\Where\\ItemConverters\\IsUserFromTeams'
      ]
    ],
    'smsProviders' => (object) [],
    'templateHelpers' => (object) [
      'googleMapsImage' => 'Espo\\Classes\\TemplateHelpers\\GoogleMaps',
      'markdownText' => 'Espo\\Classes\\TemplateHelpers\\MarkdownText',
      'tableTag' => 'Espo\\Classes\\TemplateHelpers\\TableTag',
      'trTag' => 'Espo\\Classes\\TemplateHelpers\\TrTag',
      'tdTag' => 'Espo\\Classes\\TemplateHelpers\\TdTag',
      'reportTable' => 'Espo\\Modules\\Advanced\\Core\\TemplateHelpers\\Report'
    ],
    'templates' => (object) [
      'accessInfo' => (object) [
        'scope' => 'User'
      ],
      'accessInfoPortal' => (object) [
        'scope' => 'User'
      ],
      'assignment' => (object) [
        'scopeListConfigParam' => 'assignmentEmailNotificationsEntityList'
      ],
      'mention' => (object) [
        'scope' => 'Note'
      ],
      'noteEmailReceived' => (object) [
        'scope' => 'Note'
      ],
      'notePost' => (object) [
        'scope' => 'Note'
      ],
      'notePostNoParent' => (object) [
        'scope' => 'Note'
      ],
      'noteStatus' => (object) [
        'scope' => 'Note'
      ],
      'passwordChangeLink' => (object) [
        'scope' => 'User'
      ],
      'twoFactorCode' => (object) [
        'scope' => 'User'
      ],
      'invitation' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'cancellation' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'reminder' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call',
          2 => 'Task'
        ],
        'module' => 'Crm'
      ],
      'reportSendingGrid1' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingGrid2' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingList' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'salesEmailPdf' => (object) [
        'scopeList' => [
          0 => 'Quote',
          1 => 'SalesOrder',
          2 => 'Invoice',
          3 => 'PurchaseOrder',
          4 => 'DeliveryOrder',
          5 => 'ReceiptOrder',
          6 => 'TransferOrder',
          7 => 'ReturnOrder'
        ],
        'module' => 'Sales'
      ]
    ],
    'webSocket' => (object) [
      'categories' => (object) [
        'newNotification' => (object) [],
        'recordUpdate' => (object) [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=read'
        ],
        'streamUpdate' => (object) [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=stream'
        ],
        'popupNotifications.event' => (object) [],
        'inventoryQuantityUpdate' => (object) [
          'accessCheckCommand' => 'InventoryAclCheck --userId=:userId'
        ]
      ],
      'messagers' => (object) [
        'ZeroMQ' => (object) [
          'senderClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSender',
          'subscriberClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSubscriber'
        ]
      ]
    ],
    'calendar' => (object) [
      'additionalAttributeList' => [
        0 => 'color'
      ]
    ],
    'popupNotifications' => (object) [
      'event' => (object) [
        'grouped' => true,
        'providerClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\PopupNotificationsProvider',
        'useWebSocket' => true,
        'portalDisabled' => true,
        'view' => 'crm:views/meeting/popup-notification'
      ]
    ],
    'workflow' => (object) [
      'serviceActions' => (object) [
        'Meeting' => (object) [
          'sendEventInvitations' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Call' => (object) [
          'sendEventInvitations' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Contact' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Lead' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Account' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'User' => (object) [
          'generateAndSendPassword' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\User\\GenerateAndSendPassword'
          ]
        ],
        'Quote' => (object) [
          'addQuoteItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Invoice' => (object) [
          'addInvoiceItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'SalesOrder' => (object) [
          'addSalesOrderItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Opportunity' => (object) [
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ]
        ]
      ]
    ],
    'eInvoice' => (object) [
      'formatList' => [
        0 => 'Peppol',
        1 => 'XRechnung',
        2 => 'CiusAtGov',
        3 => 'CiusAtNat',
        4 => 'CiusEsFace',
        5 => 'CiusIt',
        6 => 'CiusRo',
        7 => 'Nlcius'
      ],
      'easCodeList' => [
        0 => '0002',
        1 => '0007',
        2 => '0009',
        3 => '0037',
        4 => '0060',
        5 => '0088',
        6 => '0096',
        7 => '0097',
        8 => '0106',
        9 => '0130',
        10 => '0135',
        11 => '0142',
        12 => '0147',
        13 => '0151',
        14 => '0170',
        15 => '0183',
        16 => '0184',
        17 => '0188',
        18 => '0190',
        19 => '0191',
        20 => '0192',
        21 => '0193',
        22 => '0194',
        23 => '0195',
        24 => '0196',
        25 => '0198',
        26 => '0199',
        27 => '0200',
        28 => '0201',
        29 => '0202',
        30 => '0203',
        31 => '0204',
        32 => '0205',
        33 => '0208',
        34 => '0209',
        35 => '0210',
        36 => '0211',
        37 => '0212',
        38 => '0213',
        39 => '0215',
        40 => '0216',
        41 => '0217',
        42 => '0218',
        43 => '0221',
        44 => '0225',
        45 => '0230',
        46 => '9901',
        47 => '9910',
        48 => '9913',
        49 => '9914',
        50 => '9915',
        51 => '9918',
        52 => '9919',
        53 => '9920',
        54 => '9922',
        55 => '9923',
        56 => '9924',
        57 => '9925',
        58 => '9926',
        59 => '9927',
        60 => '9928',
        61 => '9929',
        62 => '9930',
        63 => '9931',
        64 => '9932',
        65 => '9933',
        66 => '9934',
        67 => '9935',
        68 => '9936',
        69 => '9937',
        70 => '9938',
        71 => '9939',
        72 => '9940',
        73 => '9941',
        74 => '9942',
        75 => '9943',
        76 => '9944',
        77 => '9945',
        78 => '9946',
        79 => '9947',
        80 => '9948',
        81 => '9949',
        82 => '9950',
        83 => '9951',
        84 => '9952',
        85 => '9953',
        86 => '9957',
        87 => '9959',
        88 => 'AN',
        89 => 'AQ',
        90 => 'AS',
        91 => 'AU',
        92 => 'EM'
      ],
      'easNames' => (object) [
        9901 => 'Danish Ministry of the Interior and Health',
        9910 => 'Hungary VAT number',
        9913 => 'Business Registers Network',
        9914 => 'Österreichische Umsatzsteuer-Identifikationsnummer',
        9915 => 'Österreichisches Verwaltungs bzw. Organisationskennzeichen',
        9918 => 'SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T',
        9919 => 'Kennziffer des Unternehmensregisters',
        9920 => 'Agencia Española de Administración Tributaria',
        9922 => 'Andorra VAT number',
        9923 => 'Albania VAT number',
        9924 => 'Bosnia and Herzegovina VAT number',
        9925 => 'Belgium VAT number',
        9926 => 'Bulgaria VAT number',
        9927 => 'Switzerland VAT number',
        9928 => 'Cyprus VAT number',
        9929 => 'Czech Republic VAT number',
        9930 => 'Germany VAT number',
        9931 => 'Estonia VAT number',
        9932 => 'United Kingdom VAT number',
        9933 => 'Greece VAT number',
        9934 => 'Croatia VAT number',
        9935 => 'Ireland VAT number',
        9936 => 'Liechtenstein VAT number',
        9937 => 'Lithuania VAT number',
        9938 => 'Luxemburg VAT number',
        9939 => 'Latvia VAT number',
        9940 => 'Monaco VAT number',
        9941 => 'Montenegro VAT number',
        9942 => 'Macedonia, the former Yugoslav Republic of VAT number',
        9943 => 'Malta VAT number',
        9944 => 'Netherlands VAT number',
        9945 => 'Poland VAT number',
        9946 => 'Portugal VAT number',
        9947 => 'Romania VAT number',
        9948 => 'Serbia VAT number',
        9949 => 'Slovenia VAT number',
        9950 => 'Slovakia VAT number',
        9951 => 'San Marino VAT number',
        9952 => 'Turkey VAT number',
        9953 => 'Holy See (Vatican City State) VAT number',
        9957 => 'French VAT number',
        9959 => 'Employer Identification Number (EIN, USA)',
        '0002' => 'System Information et Repertoire des Entreprise et des Etablissements: SIRENE',
        '0007' => 'Organisationsnummer (Swedish legal entities)',
        '0009' => 'SIRET-CODE',
        '0037' => 'LY-tunnus',
        '0060' => 'Data Universal Numbering System (D-U-N-S Number)',
        '0088' => 'EAN Location Code',
        '0096' => 'DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)',
        '0097' => 'FTI - Ediforum Italia, (EDIRA compliant)',
        '0106' => 'Vereniging van Kamers van Koophandel en Fabrieken in Nederland (Association of Chambers of Commerce and Industry in the Netherlands), Scheme (EDIRA compliant)',
        '0130' => 'Directorates of the European Commission',
        '0135' => 'SIA Object Identifiers',
        '0142' => 'SECETI Object Identifiers',
        '0147' => 'Standard Company Code',
        '0151' => 'Australian Business Number (ABN) Scheme',
        '0170' => 'Teikoku Company Code',
        '0183' => 'Numéro d\'identification suisse des enterprises (IDE), Swiss Unique Business Identification Number (UIDB)',
        '0184' => 'DIGSTORG',
        '0188' => 'Corporate Number of The Social Security and Tax Number System',
        '0190' => 'Dutch Originator\'s Identification Number',
        '0191' => 'Centre of Registers and Information Systems of the Ministry of Justice',
        '0192' => 'Enhetsregisteret ved Bronnoysundregisterne',
        '0193' => 'UBL.BE party identifier',
        '0194' => 'KOIOS Open Technical Dictionary',
        '0195' => 'Singapore UEN identifier',
        '0196' => 'Kennitala - Iceland legal id for individuals and legal entities',
        '0198' => 'ERSTORG',
        '0199' => 'Legal Entity Identifier (LEI)',
        '0200' => 'Legal entity code (Lithuania)',
        '0201' => 'Codice Univoco Unità Organizzativa iPA',
        '0202' => 'Indirizzo di Posta Elettronica Certificata',
        '0203' => 'eDelivery Network Participant identifier',
        '0204' => 'Leitweg-ID',
        '0205' => 'CODDEST',
        '0208' => 'Numero d\'entreprise / ondernemingsnummer / Unternehmensnummer',
        '0209' => 'GS1 identification keys',
        '0210' => 'CODICE FISCALE',
        '0211' => 'PARTITA IVA',
        '0212' => 'Finnish Organization Identifier',
        '0213' => 'Finnish Organization Value Add Tax Identifier',
        '0215' => 'Net service ID',
        '0216' => 'OVTcode',
        '0217' => 'The Netherlands Chamber of Commerce and Industry establishment number',
        '0218' => 'Unified registration number (Latvia)',
        '0221' => 'The registered number of the qualified invoice issuer',
        '0225' => 'FRCTC ELECTRONIC ADDRESS',
        '0230' => 'National e-Invoicing Framework',
        'AN' => 'O.F.T.P. (ODETTE File Transfer Protocol)',
        'AQ' => 'X.400 address for mail text',
        'AS' => 'AS2 exchange',
        'AU' => 'File Transfer Protocol',
        'EM' => 'Electronic mail'
      ]
    ],
    'customCSS' => [
      0 => 'font-style',
      1 => 'font-weight',
      2 => 'font-size',
      3 => 'font-family',
      4 => 'text-align',
      5 => 'letter spacing',
      6 => 'Text-outline',
      7 => 'word-wrap',
      8 => 'direction',
      9 => 'text-wrap',
      10 => 'text-indent',
      11 => 'word-spacing',
      12 => 'text-transform',
      13 => 'text-emphasis',
      14 => 'text-justify',
      15 => 'nav-up',
      16 => 'nav-down',
      17 => 'nav-left',
      18 => 'nav-right',
      19 => 'resize',
      20 => 'icon',
      21 => 'background-size',
      22 => 'background-image',
      23 => 'background-repeat',
      24 => 'background-attachment',
      25 => 'background-color',
      26 => 'background-position',
      27 => 'background-origin',
      28 => 'background-clip',
      29 => 'border-width',
      30 => 'border-style',
      31 => 'border-color',
      32 => 'border-left',
      33 => 'border-left-color',
      34 => 'border-left-width',
      35 => 'border-right',
      36 => 'border-right-color',
      37 => 'border-right-width',
      38 => 'border-top',
      39 => 'border-top-width',
      40 => 'border-top-color',
      41 => 'border-bottom',
      42 => 'border-bottom-color',
      43 => 'border-bottom-width',
      44 => 'border-decoration-break',
      45 => 'border-radius',
      46 => 'border-top-right-radius',
      47 => 'border-bottom-right-radius',
      48 => 'border-bottom-left-radius',
      49 => 'border-top-left-radius',
      50 => 'border-image',
      51 => 'float',
      52 => 'height',
      53 => 'max-height',
      54 => 'max-width',
      55 => 'min-height',
      56 => 'min-width',
      57 => 'margin-bottom',
      58 => 'margin',
      59 => 'margin-left',
      60 => 'margin-right',
      61 => 'margin-top',
      62 => 'padding-bottom',
      63 => 'padding-top',
      64 => 'padding-right',
      65 => 'padding-left',
      66 => 'display',
      67 => 'marquee-direction',
      68 => 'marquee-loop',
      69 => 'marquee-play-count',
      70 => 'marquee-speed',
      71 => 'marquee-style',
      72 => 'overflow',
      73 => 'overflow-style',
      74 => 'overflow-x',
      75 => 'rotation',
      76 => 'rotation-point',
      77 => 'visibility',
      78 => 'clear',
      79 => 'box-align',
      80 => 'box-direction',
      81 => 'box-flex',
      82 => 'box-flex-group',
      83 => 'box-lines',
      84 => 'box-orient',
      85 => 'box-pack',
      86 => 'box-sizing',
      87 => 'tab-side',
      88 => 'border-collapse',
      89 => 'empty-cells',
      90 => 'border-spacing',
      91 => 'table-layout',
      92 => 'caption-side',
      93 => 'column-count',
      94 => 'column-fill',
      95 => 'column-gap',
      96 => 'column-rule-width',
      97 => 'column-rule-style',
      98 => 'column-rule-color',
      99 => 'column-width',
      100 => 'column-span',
      101 => 'color',
      102 => 'opacity',
      103 => 'grid-columns',
      104 => 'grid-rows',
      105 => 'list-style-type',
      106 => 'list-style-position',
      107 => 'list-style-position',
      108 => 'list-style-image',
      109 => 'marker-offset',
      110 => 'animation-name',
      111 => 'animation-duration',
      112 => 'animation-timing-function',
      113 => 'animation-delay',
      114 => 'animation-iteration-count',
      115 => 'animation-direction',
      116 => 'animation-play-state',
      117 => 'animation-fill-mode',
      118 => 'outline-color',
      119 => 'outline-style',
      120 => 'outline-width',
      121 => 'outline-offset',
      122 => 'target-name',
      123 => 'target-new',
      124 => 'target-position',
      125 => 'fit',
      126 => 'fit-position',
      127 => 'orphans',
      128 => 'image-orientation',
      129 => 'page',
      130 => 'page-break-after',
      131 => 'page-break-before',
      132 => 'page-break-inside',
      133 => 'size',
      134 => 'windows',
      135 => 'bottom',
      136 => 'right',
      137 => 'top',
      138 => 'left',
      139 => 'z-index',
      140 => 'clip',
      141 => 'position',
      142 => 'transitions-delay',
      143 => 'transitions-duration',
      144 => 'transitions-property',
      145 => 'transition-timing-function',
      146 => 'backface-visibility',
      147 => 'perspective',
      148 => 'perspective-origin',
      149 => 'transform',
      150 => 'transform-origin',
      151 => 'transform-style',
      152 => 'cue-before – play a sound file before an element',
      153 => 'cue-after - play a sound file after an element',
      154 => 'pause',
      155 => 'pause-before',
      156 => 'pause-after',
      157 => 'voice-stress',
      158 => 'voice-pitch',
      159 => 'voice-duration',
      160 => 'voice-volume',
      161 => 'voice-family',
      162 => 'voice-rate',
      163 => 'speak',
      164 => 'caption-side – position for table caption',
      165 => 'rest-before',
      166 => 'rest-after',
      167 => 'alignment-adjust',
      168 => 'alignment-baseline',
      169 => 'drop-initial-after-align',
      170 => 'drop-initial-before-align',
      171 => 'drop-initial-before-adjust',
      172 => 'drop-initial-value',
      173 => 'drop-initial-size',
      174 => 'baseline-shift',
      175 => 'dominant-baseline',
      176 => 'line-stacking-shift',
      177 => 'line-stacking-strategy',
      178 => 'inline-box-align',
      179 => 'line-height',
      180 => 'text-height',
      181 => 'vertical-align',
      182 => 'left',
      183 => 'center',
      184 => 'top',
      185 => 'justify',
      186 => 'right',
      187 => 'normal',
      188 => 'none',
      189 => 'length',
      190 => 'color',
      191 => 'auto',
      192 => 'px',
      193 => 'distribute',
      194 => 'inter-word',
      195 => 'fixed',
      196 => 'scroll',
      197 => 'start',
      198 => 'end',
      199 => 'padding',
      200 => 'aliceblue',
      201 => 'black',
      202 => 'silver',
      203 => 'gray',
      204 => 'white',
      205 => 'maroon',
      206 => 'red',
      207 => 'purple',
      208 => 'fuchsia',
      209 => 'green',
      210 => 'lime',
      211 => 'olive',
      212 => 'yellow',
      213 => 'navy',
      214 => 'blue',
      215 => 'teal',
      216 => 'aqua',
      217 => 'aliceblue',
      218 => 'antiquewhite',
      219 => 'aquamarine',
      220 => 'azure',
      221 => 'beige',
      222 => 'bisque',
      223 => 'blanchedalmond',
      224 => 'blueviolet',
      225 => 'brown',
      226 => 'burlywood',
      227 => 'cadetblue',
      228 => 'chartreuse',
      229 => 'chocolate',
      230 => 'coral',
      231 => 'cornflowerblue',
      232 => 'cornsilk',
      233 => 'crimson',
      234 => 'cyan',
      235 => 'darkblue',
      236 => 'darkcyan',
      237 => 'darkgoldenrod',
      238 => 'darkgray',
      239 => 'darkgreen',
      240 => 'darkgrey',
      241 => 'darkkhaki',
      242 => 'darkmagenta',
      243 => 'darkolivegreen',
      244 => 'darkorange',
      245 => 'darkorchid',
      246 => 'darkred',
      247 => 'darksalmon',
      248 => 'darkseagreen',
      249 => 'darkslateblue',
      250 => 'darkslategray',
      251 => 'darkslategrey',
      252 => 'darkturquoise',
      253 => 'darkviolet',
      254 => 'deeppink',
      255 => 'deepskyblue',
      256 => 'dimgray',
      257 => 'dimgrey',
      258 => 'dodgerblue',
      259 => 'firebrick',
      260 => 'floralwhite',
      261 => 'forestgreen',
      262 => 'gainsboro',
      263 => 'ghostwhite',
      264 => 'gold',
      265 => 'goldenrod',
      266 => 'greenyellow',
      267 => 'grey',
      268 => 'honeydew',
      269 => 'hotpink',
      270 => 'indianred',
      271 => 'indigo',
      272 => 'ivory',
      273 => 'khaki',
      274 => 'lavender',
      275 => 'lavenderblush',
      276 => 'lawngreen',
      277 => 'lemonchiffon',
      278 => 'lightblue',
      279 => 'lightcoral',
      280 => 'lightcyan',
      281 => 'lightgoldenrodyellow',
      282 => 'lightgray',
      283 => 'lightgreen',
      284 => 'lightgrey',
      285 => 'lightpink',
      286 => 'lightsalmon',
      287 => 'lightseagreen',
      288 => 'lightskyblue',
      289 => 'lightslategray',
      290 => 'lightslategrey',
      291 => 'lightsteelblue',
      292 => 'lightyellow',
      293 => 'limegreen',
      294 => 'linen',
      295 => 'magenta',
      296 => 'mediumaquamarine',
      297 => 'mediumblue',
      298 => 'mediumorchid',
      299 => 'mediumpurple',
      300 => 'mediumseagreen',
      301 => 'mediumslateblue',
      302 => 'mediumspringgreen',
      303 => 'mediumturquoise',
      304 => 'mediumvioletred',
      305 => 'midnightblue',
      306 => 'mintcream',
      307 => 'mistyrose',
      308 => 'moccasin',
      309 => 'navajowhite',
      310 => 'oldlace',
      311 => 'olivedrab',
      312 => 'orangered',
      313 => 'orchid',
      314 => 'palegoldenrod',
      315 => 'palegreen',
      316 => 'paleturquoise',
      317 => 'palevioletred',
      318 => 'papayawhip',
      319 => 'peachpuff',
      320 => 'peru',
      321 => 'pink',
      322 => 'plum',
      323 => 'powderblue',
      324 => 'rosybrown',
      325 => 'royalblue',
      326 => 'saddlebrown',
      327 => 'salmon',
      328 => 'sandybrown',
      329 => 'seagreen',
      330 => 'seashell',
      331 => 'sienna',
      332 => 'skyblue',
      333 => 'slateblue',
      334 => 'slategray',
      335 => 'slategrey',
      336 => 'snow',
      337 => 'springgreen',
      338 => 'steelblue',
      339 => 'tan',
      340 => 'thistle',
      341 => 'tomato',
      342 => 'turquoise',
      343 => 'violet',
      344 => 'wheat',
      345 => 'whitesmoke',
      346 => 'yellowgreen'
    ]
  ],
  'authenticationMethods' => (object) [
    'ApiKey' => (object) [
      'api' => true,
      'credentialsHeader' => 'X-Api-Key'
    ],
    'Espo' => (object) [
      'portalDefault' => true,
      'settings' => (object) [
        'isAvailable' => true
      ]
    ],
    'Hmac' => (object) [
      'api' => true,
      'credentialsHeader' => 'X-Hmac-Authorization'
    ],
    'LDAP' => (object) [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Ldap\\LdapLogin',
      'portalDefault' => true,
      'settings' => (object) [
        'isAvailable' => true,
        'layout' => (object) [
          'label' => 'LDAP',
          'rows' => [
            0 => [
              0 => (object) [
                'name' => 'ldapHost'
              ],
              1 => (object) [
                'name' => 'ldapPort'
              ]
            ],
            1 => [
              0 => (object) [
                'name' => 'ldapAuth'
              ],
              1 => (object) [
                'name' => 'ldapSecurity'
              ]
            ],
            2 => [
              0 => (object) [
                'name' => 'ldapUsername',
                'fullWidth' => true
              ]
            ],
            3 => [
              0 => (object) [
                'name' => 'ldapPassword'
              ],
              1 => (object) [
                'name' => 'testConnection',
                'customLabel' => NULL,
                'view' => 'views/admin/authentication/fields/test-connection'
              ]
            ],
            4 => [
              0 => (object) [
                'name' => 'ldapUserNameAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserObjectClass'
              ]
            ],
            5 => [
              0 => (object) [
                'name' => 'ldapAccountCanonicalForm'
              ],
              1 => (object) [
                'name' => 'ldapBindRequiresDn'
              ]
            ],
            6 => [
              0 => (object) [
                'name' => 'ldapBaseDn',
                'fullWidth' => true
              ]
            ],
            7 => [
              0 => (object) [
                'name' => 'ldapUserLoginFilter',
                'fullWidth' => true
              ]
            ],
            8 => [
              0 => (object) [
                'name' => 'ldapAccountDomainName'
              ],
              1 => (object) [
                'name' => 'ldapAccountDomainNameShort'
              ]
            ],
            9 => [
              0 => (object) [
                'name' => 'ldapTryUsernameSplit'
              ],
              1 => (object) [
                'name' => 'ldapOptReferrals'
              ]
            ],
            10 => [
              0 => (object) [
                'name' => 'ldapCreateEspoUser'
              ],
              1 => false
            ],
            11 => [
              0 => (object) [
                'name' => 'ldapUserFirstNameAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserLastNameAttribute'
              ]
            ],
            12 => [
              0 => (object) [
                'name' => 'ldapUserTitleAttribute'
              ],
              1 => false
            ],
            13 => [
              0 => (object) [
                'name' => 'ldapUserEmailAddressAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserPhoneNumberAttribute'
              ]
            ],
            14 => [
              0 => (object) [
                'name' => 'ldapUserTeams'
              ],
              1 => (object) [
                'name' => 'ldapUserDefaultTeam'
              ]
            ],
            15 => [
              0 => (object) [
                'name' => 'ldapPortalUserLdapAuth'
              ],
              1 => false
            ],
            16 => [
              0 => (object) [
                'name' => 'ldapPortalUserPortals'
              ],
              1 => (object) [
                'name' => 'ldapPortalUserRoles'
              ]
            ]
          ]
        ],
        'fieldList' => [
          0 => 'ldapHost',
          1 => 'ldapPort',
          2 => 'ldapAuth',
          3 => 'ldapSecurity',
          4 => 'ldapUsername',
          5 => 'ldapPassword',
          6 => 'ldapBindRequiresDn',
          7 => 'ldapUserLoginFilter',
          8 => 'ldapBaseDn',
          9 => 'ldapAccountCanonicalForm',
          10 => 'ldapAccountDomainName',
          11 => 'ldapAccountDomainNameShort',
          12 => 'ldapAccountDomainName',
          13 => 'ldapAccountDomainNameShort',
          14 => 'ldapTryUsernameSplit',
          15 => 'ldapOptReferrals',
          16 => 'ldapCreateEspoUser',
          17 => 'ldapPortalUserLdapAuth'
        ],
        'dynamicLogic' => (object) [
          'fields' => (object) [
            'ldapHost' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserNameAttribute' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserObjectClass' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUsername' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapPassword' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'testConnection' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapAccountDomainName' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapAccountDomainNameShort' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapUserTitleAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserFirstNameAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserLastNameAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserEmailAddressAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserPhoneNumberAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserTeams' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserDefaultTeam' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapPortalUserPortals' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ],
            'ldapPortalUserRoles' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Oidc' => (object) [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Oidc\\Login',
      'logoutClassName' => 'Espo\\Core\\Authentication\\Oidc\\Logout',
      'login' => (object) [
        'handler' => 'handlers/login/oidc',
        'fallbackConfigParam' => 'oidcFallback'
      ],
      'provider' => (object) [
        'isAvailable' => true
      ],
      'settings' => (object) [
        'isAvailable' => true,
        'layout' => (object) [
          'label' => 'OIDC',
          'rows' => [
            0 => [
              0 => (object) [
                'name' => 'oidcClientId'
              ],
              1 => (object) [
                'name' => 'oidcClientSecret'
              ]
            ],
            1 => [
              0 => (object) [
                'name' => 'oidcAuthorizationRedirectUri',
                'view' => 'views/settings/fields/oidc-redirect-uri',
                'params' => (object) [
                  'readOnly' => true,
                  'copyToClipboard' => true
                ]
              ],
              1 => false
            ],
            2 => [
              0 => (object) [
                'name' => 'oidcAuthorizationEndpoint'
              ],
              1 => (object) [
                'name' => 'oidcTokenEndpoint'
              ]
            ],
            3 => [
              0 => (object) [
                'name' => 'oidcJwksEndpoint'
              ],
              1 => (object) [
                'name' => 'oidcJwtSignatureAlgorithmList'
              ]
            ],
            4 => [
              0 => (object) [
                'name' => 'oidcScopes'
              ],
              1 => (object) [
                'name' => 'oidcUsernameClaim'
              ]
            ],
            5 => [
              0 => (object) [
                'name' => 'oidcCreateUser'
              ],
              1 => (object) [
                'name' => 'oidcSync'
              ]
            ],
            6 => [
              0 => (object) [
                'name' => 'oidcTeams'
              ],
              1 => (object) [
                'name' => 'oidcGroupClaim'
              ]
            ],
            7 => [
              0 => (object) [
                'name' => 'oidcSyncTeams'
              ],
              1 => false
            ],
            8 => [
              0 => (object) [
                'name' => 'oidcFallback'
              ],
              1 => (object) [
                'name' => 'oidcAllowRegularUserFallback'
              ]
            ],
            9 => [
              0 => (object) [
                'name' => 'oidcAllowAdminUser'
              ],
              1 => (object) [
                'name' => 'oidcLogoutUrl'
              ]
            ],
            10 => [
              0 => (object) [
                'name' => 'oidcAuthorizationPrompt'
              ],
              1 => false
            ]
          ]
        ],
        'fieldList' => [
          0 => 'oidcClientId',
          1 => 'oidcClientSecret',
          2 => 'oidcAuthorizationEndpoint',
          3 => 'oidcTokenEndpoint',
          4 => 'oidcJwksEndpoint',
          5 => 'oidcJwtSignatureAlgorithmList',
          6 => 'oidcScopes',
          7 => 'oidcGroupClaim',
          8 => 'oidcCreateUser',
          9 => 'oidcUsernameClaim',
          10 => 'oidcTeams',
          11 => 'oidcSync',
          12 => 'oidcSyncTeams',
          13 => 'oidcAuthorizationRedirectUri',
          14 => 'oidcFallback',
          15 => 'oidcAllowRegularUserFallback',
          16 => 'oidcAllowAdminUser',
          17 => 'oidcLogoutUrl'
        ],
        'dynamicLogic' => (object) [
          'fields' => (object) [
            'oidcClientId' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcAuthorizationEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcTokenEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcUsernameClaim' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwtSignatureAlgorithmList' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwksEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'or',
                    'value' => [
                      0 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS256'
                      ],
                      1 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS384'
                      ],
                      2 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS512'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'oidcAllowRegularUserFallback' => (object) [
              'invalid' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'oidcAllowRegularUserFallback'
                  ],
                  2 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ],
            'oidcAllowAdminUser' => (object) [
              'invalid' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcAllowAdminUser'
                  ],
                  2 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'clientDefs' => (object) [
    'ActionHistoryRecord' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/action-history-record/record/list'
      ],
      'modalViews' => (object) [
        'detail' => 'views/action-history-record/modals/detail'
      ]
    ],
    'AddressCountry' => (object) [
      'controller' => 'controllers/record',
      'duplicateDisabled' => true,
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'name' => 'populateDefaults',
              'labelTranslation' => 'AddressCountry.strings.populateDefaults',
              'handler' => 'handlers/admin/address-country/populate-defaults',
              'actionFunction' => 'populate'
            ]
          ]
        ]
      ]
    ],
    'AddressMap' => (object) [
      'controller' => 'controllers/address-map'
    ],
    'ApiUser' => (object) [
      'controller' => 'controllers/api-user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/api-user/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'filterList' => [],
      'boolFilterList' => []
    ],
    'AppLogRecord' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/admin/app-log-record/record/list'
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'errors'
        ]
      ]
    ],
    'AppSecret' => (object) [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'Attachment' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/attachment/record/list',
        'detail' => 'views/attachment/record/detail'
      ],
      'modalViews' => (object) [
        'detail' => 'views/attachment/modals/detail'
      ],
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'AuthLogRecord' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/admin/auth-log-record/record/list',
        'detail' => 'views/admin/auth-log-record/record/detail',
        'detailSmall' => 'views/admin/auth-log-record/record/detail-small'
      ],
      'modalViews' => (object) [
        'detail' => 'views/admin/auth-log-record/modals/detail'
      ],
      'filterList' => [
        0 => 'accepted',
        1 => 'denied'
      ],
      'createDisabled' => true,
      'relationshipPanels' => (object) [
        'actionHistoryRecords' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthToken' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/admin/auth-token/record/list',
        'detail' => 'views/admin/auth-token/record/detail',
        'detailSmall' => 'views/admin/auth-token/record/detail-small'
      ],
      'modalViews' => (object) [
        'detail' => 'views/admin/auth-token/modals/detail'
      ],
      'filterList' => [
        0 => 'active',
        1 => 'inactive'
      ],
      'createDisabled' => true,
      'relationshipPanels' => (object) [
        'actionHistoryRecords' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthenticationProvider' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'views/authentication-provider/record/detail',
        'edit' => 'views/authentication-provider/record/edit'
      ],
      'searchPanelDisabled' => true,
      'inlineEditDisabled' => true,
      'duplicateDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true,
      'mergeDisabled' => true
    ],
    'Dashboard' => (object) [
      'controller' => 'controllers/dashboard',
      'iconClass' => 'fas fa-th-large'
    ],
    'DashboardTemplate' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'detail' => 'views/dashboard-template/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/dashboard-template/record/list'
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'action' => 'deployToUsers',
              'label' => 'Deploy to Users'
            ],
            1 => (object) [
              'action' => 'deployToTeam',
              'label' => 'Deploy to Team'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'DynamicLogic' => (object) [
      'itemTypes' => (object) [
        'and' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'and'
        ],
        'or' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'or'
        ],
        'not' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-not',
          'operator' => 'not'
        ],
        'equals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '='
        ],
        'notEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ne;'
        ],
        'greaterThan' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&gt;'
        ],
        'lessThan' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&lt;'
        ],
        'greaterThanOrEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ge;'
        ],
        'lessThanOrEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&le;'
        ],
        'isEmpty' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= &empty;'
        ],
        'isNotEmpty' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '&ne; &empty;'
        ],
        'isTrue' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 1'
        ],
        'isFalse' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 0'
        ],
        'in' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&isin;'
        ],
        'notIn' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&notin;'
        ],
        'isToday' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-is-today',
          'operatorString' => '='
        ],
        'inFuture' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-future',
          'operatorString' => '&isin;'
        ],
        'inPast' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-past',
          'operatorString' => '&isin;'
        ],
        'contains' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&niv;'
        ],
        'notContains' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&notni;'
        ],
        'has' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&niv;'
        ],
        'notHas' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&notni;'
        ],
        'startsWith' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'endsWith' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'matches' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ]
      ],
      'fieldTypes' => (object) [
        'bool' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isTrue',
            1 => 'isFalse'
          ]
        ],
        'varchar' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'contains',
            5 => 'notContains',
            6 => 'startsWith',
            7 => 'endsWith',
            8 => 'matches'
          ],
          'conditionTypes' => (object) [
            'contains' => (object) [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ],
            'notContains' => (object) [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ]
          ]
        ],
        'url' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'email' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'phone' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'text' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains',
            4 => 'matches'
          ],
          'conditionTypes' => (object) [
            'contains' => (object) [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ],
            'notContains' => (object) [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ]
          ]
        ],
        'int' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'float' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'currency' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'date' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast',
            5 => 'equals',
            6 => 'notEquals'
          ]
        ],
        'datetime' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'datetimeOptional' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'enum' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'in',
            5 => 'notIn'
          ]
        ],
        'link' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkOne' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'file' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'image' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'linkParent' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-parent',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkMultiple' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-multiple',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains'
          ]
        ],
        'foreign' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'id' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'multiEnum' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'array' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'checklist' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'urlMultiple' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'currentUser' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals'
          ]
        ],
        'currentUserTeams' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user-teams',
          'typeList' => [
            0 => 'contains',
            1 => 'notContains'
          ]
        ]
      ],
      'conditionTypes' => (object) [
        'isTrue' => (object) [
          'valueType' => 'empty'
        ],
        'isFalse' => (object) [
          'valueType' => 'empty'
        ],
        'isEmpty' => (object) [
          'valueType' => 'empty'
        ],
        'isNotEmpty' => (object) [
          'valueType' => 'empty'
        ],
        'equals' => (object) [
          'valueType' => 'field'
        ],
        'notEquals' => (object) [
          'valueType' => 'field'
        ],
        'greaterThan' => (object) [
          'valueType' => 'field'
        ],
        'lessThan' => (object) [
          'valueType' => 'field'
        ],
        'greaterThanOrEquals' => (object) [
          'valueType' => 'field'
        ],
        'lessThanOrEquals' => (object) [
          'valueType' => 'field'
        ],
        'in' => (object) [
          'valueType' => 'field'
        ],
        'notIn' => (object) [
          'valueType' => 'field'
        ],
        'contains' => (object) [
          'valueType' => 'custom'
        ],
        'notContains' => (object) [
          'valueType' => 'custom'
        ],
        'inPast' => (object) [
          'valueType' => 'empty'
        ],
        'isFuture' => (object) [
          'valueType' => 'empty'
        ],
        'isToday' => (object) [
          'valueType' => 'empty'
        ],
        'has' => (object) [
          'valueType' => 'field'
        ],
        'notHas' => (object) [
          'valueType' => 'field'
        ],
        'startsWith' => (object) [
          'valueType' => 'varchar'
        ],
        'endsWith' => (object) [
          'valueType' => 'varchar'
        ],
        'matches' => (object) [
          'valueType' => 'varchar'
        ]
      ]
    ],
    'Email' => (object) [
      'controller' => 'controllers/email',
      'acl' => 'acl/email',
      'views' => (object) [
        'list' => 'views/email/list',
        'detail' => 'views/email/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/email/record/list',
        'detail' => 'views/email/record/detail',
        'edit' => 'views/email/record/edit',
        'editQuick' => 'views/email/record/edit-quick',
        'detailQuick' => 'views/email/record/detail-quick',
        'compose' => 'views/email/record/compose',
        'listRelated' => 'views/email/record/list-related'
      ],
      'modalViews' => (object) [
        'detail' => 'views/email/modals/detail',
        'compose' => 'views/modals/compose-email'
      ],
      'quickCreateModalType' => 'compose',
      'defaultSidePanelView' => 'views/email/record/panels/default-side',
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'event',
            'label' => 'Event',
            'view' => 'views/email/record/panels/event',
            'isForm' => true,
            'hidden' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Compose',
              'action' => 'composeEmail',
              'style' => 'danger',
              'acl' => 'create',
              'className' => 'btn-s-wide',
              'title' => 'Ctrl+Space'
            ]
          ],
          'dropdown' => [
            0 => (object) [
              'name' => 'archiveEmail',
              'label' => 'Archive Email',
              'link' => '#Email/create',
              'acl' => 'create'
            ],
            1 => (object) [
              'name' => 'importEml',
              'label' => 'Import EML',
              'handler' => 'handlers/email/list-actions',
              'checkVisibilityFunction' => 'checkImportEml',
              'actionFunction' => 'importEml'
            ],
            2 => false,
            3 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            4 => (object) [
              'label' => 'Folders',
              'link' => '#EmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ]
              ]
            ],
            5 => (object) [
              'label' => 'Group Folders',
              'link' => '#GroupEmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ],
                1 => (object) [
                  'isAdminOnly' => true
                ]
              ]
            ],
            6 => (object) [
              'label' => 'Filters',
              'link' => '#EmailFilter',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ]
              ]
            ]
          ]
        ],
        'detail' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Reply',
              'action' => 'reply',
              'acl' => 'read'
            ],
            1 => (object) [
              'label' => 'Reply to All',
              'action' => 'replyToAll',
              'acl' => 'read'
            ],
            2 => (object) [
              'label' => 'Forward',
              'action' => 'forward',
              'acl' => 'read'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'selectHandler' => 'handlers/email/select-user'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'replied' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliedId',
                  'data' => (object) [
                    'field' => 'replied'
                  ]
                ]
              ]
            ]
          ],
          'replies' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliesIds',
                  'data' => (object) [
                    'field' => 'replies'
                  ]
                ]
              ]
            ]
          ],
          'folderString' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isUsers'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'groupFolderId'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'sendAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'event' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'icsEventDateStart'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [],
      'defaultFilterData' => (object) [],
      'boolFilterList' => [],
      'iconClass' => 'fas fa-envelope',
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutDetailDisabled' => true,
      'layoutDetailSmallDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true
    ],
    'EmailAccount' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/email-account/record/list',
        'detail' => 'views/email-account/record/detail',
        'edit' => 'views/email-account/record/edit'
      ],
      'views' => (object) [
        'list' => 'views/email-account/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => (object) [
        'storeSentEmails' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ],
              1 => (object) [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'sentFolder'
              ]
            ],
            1 => (object) [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'sentFolder'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'smtpUsername' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'active'
        ]
      ],
      'relationshipPanels' => (object) [
        'filters' => (object) [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailAddress' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'EmailFilter' => (object) [
      'controller' => 'controllers/email-filter',
      'dynamicHandler' => 'handlers/email-filter',
      'modalViews' => (object) [
        'edit' => 'views/email-filter/modals/edit'
      ],
      'recordViews' => (object) [
        'list' => 'views/email-filter/record/list'
      ],
      'inlineEditDisabled' => true,
      'searchPanelDisabled' => false,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'parent' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ]
          ],
          'emailFolder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ]
          ],
          'groupEmailFolder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ]
          ],
          'markAsRead' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ],
          'skipNotification' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'action' => [
            0 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isTrue'
                ]
              ],
              'optionList' => [
                0 => 'Skip'
              ]
            ],
            1 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Folder',
                2 => 'None'
              ]
            ],
            2 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'InboundEmail'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Group Folder'
              ]
            ],
            3 => (object) [
              'conditionGroup' => [],
              'optionList' => [
                0 => 'Skip'
              ]
            ]
          ]
        ]
      ]
    ],
    'EmailFolder' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/email-folder/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'EmailTemplate' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/email-template/list'
      ],
      'recordViews' => (object) [
        'edit' => 'views/email-template/record/edit',
        'detail' => 'views/email-template/record/detail',
        'editQuick' => 'views/email-template/record/edit-quick'
      ],
      'modalViews' => (object) [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual'
      ],
      'placeholderList' => [
        0 => 'optOutUrl',
        1 => 'optOutLink'
      ],
      'iconClass' => 'fas fa-envelope-square'
    ],
    'EmailTemplateCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#EmailTemplateCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#EmailTemplateCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'emailTemplates' => (object) [
          'create' => false
        ],
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'ExternalAccount' => (object) [
      'controller' => 'controllers/external-account'
    ],
    'Global' => (object) [
      'detailActionList' => [
        0 => (object) [
          'name' => 'viewAuditLog',
          'label' => 'View Audit Log',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-audit-log',
          'groupIndex' => 4
        ],
        1 => (object) [
          'name' => 'viewUserAccess',
          'label' => 'View User Access',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-user-access',
          'groupIndex' => 4
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'dropdown' => [
            0 => (object) [
              'name' => 'startProcessGlobal',
              'action' => 'startProcessGlobal',
              'label' => 'Start Process',
              'acl' => 'create',
              'aclScope' => 'BpmnProcess',
              'hidden' => true,
              'data' => (object) [
                'handler' => 'advanced:start-process-action-handler'
              ],
              'initFunction' => 'init'
            ]
          ]
        ]
      ],
      'viewSetupHandlers' => (object) [
        'detail' => [
          0 => 'advanced:handlers/manual-workflow'
        ]
      ]
    ],
    'GlobalStream' => (object) [
      'controller' => 'controllers/global-stream',
      'iconClass' => 'fas fa-rss-square'
    ],
    'GroupEmailFolder' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/group-email-folder/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/group-email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'emails',
              'labelTranslation' => 'Global.scopeNamesPlural.Email',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Home' => (object) [
      'iconClass' => 'fas fa-th-large'
    ],
    'Import' => (object) [
      'controller' => 'controllers/import',
      'acl' => 'acl/import',
      'recordViews' => (object) [
        'list' => 'views/import/record/list',
        'detail' => 'views/import/record/detail'
      ],
      'views' => (object) [
        'list' => 'views/import/list',
        'detail' => 'views/import/detail'
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'imported',
            'label' => 'Imported',
            'view' => 'views/import/record/panels/imported',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          1 => (object) [
            'name' => 'duplicates',
            'label' => 'Duplicates',
            'view' => 'views/import/record/panels/duplicates',
            'rowActionsView' => 'views/import/record/row-actions/duplicates',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          2 => (object) [
            'name' => 'updated',
            'label' => 'Updated',
            'view' => 'views/import/record/panels/updated',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => (object) [
        'errors' => (object) [
          'unlinkDisabled' => true,
          'actionList' => [
            0 => (object) [
              'name' => 'export',
              'label' => 'Export',
              'handler' => 'handlers/import',
              'actionFunction' => 'errorExport'
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-import',
      'dateFormatList' => [
        0 => 'YYYY-MM-DD',
        1 => 'DD-MM-YYYY',
        2 => 'MM-DD-YYYY',
        3 => 'MM/DD/YYYY',
        4 => 'DD/MM/YYYY',
        5 => 'DD.MM.YYYY',
        6 => 'MM.DD.YYYY',
        7 => 'YYYY.MM.DD',
        8 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm:ss',
        1 => 'HH:mm',
        2 => 'hh:mm a',
        3 => 'hh:mma',
        4 => 'hh:mm A',
        5 => 'hh:mmA',
        6 => 'hh:mm:ss a',
        7 => 'hh:mm:ssa',
        8 => 'hh:mm:ss A',
        9 => 'hh:mm:ssA'
      ]
    ],
    'ImportError' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'acl/foreign',
      'searchPanelDisabled' => true,
      'createDisabled' => true,
      'editDisabled' => true
    ],
    'InboundEmail' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/inbound-email/record/detail',
        'edit' => 'views/inbound-email/record/edit',
        'list' => 'views/inbound-email/record/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => (object) [
        'reply' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'replyEmailTemplate',
                  1 => 'replyFromAddress',
                  2 => 'replyFromName'
                ]
              ],
              1 => (object) [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'replyEmailTemplate'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'replyEmailTemplate',
                1 => 'replyFromAddress',
                2 => 'replyFromName'
              ]
            ],
            1 => (object) [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'replyEmailTemplate'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'smtpUsername' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ],
          'isSystem' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => (object) [
        'filters' => (object) [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'detailSmall' => [],
        'edit' => [],
        'editSmall' => []
      ]
    ],
    'Job' => (object) [
      'modalViews' => (object) [
        'detail' => 'views/admin/job/modals/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/admin/job/record/list',
        'detailQuick' => 'views/admin/job/record/detail-small'
      ]
    ],
    'LastViewed' => (object) [
      'controller' => 'controllers/last-viewed',
      'views' => (object) [
        'list' => 'views/last-viewed/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/last-viewed/record/list'
      ]
    ],
    'LayoutSet' => (object) [
      'controller' => 'controllers/layout-set',
      'recordViews' => (object) [
        'list' => 'views/layout-set/record/list'
      ],
      'searchPanelDisabled' => true,
      'duplicateDisabled' => true,
      'relationshipPanels' => (object) [
        'teams' => (object) [
          'createDisabled' => true,
          'viewDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ]
    ],
    'LeadCapture' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'recordViews' => (object) [
        'detail' => 'views/lead-capture/record/detail',
        'list' => 'views/lead-capture/record/list'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'subscribeContactToTargetList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'optInConfirmationLifetime' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'optInConfirmationSuccessMessage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'createLeadBeforeOptInConfirmation' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'smtpAccount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'skipOptInConfirmationIfSubscribed' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'optInConfirmation'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'targetListId',
                      'data' => (object) [
                        'field' => 'targetList'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'optInConfirmationEmailTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'apiKey' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'phoneNumberCountry' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'fieldList',
                  'value' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'formSuccessText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formSuccessRedirectUrl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formLanguage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formFrameAncestors' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formCaptcha' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'form' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'request',
            'label' => 'Request',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/request',
            'notRefreshable' => true
          ],
          1 => (object) [
            'name' => 'form',
            'label' => 'Web Form',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/form',
            'notRefreshable' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'logRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/view-and-remove',
          'layout' => 'listForLeadCapture',
          'select' => false,
          'create' => false
        ]
      ]
    ],
    'LeadCaptureLogRecord' => (object) [
      'modalViews' => (object) [
        'detail' => 'views/lead-capture-log-record/modals/detail'
      ]
    ],
    'Note' => (object) [
      'controller' => 'controllers/note',
      'collection' => 'collections/note',
      'recordViews' => (object) [
        'edit' => 'views/note/record/edit',
        'editQuick' => 'views/note/record/edit',
        'listRelated' => 'views/stream/record/list'
      ],
      'modalViews' => (object) [
        'edit' => 'views/note/modals/edit'
      ],
      'itemViews' => (object) [
        'Post' => 'views/stream/notes/post',
        'EventConfirmation' => 'crm:views/stream/notes/event-confirmation'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'handlers/note/record-detail-setup'
        ]
      ]
    ],
    'Notification' => (object) [
      'controller' => 'controllers/notification',
      'acl' => 'acl/notification',
      'aclPortal' => 'acl-portal/notification',
      'collection' => 'collections/note',
      'itemViews' => (object) [
        'System' => 'views/notification/items/system',
        'EmailInbox' => 'views/notification/items/email-inbox',
        'EventAttendee' => 'crm:views/notification/items/event-attendee'
      ]
    ],
    'PasswordChangeRequest' => (object) [
      'controller' => 'controllers/password-change-request'
    ],
    'PhoneNumber' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'Portal' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/portal/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only',
          'layout' => 'listSmall',
          'selectPrimaryFilterName' => 'activePortal'
        ],
        'authenticationProvider' => (object) [
          'createDisabled' => true
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'PortalRole' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/portal-role/record/detail',
        'edit' => 'views/portal-role/record/edit',
        'editQuick' => 'views/portal-role/record/edit',
        'list' => 'views/portal-role/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => (object) [
        'list' => 'views/portal-role/list'
      ]
    ],
    'PortalUser' => (object) [
      'controller' => 'controllers/portal-user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/portal-user/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ]
        ]
      ],
      'filterList' => [
        0 => 'activePortal'
      ],
      'boolFilterList' => [],
      'selectDefaultFilters' => (object) [
        'filter' => 'activePortal'
      ],
      'iconClass' => 'far fa-user-circle'
    ],
    'Preferences' => (object) [
      'recordViews' => (object) [
        'edit' => 'views/preferences/record/edit'
      ],
      'views' => (object) [
        'edit' => 'views/preferences/edit'
      ],
      'acl' => 'acl/preferences',
      'aclPortal' => 'acl-portal/preferences',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'assignmentEmailNotificationsIgnoreEntityTypeList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'receiveAssignmentEmailNotifications'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Role' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/role/record/detail',
        'edit' => 'views/role/record/edit',
        'editQuick' => 'views/role/record/edit',
        'list' => 'views/role/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ],
        'teams' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => (object) [
        'list' => 'views/role/list'
      ]
    ],
    'ScheduledJob' => (object) [
      'controller' => 'controllers/record',
      'relationshipPanels' => (object) [
        'log' => (object) [
          'readOnly' => true,
          'view' => 'views/scheduled-job/record/panels/log',
          'createDisabled' => true,
          'selectDisabled' => true,
          'viewDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'recordViews' => (object) [
        'list' => 'views/scheduled-job/record/list',
        'detail' => 'views/scheduled-job/record/detail'
      ],
      'views' => (object) [
        'list' => 'views/scheduled-job/list'
      ],
      'jobWithTargetList' => [
        0 => 'CheckEmailAccounts',
        1 => 'CheckInboundEmails'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'job' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ScheduledJobLogRecord' => (object) [
      'controller' => 'controllers/record'
    ],
    'Stream' => (object) [
      'controller' => 'controllers/stream',
      'iconClass' => 'fas fa-rss'
    ],
    'Team' => (object) [
      'acl' => 'acl/team',
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'createdAt'
        ]
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'layout' => 'listForTeam',
          'selectPrimaryFilterName' => 'active',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ],
          'rowActionList' => [
            0 => 'changeTeamPosition'
          ],
          'selectMandatoryAttributeList' => [
            0 => 'teamRole'
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'views/team/record/detail',
        'edit' => 'views/team/record/edit',
        'list' => 'views/team/record/list'
      ],
      'modalViews' => (object) [
        'detail' => 'views/team/modals/detail'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-users'
    ],
    'Template' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'views/template/record/detail',
        'edit' => 'views/template/record/edit'
      ],
      'mergeDisabled' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'footer' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'footerPosition' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'header' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'headerPosition' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'body' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'pageWidth' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ],
          'pageHeight' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-pdf'
    ],
    'User' => (object) [
      'controller' => 'controllers/user',
      'model' => 'models/user',
      'acl' => 'acl/user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/user/list'
      ],
      'recordViews' => (object) [
        'detail' => 'views/user/record/detail',
        'detailSmall' => 'views/user/record/detail-quick',
        'edit' => 'views/user/record/edit',
        'editSmall' => 'views/user/record/edit-quick',
        'list' => 'views/user/record/list'
      ],
      'modalViews' => (object) [
        'selectFollowers' => 'views/user/modals/select-followers',
        'detail' => 'views/user/modals/detail',
        'massUpdate' => 'views/user/modals/mass-update'
      ],
      'rowActionDefs' => (object) [
        'changeTeamPosition' => (object) [
          'labelTranslation' => 'User.actions.changePosition',
          'handler' => 'handlers/user/change-team-position-row-action',
          'groupIndex' => 3
        ]
      ],
      'defaultSidePanel' => (object) [
        'detail' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'detailSmall' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'edit' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'editSmall' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess',
          3 => 'auth2FA'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'lastAccess'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'registration' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'portals' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'layoutDefaultSidePanelDisabled' => true,
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMyTeam'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'selectRecords' => (object) [
        'orderBy' => 'userNameOwnFirst'
      ],
      'iconClass' => 'fas fa-user-circle',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'avatarColor' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'avatarId',
                  'value' => NULL,
                  'data' => (object) [
                    'field' => 'avatar'
                  ]
                ],
                1 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'regular',
                    1 => 'admin',
                    2 => 'api'
                  ]
                ]
              ]
            ]
          ],
          'emailAddress' => (object) [
            'readOnly' => NULL
          ],
          'cRegistration' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'cRegistrationId',
                  'data' => (object) [
                    'field' => 'cRegistration'
                  ]
                ]
              ]
            ]
          ],
          'usertoken' => (object) [
            'visible' => NULL
          ]
        ],
        'options' => (object) [
          'authMethod' => [
            0 => (object) [
              'optionList' => [
                0 => 'ApiKey',
                1 => 'Hmac'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'api'
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Webhook' => (object) [
      'controller' => 'controllers/record',
      'inlineEditDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/webhook/record/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.WebhookQueueItem',
              'link' => '#WebhookQueueItem',
              'aclScope' => 'WebhookQueueItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'event' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'secretKey' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WebhookQueueItem' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'textFilterDisabled' => true
    ],
    'WorkingTimeCalendar' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'iconClass' => 'fas fa-calendar-week',
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'ranges',
              'labelTranslation' => 'WorkingTimeCalendar.links.ranges',
              'link' => '#WorkingTimeRange'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'weekday0TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday0'
                ]
              ]
            ]
          ],
          'weekday1TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday1'
                ]
              ]
            ]
          ],
          'weekday2TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday2'
                ]
              ]
            ]
          ],
          'weekday3TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday3'
                ]
              ]
            ]
          ],
          'weekday4TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday4'
                ]
              ]
            ]
          ],
          'weekday5TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday5'
                ]
              ]
            ]
          ],
          'weekday6TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday6'
                ]
              ]
            ]
          ],
          'teams' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'teamsIds'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkingTimeRange' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'record/edit' => [
          0 => 'handlers/working-time-range'
        ]
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'calendars',
              'label' => 'Calendars',
              'link' => '#WorkingTimeCalendar'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'timeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Working'
                ]
              ]
            ]
          ],
          'users' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'usersIds'
                    ],
                    2 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'calendarsIds'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual'
      ]
    ],
    'Account' => (object) [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/account',
      'views' => (object) [
        'detail' => 'crm:views/account/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'filterList' => [
            0 => 'all',
            1 => 'accountActive'
          ],
          'layout' => 'listForAccount',
          'orderBy' => 'name',
          'createAttributeMap' => (object) [
            'billingAddressCity' => 'addressCity',
            'billingAddressStreet' => 'addressStreet',
            'billingAddressPostalCode' => 'addressPostalCode',
            'billingAddressState' => 'addressState',
            'billingAddressCountry' => 'addressCountry',
            'id' => 'accountId',
            'name' => 'accountName'
          ]
        ],
        'opportunities' => (object) [
          'layout' => 'listForAccount',
          'createHandler' => 'sales:handlers/account/create-opportunity'
        ],
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => (object) [
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'quotes' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'purchaseOrders' => (object) [
          'createAction' => 'createRelatedPurchaseOrder',
          'view' => 'sales:views/account/record/panels/purchase-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'registrationsReseller' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'registrationsCustomer' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendationsConfig' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendationses' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'recentlyCreated'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ],
        'formulárioDeCadastro-4customers' => (object) [
          'type' => 'detail'
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-building',
      'kanbanViewMode' => false,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'cMpnID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Partner'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Partner'
                ]
              ]
            ]
          ],
          'cTenantID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Activities' => (object) [
      'controller' => 'crm:controllers/activities'
    ],
    'Calendar' => (object) [
      'colors' => (object) [
        'Meeting' => '#558BBD',
        'Call' => '#CF605D',
        'Task' => '#70c173'
      ],
      'scopeList' => [
        0 => 'Meeting',
        1 => 'Call',
        2 => 'Task'
      ],
      'allDayScopeList' => [
        0 => 'Task'
      ],
      'modeList' => [
        0 => 'month',
        1 => 'agendaWeek',
        2 => 'timeline',
        3 => 'agendaDay'
      ],
      'sharedViewModeList' => [
        0 => 'basicWeek',
        1 => 'month',
        2 => 'basicDay'
      ],
      'additionalColorList' => [
        0 => '#AB78AD',
        1 => '#CC9B45'
      ],
      'iconClass' => 'far fa-calendar-alt',
      'slotDuration' => 30
    ],
    'Call' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/call',
      'views' => (object) [
        'detail' => 'crm:views/call/detail'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/call/record/list',
        'detail' => 'crm:views/call/record/detail',
        'editSmall' => 'crm:views/call/record/edit-small'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 3
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'planned'
        ],
        1 => (object) [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => (object) [
        'link' => 'calls',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => (object) [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => (object) [
        'bottomPanelsEditSmall' => (object) [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'iconClass' => 'fas fa-phone'
    ],
    'Campaign' => (object) [
      'controller' => 'controllers/record',
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Target Lists',
              'link' => '#TargetList',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'TargetList'
            ]
          ],
          'dropdown' => [
            0 => (object) [
              'label' => 'Mass Emails',
              'link' => '#MassEmail',
              'acl' => 'read',
              'aclScope' => 'MassEmail'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            2 => (object) [
              'label' => 'Tracking URLs',
              'labelTranslation' => 'Campaign.links.trackingUrls',
              'link' => '#CampaignTrackingUrl',
              'acl' => 'read',
              'aclScope' => 'CampaignTrackingUrl'
            ]
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/campaign/record/detail'
      ],
      'views' => (object) [
        'detail' => 'crm:views/campaign/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'statistics',
            'label' => 'Statistics',
            'view' => 'crm:views/campaign/record/panels/campaign-stats',
            'hidden' => false,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'view' => 'crm:views/campaign/record/panels/campaign-log-records',
          'layout' => 'listForCampaign',
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'select' => false,
          'create' => false
        ],
        'massEmails' => (object) [
          'createAttributeMap' => (object) [
            'targetListsIds' => 'targetListsIds',
            'targetListsNames' => 'targetListsNames',
            'excludingTargetListsIds' => 'excludingTargetListsIds',
            'excludingTargetListsNames' => 'excludingTargetListsNames'
          ],
          'createHandler' => 'crm:handlers/campaign/mass-emails-create'
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetLists' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'excludingTargetLists' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'contactsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'leadsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'accountsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'usersTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'mailMergeOnlyWithAddress' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'mailMerge' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-line'
    ],
    'CampaignLogRecord' => (object) [
      'acl' => 'crm:acl/campaign-tracking-url'
    ],
    'CampaignTrackingUrl' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/campaign-tracking-url',
      'recordViews' => (object) [
        'edit' => 'crm:views/campaign-tracking-url/record/edit',
        'editQuick' => 'crm:views/campaign-tracking-url/record/edit-small'
      ],
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'url' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ]
          ],
          'message' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Case' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'crm:views/case/record/detail'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'close',
          'label' => 'Close',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'close',
          'checkVisibilityFunction' => 'isCloseAvailable'
        ],
        1 => (object) [
          'name' => 'reject',
          'label' => 'Reject',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'reject',
          'checkVisibilityFunction' => 'isRejectAvailable'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'open'
        ],
        1 => (object) [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => (object) [
        'articles' => (object) [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'rowActionList' => [
            0 => 'sendInEmail'
          ]
        ],
        'contacts' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'open'
      ],
      'allowInternalNotes' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'cApiUser' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ]
          ],
          'cApiPassword' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'API Access'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Closed'
                ]
              ]
            ]
          ],
          'cCustomizeUrl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ]
          ],
          'cRegistrationAddress' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Pending',
                    1 => 'Closed'
                  ]
                ],
                2 => (object) [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'domain'
                ]
              ]
            ]
          ],
          'cUrlType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ]
              ]
            ]
          ],
          'cStandardUrl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'standard'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customize URL'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'cUrlType',
                  'value' => 'standard'
                ]
              ]
            ]
          ],
          'description' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'API Access',
                    1 => 'Customize URL'
                  ]
                ]
              ]
            ]
          ],
          'attachments' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'API Access',
                    1 => 'Customize URL'
                  ]
                ]
              ]
            ]
          ],
          'status' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'notIn',
                      'attribute' => 'type',
                      'value' => [
                        0 => 'Customize URL',
                        1 => 'API Access'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'name'
                    ]
                  ]
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Customize URL',
                    1 => 'API Access'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailPortal' => (object) [
          'type' => 'detail'
        ],
        'detailSmallPortal' => (object) [
          'type' => 'detail'
        ],
        'listPortal' => (object) [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-wrench',
      'kanbanViewMode' => true,
      'color' => '#00bbd0'
    ],
    'Contact' => (object) [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/contact',
      'views' => (object) [
        'detail' => 'crm:views/contact/detail'
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/contact/record/detail',
        'detailQuick' => 'crm:views/contact/record/detail-small'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'opportunities' => (object) [
          'layout' => 'listForContact',
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'cases' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'registrationsContact' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ],
        'listForAccount' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'filterList' => [
        0 => 'portalUsers'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'accountId'
                ]
              ]
            ]
          ],
          'portalUser' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => (object) [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'customerID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Customer'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'ISV'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'partnerID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'ISV'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Reseller'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-user-friends',
      'kanbanViewMode' => false
    ],
    'Document' => (object) [
      'aclPortal' => 'crm:acl-portal/document',
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/document/list'
      ],
      'modalViews' => (object) [
        'select' => 'crm:views/document/modals/select-records'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'crm:view-setup-handlers/document/record-list-drag-n-drop'
        ]
      ],
      'filterList' => [
        0 => 'active',
        1 => 'draft'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'iconClass' => 'far fa-file-alt',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'DocumentFolder' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#DocumentFolder/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#DocumentFolder',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailQueueItem' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/email-queue-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/email-queue-item/record/list'
      ],
      'createDisabled' => true,
      'mergeDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'KnowledgeBaseArticle' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/knowledge-base-article/list'
      ],
      'recordViews' => (object) [
        'editQuick' => 'crm:views/knowledge-base-article/record/edit-quick',
        'detailQuick' => 'crm:views/knowledge-base-article/record/detail-quick',
        'detail' => 'crm:views/knowledge-base-article/record/detail',
        'edit' => 'crm:views/knowledge-base-article/record/edit',
        'list' => 'crm:views/knowledge-base-article/record/list'
      ],
      'modalViews' => (object) [
        'select' => 'crm:views/knowledge-base-article/modals/select-records'
      ],
      'rowActionDefs' => (object) [
        'moveToTop' => (object) [
          'label' => 'Move to Top',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveUp' => (object) [
          'label' => 'Move Up',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveDown' => (object) [
          'label' => 'Move Down',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveToBottom' => (object) [
          'labelTranslation' => 'KnowledgeBaseArticle.labels.Move to Bottom',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'sendInEmail' => (object) [
          'label' => 'Send in Email',
          'handler' => 'crm:handlers/knowledge-base-article/send-in-email'
        ]
      ],
      'rowActionList' => [
        0 => 'moveToTop',
        1 => 'moveUp',
        2 => 'moveDown',
        3 => 'moveToBottom'
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'published',
          'accessDataList' => [
            0 => (object) [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => (object) [
          'name' => 'onlyMy',
          'accessDataList' => [
            0 => (object) [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'cases' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-view-and-unlink'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailPortal' => (object) [
          'type' => 'detail'
        ],
        'detailSmallPortal' => (object) [
          'type' => 'detail'
        ],
        'listPortal' => (object) [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-book',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'KnowledgeBaseCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#KnowledgeBaseCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#KnowledgeBaseCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Lead' => (object) [
      'controller' => 'crm:controllers/lead',
      'views' => (object) [
        'detail' => 'crm:views/lead/detail'
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/lead/record/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'converted',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'name' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'accountName'
                ],
                1 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'emailAddress'
                ],
                2 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'convertedAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Converted'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'convertedAt'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'convertedTo' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Converted'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-users',
      'kanbanViewMode' => false
    ],
    'MassEmail' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/mass-email',
      'recordViews' => (object) [
        'detail' => 'crm:views/mass-email/record/detail',
        'edit' => 'crm:views/mass-email/record/edit',
        'editQuick' => 'crm:views/mass-email/record/edit-small'
      ],
      'views' => (object) [
        'detail' => 'crm:views/mass-email/detail'
      ],
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.EmailQueueItem',
              'link' => '#EmailQueueItem',
              'accessDataList' => [
                0 => (object) [
                  'isAdminOnly' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'or',
                      'value' => [
                        0 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Complete'
                        ],
                        1 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'In Process'
                        ],
                        2 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Failed'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'status' => [
            0 => (object) [
              'optionList' => [
                0 => 'Draft',
                1 => 'Pending'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft',
                    1 => 'Pending'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'complete',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => (object) [
        'queueItems' => (object) [
          'unlinkDisabled' => true,
          'viewDisabled' => true,
          'editDisabled' => true
        ]
      ]
    ],
    'Meeting' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/meeting',
      'views' => (object) [
        'detail' => 'crm:views/meeting/detail'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/meeting/record/list',
        'detail' => 'crm:views/meeting/record/detail',
        'editSmall' => 'crm:views/meeting/record/edit-small'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'options' => (object) [
              'fieldList' => [
                0 => 'users',
                1 => 'contacts',
                2 => 'leads'
              ]
            ],
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 3
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'planned'
        ],
        1 => (object) [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => (object) [
        'link' => 'meetings',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => (object) [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => (object) [
        'bottomPanelsEditSmall' => (object) [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'duration' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isAllDay'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-calendar-check'
    ],
    'Opportunity' => (object) [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'crm:handlers/opportunity/defaults-preparator',
      'views' => (object) [
        'detail' => 'crm:views/opportunity/detail'
      ],
      'recordViews' => (object) [
        'edit' => 'crm:views/opportunity/record/edit',
        'editSmall' => 'crm:views/opportunity/record/edit-small',
        'list' => 'crm:views/opportunity/record/list',
        'kanban' => 'crm:views/opportunity/record/kanban'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true,
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'open'
        ],
        1 => (object) [
          'name' => 'won',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ],
        'listForAccount' => (object) [
          'type' => 'listSmall'
        ],
        'listForContact' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'createHandler' => 'crm:handlers/opportunity/contacts-create',
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'documents' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'quotes' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/opportunity/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => (object) [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/opportunity/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/opportunity/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'account' => (object) [
          'selectFieldHandler' => 'sales:handlers/opportunity/select-account',
          'selectMandatoryAttributeList' => [
            0 => 'priceBookId',
            1 => 'priceBookName'
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'lastStage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Lost'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-dollar-sign'
    ],
    'TargetList' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'optedOut',
            'label' => 'Opted Out',
            'view' => 'crm:views/target-list/record/panels/opted-out'
          ],
          1 => (object) [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/target-list/record/detail'
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'contacts'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'contacts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'leads' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'leads'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'leads'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'accounts' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'accounts'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'accounts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'users' => (object) [
          'create' => false,
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'users'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'users'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'syncWithReports' => (object) [
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entryCount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'optedOutCount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-crosshairs',
      'formDependency' => (object) [
        'syncWithReportsEnabled' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'syncWithReports',
                  1 => 'syncWithReportsUnlink'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'syncWithReports',
                1 => 'syncWithReportsUnlink'
              ]
            ]
          ]
        ]
      ]
    ],
    'Task' => (object) [
      'controller' => 'crm:controllers/task',
      'recordViews' => (object) [
        'list' => 'crm:views/task/record/list',
        'detail' => 'crm:views/task/record/detail'
      ],
      'views' => (object) [
        'list' => 'crm:views/task/list',
        'detail' => 'crm:views/task/detail'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/task/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/task/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/task/reminders-handler'
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Complete',
              'name' => 'setCompletedMain',
              'iconHtml' => '<span class="fas fa-check fa-sm"></span>',
              'acl' => 'edit',
              'handler' => 'crm:handlers/task/menu',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'isCompleteAvailable'
            ]
          ]
        ]
      ],
      'modalDetailActionList' => [
        0 => (object) [
          'name' => 'complete',
          'label' => 'Complete',
          'acl' => 'edit',
          'handler' => 'crm:handlers/task/detail-actions',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'isCompleteAvailable'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'dateCompleted' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'reminders' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'or',
                      'value' => [
                        0 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'dateEnd'
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'dateEndDate'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Completed'
                    ],
                    2 => (object) [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Canceled'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ],
        3 => (object) [
          'name' => 'overdue',
          'style' => 'danger'
        ],
        4 => (object) [
          'name' => 'deferred'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-tasks',
      'kanbanViewMode' => true
    ],
    'BpmnFlowNode' => (object) [
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true
    ],
    'BpmnFlowchart' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-flowchart/record/detail',
        'edit' => 'advanced:views/bpmn-flowchart/record/edit'
      ],
      'views' => (object) [
        'list' => 'modules/advanced/views/bpmn-flowchart/list-with-categories'
      ],
      'modalViews' => (object) [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Processes',
              'link' => '#BpmnProcess',
              'acl' => 'read',
              'aclScope' => 'BpmnProcess'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'relationshipPanels' => (object) [
        'processes' => (object) [
          'create' => false,
          'select' => false,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/view-only'
        ]
      ],
      'iconClass' => 'fas fa-project-diagram',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'elements' => (object) [
        'eventStartConditional' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'triggerType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'afterRecordCreated',
                1 => 'afterRecordUpdated',
                2 => 'afterRecordSaved'
              ]
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'triggerType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'triggerType' => 'afterRecordCreated',
            'isInterrupting' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-edit'
        ],
        'eventStartTimer' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ],
            'targetReport' => (object) [
              'type' => 'link',
              'entity' => 'Report',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-report',
              'tooltip' => true
            ],
            'scheduling' => (object) [
              'type' => 'varchar',
              'maxLength' => 16,
              'tooltip' => true,
              'noSpellCheck' => true
            ],
            'schedulingApplyTimezone' => (object) [
              'type' => 'bool',
              'default' => false,
              'tooltip' => true
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'targetReport'
                  ],
                  1 => (object) [
                    'name' => 'scheduling'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => (object) [
                    'name' => 'schedulingApplyTimezone'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'isInterrupting' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL,
            'targetReportId' => NULL,
            'scheduling' => '0 0 * * *',
            'schedulingApplyTimezone' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-edit'
        ],
        'eventStartError' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartEscalation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartSignal' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-signal-edit'
        ],
        'eventStart' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartCompensation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEnd' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndTerminate' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndError' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndEscalation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndSignal' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'activityId' => (object) [
              'type' => 'varchar',
              'maxLength' => 36,
              'tooltip' => 'compensateActivityId',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'activityId' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndCompensation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'activityId' => (object) [
              'type' => 'varchar',
              'maxLength' => 36,
              'tooltip' => 'compensateActivityId',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'activityId' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateMessageCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => (object) [
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'relatedTo' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateMessageBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false,
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'relatedTo' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal',
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL,
            'cancelActivity' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateErrorBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateTimerBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateTimerCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'gatewayExclusive' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'defaultFlowId' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayInclusive' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'defaultFlowId' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayParallel' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'gatewayEventBased' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'task' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'actions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/actions',
              'actionTypeList' => [
                0 => 'createEntity',
                1 => 'createRelatedEntity',
                2 => 'updateEntity',
                3 => 'updateRelatedEntity',
                4 => 'updateCreatedEntity',
                5 => 'updateProcessEntity',
                6 => 'relateWithEntity',
                7 => 'unrelateFromEntity',
                8 => 'applyAssignmentRule',
                9 => 'createNotification',
                10 => 'makeFollowed',
                11 => 'triggerWorkflow',
                12 => 'runService',
                13 => 'sendRequest',
                14 => 'executeFormula'
              ]
            ],
            'isolateVariables' => (object) [
              'type' => 'bool',
              'tooltip' => true
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => 'taskReturnVariableList'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'label' => 'Actions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'actions',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isolateVariables'
                  ],
                  1 => (object) [
                    'name' => 'returnVariableList'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description'
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'text' => NULL,
            'isolateVariables' => false,
            'returnVariableList' => [],
            'description' => NULL
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'returnVariableList' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isolateVariables'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskScript' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'formula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-script-formula'
            ],
            'isolateVariables' => (object) [
              'type' => 'bool',
              'tooltip' => true
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => 'taskReturnVariableList'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'formula',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isolateVariables'
                  ],
                  1 => (object) [
                    'name' => 'returnVariableList'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'text' => NULL,
            'isolateVariables' => false,
            'returnVariableList' => [],
            'description' => NULL,
            'formula' => NULL
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'returnVariableList' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isolateVariables'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskUser' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'name' => (object) [
              'type' => 'varchar',
              'tooltip' => 'userTaskName'
            ],
            'instructions' => (object) [
              'type' => 'text',
              'tooltip' => 'userTaskInstructions'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'actionType' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-action-type',
              'translation' => 'BpmnUserTask.options.actionType'
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-target',
              'tooltip' => true
            ],
            'assignmentType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'processAssignedUser',
                2 => 'specifiedUser',
                3 => 'rule:Round-Robin',
                4 => 'rule:Least-Busy'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-assignment-type'
            ],
            'targetUser' => (object) [
              'type' => 'link',
              'entity' => 'User'
            ],
            'targetTeam' => (object) [
              'type' => 'link',
              'entity' => 'Team'
            ],
            'targetUserPosition' => (object) [
              'type' => 'enum',
              'entity' => 'Report',
              'view' => 'advanced:views/workflow/fields/target-user-position'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'actionType'
                  ],
                  1 => (object) [
                    'name' => 'target'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'name'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'instructions'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'assignmentType'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'assignmentRule',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'targetUser'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'targetTeam'
                  ],
                  1 => (object) [
                    'name' => 'targetUserPosition'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'actionType' => 'Approve',
            'assignmentType' => 'processAssignedUser',
            'instructions' => NULL,
            'name' => NULL,
            'targetTeamId' => NULL,
            'target' => ''
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-user-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-user-edit'
        ],
        'taskSendMessage' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'Email'
              ]
            ],
            'from' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-from',
              'options' => [
                0 => 'system',
                1 => 'specifiedEmailAddress',
                2 => 'processAssignedUser'
              ]
            ],
            'to' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-to',
              'options' => [
                0 => 'processAssignedUser',
                1 => 'specifiedTeams',
                2 => 'specifiedUsers',
                3 => 'specifiedContacts',
                4 => 'specifiedEmailAddress'
              ]
            ],
            'replyTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'cc' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'fromEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageFromEmailAddress'
            ],
            'toEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'replyToEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'ccEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toSpecifiedTeams' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'Team'
            ],
            'toSpecifiedUsers' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'User'
            ],
            'toSpecifiedContacts' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'Contact'
            ],
            'emailTemplate' => (object) [
              'type' => 'link',
              'entity' => 'EmailTemplate'
            ],
            'doNotStore' => (object) [
              'type' => 'bool'
            ],
            'optOutLink' => (object) [
              'type' => 'bool'
            ],
            'attachmentsVariable' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true,
              'tooltip' => 'attachmentsVariable'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'messageType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'from'
                  ],
                  1 => (object) [
                    'name' => 'fromEmailAddress'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'to'
                  ],
                  1 => (object) [
                    'name' => 'toEmailAddress'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'toSpecifiedTeams'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'toSpecifiedUsers'
                  ],
                  1 => false
                ],
                5 => [
                  0 => (object) [
                    'name' => 'toSpecifiedContacts'
                  ],
                  1 => false
                ],
                6 => [
                  0 => (object) [
                    'name' => 'cc'
                  ],
                  1 => (object) [
                    'name' => 'ccEmailAddress'
                  ]
                ],
                7 => [
                  0 => (object) [
                    'name' => 'replyTo'
                  ],
                  1 => (object) [
                    'name' => 'replyToEmailAddress'
                  ]
                ],
                8 => [
                  0 => (object) [
                    'name' => 'emailTemplate'
                  ],
                  1 => false
                ],
                9 => [
                  0 => (object) [
                    'name' => 'doNotStore'
                  ],
                  1 => (object) [
                    'name' => 'optOutLink'
                  ]
                ],
                10 => [
                  0 => (object) [
                    'name' => 'attachmentsVariable'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-edit',
          'defaults' => (object) [
            'doNotStore' => false,
            'from' => 'system',
            'to' => 'processAssignedUser',
            'replyTo' => NULL,
            'cc' => NULL,
            'messageType' => 'Email',
            'optOutLink' => false,
            'attachmentsVariable' => NULL
          ]
        ],
        'callActivity' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'callableType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'Process'
              ],
              'required' => true
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-target',
              'tooltip' => true
            ],
            'targetIdExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnCollectionVariable' => (object) [
              'type' => 'varchar',
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ],
              'noSpellCheck' => true
            ],
            'isMultiInstance' => (object) [
              'type' => 'bool'
            ],
            'isSequential' => (object) [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchart' => (object) [
              'type' => 'link',
              'entity' => 'BpmnFlowchart',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-flowchart'
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'callableType' => 'Process',
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'callableType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'targetIdExpression'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'flowchart'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                5 => [
                  0 => (object) [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                6 => [
                  0 => (object) [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                7 => [
                  0 => (object) [
                    'name' => 'returnVariableList'
                  ],
                  1 => (object) [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'flowchart' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'returnVariableList' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'loopCollectionExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/call-activity-edit'
        ],
        'subProcess' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => (object) [
              'type' => 'varchar'
            ],
            'targetIdExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'returnCollectionVariable' => (object) [
              'type' => 'varchar',
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ],
              'noSpellCheck' => true
            ],
            'isExpanded' => (object) [
              'type' => 'bool'
            ],
            'triggeredByEvent' => (object) [
              'type' => 'bool'
            ],
            'isMultiInstance' => (object) [
              'type' => 'bool'
            ],
            'isSequential' => (object) [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchartVisualization' => (object) [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => (object) [
              'type' => 'jsonArray'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'isExpanded' => true,
            'triggeredByEvent' => false,
            'loopCollectionExpression' => NULL,
            'dataList' => [],
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => (object) [
                    'name' => 'targetType'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'targetIdExpression'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                3 => [
                  0 => (object) [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                5 => [
                  0 => (object) [
                    'name' => 'returnVariableList'
                  ],
                  1 => (object) [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'loopCollectionExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'eventSubProcess' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => (object) [
              'type' => 'varchar'
            ],
            'isExpanded' => (object) [
              'type' => 'bool'
            ],
            'triggeredByEvent' => (object) [
              'type' => 'bool'
            ],
            'flowchartVisualization' => (object) [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => (object) [
              'type' => 'jsonArray'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'isExpanded' => true,
            'triggeredByEvent' => true,
            'dataList' => [],
            'target' => ''
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => (object) [
                    'name' => 'targetType'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'flow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'startDirection' => (object) [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'r',
                2 => 'd',
                3 => 'l',
                4 => 'u'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/start-direction'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'startDirection'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ]
      ]
    ],
    'BpmnFlowchartCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'massUpdateDisabled' => true,
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#BpmnFlowchartCategory/list',
              'acl' => 'read'
            ],
            1 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.BpmnFlowchart',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#BpmnFlowchartCategory',
              'acl' => 'read'
            ],
            1 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.BpmnFlowchart',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'workflows' => (object) [
          'create' => false
        ]
      ]
    ],
    'BpmnProcess' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-process/record/detail',
        'edit' => 'advanced:views/bpmn-process/record/edit',
        'detailQuick' => 'advanced:views/bpmn-process/record/detail-quick',
        'editQuick' => 'advanced:views/bpmn-process/record/edit-quick',
        'list' => 'advanced:views/bpmn-process/record/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Flowcharts',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ],
            1 => (object) [
              'label' => 'User Tasks',
              'link' => '#BpmnUserTask',
              'acl' => 'read',
              'aclScope' => 'BpmnUserTask'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'endedAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Ended'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parentProcess' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'parentProcessId',
                  'data' => (object) [
                    'field' => 'parentProcess'
                  ]
                ]
              ]
            ]
          ],
          'flowchartVisualization' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Created'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'targetType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'flowchart' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'target' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'targetType',
                      'data' => (object) [
                        'field' => 'targetType'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'flowNodes' => (object) [
          'rowActionsView' => 'advanced:views/bpmn-flow-node/record/row-actions/default',
          'recordListView' => 'advanced:views/bpmn-flow-node/record/list',
          'select' => false,
          'create' => false,
          'unlinkDisabled' => true,
          'view' => 'advanced:views/bpmn-process/record/panels/flow-nodes'
        ],
        'userTasks' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'unlinkDisabled' => true,
          'select' => false,
          'create' => false
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => 'ended'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cogs'
    ],
    'BpmnUserTask' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-user-task/record/detail'
      ],
      'views' => (object) [
        'detail' => 'advanced:views/bpmn-user-task/detail'
      ],
      'dynamicLogic' => (object) [
        'options' => (object) [
          'resolution' => [
            0 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Approved',
                2 => 'Rejected'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Approve'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Reviewed'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Review'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Completed',
                2 => 'Failed'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Accomplish'
                ]
              ]
            ]
          ]
        ],
        'fields' => (object) [
          'resolution' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isResolved'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isCanceled'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'resolutionNote' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resolution'
                ],
                1 => (object) [
                  'type' => 'isFalse',
                  'attribute' => 'isFailed'
                ]
              ]
            ]
          ],
          'instructions' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'instructions'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'resolved',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'canceled'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-user-cog',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'Report' => (object) [
      'controller' => 'advanced:controllers/report',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'boolFilters' => [
        0 => 'onlyMy'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report/record/list',
        'detail' => 'advanced:views/report/record/detail',
        'edit' => 'advanced:views/report/record/edit'
      ],
      'views' => (object) [
        'list' => 'advanced:views/report/list',
        'result' => 'advanced:views/report/result',
        'detail' => 'advanced:views/report/detail'
      ],
      'modalViews' => (object) [
        'select' => 'advanced:views/report/modals/select-records'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ],
        'edit' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ]
      ],
      'createDisabled' => false,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Create Joint Grid Report',
              'link' => '#Report/create/type=JointGrid',
              'acl' => 'create'
            ],
            1 => (object) [
              'label' => 'Manage Categories',
              'link' => '#ReportCategory',
              'acl' => 'edit',
              'aclScope' => 'ReportCategory'
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'report',
            'label' => 'Report',
            'view' => 'advanced:views/report/record/panels/report'
          ]
        ]
      ],
      'filterList' => [
        0 => 'grid',
        1 => 'list'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'advanced:views/report/record/panels/email-sending',
            'options' => (object) [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'inlineEditDisabled' => true,
              'mode' => 'detail'
            ],
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'views/record/panels/side',
            'options' => (object) [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'mode' => 'edit'
            ],
            'isForm' => true
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'applyAcl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Grid'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-chart-bar'
    ],
    'ReportCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#ReportCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#ReportCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'reports' => (object) [
          'create' => false
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check'
    ],
    'ReportFilter' => (object) [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-filter',
      'views' => (object) [
        'list' => 'advanced:views/report-filter/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report-filter/record/list',
        'edit' => 'advanced:views/report-filter/record/edit',
        'editSmall' => 'advanced:views/report-filter/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Rebuild Filters',
              'name' => 'rebuildFilters',
              'action' => 'rebuildFilters'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'report' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'ReportPanel' => (object) [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-panel',
      'views' => (object) [
        'list' => 'advanced:views/report-panel/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report-panel/record/list',
        'edit' => 'advanced:views/report-panel/record/edit',
        'editSmall' => 'advanced:views/report-panel/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Rebuild Panels',
              'name' => 'rebuildPanels',
              'action' => 'rebuildPanels'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'report' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'Workflow' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/workflow/record/detail',
        'edit' => 'advanced:views/workflow/record/edit',
        'list' => 'advanced:views/workflow/record/list'
      ],
      'views' => (object) [
        'list' => 'advanced:views/workflow/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Workflows Log',
              'link' => '#WorkflowLogRecord'
            ],
            1 => (object) [
              'label' => 'Manage Categories',
              'link' => '#WorkflowCategory',
              'acl' => 'edit',
              'aclScope' => 'WorkflowCategory'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'type' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'signalName' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ]
          ],
          'manualLabel' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualTeams' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualDynamicLogic' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'manualAccessRequired' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualElementType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmation' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmationText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'manualConfirmation'
                ]
              ]
            ]
          ],
          'manualStyle' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'in',
                  'attribute' => 'manualElementType',
                  'value' => 'Button'
                ]
              ]
            ]
          ],
          'schedulingApplyTimezone' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ],
          'processOrder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'afterRecordCreated',
                    1 => 'afterRecordUpdated',
                    2 => 'afterRecordSaved',
                    3 => 'scheduled',
                    4 => 'signal'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'manual' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'scheduled' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-code-commit'
    ],
    'WorkflowCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#WorkflowCategory/list',
              'acl' => 'read'
            ],
            1 => (object) [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#WorkflowCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'workflows' => (object) [
          'create' => false
        ]
      ]
    ],
    'WorkflowLogRecord' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'advanced:views/workflow-log-record/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/workflow-log-record/record/list'
      ]
    ],
    'DeliveryOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrderItem',
              'link' => '#DeliveryOrderItem',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ],
        'detailCreateFromSalesOrder' => (object) [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-shipping-fast'
    ],
    'DeliveryOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct',
          'selectOrderBy' => 'createdAt',
          'selectOrderDirection' => 'asc'
        ]
      ]
    ],
    'InventoryAdjustment' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'duplicateDisabled' => true,
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            1 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustmentItem',
              'link' => '#InventoryAdjustmentItem',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustmentItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isDone'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-plus-circle'
    ],
    'InventoryAdjustmentItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ],
        'listForProduct' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'selectLayout' => 'listForProduct',
          'createHandler' => 'sales:handlers/inventory-adjustment-item/create-inventory-number'
        ]
      ]
    ],
    'InventoryNumber' => (object) [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'onHand'
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'viewHistory',
              'action' => 'viewHistory',
              'label' => 'View History',
              'data' => (object) [
                'handler' => 'sales:handlers/inventory-number/view-history-handler'
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'product' => (object) [
          'createDisabled' => true,
          'selectMandatoryAttributeList' => [
            0 => 'inventoryNumberType',
            1 => 'expirationDays'
          ],
          'selectHandler' => 'sales:handlers/inventory-number/select-product',
          'selectPrimaryFilterName' => 'available',
          'selectFieldHandler' => 'sales:handlers/inventory-number/select-field-product'
        ],
        'inventoryTransactions' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'createAttributeMap' => (object) [
            'productId' => 'productId',
            'productName' => 'productName'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listForProduct' => (object) [
          'type' => 'listSmall'
        ],
        'listForTemplateProduct' => (object) [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'dynamicLogic' => (object) [
        'panels' => (object) [
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'id',
                  'type' => 'isNotEmpty'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-barcode'
    ],
    'InventoryTransaction' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'relationshipPanels' => (object) [
        'product' => (object) [
          'selectPrimaryFilterName' => 'inventory',
          'createDisabled' => true
        ],
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/inventory-transaction/select-inventory-number'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parent' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryNumber' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Transfer',
                    1 => 'Reserve'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'inlineEditDisabled' => true,
      'massUpdateDisabled' => true,
      'convertCurrencyDisabled' => true,
      'mergeDisabled' => true,
      'layoutMassUpdateDisabled' => true,
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutSidePanelsDetailDisabled' => true,
      'layoutSidePanelsEditDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true,
      'iconClass' => 'fas fa-retweet'
    ],
    'Invoice' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'paid',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/invoice/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => (object) [
          'name' => 'eInvoice',
          'label' => 'E-Invoice',
          'handler' => 'sales:handlers/invoice/e-invoice',
          'checkVisibilityFunction' => 'isAvailable',
          'actionFunction' => 'action',
          'groupIndex' => 6
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InvoiceItem',
              'link' => '#InvoiceItem',
              'acl' => 'read',
              'aclScope' => 'InvoiceItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => (object) [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ],
                    2 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'opportunity' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Paid'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-receipt'
    ],
    'InvoiceItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Invoices',
              'link' => '#Invoice',
              'acl' => 'read',
              'aclScope' => 'Invoice'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'OpportunityItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/opportunity-item',
      'createDisabled' => true,
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Opportunities',
              'link' => '#Opportunity',
              'acl' => 'read',
              'aclScope' => 'Opportunity'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'PriceBook' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ProductPrice',
              'link' => '#ProductPrice',
              'acl' => 'read',
              'aclScope' => 'ProductPrice',
              'configCheck' => 'priceBooksEnabled'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'prices' => (object) [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'rules' => (object) [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'mergeDisabled' => true
    ],
    'PriceRule' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/price-rule',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'supplier' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ]
          ],
          'productCategory' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ]
          ],
          'conditionSelect' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'mergeDisabled' => true
    ],
    'PriceRuleCondition' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'Product' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'sales:views/product/list'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ]
      ],
      'modalViews' => (object) [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'viewPrice',
          'label' => 'View Price',
          'handler' => 'sales:handlers/product/view-price-action',
          'data' => (object) [
            'handler' => 'sales:handlers/product/view-price-action'
          ],
          'actionFunction' => 'process',
          'checkVisibilityFunction' => 'isVisible',
          'configCheck' => 'priceBooksEnabled'
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Categories',
              'link' => '#ProductCategory',
              'acl' => 'edit',
              'aclScope' => 'ProductCategory'
            ],
            1 => (object) [
              'label' => 'Brands',
              'link' => '#ProductBrand',
              'acl' => 'read',
              'aclScope' => 'ProductBrand'
            ],
            2 => (object) [
              'labelTranslation' => 'Product.links.attributes',
              'link' => '#ProductAttribute',
              'acl' => 'read',
              'aclScope' => 'ProductAttribute'
            ],
            3 => false,
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.PriceBook',
              'link' => '#PriceBook',
              'acl' => 'read',
              'aclScope' => 'PriceBook',
              'configCheck' => 'priceBooksEnabled'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            6 => false,
            7 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            8 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryNumber',
              'link' => '#InventoryNumber',
              'acl' => 'read',
              'aclScope' => 'InventoryNumber',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            9 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            10 => false,
            11 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryTransaction',
              'link' => '#InventoryTransaction',
              'acl' => 'read',
              'aclScope' => 'InventoryTransaction',
              'configCheck' => 'inventoryTransactionsEnabled'
            ]
          ]
        ]
      ],
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Product'
        ]
      ],
      'filterList' => [
        0 => 'available'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'pricingFactor' => (object) [
            'visible' => NULL
          ],
          'unitPrice' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notEquals',
                  'attribute' => 'pricingType',
                  'value' => 'Fixed'
                ]
              ]
            ]
          ],
          'inventoryNumberType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'expirationDays' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'removalStrategy' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityReserved' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnHand' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantitySoftReserved' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityInTransit' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnOrder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'type' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'inventoryNumbers' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryNumberType'
                ]
              ]
            ]
          ],
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'inventoryAdjustmentItems' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ],
                1 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Template'
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'type' => [
            0 => (object) [
              'optionList' => [
                0 => 'Regular',
                1 => 'Template'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicHandler' => 'sales:product-dynamic-handler',
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ],
          1 => (object) [
            'name' => 'orderItems',
            'label' => 'Orders',
            'view' => 'sales:views/product/record/panels/order-items',
            'recordListView' => 'sales:views/quote-item/record/list-union'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'prices' => (object) [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'createHandler' => 'sales:handlers/product/add-price',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'supplierPrices' => (object) [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryNumbers' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'onHand'
          ],
          'layout' => 'listForProduct',
          'view' => 'sales:views/product/record/panels/inventory-numbers',
          'createHandler' => 'sales:handlers/product/create-inventory-number'
        ],
        'variants' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listVariant',
          'view' => 'sales:views/product/record/panels/variants',
          'primaryFilter' => 'allVariants',
          'filterList' => [
            0 => 'allVariants',
            1 => 'availableVariants'
          ],
          'orderBy' => 'variantOrder'
        ],
        'inventoryAdjustmentItems' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'primaryFilter' => 'completed',
          'layout' => 'listForProduct',
          'orderBy' => 'createdAt',
          'orderDirection' => 'desc'
        ]
      ],
      'iconClass' => 'fas fa-cube',
      'additionalLayouts' => (object) [
        'listForAdd' => (object) [
          'type' => 'listSmall'
        ],
        'listForAddInventory' => (object) [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => (object) [
          'type' => 'listSmall'
        ],
        'listVariant' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'ProductAttribute' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'sales:views/product-attribute/record/list'
      ],
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => (object) [
        'options' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'view' => 'sales:views/product-attribute/record/panels/options',
          'recordListView' => 'sales:views/product-attribute-option/record/list-for-attribute',
          'rowActionsView' => 'sales:views/product-attribute/record/row-actions/default',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForAttribute'
        ],
        'products' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'order' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductAttributeOption' => (object) [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => (object) [
        'products' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'productVariants' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'order' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductBrand' => (object) [
      'controller' => 'controllers/record',
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL,
      'relationshipPanels' => (object) [
        'patchNotes' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cPatchNotes' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'ProductCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#ProductCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#ProductCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'ProductPrice' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/product-price',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'PriceBook'
        ]
      ]
    ],
    'PurchaseOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ],
            6 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.PurchaseOrderItem',
              'link' => '#PurchaseOrderItem',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => (object) [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/purchase-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:purchase-order-calculation-handler',
      'iconClass' => 'fas fa-cart-plus fa-flip-horizontal'
    ],
    'PurchaseOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Purchase Orders',
              'link' => '#PurchaseOrder',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'Quote' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'approved',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.QuoteItem',
              'link' => '#QuoteItem',
              'acl' => 'read',
              'aclScope' => 'QuoteItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Approved'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => (object) [
                        'field' => 'opportunity'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Approved'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => (object) [
        'salesOrders' => (object) [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/quote/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/quote/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice-dollar',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'QuoteItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Quotes',
              'link' => '#Quote',
              'acl' => 'read',
              'aclScope' => 'Quote'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReceiptOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => (object) [
          'handler' => 'sales:handlers/receipt-order/import-serial-numbers-button',
          'name' => 'importSerialNumbers',
          'label' => 'Import Serial Numbers',
          'acl' => 'edit',
          'checkVisibilityFunction' => 'isVisible'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrderItem',
              'link' => '#ReceiptOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'returnOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    2 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'supplierId',
                      'data' => (object) [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'supplierId',
                      'data' => (object) [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'supplier' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => (object) [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'purchaseOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => (object) [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'receivedItemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ],
        'detailCreateFromPurchaseOrder' => (object) [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-truck-loading'
    ],
    'ReceiptOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReturnOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrderItem',
              'link' => '#ReturnOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReturnOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => (object) [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/return-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-arrow-alt-circle-left'
    ],
    'ReturnOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrder',
              'link' => '#ReturnOrder',
              'acl' => 'read',
              'aclScope' => 'ReturnOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/return-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'SalesOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createDelivery',
              'action' => 'createDelivery',
              'label' => 'Create Delivery',
              'acl' => 'create',
              'aclScope' => 'DeliveryOrder',
              'iconHtml' => '<span class="fas fa-shipping-fast"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/sales-order/delivery-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder',
              'configCheck' => 'deliveryOrdersEnabled'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.SalesOrderItem',
              'link' => '#SalesOrderItem',
              'acl' => 'read',
              'aclScope' => 'SalesOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => (object) [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'opportunity' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'isDeliveryCreated' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => (object) [
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/sales-order/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => (object) [
          'createAction' => 'createRelatedDeliveryOrder',
          'view' => 'sales:views/sales-order/record/panels/delivery-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'returnOrders' => (object) [
          'createAction' => 'createRelatedReturnOrder',
          'view' => 'sales:views/sales-order/record/panels/return-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'SalesOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Sales Orders',
              'link' => '#SalesOrder',
              'acl' => 'read',
              'aclScope' => 'SalesOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ShippingProvider' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false
    ],
    'Supplier' => (object) [
      'controller' => 'controllers/record',
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.SupplierProductPrice',
              'link' => '#SupplierProductPrice',
              'acl' => 'read',
              'aclScope' => 'SupplierProductPrice'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'purchaseOrders' => (object) [
          'layout' => 'listForAccount',
          'unlinkDisabled' => true,
          'selectDisabled' => true
        ],
        'prices' => (object) [
          'layout' => 'listForSupplier',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ]
    ],
    'SupplierProductPrice' => (object) [
      'controller' => 'controllers/record',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Supplier'
        ]
      ]
    ],
    'Tax' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'TransferOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrderItem',
              'link' => '#TransferOrderItem',
              'acl' => 'read',
              'aclScope' => 'TransferOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-dolly fa-flip-horizontal'
    ],
    'TransferOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'Warehouse' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false,
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/warehouse/setup-record-detail'
        ]
      ],
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'products',
            'view' => 'sales:views/warehouse/record/panels/products'
          ],
          1 => (object) [
            'name' => 'inventoryNumbers',
            'view' => 'sales:views/warehouse/record/panels/inventory-numbers'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'iconClass' => 'fas fa-warehouse'
    ],
    'EblaForm' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'color' => '#55cfe0',
      'iconClass' => 'fas fa-link',
      'kanbanViewMode' => false,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'backgroundColor' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isTransparent'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Analytics' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-bar',
      'views' => (object) [
        'detail' => 'custom:views/Analytics/detail'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'appId' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'params' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'reportId' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ],
          'workspace' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'urlExterna',
                  'value' => '0'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Api' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => (object) [
        'detail' => 'custom:views/Api/detail',
        'list' => 'custom:views/Api/list'
      ],
      'iconClass' => 'fas fa-code'
    ],
    'Assessment' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-bullseye',
      'views' => (object) [
        'detail' => 'custom:views/Assessment/detail'
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'CDashboardAccess' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-magnifying-glass'
    ],
    'CImporter' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-download',
      'kanbanViewMode' => false,
      'color' => NULL,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'inputFile' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'country'
                ]
              ]
            ]
          ],
          'templateURL' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brazil'
                ]
              ]
            ]
          ],
          'templateURLmexico' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Mexico'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'CPatchNotes' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-angle-right',
      'relationshipPanels' => (object) [
        'productBrands' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CRecommendations' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-bookmark',
      'kanbanViewMode' => false,
      'color' => NULL,
      'relationshipPanels' => (object) [
        'recommendationsConfig' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'account' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CRecommendationsConfig' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'far fa-bookmark',
      'relationshipPanels' => (object) [
        'account' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'recommendations' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'CRegistration' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-user-check',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'mpnID' => (object) [
            'visible' => NULL,
            'required' => NULL
          ],
          'tenantID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'customerName' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'customerRegistered' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'customerRegisteredId',
                  'data' => (object) [
                    'field' => 'customerRegistered'
                  ]
                ]
              ]
            ]
          ],
          'resellerRegistered' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resellerRegisteredId',
                  'data' => (object) [
                    'field' => 'resellerRegistered'
                  ]
                ]
              ]
            ]
          ],
          'portalUser' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => (object) [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'contactRegistered' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'contactRegisteredId',
                  'data' => (object) [
                    'field' => 'contactRegistered'
                  ]
                ]
              ]
            ]
          ],
          'approved' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Created',
                    1 => 'Blocked',
                    2 => 'Canceled'
                  ]
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Created',
                    1 => 'Approved',
                    2 => 'Pending',
                    3 => 'Done',
                    4 => 'Canceled',
                    5 => 'Blocked'
                  ]
                ]
              ]
            ]
          ],
          'portalLink' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Pending',
                    1 => 'Done',
                    2 => 'Approved',
                    3 => 'Blocked'
                  ]
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalLink'
                ]
              ]
            ]
          ],
          'description' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'description'
                ]
              ]
            ]
          ],
          'isActive' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => (object) [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'cadastro-4customers' => (object) [
          'type' => 'detail'
        ]
      ],
      'relationshipPanels' => (object) [
        'resellerRegistered' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'customerRegistered' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'contactRegistered' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'portalUser' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CSecurityAlertSettings' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-gears',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'currentDescription' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'alerts',
                  'value' => 'currentMonth'
                ]
              ]
            ]
          ],
          'lastDescription' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'alerts',
                  'value' => 'lastMonth'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'CspUsage' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'Monitoring' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-exclamation',
      'kanbanViewMode' => true,
      'color' => NULL,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'subscriptions' => (object) [
            'visible' => NULL
          ],
          'resourceGroups' => (object) [
            'visible' => NULL
          ]
        ]
      ]
    ],
    'OrderManager' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => (object) [
        'detail' => 'custom:views/OrderManager/detail',
        'list' => 'custom:views/OrderManager/list'
      ],
      'iconClass' => 'fas fa-shopping-cart'
    ],
    'PartnerID' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'color' => NULL,
      'iconClass' => 'fas fa-barcode',
      'kanbanViewMode' => false
    ],
    'QnA' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => (object) [
        'detail' => 'custom:views/QnA/detail'
      ],
      'iconClass' => 'fas fa-question-circle'
    ],
    'Recommendation' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => true,
      'color' => NULL,
      'iconClass' => 'far fa-bell'
    ],
    'ResourceCategory' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'contacts' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => (object) [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ResourceGroup' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-check-circle',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'responsible' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => (object) [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Rocket' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => (object) [
        'list' => 'custom:views/Rocket/list'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'iconClass' => 'far fa-money-bill-alt'
    ],
    'Subscriptions' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-wind',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'responsible' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => (object) [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Tags' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'far fa-caret-square-right',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'contacts' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'monitoringId',
                  'data' => (object) [
                    'field' => 'monitoring'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Tutorial' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'views' => (object) [
        'list' => 'custom:views/Tutorial/list',
        'detail' => 'custom:views/Tutorial/detail'
      ],
      'kanbanViewMode' => false,
      'color' => '#00bbd0',
      'iconClass' => 'fas fa-book-open'
    ]
  ],
  'dashlets' => (object) [
    'Emails' => (object) [
      'view' => 'views/dashlets/emails',
      'aclScope' => 'Email',
      'entityType' => 'Email',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'folder' => (object) [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/emails/folder'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'dateSent',
          'order' => 'desc',
          'displayRecords' => 5,
          'folder' => NULL,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'subject',
                  'link' => true
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateSent',
                  'view' => 'views/fields/datetime-short'
                ],
                1 => (object) [
                  'name' => 'personStringData',
                  'view' => 'views/email/fields/person-string-data-for-expanded'
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'folder'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => (object) [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Iframe' => (object) [
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar'
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'url' => (object) [
            'type' => 'url',
            'required' => true
          ]
        ],
        'defaults' => (object) [
          'autorefreshInterval' => 0
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'url'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Memo' => (object) [
      'view' => 'views/dashlets/memo',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar'
          ],
          'text' => (object) [
            'type' => 'text'
          ]
        ],
        'defaults' => (object) [],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'text'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Records' => (object) [
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 40
          ],
          'entityType' => (object) [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/entity-type',
            'translation' => 'Global.scopeNames'
          ],
          'primaryFilter' => (object) [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/primary-filter'
          ],
          'boolFilterList' => (object) [
            'type' => 'multiEnum',
            'view' => 'views/dashlets/fields/records/bool-filter-list'
          ],
          'sortBy' => (object) [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-by'
          ],
          'sortDirection' => (object) [
            'type' => 'enum',
            'view' => 'views/dashlets/fields/records/sort-direction',
            'options' => [
              0 => 'asc',
              1 => 'desc'
            ],
            'translation' => 'DashletOptions.options.sortDirection'
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'expandedLayout' => (object) [
            'rows' => []
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'entityType'
                ],
                1 => false
              ],
              2 => [
                0 => (object) [
                  'name' => 'primaryFilter'
                ],
                1 => (object) [
                  'name' => 'sortBy'
                ]
              ],
              3 => [
                0 => (object) [
                  'name' => 'boolFilterList'
                ],
                1 => (object) [
                  'name' => 'sortDirection'
                ]
              ],
              4 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              5 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Stream' => (object) [
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'skipOwn' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'defaults' => (object) [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'skipOwn' => false
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'skipOwn'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Activities' => (object) [
      'view' => 'crm:views/dashlets/activities',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/activities',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => (object) [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'futureDays' => (object) [
            'type' => 'int',
            'min' => 0,
            'required' => true
          ],
          'includeShared' => (object) [
            'type' => 'bool'
          ]
        ],
        'defaults' => (object) [
          'displayRecords' => 10,
          'autorefreshInterval' => 0.5,
          'futureDays' => 3,
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ],
          'includeShared' => false
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'futureDays'
                ],
                1 => (object) [
                  'name' => 'includeShared'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Calendar' => (object) [
      'view' => 'crm:views/dashlets/calendar',
      'aclScope' => 'Calendar',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/calendar',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'enabledScopeList' => (object) [
            'type' => 'multiEnum',
            'translation' => 'Global.scopeNamesPlural',
            'required' => true
          ],
          'mode' => (object) [
            'type' => 'enum',
            'options' => [
              0 => 'basicWeek',
              1 => 'agendaWeek',
              2 => 'timeline',
              3 => 'month',
              4 => 'basicDay',
              5 => 'agendaDay'
            ]
          ],
          'users' => (object) [
            'type' => 'linkMultiple',
            'entity' => 'User',
            'view' => 'crm:views/calendar/fields/users',
            'sortable' => true
          ],
          'teams' => (object) [
            'type' => 'linkMultiple',
            'entity' => 'Team',
            'view' => 'crm:views/calendar/fields/teams'
          ]
        ],
        'defaults' => (object) [
          'autorefreshInterval' => 0.5,
          'mode' => 'basicWeek',
          'enabledScopeList' => [
            0 => 'Meeting',
            1 => 'Call',
            2 => 'Task'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'mode'
                ],
                1 => (object) [
                  'name' => 'enabledScopeList'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'users'
                ],
                1 => false
              ],
              3 => [
                0 => (object) [
                  'name' => 'teams'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => (object) [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Calls' => (object) [
      'view' => 'crm:views/dashlets/calls',
      'aclScope' => 'Call',
      'entityType' => 'Call',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateStart'
                ],
                1 => (object) [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => (object) [
              1 => (object) [
                'type' => 'or',
                'value' => (object) [
                  1 => (object) [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => (object) [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ],
                  3 => (object) [
                    'type' => 'lastXDays',
                    'field' => 'dateStart',
                    'value' => 5,
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => (object) [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Cases' => (object) [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Case',
      'entityType' => 'Case',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'number',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'number'
                ],
                1 => (object) [
                  'name' => 'name',
                  'link' => true
                ],
                2 => (object) [
                  'name' => 'type'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'status'
                ],
                1 => (object) [
                  'name' => 'priority'
                ],
                2 => (object) [
                  'name' => 'account'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Leads' => (object) [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Lead',
      'entityType' => 'Lead',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ],
                1 => (object) [
                  'name' => 'addressCity'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'status'
                ],
                1 => (object) [
                  'name' => 'source'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Meetings' => (object) [
      'view' => 'crm:views/dashlets/meetings',
      'aclScope' => 'Meeting',
      'entityType' => 'Meeting',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'dateStart',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateStart'
                ],
                1 => (object) [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'planned',
            'advanced' => (object) [
              1 => (object) [
                'type' => 'or',
                'value' => (object) [
                  1 => (object) [
                    'type' => 'today',
                    'field' => 'dateStart',
                    'dateTime' => true
                  ],
                  2 => (object) [
                    'type' => 'future',
                    'field' => 'dateEnd',
                    'dateTime' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => (object) [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'Opportunities' => (object) [
      'view' => 'views/dashlets/abstract/record-list',
      'aclScope' => 'Opportunity',
      'entityType' => 'Opportunity',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'closeDate',
          'order' => 'asc',
          'displayRecords' => 5,
          'populateAssignedUser' => true,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'stage'
                ],
                1 => (object) [
                  'name' => 'amount'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'open'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'OpportunitiesByLeadSource' => (object) [
      'view' => 'crm:views/dashlets/opportunities-by-lead-source',
      'aclScope' => 'Opportunity',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => (object) [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => (object) [
                  'name' => 'dateFrom'
                ],
                1 => (object) [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => (object) [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'OpportunitiesByStage' => (object) [
      'view' => 'crm:views/dashlets/opportunities-by-stage',
      'aclScope' => 'Opportunity',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => (object) [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => (object) [
                  'name' => 'dateFrom'
                ],
                1 => (object) [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => (object) [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesByMonth' => (object) [
      'view' => 'crm:views/dashlets/sales-by-month',
      'aclScope' => 'Opportunity',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/chart',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => (object) [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentFiscalYear',
              3 => 'currentFiscalQuarter',
              4 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateFilter'
                ],
                1 => false
              ],
              2 => [
                0 => (object) [
                  'name' => 'dateFrom'
                ],
                1 => (object) [
                  'name' => 'dateTo'
                ]
              ]
            ]
          ]
        ],
        'defaults' => (object) [
          'dateFilter' => 'currentYear'
        ]
      ]
    ],
    'SalesPipeline' => (object) [
      'view' => 'crm:views/dashlets/sales-pipeline',
      'aclScope' => 'Opportunity',
      'options' => (object) [
        'view' => 'crm:views/dashlets/options/sales-pipeline',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'dateFrom' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateTo' => (object) [
            'type' => 'date',
            'required' => true
          ],
          'dateFilter' => (object) [
            'type' => 'enum',
            'options' => [
              0 => 'currentYear',
              1 => 'currentQuarter',
              2 => 'currentMonth',
              3 => 'currentFiscalYear',
              4 => 'currentFiscalQuarter',
              5 => 'ever',
              6 => 'between'
            ],
            'default' => 'currentYear',
            'translation' => 'Global.options.dateSearchRanges'
          ],
          'useLastStage' => (object) [
            'type' => 'bool'
          ],
          'team' => (object) [
            'type' => 'link',
            'entity' => 'Team',
            'view' => 'crm:views/dashlets/options/sales-pipeline/fields/team'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title',
                  'span' => 2
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'dateFilter'
                ],
                1 => (object) [
                  'name' => 'useLastStage'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'dateFrom'
                ],
                1 => (object) [
                  'name' => 'dateTo'
                ]
              ],
              3 => [
                0 => (object) [
                  'name' => 'team'
                ],
                1 => false
              ]
            ]
          ]
        ],
        'defaults' => (object) [
          'dateFilter' => 'currentYear',
          'teamId' => NULL,
          'teamName' => NULL
        ]
      ]
    ],
    'Tasks' => (object) [
      'view' => 'crm:views/dashlets/tasks',
      'aclScope' => 'Task',
      'entityType' => 'Task',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'int',
            'min' => 1,
            'max' => 20
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'dateUpcoming',
          'order' => 'asc',
          'displayRecords' => 5,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'status'
                ],
                1 => (object) [
                  'name' => 'dateEnd'
                ],
                2 => (object) [
                  'name' => 'parent'
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'actualStartingNotInFuture'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout',
                  'fullWidth' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'accessDataList' => [
        0 => (object) [
          'inPortalDisabled' => true
        ]
      ]
    ],
    'BpmnUserTasks' => (object) [
      'view' => 'advanced:views/dashlets/bpmn-user-tasks',
      'aclScope' => 'BpmnUserTask',
      'entityType' => 'BpmnUserTask',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ],
          'displayRecords' => (object) [
            'type' => 'enumInt',
            'options' => [
              0 => 3,
              1 => 4,
              2 => 5,
              3 => 10,
              4 => 15,
              5 => 20,
              6 => 30
            ]
          ],
          'expandedLayout' => (object) [
            'type' => 'base',
            'view' => 'views/dashlets/fields/records/expanded-layout'
          ]
        ],
        'defaults' => (object) [
          'orderBy' => 'createdAt',
          'order' => 'desc',
          'displayRecords' => 5,
          'expandedLayout' => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'name',
                  'link' => true
                ]
              ]
            ]
          ],
          'searchData' => (object) [
            'bool' => (object) [
              'onlyMy' => true
            ],
            'primary' => 'actual'
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'displayRecords'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'expandedLayout'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Report' => (object) [
      'view' => 'advanced:views/dashlets/report',
      'aclScope' => 'Report',
      'options' => (object) [
        'view' => 'advanced:views/dashlets/options/report',
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar'
          ],
          'report' => (object) [
            'type' => 'link',
            'entity' => 'Report',
            'required' => true,
            'view' => 'advanced:views/report/fields/dashlet-select'
          ],
          'column' => (object) [
            'type' => 'enum',
            'options' => []
          ],
          'displayType' => (object) [
            'type' => 'enum',
            'default' => '',
            'options' => [
              0 => '',
              1 => 'Chart',
              2 => 'List',
              3 => 'Chart-Total',
              4 => 'Total',
              5 => 'Table'
            ],
            'translation' => 'Report.options.dashletDisplayType',
            'view' => 'advanced:views/dashlets/fields/display-type'
          ],
          'useSiMultiplier' => (object) [
            'type' => 'bool'
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'defaults' => (object) [
          'autorefreshInterval' => 0,
          'useSiMultiplier' => true,
          'displayType' => ''
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ],
              1 => [
                0 => (object) [
                  'name' => 'report'
                ],
                1 => (object) [
                  'name' => 'column'
                ]
              ],
              2 => [
                0 => (object) [
                  'name' => 'autorefreshInterval'
                ],
                1 => false
              ],
              3 => [
                0 => (object) [
                  'name' => 'displayType'
                ],
                1 => false
              ],
              4 => [
                0 => (object) [
                  'name' => 'useSiMultiplier'
                ],
                1 => false
              ]
            ]
          ]
        ]
      ]
    ],
    'Rocket' => (object) [
      'view' => 'custom:views/Rocket/detail',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientID' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'ClientSecret' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'autorefreshInterval' => (object) [
            'type' => 'enumFloat',
            'options' => [
              0 => 0,
              1 => 0.5,
              2 => 1,
              3 => 2,
              4 => 5,
              5 => 10
            ]
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ],
                1 => (object) [
                  'name' => 'autorefreshInterval'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'bluesky' => (object) [
      'view' => 'custom:views/dashlets/bluesky',
      'aclScope' => 'Account',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'blueskydataanalytics' => (object) [
      'view' => 'custom:views/dashlets/blueskydataanalytics',
      'aclScope' => 'Account',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'home-4customers' => (object) [
      'view' => 'custom:views/dashlets/home-4customers',
      'aclScope' => 'Account',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'reports' => (object) [
      'view' => 'custom:views/dashlets/reports',
      'aclScope' => 'Account',
      'options' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'altura' => (object) [
            'type' => 'varchar',
            'required' => true
          ],
          'url' => (object) [
            'type' => 'varchar',
            'required' => false
          ]
        ],
        'layout' => [
          0 => (object) [
            'rows' => [
              0 => [
                0 => (object) [
                  'name' => 'title'
                ],
                1 => (object) [
                  'name' => 'altura'
                ],
                2 => (object) [
                  'name' => 'url'
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'entityAcl' => (object) [
    'AppSecret' => (object) [
      'fields' => (object) [
        'value' => (object) [
          'internal' => true
        ]
      ]
    ],
    'Attachment' => (object) [
      'fields' => (object) [
        'storage' => (object) [
          'readOnly' => true
        ],
        'source' => (object) [
          'readOnly' => true
        ],
        'sourceId' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'AuthLogRecord' => (object) [
      'fields' => (object) [
        'username' => (object) [
          'readOnly' => true
        ],
        'portal' => (object) [
          'readOnly' => true
        ],
        'user' => (object) [
          'readOnly' => true
        ],
        'ipAddress' => (object) [
          'readOnly' => true
        ],
        'authToken' => (object) [
          'readOnly' => true
        ],
        'isDenied' => (object) [
          'readOnly' => true
        ],
        'denialReason' => (object) [
          'readOnly' => true
        ],
        'microtime' => (object) [
          'readOnly' => true
        ],
        'requestUrl' => (object) [
          'readOnly' => true
        ],
        'requestMethod' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'AuthToken' => (object) [
      'fields' => (object) [
        'hash' => (object) [
          'forbidden' => true,
          'readOnly' => true
        ],
        'token' => (object) [
          'forbidden' => true,
          'readOnly' => true
        ],
        'secret' => (object) [
          'forbidden' => true,
          'readOnly' => true
        ],
        'portal' => (object) [
          'readOnly' => true
        ],
        'user' => (object) [
          'readOnly' => true
        ],
        'ipAddress' => (object) [
          'readOnly' => true
        ],
        'lastAccess' => (object) [
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Email' => (object) [
      'fields' => (object) [
        'users' => (object) [
          'readOnly' => true
        ],
        'messageId' => (object) [
          'readOnly' => true
        ],
        'tasks' => (object) [
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'users' => (object) [
          'nonAdminReadOnly' => true
        ],
        'tasks' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'EmailAccount' => (object) [
      'fields' => (object) [
        'password' => (object) [
          'internal' => true
        ],
        'smtpPassword' => (object) [
          'internal' => true
        ],
        'imapHandler' => (object) [
          'forbidden' => true
        ],
        'smtpHandler' => (object) [
          'forbidden' => true
        ],
        'fetchData' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'InboundEmail' => (object) [
      'fields' => (object) [
        'password' => (object) [
          'internal' => true
        ],
        'smtpPassword' => (object) [
          'internal' => true
        ],
        'imapHandler' => (object) [
          'internal' => true
        ],
        'smtpHandler' => (object) [
          'internal' => true
        ],
        'fetchData' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Note' => (object) [
      'links' => (object) [
        'teams' => (object) [
          'readOnly' => true
        ],
        'users' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Preferences' => (object) [
      'fields' => (object) [
        'data' => (object) [
          'forbidden' => true
        ]
      ]
    ],
    'User' => (object) [
      'fields' => (object) [
        'userName' => (object) [
          'nonAdminReadOnly' => true
        ],
        'apiKey' => (object) [
          'onlyAdmin' => true,
          'readOnly' => true,
          'nonAdminReadOnly' => true
        ],
        'password' => (object) [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'passwordConfirm' => (object) [
          'internal' => true,
          'nonAdminReadOnly' => true
        ],
        'authLogRecordId' => (object) [
          'forbidden' => true
        ],
        'authMethod' => (object) [
          'onlyAdmin' => true
        ],
        'secretKey' => (object) [
          'readOnly' => true,
          'onlyAdmin' => true
        ],
        'isActive' => (object) [
          'nonAdminReadOnly' => true
        ],
        'emailAddress' => (object) [
          'nonAdminReadOnly' => true
        ],
        'teams' => (object) [
          'nonAdminReadOnly' => true
        ],
        'defaultTeam' => (object) [
          'nonAdminReadOnly' => true
        ],
        'roles' => (object) [
          'nonAdminReadOnly' => true
        ],
        'portals' => (object) [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => (object) [
          'nonAdminReadOnly' => true
        ],
        'contact' => (object) [
          'nonAdminReadOnly' => true
        ],
        'workingTimeCalendar' => (object) [
          'nonAdminReadOnly' => true
        ],
        'layoutSet' => (object) [
          'onlyAdmin' => true
        ],
        'accounts' => (object) [
          'nonAdminReadOnly' => true
        ],
        'type' => (object) [
          'nonAdminReadOnly' => true
        ],
        'auth2FA' => (object) [
          'onlyAdmin' => true
        ],
        'userData' => (object) [
          'forbidden' => true
        ],
        'deleteId' => (object) [
          'forbidden' => true
        ]
      ],
      'links' => (object) [
        'teams' => (object) [
          'nonAdminReadOnly' => true
        ],
        'roles' => (object) [
          'onlyAdmin' => true
        ],
        'workingTimeRanges' => (object) [
          'nonAdminReadOnly' => true
        ],
        'portalRoles' => (object) [
          'onlyAdmin' => true
        ],
        'accounts' => (object) [
          'onlyAdmin' => true
        ],
        'defaultTeam' => (object) [
          'onlyAdmin' => true
        ],
        'dashboardTemplate' => (object) [
          'onlyAdmin' => true
        ],
        'userData' => (object) [
          'forbidden' => true
        ]
      ]
    ],
    'Webhook' => (object) [
      'fields' => (object) [
        'user' => (object) [
          'onlyAdmin' => true
        ],
        'secretKey' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Case' => (object) [
      'fields' => (object) [
        'inboundEmail' => (object) [
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'inboundEmail' => (object) [
          'readOnly' => true
        ],
        'collaborators' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Contact' => (object) [
      'fields' => (object) [
        'inboundEmail' => (object) [
          'readOnly' => true
        ],
        'portalUser' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'KnowledgeBaseArticle' => (object) [
      'fields' => (object) [
        'order' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Task' => (object) [
      'fields' => (object) [
        'email' => (object) [
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'collaborators' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnFlowchart' => (object) [
      'fields' => (object) [
        'elementsDataHash' => (object) [
          'readOnly' => true
        ],
        'eventStartIdList' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'BpmnProcess' => (object) [
      'fields' => (object) [
        'flowchartElementsDataHash' => (object) [
          'readOnly' => true
        ],
        'workflowId' => (object) [
          'readOnly' => true
        ],
        'parentProcess' => (object) [
          'readOnly' => true
        ],
        'flowchartData' => (object) [
          'readOnly' => true
        ],
        'createdEntitiesData' => (object) [
          'readOnly' => true
        ],
        'variables' => (object) [
          'readOnly' => true
        ],
        'endedAt' => (object) [
          'readOnly' => true
        ],
        'status' => (object) [
          'readOnly' => true
        ],
        'parentProcessFlowNode' => (object) [
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'parentProcess' => (object) [
          'readOnly' => true
        ],
        'childProcesses' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Report' => (object) [
      'fields' => (object) [
        'internalClassName' => (object) [
          'internal' => true
        ]
      ],
      'links' => (object) [
        'portals' => (object) [
          'internal' => true
        ]
      ]
    ],
    'Workflow' => (object) [
      'fields' => (object) [
        'isInternal' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'DeliveryOrder' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryAdjustment' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'InventoryNumber' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Invoice' => (object) [
      'links' => (object) [
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Product' => (object) [
      'links' => (object) [
        'prices' => (object) [
          'readOnly' => true
        ],
        'supplierPrices' => (object) [
          'readOnly' => true
        ],
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'attributes' => (object) [
          'readOnly' => true
        ],
        'attributeOptions' => (object) [
          'readOnly' => true
        ],
        'variantAttributeOptions' => (object) [
          'readOnly' => true
        ],
        'variants' => (object) [
          'readOnly' => true
        ],
        'inventoryAdjustmentItems' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttribute' => (object) [
      'links' => (object) [
        'products' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'ProductAttributeOption' => (object) [
      'links' => (object) [
        'products' => (object) [
          'readOnly' => true
        ],
        'productVariants' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'PurchaseOrder' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'receiptOrders' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Quote' => (object) [
      'links' => (object) [
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'ReceiptOrder' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ],
        'receivedItems' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'ReturnOrder' => (object) [
      'links' => (object) [
        'receiptOrders' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'SalesOrder' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'deliveryOrders' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'TransferOrder' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ],
        'items' => (object) [
          'readOnly' => true
        ]
      ]
    ],
    'Warehouse' => (object) [
      'links' => (object) [
        'inventoryTransactions' => (object) [
          'readOnly' => true
        ]
      ]
    ]
  ],
  'entityDefs' => (object) [
    'ActionHistoryRecord' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'index' => true,
          'dbType' => 'bigint'
        ],
        'targetType' => (object) [
          'type' => 'varchar',
          'view' => 'views/action-history-record/fields/target-type',
          'translation' => 'Global.scopeNames'
        ],
        'target' => (object) [
          'type' => 'linkParent',
          'view' => 'views/action-history-record/fields/target'
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'action' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'read',
            1 => 'update',
            2 => 'create',
            3 => 'delete'
          ]
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'user' => (object) [
          'type' => 'link',
          'view' => 'views/fields/user'
        ],
        'userType' => (object) [
          'type' => 'foreign',
          'link' => 'user',
          'field' => 'type',
          'view' => 'views/fields/foreign-enum',
          'notStorable' => true
        ],
        'ipAddress' => (object) [
          'type' => 'varchar',
          'maxLength' => 39
        ],
        'authToken' => (object) [
          'type' => 'link'
        ],
        'authLogRecord' => (object) [
          'type' => 'link'
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'target' => (object) [
          'type' => 'belongsToParent'
        ],
        'authToken' => (object) [
          'type' => 'belongsTo',
          'entity' => 'AuthToken',
          'foreignName' => 'id',
          'foreign' => 'actionHistoryRecords'
        ],
        'authLogRecord' => (object) [
          'type' => 'belongsTo',
          'entity' => 'AuthLogRecord',
          'foreignName' => 'id',
          'foreign' => 'actionHistoryRecords'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'userName'
        ],
        'countDisabled' => true,
        'sortBy' => 'number',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'AddressCountry' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'code' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 2,
          'tooltip' => true,
          'pattern' => '[A-Z]{2}',
          'sanitizerClassNameList' => [
            0 => 'Espo\\Classes\\FieldSanitizers\\StringUpperCase'
          ],
          'options' => [
            0 => 'AF',
            1 => 'AX',
            2 => 'AL',
            3 => 'DZ',
            4 => 'AS',
            5 => 'AD',
            6 => 'AO',
            7 => 'AI',
            8 => 'AQ',
            9 => 'AG',
            10 => 'AR',
            11 => 'AM',
            12 => 'AW',
            13 => 'AU',
            14 => 'AT',
            15 => 'AZ',
            16 => 'BS',
            17 => 'BH',
            18 => 'BD',
            19 => 'BB',
            20 => 'BY',
            21 => 'BE',
            22 => 'BZ',
            23 => 'BJ',
            24 => 'BM',
            25 => 'BT',
            26 => 'BO',
            27 => 'BA',
            28 => 'BW',
            29 => 'BV',
            30 => 'BR',
            31 => 'IO',
            32 => 'BN',
            33 => 'BG',
            34 => 'BF',
            35 => 'BI',
            36 => 'KH',
            37 => 'CM',
            38 => 'CA',
            39 => 'CV',
            40 => 'KY',
            41 => 'CF',
            42 => 'TD',
            43 => 'CL',
            44 => 'CN',
            45 => 'CX',
            46 => 'CC',
            47 => 'CO',
            48 => 'KM',
            49 => 'CG',
            50 => 'CD',
            51 => 'CK',
            52 => 'CR',
            53 => 'CI',
            54 => 'HR',
            55 => 'CU',
            56 => 'CY',
            57 => 'CZ',
            58 => 'DK',
            59 => 'DJ',
            60 => 'DM',
            61 => 'DO',
            62 => 'EC',
            63 => 'EG',
            64 => 'SV',
            65 => 'GQ',
            66 => 'ER',
            67 => 'EE',
            68 => 'ET',
            69 => 'FK',
            70 => 'FO',
            71 => 'FJ',
            72 => 'FI',
            73 => 'FR',
            74 => 'GF',
            75 => 'PF',
            76 => 'TF',
            77 => 'GA',
            78 => 'GM',
            79 => 'GE',
            80 => 'DE',
            81 => 'GH',
            82 => 'GI',
            83 => 'GR',
            84 => 'GL',
            85 => 'GD',
            86 => 'GP',
            87 => 'GU',
            88 => 'GT',
            89 => 'GG',
            90 => 'GN',
            91 => 'GW',
            92 => 'GY',
            93 => 'HT',
            94 => 'HM',
            95 => 'VA',
            96 => 'HN',
            97 => 'HK',
            98 => 'HU',
            99 => 'IS',
            100 => 'IN',
            101 => 'ID',
            102 => 'IR',
            103 => 'IQ',
            104 => 'IE',
            105 => 'IM',
            106 => 'IL',
            107 => 'IT',
            108 => 'JM',
            109 => 'JP',
            110 => 'JE',
            111 => 'JO',
            112 => 'KZ',
            113 => 'KE',
            114 => 'KI',
            115 => 'KR',
            116 => 'KW',
            117 => 'KG',
            118 => 'LA',
            119 => 'LV',
            120 => 'LB',
            121 => 'LS',
            122 => 'LR',
            123 => 'LY',
            124 => 'LI',
            125 => 'LT',
            126 => 'LU',
            127 => 'MO',
            128 => 'MK',
            129 => 'MG',
            130 => 'MW',
            131 => 'MY',
            132 => 'MV',
            133 => 'ML',
            134 => 'MT',
            135 => 'MH',
            136 => 'MQ',
            137 => 'MR',
            138 => 'MU',
            139 => 'YT',
            140 => 'MX',
            141 => 'FM',
            142 => 'MD',
            143 => 'MC',
            144 => 'MN',
            145 => 'ME',
            146 => 'MS',
            147 => 'MA',
            148 => 'MZ',
            149 => 'MM',
            150 => 'NA',
            151 => 'NR',
            152 => 'NP',
            153 => 'NL',
            154 => 'AN',
            155 => 'NC',
            156 => 'NZ',
            157 => 'NI',
            158 => 'NE',
            159 => 'NG',
            160 => 'NU',
            161 => 'NF',
            162 => 'MP',
            163 => 'NO',
            164 => 'OM',
            165 => 'PK',
            166 => 'PW',
            167 => 'PS',
            168 => 'PA',
            169 => 'PG',
            170 => 'PY',
            171 => 'PE',
            172 => 'PH',
            173 => 'PN',
            174 => 'PL',
            175 => 'PT',
            176 => 'PR',
            177 => 'QA',
            178 => 'RE',
            179 => 'RO',
            180 => 'RU',
            181 => 'RW',
            182 => 'BL',
            183 => 'SH',
            184 => 'KN',
            185 => 'LC',
            186 => 'MF',
            187 => 'PM',
            188 => 'VC',
            189 => 'WS',
            190 => 'SM',
            191 => 'ST',
            192 => 'SA',
            193 => 'SN',
            194 => 'RS',
            195 => 'SC',
            196 => 'SL',
            197 => 'SG',
            198 => 'SK',
            199 => 'SI',
            200 => 'SB',
            201 => 'SO',
            202 => 'ZA',
            203 => 'GS',
            204 => 'ES',
            205 => 'LK',
            206 => 'SD',
            207 => 'SR',
            208 => 'SJ',
            209 => 'SZ',
            210 => 'SE',
            211 => 'CH',
            212 => 'SY',
            213 => 'TW',
            214 => 'TJ',
            215 => 'TZ',
            216 => 'TH',
            217 => 'TL',
            218 => 'TG',
            219 => 'TK',
            220 => 'TO',
            221 => 'TT',
            222 => 'TN',
            223 => 'TR',
            224 => 'TM',
            225 => 'TC',
            226 => 'TV',
            227 => 'UG',
            228 => 'UA',
            229 => 'AE',
            230 => 'GB',
            231 => 'US',
            232 => 'UM',
            233 => 'UY',
            234 => 'UZ',
            235 => 'VU',
            236 => 'VE',
            237 => 'VN',
            238 => 'VG',
            239 => 'VI',
            240 => 'WF',
            241 => 'EH',
            242 => 'YE',
            243 => 'ZM',
            244 => 'ZW'
          ]
        ],
        'isPreferred' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'preferredName' => (object) [
          'type' => 'base',
          'notStorable' => true,
          'utility' => true
        ]
      ],
      'links' => (object) [],
      'collection' => (object) [
        'orderBy' => 'preferredName',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'code'
        ],
        'sortBy' => 'preferredName',
        'asc' => true
      ],
      'indexes' => (object) [
        'name' => (object) [
          'unique' => true,
          'columns' => [
            0 => 'name'
          ]
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'AppLogRecord' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'message' => (object) [
          'type' => 'text',
          'readOnly' => true,
          'orderDisabled' => true
        ],
        'level' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Debug',
            1 => 'Info',
            2 => 'Notice',
            3 => 'Warning',
            4 => 'Error',
            5 => 'Critical',
            6 => 'Alert',
            7 => 'Emergency'
          ],
          'style' => (object) [
            'Info' => 'info',
            'Notice' => 'primary',
            'Warning' => 'warning',
            'Error' => 'danger',
            'Critical' => 'danger',
            'Alert' => 'danger',
            'Emergency' => 'danger'
          ],
          'maxLength' => 9,
          'readOnly' => true,
          'index' => true
        ],
        'code' => (object) [
          'type' => 'int',
          'readOnly' => true
        ],
        'exceptionClass' => (object) [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ],
        'file' => (object) [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ],
        'line' => (object) [
          'type' => 'int',
          'readOnly' => true
        ],
        'requestMethod' => (object) [
          'type' => 'enum',
          'maxLength' => 7,
          'options' => [
            0 => 'GET',
            1 => 'POST',
            2 => 'PUT',
            3 => 'UPDATE',
            4 => 'DELETE',
            5 => 'PATCH',
            6 => 'HEAD',
            7 => 'OPTIONS',
            8 => 'TRACE'
          ],
          'readOnly' => true
        ],
        'requestResourcePath' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'readOnly' => true
        ],
        'requestUrl' => (object) [
          'type' => 'varchar',
          'maxLength' => 512,
          'readOnly' => true
        ]
      ],
      'links' => (object) [],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'message'
        ],
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => (object) [],
      'hooksDisabled' => true
    ],
    'AppSecret' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true,
          'pattern' => '[a-zA-Z]{1}[a-zA-Z0-9_]+',
          'index' => true,
          'tooltip' => true
        ],
        'value' => (object) [
          'type' => 'text',
          'required' => true,
          'view' => 'views/admin/app-secret/fields/value'
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'deleteId' => (object) [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true,
          'notNull' => true,
          'default' => '0',
          'utility' => true,
          'customizationDisabled' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name'
        ],
        'sortBy' => 'name',
        'asc' => true
      ],
      'indexes' => (object) [
        'nameDeleteId' => (object) [
          'type' => 'unique',
          'columns' => [
            0 => 'name',
            1 => 'deleteId'
          ]
        ]
      ],
      'deleteId' => true
    ],
    'ArrayValue' => (object) [
      'fields' => (object) [
        'value' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'entity' => (object) [
          'type' => 'linkParent'
        ],
        'attribute' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ]
      ],
      'indexes' => (object) [
        'entityTypeValue' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'value'
          ]
        ],
        'entityValue' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'entityId',
            2 => 'value'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'Attachment' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/attachment/fields/name',
          'maxLength' => 255
        ],
        'type' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'size' => (object) [
          'type' => 'int',
          'dbType' => 'bigint',
          'min' => 0
        ],
        'parent' => (object) [
          'type' => 'linkParent',
          'view' => 'views/attachment/fields/parent'
        ],
        'related' => (object) [
          'type' => 'linkParent',
          'noLoad' => true,
          'view' => 'views/attachment/fields/parent',
          'validatorClassName' => 'Espo\\Classes\\FieldValidators\\Attachment\\Related'
        ],
        'source' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'utility' => true
        ],
        'field' => (object) [
          'type' => 'varchar',
          'utility' => true
        ],
        'isBeingUploaded' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'contents' => (object) [
          'type' => 'text',
          'notStorable' => true,
          'sanitizerClassNameList' => [],
          'sanitizerSuppressClassNameList' => [
            0 => 'Espo\\Classes\\FieldSanitizers\\EmptyStringToNull'
          ]
        ],
        'role' => (object) [
          'type' => 'enum',
          'maxLength' => 36,
          'options' => [
            0 => 'Attachment',
            1 => 'Inline Attachment',
            2 => 'Import File',
            3 => 'Export File',
            4 => 'Mail Merge',
            5 => 'Mass Pdf'
          ]
        ],
        'storage' => (object) [
          'type' => 'varchar',
          'maxLength' => 24,
          'default' => NULL
        ],
        'storageFilePath' => (object) [
          'type' => 'varchar',
          'maxLength' => 260,
          'default' => NULL
        ],
        'global' => (object) [
          'type' => 'bool',
          'default' => false
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'foreign' => 'attachments'
        ],
        'related' => (object) [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => (object) [
        'parent' => (object) [
          'columns' => [
            0 => 'parentType',
            1 => 'parentId'
          ]
        ]
      ],
      'sourceList' => [
        0 => 'Document'
      ]
    ],
    'AuthLogRecord' => (object) [
      'fields' => (object) [
        'username' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'maxLength' => 100
        ],
        'portal' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'user' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'authToken' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'ipAddress' => (object) [
          'type' => 'varchar',
          'maxLength' => 45,
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'isDenied' => (object) [
          'type' => 'bool',
          'readOnly' => true
        ],
        'denialReason' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'CREDENTIALS',
            2 => 'INACTIVE_USER',
            3 => 'IS_PORTAL_USER',
            4 => 'IS_NOT_PORTAL_USER',
            5 => 'USER_IS_NOT_IN_PORTAL',
            6 => 'IS_SYSTEM_USER',
            7 => 'FORBIDDEN'
          ],
          'readOnly' => true
        ],
        'requestTime' => (object) [
          'type' => 'float',
          'readOnly' => true
        ],
        'requestUrl' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'requestMethod' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'maxLength' => 15
        ],
        'authTokenIsActive' => (object) [
          'type' => 'foreign',
          'link' => 'authToken',
          'field' => 'isActive',
          'readOnly' => true,
          'view' => 'views/fields/foreign-bool'
        ],
        'authenticationMethod' => (object) [
          'type' => 'enum',
          'view' => 'views/admin/auth-log-record/fields/authentication-method',
          'translation' => 'Settings.options.authenticationMethod'
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'portal' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Portal'
        ],
        'authToken' => (object) [
          'type' => 'belongsTo',
          'entity' => 'AuthToken',
          'foreignName' => 'id'
        ],
        'actionHistoryRecords' => (object) [
          'type' => 'hasMany',
          'entity' => 'ActionHistoryRecord',
          'foreign' => 'authLogRecord'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'requestTime',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'username'
        ],
        'sortBy' => 'requestTime',
        'asc' => false
      ],
      'indexes' => (object) [
        'ipAddress' => (object) [
          'columns' => [
            0 => 'ipAddress'
          ]
        ],
        'ipAddressRequestTime' => (object) [
          'columns' => [
            0 => 'ipAddress',
            1 => 'requestTime'
          ]
        ],
        'requestTime' => (object) [
          'columns' => [
            0 => 'requestTime'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'AuthToken' => (object) [
      'fields' => (object) [
        'token' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'index' => true,
          'readOnly' => true
        ],
        'hash' => (object) [
          'type' => 'varchar',
          'maxLength' => 150,
          'index' => true,
          'readOnly' => true
        ],
        'secret' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'readOnly' => true
        ],
        'user' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'portal' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'ipAddress' => (object) [
          'type' => 'varchar',
          'maxLength' => 45,
          'readOnly' => true
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'lastAccess' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'portal' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Portal'
        ],
        'actionHistoryRecords' => (object) [
          'type' => 'hasMany',
          'entity' => 'ActionHistoryRecord',
          'foreign' => 'authToken'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'lastAccess',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'ipAddress',
          1 => 'userName'
        ],
        'sortBy' => 'lastAccess',
        'asc' => false
      ],
      'indexes' => (object) [
        'token' => (object) [
          'columns' => [
            0 => 'token',
            1 => 'deleted'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'AuthenticationProvider' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'method' => (object) [
          'type' => 'enum',
          'view' => 'views/authentication-provider/fields/method',
          'translation' => 'Settings.options.authenticationMethod',
          'required' => true,
          'validatorClassNameMap' => (object) [
            'valid' => 'Espo\\Classes\\FieldValidators\\AuthenticationProvider\\MethodValid'
          ]
        ],
        'oidcAuthorizationRedirectUri' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true
        ],
        'oidcClientId' => (object) [
          'type' => 'varchar'
        ],
        'oidcClientSecret' => (object) [
          'type' => 'password'
        ],
        'oidcAuthorizationEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcTokenEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwksEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwtSignatureAlgorithmList' => (object) [
          'type' => 'multiEnum',
          'optionsPath' => 'entityDefs.Settings.fields.oidcJwtSignatureAlgorithmList.options',
          'default' => [
            0 => 'RS256'
          ]
        ],
        'oidcScopes' => (object) [
          'type' => 'multiEnum',
          'allowCustomOptions' => true,
          'optionsPath' => 'entityDefs.Settings.fields.oidcScopes.options',
          'default' => [
            0 => 'profile',
            1 => 'email',
            2 => 'phone'
          ]
        ],
        'oidcCreateUser' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcUsernameClaim' => (object) [
          'type' => 'varchar',
          'optionsPath' => 'entityDefs.Settings.fields.oidcUsernameClaim.options',
          'tooltip' => true,
          'default' => 'sub'
        ],
        'oidcSync' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcLogoutUrl' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcAuthorizationPrompt' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'none',
            1 => 'consent',
            2 => 'login',
            3 => 'select_account'
          ],
          'maxLength' => 14
        ]
      ]
    ],
    'Autofollow' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'integer',
          'autoincrement' => true
        ],
        'entityType' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'index' => true
        ],
        'user' => (object) [
          'type' => 'link'
        ]
      ]
    ],
    'Currency' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'maxLength' => 3,
          'dbType' => 'string'
        ],
        'rate' => (object) [
          'type' => 'float'
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'DashboardTemplate' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'layout' => (object) [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout',
          'inlineEditDisabled' => true,
          'required' => true
        ],
        'dashletsOptions' => (object) [
          'type' => 'jsonObject',
          'disabled' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Email' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'subject' => (object) [
          'type' => 'varchar',
          'required' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/subject',
          'utility' => true
        ],
        'fromName' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'fromAddress' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'fromString' => (object) [
          'type' => 'varchar',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'replyToString' => (object) [
          'type' => 'varchar',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'replyToName' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'replyToAddress' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'textFilterDisabled' => true,
          'layoutFiltersDisabled' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'addressNameMap' => (object) [
          'type' => 'jsonObject',
          'utility' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'name' => 'addressNameMap',
          'label' => 'endereço Nome Mapa',
          'disabled' => true,
          'inlineEditDisabled' => false,
          'tooltip' => false
        ],
        'from' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'required' => true,
          'view' => 'views/email/fields/from-address-varchar',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'to' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'required' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassName' => 'Espo\\Classes\\FieldValidators\\Email\\EmailAddresses',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'cc' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'customizationDisabled' => true,
          'textFilterDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail',
            1 => 'filters'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'bcc' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\Valid',
            1 => 'Espo\\Classes\\FieldValidators\\Email\\Addresses\\MaxCount'
          ],
          'customizationDisabled' => true,
          'textFilterDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'replyTo' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'view' => 'views/email/fields/email-address-varchar',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'detail'
          ],
          'massUpdateDisabled' => true,
          'reportDisabled' => true
        ],
        'personStringData' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'view' => 'views/email/fields/person-string-data',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'isRead' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'default' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'isNotRead' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'isReplied' => (object) [
          'type' => 'bool',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'isNotReplied' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'isImportant' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'inTrash' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportGroupByDisabled' => true,
          'reportFilterDisabled' => true,
          'reportOrderByDisabled' => true,
          'workflowDisabled' => true
        ],
        'inArchive' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'folderId' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'default' => NULL,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'readOnly' => true,
          'reportDisabled' => true
        ],
        'isUsers' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'default' => false,
          'customizationDisabled' => true,
          'readOnly' => true,
          'reportDisabled' => true,
          'workflowDisabled' => true
        ],
        'isUsersSent' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'folder' => (object) [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'entity' => 'EmailFolder',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'reportDisabled' => true
        ],
        'folderString' => (object) [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'entity' => 'EmailFolder',
          'customizationDisabled' => true,
          'view' => 'views/email/fields/folder-string',
          'layoutAvailabilityList' => [
            0 => 'defaultSidePanel'
          ]
        ],
        'nameHash' => (object) [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'typeHash' => (object) [
          'type' => 'jsonObject',
          'notStorable' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'idHash' => (object) [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'messageId' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'readOnly' => true,
          'index' => true,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'messageIdInternal' => (object) [
          'type' => 'varchar',
          'maxLength' => 300,
          'readOnly' => true,
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'emailAddress' => (object) [
          'type' => 'base',
          'notStorable' => true,
          'view' => 'views/email/fields/email-address',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'fromEmailAddress' => (object) [
          'type' => 'link',
          'view' => 'views/email/fields/from-email-address',
          'textFilterDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true,
          'defaultAttributes' => NULL
        ],
        'toEmailAddresses' => (object) [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'ccEmailAddresses' => (object) [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'bccEmailAddresses' => (object) [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'replyToEmailAddresses' => (object) [
          'type' => 'linkMultiple',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [],
          'massUpdateDisabled' => true,
          'readOnly' => true
        ],
        'bodyPlain' => (object) [
          'type' => 'text',
          'seeMoreDisabled' => true,
          'clientReadOnly' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'massUpdateDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'body' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/email/fields/body',
          'attachmentField' => 'attachments',
          'useIframe' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isHtml' => (object) [
          'type' => 'bool',
          'default' => true,
          'fieldManagerParamList' => [
            0 => 'default',
            1 => 'tooltipText'
          ],
          'inlineEditDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Draft',
            1 => 'Sending',
            2 => 'Sent',
            3 => 'Archived',
            4 => 'Failed'
          ],
          'default' => 'Archived',
          'clientReadOnly' => true,
          'style' => (object) [
            'Draft' => 'warning',
            'Failed' => 'danger',
            'Sending' => 'warning'
          ],
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'attachments' => (object) [
          'type' => 'attachmentMultiple',
          'sourceList' => [
            0 => 'Document'
          ],
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'hasAttachment' => (object) [
          'type' => 'bool',
          'readOnly' => true,
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true
        ],
        'parent' => (object) [
          'type' => 'linkParent',
          'fieldManagerParamList' => [
            0 => 'required',
            1 => 'entityList',
            2 => 'autocompleteOnEmpty',
            3 => 'audited',
            4 => 'tooltipText'
          ],
          'entityList' => [
            0 => 'Account',
            1 => 'Lead',
            2 => 'Contact',
            3 => 'Opportunity',
            4 => 'Case',
            5 => 'CRegistration',
            6 => 'User'
          ]
        ],
        'dateSent' => (object) [
          'type' => 'datetime',
          'customizationDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'massUpdateDisabled' => true,
          'view' => 'views/email/fields/date-sent'
        ],
        'deliveryDate' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'sendAt' => (object) [
          'type' => 'datetime',
          'customizationDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters',
            1 => 'list'
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Email\\SendAt\\Future'
          ]
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'customizationDisabled' => true
        ],
        'sentBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'noLoad' => true,
          'customizationDisabled' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'customizationDisabled' => true
        ],
        'assignedUser' => (object) [
          'type' => 'link',
          'required' => false,
          'view' => 'views/fields/assigned-user',
          'massUpdateDisabled' => true
        ],
        'replied' => (object) [
          'type' => 'link',
          'noJoin' => true,
          'view' => 'views/email/fields/replied',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'replies' => (object) [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'orderBy' => 'dateSent',
          'view' => 'views/email/fields/replies',
          'customizationDisabled' => true,
          'columns' => (object) [
            'status' => 'status'
          ],
          'massUpdateDisabled' => true
        ],
        'isSystem' => (object) [
          'type' => 'bool',
          'default' => false,
          'readOnly' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isJustSent' => (object) [
          'type' => 'bool',
          'default' => false,
          'readOnly' => true,
          'utility' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'isBeingImported' => (object) [
          'type' => 'bool',
          'readOnly' => true,
          'utility' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'massUpdateDisabled' => true
        ],
        'skipNotificationMap' => (object) [
          'type' => 'jsonObject',
          'utility' => true,
          'readOnly' => true,
          'notStorable' => true
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'users' => (object) [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'readOnly' => true,
          'columns' => (object) [
            'inTrash' => 'inTrash',
            'folderId' => 'folderId'
          ],
          'customizationDisabled' => true
        ],
        'assignedUsers' => (object) [
          'type' => 'linkMultiple',
          'layoutListDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/assigned-users'
        ],
        'inboundEmails' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'noLoad' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'default'
          ]
        ],
        'emailAccounts' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'noLoad' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'default'
          ]
        ],
        'icsContents' => (object) [
          'type' => 'text',
          'readOnly' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventData' => (object) [
          'type' => 'jsonObject',
          'readOnly' => true,
          'directAccessDisabled' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventUid' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'index' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'icsEventDateStart' => (object) [
          'type' => 'datetimeOptional',
          'readOnly' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'createEvent' => (object) [
          'type' => 'base',
          'utility' => true,
          'notStorable' => true,
          'view' => 'views/email/fields/create-event',
          'customizationDisabled' => true,
          'massUpdateDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'createdEvent' => (object) [
          'type' => 'linkParent',
          'readOnly' => true,
          'view' => 'views/email/fields/created-event',
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'layoutAvailabilityList' => []
        ],
        'groupFolder' => (object) [
          'type' => 'link',
          'massUpdateDisabled' => true,
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'audited'
          ],
          'audited' => true
        ],
        'groupStatusFolder' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Archive',
            2 => 'Trash'
          ],
          'maxLength' => 7,
          'readOnly' => true,
          'customizationDisabled' => true,
          'index' => true
        ],
        'account' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'tasks' => (object) [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'columns' => (object) [
            'status' => 'status'
          ],
          'view' => 'crm:views/task/fields/tasks',
          'customizationDefaultDisabled' => true
        ],
        'icsEventDateStartDate' => (object) [
          'readOnly' => true,
          'notStorable' => true,
          'customizationDisabled' => true,
          'type' => 'date',
          'disabled' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'assignedUsers' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'relationName' => 'entityUser'
        ],
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'emails',
          'additionalColumns' => (object) [
            'isRead' => (object) [
              'type' => 'bool',
              'default' => false
            ],
            'isImportant' => (object) [
              'type' => 'bool',
              'default' => false
            ],
            'inTrash' => (object) [
              'type' => 'bool',
              'default' => false
            ],
            'inArchive' => (object) [
              'type' => 'bool',
              'default' => false
            ],
            'folderId' => (object) [
              'type' => 'foreignId',
              'default' => NULL
            ]
          ]
        ],
        'sentBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'attachments' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'foreign' => 'parent',
          'relationName' => 'attachments',
          'audited' => false
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [],
          'foreign' => 'emails'
        ],
        'replied' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Email',
          'foreign' => 'replies'
        ],
        'replies' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'replied'
        ],
        'fromEmailAddress' => (object) [
          'type' => 'belongsTo',
          'entity' => 'EmailAddress'
        ],
        'toEmailAddresses' => (object) [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => (object) [
            'addressType' => 'to'
          ],
          'additionalColumns' => (object) [
            'addressType' => (object) [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ],
        'ccEmailAddresses' => (object) [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => (object) [
            'addressType' => 'cc'
          ],
          'additionalColumns' => (object) [
            'addressType' => (object) [
              'type' => 'varchar',
              'len' => '4'
            ]
          ],
          'layoutDefaultSidePanelDisabled' => true
        ],
        'bccEmailAddresses' => (object) [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => (object) [
            'addressType' => 'bcc'
          ],
          'additionalColumns' => (object) [
            'addressType' => (object) [
              'type' => 'varchar',
              'len' => '4'
            ]
          ],
          'layoutDefaultSidePanelDisabled' => true
        ],
        'replyToEmailAddresses' => (object) [
          'type' => 'hasMany',
          'entity' => 'EmailAddress',
          'relationName' => 'emailEmailAddress',
          'conditions' => (object) [
            'addressType' => 'rto'
          ],
          'additionalColumns' => (object) [
            'addressType' => (object) [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ],
        'inboundEmails' => (object) [
          'type' => 'hasMany',
          'entity' => 'InboundEmail',
          'foreign' => 'emails',
          'audited' => false
        ],
        'emailAccounts' => (object) [
          'type' => 'hasMany',
          'entity' => 'EmailAccount',
          'foreign' => 'emails',
          'audited' => false
        ],
        'createdEvent' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Meeting'
          ]
        ],
        'groupFolder' => (object) [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder',
          'foreign' => 'emails'
        ],
        'account' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Account'
        ],
        'tasks' => (object) [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'email'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'dateSent',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'bodyPlain',
          2 => 'body'
        ],
        'countDisabled' => true,
        'fullTextSearch' => true,
        'fullTextSearchOrderType' => 'original',
        'sortBy' => 'dateSent',
        'asc' => false
      ],
      'indexes' => (object) [
        'createdById' => (object) [
          'columns' => [
            0 => 'createdById'
          ]
        ],
        'dateSent' => (object) [
          'columns' => [
            0 => 'dateSent',
            1 => 'deleted'
          ]
        ],
        'dateSentStatus' => (object) [
          'columns' => [
            0 => 'dateSent',
            1 => 'status',
            2 => 'deleted'
          ]
        ]
      ]
    ],
    'EmailAccount' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddress' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'tooltip' => true,
          'view' => 'views/email-account/fields/email-address'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active'
        ],
        'host' => (object) [
          'type' => 'varchar'
        ],
        'port' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 993
        ],
        'security' => (object) [
          'type' => 'enum',
          'default' => 'SSL',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'username' => (object) [
          'type' => 'varchar'
        ],
        'password' => (object) [
          'type' => 'password'
        ],
        'monitoredFolders' => (object) [
          'type' => 'array',
          'default' => [
            0 => 'INBOX'
          ],
          'view' => 'views/email-account/fields/folders',
          'displayAsList' => true,
          'noEmptyString' => true,
          'duplicateIgnore' => true
        ],
        'sentFolder' => (object) [
          'type' => 'varchar',
          'view' => 'views/email-account/fields/folder',
          'duplicateIgnore' => true
        ],
        'storeSentEmails' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'keepFetchedEmailsUnread' => (object) [
          'type' => 'bool'
        ],
        'fetchSince' => (object) [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\InboundEmail\\FetchSince\\Required'
          ],
          'forceValidation' => true
        ],
        'fetchData' => (object) [
          'type' => 'jsonObject',
          'readOnly' => true,
          'duplicateIgnore' => true
        ],
        'emailFolder' => (object) [
          'type' => 'link',
          'view' => 'views/email-account/fields/email-folder',
          'duplicateIgnore' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'assignedUser' => (object) [
          'type' => 'link',
          'required' => true,
          'view' => 'views/fields/assigned-user'
        ],
        'connectedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'useImap' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'useSmtp' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpHost' => (object) [
          'type' => 'varchar'
        ],
        'smtpPort' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'smtpSecurity' => (object) [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => (object) [
          'type' => 'varchar'
        ],
        'smtpPassword' => (object) [
          'type' => 'password'
        ],
        'smtpAuthMechanism' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'login',
            1 => 'crammd5',
            2 => 'plain'
          ],
          'default' => 'login'
        ],
        'imapHandler' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'smtpHandler' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'assignedUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'filters' => (object) [
          'type' => 'hasChildren',
          'foreign' => 'parent',
          'entity' => 'EmailFilter'
        ],
        'emails' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'emailAccounts',
          'audited' => false
        ],
        'emailFolder' => (object) [
          'type' => 'belongsTo',
          'entity' => 'EmailFolder'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'EmailAddress' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 255
        ],
        'lower' => (object) [
          'type' => 'varchar',
          'required' => true,
          'index' => true
        ],
        'invalid' => (object) [
          'type' => 'bool'
        ],
        'optOut' => (object) [
          'type' => 'bool'
        ],
        'primary' => (object) [
          'type' => 'bool',
          'notStorable' => true
        ]
      ],
      'links' => (object) [],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'hooksDisabled' => true
    ],
    'EmailFilter' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'tooltip' => true,
          'pattern' => '$noBadCharacters'
        ],
        'from' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'to' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'subject' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'tooltip' => true
        ],
        'bodyContains' => (object) [
          'type' => 'array',
          'tooltip' => true
        ],
        'bodyContainsAll' => (object) [
          'type' => 'array',
          'tooltip' => true
        ],
        'isGlobal' => (object) [
          'type' => 'bool',
          'tooltip' => true,
          'default' => false,
          'readOnlyAfterCreate' => true
        ],
        'parent' => (object) [
          'type' => 'linkParent',
          'view' => 'views/email-filter/fields/parent',
          'readOnlyAfterCreate' => true
        ],
        'action' => (object) [
          'type' => 'enum',
          'default' => 'Skip',
          'options' => [
            0 => 'Skip',
            1 => 'Move to Folder',
            2 => 'Move to Group Folder',
            3 => 'None'
          ]
        ],
        'emailFolder' => (object) [
          'type' => 'link',
          'view' => 'views/email-filter/fields/email-folder'
        ],
        'groupEmailFolder' => (object) [
          'type' => 'link'
        ],
        'markAsRead' => (object) [
          'type' => 'bool'
        ],
        'skipNotification' => (object) [
          'type' => 'bool'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'User',
            1 => 'EmailAccount',
            2 => 'InboundEmail'
          ]
        ],
        'emailFolder' => (object) [
          'type' => 'belongsTo',
          'entity' => 'EmailFolder'
        ],
        'groupEmailFolder' => (object) [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ]
    ],
    'EmailFolder' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 64,
          'pattern' => '$noBadCharacters'
        ],
        'order' => (object) [
          'type' => 'int'
        ],
        'assignedUser' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'skipNotifications' => (object) [
          'type' => 'bool'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'order',
        'order' => 'asc',
        'sortBy' => 'order',
        'asc' => true
      ]
    ],
    'EmailTemplate' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'subject' => (object) [
          'type' => 'varchar'
        ],
        'body' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/email-template/fields/body',
          'useIframe' => true,
          'attachmentField' => 'attachments'
        ],
        'isHtml' => (object) [
          'type' => 'bool',
          'default' => true,
          'inlineEditDisabled' => true
        ],
        'oneOff' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'attachments' => (object) [
          'type' => 'attachmentMultiple'
        ],
        'category' => (object) [
          'type' => 'link',
          'view' => 'views/fields/link-category-tree'
        ],
        'assignedUser' => (object) [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => (object) [
        'attachments' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'foreign' => 'parent'
        ],
        'category' => (object) [
          'type' => 'belongsTo',
          'foreign' => 'emailTemplates',
          'entity' => 'EmailTemplateCategory'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'assignedUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'subject'
        ],
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'optimisticConcurrencyControl' => true
    ],
    'EmailTemplateCategory' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'order' => (object) [
          'type' => 'int',
          'minValue' => 1,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'teams' => (object) [
          'type' => 'linkMultiple'
        ],
        'parent' => (object) [
          'type' => 'link'
        ],
        'childList' => (object) [
          'type' => 'jsonArray',
          'notStorable' => true,
          'name' => 'childList',
          'label' => 'Lista filho',
          'dynamicLogicVisible' => NULL,
          'dynamicLogicReadOnly' => NULL,
          'inlineEditDisabled' => false,
          'tooltip' => false
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'parent' => (object) [
          'type' => 'belongsTo',
          'foreign' => 'children',
          'entity' => 'EmailTemplateCategory'
        ],
        'children' => (object) [
          'type' => 'hasMany',
          'foreign' => 'parent',
          'entity' => 'EmailTemplateCategory',
          'readOnly' => true
        ],
        'emailTemplates' => (object) [
          'type' => 'hasMany',
          'foreign' => 'category',
          'entity' => 'EmailTemplate',
          'audited' => false
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'parent',
        'order' => 'asc',
        'sortBy' => 'parent',
        'asc' => true
      ],
      'additionalTables' => (object) [
        'EmailTemplateCategoryPath' => (object) [
          'attributes' => (object) [
            'id' => (object) [
              'type' => 'id',
              'dbType' => 'integer',
              'len' => 11,
              'autoincrement' => true
            ],
            'ascendorId' => (object) [
              'type' => 'foreignId',
              'index' => true
            ],
            'descendorId' => (object) [
              'type' => 'foreignId',
              'index' => true
            ]
          ]
        ]
      ],
      'repositoryClassName' => 'Espo\\Core\\Repositories\\CategoryTree'
    ],
    'Export' => (object) [
      'fields' => (object) [
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Running',
            2 => 'Success',
            3 => 'Failed'
          ],
          'default' => 'Pending'
        ],
        'params' => (object) [
          'type' => 'text'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'required' => true
        ],
        'notifyOnFinish' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'attachment' => (object) [
          'type' => 'link',
          'entity' => 'Attachment'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'Extension' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'version' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 50
        ],
        'fileList' => (object) [
          'type' => 'jsonArray'
        ],
        'licenseStatus' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Valid',
            2 => 'Invalid',
            3 => 'Expired',
            4 => 'Soft-Expired'
          ],
          'index' => true,
          'maxLength' => 36
        ],
        'licenseStatusMessage' => (object) [
          'type' => 'varchar'
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'isInstalled' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'checkVersionUrl' => (object) [
          'type' => 'url'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'ExternalAccount' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 64
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'enabled' => (object) [
          'type' => 'bool'
        ],
        'isLocked' => (object) [
          'type' => 'bool'
        ]
      ]
    ],
    'GroupEmailFolder' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 64,
          'pattern' => '$noBadCharacters'
        ],
        'order' => (object) [
          'type' => 'int'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'groupEmailFolders'
        ],
        'emails' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'groupFolder'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'order',
        'order' => 'asc',
        'sortBy' => 'order',
        'asc' => true
      ]
    ],
    'Import' => (object) [
      'fields' => (object) [
        'entityType' => (object) [
          'type' => 'enum',
          'translation' => 'Global.scopeNames',
          'required' => true,
          'readOnly' => true,
          'view' => 'views/fields/entity-type'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Standby',
            1 => 'Pending',
            2 => 'In Process',
            3 => 'Complete',
            4 => 'Failed'
          ],
          'readOnly' => true,
          'style' => (object) [
            'Complete' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'file' => (object) [
          'type' => 'file',
          'required' => true,
          'readOnly' => true
        ],
        'importedCount' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'duplicateCount' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'updatedCount' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'notStorable' => true
        ],
        'lastIndex' => (object) [
          'type' => 'int',
          'readOnly' => true
        ],
        'params' => (object) [
          'type' => 'jsonObject',
          'readOnly' => true
        ],
        'attributeList' => (object) [
          'type' => 'jsonArray',
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'errors' => (object) [
          'type' => 'hasMany',
          'entity' => 'ImportError',
          'foreign' => 'import',
          'readOnly' => true
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ]
    ],
    'ImportEml' => (object) [
      'fields' => (object) [
        'file' => (object) [
          'type' => 'file'
        ]
      ],
      'skipRebuild' => true
    ],
    'ImportEntity' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => (object) [
          'type' => 'linkParent'
        ],
        'import' => (object) [
          'type' => 'link'
        ],
        'isImported' => (object) [
          'type' => 'bool'
        ],
        'isUpdated' => (object) [
          'type' => 'bool'
        ],
        'isDuplicate' => (object) [
          'type' => 'bool'
        ]
      ],
      'indexes' => (object) [
        'entityImport' => (object) [
          'columns' => [
            0 => 'importId',
            1 => 'entityType'
          ]
        ]
      ]
    ],
    'ImportError' => (object) [
      'fields' => (object) [
        'import' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'entityType' => (object) [
          'type' => 'foreign',
          'link' => 'import',
          'field' => 'entityType'
        ],
        'rowIndex' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true
        ],
        'exportRowIndex' => (object) [
          'type' => 'int',
          'readOnly' => true
        ],
        'lineNumber' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true,
          'notStorable' => true,
          'view' => 'views/import-error/fields/line-number'
        ],
        'exportLineNumber' => (object) [
          'type' => 'int',
          'readOnly' => true,
          'tooltip' => true,
          'notStorable' => true,
          'view' => 'views/import-error/fields/line-number'
        ],
        'type' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Validation',
            2 => 'No-Access',
            3 => 'Not-Found',
            4 => 'Integrity-Constraint-Violation'
          ],
          'readOnly' => true
        ],
        'validationFailures' => (object) [
          'type' => 'jsonArray',
          'readOnly' => true,
          'view' => 'views/import-error/fields/validation-failures'
        ],
        'row' => (object) [
          'type' => 'array',
          'readOnly' => true,
          'displayAsList' => true,
          'doNotStoreArrayValues' => true
        ]
      ],
      'links' => (object) [
        'import' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Import',
          'foreign' => 'errors',
          'foreignName' => 'id'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'rowIndex',
        'sortBy' => 'rowIndex'
      ],
      'indexes' => (object) [
        'rowIndex' => (object) [
          'columns' => [
            0 => 'rowIndex'
          ]
        ],
        'importRowIndex' => (object) [
          'columns' => [
            0 => 'importId',
            1 => 'rowIndex'
          ]
        ]
      ]
    ],
    'InboundEmail' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddress' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100,
          'view' => 'views/inbound-email/fields/email-address'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active'
        ],
        'host' => (object) [
          'type' => 'varchar'
        ],
        'port' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 993
        ],
        'security' => (object) [
          'type' => 'enum',
          'default' => 'SSL',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'username' => (object) [
          'type' => 'varchar'
        ],
        'password' => (object) [
          'type' => 'password'
        ],
        'monitoredFolders' => (object) [
          'type' => 'array',
          'default' => [
            0 => 'INBOX'
          ],
          'view' => 'views/inbound-email/fields/folders',
          'displayAsList' => true,
          'noEmptyString' => true,
          'duplicateIgnore' => true
        ],
        'fetchSince' => (object) [
          'type' => 'date',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\InboundEmail\\FetchSince\\Required'
          ],
          'forceValidation' => true
        ],
        'fetchData' => (object) [
          'type' => 'jsonObject',
          'readOnly' => true,
          'duplicateIgnore' => true
        ],
        'assignToUser' => (object) [
          'type' => 'link',
          'tooltip' => true
        ],
        'team' => (object) [
          'type' => 'link',
          'tooltip' => true
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'addAllTeamUsers' => (object) [
          'type' => 'bool',
          'tooltip' => true,
          'default' => true
        ],
        'isSystem' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'readOnly' => true,
          'directAccessDisabled' => true,
          'tooltip' => true
        ],
        'sentFolder' => (object) [
          'type' => 'varchar',
          'view' => 'views/inbound-email/fields/folder',
          'duplicateIgnore' => true
        ],
        'storeSentEmails' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'keepFetchedEmailsUnread' => (object) [
          'type' => 'bool'
        ],
        'connectedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'excludeFromReply' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'useImap' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'useSmtp' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpIsShared' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpIsForMassEmail' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'smtpHost' => (object) [
          'type' => 'varchar'
        ],
        'smtpPort' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'smtpSecurity' => (object) [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => (object) [
          'type' => 'varchar'
        ],
        'smtpPassword' => (object) [
          'type' => 'password'
        ],
        'smtpAuthMechanism' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'login',
            1 => 'crammd5',
            2 => 'plain'
          ],
          'default' => 'login'
        ],
        'createCase' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'caseDistribution' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Direct-Assignment',
            2 => 'Round-Robin',
            3 => 'Least-Busy'
          ],
          'default' => 'Direct-Assignment',
          'tooltip' => true
        ],
        'targetUserPosition' => (object) [
          'type' => 'enum',
          'view' => 'views/inbound-email/fields/target-user-position',
          'tooltip' => true
        ],
        'reply' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'replyEmailTemplate' => (object) [
          'type' => 'link'
        ],
        'replyFromAddress' => (object) [
          'type' => 'varchar'
        ],
        'replyToAddress' => (object) [
          'type' => 'varchar',
          'view' => 'views/fields/email-address',
          'tooltip' => true
        ],
        'replyFromName' => (object) [
          'type' => 'varchar'
        ],
        'fromName' => (object) [
          'type' => 'varchar'
        ],
        'groupEmailFolder' => (object) [
          'type' => 'link',
          'tooltip' => true
        ],
        'imapHandler' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'smtpHandler' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'inboundEmails'
        ],
        'assignToUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'team' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'replyEmailTemplate' => (object) [
          'type' => 'belongsTo',
          'entity' => 'EmailTemplate'
        ],
        'filters' => (object) [
          'type' => 'hasChildren',
          'foreign' => 'parent',
          'entity' => 'EmailFilter'
        ],
        'emails' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'inboundEmails',
          'audited' => false
        ],
        'groupEmailFolder' => (object) [
          'type' => 'belongsTo',
          'entity' => 'GroupEmailFolder'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Integration' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 24
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'enabled' => (object) [
          'type' => 'bool'
        ]
      ]
    ],
    'Job' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/admin/job/fields/name'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Ready',
            2 => 'Running',
            3 => 'Success',
            4 => 'Failed'
          ],
          'default' => 'Pending',
          'style' => (object) [
            'Success' => 'success',
            'Failed' => 'danger',
            'Running' => 'warning',
            'Ready' => 'warning'
          ],
          'maxLength' => 16
        ],
        'executeTime' => (object) [
          'type' => 'datetime',
          'required' => true,
          'hasSeconds' => true
        ],
        'number' => (object) [
          'type' => 'int',
          'index' => true,
          'readOnly' => true,
          'view' => 'views/fields/autoincrement',
          'dbType' => 'bigint',
          'unique' => true,
          'autoincrement' => true
        ],
        'className' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 255
        ],
        'serviceName' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'methodName' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'job' => (object) [
          'type' => 'varchar',
          'view' => 'views/scheduled-job/fields/job'
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'scheduledJob' => (object) [
          'type' => 'link'
        ],
        'scheduledJobJob' => (object) [
          'type' => 'foreign',
          'link' => 'scheduledJob',
          'field' => 'job'
        ],
        'queue' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'default' => NULL
        ],
        'group' => (object) [
          'type' => 'varchar',
          'maxLength' => 128,
          'default' => NULL
        ],
        'targetGroup' => (object) [
          'type' => 'varchar',
          'maxLength' => 128,
          'default' => NULL
        ],
        'startedAt' => (object) [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'executedAt' => (object) [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'pid' => (object) [
          'type' => 'int'
        ],
        'attempts' => (object) [
          'type' => 'int'
        ],
        'targetId' => (object) [
          'type' => 'varchar',
          'maxLength' => 48
        ],
        'targetType' => (object) [
          'type' => 'varchar',
          'maxLength' => 64
        ],
        'failedAttempts' => (object) [
          'type' => 'int'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ]
      ],
      'links' => (object) [
        'scheduledJob' => (object) [
          'type' => 'belongsTo',
          'entity' => 'ScheduledJob'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'id',
          1 => 'name',
          2 => 'methodName',
          3 => 'serviceName'
        ],
        'countDisabled' => true,
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => (object) [
        'executeTime' => (object) [
          'columns' => [
            0 => 'status',
            1 => 'executeTime'
          ]
        ],
        'status' => (object) [
          'columns' => [
            0 => 'status',
            1 => 'deleted'
          ]
        ],
        'statusScheduledJobId' => (object) [
          'columns' => [
            0 => 'status',
            1 => 'scheduledJobId'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'KanbanOrder' => (object) [
      'fields' => (object) [
        'order' => (object) [
          'type' => 'int',
          'dbType' => 'smallint'
        ],
        'entity' => (object) [
          'type' => 'linkParent'
        ],
        'group' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'user' => (object) [
          'type' => 'link'
        ]
      ],
      'links' => (object) [
        'entity' => (object) [
          'type' => 'belongsToParent'
        ]
      ],
      'indexes' => (object) [
        'entityUserId' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'entityId',
            2 => 'userId'
          ]
        ],
        'entityType' => (object) [
          'columns' => [
            0 => 'entityType'
          ]
        ],
        'entityTypeUserId' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'userId'
          ]
        ]
      ]
    ],
    'LayoutRecord' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar'
        ],
        'layoutSet' => (object) [
          'type' => 'link'
        ],
        'data' => (object) [
          'type' => 'text'
        ]
      ],
      'links' => (object) [
        'layoutSet' => (object) [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'layoutRecords'
        ]
      ],
      'indexes' => (object) [
        'nameLayoutSetId' => (object) [
          'columns' => [
            0 => 'name',
            1 => 'layoutSetId'
          ]
        ]
      ]
    ],
    'LayoutSet' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 100
        ],
        'layoutList' => (object) [
          'type' => 'multiEnum',
          'displayAsList' => true,
          'view' => 'views/layout-set/fields/layout-list'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'layoutRecords' => (object) [
          'type' => 'hasMany',
          'entity' => 'LayoutRecord',
          'foreign' => 'layoutSet'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'layoutSet'
        ],
        'portals' => (object) [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'layoutSet'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'LeadCapture' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'campaign' => (object) [
          'type' => 'link',
          'audited' => true
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'subscribeToTargetList' => (object) [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'subscribeContactToTargetList' => (object) [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'targetList' => (object) [
          'type' => 'link',
          'audited' => true
        ],
        'fieldList' => (object) [
          'type' => 'multiEnum',
          'default' => [
            0 => 'firstName',
            1 => 'lastName',
            2 => 'emailAddress'
          ],
          'view' => 'views/lead-capture/fields/field-list',
          'displayAsList' => true,
          'required' => true,
          'ignoreFieldList' => [
            0 => 'targetList',
            1 => 'targetLists',
            2 => 'acceptanceStatus',
            3 => 'acceptanceStatusMeetings',
            4 => 'acceptanceStatusCalls',
            5 => 'campaign',
            6 => 'source',
            7 => 'teams',
            8 => 'createdOpportunity',
            9 => 'createdAccount',
            10 => 'createdContact',
            11 => 'emailAddressIsOptedOut',
            12 => 'emailAddressIsInvalid',
            13 => 'phoneNumberIsOptedOut',
            14 => 'phoneNumberIsInvalid',
            15 => 'opportunityAmountCurrency',
            16 => 'originalEmail'
          ],
          'webFormFieldTypeList' => [
            0 => 'varchar',
            1 => 'email',
            2 => 'phone',
            3 => 'text',
            4 => 'personName',
            5 => 'enum',
            6 => 'multiEnum',
            7 => 'array',
            8 => 'checklist',
            9 => 'int',
            10 => 'float',
            11 => 'currency',
            12 => 'date',
            13 => 'datetime',
            14 => 'boolean',
            15 => 'url',
            16 => 'urlMultiple',
            17 => 'address'
          ],
          'audited' => true
        ],
        'fieldParams' => (object) [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'duplicateCheck' => (object) [
          'type' => 'bool',
          'default' => true,
          'audited' => true
        ],
        'optInConfirmation' => (object) [
          'type' => 'bool',
          'audited' => true
        ],
        'optInConfirmationEmailTemplate' => (object) [
          'type' => 'link',
          'audited' => true
        ],
        'optInConfirmationLifetime' => (object) [
          'type' => 'int',
          'default' => 48,
          'min' => 1,
          'audited' => true
        ],
        'optInConfirmationSuccessMessage' => (object) [
          'type' => 'text',
          'tooltip' => true,
          'audited' => true
        ],
        'createLeadBeforeOptInConfirmation' => (object) [
          'type' => 'bool',
          'audited' => true
        ],
        'skipOptInConfirmationIfSubscribed' => (object) [
          'type' => 'bool',
          'audited' => true
        ],
        'leadSource' => (object) [
          'type' => 'enum',
          'customizationOptionsDisabled' => true,
          'optionsPath' => 'entityDefs.Lead.fields.source.options',
          'translation' => 'Lead.options.source',
          'default' => 'Web Site',
          'audited' => true
        ],
        'apiKey' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'readOnly' => true
        ],
        'formId' => (object) [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true
        ],
        'formEnabled' => (object) [
          'type' => 'bool',
          'audited' => true
        ],
        'formText' => (object) [
          'type' => 'text',
          'tooltip' => 'optInConfirmationSuccessMessage'
        ],
        'formSuccessText' => (object) [
          'type' => 'text',
          'tooltip' => 'optInConfirmationSuccessMessage'
        ],
        'formSuccessRedirectUrl' => (object) [
          'type' => 'url',
          'audited' => true
        ],
        'formLanguage' => (object) [
          'type' => 'enum',
          'maxLength' => 5,
          'view' => 'views/preferences/fields/language',
          'audited' => true
        ],
        'formFrameAncestors' => (object) [
          'type' => 'urlMultiple',
          'audited' => true
        ],
        'formCaptcha' => (object) [
          'type' => 'bool',
          'audited' => true,
          'tooltip' => true
        ],
        'targetTeam' => (object) [
          'type' => 'link',
          'audited' => true
        ],
        'exampleRequestUrl' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true,
          'copyToClipboard' => true
        ],
        'exampleRequestMethod' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'readOnly' => true
        ],
        'exampleRequestPayload' => (object) [
          'type' => 'text',
          'notStorable' => true,
          'readOnly' => true,
          'seeMoreDisabled' => true
        ],
        'exampleRequestHeaders' => (object) [
          'type' => 'array',
          'notStorable' => true,
          'readOnly' => true
        ],
        'formUrl' => (object) [
          'type' => 'url',
          'notStorable' => true,
          'readOnly' => true,
          'copyToClipboard' => true
        ],
        'inboundEmail' => (object) [
          'type' => 'link',
          'audited' => true
        ],
        'smtpAccount' => (object) [
          'type' => 'base',
          'notStorable' => true,
          'view' => 'views/lead-capture/fields/smtp-account'
        ],
        'phoneNumberCountry' => (object) [
          'type' => 'enum',
          'view' => 'views/lead-capture/fields/phone-number-country',
          'maxLength' => 2
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'targetList' => (object) [
          'type' => 'belongsTo',
          'entity' => 'TargetList'
        ],
        'campaign' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Campaign'
        ],
        'targetTeam' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'inboundEmail' => (object) [
          'type' => 'belongsTo',
          'entity' => 'InboundEmail'
        ],
        'optInConfirmationEmailTemplate' => (object) [
          'type' => 'belongsTo',
          'entity' => 'EmailTemplate'
        ],
        'logRecords' => (object) [
          'type' => 'hasMany',
          'entity' => 'LeadCaptureLogRecord',
          'foreign' => 'leadCapture'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'LeadCaptureLogRecord' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'index' => true,
          'readOnly' => true
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'isCreated' => (object) [
          'type' => 'bool'
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'leadCapture' => (object) [
          'type' => 'link'
        ],
        'target' => (object) [
          'type' => 'linkParent'
        ]
      ],
      'links' => (object) [
        'leadCapture' => (object) [
          'type' => 'belongsTo',
          'entity' => 'LeadCapture',
          'foreign' => 'logRecords'
        ],
        'target' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Contact',
            1 => 'Lead'
          ]
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'MassAction' => (object) [
      'fields' => (object) [
        'entityType' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'action' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Running',
            2 => 'Success',
            3 => 'Failed'
          ],
          'default' => 'Pending'
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'params' => (object) [
          'type' => 'text'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'required' => true
        ],
        'processedCount' => (object) [
          'type' => 'int'
        ],
        'notifyOnFinish' => (object) [
          'type' => 'bool',
          'default' => false
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'NextNumber' => (object) [
      'fields' => (object) [
        'entityType' => (object) [
          'type' => 'varchar',
          'index' => true,
          'maxLength' => 100
        ],
        'fieldName' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'value' => (object) [
          'type' => 'int',
          'default' => 1
        ]
      ],
      'indexes' => (object) [
        'entityTypeFieldName' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'fieldName'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'Note' => (object) [
      'fields' => (object) [
        'post' => (object) [
          'type' => 'text',
          'rows' => 100000,
          'view' => 'views/note/fields/post',
          'preview' => true,
          'attachmentField' => 'attachments',
          'customizationDefaultDisabled' => true,
          'customizationRequiredDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationTooltipTextDisabled' => true,
          'customizationSeeMoreDisabledDisabled' => true,
          'customizationRowsDisabled' => true,
          'customizationDisplayRawTextDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'dynamicLogicDisabled' => true
        ],
        'data' => (object) [
          'type' => 'jsonObject',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'type' => (object) [
          'type' => 'enum',
          'readOnly' => true,
          'view' => 'views/note/fields/type',
          'options' => [
            0 => 'Post',
            1 => 'Create',
            2 => 'CreateRelated',
            3 => 'Update',
            4 => 'Status',
            5 => 'Assign',
            6 => 'Relate',
            7 => 'Unrelate',
            8 => 'EmailReceived',
            9 => 'EmailSent'
          ],
          'maxLength' => 24,
          'customizationDisabled' => true,
          'default' => 'Post'
        ],
        'targetType' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'self',
            1 => 'all',
            2 => 'teams',
            3 => 'users',
            4 => 'portals'
          ],
          'maxLength' => 7,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'parent' => (object) [
          'type' => 'linkParent',
          'customizationDisabled' => true,
          'view' => 'views/note/fields/parent',
          'readOnlyAfterCreate' => true
        ],
        'related' => (object) [
          'type' => 'linkParent',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/note/fields/related'
        ],
        'attachments' => (object) [
          'type' => 'attachmentMultiple',
          'view' => 'views/stream/fields/attachment-multiple',
          'customizationRequiredDisabled' => true,
          'customizationPreviewSizeDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true,
          'customizationTooltipTextDisabled' => true,
          'dynamicLogicDisabled' => true
        ],
        'number' => (object) [
          'type' => 'autoincrement',
          'index' => true,
          'dbType' => 'bigint',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'portals' => (object) [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'users' => (object) [
          'type' => 'linkMultiple',
          'noLoad' => true,
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'isGlobal' => (object) [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'createdByGender' => (object) [
          'type' => 'foreign',
          'link' => 'createdBy',
          'field' => 'gender',
          'customizationDisabled' => true
        ],
        'notifiedUserIdList' => (object) [
          'type' => 'jsonArray',
          'notStorable' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'isInternal' => (object) [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnlyAfterCreate' => true
        ],
        'isPinned' => (object) [
          'type' => 'bool',
          'customizationDisabled' => true,
          'readOnly' => true
        ],
        'reactionCounts' => (object) [
          'type' => 'jsonObject',
          'notStorable' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'myReactions' => (object) [
          'type' => 'jsonArray',
          'notStorable' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationDisabled' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'customizationDisabled' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'attachments' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Attachment',
          'relationName' => 'attachments',
          'foreign' => 'parent'
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'foreign' => 'notes'
        ],
        'superParent' => (object) [
          'type' => 'belongsToParent'
        ],
        'related' => (object) [
          'type' => 'belongsToParent'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'notes'
        ],
        'portals' => (object) [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'notes'
        ],
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'notes'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'post'
        ],
        'fullTextSearch' => true,
        'fullTextSearchOrderType' => 'original',
        'sortBy' => 'number',
        'asc' => false
      ],
      'statusStyles' => (object) [
        'Lead' => (object) [],
        'Case' => (object) [],
        'Opportunity' => (object) [],
        'Task' => (object) []
      ],
      'indexes' => (object) [
        'createdAt' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'createdByNumber' => (object) [
          'columns' => [
            0 => 'createdById',
            1 => 'number'
          ]
        ],
        'type' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'type'
          ]
        ],
        'targetType' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'targetType'
          ]
        ],
        'parentId' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'parentId'
          ]
        ],
        'parentType' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'parentType'
          ]
        ],
        'relatedId' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'relatedId'
          ]
        ],
        'relatedType' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'relatedType'
          ]
        ],
        'superParentType' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'superParentType'
          ]
        ],
        'superParentId' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'superParentId'
          ]
        ]
      ],
      'streamRelated' => (object) [
        'Opportunity' => [
          0 => 'quotes'
        ]
      ]
    ],
    'Notification' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'dbType' => 'bigint',
          'index' => true
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'noteData' => (object) [
          'type' => 'jsonObject',
          'notStorable' => true,
          'orderDisabled' => true
        ],
        'type' => (object) [
          'type' => 'varchar'
        ],
        'read' => (object) [
          'type' => 'bool'
        ],
        'emailIsProcessed' => (object) [
          'type' => 'bool'
        ],
        'user' => (object) [
          'type' => 'link'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'message' => (object) [
          'type' => 'text'
        ],
        'related' => (object) [
          'type' => 'linkParent',
          'readOnly' => true
        ],
        'relatedParent' => (object) [
          'type' => 'linkParent',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User',
          'noJoin' => true
        ],
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'related' => (object) [
          'type' => 'belongsToParent'
        ],
        'relatedParent' => (object) [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ],
      'indexes' => (object) [
        'createdAt' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'user' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'userId',
            1 => 'createdAt'
          ]
        ]
      ]
    ],
    'PasswordChangeRequest' => (object) [
      'fields' => (object) [
        'requestId' => (object) [
          'type' => 'varchar',
          'maxLength' => 64,
          'index' => true
        ],
        'user' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'index' => true
        ],
        'url' => (object) [
          'type' => 'url'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'PhoneNumber' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'maxLength' => 36,
          'index' => true
        ],
        'type' => (object) [
          'type' => 'enum'
        ],
        'numeric' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'index' => true
        ],
        'invalid' => (object) [
          'type' => 'bool'
        ],
        'optOut' => (object) [
          'type' => 'bool'
        ],
        'primary' => (object) [
          'type' => 'bool',
          'notStorable' => true
        ]
      ],
      'links' => (object) [],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'hooksDisabled' => true
    ],
    'Portal' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters'
        ],
        'logo' => (object) [
          'type' => 'image'
        ],
        'url' => (object) [
          'type' => 'url',
          'notStorable' => true,
          'readOnly' => true
        ],
        'customId' => (object) [
          'type' => 'varchar',
          'maxLength' => 36,
          'view' => 'views/portal/fields/custom-id',
          'index' => true
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'isDefault' => (object) [
          'type' => 'bool',
          'default' => false,
          'notStorable' => true
        ],
        'portalRoles' => (object) [
          'type' => 'linkMultiple'
        ],
        'tabList' => (object) [
          'type' => 'array',
          'view' => 'views/portal/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'suppressValidationList' => [
            0 => 'arrayOfString'
          ],
          'doNotStoreArrayValues' => true
        ],
        'quickCreateList' => (object) [
          'type' => 'array',
          'translation' => 'Global.scopeNames',
          'view' => 'views/portal/fields/quick-create-list'
        ],
        'applicationName' => (object) [
          'type' => 'varchar'
        ],
        'companyLogo' => (object) [
          'type' => 'image'
        ],
        'theme' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => (object) [
          'type' => 'jsonObject'
        ],
        'language' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/language'
        ],
        'timeZone' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'dateFormat' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/date-format'
        ],
        'timeFormat' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-format'
        ],
        'weekStart' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => -1,
          'view' => 'views/preferences/fields/week-start'
        ],
        'defaultCurrency' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/default-currency'
        ],
        'dashboardLayout' => (object) [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => (object) [
          'type' => 'jsonObject',
          'utility' => true
        ],
        'customUrl' => (object) [
          'type' => 'url'
        ],
        'layoutSet' => (object) [
          'type' => 'link',
          'tooltip' => true
        ],
        'authenticationProvider' => (object) [
          'type' => 'link'
        ],
        'authTokenLifetime' => (object) [
          'type' => 'float',
          'min' => 0,
          'tooltip' => 'Settings.authTokenMaxIdleTime'
        ],
        'authTokenMaxIdleTime' => (object) [
          'type' => 'float',
          'min' => 0,
          'tooltip' => 'Settings.authTokenMaxIdleTime'
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'portals',
          'audited' => false
        ],
        'portalRoles' => (object) [
          'type' => 'hasMany',
          'entity' => 'PortalRole',
          'foreign' => 'portals'
        ],
        'notes' => (object) [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'portals'
        ],
        'layoutSet' => (object) [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'portals'
        ],
        'authenticationProvider' => (object) [
          'type' => 'belongsTo',
          'entity' => 'AuthenticationProvider'
        ],
        'articles' => (object) [
          'type' => 'hasMany',
          'entity' => 'KnowledgeBaseArticle',
          'foreign' => 'portals',
          'audited' => false
        ],
        'reports' => (object) [
          'type' => 'hasMany',
          'entity' => 'Report',
          'foreign' => 'portals'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'PortalRole' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'maxLength' => 150,
          'required' => true,
          'type' => 'varchar',
          'pattern' => '$noBadCharacters'
        ],
        'data' => (object) [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'fieldData' => (object) [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'exportPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => 'Role.exportPermission',
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'massUpdatePermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => 'Role.massUpdatePermission',
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'portalRoles',
          'audited' => false
        ],
        'portals' => (object) [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'portalRoles'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Preferences' => (object) [
      'fields' => (object) [
        'timeZone' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'dateFormat' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/date-format'
        ],
        'timeFormat' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/time-format'
        ],
        'weekStart' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => -1,
          'view' => 'views/preferences/fields/week-start'
        ],
        'defaultCurrency' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/default-currency'
        ],
        'thousandSeparator' => (object) [
          'type' => 'varchar',
          'default' => ',',
          'maxLength' => 1,
          'view' => 'views/settings/fields/thousand-separator',
          'options' => [
            0 => '.',
            1 => ',',
            2 => '\''
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\ThousandSeparator\\Valid'
          ]
        ],
        'decimalMark' => (object) [
          'type' => 'varchar',
          'default' => '.',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => '.',
            1 => ','
          ]
        ],
        'dashboardLayout' => (object) [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => (object) [
          'type' => 'jsonObject'
        ],
        'dashboardLocked' => (object) [
          'type' => 'bool'
        ],
        'importParams' => (object) [
          'type' => 'jsonObject'
        ],
        'sharedCalendarUserList' => (object) [
          'type' => 'jsonArray'
        ],
        'calendarViewDataList' => (object) [
          'type' => 'jsonArray'
        ],
        'presetFilters' => (object) [
          'type' => 'jsonObject'
        ],
        'language' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/language'
        ],
        'exportDelimiter' => (object) [
          'type' => 'varchar',
          'default' => ',',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => ',',
            1 => ';',
            2 => '\\t',
            3 => '|'
          ]
        ],
        'receiveAssignmentEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'receiveMentionEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'receiveStreamEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'assignmentNotificationsIgnoreEntityTypeList' => (object) [
          'type' => 'checklist',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/preferences/fields/assignment-notifications-ignore-entity-type-list',
          'default' => []
        ],
        'assignmentEmailNotificationsIgnoreEntityTypeList' => (object) [
          'type' => 'checklist',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/preferences/fields/assignment-email-notifications-ignore-entity-type-list'
        ],
        'reactionNotifications' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'autoFollowEntityTypeList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/preferences/fields/auto-follow-entity-type-list',
          'translation' => 'Global.scopeNamesPlural',
          'notStorable' => true,
          'tooltip' => true
        ],
        'signature' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/preferences/fields/signature'
        ],
        'defaultReminders' => (object) [
          'type' => 'jsonArray',
          'view' => 'crm:views/meeting/fields/reminders',
          'default' => [],
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\Valid',
            1 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\MaxCount'
          ]
        ],
        'defaultRemindersTask' => (object) [
          'type' => 'jsonArray',
          'view' => 'crm:views/meeting/fields/reminders',
          'default' => [],
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\Valid',
            1 => 'Espo\\Modules\\Crm\\Classes\\FieldValidators\\Event\\Reminders\\MaxCount'
          ]
        ],
        'theme' => (object) [
          'type' => 'enum',
          'view' => 'views/preferences/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => (object) [
          'type' => 'jsonObject'
        ],
        'useCustomTabList' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'addCustomTabs' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'tabList' => (object) [
          'type' => 'array',
          'view' => 'views/preferences/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'mandatoryValidationList' => [
            0 => 'array'
          ]
        ],
        'emailReplyToAllByDefault' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'emailReplyForceHtml' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'isPortalUser' => (object) [
          'type' => 'bool',
          'notStorable' => true
        ],
        'doNotFillAssignedUserIfNotRequired' => (object) [
          'type' => 'bool',
          'tooltip' => true,
          'default' => true
        ],
        'followEntityOnStreamPost' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'followCreatedEntities' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'followCreatedEntityTypeList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/preferences/fields/auto-follow-entity-type-list',
          'translation' => 'Global.scopeNamesPlural',
          'default' => [],
          'tooltip' => true
        ],
        'emailUseExternalClient' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'scopeColorsDisabled' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'tabColorsDisabled' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'textSearchStoringDisabled' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'calendarSlotDuration' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => '',
            1 => 15,
            2 => 30
          ],
          'default' => NULL,
          'view' => 'views/preferences/fields/calendar-slot-duration'
        ],
        'calendarScrollHour' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => '',
            1 => 0,
            2 => 1,
            3 => 2,
            4 => 3,
            5 => 4,
            6 => 5,
            7 => 6,
            8 => 7,
            9 => 8,
            10 => 9,
            11 => 10,
            12 => 11,
            13 => 12,
            14 => 14,
            15 => 15
          ],
          'default' => NULL,
          'view' => 'views/preferences/fields/calendar-scroll-hour'
        ]
      ],
      'noDeletedAttribute' => true,
      'modifierClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\EntityDefsModifiers\\JsonData'
    ],
    'Role' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'maxLength' => 150,
          'required' => true,
          'type' => 'varchar',
          'pattern' => '$noBadCharacters'
        ],
        'assignmentPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'userPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'messagePermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'portalPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'groupEmailAccountPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'exportPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'massUpdatePermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'dataPrivacyPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'followerManagementPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'auditPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'yes',
            2 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'mentionPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'userCalendarPermission' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'not-set',
            1 => 'all',
            2 => 'team',
            3 => 'no'
          ],
          'default' => 'not-set',
          'tooltip' => true,
          'translation' => 'Role.options.levelList',
          'view' => 'views/role/fields/permission',
          'audited' => true
        ],
        'data' => (object) [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'fieldData' => (object) [
          'type' => 'jsonObject',
          'audited' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'roles',
          'audited' => false
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'roles'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'ScheduledJob' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'job' => (object) [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/scheduled-job/fields/job'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Active',
            1 => 'Inactive'
          ],
          'default' => 'Active',
          'audited' => true
        ],
        'scheduling' => (object) [
          'type' => 'varchar',
          'required' => true,
          'view' => 'views/scheduled-job/fields/scheduling',
          'tooltip' => true,
          'audited' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\ScheduledJob\\Scheduling\\Valid'
          ]
        ],
        'lastRun' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'isInternal' => (object) [
          'type' => 'bool',
          'readOnly' => true,
          'disabled' => true,
          'default' => false
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'log' => (object) [
          'type' => 'hasMany',
          'entity' => 'ScheduledJobLogRecord',
          'foreign' => 'scheduledJob'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'jobSchedulingMap' => (object) [
        'CheckInboundEmails' => '*/2 * * * *',
        'CheckEmailAccounts' => '*/1 * * * *',
        'SendEmailReminders' => '*/2 * * * *',
        'Cleanup' => '1 1 * * 0',
        'AuthTokenControl' => '*/6 * * * *',
        'SendEmailNotifications' => '*/2 * * * *',
        'ProcessWebhookQueue' => '*/2 * * * *',
        'SendScheduledEmails' => '*/10 * * * *',
        'ProcessMassEmail' => '10,30,50 * * * *',
        'ControlKnowledgeBaseArticleStatus' => '10 1 * * *',
        'ReportTargetListSync' => '0 2 * * *',
        'ScheduleReportSending' => '0 * * * *',
        'RunScheduledWorkflows' => '*/10 * * * *',
        'ProcessPendingProcessFlows' => '* * * * *',
        'InventoryCompress' => '10 0 * * 6',
        'NotActualOrderLocking' => '10 1 * * 6',
        'InventoryDetach' => '10 2 * * 6'
      ],
      'jobs' => (object) [
        'SubmitPopupReminders' => (object) [
          'name' => 'Submit Popup Reminders',
          'isSystem' => true,
          'scheduling' => '* * * * *'
        ],
        'EblaForm' => (object) [
          'isSystem' => true,
          'scheduling' => '3 3 * * 6'
        ]
      ]
    ],
    'ScheduledJobLogRecord' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'readOnly' => true
        ],
        'status' => (object) [
          'type' => 'enum',
          'readOnly' => true,
          'options' => [
            0 => 'Success',
            1 => 'Failed'
          ],
          'style' => (object) [
            'Success' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'executionTime' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'hasSeconds' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'scheduledJob' => (object) [
          'type' => 'link'
        ],
        'target' => (object) [
          'type' => 'linkParent'
        ]
      ],
      'links' => (object) [
        'scheduledJob' => (object) [
          'type' => 'belongsTo',
          'entity' => 'ScheduledJob'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'executionTime',
        'order' => 'desc',
        'sortBy' => 'executionTime',
        'asc' => false
      ],
      'indexes' => (object) [
        'scheduledJobIdExecutionTime' => (object) [
          'type' => 'index',
          'columns' => [
            0 => 'scheduledJobId',
            1 => 'executionTime'
          ]
        ]
      ]
    ],
    'Settings' => (object) [
      'skipRebuild' => true,
      'fields' => (object) [
        'useCache' => (object) [
          'type' => 'bool',
          'default' => true,
          'tooltip' => true
        ],
        'recordsPerPage' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 200,
          'default' => 20,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageSmall' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'default' => 5,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageSelect' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'default' => 10,
          'required' => true,
          'tooltip' => true
        ],
        'recordsPerPageKanban' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 100,
          'required' => true,
          'tooltip' => true
        ],
        'timeZone' => (object) [
          'type' => 'enum',
          'default' => 'UTC',
          'options' => [
            0 => 'UTC',
            1 => 'Africa/Abidjan',
            2 => 'Africa/Accra',
            3 => 'Africa/Addis_Ababa',
            4 => 'Africa/Algiers',
            5 => 'Africa/Asmara',
            6 => 'Africa/Bamako',
            7 => 'Africa/Bangui',
            8 => 'Africa/Banjul',
            9 => 'Africa/Bissau',
            10 => 'Africa/Blantyre',
            11 => 'Africa/Brazzaville',
            12 => 'Africa/Bujumbura',
            13 => 'Africa/Cairo',
            14 => 'Africa/Casablanca',
            15 => 'Africa/Ceuta',
            16 => 'Africa/Conakry',
            17 => 'Africa/Dakar',
            18 => 'Africa/Dar_es_Salaam',
            19 => 'Africa/Djibouti',
            20 => 'Africa/Douala',
            21 => 'Africa/El_Aaiun',
            22 => 'Africa/Freetown',
            23 => 'Africa/Gaborone',
            24 => 'Africa/Harare',
            25 => 'Africa/Johannesburg',
            26 => 'Africa/Juba',
            27 => 'Africa/Kampala',
            28 => 'Africa/Khartoum',
            29 => 'Africa/Kigali',
            30 => 'Africa/Kinshasa',
            31 => 'Africa/Lagos',
            32 => 'Africa/Libreville',
            33 => 'Africa/Lome',
            34 => 'Africa/Luanda',
            35 => 'Africa/Lubumbashi',
            36 => 'Africa/Lusaka',
            37 => 'Africa/Malabo',
            38 => 'Africa/Maputo',
            39 => 'Africa/Maseru',
            40 => 'Africa/Mbabane',
            41 => 'Africa/Mogadishu',
            42 => 'Africa/Monrovia',
            43 => 'Africa/Nairobi',
            44 => 'Africa/Ndjamena',
            45 => 'Africa/Niamey',
            46 => 'Africa/Nouakchott',
            47 => 'Africa/Ouagadougou',
            48 => 'Africa/Porto-Novo',
            49 => 'Africa/Sao_Tome',
            50 => 'Africa/Tripoli',
            51 => 'Africa/Tunis',
            52 => 'Africa/Windhoek',
            53 => 'America/Adak',
            54 => 'America/Anchorage',
            55 => 'America/Anguilla',
            56 => 'America/Antigua',
            57 => 'America/Araguaina',
            58 => 'America/Argentina/Buenos_Aires',
            59 => 'America/Argentina/Catamarca',
            60 => 'America/Argentina/Cordoba',
            61 => 'America/Argentina/Jujuy',
            62 => 'America/Argentina/La_Rioja',
            63 => 'America/Argentina/Mendoza',
            64 => 'America/Argentina/Rio_Gallegos',
            65 => 'America/Argentina/Salta',
            66 => 'America/Argentina/San_Juan',
            67 => 'America/Argentina/San_Luis',
            68 => 'America/Argentina/Tucuman',
            69 => 'America/Argentina/Ushuaia',
            70 => 'America/Aruba',
            71 => 'America/Asuncion',
            72 => 'America/Atikokan',
            73 => 'America/Bahia',
            74 => 'America/Bahia_Banderas',
            75 => 'America/Barbados',
            76 => 'America/Belem',
            77 => 'America/Belize',
            78 => 'America/Blanc-Sablon',
            79 => 'America/Boa_Vista',
            80 => 'America/Bogota',
            81 => 'America/Boise',
            82 => 'America/Cambridge_Bay',
            83 => 'America/Campo_Grande',
            84 => 'America/Cancun',
            85 => 'America/Caracas',
            86 => 'America/Cayenne',
            87 => 'America/Cayman',
            88 => 'America/Chicago',
            89 => 'America/Chihuahua',
            90 => 'America/Costa_Rica',
            91 => 'America/Creston',
            92 => 'America/Cuiaba',
            93 => 'America/Curacao',
            94 => 'America/Danmarkshavn',
            95 => 'America/Dawson',
            96 => 'America/Dawson_Creek',
            97 => 'America/Denver',
            98 => 'America/Detroit',
            99 => 'America/Dominica',
            100 => 'America/Edmonton',
            101 => 'America/Eirunepe',
            102 => 'America/El_Salvador',
            103 => 'America/Fortaleza',
            104 => 'America/Glace_Bay',
            105 => 'America/Godthab',
            106 => 'America/Goose_Bay',
            107 => 'America/Grand_Turk',
            108 => 'America/Grenada',
            109 => 'America/Guadeloupe',
            110 => 'America/Guatemala',
            111 => 'America/Guayaquil',
            112 => 'America/Guyana',
            113 => 'America/Halifax',
            114 => 'America/Havana',
            115 => 'America/Hermosillo',
            116 => 'America/Indiana/Indianapolis',
            117 => 'America/Indiana/Knox',
            118 => 'America/Indiana/Marengo',
            119 => 'America/Indiana/Petersburg',
            120 => 'America/Indiana/Tell_City',
            121 => 'America/Indiana/Vevay',
            122 => 'America/Indiana/Vincennes',
            123 => 'America/Indiana/Winamac',
            124 => 'America/Inuvik',
            125 => 'America/Iqaluit',
            126 => 'America/Jamaica',
            127 => 'America/Juneau',
            128 => 'America/Kentucky/Louisville',
            129 => 'America/Kentucky/Monticello',
            130 => 'America/Kralendijk',
            131 => 'America/La_Paz',
            132 => 'America/Lima',
            133 => 'America/Los_Angeles',
            134 => 'America/Lower_Princes',
            135 => 'America/Maceio',
            136 => 'America/Managua',
            137 => 'America/Manaus',
            138 => 'America/Marigot',
            139 => 'America/Martinique',
            140 => 'America/Matamoros',
            141 => 'America/Mazatlan',
            142 => 'America/Menominee',
            143 => 'America/Merida',
            144 => 'America/Metlakatla',
            145 => 'America/Mexico_City',
            146 => 'America/Miquelon',
            147 => 'America/Moncton',
            148 => 'America/Monterrey',
            149 => 'America/Montevideo',
            150 => 'America/Montserrat',
            151 => 'America/Nassau',
            152 => 'America/New_York',
            153 => 'America/Nipigon',
            154 => 'America/Nome',
            155 => 'America/Noronha',
            156 => 'America/North_Dakota/Beulah',
            157 => 'America/North_Dakota/Center',
            158 => 'America/North_Dakota/New_Salem',
            159 => 'America/Ojinaga',
            160 => 'America/Panama',
            161 => 'America/Pangnirtung',
            162 => 'America/Paramaribo',
            163 => 'America/Phoenix',
            164 => 'America/Port-au-Prince',
            165 => 'America/Port_of_Spain',
            166 => 'America/Porto_Velho',
            167 => 'America/Puerto_Rico',
            168 => 'America/Rainy_River',
            169 => 'America/Rankin_Inlet',
            170 => 'America/Recife',
            171 => 'America/Regina',
            172 => 'America/Resolute',
            173 => 'America/Rio_Branco',
            174 => 'America/Santa_Isabel',
            175 => 'America/Santarem',
            176 => 'America/Santiago',
            177 => 'America/Santo_Domingo',
            178 => 'America/Sao_Paulo',
            179 => 'America/Scoresbysund',
            180 => 'America/Sitka',
            181 => 'America/St_Barthelemy',
            182 => 'America/St_Johns',
            183 => 'America/St_Kitts',
            184 => 'America/St_Lucia',
            185 => 'America/St_Thomas',
            186 => 'America/St_Vincent',
            187 => 'America/Swift_Current',
            188 => 'America/Tegucigalpa',
            189 => 'America/Thule',
            190 => 'America/Thunder_Bay',
            191 => 'America/Tijuana',
            192 => 'America/Toronto',
            193 => 'America/Tortola',
            194 => 'America/Vancouver',
            195 => 'America/Whitehorse',
            196 => 'America/Winnipeg',
            197 => 'America/Yakutat',
            198 => 'America/Yellowknife',
            199 => 'Antarctica/Casey',
            200 => 'Antarctica/Davis',
            201 => 'Antarctica/DumontDUrville',
            202 => 'Antarctica/Macquarie',
            203 => 'Antarctica/Mawson',
            204 => 'Antarctica/McMurdo',
            205 => 'Antarctica/Palmer',
            206 => 'Antarctica/Rothera',
            207 => 'Antarctica/Syowa',
            208 => 'Antarctica/Vostok',
            209 => 'Arctic/Longyearbyen',
            210 => 'Asia/Aden',
            211 => 'Asia/Almaty',
            212 => 'Asia/Amman',
            213 => 'Asia/Anadyr',
            214 => 'Asia/Aqtau',
            215 => 'Asia/Aqtobe',
            216 => 'Asia/Ashgabat',
            217 => 'Asia/Baghdad',
            218 => 'Asia/Bahrain',
            219 => 'Asia/Baku',
            220 => 'Asia/Bangkok',
            221 => 'Asia/Beirut',
            222 => 'Asia/Bishkek',
            223 => 'Asia/Brunei',
            224 => 'Asia/Choibalsan',
            225 => 'Asia/Chongqing',
            226 => 'Asia/Colombo',
            227 => 'Asia/Damascus',
            228 => 'Asia/Dhaka',
            229 => 'Asia/Dili',
            230 => 'Asia/Dubai',
            231 => 'Asia/Dushanbe',
            232 => 'Asia/Gaza',
            233 => 'Asia/Harbin',
            234 => 'Asia/Hebron',
            235 => 'Asia/Ho_Chi_Minh',
            236 => 'Asia/Hong_Kong',
            237 => 'Asia/Hovd',
            238 => 'Asia/Irkutsk',
            239 => 'Asia/Jakarta',
            240 => 'Asia/Jayapura',
            241 => 'Asia/Jerusalem',
            242 => 'Asia/Kabul',
            243 => 'Asia/Kamchatka',
            244 => 'Asia/Karachi',
            245 => 'Asia/Kashgar',
            246 => 'Asia/Kathmandu',
            247 => 'Asia/Khandyga',
            248 => 'Asia/Kolkata',
            249 => 'Asia/Krasnoyarsk',
            250 => 'Asia/Kuala_Lumpur',
            251 => 'Asia/Kuching',
            252 => 'Asia/Kuwait',
            253 => 'Asia/Macau',
            254 => 'Asia/Magadan',
            255 => 'Asia/Makassar',
            256 => 'Asia/Manila',
            257 => 'Asia/Muscat',
            258 => 'Asia/Nicosia',
            259 => 'Asia/Novokuznetsk',
            260 => 'Asia/Novosibirsk',
            261 => 'Asia/Omsk',
            262 => 'Asia/Oral',
            263 => 'Asia/Phnom_Penh',
            264 => 'Asia/Pontianak',
            265 => 'Asia/Pyongyang',
            266 => 'Asia/Qatar',
            267 => 'Asia/Qyzylorda',
            268 => 'Asia/Rangoon',
            269 => 'Asia/Riyadh',
            270 => 'Asia/Sakhalin',
            271 => 'Asia/Samarkand',
            272 => 'Asia/Seoul',
            273 => 'Asia/Shanghai',
            274 => 'Asia/Singapore',
            275 => 'Asia/Taipei',
            276 => 'Asia/Tashkent',
            277 => 'Asia/Tbilisi',
            278 => 'Asia/Tehran',
            279 => 'Asia/Thimphu',
            280 => 'Asia/Tokyo',
            281 => 'Asia/Ulaanbaatar',
            282 => 'Asia/Urumqi',
            283 => 'Asia/Ust-Nera',
            284 => 'Asia/Vientiane',
            285 => 'Asia/Vladivostok',
            286 => 'Asia/Yakutsk',
            287 => 'Asia/Yekaterinburg',
            288 => 'Asia/Yerevan',
            289 => 'Atlantic/Azores',
            290 => 'Atlantic/Bermuda',
            291 => 'Atlantic/Canary',
            292 => 'Atlantic/Cape_Verde',
            293 => 'Atlantic/Faroe',
            294 => 'Atlantic/Madeira',
            295 => 'Atlantic/Reykjavik',
            296 => 'Atlantic/South_Georgia',
            297 => 'Atlantic/St_Helena',
            298 => 'Atlantic/Stanley',
            299 => 'Australia/Adelaide',
            300 => 'Australia/Brisbane',
            301 => 'Australia/Broken_Hill',
            302 => 'Australia/Currie',
            303 => 'Australia/Darwin',
            304 => 'Australia/Eucla',
            305 => 'Australia/Hobart',
            306 => 'Australia/Lindeman',
            307 => 'Australia/Lord_Howe',
            308 => 'Australia/Melbourne',
            309 => 'Australia/Perth',
            310 => 'Australia/Sydney',
            311 => 'Europe/Amsterdam',
            312 => 'Europe/Andorra',
            313 => 'Europe/Athens',
            314 => 'Europe/Belgrade',
            315 => 'Europe/Berlin',
            316 => 'Europe/Bratislava',
            317 => 'Europe/Brussels',
            318 => 'Europe/Bucharest',
            319 => 'Europe/Budapest',
            320 => 'Europe/Busingen',
            321 => 'Europe/Chisinau',
            322 => 'Europe/Copenhagen',
            323 => 'Europe/Dublin',
            324 => 'Europe/Gibraltar',
            325 => 'Europe/Guernsey',
            326 => 'Europe/Helsinki',
            327 => 'Europe/Isle_of_Man',
            328 => 'Europe/Istanbul',
            329 => 'Europe/Jersey',
            330 => 'Europe/Kaliningrad',
            331 => 'Europe/Kyiv',
            332 => 'Europe/Lisbon',
            333 => 'Europe/Ljubljana',
            334 => 'Europe/London',
            335 => 'Europe/Luxembourg',
            336 => 'Europe/Madrid',
            337 => 'Europe/Malta',
            338 => 'Europe/Mariehamn',
            339 => 'Europe/Minsk',
            340 => 'Europe/Monaco',
            341 => 'Europe/Moscow',
            342 => 'Europe/Oslo',
            343 => 'Europe/Paris',
            344 => 'Europe/Podgorica',
            345 => 'Europe/Prague',
            346 => 'Europe/Riga',
            347 => 'Europe/Rome',
            348 => 'Europe/Samara',
            349 => 'Europe/San_Marino',
            350 => 'Europe/Sarajevo',
            351 => 'Europe/Simferopol',
            352 => 'Europe/Skopje',
            353 => 'Europe/Sofia',
            354 => 'Europe/Stockholm',
            355 => 'Europe/Tallinn',
            356 => 'Europe/Tirane',
            357 => 'Europe/Uzhhorod',
            358 => 'Europe/Vaduz',
            359 => 'Europe/Vatican',
            360 => 'Europe/Vienna',
            361 => 'Europe/Vilnius',
            362 => 'Europe/Volgograd',
            363 => 'Europe/Warsaw',
            364 => 'Europe/Zagreb',
            365 => 'Europe/Zaporizhzhia',
            366 => 'Europe/Zurich',
            367 => 'Indian/Antananarivo',
            368 => 'Indian/Chagos',
            369 => 'Indian/Christmas',
            370 => 'Indian/Cocos',
            371 => 'Indian/Comoro',
            372 => 'Indian/Kerguelen',
            373 => 'Indian/Mahe',
            374 => 'Indian/Maldives',
            375 => 'Indian/Mauritius',
            376 => 'Indian/Mayotte',
            377 => 'Indian/Reunion',
            378 => 'Pacific/Apia',
            379 => 'Pacific/Auckland',
            380 => 'Pacific/Chatham',
            381 => 'Pacific/Chuuk',
            382 => 'Pacific/Easter',
            383 => 'Pacific/Efate',
            384 => 'Pacific/Enderbury',
            385 => 'Pacific/Fakaofo',
            386 => 'Pacific/Fiji',
            387 => 'Pacific/Funafuti',
            388 => 'Pacific/Galapagos',
            389 => 'Pacific/Gambier',
            390 => 'Pacific/Guadalcanal',
            391 => 'Pacific/Guam',
            392 => 'Pacific/Honolulu',
            393 => 'Pacific/Johnston',
            394 => 'Pacific/Kiritimati',
            395 => 'Pacific/Kosrae',
            396 => 'Pacific/Kwajalein',
            397 => 'Pacific/Majuro',
            398 => 'Pacific/Marquesas',
            399 => 'Pacific/Midway',
            400 => 'Pacific/Nauru',
            401 => 'Pacific/Niue',
            402 => 'Pacific/Norfolk',
            403 => 'Pacific/Noumea',
            404 => 'Pacific/Pago_Pago',
            405 => 'Pacific/Palau',
            406 => 'Pacific/Pitcairn',
            407 => 'Pacific/Pohnpei',
            408 => 'Pacific/Port_Moresby',
            409 => 'Pacific/Rarotonga',
            410 => 'Pacific/Saipan',
            411 => 'Pacific/Tahiti',
            412 => 'Pacific/Tarawa',
            413 => 'Pacific/Tongatapu',
            414 => 'Pacific/Wake',
            415 => 'Pacific/Wallis'
          ],
          'global' => true
        ],
        'dateFormat' => (object) [
          'type' => 'enum',
          'default' => 'DD.MM.YYYY',
          'view' => 'views/settings/fields/date-format',
          'global' => true
        ],
        'timeFormat' => (object) [
          'type' => 'enum',
          'default' => 'HH:mm',
          'view' => 'views/settings/fields/time-format',
          'global' => true
        ],
        'weekStart' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => 0,
            1 => 1,
            2 => 2,
            3 => 3,
            4 => 4,
            5 => 5,
            6 => 6
          ],
          'default' => 0,
          'translation' => 'Global.lists.dayNames'
        ],
        'fiscalYearShift' => (object) [
          'type' => 'enumInt',
          'default' => 0,
          'view' => 'views/settings/fields/fiscal-year-shift'
        ],
        'thousandSeparator' => (object) [
          'type' => 'varchar',
          'default' => ',',
          'maxLength' => 1,
          'view' => 'views/settings/fields/thousand-separator',
          'options' => [
            0 => '.',
            1 => ',',
            2 => '\''
          ],
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\ThousandSeparator\\Valid'
          ]
        ],
        'decimalMark' => (object) [
          'type' => 'varchar',
          'default' => '.',
          'required' => true,
          'maxLength' => 1,
          'options' => [
            0 => '.',
            1 => ','
          ]
        ],
        'currencyList' => (object) [
          'type' => 'multiEnum',
          'default' => [
            0 => 'USD',
            1 => 'EUR'
          ],
          'required' => true,
          'view' => 'views/settings/fields/currency-list',
          'tooltip' => true,
          'global' => true
        ],
        'defaultCurrency' => (object) [
          'type' => 'enum',
          'default' => 'USD',
          'required' => true,
          'view' => 'views/settings/fields/default-currency',
          'global' => true
        ],
        'baseCurrency' => (object) [
          'type' => 'enum',
          'default' => 'USD',
          'required' => true,
          'view' => 'views/settings/fields/default-currency'
        ],
        'currencyRates' => (object) [
          'type' => 'base',
          'view' => 'views/settings/fields/currency-rates'
        ],
        'outboundEmailIsShared' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'outboundEmailFromName' => (object) [
          'type' => 'varchar',
          'default' => 'Partners'
        ],
        'outboundEmailFromAddress' => (object) [
          'type' => 'varchar',
          'default' => 'crm@example.com',
          'tooltip' => true,
          'view' => 'views/settings/fields/outbound-email-from-address'
        ],
        'emailAddressLookupEntityTypeList' => (object) [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/email-address-lookup-entity-type-list'
        ],
        'emailAddressSelectEntityTypeList' => (object) [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/email-address-lookup-entity-type-list'
        ],
        'smtpServer' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'smtpPort' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 65535,
          'default' => 587
        ],
        'smtpAuth' => (object) [
          'type' => 'bool'
        ],
        'smtpSecurity' => (object) [
          'type' => 'enum',
          'default' => 'TLS',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'smtpUsername' => (object) [
          'type' => 'varchar'
        ],
        'smtpPassword' => (object) [
          'type' => 'password'
        ],
        'tabList' => (object) [
          'type' => 'array',
          'view' => 'views/settings/fields/tab-list',
          'validationList' => [
            0 => 'array',
            1 => 'required'
          ],
          'mandatoryValidationList' => [
            0 => 'array'
          ]
        ],
        'quickCreateList' => (object) [
          'type' => 'array',
          'translation' => 'Global.scopeNames',
          'view' => 'views/settings/fields/quick-create-list'
        ],
        'language' => (object) [
          'type' => 'enum',
          'default' => 'en_US',
          'view' => 'views/settings/fields/language',
          'isSorted' => true
        ],
        'globalSearchEntityList' => (object) [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNames',
          'view' => 'views/settings/fields/global-search-entity-list',
          'tooltip' => true
        ],
        'exportDelimiter' => (object) [
          'type' => 'varchar',
          'default' => ',',
          'required' => true,
          'maxLength' => 1
        ],
        'companyLogo' => (object) [
          'type' => 'image'
        ],
        'authenticationMethod' => (object) [
          'type' => 'enum',
          'default' => 'Espo',
          'view' => 'views/settings/fields/authentication-method'
        ],
        'auth2FA' => (object) [
          'type' => 'bool'
        ],
        'auth2FAMethodList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/auth-two-fa-method-list'
        ],
        'auth2FAForced' => (object) [
          'type' => 'bool'
        ],
        'auth2FAInPortal' => (object) [
          'type' => 'bool'
        ],
        'passwordRecoveryDisabled' => (object) [
          'type' => 'bool'
        ],
        'passwordRecoveryForAdminDisabled' => (object) [
          'type' => 'bool'
        ],
        'passwordRecoveryForInternalUsersDisabled' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'passwordRecoveryNoExposure' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'passwordGenerateLength' => (object) [
          'type' => 'int',
          'min' => 6,
          'max' => 150,
          'required' => true
        ],
        'passwordStrengthLength' => (object) [
          'type' => 'int',
          'max' => 150,
          'min' => 1
        ],
        'passwordStrengthLetterCount' => (object) [
          'type' => 'int',
          'max' => 150,
          'min' => 0
        ],
        'passwordStrengthNumberCount' => (object) [
          'type' => 'int',
          'max' => 150,
          'min' => 0
        ],
        'passwordStrengthSpecialCharacterCount' => (object) [
          'type' => 'int',
          'max' => 50,
          'min' => 0
        ],
        'passwordStrengthBothCases' => (object) [
          'type' => 'bool'
        ],
        'ldapHost' => (object) [
          'type' => 'varchar'
        ],
        'ldapPort' => (object) [
          'type' => 'varchar',
          'default' => 389
        ],
        'ldapSecurity' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'SSL',
            2 => 'TLS'
          ]
        ],
        'ldapAuth' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapUsername' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapPassword' => (object) [
          'type' => 'password',
          'tooltip' => true
        ],
        'ldapBindRequiresDn' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapUserLoginFilter' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapBaseDn' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountCanonicalForm' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Dn',
            1 => 'Username',
            2 => 'Backslash',
            3 => 'Principal'
          ],
          'tooltip' => true
        ],
        'ldapAccountDomainName' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountDomainNameShort' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapAccountFilterFormat' => (object) [
          'type' => 'varchar'
        ],
        'ldapTryUsernameSplit' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapOptReferrals' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'ldapPortalUserLdapAuth' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'ldapCreateEspoUser' => (object) [
          'type' => 'bool',
          'default' => true,
          'tooltip' => true
        ],
        'ldapUserNameAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserObjectClass' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserFirstNameAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserLastNameAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserTitleAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserEmailAddressAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserPhoneNumberAttribute' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'ldapUserDefaultTeam' => (object) [
          'type' => 'link',
          'tooltip' => true,
          'entity' => 'Team'
        ],
        'ldapUserTeams' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'Team'
        ],
        'ldapPortalUserPortals' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'Portal'
        ],
        'ldapPortalUserRoles' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'entity' => 'PortalRole'
        ],
        'exportDisabled' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'emailNotificationsDelay' => (object) [
          'type' => 'int',
          'min' => 0,
          'max' => 18000,
          'tooltip' => true
        ],
        'assignmentEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'assignmentEmailNotificationsEntityList' => (object) [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/assignment-email-notifications-entity-list'
        ],
        'assignmentNotificationsEntityList' => (object) [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/assignment-notifications-entity-list'
        ],
        'postEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'updateEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'mentionEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'streamEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'portalStreamEmailNotifications' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'streamEmailNotificationsEntityList' => (object) [
          'type' => 'multiEnum',
          'translation' => 'Global.scopeNamesPlural',
          'view' => 'views/settings/fields/stream-email-notifications-entity-list',
          'tooltip' => true
        ],
        'streamEmailNotificationsTypeList' => (object) [
          'type' => 'multiEnum',
          'options' => [
            0 => 'Post',
            1 => 'Status',
            2 => 'EmailReceived'
          ]
        ],
        'streamEmailWithContentEntityTypeList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/stream-email-with-content-entity-type-list'
        ],
        'newNotificationCountInTitle' => (object) [
          'type' => 'bool'
        ],
        'b2cMode' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'avatarsDisabled' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'followCreatedEntities' => (object) [
          'type' => 'bool',
          'default' => false,
          'tooltip' => true
        ],
        'adminPanelIframeUrl' => (object) [
          'type' => 'varchar'
        ],
        'displayListViewRecordCount' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'userThemesDisabled' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'theme' => (object) [
          'type' => 'enum',
          'view' => 'views/settings/fields/theme',
          'translation' => 'Global.themes'
        ],
        'themeParams' => (object) [
          'type' => 'jsonObject'
        ],
        'attachmentUploadMaxSize' => (object) [
          'type' => 'float',
          'min' => 0
        ],
        'attachmentUploadChunkSize' => (object) [
          'type' => 'float',
          'min' => 0
        ],
        'emailMessageMaxSize' => (object) [
          'type' => 'float',
          'min' => 0,
          'tooltip' => true
        ],
        'inboundEmailMaxPortionSize' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 500
        ],
        'personalEmailMaxPortionSize' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 500
        ],
        'maxEmailAccountCount' => (object) [
          'type' => 'int'
        ],
        'massEmailMaxPerHourCount' => (object) [
          'type' => 'int',
          'min' => 1,
          'required' => true
        ],
        'massEmailMaxPerBatchCount' => (object) [
          'type' => 'int',
          'min' => 1
        ],
        'massEmailVerp' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'emailScheduledBatchCount' => (object) [
          'type' => 'int',
          'min' => 1,
          'required' => true
        ],
        'authTokenLifetime' => (object) [
          'type' => 'float',
          'min' => 0,
          'default' => 0,
          'tooltip' => true
        ],
        'authTokenMaxIdleTime' => (object) [
          'type' => 'float',
          'min' => 0,
          'default' => 0,
          'tooltip' => true
        ],
        'authTokenPreventConcurrent' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'dashboardLayout' => (object) [
          'type' => 'jsonArray',
          'view' => 'views/settings/fields/dashboard-layout'
        ],
        'dashletsOptions' => (object) [
          'type' => 'jsonObject',
          'disabled' => true
        ],
        'siteUrl' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'applicationName' => (object) [
          'type' => 'varchar'
        ],
        'readableDateFormatDisabled' => (object) [
          'type' => 'bool'
        ],
        'addressFormat' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => 1,
            1 => 2,
            2 => 3,
            3 => 4
          ]
        ],
        'addressPreview' => (object) [
          'type' => 'address',
          'notStorable' => true,
          'readOnly' => true,
          'view' => 'views/settings/fields/address-preview'
        ],
        'personNameFormat' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'firstLast',
            1 => 'lastFirst',
            2 => 'firstMiddleLast',
            3 => 'lastFirstMiddle'
          ]
        ],
        'currencyFormat' => (object) [
          'type' => 'enumInt',
          'options' => [
            0 => 1,
            1 => 2,
            2 => 3
          ]
        ],
        'currencyDecimalPlaces' => (object) [
          'type' => 'int',
          'tooltip' => true,
          'min' => 0,
          'max' => 20,
          'global' => true
        ],
        'notificationSoundsDisabled' => (object) [
          'type' => 'bool'
        ],
        'calendarEntityList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/calendar-entity-list',
          'tooltip' => true
        ],
        'activitiesEntityList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/activities-entity-list',
          'tooltip' => true
        ],
        'historyEntityList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/history-entity-list',
          'tooltip' => true
        ],
        'busyRangesEntityList' => (object) [
          'type' => 'multiEnum',
          'tooltip' => true,
          'view' => 'views/settings/fields/busy-ranges-entity-list'
        ],
        'googleMapsApiKey' => (object) [
          'type' => 'varchar'
        ],
        'massEmailDisableMandatoryOptOutLink' => (object) [
          'type' => 'bool'
        ],
        'massEmailOpenTracking' => (object) [
          'type' => 'bool'
        ],
        'aclAllowDeleteCreated' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'lastViewedCount' => (object) [
          'type' => 'int',
          'min' => 1,
          'max' => 200,
          'default' => 20,
          'required' => true
        ],
        'adminNotifications' => (object) [
          'type' => 'bool'
        ],
        'adminNotificationsNewVersion' => (object) [
          'type' => 'bool'
        ],
        'adminNotificationsNewExtensionVersion' => (object) [
          'type' => 'bool'
        ],
        'textFilterUseContainsForVarchar' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'phoneNumberNumericSearch' => (object) [
          'type' => 'bool'
        ],
        'phoneNumberInternational' => (object) [
          'type' => 'bool'
        ],
        'phoneNumberExtensions' => (object) [
          'type' => 'bool'
        ],
        'phoneNumberPreferredCountryList' => (object) [
          'type' => 'multiEnum',
          'view' => 'views/settings/fields/phone-number-preferred-country-list'
        ],
        'scopeColorsDisabled' => (object) [
          'type' => 'bool'
        ],
        'tabColorsDisabled' => (object) [
          'type' => 'bool'
        ],
        'tabIconsDisabled' => (object) [
          'type' => 'bool'
        ],
        'emailAddressIsOptedOutByDefault' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'outboundEmailBccAddress' => (object) [
          'type' => 'varchar',
          'view' => 'views/fields/email-address'
        ],
        'cleanupDeletedRecords' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'addressCityList' => (object) [
          'type' => 'multiEnum',
          'tooltip' => true
        ],
        'addressStateList' => (object) [
          'type' => 'multiEnum',
          'tooltip' => true
        ],
        'jobRunInParallel' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'jobMaxPortion' => (object) [
          'type' => 'int',
          'tooltip' => true
        ],
        'jobPoolConcurrencyNumber' => (object) [
          'type' => 'int',
          'tooltip' => true,
          'min' => 1
        ],
        'jobForceUtc' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'daemonInterval' => (object) [
          'type' => 'int',
          'tooltip' => true
        ],
        'daemonMaxProcessNumber' => (object) [
          'type' => 'int',
          'tooltip' => true,
          'min' => 1
        ],
        'daemonProcessTimeout' => (object) [
          'type' => 'int',
          'tooltip' => true
        ],
        'cronDisabled' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'maintenanceMode' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'useWebSocket' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'awsS3Storage' => (object) [
          'type' => 'jsonObject'
        ],
        'outboundSmsFromNumber' => (object) [
          'type' => 'varchar'
        ],
        'smsProvider' => (object) [
          'type' => 'enum',
          'view' => 'views/settings/fields/sms-provider'
        ],
        'workingTimeCalendar' => (object) [
          'type' => 'link',
          'tooltip' => true,
          'entity' => 'WorkingTimeCalendar'
        ],
        'oidcClientId' => (object) [
          'type' => 'varchar'
        ],
        'oidcClientSecret' => (object) [
          'type' => 'password'
        ],
        'oidcAuthorizationEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcTokenEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwksEndpoint' => (object) [
          'type' => 'url',
          'strip' => false
        ],
        'oidcJwtSignatureAlgorithmList' => (object) [
          'type' => 'multiEnum',
          'options' => [
            0 => 'RS256',
            1 => 'RS384',
            2 => 'RS512',
            3 => 'HS256',
            4 => 'HS384',
            5 => 'HS512'
          ]
        ],
        'oidcScopes' => (object) [
          'type' => 'multiEnum',
          'allowCustomOptions' => true,
          'options' => [
            0 => 'profile',
            1 => 'email',
            2 => 'phone',
            3 => 'address'
          ]
        ],
        'oidcGroupClaim' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcCreateUser' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcUsernameClaim' => (object) [
          'type' => 'varchar',
          'options' => [
            0 => 'sub',
            1 => 'preferred_username',
            2 => 'email'
          ],
          'tooltip' => true
        ],
        'oidcTeams' => (object) [
          'type' => 'linkMultiple',
          'entity' => 'Team',
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'view' => 'views/settings/fields/oidc-teams',
          'tooltip' => true
        ],
        'oidcSync' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcSyncTeams' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcFallback' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'oidcAllowRegularUserFallback' => (object) [
          'type' => 'bool'
        ],
        'oidcAllowAdminUser' => (object) [
          'type' => 'bool'
        ],
        'oidcLogoutUrl' => (object) [
          'type' => 'varchar',
          'tooltip' => true
        ],
        'oidcAuthorizationPrompt' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'none',
            1 => 'consent',
            2 => 'login',
            3 => 'select_account'
          ]
        ],
        'pdfEngine' => (object) [
          'type' => 'enum',
          'view' => 'views/settings/fields/pdf-engine'
        ],
        'quickSearchFullTextAppendWildcard' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'authIpAddressCheck' => (object) [
          'type' => 'bool'
        ],
        'authIpAddressWhitelist' => (object) [
          'type' => 'array',
          'allowCustomOptions' => true,
          'noEmptyString' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\AuthIpAddressWhitelist\\Valid'
          ],
          'tooltip' => true
        ],
        'authIpAddressCheckExcludedUsers' => (object) [
          'type' => 'linkMultiple',
          'entity' => 'User',
          'tooltip' => true
        ],
        'availableReactions' => (object) [
          'type' => 'array',
          'maxCount' => 9,
          'view' => 'views/settings/fields/available-reactions',
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\Settings\\AvailableReactions\\Valid'
          ]
        ],
        'defaultPriceBook' => (object) [
          'type' => 'link',
          'entity' => 'PriceBook'
        ],
        'priceBooksEnabled' => (object) [
          'type' => 'bool'
        ],
        'inventoryTransactionsEnabled' => (object) [
          'type' => 'bool'
        ],
        'deliveryOrdersEnabled' => (object) [
          'type' => 'bool'
        ],
        'receiptOrdersEnabled' => (object) [
          'type' => 'bool'
        ],
        'warehousesEnabled' => (object) [
          'type' => 'bool'
        ],
        'salesForbidOrderUnlock' => (object) [
          'type' => 'bool',
          'tooltip' => true
        ],
        'eInvoiceFormat' => (object) [
          'type' => 'enum',
          'view' => 'sales:views/settings/fields/e-invoice-format',
          'translation' => 'Invoice.options.eInvoiceFormats'
        ],
        'sellerCompanyName' => (object) [
          'type' => 'varchar',
          'maxLength' => 150
        ],
        'sellerElectronicAddressScheme' => (object) [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'sellerElectronicAddressIdentifier' => (object) [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'sellerTaxRegistrationScheme' => (object) [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'sellerTaxRegistrationIdentifier' => (object) [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'sellerVatNumber' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'sellerAddress' => (object) [
          'type' => 'address'
        ],
        'sellerContactName' => (object) [
          'type' => 'varchar',
          'maxLength' => 150
        ],
        'sellerContactEmailAddress' => (object) [
          'type' => 'varchar',
          'maxLength' => 255,
          'view' => 'views/fields/email-address'
        ],
        'sellerContactPhoneNumber' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$phoneNumberLoose'
        ],
        'reCaptchaSiteKey' => (object) [
          'global' => true,
          'type' => 'varchar'
        ],
        'reCaptchaSecretKey' => (object) [
          'global' => true,
          'type' => 'varchar'
        ],
        'addressPreviewStreet' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'addressPreviewCity' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewState' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewCountry' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewPostalCode' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'addressPreviewMap' => (object) [
          'notStorable' => true,
          'readOnly' => true,
          'type' => 'map',
          'orderDisabled' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'sellerAddressStreet' => (object) [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'sellerAddressCity' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressState' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressCountry' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressPostalCode' => (object) [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'sellerAddressMap' => (object) [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ]
      ]
    ],
    'Sms' => (object) [
      'fields' => (object) [
        'from' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'fromName' => (object) [
          'type' => 'varchar'
        ],
        'to' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'required' => true,
          'textFilterDisabled' => true
        ],
        'fromPhoneNumber' => (object) [
          'type' => 'link',
          'textFilterDisabled' => true
        ],
        'toPhoneNumbers' => (object) [
          'type' => 'linkMultiple'
        ],
        'body' => (object) [
          'type' => 'text'
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Draft',
            1 => 'Sending',
            2 => 'Sent',
            3 => 'Archived',
            4 => 'Failed'
          ],
          'default' => 'Archived',
          'clientReadOnly' => true,
          'style' => (object) [
            'Draft' => 'warning',
            'Failed' => 'danger',
            'Sending' => 'warning'
          ]
        ],
        'parent' => (object) [
          'type' => 'linkParent'
        ],
        'dateSent' => (object) [
          'type' => 'datetime'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user'
        ],
        'replied' => (object) [
          'type' => 'link',
          'noJoin' => true,
          'readOnly' => true,
          'view' => 'views/email/fields/replied'
        ],
        'replies' => (object) [
          'type' => 'linkMultiple',
          'readOnly' => true,
          'orderBy' => 'dateSent',
          'view' => 'views/email/fields/replies'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Account',
            1 => 'Contact',
            2 => 'Lead',
            3 => 'Opportunity'
          ],
          'foreign' => 'emails'
        ],
        'replied' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Sms',
          'foreign' => 'replies',
          'foreignName' => 'id'
        ],
        'replies' => (object) [
          'type' => 'hasMany',
          'entity' => 'Sms',
          'foreign' => 'replied'
        ],
        'fromPhoneNumber' => (object) [
          'type' => 'belongsTo',
          'entity' => 'PhoneNumber'
        ],
        'toPhoneNumbers' => (object) [
          'type' => 'hasMany',
          'entity' => 'PhoneNumber',
          'relationName' => 'smsPhoneNumber',
          'conditions' => (object) [
            'addressType' => 'to'
          ],
          'additionalColumns' => (object) [
            'addressType' => (object) [
              'type' => 'varchar',
              'len' => '4'
            ]
          ]
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'dateSent',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'body'
        ],
        'sortBy' => 'dateSent',
        'asc' => false
      ],
      'indexes' => (object) [
        'dateSent' => (object) [
          'columns' => [
            0 => 'dateSent',
            1 => 'deleted'
          ]
        ],
        'dateSentStatus' => (object) [
          'columns' => [
            0 => 'dateSent',
            1 => 'status',
            2 => 'deleted'
          ]
        ]
      ]
    ],
    'StarSubscription' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => (object) [
          'type' => 'linkParent'
        ],
        'user' => (object) [
          'type' => 'link'
        ],
        'createdAt' => (object) [
          'type' => 'datetime'
        ]
      ],
      'indexes' => (object) [
        'userEntity' => (object) [
          'unique' => true,
          'columns' => [
            0 => 'userId',
            1 => 'entityId',
            2 => 'entityType'
          ]
        ],
        'userEntityType' => (object) [
          'columns' => [
            0 => 'userId',
            1 => 'entityType'
          ]
        ]
      ]
    ],
    'StreamSubscription' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'bigint',
          'autoincrement' => true
        ],
        'entity' => (object) [
          'type' => 'linkParent'
        ],
        'user' => (object) [
          'type' => 'link'
        ]
      ],
      'indexes' => (object) [
        'userEntity' => (object) [
          'columns' => [
            0 => 'userId',
            1 => 'entityId',
            2 => 'entityType'
          ]
        ]
      ]
    ],
    'SystemData' => (object) [
      'fields' => (object) [
        'id' => (object) [
          'type' => 'id',
          'dbType' => 'string',
          'maxLength' => 1
        ],
        'lastPasswordRecoveryDate' => (object) [
          'type' => 'datetime'
        ]
      ]
    ],
    'Team' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'audited' => true
        ],
        'roles' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'audited' => true
        ],
        'positionList' => (object) [
          'type' => 'array',
          'displayAsList' => true,
          'tooltip' => true,
          'audited' => true
        ],
        'userRole' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'utility' => true
        ],
        'layoutSet' => (object) [
          'type' => 'link',
          'tooltip' => true,
          'audited' => true
        ],
        'workingTimeCalendar' => (object) [
          'type' => 'link',
          'tooltip' => true,
          'audited' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'users' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'teams',
          'columnAttributeMap' => (object) [
            'role' => 'userRole'
          ],
          'audited' => false
        ],
        'roles' => (object) [
          'type' => 'hasMany',
          'entity' => 'Role',
          'foreign' => 'teams'
        ],
        'notes' => (object) [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'teams'
        ],
        'inboundEmails' => (object) [
          'type' => 'hasMany',
          'entity' => 'InboundEmail',
          'foreign' => 'teams'
        ],
        'layoutSet' => (object) [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'foreign' => 'teams'
        ],
        'workingTimeCalendar' => (object) [
          'type' => 'belongsTo',
          'entity' => 'WorkingTimeCalendar',
          'foreign' => 'teams'
        ],
        'groupEmailFolders' => (object) [
          'type' => 'hasMany',
          'entity' => 'GroupEmailFolder',
          'foreign' => 'teams'
        ],
        'manualWorkflows' => (object) [
          'type' => 'hasMany',
          'entity' => 'Workflow',
          'foreign' => 'manualTeams'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'Template' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'pattern' => '$noBadCharacters'
        ],
        'body' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body'
        ],
        'header' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body'
        ],
        'footer' => (object) [
          'type' => 'wysiwyg',
          'view' => 'views/template/fields/body',
          'tooltip' => true
        ],
        'entityType' => (object) [
          'type' => 'enum',
          'required' => true,
          'translation' => 'Global.scopeNames',
          'view' => 'views/template/fields/entity-type'
        ],
        'leftMargin' => (object) [
          'type' => 'float',
          'default' => 10
        ],
        'rightMargin' => (object) [
          'type' => 'float',
          'default' => 10
        ],
        'topMargin' => (object) [
          'type' => 'float',
          'default' => 10
        ],
        'bottomMargin' => (object) [
          'type' => 'float',
          'default' => 20
        ],
        'printFooter' => (object) [
          'type' => 'bool',
          'inlineEditDisabled' => true
        ],
        'printHeader' => (object) [
          'type' => 'bool',
          'inlineEditDisabled' => true
        ],
        'footerPosition' => (object) [
          'type' => 'float',
          'default' => 10,
          'min' => NULL,
          'max' => NULL
        ],
        'headerPosition' => (object) [
          'type' => 'float',
          'default' => 0
        ],
        'style' => (object) [
          'type' => 'text',
          'view' => 'views/template/fields/style'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'variables' => (object) [
          'type' => 'base',
          'notStorable' => true,
          'tooltip' => true
        ],
        'pageOrientation' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Portrait',
            1 => 'Landscape'
          ],
          'default' => 'Portrait',
          'style' => (object) [
            'Portrait' => NULL,
            'Landscape' => NULL
          ]
        ],
        'pageFormat' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'A3',
            1 => 'A4',
            2 => 'A5',
            3 => 'A6',
            4 => 'A7',
            5 => 'Custom'
          ],
          'default' => 'A4',
          'style' => (object) [
            'A3' => NULL,
            'A4' => NULL,
            'A5' => NULL,
            'A6' => NULL,
            'A7' => NULL,
            'Custom' => NULL
          ]
        ],
        'pageWidth' => (object) [
          'type' => 'float',
          'min' => 1,
          'default' => NULL,
          'max' => NULL
        ],
        'pageHeight' => (object) [
          'type' => 'float',
          'min' => 1,
          'default' => NULL,
          'max' => NULL
        ],
        'fontFace' => (object) [
          'type' => 'enum',
          'view' => 'views/template/fields/font-face'
        ],
        'title' => (object) [
          'type' => 'varchar'
        ]
      ],
      'links' => (object) [
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam'
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'sortBy' => 'name',
        'asc' => true
      ],
      'optimisticConcurrencyControl' => true,
      'defaultTemplates' => (object) [
        'Report' => (object) [
          'body' => '<h1>{{name}}</h1><br>{{reportTable border=1 borderColor="#333" cellpadding=2}}',
          'footer' => '<div style="text-align: center;"><span style="font-size: 10px;">{pageNumber}</span></div>'
        ],
        'Quote' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Quote</span></p>
        <p>Date: {{dateQuoted}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'SalesOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Sales Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'Invoice' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{billingAddressStreet}}}
           <br>
           {{billingAddressCity}}{{#if billingAddressState}},{{/if}} {{billingAddressState}} {{billingAddressPostalCode}}<br>{{billingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Invoice</span></p>
        <p>Date: {{dateInvoiced}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
  <th width="16%" align="left">List Price</th>
  <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
  <td align="right">{{listPrice}}</td>
  <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="6">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="6">&nbsp;</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Pre-Discounted Amount</td>
   <td align="right">{{preDiscountedAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Discount Amount</td>
   <td align="right">{{discountAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="5" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p>{{#if dateDue}}Due date: {{dateDue}}{{else}}<br>{{/if}}</p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'PurchaseOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{supplierName}}
         </p>
         <p>
           {{{supplierAddressStreet}}}
           <br>
           {{supplierAddressCity}}{{#if supplierAddressState}},{{/if}} {{supplierAddressState}} {{supplierAddressPostalCode}}<br>{{supplierAddressCountry}}
         </p>
       </td>
       <td style="width: 50%; vertical-align: top; text-align: right;">
         <p><span style="font-size: 1.2em;">Purchase Order</span></p>
         <p>Date: {{dateOrdered}}</p>
         <p>
           Ship to
         </p>
         <p>
           {{{shippingAddressStreet}}}
           <br>
           {{shippingAddressCity}}{{#if shippingAddressState}},{{/if}} {{shippingAddressState}} {{shippingAddressPostalCode}}<br>{{shippingAddressCountry}}
         </p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>
<p>Currency: {{amountCurrency}}</p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
   <th width="16%" align="left">Unit Price</th>
  <th width="16%" align="left">Amount</th>
 </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   <td align="right">{{unitPrice}}</td>
  <td align="right">{{amount}}</td>
 </tr>
<!-- {{#if description}} -->
<tr><td colspan="4">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> <tr>
   <td colspan="5">&nbsp;</td>
 </tr>
  <tr><td colspan="4" align="right">Amount</td>
   <td align="right">{{amount}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Tax Amount</td>
   <td align="right">{{taxAmount}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Shipping Cost</td>
   <td align="right">{{shippingCost}}</td>
 </tr>
 <tr>
   <td colspan="4" align="right">Grand Total Amount</td>
   <td align="right"><b>{{grandTotalAmount}}</b></td>
 </tr>
</tbody>
</table>
<p><br></p>
<p align="center">Thank you for your business.</p>',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'DeliveryOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
           {{{shippingAddressStreet}}}
           <br>
           {{shippingAddressCity}}{{#if shippingAddressState}},{{/if}} {{shippingAddressState}} {{shippingAddressPostalCode}}<br>{{shippingAddressCountry}}
         </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Delivery Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'ReceiptOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{supplierName}}
         </p>
         <p>
          {{shippingProviderName}}
           </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Receipt Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'TransferOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Transfer Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>

<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         From
       </td>
       <td style="width: 50%; vertical-align: top;">
         To
       </td>
     </tr>
     <tr>
       <td style="vertical-align: top;">
         {{fromWarehouseName}}
       </td>
       <td style="width: 50%; vertical-align: top;">
         {{toWarehouseName}}
       </td>
     </tr>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p>
           {{{fromAddressStreet}}}
           <br>
           {{fromAddressCity}}{{#if fromAddressState}},{{/if}} {{fromAddressState}} {{fromAddressPostalCode}}<br>{{fromAddressCountry}}
         </p>
       </td>
       <td style="width: 50%; vertical-align: top;">
         <p>
           {{{toAddressStreet}}}
           <br>
           {{toAddressCity}}{{#if toAddressState}},{{/if}} {{toAddressState}} {{toAddressPostalCode}}<br>{{toAddressCountry}}
         </p>
       </td>
     </tr>
  </tbody>
</table>

<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ],
        'ReturnOrder' => (object) [
          'body' => '<table style="line-height: 1.36; width: 100%;">
  <tbody>
     <tr>
       <td style="width: 50%; vertical-align: top;">
         <p><span style="font-size: 1.4em;">Company Name</span></p>
         <p><br></p>
         <p>
           {{accountName}}
         </p>
         <p>
          {{shippingProviderName}}
           </p>
      </td>
      <td style="width: 50%; vertical-align: top; text-align: right;">
        <p><span style="font-size: 1.2em;">Return Order</span></p>
        <p>Date: {{dateOrdered}}</p>
      </td>
    </tr>
  </tbody>
</table>
<p><span style="font-size: 1.2em;">{{name}}</span></p>

<table style="border: 0.5pt; border-spacing: 0; border-collapse: collapse; width: 100%;" cellpadding="2" border="0.5pt">
<tbody>
 <tr>
  <th width="5%" align="left">#</th>
  <th width="37%" align="left">Name</th>
  <th width="8%" align="left">Qty</th>
    </tr>
 <!-- {{#each itemList}} --> <tr>
  <td>{{order}}</td>
  <td>{{name}}</td>
  <td>{{quantity}}</td>
   </tr>
<!-- {{#if description}} -->
<tr><td colspan="2">{{{description}}}</td></tr>
<!-- {{/if}} -->
<!-- {{/each}} --> 
</tbody>
</table>
<p><br></p>
',
          'footer' => '<div style="width: 100%; text-align: center;"><span style="font-size: 0.8em">{pageNumber}</span></div>'
        ]
      ]
    ],
    'TwoFactorCode' => (object) [
      'fields' => (object) [
        'code' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'method' => (object) [
          'type' => 'varchar',
          'maxLength' => 100
        ],
        'attemptsLeft' => (object) [
          'type' => 'int'
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'indexes' => (object) [
        'createdAt' => (object) [
          'columns' => [
            0 => 'createdAt'
          ]
        ],
        'userIdMethod' => (object) [
          'columns' => [
            0 => 'userId',
            1 => 'method'
          ]
        ],
        'userIdMethodIsActive' => (object) [
          'columns' => [
            0 => 'userId',
            1 => 'method',
            2 => 'isActive'
          ]
        ],
        'userIdMethodCreatedAt' => (object) [
          'columns' => [
            0 => 'userId',
            1 => 'method',
            2 => 'createdAt'
          ]
        ]
      ]
    ],
    'UniqueId' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true,
          'index' => true
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'terminateAt' => (object) [
          'type' => 'datetime'
        ],
        'target' => (object) [
          'type' => 'linkParent'
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'target' => (object) [
          'type' => 'belongsToParent'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'hooksDisabled' => true
    ],
    'User' => (object) [
      'fields' => (object) [
        'userName' => (object) [
          'type' => 'varchar',
          'maxLength' => 50,
          'required' => true,
          'view' => 'views/user/fields/user-name',
          'tooltip' => true,
          'fieldManagerParamList' => [
            0 => 'maxLength',
            1 => 'tooltipText',
            2 => 'inlineEditDisabled'
          ],
          'index' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\User\\UserName\\Valid'
          ],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'name' => (object) [
          'type' => 'personName',
          'view' => 'views/user/fields/name',
          'dependeeAttributeList' => [
            0 => 'userName'
          ],
          'dynamicLogicVisibleDisabled' => true
        ],
        'type' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'regular',
            1 => 'admin',
            2 => 'portal',
            3 => 'system',
            4 => 'super-admin',
            5 => 'api'
          ],
          'default' => 'regular',
          'maxLength' => 24,
          'index' => true,
          'inlineEditDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'style' => (object) [
            'regular' => NULL,
            'admin' => NULL,
            'portal' => NULL,
            'system' => NULL,
            'super-admin' => NULL,
            'api' => NULL
          ]
        ],
        'password' => (object) [
          'type' => 'password',
          'maxLength' => 150,
          'internal' => true,
          'utility' => true,
          'directAccessDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'orderDisabled' => true
        ],
        'passwordConfirm' => (object) [
          'type' => 'password',
          'maxLength' => 150,
          'internal' => true,
          'utility' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'fieldManagerParamList' => []
        ],
        'authMethod' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'ApiKey',
            2 => 'Hmac'
          ],
          'maxLength' => 24,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'style' => (object) [
            'ApiKey' => NULL,
            'Hmac' => NULL
          ],
          'default' => 'ApiKey'
        ],
        'apiKey' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'copyToClipboard' => true,
          'dynamicLogicVisibleDisabled' => true,
          'orderDisabled' => true
        ],
        'secretKey' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'notStorable' => true,
          'orderDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ],
          'copyToClipboard' => true,
          'dynamicLogicVisibleDisabled' => true,
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'salutationName' => (object) [
          'type' => 'enum',
          'customizationOptionsReferenceDisabled' => true,
          'options' => [
            0 => '',
            1 => 'Mr.',
            2 => 'Ms.',
            3 => 'Mrs.',
            4 => 'Dr.'
          ]
        ],
        'firstName' => (object) [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100,
          'suppressValidationList' => [
            0 => 'required'
          ]
        ],
        'lastName' => (object) [
          'type' => 'varchar',
          'pattern' => '$noBadCharacters',
          'maxLength' => 100,
          'required' => false,
          'suppressValidationList' => [
            0 => 'required'
          ],
          'default' => NULL,
          'options' => []
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'default' => true,
          'customizationAuditedDisabled' => true,
          'audited' => true
        ],
        'title' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'customizationAuditedDisabled' => true,
          'dynamicLogicVisibleDisabled' => true,
          'default' => NULL,
          'options' => []
        ],
        'position' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'notStorable' => true,
          'orderDisabled' => true,
          'where' => (object) [
            'LIKE' => (object) [
              'whereClause' => (object) [
                'id=s' => (object) [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => (object) [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            'NOT LIKE' => (object) [
              'whereClause' => (object) [
                'id!=s' => (object) [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => (object) [
                    'deleted' => false,
                    'role*' => '{value}'
                  ]
                ]
              ]
            ],
            '=' => (object) [
              'whereClause' => (object) [
                'id=s' => (object) [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => (object) [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            '<>' => (object) [
              'whereClause' => (object) [
                'id=!s' => (object) [
                  'from' => 'TeamUser',
                  'select' => [
                    0 => 'userId'
                  ],
                  'whereClause' => (object) [
                    'deleted' => false,
                    'role' => '{value}'
                  ]
                ]
              ]
            ],
            'IS NULL' => (object) [
              'whereClause' => (object) [
                'NOT' => (object) [
                  'EXISTS' => (object) [
                    'from' => 'User',
                    'fromAlias' => 'sq',
                    'select' => [
                      0 => 'id'
                    ],
                    'leftJoins' => [
                      0 => [
                        0 => 'teams',
                        1 => 'm',
                        2 => (object) [],
                        3 => (object) [
                          'onlyMiddle' => true
                        ]
                      ]
                    ],
                    'whereClause' => (object) [
                      'm.role!=' => NULL,
                      'sq.id:' => 'user.id'
                    ]
                  ]
                ]
              ]
            ],
            'IS NOT NULL' => (object) [
              'whereClause' => (object) [
                'EXISTS' => (object) [
                  'from' => 'User',
                  'fromAlias' => 'sq',
                  'select' => [
                    0 => 'id'
                  ],
                  'leftJoins' => [
                    0 => [
                      0 => 'teams',
                      1 => 'm',
                      2 => (object) [],
                      3 => (object) [
                        'onlyMiddle' => true
                      ]
                    ]
                  ],
                  'whereClause' => (object) [
                    'm.role!=' => NULL,
                    'sq.id:' => 'user.id'
                  ]
                ]
              ]
            ]
          ],
          'directUpdateDisabled' => true,
          'readOnly' => true,
          'importDisabled' => true,
          'exportDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'textFilterDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'tooltipText'
          ]
        ],
        'emailAddress' => (object) [
          'type' => 'email',
          'required' => false,
          'layoutMassUpdateDisabled' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'phoneNumber' => (object) [
          'type' => 'phone',
          'typeList' => [
            0 => 'Mobile',
            1 => 'Office',
            2 => 'Home',
            3 => 'Fax',
            4 => 'Other'
          ],
          'defaultType' => 'Mobile',
          'dynamicLogicVisibleDisabled' => true
        ],
        'token' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true
        ],
        'authTokenId' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'authLogRecordId' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'ipAddress' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'customizationDisabled' => true
        ],
        'defaultTeam' => (object) [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'customizationAuditedDisabled' => true,
          'customizationAutocompleteOnEmptyDisabled' => true,
          'validatorClassNameList' => [
            0 => 'Espo\\Classes\\FieldValidators\\User\\DefaultTeam\\IsUserTeam'
          ],
          'view' => 'views/user/fields/default-team',
          'dynamicLogicVisibleDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'acceptanceStatus' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'exportDisabled' => true,
          'utility' => true,
          'fieldManagerParamList' => [],
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'acceptanceStatusMeetings' => (object) [
          'type' => 'enum',
          'notStorable' => true,
          'orderDisabled' => true,
          'directUpdateDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters'
          ],
          'importDisabled' => true,
          'exportDisabled' => true,
          'view' => 'crm:views/lead/fields/acceptance-status',
          'link' => 'meetings',
          'column' => 'status',
          'fieldManagerParamList' => [],
          'reportDisabled' => true,
          'options' => false,
          'style' => [],
          'default' => ''
        ],
        'acceptanceStatusCalls' => (object) [
          'type' => 'enum',
          'notStorable' => true,
          'orderDisabled' => true,
          'directUpdateDisabled' => true,
          'layoutAvailabilityList' => [
            0 => 'filters'
          ],
          'importDisabled' => true,
          'exportDisabled' => true,
          'view' => 'crm:views/lead/fields/acceptance-status',
          'link' => 'calls',
          'column' => 'status',
          'fieldManagerParamList' => [],
          'reportDisabled' => true,
          'options' => false,
          'style' => [],
          'default' => ''
        ],
        'teamRole' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true,
          'fieldManagerParamList' => [],
          'default' => NULL,
          'maxLength' => NULL,
          'trim' => false,
          'options' => []
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true,
          'columns' => (object) [
            'role' => 'userRole'
          ],
          'additionalAttributeList' => [
            0 => 'columns'
          ],
          'layoutDetailDisabled' => true,
          'view' => 'views/user/fields/teams',
          'default' => 'javascript: return {teamsIds: []}',
          'audited' => true
        ],
        'roles' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'portals' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'portalRoles' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'tooltip' => true,
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'contact' => (object) [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'view' => 'views/user/fields/contact',
          'fieldManagerParamList' => [
            0 => 'inlineEditDisabled',
            1 => 'tooltipText'
          ],
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'accounts' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'inlineEditDisabled',
            1 => 'tooltipText'
          ],
          'audited' => true,
          'dynamicLogicVisibleDisabled' => true
        ],
        'account' => (object) [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'directAccessDisabled' => true,
          'foreignAccessDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'readOnly' => true,
          'audited' => true,
          'defaultAttributes' => NULL
        ],
        'portal' => (object) [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'customizationDisabled' => true,
          'utility' => true
        ],
        'avatar' => (object) [
          'type' => 'image',
          'view' => 'views/user/fields/avatar',
          'layoutDetailDisabled' => true,
          'previewSize' => 'small',
          'customizationAuditedDisabled' => true,
          'defaultAttributes' => (object) [
            'avatarId' => NULL
          ],
          'layoutAvailabilityList' => []
        ],
        'avatarColor' => (object) [
          'type' => 'colorpicker',
          'dynamicLogicDisabled' => true,
          'layoutAvailabilityList' => []
        ],
        'sendAccessInfo' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'utility' => true
        ],
        'gender' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Male',
            2 => 'Female',
            3 => 'Neutral'
          ],
          'dynamicLogicVisibleDisabled' => true,
          'style' => (object) [
            '' => NULL,
            'Male' => NULL,
            'Female' => NULL,
            'Neutral' => NULL
          ]
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ],
          'useNumericFormat' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'dashboardTemplate' => (object) [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true
        ],
        'workingTimeCalendar' => (object) [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true
        ],
        'layoutSet' => (object) [
          'type' => 'link',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'customizationAuditedDisabled' => true,
          'tooltip' => true
        ],
        'auth2FA' => (object) [
          'type' => 'foreign',
          'link' => 'userData',
          'field' => 'auth2FA',
          'readOnly' => true,
          'view' => 'views/fields/foreign-bool'
        ],
        'userData' => (object) [
          'type' => 'linkOne',
          'utility' => true,
          'customizationDisabled' => true
        ],
        'lastAccess' => (object) [
          'type' => 'datetime',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutDetailDisabled' => true,
          'directAccessDisabled' => true,
          'exportDisabled' => true,
          'default' => NULL,
          'after' => NULL,
          'before' => NULL,
          'minuteStep' => 30
        ],
        'emailAddressList' => (object) [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'userEmailAddressList' => (object) [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'excludeFromReplyEmailAddressList' => (object) [
          'type' => 'array',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'recordAccessLevels' => (object) [
          'type' => 'jsonObject',
          'utility' => true,
          'notStorable' => true,
          'readOnly' => true
        ],
        'targetListIsOptedOut' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true,
          'fieldManagerParamList' => []
        ],
        'customerId' => (object) [
          'type' => 'varchar',
          'audited' => true,
          'readOnly' => false,
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'usertoken' => (object) [
          'type' => 'varchar',
          'audited' => true,
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'partnerid' => (object) [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true,
          'trim' => false
        ],
        'isChecked' => (object) [
          'notNull' => true,
          'type' => 'bool',
          'audited' => true,
          'isCustom' => true
        ],
        'clientid' => (object) [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'clientsecret' => (object) [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'country' => (object) [
          'readOnly' => true,
          'type' => 'foreign',
          'link' => 'contact',
          'field' => 'country',
          'view' => 'views/fields/foreign-enum',
          'isCustom' => true
        ],
        'awsClientId' => (object) [
          'type' => 'varchar',
          'maxLength' => 200,
          'default' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'awsClientSecret' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'default' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'awsMargem' => (object) [
          'notNull' => false,
          'type' => 'float',
          'default' => NULL,
          'min' => NULL,
          'max' => NULL,
          'isCustom' => true
        ],
        'cRegistration' => (object) [
          'type' => 'link'
        ],
        'cAccess' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cLinkPortal' => (object) [
          'type' => 'url',
          'audited' => true,
          'isCustom' => true
        ],
        'middleName' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'pattern' => '$noBadCharacters'
        ],
        'emailAddressIsOptedOut' => (object) [
          'layoutMassUpdateDisabled' => true,
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'emailAddressIsInvalid' => (object) [
          'layoutMassUpdateDisabled' => true,
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsOptedOut' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsInvalid' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'deleteId' => (object) [
          'type' => 'varchar',
          'maxLength' => 17,
          'readOnly' => true,
          'notNull' => true,
          'default' => '0',
          'utility' => true,
          'customizationDisabled' => true
        ]
      ],
      'links' => (object) [
        'defaultTeam' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Team'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'foreign' => 'users',
          'additionalColumns' => (object) [
            'role' => (object) [
              'type' => 'varchar',
              'len' => 100
            ]
          ],
          'layoutRelationshipsDisabled' => true,
          'columnAttributeMap' => (object) [
            'role' => 'teamRole'
          ],
          'dynamicLogicVisibleDisabled' => true,
          'audited' => false
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'roles' => (object) [
          'type' => 'hasMany',
          'entity' => 'Role',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'portals' => (object) [
          'type' => 'hasMany',
          'entity' => 'Portal',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'portalRoles' => (object) [
          'type' => 'hasMany',
          'entity' => 'PortalRole',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'dashboardTemplate' => (object) [
          'type' => 'belongsTo',
          'entity' => 'DashboardTemplate'
        ],
        'workingTimeCalendar' => (object) [
          'type' => 'belongsTo',
          'entity' => 'WorkingTimeCalendar',
          'noJoin' => true
        ],
        'workingTimeRanges' => (object) [
          'type' => 'hasMany',
          'foreign' => 'users',
          'entity' => 'WorkingTimeRange'
        ],
        'layoutSet' => (object) [
          'type' => 'belongsTo',
          'entity' => 'LayoutSet',
          'noJoin' => true
        ],
        'userData' => (object) [
          'type' => 'hasOne',
          'entity' => 'UserData',
          'foreign' => 'user',
          'foreignName' => 'id'
        ],
        'meetings' => (object) [
          'type' => 'hasMany',
          'entity' => 'Meeting',
          'foreign' => 'users',
          'columnAttributeMap' => (object) [
            'status' => 'acceptanceStatus'
          ]
        ],
        'calls' => (object) [
          'type' => 'hasMany',
          'entity' => 'Call',
          'foreign' => 'users',
          'columnAttributeMap' => (object) [
            'status' => 'acceptanceStatus'
          ]
        ],
        'emails' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'users'
        ],
        'notes' => (object) [
          'type' => 'hasMany',
          'entity' => 'Note',
          'foreign' => 'users',
          'layoutRelationshipsDisabled' => true
        ],
        'contact' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Contact',
          'foreign' => 'portalUser'
        ],
        'accounts' => (object) [
          'type' => 'hasMany',
          'entity' => 'Account',
          'foreign' => 'portalUsers',
          'relationName' => 'AccountPortalUser',
          'audited' => false
        ],
        'tasks' => (object) [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'assignedUser',
          'audited' => false
        ],
        'targetLists' => (object) [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'users',
          'columnAttributeMap' => (object) [
            'optedOut' => 'targetListIsOptedOut'
          ],
          'audited' => false
        ],
        'reportEmailSending' => (object) [
          'type' => 'hasMany',
          'entity' => 'Report',
          'foreign' => 'emailSendingUsers',
          'utility' => true,
          'audited' => false
        ],
        'cRegistration' => (object) [
          'type' => 'belongsTo',
          'foreign' => 'portalUser',
          'entity' => 'CRegistration',
          'isCustom' => true
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'userName',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name',
          1 => 'userName',
          2 => 'emailAddress',
          3 => 'phoneNumber'
        ],
        'fullTextSearch' => false,
        'sortBy' => 'userName',
        'asc' => true
      ],
      'indexes' => (object) [
        'userNameDeleteId' => (object) [
          'type' => 'unique',
          'columns' => [
            0 => 'userName',
            1 => 'deleteId'
          ]
        ]
      ],
      'deleteId' => true
    ],
    'UserData' => (object) [
      'fields' => (object) [
        'auth2FA' => (object) [
          'type' => 'bool'
        ],
        'auth2FAMethod' => (object) [
          'type' => 'enum'
        ],
        'auth2FATotpSecret' => (object) [
          'type' => 'varchar',
          'maxLength' => 32
        ],
        'auth2FAEmailAddress' => (object) [
          'type' => 'varchar'
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ]
    ],
    'UserReaction' => (object) [
      'fields' => (object) [
        'type' => (object) [
          'type' => 'varchar',
          'maxLength' => 10
        ],
        'user' => (object) [
          'type' => 'link'
        ],
        'parent' => (object) [
          'type' => 'linkParent'
        ],
        'createdAt' => (object) [
          'type' => 'datetime'
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'parent' => (object) [
          'type' => 'belongsToParent',
          'entityList' => [
            0 => 'Note'
          ]
        ]
      ],
      'indexes' => (object) [
        'parentUserType' => (object) [
          'unique' => true,
          'columns' => [
            0 => 'parentId',
            1 => 'parentType',
            2 => 'userId',
            3 => 'type'
          ]
        ]
      ],
      'noDeletedAttribute' => true
    ],
    'Webhook' => (object) [
      'fields' => (object) [
        'event' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true,
          'view' => 'views/webhook/fields/event'
        ],
        'url' => (object) [
          'type' => 'varchar',
          'maxLength' => 512,
          'required' => true,
          'copyToClipboard' => true
        ],
        'isActive' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'user' => (object) [
          'type' => 'link',
          'view' => 'views/webhook/fields/user'
        ],
        'entityType' => (object) [
          'type' => 'varchar',
          'readOnly' => true,
          'view' => 'views/fields/entity-type'
        ],
        'type' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'create',
            1 => 'update',
            2 => 'fieldUpdate',
            3 => 'delete'
          ],
          'readOnly' => true
        ],
        'field' => (object) [
          'type' => 'varchar',
          'readOnly' => true
        ],
        'secretKey' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'readOnly' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutFiltersDisabled' => true,
          'layoutListDisabled' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'user' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'createdAt',
        'order' => 'desc',
        'textFilterFields' => [
          0 => 'event'
        ],
        'sortBy' => 'createdAt',
        'asc' => false
      ],
      'indexes' => (object) [
        'event' => (object) [
          'columns' => [
            0 => 'event'
          ]
        ],
        'entityTypeType' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'type'
          ]
        ],
        'entityTypeField' => (object) [
          'columns' => [
            0 => 'entityType',
            1 => 'field'
          ]
        ]
      ],
      'hooksDisabled' => true
    ],
    'WebhookEventQueueItem' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'event' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'target' => (object) [
          'type' => 'linkParent'
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'isProcessed' => (object) [
          'type' => 'bool'
        ]
      ],
      'links' => (object) [],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'WebhookQueueItem' => (object) [
      'fields' => (object) [
        'number' => (object) [
          'type' => 'autoincrement',
          'dbType' => 'bigint'
        ],
        'event' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'required' => true
        ],
        'webhook' => (object) [
          'type' => 'link'
        ],
        'target' => (object) [
          'type' => 'linkParent'
        ],
        'data' => (object) [
          'type' => 'jsonObject'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'status' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Pending',
            1 => 'Success',
            2 => 'Failed'
          ],
          'default' => 'Pending',
          'maxLength' => 7,
          'style' => (object) [
            'Success' => 'success',
            'Failed' => 'danger'
          ]
        ],
        'processedAt' => (object) [
          'type' => 'datetime',
          'hasSeconds' => true
        ],
        'attempts' => (object) [
          'type' => 'int',
          'default' => 0
        ],
        'processAt' => (object) [
          'type' => 'datetime'
        ]
      ],
      'links' => (object) [
        'target' => (object) [
          'type' => 'belongsToParent'
        ],
        'webhook' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Webhook',
          'foreignName' => 'id'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'number',
        'order' => 'desc',
        'sortBy' => 'number',
        'asc' => false
      ]
    ],
    'WorkingTimeCalendar' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'required' => true
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'timeZone' => (object) [
          'type' => 'enum',
          'default' => '',
          'view' => 'views/preferences/fields/time-zone'
        ],
        'timeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => [
            0 => [
              0 => '9:00',
              1 => '17:00'
            ]
          ],
          'view' => 'views/working-time-calendar/fields/time-ranges',
          'required' => true
        ],
        'weekday0' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'weekday1' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'weekday2' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'weekday3' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'weekday4' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'weekday5' => (object) [
          'type' => 'bool',
          'default' => true
        ],
        'weekday6' => (object) [
          'type' => 'bool',
          'default' => false
        ],
        'weekday0TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday1TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday2TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday3TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday4TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday5TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'weekday6TimeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'readOnly' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'ranges' => (object) [
          'type' => 'hasMany',
          'foreign' => 'calendars',
          'entity' => 'WorkingTimeRange'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'foreign' => 'workingTimeCalendar',
          'entity' => 'Team',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'name',
        'order' => 'asc',
        'textFilterFields' => [
          0 => 'name'
        ],
        'sortBy' => 'name',
        'asc' => true
      ]
    ],
    'WorkingTimeRange' => (object) [
      'fields' => (object) [
        'timeRanges' => (object) [
          'type' => 'jsonArray',
          'default' => NULL,
          'view' => 'views/working-time-calendar/fields/time-ranges'
        ],
        'dateStart' => (object) [
          'type' => 'date',
          'required' => true
        ],
        'dateEnd' => (object) [
          'type' => 'date',
          'required' => true,
          'view' => 'views/working-time-range/fields/date-end',
          'after' => 'dateStart',
          'afterOrEqual' => true
        ],
        'type' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Non-working',
            1 => 'Working'
          ],
          'default' => 'Non-working',
          'index' => true,
          'maxLength' => 11
        ],
        'name' => (object) [
          'type' => 'varchar'
        ],
        'description' => (object) [
          'type' => 'text'
        ],
        'calendars' => (object) [
          'type' => 'linkMultiple',
          'tooltip' => true
        ],
        'users' => (object) [
          'type' => 'linkMultiple',
          'view' => 'views/working-time-range/fields/users',
          'tooltip' => true
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true
        ]
      ],
      'links' => (object) [
        'calendars' => (object) [
          'type' => 'hasMany',
          'foreign' => 'ranges',
          'entity' => 'WorkingTimeCalendar'
        ],
        'users' => (object) [
          'type' => 'hasMany',
          'foreign' => 'workingTimeRanges',
          'entity' => 'User'
        ],
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ]
      ],
      'collection' => (object) [
        'orderBy' => 'dateStart',
        'order' => 'desc',
        'sortBy' => 'dateStart',
        'asc' => false
      ],
      'indexes' => (object) [
        'typeRange' => (object) [
          'columns' => [
            0 => 'type',
            1 => 'dateStart',
            2 => 'dateEnd'
          ]
        ],
        'type' => (object) [
          'columns' => [
            0 => 'type'
          ]
        ]
      ]
    ],
    'Account' => (object) [
      'fields' => (object) [
        'name' => (object) [
          'type' => 'varchar',
          'maxLength' => 249,
          'required' => true,
          'pattern' => '$noBadCharacters',
          'audited' => true,
          'default' => NULL,
          'options' => []
        ],
        'website' => (object) [
          'type' => 'url',
          'strip' => true
        ],
        'emailAddress' => (object) [
          'type' => 'email',
          'isPersonalData' => true
        ],
        'phoneNumber' => (object) [
          'type' => 'phone',
          'typeList' => [
            0 => 'Office',
            1 => 'Mobile',
            2 => 'Fax',
            3 => 'Other'
          ],
          'defaultType' => 'Office'
        ],
        'type' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Customer',
            2 => 'ISV',
            3 => 'Partner'
          ],
          'customizationOptionsReferenceDisabled' => true,
          'style' => (object) [
            '' => NULL,
            'Customer' => NULL,
            'ISV' => NULL,
            'Partner' => NULL
          ],
          'required' => true
        ],
        'industry' => (object) [
          'type' => 'enum',
          'options' => [
            0 => '',
            1 => 'Advertising',
            2 => 'Aerospace',
            3 => 'Agriculture',
            4 => 'Apparel & Accessories',
            5 => 'Architecture',
            6 => 'Automotive',
            7 => 'Banking',
            8 => 'Biotechnology',
            9 => 'Building Materials & Equipment',
            10 => 'Chemical',
            11 => 'Construction',
            12 => 'Consulting',
            13 => 'Computer',
            14 => 'Culture',
            15 => 'Creative',
            16 => 'Defense',
            17 => 'Education',
            18 => 'Electronics',
            19 => 'Electric Power',
            20 => 'Energy',
            21 => 'Entertainment & Leisure',
            22 => 'Finance',
            23 => 'Food & Beverage',
            24 => 'Grocery',
            25 => 'Healthcare',
            26 => 'Hospitality',
            27 => 'Insurance',
            28 => 'Manufacturing',
            29 => 'Mass Media',
            30 => 'Marketing',
            31 => 'Mining',
            32 => 'Music',
            33 => 'Publishing',
            34 => 'Petroleum',
            35 => 'Real Estate',
            36 => 'Retail',
            37 => 'Service',
            38 => 'Sports',
            39 => 'Software',
            40 => 'Support',
            41 => 'Shipping',
            42 => 'Travel',
            43 => 'Technology',
            44 => 'Telecommunications',
            45 => 'Television',
            46 => 'Transportation',
            47 => 'Testing, Inspection & Certification',
            48 => 'Venture Capital',
            49 => 'Wholesale',
            50 => 'Water'
          ],
          'isSorted' => true,
          'customizationOptionsReferenceDisabled' => true,
          'style' => (object) [
            '' => NULL,
            'Advertising' => NULL,
            'Aerospace' => NULL,
            'Agriculture' => NULL,
            'Apparel & Accessories' => NULL,
            'Architecture' => NULL,
            'Automotive' => NULL,
            'Banking' => NULL,
            'Biotechnology' => NULL,
            'Building Materials & Equipment' => NULL,
            'Chemical' => NULL,
            'Construction' => NULL,
            'Consulting' => NULL,
            'Computer' => NULL,
            'Culture' => NULL,
            'Creative' => NULL,
            'Defense' => NULL,
            'Education' => NULL,
            'Electronics' => NULL,
            'Electric Power' => NULL,
            'Energy' => NULL,
            'Entertainment & Leisure' => NULL,
            'Finance' => NULL,
            'Food & Beverage' => NULL,
            'Grocery' => NULL,
            'Healthcare' => NULL,
            'Hospitality' => NULL,
            'Insurance' => NULL,
            'Manufacturing' => NULL,
            'Mass Media' => NULL,
            'Marketing' => NULL,
            'Mining' => NULL,
            'Music' => NULL,
            'Publishing' => NULL,
            'Petroleum' => NULL,
            'Real Estate' => NULL,
            'Retail' => NULL,
            'Service' => NULL,
            'Sports' => NULL,
            'Software' => NULL,
            'Support' => NULL,
            'Shipping' => NULL,
            'Travel' => NULL,
            'Technology' => NULL,
            'Telecommunications' => NULL,
            'Television' => NULL,
            'Transportation' => NULL,
            'Testing, Inspection & Certification' => NULL,
            'Venture Capital' => NULL,
            'Wholesale' => NULL,
            'Water' => NULL
          ]
        ],
        'sicCode' => (object) [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters',
          'noSpellCheck' => true
        ],
        'contactRole' => (object) [
          'type' => 'varchar',
          'notStorable' => true,
          'utility' => true,
          'orderDisabled' => true,
          'maxLength' => 100,
          'pattern' => '$noBadCharacters',
          'layoutMassUpdateDisabled' => true,
          'layoutListDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutSearchDisabled' => true,
          'fieldManagerParamList' => [
            0 => 'pattern'
          ],
          'default' => NULL,
          'trim' => false,
          'options' => []
        ],
        'contactIsInactive' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'default' => false,
          'utility' => true
        ],
        'billingAddress' => (object) [
          'type' => 'address'
        ],
        'billingAddressStreet' => (object) [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'billingAddressCity' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressState' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressCountry' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'billingAddressPostalCode' => (object) [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddress' => (object) [
          'type' => 'address',
          'view' => 'crm:views/account/fields/shipping-address'
        ],
        'shippingAddressStreet' => (object) [
          'type' => 'text',
          'maxLength' => 255,
          'dbType' => 'varchar'
        ],
        'shippingAddressCity' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-city',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressState' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-state',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressCountry' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'view' => 'views/fields/address-country',
          'customizationOptionsDisabled' => true,
          'customizationOptionsReferenceDisabled' => true,
          'pattern' => '$noBadCharacters'
        ],
        'shippingAddressPostalCode' => (object) [
          'type' => 'varchar',
          'maxLength' => 40,
          'pattern' => '$noBadCharacters'
        ],
        'description' => (object) [
          'type' => 'text',
          'default' => NULL,
          'maxLength' => NULL,
          'rows' => NULL,
          'cutHeight' => NULL
        ],
        'campaign' => (object) [
          'type' => 'link'
        ],
        'createdAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'modifiedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'fieldManagerParamList' => [
            0 => 'useNumericFormat'
          ]
        ],
        'createdBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'modifiedBy' => (object) [
          'type' => 'link',
          'readOnly' => true,
          'view' => 'views/fields/user',
          'fieldManagerParamList' => []
        ],
        'assignedUser' => (object) [
          'type' => 'link',
          'view' => 'views/fields/assigned-user'
        ],
        'teams' => (object) [
          'type' => 'linkMultiple',
          'view' => 'views/fields/teams'
        ],
        'targetLists' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'importDisabled' => true,
          'exportDisabled' => true,
          'noLoad' => true
        ],
        'targetList' => (object) [
          'type' => 'link',
          'notStorable' => true,
          'orderDisabled' => true,
          'layoutDetailDisabled' => true,
          'layoutListDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'layoutFiltersDisabled' => true,
          'entity' => 'TargetList',
          'directAccessDisabled' => true,
          'reportDisabled' => true,
          'defaultAttributes' => NULL
        ],
        'originalLead' => (object) [
          'type' => 'linkOne',
          'readOnly' => true,
          'view' => 'views/fields/link-one',
          'defaultAttributes' => NULL
        ],
        'targetListIsOptedOut' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'utility' => true
        ],
        'priceBook' => (object) [
          'type' => 'link',
          'autocompleteOnEmpty' => true
        ],
        'electronicAddressScheme' => (object) [
          'type' => 'enum',
          'maxLength' => 4,
          'view' => 'sales:views/fields/electronic-address-scheme',
          'validatorClassNameList' => [
            0 => 'Espo\\Modules\\Sales\\FieldValidators\\Account\\ElectronicAddressScheme\\Valid'
          ]
        ],
        'electronicAddressIdentifier' => (object) [
          'type' => 'varchar',
          'maxLength' => 255
        ],
        'products' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => false,
          'layoutMassUpdateDisabled' => false,
          'noLoad' => false,
          'importDisabled' => false,
          'isCustom' => true
        ],
        'recommendations' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'resourceCategories' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'resourceGroups' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'monitorings' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'edge' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Engage',
            1 => 'Develop',
            2 => 'Grow',
            3 => 'Extend',
            4 => ''
          ],
          'style' => (object) [
            'Engage' => NULL,
            'Develop' => NULL,
            'Grow' => NULL,
            'Extend' => NULL,
            '' => NULL
          ],
          'default' => NULL,
          'isCustom' => true,
          'audited' => true
        ],
        'tags' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => true,
          'layoutMassUpdateDisabled' => true,
          'noLoad' => true,
          'importDisabled' => true,
          'isCustom' => true
        ],
        'subscriptions' => (object) [
          'type' => 'linkMultiple',
          'layoutDetailDisabled' => false,
          'layoutMassUpdateDisabled' => false,
          'noLoad' => false,
          'importDisabled' => false,
          'isCustom' => true
        ],
        'country' => (object) [
          'type' => 'enum',
          'options' => [
            0 => 'Select',
            1 => 'Argentina',
            2 => 'Brazil',
            3 => 'Colombia',
            4 => 'Canada',
            5 => 'Equador',
            6 => 'Mexico',
            7 => 'South Africa',
            8 => 'United States of America',
            9 => 'Cala',
            10 => 'Chile',
            11 => 'Peru',
            12 => 'Uruguai',
            13 => ''
          ],
          'style' => (object) [
            'Select' => 'warning',
            'Argentina' => NULL,
            'Brazil' => NULL,
            'Colombia' => NULL,
            'Canada' => NULL,
            'Equador' => NULL,
            'Mexico' => NULL,
            'South Africa' => NULL,
            'United States of America' => NULL,
            'Cala' => NULL,
            'Chile' => NULL,
            'Peru' => NULL,
            'Uruguai' => NULL,
            '' => NULL
          ],
          'default' => NULL,
          'isCustom' => true,
          'required' => true
        ],
        'clientsecret' => (object) [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'clientid' => (object) [
          'type' => 'varchar',
          'default' => NULL,
          'maxLength' => NULL,
          'options' => [],
          'isCustom' => true
        ],
        'cMpnID' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cTenantID' => (object) [
          'type' => 'varchar',
          'maxLength' => 100,
          'options' => [],
          'isCustom' => true
        ],
        'cRegistrationsReseller' => (object) [
          'type' => 'linkMultiple'
        ],
        'cRegistrationsCustomer' => (object) [
          'type' => 'linkMultiple'
        ],
        'cRecommendationsConfig' => (object) [
          'type' => 'linkMultiple'
        ],
        'cRecommendationses' => (object) [
          'type' => 'linkMultiple'
        ],
        'emailAddressIsOptedOut' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'emailAddressIsInvalid' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsOptedOut' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'phoneNumberIsInvalid' => (object) [
          'type' => 'bool',
          'notStorable' => true,
          'layoutDetailDisabled' => true,
          'layoutDefaultSidePanelDisabled' => true,
          'mergeDisabled' => true,
          'customizationDefaultDisabled' => true,
          'customizationReadOnlyDisabled' => true,
          'customizationInlineEditDisabledDisabled' => true
        ],
        'billingAddressMap' => (object) [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'shippingAddressMap' => (object) [
          'type' => 'map',
          'notStorable' => true,
          'orderDisabled' => true,
          'readOnly' => true,
          'layoutListDisabled' => true,
          'provider' => 'Google',
          'height' => 300,
          'exportDisabled' => true,
          'importDisabled' => true
        ],
        'streamUpdatedAt' => (object) [
          'type' => 'datetime',
          'readOnly' => true,
          'customizationReadOnlyDisabled' => true
        ]
      ],
      'links' => (object) [
        'createdBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'modifiedBy' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'assignedUser' => (object) [
          'type' => 'belongsTo',
          'entity' => 'User'
        ],
        'teams' => (object) [
          'type' => 'hasMany',
          'entity' => 'Team',
          'relationName' => 'entityTeam',
          'layoutRelationshipsDisabled' => true
        ],
        'contacts' => (object) [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'accounts',
          'columnAttributeMap' => (object) [
            'role' => 'contactRole',
            'isInactive' => 'contactIsInactive'
          ],
          'audited' => false
        ],
        'contactsPrimary' => (object) [
          'type' => 'hasMany',
          'entity' => 'Contact',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'opportunities' => (object) [
          'type' => 'hasMany',
          'entity' => 'Opportunity',
          'foreign' => 'account',
          'audited' => false
        ],
        'cases' => (object) [
          'type' => 'hasMany',
          'entity' => 'Case',
          'foreign' => 'account'
        ],
        'documents' => (object) [
          'type' => 'hasMany',
          'entity' => 'Document',
          'foreign' => 'accounts',
          'audited' => true
        ],
        'meetingsPrimary' => (object) [
          'type' => 'hasMany',
          'entity' => 'Meeting',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'emailsPrimary' => (object) [
          'type' => 'hasMany',
          'entity' => 'Email',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'callsPrimary' => (object) [
          'type' => 'hasMany',
          'entity' => 'Call',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'tasksPrimary' => (object) [
          'type' => 'hasMany',
          'entity' => 'Task',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'meetings' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Meeting',
          'foreign' => 'parent',
          'audited' => true
        ],
        'calls' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Call',
          'foreign' => 'parent',
          'audited' => true
        ],
        'tasks' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Task',
          'foreign' => 'parent'
        ],
        'emails' => (object) [
          'type' => 'hasChildren',
          'entity' => 'Email',
          'foreign' => 'parent',
          'layoutRelationshipsDisabled' => true
        ],
        'campaign' => (object) [
          'type' => 'belongsTo',
          'entity' => 'Campaign',
          'foreign' => 'accounts'
        ],
        'campaignLogRecords' => (object) [
          'type' => 'hasChildren',
          'entity' => 'CampaignLogRecord',
          'foreign' => 'parent'
        ],
        'targetLists' => (object) [
          'type' => 'hasMany',
          'entity' => 'TargetList',
          'foreign' => 'accounts',
          'columnAttributeMap' => (object) [
            'optedOut' => 'targetListIsOptedOut'
          ]
        ],
        'portalUsers' => (object) [
          'type' => 'hasMany',
          'entity' => 'User',
          'foreign' => 'accounts',
          'audited' => false
        ],
        'originalLead' => (object) [
          'type' => 'hasOne',
          'entity' => 'Lead',
          'foreign' => 'createdAccount'
        ],
        'supplier' => (object) [
          'type' => 'hasOne',
          'foreign' => 'account',
          'entity' => 'Supplier'
        ],
        'quotes' => (object) [
          'type' => 'hasMany',
          'entity' => 'Quote',
          'foreign' => 'account',
          'audited' => true
        ],
        'quoteItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'QuoteItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'salesOrders' => (object) [
          'type' => 'hasMany',
          'entity' => 'SalesOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'salesOrderItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'SalesOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'invoices' => (object) [
          'type' => 'hasMany',
          'entity' => 'Invoice',
          'foreign' => 'account',
          'audited' => true
        ],
        'invoiceItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'InvoiceItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true,
          'audited' => false
        ],
        'purchaseOrders' => (object) [
          'type' => 'hasMany',
          'entity' => 'PurchaseOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'purchaseOrderItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'PurchaseOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'deliveryOrders' => (object) [
          'type' => 'hasMany',
          'entity' => 'DeliveryOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'deliveryOrderItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'DeliveryOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'receiptOrders' => (object) [
          'type' => 'hasMany',
          'entity' => 'ReceiptOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'returnOrders' => (object) [
          'type' => 'hasMany',
          'entity' => 'ReturnOrder',
          'foreign' => 'account',
          'audited' => true
        ],
        'receiptOrderItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'ReceiptOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'returnOrderItems' => (object) [
          'type' => 'hasMany',
          'entity' => 'ReturnOrderItem',
          'foreign' => 'account',
          'layoutRelationshipsDisabled' => true
        ],
        'priceBook' => (object) [
          'type' => 'belongsTo',
          'entity' => 'PriceBook',
          'foreign' => 'accounts'
        ],
        'products' => (object) [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Product',
          'audited' => false,
          'isCustom' => true
        ],
        'recommendations' => (object) [
          'type' => 'hasMany',
          'foreign' => 'account',
          'entity' => 'Recommendation',
          'audited' => false,
          'isCustom' => true
        ],
        'resourceCategories' => (object) [
          'type' => 'hasMany',
          'f