<?php
return [
  'ActionHistoryRecord' => [
    'fields' => [
      'user' => 'Usuario',
      'action' => 'Acción',
      'createdAt' => 'Fecha',
      'userType' => 'Tipo de usuario',
      'target' => 'Entidad objetivo',
      'targetType' => 'Tipo de objetivo',
      'authToken' => 'Token de autenticación',
      'ipAddress' => 'Dirección IP',
      'authLogRecord' => 'Entrada del registro de autenticación'
    ],
    'links' => [
      'authToken' => 'Token de autenticación',
      'authLogRecord' => 'Entrada del registro de autenticación',
      'user' => 'Usuario',
      'target' => 'Objetivo'
    ],
    'presetFilters' => [
      'onlyMy' => 'Solo míos'
    ],
    'options' => [
      'action' => [
        'read' => 'Leer',
        'update' => 'Guardar',
        'delete' => 'Eliminar',
        'create' => 'Crear'
      ]
    ]
  ],
  'AddressCountry' => [
    'labels' => [
      'Create AddressCountry' => 'Create Address Country',
      'Populate' => 'Populate'
    ],
    'fields' => [
      'code' => 'Code',
      'isPreferred' => 'Is Preferred'
    ],
    'tooltips' => [
      'code' => 'ISO 3166-1 alpha-2 code.',
      'isPreferred' => 'Preferred countries appear first in the picklist.'
    ],
    'messages' => [
      'confirmPopulateDefaults' => 'All existing countries will be deleted, the default country list will be created. It won\'t be possible to revert the operation.

Are you sure?'
    ],
    'strings' => [
      'populateDefaults' => 'Populate with default country list'
    ]
  ],
  'Admin' => [
    'labels' => [
      'Enabled' => 'Activado',
      'Disabled' => 'Desactivado',
      'System' => 'Sistema',
      'Users' => 'Usuarios',
      'Email' => 'Correos',
      'Messaging' => 'Messaging',
      'Data' => 'Datos',
      'Misc' => 'Misc',
      'Setup' => 'Setup',
      'Customization' => 'Personalizaciones',
      'Available Fields' => 'Campos disponibles',
      'Layout' => 'Diseño',
      'Entity Manager' => 'Entidades',
      'Add Panel' => 'Añadir Panel',
      'Add Field' => 'Añadir Campo',
      'Settings' => 'Ajustes',
      'Scheduled Jobs' => 'Tareas programadas',
      'Upgrade' => 'Actualizar',
      'Clear Cache' => 'Limpiar caché',
      'Rebuild' => 'Reconstruir',
      'Teams' => 'Equipos',
      'Roles' => 'Roles',
      'Portal' => 'Portales',
      'Portals' => 'Portales',
      'Portal Roles' => 'Roles del portal',
      'Portal Users' => 'Usuarios del portal',
      'API Users' => 'Usuarios de API',
      'Outbound Emails' => 'Salientes',
      'Group Email Accounts' => 'Grupales',
      'Personal Email Accounts' => 'Personales',
      'Inbound Emails' => 'Entrantes',
      'Email Templates' => 'Plantillas',
      'Import' => 'Importar',
      'Layout Manager' => 'Diseño',
      'User Interface' => 'Interfaz de usuario',
      'Auth Tokens' => 'Tokens',
      'Auth Log' => 'Registros de autenticación',
      'App Log' => 'App Log',
      'App Secrets' => 'App Secrets',
      'Authentication' => 'Autenticación',
      'Currency' => 'Moneda',
      'Integrations' => 'Integración',
      'Extensions' => 'Extensiones',
      'Webhooks' => 'Webhooks',
      'Dashboard Templates' => 'Plantilla de escritorio',
      'Upload' => 'Subir',
      'Installing...' => 'Instalando...',
      'Upgrading...' => 'Actualizando',
      'Upgraded successfully' => 'Actualización exitosa',
      'Installed successfully' => 'Instalado de forma exitosa',
      'Ready for upgrade' => 'Listo para actualizar',
      'Run Upgrade' => 'Ejecutar actualización',
      'Install' => 'Instalar',
      'Ready for installation' => 'Listo para instalación',
      'Uninstalling...' => 'Desinstalando',
      'Uninstalled' => 'Desinstalado',
      'Create Entity' => 'Crear entidad',
      'Edit Entity' => 'Editar Entidad',
      'Create Link' => 'Crear enlace',
      'Edit Link' => 'Editar Enlace',
      'Notifications' => 'Notificaciones',
      'Jobs' => 'Trabajos',
      'Job Settings' => 'Job Settings',
      'Reset to Default' => 'Aplicar a valores por defecto',
      'Email Filters' => 'Filtros',
      'Action History' => 'Histórico',
      'Label Manager' => 'Etiquetas',
      'Template Manager' => 'Gestor de plantillas',
      'Lead Capture' => 'Captura de Posible cliente',
      'Attachments' => 'Adjuntos',
      'System Requirements' => 'Requerimientos del sistema',
      'PDF Templates' => 'Plantillas PDF',
      'PHP Settings' => 'Configuraciones PHP',
      'Database Settings' => 'Configuraciones de la Base de Datos',
      'Permissions' => 'Permisos',
      'Email Addresses' => 'Correos electrónicos',
      'Phone Numbers' => 'Números de teléfono',
      'Layout Sets' => 'Conjuntos de diseño',
      'Working Time Calendars' => 'Working Time Calendars',
      'Group Email Folders' => 'Group Email Folders',
      'Authentication Providers' => 'Authentication Providers',
      'Address Countries' => 'Address Countries',
      'Success' => 'Éxito',
      'Fail' => 'Falló',
      'Configuration Instructions' => 'Configuration Instructions',
      'Formula Sandbox' => 'Formula Sandbox',
      'is recommended' => 'es recomendado',
      'extension is missing' => 'no se encuentra la extensión',
      'Workflow Manager' => 'Flujos de trabajo',
      'Flowcharts' => 'Diagramas de flujo',
      'Processes' => 'Procesos',
      'Business Process Management' => 'Gestión de procesos de negocio',
      'Report Filters' => 'Filtros de informes',
      'Report Panels' => 'Paneles de informes',
      'Price Rule Conditions' => 'Price Rule Conditions'
    ],
    'layouts' => [
      'list' => 'Lista',
      'detail' => 'Detalle',
      'listSmall' => 'Lista (pequeña)',
      'detailSmall' => 'Detalle (Pequeño)',
      'detailPortal' => 'Detalle (portal)',
      'detailSmallPortal' => 'Detalle (pequeño, portal)',
      'listSmallPortal' => 'Lusta (pequeña, portal)',
      'listPortal' => 'Lista (portal)',
      'relationshipsPortal' => 'Paneles de relaciones (Portal)',
      'filters' => 'Filtros de Búsqueda',
      'massUpdate' => 'Actualización masiva',
      'relationships' => 'Paneles de relaciones',
      'defaultSidePanel' => 'Campos del panel lateral',
      'bottomPanelsDetail' => 'Paneles inferiores',
      'bottomPanelsEdit' => 'Paneles inferiores (editar)',
      'bottomPanelsDetailSmall' => 'Paneles inferiores (detalle pequeño)',
      'bottomPanelsEditSmall' => 'Paneles inferiores (Editar pequeño)',
      'sidePanelsDetail' => 'Paneles laterales (detalle)',
      'sidePanelsEdit' => 'Paneles laterales (editar)',
      'sidePanelsDetailSmall' => 'Paneles laterales (detalle pequeño)',
      'sidePanelsEditSmall' => 'Paneles laterales (editar pequeño)',
      'kanban' => 'Kanban',
      'detailConvert' => 'Convertir posible cliente',
      'listForAccount' => 'Listado (por Cuentas)',
      'listForContact' => 'Lista (para contacto)',
      'listItem' => 'Lista (artículo)',
      'detailBottomTotal' => 'Total inferior',
      'listForAdd' => 'List (Select for Item)',
      'listForAddInventory' => 'List (Select Inventory)',
      'detailCreateFromSalesOrder' => 'Create from Sales Order',
      'detailCreateFromPurchaseOrder' => 'Create from Purchase Order',
      'listForProduct' => 'List for Product',
      'listForTemplateProduct' => 'List for Template Product',
      'listForWarehouse' => 'List for Warehouse',
      'listVariant' => 'List Variants',
      'ebla-form' => 'Ebla Public Form'
    ],
    'fieldTypes' => [
      'address' => 'Dirección',
      'array' => 'Lista ordenable',
      'foreign' => 'Clave foránea',
      'duration' => 'Duración',
      'password' => 'Contraseña',
      'personName' => 'Nombre',
      'autoincrement' => 'Incremental',
      'bool' => 'SI / NO',
      'currency' => 'Moneda',
      'currencyConverted' => 'Moneda (convertido)',
      'date' => 'Fecha',
      'datetime' => 'Fecha y hora',
      'datetimeOptional' => 'Fecha / Fecha-Hora',
      'email' => 'Correo electrónico',
      'enum' => 'Lista',
      'enumInt' => 'Lista de enteros',
      'enumFloat' => 'Lista de decimales',
      'float' => 'Decimal',
      'int' => 'Entero',
      'link' => 'Enlace',
      'linkMultiple' => 'Enlace múltiple',
      'linkParent' => 'Enlace Padre',
      'linkOne' => 'Enlace uno',
      'phone' => 'Teléfono',
      'text' => 'Área de texto simple',
      'url' => 'Url',
      'urlMultiple' => 'Url Multiple',
      'varchar' => 'Texto',
      'file' => 'Archivo',
      'image' => 'Imagen',
      'multiEnum' => 'Lista múltiple',
      'attachmentMultiple' => 'Adjuntos múltiples',
      'rangeInt' => 'Rango de enteros',
      'rangeFloat' => 'Rango de decimales',
      'rangeCurrency' => 'Rango de moneda',
      'wysiwyg' => 'Área de texto con editor',
      'map' => 'Mapa',
      'number' => 'Número',
      'colorpicker' => 'Selector de color',
      'checklist' => 'Lista de verificación',
      'barcode' => 'Código de barras',
      'jsonArray' => 'Array JSON',
      'jsonObject' => 'Objeto JSON'
    ],
    'fields' => [
      'type' => 'Tipo',
      'name' => 'Nombre',
      'label' => 'Etiqueta',
      'tooltipText' => 'Texto de la ayuda',
      'required' => 'Requerido',
      'default' => 'Por defecto',
      'maxLength' => 'Longitud máxima',
      'options' => 'Ajustes',
      'optionsReference' => 'Options Reference',
      'after' => 'Después (campo)',
      'before' => 'Antes (campo)',
      'link' => 'Enlace',
      'field' => 'Campo',
      'min' => 'Mínimo',
      'max' => 'Máximo',
      'translation' => 'Traducción',
      'previewSize' => 'Tamaño de vista previa',
      'listPreviewSize' => 'Vista previa del tamaño en la vista de lista',
      'noEmptyString' => 'No están permitidos los valores de cadenas vacías',
      'defaultType' => 'Tipo por defecto',
      'seeMoreDisabled' => 'Desactivar cortar texto',
      'cutHeight' => 'Altura de corte (px)',
      'entityList' => 'Lista de entidades',
      'isSorted' => '¿Se debe ordenar?',
      'audited' => 'Auditada',
      'trim' => 'Recortar',
      'height' => 'Altura (px)',
      'minHeight' => 'Altura mínima (px)',
      'provider' => 'Proveedor',
      'typeList' => 'Tipo de lista',
      'rows' => 'Número de filas del área de texto',
      'lengthOfCut' => 'Longitud del corte',
      'sourceList' => 'Lista de tomas de contacto',
      'prefix' => 'Prefijo',
      'nextNumber' => 'Siguiente Número',
      'padLength' => 'Longitud del relleno',
      'disableFormatting' => 'Desactivar formateo',
      'dynamicLogicVisible' => 'Condiciones para hacer el campo visible',
      'dynamicLogicReadOnly' => 'Condiciones para hacer el campo solo lectura',
      'dynamicLogicRequired' => 'Condiciones para hacer el campo obligatorio',
      'dynamicLogicOptions' => 'Opciones condicionales',
      'dynamicLogicInvalid' => 'Conditions making field invalid',
      'probabilityMap' => 'Probabilidades de la etapa (%)',
      'notActualOptions' => 'Opciones no reales',
      'activeOptions' => 'Active Options',
      'readOnly' => 'Solo lectura',
      'readOnlyAfterCreate' => 'Read-only After Create',
      'preview' => 'Preview',
      'attachmentField' => 'Attachment Field',
      'maxFileSize' => 'Tamaño máximo de archivo (MB)',
      'isPersonalData' => '¿Es un dato personal?',
      'useIframe' => 'Usar iframe',
      'useNumericFormat' => 'Usar formato numérico',
      'strip' => 'Banda',
      'minuteStep' => 'Paso de minutos',
      'inlineEditDisabled' => 'Desactivar edición en línea',
      'allowCustomOptions' => 'Permitir opciones personalizadas',
      'displayAsLabel' => 'Mostrar como etiqueta',
      'displayAsList' => 'Mostrar como lista',
      'labelType' => 'Label Type',
      'maxCount' => 'Cantidad máxima de items',
      'accept' => 'Aceptar',
      'viewMap' => 'Botón Ver mapa',
      'codeType' => 'Tipo de código',
      'lastChar' => 'Último personaje',
      'onlyDefaultCurrency' => 'Única moneda predeterminada',
      'decimal' => 'Decimal',
      'displayRawText' => 'Mostrar texto sin formato (sin markdown)',
      'conversionDisabled' => 'Disable Conversion',
      'decimalPlaces' => 'Decimal Places',
      'pattern' => 'Pattern',
      'globalRestrictions' => 'Global Restrictions',
      'copyToClipboard' => 'Copy to clipboard button',
      'createButton' => 'Create Button',
      'autocompleteOnEmpty' => 'Autocomplete on empty input',
      'relateOnImport' => 'Relate on Import',
      'aclScope' => 'ACL Scope',
      'onlyAdmin' => 'Only for Admin',
      'useAutoincrement' => 'Autoincremento',
      'copyFieldList' => 'Campos para copiar'
    ],
    'strings' => [
      'rebuildRequired' => 'Se requiere reconstrucción'
    ],
    'messages' => [
      'cacheIsDisabled' => 'Cache is disabled, the application will run slow. Enable cache in the [settings](#Admin/settings).',
      'formulaFunctions' => 'Se pueden encontrar más funciones en [documentación] ({documentationUrl}).',
      'rebuildRequired' => 'Necesita ejecutar la reconstrucción desde CLI.',
      'upgradeVersion' => 'Partners se actualizará a la versión **{version}**. Tenga paciencia ya que esto puede llevar un tiempo.',
      'upgradeDone' => 'Partners se ha actualizado a la versión **{version}**.',
      'upgradeBackup' => 'Recomendamos hacer una copia de seguridad de los archivos y datos de Partners antes de actualizar.',
      'thousandSeparatorEqualsDecimalMark' => 'El símbolo de separador de miles no puede ser el mismo que el de punto decimal.',
      'userHasNoEmailAddress' => 'El usuario no tiene dirección de correo electrónico.',
      'selectEntityType' => 'Seleccione el tipo de entidad en el menú de la izquierda.',
      'selectUpgradePackage' => 'Seleccione el paquete para actualizar',
      'downloadUpgradePackage' => 'Descargue los paquetes de actualización [aquí]({url}).',
      'selectLayout' => 'Seleccione el diseño necesario en el menú de la izquierda y edítelo.',
      'selectExtensionPackage' => 'Seleccione el paquete de la extensión',
      'extensionInstalled' => 'La extensión {name} {version} ha sido instalada',
      'installExtension' => 'La extensión {name} {version} está lista para ser instalada.',
      'cronIsDisabled' => 'Cron is disabled, the application is not fully functional. Enable cron in the [settings](#Admin/settings).',
      'cronIsNotConfigured' => 'Los trabajos programados no se están ejecutando. Por lo tanto, los correos electrónicos entrantes, las notificaciones y los recordatorios no funcionan. Siga las [instrucciones](https://www.espocrm.com/documentation/administration/server-configuration/#user-content-setup-a-crontab) para configurar el trabajo cron.',
      'newVersionIsAvailable' => 'La nueva versión de Partners {latestVersion} está disponible. Siga las [instrucciones](https://www.espocrm.com/documentation/administration/upgrading/) para actualizar su instancia.',
      'newExtensionVersionIsAvailable' => 'La nueva versión {latestVersion} de {extensionName} está disponible.',
      'uninstallConfirmation' => '¿Seguro que quieres desinstalar la extensión?',
      'upgradeInfo' => 'Consulte la [documentación]({url}) sobre cómo actualizar su instancia de Partners.',
      'upgradeRecommendation' => 'No se recomienda esta forma de actualización. Es mejor actualizar desde CLI.',
      'newAdvancedPackVersionIsAvailable' => 'Hay disponible una nueva versión del paquete avanzado {latestVersion}. Puede descargarla en el portal del cliente.'
    ],
    'descriptions' => [
      'settings' => 'Ajustes generales del sistema.',
      'scheduledJob' => 'Trabajos que se ejecutan en segundo plano (CRON).',
      'jobs' => 'Los trabajos que ejecutan tareas en segundo plano.',
      'upgrade' => 'Actualiza Partners.',
      'clearCache' => 'Limpia toda la memoria caché del sistema.',
      'rebuild' => 'Reconstruir el sistema y limpia la caché.',
      'users' => 'Gestión de usuarios.',
      'teams' => 'Gestión de equipos.',
      'roles' => 'Gestión de roles.',
      'portals' => 'Gestión de portales.',
      'portalRoles' => 'Roles para el portal.',
      'portalUsers' => 'Usuarios del portal.',
      'outboundEmails' => 'Ajustes para los correos del sistema y de envíos masivos.',
      'groupEmailAccounts' => 'Ajustes de cuentas de correo grupales. Ejemplo: casilla de soporte.',
      'personalEmailAccounts' => 'Ajustes de cuentas de correo personales de los usuarios.',
      'emailTemplates' => 'Plantillas para de correos salientes.',
      'import' => 'Importar datos desde CSV.',
      'layoutManager' => 'Personalizar diseños (listas, detalles, editar, buscar, actualización masiva).',
      'entityManager' => 'Crear y editar entidades personalizadas. Administrar campos y relaciones.',
      'userInterface' => 'Configurar interfaz de usuario: Logo, tema, menu, etc.',
      'authTokens' => 'Sesiones de usuarios activas. Direcciones IP y última fecha de acceso.',
      'authentication' => 'Ajustes de autenticación.',
      'currency' => 'Ajustes de moneda y tipos de cambio.',
      'extensions' => 'Instalar o desinstalar extensiones.',
      'integrations' => 'Integración con los servicios de terceros.',
      'notifications' => 'Ajustes de notificaciones del sistema y por correo electrónico.',
      'inboundEmails' => 'Ajustes para los correos entrantes.',
      'emailFilters' => 'Filtros para los correos entrantes.',
      'groupEmailFolders' => 'Email folders shared for teams.',
      'actionHistory' => 'Registro de las acciones del usuario.',
      'labelManager' => 'Personaliza las etiquetas de las aplicaciones.',
      'templateManager' => 'Personalice las plantillas de mensajes.',
      'authLog' => 'Historial de acceso.',
      'appLog' => 'Application log.',
      'appSecrets' => 'Store sensitive information like API keys, passwords, and other secrets.',
      'leadCapture' => 'Puntos de acceso al API para Web-to-Lead.',
      'attachments' => 'Todos los archivos adjuntos almacenados en el sistema.',
      'systemRequirements' => 'Requerimientos del sistema para Partners.',
      'apiUsers' => 'Usuarios separados para propósitos de integraciones.',
      'webhooks' => 'Administrar webhooks.',
      'authenticationProviders' => 'Additional authentication providers for portals.',
      'emailAddresses' => 'Todas las direcciones de correo electrónico almacenadas en el sistema.',
      'phoneNumbers' => 'Todos los números de teléfono almacenados en el sistema.',
      'dashboardTemplates' => 'Implemente paneles para los usuarios.',
      'layoutSets' => 'Colecciones de diseños que se pueden asignar a equipos y portales.',
      'workingTimeCalendars' => 'Working schedule.',
      'jobsSettings' => 'Job processing settings. Jobs execute tasks in the background.',
      'sms' => 'SMS settings.',
      'pdfTemplates' => 'Plantillas para impresión en PDF.',
      'formulaSandbox' => 'Write and test formula scripts.',
      'addressCountries' => 'Countries available for address fields.',
      'workflowManager' => 'Configurar reglas de flujo de trabajo.',
      'bpmnFlowcharts' => 'Definiciones de procesos de negocio.',
      'bpmnProcesses' => 'Instancias de procesos de negocio.',
      'reportFilters' => 'Filtros de vista de lista personalizados basados en informes.',
      'reportPanels' => 'Vista detallada de los paneles que muestran los resultados del informe.',
      'salesPackSettings' => 'Parameters for sales & purchase functionality.',
      'priceRuleConditions' => 'Formula conditions for price rules.',
      'eblaFormDescription' => 'Public Forms Management'
    ],
    'keywords' => [
      'settings' => 'sistema',
      'userInterface' => 'interfaz de usuario, tema, pestañas, logotipo, tablero',
      'authentication' => 'contraseña',
      'scheduledJob' => 'cron, trabajos',
      'integrations' => 'google, mapas, mapas de google',
      'authLog' => 'registro, historia',
      'authTokens' => 'historial, acceso, registro',
      'entityManager' => 'campos, relaciones, relaciones',
      'templateManager' => 'notificaciones',
      'jobs' => 'cron',
      'labelManager' => 'language,translation',
      'appSecrets' => 'key,keys,password',
      'leadCapture' => 'web forms',
      'bpmnFlowcharts' => 'bpm',
      'bpmnProcesses' => 'bpm',
      'salesPack' => 'price,price book,price books'
    ],
    'options' => [
      'previewSize' => [
        '' => 'Defecto',
        'x-small' => 'Muy Pequeño',
        'small' => 'Pequeño',
        'medium' => 'Mediano',
        'large' => 'Grande'
      ],
      'labelType' => [
        'state' => 'State',
        'regular' => 'Regular'
      ]
    ],
    'logicalOperators' => [
      'and' => 'Y',
      'or' => 'O',
      'not' => 'NO'
    ],
    'systemRequirements' => [
      'requiredPhpVersion' => 'Versión de PHP',
      'requiredMysqlVersion' => 'Versión de MySQL',
      'requiredMariadbVersion' => 'Version de MariaDB',
      'requiredPostgresqlVersion' => 'PostgreSQL version',
      'host' => 'Nombre de host',
      'dbname' => 'Nombre de la Base de Datos',
      'user' => 'Nombre de usuario',
      'writable' => 'Escribible',
      'readable' => 'Legible'
    ],
    'templates' => [
      'twoFactorCode' => '2FA Code',
      'accessInfo' => 'Información de acceso',
      'accessInfoPortal' => 'Información de acceso para portales',
      'assignment' => 'Asignación',
      'mention' => 'Mencionar',
      'noteEmailReceived' => 'Nota sobre el correo electrónico recibido',
      'notePost' => 'Nota sobre la publicación',
      'notePostNoParent' => 'Nota sobre la publicación (sin padre)',
      'noteStatus' => 'Nota sobre la actualización de estado',
      'passwordChangeLink' => 'Enlace de cambio de contraseña',
      'invitation' => 'Invitación',
      'cancellation' => 'Cancellation',
      'reminder' => 'Recordatorio',
      'reportSendingGrid1' => 'Cuadrícula de informe-1',
      'reportSendingGrid2' => 'Cuadrícula de informe-2',
      'reportSendingList' => 'Lista de informes',
      'salesEmailPdf' => 'Enviar PDF por correo electrónico (ventas)'
    ]
  ],
  'ApiUser' => [
    'labels' => [
      'Create ApiUser' => 'Crear usuarios de API'
    ]
  ],
  'AppLogRecord' => [
    'fields' => [
      'message' => 'Message',
      'code' => 'Code',
      'level' => 'Level',
      'exceptionClass' => 'Exception Class',
      'file' => 'File',
      'line' => 'Line',
      'requestMethod' => 'Request Method',
      'requestResourcePath' => 'Request Resource Path'
    ],
    'presetFilters' => [
      'errors' => 'Errors'
    ]
  ],
  'AppSecret' => [
    'labels' => [
      'Create AppSecret' => 'Create Secret'
    ],
    'fields' => [
      'value' => 'Value'
    ],
    'tooltips' => [
      'name' => 'Allowed characters:
* `[a-z]`
* `[A-Z]`
* `[0-9]`
* `_`'
    ]
  ],
  'Attachment' => [
    'fields' => [
      'role' => 'Rol',
      'related' => 'Relacionado',
      'file' => 'Archivo',
      'type' => 'Tipo',
      'field' => 'Campo',
      'sourceId' => 'Origen ID',
      'storage' => 'Almacenamiento',
      'size' => 'Tamaño (bytes)',
      'isBeingUploaded' => 'Is Being Uploaded'
    ],
    'options' => [
      'role' => [
        'Attachment' => 'Adjunto',
        'Inline Attachment' => 'Adjunto en linea',
        'Import File' => 'Importar archivos',
        'Export File' => 'Exportar archivo',
        'Mail Merge' => 'Unificación de correo',
        'Mass Pdf' => 'Pdf masivo'
      ]
    ],
    'insertFromSourceLabels' => [
      'Document' => 'Insertar documento'
    ],
    'presetFilters' => [
      'orphan' => 'Huérfano'
    ]
  ],
  'AuthLogRecord' => [
    'fields' => [
      'username' => 'Nombre de usuario',
      'ipAddress' => 'Dirección IP',
      'requestTime' => 'Tiempo de la solicitud',
      'createdAt' => 'Solicitado en',
      'isDenied' => 'Es denegado',
      'denialReason' => 'Motivo de denegación',
      'portal' => 'Portal',
      'user' => 'Usuario',
      'authToken' => 'Token de autenticación creado',
      'requestUrl' => 'URL de la solicitud',
      'requestMethod' => 'Método de solicitud',
      'authTokenIsActive' => 'Token de autenticación está activo',
      'authenticationMethod' => 'Método de autenticación'
    ],
    'links' => [
      'authToken' => 'Token de autenticación creado',
      'user' => 'Usuario',
      'portal' => 'Portal',
      'actionHistoryRecords' => 'Historial de acciones'
    ],
    'presetFilters' => [
      'denied' => 'Denegado',
      'accepted' => 'Aceptada'
    ],
    'options' => [
      'denialReason' => [
        'CREDENTIALS' => 'Credenciales no válidas',
        'WRONG_CODE' => 'Wrong code',
        'INACTIVE_USER' => 'Usuario inactivo',
        'IS_PORTAL_USER' => 'Usuario del portal',
        'IS_NOT_PORTAL_USER' => 'No es un usuario del portal',
        'USER_IS_NOT_IN_PORTAL' => 'El usuario no está relacionado con el portal',
        'IS_SYSTEM_USER' => 'Is system user',
        'FORBIDDEN' => 'Forbidden'
      ]
    ]
  ],
  'AuthToken' => [
    'fields' => [
      'user' => 'Usuario',
      'ipAddress' => 'Dirección IP',
      'lastAccess' => 'Fecha del último acceso',
      'createdAt' => 'Fecha de acceso',
      'isActive' => 'Está activo',
      'portal' => 'Portal'
    ],
    'links' => [
      'actionHistoryRecords' => 'Histórico'
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'inactive' => 'Inactivo'
    ],
    'labels' => [
      'Set Inactive' => 'Establecer Inactivo'
    ],
    'massActions' => [
      'setInactive' => 'Establecer Inactivo'
    ]
  ],
  'AuthenticationProvider' => [
    'fields' => [
      'method' => 'Method'
    ],
    'labels' => [
      'Create AuthenticationProvider' => 'Create Provider'
    ]
  ],
  'Currency' => [
    'names' => [
      'AED' => 'Dírham de los Emiratos Árabes Unidos',
      'AFN' => 'Afgano afgano',
      'ALL' => 'Lek albanés',
      'AMD' => 'Dram armenio',
      'ANG' => 'Florín de las Antillas Neerlandesas',
      'AOA' => 'Kwanza angoleño',
      'ARS' => 'Peso argentino',
      'AUD' => 'Dólar australiano',
      'AWG' => 'Florín de Aruba',
      'AZN' => 'Manat azerbaiyano',
      'BAM' => 'Marco convertible de Bosnia-Herzegovina',
      'BBD' => 'Dólar de Barbados',
      'BDT' => 'Taka de Bangladesh',
      'BGN' => 'Lev búlgaro',
      'BHD' => 'Dinar bahreiní',
      'BIF' => 'Franco burundés',
      'BMD' => 'Dólar de las Bermudas',
      'BND' => 'Dólar de Brunei',
      'BOB' => 'Boliviano de Bolivia',
      'BOV' => 'Mvdol boliviano',
      'BRL' => 'Real brasileño',
      'BSD' => 'Dólar de las Bahamas',
      'BTN' => 'Ngultrum butanés',
      'BWP' => 'Pula de Botswana',
      'BYN' => 'Rublo bielorruso',
      'BZD' => 'Dólar beliceño',
      'CAD' => 'Dolar canadiense',
      'CDF' => 'Franco congoleño',
      'CHE' => 'WIR Euro',
      'CHF' => 'Franco suizo',
      'CHW' => 'Franco WIR',
      'CLF' => 'Unidad de Cuenta Chilena (UF)',
      'CLP' => 'Peso chileno',
      'CNH' => 'Yuan chino (en alta mar)',
      'CNY' => 'Yuan chino',
      'COP' => 'Peso colombiano',
      'COU' => 'Unidad de valor real colombiano',
      'CRC' => 'Colón costarricense',
      'CUC' => 'Peso convertible cubano',
      'CUP' => 'Peso cubano',
      'CVE' => 'Escudo caboverdiano',
      'CZK' => 'Corona checa',
      'DJF' => 'Franco de Yibuti',
      'DKK' => 'Corona danesa',
      'DOP' => 'Peso dominicano',
      'DZD' => 'Dinar argelino',
      'EGP' => 'Libra egipcia',
      'ERN' => 'Eritrean Nakfa',
      'ETB' => 'Birr etíope',
      'EUR' => 'Euro',
      'FJD' => 'Dólar fiyiano',
      'FKP' => 'Libra de las Islas Malvinas',
      'GBP' => 'Libra británica',
      'GEL' => 'Lari georgiano',
      'GHS' => 'Cedi de Ghana',
      'GIP' => 'Libra gibraltareña',
      'GMD' => 'Dalasi de Gambia',
      'GNF' => 'Franco guineano',
      'GTQ' => 'Quetzal guatemalteco',
      'GYD' => 'Dólar de Guyana',
      'HKD' => 'Dolar de Hong Kong',
      'HNL' => 'Lempira hondureña',
      'HRK' => 'Kuna croata',
      'HTG' => 'Gourde haitiano',
      'HUF' => 'Florín húngaro',
      'IDR' => 'Rupia indonesia',
      'ILS' => 'Nuevo shekel israelí',
      'INR' => 'Rupia india',
      'IQD' => 'Dinar iraquí',
      'IRR' => 'Rial iraní',
      'ISK' => 'Corona islandesa',
      'JMD' => 'Dólar jamaiquino',
      'JOD' => 'Dinar jordano',
      'JPY' => 'Yen japonés',
      'KES' => 'Chelín keniano',
      'KGS' => 'Som kirguís',
      'KHR' => 'Riel camboyano',
      'KMF' => 'Franco comorano',
      'KPW' => 'Won norcoreano',
      'KRW' => 'Won surcoreano',
      'KWD' => 'Dinar kuwaití',
      'KYD' => 'Dólar de las Islas Caimán',
      'KZT' => 'Tenge kazajo',
      'LAK' => 'Kip de Laos',
      'LBP' => 'Libra libanesa',
      'LKR' => 'Rupia de Sri Lanka',
      'LRD' => 'Dólar liberiano',
      'LSL' => 'Loti de Lesoto',
      'LYD' => 'Dinar libio',
      'MAD' => 'Dirham marroquí',
      'MDL' => 'Leu moldavo',
      'MGA' => 'Ariary malgache',
      'MKD' => 'Denar macedonio',
      'MMK' => 'Kyat de Myanmar',
      'MNT' => 'Tugrik mongol',
      'MOP' => 'Pataca de Macao',
      'MRO' => 'Ouguiya mauritano',
      'MUR' => 'Rupia de Mauricio',
      'MWK' => 'Kwacha malauí',
      'MXN' => 'Peso mexicano',
      'MXV' => 'Unidad Mexicana de Inversiones',
      'MYR' => 'Ringgit malayo',
      'MZN' => 'Metical mozambiqueño',
      'NAD' => 'Dólar de Namibia',
      'NGN' => 'Naira nigeriana',
      'NIO' => 'Córdoba nicaragüense',
      'NOK' => 'Corona noruega',
      'NPR' => 'Rupia nepalí',
      'NZD' => 'Dolar de Nueva Zelanda',
      'OMR' => 'Rial omaní',
      'PAB' => 'Balboa panameño',
      'PEN' => 'Sol peruano',
      'PGK' => 'Kina de Papúa Nueva Guinea',
      'PHP' => 'Piso filipino',
      'PKR' => 'Rupia pakistaní',
      'PLN' => 'Zloty polaco',
      'PYG' => 'Guaraní paraguayo',
      'QAR' => 'Rial de Qatar',
      'RON' => 'Leu rumano',
      'RSD' => 'Dinar serbio',
      'RUB' => 'Rublo ruso',
      'RWF' => 'Franco ruandés',
      'SAR' => 'Riyal saudí',
      'SBD' => 'Dólar de las Islas Salomón',
      'SCR' => 'Rupia de Seychelles',
      'SDG' => 'Libra sudanesa',
      'SEK' => 'Corona sueca',
      'SGD' => 'Dolar de Singapur',
      'SHP' => 'Libra de Santa Elena',
      'SLL' => 'Sierra Leona Leona',
      'SOS' => 'Chelín somalí',
      'SRD' => 'Dólar surinamés',
      'SSP' => 'Libra sursudanesa',
      'STN' => 'Santo Tomé y Príncipe Dobra (2018)',
      'SYP' => 'Libra siria',
      'SZL' => 'Swazi Lilangeni',
      'SVC' => 'Colón salvadoreño',
      'THB' => 'Baht tailandés',
      'TJS' => 'Tayikistán Somoni',
      'TND' => 'Dinar tunecino',
      'TOP' => 'Tongan Paʻanga',
      'TRY' => 'Lira turca',
      'TTD' => 'Dólar de Trinidad y Tobago',
      'TWD' => 'Nuevo dólar taiwanés',
      'TZS' => 'Chelín de Tanzania',
      'UAH' => 'Grivna ucraniana',
      'UGX' => 'Chelín ugandés',
      'USD' => 'Dólar estadounidense',
      'USN' => 'Dólar estadounidense (día siguiente)',
      'UYI' => 'Peso uruguayo (unidades indexadas)',
      'UYU' => 'Peso uruguayo',
      'UZS' => 'Som uzbeko',
      'VEF' => 'Bolívar venezolano',
      'VND' => 'Dong vietnamita',
      'VUV' => 'Vanuatu Vatu',
      'WST' => 'Tala de Samoa',
      'XAF' => 'Franco CFA de África Central',
      'XCD' => 'Dólar del Caribe Oriental',
      'XOF' => 'Franco CFA de África Occidental',
      'XPF' => 'Franco CFP',
      'YER' => 'Rial yemení',
      'ZAR' => 'Rand sudafricano',
      'ZMW' => 'Kwacha de Zambia',
      'ZWL' => 'Dólar de Zimbabwe'
    ]
  ],
  'DashboardTemplate' => [
    'fields' => [
      'layout' => 'Diseño',
      'append' => 'Agregar (no elimina las pestañas del usuario)'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardTemplate' => 'Crear plantilla',
      'Deploy to Users' => 'Implementar a los usuarios',
      'Deploy to Team' => 'Implementar en equipo'
    ]
  ],
  'DashletOptions' => [
    'fields' => [
      'title' => 'Título',
      'dateFrom' => 'Fecha desde',
      'dateTo' => 'Fecha hasta',
      'autorefreshInterval' => 'Actualizar cada:',
      'displayRecords' => 'Mostrar Registros',
      'isDoubleHeight' => 'Altitud 2x',
      'mode' => 'Modo',
      'enabledScopeList' => 'Qué mostrar',
      'users' => 'Usuarios',
      'entityType' => 'Tipo de entidad',
      'primaryFilter' => 'Filtro principal',
      'boolFilterList' => 'Filtros adicionales',
      'sortBy' => 'Ordenar (campo)',
      'sortDirection' => 'Ordenar (dirección)',
      'expandedLayout' => 'Diseño',
      'skipOwn' => 'No mostrar registros propios',
      'url' => 'URL',
      'dateFilter' => 'Filtro de fecha',
      'text' => 'Text',
      'folder' => 'Folder',
      'includeShared' => 'Include Shared',
      'team' => 'Equipo',
      'futureDays' => 'Próximos X días',
      'useLastStage' => 'Agrupar por última etapa alcanzada',
      'report' => 'Informe',
      'column' => 'Columna de resumen',
      'displayOnlyCount' => 'Mostrar solo el total',
      'displayTotal' => 'Mostrar total',
      'useSiMultiplier' => 'Multiplicador SI',
      'displayType' => 'What to display'
    ],
    'options' => [
      'mode' => [
        'agendaWeek' => 'Semana (orden del día)',
        'basicWeek' => 'Semana',
        'month' => 'Mes',
        'basicDay' => 'Día',
        'agendaDay' => 'Día (agenda)',
        'timeline' => 'Línea de tiempo'
      ],
      'sortDirection' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ]
    ],
    'messages' => [
      'selectEntityType' => 'Seleccione el tipo de entidad en las opciones de la caja.'
    ],
    'tooltips' => [
      'skipOwn' => 'Las acciones realizadas por su cuenta de usuario no se mostrarán.'
    ]
  ],
  'DynamicLogic' => [
    'labels' => [
      'Field' => 'Campo'
    ],
    'options' => [
      'operators' => [
        'equals' => 'Es igual',
        'notEquals' => 'No es igual',
        'greaterThan' => 'Es mayor que',
        'lessThan' => 'Es menor que',
        'greaterThanOrEquals' => 'Es mayor o igual que',
        'lessThanOrEquals' => 'Es menor o igual que',
        'in' => 'Está en',
        'notIn' => 'No está en',
        'inPast' => 'Es antes de hoy',
        'inFuture' => 'Es después de hoy',
        'isToday' => 'Es hoy',
        'isTrue' => 'Es verdadero',
        'isFalse' => 'Es falso',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No está vacío',
        'contains' => 'Contiene',
        'notContains' => 'No Contiene',
        'has' => 'Contiene',
        'notHas' => 'No Contiene',
        'startsWith' => 'Starts With',
        'endsWith' => 'Ends With',
        'matches' => 'Matches (reg exp)'
      ]
    ]
  ],
  'Email' => [
    'fields' => [
      'name' => 'Asunto',
      'parent' => 'Padre',
      'status' => 'Estado',
      'dateSent' => 'Fecha de envío',
      'from' => 'De',
      'to' => 'Para',
      'cc' => 'CC',
      'bcc' => 'CCO',
      'replyTo' => 'Responder a',
      'replyToString' => 'Responder a (string)',
      'personStringData' => 'Datos de cadena de personas',
      'isHtml' => 'Es HTML',
      'body' => 'Cuerpo',
      'bodyPlain' => 'Cuerpo (plano)',
      'subject' => 'Asunto',
      'attachments' => 'Adjuntos',
      'selectTemplate' => 'Seleccione una plantilla',
      'fromEmailAddress' => 'De dirección (enlace)',
      'emailAddress' => 'Dirección de correo electrónico',
      'deliveryDate' => 'Fecha de entrega',
      'account' => 'Cuenta',
      'users' => 'Usuarios',
      'replied' => 'Es una respuesta a:',
      'replies' => 'Respondiste en:',
      'isRead' => 'Es leído',
      'isNotRead' => 'No leído',
      'isImportant' => 'Es importante',
      'isReplied' => 'Tiene respuesta',
      'isNotReplied' => 'No se respondieron',
      'isUsers' => 'Es del usuario',
      'isUsersSent' => 'Is User\'s Sent',
      'inTrash' => 'En papelera',
      'inArchive' => 'In Archive',
      'folder' => 'Carpeta',
      'inboundEmails' => 'Cuentas grupales',
      'emailAccounts' => 'Cuentas personales',
      'hasAttachment' => 'Tiene adjunto',
      'assignedUsers' => 'Usuarios asignados',
      'sentBy' => 'Enviado por',
      'toEmailAddresses' => 'A dirección de correo electrónico',
      'ccEmailAddresses' => 'Correos electrónicos CC',
      'bccEmailAddresses' => 'Correos electrónicos BBC',
      'replyToEmailAddresses' => 'Responder a la dirección de correo electrónico',
      'messageId' => 'ID del mensaje',
      'messageIdInternal' => 'ID del mensaje (interno)',
      'folderId' => 'ID de carpeta',
      'folderString' => 'Folder',
      'fromName' => 'De Nombre',
      'fromString' => 'De cadena',
      'fromAddress' => 'De (email)',
      'replyToName' => 'Responder a nombre',
      'replyToAddress' => 'Responder a la dirección',
      'isSystem' => '¿Es sistema?',
      'icsContents' => 'ICS Contents',
      'icsEventData' => 'ICS Event Data',
      'icsEventUid' => 'ICS Event UID',
      'createdEvent' => 'Created Event',
      'event' => 'Event',
      'icsEventDateStart' => 'ICS Event Date Start',
      'groupFolder' => 'Group Folder',
      'groupStatusFolder' => 'Group Status Folder',
      'sendAt' => 'Send At',
      'tasks' => 'Tasks'
    ],
    'links' => [
      'replied' => 'Es una respuesta a:',
      'replies' => 'Respondiste en:',
      'inboundEmails' => 'Cuentas grupales',
      'emailAccounts' => 'Cuentas personales',
      'assignedUsers' => 'Usuarios asignados',
      'sentBy' => 'Enviado por',
      'attachments' => 'Adjuntos',
      'fromEmailAddress' => 'De correo electrónico',
      'toEmailAddresses' => 'A dirección de correo electrónico',
      'ccEmailAddresses' => 'Correos electrónicos CC',
      'bccEmailAddresses' => 'Correos electrónicos BBC',
      'replyToEmailAddresses' => 'Responder a la dirección de correo electrónico',
      'createdEvent' => 'Created Event',
      'groupFolder' => 'Group Folder'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Sending' => 'Enviando',
        'Sent' => 'Enviado',
        'Archived' => 'Archivado',
        'Received' => 'Recibido',
        'Failed' => 'Falló'
      ],
      'groupStatusFolder' => [
        'Archive' => 'Archive',
        'Trash' => 'Trash'
      ]
    ],
    'labels' => [
      'Create Email' => 'Nuevo correo archivado',
      'Archive Email' => 'Nuevo correo archivado',
      'Import EML' => 'Import EML',
      'Compose' => 'Nuevo',
      'Reply' => 'Responder',
      'Reply to All' => 'Responder a todos',
      'Forward' => 'Reenviar',
      'Insert Field' => 'Insertar campo',
      'Original message' => 'Mensaje original',
      'Forwarded message' => 'Mensaje reenviado',
      'Email Accounts' => 'Ir a cuentas de correo personales',
      'Inbound Emails' => 'Ir a cuentas de correo grupales',
      'Email Templates' => 'Plantillas de correo',
      'Send Test Email' => 'Enviar correo electrónico de prueba',
      'Send' => 'Enviar',
      'Email Address' => 'Correo electrónico',
      'Mark Read' => 'Marcar como leído',
      'Sending...' => 'Enviando...',
      'Save Draft' => 'Guardar borrador',
      'Mark all as read' => 'Marcar todos como leídos',
      'Show Plain Text' => 'Ver en texto plano',
      'Mark as Important' => 'Marcar como importante',
      'Unmark Importance' => 'Marcar como No importante',
      'Move to Trash' => 'Mover a la papelera',
      'Retrieve from Trash' => 'Recuperar de la papelera',
      'Move to Folder' => 'Mover a la carpeta',
      'Moved to Archive' => 'Moved to Archive',
      'No Records Moved' => 'No Records Moved',
      'Filters' => 'Filtros',
      'Folders' => 'Ir a carpetas de correo',
      'Group Folders' => 'Group Folders',
      'No Subject' => 'Sin asunto',
      'View Users' => 'Ver usuarios',
      'Event' => 'Event',
      'View Attachments' => 'View Attachments',
      'Moved to Trash' => 'Moved to Trash',
      'Retrieved from Trash' => 'Retrieved from Trash',
      'Schedule Send' => 'Schedule Send',
      'Create Lead' => 'Crear posible cliente',
      'Create Contact' => 'Crear contacto',
      'Add to Contact' => 'Agregar a contacto',
      'Add to Lead' => 'Agregar a posible cliente',
      'Create Task' => 'Crear tarea',
      'Create Case' => 'Crear ticket'
    ],
    'strings' => [
      'sendingFailed' => 'Error al enviar el correo electrónico',
      'group' => 'Group'
    ],
    'messages' => [
      'confirmSend' => 'Send the email?',
      'couldNotSentScheduledEmail' => 'Could not send scheduled [email]({link})',
      'notEditAccess' => 'No edit access to email.',
      'groupFolderNoAccess' => 'No access to group folder.',
      'groupMoveOutNoEditAccess' => 'Cannot move out from group folder. No edit access to email.',
      'groupMoveToNoEditAccess' => 'Cannot move to group folder. No edit access to email.',
      'groupMoveToTrashNoEditAccess' => 'Cannot move email from group folder to trash. No edit access to email.',
      'groupMoveToArchiveNoEditAccess' => 'Cannot move from group folder to Archive. No edit access to email.',
      'alreadyImported' => 'The [email]({link}) already exists in the system.',
      'invalidCredentials' => 'Invalid credentials.',
      'unknownError' => 'Unknown error.',
      'recipientAddressRejected' => 'Recipient address rejected.',
      'noSmtpSetup' => 'SMTP no está configurado: {link}',
      'testEmailSent' => 'El correo de prueba ha sido enviado.',
      'emailSent' => 'El correo electrónico ha sido enviada',
      'savedAsDraft' => 'Guardado como borrador',
      'sendConfirm' => '¿Enviar el correo electrónico?',
      'removeSelectedRecordsConfirmation' => '¿Está seguro de que desea eliminar los correos electrónicos seleccionados?

También se eliminarán para otros usuarios.',
      'removeRecordConfirmation' => '¿Estás seguro de que deseas eliminar el correo electrónico?

También se eliminará para otros usuarios.',
      'confirmInsertTemplate' => 'El cuerpo del correo electrónico se perderá. ¿Seguro que quieres insertar la plantilla?'
    ],
    'presetFilters' => [
      'sent' => 'Enviados',
      'archived' => 'Archivado',
      'inbox' => 'Bandeja de entrada',
      'drafts' => 'Borradores',
      'trash' => 'Papelera',
      'archive' => 'Archive',
      'important' => 'Importante'
    ],
    'actions' => [
      'moveToArchive' => 'Archive'
    ],
    'massActions' => [
      'markAsRead' => 'Marcar como leído',
      'markAsNotRead' => 'Marcar como No leído',
      'markAsImportant' => 'Marcar como importante',
      'markAsNotImportant' => 'Marcar como No importante',
      'moveToTrash' => 'Mover a la papelera',
      'moveToFolder' => 'Mover a la carpeta',
      'moveToArchive' => 'Archive',
      'retrieveFromTrash' => 'Recuperar de la papelera'
    ],
    'otherFields' => [
      'file' => 'File'
    ]
  ],
  'EmailAccount' => [
    'fields' => [
      'name' => 'Nombre de la cuenta',
      'status' => 'Estado',
      'host' => 'Servidor',
      'username' => 'Nombre de usuario',
      'password' => 'Contraseña',
      'port' => 'Puerto',
      'monitoredFolders' => 'Carpetas sincronizadas',
      'security' => 'Seguridad',
      'fetchSince' => 'Traer correos desde',
      'emailAddress' => 'Correo electrónico',
      'sentFolder' => 'Carpeta de enviados',
      'storeSentEmails' => 'Almacenar correos enviados',
      'keepFetchedEmailsUnread' => 'Mantener los correos que se han obtenido sin leer',
      'emailFolder' => 'Poner en la carpeta',
      'connectedAt' => 'Connected At',
      'useImap' => 'Obtener correos electrónicos',
      'useSmtp' => 'Usar SMTP',
      'smtpHost' => 'Servidor SMTP',
      'smtpPort' => 'Puerto SMTP',
      'smtpAuth' => 'Autentificación SMTP',
      'smtpSecurity' => 'Seguridad SMTP',
      'smtpAuthMechanism' => 'Mecanismo de autenticación SMTP',
      'smtpUsername' => 'Usuario SMTP',
      'smtpPassword' => 'Contraseña SMTP'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Correos'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'Entrar',
        'crammd5' => 'RAM-MD5'
      ]
    ],
    'labels' => [
      'Create EmailAccount' => 'Crear cuenta pesonal',
      'IMAP' => 'IMAP',
      'Main' => 'Principal',
      'Test Connection' => 'Probar conexión',
      'Send Test Email' => 'Enviar correo electrónico de prueba',
      'SMTP' => 'SMTP'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'No se pudo conectar con el servidor IMAP',
      'connectionIsOk' => 'Conexión correcta',
      'imapNotConnected' => 'Could not connect to [IMAP account](#EmailAccount/view/{id}).'
    ],
    'tooltips' => [
      'useSmtp' => 'La capacidad de enviar correos electrónicos.',
      'emailAddress' => 'El registro de usuario (usuario asignado) debe tener la misma dirección de correo electrónico para poder utilizar esta cuenta de correo electrónico para enviar.',
      'monitoredFolders' => 'Las carpetas deben estar separadas por comas.

Puede agregar una carpeta \'Enviados\' para sincronizar los correos electrónicos enviados desde un cliente externo.',
      'storeSentEmails' => 'Los correos electrónicos enviados se almacenarán en el servidor IMAP. El campo Dirección de correo electrónico debe coincidir con la dirección desde donde se enviarán los correos electrónicos.'
    ]
  ],
  'EmailAddress' => [
    'labels' => [
      'Primary' => 'Principal',
      'Opted Out' => 'Se dieron de baja',
      'Invalid' => 'Inválido'
    ],
    'fields' => [
      'optOut' => 'Opted Out',
      'invalid' => 'Inválido'
    ],
    'presetFilters' => [
      'orphan' => 'Huérfano'
    ]
  ],
  'EmailFilter' => [
    'fields' => [
      'from' => 'De',
      'to' => 'Para',
      'subject' => 'Asunto',
      'bodyContains' => 'Contenido del cuerpo',
      'bodyContainsAll' => 'Body Contains All',
      'action' => 'Acción',
      'isGlobal' => 'Es global',
      'emailFolder' => 'Carpeta',
      'groupEmailFolder' => 'Group Email Folder',
      'markAsRead' => 'Mark as Read',
      'skipNotification' => 'Skip Notification'
    ],
    'links' => [
      'emailFolder' => 'Folder',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'labels' => [
      'Create EmailFilter' => 'Crear un filtro de email',
      'Emails' => 'Correos'
    ],
    'options' => [
      'action' => [
        'None' => 'None',
        'Skip' => 'Ignorar',
        'Move to Folder' => 'Poner en la carpeta',
        'Move to Group Folder' => 'Put in Group Folder'
      ]
    ],
    'tooltips' => [
      'name' => 'Dé al filtro un nombre descriptivo.',
      'subject' => 'Utilice un comodín *:

 * `texto *` - comienza con texto,
 * `* texto *` - contiene texto,
 * `* texto` - termina con texto.',
      'bodyContains' => 'Filtra los correos que en el cuerpo contengan cualquiera de estas palabras o frases.',
      'bodyContainsAll' => 'An email body contains all specified words or phrases.',
      'from' => 'Filtra los correos enviados desde esta dirección. Dejar en blanco si no es necesario. Puede usar el comodín *.',
      'to' => 'Filtra los correos enviados a esta dirección. Dejar en blanco si no es necesario. Puede usar el comodín *.',
      'isGlobal' => 'Aplica este filtro a todos los correos entrantes del sistema.'
    ]
  ],
  'EmailFolder' => [
    'fields' => [
      'skipNotifications' => 'Omitir notificaciones'
    ],
    'labels' => [
      'Create EmailFolder' => 'Crear carpeta',
      'Manage Folders' => 'Administrar carpetas',
      'Emails' => 'Correos'
    ]
  ],
  'EmailTemplate' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'isHtml' => 'Es HTML',
      'body' => 'Cuerpo',
      'subject' => 'Asunto',
      'attachments' => 'Adjuntos',
      'oneOff' => 'Único',
      'category' => 'Categoría',
      'insertField' => 'Marcadores de posición'
    ],
    'links' => [],
    'labels' => [
      'Create EmailTemplate' => 'Crear plantilla de correo',
      'Info' => 'Información',
      'Available placeholders' => 'Placeholders disponibles'
    ],
    'messages' => [
      'infoText' => 'Marcadores de posición disponibles:

{optOutUrl} & # 8211; URL para un enlace para darse de baja;

{optOutLink} & # 8211; un enlace para darse de baja.'
    ],
    'tooltips' => [
      'oneOff' => 'Marque la casilla si usted va a utilizar esta plantilla solo una vez. Por ejemplo para correo masivo.'
    ],
    'presetFilters' => [
      'actual' => 'Actuales'
    ],
    'placeholderTexts' => [
      'today' => 'El día de hoy',
      'now' => 'Fecha y hora actual',
      'currentYear' => 'Año actual',
      'optOutUrl' => 'URL for an unsubscribe link',
      'optOutLink' => 'un enlace para darse de baja'
    ]
  ],
  'EmailTemplateCategory' => [
    'labels' => [
      'Create EmailTemplateCategory' => 'Crear categoría',
      'Manage Categories' => 'Administrar categorías',
      'EmailTemplates' => 'Plantillas de correo electrónico'
    ],
    'fields' => [
      'order' => 'Orden',
      'childList' => 'Lista hija'
    ],
    'links' => [
      'emailTemplates' => 'Plantillas de correo electrónico'
    ]
  ],
  'EntityManager' => [
    'labels' => [
      'Fields' => 'Campos',
      'Relationships' => 'Relaciones',
      'Layouts' => 'Diseños',
      'Schedule' => 'Programar',
      'Log' => 'Registros',
      'Formula' => 'Fórmula',
      'Parameters' => 'Parameters'
    ],
    'fields' => [
      'name' => 'Nombre',
      'type' => 'Tipo',
      'labelSingular' => 'Etiqueta en singular',
      'labelPlural' => 'Etiqueta en plural',
      'stream' => 'Historia',
      'label' => 'Etiqueta',
      'linkType' => 'Tipo de enlace',
      'entity' => 'Entity',
      'entityForeign' => 'Entidad foránea',
      'linkForeign' => 'Enlace Foráneo',
      'link' => 'Enlace',
      'labelForeign' => 'Etiqueta Foránea',
      'sortBy' => 'Orden por defecto (campo)',
      'sortDirection' => 'Orden por defecto (dirección)',
      'relationName' => 'Nombre de la Tabla Intermedia',
      'linkMultipleField' => 'Enlaza múltiples campos',
      'linkMultipleFieldForeign' => 'Enlaza múltiples campos foráneos',
      'disabled' => 'Desactivado',
      'textFilterFields' => 'Los campos de filtro de texto',
      'audited' => 'Auditado',
      'auditedForeign' => 'Foráneo auditado',
      'statusField' => 'Campo estado',
      'beforeSaveCustomScript' => 'Antes de guardar la secuencia de comandos personalizada',
      'beforeSaveApiScript' => 'API Before Save Script',
      'color' => 'Color',
      'kanbanViewMode' => 'Vista Kanban',
      'kanbanStatusIgnoreList' => 'Grupos ignorados en la vista Kanban',
      'iconClass' => 'Ícono',
      'countDisabled' => 'Deshabilitar recuento de registros',
      'fullTextSearch' => 'Búsqueda de texto completo',
      'parentEntityTypeList' => 'Tipos de entidad principal',
      'foreignLinkEntityTypeList' => 'Enlaces extranjeros',
      'optimisticConcurrencyControl' => 'Optimistic concurrency control',
      'preserveAuditLog' => 'Preserve Audit Log',
      'updateDuplicateCheck' => 'Duplicate check on update',
      'duplicateCheckFieldList' => 'Duplicate check fields',
      'stars' => 'Stars',
      'layout' => 'Layout',
      'selectFilter' => 'Select Filter',
      'author' => 'Author',
      'module' => 'Module',
      'version' => 'Version',
      'primaryFilters' => 'Primary Filters',
      'assignedUsers' => 'Multiple Assigned Users',
      'collaborators' => 'Collaborators',
      'aclContactLink' => 'ACL Contact Link',
      'aclAccountLink' => 'ACL Account Link',
      'activityStatusList' => 'Activity Statuses',
      'historyStatusList' => 'History Statuses',
      'completedStatusList' => 'Completed Statuses',
      'canceledStatusList' => 'Canceled Statuses',
      'variantSyncFieldList' => 'Variant sync fields',
      'doneStatusList' => 'Done Statuses',
      'softReserveStatusList' => 'Soft Reserve Statuses',
      'reserveStatusList' => 'Reserve Statuses',
      'failedStatusList' => 'Failed Statuses',
      'deliveryRequiredStatusList' => 'Delivery Required Statuses',
      'lockableFieldList' => 'Lock Fields'
    ],
    'options' => [
      'type' => [
        '' => 'Ninguno',
        'Base' => 'Base',
        'Person' => 'Persona',
        'CategoryTree' => 'Árbol de categorías',
        'Event' => 'Evento',
        'BasePlus' => 'Base Plus',
        'Company' => 'Empresa'
      ],
      'linkType' => [
        'manyToMany' => 'Mucho-a-Muchos',
        'oneToMany' => 'Uno-a-Muchos',
        'manyToOne' => 'Muchos-a-uno',
        'oneToOneRight' => 'Uno a uno a la derecha',
        'oneToOneLeft' => 'Uno a uno a la izquierda',
        'parentToChildren' => 'Padres-a-Hijos',
        'childrenToParent' => 'Hijos-a-Padres'
      ],
      'sortDirection' => [
        'asc' => 'Ascendente',
        'desc' => 'Descendente'
      ],
      'module' => [
        'Custom' => 'Custom'
      ]
    ],
    'messages' => [
      'urlHashCopiedToClipboard' => 'A URL fragment for the *{name}* filter is copied to the clipboard. You can add it to the navbar.',
      'confirmRemoveLink' => 'Are you sure you want to remove the *{link}* relationship?',
      'nameIsAlreadyUsed' => 'Name \'{name}\' is already used.',
      'nameIsNotAllowed' => 'Name \'{name}\' is not allowed.',
      'nameIsTooLong' => 'Name is too long.',
      'confirmRemove' => '¿Está seguro de que desea eliminar el tipo de entidad del sistema?',
      'entityCreated' => 'La entidad ha sido creada',
      'linkAlreadyExists' => 'Conflicto de nombres en el enlace.',
      'linkConflict' => 'Conflicto de nombres: un enlace o campo con el mismo nombre ya existe.',
      'beforeSaveCustomScript' => 'A script called every time before an entity is saved. Use for setting calculated fields.',
      'beforeSaveApiScript' => 'A script called on create and update API requests before an entity is saved. Use for custom validation and duplicate checking.'
    ],
    'tooltips' => [
      'aclContactLink' => 'The link with Contact to use when applying access control for portal users.',
      'aclAccountLink' => 'The link with Account to use when applying access control for portal users.',
      'collaborators' => 'The ability to share records with specific users.',
      'assignedUsers' => 'The ability to assign multiple users to a record.

Note that after enabling the parameter, existing assigned users won\'t be transferred to the new *Assigned Users* field.',
      'duplicateCheckFieldList' => 'Which fields to check when performing checking for duplicates.',
      'updateDuplicateCheck' => 'Perform checking for duplicates when updating a record.',
      'optimisticConcurrencyControl' => 'Prevents writing conflicts.',
      'preserveAuditLog' => 'Disables cleanup of the audit log. This parameter is applicable only if Stream is disabled. As if Stream is enabled, audit log records are not being deleted.',
      'stars' => 'The ability to star records. Stars can be used by users to bookmark records.',
      'statusField' => 'Las actualizaciones de este campo se registran en la historia.',
      'textFilterFields' => 'Campos utilizados por la búsqueda de texto.',
      'stream' => 'Marque para que la entidad tenga historia.',
      'disabled' => 'Marque si no necesita esta entidad en su sistema.',
      'linkAudited' => 'Crear un registro relacionado y vincularlo con el registro existente, hará que se registre en la historia.',
      'linkMultipleField' => 'El campo de relaciones múltiples proporciona una manera práctica de editar relaciones. No lo use si puede tener un gran número de registros relacionados.',
      'linkSelectFilter' => 'A primary filter to apply by default when selecting a record.',
      'entityType' => 'Base: Sin elementos adicionales 

Base Plus - Similar a Posibles clientes y Oportunidades (tiene paneles de Actividades planeadas, Historial de actividades y Tareas).

Evento - Similar a Reuniones y Llamadas (disponible en Calendario y en el Panel de Actividades).

Persona - Similar a Contacto.

Empresa - Similar a Cuenta.',
      'countDisabled' => 'El número total no se mostrará en la vista de lista. Puede disminuir el tiempo de carga cuando la tabla DB es grande.',
      'fullTextSearch' => 'Se requiere ejecutar la reconstrucción.',
      'linkParamReadOnly' => 'A read-only link cannot be edited via the *link* and *unlink* API requests. It won\'t be possible to relate and unrelate records via the relationship panel. It still possible to edit read-only links via link and link-multiple fields.',
      'activityStatusList' => 'Status values determining that an activity record should be displayed in the Activity panel and considered as actual.',
      'historyStatusList' => 'Status values determining that an activity record should be displayed in the History panel.',
      'completedStatusList' => 'Status values determining that an activity is completed.',
      'canceledStatusList' => 'Status values determining that an activity is canceled and won\'t be taken into account in free/busy ranges.',
      'lockableFieldList' => 'Fields that become read-only when an order is locked.',
      'productVariantSyncFieldList' => 'Fields that are synced from a template to product variants.',
      'salesOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'salesOrderDoneStatusList' => 'Statuses indicating that a sales order is done.',
      'purchaseOrderDoneStatusList' => 'Statuses indicating that a purchase order is done.',
      'purchaseOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'receiptOrderDoneStatusList' => 'Statuses indicating that a receipt order is done.',
      'receiptOrderCanceledStatusList' => 'Statuses indicating that a receipt order is canceled.',
      'salesOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'invoiceDoneStatusList' => 'Statuses indicating that an invoice is done.',
      'invoiceCanceledStatusList' => 'Statuses indicating that an invoice is canceled.',
      'quoteDoneStatusList' => 'Statuses indicating that a quote is done.',
      'quoteCanceledStatusList' => 'Statuses indicating that a quote is canceled.',
      'deliveryRequiredStatusList' => 'Statuses on which a delivery order should be created.',
      'deliveryOrderCanceledStatusList' => 'Statuses indicating that a delivery order is canceled. Inventory is automatically returned to stock.',
      'deliveryOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'deliveryOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'deliveryOrderFailedStatusList' => 'Statuses indicating that a delivery order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'deliveryOrderDoneStatusList' => 'Statuses indicating that a delivery order is done.',
      'transferOrderCanceledStatusList' => 'Statuses indicating that a transfer order is canceled. Inventory is automatically returned to stock.',
      'transferOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'transferOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'transferOrderFailedStatusList' => 'Statuses indicating that a transfer order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'transferOrderDoneStatusList' => 'Statuses indicating that a transfer order is done.',
      'returnOrderDoneStatusList' => 'Statuses indicating that a return order is done.',
      'returnOrderCanceledStatusList' => 'Statuses indicating that a return order is canceled.'
    ]
  ],
  'Export' => [
    'fields' => [
      'exportAllFields' => 'Exportar todos los campos',
      'fieldList' => 'Lista de campos',
      'format' => 'Formato',
      'status' => 'Status',
      'xlsxLite' => 'Lite',
      'xlsxRecordLinks' => 'Record Links',
      'xlsxTitle' => 'Title'
    ],
    'options' => [
      'format' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'tooltips' => [
      'xlsxLite' => 'Consumes much less memory. Recommended if a big number of records is exported.',
      'xlsxTitle' => 'Print a title and current date in the header.'
    ],
    'messages' => [
      'exportProcessed' => 'Export has been processed. Download the [file]({url}).',
      'infoText' => 'The export is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Extension' => [
    'fields' => [
      'name' => 'Nombre',
      'version' => 'Versión',
      'description' => 'Descripción',
      'isInstalled' => 'Instalado',
      'checkVersionUrl' => 'Una URL para verificar nuevas versiones'
    ],
    'labels' => [
      'Uninstall' => 'Desinstalar',
      'Install' => 'Instalar'
    ],
    'messages' => [
      'uninstalled' => 'Extensión {name} ha sido desinstalada',
      'fileExceedsMaxUploadSize' => 'The file size exceeds the max upload size {maxSize}. Consider increasing `post_max_size` or install the extension via CLI.'
    ]
  ],
  'ExternalAccount' => [
    'labels' => [
      'Connect' => 'Conectar',
      'Disconnect' => 'Desconectar',
      'Disconnected' => 'Desconectado',
      'Connected' => 'Conectado'
    ],
    'help' => [],
    'messages' => [
      'externalAccountNoConnectDisabled' => 'External account for integration \'{integration}\' has been disabled due not being able to connect.'
    ]
  ],
  'FieldManager' => [
    'labels' => [
      'Dynamic Logic' => 'Lógica dinámica',
      'Name' => 'Nombre',
      'Label' => 'Etiqueta',
      'Type' => 'Tipo'
    ],
    'options' => [
      'dateTimeDefault' => [
        '' => 'Nada',
        'javascript: return this.dateTime.getNow(1);' => 'Ahora',
        'javascript: return this.dateTime.getNow(5);' => 'Ahora (5m)',
        'javascript: return this.dateTime.getNow(15);' => 'Ahora (15m)',
        'javascript: return this.dateTime.getNow(30);' => 'Ahora (30m)',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'hours\', 15);' => '+1 hora',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'hours\', 15);' => '+2 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'hours\', 15);' => '+3 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'hours\', 15);' => '+4 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'hours\', 15);' => '+5 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'hours\', 15);' => '+6 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(7, \'hours\', 15);' => '+7 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(8, \'hours\', 15);' => '+8 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(9, \'hours\', 15);' => '+9 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(10, \'hours\', 15);' => '+10 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(11, \'hours\', 15);' => '+11 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(12, \'hours\', 15);' => '+12 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'days\', 15);' => '+1 día',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'days\', 15);' => '+2 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'days\', 15);' => '+3 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'days\', 15);' => '+4 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'days\', 15);' => '+5 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'days\', 15);' => '+6 días',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'week\', 15);' => '+1 semana'
      ],
      'dateDefault' => [
        '' => 'Nada',
        'javascript: return this.dateTime.getToday();' => 'Hoy',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'days\');' => '+1 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'days\');' => '+2 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'days\');' => '+3 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'days\');' => '+4 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'days\');' => '+5 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'days\');' => '+6 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'days\');' => '+7 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'days\');' => '+8 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'days\');' => '+9 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'days\');' => '+10 días',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'weeks\');' => '+1 semana',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'weeks\');' => '+2 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'weeks\');' => '+3 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'months\');' => '+1 mes',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'months\');' => '+2 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'months\');' => '+3 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'months\');' => '+4 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'months\');' => '+5 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'months\');' => '+6 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'months\');' => '+7 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'months\');' => '+8 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'months\');' => '+9 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'months\');' => '+10 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(11, \'months\');' => '+11 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'year\');' => '+1 año'
      ],
      'barcodeType' => [
        'EAN13' => 'EAN-13',
        'EAN8' => 'EAN-8',
        'EAN5' => 'EAN-5',
        'EAN2' => 'EAN-2',
        'UPC' => 'UPC (A)',
        'UPCE' => 'UPC (E)',
        'pharmacode' => 'Pharmacode',
        'QRcode' => 'Código QR'
      ],
      'globalRestrictions' => [
        'forbidden' => 'Forbidden',
        'internal' => 'Internal',
        'onlyAdmin' => 'Admin-only',
        'readOnly' => 'Read-only',
        'nonAdminReadOnly' => 'Non-admin read-only'
      ]
    ],
    'tooltips' => [
      'optionsReference' => 'Re-use options from another field.',
      'currencyDecimal' => 'Use the Decimal DB type. In the app, values will be represented as strings. Check this parameter if precision is required.',
      'cutHeight' => 'A text higher then a specified value will be cut with a \'show more\' button displayed.',
      'urlStrip' => 'Strip a protocol and a trailing slash.',
      'audited' => 'Las actualizaciones se registrarán en la historia.',
      'required' => 'El campo será obligatorio. No se puede dejar vacío.',
      'default' => 'El valor se establecerá de forma predeterminada al guardar.',
      'min' => 'Valor mínimo aceptado.',
      'max' => 'Valor máximo aceptado.',
      'seeMoreDisabled' => 'Si no se marca, los textos largos se cortarán.',
      'lengthOfCut' => 'Que largo tendrán los textos antes de ser cortados.',
      'maxLength' => 'Longitud máxima aceptable del texto.',
      'before' => 'El valor de fecha debe ser anterior al valor de fecha del campo especificado.',
      'after' => 'El valor de fecha debe ser posterior al valor de fecha del campo especificado.',
      'readOnly' => 'El usuario no puede especificar el valor del campo. Pero se puede calcular por fórmula.',
      'readOnlyAfterCreate' => 'The field value can be specified when creating a new record. After that, the field becomes read-only. It can still be calculated by formula.',
      'preview' => 'Show the preview button. Applicable if Markdown is enabled.',
      'fileAccept' => 'Qué tipos de archivos aceptar. Es posible agregar elementos personalizados.',
      'barcodeLastChar' => 'Para el tipo EAN-13.',
      'maxFileSize' => 'Si está vacío o es 0, entonces no limitar',
      'conversionDisabled' => 'The currency conversion action won\'t be applied to this field.',
      'pattern' => 'A regular expression to check a field value against. Define an expression or select a predefined one.',
      'options' => 'A list of possible values and their labels.',
      'optionsArray' => 'A list of possible values and their labels. If empty, the field will allow entering custom values.',
      'maxCount' => 'Maximum number of items allowed to be selected.',
      'displayAsList' => 'Each item in a new line.',
      'optionsVarchar' => 'A list of autocomplete values.',
      'linkReadOnly' => 'Field value can\'t be specified by user. But can be calculated by formula.

It will also disable the ability to create a related record from relationship panels.',
      'relateOnImport' => 'When importing with this field, it will automatically relate a record with a matching foreign record. Use this functionality only if the foreign field is considered as unique.'
    ],
    'fieldParts' => [
      'address' => [
        'street' => 'Calle',
        'city' => 'Ciudad',
        'state' => 'Estado',
        'country' => 'País',
        'postalCode' => 'Código Postal',
        'map' => 'Mapa'
      ],
      'personName' => [
        'salutation' => 'Saludo',
        'first' => 'Nombre',
        'middle' => 'Medio',
        'last' => 'Apellido'
      ],
      'currency' => [
        'converted' => '(Convertido)',
        'currency' => '(Moneda)'
      ],
      'datetimeOptional' => [
        'date' => 'Fecha'
      ]
    ],
    'fieldInfo' => [
      'varchar' => 'Un texto de una sola línea.',
      'enum' => 'En la casilla de selección, solo se puede seleccionar un valor.',
      'text' => 'Un texto de varias líneas con soporte de rebajas.',
      'date' => 'Fecha sin hora.',
      'datetime' => 'Fecha y hora',
      'currency' => 'Un valor de moneda. Un número flotante con un código de moneda.',
      'int' => 'Un número entero.',
      'float' => 'Un número con una parte decimal.',
      'bool' => 'Una casilla de verificación. Dos valores posibles: verdadero y falso.',
      'multiEnum' => 'Se puede seleccionar una lista de valores, múltiples valores. La lista está ordenada.',
      'checklist' => 'Una lista de casillas de verificación.',
      'array' => 'Una lista de valores, similar al campo Multi-Enum.',
      'address' => 'Una dirección con calle, ciudad, estado, código postal y país.',
      'url' => 'Para almacenar enlaces.',
      'urlMultiple' => 'Multiple links.',
      'wysiwyg' => 'Un texto con soporte HTML.',
      'file' => 'Para cargar archivos.',
      'image' => 'Para cargar imágenes.',
      'attachmentMultiple' => 'Permite cargar varios archivos.',
      'number' => 'Un número de tipo de cadena que se incrementa automáticamente con un posible prefijo y una longitud específica.',
      'autoincrement' => 'Un número entero generado de solo lectura que se incrementa automáticamente.',
      'barcode' => 'Un código de barras. Puede imprimirse en PDF.',
      'email' => 'Un conjunto de direcciones de correo electrónico con sus parámetros: inhabilitado, no válido, principal.',
      'phone' => 'Un conjunto de números de teléfono con sus parámetros: tipo, inhabilitado, no válido, principal.',
      'foreign' => 'Un campo de un registro relacionado. Solo lectura.',
      'link' => 'Un registro relacionado a través de la relación Pertenece a (varios a uno o uno a uno).',
      'linkParent' => 'Un registro relacionado a través de la relación Pertenece a los padres. Puede ser de diferentes tipos de entidad.',
      'linkMultiple' => 'A set of records related through Has-Many (many-to-many or one-to-many) relationship. Not all relationships have their link-multiple fields. Only those do, where Link-Multiple parameter(s) is enabled.'
    ],
    'messages' => [
      'fieldCreatedAddToLayouts' => 'Field has been created. Now, you can add it to [layouts]({link})',
      'confirmRemove' => 'Are you sure you want to remove the *{field}* field?

Field removal does not remove data from the database. Data from the database will be removed if you run hard rebuild.',
      'fieldNameIsNotAllowed' => 'Field name \'{field}\' is not allowed.',
      'fieldAlreadyExists' => 'Field \'{field}\' already exists in \'{entityType}\'.',
      'linkWithSameNameAlreadyExists' => 'Link with the name \'{field}\' already exists in \'{entityType}\'.',
      'namingFieldLinkConflict' => 'Name \'{field}\' conflicts with link.'
    ]
  ],
  'Formula' => [
    'labels' => [
      'Check Syntax' => 'Check Syntax',
      'Run' => 'Run'
    ],
    'fields' => [
      'target' => 'Target',
      'targetType' => 'Target Type',
      'script' => 'Script',
      'output' => 'Output',
      'error' => 'Error'
    ],
    'messages' => [
      'runSuccess' => 'Executed successfully.',
      'runError' => 'Error.',
      'checkSyntaxSuccess' => 'Syntax is correct.',
      'checkSyntaxError' => 'Syntax error.',
      'emptyScript' => 'Script is empty.'
    ],
    'tooltips' => [
      'output' => 'Print values with the function `output\\printLine`.'
    ]
  ],
  'Global' => [
    'scopeNames' => [
      'Note' => 'Note',
      'Email' => 'Correo electrónico',
      'User' => 'Usuario',
      'Team' => 'Equipo',
      'Role' => 'Rol',
      'EmailTemplate' => 'Plantilla de Correo',
      'EmailTemplateCategory' => 'Categorías de plantillas de correo electrónico',
      'EmailAccount' => 'Cuenta de correo personal',
      'EmailAccountScope' => 'Cuenta de correo personal',
      'OutboundEmail' => 'Correo Saliente',
      'ScheduledJob' => 'Tarea Programada',
      'ExternalAccount' => 'Cuenta Externa',
      'Extension' => 'Extensión',
      'Dashboard' => 'Escritorio',
      'InboundEmail' => 'Cuenta de correo grupal',
      'Stream' => 'Historia',
      'Import' => 'Importar',
      'ImportError' => 'Import Error',
      'Template' => 'Plantilla',
      'Job' => 'Trabajo',
      'EmailFilter' => 'Filtro de correo',
      'Portal' => 'Portal',
      'PortalRole' => 'Rol del portal',
      'Attachment' => 'Adjunto',
      'EmailFolder' => 'Carpeta de correo electrónico',
      'GroupEmailFolder' => 'Group Email Folder',
      'PortalUser' => 'Usuario del portal',
      'ApiUser' => 'Usuario de API',
      'ScheduledJobLogRecord' => 'Registro del registro de trabajo programado',
      'PasswordChangeRequest' => 'Solicitar Cambio de Contraseña',
      'ActionHistoryRecord' => 'Registro del histórico',
      'AuthToken' => 'Token de autenticación',
      'UniqueId' => 'ID Único',
      'LastViewed' => 'Historial de acciones',
      'Settings' => 'Ajustes',
      'FieldManager' => 'Administrador de campos',
      'Integration' => 'Integración',
      'LayoutManager' => 'Administrador de diseño',
      'EntityManager' => 'Gestionar de entidades',
      'Export' => 'Exportar',
      'DynamicLogic' => 'Lógica dinámica',
      'DashletOptions' => 'Ajustes de cajas',
      'Admin' => 'Administrador',
      'Global' => 'Global',
      'Preferences' => 'Preferencias',
      'EmailAddress' => 'Correo electrónico',
      'PhoneNumber' => 'Número de teléfono',
      'AppLogRecord' => 'App Log Record',
      'AuthLogRecord' => 'Entrada del registro de autenticación',
      'AuthFailLogRecord' => 'Entrada de registros de fallos de autenticación ',
      'LeadCapture' => 'Punto de entrada de captura de clientes potenciales',
      'LeadCaptureLogRecord' => 'Entrada del registro de captura de clientes potenciales',
      'ArrayValue' => 'Valor de matriz',
      'DashboardTemplate' => 'Plantilla de escritorio',
      'Currency' => 'Divisa',
      'LayoutSet' => 'Conjunto de diseño',
      'Webhook' => 'Webhook',
      'WebhookQueueItem' => 'Webhook Queue Item',
      'Mass Action' => 'Mass Action',
      'WorkingTimeCalendar' => 'Working Time Calendar',
      'WorkingTimeRange' => 'Working Time Exception',
      'AuthenticationProvider' => 'Authentication Provider',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Country',
      'AppSecret' => 'App Secret',
      'Account' => 'Cuenta',
      'Contact' => 'Contacto',
      'Lead' => 'Posible cliente',
      'Target' => 'Objetivo',
      'Opportunity' => 'Oportunidad',
      'Meeting' => 'Reunión',
      'Calendar' => 'Calendario',
      'Call' => 'Llamada',
      'Task' => 'Tarea',
      'Case' => 'Ticket',
      'Document' => 'Documento',
      'DocumentFolder' => 'Carpeta de documento',
      'Campaign' => 'Campaña',
      'TargetList' => 'Lista de objetivos',
      'MassEmail' => 'Correo masivo',
      'EmailQueueItem' => 'Elemento en cola de correos',
      'CampaignTrackingUrl' => 'URL de seguimiento',
      'Activities' => 'Actividades',
      'KnowledgeBaseArticle' => 'Artículo de la base de conocimiento',
      'KnowledgeBaseCategory' => 'Categoría de la base de conocimiento',
      'CampaignLogRecord' => 'Registro del registro de la campaña',
      'Workflow' => 'Flujo de trabajo',
      'Report' => 'Informe',
      'ReportCategory' => 'Categoría del informe',
      'WorkflowLogRecord' => 'Registro de registros de flujos de trabajo',
      'WorkflowCategory' => 'Workflow Category',
      'BpmnFlowchart' => 'Diagrama de flujo del proceso',
      'BpmnProcess' => 'Proceso',
      'BpmnUserTask' => 'Acción del usuario',
      'ReportFilter' => 'Filtro de informe',
      'ReportPanel' => 'Panel de informes',
      'BpmnFlowchartCategory' => 'Flowchart Category',
      'Product' => 'Producto',
      'ProductCategory' => 'Categoría del producto',
      'ProductBrand' => 'Marca del producto',
      'ProductAttribute' => 'Product Attribute',
      'ProductAttributeOption' => 'Product Attribute Option',
      'Quote' => 'Cotización',
      'QuoteItem' => 'Artículo de presupuesto',
      'SalesOrder' => 'Orden de venta',
      'SalesOrderItem' => 'Artículo de orden de venta',
      'Invoice' => 'Factura',
      'InvoiceItem' => 'Artículo de factura',
      'DeliveryOrder' => 'Delivery Order',
      'DeliveryOrderItem' => 'Delivery Order Item',
      'ReceiptOrder' => 'Receipt Order',
      'ReceiptOrderItem' => 'Receipt Order Item',
      'TransferOrder' => 'Transfer Order',
      'TransferOrderItem' => 'Transfer Order Item',
      'Tax' => 'Impuesto',
      'ShippingProvider' => 'Proveedor de envío',
      'OpportunityItem' => 'Artículo en oferta',
      'PurchaseOrder' => 'Purchase Order',
      'PurchaseOrderItem' => 'Purchase Order Item',
      'ReturnOrder' => 'Return Order',
      'ReturnOrderItem' => 'Return Order Item',
      'Supplier' => 'Supplier',
      'ProductPrice' => 'Product Price',
      'SupplierProductPrice' => 'Supplier Product Price',
      'PriceBook' => 'Price Book',
      'PriceRule' => 'Price Rule',
      'PriceRuleCondition' => 'Price Rule Condition',
      'Warehouse' => 'Warehouse',
      'InventoryTransaction' => 'Inventory Transaction',
      'InventoryNumber' => 'Inventory Number',
      'InventoryAdjustment' => 'Inventory Adjustment',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Item',
      'EblaForm' => 'Ebla Public Form',
      'Analytics' => 'Analytics',
      'Api' => 'Api',
      'QnA' => 'QnA',
      'CspUsage' => 'CspUsage',
      'ResourceCategory' => 'Categoría de Recurso',
      'ResourceGroup' => 'Grupo de Recurso',
      'Recommendation' => 'Recomendación',
      'Assessment' => 'Assessment',
      'Monitoring' => 'Monitoreo',
      'Tags' => 'Etiqueta',
      'Subscriptions' => 'Suscripciones',
      'OrderManager' => 'Order Manager',
      'PartnerID' => 'Partner ID',
      'Tutorial' => 'Tutorial',
      'Rocket' => 'Rocket',
      'CRegistration' => 'Cadastro',
      'CSecurityAlertSettings' => 'SecurityAlertSetting',
      'CPatchNotes' => 'Patch Notes',
      'CDashboardAccess' => 'Dashboard Access',
      'CImporter' => 'Markup Request',
      'CRecommendationsConfig' => 'Configurar Recomendações',
      'CRecommendations' => 'Recomendações'
    ],
    'scopeNamesPlural' => [
      'Note' => 'Notes',
      'Email' => 'Correos',
      'User' => 'Usuarios',
      'Team' => 'Equipos',
      'Role' => 'Roles',
      'EmailTemplate' => 'Plantillas de correo',
      'EmailTemplateCategory' => 'Categorías de plantillas de correo electrónico',
      'EmailAccount' => 'Cuentas de correo personales',
      'EmailAccountScope' => 'Cuentas de correo personales',
      'OutboundEmail' => 'Salientes',
      'ScheduledJob' => 'Tareas programadas',
      'ExternalAccount' => 'Cuentas externas',
      'Extension' => 'Extensiones',
      'Dashboard' => 'Escritorio',
      'InboundEmail' => 'Cuentas de correo grupales',
      'EmailAddress' => 'Correos electrónicos',
      'PhoneNumber' => 'Números de teléfono',
      'Stream' => 'Historia',
      'Import' => 'Importar',
      'ImportError' => 'Import Errors',
      'Template' => 'Plantillas',
      'Job' => 'Trabajos',
      'EmailFilter' => 'Filtros',
      'Portal' => 'Portales',
      'PortalRole' => 'Roles del portal',
      'Attachment' => 'Adjuntos',
      'EmailFolder' => 'Carpetas de correo',
      'GroupEmailFolder' => 'Group Email Folders',
      'PortalUser' => 'Usuarios del portal',
      'ApiUser' => 'Usuarios de API',
      'ScheduledJobLogRecord' => 'Registros del registro de trabajo programado',
      'PasswordChangeRequest' => 'Solicitar Cambios de Contraseñas',
      'ActionHistoryRecord' => 'Histórico',
      'AuthToken' => 'Tokens',
      'UniqueId' => 'ID Únicos',
      'LastViewed' => 'Historial de acciones',
      'AppLogRecord' => 'App Log',
      'AuthLogRecord' => 'Registros de autenticación',
      'AuthFailLogRecord' => 'Registros de fallos de autenticación',
      'LeadCapture' => 'Captura de clientes potenciales',
      'LeadCaptureLogRecord' => 'Registros de captura de clientes potenciales',
      'ArrayValue' => 'Valor de matriz',
      'DashboardTemplate' => 'Plantilla de escritorio',
      'Currency' => 'Divisa',
      'LayoutSet' => 'Conjuntos de diseño',
      'Webhook' => 'Webhooks',
      'WebhookQueueItem' => 'Webhook Queue Items',
      'WorkingTimeCalendar' => 'Working Time Calendars',
      'WorkingTimeRange' => 'Working Time Exceptions',
      'AuthenticationProvider' => 'Authentication Providers',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Countries',
      'AppSecret' => 'App Secrets',
      'Account' => 'Cuentas',
      'Contact' => 'Contactos',
      'Lead' => 'Posibles clientes',
      'Target' => 'Objetivos',
      'Opportunity' => 'Oportunidades',
      'Meeting' => 'Reuniones',
      'Calendar' => 'Calendario',
      'Call' => 'Llamadas',
      'Task' => 'Tareas',
      'Case' => 'Tickets',
      'Document' => 'Documentos',
      'DocumentFolder' => 'Carpetas de documentos',
      'Campaign' => 'Campañas',
      'TargetList' => 'Lista de objetivos',
      'MassEmail' => 'Correos masivos',
      'EmailQueueItem' => 'Elementos en cola de correos',
      'CampaignTrackingUrl' => 'URLs de seguimiento',
      'Activities' => 'Actividades',
      'KnowledgeBaseArticle' => 'Base de conocimiento',
      'KnowledgeBaseCategory' => 'Categorías de la base de conocimiento',
      'CampaignLogRecord' => 'Registros del registro de la campaña',
      'Workflow' => 'Flujos de trabajo',
      'Report' => 'Informes',
      'ReportCategory' => 'Categorías de informes',
      'WorkflowLogRecord' => 'Registro de flujos de trabajo',
      'WorkflowCategory' => 'Workflow Categories',
      'BpmnFlowchart' => 'Diagramas de flujo de procesos',
      'BpmnProcess' => 'Procesos',
      'BpmnUserTask' => 'Acciones del usuario',
      'ReportFilter' => 'Filtros de informes',
      'ReportPanel' => 'Paneles de informes',
      'BpmnFlowchartCategory' => 'Flowchart Categories',
      'Product' => 'Productos',
      'ProductCategory' => 'Categorías de productos',
      'ProductBrand' => 'Marcas de productos',
      'ProductAttribute' => 'Product Attributes',
      'ProductAttributeOption' => 'Product Attribute Options',
      'OpportunityItem' => 'Artículos en oferta',
      'Quote' => 'Cotizaciónes',
      'QuoteItem' => 'Artículos de presupuesto',
      'SalesOrder' => 'Órdenes de venta',
      'SalesOrderItem' => 'Artículos de orden de venta',
      'Invoice' => 'Facturas',
      'InvoiceItem' => 'Artículos de la factura',
      'PurchaseOrder' => 'Purchase Orders',
      'PurchaseOrderItem' => 'Purchase Order Items',
      'ReturnOrder' => 'Return Orders',
      'ReturnOrderItem' => 'Return Order Items',
      'DeliveryOrder' => 'Delivery Orders',
      'DeliveryOrderItem' => 'Delivery Order Items',
      'ReceiptOrder' => 'Receipt Orders',
      'ReceiptOrderItem' => 'Receipt Order Items',
      'TransferOrder' => 'Transfer Orders',
      'TransferOrderItem' => 'Transfer Order Items',
      'Tax' => 'Impuestos',
      'ShippingProvider' => 'Proveedores de envío',
      'Supplier' => 'Suppliers',
      'ProductPrice' => 'Product Prices',
      'SupplierProductPrice' => 'Supplier Product Prices',
      'PriceBook' => 'Price Books',
      'PriceRule' => 'Price Rules',
      'PriceRuleCondition' => 'Price Rule Conditions',
      'Warehouse' => 'Warehouses',
      'InventoryTransaction' => 'Inventory Transactions',
      'InventoryNumber' => 'Inventory Numbers',
      'InventoryAdjustment' => 'Inventory Adjustments',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Items',
      'EblaForm' => 'Ebla Public Forms',
      'Analytics' => 'Analytics',
      'Api' => 'Api',
      'QnA' => 'QnA',
      'CspUsage' => 'CspUsage',
      'ResourceCategory' => 'Categorías de Recursos',
      'ResourceGroup' => 'Grupos de Recursos',
      'Recommendation' => 'Recomendaciones',
      'Assessment' => 'Assessments',
      'Monitoring' => 'Monitoreos',
      'Tags' => 'Etiquetas',
      'Subscriptions' => 'Suscripciones',
      'OrderManager' => 'Order Manager',
      'PartnerID' => 'PartnerIDs',
      'Tutorial' => 'Tutorials',
      'Rocket' => 'Rockets',
      'CRegistration' => 'Cadastros',
      'CSecurityAlertSettings' => 'SecurityAlertSettings',
      'CPatchNotes' => 'Patch Notes',
      'CDashboardAccess' => 'Dashboard Access',
      'CImporter' => 'Markup Request',
      'CRecommendationsConfig' => 'Configurar Recomendações',
      'CRecommendations' => 'Recomendações'
    ],
    'labels' => [
      'Previous Page' => 'Previous Page',
      'Next Page' => 'Next Page',
      'First Page' => 'First Page',
      'Last Page' => 'Last Page',
      'Page' => 'Page',
      'Sort' => 'Sort',
      'Column Resize' => 'Column Resize',
      'Misc' => 'Misceláneos',
      'General' => 'General',
      'Merge' => 'Unir',
      'None' => 'Ninguno',
      'Home' => 'Inicio',
      'by' => 'por',
      'Proceed' => 'Continuar',
      'Saved' => 'Guardado',
      'Error' => 'Error',
      'Select' => 'Seleccionar',
      'Not valid' => 'No válido',
      'Please wait...' => 'Por favor espere...',
      'Please wait' => 'Por favor espere',
      'Attached' => 'Adjunto',
      'Loading...' => 'Cargando...',
      'Uploading...' => 'Subiendo...',
      'Sending...' => 'Enviando...',
      'Send' => 'Send',
      'Merged' => 'Fusionado',
      'Removed' => 'Eliminado',
      'Posted' => 'Publicado',
      'Linked' => 'Enlazado',
      'Unlinked' => 'Desenlazado',
      'Done' => 'Hecho',
      'Access denied' => 'Acceso denegado',
      'Not found' => 'No encontrado',
      'Access' => 'Acceso',
      'Timeout' => 'Timeout',
      'No internet' => 'No internet',
      'Are you sure?' => '¿Está seguro?',
      'Record has been removed' => 'Registro Eliminado',
      'Wrong username/password' => 'Nombre de usuario/contraseña incorrectos',
      'Post cannot be empty' => 'La entrada no puede estar vacia',
      'Username can not be empty!' => '¡El nombre de usuario no puede estar vacío!',
      'Cache is not enabled' => 'La caché no está habilitada',
      'Cache has been cleared' => 'La caché fue limpiada correctamente',
      'Rebuild has been done' => 'El sistema se ha reconstruido correctamente',
      'Return to Application' => 'Volver a la aplicación',
      'Modified' => 'Modificado',
      'Created' => 'Creado',
      'Create' => 'Crear',
      'create' => 'crear',
      'Scheduled' => 'Scheduled',
      'Overview' => 'General',
      'Details' => 'Detalles',
      'Add Field' => 'Añadir Campo',
      'Add Dashlet' => 'Añadir Caja',
      'Filter' => 'Filtro',
      'Edit Dashboard' => 'Editar escritorio',
      'Add' => 'Añadir',
      'Add Item' => 'Agregar elemento',
      'Reset' => 'Resetear',
      'Menu' => 'Menú',
      'More' => 'Más',
      'Search' => 'Buscar',
      'Only My' => 'Solo míos',
      'Open' => 'Abiertos',
      'Admin' => 'Administrador',
      'About' => 'Acerca',
      'Refresh' => 'Actualizar',
      'Remove' => 'Eliminar',
      'Restore' => 'Restaurar',
      'Options' => 'Ajustes',
      'Username' => 'Nombre de usuario',
      'Password' => 'Contraseña',
      'Login' => 'Entrar',
      'Log Out' => 'Salir',
      'Log in' => 'Log in',
      'Log in as' => 'Log in as',
      'Sign in' => 'Sign in',
      'Preferences' => 'Preferencias',
      'State' => 'Estado',
      'Street' => 'Calle',
      'Country' => 'País',
      'City' => 'Ciudad',
      'PostalCode' => 'Código Postal',
      'Star' => 'Star',
      'Unstar' => 'Unstar',
      'Starred' => 'Starred',
      'Followed' => 'Siguiendo',
      'Follow' => 'Seguir',
      'Followers' => 'Seguidores',
      'Clear Local Cache' => 'Borrar la caché local',
      'Actions' => 'Acciones',
      'Delete' => 'Borrar',
      'Update' => 'Guardar',
      'Save' => 'Guardar',
      'Edit' => 'Editar',
      'View' => 'Ver',
      'Cancel' => 'Cancelar',
      'Apply' => 'Aplicar',
      'Unlink' => 'Desenlazar',
      'Mass Update' => 'Actualización masiva',
      'Export' => 'Exportar',
      'No Data' => 'Sin Datos',
      'No Access' => 'Sin acceso',
      'All' => 'Todos',
      'Active' => 'Activo',
      'Inactive' => 'Inactivo',
      'Write your comment here' => 'Escriba su comentario aquí',
      'Post' => 'Publicar',
      'Stream' => 'Historia',
      'Show more' => 'Mostrar mas',
      'Dashlet Options' => 'Ajustes de cajas',
      'Full Form' => 'Formulario Completo',
      'Insert' => 'Insertar',
      'Person' => 'Persona',
      'First Name' => 'Nombre',
      'Last Name' => 'Apellidos',
      'Middle Name' => 'Segundo nombre',
      'Original' => 'Original',
      'You' => 'Tu',
      'you' => 'tu',
      'change' => 'cambiar',
      'Change' => 'Cambio',
      'Primary' => 'Principal',
      'Save Filter' => 'Guardar Filtro',
      'Remove Filter' => 'Remove Filter',
      'Ready' => 'Ready',
      'Administration' => 'Administración',
      'Run Import' => 'Ejecutar importación',
      'Duplicate' => 'Duplicar',
      'Notifications' => 'Notificaciones',
      'Mark all read' => 'Marcar todos como leído',
      'See more' => 'Ver más',
      'Today' => 'Hoy',
      'Tomorrow' => 'Mañana',
      'Yesterday' => 'Ayer',
      'Now' => 'Now',
      'Submit' => 'Enviar',
      'Close' => 'Cerrar',
      'Yes' => 'Si',
      'No' => 'No',
      'Select All Results' => 'Seleccionar todos los resultados',
      'Value' => 'Valor',
      'Current version' => 'Versión actual',
      'List View' => 'Vista de Lista',
      'Tree View' => 'Vista de árbol',
      'Unlink All' => 'Desenlazar todo',
      'Total' => 'Total',
      'Print' => 'Print',
      'Print to PDF' => 'Imprimir PDF',
      'Default' => 'Por defecto',
      'Number' => 'Número',
      'From' => 'De',
      'To' => 'Para',
      'Create Post' => 'Crear entrada',
      'Previous Entry' => 'Entrada anterior',
      'Next Entry' => 'Siguiente Entrada',
      'View List' => 'Ver lista completa',
      'Attach File' => 'Adjuntar archivo',
      'Skip' => 'Omitir',
      'Attribute' => 'Atributo',
      'Function' => 'Función',
      'Self-Assign' => 'Autoasignar',
      'Self-Assigned' => 'Autosegnado',
      'Expand' => 'Expandir',
      'Collapse' => 'Contraer',
      'Expanded' => 'Expanded',
      'Collapsed' => 'Collapsed',
      'Top Level' => 'Top Level',
      'New notifications' => 'Nuevas notificaciones',
      'Manage Categories' => 'Administrar categorías',
      'Manage Folders' => 'Administrar carpetas',
      'Convert to' => 'Convertir a',
      'View Personal Data' => 'Ver datos personales',
      'Personal Data' => 'Información personal',
      'Erase' => 'Borrar',
      'View Followers' => 'Ver seguidores',
      'Convert Currency' => 'Convertir moneda',
      'View on Map' => 'Ver en el mapa',
      'Preview' => 'Avance',
      'Move Over' => 'Moverse',
      'Up' => 'Up',
      'Save & Continue Editing' => 'Save & Continue Editing',
      'Save & New' => 'Save & New',
      'Field' => 'Field',
      'Fields' => 'Fields',
      'Resolution' => 'Resolution',
      'Resolve Conflict' => 'Resolve Conflict',
      'Download' => 'Download',
      'Global Search' => 'Global Search',
      'Navigation Panel' => 'Show Navigation Panel',
      'Copy to Clipboard' => 'Copy to Clipboard',
      'Copied to clipboard' => 'Copied to clipboard',
      'Audit Log' => 'Audit Log',
      'View Audit Log' => 'View Audit Log',
      'View User Access' => 'View User Access',
      'Reacted' => 'Reacted',
      'Reaction Removed' => 'Reaction Removed',
      'Reactions' => 'Reactions',
      'Schedule' => 'Schedule',
      'Log' => 'Log',
      'Scheduler' => 'Programador',
      'Create InboundEmail' => 'Crear correo grupal',
      'Activities' => 'Actividades',
      'History' => 'Historial de actividades',
      'Attendees' => 'Asistentes',
      'Schedule Meeting' => 'Programar reunión',
      'Schedule Call' => 'Programar llamada',
      'Compose Email' => 'Escribir correo',
      'Log Meeting' => 'Registrar reunión',
      'Log Call' => 'Registrar llamada',
      'Archive Email' => 'Nuevo Correo Archivado',
      'Create Task' => 'Crear tarea',
      'Tasks' => 'Tareas',
      'Start Process' => 'Iniciar proceso',
      'Lock' => 'Lock',
      'Unlock' => 'Unlock',
      'Merging...' => 'Fusionando...',
      'Removing...' => 'Removiendo...',
      'Unlinking...' => 'Desenlazando...',
      'Posting...' => 'Publicando...',
      'Saving...' => 'Guardando...'
    ],
    'messages' => [
      'pleaseWait' => 'Por favor espere...',
      'loading' => 'Cargando...',
      'saving' => 'Guardando...',
      'confirmLeaveOutMessage' => '¿Seguro que quieres salir del formulario?',
      'notModified' => 'Usted no ha modificado el registro',
      'duplicate' => 'El registro que está creando parece ser un duplicado',
      'dropToAttach' => 'Arrastre para adjuntar',
      'pageNumberIsOutOfBound' => 'Page number is out of bound',
      'fieldUrlExceedsMaxLength' => 'Encoded URL exceeds max length of {maxLength}',
      'fieldNotMatchingPattern' => '{field} does not match the pattern `{pattern}`',
      'fieldNotMatchingPattern$noBadCharacters' => '{field} contains not allowed characters',
      'fieldNotMatchingPattern$noAsciiSpecialCharacters' => '{field} should not contain ASCII special characters',
      'fieldNotMatchingPattern$latinLetters' => '{field} can contain only latin letters',
      'fieldNotMatchingPattern$latinLettersDigits' => '{field} can contain only latin letters and digits',
      'fieldNotMatchingPattern$latinLettersDigitsWhitespace' => '{field} can contain only latin letters, digits and whitespace',
      'fieldNotMatchingPattern$latinLettersWhitespace' => '{field} can contain only latin letters and whitespace',
      'fieldNotMatchingPattern$digits' => '{field} can contain only digits',
      'fieldNotMatchingPattern$uriOptionalProtocol' => '{field} must be a valid URL',
      'fieldNotMatchingPattern$phoneNumberLoose' => '{field} contains characters not allowed in a phone number',
      'fieldInvalid' => '{campo} no es válido',
      'fieldIsRequired' => '{field} es requerido',
      'fieldPhoneInvalid' => '{field} is invalid',
      'fieldPhoneInvalidCode' => 'Invalid country code',
      'fieldPhoneTooShort' => '{field} is too short',
      'fieldPhoneTooLong' => '{field} is too long',
      'fieldPhoneInvalidCharacters' => 'Only digits, latin letters and characters `-+_@:#().` are allowed',
      'fieldPhoneExtensionTooLong' => 'Extension should not be longer than {maxLength}',
      'fieldShouldBeEmail' => '{field} debe ser un correo electrónico válido',
      'fieldShouldBeFloat' => '{field} debe ser un decimal válido',
      'fieldShouldBeInt' => '{field} debe ser un entero válido',
      'fieldShouldBeNumber' => '{field} should be a valid number',
      'fieldShouldBeDate' => '{field} debe ser una fecha válida',
      'fieldShouldBeDatetime' => '{field} debe ser una fecha válida fecha/hora',
      'fieldShouldAfter' => '{field} debe estar después de {otherField}',
      'fieldShouldBefore' => '{field} debe estar antes de {otherField}',
      'fieldShouldBeBetween' => '{field} debe estar entre {min} y {max}',
      'fieldShouldBeLess' => '{field} no debería ser mayor que {value}',
      'fieldShouldBeGreater' => '{field} no debería ser menor que {value}',
      'fieldBadPasswordConfirm' => '{field} confirmado de forma incorrecta',
      'fieldMaxFileSizeError' => 'El archivo no puede exeder los {max} Mb',
      'fieldValueDuplicate' => 'Valor duplicado',
      'fieldIsUploading' => 'Subida en progreso',
      'fieldExceedsMaxCount' => 'El recuento excede el máximo permitido {maxCount}',
      'barcodeInvalid' => '{field} is not valid {type}',
      'arrayItemMaxLength' => 'Item shouldn\'t be longer than {max} characters',
      'resetPreferencesDone' => 'Preferencias se ha restablecido a los valores predeterminados',
      'confirmation' => '¿Está seguro?',
      'unlinkAllConfirmation' => '¿Seguro que deseas desvincular todos los registros relacionados?',
      'resetPreferencesConfirmation' => '¿Está seguro que desea restablecer las preferencias?',
      'removeRecordConfirmation' => '¿Está seguro que quiere eliminar los registros?',
      'unlinkRecordConfirmation' => '¿Está seguro que quiere desenlazar la relación?',
      'removeSelectedRecordsConfirmation' => '¿Está seguro que quiere eliminar los registros seleccionados?',
      'unlinkSelectedRecordsConfirmation' => '¿Está seguro de que desea desvincular los registros seleccionados?',
      'massUpdateResult' => '{count} registros se han actualizado',
      'massUpdateResultSingle' => '{count} registro ha sido actualizado',
      'recalculateFormulaConfirmation' => '¿Está seguro de que desea volver a calcular la fórmula para los registros seleccionados?',
      'noRecordsUpdated' => 'Ningún registro fue actualizado',
      'massRemoveResult' => '{count} registros se han eliminado',
      'massRemoveResultSingle' => '{count} registro se ha eliminado',
      'noRecordsRemoved' => 'Ningún registro fue eliminado',
      'clickToRefresh' => 'Clic para actualizar',
      'writeYourCommentHere' => 'Escriba su comentario aquí',
      'writeMessageToUser' => 'Escribir un mensaje a {user}',
      'writeMessageToSelf' => 'Escribir un mensaje en tu historia',
      'typeAndPressEnter' => 'Escriba y presione enter',
      'checkForNewNotifications' => 'Comprobar si hay nuevas notificaciones',
      'checkForNewNotes' => 'Comprobar si hay actualizaciones en la historia',
      'internalPost' => 'El puesto será visto solo por los usuarios internos',
      'internalPostTitle' => 'El mensaje es visto solo por usuarios internos',
      'done' => 'Hecho',
      'notUpdated' => 'No actualizado',
      'confirmMassUpdate' => 'Are you sure you want to mass-update selected records?',
      'confirmMassFollow' => '¿Está seguro que desea seguir los registros seleccionados?',
      'confirmMassUnfollow' => '¿Está seguro que desea dejar de seguir los registros seleccionados?',
      'massFollowResult' => 'Se han seguido {count} registros',
      'massUnfollowResult' => 'Se han dejado de seguir {count} registros',
      'massFollowResultSingle' => 'Se han seguido {count} registro',
      'massUnfollowResultSingle' => 'Se han dejado de seguir {count} registro',
      'massFollowZeroResult' => 'Nada se siguió',
      'massUnfollowZeroResult' => 'Nada se dejó de seguir',
      'erasePersonalDataConfirmation' => 'Los campos marcados se borrarán permanentemente. ¿Estás seguro?',
      'maintenanceModeError' => 'The application currently is in maintenance mode.',
      'maintenanceMode' => 'La aplicación actualmente está en modo de mantenimiento. Solo los usuarios administradores tienen acceso.

El modo de mantenimiento se puede deshabilitar en Administración → Ajustes.',
      'resolveSaveConflict' => 'The record has been modified. You need to resolve the conflict before you can save the record.',
      'massPrintPdfMaxCountError' => 'No se puede imprimir más que {maxCount} registros.',
      'massActionProcessed' => 'Mass action has been processed.',
      'validationFailure' => 'Backend validation failure.

Field: `{field}`
Validation: `{type}`',
      'extensionLicenseInvalid' => 'Invalid \'{name}\' extension license.',
      'extensionLicenseExpired' => 'The \'{name}\' extension license subscription has expired.',
      'extensionLicenseSoftExpired' => 'The \'{name}\' extension license subscription has expired.',
      'confirmAppRefresh' => 'The application has been updated. It is recommended to refresh the page to ensure the proper functioning.',
      'loggedOutLeaveOut' => 'Logged out. The session is inactive. You may lose unsaved form data after page refresh. You may need to make a copy.',
      'noAccessToRecord' => 'Operation requires `{action}` access to record.',
      'noAccessToForeignRecord' => 'Operation requires `{action}` access to foreign record.',
      'noLinkAccess' => 'Can\'t relate with {foreignEntityType} record through the link \'{link}\'. No access.',
      'cannotUnrelateRequiredLink' => 'Can\'t unrelate required link.',
      'cannotRelateNonExisting' => 'Can\'t relate with non-existing {foreignEntityType} record.',
      'cannotRelateForbidden' => 'Can\'t relate with forbidden {foreignEntityType} record. `{action}` access required.',
      'cannotRelateForbiddenLink' => 'No access to link \'{link}\'.',
      'cannotLinkAlreadyLinked' => 'Cannot link an already linked record.',
      'error404' => 'The url you requested can\'t be handled.',
      'error403' => 'You don\'t have access to this area.',
      'emptyMassUpdate' => 'No fields available for Mass Update.',
      'attemptIntervalFailure' => 'The operation is not allowed during a specific time interval. Wait for some time before the next attempt.',
      'confirmRestoreFromAudit' => 'The previous values will be set in a form. Then you can save the record to restore the previous values.',
      'starsLimitExceeded' => 'The number of stars exceeded the limit.',
      'select2OrMoreRecords' => 'Select 2 or more records',
      'selectNotMoreThanNumberRecords' => 'Select not more than {number} records',
      'selectAtLeastOneRecord' => 'Select at least one record',
      'duplicateConflict' => 'A record already exists.',
      'cannotRemoveCategoryWithChildCategory' => 'Cannot remove a category that has a child category.',
      'cannotRemoveNotEmptyCategory' => 'Cannot remove a non-empty category.',
      'posting' => 'Publicando...'
    ],
    'boolFilters' => [
      'onlyMy' => 'Solo míos',
      'onlyMyTeam' => 'Mi equipo',
      'followed' => 'Siguiendo',
      'shared' => 'Shared'
    ],
    'presetFilters' => [
      'followed' => 'Siguiendo',
      'all' => 'Todos',
      'starred' => 'Starred'
    ],
    'massActions' => [
      'delete' => 'Delete',
      'remove' => 'Eliminar',
      'merge' => 'Unir',
      'update' => 'Update',
      'massUpdate' => 'Actualización masiva',
      'unlink' => 'Desvincular',
      'export' => 'Exportar',
      'follow' => 'Seguir',
      'unfollow' => 'Dejar de seguir',
      'convertCurrency' => 'Convertir moneda',
      'recalculateFormula' => 'Recalcular fórmula',
      'printPdf' => 'Print to PDF
',
      'lock' => 'Lock',
      'unlock' => 'Unlock'
    ],
    'fields' => [
      'name' => 'Nombre',
      'firstName' => 'Nombre',
      'lastName' => 'Apellidos',
      'middleName' => 'Segundo nombre',
      'salutationName' => 'Saludo',
      'assignedUser' => 'Usuario asignado',
      'assignedUsers' => 'Usuarios asignados',
      'collaborators' => 'Collaborators',
      'emailAddress' => 'Correo electrónico',
      'emailAddressData' => 'Datos de Correos electrónicos',
      'emailAddressIsOptedOut' => 'La dirección de correo electrónico está dada de baja',
      'emailAddressIsInvalid' => 'Email Address is Invalid',
      'assignedUserName' => 'Nombre de usuario asignado',
      'teams' => 'Equipos',
      'users' => 'Users',
      'createdAt' => 'Creado en',
      'modifiedAt' => 'Modificado el',
      'createdBy' => 'Creado por',
      'modifiedBy' => 'Modificado Por',
      'streamUpdatedAt' => 'Stream Updated At',
      'description' => 'Descripción',
      'address' => 'Dirección',
      'phoneNumber' => 'Teléfono',
      'phoneNumberMobile' => 'Teléfono (Móvil)',
      'phoneNumberHome' => 'Teléfono (Casa)',
      'phoneNumberFax' => 'Teléfono (Fax)',
      'phoneNumberOffice' => 'Teléfono (Oficina)',
      'phoneNumberOther' => 'Teléfono (Otro)',
      'phoneNumberData' => 'Datos del número de teléfono',
      'phoneNumberIsOptedOut' => 'El teléfono está excluido',
      'phoneNumberIsInvalid' => 'Phone Number is Invalid',
      'order' => 'Orden',
      'parent' => 'Padre',
      'children' => 'Hijos',
      'id' => 'ID',
      'ids' => 'IDs',
      'type' => 'Tipo',
      'names' => 'Nombres',
      'types' => 'Tipos',
      'targetListIsOptedOut' => 'Se dieró de baja',
      'childList' => 'Child List',
      'billingAddressCity' => 'Ciudad',
      'billingAddressCountry' => 'País',
      'billingAddressPostalCode' => 'Código Postal',
      'billingAddressState' => 'Estado',
      'billingAddressStreet' => 'Calle',
      'billingAddressMap' => 'Mapa',
      'addressCity' => 'Ciudad',
      'addressStreet' => 'Calle',
      'addressCountry' => 'País',
      'addressState' => 'Estado',
      'addressPostalCode' => 'Código Postal',
      'addressMap' => 'Mapa',
      'shippingAddressCity' => 'Ciudad (envío)',
      'shippingAddressStreet' => 'Calle (envío)',
      'shippingAddressCountry' => 'País (envío)',
      'shippingAddressState' => 'Estado (envío)',
      'shippingAddressPostalCode' => 'Código Postal (envío)',
      'shippingAddressMap' => 'Mapa (envío)',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'productType' => 'Product Type',
      'isDone' => 'Is Done',
      'isNotActual' => 'Is Not Actual',
      'isLocked' => 'Locked',
      'isHardLocked' => 'Hard-Locked'
    ],
    'links' => [
      'assignedUser' => 'Usuario asignado',
      'assignedUsers' => 'Assigned Users',
      'collaborators' => 'Collaborators',
      'createdBy' => 'Creado por',
      'modifiedBy' => 'Modificado Por',
      'team' => 'Equipo',
      'roles' => 'Roles',
      'teams' => 'Equipos',
      'users' => 'Usuarios',
      'parent' => 'Padre',
      'children' => 'Hijos',
      'contacts' => 'Contactos',
      'opportunities' => 'Oportunidades',
      'leads' => 'Posibles clientes',
      'meetings' => 'Reuniones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'emails' => 'Correos',
      'accounts' => 'Cuentas',
      'cases' => 'Tickets',
      'documents' => 'Documentos',
      'account' => 'Cuenta',
      'opportunity' => 'Oportunidad',
      'contact' => 'Contacto'
    ],
    'dashlets' => [
      'Stream' => 'Historia',
      'Emails' => 'Mi bandeja de entrada',
      'Iframe' => 'Iframe',
      'Records' => 'Lista de registros',
      'Memo' => 'Memo',
      'Leads' => 'Mis posibles clientes',
      'Opportunities' => 'Mis oportunidades',
      'Tasks' => 'Mis tareas',
      'Cases' => 'Mis tickets',
      'Calendar' => 'Calendario',
      'Calls' => 'Mis llamadas',
      'Meetings' => 'Mis reuniones',
      'OpportunitiesByStage' => 'Oportunidades por Etapa',
      'OpportunitiesByLeadSource' => 'Oportunidades por toma de contacto del posible cliente',
      'SalesByMonth' => 'Ventas por mes',
      'SalesPipeline' => 'Canalización de ventas',
      'Activities' => 'Mis próximas actividades',
      'Report' => 'Informe',
      'BpmnUserTasks' => 'Procesar tareas de usuario'
    ],
    'notificationMessages' => [
      'assign' => '{entityType} {entity} ha sido asignado a usted',
      'emailReceived' => 'Correo recibido de: {from}',
      'entityRemoved' => '{user} ha eliminado: {entityType} {entity}',
      'emailInbox' => '{user} added email {entity} to your inbox',
      'userPostReaction' => '{user} reacted to your {post}',
      'userPostInParentReaction' => '{user} reacted to your {post} in {entityType} {entity}',
      'eventAttendee' => '{user} added you to {entityType} {entity}'
    ],
    'streamMessages' => [
      'post' => '{user} ha publicado en: {entityType} {entity}',
      'attach' => '{user} ha añadido un archivo adjunto en: {entityType} {entity}',
      'status' => '{user} ha actualizado el campo {field} en: {entityType} {entity}',
      'update' => '{user} ha actualizado: {entityType} {entity}',
      'postTargetTeam' => '{user} ha publicado en el equipo {target}',
      'postTargetTeams' => '{user} ha publicado en los equipos {target}',
      'postTargetPortal' => '{user} ha publicado en el portal {target}',
      'postTargetPortals' => '{user} ha publicado en los portales {target}',
      'postTarget' => '{user} ha publicado en {target}',
      'postTargetYou' => '{user} ha publicado pora usted',
      'postTargetYouAndOthers' => '{user} ha publicado para {target} y para usted',
      'postTargetAll' => '{user} ha publicado para todos',
      'postTargetSelf' => '{user} se ha enviado un mensaje a sí mismo',
      'postTargetSelfAndOthers' => '{user} ha publicado para {target} y para sí mismo',
      'mentionInPost' => '{user} ha mencionado a {mentioned} en: {entityType} {entity}',
      'mentionYouInPost' => '{user} te ha mencionado en: {entityType} {entity}',
      'mentionInPostTarget' => '{user} ha mencionado a {mentioned} en la publicación',
      'mentionYouInPostTarget' => '{user} te ha mencionado en la publicación para {target}',
      'mentionYouInPostTargetAll' => '{user} te ha mencionado en una publicación para todos',
      'mentionYouInPostTargetNoTarget' => '{user} te ha mencionado en una publicación',
      'create' => '{user} ha creado: {entityType} {entity}',
      'createThis' => '{user} ha creado: {entityType}',
      'createAssignedThis' => '{user} ha creado y se lo ha asignado a {assignee}: {entityType}',
      'createAssigned' => '{user} ha creado y se lo ha asignado a {assignee}: {entityType} {entity}',
      'createAssignedYou' => '{user} ha creado y te lo ha asignado: {entityType} {entity}',
      'createAssignedThisSelf' => '{user} ha creado y se ha asignado a sí mismo: {entityType}',
      'createAssignedSelf' => '{user} ha creado y se ha asignado a sí mismo: {entityType} {entity}',
      'assign' => '{user} ha asignado: {entityType} {entity} a {assignee}',
      'assignThis' => '{user} ha asignado {entityType} a {assignee}',
      'assignYou' => '{user} te ha asignado {entityType} {entity} a ti',
      'assignThisVoid' => '{user} ha desasignado: {entityType}',
      'assignVoid' => '{user} ha desasignado: {entityType} {entity}',
      'assignThisSelf' => '{user} se ha asignado así mismo: {entityType}',
      'assignSelf' => '{user} se ha asignado así mismo: {entityType} {entity}',
      'assignMultiAdd' => '{user} assigned {entity} to {assignee}',
      'assignMultiRemove' => '{user} unassigned {entity} from {removedAssignee}',
      'assignMultiAddRemove' => '{user} assigned {entity} to {assignee} and unassigned from {removedAssignee}',
      'assignMultiAddThis' => '{user} assigned this {entityType} to {assignee}',
      'assignMultiRemoveThis' => '{user} unassigned this {entityType} from {removedAssignee}',
      'assignMultiAddRemoveThis' => '{user} assigned this {entityType} to {assignee} and unassigned from {removedAssignee}',
      'postThis' => '{user} ha publicado',
      'attachThis' => '{user} ha adjuntado',
      'statusThis' => '{user} ha actualizado el campo {field}',
      'updateThis' => '{user} ha actualizado: {entityType}',
      'createRelatedThis' => '{user} ha creado: {relatedEntityType} {relatedEntity}, enlazado a {entityType}',
      'createRelated' => '{user} ha creado: {relatedEntityType} {relatedEntity} enlazado a {entityType} {entity}',
      'relate' => '{user} ha enlazado {relatedEntityType} {relatedEntity} a {entityType} {entity}',
      'relateThis' => '{user} vinculado {relatedEntityType} {relatedEntity} con este {entityType}',
      'unrelate' => '{user} unlinked {relatedEntityType} {relatedEntity} from {entityType} {entity}',
      'unrelateThis' => '{user} unlinked {relatedEntityType} {relatedEntity} from this {entityType}',
      'emailReceivedFromThis' => 'Correo recibido de: {from}',
      'emailReceivedInitialFromThis' => 'Correo recibido de {from}, se ha creado: {entityType}',
      'emailReceivedThis' => 'Correo recibido',
      'emailReceivedInitialThis' => 'Correo recibido, se ha creado: {entityType}',
      'emailReceivedFrom' => 'Correo recibido de {from}, relacionado a: {entityType} {entity}',
      'emailReceivedFromInitial' => 'Correo recibido de {from}, se ha creado: {entityType} {entity}',
      'emailReceived' => 'El correo {email} ha sido recibido para el {entityType} {entity}',
      'emailReceivedInitial' => 'Correo recibido, se ha creado: {entityType} {entity}',
      'emailReceivedInitialFrom' => 'Correo recibido de {from}, se ha creado: {entityType} {entity}',
      'emailSent' => '{by} ha enviado un correo relacionado a: {entityType} {entity}',
      'emailSentThis' => '{by} ha enviado un correo',
      'eventConfirmationAccepted' => '{invitee} accepted participation in {entityType} {entity}',
      'eventConfirmationDeclined' => '{invitee} declined participation in {entityType} {entity}',
      'eventConfirmationTentative' => '{invitee} is tentative about participation in {entityType} {entity}',
      'eventConfirmationAcceptedThis' => '{invitee} accepted participation',
      'eventConfirmationDeclinedThis' => '{invitee} declined participation',
      'eventConfirmationTentativeThis' => '{invitee} is tentative about participation'
    ],
    'streamMessagesMale' => [
      'postTargetSelfAndOthers' => '{user} ha publicado para {target} y para sí mismo'
    ],
    'streamMessagesFemale' => [
      'postTargetSelfAndOthers' => '{user} ha publicado para {target} y para sí misma'
    ],
    'lists' => [
      'monthNames' => [
        0 => 'Enero',
        1 => 'Febrero',
        2 => 'Marzo',
        3 => 'Abril',
        4 => 'Mayo',
        5 => 'Junio',
        6 => 'Julio',
        7 => 'Agosto',
        8 => 'Septiembre',
        9 => 'Octubre',
        10 => 'Noviembre',
        11 => 'Diciembre'
      ],
      'monthNamesShort' => [
        0 => 'Ene',
        1 => 'Feb',
        2 => 'Mar',
        3 => 'Abr',
        4 => 'May',
        5 => 'Jun',
        6 => 'Jul',
        7 => 'Ago',
        8 => 'Sep',
        9 => 'Oct',
        10 => 'Nov',
        11 => 'Dic'
      ],
      'dayNames' => [
        0 => 'Domingo',
        1 => 'Lunes',
        2 => 'Martes',
        3 => 'Miércoles',
        4 => 'Jueves',
        5 => 'Viernes',
        6 => 'Sábado'
      ],
      'dayNamesShort' => [
        0 => 'Dom',
        1 => 'Lun',
        2 => 'Mar',
        3 => 'Mie',
        4 => 'Jue',
        5 => 'Vie',
        6 => 'Sab'
      ],
      'dayNamesMin' => [
        0 => 'Do',
        1 => 'Lu',
        2 => 'Ma',
        3 => 'Mi',
        4 => 'Ju',
        5 => 'Vi',
        6 => 'Sa'
      ]
    ],
    'durationUnits' => [
      'd' => 'd',
      'h' => 'h',
      'm' => 'm',
      's' => 's'
    ],
    'options' => [
      'salutationName' => [
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Ms.' => 'Sta.',
        'Dr.' => 'Dr.'
      ],
      'language' => [
        'ar_AR' => 'Arabic',
        'af_ZA' => 'Afrikáans',
        'az_AZ' => 'Azerbaiyán',
        'be_BY' => 'Bielorruso',
        'bg_BG' => 'Bulgaro',
        'bn_IN' => 'Bengalí',
        'bs_BA' => 'Bosnio',
        'ca_ES' => 'Catalán',
        'cs_CZ' => 'Checo',
        'cy_GB' => 'Galés',
        'da_DK' => 'Danés',
        'de_DE' => 'Alemán',
        'el_GR' => 'Griego',
        'en_GB' => 'Inglés (UK)',
        'es_MX' => 'Español (México)',
        'en_US' => 'Inglés (US)',
        'es_ES' => 'Español (España)',
        'et_EE' => 'Estonio',
        'eu_ES' => 'Vasco',
        'fa_IR' => 'Persa',
        'fi_FI' => 'Finlandés',
        'fo_FO' => 'Feroés',
        'fr_CA' => 'Francés (Canada)',
        'fr_FR' => 'Francés (Francia)',
        'ga_IE' => 'Irlandés',
        'gl_ES' => 'Gallego',
        'gn_PY' => 'Guaraní',
        'he_IL' => 'Hebreo',
        'hi_IN' => 'Hindi',
        'hr_HR' => 'Croata',
        'hu_HU' => 'Hungaro',
        'hy_AM' => 'Armenio',
        'id_ID' => 'Indonesio',
        'is_IS' => 'Islandés',
        'it_IT' => 'Italiano',
        'ja_JP' => 'Japonés',
        'ka_GE' => 'Georgiano',
        'km_KH' => 'Camboyano',
        'ko_KR' => 'Coreano',
        'ku_TR' => 'Kurdo',
        'lt_LT' => 'Lituano',
        'lv_LV' => 'Latón',
        'mk_MK' => 'Macedonio',
        'ml_IN' => 'Malabar',
        'ms_MY' => 'Malayo',
        'nb_NO' => 'Noruego Bokmål',
        'nn_NO' => 'Noruego Nynorsk',
        'ne_NP' => 'Nepalí',
        'nl_NL' => 'Holandés',
        'pa_IN' => 'Punyabí',
        'pl_PL' => 'Polaco',
        'ps_AF' => 'Pastún',
        'pt_BR' => 'Portugués (Brasil)',
        'pt_PT' => 'Portugués (Portugal)',
        'ro_RO' => 'Rumano',
        'ru_RU' => 'Ruso',
        'sk_SK' => 'Eslovaco',
        'sl_SI' => 'Esloveno',
        'sq_AL' => 'Albanés',
        'sr_RS' => 'Serbio',
        'sv_SE' => 'Sueco',
        'sw_KE' => 'Suajili',
        'ta_IN' => 'Tamil',
        'te_IN' => 'Télugu',
        'th_TH' => 'Tailandés',
        'tl_PH' => 'Tagalo',
        'tr_TR' => 'Turco',
        'uk_UA' => 'Ucraniano',
        'ur_PK' => 'Urdu',
        'vi_VN' => 'Vietnamita',
        'zh_CN' => 'Chino Simplificado (China)',
        'zh_HK' => 'Chino Tradicional (Hong Kong)',
        'zh_TW' => 'Chino Traditional (Taiwán)'
      ],
      'dateSearchRanges' => [
        'on' => 'Está en',
        'notOn' => 'No está en',
        'after' => 'Después',
        'before' => 'Antes',
        'between' => 'Entre',
        'today' => 'Hoy',
        'past' => 'Pasado',
        'future' => 'Futuro',
        'currentMonth' => 'Mes Actual',
        'lastMonth' => 'Mes pasado',
        'nextMonth' => 'Siguiente mes',
        'currentQuarter' => 'Trimestre Actual',
        'lastQuarter' => 'Trimestre pasado',
        'currentYear' => 'Año Actual',
        'lastYear' => 'Año pasado',
        'lastSevenDays' => 'Últimos 7 Días',
        'lastXDays' => 'Últimos X Días',
        'nextXDays' => 'Próximos X Días',
        'ever' => 'Nunca',
        'isEmpty' => 'Está Vacío',
        'olderThanXDays' => 'Más de X Días',
        'afterXDays' => 'Después de X días',
        'currentFiscalYear' => 'Año fiscal actual',
        'lastFiscalYear' => 'Último año fiscal',
        'currentFiscalQuarter' => 'Trimestre fiscal actual',
        'lastFiscalQuarter' => 'Último trimestre fiscal'
      ],
      'searchRanges' => [
        'is' => 'Es',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No Está Vacío',
        'isOneOf' => 'Cualquiera de',
        'isFromTeams' => 'Es del equipo',
        'isNot' => 'No es',
        'isNotOneOf' => 'Ninguno de',
        'anyOf' => 'Cualquiera de',
        'allOf' => 'Todo de',
        'noneOf' => 'Ninguno de',
        'any' => 'Alguno'
      ],
      'varcharSearchRanges' => [
        'equals' => 'Equivale',
        'like' => 'Es como (%)',
        'notLike' => 'No es como (%)',
        'startsWith' => 'Comienza con',
        'endsWith' => 'Termina con',
        'contains' => 'Contiene',
        'notContains' => 'No contiene',
        'isEmpty' => 'Está vacío',
        'isNotEmpty' => 'No Está Vacío',
        'notEquals' => 'No es igual'
      ],
      'intSearchRanges' => [
        'equals' => 'Equivale',
        'notEquals' => 'Diferentes',
        'greaterThan' => 'Mayor que',
        'lessThan' => 'Menor que',
        'greaterThanOrEquals' => 'Mayor o igual que',
        'lessThanOrEquals' => 'Menor o igual que',
        'between' => 'Entre',
        'isEmpty' => 'Está Vacío',
        'isNotEmpty' => 'No está Vacío'
      ],
      'autorefreshInterval' => [
        0 => 'Ninguno',
        '0.5' => '30 segundos',
        1 => '1 minuto',
        2 => '2 minutos',
        5 => '5 minutos',
        10 => '10 minutos'
      ],
      'phoneNumber' => [
        'Mobile' => 'Teléfono móvil',
        'Office' => 'Oficina',
        'Fax' => 'Fax',
        'Home' => 'Hogar',
        'Other' => 'Otro'
      ],
      'saveConflictResolution' => [
        'current' => 'Current',
        'actual' => 'Actual',
        'original' => 'Original'
      ],
      'reminderTypes' => [
        'Popup' => 'Ventana emergente',
        'Email' => 'Correo electrónico'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'sets' => [
      'summernote' => [
        'NOTICE' => 'Usted puede encontrar aquí la traducción: https://github.com/HackerWins/summernote/tree/master/lang',
        'font' => [
          'bold' => 'Negrita',
          'italic' => 'Itálico',
          'underline' => 'Subrayado',
          'strike' => 'Tachado',
          'clear' => 'Quitar Estilo de Fuente',
          'height' => 'Alto de línea',
          'name' => 'Familia de Fuente',
          'size' => 'Tamaño de Fuente'
        ],
        'image' => [
          'image' => 'Visualización',
          'insert' => 'Insertar imagen',
          'resizeFull' => 'Cambiar el tamaño a completo',
          'resizeHalf' => 'Cambiar el tamaño a la mitad',
          'resizeQuarter' => 'Cambiar el tamaño a un cuarto',
          'floatLeft' => 'Flotar Izquierda',
          'floatRight' => 'Flotar Derecha',
          'floatNone' => 'Sin Flotar',
          'dragImageHere' => 'Arrastrar una imagen aquí',
          'selectFromFiles' => 'Seleccionar desde Archivo',
          'url' => 'Url de imagen',
          'remove' => 'Eliminar imagen'
        ],
        'link' => [
          'link' => 'Enlace',
          'insert' => 'Insertar Enlace',
          'unlink' => 'Desenlazar',
          'edit' => 'Editar',
          'textToDisplay' => 'Texto a mostrar',
          'url' => '¿A que URL debería ir este enlace?',
          'openInNewWindow' => 'Abrir en nueva ventana'
        ],
        'video' => [
          'video' => 'Video',
          'videoLink' => 'Enlace al Video',
          'insert' => 'Insertar Video',
          'url' => '¿URL del Video?',
          'providers' => '(YouTube, Vimeo, Vine, Instagram, or DailyMotion)'
        ],
        'table' => [
          'table' => 'Tabla'
        ],
        'hr' => [
          'insert' => 'Insertar regla horizontal'
        ],
        'style' => [
          'style' => 'Estilo',
          'normal' => 'Normal',
          'blockquote' => 'Cita',
          'pre' => 'Código',
          'h1' => 'Cabecera 1',
          'h2' => 'Cabecera 2',
          'h3' => 'Cabecera 3',
          'h4' => 'Cabecera 4',
          'h5' => 'Cabecera 5',
          'h6' => 'Cabecera 6'
        ],
        'lists' => [
          'unordered' => 'Lista sin Ordenar',
          'ordered' => 'Lista Ordenada'
        ],
        'options' => [
          'help' => 'Ayuda',
          'fullscreen' => 'Pantalla Completa',
          'codeview' => 'Ver Código'
        ],
        'paragraph' => [
          'paragraph' => 'Párrafo',
          'outdent' => 'Anular sangría',
          'indent' => 'Sangría',
          'left' => 'Alinear Izquierda',
          'center' => 'Alinear Centro',
          'right' => 'Alinear Derecha',
          'justify' => 'Justificado'
        ],
        'color' => [
          'recent' => 'Color Reciente',
          'more' => 'Mas Colores',
          'background' => 'Color de Fondo',
          'foreground' => 'Color de Fuente',
          'transparent' => 'Transparente',
          'setTransparent' => 'Establecer transparente',
          'reset' => 'Resetear',
          'resetToDefault' => 'Restablecer a (por defecto)'
        ],
        'shortcut' => [
          'shortcuts' => 'Atajos de teclado',
          'close' => 'Cerrar',
          'textFormatting' => 'Formato de texto',
          'action' => 'Acción',
          'paragraphFormatting' => 'Formato de párrafo',
          'documentStyle' => 'Estilo de Documento'
        ],
        'history' => [
          'undo' => 'Deshacer',
          'redo' => 'Rehacer'
        ]
      ]
    ],
    'listViewModes' => [
      'list' => 'List',
      'kanban' => 'Kanban'
    ],
    'themes' => [
      'Dark' => 'Dark',
      'Light' => 'Light',
      'Espo' => 'Espo',
      'EspoRtl' => 'RTL',
      'Sakura' => 'Sakura',
      'Violet' => 'Violet',
      'Hazyblue' => 'Hazyblue',
      'Glass' => 'Glass'
    ],
    'themeNavbars' => [
      'side' => 'Side Navbar',
      'top' => 'Top Navbar'
    ],
    'fieldValidations' => [
      'required' => 'Required',
      'maxCount' => 'Max Count',
      'maxLength' => 'Max Length',
      'pattern' => 'Pattern Matching',
      'emailAddress' => 'Valid Email Address',
      'phoneNumber' => 'Valid Phone Number',
      'array' => 'Array',
      'arrayOfString' => 'Array of Strings',
      'valid' => 'Validity',
      'noEmptyString' => 'No Empty String',
      'max' => 'Max Value',
      'min' => 'Min Value'
    ],
    'fieldValidationExplanations' => [
      'valid' => 'Invalid value.',
      'maxLength' => 'Value length exceeds maximum value.',
      'phone_valid' => 'Phone number is not valid. May be caused by a wrong or empty country code.',
      'url_valid' => 'Invalid URL value.',
      'currency_valid' => 'Invalid amount value.',
      'currency_validCurrency' => 'The currency code value is invalid or not allowed.',
      'varchar_pattern' => 'Likely, the value contains not allowed characters.',
      'email_emailAddress' => 'Invalid email address value.',
      'phone_phoneNumber' => 'Invalid phone number value.',
      'datetimeOptional_valid' => 'Invalid date-time value.',
      'datetime_valid' => 'Invalid date-time value.',
      'date_valid' => 'Invalid date value.',
      'enum_valid' => 'Invalid enum value. The value must be one of defined enum options. An empty value is allowed only if the field has an empty option.',
      'int_valid' => 'Invalid integer number value.',
      'float_valid' => 'Invalid number value.',
      'multiEnum_valid' => 'Invalid multi-enum value. Values must be one of defined field options.'
    ],
    'navbarTabs' => [
      'Business' => 'Business',
      'Marketing' => 'Marketing',
      'Support' => 'Support',
      'CRM' => 'CRM',
      'Activities' => 'Activities',
      'SalesPack' => 'Sales & Purchase'
    ],
    'wysiwygLabels' => [
      'cell' => 'Cell',
      'align' => 'Align',
      'width' => 'Width',
      'height' => 'Height',
      'borderWidth' => 'Border Width',
      'borderColor' => 'Border Color',
      'cellPadding' => 'Cell Padding',
      'backgroundColor' => 'Background Color',
      'verticalAlign' => 'Vertical Align'
    ],
    'wysiwygOptions' => [
      'align' => [
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right'
      ],
      'verticalAlign' => [
        'top' => 'Top',
        'middle' => 'Middle',
        'bottom' => 'Bottom'
      ]
    ],
    'detailViewModes' => [
      'detail' => 'Detail'
    ],
    'strings' => [
      'yesterdayShort' => 'Yest'
    ],
    'reactions' => [
      'Smile' => 'Smile',
      'Surprise' => 'Surprise',
      'Laugh' => 'Laugh',
      'Meh' => 'Meh',
      'Sad' => 'Sad',
      'Love' => 'Love',
      'Like' => 'Like',
      'Dislike' => 'Dislike'
    ],
    'recordActions' => [
      'create' => 'Create',
      'read' => 'Read',
      'edit' => 'Edit',
      'delete' => 'Delete',
      'stream' => 'Stream'
    ],
    'tabs' => [
      'Stream' => 'Stream'
    ],
    'featureEnableInfo' => [
      'PriceBooks' => 'The *Price Books* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'Warehouses' => 'The *Warehouses* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'InventoryTransactions' => 'The *Inventory Transactions* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).'
    ]
  ],
  'GroupEmailFolder' => [
    'links' => [
      'emails' => 'Emails'
    ],
    'labels' => [
      'Create GroupEmailFolder' => 'Create Folder'
    ]
  ],
  'Import' => [
    'labels' => [
      'New import with same params' => 'Nueva importación con los mismos parámetros',
      'Revert Import' => 'Revertir Importación',
      'Return to Import' => 'Regreso a Importar',
      'Run Import' => 'Ejecutar importación',
      'Back' => 'Anterior',
      'Field Mapping' => 'Mapeo de Campos',
      'Default Values' => 'Valores por defecto',
      'Add Field' => 'Añadir Campo',
      'Created' => 'Creado',
      'Updated' => 'Actualizado',
      'Result' => 'Resultado',
      'Show records' => 'Mostrar registros',
      'Remove Duplicates' => 'Eliminar Duplicados',
      'importedCount' => 'Importado (recuento)',
      'duplicateCount' => 'Duplicados (recuento)',
      'updatedCount' => 'Actualizado (recuento)',
      'Create Only' => 'Solo crear',
      'Create and Update' => 'Crear y actualizar',
      'Update Only' => 'Solo actualizar',
      'Update by' => 'Actualizado por',
      'Set as Not Duplicate' => 'Establecer como No Duplicado',
      'File (CSV)' => 'Archivo (CSV)',
      'First Row Value' => 'Valor de la primera fila',
      'Skip' => 'Omitir',
      'Header Row Value' => 'Campo del sistema',
      'Field' => 'Columnas del archivo',
      'What to Import?' => '¿Qué va a importar?',
      'Entity Type' => 'Tipo de entidad',
      'What to do?' => '¿Qué hacer?',
      'Properties' => 'Propiedades',
      'Header Row' => '¿Tiene una fila de Encabezado?',
      'Person Name Format' => 'Formato del nombre de la persona',
      'John Smith' => 'Juan Pérez',
      'Smith John' => 'Pérez Juan',
      'Smith, John' => 'Pérez, Juan',
      'Field Delimiter' => 'Delimitador de campo',
      'Date Format' => 'Formato de fecha',
      'Decimal Mark' => 'Símbolo Decimal',
      'Text Qualifier' => 'Delimitador de texto',
      'Time Format' => 'Formato de hora',
      'Currency' => 'Moneda',
      'Preview' => 'Vista previa',
      'Next' => 'Siguiente',
      'Step 1' => 'Paso 1',
      'Step 2' => 'Paso 2',
      'Double Quote' => 'Comillas dobles',
      'Single Quote' => 'Comillas simples',
      'Imported' => 'Importado',
      'Duplicates' => 'Duplicados',
      'Skip searching for duplicates' => 'Omitir la búsqueda de duplicados',
      'Timezone' => 'Zona horaria',
      'Remove Import Log' => 'Eliminar registro de importación',
      'New Import' => 'Nueva importación',
      'Import Results' => 'Importar resultados',
      'Run Manually' => 'Ejecutar manualmente',
      'Silent Mode' => 'Modo silencioso',
      'Export' => 'Export'
    ],
    'messages' => [
      'importRunning' => 'Import running...',
      'noErrors' => 'No errors',
      'utf8' => 'Debe ser codificado en UTF-8',
      'duplicatesRemoved' => 'Duplicados eliminados',
      'inIdle' => 'Ejecutar en segundo plano (para gran cantidad de datos, vía cron)',
      'revert' => 'Esto eliminará todos los registros importados de forma permanente.',
      'removeDuplicates' => 'Esto eliminará permanentemente todos los registros importados que fueron reconocidos como duplicados.',
      'confirmRevert' => 'Esto eliminará todos los registros importados de forma permanente. ¿Estás seguro?',
      'confirmRemoveDuplicates' => 'Esto eliminará permanentemente todos los registros importados que fueron reconocidos como duplicados. ¿Estás seguro?',
      'confirmRemoveImportLog' => 'Esto eliminará el registro de importación. Se conservarán todos los registros importados. No podrá revertir los resultados de la importación. ¿Está seguro?',
      'removeImportLog' => 'Esto eliminará el registro de importación. Todos los registros importados se mantendrán. Úselo si está seguro de que la importación está bien.'
    ],
    'params' => [
      'phoneNumberCountry' => 'Telephone country code'
    ],
    'fields' => [
      'file' => 'Archivo',
      'entityType' => 'Tipo de entidad',
      'imported' => 'Registros Importados',
      'duplicates' => 'registros Duplicados',
      'updated' => 'registros Actualizados',
      'status' => 'Estado'
    ],
    'links' => [
      'errors' => 'Errors'
    ],
    'options' => [
      'status' => [
        'Failed' => 'Falló',
        'Standby' => 'Apoyar',
        'Pending' => 'Pendiente',
        'In Process' => 'En proceso',
        'Complete' => 'Completo'
      ],
      'personNameFormat' => [
        'f l' => 'Primero último',
        'l f' => 'Último primero',
        'f m l' => 'Primero Segundo Nombre Apellido',
        'l f m' => 'Último primero medio',
        'l, f' => 'Último primero'
      ]
    ],
    'strings' => [
      'commandToRun' => 'Comando para ejecutar (desde CLI)',
      'saveAsDefault' => 'Guardar por defecto'
    ],
    'tooltips' => [
      'manualMode' => 'Si está marcado, deberá ejecutar la importación manualmente desde CLI. El comando se mostrará después de configurar la importación.',
      'silentMode' => 'Se omitirá la mayoría de los scripts posteriores a guardar, no se crearán notas de transmisión. La importación se ejecutará más rápido.'
    ]
  ],
  'ImportError' => [
    'fields' => [
      'type' => 'Type',
      'validationFailures' => 'Validation Failures',
      'import' => 'Import',
      'rowIndex' => 'Row Index',
      'exportRowIndex' => 'Export Row Index',
      'lineNumber' => 'Line Number',
      'exportLineNumber' => 'Export Line Number',
      'row' => 'Row',
      'entityType' => 'Entity Type'
    ],
    'options' => [
      'type' => [
        'Validation' => 'Validation',
        'Access' => 'Access',
        'Not-Found' => 'Not-Found'
      ]
    ],
    'tooltips' => [
      'lineNumber' => 'A line number in the original CSV.',
      'exportLineNumber' => 'A line number in the export CSV.'
    ]
  ],
  'InboundEmail' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Dirección de correo electrónico',
      'team' => 'Equipo objetivo',
      'status' => 'Estado',
      'assignToUser' => 'Asignar al usuario',
      'host' => 'Servidor',
      'username' => 'Nombre de usuario',
      'password' => 'Contraseña',
      'port' => 'Puerto',
      'monitoredFolders' => 'Carpetas sincronizadas',
      'trashFolder' => 'Carpeta de papelera',
      'security' => 'Seguridad',
      'createCase' => 'Crear ticket',
      'reply' => 'Respuesta automática',
      'caseDistribution' => 'Distribución de tickets',
      'replyEmailTemplate' => 'Plantilla de respuesta de correo',
      'replyFromAddress' => 'Responder de (dirección)',
      'replyToAddress' => 'Responder a (dirección)',
      'replyFromName' => 'Respuesta de (nombre):',
      'targetUserPosition' => 'Asigna a usuarios por puesto',
      'fetchSince' => 'Traer correos desde',
      'addAllTeamUsers' => 'Para todos los usuarios del equipo',
      'teams' => 'Equipos',
      'sentFolder' => 'Carpeta de enviados',
      'storeSentEmails' => 'Almacenar correos enviados',
      'keepFetchedEmailsUnread' => 'Mantenga los correos electrónicos recuperados como no leídos',
      'connectedAt' => 'Connected At',
      'excludeFromReply' => 'Exclude from Reply',
      'useImap' => 'Obtener correos electrónicos',
      'useSmtp' => 'Usar SMTP',
      'smtpHost' => 'Servidor SMTP',
      'smtpPort' => 'Puerto SMTP',
      'smtpAuth' => 'Autentificación SMTP',
      'smtpSecurity' => 'Seguridad SMTP',
      'smtpAuthMechanism' => 'Mecanismo de autenticación SMTP',
      'smtpUsername' => 'Usuario SMTP',
      'smtpPassword' => 'Contraseña SMTP',
      'fromName' => 'De (nombre):',
      'smtpIsShared' => 'SMTP ¿Es compartido?',
      'smtpIsForMassEmail' => 'SMTP es para envíos masivos',
      'groupEmailFolder' => 'Group Email Folder',
      'isSystem' => 'Is System'
    ],
    'tooltips' => [
      'isSystem' => 'Is the system email account.',
      'useSmtp' => 'La capacidad de enviar correos electrónicos.',
      'reply' => 'Notifique a los remitentes de correo que han recibido sus mensajes.

Solo un correo será enviado a un destinatario particular durante un período de tiempo para evitar bucles.',
      'createCase' => 'Automaticamente crear un ticket de los correos entrantes.',
      'replyToAddress' => 'Especifique la dirección de correo de este buzón para hacer que las respuestas vegan aquí.',
      'caseDistribution' => '¿Cómo serán asignados a los tickets? Asignados directamente a un usuario o al equipo.',
      'assignToUser' => 'Los tickets serán asignados al usuario:',
      'team' => 'Los tickets serán asignados al siguiente equipo:',
      'teams' => 'Los correos serán asignados a estos equipos:',
      'targetUserPosition' => 'Los usuarios con los puestos especificados recibirán los tickets.',
      'addAllTeamUsers' => 'Los correos aparecerán en la bandeja de entrada de todos los usuarios de los equipos especificados.',
      'monitoredFolders' => 'Las carpetas deben estar separadas por comas.',
      'smtpIsShared' => 'Si se marca, entonces los usuarios podrán enviar correos usando este SMTP. La disponibilidad está controlada por Roles a través de los permisos de la cuenta de correo grupal.',
      'smtpIsForMassEmail' => 'Si está marcado, SMTP estará disponible para correo masivo.',
      'storeSentEmails' => 'Los correos electrónicos enviados se almacenarán en el servidor IMAP.',
      'groupEmailFolder' => 'Put incoming emails in a group folder.',
      'excludeFromReply' => 'When replying on emails sent to this account\'s email address, its email address won\'t be added to CC.

Note that by enabling this parameter, the email address of this account will be exposed to users who have access to send Emails.'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Correos',
      'assignToUser' => 'Asignar al usuario',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ],
      'caseDistribution' => [
        '' => 'Ninguno',
        'Direct-Assignment' => 'Asignación directa',
        'Round-Robin' => 'Todos contra todos',
        'Least-Busy' => 'Menos ocupado'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'Entrar',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create InboundEmail' => 'Crear cuenta grupal',
      'IMAP' => 'IMAP',
      'Actions' => 'Acciones',
      'Main' => 'Principal'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'No se pudo conectar con el servidor IMAP',
      'imapNotConnected' => 'Could not connect to group [IMAP account](#InboundEmail/view/{id}).'
    ]
  ],
  'Integration' => [
    'fields' => [
      'enabled' => 'Activado',
      'clientId' => 'ID Cliente',
      'clientSecret' => 'Secreto del cliente',
      'redirectUri' => 'Redireccionar URI',
      'apiKey' => 'Clave de API',
      'siteKey' => 'Site Key',
      'secretKey' => 'Secret Key',
      'scoreThreshold' => 'Score Threshold',
      'reCaptchaSiteKey' => 'reCaptcha Site Key',
      'reCaptchaSecretKey' => 'reCaptcha Secret Key'
    ],
    'titles' => [
      'GoogleMaps' => 'Google Maps',
      'GoogleReCaptcha' => 'Google reCAPTCHA'
    ],
    'messages' => [
      'selectIntegration' => 'Seleccionar una integración en menú',
      'noIntegrations' => 'No hay integraciones disponibles'
    ],
    'help' => [
      'GoogleReCaptcha' => 'Obtain the Site Key and Secret Key from [Google](https://www.google.com/recaptcha/).',
      'Google' => '**Obtenga las credenciales de OAuth 2.0 de la Consola de desarrolladores de Google.**

Visite [Google Developers Console](https://console.developers.google.com/project) para obtener las credenciales de OAuth 2.0, como un ID de cliente y un secreto de cliente que son conocidos tanto por Google como por la aplicación Partners.',
      'GoogleMaps' => 'Obtener Clave de API [aquí](https://developers.google.com/maps/documentation/javascript/get-api-key).',
      'ReCaptcha' => '**Obtain credentials from the Google reCaptcha Console.**

Visit [Google reCaptcha Console](https://www.google.com/recaptcha/admin) to obtain Site Key & Site Secret that are known to both Google and EspoCRM application.

**NOTE: compatible with V2 reCaptcha ONLY**'
    ]
  ],
  'Job' => [
    'fields' => [
      'status' => 'Estado',
      'executeTime' => 'Ejecutar a',
      'executedAt' => 'Ejecutado en',
      'startedAt' => 'Empezó a las',
      'attempts' => 'Intentos restantes',
      'failedAttempts' => 'Intentos Fallidos',
      'serviceName' => 'Servicio',
      'method' => 'Método',
      'methodName' => 'Método',
      'scheduledJob' => 'Tarea Programada',
      'scheduledJobJob' => 'Nombre de trabajo programado',
      'data' => 'Datos',
      'targetType' => 'Tipo de objetivo',
      'targetId' => 'ID Objetivo',
      'number' => 'Numero',
      'queue' => 'Cola',
      'group' => 'Group',
      'className' => 'Class Name',
      'targetGroup' => 'Target Group',
      'job' => 'Trabajo'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendiente',
        'Success' => 'Exitoso',
        'Running' => 'Corriendo',
        'Failed' => 'Falló'
      ]
    ]
  ],
  'LayoutManager' => [
    'fields' => [
      'width' => 'Ancho (%)',
      'link' => 'Enlace',
      'notSortable' => 'No ordenable',
      'align' => 'Alinear',
      'panelName' => 'Nombre del Panel',
      'style' => 'Estilo',
      'sticked' => 'Pegado',
      'isMuted' => 'Muted color',
      'isLarge' => 'Tamaño de fuente grande',
      'hidden' => 'Oculto',
      'noLabel' => 'No Label',
      'dynamicLogicVisible' => 'Condiciones que hacen visible el panel',
      'dynamicLogicStyled' => 'Conditions making style applied',
      'tabLabel' => 'Tab Label',
      'tabBreak' => 'Tab-Break',
      'noteText' => 'Note Text',
      'noteStyle' => 'Note Style'
    ],
    'options' => [
      'align' => [
        'left' => 'Izquierda',
        'right' => 'Derecha'
      ],
      'style' => [
        'default' => 'Borrador',
        'success' => 'Exito',
        'danger' => 'Peligro',
        'info' => 'Información',
        'warning' => 'Advertencia',
        'primary' => 'Principal'
      ]
    ],
    'labels' => [
      'New panel' => 'Nuevo panel',
      'Layout' => 'Diseño'
    ],
    'messages' => [
      'alreadyExists' => 'Layout `{name}` already exists.',
      'createInfo' => 'Custom list layouts can be used by relationship panels.',
      'cantBeEmpty' => 'Layout can\'t be empty.',
      'fieldsIncompatible' => 'Fields can\'t be on the layout together: {fields}.'
    ],
    'tooltips' => [
      'noteText' => 'A text to be displayed in the panel. Markdown is supported.',
      'tabBreak' => 'A separate tab for the panel and all following panels until the next tab-break.',
      'noLabel' => 'Don\'t display a column label in the header.',
      'notSortable' => 'Disables the ability to sort by the column.',
      'width' => 'A column width. It\'s recommended to have one column without specified width, usually it should be the *Name* field.',
      'sticked' => 'The panel will be sticked to the panel above. No gap between panels.',
      'hiddenPanel' => 'Necesita hacer clic en "mostrar más" para ver el panel.',
      'panelStyle' => 'A color of the panel.',
      'dynamicLogicVisible' => 'If set, the panel will be hidden unless the condition is met.',
      'dynamicLogicStyled' => 'A color will be applied if a specific condition is met . The color is defined by the *Style* parameter.',
      'link' => 'Si se marca, se mostrará un valor de campo como un enlace que apunta a la vista detallada del registro. Por lo general, se usa para los campos *Name*.'
    ]
  ],
  'LayoutSet' => [
    'fields' => [
      'layoutList' => 'Diseños'
    ],
    'labels' => [
      'Create LayoutSet' => 'Crear conjunto de diseño',
      'Edit Layouts' => 'Editar diseños'
    ],
    'tooltips' => []
  ],
  'LeadCapture' => [
    'fields' => [
      'name' => 'Nombre',
      'campaign' => 'Campaña',
      'isActive' => 'Está activo',
      'subscribeToTargetList' => 'Suscríbase a la lista de objetivos',
      'subscribeContactToTargetList' => 'Suscribir contacto si existe',
      'targetList' => 'Lista de objetivos',
      'fieldList' => 'Campos de carga útil',
      'optInConfirmation' => 'Doble confirmación de suscripción',
      'optInConfirmationEmailTemplate' => 'Plantilla de email de cofirmación de suscripción',
      'optInConfirmationLifetime' => 'Tiempo de vida del enlace de confirmación de suscripción (horas)',
      'optInConfirmationSuccessMessage' => 'Texto para mostrar después de la confirmación de correo electrónico',
      'leadSource' => 'Toma de contacto del posible cliente',
      'apiKey' => 'Clave de API',
      'targetTeam' => 'Equipo objetivo',
      'exampleRequestMethod' => 'Método',
      'exampleRequestUrl' => 'URL',
      'exampleRequestPayload' => 'Carga útil',
      'exampleRequestHeaders' => 'Headers',
      'createLeadBeforeOptInConfirmation' => 'Crear cliente potencial antes de la confirmación',
      'skipOptInConfirmationIfSubscribed' => 'Omitir confirmación si el cliente potencial ya está en la lista de objetivos',
      'smtpAccount' => 'Cuenta SMTP',
      'inboundEmail' => 'Cuenta de correo electrónico grupal',
      'duplicateCheck' => 'Duplicar verificación',
      'phoneNumberCountry' => 'Telephone country code',
      'fieldParams' => 'Field Params',
      'formId' => 'Form ID',
      'formEnabled' => 'Web Form',
      'formUrl' => 'Form URL',
      'formSuccessText' => 'Text to display after form submission',
      'formText' => 'Text to display on form',
      'formSuccessRedirectUrl' => 'URL to redirect to after form submission',
      'formLanguage' => 'Language used on form',
      'formFrameAncestors' => 'Allowed hosts for form embedding',
      'formCaptcha' => 'Use Captcha'
    ],
    'links' => [
      'targetList' => 'Lista de objetivos',
      'campaign' => 'Campaña',
      'optInConfirmationEmailTemplate' => 'Plantilla de email de cofirmación de suscripción',
      'targetTeam' => 'Equipo objetivo',
      'inboundEmail' => 'Cuenta de correo electrónico grupal',
      'logRecords' => 'Registro'
    ],
    'labels' => [
      'Create LeadCapture' => 'Crear punto de entrada',
      'Generate New API Key' => 'Generar una nueva clave de API',
      'Request' => 'Solicitud',
      'Confirm Opt-In' => 'Confirmar suscripción',
      'Generate New Form ID' => 'Generate New Form ID',
      'Web Form' => 'Web Form'
    ],
    'messages' => [
      'generateApiKey' => 'Crear nueva clave de API',
      'optInConfirmationExpired' => 'El enlace de confirmación de suscripción ha caducado.',
      'optInIsConfirmed' => 'Correo electrónico está confirmado'
    ],
    'tooltips' => [
      'formCaptcha' => 'To be able to use Captcha, you need to configure it under **Administration** > **Integrations**.',
      'optInConfirmationSuccessMessage' => 'Markdown es soportado'
    ]
  ],
  'LeadCaptureLogRecord' => [
    'fields' => [
      'number' => 'Número',
      'data' => 'Datos',
      'target' => 'Objetivo',
      'leadCapture' => 'Captura de clientes potenciales',
      'createdAt' => 'Entró en',
      'isCreated' => '¿Se creó el cliente potencial?'
    ],
    'links' => [
      'leadCapture' => 'Captura de clientes potenciales',
      'target' => 'Objetivo'
    ]
  ],
  'MassAction' => [
    'fields' => [
      'status' => 'Status',
      'processedCount' => 'Processed Count'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Running' => 'Running',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ],
    'messages' => [
      'infoText' => 'The mass action is being processed in idle by cron. It can take some time to finish. Closing this modal dialog won\'t affect the execution process.'
    ]
  ],
  'Note' => [
    'fields' => [
      'post' => 'Entrada',
      'attachments' => 'Adjuntos',
      'targetType' => 'Objetivo',
      'teams' => 'Equipos',
      'users' => 'Usuarios',
      'portals' => 'Portales',
      'type' => 'Tipo',
      'isGlobal' => 'Es global',
      'isInternal' => 'Es Interno (para usuarios internos)',
      'isPinned' => 'Is Pinned',
      'related' => 'Relacionado',
      'createdByGender' => 'Creado por género',
      'data' => 'Datos',
      'number' => 'Número'
    ],
    'filters' => [
      'all' => 'Todos',
      'posts' => 'Entradas',
      'updates' => 'Actualizaciones',
      'activity' => 'Activity'
    ],
    'options' => [
      'targetType' => [
        'self' => 'Para mí',
        'users' => 'Para determinado/s usuario/s',
        'teams' => 'Para determinado/s equipo/s',
        'all' => 'Para todos los usuarios',
        'portals' => 'Para los usuarios del portal'
      ],
      'type' => [
        'Post' => 'Entrada',
        'Create' => 'Create',
        'CreateRelated' => 'Create Related',
        'Update' => 'Update',
        'Status' => 'Status',
        'Assign' => 'Assign',
        'Relate' => 'Relate',
        'Unrelate' => 'Unrelate',
        'EmailReceived' => 'Email Received',
        'EmailSent' => 'Email Sent'
      ]
    ],
    'labels' => [
      'View Posts' => 'View Posts',
      'View Activity' => 'View Activity',
      'Pin' => 'Pin',
      'Unpin' => 'Unpin',
      'Pinned' => 'Pinned',
      'Quote Reply' => 'Quote Reply'
    ],
    'messages' => [
      'writeMessage' => 'Escriba su mensaje aquí',
      'pinnedMaxCountExceeded' => 'Cannot pin more notes. Max allowed number is {count}.'
    ],
    'links' => [
      'portals' => 'Portals',
      'attachments' => 'Attachments',
      'superParent' => 'Super padre',
      'related' => 'Relacionado'
    ]
  ],
  'PhoneNumber' => [
    'fields' => [
      'type' => 'Escribe',
      'optOut' => 'Opted Out',
      'invalid' => 'Inválido',
      'numeric' => 'Numeric Value'
    ],
    'presetFilters' => [
      'orphan' => 'Huérfano'
    ]
  ],
  'Portal' => [
    'fields' => [
      'name' => 'Nombre',
      'logo' => 'Logotipo',
      'url' => 'URL',
      'portalRoles' => 'Roles',
      'isActive' => 'Está activo',
      'isDefault' => 'Portal por defecto',
      'tabList' => 'Lista de pestañas',
      'applicationName' => 'Application Name',
      'quickCreateList' => 'Lista de creación rápida',
      'companyLogo' => 'Logotipo',
      'theme' => 'Tema',
      'language' => 'Idioma',
      'dashboardLayout' => 'Diseño del escritorio',
      'dateFormat' => 'Formato de fecha',
      'timeFormat' => 'Formato de hora',
      'timeZone' => 'Zona horaria',
      'weekStart' => 'Primer día de la semana',
      'defaultCurrency' => 'Moneda por defecto',
      'layoutSet' => 'Conjunto de diseño',
      'authenticationProvider' => 'Authentication Provider',
      'customUrl' => 'URL personalizada',
      'customId' => 'ID personalizado',
      'authTokenLifetime' => 'Auth Token Lifetime (hours)',
      'authTokenMaxIdleTime' => 'Auth Token Max Idle Time (hours)'
    ],
    'links' => [
      'users' => 'Usuarios',
      'portalRoles' => 'Roles',
      'layoutSet' => 'Conjunto de diseño',
      'authenticationProvider' => 'Authentication Provider',
      'notes' => 'Notas',
      'articles' => 'Artículos de la base de conocimiento'
    ],
    'tooltips' => [
      'layoutSet' => 'Proporciona la capacidad de tener diseños que difieran de los estándar.',
      'portalRoles' => 'Los roles del portal indicados se aplicarán a todos los usuarios de este portal.'
    ],
    'labels' => [
      'Create Portal' => 'Crear portal',
      'User Interface' => 'Interfaz del Usuario',
      'General' => 'General',
      'Settings' => 'Ajustes'
    ]
  ],
  'PortalRole' => [
    'fields' => [
      'exportPermission' => 'Permisos de exportación',
      'massUpdatePermission' => 'Permiso de actualización masiva',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuarios'
    ],
    'labels' => [
      'Access' => 'Acceder',
      'Create PortalRole' => 'Crear rol del portal',
      'Scope Level' => 'Nivel de acceso a entidades',
      'Field Level' => 'Nivel de acceso a campos'
    ],
    'tooltips' => [
      'exportPermission' => 'Define si los usuarios del portal tienen la capacidad de exportar registros.',
      'massUpdatePermission' => 'Define si los usuarios del portal tienen la capacidad de realizar una actualización masiva de registros.'
    ]
  ],
  'PortalUser' => [
    'labels' => [
      'Create PortalUser' => 'Crear usuario del portal'
    ]
  ],
  'Preferences' => [
    'fields' => [
      'dateFormat' => 'Formato de fecha',
      'timeFormat' => 'Formato de hora',
      'timeZone' => 'Zona horaria',
      'weekStart' => 'Primer día de la semana',
      'thousandSeparator' => 'Separador de miles',
      'decimalMark' => 'Separador decimal',
      'defaultCurrency' => 'Moneda por defecto',
      'currencyList' => 'Lista de monedas',
      'language' => 'Idioma',
      'exportDelimiter' => 'Separador de campos',
      'receiveAssignmentEmailNotifications' => 'Recibir notificaciones por correo electrónico al ser asignado',
      'receiveMentionEmailNotifications' => 'Notificaciones por correo electrónico acerca de menciones en los mensajes',
      'receiveStreamEmailNotifications' => 'Notificaciones por correo electrónico sobre los mensajes y actualizaciones de estado',
      'assignmentNotificationsIgnoreEntityTypeList' => 'Asignación de notificaciones del sistema',
      'assignmentEmailNotificationsIgnoreEntityTypeList' => 'Notificaciones de asignación de correo electrónico',
      'reactionNotifications' => 'In-app notifications about reactions',
      'autoFollowEntityTypeList' => 'Seguir automaticamente (global)',
      'signature' => 'Firma de correo',
      'dashboardTabList' => 'Lista de pestañas',
      'defaultReminders' => 'Recordatorios por defecto',
      'defaultRemindersTask' => 'Default Reminders for Tasks',
      'theme' => 'Tema',
      'useCustomTabList' => 'Lista de pestañas personalizadas',
      'addCustomTabs' => 'Add Custom Tabs',
      'tabList' => 'Lista de pestañas',
      'emailReplyToAllByDefault' => 'Correo: responder a todos por defecto',
      'dashboardLayout' => 'Diseño del escritorio',
      'dashboardLocked' => 'Lock Dashboard',
      'emailReplyForceHtml' => 'Correo: responder en formato HTML',
      'doNotFillAssignedUserIfNotRequired' => 'No precompletar usuario asignado en la creación de registros',
      'followEntityOnStreamPost' => 'Seguimiento automático después de publicar en la historia',
      'followCreatedEntities' => 'Seguimiento automático de registros creados',
      'followCreatedEntityTypeList' => 'Seguimiento automático de registros creados de tipos de entidades específicos',
      'emailUseExternalClient' => 'Use un cliente de correo electrónico externo',
      'textSearchStoringDisabled' => 'Disable text filter storing',
      'calendarSlotDuration' => 'Calendar Slot Duration',
      'calendarScrollHour' => 'Calendar Scroll to Hour',
      'smtpServer' => 'Servidor',
      'smtpPort' => 'Puerto',
      'smtpAuth' => '¿Requiere autenticación?',
      'smtpSecurity' => 'Seguridad',
      'smtpUsername' => 'Nombre de usuario',
      'emailAddress' => 'Correo electrónico',
      'smtpPassword' => 'Contraseña',
      'smtpEmailAddress' => 'Correo electrónico',
      'scopeColorsDisabled' => 'Deshabilitar color de los ámbitos',
      'tabColorsDisabled' => 'Deshabilitar colores de pestañas'
    ],
    'links' => [],
    'options' => [
      'weekStart' => [
        0 => 'Domingo',
        1 => 'Lunes'
      ]
    ],
    'labels' => [
      'Notifications' => 'Notificaciones',
      'User Interface' => 'Interfaz de usuario',
      'Misc' => 'Misceláneos',
      'Locale' => 'Localización',
      'Reset Dashboard to Default' => 'Reiniciar al escritorio por defecto'
    ],
    'tooltips' => [
      'addCustomTabs' => 'If checked, custom tabs will be appended to default tabs. Otherwise, custom tabs will be used instead of default tabs.',
      'autoFollowEntityTypeList' => 'Siguirá automáticamente todos los registros nuevos (creados por cualquier usuario) de los tipos de entidad seleccionados. Para poder ver información en la historia y recibir notificaciones sobre todos los registros en el sistema.',
      'doNotFillAssignedUserIfNotRequired' => 'Cuando cree un registro, el usuario asignado no se completará con su propio usuario a menos que el campo sea obligatorio.',
      'followCreatedEntities' => 'Al crear nuevos registros, se seguirán automáticamente incluso si se asignan a otro usuario.',
      'followCreatedEntityTypeList' => 'Al crear nuevos registros de los tipos de entidades seleccionados, se seguirán automáticamente incluso si se asignan a otro usuario.'
    ],
    'tabFields' => [
      'label' => 'Label',
      'iconClass' => 'Icon',
      'color' => 'Color'
    ]
  ],
  'Role' => [
    'fields' => [
      'name' => 'Nombre',
      'roles' => 'Roles',
      'assignmentPermission' => 'Asignación de permisos',
      'userPermission' => 'Permisos de Usuario',
      'messagePermission' => 'Message Permission',
      'portalPermission' => 'Permisos del portal',
      'groupEmailAccountPermission' => 'Permiso de la cuenta de correo grupal',
      'exportPermission' => 'Permisos de exportación',
      'massUpdatePermission' => 'Permiso de actualización masiva',
      'followerManagementPermission' => 'Follower Management Permission',
      'dataPrivacyPermission' => 'Permiso de privacidad de datos',
      'auditPermission' => 'Audit Permission',
      'mentionPermission' => 'Mention Permission',
      'userCalendarPermission' => 'User Calendar Permission',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuarios',
      'teams' => 'Equipos'
    ],
    'tooltips' => [
      'messagePermission' => 'Allows to send messages to other users.

* all – can send to all
* team – can send only to teammates
* no – cannot send',
      'assignmentPermission' => 'Permite restringir la capacidad de los usuarios para que asignen registros y publicaciones a otros usuarios.

todo - sin restricción

equipo - puede asignar a usuarios de su propio equipo

no - solo puede asignarse a sí mismo',
      'userPermission' => 'Permite restringir la capacidad de los usuarios para ver tareas, calendarios y la historia de otros usuarios.

todo - pueden ver todo

equipo - pueden ver las actividades de su equipo

no - solo las propias',
      'userCalendarPermission' => 'Allows to view calendars of other users.',
      'portalPermission' => 'Define un acceso a la información del portal, la capacidad de publicar mensajes a los usuarios del portal.
',
      'groupEmailAccountPermission' => 'Define el acceso a las cuentas de correo grupales, la capacidad de enviar correos a través del SMTP grupal.',
      'exportPermission' => 'Define si los usuarios tienen la capacidad de exportar registros.',
      'massUpdatePermission' => 'Define si los usuarios tienen la capacidad de realizar actualizaciones masivas de registros.',
      'followerManagementPermission' => 'Allows to manage followers of specific records.',
      'dataPrivacyPermission' => 'Permite ver y borrar datos personales.',
      'auditPermission' => 'Allows to view the audit log.',
      'mentionPermission' => 'Allows to mention other users in the Stream.

* all – can mention all
* team – can mention only teammates
* no – cannot mention'
    ],
    'labels' => [
      'Access' => 'Acceso',
      'Create Role' => 'Crear rol',
      'Scope Level' => 'Nivel de acceso a entidades',
      'Field Level' => 'Nivel de acceso a campos'
    ],
    'options' => [
      'accessList' => [
        'not-set' => 'sin establecer',
        'enabled' => 'activado',
        'disabled' => 'desactivado'
      ],
      'levelList' => [
        'all' => 'Todos',
        'team' => 'Equipo',
        'account' => 'Cuenta',
        'contact' => 'Contacto',
        'own' => 'Propio',
        'no' => 'No',
        'yes' => 'Si',
        'not-set' => 'Sin establecer'
      ]
    ],
    'actions' => [
      'read' => 'Leer',
      'edit' => 'Editar',
      'delete' => 'Borrar',
      'stream' => 'Historia',
      'create' => 'Crear'
    ],
    'messages' => [
      'changesAfterClearCache' => 'Todos los cambios en el control de acceso serán aplicacados después de limpiar la caché'
    ]
  ],
  'ScheduledJob' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'job' => 'Trabajo',
      'scheduling' => 'Programación (notación CRONTab)'
    ],
    'links' => [
      'log' => 'Registro'
    ],
    'labels' => [
      'As often as possible' => 'Tan seguido como sea posible',
      'Create ScheduledJob' => 'Crear tarea programada'
    ],
    'options' => [
      'job' => [
        'Cleanup' => 'Limpiar',
        'CheckInboundEmails' => 'Comprobar cuentas de correo grupales',
        'CheckEmailAccounts' => 'Comprobar cuentas de correo personales',
        'SendEmailReminders' => 'Enviar Recordatorios por Email',
        'AuthTokenControl' => 'Control del Token de Autenticación',
        'SendEmailNotifications' => 'Enviar notificaciones por correo electrónico',
        'CheckNewVersion' => 'Verificar nueva versión',
        'ProcessWebhookQueue' => 'Procesar cola de webhook',
        'SendScheduledEmails' => 'Send Scheduled Emails',
        'ProcessMassEmail' => 'Enviar correo masivo',
        'ControlKnowledgeBaseArticleStatus' => 'Controlar estado de los artículos de la base de conocimiento',
        'ReportTargetListSync' => 'Sincronizar listas de destino con informes',
        'ScheduleReportSending' => 'Programar envío de informes',
        'RunScheduledWorkflows' => 'Ejecutar flujos de trabajo programados',
        'ProcessPendingProcessFlows' => 'Procesar flujos pendientes',
        'InventoryCompress' => 'Inventory Transaction Compress',
        'NotActualOrderLocking' => 'Lock Not Actual Orders',
        'InventoryDetach' => 'Inventory Transaction Detaching'
      ],
      'cronSetup' => [
        'linux' => 'Nota: añada esta línea al archivo crontab para que Partners pueda ejecutar las tareas programadas:',
        'mac' => 'Nota: añada esta línea al archivo crontab para que Partners pueda ejecutar las tareas programadas:',
        'windows' => 'Nota: Crear un archivo por lotes con los siguientes comandos para ejecutar tareas programadas de Partners usando tareas programadas de Windows:',
        'default' => 'Nota: Agregar este comando a Cron Job (Tarea Programada):'
      ],
      'status' => [
        'Active' => 'Activo',
        'Inactive' => 'Inactivo'
      ]
    ],
    'tooltips' => [
      'scheduling' => 'Notación crontab. Define la frecuencia de ejecución de trabajos.

`* / 5 * * * *` - cada 5 minutos

`0 * / 2 * * *` - cada 2 horas

`30 1 * * *` - a las 01:30 una vez al día

`0 0 1 * *` - el primer día del mes'
    ]
  ],
  'ScheduledJobLogRecord' => [
    'fields' => [
      'status' => 'Estado',
      'executionTime' => 'Fecha de ejecución',
      'target' => 'Objetivo'
    ]
  ],
  'Settings' => [
    'fields' => [
      'useCache' => 'Usar caché',
      'dateFormat' => 'Formato de fecha',
      'timeFormat' => 'Formato de hora',
      'timeZone' => 'Zona horaria',
      'weekStart' => 'Primer día de la semana',
      'thousandSeparator' => 'Separador de miles',
      'decimalMark' => 'Separador decimal',
      'defaultCurrency' => 'Moneda por defecto',
      'baseCurrency' => 'Moneda Base',
      'currencyRates' => 'Tipos de cambio',
      'currencyList' => 'Lista de monedas',
      'language' => 'Idioma',
      'companyLogo' => 'Logo de la empresa',
      'smsProvider' => 'SMS Provider',
      'outboundSmsFromNumber' => 'SMS From Number',
      'smtpServer' => 'Servidor',
      'smtpPort' => 'Puerto',
      'smtpAuth' => '¿Requiere autenticación?',
      'smtpSecurity' => 'Seguridad',
      'smtpUsername' => 'Nombre de usuario',
      'emailAddress' => 'Correo electrónico',
      'smtpPassword' => 'Contraseña',
      'outboundEmailFromName' => 'De (nombre):',
      'outboundEmailFromAddress' => 'De (email)',
      'outboundEmailIsShared' => '¿Es compartido?',
      'emailAddressLookupEntityTypeList' => 'Ámbitos de búsqueda de direcciones de correo electrónico',
      'emailAddressSelectEntityTypeList' => 'Email address select scopes',
      'recordsPerPage' => 'Registros por página',
      'recordsPerPageSmall' => 'Registros por página (pequeño)',
      'recordsPerPageSelect' => 'Records Per Page (Select)',
      'recordsPerPageKanban' => 'Records Per Page (Kanban)',
      'tabList' => 'Lista de pestañas',
      'quickCreateList' => 'Lista de creación rápida',
      'exportDelimiter' => 'Separador de campos',
      'globalSearchEntityList' => 'Búsqueda Global: Lista de entidades',
      'authenticationMethod' => 'Método de autenticación',
      'ldapHost' => 'Servidor',
      'ldapPort' => 'Puerto',
      'ldapAuth' => '¿Requiere autenticación?',
      'ldapUsername' => 'Nombre de usuario',
      'ldapPassword' => 'Contraseña',
      'ldapBindRequiresDn' => 'Bind Necesita Nd (Nombre Dominio)',
      'ldapBaseDn' => 'ND Base',
      'ldapAccountCanonicalForm' => 'Forma canónica de la cuenta',
      'ldapAccountDomainName' => 'Nombre de Dominio de la Cuenta',
      'ldapTryUsernameSplit' => 'Intentar dividir el nombre de Usuario',
      'ldapPortalUserLdapAuth' => 'Use la autenticación LDAP para usuarios del portal',
      'ldapCreateEspoUser' => 'Crear usuario en Partners',
      'ldapSecurity' => 'Seguridad',
      'ldapUserLoginFilter' => 'Usar Filtro en el Login',
      'ldapAccountDomainNameShort' => 'Nombre Dominio Corto para la Cuenta',
      'ldapOptReferrals' => 'Referencias Opt',
      'ldapUserNameAttribute' => 'Atributo de nombre de usuario',
      'ldapUserObjectClass' => 'Usuario ObjectClass',
      'ldapUserTitleAttribute' => 'Atributo del usuario Título',
      'ldapUserFirstNameAttribute' => 'Nombre de usuario Atributo',
      'ldapUserLastNameAttribute' => 'Apellido de usuario Atributo',
      'ldapUserEmailAddressAttribute' => 'Dirección de correo electrónico del usuario atributo',
      'ldapUserTeams' => 'Los equipos de los usuarios',
      'ldapUserDefaultTeam' => 'Equipo de usuario por defecto',
      'ldapUserPhoneNumberAttribute' => 'Número de teléfono del usuario Atributo',
      'ldapPortalUserPortals' => 'Portales predeterminados para un usuario del portal',
      'ldapPortalUserRoles' => 'Roles predeterminados para un usuario del portal',
      'exportDisabled' => 'Desactivar exportar (Solo estará permitido para el administrador)',
      'assignmentNotificationsEntityList' => 'Estas entidades notificarán al usuario cuando le sean asignadas',
      'assignmentEmailNotifications' => 'Se enviará un correo cuando reciba una asignación',
      'assignmentEmailNotificationsEntityList' => 'Entidades a notificar',
      'streamEmailNotifications' => 'Se enviará un correo sobre las actualizaciones en la historia para los usuarios internos',
      'portalStreamEmailNotifications' => 'Se enviará un correo sobre actualizaciones en la historia a los usuarios del portal',
      'streamEmailNotificationsEntityList' => 'Se notificará por correo en las siguientes entidades',
      'streamEmailNotificationsTypeList' => 'Qué se va a notificar',
      'streamEmailWithContentEntityTypeList' => 'Entities with email body in stream notes',
      'emailNotificationsDelay' => 'Retraso de las notificaciones por correo electrónico (en segundos)',
      'b2cMode' => 'Modo B2C',
      'avatarsDisabled' => 'Deshabilitar avatares',
      'followCreatedEntities' => 'Seguir los registros creados',
      'displayListViewRecordCount' => 'Mostrar totales (en la vista de lista)',
      'theme' => 'Tema',
      'userThemesDisabled' => 'Deshabilitar temas de usuarios',
      'attachmentUploadMaxSize' => 'Upload Max Size (Mb)',
      'attachmentUploadChunkSize' => 'Upload Chunk Size (Mb)',
      'emailMessageMaxSize' => 'Tamaño máximo de los correos entrantes (Mb)',
      'massEmailMaxPerHourCount' => 'Cantidad máxima de correos enviados por hora',
      'massEmailMaxPerBatchCount' => 'Max number of emails sent per batch',
      'personalEmailMaxPortionSize' => 'Cantidad máxima de correos personales que se recuperarán cada vez',
      'inboundEmailMaxPortionSize' => 'Cantidad máxima de correos grupales que se recuperarán cada vez',
      'maxEmailAccountCount' => 'Cantidad máxima de cuentas personales que se pueden crear por usuario',
      'emailScheduledBatchCount' => 'Max number of scheduled emails sent per batch',
      'authTokenLifetime' => 'Vida del token de autenticación (horas)',
      'authTokenMaxIdleTime' => 'Máximo tiempo de inactividad del token de autenticación (horas)',
      'dashboardLayout' => 'Diseño del escritorio (por defecto)',
      'siteUrl' => 'URL del sitio',
      'addressPreview' => 'Vista previa de la dirección',
      'addressFormat' => 'Formato de la Dirección',
      'personNameFormat' => 'Formato de nombre de persona',
      'notificationSoundsDisabled' => 'Desactivar los sonidos de notificación',
      'newNotificationCountInTitle' => 'Mostrar nuevo número de notificación en el título de la página',
      'applicationName' => 'Nombre de la aplicación',
      'calendarEntityList' => 'Lista de entidades de calendario',
      'busyRangesEntityList' => 'Lista de entidades libres / ocupadas',
      'mentionEmailNotifications' => 'Se enviará un correo cuando sean mencionados en los mensajes',
      'massEmailDisableMandatoryOptOutLink' => 'Deshabilitar la obligatoridad del enlace "darse de baja"',
      'massEmailOpenTracking' => 'Seguimiento de apertura de correo electrónico',
      'massEmailVerp' => 'Utilice VERP',
      'activitiesEntityList' => 'Lista de entidades de actividades',
      'historyEntityList' => 'Lista de entidades de historia',
      'currencyFormat' => 'Formato de Moneda',
      'currencyDecimalPlaces' => 'Lugares decimales en la moneda',
      'aclAllowDeleteCreated' => 'Permitir eliminar registros creados',
      'adminNotifications' => 'Notificaciones del sistema en el panel de administración',
      'adminNotificationsNewVersion' => 'Mostrar notificación cuando la nueva versión de Partners esté disponible',
      'adminNotificationsNewExtensionVersion' => 'Mostrar notificación cuando haya nuevas versiones de extensiones disponibles',
      'textFilterUseContainsForVarchar' => 'Utilice el operador \'contiene\' cuando filtre campos varchar',
      'phoneNumberNumericSearch' => 'Numeric phone number search',
      'phoneNumberInternational' => 'International phone numbers',
      'phoneNumberExtensions' => 'Phone number extensions',
      'phoneNumberPreferredCountryList' => 'Preferred telephone country codes',
      'authTokenPreventConcurrent' => 'Solo un token de autenticación por usuario',
      'scopeColorsDisabled' => 'Deshabilitar color de los ámbitos',
      'tabColorsDisabled' => 'Deshabilitar colores de pestañas',
      'tabIconsDisabled' => 'Deshabilitar íconos de pestañas',
      'emailAddressIsOptedOutByDefault' => 'Marcar nuevas direcciones de correo electrónico como excluídas',
      'outboundEmailBccAddress' => 'Dirección BCC para clientes externos',
      'cleanupDeletedRecords' => 'Limpiar registros eliminados',
      'addressCityList' => 'Lista de autocompletar de ciudades',
      'addressStateList' => 'Lista de autocompletar de estados',
      'fiscalYearShift' => 'Inicio del año fiscal',
      'jobRunInParallel' => 'Trabajos ejecutados en paralelo',
      'jobMaxPortion' => 'Máximo de trabajos ejecutándose',
      'jobPoolConcurrencyNumber' => 'Número de concurrencia del grupo de trabajos',
      'jobForceUtc' => 'Force UTC Time Zone',
      'daemonInterval' => 'Intervalo del demonio',
      'daemonMaxProcessNumber' => 'Máximo número de demonios ejecutándose',
      'daemonProcessTimeout' => 'Demonio Timeout',
      'cronDisabled' => 'Deshabilitar Tareas programadas',
      'maintenanceMode' => 'Modo de mantenimiento',
      'useWebSocket' => 'Usar WebSocket',
      'passwordRecoveryDisabled' => 'Deshabilitar recuperación de contraseña',
      'passwordRecoveryForAdminDisabled' => 'Deshabilitar la recuperación de contraseña para usuarios administradores',
      'passwordRecoveryForInternalUsersDisabled' => 'Deshabilitar la recuperación de contraseña para usuarios internos',
      'passwordRecoveryNoExposure' => 'Evite la exposición de la dirección de correo electrónico en el formulario de recuperación de contraseña',
      'passwordGenerateLength' => 'Longitud de las contraseñas generadas',
      'passwordStrengthLength' => 'Longitud mínima de contraseña',
      'passwordStrengthLetterCount' => 'Número de letras requeridas en la contraseña',
      'passwordStrengthNumberCount' => 'Número de dígitos requeridos en la contraseña',
      'passwordStrengthBothCases' => 'La contraseña debe contener letras mayúsculas y minúsculas',
      'passwordStrengthSpecialCharacterCount' => 'Number of special character required in password',
      'auth2FA' => 'Habilitar autenticación de 2 factores',
      'auth2FAForced' => 'Obligar a los usuarios habituales a configurar 2FA',
      'auth2FAMethodList' => 'Métodos 2FA disponibles',
      'auth2FAInPortal' => 'Allow 2FA in portals',
      'workingTimeCalendar' => 'Working Time Calendar',
      'oidcClientId' => 'OIDC Client ID',
      'oidcClientSecret' => 'OIDC Client Secret',
      'oidcAuthorizationRedirectUri' => 'OIDC Authorization Redirect URI',
      'oidcAuthorizationEndpoint' => 'OIDC Authorization Endpoint',
      'oidcTokenEndpoint' => 'OIDC Token Endpoint',
      'oidcJwksEndpoint' => 'OIDC JSON Web Key Set Endpoint',
      'oidcJwtSignatureAlgorithmList' => 'OIDC JWT Allowed Signature Algorithms',
      'oidcScopes' => 'OIDC Scopes',
      'oidcGroupClaim' => 'OIDC Group Claim',
      'oidcCreateUser' => 'OIDC Create User',
      'oidcUsernameClaim' => 'OIDC Username Claim',
      'oidcTeams' => 'OIDC Teams',
      'oidcSync' => 'OIDC Sync',
      'oidcSyncTeams' => 'OIDC Sync Teams',
      'oidcFallback' => 'OIDC Fallback Login',
      'oidcAllowRegularUserFallback' => 'OIDC Allow fallback login for regular users',
      'oidcAllowAdminUser' => 'OIDC Allow OIDC login for admin users',
      'oidcLogoutUrl' => 'OIDC Logout URL',
      'oidcAuthorizationPrompt' => 'OIDC Authorization Prompt',
      'pdfEngine' => 'PDF Engine',
      'quickSearchFullTextAppendWildcard' => 'Append wildcard in quick search',
      'authIpAddressCheck' => 'Restrict access by IP address',
      'authIpAddressWhitelist' => 'IP Address Whitelist',
      'authIpAddressCheckExcludedUsers' => 'Users excluded from check',
      'availableReactions' => 'Available Reactions',
      'priceBooksEnabled' => 'Price Books',
      'defaultPriceBook' => 'Default Price Book',
      'inventoryTransactionsEnabled' => 'Inventory Transactions',
      'warehousesEnabled' => 'Warehouses',
      'deliveryOrdersEnabled' => 'Delivery Orders',
      'receiptOrdersEnabled' => 'Receipt Orders',
      'eInvoiceFormat' => 'Default Format',
      'sellerCompanyName' => 'Company Name',
      'sellerElectronicAddressScheme' => 'Electronic Address Scheme',
      'sellerElectronicAddressIdentifier' => 'Electronic Address Identifier',
      'sellerVatNumber' => 'VAT Number',
      'sellerTaxRegistrationScheme' => 'Tax Registration Scheme',
      'sellerTaxRegistrationIdentifier' => 'Tax Registration Identifier',
      'sellerAddress' => 'Company Address',
      'sellerContactName' => 'Contact Name',
      'sellerContactEmailAddress' => 'Contact Email Address',
      'sellerContactPhoneNumber' => 'Contact Phone Number',
      'salesForbidOrderUnlock' => 'Forbid order unlocking',
      'addressCountryList' => 'Lista de autocompletar de países'
    ],
    'options' => [
      'authenticationMethod' => [
        'Oidc' => 'OIDC'
      ],
      'currencyFormat' => [
        1 => '10 USD',
        2 => '$10',
        3 => '10 $'
      ],
      'personNameFormat' => [
        'firstLast' => 'Primero último',
        'lastFirst' => 'Último primero',
        'firstMiddleLast' => 'Primero Segundo Nombre Apellido',
        'lastFirstMiddle' => 'Último primero medio'
      ],
      'streamEmailNotificationsTypeList' => [
        'Post' => 'Entradas',
        'Status' => 'Estados de actualizaciones',
        'EmailReceived' => 'Emails recibidos'
      ],
      'auth2FAMethodList' => [
        'Totp' => 'TOTP
',
        'Email' => 'Email',
        'Sms' => 'SMS'
      ]
    ],
    'tooltips' => [
      'authIpAddressCheckExcludedUsers' => 'Users that will be able to log in regardless whether their IP address is in the whitelist.',
      'authIpAddressWhitelist' => 'A list of IP addresses or ranges in CIDR notation.

Portals are not affected by restriction.',
      'workingTimeCalendar' => 'A working time calendar that will be applied to all users by default.',
      'displayListViewRecordCount' => 'Se mostrará un número total de registros en la vista de lista.',
      'currencyList' => 'Qué divisas estarán disponibles en el sistema.',
      'activitiesEntityList' => 'Qué registros estarán disponibles en el panel Actividades.',
      'historyEntityList' => 'Qué registros estarán disponibles en el panel Historial.',
      'calendarEntityList' => 'Qué registros estarán disponibles en el Calendario.',
      'addressStateList' => 'Indique sugerencias para los campos de dirección.',
      'addressCityList' => 'Sugerencias de ciudades para campos de direcciones.',
      'addressCountryList' => 'Sugerencias de países para campos de direcciones.',
      'exportDisabled' => 'Los usuarios no podrán exportar registros. Solo se permitirá el administrador.',
      'globalSearchEntityList' => 'Qué registros se pueden buscar con la búsqueda global.',
      'siteUrl' => 'Una URL de esta instancia de Partners. Necesita cambiarlo si se muda a otro dominio.',
      'useCache' => 'No se recomienda deshabilitar, a menos que sea con fines de desarrollo.',
      'useWebSocket' => 'WebSocket permite la comunicación interactiva bidireccional entre un servidor y un navegador. Requiere configurar el demonio WebSocket en su servidor. Consulte la documentación para obtener más información.',
      'passwordRecoveryForInternalUsersDisabled' => 'Solo los usuarios del portal podrán recuperar la contraseña.',
      'passwordRecoveryNoExposure' => 'No será posible determinar si una dirección de correo electrónico específica está registrada en el sistema.',
      'emailAddressLookupEntityTypeList' => 'Para autocompletar la dirección de correo electrónico.',
      'emailAddressSelectEntityTypeList' => 'Entity types available when searching for an email address from a modal.',
      'emailNotificationsDelay' => 'Un mensaje se puede editar dentro del período de tiempo especificado antes de que se envíe la notificación.',
      'outboundEmailFromAddress' => 'La dirección de correo electrónico del sistema.',
      'smtpServer' => 'Si está vacío, se utilizará la cuenta de correo electrónico del grupo con la dirección de correo electrónico correspondiente.',
      'busyRangesEntityList' => 'Qué se tendrá en cuenta al mostrar rangos de tiempo ocupado en el programador y la línea de tiempo.',
      'massEmailVerp' => 'Ruta de retorno de sobre variable. Para un mejor manejo de los mensajes rebotados. Asegúrese de que su proveedor de SMTP lo admita.',
      'recordsPerPage' => 'Número de registros a mostrar inicialmente en las vistas.',
      'recordsPerPageSmall' => 'Número de registros a mostrar inicialmente en los paneles relacionados',
      'recordsPerPageSelect' => 'Number of records initially displayed when selecting records.',
      'recordsPerPageKanban' => 'Number of records initially displayed in kanban columns.',
      'outboundEmailIsShared' => 'Permitir a los usuarios enviar correos electrónicos desde esta dirección.',
      'followCreatedEntities' => 'Los usuarios seguirán automáticamente los registros que ellos crearon.',
      'emailMessageMaxSize' => 'Todos los correos entrantes que superen un tamaño especificado se omitirán.',
      'authTokenLifetime' => 'Define cuanto tiempo de vida tienen los tokens.
0 - significa que no caduca.',
      'authTokenMaxIdleTime' => 'Define cuándo caduca el Token luego del último acceso.
0 - significa que no caduca.',
      'userThemesDisabled' => 'Si está marcado, los usuarios no podrán seleccionar otro tema.',
      'ldapUsername' => 'El sistema de usuario DN completo que permite a los usuarios buscar otros. E.g. "CN=LDAP usuario del sistema,OU=users,OU=espocrm, DC=test,DC=lan".',
      'ldapPassword' => 'La contraseña para acceder al servidor LDAP.',
      'ldapAuth' => 'Credenciales de acceso para el servidor LDAP.',
      'ldapUserNameAttribute' => 'El atributo para identificar al usuario.
Por ejemplo: "userPrincipalName" o "sAMAccountName" para Active Directory, "uid" para OpenLDAP.',
      'ldapUserObjectClass' => 'Atributo ObjectClass para buscar usuarios. Por ejemplo: "person" para AD, "inetOrgPerson" para OpenLDAP.',
      'ldapAccountCanonicalForm' => 'El tipo de forma canónica de su cuenta. Hay 4 opciones:

- \'Dn\' - el formulario en el formato CN=tester,OU=espocrm,DC=test, DC=lan\'.

- \'Username\': el formulario \'tester\'.

- \'Backslash\': el formulario \'COMPANY\\tester\'.

- \'Principal\': el formulario \'tester@company.com\'.',
      'ldapBindRequiresDn' => 'La opción para formatear el nombre de usuario en el formulario de DN.',
      'ldapBaseDn' => 'La base DN predeterminado utilizado para la búsqueda de los usuarios. E.g. "OU=users,OU=espocrm,DC=test, DC=lan".',
      'ldapTryUsernameSplit' => 'La opción de dividir un nombre de usuario con el dominio.',
      'ldapOptReferrals' => 'La opción de dividir un nombre de usuario con el dominio.',
      'ldapPortalUserLdapAuth' => 'Permita que los usuarios del portal utilicen la autenticación LDAP en lugar de la autenticación Espo.',
      'ldapCreateEspoUser' => 'Esta opción permite Partners para crear un usuario del LDAP.',
      'ldapUserFirstNameAttribute' => 'atributo LDAP que se utiliza para determinar el nombre de usuario primero. E.g. "givenname".',
      'ldapUserLastNameAttribute' => 'LDAP attribute which is used to determine the user last name. E.g. "sn".',
      'ldapUserTitleAttribute' => 'LDAP attribute which is used to determine the user title. E.g. "title".',
      'ldapUserEmailAddressAttribute' => 'LDAP attribute which is used to determine the user email address. E.g. "mail".',
      'ldapUserPhoneNumberAttribute' => 'LDAP attribute which is used to determine the user phone number. E.g. "telephoneNumber".',
      'ldapUserLoginFilter' => 'The filter which allows to restrict users who able to use Partners. E.g. "memberOf=CN=espoGroup, OU=groups,OU=espocrm, DC=test,DC=lan".',
      'ldapAccountDomainName' => 'The domain which is used for authorization to LDAP server.',
      'ldapAccountDomainNameShort' => 'The short domain which is used for authorization to LDAP server.',
      'ldapUserTeams' => 'Equipos de usuario creado. Para más información, véase el perfil de usuario.',
      'ldapUserDefaultTeam' => 'equipo predeterminado de usuario creado. Para más información, véase el perfil de usuario.',
      'ldapPortalUserPortals' => 'Portales predeterminados para el usuario del portal creados',
      'ldapPortalUserRoles' => 'Roles predeterminados para el usuario del portal creados',
      'b2cMode' => 'Por defecto Partners esta adaptado para B2B. Usted puede cambiarlo a B2C.',
      'currencyDecimalPlaces' => 'Número de decimales. Si está vacía, se mostrarán todas las posiciones decimales disponibles.',
      'aclStrictMode' => 'Activado: el acceso a los ámbitos estará prohibido si no está especificado en roles.

Deshabilitado: se permitirá el acceso a ámbitos si no está especificado en roles.',
      'aclAllowDeleteCreated' => 'Los usuarios podrán eliminar sus propios registros, incluso si no tienen un acceso de eliminación.',
      'textFilterUseContainsForVarchar' => 'Si no está marcado, se utiliza el operador \'comienza con\'. Puede usar el comodín \'%\'.',
      'streamEmailNotificationsEntityList' => 'Notificaciones por correo electrónico sobre actualizaciones de flujo de registros seguidos. Los usuarios recibirán notificaciones por correo electrónico solo para los tipos de entidad especificados.',
      'authTokenPreventConcurrent' => 'Los usuarios no podrán iniciar sesión en varios dispositivos simultáneamente.',
      'emailAddressIsOptedOutByDefault' => 'Al crear un nuevo registro, la dirección de correo electrónico se marcará como excluida.',
      'cleanupDeletedRecords' => 'Los registros eliminados se eliminarán de la base de datos después de un tiempo.',
      'jobRunInParallel' => 'Los trabajos se ejecutarán en procesos paralelos.',
      'jobPoolConcurrencyNumber' => 'Número máximo de procesos ejecutados simultáneamente.',
      'jobMaxPortion' => 'Número máximo de trabajos procesados por una ejecución.',
      'jobForceUtc' => 'Use the UTC time zone for scheduled jobs. Otherwise, the time zone set in settings will be used.',
      'daemonInterval' => 'Intervalo entra la ejecución de cada Tarea Programada. En segundos.',
      'daemonMaxProcessNumber' => 'Número máximo de Tareas programada ejecutados simultáneamente.',
      'daemonProcessTimeout' => 'Tiempo máximo de ejecución (en segundos) asignado para un solo proceso cron.',
      'cronDisabled' => 'Las tareas Programadas no se ejecutarán',
      'maintenanceMode' => 'Solo los administradores tendrán acceso al sistema.',
      'oidcGroupClaim' => 'A claim to use for team mapping.',
      'oidcFallback' => 'Allow login by username/password.',
      'oidcCreateUser' => 'Create a new user in Espo when no matching user found.',
      'oidcSync' => 'Sync user data (on every login).',
      'oidcSyncTeams' => 'Sync user teams (on every login).',
      'oidcUsernameClaim' => 'A claim to use for a username (for user matching and creation).',
      'oidcTeams' => 'Espo teams mapped against groups/teams/roles of the identity provider. Teams with an empty mapping value will be always assigned to a user (when creating or syncing).',
      'oidcLogoutUrl' => 'An URL the browser will redirect to after logging out from Espo. Intended for clearing the session information in the browser and doing logging out on the provider side. Usually the URL contains a redirect-URL parameter, to return back to Espo.

Available placeholders:
* `{siteUrl}`
* `{clientId}`',
      'quickSearchFullTextAppendWildcard' => 'Append a wildcard to an autocomplete search query when Full-Text search is enabled. Reduces search performance.',
      'salesForbidOrderUnlock' => 'Once an order is locked, it can only be unlocked by an administrator.'
    ],
    'labels' => [
      'Group Tab' => 'Ficha Grupo',
      'Divider' => 'Divider',
      'System' => 'Sistema',
      'Locale' => 'Localización',
      'Search' => 'Buscar',
      'Misc' => 'Misceláneos',
      'SMTP' => 'SMTP',
      'General' => 'General',
      'Phone Numbers' => 'Phone Numbers',
      'Navbar' => 'Navbar',
      'Dashboard' => 'Dashboard',
      'Configuration' => 'Configuración',
      'In-app Notifications' => 'Notificaciones del sistema',
      'Email Notifications' => 'Notificaciones de correo',
      'Currency Settings' => 'Ajustes de moneda',
      'Currency Rates' => 'Tasas de conversión de divisas',
      'Mass Email' => 'Correo masivo',
      'Scheduled Send' => 'Scheduled Send',
      'Test Connection' => 'Probar conexión',
      'Connecting' => 'Conectando...',
      'Activities' => 'Actividades planeadas',
      'Admin Notifications' => 'Notificaciones de administrador',
      'Passwords' => 'Contraseñas',
      '2-Factor Authentication' => 'Autenticación de 2 factores',
      'Attachments' => 'Attachments',
      'IdP Group' => 'IdP Group',
      'Access' => 'Access',
      'Strength' => 'Strength',
      'Recovery' => 'Recovery',
      'Electronic Invoicing' => 'Electronic Invoicing',
      'Seller Information' => 'Seller Information'
    ],
    'messages' => [
      'ldapTestConnection' => 'La conexión fue establecida con éxito.'
    ]
  ],
  'Stream' => [
    'messages' => [
      'infoMention' => 'Escriba **@nombredeusuario** para mencionar al usuario en la publicación.',
      'infoSyntax' => 'Sintaxis de markdown disponible',
      'couldNotAddFollowerUserHasNoAccessToStream' => 'Could not add the user \'{userName}\' to the followers. The user does not have \'stream\' access to the record.'
    ],
    'syntaxItems' => [
      'code' => 'código',
      'multilineCode' => 'código multilínea',
      'strongText' => 'texto en negrita',
      'emphasizedText' => 'texto enfatizado',
      'deletedText' => 'texto eliminado',
      'blockquote' => 'bloque de cita',
      'link' => 'enlace'
    ]
  ],
  'Team' => [
    'fields' => [
      'name' => 'Nombre',
      'roles' => 'Roles',
      'layoutSet' => 'Conjunto de diseño',
      'workingTimeCalendar' => 'Working Time Calendar',
      'positionList' => 'Lista de puestos',
      'userRole' => 'User Role'
    ],
    'links' => [
      'users' => 'Usuarios',
      'notes' => 'Notas',
      'roles' => 'Roles',
      'layoutSet' => 'Conjunto de diseño',
      'workingTimeCalendar' => 'Working Time Calendar',
      'inboundEmails' => 'Cuentas de correo grupales',
      'groupEmailFolders' => 'Group Email Folders'
    ],
    'tooltips' => [
      'workingTimeCalendar' => 'A calendar will be applied to users who have this team set as a Default Team.',
      'layoutSet' => 'Proporciona la capacidad de tener diseños que difieran de los estándar. El Conjunto de diseño se aplicará a los usuarios que tengan este equipo configurado como Equipo predeterminado.',
      'roles' => 'Todos los usuarios de este equipo tendrán acceso a la configuración desde los roles seleccionados',
      'positionList' => 'Puestos disponibles en este equipo. Por ejemplo Vendedor, Gerente.'
    ],
    'labels' => [
      'Create Team' => 'Crear equipo'
    ]
  ],
  'Template' => [
    'fields' => [
      'name' => 'Nombre',
      'body' => 'Cuerpo',
      'entityType' => 'Tipo de entidad',
      'header' => 'Cabecera',
      'footer' => 'Pié',
      'leftMargin' => 'Margen Izquierdo',
      'topMargin' => 'Margen Superior',
      'rightMargin' => 'Margen Derecho',
      'bottomMargin' => 'Margen Inferior',
      'printFooter' => 'Imprimir Pié',
      'printHeader' => 'Print Header',
      'footerPosition' => 'Posición del Pié',
      'headerPosition' => 'Posición del encabezado',
      'variables' => 'Etiquetas disponibles.',
      'pageOrientation' => 'Oriteción de página',
      'pageFormat' => 'Formato de papel',
      'pageWidth' => 'Ancho de página (mm)',
      'pageHeight' => 'Altura de página (mm)',
      'fontFace' => 'Fuente',
      'title' => 'Title',
      'style' => 'Style'
    ],
    'links' => [],
    'labels' => [
      'Create Template' => 'Crear plantilla'
    ],
    'options' => [
      'pageOrientation' => [
        'Portrait' => 'Vertical',
        'Landscape' => 'Horizontal'
      ],
      'pageFormat' => [
        'Custom' => 'Personalizada'
      ],
      'placeholders' => [
        'pagebreak' => 'Salto de página',
        'today' => 'Hoy (fecha)',
        'now' => 'Ahora (fecha/hora)'
      ],
      'fontFace' => [
        'kozgopromedium' => '
Kozgo Pro Medium',
        'kozminproregular' => '
Kozmin Pro Regular',
        'msungstdlight' => '
Msung Std Light',
        'stsongstdlight' => '
STSong Std Light',
        'symbol' => 'Símbolo'
      ]
    ],
    'tooltips' => [
      'footer' => 'Use {pageNumber} para imprimir el número de página.',
      'variables' => 'Copie y Pegue la etiqueta necesaria en el encabezado, cuerpo o pie de página.'
    ]
  ],
  'User' => [
    'fields' => [
      'name' => 'Nombre',
      'userName' => 'Nombre de Usuario',
      'title' => 'Título',
      'type' => 'Tipo',
      'isAdmin' => 'Es administrador',
      'defaultTeam' => 'Equipo por defecto',
      'emailAddress' => 'Correo electrónico',
      'phoneNumber' => 'Teléfono',
      'roles' => 'Roles',
      'portals' => 'Portales',
      'portalRoles' => 'Roles del portal',
      'teamRole' => 'Puesto',
      'password' => 'Contraseña',
      'currentPassword' => 'Contraseña Actual',
      'passwordConfirm' => 'Confirmar Contraseña',
      'newPassword' => 'Nueva Contraseña',
      'newPasswordConfirm' => 'Confirmar Contraseña Nueva',
      'yourPassword' => 'Tu contraseña actual',
      'avatar' => 'Avatar',
      'avatarColor' => 'Avatar Color',
      'isActive' => 'Está activo',
      'isPortalUser' => 'Es usuario del portal',
      'contact' => 'Contacto',
      'accounts' => 'Cuentas',
      'account' => 'Cuenta (principal)',
      'sendAccessInfo' => 'Enviar información de acceso al usuario',
      'portal' => 'Portal',
      'gender' => 'Sexo',
      'position' => 'Puesto en el equipo',
      'ipAddress' => 'Dirección IP',
      'passwordPreview' => 'Vista previa de la contraseña',
      'isSuperAdmin' => 'Es superadministrador',
      'lastAccess' => 'Último acceso',
      'apiKey' => 'Clave de API',
      'secretKey' => 'Clave de secreto',
      'dashboardTemplate' => 'Plantilla de escritorio',
      'workingTimeCalendar' => 'Working Time Calendar',
      'auth2FA' => '2FA',
      'authMethod' => 'Método de autenticación',
      'auth2FAEnable' => 'Habilitar autenticación de 2 factores',
      'auth2FAMethod' => 'Método 2FA',
      'auth2FATotpSecret' => '2FA TOTP Secreto',
      'layoutSet' => 'Layout Set',
      'acceptanceStatus' => 'Estado de Aceptación',
      'acceptanceStatusMeetings' => 'Estado de aceptación (Reuniones)',
      'acceptanceStatusCalls' => 'Estado de aceptación (Llamadas)',
      'customerId' => 'Customer Tenant ID',
      'usertoken' => 'User Token',
      'partnerid' => 'MPN ID',
      'isChecked' => 'Is Checked?',
      'clientid' => 'Client_id',
      'clientsecret' => 'Client_secret',
      'country' => 'País',
      'awsClientId' => 'AwsClientId',
      'awsClientSecret' => 'AwsClientSecret',
      'awsMargem' => 'AwsMargem',
      'cRegistration' => 'Cadastro',
      'cAccess' => 'Acesso',
      'cLinkPortal' => 'Link Portal'
    ],
    'links' => [
      'defaultTeam' => 'Equipo predeterminado',
      'teams' => 'Equipos',
      'roles' => 'Roles',
      'notes' => 'Notas',
      'portals' => 'Portales',
      'portalRoles' => 'Roles del portal',
      'contact' => 'Contacto',
      'accounts' => 'Cuentas',
      'account' => 'Cuenta (principal)',
      'tasks' => 'Tareas',
      'userData' => 'Datos del usuario',
      'dashboardTemplate' => 'Plantilla de escritorio',
      'workingTimeCalendar' => 'Working Time Calendar',
      'workingTimeRanges' => 'Working Time Exceptions',
      'layoutSet' => 'Layout Set',
      'targetLists' => 'Lista de objetivos',
      'cRegistration' => 'Cadastro'
    ],
    'labels' => [
      'Create User' => 'Crear usuario',
      'Generate' => 'Generar',
      'Access' => 'Acceso',
      'Preferences' => 'Preferencias',
      'Change Password' => 'Cambiar Contraseña',
      'Teams and Access Control' => 'Equipos y control de acceso',
      'Forgot Password?' => '¿Olvidó la Contraseña?',
      'Password Change Request' => 'Solicitar Cambio de Contraseña',
      'Email Address' => 'Correo electrónico',
      'External Accounts' => 'Cuentas externas',
      'Email Accounts' => 'Cuentas de correo',
      'Portal' => 'Portal',
      'Create Portal User' => 'Crear usuario del portal',
      'Proceed w/o Contact' => 'Continuar sin contacto',
      'Generate New API Key' => 'Generar una nueva clave de API',
      'Generate New Password' => 'Generar nueva contraseña',
      'Send Password Change Link' => 'Send Password Change Link',
      'Back to login form' => 'Volver al formulario de inicio de sesión',
      'Requirements' => 'Requisitos',
      'Security' => 'Seguridad',
      'Reset 2FA' => 'Reiniciar 2FA',
      'Code' => 'Código',
      'Secret' => 'Secreto',
      'Send Code' => 'Send Code',
      'Login Link' => 'Login Link'
    ],
    'tooltips' => [
      'defaultTeam' => 'Todos los registros creados por este usuario serán relacionados a este equipo por defecto.',
      'userName' => 'Letras a-z, números 0-9 y guiones bajos están permitidos',
      'isAdmin' => 'El usuario administrador puede tener acceso a todo.',
      'isActive' => 'Si lo desmarca, el usuario no podrá iniciar sesión.',
      'teams' => 'Equipos a los que este usuario pertenece. Nivel de control de acceso se hereda de los roles de equipo.',
      'roles' => 'Roles de acceso adicionales. Úsalo si el usuario no pertenece a ningún equipo o si necesita ampliar el nivel de control de acceso solo para este usuario.',
      'portalRoles' => 'Roles adicionales del portal. Utilícelos para extender el nivel de acceso exclusivamente para este usuario.',
      'portals' => 'El usuario tiene accesos a los siguientes portales.',
      'layoutSet' => 'Layouts from a specified set will be applied for the user instead of default ones.'
    ],
    'messages' => [
      '2faMethodNotConfigured' => 'The 2FA method is not fully configured in the system.',
      'loginAs' => 'Open the login link in an incognito window to preserve your current session. Use your admin credentials to log in.',
      'sendPasswordChangeLinkConfirmation' => 'An email with a unique link will be sent to the user allowing them to change their password. The link will expire after a specific amount of time.',
      'passwordRecoverySentIfMatched' => 'Suponiendo que los datos ingresados coincidieran con cualquier cuenta de usuario.',
      'passwordStrengthLength' => 'Debe tener al menos {length} caracteres de longitud.',
      'passwordStrengthLetterCount' => 'Debe contener al menos {count} letras.',
      'passwordStrengthNumberCount' => 'Debe contener al menos {count} dígito(s).',
      'passwordStrengthSpecialCharacterCount' => 'Must contain at least {count} special character(s).',
      'passwordStrengthBothCases' => 'Debe contener letras en mayúscula y minúscula.',
      'passwordWillBeSent' => 'La Contraseña será enviada al correo electrónico del usuario',
      'passwordChanged' => 'La Contraseña ha sido cambiada',
      'userCantBeEmpty' => 'El nombre de usuario no puede estar vacío',
      'wrongUsernamePassword' => 'Nombre de usuario/contraseña incorrectos',
      'failedToLogIn' => 'Failed to log in',
      'emailAddressCantBeEmpty' => 'La dirección de correo no puede estar vacía',
      'userNameEmailAddressNotFound' => 'Nombre de Usuario/Correo no encontrado',
      'forbidden' => 'Prohibido, por favor intente después',
      'uniqueLinkHasBeenSent' => 'El enlace único ha sido enviado a la dirección de correo electrónico especificada.',
      'passwordChangedByRequest' => 'La contraseña ha sido cambiada.',
      'setupSmtpBefore' => 'Debe configurar [Configuración SMTP]({url}) para que el sistema pueda enviar la contraseña por correo electrónico.',
      'userNameExists' => 'Nombre de usuario ya existe',
      'loginError' => 'Error occurred',
      'wrongCode' => 'Código incorrecto',
      'codeIsRequired' => 'El código es obligatorio',
      'yourAuthenticationCode' => 'Your authentication code: {code}.',
      'choose2FaSmsPhoneNumber' => 'Select a phone number that will be used for 2FA.',
      'choose2FaEmailAddress' => 'Select an email address that will be used for 2FA. It\'s highly recommended to use a non-primary email address.',
      'enterCodeSentInEmail' => 'Enter the code sent to your email address.',
      'enterCodeSentBySms' => 'Enter the code sent by SMS to your phone number.',
      'enterTotpCode' => 'Ingrese un código de su aplicación de autenticación.',
      'verifyTotpCode' => 'Escanee el código QR con su aplicación de autenticación móvil. Si tiene problemas para escanear, puede ingresar el secreto manualmente. Después de eso, verá un código de 6 dígitos en su aplicación. Ingresar este código en el campo de abajo.',
      'generateAndSendNewPassword' => 'Se generará una nueva contraseña y se enviará a la dirección de correo electrónico del usuario.',
      'security2FaResetConfirmation' => '¿Está seguro de que desea restablecer la configuración actual de 2FA?',
      'auth2FARequiredHeader' => 'Se requiere autenticación de 2 factores',
      'auth2FARequired' => 'Debe configurar la autenticación de 2 factores. Utilice una aplicación de autenticación en su teléfono móvil (por ejemplo, Google Authenticator).',
      'ldapUserInEspoNotFound' => 'El usuario no se encuentra en Partners. Póngase en contacto con su administrador para crear el usuario.',
      'passwordChangeRequestNotFound' => 'The password change request is not found. It might be expired. Try to initiate a new password recovery from the [login page]({url}).',
      'defaultTeamIsNotUsers' => 'Default Team should be one of user\'s Teams'
    ],
    'options' => [
      'gender' => [
        '' => 'No definido',
        'Male' => 'Masculino',
        'Female' => 'Femenino',
        'Neutral' => 'Neutral'
      ],
      'type' => [
        'regular' => 'Regular',
        'admin' => 'Administrador',
        'portal' => 'Portal',
        'system' => 'SIstema',
        'super-admin' => 'Superadministrador',
        'api' => 'API'
      ],
      'authMethod' => [
        'ApiKey' => 'Clave de API',
        'Hmac' => 'HMAC'
      ]
    ],
    'boolFilters' => [
      'onlyMyTeam' => 'Solo de mi equipo',
      'onlyMe' => 'OnlyMe'
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'activePortal' => 'Portales activos',
      'activeApi' => 'API Activa'
    ],
    'actions' => [
      'changePosition' => 'Change Position'
    ]
  ],
  'Webhook' => [
    'labels' => [
      'Create Webhook' => 'Crear Webhook'
    ],
    'fields' => [
      'event' => 'Evento',
      'url' => 'URL',
      'isActive' => 'Está activo',
      'user' => 'Usuario de API',
      'entityType' => 'Tipo de entidad',
      'field' => 'Campo',
      'secretKey' => 'Clave de secreto'
    ],
    'links' => [
      'user' => 'Usuario'
    ]
  ],
  'WebhookQueueItem' => [
    'fields' => [
      'event' => 'Event',
      'webhook' => 'Webhook',
      'target' => 'Target',
      'data' => 'Data',
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'attempts' => 'Attempts',
      'processAt' => 'Process At'
    ],
    'links' => [
      'webhook' => 'Webhook'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ]
  ],
  'WorkingTimeCalendar' => [
    'labels' => [
      'Create WorkingTimeCalendar' => 'Create Calendar'
    ],
    'fields' => [
      'timeZone' => 'Time Zone',
      'timeRanges' => 'Workday Schedule',
      'weekday0' => 'Sun',
      'weekday1' => 'Mon',
      'weekday2' => 'Tue',
      'weekday3' => 'Wed',
      'weekday4' => 'Thu',
      'weekday5' => 'Fri',
      'weekday6' => 'Sat',
      'weekday0TimeRanges' => 'Sun Schedule',
      'weekday1TimeRanges' => 'Mon Schedule',
      'weekday2TimeRanges' => 'Tue Schedule',
      'weekday3TimeRanges' => 'Wed Schedule',
      'weekday4TimeRanges' => 'Thu Schedule',
      'weekday5TimeRanges' => 'Fri Schedule',
      'weekday6TimeRanges' => 'Sat Schedule'
    ],
    'links' => [
      'ranges' => 'Exceptions'
    ]
  ],
  'WorkingTimeRange' => [
    'labels' => [
      'Create WorkingTimeRange' => 'Create Exception',
      'Calendars' => 'Calendars'
    ],
    'fields' => [
      'timeRanges' => 'Schedule',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'type' => 'Type',
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'links' => [
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'options' => [
      'type' => [
        'Non-working' => 'Non-working',
        'Working' => 'Working'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Actual'
    ],
    'tooltips' => [
      'calendars' => 'Calendars to apply the exception to. The exception will be applied to all users of selected calendars.

Leave the field empty if you need to apply the exception only for specific users.',
      'users' => 'Specific users to apply the exception to.'
    ]
  ],
  'Account' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'website' => 'Sitio web',
      'phoneNumber' => 'Teléfono',
      'billingAddress' => 'Dirección de facturación',
      'shippingAddress' => 'Dirección de envío',
      'description' => 'Descripción',
      'sicCode' => 'Código SIC',
      'industry' => 'Industria',
      'type' => 'Tipo',
      'contactRole' => 'Título',
      'contactIsInactive' => 'Inactivo',
      'campaign' => 'Campaña',
      'targetLists' => 'Lista de objetivos',
      'targetList' => 'Lista de objetivos',
      'originalLead' => 'Posible cliente de origen',
      'priceBook' => 'Price Book',
      'electronicAddressScheme' => 'Electronic Address Scheme',
      'electronicAddressIdentifier' => 'Electronic Address Identifier',
      'products' => 'Products',
      'recommendations' => 'Recommendations',
      'resourceCategories' => 'ResourceCategories',
      'resourceGroups' => 'ResourceGroups',
      'resourceSubCategories' => 'ResourceSubCategories',
      'monitorings' => 'Monitorings',
      'edge' => 'Edge',
      'tags' => 'Tags',
      'subscriptions' => 'Subscriptions',
      'country' => 'Country',
      'clientsecret' => 'Client_secret',
      'clientid' => 'Client_id',
      'cMpnID' => 'Tier 2 MPN ID',
      'cTenantID' => 'Customer Tenant ID',
      'cRegistrationsReseller' => 'Registration: Reseller',
      'cRegistrationsCustomer' => 'Registration: End Customer',
      'cRecommendationsConfig' => 'Recommendations',
      'cRecommendationses' => 'Recommendations'
    ],
    'links' => [
      'contacts' => 'Contactos',
      'contactsPrimary' => 'Contacts (primary)',
      'opportunities' => 'Oportunidades',
      'cases' => 'Tickets',
      'documents' => 'Documentos',
      'meetingsPrimary' => 'Reuniones (ampliado)',
      'callsPrimary' => 'Llamadas (ampliado)',
      'tasksPrimary' => 'Tareas (ampliado)',
      'emailsPrimary' => 'Correos (ampliado)',
      'targetLists' => 'Lista de objetivos',
      'campaignLogRecords' => 'Registro de Campaña',
      'campaign' => 'Campaña',
      'portalUsers' => 'Usuarios del portal',
      'originalLead' => 'Posible cliente de origen',
      'priceBook' => 'Price Book',
      'supplier' => 'Supplier',
      'quotes' => 'Presupuestos',
      'quoteItems' => 'Artículos de presupuesto',
      'salesOrders' => 'Órdenes de venta',
      'salesOrderItems' => 'Artículos de orden de venta',
      'invoices' => 'Facturas',
      'invoiceItems' => 'Artículos de la factura',
      'purchaseOrders' => 'Purchase Orders',
      'purchaseOrderItems' => 'Purchase Order Items',
      'deliveryOrders' => 'Delivery Orders',
      'deliveryOrderItems' => 'Delivery Order Items',
      'receiptOrders' => 'Receipt Orders',
      'receiptOrderItems' => 'Receipt Order Items',
      'returnOrders' => 'Return Orders',
      'returnOrderItems' => 'Return Order Items',
      'products' => 'Products',
      'recommendations' => 'Recommendations',
      'resourceCategories' => 'ResourceCategories',
      'resourceGroups' => 'ResourceGroups',
      'resourceSubCategories' => 'ResourceSubCategories',
      'monitorings' => 'Monitorings',
      'tags' => 'Tags',
      'subscriptions' => 'Subscriptions',
      'cRegistrationsReseller' => 'Registration: Reseller',
      'cRegistrationsCustomer' => 'Registration: End Customer',
      'cRecommendationsConfig' => 'Recommendations',
      'cRecommendationses' => 'Recommendations'
    ],
    'options' => [
      'type' => [
        'Customer' => 'Cliente',
        'Investor' => 'Inversor',
        'Partner' => 'Socio',
        'Reseller' => 'Revendedor'
      ],
      'industry' => [
        'Aerospace' => 'Aeroespacial',
        'Agriculture' => 'Agrícola',
        'Advertising' => 'Publicidad',
        'Apparel & Accessories' => 'Ropa y accesorios',
        'Architecture' => 'Arquitectura',
        'Automotive' => 'Automotriz',
        'Banking' => 'Banca',
        'Biotechnology' => 'Biotecnología',
        'Building Materials & Equipment' => 'Materiales de construcción y equipamiento',
        'Chemical' => 'Química',
        'Construction' => 'Construcción',
        'Computer' => 'Computación',
        'Defense' => 'Defensa',
        'Creative' => 'Creativa',
        'Culture' => 'Cultural',
        'Consulting' => 'Consultoría',
        'Education' => 'Educación',
        'Electronics' => 'Electrónicos',
        'Electric Power' => 'Energía eléctrica',
        'Energy' => 'Energía',
        'Entertainment & Leisure' => 'Entretenimiento y ocio',
        'Finance' => 'Finanzas',
        'Food & Beverage' => 'Alimentación y bebidas',
        'Grocery' => 'Comestibles',
        'Hospitality' => 'Hostelería',
        'Healthcare' => 'Cuidado de la salud',
        'Insurance' => 'Seguros',
        'Legal' => 'Jurídica',
        'Manufacturing' => 'Fabricación',
        'Mass Media' => 'Medios masivos',
        'Mining' => 'Minería',
        'Music' => 'Música',
        'Marketing' => 'Marketing',
        'Publishing' => 'Publicaciones',
        'Petroleum' => 'Petróleo',
        'Real Estate' => 'Bienes raices',
        'Retail' => 'Venta al por menor',
        'Shipping' => 'Naviera',
        'Service' => 'Servicio',
        'Support' => 'Soporte',
        'Sports' => 'Deportes',
        'Software' => 'Software',
        'Technology' => 'Tecnología',
        'Telecommunications' => 'Telecomunicaciones',
        'Television' => 'Televisión',
        'Testing, Inspection & Certification' => 'Pruebas, inspección y certificación',
        'Transportation' => 'Transporte',
        'Travel' => 'Viajes',
        'Venture Capital' => 'Capital de riesgo',
        'Wholesale' => 'Venta al por mayor',
        'Water' => 'Agua'
      ],
      'edge' => [
        'Engage' => 'Engage',
        'Develop' => 'Develop',
        'Grow' => 'Grow',
        'Extend' => 'Extend',
        '' => ''
      ],
      'country' => [
        'Select' => 'Selecione',
        'Argentina' => 'Argentina',
        'Brazil' => 'Brasil',
        'Colombia' => 'Colômbia',
        'Canada' => 'Canadá',
        'Mexico' => 'México',
        'South Africa' => 'África do Sul',
        'United States of America' => 'Estados Unidos',
        'Equador' => 'Equador',
        'Cala' => 'Cala',
        'Chile' => 'Chile',
        'Peru' => 'Peru',
        'Uruguai' => 'Uruguai',
        '' => 'Selecione'
      ]
    ],
    'labels' => [
      'Create Account' => 'Crear cuenta',
      'Copy Billing' => 'Copiar desde facturación',
      'Set Primary' => 'Establecer como principal'
    ],
    'presetFilters' => [
      'customers' => 'Clientes',
      'partners' => 'Socios',
      'recentlyCreated' => 'Creado recientemente'
    ],
    'tabs' => [
      'Account' => 'Account',
      'Support' => 'Support'
    ]
  ],
  'Calendar' => [
    'modes' => [
      'month' => 'Mes',
      'week' => 'Semana',
      'day' => 'Día',
      'agendaWeek' => 'Semana',
      'agendaDay' => 'Día',
      'timeline' => 'Línea de tiempo'
    ],
    'labels' => [
      'Today' => 'Hoy',
      'Create' => 'Crear',
      'Shared' => 'Compartido',
      'Add User' => 'Agregar usuario',
      'current' => 'actual',
      'time' => 'hora',
      'User List' => 'Lista de usuarios',
      'Manage Users' => 'Administrar usuarios',
      'View Calendar' => 'Ver calendario',
      'Create Shared View' => 'Crear vista compartida'
    ]
  ],
  'Call' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estado',
      'dateStart' => 'Fecha de comienzo',
      'dateEnd' => 'Fecha de finalización',
      'direction' => 'Dirección',
      'duration' => 'Duración',
      'description' => 'Descripción',
      'users' => 'Usuarios',
      'contacts' => 'Contactos',
      'leads' => 'Posibles clientes',
      'reminders' => 'Recordatorios',
      'account' => 'Cuenta',
      'acceptanceStatus' => 'Estado de aceptación',
      'uid' => 'UID'
    ],
    'links' => [],
    'options' => [
      'status' => [
        'Planned' => 'Planeadas',
        'Held' => 'Celebradas',
        'Not Held' => 'Sin celebrar'
      ],
      'direction' => [
        'Outbound' => 'Saliente',
        'Inbound' => 'Entrante'
      ],
      'acceptanceStatus' => [
        'None' => 'Ninguno',
        'Accepted' => 'Aceptado',
        'Declined' => 'Rechazado',
        'Tentative' => 'Tentativa'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar como celebrada',
      'setNotHeld' => 'Marcar como No celebrada'
    ],
    'labels' => [
      'Create Call' => 'Crear llamada',
      'Set Held' => 'Marcar como celebrada',
      'Set Not Held' => 'Marcar como No celebrada',
      'Send Invitations' => 'Enviar Invitaciones'
    ],
    'presetFilters' => [
      'planned' => 'Planeadas',
      'held' => 'Celebradas',
      'todays' => 'De hoy'
    ]
  ],
  'Campaign' => [
    'fields' => [
      'name' => 'Nombre',
      'description' => 'Descripción',
      'status' => 'Estado',
      'type' => 'Tipo',
      'startDate' => 'Fecha de inicio',
      'endDate' => 'Fecha de finalización',
      'targetLists' => 'Lista de objetivos',
      'excludingTargetLists' => 'Lista de objetivos excluídos',
      'sentCount' => 'Enviado',
      'openedCount' => 'Abierto',
      'clickedCount' => 'Cliqueados',
      'optedOutCount' => 'Se dieron de baja',
      'bouncedCount' => 'Rebotados',
      'optedInCount' => 'Se dieron de alta',
      'hardBouncedCount' => 'Rebotados Duro',
      'softBouncedCount' => 'Rebotado Suave',
      'leadCreatedCount' => 'Posibles clientes creados',
      'revenue' => 'Ingresos',
      'revenueConverted' => 'ingresos (convertido)',
      'budget' => 'Presupuesto',
      'budgetConverted' => 'Presupuesto (convertido)',
      'budgetCurrency' => 'Moneda de presupuesto',
      'contactsTemplate' => 'Plantilla de contactos',
      'leadsTemplate' => 'Plantilla de posible cliente',
      'accountsTemplate' => 'Plantilla de cuentas',
      'usersTemplate' => 'Plantillas de usuarios',
      'mailMergeOnlyWithAddress' => 'Saltar registros sin dirección completa'
    ],
    'links' => [
      'targetLists' => 'Lista de objetivos',
      'excludingTargetLists' => 'Lista de objetivos excluídos',
      'accounts' => 'Cuentas',
      'contacts' => 'Contactos',
      'leads' => 'Posibles clientes',
      'opportunities' => 'Oportunidades',
      'campaignLogRecords' => 'Registros',
      'massEmails' => 'Correos masivos',
      'trackingUrls' => 'URLs de seguimiento',
      'contactsTemplate' => 'Plantilla de contactos',
      'leadsTemplate' => 'Plantilla de posible cliente',
      'accountsTemplate' => 'Plantilla de cuentas',
      'usersTemplate' => 'Plantillas de usuarios'
    ],
    'options' => [
      'type' => [
        'Email' => 'Correo electrónico',
        'Web' => 'Web',
        'Television' => 'Televisión',
        'Radio' => 'Radio',
        'Newsletter' => 'Boletín de noticias',
        'Mail' => 'Correo'
      ],
      'status' => [
        'Planning' => 'Planificación',
        'Active' => 'Activo',
        'Inactive' => 'Inactivo',
        'Complete' => 'Completada'
      ]
    ],
    'labels' => [
      'Create Campaign' => 'Crear campaña',
      'Target Lists' => 'Lista de objetivos',
      'Statistics' => 'Estadísticas',
      'hard' => 'duro',
      'soft' => 'suave',
      'Unsubscribe' => 'Desuscribirse',
      'Mass Emails' => 'Correos masivos',
      'Email Templates' => 'Plantillas de correos',
      'Unsubscribe again' => 'Cancelar otra vez la suscripción',
      'Subscribe again' => 'Suscribirse nuevamente',
      'Create Target List' => 'Crear lista de obejtivos',
      'Mail Merge' => 'Combinar correspondencia',
      'Generate Mail Merge PDF' => 'Generar PDF de combinación de correspondencia'
    ],
    'presetFilters' => [
      'active' => 'Activo'
    ],
    'messages' => [
      'unsubscribed' => 'Usted ha cancelado la suscripción a nuestra lista de correo.',
      'subscribedAgain' => 'Se ha vuelto a suscribir.'
    ],
    'tooltips' => [
      'targetLists' => 'Los objetivos que deben recibir los mensajes.',
      'excludingTargetLists' => 'Los objetivos que no deben recibir mensajes.'
    ]
  ],
  'CampaignLogRecord' => [
    'fields' => [
      'action' => 'Acción',
      'actionDate' => 'Fecha',
      'data' => 'Datos',
      'campaign' => 'Campaña',
      'parent' => 'Objetivo',
      'object' => 'Objeto',
      'application' => 'Aplicacion',
      'queueItem' => 'Elemento de la cola',
      'stringData' => 'Cadena de datos',
      'stringAdditionalData' => 'Cadena de datos adicional',
      'isTest' => 'Es una prueba'
    ],
    'links' => [
      'queueItem' => 'Elemento de la cola',
      'parent' => 'Padre',
      'object' => 'Objeto',
      'campaign' => 'Campaña'
    ],
    'options' => [
      'action' => [
        'Sent' => 'Enviado',
        'Opened' => 'Abierto',
        'Opted Out' => 'Se dieron de baja',
        'Bounced' => 'Rebotados',
        'Clicked' => 'Cliqueados',
        'Lead Created' => 'Posible cliente creado',
        'Opted In' => 'Se dieron de alta'
      ]
    ],
    'labels' => [
      'All' => 'Todos'
    ],
    'presetFilters' => [
      'sent' => 'Enviado',
      'opened' => 'Abierto',
      'optedOut' => 'Se dieron de baja',
      'optedIn' => 'Se dieron de alta',
      'bounced' => 'Rebotados',
      'clicked' => 'Cliqueados',
      'leadCreated' => 'Posible cliente creado'
    ]
  ],
  'CampaignTrackingUrl' => [
    'fields' => [
      'url' => 'URL',
      'action' => 'Acción',
      'urlToUse' => 'Código para insertar en lugar de la URL',
      'message' => 'Mensaje',
      'campaign' => 'Campaña'
    ],
    'links' => [
      'campaign' => 'Campaña'
    ],
    'labels' => [
      'Create CampaignTrackingUrl' => 'Crear URL de seguimiento'
    ],
    'options' => [
      'action' => [
        'Redirect' => 'Redirigir',
        'Show Message' => 'Mostrar mensaje'
      ]
    ],
    'tooltips' => [
      'url' => 'El destinatario será redirigido a esta ubicación después de seguir el enlace.',
      'message' => 'El mensaje se mostrará al destinatario después de que sigan el enlace. Se admite Markdown.'
    ]
  ],
  'Case' => [
    'fields' => [
      'name' => 'Nombre',
      'number' => 'Número',
      'status' => 'Estado',
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'contacts' => 'Contactos',
      'priority' => 'Prioridad',
      'type' => 'Tipo',
      'description' => 'Descripción',
      'inboundEmail' => 'Cuenta de correo electrónico grupal',
      'lead' => 'Posible cliente',
      'attachments' => 'Adjuntos',
      'originalEmail' => 'Original Email',
      'isInternal' => 'Hidden from Portal',
      'instructions' => 'Orientations',
      'cApiUser' => 'Username',
      'cApiPassword' => 'Password',
      'cCustomizeUrl' => 'URL Personalizada',
      'cRegistrationAddress' => 'Endereço',
      'cUrlType' => 'Tipo de customização:',
      'cStandardUrl' => 'URL Personalizada Padrão'
    ],
    'links' => [
      'inboundEmail' => 'Cuenta de correo electrónico grupal',
      'account' => 'Cuenta',
      'contact' => 'Contratos (principal)',
      'Contacts' => 'Contactos',
      'meetings' => 'Reuniones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'emails' => 'Correos',
      'articles' => 'Artículos de la base de conocimiento',
      'lead' => 'Posible cliente',
      'attachments' => 'Adjuntos'
    ],
    'options' => [
      'status' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'Pending' => 'Pendiente',
        'Closed' => 'Cerrados',
        'Rejected' => 'Rechazado',
        'Duplicate' => 'Duplicar'
      ],
      'priority' => [
        'Low' => 'Baja',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ],
      'type' => [
        'Question' => 'Pregunta',
        'Incident' => 'Incidente',
        'Problem' => 'Problema'
      ],
      'cUrlType' => [
        '' => '',
        'standard' => 'Personalização básica',
        'domain' => 'Domínio próprio'
      ]
    ],
    'labels' => [
      'Create Case' => 'Crear ticket',
      'Close' => 'Cerrar',
      'Reject' => 'Rechazar',
      'Closed' => 'Cerrados',
      'Rejected' => 'Rechazado'
    ],
    'presetFilters' => [
      'open' => 'Abiertos',
      'closed' => 'Cerrados'
    ],
    'tooltips' => [
      'cStandardUrl' => 'Customize the end of the URL with your company name. Ex: "https://partners.enube.me/portal/customizehere"'
    ]
  ],
  'Contact' => [
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'title' => 'Titulo de cuenta',
      'account' => 'Cuenta',
      'accounts' => 'Cuentas',
      'phoneNumber' => 'Teléfono',
      'accountType' => 'Tipo de Cuenta',
      'doNotCall' => 'No llamar',
      'address' => 'Dirección',
      'opportunityRole' => 'Rol de Oportunidad',
      'accountRole' => 'Título',
      'description' => 'Descripción',
      'campaign' => 'Campaña',
      'targetLists' => 'Lista de objetivos',
      'targetList' => 'Lista de objetivos',
      'portalUser' => 'Usuario del portal',
      'hasPortalUser' => 'Tiene usuario del portal',
      'originalLead' => 'Posible cliente de origen',
      'acceptanceStatus' => 'Estado de Aceptación',
      'accountIsInactive' => 'Cuenta inactiva',
      'acceptanceStatusMeetings' => 'Estado de aceptación (Reuniones)',
      'acceptanceStatusCalls' => 'Estado de aceptación (Llamadas)',
      'originalEmail' => 'Original Email',
      'customerID' => 'Customer Tenant ID',
      'cspUsage' => 'CspUsage',
      'portaluserisactive' => 'Active User',
      'subscriptions' => 'Subscriptions',
      'resourceCategories' => 'ResourceCategories',
      'resourceGroups' => 'ResourceGroups',
      'resourceSubCategories' => 'ResourceSubCategories',
      'recommendations' => 'Recommendations',
      'monitorings' => 'Monitorings',
      'analytics' => 'Analytics',
      'tags' => 'Tags',
      'subscriptionR' => 'Subscription',
      'resourceGroupsR' => 'ResourceGroups1',
      'country' => 'Country',
      'type' => 'Type',
      'partnerID' => 'Tier2 MPN ID',
      'resourceCategories1' => 'ResourceCategories1',
      'tags1' => 'Tags1',
      'isChecked' => 'is Checked?',
      'cRegistrationsContact' => 'Registration: Contact',
      'cAccountType' => 'AccountType'
    ],
    'links' => [
      'opportunities' => 'Oportunidades',
      'cases' => 'Tickets',
      'targetLists' => 'Lista de objetivos',
      'campaignLogRecords' => 'Registro de Campaña',
      'campaign' => 'Campaña',
      'account' => 'Cuentas (principal)',
      'accounts' => 'Cuentas',
      'casesPrimary' => 'Tickets (principal)',
      'tasksPrimary' => 'Tareas (ampliadas)',
      'opportunitiesPrimary' => 'Oportunidades (primaria)',
      'portalUser' => 'Usuario del portal',
      'originalLead' => 'Posible cliente de origen',
      'documents' => 'Documentos',
      'quotesBilling' => 'Presupuestos (facturación)',
      'quotesShipping' => 'Presupuestos (Envío)',
      'salesOrdersBilling' => 'Órdenes de venta (facturación)',
      'salesOrdersShipping' => 'Órdenes de venta (envío)',
      'invoicesBilling' => 'Facturas (facturación)',
      'invoicesShipping' => 'Facturas (envío)',
      'purchaseOrdersBilling' => 'Purchase Orders (Billing)',
      'purchaseOrdersShipping' => 'Purchase Orders (Shipping)',
      'deliveryOrdersShipping' => 'Delivery Orders (Shipping)',
      'returnOrdersBilling' => 'Return Orders (Billing)',
      'returnOrdersShipping' => 'Return Orders (Shipping)',
      'receiptOrdersShipping' => 'Receipt Orders (Shipping)',
      'cspUsage' => 'CspUsage',
      'subscriptions' => 'Subscriptions',
      'resourceCategories' => 'ResourceCategories',
      'resourceGroups' => 'ResourceGroups',
      'resourceSubCategories' => 'ResourceSubCategories',
      'recommendations' => 'Recommendations',
      'monitorings' => 'Monitorings',
      'analytics' => 'Analytics',
      'tags' => 'Tags',
      'subscriptionR' => 'Subscription',
      'resourceGroupsR' => 'ResourceGroups1',
      'resourceCategories1' => 'ResourceCategories1',
      'tags1' => 'Tags1',
      'cRegistrationsContact' => 'Cadastro: Contato'
    ],
    'labels' => [
      'Create Contact' => 'Crear contacto'
    ],
    'options' => [
      'opportunityRole' => [
        '' => '',
        'Decision Maker' => 'Tomador de decisiones',
        'Evaluator' => 'Evaluador',
        'Influencer' => 'Factor de influencia'
      ],
      'country' => [
        'Select' => 'Selecione',
        'Argentina' => 'Argentina',
        'Brazil' => 'Brasil',
        'Colombia' => 'Colômbia',
        'Canada' => 'Canadá',
        'Mexico' => 'México',
        'South Africa' => 'África do Sul',
        'United States of America' => 'Estados Unidos',
        'Equador' => 'Equador',
        'Cala' => 'Cala',
        'Chile' => 'Chile',
        'Peru' => 'Peru',
        'Uruguai' => 'Uruguai'
      ],
      'type' => [
        'Select' => 'Select',
        'Reseller' => 'Reseller',
        'Customer' => 'Customer',
        'ISV' => 'ISV',
        'Partner' => 'Partner'
      ]
    ],
    'presetFilters' => [
      'portalUsers' => 'Usuarios del portal',
      'notPortalUsers' => 'No son usuarios del portal',
      'accountActive' => 'Activo'
    ],
    'tooltips' => [
      'customerID' => 'Tenant ID azure'
    ]
  ],
  'Document' => [
    'labels' => [
      'Create Document' => 'Crear documento',
      'Details' => 'Detalles'
    ],
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'file' => 'Archivo',
      'type' => 'Tipo',
      'publishDate' => 'Fecha de publicación',
      'expirationDate' => 'Fecha de caducidad',
      'description' => 'Descripción',
      'accounts' => 'Cuentas',
      'folder' => 'Carpeta'
    ],
    'links' => [
      'accounts' => 'Cuentas',
      'opportunities' => 'Oportunidades',
      'folder' => 'Carpeta',
      'leads' => 'Posibles clientes',
      'contacts' => 'Contactos'
    ],
    'options' => [
      'status' => [
        'Active' => 'Activo',
        'Draft' => 'Borrador',
        'Expired' => 'Expirado',
        'Canceled' => 'Cancelado'
      ],
      'type' => [
        '' => 'Ninguno',
        'Contract' => 'Contrato',
        'NDA' => 'NDA',
        'EULA' => 'EULA',
        'License Agreement' => 'Contrato de licencia'
      ]
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'draft' => 'Borrador'
    ]
  ],
  'DocumentFolder' => [
    'labels' => [
      'Create DocumentFolder' => 'Crear carpeta de documentos',
      'Manage Categories' => 'Administrar carpetas',
      'Documents' => 'Documentos'
    ],
    'links' => [
      'documents' => 'Documentos'
    ]
  ],
  'EmailQueueItem' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'target' => 'Objetivo',
      'sentAt' => 'Fecha de envío',
      'attemptCount' => 'Intentos',
      'emailAddress' => 'Correo electrónico',
      'massEmail' => 'Correo masivo',
      'isTest' => 'Es una prueba'
    ],
    'links' => [
      'target' => 'Objetivo',
      'massEmail' => 'Correo masivo'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendiente',
        'Sent' => 'Enviado',
        'Failed' => 'Falló',
        'Sending' => 'Enviando'
      ]
    ],
    'presetFilters' => [
      'pending' => 'Pendiente',
      'sent' => 'Enviado',
      'failed' => 'Falló'
    ]
  ],
  'KnowledgeBaseArticle' => [
    'labels' => [
      'Create KnowledgeBaseArticle' => 'Crear artículo',
      'Any' => 'Cualquiera',
      'Send in Email' => 'Enviar por correo',
      'Move Up' => 'Mover arriba',
      'Move Down' => 'Mover abajo',
      'Move to Top' => 'Mover al inicio',
      'Move to Bottom' => 'Mover al final'
    ],
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'type' => 'Tipo',
      'attachments' => 'Adjuntos',
      'publishDate' => 'Fecha de publicación',
      'expirationDate' => 'Fecha de caducidad',
      'description' => 'Descripción',
      'body' => 'Cuerpo',
      'categories' => 'Categorías',
      'language' => 'Idioma',
      'portals' => 'Portales'
    ],
    'links' => [
      'cases' => 'Tickets',
      'opportunities' => 'Oportunidades',
      'categories' => 'Categorías',
      'portals' => 'Portales'
    ],
    'options' => [
      'status' => [
        'In Review' => 'En revisión',
        'Draft' => 'Borrador',
        'Archived' => 'Archivado',
        'Published' => 'Publicado'
      ],
      'type' => [
        'Article' => 'Artículo'
      ]
    ],
    'tooltips' => [
      'portals' => 'El artículo estará disponible solo en los portales especificados.'
    ],
    'presetFilters' => [
      'published' => 'Publicado'
    ]
  ],
  'KnowledgeBaseCategory' => [
    'labels' => [
      'Create KnowledgeBaseCategory' => 'Crear categoría',
      'Manage Categories' => 'Administrar categorías',
      'Articles' => 'Artículos'
    ],
    'links' => [
      'articles' => 'Artículos'
    ]
  ],
  'Lead' => [
    'labels' => [
      'Converted To' => 'Convertido a',
      'Create Lead' => 'Crear posible cliente',
      'Convert' => 'Convertir',
      'convert' => 'convertir'
    ],
    'fields' => [
      'name' => 'Nombre',
      'emailAddress' => 'Correo electrónico',
      'title' => 'Título',
      'website' => 'Sitio web',
      'phoneNumber' => 'Teléfono',
      'accountName' => 'Nombre de la cuenta',
      'doNotCall' => 'No llamar',
      'address' => 'Dirección',
      'status' => 'Estado',
      'source' => 'Toma de contacto',
      'opportunityAmount' => 'Costo de oportunidad',
      'opportunityAmountConverted' => 'Costo de oportunidad (convertido)',
      'description' => 'Descripción',
      'createdAccount' => 'Cuenta',
      'createdContact' => 'Contacto',
      'createdOpportunity' => 'Oportunidad',
      'convertedAt' => 'Convertido en',
      'campaign' => 'Campaña',
      'targetLists' => 'Listas de objetivos',
      'targetList' => 'Lista de objetivos',
      'industry' => 'Industria',
      'acceptanceStatus' => 'Estado de aceptación',
      'opportunityAmountCurrency' => 'Moneda del costo de oportunidad',
      'acceptanceStatusMeetings' => 'Estado de aceptación (Reuniones)',
      'acceptanceStatusCalls' => 'Estado de aceptación (Llamadas)',
      'originalEmail' => 'Original Email'
    ],
    'links' => [
      'targetLists' => 'Lista de objetivos',
      'campaignLogRecords' => 'Registros de la campaña',
      'campaign' => 'Campaña',
      'createdAccount' => 'Cuenta',
      'createdContact' => 'Contacto',
      'createdOpportunity' => 'Oportunidad',
      'cases' => 'Tickets',
      'documents' => 'Documentos'
    ],
    'options' => [
      'status' => [
        'New' => 'Nuevo',
        'Assigned' => 'Asignado',
        'In Process' => 'En proceso',
        'Converted' => 'Convertidos',
        'Recycled' => 'Reciclado',
        'Dead' => 'Muerto'
      ],
      'source' => [
        'Call' => 'Llamada',
        'Email' => 'Correo electrónico',
        'Existing Customer' => 'Cliente Existente',
        'Partner' => 'Socio',
        'Public Relations' => 'Relaciones Públicas',
        'Web Site' => 'Sitio web',
        'Campaign' => 'Campaña',
        'Other' => 'Otro'
      ]
    ],
    'presetFilters' => [
      'active' => 'Activo',
      'actual' => 'Actuales',
      'converted' => 'Convertidos'
    ]
  ],
  'MassEmail' => [
    'fields' => [
      'name' => 'Nombre',
      'status' => 'Estado',
      'storeSentEmails' => 'Almacenar correos enviados',
      'startAt' => 'Fecha de inicio',
      'fromAddress' => 'De (email)',
      'fromName' => 'De (nombre):',
      'replyToAddress' => 'Responder a (dirección)',
      'replyToName' => 'Responder a (nombre)',
      'campaign' => 'Campaña',
      'emailTemplate' => 'Plantilla de correo',
      'inboundEmail' => 'Cuenta de correo',
      'targetLists' => 'Lista de objetivos',
      'excludingTargetLists' => 'Lista de objetivos excluídos',
      'optOutEntirely' => 'Dar de baja completamente',
      'smtpAccount' => 'Cuenta SMTP'
    ],
    'links' => [
      'targetLists' => 'Lista de objetivos',
      'excludingTargetLists' => 'Lista de objetivos excluídos',
      'queueItems' => 'Elementos en cola',
      'campaign' => 'Campaña',
      'emailTemplate' => 'Plantilla de correo',
      'inboundEmail' => 'Cuenta de correo'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Pending' => 'Pendiente',
        'In Process' => 'En proceso',
        'Complete' => 'Completada',
        'Canceled' => 'Cancelado',
        'Failed' => 'Falló'
      ]
    ],
    'labels' => [
      'Create MassEmail' => 'Crear correo masivo',
      'Send Test' => 'Enviar prueba',
      'System SMTP' => 'Sistema SMTP',
      'system' => 'sistema',
      'group' => 'grupo'
    ],
    'messages' => [
      'selectAtLeastOneTarget' => 'Seleccione al menos un objetivo.',
      'testSent' => 'Se supone que el/los email/s de preuebas fueron enviados'
    ],
    'tooltips' => [
      'optOutEntirely' => 'Las direcciones de correo de los destinatarios que se desuscriban serán marcadas como dadas de baja y no van a recibir ningún correo masivo.',
      'targetLists' => 'Los objetivos que deben recibir los mensajes.',
      'excludingTargetLists' => 'Los objetivos que no deben recibir mensajes.',
      'storeSentEmails' => 'Los correos se almacenarán en el CRM.'
    ],
    'presetFilters' => [
      'actual' => 'Actuales',
      'complete' => 'Completo'
    ]
  ],
  'Meeting' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estado',
      'dateStart' => 'Fecha de comienzo',
      'dateEnd' => 'Fecha de finalización',
      'duration' => 'Duración',
      'description' => 'Descripción',
      'users' => 'Usuarios',
      'contacts' => 'Contactos',
      'leads' => 'Posibles clientes',
      'reminders' => 'Recordatorios',
      'account' => 'Cuenta',
      'acceptanceStatus' => 'Estado de aceptación',
      'dateStartDate' => 'Fecha de inicio (todo el día)',
      'dateEndDate' => 'Fecha de finalización (todo el día)',
      'isAllDay' => 'Es todo el día',
      'sourceEmail' => 'Source Email',
      'uid' => 'UID',
      'joinUrl' => 'Join URL',
      'Acceptance' => 'Aceptación'
    ],
    'links' => [],
    'options' => [
      'status' => [
        'Planned' => 'Planeadas',
        'Held' => 'Celebradas',
        'Not Held' => 'Sin celebrar'
      ],
      'acceptanceStatus' => [
        'None' => 'Ninguno',
        'Accepted' => 'Aceptado',
        'Declined' => 'Rechazado',
        'Tentative' => 'Tentativa'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar como celebrada',
      'setNotHeld' => 'Marcar como No celebrada'
    ],
    'labels' => [
      'Create Meeting' => 'Crear reunión',
      'Set Held' => 'Marcar como celebrada',
      'Set Not Held' => 'Marcar como No celebrada',
      'Send Invitations' => 'Enviar Invitaciones',
      'Send Cancellation' => 'Send Cancellation',
      'on time' => 'a tiempo',
      'before' => 'antes',
      'All-Day' => 'Todo el día',
      'Acceptance' => 'Acceptance'
    ],
    'presetFilters' => [
      'planned' => 'Planeadas',
      'held' => 'Celebradas',
      'todays' => 'De hoy'
    ],
    'messages' => [
      'sendInvitationsToSelectedAttendees' => 'Invitation emails will be sent to the selected attendees.',
      'sendCancellationsToSelectedAttendees' => 'Cancellation emails will be sent to the selected attendees.',
      'selectAcceptanceStatus' => 'Establece tu estado de aceptación.',
      'nothingHasBeenSent' => 'No se ha enviado nada'
    ]
  ],
  'Opportunity' => [
    'fields' => [
      'name' => 'Nombre',
      'account' => 'Cuenta',
      'stage' => 'Etapa de ventas',
      'amount' => 'Ingresos esperados',
      'probability' => 'Probabilidad de ganar (%)',
      'leadSource' => 'Toma de contacto del posible cliente',
      'doNotCall' => 'No llamar',
      'closeDate' => 'Fecha esperada de cierre',
      'contacts' => 'Contactos',
      'contact' => 'Contacto (principal)',
      'description' => 'Descripción',
      'amountConverted' => 'Cantidad (convertido)',
      'amountWeightedConverted' => 'Cantidad Ponderada',
      'campaign' => 'Campaña',
      'originalLead' => 'Posible cliente de origen',
      'amountCurrency' => 'Monto de la Moneda',
      'contactRole' => 'Rol de contacto',
      'lastStage' => 'Última etapa',
      'itemList' => 'Lista de articulos',
      'priceBook' => 'Price Book'
    ],
    'links' => [
      'contacts' => 'Contactos',
      'contact' => 'Contacto (principal)',
      'documents' => 'Documentos',
      'campaign' => 'Campaña',
      'originalLead' => 'Posible cliente de origen',
      'quotes' => 'Presupuestos',
      'salesOrders' => 'Órdenes de venta',
      'invoices' => 'Facturas',
      'items' => 'Artículos',
      'priceBook' => 'Price Book'
    ],
    'options' => [
      'stage' => [
        'Prospecting' => 'Prospección',
        'Qualification' => 'Calificación',
        'Proposal' => 'Propuesta',
        'Negotiation' => 'Negociación',
        'Needs Analysis' => 'Análisis de necesidades',
        'Value Proposition' => 'Propuesta de valor',
        'Id. Decision Makers' => 'Identificar tomador de decisiones',
        'Perception Analysis' => 'Análisis de percepcion',
        'Proposal/Price Quote' => 'Propuesta/Presupuesto',
        'Negotiation/Review' => 'Negociación/Revisión',
        'Closed Won' => 'Cerrado ganado',
        'Closed Lost' => 'Cerrado perdido'
      ]
    ],
    'labels' => [
      'Create Opportunity' => 'Crear oportunidad',
      'Items' => 'Artículos',
      'Select Product' => 'Seleccionar producto',
      'Add Item' => 'Añadir artículo',
      'Add Products' => 'Add Products'
    ],
    'presetFilters' => [
      'open' => 'Abiertos',
      'won' => 'Ganados',
      'lost' => 'Perdido'
    ],
    'panels' => [
      'items' => 'Items'
    ]
  ],
  'TargetList' => [
    'fields' => [
      'name' => 'Nombre',
      'description' => 'Descripción',
      'entryCount' => 'Contador de entrada',
      'optedOutCount' => 'Contador de bajas',
      'campaigns' => 'Campañas',
      'endDate' => 'Fecha de finalización',
      'targetLists' => 'Lista de objetivos',
      'includingActionList' => 'Incluyendo',
      'excludingActionList' => 'Excluyendo',
      'targetStatus' => 'Estado del objetivo',
      'isOptedOut' => 'Se dieró de baja',
      'sourceCampaign' => 'Source Campaign',
      'syncWithReports' => 'Informes',
      'syncWithReportsEnabled' => 'Habilitado',
      'syncWithReportsUnlink' => 'Desvincular'
    ],
    'links' => [
      'accounts' => 'Cuentas',
      'contacts' => 'Contactos',
      'leads' => 'Posibles clientes',
      'campaigns' => 'Campañas',
      'massEmails' => 'Correos masivos',
      'syncWithReports' => 'Sincronizar con informes'
    ],
    'options' => [
      'type' => [
        'Email' => 'Correo electrónico',
        'Web' => 'Web',
        'Television' => 'Televisión',
        'Radio' => 'Radio',
        'Newsletter' => 'Boletín de noticias'
      ],
      'targetStatus' => [
        'Opted Out' => 'Se dieron de baja',
        'Listed' => 'Listados'
      ]
    ],
    'labels' => [
      'Create TargetList' => 'Crear una lista de objetivos',
      'Opted Out' => 'Se dieron de baja',
      'Cancel Opt-Out' => 'Cancelar darse de baja',
      'Opt-Out' => 'Darse de baja',
      'Sync with Reports' => 'Sincronizar con informes'
    ],
    'tooltips' => [
      'syncWithReportsEnabled' => 'Enable auto-sync with a list report.',
      'syncWithReportsUnlink' => 'Las entradas que no están contenidas en los resultados del informe se desvincularán de la Lista de objetivos.',
      'syncWithReports' => 'La lista de objetivos se sincronizará con los resultados de los informes seleccionados.'
    ]
  ],
  'Task' => [
    'fields' => [
      'name' => 'Nombre',
      'parent' => 'Padre',
      'status' => 'Estado',
      'dateStart' => 'Fecha de comienzo',
      'dateEnd' => 'Fecha de vencimiento',
      'dateStartDate' => 'Fecha de Inicio (todo el día)',
      'dateEndDate' => 'Fecha de finalización (todo el día)',
      'priority' => 'Prioridad',
      'description' => 'Descripción',
      'isOverdue' => 'Atrasado',
      'account' => 'Cuenta',
      'dateCompleted' => 'Fecha de completado',
      'attachments' => 'Adjuntos',
      'reminders' => 'Recordatorios',
      'contact' => 'Contacto',
      'originalEmail' => 'Original Email'
    ],
    'links' => [
      'attachments' => 'Adjuntos',
      'account' => 'Cuenta',
      'contact' => 'Contacto',
      'email' => 'Email'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Sin empezar',
        'Started' => 'Comenzado',
        'Completed' => 'Completado',
        'Canceled' => 'Cancelado',
        'Deferred' => 'Diferido'
      ],
      'priority' => [
        'Low' => 'Baja',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ]
    ],
    'labels' => [
      'Create Task' => 'Crear tarea',
      'Complete' => 'Completada',
      'overdue' => 'atrasado'
    ],
    'presetFilters' => [
      'actual' => 'Actuales',
      'completed' => 'Completado',
      'deferred' => 'Diferido',
      'todays' => 'De hoy',
      'overdue' => 'Atrazadas'
    ],
    'nameOptions' => [
      'replyToEmail' => 'Reply to email'
    ]
  ],
  'BpmnFlowNode' => [
    'labels' => [
      'Reset' => 'Restablecer'
    ],
    'fields' => [
      'status' => 'Estado',
      'processedAt' => 'Procesado en',
      'elementType' => 'Tipo de elemento',
      'element' => 'Elemento'
    ],
    'options' => [
      'status' => [
        'Created' => 'Creado',
        'Pending' => 'Pendiente',
        'In Process' => 'En proceso',
        'Standby' => 'En espera',
        'Processed' => 'Procesado',
        'Rejected' => 'Rechazado',
        'Failed' => 'Ha fallado',
        'Interrupted' => 'Interrumpido'
      ]
    ]
  ],
  'BpmnFlowchart' => [
    'labels' => [
      'Create BpmnFlowchart' => 'Crear diagrama de flujo',
      'Hand tool' => 'Herramienta de mano',
      'Create Event tool' => 'Herramienta de crear evento',
      'Create Gateway tool' => 'Herramienta de crear evento',
      'Create Activity tool' => 'Herramienta de crear actividad',
      'Connect tool' => 'Herramienta de conexión',
      'Erase tool' => 'Herramienta de borrado',
      'Full Screen' => 'Pantalla completa',
      'Processes' => 'Procesos',
      'data' => 'Datos',
      'Zoom In' => 'Acercarse',
      'Zoom Out' => 'Alejarse',
      'Error' => 'Error',
      'Events' => 'Events',
      'Activities' => 'Activities',
      'Gateways' => 'Gateways',
      'Move to Center' => 'Move to Center',
      'Undo' => 'Undo',
      'Redo' => 'Redo'
    ],
    'fields' => [
      'isActive' => 'Está activo',
      'targetType' => 'Tipo de entidad objetivo',
      'data' => 'Datos',
      'hasNoneStartEvent' => 'Tiene evento de inicio de tipo Ninguno',
      'category' => 'Category'
    ],
    'links' => [
      'processes' => 'Procesos',
      'category' => 'Category'
    ],
    'elements' => [
      'eventStartConditional' => 'Evento de inicio condicional',
      'eventStartTimer' => 'Evento de inicio de temporizador',
      'eventStartError' => 'Evento de inicio de error',
      'eventStartEscalation' => 'Evento de inicio de remisión a instancia superior',
      'eventStartSignal' => 'Evento de inicio de señal',
      'eventStart' => 'Evento de inicio',
      'eventStartCompensation' => 'Compensation Start Event',
      'eventStartConditionalEventSubProcess' => 'Evento de inicio condicional de subproceso',
      'eventStartTimerEventSubProcess' => 'Evento de inicio del temporizador de subproceso',
      'eventStartSignalEventSubProcess' => 'Evento de inicio de señal de subproceso',
      'eventIntermediateTimerCatch' => 'Evento intermedio del temporizador (captura)',
      'eventIntermediateConditionalCatch' => 'Evento intermedio condicional (captura)',
      'eventIntermediateEscalationThrow' => 'Evento intermedio de remisión a instancia superior (lanzamiento)',
      'eventIntermediateSignalThrow' => 'Evento intermedio de señal (lanzamiento)',
      'eventIntermediateCompensationThrow' => 'Compensation Intermediate Event (Throwing)',
      'eventIntermediateSignalCatch' => 'Evento intermedio de señal (captura)',
      'eventIntermediateMessageCatch' => 'Evento intermedio de mensaje (captura)',
      'eventEnd' => 'Evento de finalización',
      'eventEndTerminate' => 'Evento final de finalización',
      'eventEndError' => 'Evento final de error',
      'eventEndEscalation' => 'Evento final de remisión a instancia superior',
      'eventEndSignal' => 'Evento final de señal',
      'eventEndCompensation' => 'Compensation End Event',
      'eventIntermediateErrorBoundary' => 'Evento intermedio de error (límite)',
      'eventIntermediateTimerBoundary' => 'Evento intermedio del temporizador (límite)',
      'eventIntermediateConditionalBoundary' => 'Evento intermedio condicional (límite)',
      'eventIntermediateEscalationBoundary' => 'Evento intermedio de remisión a instancia superior (límite)',
      'eventIntermediateSignalBoundary' => 'Evento intermedio de señal (límite)',
      'eventIntermediateMessageBoundary' => 'Evento intermedio de mensaje (límite)',
      'eventIntermediateCompensationBoundary' => 'Compensation Intermediate Event (Boundary)',
      'gatewayExclusive' => 'Pasarela exclusiva',
      'gatewayInclusive' => 'Pasarela inclusiva',
      'gatewayParallel' => 'Pasarela paralela',
      'gatewayEventBased' => 'Pasarela basada en eventos',
      'taskSendMessage' => 'Tarea de enviar mensaje',
      'taskScript' => 'Tarea de script',
      'taskBusinessRule' => 'Tarea de regla de negocios',
      'taskUser' => 'Tarea de usuario',
      'task' => 'Tarea',
      'callActivity' => 'Actividad de llamada',
      'subProcess' => 'Subproceso',
      'eventSubProcess' => 'Subproceso de evento',
      'flow' => 'Flujo de secuencia'
    ],
    'presetFilters' => [
      'isManuallyStartable' => 'Iniciable manualmente',
      'activeHasNoneStartEvent' => 'Activo sin evento de inicio',
      'active' => 'Activo'
    ]
  ],
  'BpmnFlowchartCategory' => [
    'labels' => [
      'Create BpmnFlowchartCategory' => 'Create Category'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'flowcharts' => 'Flowcharts'
    ]
  ],
  'BpmnFlowchartElement' => [
    'fields' => [
      'text' => 'Texto',
      'triggerType' => 'Tipo de desencadenador',
      'timer' => 'Parámetros de temporizador',
      'defaultFlowId' => 'Flujo predeterminado',
      'from' => 'De',
      'to' => 'Para',
      'replyTo' => 'Responder a',
      'cc' => 'CC',
      'fromEmailAddress' => 'Dirección de correo electrónico del remitente',
      'toEmailAddress' => 'Dirección de correo electrónico del destinatario',
      'replyToEmailAddress' => 'Dirección de correo electrónico de respuesta',
      'ccEmailAddress' => 'CC Email Address',
      'toSpecifiedTeams' => 'A equipos',
      'toSpecifiedUsers' => 'A usuarios',
      'toSpecifiedContacts' => 'Contactos "Para"',
      'attachmentsVariable' => 'Attachments Variable',
      'emailTemplate' => 'Plantilla de correo electrónico',
      'doNotStore' => 'No almacenar correo electrónico enviado',
      'actions' => 'Acciones',
      'formula' => 'Fórmula (script)',
      'actionType' => 'Tipo de acción',
      'targetUser' => 'Usuario objetivo',
      'assignmentType' => 'Asignación',
      'targetTeam' => 'Equipo objetivo',
      'targetUserPosition' => 'Posición de usuario objetivo',
      'startDirection' => 'Dirección de inicio',
      'targetReport' => 'Informe de destino',
      'scheduling' => 'Programación',
      'schedulingApplyTimezone' => 'Apply timezone',
      'messageType' => 'Tipo de mensaje',
      'canBeFailed' => 'Puede fallar',
      'target' => 'Objetivo',
      'callableType' => 'Tipo llamable',
      'errorCode' => 'Código de error',
      'escalationCode' => 'Código de remisión a instancia superior',
      'cancelActivity' => 'Está interrumpiendo',
      'isInterrupting' => 'Está interrumpiendo',
      'targetType' => 'Tipo de entidad objetivo',
      'flowchartVisualization' => 'Diagrama de flujo',
      'flowchart' => 'Diagrama de flujo',
      'signal' => 'Señal',
      'isolateVariables' => 'Isolate Variables',
      'returnVariableList' => 'Variables de retorno',
      'returnCollectionVariable' => 'Return Collection Variable',
      'repliedTo' => 'Responder a',
      'relatedTo' => 'Relacionado con',
      'instructions' => 'Instrucciones',
      'conditionsFormula' => 'Fórmula de condiciones',
      'optOutLink' => 'Enlace de exclusión',
      'isMultiInstance' => 'Multi-Instance',
      'isSequential' => 'Sequential',
      'loopCollectionExpression' => 'Collection Expression',
      'targetIdExpression' => 'Target ID Expression',
      'activityId' => 'Activity ID'
    ],
    'labels' => [
      'Conditions' => 'Condiciones',
      'Actions' => 'Acciones',
      'Field' => 'Campo',
      'Flows Conditions' => 'Condiciones de flujo'
    ],
    'tooltips' => [
      'attachmentsVariable' => 'A Formula variable name that contains an attachment ID or an array of attachment IDs. You can generate needed attachments in a Script Task earlier in the flow.',
      'compensateActivityId' => 'An ID of an activity to compensate. If omitted, all completed compensable activities will be compensated.',
      'targetIdExpression' => 'The expression defining an ID of the target record.',
      'returnCollectionVariable' => 'Specify a variable name for data that will be returned from the multi-instance sub-process. The variable will contain an array of objects. Each object will contain return-variables of each sub-process instance.',
      'loopCollectionExpression' => 'The expression defining a list of values. Each value will instantiate a separate sub-process. Within a sub-process, the value will be available in the variable `$inputItem`.',
      'taskSendMessageFromEmailAddress' => 'Available placeholders:

* `{$$variable}`',
      'taskSendMessageEmailAddress' => 'Marcadores de posición disponibles:

* `{$$variable}`',
      'targetReport' => 'Los registros del informe de la lista se pasarán al nuevo proceso.',
      'target' => 'Seleccione qué registro se utilizará como objetivo.',
      'userTaskName' => 'Un nombre del registro de tareas de usuario que se creará.

Marcadores de posición disponibles:
* `{$attribute}`
* `{$$variable}`',
      'userTaskInstructions' => 'Instrucciones para un usuario. Se admite reducción.

Marcadores de posición disponibles:
* `{$attribute}`
* `{$$variable}`',
      'returnVariableList' => 'Especifique las variables de fórmula que se copiarán del subproceso al proceso principal una vez que el subproceso finalice correctamente.',
      'scheduling' => 'Notación de Crontab. Define la frecuencia. Zona horaria UTC.

`*/5 * * * *` - cada 5 minutos

`0 */2 * * *` - cada 2 horas

`30 1 * * *` - a las 01:30 una vez al día

`0 0 1 * *` - el primer día de el mes',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.',
      'isolateVariables' => 'Do not expose Formula variables defined within the task.',
      'taskReturnVariableList' => 'Specify Formula variables that will be copied from the task and be available further in the flow after the task is processed.'
    ],
    'options' => [
      'emailAddress' => [
        'system' => 'Sistema',
        'currentUser' => 'Usuario actual',
        'specifiedEmailAddress' => 'Dirección de correo electrónico especificada',
        'assignedUser' => 'Usuario asignado',
        'followers' => 'Seguidores',
        'specifiedContacts' => 'Contactos especificados',
        'specifiedUsers' => 'Usuarios especificados',
        'specifiedTeams' => 'Equipos especificados',
        'followersExcludingAssignedUser' => 'Seguidores excluyendo el usuario asignado',
        'processAssignedUser' => 'Usuario asignado al proceso',
        'targetEntity' => 'Registro objetivo',
        '' => 'Ninguna'
      ],
      'triggerType' => [
        'afterRecordCreated' => 'Después de crear el registro',
        'afterRecordSaved' => 'Después de guardar el registro',
        'afterRecordUpdated' => 'Después de actualizar el registro',
        'sequential' => 'Secuencial'
      ],
      'timerShiftOperator' => [
        'plus' => 'más',
        'minus' => 'menos'
      ],
      'timerShiftUnits' => [
        'minutes' => 'minutos',
        'hours' => 'horas',
        'days' => 'días',
        'months' => 'meses',
        'seconds' => 'segundos'
      ],
      'timerBase' => [
        'moment' => 'Momento en el que se desencadena el evento',
        'formula' => 'Calculado por fórmula'
      ],
      'actionType' => [
        'Approve' => 'Aprobar',
        'Review' => 'Revisar'
      ],
      'assignmentType' => [
        '' => 'Ninguna',
        'processAssignedUser' => 'Usuario asignado al proceso',
        'specifiedUser' => 'Usuario especificado',
        'rule:Round-Robin' => 'Todos contra todos',
        'rule:Least-Busy' => 'Menos ocupado'
      ],
      'startDirection' => [
        '' => 'Auto',
        'r' => 'Derecha',
        'd' => 'Abajo',
        'u' => 'Arriba',
        'l' => 'Izquierda'
      ],
      'messageType' => [
        'Email' => 'Correo electrónico'
      ]
    ]
  ],
  'BpmnProcess' => [
    'labels' => [
      'Create BpmnProcess' => 'Iniciar proceso',
      'Stop Process' => 'Detener el proceso',
      'User Tasks' => 'Tareas de usuario',
      'Flowcharts' => 'Diagramas de flujo',
      'Interrupt' => 'Interrumpir',
      'Reject' => 'Rechazar',
      'Start flow from here' => 'Comenzar flujo desde aquí',
      'Reactivate' => 'Reactivate',
      'View Variables' => 'View Variables',
      'View Error' => 'View Error',
      'Error Message' => 'Error Message'
    ],
    'fields' => [
      'status' => 'Estado',
      'targetType' => 'Tipo de entidad objetivo',
      'target' => 'Objetivo',
      'createdEntitiesData' => 'Datos de entidades creadas',
      'flowchartData' => 'Datos del diagrama de flujo',
      'flowchart' => 'Diagrama de flujo',
      'flowchartVisualization' => 'Diagrama de flujo (visualización)',
      'flowchartElementsDataHash' => 'Elementos de diagrama de flujo',
      'variables' => 'Variables',
      'endedAt' => 'Finalizado en',
      'startElementId' => 'Iniciar elemento',
      'workflowId' => 'Workflow ID',
      'parentProcess' => 'Proceso principal',
      'parentProcessFlowNode' => 'Nodo de flujo del proceso principal',
      'rootProcess' => 'Root Process'
    ],
    'links' => [
      'flowchart' => 'Diagrama de flujo',
      'target' => 'Objetivo',
      'flowNodes' => 'Registro de flujo',
      'userTasks' => 'Procesar tareas de usuario',
      'childProcesses' => 'Procesos secundarios',
      'parentProcess' => 'Proceso principal',
      'parentProcessFlowNode' => 'Nodo de flujo del proceso principal',
      'rootProcess' => 'Root Process'
    ],
    'options' => [
      'status' => [
        'Created' => 'Creado',
        'Started' => 'Empezado',
        'Ended' => 'Finalizado',
        'Paused' => 'Pausado',
        'Stopped' => 'Detenido',
        'Interrupted' => 'Interrumpido'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'ended' => 'Finalizado'
    ]
  ],
  'BpmnUserTask' => [
    'labels' => [
      'Resolve' => 'Resolver'
    ],
    'fields' => [
      'actionType' => 'Tipo de acción',
      'resolution' => 'Resolución',
      'target' => 'Objetivo',
      'process' => 'Proceso',
      'isResolved' => 'Está resuelto',
      'resolutionNote' => 'Nota de resolución',
      'instructions' => 'Instrucciones',
      'isCanceled' => 'Está cancelado'
    ],
    'links' => [
      'process' => 'Proceso',
      'target' => 'Objetivo',
      'flowNode' => 'Nodo de flujo'
    ],
    'options' => [
      'actionType' => [
        'Approve' => 'Aprobar',
        'Review' => 'Revisar',
        'Accomplish' => 'Conseguir'
      ],
      'resolution' => [
        '' => 'Ninguna',
        'Approved' => 'Aprobado',
        'Rejected' => 'Rechazado',
        'Reviewed' => 'Revisado',
        'Completed' => 'Completado',
        'Canceled' => 'Cancelado'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'resolved' => 'Resuelto',
      'canceled' => 'Cancelado'
    ]
  ],
  'Report' => [
    'labels' => [
      'Create Report' => 'Crear informe',
      'Run' => 'Ejecutar',
      'Total' => 'Total',
      'Group Total' => 'Group Total',
      '-Empty-' => '-Vacío-',
      'Parameters' => 'Parámetros',
      'Filters' => 'Filtros',
      'Chart' => 'Gráfico',
      'List Report' => 'Informe de lista',
      'Grid Report' => 'Informe de cuadrícula',
      'days' => 'días',
      'never' => 'nunca',
      'Get Csv' => 'Obtener CSV',
      'EmailSending' => 'Correo electrónico enviándose',
      'View Report' => 'Ver informe',
      'Report' => 'Informe',
      'AND' => 'AND',
      'OR' => 'O',
      'NOT' => 'NO EN',
      'IN' => 'EN',
      'Complex expression' => 'Expresión compleja',
      'Having' => 'Teniendo',
      'Add AND group' => 'Añadir grupo AND',
      'Add OR group' => 'Añadir grupo OR',
      'Add NOT group' => 'Añadir grupo NOT',
      'Add IN group' => 'Añadir grupo DENTRO',
      'Add Having group' => 'Añadir grupo Teniendo',
      'Add Complex expression' => 'Agregar expresión compleja',
      'Columns' => 'Columnas',
      'Send Email' => 'Enviar correo electrónico',
      'Results View' => 'Vista de resultados',
      'Create Joint Grid Report' => 'Crear informe de cuadrícula conjunta',
      'Label' => 'Label',
      'Type' => 'Type',
      'Decimal Places' => 'Decimal Places',
      'Preview' => 'Preview'
    ],
    'fields' => [
      'type' => 'Tipo',
      'entityType' => 'Tipo de entidad',
      'description' => 'Descripción',
      'groupBy' => 'Agrupar por',
      'columns' => 'Columnas',
      'orderBy' => 'Ordenar por',
      'filters' => 'Filtros',
      'runtimeFilters' => 'Filtros de tiempo de ejecución',
      'chartType' => 'Tipo de gráfico',
      'emailSendingInterval' => 'Intervalo',
      'emailSendingTime' => 'Hora',
      'emailSendingUsers' => 'Usuarios',
      'emailSendingSettingDay' => 'Día',
      'emailSendingSettingMonth' => 'Mes',
      'emailSendingSettingWeekdays' => 'Días',
      'emailSendingDoNotSendEmptyReport' => 'No enviar si el informe está vacío',
      'chartColorList' => 'Colores',
      'chartColor' => 'Color',
      'chartOneColumns' => 'Chart Columns',
      'chartOneY2Columns' => 'Chart Secondary Axis Columns',
      'orderByList' => 'Orden de la lista',
      'orderByListShort' => 'Order',
      'column' => 'Columna',
      'exportFormat' => 'Formato',
      'category' => 'Categoría',
      'applyAcl' => 'Aplicar ACL',
      'portals' => 'Portales',
      'joinedReports' => 'Subinformes',
      'joinedReportLabel' => 'Etiqueta de subinforme',
      'filtersDataList' => 'Filters Data List',
      'columnsData' => 'Columns Data',
      'filtersData' => 'Filters Data'
    ],
    'tooltips' => [
      'chartOneColumns' => 'Columns to display on the chart. If not specified, the system will include all columns that can be combined into a single chart.',
      'chartOneY2Columns' => 'Columns to display on the secondary axis of the chart.',
      'orderBy' => 'Result data will be ordered by the specified columns and groups.',
      'emailSendingUsers' => 'El resultado del informe de usuarios se enviará a',
      'chartColorList' => 'Colores personalizados para grupos específicos.',
      'applyAcl' => 'Los resultados del informe dependerán del acceso del usuario.',
      'groupBy' => 'Los datos se agregarán por uno o dos grupos. Si está vacío, los datos no se agregarán, solo se mostrarán los totales.

Se pueden usar [expresiones complejas](https://www.espocrm.com/documentation/user-guide/complex-expressions/).',
      'columns' => 'Qué datos mostrar.',
      'runtimeFilters' => 'Filtros adicionales que estarán disponibles en la vista de informe.',
      'portals' => 'El informe estará disponible solo en los portales especificados.'
    ],
    'functions' => [
      'COUNT' => 'Contar',
      'SUM' => 'Suma',
      'AVG' => 'Promedio',
      'MIN' => 'Mín',
      'MAX' => 'Máx',
      'YEAR' => 'Año',
      'QUARTER' => 'Trimestre',
      'MONTH' => 'Mes',
      'DAY' => 'Día',
      'WEEK' => 'Semana',
      'YEAR_FISCAL' => 'Año fiscal',
      'QUARTER_FISCAL' => 'Trimestre Fiscal'
    ],
    'orders' => [
      'ASC' => 'ASC',
      'DESC' => 'DESC',
      'LIST' => 'LISTA'
    ],
    'options' => [
      'dashletDisplayType' => [
        '' => '',
        'Chart' => 'Chart',
        'List' => 'List',
        'Chart-Total' => 'Chart & Total',
        'Total' => 'Total',
        'Table' => 'Table'
      ],
      'chartType' => [
        'BarHorizontal' => 'Barra (horizontal)',
        'BarVertical' => 'Barra (vertical)',
        'BarGroupedHorizontal' => 'Barra agrupada (horizontal)',
        'BarGroupedVertical' => 'Barra agrupada (vertical)',
        'Pie' => 'Tarta',
        'Line' => 'Línea',
        'Radar' => 'Radar'
      ],
      'emailSendingInterval' => [
        'Daily' => 'Diario',
        'Weekly' => 'Semanal',
        'Monthly' => 'Mensual',
        'Yearly' => 'Anual',
        '' => 'Ninguna'
      ],
      'emailSendingSettingDay' => [
        32 => 'Ultimo día del mes'
      ],
      'type' => [
        'Grid' => 'Cuadrícula',
        'List' => 'Lista',
        'JointGrid' => 'Cuadrícula conjunta'
      ],
      'function' => [
        '' => 'Sin función',
        'custom' => 'Expresión',
        'customWithOperator' => 'Expresión con operador',
        'DATE_NUMBER' => 'FECHA',
        'MONTH_NUMBER' => 'MES',
        'YEAR_NUMBER' => 'AÑO',
        'QUARTER_NUMBER' => 'TRIMESTRE',
        'DAYOFWEEK_NUMBER' => 'DÍA DE LA SEMANA',
        'HOUR_NUMBER' => 'HORA',
        'MINUTE_NUMBER' => 'MINUTO',
        'LOWER' => 'INFERIOR',
        'UPPER' => 'SUPERIOR',
        'TRIM' => 'RECORTAR',
        'LENGTH' => 'LONGITUD',
        'WEEK_NUMBER_0' => 'SEMANA (domingo)',
        'WEEK_NUMBER_1' => 'SEMANA (lunes)',
        'COUNT' => 'CONTAR',
        'SUM' => 'SUMA',
        'AVG' => 'PROMEDIO',
        'MAX' => 'MÁX',
        'MIN' => 'MÍN'
      ],
      'operator' => [
        'equals' => 'Igual a',
        'notEquals' => 'No es igual',
        'greaterThan' => 'Mayor que',
        'lessThan' => 'Menos que',
        'greaterThanOrEquals' => 'Mayor o igual que',
        'lessThanOrEquals' => 'Menor o igual que',
        'in' => 'En',
        'notIn' => 'No en',
        'isTrue' => 'Es verdadero',
        'isFalse' => 'Es falso',
        'isNull' => 'Es nulo',
        'isNotNull' => 'No es nulo',
        'like' => 'Como'
      ],
      'exportFormat' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'layoutAlign' => [
        'left' => 'Izquierda',
        'right' => 'Derecha'
      ],
      'columnType' => [
        '' => 'Auto',
        'Summary' => 'Summary'
      ]
    ],
    'messages' => [
      'noSubReportInPreview' => 'Sub-reports cannot be displayed in the preview mode.',
      'emailTemplateParsingError' => 'Error while parsing template `{template}`.',
      'executionError' => 'Could not run the report. Check the report parameters. Find more details in the log file.',
      'emptyStringGroupExcluded' => 'A group with an empty string value is excluded from the results.',
      'notAllowedFormulaInFilter' => 'Formula expression in filters contains a not allowed function.',
      'validateMaxCount' => 'El recuento no debe ser mayor que {maxCount}',
      'havingFilterWithoutGroupByError' => 'Having filter can\'t be used without Group-By.',
      'gridReportDescription' => 'Agrupar por una o dos columnas y ver las sumas. Se puede mostrar como un gráfico.',
      'listReportDescription' => 'Lista simple de registros que cumplen con los criterios de los filtros.',
      'invalidColumnError' => 'Invalid column name. Check the report parameters.',
      'sqlSyntaxError' => 'Could not compose a valid SQL from report parameters.',
      'onlyFullGroupByError' => 'Unsupported report parameters. Either change parameters or disable `ONLY_FULL_GROUP_BY` SQL mode in the database config.'
    ],
    'presetFilters' => [
      'list' => 'Lista',
      'grid' => 'Cuadrícula',
      'listTargets' => 'Lista (objetivos)',
      'listAccounts' => 'Lista (cuentas)',
      'listContacts' => 'Lista (contactos)',
      'listLeads' => 'Lista (clientes potenciales)',
      'listUsers' => 'Lista (usuarios)'
    ],
    'errorMessages' => [
      'error' => 'Error',
      'noChart' => 'No se ha seleccionado ningún gráfico para el informe.',
      'selectReport' => 'Seleccione un informe en las opciones del dashlet.'
    ],
    'filtersGroupTypes' => [
      'or' => 'O',
      'and' => 'AND',
      'not' => 'NO EN',
      'subQueryIn' => 'EN',
      'having' => 'Teniendo'
    ],
    'layoutFields' => [
      'link' => 'Enlace',
      'width' => 'Anchura',
      'notSortable' => 'No clasificable',
      'exportOnly' => 'Exportar solo',
      'align' => 'Alinear'
    ]
  ],
  'ReportCategory' => [
    'labels' => [
      'Create ReportCategory' => 'Crear categoría',
      'Manage Categories' => 'Gestionar categorías',
      'Reports' => 'Informes'
    ],
    'fields' => [
      'order' => 'Orden',
      'monitorings' => 'Monitorings'
    ],
    'links' => [
      'reports' => 'Informes',
      'monitorings' => 'Monitorings'
    ]
  ],
  'ReportFilter' => [
    'labels' => [
      'Create ReportFilter' => 'Crear filtro',
      'Rebuild Filters' => 'Reconstruir filtros'
    ],
    'fields' => [
      'order' => 'Orden',
      'report' => 'Informe',
      'entityType' => 'Tipo de entidad',
      'isActive' => 'Está habilitado'
    ],
    'links' => [
      'report' => 'Informe'
    ],
    'tooltips' => [
      'teams' => 'Equipos para los que estará disponible el filtro. Si no se especificó ningún equipo, no se aplicará ninguna restricción por equipo.',
      'report' => 'Informe de lista que se utilizará para el filtro.'
    ]
  ],
  'ReportPanel' => [
    'labels' => [
      'Create ReportPanel' => 'Crear panel',
      'Rebuild Panels' => 'Reconstruir paneles'
    ],
    'fields' => [
      'report' => 'Informe',
      'entityType' => 'Tipo de entidad',
      'isActive' => 'Está habilitado',
      'type' => 'Tipo',
      'reportType' => 'Tipo de informe',
      'displayTotal' => 'Mostrar total',
      'displayOnlyTotal' => 'Mostrar solo el total',
      'column' => 'Columna',
      'reportEntityType' => 'Tipo de entidad de informe',
      'columnList' => 'Lista de columnas',
      'dynamicLogicVisible' => 'Condiciones que hacen visible el panel',
      'order' => 'Orden',
      'displayType' => 'What to display',
      'useSiMultiplier' => 'Multiplicador SI'
    ],
    'links' => [
      'report' => 'Informe'
    ],
    'tooltips' => [
      'teams' => 'Equipos para los que se mostrará el panel. Si no se especificó ningún equipo, no se aplicará ninguna restricción por equipo.',
      'report' => 'Informe que se utilizará para el panel.',
      'order' => '[0..1] - antes del panel de transmisión;
[3..4] - antes de los paneles de relaciones;
[6..] - después de los paneles de relaciones.'
    ],
    'options' => [
      'type' => [
        'side' => 'Lado',
        'bottom' => 'Inferior'
      ]
    ]
  ],
  'Workflow' => [
    'fields' => [
      'Name' => 'Nombre',
      'entityType' => 'Entidad objetivo',
      'type' => 'Tipo de desencadenador',
      'isActive' => 'Activo',
      'description' => 'Descripción',
      'usersToMakeToFollow' => 'Usuarios que hay que hacer para seguir el registro',
      'whatToFollow' => 'Qué seguir',
      'portalOnly' => 'Solo portal',
      'portal' => 'Portal',
      'targetReport' => 'Informe de destino',
      'scheduling' => 'Programación',
      'schedulingApplyTimezone' => 'Apply timezone',
      'methodName' => 'Método de servicio',
      'assignmentRule' => 'Regla de asignación',
      'targetTeam' => 'Equipo objetivo',
      'targetUserPosition' => 'Posición de usuario objetivo',
      'listReport' => 'Informe de lista',
      'linkList' => 'Enlace con la entidad objetivo a través de relaciones',
      'linkListShort' => 'Enlaces',
      'target' => 'Objetivo',
      'whoFollow' => 'Quién hacer para seguir',
      'signalName' => 'Señal',
      'requestType' => 'Tipo de solicitud',
      'requestUrl' => 'URL',
      'requestContentType' => 'Tipo de contenido',
      'requestContent' => 'Carga útil',
      'requestContentVariable' => 'Payload from variable',
      'optOutLink' => 'Enlace de exclusión',
      'headers' => 'Encabezados',
      'manualLabel' => 'Manual Label',
      'manualDynamicLogic' => 'Manual Dynamic-Logic',
      'manualTeams' => 'Manual Teams',
      'manualAccessRequired' => 'Manual Access Required',
      'manualElementType' => 'Manual Element Type',
      'manualElementTypeInForm' => 'Element Type',
      'manualLabelInForm' => 'Label',
      'manualAccessRequiredInForm' => 'Access Required',
      'manualTeamsInForm' => 'For Teams',
      'manualDynamicLogicInForm' => 'Conditions',
      'manualConfirmation' => 'Manual Confirmation',
      'manualConfirmationInForm' => 'Confirmation Dialog',
      'manualConfirmationText' => 'Manual Confirmation Text',
      'manualConfirmationTextInForm' => 'Confirmation Text',
      'manualStyle' => 'Manual Button Style',
      'manualStyleInForm' => 'Button Style',
      'category' => 'Category',
      'conditionsAll' => 'Conditions All',
      'conditionsAny' => 'Conditions Any',
      'conditionsFormula' => 'Conditions Formula',
      'actions' => 'Actions',
      'processOrder' => 'Process Order',
      'attachmentsVariable' => 'Attachments Variable'
    ],
    'links' => [
      'portal' => 'Portal',
      'targetReport' => 'Informe de destino',
      'workflowLogRecords' => 'Registro',
      'category' => 'Category'
    ],
    'tooltips' => [
      'toEmailAddress' => 'Multiple email addresses can be specified by separating them with a semicolon.

Available placeholders:
* `{$$variable}`',
      'attachmentsVariable' => 'A Formula variable name that contains an attachment ID or an array of attachment IDs. You can generate needed attachments in a Formula script in a previous action.',
      'createEntityFormula' => 'Use Formula to set entity attributes with calculated values.',
      'entityType' => 'An entity type the rule is applied to.',
      'targetReport' => 'The scheduled workflow will run the actions for all records returned by the specified list report.',
      'type' => '
* After record created/updated – Whenever a record is created/updated. The action can be initiated by a user, another workflow, a formula script, or by the system.
* Manual – A user can start the workflow by clicking a button on the record detail view.
* Scheduled – Run automatically based on the defined scheduling.
* Sequential – Can be run by another workflow rule.
* Signal – When the specified signal is broadcast in the system.',
      'processOrder' => 'Multiple workflow rules for the same target will be processed according their order. The lower the order value, the sooner a rule runs.',
      'manualConfirmation' => 'To display a confirmation dialog before running the workflow.',
      'manualConfirmationText' => 'A text to show to a user when confirming workflow start.',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.',
      'manualDynamicLogic' => 'Conditions making the workflow available for a record.',
      'manualTeams' => 'Teams who will have access to run the workflow. If empty, only admin will have access.',
      'manualAccessRequired' => 'Access to a record required to be able run the workflow.',
      'manualLabel' => 'A UI element label text.',
      'requestUrl' => 'Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestHeaders' => 'Encabezados adicionales.

Formato:
```clave: valor```

Marcadores de posición disponibles:
* `{$attribute}`
* `{$$variable}`
* `{#secrets.name}`',
      'requestContent' => 'En formato JSON.

Marcadores de posición disponibles:
* `{$attribute}`
* `{$$variable}`',
      'requestContentVariable' => 'A variable name. If specified, payload will be taken from the variable.',
      'portalOnly' => 'Si se marca, el flujo de trabajo solo se activará en el portal.',
      'portal' => 'Portal específico donde se activará el flujo de trabajo. Déjelo vacío si necesita que funcione en cualquier portal.',
      'scheduling' => 'Notación de Crontab. Define la frecuencia con la que se ejecuta la regla de flujo de trabajo. Zona horaria UTC.

`*/5 * * * *` - cada 5 minutos

`0 */2 * * *` - cada 2 horas

`30 1 * * *` - a las 01:30 una vez al día

`0 0 1 * *` - el primer día de el mes'
    ],
    'labels' => [
      'Create Workflow' => 'Crear regla',
      'General' => 'General',
      'Manual Trigger' => 'Manual Trigger',
      'Scheduled Trigger' => 'Scheduled Trigger',
      'Conditions' => 'Condiciones',
      'Actions' => 'Acciones',
      'All' => 'Todo',
      'Any' => 'Cualquiera',
      'Formula' => 'Fórmula',
      'Email Address' => 'Dirección de correo electrónico',
      'Email Template' => 'Plantilla de correo electrónico',
      'From' => 'Desde',
      'To' => 'Para',
      'immediately' => 'Inmediatamente',
      'Reply-To' => 'Responder a',
      'CC' => 'CC',
      'later' => 'Más tarde',
      'today' => 'hoy',
      'plus' => 'más',
      'minus' => 'menos',
      'days' => 'dias',
      'hours' => 'horas',
      'months' => 'meses',
      'minutes' => 'minutos',
      'Link' => 'Enlace',
      'Add Field' => 'Añadir campo',
      'equals' => 'igual a',
      'wasEqual' => 'fue igual',
      'notEquals' => 'no es igual',
      'wasNotEqual' => 'no era igual',
      'changed' => 'cambiado',
      'notChanged' => 'sin cambios',
      'notEmpty' => 'no vacío',
      'isEmpty' => 'vacío',
      'value' => 'valor',
      'field' => 'campo',
      'true' => 'verdadero',
      'false' => 'falso',
      'greaterThan' => 'mayor que',
      'lessThan' => 'menos que',
      'greaterThanOrEquals' => 'mayor o igual que',
      'lessThanOrEquals' => 'menor o igual',
      'between' => 'entre',
      'on' => 'en',
      'before' => 'antes',
      'after' => 'después',
      'beforeToday' => 'antes de hoy',
      'afterToday' => 'después de hoy',
      'recipient' => 'Destinatario',
      'has' => 'tiene',
      'notHas' => 'no tiene',
      'contains' => 'contiene',
      'notContains' => 'no contiene',
      'messageTemplate' => 'Plantilla de mensaje',
      'users' => 'Usuarios',
      'Target Entity' => 'Entidad objetivo',
      'Current' => 'Actual',
      'Workflow' => 'Flujo de trabajo',
      'Workflows Log' => 'Registro de flujos de trabajo',
      'methodName' => 'Método de servicio',
      'additionalParameters' => 'Parámetros adicionales (formato JSON)',
      'doNotStore' => 'No almacenar correo electrónico enviado',
      'Related' => 'Relacionado',
      'Entity Type' => 'Tipo de entidad',
      'Workflow Rule' => 'Regla de flujo de trabajo',
      'Add Condition' => 'Añadir condición',
      'Add Action' => 'Añadir acción',
      'Created' => 'Creado',
      'Field' => 'Campo',
      'Entity' => 'Entidad',
      'Process' => 'Proceso',
      'now' => 'ahora'
    ],
    'emailAddressOptions' => [
      '' => 'Ninguna',
      'currentUser' => 'Usuario actual',
      'specifiedEmailAddress' => 'Dirección de correo electrónico especificada',
      'assignedUser' => 'Usuario asignado',
      'targetEntity' => 'Registro objetivo',
      'specifiedUsers' => 'Usuarios especificados',
      'specifiedContacts' => 'Contactos especificados',
      'teamUsers' => 'Usuarios de equipos relacionados con el registro objetivo',
      'followers' => 'Seguidores del registro objetivo',
      'followersExcludingAssignedUser' => 'Seguidores excluyendo el usuario asignado',
      'specifiedTeams' => 'Usuarios de los equipos especificados',
      'system' => 'Sistema',
      'fromOrReplyTo' => 'Dirección del remitente/respuesta'
    ],
    'options' => [
      'type' => [
        'afterRecordSaved' => 'Después de guardar el registro (creado o actualizado)',
        'afterRecordCreated' => 'Después de crear el registro',
        'afterRecordUpdated' => 'Después de actualizar el registro',
        'manual' => 'Manual',
        'scheduled' => 'Programado',
        'sequential' => 'Secuencial',
        'signal' => 'Señal'
      ],
      'subjectType' => [
        'value' => 'valor',
        'field' => 'campo',
        'today' => 'hoy/ahora',
        'typeOf' => 'tipo de'
      ],
      'assignmentRule' => [
        'Round-Robin' => 'Todos contra todos',
        'Least-Busy' => 'Menos ocupado'
      ],
      'manualAccessRequired' => [
        'read' => 'read',
        'edit' => 'edit',
        'admin' => 'admin'
      ],
      'manualElementType' => [
        'Button' => 'Button',
        'Dropdown-Item' => 'Dropdown Item'
      ]
    ],
    'actionTypes' => [
      'sendEmail' => 'Enviar correo electrónico',
      'createEntity' => 'Crear registro',
      'createRelatedEntity' => 'Crear registro relacionado',
      'updateEntity' => 'Actualizar registro de destino',
      'updateRelatedEntity' => 'Actualizar registro relacionado',
      'relateWithEntity' => 'Vincular con otro registro',
      'unrelateFromEntity' => 'Desvincular de otro registro',
      'makeFollowed' => 'Hacer seguido',
      'createNotification' => 'Crear notificación',
      'triggerWorkflow' => 'Desencadenar otra regla de flujo de trabajo',
      'runService' => 'Ejecutar acción de servicio',
      'applyAssignmentRule' => 'Aplicar regla de asignación',
      'updateCreatedEntity' => 'Actualizar registro creado',
      'updateProcessEntity' => 'Actualizar registro de procesos',
      'startBpmnProcess' => 'Iniciar proceso BPM',
      'sendRequest' => 'Enviar solicitud HTTP',
      'executeFormula' => 'Execute Formula Script'
    ],
    'texts' => [
      'allMustBeMet' => 'Todo debe cumplirse',
      'atLeastOneMustBeMet' => 'Al menos una debe cumplirse',
      'formulaInfo' => 'Condiciones de cualquier complejidad en el lenguaje de fórmula de espo'
    ],
    'messages' => [
      'jsonInvalid' => 'No es JSON válido.',
      'loopNotice' => 'Tenga cuidado con un posible bucle a través de dos o más reglas de flujo de trabajo continuamente.',
      'messageTemplateHelpText' => 'Variables disponibles:

* {entity} – registro objetivo
* {user} – usuario actual
* `{$$variable}`'
    ],
    'serviceActions' => [
      'sendEventInvitations' => 'Enviar invitaciones',
      'addQuoteItemList' => 'Agregar artículos de presupuesto',
      'addInvoiceItemList' => 'Añadir artículos de la factura',
      'addSalesOrderItemList' => 'Añadir artículos de orden de venta',
      'convertCurrency' => 'Convertir moneda',
      'sendInEmail' => 'Enviar en correo electrónico',
      'optOut' => 'Exclusión',
      'generateAndSendPassword' => 'Generar contraseña'
    ],
    'serviceActionsHelp' => [
      'generateAndSendPassword' => 'Se generará una nueva contraseña y se enviará a la dirección de correo electrónico del usuario.',
      'optOut' => 'Parámetro opcional: targetListId. Si no se especifica, marca una dirección de correo electrónico como inhabilitada.

 Ejemplo:
```{"targetListId": "TARGET_LIST_ID"}```',
      'convertCurrency' => 'Parámetro opcional: targetCurrency. Si no se especifica, se convertirá a la moneda predeterminada.',
      'sendInEmail' => 'Parámetros:
* templateId - ID de la plantilla PDF
* emailTemplateId - ID de la plantilla de correo electrónico
* to - destinatario (parámetro opcional); de forma predeterminada se enviará al contacto o cuenta de facturación; ejemplo: `link:account.assignedUser`

Ejemplo:

```{
    "templateId": "TEMPLATE_ID",
    "emailTemplateId": "EMAIL_TEMPLATE_ID",
    "to": "link:billingContact"
}```',
      'addQuoteItemList' => 'Ejemplo: 

```{
  "itemList": [
     {
      "quantity": 1, "productId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addInvoiceItemList' => 'Ejemplo: 

```{
  "itemList": [
     {
      "quantity": 1, "productId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addSalesOrderItemList' => 'Ejemplo: 

```{
  "itemList": [
     {
      "quantity": 1, "productId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'WorkflowCategory' => [
    'labels' => [
      'Create WorkflowCategory' => 'Create Category'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'workflows' => 'Workflows'
    ]
  ],
  'WorkflowLogRecord' => [
    'labels' => [],
    'fields' => [
      'target' => 'Objetivo',
      'workflow' => 'Flujo de trabajo'
    ]
  ],
  'DeliveryOrder' => [
    'labels' => [
      'Create DeliveryOrder' => 'Create Delivery Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'shippingAddress' => 'Shipping Address',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'salesOrder' => 'Sales Order',
      'account' => 'Account',
      'tax' => 'Tax',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'notAvailableInventory' => 'Not enough inventory is available.',
      'notAvailableInventoryStatusChanged' => 'Not enough inventory is available. Cannot change the status.'
    ],
    'texts' => [
      'itemTooMany' => '{number} extra needs to be removed.',
      'itemTooFew' => '{number} more needs to be added.'
    ]
  ],
  'DeliveryOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'deliveryOrder' => 'Delivery Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'deliveryOrderStatus' => 'Delivery Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'deliveryOrder' => 'Delivery Order',
      'product' => 'Product',
      'account' => 'Account',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'InventoryAdjustment' => [
    'labels' => [
      'Create InventoryAdjustment' => 'Create Adjustment',
      'Add Item' => 'Add Item',
      'Items' => 'Items'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'amount' => 'Amount',
      'itemList' => 'Item List',
      'date' => 'Date',
      'reason' => 'Reason',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done',
      'doneAt' => 'Done At'
    ],
    'links' => [
      'items' => 'Items',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ],
      'reason' => [
        'Stocktaking' => 'Stocktaking',
        'Write-off' => 'Write-off',
        'Waste' => 'Waste',
        'Shrinkage' => 'Shrinkage',
        'Damage' => 'Damage',
        'Internal' => 'Internal'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'itemProductIsNotInventory' => 'Product {name} is not inventory.',
      'emptyNewQuantityInItem' => 'On-hand quantity is not specified for an item.',
      'sameItemsInAnotherAdjustment' => 'The same items are in another started adjustment.',
      'duplicateItems' => 'Can\'t have the same items in an adjustment.'
    ]
  ],
  'InventoryAdjustmentItem' => [
    'fields' => [
      'name' => 'Name',
      'newQtyOnHand' => 'On-Hand Qty',
      'qty' => 'Adjusted',
      'newQuantityOnHand' => 'New On-Hand Quantity ',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'inventoryAdjustment' => 'Adjustment',
      'description' => 'Description',
      'inventoryAdjustmentStatus' => 'Inventory Adjustment Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'warehouse' => 'Warehouse'
    ],
    'links' => [
      'inventoryAdjustment' => 'Adjustment',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ],
    'presetFilters' => [
      'completed' => 'Completed'
    ]
  ],
  'InventoryNumber' => [
    'labels' => [
      'Create InventoryNumber' => 'Create Number',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Inventory History' => 'Inventory History',
      'View History' => 'View History',
      'Received' => 'Received',
      'Shipped' => 'Shipped'
    ],
    'fields' => [
      'type' => 'Type',
      'product' => 'Product',
      'quantityOnHand' => 'On Hand',
      'quantityReserved' => 'Reserved',
      'quantityInTransit' => 'In Transit',
      'incomingDate' => 'Incoming Date',
      'productionDate' => 'Production Date',
      'expirationDate' => 'Expiration Date',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'deleteId' => 'Delete ID',
      'number' => 'Internal Number',
      'orderFifo' => 'Order FIFO',
      'orderFefo' => 'Order FEFO',
      'orderLifo' => 'Order LIFO',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse',
      'idForSearch' => 'IDs excluded'
    ],
    'links' => [
      'product' => 'Product',
      'inventoryTransactions' => 'Inventory Transactions'
    ],
    'presetFilters' => [
      'onHand' => 'On Hand',
      'notOnHand' => 'Not On Hand'
    ],
    'messages' => [
      'alreadyExists' => 'The same inventory number already exists.'
    ]
  ],
  'InventoryTransaction' => [
    'labels' => [
      'Create InventoryTransaction' => 'Create Transaction'
    ],
    'fields' => [
      'number' => 'Number',
      'type' => 'Type',
      'parent' => 'Parent',
      'quantity' => 'Quantity',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'links' => [
      'parent' => 'Parent',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'options' => [
      'type' => [
        'Transfer' => 'Transfer',
        'Reserve' => 'Reserve',
        'Soft Reserve' => 'Soft Reserve'
      ]
    ]
  ],
  'Invoice' => [
    'labels' => [
      'Create Invoice' => 'Crear factura',
      'Taxes' => 'Impuestos',
      'Shipping Providers' => 'Proveedores de envío',
      'Add Item' => 'Añadir artículo',
      'Templates' => 'Plantillas',
      'Items' => 'Artículos',
      'Invoice Items' => 'Artículos de la factura',
      'E-Invoice' => 'E-Invoice',
      'Validate' => 'Validate'
    ],
    'fields' => [
      'status' => 'Estado',
      'number' => 'Número',
      'numberA' => 'Número (auto-incrementado)',
      'account' => 'Cuenta',
      'opportunity' => 'Oferta',
      'quote' => 'Presupuesto',
      'salesOrder' => 'Orden de venta',
      'billingAddress' => 'Dirección de facturación',
      'shippingAddress' => 'Dirección de envío',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'tax' => 'Impuesto',
      'taxRate' => 'Tasa de impuesto',
      'shippingCost' => 'Gastos de envío',
      'shippingProvider' => 'Proveedor de envío',
      'taxAmount' => 'Importe del impuesto',
      'discountAmount' => 'Importe de descuento',
      'amount' => 'Cantidad',
      'preDiscountedAmount' => 'Importe antes del descuento',
      'grandTotalAmount' => 'Importe total final',
      'itemList' => 'Lista de articulos',
      'dateInvoiced' => 'Fecha de facturación',
      'dateDue' => 'Due Date',
      'weight' => 'Peso',
      'amountConverted' => 'Cantidad (convertida)',
      'taxAmountConverted' => 'Importe de impuesto (convertido)',
      'shippingCostConverted' => 'Gastos de envío (convertido)',
      'preDiscountedAmountConverted' => 'Importe antes del descuento (convertido)',
      'discountAmountConverted' => 'Importe de descuento (convertido)',
      'grandTotalAmountConverted' => 'Importe total final (convertido)',
      'shippingCostCurrency' => 'Moneda de gastos de envío',
      'taxAmountCurrency' => 'Moneda del importe del impuesto',
      'discountAmountCurrency' => 'Moneda del importe de descuento',
      'amountCurrency' => 'Moneda del importe',
      'preDiscountedAmountCurrency' => 'Moneda del importe antes del descuento',
      'grandTotalAmountCurrency' => 'Moneda del importe total final',
      'currency' => 'Moneda',
      'priceBook' => 'Price Book',
      'buyerReference' => 'Buyer Reference',
      'purchaseOrderReference' => 'Purchase Order Reference',
      'note' => 'Note'
    ],
    'links' => [
      'items' => 'Artículos',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'shippingProvider' => 'Proveedor de envío',
      'opportunity' => 'Oferta',
      'account' => 'Cuenta',
      'tax' => 'Impuesto',
      'quote' => 'Presupuesto',
      'salesOrder' => 'Orden de venta',
      'priceBook' => 'Price Book'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Sent' => 'Sent',
        'In Review' => 'En revisión',
        'Confirmed' => 'Confirmado',
        'Paid' => 'Pagado',
        'Rejected' => 'Rechazado',
        'Canceled' => 'Cancelado'
      ],
      'eInvoiceFormats' => [
        'CiusRo' => 'CIUS-RO e-Factura',
        'CiusIt' => 'CIUS-IT',
        'CiusAtGov' => 'CIUS-AT-GOV',
        'CiusAtNat' => 'CIUS-AT-NAT',
        'Peppol' => 'PEPPOL BIS Billing 3.0',
        'CiusEsFace' => 'CIUS-ES-FACE',
        'Nlcius' => 'NLCIUS',
        'XRechnung' => 'XRechnung'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'paid' => 'Pagado'
    ],
    'messages' => [
      'invoiceIsValid' => 'Invoice is valid',
      'ublRuleValidationFailure' => 'Invalid invoice.

Failed rule ID: `{ruleId}`

{message}'
    ],
    'eInvoiceFields' => [
      'eInvoiceFormat' => 'E-Invoice Format',
      'format' => 'Format'
    ]
  ],
  'InvoiceItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cantidad',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'amount' => 'Cantidad',
      'taxRate' => 'Tasa de impuesto',
      'product' => 'Producto',
      'order' => 'Número de línea',
      'invoice' => 'Factura',
      'weight' => 'Peso',
      'unitWeight' => 'Peso de la unidad',
      'description' => 'Descripción',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Cantidad (convertida)',
      'unitPriceConverted' => 'Precio unitario (convertido)',
      'listPriceConverted' => 'Precio de lista (convertido)',
      'account' => 'Cuenta',
      'listPriceCurrency' => 'Moneda del precio de lista',
      'unitPriceCurrency' => 'Moneda del precio unitario',
      'amountCurrency' => 'Moneda del importe',
      'invoiceStatus' => 'Estado de la factura'
    ],
    'links' => [
      'invoice' => 'Factura',
      'product' => 'Producto',
      'account' => 'Cuenta'
    ],
    'labels' => [
      'Invoices' => 'Facturas'
    ]
  ],
  'OpportunityItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cantidad',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Quantity (Int)',
      'unitPrice' => 'Precio unitario',
      'amount' => 'Cantidad',
      'amountCurrency' => 'Amount (Currency)',
      'unitPriceCurrency' => 'Unit Price (Currency)',
      'product' => 'Producto',
      'order' => 'Número de línea',
      'opportunity' => 'Oferta',
      'description' => 'Descripción',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Cantidad (convertida)',
      'unitPriceConverted' => 'Precio unitario (convertido)',
      'listPrice' => 'Precio de lista',
      'listPriceConverted' => 'Precio de lista (convertido)',
      'listPriceCurrency' => 'List Price Currency',
      'opportunityStage' => 'Etapa'
    ],
    'links' => [
      'opportunity' => 'Oferta',
      'product' => 'Producto'
    ],
    'labels' => [
      'Opportunities' => 'Oportunidades'
    ]
  ],
  'PriceBook' => [
    'labels' => [
      'Create PriceBook' => 'Create Price Book'
    ],
    'fields' => [
      'parentPriceBook' => 'Parent Price Book',
      'status' => 'Status'
    ],
    'links' => [
      'products' => 'Products',
      'parentPriceBook' => 'Parent Price Book',
      'accounts' => 'Accounts',
      'prices' => 'Prices',
      'rules' => 'Rules',
      'childPriceBooks' => 'Child Price Books'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'PriceRule' => [
    'labels' => [
      'Create PriceRule' => 'Create Rule'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'productCategory' => 'Product Category',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'percentage' => 'Percentage',
      'discount' => 'Discount',
      'target' => 'Target',
      'condition' => 'Condition',
      'conditionSelect' => 'Condition Select',
      'roundingMethod' => 'Rounding Method',
      'roundingFactor' => 'Rounding Factor',
      'surcharge' => 'Surcharge',
      'currency' => 'Currency',
      'basedOn' => 'Based On',
      'supplier' => 'Supplier'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'productCategory' => 'Product Category',
      'condition' => 'Condition',
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'basedOn' => [
        'Unit' => 'Unit',
        'Price Book' => 'Price Book',
        'Supplier' => 'Supplier',
        'Cost' => 'Cost'
      ],
      'basedOnShort' => [
        'Unit' => 'U',
        'Price Book' => 'PB',
        'Supplier' => 'S',
        'Cost' => 'C'
      ],
      'target' => [
        'All' => 'All',
        'Product Category' => 'Product Category',
        'Conditional' => 'Conditional'
      ],
      'percentageType' => [
        'Discount' => 'Discount',
        'Markup' => 'Markup'
      ],
      'roundingFactor' => [
        'Half Up' => 'Half Up',
        'Up' => 'Up',
        'Down' => 'Down'
      ]
    ],
    'tooltips' => [
      'minQuantity' => 'The rule will be applied only if the quantity of items being sold exceeds the specified value.',
      'currency' => 'The amount will be converted to the specified currency before rounding. Also defines the currency of the surcharge.',
      'basedOn' => 'What to use as a base price.

* Unit – the unit price defined in the Price Book or defined in the Product record; Price Book rules are not applied;
* Price Book – is obtained from the same Price Book; rules are applied;
* Supplier – the price of the Supplier;
* Cost – the cost specified in the Product record.',
      'surcharge' => 'An amount to add after percentage and rounding are applied. Use a negative number to subtract.',
      'roundingFactor' => 'The amount will be round off to the multiple of the specified value.',
      'percentage' => 'A percentage of the standard price to deduct or add.'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'PriceRuleCondition' => [
    'labels' => [
      'Create PriceRuleCondition' => 'Create Condition'
    ],
    'fields' => [
      'condition' => 'Condition'
    ],
    'tooltips' => [
      'condition' => 'A formula expression. Should return true or false.'
    ]
  ],
  'Product' => [
    'labels' => [
      'Create Product' => 'Crear producto',
      'Price' => 'Precio',
      'Brands' => 'Marcas',
      'Categories' => 'Categorias',
      'Price Books' => 'Price Books',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Generate' => 'Generate',
      'Orders' => 'Orders',
      'Select Variant' => 'Select Variant',
      'Select Variants' => 'Select Variants',
      'Select Template' => 'Select Template',
      'View Price' => 'View Price'
    ],
    'fields' => [
      'status' => 'Estado',
      'brand' => 'Marca',
      'partNumber' => 'Número de pieza',
      'category' => 'Categoría',
      'pricingType' => 'Tipo de precio',
      'pricingFactor' => 'Factor de precio',
      'costPrice' => 'Precio de coste',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'costPriceCurrency' => 'Moneda del precio de coste',
      'listPriceCurrency' => 'Moneda del precio de lista',
      'unitPriceCurrency' => 'Moneda del precio unitario',
      'costPriceConverted' => 'Precio de coste (convertido)',
      'listPriceConverted' => 'Precio de lista (convertido)',
      'unitPriceConverted' => 'Precio unitario (convertido)',
      'url' => 'URL',
      'isTaxFree' => 'Libre de impuestos',
      'weight' => 'Peso',
      'suppliers' => 'Suppliers',
      'unitPriceSelect' => 'Unit Price (Select)',
      'unitPriceSelectCurrency' => 'Unit Price (Select) (Currency)',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'quantity' => 'Available',
      'quantityReserved' => 'Reserved',
      'quantitySoftReserved' => 'Soft-Reserved',
      'quantityOnHand' => 'On Hand',
      'quantityInTransit' => 'In Transit',
      'quantityOnOrder' => 'On Order',
      'quantityWarehouse' => 'Available in Warehouse',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse',
      'qty' => 'Qty',
      'isInventory' => 'Is Inventory',
      'inventoryNumberType' => 'Inventory Number Type',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'type' => 'Type',
      'template' => 'Template',
      'attributes' => 'Attributes',
      'variantAttributeOptions' => 'Attribute Values',
      'variantOrder' => 'Variant Order',
      'expirationDays' => 'Expiration Days',
      'removalStrategy' => 'Removal Strategy',
      'account' => 'Account'
    ],
    'links' => [
      'brand' => 'Marca',
      'category' => 'Categoría',
      'prices' => 'Prices',
      'supplierPrices' => 'Supplier Prices',
      'inventoryNumbers' => 'Inventory Numbers',
      'inventoryTransactions' => 'Inventory Transactions',
      'attributes' => 'Attributes',
      'attributeOptions' => 'Attribute Options',
      'variantAttributeOptions' => 'Variant Attribute Options',
      'template' => 'Template',
      'variants' => 'Variants',
      'variantInventoryNumbers' => 'Variant Inventory Numbers',
      'inventoryAdjustmentItems' => 'Adjustments',
      'account' => 'Account'
    ],
    'options' => [
      'status' => [
        'Available' => 'Active',
        'Unavailable' => 'Inactive'
      ],
      'pricingType' => [
        'Same as List' => 'Igual que la lista',
        'Fixed' => 'Fijo',
        'Discount from List' => 'Descontar de la lista',
        'Markup over Cost' => 'Margen sobre coste',
        'Profit Margin' => 'Margen de beneficio'
      ],
      'inventoryNumberType' => [
        'Batch' => 'Batch',
        'Serial' => 'Serial'
      ],
      'type' => [
        'Regular' => 'Regular',
        'Template' => 'Template',
        'Variant' => 'Variant'
      ],
      'removalStrategy' => [
        'FIFO' => 'FIFO',
        'FEFO' => 'FEFO',
        'LIFO' => 'LIFO'
      ]
    ],
    'presetFilters' => [
      'available' => 'Disponible',
      'inventory' => 'Inventory',
      'allVariants' => 'All Variants',
      'availableVariants' => 'Active Variants'
    ],
    'tabs' => [
      'inventory' => 'Inventory',
      'prices' => 'Prices',
      'variants' => 'Variants',
      'template' => 'Template',
      'orders' => 'Orders'
    ],
    'messages' => [
      'generateVariantsConfirmation' => 'Generate all possible variant combinations?',
      'variantsGenerated' => 'Done. {count} variants generated.',
      'attributesRequired' => 'At least one attribute is required',
      'optionsRequired' => 'Options are required'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'ProductAttribute' => [
    'labels' => [
      'Create ProductAttribute' => 'Create Attribute',
      'Move to Top' => 'Move to Top',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down',
      'Move to Bottom' => 'Move to Bottom'
    ],
    'fields' => [
      'order' => 'Order',
      'options' => 'Options'
    ],
    'links' => [
      'options' => 'Options',
      'products' => 'Products'
    ]
  ],
  'ProductAttributeOption' => [
    'labels' => [
      'Create ProductAttributeOption' => 'Create Option'
    ],
    'fields' => [
      'order' => 'Order',
      'attribute' => 'Attribute',
      'color' => 'Color',
      'attributeOrder' => 'Attribute Order'
    ],
    'links' => [
      'attribute' => 'Attribute',
      'products' => 'Products',
      'productVariants' => 'Product Variants'
    ]
  ],
  'ProductBrand' => [
    'labels' => [
      'Create ProductBrand' => 'Crear marca'
    ],
    'fields' => [
      'website' => 'Sitio web',
      'cPatchNotes' => 'Patch Notes'
    ],
    'links' => [
      'products' => 'Productos',
      'cPatchNotes' => 'Patch Notes'
    ]
  ],
  'ProductCategory' => [
    'labels' => [
      'Create ProductCategory' => 'Crear categoría',
      'Manage Categories' => 'Gestionar categorías',
      'Products' => 'Productos'
    ],
    'fields' => [
      'order' => 'Orden',
      'childList' => 'Lista secundaria'
    ],
    'links' => [
      'products' => 'Productos'
    ]
  ],
  'ProductPrice' => [
    'labels' => [
      'Create ProductPrice' => 'Create Price'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'tooltips' => [
      'minQuantity' => 'The price will be used only when the quantity of items being sold exceeds the specified value.'
    ],
    'messages' => [
      'priceMassUpdated' => 'Prices updated, count: {count}'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'PurchaseOrder' => [
    'labels' => [
      'Create PurchaseOrder' => 'Create Purchase Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Purchase Order Items' => 'Purchase Order Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'supplierAddress' => 'Supplier Address',
      'supplierAddressStreet' => 'Street (Supplier)',
      'supplierAddressCity' => 'City (Supplier)',
      'supplierAddressState' => 'State (Supplier)',
      'supplierAddressCountry' => 'Country (Supplier)',
      'supplierAddressPostalCode' => 'Postal Code (Supplier)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'PurchaseOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'purchaseOrder' => 'Purchase Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'purchaseOrderStatus' => 'Purchase Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'purchaseOrder' => 'Purchase Order',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Purchase Orders' => 'Purchase Orders'
    ]
  ],
  'Quote' => [
    'labels' => [
      'Create Quote' => 'Crear presupuesto',
      'Taxes' => 'Impuestos',
      'Shipping Providers' => 'Proveedores de envío',
      'Add Item' => 'Añadir artículo',
      'Templates' => 'Plantillas',
      'Items' => 'Artículos',
      'Quote Items' => 'Artículos de presupuesto',
      'Apply Price Book' => 'Apply Price Book',
      'Locked' => 'Locked',
      'Unlocked' => 'Unlocked',
      'Send in Email' => 'Send in Email',
      'Send In Email' => 'Enviar por correo electrónico'
    ],
    'fields' => [
      'status' => 'Estado',
      'number' => 'Número de presupuesto',
      'numberA' => 'Número de presupuesto (autoincrementado)',
      'invoiceNumber' => 'Número de factura',
      'account' => 'Cuenta',
      'opportunity' => 'Oferta',
      'billingAddress' => 'Dirección de facturación',
      'shippingAddress' => 'Dirección de envío',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'tax' => 'Impuesto',
      'taxRate' => 'Tasa de impuesto',
      'shippingCost' => 'Gastos de envío',
      'shippingProvider' => 'Proveedor de envío',
      'taxAmount' => 'Importe del impuesto',
      'discountAmount' => 'Importe de descuento',
      'amount' => 'Cantidad',
      'preDiscountedAmount' => 'Importe antes del descuento',
      'grandTotalAmount' => 'Importe total final',
      'itemList' => 'Lista de articulos',
      'dateQuoted' => 'Fecha de presupuesto',
      'dateOrdered' => 'Fecha del pedido',
      'dateInvoiced' => 'Fecha de facturación',
      'weight' => 'Peso',
      'amountConverted' => 'Cantidad (convertida)',
      'taxAmountConverted' => 'Importe de impuesto (convertido)',
      'shippingCostConverted' => 'Gastos de envío (convertido)',
      'preDiscountedAmountConverted' => 'Importe antes del descuento (convertido)',
      'discountAmountConverted' => 'Importe de descuento (convertido)',
      'grandTotalAmountConverted' => 'Importe total final (convertido)',
      'shippingCostCurrency' => 'Moneda de gastos de envío',
      'taxAmountCurrency' => 'Moneda del importe del impuesto',
      'discountAmountCurrency' => 'Moneda del importe de descuento',
      'amountCurrency' => 'Moneda del importe',
      'preDiscountedAmountCurrency' => 'Moneda del importe antes del descuento',
      'grandTotalAmountCurrency' => 'Moneda del importe total final',
      'currency' => 'Moneda',
      'priceBook' => 'Price Book',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Artículos',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'shippingProvider' => 'Proveedor de envío',
      'opportunity' => 'Oferta',
      'account' => 'Cuenta',
      'tax' => 'Impuesto',
      'salesOrders' => 'Órdenes de venta',
      'invoices' => 'Facturas',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'In Review' => 'En revisión',
        'Presented' => 'Presentado',
        'Approved' => 'Aprobado',
        'Rejected' => 'Rechazado',
        'Canceled' => 'Cancelado'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'approved' => 'Aprobado'
    ],
    'messages' => [
      'cannotRemoveLockedRecord' => 'Cannot remove the locked record.',
      'massLockDone' => '{count} locked',
      'massUnlockDone' => '{count} unlocked',
      'confirmMassLock' => 'Are you sure you want to lock selected records?',
      'confirmMassUnlock' => 'Are you sure you want to unlock selected records?',
      'cantModifyLocked' => 'Cannot modify *{field}* in the locked record.',
      'productTemplateCannotBeSelected' => 'A product template cannot be selected in an item. *{name}* is a template.',
      'fieldCannotBeFractional' => 'Quantity cannot be fractional for this product',
      'invalidItems' => 'Invalid items.',
      'requiredInventoryNumber' => 'Inventory Number is required.',
      'requiredQuantityReceived' => 'Quantity Received is required.',
      'notEnoughQuantity' => 'Not enough quantity is available',
      'enoughQuantity' => 'Enough quantity is available',
      'softNotEnoughQuantity' => 'Enough quantity is on hand but some items are soft-reserved',
      'applyNewPriceConfirmation' => 'A different price is available for the specified quantity. Would you like to apply it?',
      'cannotUnlockByRegularUser' => 'Cannot unlock. Only an administrator is permitted.'
    ],
    'texts' => [
      'onHandQuantityInfo' => 'On hand',
      'availableQuantityInfo' => 'Available',
      'lackingQuantityInfo' => 'Lacking',
      'totalAvailableQuantityInfo' => 'In all warehouses',
      'totalOnHandQuantityInfo' => 'On hand in all warehouses',
      'onHandInventoryNumberInfo' => 'Inv. number on hand',
      'onHandBatchInfo' => 'On hand in batch',
      'onHandSerialInfo' => 'Serial on hand'
    ]
  ],
  'QuoteItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cantidad',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'amount' => 'Cantidad',
      'taxRate' => 'Tasa de impuesto',
      'product' => 'Producto',
      'order' => 'Número de línea',
      'quote' => 'Presupuesto',
      'weight' => 'Peso',
      'unitWeight' => 'Peso de la unidad',
      'description' => 'Descripción',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Cantidad (convertida)',
      'unitPriceConverted' => 'Precio unitario (convertido)',
      'listPriceConverted' => 'Precio de lista (convertido)',
      'account' => 'Cuenta',
      'listPriceCurrency' => 'Moneda del precio de lista',
      'unitPriceCurrency' => 'Moneda del precio unitario',
      'amountCurrency' => 'Moneda del importe',
      'quoteStatus' => 'Estado del presupuesto'
    ],
    'links' => [
      'quote' => 'Presupuesto',
      'product' => 'Producto',
      'account' => 'Cuenta'
    ],
    'labels' => [
      'Quotes' => 'Presupuestos'
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ]
  ],
  'ReceiptOrder' => [
    'labels' => [
      'Create ReceiptOrder' => 'Create Receipt Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Received Inventory' => 'Received Inventory',
      'Import Serial Numbers' => 'Import Serial Numbers',
      'CSV File' => 'CSV File'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingProvider' => 'Shipping Provider',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'itemList' => 'Item List',
      'receivedItemList' => 'Received Item List',
      'dateOrdered' => 'Date Ordered',
      'dateReceived' => 'Date Received',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'isDone' => 'Is Done',
      'warehouse' => 'Warehouse',
      'fieldDelimiter' => 'Field Delimiter',
      'textQualifier' => 'Text Qualifier',
      'headerRow' => 'Header Row',
      'columnNumber' => 'Column Number',
      'preview' => 'Preview'
    ],
    'links' => [
      'items' => 'Items',
      'receivedItems' => 'Received Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'serialNumbersExists' => 'Some serial numbers already exists.

{numbers}',
      'serialNumberImportLimitExceeded' => 'Cannot import more than {maxSize} serial numbers.',
      'serialNumberAlreadyInStock' => 'Serial number already in stock.

{numbers}',
      'receivedSerialNumberNotOne' => 'Quantity of a received item with a serial number should be one.',
      'receivedInventoryNumberProductMismatch' => 'Inventory number does not correspond to the product.',
      'receivedInventoryNumberIsEmpty' => 'Not specified inventory number.',
      'receivedQuantityMismatch' => 'Received quantity mismatch.',
      'emptyQuantityReceived' => 'Need to specify Quantity Received before completing the order.'
    ]
  ],
  'ReceiptOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'receiptOrder' => 'Receipt Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'receiptOrderStatus' => 'Receipt Order Status',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'receiptOrder' => 'Receipt Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'ReturnOrder' => [
    'labels' => [
      'Create ReturnOrder' => 'Create Return Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'fromAddress' => 'Ship from Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'fromAddressStreet' => 'Street (from)',
      'fromAddressCity' => 'City (from)',
      'fromAddressState' => 'State (from)',
      'fromAddressCountry' => 'Country (from)',
      'fromAddressPostalCode' => 'Postal Code (from)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'ReturnOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number',
      'order' => 'Line Number',
      'returnOrder' => 'Return Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'returnOrderStatus' => 'Return Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'returnOrder' => 'Return Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'SalesOrder' => [
    'labels' => [
      'Create SalesOrder' => 'Crear orden de venta',
      'Taxes' => 'Impuestos',
      'Shipping Providers' => 'Proveedores de envío',
      'Add Item' => 'Añadir artículo',
      'Templates' => 'Plantillas',
      'Items' => 'Artículos',
      'Sales Order Items' => 'Artículos de orden de venta',
      'Create Delivery' => 'Create Delivery',
      'Add Delivery' => 'Add Delivery',
      'Not Created' => 'Not Created'
    ],
    'fields' => [
      'status' => 'Estado',
      'number' => 'Número',
      'numberA' => 'Número (auto-incrementado)',
      'account' => 'Cuenta',
      'opportunity' => 'Oferta',
      'quote' => 'Presupuesto',
      'billingAddress' => 'Dirección de facturación',
      'shippingAddress' => 'Dirección de envío',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'tax' => 'Impuesto',
      'taxRate' => 'Tasa de impuesto',
      'shippingCost' => 'Gastos de envío',
      'shippingProvider' => 'Proveedor de envío',
      'taxAmount' => 'Importe del impuesto',
      'discountAmount' => 'Importe de descuento',
      'amount' => 'Cantidad',
      'preDiscountedAmount' => 'Importe antes del descuento',
      'grandTotalAmount' => 'Importe total final',
      'itemList' => 'Lista de articulos',
      'dateOrdered' => 'Fecha del pedido',
      'dateInvoiced' => 'Fecha de facturación',
      'weight' => 'Peso',
      'amountConverted' => 'Cantidad (convertida)',
      'taxAmountConverted' => 'Importe de impuesto (convertido)',
      'shippingCostConverted' => 'Gastos de envío (convertido)',
      'preDiscountedAmountConverted' => 'Importe antes del descuento (convertido)',
      'discountAmountConverted' => 'Importe de descuento (convertido)',
      'grandTotalAmountConverted' => 'Importe total final (convertido)',
      'shippingCostCurrency' => 'Moneda de gastos de envío',
      'taxAmountCurrency' => 'Moneda del importe del impuesto',
      'discountAmountCurrency' => 'Moneda del importe de descuento',
      'amountCurrency' => 'Moneda del importe',
      'preDiscountedAmountCurrency' => 'Moneda del importe antes del descuento',
      'grandTotalAmountCurrency' => 'Moneda del importe total final',
      'currency' => 'Moneda',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDeliveryCreated' => 'Delivery Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Artículos',
      'billingContact' => 'Contacto de facturación',
      'shippingContact' => 'Contacto de envío',
      'shippingProvider' => 'Proveedor de envío',
      'opportunity' => 'Oferta',
      'account' => 'Cuenta',
      'tax' => 'Impuesto',
      'quote' => 'Presupuesto',
      'invoices' => 'Facturas',
      'deliveryOrders' => 'Delivery Orders',
      'returnOrders' => 'Return Orders',
      'priceBook' => 'Price Book',
      'inventoryTransactions' => 'Inventory Transactions'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Borrador',
        'Ready' => 'Listo',
        'Active' => 'Activo',
        'Approved' => 'Aprobado',
        'Completed' => 'Completado',
        'Rejected' => 'Rechazado',
        'Canceled' => 'Cancelado'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'completed' => 'Completado'
    ],
    'messages' => [
      'cannotCreateDeliveryInEditMode' => 'Cannot create delivery orders while in edit mode.'
    ]
  ],
  'SalesOrderItem' => [
    'fields' => [
      'name' => 'Nombre',
      'qty' => 'Cantidad',
      'quantity' => 'Cantidad',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'Precio de lista',
      'unitPrice' => 'Precio unitario',
      'amount' => 'Cantidad',
      'taxRate' => 'Tasa de impuesto',
      'product' => 'Producto',
      'order' => 'Número de línea',
      'salesOrder' => 'Orden de venta',
      'weight' => 'Peso',
      'unitWeight' => 'Peso de la unidad',
      'description' => 'Descripción',
      'discount' => 'Descuento (%)',
      'amountConverted' => 'Cantidad (convertida)',
      'unitPriceConverted' => 'Precio unitario (convertido)',
      'listPriceConverted' => 'Precio de lista (convertido)',
      'account' => 'Cuenta',
      'listPriceCurrency' => 'Moneda del precio de lista',
      'unitPriceCurrency' => 'Moneda del precio unitario',
      'amountCurrency' => 'Moneda del importe',
      'salesOrderStatus' => 'Estado de la orden de venta',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'salesOrder' => 'Orden de venta',
      'product' => 'Producto',
      'account' => 'Cuenta'
    ],
    'labels' => [
      'Sales Orders' => 'Órdenes de venta'
    ]
  ],
  'ShippingProvider' => [
    'labels' => [
      'Create ShippingProvider' => 'Crear proveedor de envío'
    ],
    'fields' => [
      'website' => 'Sitio web'
    ]
  ],
  'Supplier' => [
    'labels' => [
      'Create Supplier' => 'Create Supplier'
    ],
    'fields' => [
      'account' => 'Account',
      'status' => 'Status'
    ],
    'links' => [
      'account' => 'Account',
      'prices' => 'Prices',
      'purchaseOrders' => 'Purchase Orders'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'SupplierProductPrice' => [
    'labels' => [
      'Create SupplierProductPrice' => 'Create Supplier Price'
    ],
    'fields' => [
      'supplier' => 'Supplier',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'Tax' => [
    'labels' => [
      'Create Tax' => 'Crear impuesto'
    ],
    'fields' => [
      'rate' => 'Tasa'
    ]
  ],
  'TransferOrder' => [
    'labels' => [
      'Create TransferOrder' => 'Create Transfer Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse',
      'fromAddress' => 'Ship from Address',
      'toAddress' => 'Ship to Address',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'inventoryTransactions' => 'Inventory Transactions',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'warehousesAreSame' => 'Warehouses must be different'
    ]
  ],
  'TransferOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'transferOrder' => 'Transfer Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'transferOrderStatus' => 'Transfer Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'transferOrder' => 'Transfer Order',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'Warehouse' => [
    'labels' => [
      'Create Warehouse' => 'Create Warehouse'
    ],
    'fields' => [
      'status' => 'Status',
      'isAvailableForStock' => 'Available for Stock',
      'isStock' => 'Stock'
    ],
    'links' => [
      'inventoryTransactions' => 'Inventory Transactions',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active',
      'stocked' => 'Stocked'
    ]
  ],
  'EblaForm' => [
    'fields' => [
      'fields' => 'Fields',
      'entity' => 'Entity',
      'showLogo' => 'Show Logo',
      'type' => 'Type',
      'layout' => 'Layout',
      'accessLink' => 'Access Link',
      'isActive' => 'Is active',
      'thanksMessage' => 'Thanks Message',
      'defaultValues' => 'Default values',
      'backgroundColor' => 'Background Color',
      'isTransparent' => 'Transparent Background',
      'welcomeMessage' => 'Welcome Message',
      'customCSS' => 'Custom CSS',
      'reCaptchaEnabled' => 'Enable reCaptcha',
      'cAllowEblaFormUpload' => 'AllowEblaFormUpload'
    ],
    'labels' => [
      'Create EblaForm' => 'Create Ebla Public Form'
    ],
    'options' => [
      'fields' => [],
      'type' => [
        '' => '',
        'Create' => 'Create',
        'Edit' => 'Edit'
      ],
      'layout' => [
        'createNewLayout' => 'Create a new layout'
      ]
    ]
  ],
  'Analytics' => [
    'fields' => [
      'appId' => 'AppId',
      'embed' => 'Embed URL',
      'params' => 'Parameters',
      'reportId' => 'Report ID',
      'workspace' => 'Workspace',
      'url' => 'Url',
      'contacts' => 'Contact',
      'urlExterna' => 'Url Externa',
      'rocket' => 'Rocket',
      'autorizationToken' => 'AutorizationToken',
      'clientid' => 'Client_id',
      'clientsecret' => 'Client_secret',
      'licenciamento' => 'License',
      'embedParamCheck' => 'Embed Parameters Check',
      'iframerate' => 'Iframe Rate',
      'insertText' => 'Insert Text',
      'pbixLink' => 'Download PBI',
      'pdfLink' => 'Download PDF',
      'ratio' => 'Aspect Ratio'
    ],
    'links' => [
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Analytics' => 'Vytvořit Analytics'
    ],
    'options' => [
      'urlExterna' => [
        'Sim' => '1',
        'Não' => '0',
        0 => 'Não',
        1 => 'Yes'
      ]
    ]
  ],
  'Api' => [
    'fields' => [
      'url' => 'Url'
    ],
    'links' => [],
    'labels' => [
      'Create Api' => 'Vytvořit Api'
    ]
  ],
  'Assessment' => [
    'fields' => [
      'url' => 'Url',
      'comments' => 'Comentarios',
      'description' => 'Descripción'
    ],
    'links' => [],
    'labels' => [
      'Create Assessment' => 'Crear Evaluación'
    ]
  ],
  'CDashboardAccess' => [
    'fields' => [
      'accessTime' => 'Access Time',
      'tabName' => 'Tab Name'
    ],
    'links' => [],
    'labels' => [
      'Create CDashboardAccess' => 'Crear Dashboard Access'
    ]
  ],
  'CImporter' => [
    'fields' => [
      'inputFile' => 'Upload Document',
      'type' => 'Cloud',
      'status' => 'Status',
      'outputFile' => 'Output file',
      'templateURL' => 'Download Template',
      'country' => 'País',
      'endDate' => 'End Date',
      'startDate' => 'Start Date',
      'templateURLmexico' => 'Download Template',
      'productType' => 'Tipo'
    ],
    'links' => [],
    'labels' => [
      'Create CImporter' => 'Crear Importador'
    ],
    'options' => [
      'type' => [
        '' => 'Select',
        'Requests' => 'Requests',
        'Microsoft' => 'Microsoft',
        'AWS' => 'AWS',
        'Google' => 'Google'
      ],
      'status' => [
        'Created' => 'Created',
        'Processing' => 'Processing',
        'Done' => 'Done',
        'Error' => 'Error'
      ],
      'country' => [],
      'productType' => [
        '' => 'Select',
        'Azure Plan' => 'Azure Plan',
        'Reserved Instance' => 'Reserved Instance'
      ]
    ],
    'tooltips' => [
      'inputFile' => 'Download the template above, enter the markup data for the specified period, and upload the file.',
      'startDate' => 'The system only supports 1 Markup per month for each subscription. Ex: 01/08/2025 - 31/08/2025',
      'templateURL' => 'Download the template, enter the markup data for the specified period, and upload the file below.',
      'templateURLmexico' => 'Download the template, enter the markup data for the specified period, and upload the file below.'
    ]
  ],
  'CPatchNotes' => [
    'fields' => [
      'attachment' => 'Attachment',
      'buttonText' => 'Button text',
      'displayModal' => 'Display Modal',
      'modalLink' => 'Modal link',
      'modaltext' => 'Modal text',
      'productBrands' => 'Product Brands',
      'releasedate' => 'Release Date',
      'titleText' => 'Title text',
      'updateType' => 'Type',
      'updatestatus' => 'Status',
      'updatetype' => 'Type of Update',
      'version' => 'Version'
    ],
    'links' => [
      'productBrands' => 'Product Brands'
    ],
    'labels' => [
      'Create CPatchNotes' => 'Crear Patch Notes'
    ],
    'options' => [
      'updateType' => [
        '' => '',
        'Aviso' => 'Notice',
        'Atualização Disponível' => 'Update Available',
        'Manutenção Programada' => 'Scheduled maintenance'
      ],
      'updatestatus' => [
        'Planned' => 'Planned',
        'In Progress' => 'In Progress',
        'Released' => 'Implemented'
      ],
      'updatetype' => [
        '' => '',
        'New Feature' => 'New Feature',
        'Improvements' => 'Improvements',
        'Bug Fixes' => 'Bug Fixes',
        'Minor Changes' => 'Minor Changes',
        'Migration' => 'Migration'
      ]
    ]
  ],
  'CRecommendations' => [
    'fields' => [
      'pillars' => 'Pillars',
      'recommendedAction' => 'Recommended Action',
      'recommendationsConfig' => 'Request',
      'account' => 'Account',
      'subscriptionID' => 'Subscription ID'
    ],
    'links' => [
      'recommendationsConfig' => 'Request',
      'account' => 'Account'
    ],
    'labels' => [
      'Create CRecommendations' => 'Crear Recomendações'
    ],
    'options' => [
      'pillars' => []
    ]
  ],
  'CRecommendationsConfig' => [
    'fields' => [
      'mpnID' => 'Tier 2 MPN ID',
      'tenantID' => 'Customer Tenant ID',
      'pillars' => 'Pillars',
      'account' => 'Account',
      'recommendations' => 'Recommendations'
    ],
    'links' => [
      'account' => 'Account',
      'recommendations' => 'Recommendations'
    ],
    'labels' => [
      'Create CRecommendationsConfig' => 'Crear Configurar Recomendações'
    ],
    'options' => [
      'pillars' => [
        'Security' => 'Security',
        'Performance' => 'Perfomance',
        'Cost' => 'Cost'
      ]
    ],
    'tooltips' => [
      'pillars' => 'Select the pillars you want to prioritize in your cloud consumption analysis: Security, Performance and Cost.'
    ]
  ],
  'CRegistration' => [
    'fields' => [
      'address' => 'Dirección',
      'mpnID' => 'Tier 2 MPN ID',
      'tenantID' => 'Customer Tenant ID',
      'subscriptionID' => 'Subscription ID',
      'type' => 'Type',
      'resellerName' => 'Reseller Name',
      'customerName' => 'End Customer Name',
      'country' => 'Country',
      'logo' => 'Logo',
      'status' => 'Status',
      'resellerRegistered' => 'Reseller',
      'customerRegistered' => 'End Customer',
      'contactRegistered' => 'Contact',
      'portalUser' => 'Portal User',
      'approved' => 'Approved',
      'portalLink' => 'Portal Link',
      'cloud' => 'Cloud',
      'name' => 'User Name',
      'isActive' => 'Is Active'
    ],
    'links' => [
      'meetings' => 'Reuniones',
      'calls' => 'Llamadas',
      'tasks' => 'Tareas',
      'resellerRegistered' => 'Reseller',
      'customerRegistered' => 'End Customer',
      'contactRegistered' => 'Contact',
      'portalUser' => 'Portal user',
      'logo' => 'Logo'
    ],
    'labels' => [
      'Create CRegistration' => 'Crear Cadastro'
    ],
    'options' => [
      'type' => [
        '' => '',
        'Reseller' => 'Reseller',
        'Customer' => 'End Customer'
      ],
      'country' => [],
      'status' => [
        'Created' => 'Requested',
        'Approval' => 'Waiting for Approval',
        'Pending' => 'Waiting for Release',
        'Done' => 'Access to the Portal Released',
        'Canceled' => 'Canceled',
        'Blocked' => 'Existing Portal User',
        'Approved' => 'Approved'
      ],
      'cloud' => [
        'Microsoft' => 'Microsoft'
      ]
    ],
    'tooltips' => [
      'logo' => 'Upload the image in png format'
    ]
  ],
  'CSecurityAlertSettings' => [
    'fields' => [
      'analysisDays' => 'AnalysisDays',
      'alerts' => 'Alerts',
      'currentDescription' => 'Opção mês corrente',
      'lastDescription' => 'Opção mês anterior'
    ],
    'links' => [],
    'labels' => [
      'Create CSecurityAlertSettings' => 'Crear SecurityAlertSetting'
    ],
    'tooltips' => [
      'analysisDays' => 'This value determines the analysis window for detecting consumption anomalies. The calculation uses the current day minus the number in this field.'
    ],
    'options' => [
      'alerts' => [
        'currentMonth' => 'Variação sobre mês corrente',
        'lastMonth' => 'Variação sobre mês anterior '
      ]
    ]
  ],
  'CspUsage' => [
    'fields' => [
      'contact' => 'Contact',
      'netValue' => 'NetValue',
      'netValueCurrency' => 'NetValue (Currency)',
      'netValueConverted' => 'NetValue (Converted)'
    ],
    'links' => [
      'contact' => 'Contact'
    ],
    'labels' => [
      'Create CspUsage' => 'Crear CspUsage'
    ]
  ],
  'Monitoring' => [
    'fields' => [
      'type' => 'Tipo',
      'netValue' => 'NetValue',
      'netValueCurrency' => 'NetValue (moeda)',
      'netValueConverted' => 'NetValue (convertido)',
      'contact' => 'Contact',
      'reportCategory' => 'ReportCategory',
      'resourceSubCategory' => 'ResourceSubCategory',
      'resourceGroup' => 'ResourceGroup',
      'resourceCategory' => 'ResourceCategory',
      'resourceCategories' => 'Categorías de Recursos',
      'resourceGroups' => 'Grupos de Recursos',
      'resourceSubCategories' => 'ResourceSubCategories',
      'account' => 'Empresa',
      'subscriptions' => 'Suscripciones',
      'alerts' => 'Alertas',
      'contacts' => 'Responsable (para ser notificado)',
      'tags' => 'Etiquetas',
      'description' => 'Descripción',
      'modifiedAt' => 'Modificado en'
    ],
    'links' => [
      'contact' => 'Contact',
      'reportCategory' => 'ReportCategory',
      'resourceSubCategory' => 'ResourceSubCategory',
      'resourceGroup' => 'ResourceGroup',
      'resourceCategory' => 'ResourceCategory',
      'resourceCategories' => 'Categorías de Recursos',
      'resourceGroups' => 'Grupos de Recursos',
      'resourceSubCategories' => 'ResourceSubCategories',
      'account' => 'Empresa',
      'subscriptions' => 'Suscripciones',
      'contacts' => 'Responsable (para ser notificado)',
      'tags' => 'Etiquetas'
    ],
    'labels' => [
      'Create Monitoring' => 'Crear monitoreo'
    ],
    'options' => [
      'type' => [
        'ResourceGroup' => 'ResourceGroup',
        'ResourceSubCategory' => 'ResourceSubCategory',
        'ResourceCategory' => 'ResourceCategory',
        'Tags' => 'Tags',
        'Subscription' => 'Subscription',
        'Select' => 'Select'
      ],
      'alerts' => [
        '50%' => '50%',
        '75%' => '75%',
        '90%' => '90%',
        '100%' => '100%',
        '10%' => '10%',
        '20%' => '20%',
        '30%' => '30%',
        '40%' => '40%',
        '60%' => '60%',
        '70%' => '70%',
        '80%' => '80%',
        '85%' => '85%',
        '95%' => '95%'
      ]
    ],
    'tooltips' => [
      'netValue' => 'Ingrese el valor de referencia a ser monitoreado. Cuando este valor se acerca o se alcanza, se enviará una alerta al contacto responsable.',
      'type' => 'Enter the alert type. This information facilitates viewing reports.',
      'resourceGroups' => 'Select here the names of the resource groups to be monitored. If any of these resource groups reach the consumption specified in NetValue, a message will be sent to the alert creator.',
      'alerts' => 'Seleccione el porcentaje de aproximación del consumo que desea recibir alertas.',
      'contacts' => 'Seleccione un contacto para recibir notificaciones.',
      'name' => 'Ingrese el nombre del monitoreo. Ejemplo: Alerta $ 400.',
      'modifiedAt' => 'Fecha de última modificación'
    ]
  ],
  'OrderManager' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create OrderManager' => 'Crear Order Manager'
    ]
  ],
  'PartnerID' => [
    'fields' => [
      'token' => 'Token',
      'partnerID' => 'Partner ID',
      'type' => 'Tipo'
    ],
    'links' => [],
    'labels' => [
      'Create PartnerID' => 'Vytvořit Partner ID'
    ],
    'options' => [
      'type' => [
        'Revenda' => 'Revenda',
        'Cliente Final' => 'Cliente Final',
        'Selecione' => 'Selecione'
      ]
    ]
  ],
  'QnA' => [
    'fields' => [
      'url' => 'Url',
      'description' => 'Descripción'
    ],
    'links' => [],
    'labels' => [
      'Create QnA' => 'Crear QnA'
    ]
  ],
  'Recommendation' => [
    'fields' => [
      'enubeAzureRecomendationId' => 'Enube ID de recomendación de Azure',
      'resourceURI' => 'URI do recurso',
      'type' => 'Tipo',
      'scope' => 'Alcance',
      'category' => 'Categoría',
      'impactedField' => 'Campo impactado',
      'impactedValue' => 'Valor impactado',
      'savingsCurrency' => 'Moneda de ahorro',
      'lastUpdated' => 'Última actualización',
      'annualSavingAmount' => 'Cantidad de ahorro anual',
      'recommendationTypeId' => 'ID de tipo de recomendación',
      'savingsAmount' => 'Cantidad de ahorro',
      'problem' => 'Problema',
      'reservationType' => 'Tipo de reserva',
      'solution' => 'Solución',
      'location' => 'Ubicación',
      'vmSize' => 'VmSize',
      'targetResourceCount' => 'Recuento de recursos objetivo',
      'savingsPercentage' => 'PPorcentaje de ahorro',
      'term' => 'Condiciones',
      'impact' => 'Impacto',
      'risk' => 'Riesgo',
      'contact' => 'Contacto',
      'account' => 'Empresa',
      'advisor' => 'Advisor'
    ],
    'links' => [
      'contact' => 'contacto',
      'account' => 'Empresa'
    ],
    'labels' => [
      'Create Recommendation' => 'Crear recomendación'
    ],
    'options' => [
      'impact' => [
        'Low' => 'Bajo',
        'Medium' => 'Medio',
        'High' => 'Alto'
      ],
      'risk' => [
        'None' => 'Ninguno',
        'Error' => 'Error',
        'Warning' => 'Advertencia'
      ]
    ]
  ],
  'ResourceCategory' => [
    'fields' => [
      'subscriptions' => 'Suscripciones',
      'netValue' => 'NetValue (Actual)',
      'netValueCurrency' => 'NetValue (Moneda)',
      'netValueConverted' => 'NetValue (Convertido)',
      'contact' => 'Responsable (para ser notificado)',
      'resourceSubCategories' => 'Subcategorías de recursos',
      'resourceGroups' => 'Grupos de Recursos',
      'monitorings' => 'Monitoreos',
      'monitorings1' => 'Monitoreos1',
      'monitoring' => 'Alerta',
      'account' => 'Empresa',
      'contacts' => 'Responsable (para ser notificado)',
      'description' => 'Descripción'
    ],
    'links' => [
      'subscriptions' => 'Suscripciones',
      'contact' => 'Responsable (para ser notificado)',
      'resourceSubCategories' => 'Subcategorías de recursos',
      'resourceGroups' => 'rupos de Recursos',
      'monitorings' => 'Monitoreos',
      'monitorings1' => 'Monitoreos1',
      'monitoring' => 'Alerta',
      'account' => 'Empresa',
      'contacts' => 'Responsable (para ser notificado)'
    ],
    'labels' => [
      'Create ResourceCategory' => 'Crear Categoría de Recurso'
    ],
    'tooltips' => [
      'contacts' => 'Por favor, elija el responsable para recibir las alertas de su monitoreo.',
      'netValue' => 'Valor de consumo actual de su categoría de recurso',
      'monitoring' => 'Seleccione una alerta de monitoreo o cree una nueva.',
      'modifiedAt' => 'Last Modified Date'
    ]
  ],
  'ResourceGroup' => [
    'fields' => [
      'subscriptions' => 'Subscriptions',
      'netValue' => 'NetValue (actual)',
      'netValueCurrency' => 'NetValue (Currency)',
      'netValueConverted' => 'NetValue (Converted)',
      'resourceSubCategories' => 'ResourceSubCategories',
      'contact' => 'Contact',
      'monitorings' => 'Monitorings',
      'monitoring' => 'Alerta',
      'account' => 'Account',
      'contacts' => 'Owner',
      'responsible' => 'Responsable (para ser notificado)',
      'modifiedAt' => 'Modificado en',
      'modifiedBy' => 'Modificado por'
    ],
    'links' => [
      'subscriptions' => 'Subscriptions',
      'resourceCategories' => 'ResourceCategories',
      'resourceSubCategories' => 'ResourceSubCategories',
      'contact' => 'Contact',
      'monitorings' => 'Monitorings',
      'monitoring' => 'Monitoring',
      'account' => 'Account',
      'contacts' => 'Owner (to be notified)',
      'responsible' => 'Contacts1'
    ],
    'labels' => [
      'Create ResourceGroup' => 'Crear Grupo de Recursos'
    ],
    'tooltips' => [
      'netValue' => 'Valor de consumo actual del grupo de recursos',
      'contacts' => 'Please, choose the owner to receive the alerts of your monitoring.',
      'responsible' => 'Por favor, elija el responsable para recibir las alertas de su monitoreo.',
      'monitoring' => 'Seleccione una alerta de monitoreo o cree una nueva.',
      'name' => 'Nombre de su grupo de recursos',
      'modifiedAt' => 'Fecha de la última modificación.'
    ]
  ],
  'Rocket' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Rocket' => 'Vytvořit Rocket'
    ]
  ],
  'Subscriptions' => [
    'fields' => [
      'contacts' => 'Contactos',
      'monitoring' => 'Alerta',
      'subscriptionId' => 'ID de Suscripción',
      'netValue' => 'NetValue (actual)',
      'netValueCurrency' => 'Valor líquido (Moneda)',
      'netValueConverted' => 'NetValue (Convertido)',
      'account' => 'Empresa',
      'responsible' => 'Responsable (para ser notificado)',
      'margin' => 'Margem',
      'modifiedAt' => 'Modificado en',
      'modifiedBy' => 'Modificado por'
    ],
    'links' => [
      'contacts' => 'Contactos',
      'monitoring' => 'Alerta',
      'account' => 'Empresa',
      'responsible' => 'Responsible (to be notified)'
    ],
    'labels' => [
      'Create Subscriptions' => 'Crear Suscripciones'
    ],
    'tooltips' => [
      'netValue' => 'Cantidad de consumo actual de su suscripción',
      'subscriptionId' => 'ID de Suscripción',
      'responsible' => 'Por favor, elija el responsable para recibir las alertas de su monitoreo.',
      'name' => 'Nombre descriptivo de la suscripción',
      'monitoring' => 'Seleccione una alerta de monitoreo o cree una nueva.',
      'modifiedAt' => 'Fecha de última modificación'
    ]
  ],
  'Tags' => [
    'fields' => [
      'netValue' => 'NetValue (Actual)',
      'netValueCurrency' => 'NetValue (moneda)',
      'netValueConverted' => 'NetValue (convertido)',
      'account' => 'Cuenta',
      'contact' => 'Responsable (para ser notificado)',
      'monitoring' => 'Alerta',
      'contacts' => 'Responsable (para ser notificado)',
      'description' => 'Descripción'
    ],
    'links' => [
      'account' => 'Cuenta',
      'contact' => 'Responsable (para ser notificado)',
      'monitoring' => 'Alerta',
      'contacts' => 'Responsable (para ser notificado)'
    ],
    'labels' => [
      'Create Tags' => 'Crear Etiqueta'
    ],
    'tooltips' => [
      'contacts' => 'Elija el responsable para recibir las alertas de su monitoreo.',
      'netValue' => 'Valor actual de consumo de su etiqueta',
      'monitoring' => 'Seleccione una alerta de monitoreo o cree una nueva.',
      'name' => 'Nombre de su etiqueta',
      'contact' => 'Elija el responsable para recibir las alertas de su monitoreo.'
    ]
  ],
  'Tutorial' => [
    'fields' => [
      'thumbnail' => 'Thumbnail',
      'embeddedUrl' => 'Embedded url'
    ],
    'links' => [],
    'labels' => [
      'Create Tutorial' => 'Vytvořit Tutorial'
    ]
  ]
];
