<?php

use Espo\Core\InjectableFactory;
use Espo\Modules\EblaForm\Services\EblaForm;

class AfterInstall
{
    protected $container;

    public function run($container)
    {
        $this->container = $container;

        $this->clearCache();

        /* @var InjectableFactory $injectableFactory */
        $injectableFactory = $this->container->get('injectableFactory');
        $injectableFactory->create(EblaForm::class)->eblaFormJob(null);
    }

    protected function clearCache()
    {
        try {
            $this->container->get('dataManager')->clearCache();
        } catch (\Exception $e) {
        }
    }
}
