<?php

declare(strict_types=1);

namespace PackageVersions;

use Composer\InstalledVersions;
use OutOfBoundsException;

class_exists(InstalledVersions::class);

/**
 * This class is generated by composer/package-versions-deprecated, specifically by
 * @see \PackageVersions\Installer
 *
 * This file is overwritten at every run of `composer install` or `composer update`.
 *
 * @deprecated in favor of the Composer\InstalledVersions class provided by Composer 2. Require composer-runtime-api:^2 to ensure it is present.
 */
final class Versions
{
    /**
     * @deprecated please use {@see self::rootPackageName()} instead.
     *             This constant will be removed in version 2.0.0.
     */
    const ROOT_PACKAGE_NAME = 'espocrm/espocrm';

    /**
     * Array of all available composer packages.
     * Dont read this array from your calling code, but use the \PackageVersions\Versions::getVersion() method instead.
     *
     * @var array<string, string>
     * @internal
     */
    const VERSIONS          = array (
  'async-aws/core' => '1.9.1@7c623f72aba439d514742c1476a803c7b4311cc8',
  'async-aws/s3' => '1.8.0@6da98edfe96fa4777d3a5eb2c95ec19ef0d6376c',
  'cboden/ratchet' => 'v0.4.1@0d31f3a8ad4795fd48397712709e55cd07f51360',
  'composer/package-versions-deprecated' => '1.11.99.1@7413f0b55a051e89485c5cb9f765fe24bb02a7b6',
  'composer/semver' => '3.0.0@3426bd5efa8a12d230824536c42a8a4ad30b7940',
  'container-interop/container-interop' => '1.2.0@79cbf1341c22ec75643d841642dd5d6acd83bdb8',
  'doctrine/cache' => '1.10.2@13e3381b25847283a91948d04640543941309727',
  'doctrine/dbal' => '3.0.0@ee6d1260d5cc20ec506455a585945d7bdb98662c',
  'doctrine/event-manager' => '1.1.1@41370af6a30faa9dc0368c4a6814d596e81aba7f',
  'dragonmantank/cron-expression' => 'v3.0.2@48212cdc0a79051d50d7fc2f0645c5a321caf926',
  'evenement/evenement' => 'v3.0.1@531bfb9d15f8aa57454f5f0285b18bec903b8fb7',
  'ezyang/htmlpurifier' => 'v4.13.0@08e27c97e4c6ed02f37c5b2b20488046c8d90d75',
  'fig/http-message-util' => '1.1.5@9d94dc0154230ac39e5bf89398b324a86f63f765',
  'guzzlehttp/psr7' => '1.6.1@239400de7a173fe9901b9ac7c06497751f00727a',
  'johngrogg/ics-parser' => 'v3.0.0@c74f5881198760386f243d6b1e090e54952ac825',
  'laminas/laminas-ldap' => '2.11.0@c1370452cd6548e103fb181d8e6e1fca9954dba4',
  'laminas/laminas-loader' => '2.7.0@bcf8a566cb9925a2e7cc41a16db09235ec9fb616',
  'laminas/laminas-mail' => '2.14.1@180c6c7baa37cba16fe9fd34af0f346e796cf1a1',
  'laminas/laminas-mime' => '2.8.0@9a59704f33106427a384d0ae421f96043174093a',
  'laminas/laminas-servicemanager' => '3.6.4@b1445e1a7077c21b0fad0974a1b7a11b9dbe0828',
  'laminas/laminas-stdlib' => '3.3.1@d81c7ffe602ed0e6ecb18691019111c0f4bf1efe',
  'laminas/laminas-validator' => '2.14.4@e370c4695db1c81e6dfad38d8c4dbdb37b23d776',
  'laminas/laminas-zendframework-bridge' => '1.1.1@6ede70583e101030bcace4dcddd648f760ddf642',
  'league/flysystem' => '2.1.1@a3c694de9f7e844b76f9d1b61296ebf6e8d89d74',
  'league/flysystem-async-aws-s3' => '2.0.4@2a2e566cf1dae8e0ebfca49c6eda8050935d1c0d',
  'league/mime-type-detection' => '1.7.0@3b9dff8aaf7323590c1d2e443db701eb1f9aa0d3',
  'maennchen/zipstream-php' => '2.1.0@c4c5803cc1f93df3d2448478ef79394a5981cc58',
  'markbaker/complex' => '2.0.0@9999f1432fae467bc93c53f357105b4c31bb994c',
  'markbaker/matrix' => '2.1.2@361c0f545c3172ee26c3d596a0aa03f0cef65e6a',
  'michelf/php-markdown' => '1.9.0@c83178d49e372ca967d1a8c77ae4e051b3a3c75c',
  'monolog/monolog' => '2.1.1@f9eee5cec93dfb313a38b6b288741e84e53f02d5',
  'myclabs/php-enum' => '1.7.7@d178027d1e679832db9f38248fcc7200647dc2b7',
  'nesbot/carbon' => '2.26.0@e01ecc0b71168febb52ae1fdc1cfcc95428e604e',
  'nikic/fast-route' => 'v1.3.0@181d480e08d9476e61381e04a71b34dc0432e812',
  'opis/closure' => '3.6.1@943b5d70cc5ae7483f6aff6ff43d7e34592ca0f5',
  'phpoffice/phpspreadsheet' => '1.16.0@76d4323b85129d0c368149c831a07a3e258b2b50',
  'psr/cache' => '1.0.1@d11b50ad223250cf17b86e38383413f5a6764bf8',
  'psr/container' => '1.0.0@b7ce3b176482dbbc1245ebf52b181af44c2cf55f',
  'psr/http-client' => '1.0.1@2dfb5f6c5eff0e91e20e913f8c5452ed95b86621',
  'psr/http-factory' => '1.0.1@12ac7fcd07e5b077433f5f2bee95b3a771bf61be',
  'psr/http-message' => '1.0.1@f6561bf28d520154e4b0ec72be95418abe6d9363',
  'psr/http-server-handler' => '1.0.1@aff2f80e33b7f026ec96bb42f63242dc50ffcae7',
  'psr/http-server-middleware' => '1.0.1@2296f45510945530b9dceb8bcedb5cb84d40c5f5',
  'psr/log' => '1.1.3@0f73288fd15629204f9d42b7055f72dacbe811fc',
  'psr/simple-cache' => '1.0.1@408d5eafb83c57f6365a3ca330ff23aa4a5fa39b',
  'ralouphie/getallheaders' => '3.0.3@120b605dfeb996808c31b6477290a714d356e822',
  'ratchet/rfc6455' => '0.2.4@1612f528c3496ad06e910d0f8b6f16ab97696706',
  'react/cache' => 'v0.5.0@7d7da7fb7574d471904ba357b39bbf110ccdbf66',
  'react/dns' => 'v0.4.16@0a0bedfec72b38406413c6ea01e1c015bd0bf72b',
  'react/event-loop' => 'v1.0.0@0266aff7aa7b0613b1f38a723e14a0ebc55cfca3',
  'react/promise' => 'v2.7.1@31ffa96f8d2ed0341a57848cbb84d88b89dd664d',
  'react/promise-timer' => 'v1.5.0@a11206938ca2394dc7bb368f5da25cd4533fa603',
  'react/socket' => 'v1.2.0@23b7372bb25cea934f6124f5bdac34e30161959e',
  'react/stream' => 'v1.1.0@50426855f7a77ddf43b9266c22320df5bf6c6ce6',
  'react/zmq' => 'v0.4.0@13dec0bd2397adcc5d6aa54c8d7f0982fba66f39',
  'robthree/twofactorauth' => '1.6.7@3407c33775391fa8c36f7d766f26c5e59a736374',
  'slim/psr7' => '1.4@0dca983ca32a26f4a91fb11173b7b9eaee29e9d6',
  'slim/slim' => '4.7.1@0905e0775f8c1cfb3bbcfabeb6588dcfd8b82d3f',
  'spatie/async' => '1.5.3@d371b76ff876530c4906596490fd977720477e48',
  'symfony/deprecation-contracts' => 'v2.2.0@5fa56b4074d1ae755beb55617ddafe6f5d78f665',
  'symfony/http-client' => 'v5.2.3@22cb1a7844fff206cc5186409776e78865405ea5',
  'symfony/http-client-contracts' => 'v2.3.1@41db680a15018f9c1d4b23516059633ce280ca33',
  'symfony/http-foundation' => 'v4.4.25@0c79d5a65ace4fe66e49702658c024a419d2438b',
  'symfony/mime' => 'v5.3.0@ed710d297b181f6a7194d8172c9c2423d58e4852',
  'symfony/polyfill-iconv' => 'v1.20.0@c536646fdb4f29104dd26effc2fdcb9a5b085024',
  'symfony/polyfill-intl-idn' => 'v1.13.1@6f9c239e61e1b0c9229a28ff89a812dc449c3d46',
  'symfony/polyfill-mbstring' => 'v1.20.0@39d483bdf39be819deabf04ec872eb0b2410b531',
  'symfony/polyfill-php72' => 'v1.13.1@66fea50f6cb37a35eea048d75a7d99a45b586038',
  'symfony/polyfill-php73' => 'v1.22.1@a678b42e92f86eca04b7fa4c0f6f19d097fb69e2',
  'symfony/polyfill-php80' => 'v1.22.1@dc3063ba22c2a1fd2f45ed856374d79114998f91',
  'symfony/process' => 'v4.4.25@cd61e6dd273975c6625316de9d141ebd197f93c9',
  'symfony/routing' => 'v3.2.14@b382d7c4f443372c118efcd0cd2bf1028434f2f5',
  'symfony/service-contracts' => 'v2.2.0@d15da7ba4957ffb8f1747218be9e1a121fd298a1',
  'symfony/translation' => 'v4.4.25@dfe132c5c6d89f90ce7f961742cc532e9ca16dd4',
  'symfony/translation-contracts' => 'v2.4.0@95c812666f3e91db75385749fe219c5e494c7f95',
  'tecnickcom/tcpdf' => '6.3.5@19a535eaa7fb1c1cac499109deeb1a7a201b4549',
  'true/punycode' => 'v2.1.1@a4d0c11a36dd7f4e7cd7096076cab6d3378a071e',
  'yzalis/identicon' => '1.1.0@a99fc2a3d018512f7914bc6f972952536c0f309b',
  'zbateson/mail-mime-parser' => '1.3.1@706964d904798b8c22d63f62f0ec5f5bc84e30d9',
  'zbateson/mb-wrapper' => '1.0.1@721b3dfbf7ab75fee5ac60a542d7923ffe59ef6d',
  'zbateson/stream-decorators' => '1.0.4@6f54738dfecc65e1d5bfb855035836748083a6dd',
  'zordius/lightncandy' => 'dev-espo@207d424c4ced34644663fdc0758c19d5b6974adc',
  'espocrm/espocrm' => 'dev-master@216e1061d27385843da4b9fb0f8920d7618b705e',
);

    private function __construct()
    {
    }

    /**
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function rootPackageName() : string
    {
        if (!class_exists(InstalledVersions::class, false) || !InstalledVersions::getRawData()) {
            return self::ROOT_PACKAGE_NAME;
        }

        return InstalledVersions::getRootPackage()['name'];
    }

    /**
     * @throws OutOfBoundsException If a version cannot be located.
     *
     * @psalm-param key-of<self::VERSIONS> $packageName
     * @psalm-pure
     *
     * @psalm-suppress ImpureMethodCall we know that {@see InstalledVersions} interaction does not
     *                                  cause any side effects here.
     */
    public static function getVersion(string $packageName): string
    {
        if (class_exists(InstalledVersions::class, false) && InstalledVersions::getRawData()) {
            return InstalledVersions::getPrettyVersion($packageName)
                . '@' . InstalledVersions::getReference($packageName);
        }

        if (isset(self::VERSIONS[$packageName])) {
            return self::VERSIONS[$packageName];
        }

        throw new OutOfBoundsException(
            'Required package "' . $packageName . '" is not installed: check your ./vendor/composer/installed.json and/or ./composer.lock files'
        );
    }
}
