<?php
return [
  0 => [
    'route' => 'ProjectColumn/:id/moveUp',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Column\\Api\\PostMoveUp',
    'adjustedRoute' => '/ProjectColumn/{id}/moveUp'
  ],
  1 => [
    'route' => 'ProjectColumn/:id/moveDown',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Column\\Api\\PostMoveDown',
    'adjustedRoute' => '/ProjectColumn/{id}/moveDown'
  ],
  2 => [
    'route' => 'Project/:id/plan',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetPlan',
    'adjustedRoute' => '/Project/{id}/plan'
  ],
  3 => [
    'route' => 'Project/:id/gantt',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGantt',
    'adjustedRoute' => '/Project/{id}/gantt'
  ],
  4 => [
    'route' => 'Project/:id/ganttNonWorkingRanges',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGanttNonWorkingRanges',
    'adjustedRoute' => '/Project/{id}/ganttNonWorkingRanges'
  ],
  5 => [
    'route' => 'ProjectGroup/:id/ganttTasks',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGroupGanttTasks',
    'adjustedRoute' => '/ProjectGroup/{id}/ganttTasks'
  ],
  6 => [
    'route' => 'ProjectGroup/:id/board',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGroupBoard',
    'adjustedRoute' => '/ProjectGroup/{id}/board'
  ],
  7 => [
    'route' => 'ProjectGroup/:id/boardOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostGroupBoardOrder',
    'adjustedRoute' => '/ProjectGroup/{id}/boardOrder'
  ],
  8 => [
    'route' => 'ProjectGroup/:id/tasks',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostGroupTasks',
    'adjustedRoute' => '/ProjectGroup/{id}/tasks'
  ],
  9 => [
    'route' => 'ProjectGroup/:id/taskReOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostTaskReOrder',
    'adjustedRoute' => '/ProjectGroup/{id}/taskReOrder'
  ],
  10 => [
    'route' => 'ProjectTask/:id/subTaskReOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostSubTaskReOrder',
    'adjustedRoute' => '/ProjectTask/{id}/subTaskReOrder'
  ],
  11 => [
    'route' => 'Project/:id/reorderGroups',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostReorderGroups',
    'adjustedRoute' => '/Project/{id}/reorderGroups'
  ],
  12 => [
    'route' => 'Project/:id/clone',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostClone',
    'adjustedRoute' => '/Project/{id}/clone'
  ],
  13 => [
    'route' => 'Project/:id/members',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostMembers',
    'adjustedRoute' => '/Project/{id}/members'
  ],
  14 => [
    'route' => 'ProjectTask/:id/complete',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostComplete',
    'adjustedRoute' => '/ProjectTask/{id}/complete'
  ],
  15 => [
    'route' => 'ProjectTask/:id/column',
    'method' => 'put',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PutColumn',
    'adjustedRoute' => '/ProjectTask/{id}/column'
  ],
  16 => [
    'route' => 'ProjectTask/:id/cancel',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostCancel',
    'adjustedRoute' => '/ProjectTask/{id}/cancel'
  ],
  17 => [
    'route' => 'ProjectTask/:id/moveInGroup',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostMoveInGroup',
    'adjustedRoute' => '/ProjectTask/{id}/moveInGroup'
  ],
  18 => [
    'route' => 'Product/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/Product/{id}/warehousesQuantity'
  ],
  19 => [
    'route' => 'InventoryNumber/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/InventoryNumber/{id}/warehousesQuantity'
  ],
  20 => [
    'route' => 'InventoryNumber/:id/history',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetHistory',
    'adjustedRoute' => '/InventoryNumber/{id}/history'
  ],
  21 => [
    'route' => 'Warehouse/:id/products',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetProducts',
    'adjustedRoute' => '/Warehouse/{id}/products'
  ],
  22 => [
    'route' => 'Warehouse/:id/inventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetInventoryNumbers',
    'adjustedRoute' => '/Warehouse/{id}/inventoryNumbers'
  ],
  23 => [
    'route' => 'ReceiptOrder/:id/importSerialNumbers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ReceiptOrder\\Api\\PostImportSerialNumbers',
    'adjustedRoute' => '/ReceiptOrder/{id}/importSerialNumbers'
  ],
  24 => [
    'route' => 'ProductAttribute/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMove',
    'adjustedRoute' => '/ProductAttribute/{id}/move/{type}'
  ],
  25 => [
    'route' => 'ProductAttributeOption/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMoveOption',
    'adjustedRoute' => '/ProductAttributeOption/{id}/move/{type}'
  ],
  26 => [
    'route' => 'ProductAttribute/options',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\GetOptions',
    'adjustedRoute' => '/ProductAttribute/options'
  ],
  27 => [
    'route' => 'Product/:id/generateVariants',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\PostGenerateVariants',
    'adjustedRoute' => '/Product/{id}/generateVariants'
  ],
  28 => [
    'route' => 'Product/:id/variantInventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetVariantInventoryNumbers',
    'adjustedRoute' => '/Product/{id}/variantInventoryNumbers'
  ],
  29 => [
    'route' => 'Product/:id/orderItems',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetOrderItems',
    'adjustedRoute' => '/Product/{id}/orderItems'
  ],
  30 => [
    'route' => 'DeliveryOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/lock'
  ],
  31 => [
    'route' => 'DeliveryOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/unlock'
  ],
  32 => [
    'route' => 'Invoice/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/lock'
  ],
  33 => [
    'route' => 'Invoice/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/unlock'
  ],
  34 => [
    'route' => 'Quote/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/lock'
  ],
  35 => [
    'route' => 'Quote/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/unlock'
  ],
  36 => [
    'route' => 'ReceiptOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/lock'
  ],
  37 => [
    'route' => 'ReceiptOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/unlock'
  ],
  38 => [
    'route' => 'ReturnOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/lock'
  ],
  39 => [
    'route' => 'ReturnOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/unlock'
  ],
  40 => [
    'route' => 'SalesOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/lock'
  ],
  41 => [
    'route' => 'SalesOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/unlock'
  ],
  42 => [
    'route' => 'TransferOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/lock'
  ],
  43 => [
    'route' => 'TransferOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/unlock'
  ],
  44 => [
    'route' => 'PurchaseOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/lock'
  ],
  45 => [
    'route' => 'PurchaseOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/unlock'
  ],
  46 => [
    'route' => 'InventoryAdjustment/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/lock'
  ],
  47 => [
    'route' => 'InventoryAdjustment/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/unlock'
  ],
  48 => [
    'route' => 'PriceRuleCondition/list',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\GetPriceRuleConditionList',
    'adjustedRoute' => '/PriceRuleCondition/list'
  ],
  49 => [
    'route' => 'ProductPrice/getSalesPrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetSalesPrice',
    'adjustedRoute' => '/ProductPrice/getSalesPrice'
  ],
  50 => [
    'route' => 'ProductPrice/getPurchasePrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetPurchasePrice',
    'adjustedRoute' => '/ProductPrice/getPurchasePrice'
  ],
  51 => [
    'route' => 'Invoice/:id/exportEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostExportEInvoice',
    'adjustedRoute' => '/Invoice/{id}/exportEInvoice'
  ],
  52 => [
    'route' => 'Invoice/:id/validateEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostValidateEInvoice',
    'adjustedRoute' => '/Invoice/{id}/validateEInvoice'
  ],
  53 => [
    'route' => 'RealEstateMatchingConfiguration',
    'method' => 'put',
    'params' => [
      'controller' => 'RealEstateMatchingConfiguration',
      'action' => 'update'
    ],
    'adjustedRoute' => '/RealEstateMatchingConfiguration'
  ],
  54 => [
    'route' => 'RealEstateProperty/:id/matchingRequests',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\RealEstate\\Tools\\Property\\Api\\GetMatchingRequests',
    'adjustedRoute' => '/RealEstateProperty/{id}/matchingRequests'
  ],
  55 => [
    'route' => 'RealEstateRequest/:id/matchingProperties',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\RealEstate\\Tools\\Request\\Api\\GetMatchingProperties',
    'adjustedRoute' => '/RealEstateRequest/{id}/matchingProperties'
  ],
  56 => [
    'route' => 'Report/runGridPreview',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Advanced\\Tools\\Report\\Api\\PostRunGridPreview',
    'adjustedRoute' => '/Report/runGridPreview'
  ],
  57 => [
    'route' => 'Report/runListPreview',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Advanced\\Tools\\Report\\Api\\GetRunListPreview',
    'adjustedRoute' => '/Report/runListPreview'
  ],
  58 => [
    'route' => '/Activities/:parentType/:id/composeEmailAddressList',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetComposeAddressList',
    'adjustedRoute' => '/Activities/{parentType}/{id}/composeEmailAddressList'
  ],
  59 => [
    'route' => '/Activities/:parentType/:id/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\Get',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}'
  ],
  60 => [
    'route' => '/Activities/:parentType/:id/:type/list/:targetType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetListTyped',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}/list/{targetType}'
  ],
  61 => [
    'route' => '/Activities/upcoming',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetUpcoming',
    'adjustedRoute' => '/Activities/upcoming'
  ],
  62 => [
    'route' => '/Activities',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetCalendar',
    'adjustedRoute' => '/Activities'
  ],
  63 => [
    'route' => '/Timeline',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetTimeline',
    'adjustedRoute' => '/Timeline'
  ],
  64 => [
    'route' => '/Timeline/busyRanges',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetBusyRanges',
    'adjustedRoute' => '/Timeline/busyRanges'
  ],
  65 => [
    'route' => '/Meeting/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Meeting',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Meeting/{id}/attendees'
  ],
  66 => [
    'route' => '/Call/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Call',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Call/{id}/attendees'
  ],
  67 => [
    'route' => '/Campaign/:id/generateMailMerge',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Campaign\\Api\\PostGenerateMailMerge',
    'adjustedRoute' => '/Campaign/{id}/generateMailMerge'
  ],
  68 => [
    'route' => '/TargetList/:id/optedOut',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\TargetList\\Api\\GetOptedOut',
    'adjustedRoute' => '/TargetList/{id}/optedOut'
  ],
  69 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  70 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  71 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  72 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  73 => [
    'route' => '/',
    'method' => 'get',
    'params' => [
      'controller' => 'ApiIndex',
      'action' => 'index'
    ],
    'adjustedRoute' => '/'
  ],
  74 => [
    'route' => '/App/user',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetUser',
    'adjustedRoute' => '/App/user'
  ],
  75 => [
    'route' => '/App/destroyAuthToken',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\PostDestroyAuthToken',
    'adjustedRoute' => '/App/destroyAuthToken'
  ],
  76 => [
    'route' => '/App/about',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetAbout',
    'adjustedRoute' => '/App/about'
  ],
  77 => [
    'route' => '/Metadata',
    'method' => 'get',
    'params' => [
      'controller' => 'Metadata'
    ],
    'adjustedRoute' => '/Metadata'
  ],
  78 => [
    'route' => '/I18n',
    'method' => 'get',
    'params' => [
      'controller' => 'I18n'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/I18n'
  ],
  79 => [
    'route' => '/Settings',
    'method' => 'get',
    'params' => [
      'controller' => 'Settings'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Settings'
  ],
  80 => [
    'route' => '/Settings',
    'method' => 'patch',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  81 => [
    'route' => '/Settings',
    'method' => 'put',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  82 => [
    'route' => '/Stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'scope' => 'User'
    ],
    'adjustedRoute' => '/Stream'
  ],
  83 => [
    'route' => '/GlobalStream',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetGlobal',
    'adjustedRoute' => '/GlobalStream'
  ],
  84 => [
    'route' => '/GlobalSearch',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\GlobalSearch\\Api\\Get',
    'adjustedRoute' => '/GlobalSearch'
  ],
  85 => [
    'route' => '/LeadCapture/form/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\LeadCapture\\Api\\PostForm',
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/form/{id}'
  ],
  86 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'post',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  87 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'options',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  88 => [
    'route' => '/:controller/action/:action',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  89 => [
    'route' => '/:controller/action/:action',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  90 => [
    'route' => '/:controller/action/:action',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  91 => [
    'route' => '/:controller/layout/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  92 => [
    'route' => '/:controller/layout/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  93 => [
    'route' => '/:controller/layout/:name/:setId',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}/{setId}'
  ],
  94 => [
    'route' => '/Admin/rebuild',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'rebuild'
    ],
    'adjustedRoute' => '/Admin/rebuild'
  ],
  95 => [
    'route' => '/Admin/clearCache',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'clearCache'
    ],
    'adjustedRoute' => '/Admin/clearCache'
  ],
  96 => [
    'route' => '/Admin/jobs',
    'method' => 'get',
    'params' => [
      'controller' => 'Admin',
      'action' => 'jobs'
    ],
    'adjustedRoute' => '/Admin/jobs'
  ],
  97 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'read',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  98 => [
    'route' => '/Admin/fieldManager/:scope',
    'method' => 'post',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'create',
      'scope' => ':scope'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}'
  ],
  99 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  100 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'patch',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  101 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'delete',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'delete',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  102 => [
    'route' => '/CurrencyRate',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\Get',
    'adjustedRoute' => '/CurrencyRate'
  ],
  103 => [
    'route' => '/CurrencyRate',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\PutUpdate',
    'adjustedRoute' => '/CurrencyRate'
  ],
  104 => [
    'route' => '/Action',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\Action\\Api\\PostProcess',
    'adjustedRoute' => '/Action'
  ],
  105 => [
    'route' => '/MassAction',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostProcess',
    'adjustedRoute' => '/MassAction'
  ],
  106 => [
    'route' => '/MassAction/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\GetStatus',
    'adjustedRoute' => '/MassAction/{id}/status'
  ],
  107 => [
    'route' => '/MassAction/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostSubscribe',
    'adjustedRoute' => '/MassAction/{id}/subscribe'
  ],
  108 => [
    'route' => '/Export',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostProcess',
    'adjustedRoute' => '/Export'
  ],
  109 => [
    'route' => '/Export/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\GetStatus',
    'adjustedRoute' => '/Export/{id}/status'
  ],
  110 => [
    'route' => '/Export/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostSubscribe',
    'adjustedRoute' => '/Export/{id}/subscribe'
  ],
  111 => [
    'route' => '/Import',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\Post',
    'adjustedRoute' => '/Import'
  ],
  112 => [
    'route' => '/Import/file',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostFile',
    'adjustedRoute' => '/Import/file'
  ],
  113 => [
    'route' => '/Import/:id/revert',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRevert',
    'adjustedRoute' => '/Import/{id}/revert'
  ],
  114 => [
    'route' => '/Import/:id/removeDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRemoveDuplicates',
    'adjustedRoute' => '/Import/{id}/removeDuplicates'
  ],
  115 => [
    'route' => '/Import/:id/unmarkDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostUnmarkDuplicates',
    'adjustedRoute' => '/Import/{id}/unmarkDuplicates'
  ],
  116 => [
    'route' => '/Import/:id/exportErrors',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostExportErrors',
    'adjustedRoute' => '/Import/{id}/exportErrors'
  ],
  117 => [
    'route' => '/Kanban/order',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\PutOrder',
    'adjustedRoute' => '/Kanban/order'
  ],
  118 => [
    'route' => '/Kanban/:entityType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\GetData',
    'adjustedRoute' => '/Kanban/{entityType}'
  ],
  119 => [
    'route' => '/Attachment/file/:id',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\GetFile',
    'adjustedRoute' => '/Attachment/file/{id}'
  ],
  120 => [
    'route' => '/Attachment/chunk/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostChunk',
    'adjustedRoute' => '/Attachment/chunk/{id}'
  ],
  121 => [
    'route' => '/Attachment/fromImageUrl',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostFromImageUrl',
    'adjustedRoute' => '/Attachment/fromImageUrl'
  ],
  122 => [
    'route' => '/Attachment/copy/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostCopy',
    'adjustedRoute' => '/Attachment/copy/{id}'
  ],
  123 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  124 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  125 => [
    'route' => '/Note/:id/reactors/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetNoteReactors',
    'adjustedRoute' => '/Note/{id}/reactors/{type}'
  ],
  126 => [
    'route' => '/EmailTemplate/:id/prepare',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\EmailTemplate\\Api\\PostPrepare',
    'adjustedRoute' => '/EmailTemplate/{id}/prepare'
  ],
  127 => [
    'route' => '/Email/:id/attachments/copy',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostAttachmentsCopy',
    'adjustedRoute' => '/Email/{id}/attachments/copy'
  ],
  128 => [
    'route' => '/Email/importEml',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostImportEml',
    'adjustedRoute' => '/Email/importEml'
  ],
  129 => [
    'route' => '/Email/sendTest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostSendTest',
    'adjustedRoute' => '/Email/sendTest'
  ],
  130 => [
    'route' => '/Email/inbox/read',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  131 => [
    'route' => '/Email/inbox/read',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  132 => [
    'route' => '/Email/inbox/important',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  133 => [
    'route' => '/Email/inbox/important',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  134 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  135 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  136 => [
    'route' => '/Email/inbox/folders/:folderId',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostFolder',
    'adjustedRoute' => '/Email/inbox/folders/{folderId}'
  ],
  137 => [
    'route' => '/Email/inbox/notReadCounts',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetNotReadCounts',
    'adjustedRoute' => '/Email/inbox/notReadCounts'
  ],
  138 => [
    'route' => '/Email/insertFieldData',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetInsertFieldData',
    'adjustedRoute' => '/Email/insertFieldData'
  ],
  139 => [
    'route' => '/Email/:id/users',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostUsers',
    'adjustedRoute' => '/Email/{id}/users'
  ],
  140 => [
    'route' => '/EmailAddress/search',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\EmailAddress\\Api\\GetSearch',
    'adjustedRoute' => '/EmailAddress/search'
  ],
  141 => [
    'route' => '/User/:id/stream/own',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetOwn',
    'adjustedRoute' => '/User/{id}/stream/own'
  ],
  142 => [
    'route' => '/User/:id/acl',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\GetUserAcl',
    'adjustedRoute' => '/User/{id}/acl'
  ],
  143 => [
    'route' => '/UserSecurity/apiKey/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostApiKeyGenerate',
    'adjustedRoute' => '/UserSecurity/apiKey/generate'
  ],
  144 => [
    'route' => '/UserSecurity/password',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PutPassword',
    'adjustedRoute' => '/UserSecurity/password'
  ],
  145 => [
    'route' => '/UserSecurity/password/recovery',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordRecovery',
    'adjustedRoute' => '/UserSecurity/password/recovery'
  ],
  146 => [
    'route' => '/UserSecurity/password/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordGenerate',
    'adjustedRoute' => '/UserSecurity/password/generate'
  ],
  147 => [
    'route' => '/User/passwordChangeRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordChangeRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/passwordChangeRequest'
  ],
  148 => [
    'route' => '/User/changePasswordByRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostChangePasswordByRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/changePasswordByRequest'
  ],
  149 => [
    'route' => '/Team/:id/userPosition',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PutTeamUserPosition',
    'adjustedRoute' => '/Team/{id}/userPosition'
  ],
  150 => [
    'route' => '/Oidc/authorizationData',
    'method' => 'get',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'authorizationData'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/authorizationData'
  ],
  151 => [
    'route' => '/Oidc/backchannelLogout',
    'method' => 'post',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'backchannelLogout'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/backchannelLogout'
  ],
  152 => [
    'method' => 'post',
    'route' => '/OAuth/:id/connection',
    'actionClassName' => 'Espo\\Tools\\OAuth\\Api\\PostConnection',
    'adjustedRoute' => '/OAuth/{id}/connection'
  ],
  153 => [
    'method' => 'delete',
    'route' => '/OAuth/:id/connection',
    'actionClassName' => 'Espo\\Tools\\OAuth\\Api\\DeleteConnection',
    'adjustedRoute' => '/OAuth/{id}/connection'
  ],
  154 => [
    'route' => '/:controller/:id',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'read',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  155 => [
    'route' => '/:controller',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'index'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  156 => [
    'route' => '/:controller',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'create'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  157 => [
    'route' => '/:controller/:id',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  158 => [
    'route' => '/:controller/:id',
    'method' => 'patch',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  159 => [
    'route' => '/:controller/:id',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'delete',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  160 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  161 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  162 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  163 => [
    'route' => '/:controller/:id/stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/stream'
  ],
  164 => [
    'route' => '/:controller/:id/posts',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listPosts',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/posts'
  ],
  165 => [
    'route' => '/:controller/:id/updateStream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listUpdates',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/updateStream'
  ],
  166 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'follow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  167 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'unfollow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  168 => [
    'route' => '/:entityType/:id/streamAttachments',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetStreamAttachments',
    'adjustedRoute' => '/{entityType}/{id}/streamAttachments'
  ],
  169 => [
    'route' => '/:Note/:id/pin',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  170 => [
    'route' => '/:Note/:id/pin',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  171 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\PutStar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  172 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\DeleteUnstar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  173 => [
    'route' => '/:entityType/:id/usersAccess',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PostRecordUsersAccess',
    'adjustedRoute' => '/{entityType}/{id}/usersAccess'
  ],
  174 => [
    'route' => '/:controller/:id/:link',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'listLinked',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  175 => [
    'route' => '/:controller/:id/:link',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'createLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  176 => [
    'route' => '/:controller/:id/:link',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'removeLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ]
];
