<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project;

use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectRole;

class MemberRole
{
    public function __construct(
        readonly public ?string $role,
        readonly public ProjectRole $record,
    ) {}

    public function getTaskCreate(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_YES;
        }

        return $this->record->getTaskCreate();
    }

    public function getTaskRead(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_ALL;
        }

        return $this->record->getTaskRead();
    }

    public function getTaskStream(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_ALL;
        }

        return $this->record->getTaskStream();
    }

    public function getTaskEdit(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_ALL;
        }

        return $this->record->getTaskEdit();
    }

    public function getTaskDelete(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_ALL;
        }

        return $this->record->getTaskDelete();
    }

    public function getTaskColumnEdit(): string
    {
        if (in_array($this->role, [Project::ROLE_OWNER, Project::ROLE_EDITOR])) {
            return ProjectRole::LEVEL_ALL;
        }

        return $this->record->getTaskColumnEdit();
    }
}
