<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Api;

use Espo\Core\Acl;
use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Exceptions\Forbidden;
use Espo\Core\Record\EntityProvider;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Tools\Project\MembersService;

class PostMembers implements Action
{
    public function __construct(
        private Acl $acl,
        private EntityProvider $entityProvider,
        private MembersService $service,
    ) {}

    /**
     * @inheritDoc
     */
    public function process(Request $request): Response
    {
        $id = $request->getRouteParam('id') ?? throw new BadRequest();
        $ids = $request->getParsedBody()->ids ?? null;
        $role = $request->getParsedBody()->role ?? null;

        if (!property_exists($request->getParsedBody(), 'role')) {
            throw new BadRequest("No 'role'");
        }

        if (!is_string($role) && $role !== null) {
            throw new BadRequest("Bad 'role'");
        }

        if (!is_array($ids)) {
            throw new BadRequest("No or bad 'ids'");
        }

        foreach ($ids as $itId) {
            if (!is_string($itId)) {
                throw new BadRequest("Bad 'ids'");
            }
        }

        if (!$this->acl->checkScope(Project::ENTITY_TYPE)) {
            throw new Forbidden("No access to Project scope.");
        }

        $project = $this->entityProvider->getByClass(Project::class, $id);

        if (!$this->acl->checkEntityEdit($project)) {
            throw new Forbidden("No 'edit' access.");
        }

        $this->service->link($project, $ids, $role);

        return ResponseComposer::json(true);
    }
}
