<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Api;

use Espo\Core\Api\Action;
use Espo\Core\Api\Request;
use Espo\Core\Api\Response;
use Espo\Core\Api\ResponseComposer;
use Espo\Core\Exceptions\BadRequest;
use Espo\Core\Record\EntityProvider;
use Espo\Core\Record\SearchParamsFetcher;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\Modules\Project\Tools\Board\Service;

/**
 * @noinspection PhpUnused
 */
class GetGroupBoard implements Action
{
    public function __construct(
        private EntityProvider $entityProvider,
        private Service $service,
        private SearchParamsFetcher $searchParamsFetcher,
    ) {}

    public function process(Request $request): Response
    {
        $id = $request->getRouteParam('id') ?? new BadRequest();
        $searchParams = $this->searchParamsFetcher->fetch($request);

        $group = $this->entityProvider->getByClass(ProjectGroup::class, $id);

        $result = $this->service->get($group, $searchParams);

        $list = [];

        foreach ($result->getGroups() as $group) {
            $list = [...$list, ...$group->collection->getValueMapList()];
        }

        return ResponseComposer::json([
            'total' => $result->getTotal(),
            'groups' => array_map(fn ($it) => $it->toRaw(), $result->getGroups()),
            'list' => $list,
        ]);
    }
}
