/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

define(['views/record/list'], (/** typeof import('views/record/list').default */Dep) => {

    return class ListForReportRecordView extends Dep {

        forcedCheckAllResultMassActionList = ['export']
        checkAllResultMassActionList = ['export']

        setup() {
            super.setup();

            if (this.options.isPreview) {
                this.removeMassAction('export');
            }
        }

        export(data, url, fieldList) {
            const exportData = {};

            let exportFieldList = null;

            if (this.options.listLayout) {
                exportFieldList = [];

                this.options.listLayout.forEach(item => {
                    exportFieldList.push(item.name);
                });
            }

            if (!this.allResultIsChecked) {
                exportData.ids = this.checkedList;
            }

            exportData.id = this.options.reportId;

            if ('runtimeWhere' in this.options) {
                exportData.where = this.options.runtimeWhere;
            }

            if ('groupValue' in this.options) {
                exportData.groupValue = this.options.groupValue;
            }

            if ('groupIndex' in this.options) {
                exportData.groupIndex = this.options.groupIndex;
            }

            if (this.options.groupValue2 !== undefined) {
                exportData.groupValue2 = this.options.groupValue2;
            }

            exportData.orderBy = this.collection.orderBy;
            exportData.order = this.collection.order;

            const exportUrl = 'Report/action/exportList';

            super.export(exportData, exportUrl, exportFieldList);
        }
    }
});
