<?php
/**
 * This file is part of the eNUBE Custom - EspoCRM extension.
 *
 * dubas s.c. - contact@dubas.pro
 * Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Espo\Modules\DubasCustom\Hooks\DashboardTemplate;

use Espo\Core\Hook\Hook\AfterSave;
use Espo\Entities\DashboardTemplate;
use Espo\Modules\DubasCustom\Entities\DashboardSet;
use Espo\Modules\DubasCustom\Tools\DashboardSet\Service;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;
use Espo\ORM\Repository\Option\SaveOptions;

/**
 * @implements AfterSave<DashboardTemplate>
 */
class DashboardSetDefs implements AfterSave
{
    public function __construct(
        private readonly EntityManager $entityManager,
        private readonly Service $service
    ) {}

    public function afterSave(Entity $entity, SaveOptions $options): void
    {
        $toProcess =
            $entity->isAttributeChanged('layout') ||
            $entity->isAttributeChanged('dashletsOptions');

        if (!$toProcess) {
            return;
        }

        /** @var DashboardSet[] $dashboardSetList */
        $dashboardSetList = $this->entityManager
            ->getRDBRepositoryByClass(DashboardSet::class)
            ->where([
                'dashboardTemplateId' => $entity->getId(),
            ])
            ->select(['id'])
            ->find();

        foreach ($dashboardSetList as $dashboardSet) {
            $this->service->saveDefs($dashboardSet->getId());
        }
    }
}
