Product = {
    init: function(){
        console.log('init')
        Product.loadProduct()
    },

    loadProduct() {
        const params = new URLSearchParams(document.location.search);
        const id = params.get("id");
        var myHeaders = new Headers();
        myHeaders.append("Authorization", "Basic ZW51YmU6VHViYXJAMDE=");
        var requestOptions = {
            method: 'GET',
            headers: myHeaders,
            redirect: 'manual'
        };
        fetch(`https://${window.location.host}/api/v1/Product/${(id !== null ? id : '61c4a72dc56bdfc86')}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            console.log(data.description)
            var  tpl = 
            `<div class="product col-md-6">
                <h2 class="title" id="exampleModalLabel">${data.name}</h2>
                ${data.productImageId !== null ? 
                `<div class="form-fake col-md-12">
                    <img src="https://${window.location.host}/?entryPoint=DubasPublicAttachment&size=medium&id=${data.productImageId}">
                </div>` : ''}
                ${data.url !== null ? 
                    `<div class="form-fake col-md-12">
                        <p class="input text-small"><strong>Link: </strong><a href="${data.url}" target="_blank">${data.url}</a></p>
                    </div>` : ''}
                
            </div>
            <div class="info-product col-md-6">
                <div class="accordion" id="accordionExample">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="headingZero">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseZero" aria-expanded="true" aria-controls="collapseZero">
                            Visão Geral
                        </button>
                    </h2>
                    <div id="collapseZero" class="accordion-collapse collapse show" aria-labelledby="headingZero" data-bs-parent="#accordionExample">
                        <div class="accordion-body ">
                            <p><strong>Fabricante:</strong> ${data.brandName}</p>
                            <p><strong>Categoria:</strong> ${data.categoryName}</p>
                            <p><strong>Tipo:</strong> ${data.typeName}</p>
                            <p><strong>PartNumber:</strong> ${data.partNumber}</p>
                        </div>
                    </div>
                </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                Descrição
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p class="input">${data.description}</p>
                            </div>
                        </div>
                    </div>
                    ${data.commercialDetails !== null ? 
                        `<div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Detalhes Comerciais
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p class="input">${data.commercialDetails}</p>
                            </div>
                        </div>
                    </div>` : ''}
                    
                    ${data.techDetails !== null ? 
                        `<div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                Descrição Técnica
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p class="input">${data.techDetails}</p>
                            </div>
                        </div>
                    </div>` : ''}
                    
                    ${data.otherTechnologies !== null ? 
                    `<div class="accordion-item">
                        <h2 class="accordion-header" id="headingFour">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                Tecnologias Complementares
                            </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse " aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p class="input">${data.otherTechnologies}</p>
                            </div>
                        </div>
                    </div>`: ''}
                    ${data.video !== null ? 
                    `<div class="accordion-item">
                        <h2 class="accordion-header" id="headingFive">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                Vídeo
                            </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse " aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <iframe width="560" height="315" src="https://www.youtube.com/embed/${data.video.split('=')[1]}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            </div>
                        </div>
                    </div>`: ''}
                    ${data.customerDescriptionCategory !== null ? 
                        `<div class="accordion-item">
                            <h2 class="accordion-header" id="headingSix">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                Sobre a categoria de produto
                                </button>
                            </h2>
                            <div id="collapseSix" class="accordion-collapse collapse " aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <p class="input">${data.customerDescriptionCategory}</p>
                                </div>
                            </div>
                        </div>` : ''}
                    ${data.customerDescriptionBrand !== null ? 
                    `<div class="accordion-item">
                        <h2 class="accordion-header" id="headingSeven">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                Sobre o Fabricante
                            </button>
                        </h2>
                        <div id="collapseSeven" class="accordion-collapse collapse " aria-labelledby="headingSeven" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p class="input">${data.customerDescriptionBrand}</p>
                            </div>
                        </div>
                    </div>` : ''}
                    
                </div>
            </div>`;

            document.getElementById('product').innerHTML = tpl
            
        })
        .catch(error => {
            console.log(error)
        });
        
    }
}

window.addEventListener('load', function(){
    Product.init();
})


