var JSZip = new JSZip();

var IN_PROGRESS = false;
const STATUS = {
    IN_REVIEW: "In Review",
    APPROVED: "Approved",
    PRESENTED: "Presented"
}

window.onload = function () {
    quoteToMain()
    getParams()
    closeBookByEsc()

    var openBookEl = document.querySelector(".open-book")
    var pdfButton = document.querySelector('.download-pdf')
    var documentsButton = document.querySelector('.download-documents');
    openBookEl.addEventListener('click', function clickBook() {
        console.log(`openBookEl was clicked and the current id is: ${openBookEl.getAttribute('data-quote-id')}`)
        openBook(openBookEl.getAttribute('data-quote-id'));
    })
    pdfButton.addEventListener('click', function clickDownload() {
        console.log(`pdfButton was clicked and the current id is: ${pdfButton.getAttribute('data-quote-id')}`)
        DownloadPDF(pdfButton.getAttribute('data-quote-id'));
    })
    documentsButton.addEventListener('click', function clickDownload() {
        console.log(`documentsButton was clicked and the current id is: ${documentsButton.getAttribute('data-quote-id')}`)
        loadQuotes(documentsButton.getAttribute('data-quote-id'), function (res) {
            console.log(res);
            if (res.documentsIds.length > 0) {
                res.documentsIds.forEach(function (item) {
                    GETDocument(item, function (data) {
                        console.log(data);
                        var fileType = data.fileName.split('.')[1];
                        var fileId = data.fileId;
                        console.log(fileType, fileId);
                        DownloadGeneratedGeneric(fileId, `${fileId}-${data.fileName}`);
                    })
                })
            } else {
                Swal.fire({
                    icon: "warning",
                    title: "Não encontramos nenhuma Estimativa.",
                    text: "Não foi encontrado nenhuma estimativa para essa cotação.",
                });
            }
        })
    })
}

var currentQuote = ""
var totalProduct = 0
var quotesId = []

function getClientId(oppId) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://${window.location.host}/api/v1/Quote?select=createdAt,assignedUserId,assignedUserName,amountCurrency,amountWithDiscount,amount,status,accountId,accountName,number,name&maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=equals&where[0][attribute]=opportunityId&where[0][value]=${oppId}`, requestOptions)
        .then(response => {
            if (response.status == 404) {
                Swal.fire({
                    icon: "error",
                    title: "Não Encontrado",
                    text: "O registro não foi encontrado",
                });
            } else if (response.status != 200) {
                Swal.fire({
                    icon: "error",
                    title: "Algo não funcionou corretamente",
                    text: "Pedimos para que atualize a página e tente novamente.",
                });
            } else {
                return response.json()
            }

        })
        .then(data => {
            yepnope({
                test: Modernizr.csstransforms,
                yep: ['assets/turnjs4/lib/turn.js'],
                nope: ['assets/turnjs4/lib/turn.html4.min.js'],
                both: ['css/basic.css'],
                complete: appLoad
            })

            // quote creation
            data.list.forEach((element, index) => {
                var acceptButton = ""
                var reviewButton = ""
                var quoteButton = ""
                if (element.status != "Presented" && element.status != "Approved" && element.status != "In Review") {
                    console.log(element)
                    return
                } else if (element.status == "Approved" || element.status == "In Review") {
                    acceptButton = ``
                    reviewButton = ``
                    quoteButton = ` <div class="col-md-2 text-center">
                        <button type="button" style="width:95%; background-color: #08BED5; border: 0;" class="btn btn-primary visualize-button" data-sample="${element.id}" data-bs-toggle="modal" data-bs-target="#modalView" >
                            Visualizar
                        </button>
                    </div>`
                } else {
                    var acceptButton = `
                    <div class="col-md-2 text-center">
                        <button type="button" style="width:95%; background-color: #2D9F88; border: 0;" class="btn btn-primary accept-button" data-sample="${element.id}">
                            Aceitar
                        </button>
                    </div>
                    `
                    var reviewButton = `<div class="col-md-2 text-center">
                        <button type="button" style="width:95%; background-color: #63666A; border: 0;" class="btn btn-primary review-button" data-bs-toggle="modal" data-bs-target="#modalQuote" data-sample="${element.id}">
                            Revisar
                        </button>
                    </div>`
                    var quoteButton = `<div class="col-md-2 text-center">
                        <button type="button" style="width:95%; background-color: #08BED5; border: 0;" class="btn btn-primary visualize-button" data-sample="${element.id}" data-bs-toggle="modal" data-bs-target="#modalView" >
                            Visualizar
                        </button>
                    </div>`
                }
                quotesId.push('.' + element.id)
                var total = ""
                console.log("element" , element)
                if (element.amountCurrency == "BRL") {
                    total = element.amountWithDiscount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })
                } else if (element.amountCurrency == "USD") {
                    total = element.amountWithDiscount.toLocaleString('en-us', { style: 'currency', currency: 'USD' })
                }

                loadQuotes(element.id, function (response) {
                    var date = "";
                    var title = "";
                    console.log(response)
                    if (response.reviewDate != null) {
                        date = response.reviewDate;
                        title = "Revisão realizada em:"
                    } else {
                        date = response.dateOrdered;
                        title = "Data de Vencimento (Prazo): "
                    }
                    var formattedDate = date;
                    formattedDate = formattedDate.split('-')
                    formattedDate = `${formattedDate[2]}/${formattedDate[1]}/${formattedDate[0]}`
                    var billingText = response.itemList[0].solutionType
                    var timeContractText = response.itemList[0].timeContract
                    switch (timeContractText) {
                        case "onetime":
                            timeContractText = "Uma vez";
                            break;
                        case "1 Month":
                            timeContractText = "1 Mês";
                            break;
                        case "1 Year":
                            timeContractText = "1 Ano";
                            break;
                        case "2 Years":
                            timeContractText = "2 Anos";
                            break;
                        case "3 Years":
                            timeContractText = "3 Anos";
                            break;
                        case "Perpetual":
                            timeContractText = "Perpétuo";
                            break;
                        case "Pay as you go":
                            timeContractText = "Pague conforme o uso";
                            break;
                        default:
                            timeContractText = "";
                    }

                    switch (billingText) {
                        case "onetime":
                            billingText = "Uma vez";
                            break;
                        case "1 Month":
                            billingText = "1 Mês";
                            break;
                        case "1 Year":
                            billingText = "1 Ano";
                            break;
                        case "2 Years":
                            billingText = "2 Anos";
                            break;
                        case "3 Years":
                            billingText = "3 Anos";
                            break;
                        case "Annual":
                            billingText = "Anual";
                            break;
                        case "Annual - Monthly Payment":
                            billingText = "Anual - Pagamento Mensal";
                            break;
                        case "Flexible":
                            billingText = "Flexível";
                            break;
                        case "Monthly":
                            billingText = "Mensal";
                            break;
                        case "Pay as you go":
                            billingText = "Pague conforme o uso";
                            break;
                        case "Perpetual":
                            billingText = "Perpétuo";
                            break;
                        case "Quote":
                            billingText = "Orçamento";
                            break;
                        case "Trial":
                            billingText = "Teste";
                            break;
                        case "Up front":
                            billingText = "Adiantado";
                            break;
                        default:
                            billingText = "";
                    }
                    $('.list-quotes').append(`
                        <div class="row g-0 align-items-center">
                        <div class="col-md-6 align-items-center" style="text-align: left;">
                            <a style="font-size:0.8rem; font-weight: 600;" href="#" class="col-md-6 title-quote text-blue">${response.name}</a>
                        </div>
                        <div class="col-md-2 align-items-center" style="text-align: right;">
                            <a style="font-size:0.9rem; font-weight: 600;" href="#" class="col-md-2 budget">${total}</a>
                        </div>
                        <div class="col-md-2  align-items-center" style="text-align: right;">
                            <a style="font-size:0.9rem; font-weight: 600;" href="#" class="col-md-2 budget">${timeContractText}</a>
                        </div>
                        <div class="col-md-2  align-items-center" style="text-align: right;">
                            <a style="font-size:0.9rem; font-weight: 600;" href="#" class="col-md-2 budget">${billingText}</a>
                        </div>
                            <div class="col-md-12 text-center" style="margin-top: 35px; display:flex; flex-direction:row;">
                                <div class="row g-0 align-items-center" style="width: 100%;justify-content: center;align-items:center; gap:10px;">
                                ${quoteButton}
                                ${acceptButton}
                                ${reviewButton}

                                </div>
                            </div>
                                <div class="row g-0 align-items-center" >
                                    <p style="    display: flex;
                                    flex-direction: row;
                                    justify-content: center;
                                    margin: 10px 0 0 0 ;
                                    font-size: 0.7rem;
                                    font-weight: bold;
                                    color: #525f7f;" >${title} ${formattedDate}</p>
                                </div>
                        </div>
                    `)
                    var loading = document.querySelector('#loading-quotes');
                    loading.style.display = 'none'
                })
            });
            setTimeout(() => {
                var sendReviewButton = document.querySelector('.send-review');
                var reviewContent = document.querySelector('#review-content');

                var acceptButtons = document.querySelectorAll('.accept-button');
                var reviewButtons = document.querySelectorAll('.review-button');
                acceptButtons.forEach(function (button) {
                    button.addEventListener('click', function () {


                        Swal.fire({
                            icon: "info",
                            iconColor: '#007b78',
                            title: 'Atenção!',
                            width: '45rem',
                            html:
                                '<div style="text-align: left;">' +
                                `Ao clicar em "aprovar", você estará confirmando a cotação enviada pelo vendedor. <br>
                                Após a aprovação, não será possível solicitar a revisão da cotação. Qualquer alteração deverá ser tratada diretamente com o vendedor.<br> <br>
                                Você realmente deseja aprovar a cotação?` +
                                '</div>',
                            showDenyButton: true,
                            confirmButtonColor: '#007b78',
                            denyButtonColor: '#ad4846',
                            confirmButtonText: "Aprovar",
                            denyButtonText: `Não Aprovar`
                        }).then((result) => {
                            if (result.isConfirmed) {
                                UpdateQuote(button.dataset.sample, { "status": STATUS.APPROVED }, function () {
                                    Swal.fire({
                                        title: "Você aceitou esta proposta!",
                                        text: "Para dar seguimento ao seu pedido, é necessário incluí-lo no processo de compras. Clique no botão abaixo para ser direcionado.",
                                        confirmButtonText: "Seguir para ECExpress",
                                        confirmButtonColor: "#2D9F88"
                                    }).then((result) => {
                                        if (result.isConfirmed) {
                                            window.location.href = "https://ec-br.synnex.com/ecx/login.html?redirectReq=1"
                                        }
                                    });
                                })
                            } else if (result.isDenied) {
                                return
                            }
                        });


                    })
                })

                reviewButtons.forEach(function (button) {
                    button.addEventListener('click', function () {
                        var x = button.parentElement;
                        x = x.parentElement;
                        x = x.parentElement;
                        var y = x.previousElementSibling
                        const date = new Date();
                        const reviewDate = date.toLocaleDateString('pt-BR', {
                            day: '2-digit',
                            month: '2-digit',
                            year: '2-digit'
                        });
                        sendReviewButton.addEventListener('click', function () {
                            var payload = {
                                "status": STATUS.IN_REVIEW,
                                "reply": reviewContent.value,
                                "reviewDate": reviewDate
                            }
                            UpdateQuote(button.dataset.sample, payload, function () {
                                Swal.fire({
                                    icon: "info",
                                    title: "Seu pedido de revisão foi enviado!",
                                    text: "Em até 48h você receberá uma nova versão desta cotação em seu email cadastrado.",
                                    backdrop: false,
                                    confirmButtonText: "Continuar",
                                }).then((result) => {
                                    if (result.isConfirmed) {
                                        location.reload(true);
                                    }
                                });
                            })
                        })
                    })
                })
                setTimeout(function () {
                    clickQuote()
                    IN_PROGRESS = false
                }, 200)
            }, 300);
        })
        .catch(error => {
            console.log(error)
        });

}
function openBook(id) {
    console.log(`openBook was called ${id}`)
    loadQuotes(id, function (response) {
        mountQuotes(response)
    })

}
function clickQuote() {
    document.querySelectorAll('button[data-sample].visualize-button').forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            console.log(`[data-sample] was clicked`)
            e.preventDefault();
            $('#book-zoom').empty()
            $('.samples').hide()
            className = '.' + $(this).attr('data-sample')
            let id = $(this).attr('data-sample');
            document.querySelector('.download-documents').dataset.quoteId = id
            var openBookEl = document.querySelector(".open-book");
            var pdfButtonEl = document.querySelector('.download-pdf');

            openBookEl.setAttribute('data-quote-id', id)
            pdfButtonEl.setAttribute('data-quote-id', id)
            console.log(`openBookEl.setAttribute('data-quote-id', id) was called and the new data-quote-id is ${id}`)
            console.log(`pdfButtonEl.setAttribute('data-quote-id', id) was called and the new data-quote-id is ${id}`)
        })
    })

    $('.icon-quit').on('click', function () {
        $('.samples').hide()
        $('#book-zoom').empty()
    })
}

function loadQuotes(id, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://${window.location.host}/api/v1/Quote/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            callback(data)
        })
        .catch(error => {
            console.log(error)
        });

}
function loadBrands(callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://${window.location.host}/api/v1/ProductBrand`, requestOptions)
        .then(response => response.json())
        .then(response => {
            var count = response.list.length;
            var quantityFirst = Math.round(count / 2) - 1
            response.list.map((item, index) => {
                id = item.id
                var list = `<a href="/brand?id=${id}" target="_blank" title="As informações do Fabricante serão abertas em uma nova guia.">
            <div class="row no-gutters">
            ${item.brandLogoId !== null && `<div class="col-md-8"><img src="https://${window.location.host}/?entryPoint=DubasPublicAttachment&id=${item.brandLogoId}" alt="Logo ${item.name}" class="img-custom"></div>`}
            <div class="col-md-4 title-quote text-blue">${item.name}</div>
        
            </div></a>`;
                $('.product-info.brand-1 .list-brand ').append(list)
            })
        })
        .catch(error => {
            console.log(error)
        });
}
function getAgent(id, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://${window.location.host}/api/v1/User/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            callback(data)
        })
        .catch(error => {
            console.log(error)
        });
}
function mountQuotes(data) {
    var tpl = '';
    var user = ''
    let total = 0
    currentQuote = data.id
    getAgent(data.assignedUserId, function (response) {
        var desc = ""
        let total = 0
        switch (currentQuote) {
            case '61e5b28830e0c8841':
                total = 'USD 55.038,95'
                break;
            case '61e090aa1171e2625':
                total = 'USD 47.802,79'
                break;
            case '61e73ce63da97fa3f':
                total = `USD ${data.amountWithDiscount.toFixed(2)}`
                break;
            default:
                total = data.amountCurrency === 'BRL' ? `${data.amountWithDiscount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}` : `${data.amountWithDiscount.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}`;
        }
        user = response
        if (data.commercialConditions == null) {
            var email = ""
            if (user.emailAddress != "") {
                email = user.emailAddress
            }
            desc = `Em caso de dúvidas sobre essa cotação, entre em contato conosco via email ${email}`
        } else {
            desc = data.commercialConditions.replaceAll('\n', '<br/>')
        }
        user = response
        var documentHTML = ""
        var documentTitle = ""
        if (data.documentsIds.length > 0) {
            documentTitle = `<span id="download-book-docs" style="cursor: pointer; color:#0d6efd;">Clique aqui</span> para fazer o download das estimativas.`
            for (i = 0; i < data.documentsIds.length; i++) {
                documentHTML = documentHTML + `<p class="input" data-download-doc-id="${data.documentsIds[i]}">${data.documentsNames[data.documentsIds[i]]}</p>`
            }
        } else {
            documentTitle = "Não encontramos documentos."
            documentHTML = documentHTML + `<p class="input">Não foi anexado nenhum documento para essa cotação</p>`
        }
        console.log("data : ", data)
        var documentstpl = `
        
        <hr>
        <h4>estimativas</h4>
        <div class="row">
            <div class="form-fake col-md-12">
                <p class="label" style="font-size: 12px">${documentTitle}</p>
                ${documentHTML}
            </div>
        </div>
        `
        tpl = `<div class="flipbook-viewport">
                <div class="holder">
                    <div class="${data.id} page-quote">
                        <div class="page capa"></div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Em nossa essência, somos uma empresa que se importa</h2>
                                <h3 class="sub-title">Quem Somos</h3>
                                <p>Nosso programa de cidadania corporativa é uma extensão natural de nossos valores compartilhados. Assim como mantemos os mais altos padrões todos os dias, nossos parceiros em todo o mundo também o fazem. É por isso que a TD SYNNEX tem compromissos claros para reduzir nossa pegada de carbono e promover um ambiente de trabalho diversificado, equitativo e inclusivo.</p>
                            </div>
                            <div class="blue d-flex justify-content-end flex-column">
                                <div class="address">
                                    <div class="row">
                                        <div class="col-7 col-sm-7 border-right">
                                            <p>Av. Alfredo Egídio de Souza Aranha, 100 <br>
                                            Chácara Santo Antônio<br>
                                            SP, 04726-170</p>
                                        </div>
                                        <div class="col-5 col-sm-5 text-center">
                                            <img src="./assets/images/logo.png" alt="">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="footer"> <i class="fs-5 bi-arrow-left "></i> | 01 | TD SYNNEX</div>
                        </div>
                        <div class="page content bg d-flex justify-content-end flex-column">    
                            <div class="blue agent">
                                <div class="row infos">
                                    <div class="col-md-12 proposal">
                                        <h2>${data.accountName}</h2>
                                        <h3>${data.name}</h3>
                                    </div>
                                    <div class="col-md-5 info-proposal address">
                                        <p><strong>Data: </strong>${data.dateQuoted.split("-")[2]}/${data.dateQuoted.split("-")[1]}/${data.dateQuoted.split("-")[0]}</p>
                                        <p><strong>Número: </strong> ${data.number}</p>
                                        <p><strong>Valor: </strong> ${total}</p>
                                    </div>
                                    
                                    <div class="col-md-7 info-proposal address">
                                        <div class="row">
                                            ${user.avatarId !== null ? `<div class="col-md-3 col-4">
                                            <img src="https://${window.location.host}/?entryPoint=DubasPublicAttachment&id=${user.avatarId}" alt="" width="60">
                                        </div>` : ''}
                                            <div class="col-md-12 col-8">
                                                <p><strong>Vendedor: </strong> ${user.name}</p>
                                            </div>
                                             <div class="col-md-12 col-8">
                                                <p><strong>Data de Vencimento: </strong>${data.dateOrdered.split("-")[2]}/${data.dateOrdered.split("-")[1]}/${data.dateOrdered.split("-")[0]}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>                      
                            </div>
                            <div class="footer mb-1 ">TD SYNNEX | 02 | <i class="fs-5 bi-arrow-right"></i> </div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Informações para Faturamento</h2>
                                <h3 class="sub-title"> ${data.name} | ${data.number}</h3>
                            </div>
                            <div class="box-info">
                                <h4>Dados da Revenda</h4>
                                <div class="row">
                                    <div class="form-fake col-md-12">
                                        <p class="label">Nome</p>
                                        <p class="input">${data.accountName}</p>
                                    </div>
                                    <div class="form-fake col-md-6">
                                        <p class="label">Data da Cotação</p>
                                        <p class="input">${data.dateQuoted.split("-")[2]}/${data.dateQuoted.split("-")[1]}/${data.dateQuoted.split("-")[0]}</p>
                                    </div>
                                    <div class="form-fake col-md-6">
                                        <p class="label">Numero da Cotação</p>
                                        <p class="input">${data.number}</p>
                                    </div>
                                </div>
                                ${documentstpl}
                            </div>
                            <div class="footer mb-1 border-top"><i class=" fs-5 bi-arrow-left"></i> | 03 | TD SYNNEX</div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Informação do Produto</h2>
                                <h3 class="sub-title"> ${data.name} | ${data.number}</h3>
                            </div>
                            <div class="list-products-all-prices">
                            </div>
                            <div class="box-info product-info">
                                <div class="list-products">
                                </div>
                                <div class="row flex-row-reverse ">
                                    <div class="col-md-3 pt-2 pb-4">
                                        <button type="button" class="btn btn-primary" onclick="download('${data.id}')">Download</button>
                                    </div>
                                </div>
                            </div>
                            <div class="footer mb-1 border-top" style="text-align:right;">TD SYNNEX | 04 | <i class="fs-5 bi-arrow-right"></i></div>
                        </div>
                         <div class="page content grey page-2">
                            <div class="info">
                                <h2 class="title">Observações</h2>
                            </div>
                            <div class="box-info product-info brand-2">
                                <div class="list-ob pb-3">
                                    ${desc}
                                </div>
                            </div>
                            <div class="footer mb-1 border-top"><i class="fs-5 bi-arrow-left "></i> | 05 | TD SYNNEX</div>
                        </div>
                        <div class="page content grey">
                            <div class="info">
                                <h2 class="title">Fabricantes</h2>
                            </div>
                            <div class="box-info product-info brand-1">
                                <div class="list-brand">
                                <div id="gallery-1" class="gallery galleryid-79 gallery-columns-5 gallery-size-full" style="text-align: center;">
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/01-a10.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/02-Aerohive.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/03-appgate.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/04-appviewx.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/05-arcserve.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/06-Arista.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/aruba.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/08-audiocodes-1.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/09-avaya.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/10-aws.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/11-backbox_logo.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/12-barracuda.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/13-bigswitch.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2023/02/logo-cisco.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/14-cylance.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/15-bluecat.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/16-brocade.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img width="250" height="250"
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/carbon.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        >
                                    </div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/18-checkpoint.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/ciena.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/citrix.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/22-commscope.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/23-commvault2.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/24-cumulus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/cyberark_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/Cyberpower.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/dell.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/27-eaton.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/28-ekahau.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/29-erwin.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/30-exabeam.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/31-exagrid.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/32-ExtraHop.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/extreme.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/34-f5.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/35-fidelis.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/36-fireeye.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/37-Firemon.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/38-Forcepoint.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/39-forescout.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/40-Fortinet.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/41-gfi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/42-gigamon_n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/google.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/43-hpe.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/hitachi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/44-ibm.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/45-idaptive.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/46-imperva.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/47-infoblox.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/48-infovista.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/integraoptics_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/50-ivanti.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/51-ixia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/52-Jabra.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/53-juniper.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/54-kemp.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/55-Lenovo-1.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/56-lifesize.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/57-logrhytm.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/58-logitech.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/microfocus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/59-microsoft.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/60-netap.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/NFBlueBG_GS.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/62-netscout.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/Netwitness.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/63-niagara.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/64-nokia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/65-nozomi.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/nvidia.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/66-opengear-n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/67-oracle.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/68-paloalto-n.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/69-poly.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/70-pulse.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/71-purestorage.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/72-purple.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/73-qnap.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/74-quantum.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/75-amountWithDiscount.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/76-radware.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/RedHat.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/77-rsa.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/78-Rubrik.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/ruckus.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/81-spirent.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/80-sonicwall.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/82-splunk.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/84-teamviewer.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/85-tenable.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2023/03/thales-logo.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/86-Trend-Micro.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img width="494" height="494"
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/tripwire-logo-white-1-svg.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        >wp-content/uploads/sites/33/2022/10/tripwire-logo-white-1-svg-12x12.png 12w"
                                            sizes="(max-width: 494px) 100vw, 494px">
                                    </>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/88-troy.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/89-tufin.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/90-varonis.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/veeam.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/vertros.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/93-vmware.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/zoom.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                                <figure class="gallery-item">
                                    <div class="gallery-icon landscape">
                                        <img 
                                            src="https://lac.tdsynnex.com/br/wp-content/uploads/sites/33/2022/10/zscaler.png"
                                            class="" alt="" decoding="async" loading="lazy"
                                        ></div>
                                </figure>
                            </div>
                                </div>
                            </div>
                        <div class="footer mb-1 border-top" style="text-align:right;"> TD SYNNEX | 06 |  <i class="fs-5 bi-arrow-right"></i></div>
                        </div>
                       
                        
                        <div class="page contra-capa"></div>
                    </div>
                </div>
            </div>`

        $('#book-zoom').append(tpl)
        // loadBrands()
        if (data.itemList.length > 0) {

            var list = `<a target="_blank" title="As informações do Produto serão abertas em uma nova guia.">
            <div class="row g-0 ">
                <div class="col-md-5 title-quote text-blue p-2 pt-0 pb-0" style="font-size:12px">Nome do Produto</div>
                <div class="col-md-2 quantity text-center" style="font-size:10px;">Quantidade</div>
                <div class="col-md-2 quantity text-center" style="font-size:10px;">Desconto (%)</div>
                <div class="col-md-3 budget text-center" style="font-size:10px;">Valor c/ Desconto</div>
            </div></a>`;
            $('.product-info .list-products').append(list)

            data.itemList.map((item, key) => {
                discountAmount = data.amountCurrency === 'BRL' ? `${item.discountAmount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}` : `${item.discountAmount.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}`;
                var list = `<a title="As informações do Produto serão abertas em uma nova guia.">
                    <div class="row g-0 ">
                        <div class="col-md-5 title-quote text-blue p-2 pt-0 pb-0" style="font-size:12px">${item.name}</div>
                        <div class="col-md-2 quantity text-center">${item.quantity}</div>
                        <div class="col-md-2 quantity text-center"> ${item.discount ? item.discount + '%' : '-'}</div>
                        <div class="col-md-3 budget text-center">${(discountAmount)}</div>
                    </div></a>`;

                $('.product-info .list-products').append(list)
            })

            var princesListNames = `
        <div class="row g-0 gap-2" style="background-color:#fff; padding-top:10px">
            <div class="col-md-2 title-quote text-blue" style="font-size:13px; font-weight:bold;"></div>
            <div class="col-md-3 price  title-quote text-blue text-center" style="font-size:13px;">Valor</div>
            <div class="col-md-3 priceDiscount title-quote text-blue text-center" style="font-size:13px;">Valor Descontado</div>
            <div class="col-md-3 totalPriceDiscount title-quote text-blue text-center" style="font-size:13px;">Valor c/ Desconto</div>
        </div>
            `
            $('.list-products-all-prices').append(princesListNames)
            var totalAmounts = data.itemList.reduce((totals, item) => {
                totals.amount += item.amount;
                totals.discountAmount += item.discountAmount;
                return totals;
            }, { amount: 0, discountAmount: 0 });
            var totalAmount = totalAmounts.amount;
            var totalDiscountAmount = totalAmounts.discountAmount;
            // var totalPriceWithDiscount = totalAmount - totalDiscountAmount;
            var totalPriceWithDiscount = totalDiscountAmount - totalAmount;
            totalAmount = data.amountCurrency === 'BRL' ? `${totalAmount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}` : `${totalAmount.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}`;
            totalDiscountAmount = data.amountCurrency === 'BRL' ? `${totalDiscountAmount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}` : `${totalDiscountAmount.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}`;
            totalPriceWithDiscount = data.amountCurrency === 'BRL' ? `${totalPriceWithDiscount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })}` : `${totalPriceWithDiscount.toLocaleString('en-US', { style: 'currency', currency: 'USD' })}`;
            var allPricesList = `
        <div class="row g-0 gap-2" style="background-color:#fff;text-align:end">
            <div class="col-md-2 title-quote text-blue" style="font-size:13px; font-weight:bold;">Resumo :</div>
            <div class="col-md-3 price text-center" style="font-size:12px;" >${(totalAmount)}</div>
            <div class="col-md-3 priceDiscount text-center" style="font-size:12px;" >${(totalPriceWithDiscount)}</div>
            <div class="col-md-3 totalPriceDiscount text-center" style="font-size:12px;">${(totalDiscountAmount)}</div>
            <hr style="margin: 0 0; width:90%; margin: 0px auto;">
        </div>`
            $('.list-products-all-prices').append(allPricesList)
        }
        setTimeout(() => {
            document.querySelector('#download-book-docs')?.addEventListener('click', function () {
                console.log('click');

                var documentsIdsElements = document.querySelectorAll('[data-download-doc-id]');
                documentsIdsElements.forEach(function (item) {
                    console.log(item.dataset.downloadDocId);
                    GETDocument(item.dataset.downloadDocId, function (data) {
                        console.log(data);
                        var fileType = data.fileName.split('.')[1];
                        var fileId = data.fileId;
                        console.log(fileType, fileId);
                        DownloadGeneratedGeneric(fileId, `${fileId}-${data.fileName}`);
                    })

                })
            })
            if ($(window).width() > 768) {
                $(className).turn({
                    width: 1060,
                    height: 550,
                    elevation: 50,
                    gradients: true,
                    autoCenter: true
                });
                $('.samples').show()
            } else {
                $('.samples').show()
            }
        }, 2000);
    })

}

function download(id) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var raw = JSON.stringify({
        "idList": [
            id
        ],
        "entityType": "Quote",
        "templateId": "61256edb1baefa825"
    });

    var requestOptions = {
        method: 'POST',
        headers: myHeaders,
        body: raw,
        redirect: 'follow'
    };

    fetch(`https://${window.location.host}/api/v1/Pdf/action/massPrint`, requestOptions)
        .then(response => response.json())
        .then(result => {
            window.open(`https://${window.location.host}/?entryPoint=download&id=` + result.id)
        })
        .catch(error => console.log('error', error));
}

function appLoad() {

}


function UpdateQuote(id, request, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var requestOptions = {
        method: 'PATCH',
        headers: myHeaders,
        redirect: 'manual',
        body: JSON.stringify(request)
    };

    fetch(`https://${window.location.host}/api/v1/Quote/${id}`, requestOptions)
        .then(response => response.json())
        .then(data => {
            if (callback == undefined || callback == null) {
                location.reload(true)
            } else {
                callback()
            }
        })
        .catch(error => {
            console.log(error)
        });
}

function DownloadPDF(id) {
    console.log(`DownloadPDF was called with id: ${id}`)
    var requestOptions = {
        method: 'POST',
        headers: {
            "Authorization": "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=",
            "Content-Type": "application/json"

        },
        redirect: 'manual',
        body: JSON.stringify(
            {
                idList: [id],
                entityType: "Quote",
                templateId: "001",
            })
    };

    fetch(`https://${window.location.host}/api/v1/Pdf/action/massPrint`, requestOptions)
        .then(response => response.json())
        .then(data => {
            console.log(data)
            DownloadGeneratedPDF(data.id)
        })
        .catch(error => {
            console.log(error)
        });
}

function DownloadGeneratedPDF(id) {
    var requestOptions = {
        method: 'GET',
        headers: {
            "Authorization": "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=",
            "Content-Type": "application/json"
        },
        redirect: 'manual',
    };
    fetch(`https://${window.location.host}/api/v1/Attachment/file/${id}`, requestOptions)
        .then(res => res.blob())
        .then(async data => {
            if (data.type == "application/zip") {
                var zippedFile = new Blob([data])
                var zip = await JSZip.loadAsync(zippedFile)
                var pdf = zip.file(Object.keys(zip.files)[0])
                console.log(pdf)
                var blobData = await pdf.async('blob')

                downloadFile(new Blob([blobData]), `cotacao-${pdf.name}`);
            } else {
                downloadFile(new Blob([blobData]), `cotacao-${id}.pdf`);
            }
        })
        .catch(error => {
            console.log(error)
        });
}


function DownloadGeneratedGeneric(id, fileName) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual',
    };
    fetch(`https://${window.location.host}/api/v1/Attachment/file/${id}`, requestOptions)
        .then(res => res.blob())
        .then(data => {
            downloadFile(new Blob([data]), fileName);
        })
        .catch(error => {
            console.log(error)
        });
}

function GETDocument(id, callback) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    myHeaders.append("Content-Type", "application/json");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual',
    };
    fetch(`https://${window.location.host}/api/v1/Document/${id}`, requestOptions)
        .then(res => res.json())
        .then(data => {
            callback(data)
        })
        .catch(error => {
            console.log(error)
        });
}

const downloadFile = (blob, fileName) => {
    const link = document.createElement('a');
    link.href = URL.createObjectURL(blob);
    link.download = fileName;
    document.body.append(link);
    link.click();
    link.remove();
    setTimeout(() => URL.revokeObjectURL(link.href), 7000);
    location.reload(true)
};


var changeText = function (id, newText) {
    item = document.querySelector(id);
    let animation = item.animate([
        { transform: 'translateY(0px)', opacity: '1' },
        { transform: 'translateY(1px)', opacity: '0.9' },
        { transform: 'translateY(4px)', opacity: '0.7' },
        { transform: 'translateY(9px)', opacity: '0.5' },
        { transform: 'translateY(14px)', opacity: '0.3' }

    ], {
        duration: 500,

    });

    animation.onfinish = function () {
        item.innerText = newText;
        item.animate([
            { transform: 'translateY(14px)', opacity: '0.3' },
            { transform: 'translateY(9px)', opacity: '0.5' },
            { transform: 'translateY(4px)', opacity: '0.7' },
            { transform: 'translateY(1px)', opacity: '0.9' },
            { transform: 'translateY(0px)', opacity: '1' }
        ], {
            duration: 500,
        });
    };
}
function loadingText(selector) {
    console.log('interval')
    var el = document.querySelector(selector);
    if (el.classList.contains("animate__fadeIn")) {
        el.classList.remove('animate__fadeIn')
        el.classList.add('animate__fadeOut')
    } else {
        el.classList.remove('animate__fadeOut')
        el.classList.add('animate__fadeIn')
    }

}
function getDataKey(keyInput) {
    localStorage.setItem('keyData', keyInput);
    document.querySelector('.list-quotes').innerHTML = `
    <span style="color:#007b78; font-weight: bold; padding: 5px;" class="text-center" id="loading-quotes">
        <div class="spinner-border text-success" role="status" style="text-align: center;margin: 15px auto;color: #007b78!important; display: block;">
            <span class="visually-hidden">Loading...</span>

        </div>
        <span id="loading-text" class="text-center animate__animated animate__fadeIn">Carregando Informações...</span>
    </span>
    `
    var interval = setInterval(function () {
        loadingText('#loading-text')
    }, 1000)
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://${window.location.host}/api/v1/Contact/${keyInput}`, requestOptions)
        .then(response => {
            if (response.status == 404) {
                Swal.fire({
                    icon: "error",
                    title: "Erro na Chave de Acesso",
                    text: "Ops! Não conseguimos localizar essa chave de acesso em nosso sistema. Por favor, verifique novamente o código no e-mail enviado pelo seu vendedor. A chave é composta por 16 caracteres, incluindo letras e números.",
                });
                clearInterval(interval)

            } else if (response.status != 200) {
                Swal.fire({
                    icon: "error",
                    title: "Algo não funcionou corretamente",
                    text: "Pedimos para que atualize a página e tente novamente.",
                });
                clearInterval(interval)

            } else {
                clearInterval(interval)
                return response.json()
            }
        })
        .then(data => {
            console.log(data)

            changeText('#greeting', `Olá, ${data.firstName}!`)
            getClientId(localStorage.getItem('chooseOpp'))
        })
}
function getParams() {
    var keyInput = document.querySelector('#quote-key');
    var serchKeyQuote = document.querySelector('.search-quote-key');
    var keyData = localStorage.getItem('keyData');
    if (keyData != null && keyData != undefined && keyData != '') {
        keyInput.value = keyData;
        getDataKey(keyData);
    }
    serchKeyQuote.addEventListener('click', function (e) {
        console.log(keyInput.value)
        if (!IN_PROGRESS) {
            IN_PROGRESS = true;
            getDataKey(keyInput.value);
        } else {
            console.log("Já está em progresso")
        }

    });
    keyInput.addEventListener('keyup', function (e) {
        var key = e.which || e.keyCode;
        if (key == 13) {
            if (!IN_PROGRESS) {
                IN_PROGRESS = true;
                getDataKey(keyInput.value);
            } else {
                console.log("Já está em progresso")
            }
        }
    });
}
function closeBookByEsc() {
    document.addEventListener('keyup', function (e) {
        if (e.key === 'Escape') { // Verifica se a tecla Esc foi pressionada
            $('.samples').hide();
            $('#book-zoom').empty();
        }
    });
}


function quoteToMain() {
    var backParam = document.querySelectorAll('.backToOpp');
    backParam.forEach(btn => {
        btn.addEventListener('click', () => {
            console.log("click")
            if (window.location.href.includes('quotes.html')) {
                window.location.href = window.location.href.replace("quotes.html", "");
            }
        })
    });
}