/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:views/dashboard-set', ['views/dashboard'], (Dep) => {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);

            this.layoutReadOnly = true;
            this.dashletsReadOnly = true;
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            this.$el.find('h3').text(
                this.getLanguage().translate(this.options.dashboardSetId, 'scopeNames')
            );
        },

        setupCurrentTabLayout: function () {
            this.dashboardLayout = this.getMetadata().get(['clientDefs', this.options.dashboardSetId, 'dashboardLayout']) || [];

            Dep.prototype.setupCurrentTabLayout.call(this);
        },

        saveLayout: function () {},

    });

});
