/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:controllers/dashboard-set', ['controller'], (Dep) => {

    return Dep.extend({

        defaultAction: 'index',

        actionIndex: function () {
            let url = window.location.href;
            let fragment = url.split('#')[1];

            this.getUserDashboardSetList(result => {
                if (!~result.indexOf(fragment)) {
                    return;
                }

                this.main('dubas-custom:views/dashboard-set', {
                    displayTitle: true,
                    dashboardSetId: fragment,
                }, (view) => {
                    view.render();
                });
            });
        },

        getUserDashboardSetList: function (callback) {
            Promise.all([
                new Promise(resolve => {
                    Espo.Ajax.postRequest('DashboardSet/action/getUserDashboardSetList', {
                        userId: this.getUser().id,
                    })
                        .then(result => {
                            callback(result);
                            resolve();
                        });
                })
            ])
        },

    });

});
