/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:views/dashboard-set', ['views/dashboard'], (Dep) => {

    return Dep.extend({

        setup: function () {
            Dep.prototype.setup.call(this);

            this.layoutReadOnly = true;
            this.dashletsReadOnly = true;
        },

        afterRender: function () {
            Dep.prototype.afterRender.call(this);

            this.$el.find('h3').text(
                this.getLanguage().translate(this.options.dashboardSetId, 'scopeNames')
            );
        },

        setupCurrentTabLayout: function () {
            this.dashboardLayout = this.getMetadata().get(['clientDefs', this.options.dashboardSetId, 'dashboardLayout']) || [];

            Dep.prototype.setupCurrentTabLayout.call(this);
        },

        saveLayout: function () {},

    });

});

/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:views/site/navbar', ['views/site/navbar'], (Dep) => {

    return Dep.extend({

        setup: function () {
            this.userDashboardSetList = [];

            this.getUserDashboardSetList(result => {
                this.userDashboardSetList = result;

                Dep.prototype.setup.call(this);
            });
        },

        filterTabItem: function (scope) {
            if (~['Home', '_delimiter_', '_delimiter-ext_'].indexOf(scope)) {
                return true;
            }

            let scopes = this.getMetadata().get('scopes') || {};

            if (!scopes[scope]) {
                return false;
            }

            let defs = scopes[scope] || {};

            if (defs.disabled) {
                return;
            }

            if (defs.isDashboardSet) {
                return ~this.userDashboardSetList.indexOf(scope);
            }

            if (defs.acl) {
                return this.getAcl().check(scope);
            }
            if (defs.tabAclPermission) {
                let level = this.getAcl().get(defs.tabAclPermission);

                return level && level !== 'no';
            }

            return true;
        },

        getUserDashboardSetList: function (callback) {
            this.wait(
                Promise.all([
                    new Promise(resolve => {
                        Espo.Ajax.postRequest('DashboardSet/action/getUserDashboardSetList', {
                            userId: this.getUser().id,
                        })
                            .then(result => {
                                callback(result);
                                resolve();
                            });
                    })
                ])
            );
        },

    });

});

/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:controllers/dashboard-set', ['controller'], (Dep) => {

    return Dep.extend({

        defaultAction: 'index',

        actionIndex: function () {
            let url = window.location.href;
            let fragment = url.split('#')[1];

            this.getUserDashboardSetList(result => {
                if (!~result.indexOf(fragment)) {
                    return;
                }

                this.main('dubas-custom:views/dashboard-set', {
                    displayTitle: true,
                    dashboardSetId: fragment,
                }, (view) => {
                    view.render();
                });
            });
        },

        getUserDashboardSetList: function (callback) {
            Promise.all([
                new Promise(resolve => {
                    Espo.Ajax.postRequest('DashboardSet/action/getUserDashboardSetList', {
                        userId: this.getUser().id,
                    })
                        .then(result => {
                            callback(result);
                            resolve();
                        });
                })
            ])
        },

    });

});

/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:acl/service-item', ['acl'], (Dep) => {

    return Dep.extend({

        checkIsOwner: function (model) {
            if (model.has('opportunityId')) {
                return true;
            } else {
                return Dep.prototype.checkIsOwner.call(this, model);
            }
        },

        checkInTeam: function (model) {
            if (model.has('opportunityId')) {
                return true;
            } else {
                return Dep.prototype.checkInTeam.call(this, model);
            }
        },

    });

});

/************************************************************************
This file is part of the eNUBE Custom - TD SYNNEX extension.

dubas s.c. - contact@dubas.pro
Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
************************************************************************/

define('dubas-custom:acl/dashboard-set', ['acl'], (Dep) => {

    return Dep.extend({

        // eslint-disable-next-line no-unused-vars
        checkScope: function(data, action, precise) {
            return true;
        },

    });

});


