/*********************************************************************************
 * The contents of this file are subject to the TD SYNNEX Advanced Pack
 * Agreement ("License") which can be viewed at
 * https://www.espocrm.com/advanced-pack-agreement.
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * sublicense, resell, rent, lease, distribute, or otherwise  transfer rights
 * or usage to the software.
 * 
 * Copyright (C) 2015-2020 Letrium Ltd.
 * 
 * License ID: 17e980fb90b374d15b20258de2855b7b
 ***********************************************************************************/

Espo.define('advanced:views/dashlets/options/report', ['views/dashlets/options/base', 'advanced:views/report/fields/columns', 'advanced:report-helper'], function (Dep, Columns, ReportHelper) {

    return Dep.extend({

        template: 'advanced:dashlets/options/report',

        setup: function () {
            Dep.prototype.setup.call(this);

            this.reportData = {
                entityType: this.optionsData.entityType || null,
                type: this.optionsData.type || null,
                runtimeFilters: this.optionsData.runtimeFilters || null,
                columns: this.optionsData.columns || null,
                depth: this.optionsData.depth || 0,
            };

            this.reportHelper = new ReportHelper(
                this.getMetadata(),
                this.getLanguage(),
                this.getDateTime(),
                this.getConfig(),
                this.getPreferences()
            );

            this.listenTo(this.model, 'change:reportName', function (model) {
                setTimeout(function () {
                    model.set('title', model.get('reportName'));
                }, 100);
            }, this);

            this.cotrolUseSiMultiplierField();
            this.cotrolTotalField();

            this.listenTo(this.model, 'change:displayTotal', function (value, model, o) {
                this.cotrolUseSiMultiplierField();
            }, this);

            this.listenTo(this.model, 'change:displayOnlyCount', function (value, model, o) {
                this.cotrolUseSiMultiplierField();
                this.cotrolTotalField();
            }, this);

            this.listenTo(this.model, 'change:reportId', function (model) {
                this.reportData = {};
                this.removeRuntimeFilters();
                this.hideColumnsField();

                this.hideField('displayOnlyCount');
                this.hideField('displayTotal');
                this.hideField('useSiMultiplier');

                var reportId = model.get('reportId');
                if (!reportId) {
                    return;
                }
                this.getModelFactory().create('Report', function (model) {
                    model.id = reportId;
                    this.listenToOnce(model, 'sync', function () {
                        var columns = (model.get('columns') || []).filter(function (item) {
                            return this.reportHelper.isColumnNumeric(item, model.get('entityType'));
                        }, this);

                        var reportData = {
                            entityType: model.get('entityType'),
                            type: model.get('type'),
                            runtimeFilters: model.get('runtimeFilters'),
                            columns: columns,
                        };

                        if (
                            (model.get('type') === 'Grid' || model.get('type') === 'JointGrid')
                            &&
                            model.get('groupBy')
                        ) {
                            reportData.depth = model.get('groupBy').length;
                        } else {
                            reportData.depth = null;
                        }

                        this.model.set('depth', reportData.depth);
                        this.model.set('entityType', model.get('entityType'));

                        this.reportData = reportData;

                        if (this.hasRuntimeFilters()) {
                            this.createRuntimeFilters();
                        }

                        this.handleColumnField();
                        this.cotrolUseSiMultiplierField();
                        this.cotrolTotalField();

                    }, this);
                    model.fetch();
                }, this);

            }, this);
        },

        cotrolUseSiMultiplierField: function () {
            if (this.model.get('displayOnlyCount') || this.model.get('displayTotal')) {
                this.showField('useSiMultiplier');
            } else {
                this.hideField('useSiMultiplier');
            }
        },

        cotrolTotalField: function () {
            if (!this.reportData.type) {
                this.hideField('displayTotal');
                return;
            }

            if (this.reportData.type === 'List') {
                this.hideField('displayTotal');
                return;
            }

            if (this.model.get('displayOnlyCount')) {
                this.hideField('displayTotal');
            } else {
                this.showField('displayTotal');
            }
        },

        handleColumnField: function () {
            var recordView = this.getView('record');
            this.hideField('displayOnlyCount');

            if (this.reportData.type) {
                this.showField('displayOnlyCount');
                if (this.reportData.type == 'Grid') {
                    this.showField('displayTotal');
                }

                if (this.reportData.type == 'JointGrid') {
                    this.showField('displayTotal');
                }

                if (this.reportData.type === 'List') {
                    this.hideField('displayTotal');
                }
            }

            if (recordView) {
                var columnView = recordView.getFieldView('column');
                if (this.reportData.type == 'Grid') {
                    columnView.params.options = Espo.Utils.clone(this.reportData.columns || []);
                    columnView.translatedOptions = {};
                    Columns.prototype.setupTranslatedOptions.call(columnView);

                    if ((this.reportData.depth === 0 || this.reportData.depth === 1) && columnView.params.options.length > 1) {
                        columnView.params.options.unshift('');
                        columnView.translatedOptions[''] = this.translate('All');
                    }

                    this.$el.find('.cell-column').removeClass('hidden');
                    var recordView = this.getView('record');
                    if ('showField' in recordView) {
                        recordView.showField('column');
                    }

                } else {
                    columnView.params.options = [];
                    this.hideColumnsField();
                }
                columnView.render();
            }
        },

        hideColumnsField: function () {
            this.$el.find('.cell-column').addClass('hidden');
            var recordView = this.getView('record');
            if ('hideField' in recordView) {
                recordView.hideField('column');
            }
        },

        afterRender: function () {
            this.handleColumnField();

            if (this.hasRuntimeFilters()) {
                this.createRuntimeFilters();
            }
        },

        hasRuntimeFilters: function () {
            return (this.reportData.runtimeFilters || []).length != 0
        },

        removeRuntimeFilters: function () {
            this.clearView('runtimeFilters');
        },

        createRuntimeFilters: function () {
            this.createView('runtimeFilters', 'advanced:views/report/runtime-filters', {
                el: this.options.el + ' .runtime-filters-contanier',
                entityType: this.reportData.entityType,
                filterList: this.reportData.runtimeFilters,
                filtersData: this.optionsData.filtersData || null,
            }, function (view) {
                view.render();
            });
        },

        fetchAttributes: function () {
            var attributes = Dep.prototype.fetchAttributes.call(this);

            if (this.hasRuntimeFilters()) {
                var runtimeFiltersView = this.getView('runtimeFilters');
                if (runtimeFiltersView) {
                    attributes.filtersData = runtimeFiltersView.fetchRaw();
                }
            }
            attributes.entityType = this.reportData.entityType;
            attributes.runtimeFilters = this.reportData.runtimeFilters;
            attributes.type = this.reportData.type;
            attributes.columns = this.reportData.columns;
            attributes.depth = this.reportData.depth;

            return attributes;
        }

    });
});
