<?php
/*********************************************************************************
 * The contents of this file are subject to the TD SYNNEX Advanced Pack
 * Agreement ("License") which can be viewed at
 * https://www.espocrm.com/advanced-pack-agreement.
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * sublicense, resell, rent, lease, distribute, or otherwise  transfer rights
 * or usage to the software.
 * 
 * Copyright (C) 2015-2020 Letrium Ltd.
 * 
 * License ID: 17e980fb90b374d15b20258de2855b7b
 ***********************************************************************************/

namespace Espo\Modules\Advanced\Hooks\CampaignTrackingUrl;

class Signal extends \Espo\Core\Hooks\Base
{
    public static $order = 100;

    protected function init()
    {
        $this->addDependency('signalManager');
        $this->addDependency('entityManager');
    }

    public function afterClick(\Espo\ORM\Entity $entity, array $options, array $hookData)
    {
        if (!empty($options['skipWorkflow'])) return;
        if (!empty($options['skipSignal'])) return;
        if (!empty($options['silent'])) return;

        $signalManager = $this->getInjection('signalManager');
        $em = $this->getInjection('entityManager');

        $targetType = $hookData['targetType'];
        $targetId = $hookData['targetId'];

        $target = $em->getEntity($targetType, $targetId);

        if (!$target) return;

        $signalManager->trigger(implode('.', ['@clickUrl', $entity->id]), $target);
        $signalManager->trigger(implode('.', ['@clickUrl']), $target);

        $signalManager->trigger(implode('.', ['clickUrl', $targetType, $targetId, $entity->id]));
        $signalManager->trigger(implode('.', ['clickUrl', $targetType, $targetId]));
    }
}
