<?php
return [
  0 => [
    'route' => 'ProjectColumn/:id/moveUp',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Column\\Api\\PostMoveUp',
    'adjustedRoute' => '/ProjectColumn/{id}/moveUp'
  ],
  1 => [
    'route' => 'ProjectColumn/:id/moveDown',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Column\\Api\\PostMoveDown',
    'adjustedRoute' => '/ProjectColumn/{id}/moveDown'
  ],
  2 => [
    'route' => 'Project/:id/plan',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetPlan',
    'adjustedRoute' => '/Project/{id}/plan'
  ],
  3 => [
    'route' => 'Project/:id/gantt',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGantt',
    'adjustedRoute' => '/Project/{id}/gantt'
  ],
  4 => [
    'route' => 'Project/:id/ganttNonWorkingRanges',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGanttNonWorkingRanges',
    'adjustedRoute' => '/Project/{id}/ganttNonWorkingRanges'
  ],
  5 => [
    'route' => 'ProjectGroup/:id/ganttTasks',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGroupGanttTasks',
    'adjustedRoute' => '/ProjectGroup/{id}/ganttTasks'
  ],
  6 => [
    'route' => 'ProjectGroup/:id/board',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\GetGroupBoard',
    'adjustedRoute' => '/ProjectGroup/{id}/board'
  ],
  7 => [
    'route' => 'ProjectGroup/:id/boardOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostGroupBoardOrder',
    'adjustedRoute' => '/ProjectGroup/{id}/boardOrder'
  ],
  8 => [
    'route' => 'ProjectGroup/:id/tasks',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostGroupTasks',
    'adjustedRoute' => '/ProjectGroup/{id}/tasks'
  ],
  9 => [
    'route' => 'ProjectGroup/:id/taskReOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostTaskReOrder',
    'adjustedRoute' => '/ProjectGroup/{id}/taskReOrder'
  ],
  10 => [
    'route' => 'ProjectTask/:id/subTaskReOrder',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostSubTaskReOrder',
    'adjustedRoute' => '/ProjectTask/{id}/subTaskReOrder'
  ],
  11 => [
    'route' => 'Project/:id/reorderGroups',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostReorderGroups',
    'adjustedRoute' => '/Project/{id}/reorderGroups'
  ],
  12 => [
    'route' => 'Project/:id/clone',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostClone',
    'adjustedRoute' => '/Project/{id}/clone'
  ],
  13 => [
    'route' => 'Project/:id/members',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\Project\\Api\\PostMembers',
    'adjustedRoute' => '/Project/{id}/members'
  ],
  14 => [
    'route' => 'ProjectTask/:id/complete',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostComplete',
    'adjustedRoute' => '/ProjectTask/{id}/complete'
  ],
  15 => [
    'route' => 'ProjectTask/:id/column',
    'method' => 'put',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PutColumn',
    'adjustedRoute' => '/ProjectTask/{id}/column'
  ],
  16 => [
    'route' => 'ProjectTask/:id/cancel',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostCancel',
    'adjustedRoute' => '/ProjectTask/{id}/cancel'
  ],
  17 => [
    'route' => 'ProjectTask/:id/moveInGroup',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Project\\Tools\\ProjectTask\\Api\\PostMoveInGroup',
    'adjustedRoute' => '/ProjectTask/{id}/moveInGroup'
  ],
  18 => [
    'route' => 'Product/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/Product/{id}/warehousesQuantity'
  ],
  19 => [
    'route' => 'InventoryNumber/:id/warehousesQuantity',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetWarehousesQuantity',
    'adjustedRoute' => '/InventoryNumber/{id}/warehousesQuantity'
  ],
  20 => [
    'route' => 'InventoryNumber/:id/history',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\InventoryNumber\\Api\\GetHistory',
    'adjustedRoute' => '/InventoryNumber/{id}/history'
  ],
  21 => [
    'route' => 'Warehouse/:id/products',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetProducts',
    'adjustedRoute' => '/Warehouse/{id}/products'
  ],
  22 => [
    'route' => 'Warehouse/:id/inventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Warehouse\\Api\\GetInventoryNumbers',
    'adjustedRoute' => '/Warehouse/{id}/inventoryNumbers'
  ],
  23 => [
    'route' => 'ReceiptOrder/:id/importSerialNumbers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ReceiptOrder\\Api\\PostImportSerialNumbers',
    'adjustedRoute' => '/ReceiptOrder/{id}/importSerialNumbers'
  ],
  24 => [
    'route' => 'ProductAttribute/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMove',
    'adjustedRoute' => '/ProductAttribute/{id}/move/{type}'
  ],
  25 => [
    'route' => 'ProductAttributeOption/:id/move/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\PostMoveOption',
    'adjustedRoute' => '/ProductAttributeOption/{id}/move/{type}'
  ],
  26 => [
    'route' => 'ProductAttribute/options',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\ProductAttribute\\Api\\GetOptions',
    'adjustedRoute' => '/ProductAttribute/options'
  ],
  27 => [
    'route' => 'Product/:id/generateVariants',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\PostGenerateVariants',
    'adjustedRoute' => '/Product/{id}/generateVariants'
  ],
  28 => [
    'route' => 'Product/:id/variantInventoryNumbers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetVariantInventoryNumbers',
    'adjustedRoute' => '/Product/{id}/variantInventoryNumbers'
  ],
  29 => [
    'route' => 'Product/:id/orderItems',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Product\\Api\\GetOrderItems',
    'adjustedRoute' => '/Product/{id}/orderItems'
  ],
  30 => [
    'route' => 'DeliveryOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/lock'
  ],
  31 => [
    'route' => 'DeliveryOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'DeliveryOrder'
    ],
    'adjustedRoute' => '/DeliveryOrder/{id}/unlock'
  ],
  32 => [
    'route' => 'Invoice/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/lock'
  ],
  33 => [
    'route' => 'Invoice/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Invoice'
    ],
    'adjustedRoute' => '/Invoice/{id}/unlock'
  ],
  34 => [
    'route' => 'Quote/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/lock'
  ],
  35 => [
    'route' => 'Quote/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'Quote'
    ],
    'adjustedRoute' => '/Quote/{id}/unlock'
  ],
  36 => [
    'route' => 'ReceiptOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/lock'
  ],
  37 => [
    'route' => 'ReceiptOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReceiptOrder'
    ],
    'adjustedRoute' => '/ReceiptOrder/{id}/unlock'
  ],
  38 => [
    'route' => 'ReturnOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/lock'
  ],
  39 => [
    'route' => 'ReturnOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'ReturnOrder'
    ],
    'adjustedRoute' => '/ReturnOrder/{id}/unlock'
  ],
  40 => [
    'route' => 'SalesOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/lock'
  ],
  41 => [
    'route' => 'SalesOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'SalesOrder'
    ],
    'adjustedRoute' => '/SalesOrder/{id}/unlock'
  ],
  42 => [
    'route' => 'TransferOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/lock'
  ],
  43 => [
    'route' => 'TransferOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'TransferOrder'
    ],
    'adjustedRoute' => '/TransferOrder/{id}/unlock'
  ],
  44 => [
    'route' => 'PurchaseOrder/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/lock'
  ],
  45 => [
    'route' => 'PurchaseOrder/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'PurchaseOrder'
    ],
    'adjustedRoute' => '/PurchaseOrder/{id}/unlock'
  ],
  46 => [
    'route' => 'InventoryAdjustment/:id/lock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostLock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/lock'
  ],
  47 => [
    'route' => 'InventoryAdjustment/:id/unlock',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Quote\\Api\\PostUnlock',
    'params' => [
      'entityType' => 'InventoryAdjustment'
    ],
    'adjustedRoute' => '/InventoryAdjustment/{id}/unlock'
  ],
  48 => [
    'route' => 'PriceRuleCondition/list',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\GetPriceRuleConditionList',
    'adjustedRoute' => '/PriceRuleCondition/list'
  ],
  49 => [
    'route' => 'ProductPrice/getSalesPrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetSalesPrice',
    'adjustedRoute' => '/ProductPrice/getSalesPrice'
  ],
  50 => [
    'route' => 'ProductPrice/getPurchasePrice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Price\\Api\\PostGetPurchasePrice',
    'adjustedRoute' => '/ProductPrice/getPurchasePrice'
  ],
  51 => [
    'route' => 'Invoice/:id/exportEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostExportEInvoice',
    'adjustedRoute' => '/Invoice/{id}/exportEInvoice'
  ],
  52 => [
    'route' => 'Invoice/:id/validateEInvoice',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Sales\\Tools\\Invoice\\Api\\PostValidateEInvoice',
    'adjustedRoute' => '/Invoice/{id}/validateEInvoice'
  ],
  53 => [
    'route' => '/Activities/:parentType/:id/composeEmailAddressList',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetComposeAddressList',
    'adjustedRoute' => '/Activities/{parentType}/{id}/composeEmailAddressList'
  ],
  54 => [
    'route' => '/Activities/:parentType/:id/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\Get',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}'
  ],
  55 => [
    'route' => '/Activities/:parentType/:id/:type/list/:targetType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetListTyped',
    'adjustedRoute' => '/Activities/{parentType}/{id}/{type}/list/{targetType}'
  ],
  56 => [
    'route' => '/Activities/upcoming',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\Api\\GetUpcoming',
    'adjustedRoute' => '/Activities/upcoming'
  ],
  57 => [
    'route' => '/Activities',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetCalendar',
    'adjustedRoute' => '/Activities'
  ],
  58 => [
    'route' => '/Timeline',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetTimeline',
    'adjustedRoute' => '/Timeline'
  ],
  59 => [
    'route' => '/Timeline/busyRanges',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Calendar\\Api\\GetBusyRanges',
    'adjustedRoute' => '/Timeline/busyRanges'
  ],
  60 => [
    'route' => '/Meeting/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Meeting',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Meeting/{id}/attendees'
  ],
  61 => [
    'route' => '/Call/:id/attendees',
    'method' => 'get',
    'params' => [
      'controller' => 'Call',
      'action' => 'attendees'
    ],
    'adjustedRoute' => '/Call/{id}/attendees'
  ],
  62 => [
    'route' => '/Campaign/:id/generateMailMerge',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\Campaign\\Api\\PostGenerateMailMerge',
    'adjustedRoute' => '/Campaign/{id}/generateMailMerge'
  ],
  63 => [
    'route' => '/TargetList/:id/optedOut',
    'method' => 'get',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\TargetList\\Api\\GetOptedOut',
    'adjustedRoute' => '/TargetList/{id}/optedOut'
  ],
  64 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  65 => [
    'route' => '/Campaign/unsubscribe/:id',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{id}'
  ],
  66 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\PostUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  67 => [
    'route' => '/Campaign/unsubscribe/:emailAddress/:hash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Modules\\Crm\\Tools\\MassEmail\\Api\\DeleteUnsubscribe',
    'noAuth' => true,
    'adjustedRoute' => '/Campaign/unsubscribe/{emailAddress}/{hash}'
  ],
  68 => [
    'route' => 'EblaUnlink/:scope/:id/:link',
    'method' => 'delete',
    'params' => [
      'controller' => 'EblaUnlink',
      'action' => 'removeLink',
      'scope' => ':scope',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/EblaUnlink/{scope}/{id}/{link}'
  ],
  69 => [
    'route' => '/',
    'method' => 'get',
    'params' => [
      'controller' => 'ApiIndex',
      'action' => 'index'
    ],
    'adjustedRoute' => '/'
  ],
  70 => [
    'route' => '/App/user',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetUser',
    'adjustedRoute' => '/App/user'
  ],
  71 => [
    'route' => '/App/destroyAuthToken',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\PostDestroyAuthToken',
    'adjustedRoute' => '/App/destroyAuthToken'
  ],
  72 => [
    'route' => '/App/about',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\App\\Api\\GetAbout',
    'adjustedRoute' => '/App/about'
  ],
  73 => [
    'route' => '/Metadata',
    'method' => 'get',
    'params' => [
      'controller' => 'Metadata'
    ],
    'adjustedRoute' => '/Metadata'
  ],
  74 => [
    'route' => '/I18n',
    'method' => 'get',
    'params' => [
      'controller' => 'I18n'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/I18n'
  ],
  75 => [
    'route' => '/Settings',
    'method' => 'get',
    'params' => [
      'controller' => 'Settings'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Settings'
  ],
  76 => [
    'route' => '/Settings',
    'method' => 'patch',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  77 => [
    'route' => '/Settings',
    'method' => 'put',
    'params' => [
      'controller' => 'Settings'
    ],
    'adjustedRoute' => '/Settings'
  ],
  78 => [
    'route' => '/Stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'scope' => 'User'
    ],
    'adjustedRoute' => '/Stream'
  ],
  79 => [
    'route' => '/GlobalStream',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetGlobal',
    'adjustedRoute' => '/GlobalStream'
  ],
  80 => [
    'route' => '/GlobalSearch',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\GlobalSearch\\Api\\Get',
    'adjustedRoute' => '/GlobalSearch'
  ],
  81 => [
    'route' => '/LeadCapture/form/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\LeadCapture\\Api\\PostForm',
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/form/{id}'
  ],
  82 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'post',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  83 => [
    'route' => '/LeadCapture/:apiKey',
    'method' => 'options',
    'params' => [
      'controller' => 'LeadCapture',
      'action' => 'leadCapture',
      'apiKey' => ':apiKey'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/LeadCapture/{apiKey}'
  ],
  84 => [
    'route' => '/:controller/action/:action',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  85 => [
    'route' => '/:controller/action/:action',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  86 => [
    'route' => '/:controller/action/:action',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => ':action'
    ],
    'adjustedRoute' => '/{controller}/action/{action}'
  ],
  87 => [
    'route' => '/:controller/layout/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  88 => [
    'route' => '/:controller/layout/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}'
  ],
  89 => [
    'route' => '/:controller/layout/:name/:setId',
    'method' => 'put',
    'params' => [
      'controller' => 'Layout',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/layout/{name}/{setId}'
  ],
  90 => [
    'route' => '/Admin/rebuild',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'rebuild'
    ],
    'adjustedRoute' => '/Admin/rebuild'
  ],
  91 => [
    'route' => '/Admin/clearCache',
    'method' => 'post',
    'params' => [
      'controller' => 'Admin',
      'action' => 'clearCache'
    ],
    'adjustedRoute' => '/Admin/clearCache'
  ],
  92 => [
    'route' => '/Admin/jobs',
    'method' => 'get',
    'params' => [
      'controller' => 'Admin',
      'action' => 'jobs'
    ],
    'adjustedRoute' => '/Admin/jobs'
  ],
  93 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'get',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'read',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  94 => [
    'route' => '/Admin/fieldManager/:scope',
    'method' => 'post',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'create',
      'scope' => ':scope'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}'
  ],
  95 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'put',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  96 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'patch',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'update',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  97 => [
    'route' => '/Admin/fieldManager/:scope/:name',
    'method' => 'delete',
    'params' => [
      'controller' => 'FieldManager',
      'action' => 'delete',
      'scope' => ':scope',
      'name' => ':name'
    ],
    'adjustedRoute' => '/Admin/fieldManager/{scope}/{name}'
  ],
  98 => [
    'route' => '/CurrencyRate',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\Get',
    'adjustedRoute' => '/CurrencyRate'
  ],
  99 => [
    'route' => '/CurrencyRate',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Currency\\Api\\PutUpdate',
    'adjustedRoute' => '/CurrencyRate'
  ],
  100 => [
    'route' => '/Action',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\Action\\Api\\PostProcess',
    'adjustedRoute' => '/Action'
  ],
  101 => [
    'route' => '/MassAction',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostProcess',
    'adjustedRoute' => '/MassAction'
  ],
  102 => [
    'route' => '/MassAction/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\GetStatus',
    'adjustedRoute' => '/MassAction/{id}/status'
  ],
  103 => [
    'route' => '/MassAction/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Core\\MassAction\\Api\\PostSubscribe',
    'adjustedRoute' => '/MassAction/{id}/subscribe'
  ],
  104 => [
    'route' => '/Export',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostProcess',
    'adjustedRoute' => '/Export'
  ],
  105 => [
    'route' => '/Export/:id/status',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\GetStatus',
    'adjustedRoute' => '/Export/{id}/status'
  ],
  106 => [
    'route' => '/Export/:id/subscribe',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Export\\Api\\PostSubscribe',
    'adjustedRoute' => '/Export/{id}/subscribe'
  ],
  107 => [
    'route' => '/Import',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\Post',
    'adjustedRoute' => '/Import'
  ],
  108 => [
    'route' => '/Import/file',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostFile',
    'adjustedRoute' => '/Import/file'
  ],
  109 => [
    'route' => '/Import/:id/revert',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRevert',
    'adjustedRoute' => '/Import/{id}/revert'
  ],
  110 => [
    'route' => '/Import/:id/removeDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostRemoveDuplicates',
    'adjustedRoute' => '/Import/{id}/removeDuplicates'
  ],
  111 => [
    'route' => '/Import/:id/unmarkDuplicates',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostUnmarkDuplicates',
    'adjustedRoute' => '/Import/{id}/unmarkDuplicates'
  ],
  112 => [
    'route' => '/Import/:id/exportErrors',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Import\\Api\\PostExportErrors',
    'adjustedRoute' => '/Import/{id}/exportErrors'
  ],
  113 => [
    'route' => '/Kanban/order',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\PutOrder',
    'adjustedRoute' => '/Kanban/order'
  ],
  114 => [
    'route' => '/Kanban/:entityType',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Kanban\\Api\\GetData',
    'adjustedRoute' => '/Kanban/{entityType}'
  ],
  115 => [
    'route' => '/Attachment/file/:id',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\GetFile',
    'adjustedRoute' => '/Attachment/file/{id}'
  ],
  116 => [
    'route' => '/Attachment/chunk/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostChunk',
    'adjustedRoute' => '/Attachment/chunk/{id}'
  ],
  117 => [
    'route' => '/Attachment/fromImageUrl',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostFromImageUrl',
    'adjustedRoute' => '/Attachment/fromImageUrl'
  ],
  118 => [
    'route' => '/Attachment/copy/:id',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Attachment\\Api\\PostCopy',
    'adjustedRoute' => '/Attachment/copy/{id}'
  ],
  119 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  120 => [
    'route' => '/Note/:id/myReactions/:type',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteMyReactions',
    'adjustedRoute' => '/Note/{id}/myReactions/{type}'
  ],
  121 => [
    'route' => '/Note/:id/reactors/:type',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetNoteReactors',
    'adjustedRoute' => '/Note/{id}/reactors/{type}'
  ],
  122 => [
    'route' => '/EmailTemplate/:id/prepare',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\EmailTemplate\\Api\\PostPrepare',
    'adjustedRoute' => '/EmailTemplate/{id}/prepare'
  ],
  123 => [
    'route' => '/Email/:id/attachments/copy',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostAttachmentsCopy',
    'adjustedRoute' => '/Email/{id}/attachments/copy'
  ],
  124 => [
    'route' => '/Email/importEml',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostImportEml',
    'adjustedRoute' => '/Email/importEml'
  ],
  125 => [
    'route' => '/Email/sendTest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostSendTest',
    'adjustedRoute' => '/Email/sendTest'
  ],
  126 => [
    'route' => '/Email/inbox/read',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  127 => [
    'route' => '/Email/inbox/read',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxRead',
    'adjustedRoute' => '/Email/inbox/read'
  ],
  128 => [
    'route' => '/Email/inbox/important',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  129 => [
    'route' => '/Email/inbox/important',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxImportant',
    'adjustedRoute' => '/Email/inbox/important'
  ],
  130 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  131 => [
    'route' => '/Email/inbox/inTrash',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\DeleteInboxInTrash',
    'adjustedRoute' => '/Email/inbox/inTrash'
  ],
  132 => [
    'route' => '/Email/inbox/folders/:folderId',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostFolder',
    'adjustedRoute' => '/Email/inbox/folders/{folderId}'
  ],
  133 => [
    'route' => '/Email/inbox/notReadCounts',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetNotReadCounts',
    'adjustedRoute' => '/Email/inbox/notReadCounts'
  ],
  134 => [
    'route' => '/Email/insertFieldData',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\GetInsertFieldData',
    'adjustedRoute' => '/Email/insertFieldData'
  ],
  135 => [
    'route' => '/Email/:id/users',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Email\\Api\\PostUsers',
    'adjustedRoute' => '/Email/{id}/users'
  ],
  136 => [
    'route' => '/EmailAddress/search',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\EmailAddress\\Api\\GetSearch',
    'adjustedRoute' => '/EmailAddress/search'
  ],
  137 => [
    'route' => '/User/:id/stream/own',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetOwn',
    'adjustedRoute' => '/User/{id}/stream/own'
  ],
  138 => [
    'route' => '/User/:id/acl',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\GetUserAcl',
    'adjustedRoute' => '/User/{id}/acl'
  ],
  139 => [
    'route' => '/UserSecurity/apiKey/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostApiKeyGenerate',
    'adjustedRoute' => '/UserSecurity/apiKey/generate'
  ],
  140 => [
    'route' => '/UserSecurity/password',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PutPassword',
    'adjustedRoute' => '/UserSecurity/password'
  ],
  141 => [
    'route' => '/UserSecurity/password/recovery',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordRecovery',
    'adjustedRoute' => '/UserSecurity/password/recovery'
  ],
  142 => [
    'route' => '/UserSecurity/password/generate',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordGenerate',
    'adjustedRoute' => '/UserSecurity/password/generate'
  ],
  143 => [
    'route' => '/User/passwordChangeRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostPasswordChangeRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/passwordChangeRequest'
  ],
  144 => [
    'route' => '/User/changePasswordByRequest',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\UserSecurity\\Api\\PostChangePasswordByRequest',
    'noAuth' => true,
    'adjustedRoute' => '/User/changePasswordByRequest'
  ],
  145 => [
    'route' => '/Team/:id/userPosition',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PutTeamUserPosition',
    'adjustedRoute' => '/Team/{id}/userPosition'
  ],
  146 => [
    'route' => '/Oidc/authorizationData',
    'method' => 'get',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'authorizationData'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/authorizationData'
  ],
  147 => [
    'route' => '/Oidc/backchannelLogout',
    'method' => 'post',
    'params' => [
      'controller' => 'Oidc',
      'action' => 'backchannelLogout'
    ],
    'noAuth' => true,
    'adjustedRoute' => '/Oidc/backchannelLogout'
  ],
  148 => [
    'route' => '/:controller/:id',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'read',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  149 => [
    'route' => '/:controller',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'index'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  150 => [
    'route' => '/:controller',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'create'
    ],
    'adjustedRoute' => '/{controller}'
  ],
  151 => [
    'route' => '/:controller/:id',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  152 => [
    'route' => '/:controller/:id',
    'method' => 'patch',
    'params' => [
      'controller' => ':controller',
      'action' => 'update',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  153 => [
    'route' => '/:controller/:id',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'delete',
      'id' => ':id'
    ],
    'adjustedRoute' => '/{controller}/{id}'
  ],
  154 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\GetFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  155 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  156 => [
    'route' => '/:entityType/:id/followers',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteFollowers',
    'adjustedRoute' => '/{entityType}/{id}/followers'
  ],
  157 => [
    'route' => '/:controller/:id/stream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'list',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/stream'
  ],
  158 => [
    'route' => '/:controller/:id/posts',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listPosts',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/posts'
  ],
  159 => [
    'route' => '/:controller/:id/updateStream',
    'method' => 'get',
    'params' => [
      'controller' => 'Stream',
      'action' => 'listUpdates',
      'id' => ':id',
      'scope' => ':controller'
    ],
    'adjustedRoute' => '/{controller}/{id}/updateStream'
  ],
  160 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'put',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'follow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  161 => [
    'route' => '/:controller/:id/subscription',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'id' => ':id',
      'action' => 'unfollow'
    ],
    'adjustedRoute' => '/{controller}/{id}/subscription'
  ],
  162 => [
    'route' => '/:Note/:id/pin',
    'method' => 'post',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\PostNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  163 => [
    'route' => '/:Note/:id/pin',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stream\\Api\\DeleteNotePin',
    'adjustedRoute' => '/{Note}/{id}/pin'
  ],
  164 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'put',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\PutStar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  165 => [
    'route' => '/:entityType/:id/starSubscription',
    'method' => 'delete',
    'actionClassName' => 'Espo\\Tools\\Stars\\Api\\DeleteUnstar',
    'adjustedRoute' => '/{entityType}/{id}/starSubscription'
  ],
  166 => [
    'route' => '/:entityType/:id/usersAccess',
    'method' => 'get',
    'actionClassName' => 'Espo\\Tools\\User\\Api\\PostRecordUsersAccess',
    'adjustedRoute' => '/{entityType}/{id}/usersAccess'
  ],
  167 => [
    'route' => '/:controller/:id/:link',
    'method' => 'get',
    'params' => [
      'controller' => ':controller',
      'action' => 'listLinked',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  168 => [
    'route' => '/:controller/:id/:link',
    'method' => 'post',
    'params' => [
      'controller' => ':controller',
      'action' => 'createLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ],
  169 => [
    'route' => '/:controller/:id/:link',
    'method' => 'delete',
    'params' => [
      'controller' => ':controller',
      'action' => 'removeLink',
      'id' => ':id',
      'link' => ':link'
    ],
    'adjustedRoute' => '/{controller}/{id}/{link}'
  ]
];
