<?php
return (object) [
  'aclDefs' => (object) [
    'ActionHistoryRecord' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\ActionHistoryRecord\\OwnershipChecker'
    ],
    'Attachment' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Attachment\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Attachment\\OwnershipChecker'
    ],
    'AuthToken' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\AuthToken\\AccessChecker'
    ],
    'Email' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Email\\OwnershipChecker',
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\Email\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'linkCheckerClassNameMap' => (object) [
        'parent' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\ParentLinkChecker',
        'teams' => 'Espo\\Classes\\Acl\\Email\\LinkCheckers\\TeamsLinkChecker'
      ]
    ],
    'EmailFilter' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\EmailFilter\\OwnershipChecker'
    ],
    'Import' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Import\\AccessChecker'
    ],
    'ImportEml' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ImportEml\\AccessChecker'
    ],
    'ImportError' => (object) [
      'accessCheckerClassName' => 'Espo\\Core\\Acl\\AccessChecker\\AccessCheckers\\Foreign',
      'link' => 'import'
    ],
    'Note' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Note\\OwnershipChecker',
      'portalAccessCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\AccessChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Note\\OwnershipChecker'
    ],
    'Notification' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Notification\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\Notification\\OwnershipChecker'
    ],
    'Portal' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Portal\\AccessChecker'
    ],
    'ScheduledJob' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\ScheduledJob\\AccessChecker'
    ],
    'Team' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Team\\OwnershipChecker'
    ],
    'User' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\User\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\User\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Classes\\AclPortal\\User\\OwnershipChecker'
    ],
    'Webhook' => (object) [
      'accessCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\AccessChecker',
      'ownershipCheckerClassName' => 'Espo\\Classes\\Acl\\Webhook\\OwnershipChecker'
    ],
    'WorkingTimeRange' => (object) [
      'assignmentCheckerClassName' => 'Espo\\Classes\\Acl\\WorkingTimeRange\\AssignmentChecker'
    ],
    'Account' => (object) [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Account\\OwnershipChecker'
    ],
    'Call' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Call\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'CampaignLogRecord' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignLogRecord\\OwnershipChecker'
    ],
    'CampaignTrackingUrl' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\CampaignTrackingUrl\\OwnershipChecker'
    ],
    'Case' => (object) [
      'linkCheckerClassNameMap' => (object) [
        'lead' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\LeadLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\AccountLinkChecker',
        'contact' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker',
        'contacts' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Case\\LinkCheckers\\ContactLinkChecker'
      ],
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Case\\OwnershipChecker',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Contact' => (object) [
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\Contact\\OwnershipChecker',
      'accountLink' => 'accounts'
    ],
    'Document' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'accounts'
    ],
    'KnowledgeBaseArticle' => (object) [
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\AclPortal\\KnowledgeBaseArticle\\AccessChecker'
    ],
    'MassEmail' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\OwnershipChecker',
      'linkCheckerClassNameMap' => (object) [
        'inboundEmail' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\LinkCheckers\\InboundEmailLinkChecker'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\MassEmail\\AccessChecker'
    ],
    'Meeting' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Meeting\\AssignmentChecker',
      'readOwnerUserField' => 'users',
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Opportunity' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'Task' => (object) [
      'linkCheckerClassNameMap' => (object) [
        'parent' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\ParentLinkChecker',
        'account' => 'Espo\\Modules\\Crm\\Classes\\Acl\\Task\\LinkCheckers\\AccountLinkChecker'
      ],
      'contactLink' => 'contacts',
      'accountLink' => 'account'
    ],
    'BpmnFlowNode' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnFlowNode\\AccessChecker'
    ],
    'BpmnProcess' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\BpmnProcess\\OwnershipChecker'
    ],
    'Report' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\Acl\\Report\\AccessChecker',
      'portalAccessCheckerClassName' => 'Espo\\Modules\\Advanced\\Classes\\AclPortal\\Report\\AccessChecker'
    ],
    'DeliveryOrder' => (object) [
      'accountLink' => 'account'
    ],
    'DeliveryOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryAdjustmentItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'InventoryNumber' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\InventoryNumber\\AccessChecker'
    ],
    'Invoice' => (object) [
      'accountLink' => 'account'
    ],
    'InvoiceItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'OpportunityItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'PriceBook' => (object) [
      'accountLink' => 'accounts',
      'contactLink' => NULL
    ],
    'PriceRule' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\PriceRule\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\PriceRule\\AccessChecker'
    ],
    'ProductPrice' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\ProductPrice\\OwnershipChecker',
      'accessCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\ProductPrice\\AccessChecker'
    ],
    'PurchaseOrder' => (object) [
      'accountLink' => 'account'
    ],
    'PurchaseOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Quote' => (object) [
      'accountLink' => 'account'
    ],
    'QuoteItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReceiptOrder' => (object) [
      'accountLink' => 'account'
    ],
    'ReceiptOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ReturnOrder' => (object) [
      'accountLink' => 'account'
    ],
    'ReturnOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SalesOrder' => (object) [
      'accountLink' => 'account'
    ],
    'SalesOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'SupplierProductPrice' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\SupplierProductPrice\\OwnershipChecker'
    ],
    'TransferOrderItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'ServiceItem' => (object) [
      'ownershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\Acl\\QuoteItem\\OwnershipChecker',
      'portalOwnershipCheckerClassName' => 'Espo\\Modules\\Sales\\Classes\\AclPortal\\QuoteItem\\OwnershipChecker'
    ],
    'Project' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Project\\AccessChecker',
      'linkCheckerClassNameMap' => (object) [
        'members' => 'Espo\\Modules\\Project\\Classes\\Acl\\Project\\LinkCheckers\\Members'
      ]
    ],
    'ProjectColumn' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Common\\AccessCheckers\\Foreign',
      'link' => 'board'
    ],
    'ProjectGroup' => (object) [
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\Common\\AccessCheckers\\Foreign',
      'link' => 'project'
    ],
    'ProjectTask' => (object) [
      'linkCheckerClassNameMap' => (object) [
        'owner' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\LinkCheckers\\Owner'
      ],
      'accessCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\AccessChecker',
      'assignmentCheckerClassName' => 'Espo\\Modules\\Project\\Classes\\Acl\\ProjectTask\\AssignmentChecker'
    ],
    'AWS' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'AWSVersions' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'AccountVBM' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'Analytics' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'AssesmentCompany' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'BillingVendor' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'BucketTimer' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'CAccountEndCustomer' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'CPB' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'accounts'
    ],
    'CPartnerAssessment' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Cisco' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'CiscoDMP' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Citrix' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'CloudConsumption' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Contract' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'ContractGoals' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Country' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DSET' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'DashboardAccess' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DataAnalyticsReport' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Distributor' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'DsetAws' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Earn' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'EmailContent' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'accounts'
    ],
    'ExternalFormPost' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'GooglePartnerAdvantage' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'ISVExperience' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Importer' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'IncentivesVendor' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'KNOW' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'LeadsPartnerCenter' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'LevelUp' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'LevelUpActivities' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Marketing' => (object) [
      'contactLink' => 'contacts',
      'accountLink' => NULL
    ],
    'Messenger' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Migrations' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Notifications' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'NurturingForm' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'OpportunityAWS' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'OpportunityGoogle' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Orders' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PBGeral' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'PartnerID' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'PartnersGoogleCloud' => (object) [
      'contactLink' => 'contact',
      'accountLink' => 'account'
    ],
    'PatchNotes' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Portfolio' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'PrizeRoulette' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'accounts'
    ],
    'Program' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Renewals' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'RocketMargins' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Services' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'ServicesBilling' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'ServicesVersions' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'Sources' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'Surestep' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'TechnicalSupport' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'TourContent' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorAccount' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ],
    'VendorCloudConsumption' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorContract' => (object) [
      'contactLink' => NULL,
      'accountLink' => NULL
    ],
    'VendorSubscription' => (object) [
      'contactLink' => NULL,
      'accountLink' => 'account'
    ]
  ],
  'app' => (object) [
    'acl' => (object) [
      'mandatory' => (object) [
        'scopeLevel' => (object) [
          'Note' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Portal' => (object) [
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Attachment' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailAccount' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFilter' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'EmailFolder' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'GroupEmailFolder' => (object) [
            'read' => 'team',
            'edit' => 'no',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Preferences' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'Notification' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'ActionHistoryRecord' => (object) [
            'read' => 'own'
          ],
          'Role' => false,
          'PortalRole' => false,
          'ImportError' => 'Import',
          'ImportEml' => 'Import',
          'WorkingTimeRange' => 'WorkingTimeCalendar',
          'Stream' => true,
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => 'Campaign',
          'Workflow' => false,
          'WorkflowLogRecord' => false,
          'ReportPanel' => false,
          'BpmnFlowNode' => 'BpmnProcess',
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'InventoryAdjustmentItem' => 'InventoryAdjustment',
          'ProductPrice' => 'PriceBook',
          'PriceRule' => 'PriceBook',
          'SupplierProductPrice' => 'Supplier',
          'ProductAttributeOption' => 'ProductAttribute',
          'ServiceItem' => 'Service',
          'ProjectGroup' => 'Project',
          'ProjectColumn' => 'ProjectBoard',
          'ProjectTask' => 'boolean:Project',
          'ProjectRole' => false,
          'DashboardSet1' => 'DashboardSet',
          'DashboardSet2' => 'DashboardSet',
          'DashboardSet3' => 'DashboardSet',
          'DashboardSet4' => 'DashboardSet',
          'DashboardSet5' => 'DashboardSet',
          'DashboardSet6' => 'DashboardSet',
          'DashboardSet7' => 'DashboardSet',
          'DashboardSet8' => 'DashboardSet',
          'DashboardSet9' => 'DashboardSet',
          'DashboardSet10' => 'DashboardSet',
          'DashboardSet11' => 'DashboardSet',
          'DashboardSet12' => 'DashboardSet',
          'DashboardSet13' => 'DashboardSet',
          'DashboardSet14' => 'DashboardSet',
          'DashboardSet15' => 'DashboardSet',
          'DashboardSet16' => 'DashboardSet',
          'DashboardSet17' => 'DashboardSet',
          'DashboardSet18' => 'DashboardSet',
          'DashboardSet19' => 'DashboardSet',
          'DashboardSet20' => 'DashboardSet',
          'DashboardSet21' => 'DashboardSet',
          'DashboardSet22' => 'DashboardSet',
          'DashboardSet23' => 'DashboardSet',
          'DashboardSet24' => 'DashboardSet',
          'DashboardSet25' => 'DashboardSet',
          'DashboardSet26' => 'DashboardSet',
          'DashboardSet27' => 'DashboardSet',
          'DashboardSet28' => 'DashboardSet',
          'DashboardSet29' => 'DashboardSet',
          'DashboardSet30' => 'DashboardSet',
          'DashboardSet31' => 'DashboardSet',
          'DashboardSet32' => 'DashboardSet',
          'DashboardSet33' => 'DashboardSet',
          'DashboardSet34' => 'DashboardSet',
          'DashboardSet35' => 'DashboardSet',
          'DashboardSet36' => 'DashboardSet',
          'DashboardSet37' => 'DashboardSet',
          'DashboardSet38' => 'DashboardSet',
          'DashboardSet39' => 'DashboardSet',
          'DashboardSet40' => 'DashboardSet',
          'DashboardSet41' => 'DashboardSet',
          'DashboardSet42' => 'DashboardSet',
          'DashboardSet43' => 'DashboardSet',
          'DashboardSet44' => 'DashboardSet',
          'DashboardSet45' => 'DashboardSet',
          'DashboardSet46' => 'DashboardSet',
          'DashboardSet47' => 'DashboardSet',
          'DashboardSet48' => 'DashboardSet',
          'DashboardSet49' => 'DashboardSet',
          'DashboardSet50' => 'DashboardSet',
          'DashboardSet51' => 'DashboardSet',
          'DashboardSet52' => 'DashboardSet',
          'DashboardSet53' => 'DashboardSet',
          'DashboardSet54' => 'DashboardSet',
          'DashboardSet55' => 'DashboardSet',
          'DashboardSet56' => 'DashboardSet',
          'DashboardSet57' => 'DashboardSet',
          'DashboardSet58' => 'DashboardSet',
          'DashboardSet59' => 'DashboardSet',
          'DashboardSet60' => 'DashboardSet',
          'DashboardSet61' => 'DashboardSet',
          'DashboardSet62' => 'DashboardSet',
          'DashboardSet63' => 'DashboardSet',
          'DashboardSet64' => 'DashboardSet',
          'DashboardSet65' => 'DashboardSet',
          'DashboardSet66' => 'DashboardSet',
          'DashboardSet67' => 'DashboardSet',
          'DashboardSet68' => 'DashboardSet',
          'DashboardSet69' => 'DashboardSet',
          'DashboardSet70' => 'DashboardSet',
          'DashboardSet71' => 'DashboardSet',
          'DashboardSet72' => 'DashboardSet',
          'DashboardSet73' => 'DashboardSet',
          'DashboardSet74' => 'DashboardSet',
          'DashboardSet75' => 'DashboardSet',
          'DashboardSet76' => 'DashboardSet',
          'DashboardSet77' => 'DashboardSet',
          'DashboardSet78' => 'DashboardSet',
          'DashboardSet79' => 'DashboardSet',
          'DashboardSet80' => 'DashboardSet'
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'EmailAccount' => (object) [
            'assignedUser' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'EmailFolder' => (object) [
            'assignedUser' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Email' => (object) [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => (object) [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'password' => false,
            'passwordConfirm' => false,
            'auth2FA' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false
          ],
          'ActionHistoryRecord' => (object) [
            'authToken' => false,
            'authLogRecord' => false
          ]
        ]
      ],
      'strictDefault' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'read' => 'own',
            'edit' => 'no'
          ],
          'Team' => (object) [
            'read' => 'team'
          ],
          'Import' => false,
          'Webhook' => false
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'User' => (object) [
            'gender' => false,
            'avatarColor' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Meeting' => (object) [
            'uid' => false
          ],
          'Call' => (object) [
            'uid' => false
          ]
        ]
      ],
      'adminMandatory' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Team' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'Job' => (object) [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Extension' => (object) [
            'create' => 'no',
            'read' => 'all',
            'edit' => 'no',
            'delete' => 'all'
          ],
          'Stream' => true,
          'ImportEml' => 'Import',
          'BpmnFlowchart' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all',
            'stream' => 'all'
          ],
          'InventoryTransaction' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'PriceRuleCondition' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'ProjectGroup' => (object) [
            'create' => 'yes',
            'read' => 'all',
            'edit' => 'all',
            'delete' => 'all'
          ],
          'ProjectColumn' => 'ProjectBoard',
          'ProjectTask' => true
        ]
      ],
      'valuePermissionList' => [
        0 => 'assignmentPermission',
        1 => 'messagePermission',
        2 => 'mentionPermission',
        3 => 'userCalendarPermission',
        4 => 'auditPermission',
        5 => 'exportPermission',
        6 => 'massUpdatePermission',
        7 => 'userPermission',
        8 => 'portalPermission',
        9 => 'groupEmailAccountPermission',
        10 => 'followerManagementPermission',
        11 => 'dataPrivacyPermission'
      ],
      'valuePermissionHighestLevels' => (object) [
        'assignmentPermission' => 'all',
        'userPermission' => 'all',
        'messagePermission' => 'all',
        'portalPermission' => 'yes',
        'groupEmailAccountPermission' => 'all',
        'exportPermission' => 'yes',
        'massUpdatePermission' => 'yes',
        'followerManagementPermission' => 'all',
        'dataPrivacyPermission' => 'yes',
        'auditPermission' => 'yes',
        'mentionPermission' => 'yes',
        'userCalendarPermission' => 'all'
      ],
      'permissionsStrictDefaults' => (object) [
        'assignmentPermission' => 'no',
        'userPermission' => 'no',
        'messagePermission' => 'no',
        'portalPermission' => 'no',
        'groupEmailAccountPermission' => 'no',
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no',
        'followerManagementPermission' => 'no',
        'dataPrivacyPermission' => 'no',
        'auditPermission' => 'no',
        'mentionPermission' => 'no',
        'userCalendarPermission' => 'no'
      ]
    ],
    'aclPortal' => (object) [
      'mandatory' => (object) [
        'scopeLevel' => (object) [
          'User' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'no',
            'stream' => 'no',
            'create' => 'no'
          ],
          'Team' => false,
          'Note' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'Notification' => (object) [
            'read' => 'own',
            'edit' => 'no',
            'delete' => 'own',
            'create' => 'no'
          ],
          'Portal' => false,
          'Attachment' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'own',
            'create' => 'yes'
          ],
          'ExternalAccount' => false,
          'Role' => false,
          'PortalRole' => false,
          'EmailFilter' => false,
          'EmailFolder' => false,
          'EmailAccount' => false,
          'EmailTemplate' => false,
          'ActionHistoryRecord' => (object) [
            'read' => 'own'
          ],
          'Preferences' => (object) [
            'read' => 'own',
            'edit' => 'own',
            'delete' => 'no',
            'create' => 'no'
          ],
          'MassEmail' => 'Campaign',
          'CampaignLogRecord' => 'Campaign',
          'CampaignTrackingUrl' => 'Campaign',
          'EmailQueueItem' => false,
          'QuoteItem' => 'Quote',
          'SalesOrderItem' => 'SalesOrder',
          'InvoiceItem' => 'Invoice',
          'PurchaseOrderItem' => 'PurchaseOrder',
          'DeliveryOrderItem' => 'DeliveryOrder',
          'ReceiptOrderItem' => 'ReceiptOrder',
          'TransferOrderItem' => 'TransferOrder',
          'ReturnOrderItem' => 'ReturnOrder',
          'OpportunityItem' => 'Opportunity',
          'ProductPrice' => 'PriceBook',
          'ServiceItem' => 'Service'
        ],
        'fieldLevel' => (object) [],
        'scopeFieldLevel' => (object) [
          'Preferences' => (object) [
            'smtpServer' => false,
            'smtpPort' => false,
            'smtpSecurity' => false,
            'smtpUsername' => false,
            'smtpPassword' => false,
            'smtpAuth' => false,
            'receiveAssignmentEmailNotifications' => false,
            'receiveMentionEmailNotifications' => false,
            'defaultReminders' => false,
            'autoFollowEntityTypeList' => false,
            'emailReplyForceHtml' => false,
            'emailReplyToAllByDefault' => false,
            'signature' => false,
            'followCreatedEntities' => false,
            'followEntityOnStreamPost' => false,
            'doNotFillAssignedUserIfNotRequired' => false,
            'useCustomTabList' => false,
            'addCustomTabs' => false,
            'tabList' => false,
            'emailUseExternalClient' => false,
            'assignmentNotificationsIgnoreEntityTypeList' => false,
            'assignmentEmailNotificationsIgnoreEntityTypeList' => false,
            'dashletsOptions' => false,
            'dashboardLayout' => false
          ],
          'Call' => (object) [
            'reminders' => false,
            'uid' => false
          ],
          'Meeting' => (object) [
            'reminders' => false,
            'uid' => false
          ],
          'Note' => (object) [
            'isInternal' => false,
            'isGlobal' => false
          ],
          'Email' => (object) [
            'inboundEmails' => false,
            'emailAccounts' => false
          ],
          'User' => (object) [
            'dashboardTemplate' => false,
            'workingTimeCalendar' => false,
            'password' => false,
            'authMethod' => false,
            'apiKey' => false,
            'secretKey' => false,
            'token' => false,
            'isAdmin' => false,
            'type' => false,
            'contact' => false,
            'accounts' => false,
            'account' => false,
            'portalRoles' => false,
            'portals' => false,
            'roles' => false,
            'defaultTeam' => false,
            'auth2FA' => false,
            'isActive' => false
          ],
          'ActionHistoryRecord' => (object) [
            'authToken' => false,
            'authLogRecord' => false
          ],
          'Case' => (object) [
            'isInternal' => false
          ],
          'Report' => (object) [
            'portals' => false,
            'assignedUser' => false,
            'teams' => false,
            'emailSendingInterval' => false,
            'emailSendingSettingMonth' => false,
            'emailSendingSettingDay' => false,
            'emailSendingSettingWeekdays' => false,
            'emailSendingTime' => false,
            'emailSendingUsers' => false,
            'emailSendingLastDateSent' => false,
            'emailSendingDoNotSendEmptyReport' => false,
            'applyAcl' => false
          ]
        ]
      ],
      'strictDefault' => (object) [
        'scopeLevel' => (object) [],
        'fieldLevel' => (object) [
          'assignedUser' => (object) [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'assignedUsers' => (object) [
            'read' => 'yes',
            'edit' => 'no'
          ],
          'collaborators' => false,
          'teams' => false
        ],
        'scopeFieldLevel' => (object) [
          'User' => (object) [
            'gender' => false
          ],
          'KnowledgeBaseArticle' => (object) [
            'portals' => false,
            'order' => false,
            'status' => false,
            'assignedUser' => false
          ],
          'Call' => (object) [
            'users' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Meeting' => (object) [
            'users' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ],
            'leads' => false
          ],
          'Case' => (object) [
            'status' => (object) [
              'read' => 'yes',
              'edit' => 'no'
            ]
          ],
          'Report' => (object) [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ],
      'valuePermissionList' => [
        0 => 'exportPermission',
        1 => 'massUpdatePermission'
      ],
      'permissionsStrictDefaults' => (object) [
        'exportPermission' => 'no',
        'massUpdatePermission' => 'no'
      ],
      'default' => (object) [
        'scopeFieldLevel' => (object) [
          'Report' => (object) [
            'modifiedAt' => false,
            'modifiedBy' => false,
            'createdAt' => false,
            'createdBy' => false
          ]
        ]
      ]
    ],
    'actions' => (object) [
      'convertCurrency' => (object) [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\ConvertCurrency'
      ],
      'merge' => (object) [
        'implementationClassName' => 'Espo\\Core\\Action\\Actions\\Merge'
      ]
    ],
    'addressFormats' => (object) [
      1 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter1'
      ],
      2 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter2'
      ],
      3 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter3'
      ],
      4 => (object) [
        'formatterClassName' => 'Espo\\Classes\\AddressFormatters\\Formatter4'
      ]
    ],
    'adminPanel' => (object) [
      'system' => (object) [
        'label' => 'System',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/settings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'settings',
            'recordView' => 'views/admin/settings'
          ],
          1 => (object) [
            'url' => '#Admin/userInterface',
            'label' => 'User Interface',
            'iconClass' => 'fas fa-desktop',
            'description' => 'userInterface',
            'recordView' => 'views/admin/user-interface'
          ],
          2 => (object) [
            'url' => '#Admin/authentication',
            'label' => 'Authentication',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authentication',
            'recordView' => 'views/admin/authentication'
          ],
          3 => (object) [
            'url' => '#ScheduledJob',
            'label' => 'Scheduled Jobs',
            'iconClass' => 'fas fa-clock',
            'description' => 'scheduledJob'
          ],
          4 => (object) [
            'url' => '#Admin/currency',
            'label' => 'Currency',
            'iconClass' => 'fas fa-euro-sign',
            'description' => 'currency',
            'recordView' => 'views/admin/currency'
          ],
          5 => (object) [
            'url' => '#Admin/notifications',
            'label' => 'Notifications',
            'iconClass' => 'fas fa-bell',
            'description' => 'notifications',
            'recordView' => 'views/admin/notifications'
          ],
          6 => (object) [
            'url' => '#Admin/integrations',
            'label' => 'Integrations',
            'iconClass' => 'fas fa-network-wired',
            'description' => 'integrations'
          ],
          7 => (object) [
            'url' => '#Admin/extensions',
            'label' => 'Extensions',
            'iconClass' => 'fas fa-upload',
            'description' => 'extensions'
          ],
          8 => (object) [
            'url' => '#Admin/systemRequirements',
            'label' => 'System Requirements',
            'iconClass' => 'fas fa-server',
            'description' => 'systemRequirements'
          ],
          9 => (object) [
            'url' => '#Admin/jobsSettings',
            'label' => 'Job Settings',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobsSettings',
            'recordView' => 'views/admin/jobs-settings'
          ],
          10 => (object) [
            'url' => '#Admin/upgrade',
            'label' => 'Upgrade',
            'iconClass' => 'fas fa-arrow-alt-circle-up',
            'description' => 'upgrade',
            'view' => 'views/admin/upgrade/index'
          ],
          11 => (object) [
            'action' => 'clearCache',
            'label' => 'Clear Cache',
            'iconClass' => 'fas fa-broom',
            'description' => 'clearCache'
          ],
          12 => (object) [
            'action' => 'rebuild',
            'label' => 'Rebuild',
            'iconClass' => 'fas fa-database',
            'description' => 'rebuild'
          ]
        ],
        'order' => 0
      ],
      'users' => (object) [
        'label' => 'Users',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/users',
            'label' => 'Users',
            'iconClass' => 'fas fa-user',
            'description' => 'users',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/teams',
            'label' => 'Teams',
            'iconClass' => 'fas fa-users',
            'description' => 'teams',
            'tabQuickSearch' => true
          ],
          2 => (object) [
            'url' => '#Admin/roles',
            'label' => 'Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'roles',
            'tabQuickSearch' => true
          ],
          3 => (object) [
            'url' => '#Admin/authLog',
            'label' => 'Auth Log',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authLog'
          ],
          4 => (object) [
            'url' => '#Admin/authTokens',
            'label' => 'Auth Tokens',
            'iconClass' => 'fas fa-shield-alt',
            'description' => 'authTokens'
          ],
          5 => (object) [
            'url' => '#Admin/actionHistory',
            'label' => 'Action History',
            'iconClass' => 'fas fa-history',
            'description' => 'actionHistory'
          ],
          6 => (object) [
            'url' => '#Admin/apiUsers',
            'label' => 'API Users',
            'iconClass' => 'fas fa-user-cog',
            'description' => 'apiUsers'
          ]
        ],
        'order' => 5
      ],
      'customization' => (object) [
        'label' => 'Customization',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/entityManager',
            'label' => 'Entity Manager',
            'iconClass' => 'fas fa-tools',
            'description' => 'entityManager',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/layouts',
            'label' => 'Layout Manager',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutManager'
          ],
          2 => (object) [
            'url' => '#Admin/labelManager',
            'label' => 'Label Manager',
            'iconClass' => 'fas fa-language',
            'description' => 'labelManager'
          ],
          3 => (object) [
            'url' => '#Admin/templateManager',
            'label' => 'Template Manager',
            'iconClass' => 'fas fa-envelope-open-text',
            'description' => 'templateManager'
          ],
          4 => (object) [
            'url' => '#ReportFilter',
            'label' => 'Report Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'reportFilters'
          ],
          5 => (object) [
            'url' => '#ReportPanel',
            'label' => 'Report Panels',
            'iconClass' => 'fas fa-chart-area',
            'description' => 'reportPanels'
          ]
        ],
        'order' => 10
      ],
      'email' => (object) [
        'label' => 'Messaging',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/outboundEmails',
            'label' => 'Outbound Emails',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'outboundEmails',
            'recordView' => 'views/admin/outbound-emails'
          ],
          1 => (object) [
            'url' => '#Admin/inboundEmails',
            'label' => 'Inbound Emails',
            'iconClass' => 'fas fa-envelope',
            'description' => 'inboundEmails',
            'recordView' => 'views/admin/inbound-emails'
          ],
          2 => (object) [
            'url' => '#Admin/groupEmailAccounts',
            'label' => 'Group Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'groupEmailAccounts'
          ],
          3 => (object) [
            'url' => '#Admin/personalEmailAccounts',
            'label' => 'Personal Email Accounts',
            'iconClass' => 'fas fa-inbox',
            'description' => 'personalEmailAccounts'
          ],
          4 => (object) [
            'url' => '#Admin/emailFilters',
            'label' => 'Email Filters',
            'iconClass' => 'fas fa-filter',
            'description' => 'emailFilters'
          ],
          5 => (object) [
            'url' => '#Admin/groupEmailFolders',
            'label' => 'Group Email Folders',
            'iconClass' => 'fas fa-folder',
            'description' => 'groupEmailFolders'
          ],
          6 => (object) [
            'url' => '#Admin/emailTemplates',
            'label' => 'Email Templates',
            'iconClass' => 'fas fa-envelope-square',
            'description' => 'emailTemplates'
          ],
          7 => (object) [
            'url' => '#Admin/sms',
            'label' => 'SMS',
            'iconClass' => 'fas fa-paper-plane',
            'description' => 'sms',
            'recordView' => 'views/admin/sms'
          ]
        ],
        'order' => 15
      ],
      'portal' => (object) [
        'label' => 'Portal',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/portals',
            'label' => 'Portals',
            'iconClass' => 'fas fa-parking',
            'description' => 'portals'
          ],
          1 => (object) [
            'url' => '#Admin/portalUsers',
            'label' => 'Portal Users',
            'iconClass' => 'fas fa-user',
            'description' => 'portalUsers',
            'tabQuickSearch' => true
          ],
          2 => (object) [
            'url' => '#Admin/portalRoles',
            'label' => 'Portal Roles',
            'iconClass' => 'fas fa-key',
            'description' => 'portalRoles'
          ]
        ],
        'order' => 20
      ],
      'setup' => (object) [
        'label' => 'Setup',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/workingTimeCalendar',
            'label' => 'Working Time Calendars',
            'iconClass' => 'far fa-calendar-alt',
            'description' => 'workingTimeCalendars',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#Admin/layoutSets',
            'label' => 'Layout Sets',
            'iconClass' => 'fas fa-table',
            'description' => 'layoutSets'
          ],
          2 => (object) [
            'url' => '#Admin/dashboardTemplates',
            'label' => 'Dashboard Templates',
            'iconClass' => 'fas fa-th-large',
            'description' => 'dashboardTemplates'
          ],
          3 => (object) [
            'url' => '#Admin/leadCapture',
            'label' => 'Lead Capture',
            'iconClass' => 'fas fa-id-card',
            'description' => 'leadCapture'
          ],
          4 => (object) [
            'url' => '#Admin/pdfTemplates',
            'label' => 'PDF Templates',
            'iconClass' => 'fas fa-file-pdf',
            'description' => 'pdfTemplates'
          ],
          5 => (object) [
            'url' => '#Admin/webhooks',
            'label' => 'Webhooks',
            'iconClass' => 'fas fa-share-alt icon-rotate-90',
            'description' => 'webhooks'
          ],
          6 => (object) [
            'url' => '#Admin/addressCountries',
            'label' => 'Address Countries',
            'iconClass' => 'far fa-flag',
            'description' => 'addressCountries'
          ],
          7 => (object) [
            'url' => '#Admin/authenticationProviders',
            'label' => 'Authentication Providers',
            'iconClass' => 'fas fa-sign-in-alt',
            'description' => 'authenticationProviders'
          ]
        ],
        'order' => 24
      ],
      'data' => (object) [
        'label' => 'Data',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/import',
            'label' => 'Import',
            'iconClass' => 'fas fa-file-import',
            'description' => 'import'
          ],
          1 => (object) [
            'url' => '#Admin/attachments',
            'label' => 'Attachments',
            'iconClass' => 'fas fa-paperclip',
            'description' => 'attachments'
          ],
          2 => (object) [
            'url' => '#Admin/jobs',
            'label' => 'Jobs',
            'iconClass' => 'fas fa-list-ul',
            'description' => 'jobs'
          ],
          3 => (object) [
            'url' => '#Admin/emailAddresses',
            'label' => 'Email Addresses',
            'iconClass' => 'fas fa-envelope',
            'description' => 'emailAddresses'
          ],
          4 => (object) [
            'url' => '#Admin/phoneNumbers',
            'label' => 'Phone Numbers',
            'iconClass' => 'fas fa-phone',
            'description' => 'phoneNumbers'
          ],
          5 => (object) [
            'url' => '#Admin/appSecrets',
            'label' => 'App Secrets',
            'iconClass' => 'fas fa-key',
            'description' => 'appSecrets'
          ],
          6 => (object) [
            'url' => '#Admin/appLog',
            'label' => 'App Log',
            'iconClass' => 'fas fa-list',
            'description' => 'appLog'
          ]
        ],
        'order' => 25
      ],
      'misc' => (object) [
        'label' => 'Misc',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/formulaSandbox',
            'label' => 'Formula Sandbox',
            'iconClass' => 'fas fa-code',
            'description' => 'formulaSandbox',
            'view' => 'views/admin/formula-sandbox/index'
          ]
        ],
        'order' => 26
      ],
      'workflows' => (object) [
        'label' => 'Workflow Manager',
        'itemList' => [
          0 => (object) [
            'url' => '#Workflow',
            'label' => 'Workflow Manager',
            'iconClass' => 'fas fa-code-branch icon-rotate-180',
            'description' => 'workflowManager',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 99
      ],
      'bpmn' => (object) [
        'label' => 'Business Process Management',
        'itemList' => [
          0 => (object) [
            'url' => '#BpmnFlowchart',
            'label' => 'Flowcharts',
            'iconClass' => 'fas fa-project-diagram',
            'description' => 'bpmnFlowcharts',
            'tabQuickSearch' => true
          ],
          1 => (object) [
            'url' => '#BpmnProcess',
            'label' => 'Processes',
            'iconClass' => 'fas fa-cogs',
            'description' => 'bpmnProcesses',
            'tabQuickSearch' => true
          ]
        ],
        'order' => 100
      ],
      'salesPack' => (object) [
        'label' => 'Sales Pack',
        'itemList' => [
          0 => (object) [
            'url' => '#Admin/salesPackSettings',
            'label' => 'Settings',
            'iconClass' => 'fas fa-cog',
            'description' => 'salesPackSettings',
            'recordView' => 'sales:views/settings/record/settings'
          ],
          1 => (object) [
            'url' => '#PriceRuleCondition',
            'label' => 'Price Rule Conditions',
            'iconClass' => 'fas fa-code',
            'description' => 'priceRuleConditions'
          ]
        ]
      ]
    ],
    'api' => (object) [
      'globalMiddlewareClassNameList' => [],
      'routeMiddlewareClassNameListMap' => (object) [],
      'controllerMiddlewareClassNameListMap' => (object) [],
      'controllerActionMiddlewareClassNameListMap' => (object) []
    ],
    'appParams' => (object) [
      'templateEntityTypeList' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\TemplateEntityTypeList'
      ],
      'extensions' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\Extensions'
      ],
      'addressCountryData' => (object) [
        'className' => 'Espo\\Classes\\AppParams\\AddressCountryData'
      ],
      'flowchartEntityTypeList' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\AppParams\\FlowchartEntityTypeList'
      ],
      'manualWorkflows' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Classes\\AppParams\\ManualWorkflows'
      ],
      'defaultTaxRateQuote' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateQuote'
      ],
      'defaultTaxRateSalesOrder' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateSalesOrder'
      ],
      'defaultTaxRateInvoice' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRateInvoice'
      ],
      'defaultTaxRatePurchaseOrder' => (object) [
        'className' => 'Espo\\Modules\\Sales\\AppParams\\DefaultTaxRatePurchaseOrder'
      ],
      'projectBoards' => (object) [
        'className' => 'Espo\\Modules\\Project\\Classes\\AppParams\\ProjectBoards'
      ],
      'projectRoles' => (object) [
        'className' => 'Espo\\Modules\\Project\\Classes\\AppParams\\ProjectRoles'
      ]
    ],
    'authentication' => (object) [
      'beforeLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedAttemptsLimit',
        1 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\FailedCodeAttemptsLimit'
      ],
      'onLoginHookClassNameList' => [
        0 => 'Espo\\Core\\Authentication\\Hook\\Hooks\\IpAddressWhitelist'
      ],
      'onFailHookClassNameList' => [],
      'onSuccessHookClassNameList' => [],
      'onSuccessByTokenHookClassNameList' => [],
      'onSecondStepRequiredHookClassNameList' => []
    ],
    'authentication2FAMethods' => (object) [
      'Totp' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/totp',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Totp\\TotpUserSetup'
      ],
      'Email' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-email',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Email\\EmailUserSetup'
      ],
      'Sms' => (object) [
        'settings' => (object) [
          'isAvailable' => true
        ],
        'userApplyView' => 'views/user-security/modals/two-factor-sms',
        'loginClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsLogin',
        'userSetupClassName' => 'Espo\\Core\\Authentication\\TwoFactor\\Sms\\SmsUserSetup'
      ]
    ],
    'cleanup' => (object) [
      'reminders' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Reminders',
        'order' => 10
      ],
      'webhookQueue' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\WebhookQueue',
        'order' => 11
      ],
      'twoFactorCodes' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\TwoFactorCodes'
      ],
      'massActions' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\MassActions'
      ],
      'exports' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Exports'
      ],
      'passwordChangeRequests' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\PasswordChangeRequests'
      ],
      'subscribers' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Subscribers'
      ],
      'audit' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Audit'
      ],
      'stars' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\Stars'
      ],
      'appLog' => (object) [
        'className' => 'Espo\\Classes\\Cleanup\\AppLog'
      ],
      'workflowLog' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\WorkflowLog',
        'order' => 20
      ],
      'advancedPack' => (object) [
        'className' => 'Espo\\Modules\\Advanced\\Core\\Cleanup\\Integrity'
      ],
      'salesIntegrity' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\Cleanup\\Integrity'
      ],
      'subProjectTasks' => (object) [
        'className' => 'Espo\\Modules\\Project\\Classes\\Cleanup\\SubProjectTasks'
      ],
      'projectIntegrity' => (object) [
        'className' => 'Espo\\Modules\\Project\\Classes\\Cleanup\\Integrity'
      ]
    ],
    'client' => (object) [
      'scriptList' => [
        0 => 'client/lib/espo.js',
        1 => 'client/lib/espo-main.js',
        2 => 'client/custom/modules/ebla-link-pro/src/ebla-link-pro-script.js',
        3 => 'client/custom/modules/dubas-custom/lib/init.js',
        4 => 'client/custom/modules/project/lib/init.js',
        5 => 'client/custom/modules/ebla-kanban-multiple/src/ebla-kanban-multiple-script.js',
        6 => 'client/custom/modules/enube/patchNotes.js'
      ],
      'developerModeScriptList' => [
        0 => 'client/src/loader.js',
        1 => 'client/custom/modules/ebla-link-pro/src/ebla-link-pro-script.js',
        2 => 'client/custom/modules/ebla-kanban-multiple/src/ebla-kanban-multiple-script.js'
      ],
      'linkList' => [
        0 => (object) [
          'href' => 'client/fonts/inter/Inter-Regular.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        1 => (object) [
          'href' => 'client/fonts/inter/Inter-Medium.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        2 => (object) [
          'href' => 'client/fonts/inter/Inter-SemiBold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        3 => (object) [
          'href' => 'client/fonts/inter/Inter-Bold.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        4 => (object) [
          'href' => 'client/fonts/fa-solid-900.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ],
        5 => (object) [
          'href' => 'client/fonts/fa-regular-400.woff2',
          'as' => 'font',
          'type' => 'font/woff2',
          'rel' => 'preload',
          'noTimestamp' => true,
          'crossorigin' => true
        ]
      ],
      'developerModeCssList' => [
        0 => 'client/custom/modules/ebla-link-pro/css/ebla-link-pro.css'
      ],
      'cssList' => [
        0 => 'client/custom/modules/ebla-link-pro/css/ebla-link-pro.css',
        1 => 'client/custom/css/style.css'
      ]
    ],
    'clientNavbar' => (object) [
      'items' => (object) [
        'globalSearch' => (object) [
          'view' => 'views/global-search/global-search',
          'class' => 'navbar-form global-search-container',
          'order' => 5,
          'disabled' => false
        ],
        'quickCreate' => (object) [
          'view' => 'views/site/navbar/quick-create',
          'class' => 'dropdown hidden-xs quick-create-container',
          'order' => 10,
          'disabled' => false
        ],
        'notificationBadge' => (object) [
          'view' => 'views/notification/badge',
          'class' => 'dropdown notifications-badge-container',
          'order' => 15,
          'disabled' => false
        ]
      ],
      'menuItems' => (object) [
        'admin' => (object) [
          'order' => 0,
          'groupIndex' => 1,
          'link' => '#Admin',
          'labelTranslation' => 'Global.labels.Administration',
          'accessDataList' => [
            0 => (object) [
              'isAdminOnly' => true
            ]
          ]
        ],
        'preferences' => (object) [
          'order' => 1,
          'groupIndex' => 1,
          'link' => '#Preferences',
          'labelTranslation' => 'Global.labels.Preferences'
        ],
        'lastViewed' => (object) [
          'order' => 0,
          'groupIndex' => 5,
          'link' => '#LastViewed',
          'labelTranslation' => 'Global.scopeNamesPlural.LastViewed',
          'configCheck' => '!actionHistoryDisabled',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'lastViewed'
        ],
        'about' => (object) [
          'order' => 0,
          'groupIndex' => 10,
          'link' => '#About',
          'labelTranslation' => 'Global.labels.About'
        ],
        'logout' => (object) [
          'order' => 1,
          'groupIndex' => 10,
          'labelTranslation' => 'Global.labels.Log Out',
          'handler' => 'handlers/navbar-menu',
          'actionFunction' => 'logout'
        ]
      ]
    ],
    'clientRecord' => (object) [
      'panels' => (object) [
        'activities' => (object) [
          'name' => 'activities',
          'label' => 'Activities',
          'view' => 'crm:views/record/panels/activities',
          'aclScope' => 'Activities'
        ],
        'history' => (object) [
          'name' => 'history',
          'label' => 'History',
          'view' => 'crm:views/record/panels/history',
          'aclScope' => 'Activities'
        ],
        'tasks' => (object) [
          'name' => 'tasks',
          'label' => 'Tasks',
          'view' => 'crm:views/record/panels/tasks',
          'aclScope' => 'Task'
        ]
      ]
    ],
    'clientRoutes' => (object) [
      'AddressMap/view/:entityType/:id/:field' => (object) [
        'params' => (object) [
          'controller' => 'AddressMap',
          'action' => 'view'
        ]
      ],
      'Admin/:page' => (object) [
        'params' => (object) [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      'Admin/:page/:options' => (object) [
        'params' => (object) [
          'controller' => 'Admin',
          'action' => 'page'
        ],
        'order' => 1
      ],
      ':entityType/activities/:id/:targetEntityType' => (object) [
        'params' => (object) [
          'controller' => 'Activities',
          'action' => 'activities'
        ],
        'order' => 1
      ],
      ':entityType/history/:id/:targetEntityType' => (object) [
        'params' => (object) [
          'controller' => 'Activities',
          'action' => 'history'
        ],
        'order' => 1
      ],
      'Report/show/:id' => (object) [
        'params' => (object) [
          'controller' => 'Report',
          'action' => 'show'
        ]
      ]
    ],
    'complexExpression' => (object) [
      'functionList' => [
        0 => (object) [
          'name' => 'EQUAL',
          'insertText' => 'EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        1 => (object) [
          'name' => 'NOT_EQUAL',
          'insertText' => 'NOT_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        2 => (object) [
          'name' => 'OR',
          'insertText' => 'OR:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        3 => (object) [
          'name' => 'AND',
          'insertText' => 'AND:(EXPR1, EXPR2)',
          'returnType' => 'bool'
        ],
        4 => (object) [
          'name' => 'NOT',
          'insertText' => 'NOT:(EXPR)',
          'returnType' => 'bool'
        ],
        5 => (object) [
          'name' => 'LIKE',
          'insertText' => 'LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        6 => (object) [
          'name' => 'NOT_LIKE',
          'insertText' => 'NOT_LIKE:(VALUE, \'pattern%\')',
          'returnType' => 'bool'
        ],
        7 => (object) [
          'name' => 'GREATER_THAN',
          'insertText' => 'GREATER_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        8 => (object) [
          'name' => 'LESS_THAN',
          'insertText' => 'LESS_THAN:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        9 => (object) [
          'name' => 'GREATER_THAN_OR_EQUAL',
          'insertText' => 'GREATER_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        10 => (object) [
          'name' => 'LESS_THAN_OR_EQUAL',
          'insertText' => 'LESS_THAN_OR_EQUAL:(VALUE1, VALUE2)',
          'returnType' => 'bool'
        ],
        11 => (object) [
          'name' => 'IS_NULL',
          'insertText' => 'IS_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        12 => (object) [
          'name' => 'IS_NOT_NULL',
          'insertText' => 'IS_NOT_NULL:(VALUE)',
          'returnType' => 'bool'
        ],
        13 => (object) [
          'name' => 'IN',
          'insertText' => 'IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        14 => (object) [
          'name' => 'NOT_IN',
          'insertText' => 'NOT_IN:(VALUE, VALUE1, VALUE2, VALUE3)',
          'returnType' => 'bool'
        ],
        15 => (object) [
          'name' => 'IF',
          'insertText' => 'IF:(CONDITION, THEN_VALUE, ELSE_VALUE)'
        ],
        16 => (object) [
          'name' => 'SWITCH',
          'insertText' => 'SWITCH:(CONDITION1, VALUE1, CONDITION2, VALUE2, ELSE_VALUE)'
        ],
        17 => (object) [
          'name' => 'MAP',
          'insertText' => 'MAP:(EXPR, WHEN_VALUE1, THEN_VALUE1, WHEN_VALUE2, THEN_VALUE2, ELSE_VALUE)'
        ],
        18 => (object) [
          'name' => 'MONTH_NUMBER',
          'insertText' => 'MONTH_NUMBER:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        19 => (object) [
          'name' => 'WEEK_NUMBER_0',
          'insertText' => 'WEEK_NUMBER_0:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        20 => (object) [
          'name' => 'WEEK_NUMBER_1',
          'insertText' => 'WEEK_NUMBER_1:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        21 => (object) [
          'name' => 'DAYOFWEEK',
          'insertText' => 'DAYOFWEEK:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        22 => (object) [
          'name' => 'DAYOFMONTH',
          'insertText' => 'DAYOFMONTH:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        23 => (object) [
          'name' => 'YEAR',
          'insertText' => 'YEAR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        24 => (object) [
          'name' => 'HOUR',
          'insertText' => 'HOUR:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        25 => (object) [
          'name' => 'MINUTE',
          'insertText' => 'MINUTE:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        26 => (object) [
          'name' => 'MONTH',
          'insertText' => 'MONTH:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        27 => (object) [
          'name' => 'QUARTER',
          'insertText' => 'QUARTER:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        28 => (object) [
          'name' => 'WEEK',
          'insertText' => 'WEEK:(DATE_VALUE)',
          'returnType' => 'string'
        ],
        29 => (object) [
          'name' => 'NOW',
          'insertText' => 'NOW:()',
          'returnType' => 'string'
        ],
        30 => (object) [
          'name' => 'TZ',
          'insertText' => 'TZ:(DATE_VALUE, OFFSET)',
          'returnType' => 'string'
        ],
        31 => (object) [
          'name' => 'UNIX_TIMESTAMP',
          'insertText' => 'UNIX_TIMESTAMP:(DATE_VALUE)',
          'returnType' => 'int'
        ],
        32 => (object) [
          'name' => 'TIMESTAMPDIFF_YEAR',
          'insertText' => 'TIMESTAMPDIFF_YEAR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        33 => (object) [
          'name' => 'TIMESTAMPDIFF_MONTH',
          'insertText' => 'TIMESTAMPDIFF_MONTH:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        34 => (object) [
          'name' => 'TIMESTAMPDIFF_WEEK',
          'insertText' => 'TIMESTAMPDIFF_WEEK:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        35 => (object) [
          'name' => 'TIMESTAMPDIFF_DAY',
          'insertText' => 'TIMESTAMPDIFF_DAY:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        36 => (object) [
          'name' => 'TIMESTAMPDIFF_HOUR',
          'insertText' => 'TIMESTAMPDIFF_HOUR:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        37 => (object) [
          'name' => 'TIMESTAMPDIFF_MINUTE',
          'insertText' => 'TIMESTAMPDIFF_MINUTE:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        38 => (object) [
          'name' => 'TIMESTAMPDIFF_SECOND',
          'insertText' => 'TIMESTAMPDIFF_SECOND:(DATE_FROM, DATE_TO)',
          'returnType' => 'int'
        ],
        39 => (object) [
          'name' => 'CONCAT',
          'insertText' => 'CONCAT:(STRING1, STRING2)',
          'returnType' => 'string'
        ],
        40 => (object) [
          'name' => 'LEFT',
          'insertText' => 'LEFT:(STRING, NUMBER_OF_CHARACTERS)',
          'returnType' => 'string'
        ],
        41 => (object) [
          'name' => 'LOWER',
          'insertText' => 'LOWER:(STRING)',
          'returnType' => 'string'
        ],
        42 => (object) [
          'name' => 'UPPER',
          'insertText' => 'UPPER:(STRING)',
          'returnType' => 'string'
        ],
        43 => (object) [
          'name' => 'TRIM',
          'insertText' => 'TRIM:(STRING)',
          'returnType' => 'string'
        ],
        44 => (object) [
          'name' => 'CHAR_LENGTH',
          'insertText' => 'CHAR_LENGTH:(STRING)',
          'returnType' => 'int'
        ],
        45 => (object) [
          'name' => 'BINARY',
          'insertText' => 'BINARY:(STRING)',
          'returnType' => 'string'
        ],
        46 => (object) [
          'name' => 'REPLACE',
          'insertText' => 'REPLACE:(HAYSTACK, NEEDLE, REPLACE_WITH)',
          'returnType' => 'string'
        ],
        47 => (object) [
          'name' => 'ADD',
          'insertText' => 'ADD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        48 => (object) [
          'name' => 'SUB',
          'insertText' => 'SUB:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        49 => (object) [
          'name' => 'MUL',
          'insertText' => 'MUL:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        50 => (object) [
          'name' => 'DIV',
          'insertText' => 'DIV:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        51 => (object) [
          'name' => 'MOD',
          'insertText' => 'MOD:(VALUE1, VALUE2)',
          'returnType' => 'float'
        ],
        52 => (object) [
          'name' => 'FLOOR',
          'insertText' => 'FLOOR:(VALUE)',
          'returnType' => 'int'
        ],
        53 => (object) [
          'name' => 'CEIL',
          'insertText' => 'CEIL:(VALUE)',
          'returnType' => 'int'
        ],
        54 => (object) [
          'name' => 'ROUND',
          'insertText' => 'ROUND:(VALUE, PRECISION)',
          'returnType' => 'float'
        ],
        55 => (object) [
          'name' => 'COUNT',
          'insertText' => 'COUNT:(EXPR)',
          'returnType' => 'int'
        ],
        56 => (object) [
          'name' => 'SUM',
          'insertText' => 'SUM:(EXPR)',
          'returnType' => 'int|float'
        ],
        57 => (object) [
          'name' => 'AVG',
          'insertText' => 'AVG:(EXPR)',
          'returnType' => 'float'
        ],
        58 => (object) [
          'name' => 'MAX',
          'insertText' => 'MAX:(EXPR)',
          'returnType' => 'int|float'
        ],
        59 => (object) [
          'name' => 'MIN',
          'insertText' => 'MIN:(EXPR)',
          'returnType' => 'int|float'
        ]
      ]
    ],
    'config' => (object) [
      'entityTypeListParamList' => [
        0 => 'tabList',
        1 => 'quickCreateList',
        2 => 'globalSearchEntityList',
        3 => 'assignmentEmailNotificationsEntityList',
        4 => 'assignmentNotificationsEntityList',
        5 => 'calendarEntityList',
        6 => 'streamEmailNotificationsEntityList',
        7 => 'activitiesEntityList',
        8 => 'historyEntityList',
        9 => 'streamEmailNotificationsTypeList',
        10 => 'emailKeepParentTeamsEntityList'
      ],
      'params' => (object) [
        'isDeveloperMode' => (object) [
          'readOnly' => true
        ],
        'clientSecurityHeadersDisabled' => (object) [
          'readOnly' => true
        ],
        'clientCspDisabled' => (object) [
          'readOnly' => true
        ],
        'clientCspScriptSourceList' => (object) [
          'readOnly' => true
        ],
        'clientStrictTransportSecurityHeaderDisabled' => (object) [
          'readOnly' => true
        ],
        'clientXFrameOptionsHeaderDisabled' => (object) [
          'readOnly' => true
        ],
        'systemUserId' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smtpPassword' => (object) [
          'level' => 'internal'
        ],
        'awsS3Storage' => (object) [
          'level' => 'system'
        ],
        'defaultFileStorage' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'smsProvider' => (object) [
          'level' => 'admin'
        ],
        'authAnotherUserDisabled' => (object) [
          'level' => 'admin',
          'readOnly' => true
        ],
        'userNameRegularExpression' => (object) [
          'readOnly' => true
        ],
        'workingTimeCalendar' => (object) [
          'level' => 'admin'
        ],
        'ldapPassword' => (object) [
          'level' => 'internal'
        ],
        'oidcClientId' => (object) [
          'level' => 'admin'
        ],
        'oidcClientSecret' => (object) [
          'level' => 'internal'
        ],
        'oidcAuthorizationEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcTokenEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcJwksEndpoint' => (object) [
          'level' => 'admin'
        ],
        'oidcJwksCachePeriod' => (object) [
          'level' => 'admin'
        ],
        'oidcJwtSignatureAlgorithmList' => (object) [
          'level' => 'admin'
        ],
        'oidcScopes' => (object) [
          'level' => 'admin'
        ],
        'oidcGroupClaim' => (object) [
          'level' => 'admin'
        ],
        'oidcCreateUser' => (object) [
          'level' => 'admin'
        ],
        'oidcUsernameClaim' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsIds' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsNames' => (object) [
          'level' => 'admin'
        ],
        'oidcTeamsColumns' => (object) [
          'level' => 'admin'
        ],
        'oidcSync' => (object) [
          'level' => 'admin'
        ],
        'oidcSyncTeams' => (object) [
          'level' => 'admin'
        ],
        'oidcFallback' => (object) [
          'level' => 'admin'
        ],
        'oidcAllowRegularUserFallback' => (object) [
          'level' => 'admin'
        ],
        'oidcAllowAdminUser' => (object) [
          'level' => 'admin'
        ],
        'oidcAuthorizationPrompt' => (object) [
          'level' => 'admin'
        ],
        'oidcAuthorizationMaxAge' => (object) [
          'level' => 'admin'
        ],
        'oidcLogoutUrl' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedMethodList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedHeaderList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsAllowedOriginList' => (object) [
          'level' => 'admin'
        ],
        'apiCorsMaxAge' => (object) [
          'level' => 'admin'
        ],
        'customExportManifest' => (object) [
          'level' => 'admin'
        ],
        'starsLimit' => (object) [
          'level' => 'admin'
        ],
        'authIpAddressCheck' => (object) [
          'level' => 'superAdmin'
        ],
        'authIpAddressWhitelist' => (object) [
          'level' => 'superAdmin'
        ],
        'authIpAddressCheckExcludedUsers' => (object) [
          'level' => 'superAdmin'
        ],
        'availableReactions' => (object) [
          'level' => 'default'
        ],
        'emailScheduledBatchCount' => (object) [
          'level' => 'admin'
        ],
        'streamEmailWithContentEntityTypeList' => (object) [
          'level' => 'admin'
        ],
        'defaultPriceBook' => (object) [],
        'priceBooksEnabled' => (object) [],
        'inventoryTransactionsEnabled' => (object) [],
        'warehousesEnabled' => (object) [],
        'deliveryOrdersEnabled' => (object) [],
        'receiptOrdersEnabled' => (object) [],
        'inventoryCompressJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'inventoryDetachJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'notActualOrderLockingJobPeriod' => (object) [
          'level' => 'admin'
        ],
        'productVariantMaxCount' => (object) [],
        'salesForbidOrderUnlock' => (object) [
          'level' => 'default'
        ],
        'eInvoiceFormat' => (object) [
          'level' => 'default'
        ],
        'sellerCompanyName' => (object) [
          'level' => 'admin'
        ],
        'sellerElectronicAddressScheme' => (object) [
          'level' => 'admin'
        ],
        'sellerElectronicAddressIdentifier' => (object) [
          'level' => 'admin'
        ],
        'sellerVatNumber' => (object) [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationScheme' => (object) [
          'level' => 'admin'
        ],
        'sellerTaxRegistrationIdentifier' => (object) [
          'level' => 'admin'
        ],
        'sellerAddress' => (object) [
          'level' => 'admin'
        ],
        'sellerContactName' => (object) [
          'level' => 'admin'
        ],
        'sellerContactEmailAddress' => (object) [
          'level' => 'admin'
        ],
        'sellerContactPhoneNumber' => (object) [
          'level' => 'admin'
        ]
      ]
    ],
    'consoleCommands' => (object) [
      'import' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\Import',
        'listed' => true
      ],
      'clearCache' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'rebuild' => (object) [
        'listed' => true,
        'noSystemUser' => true,
        'allowedFlags' => [
          0 => 'hard',
          1 => 'y'
        ]
      ],
      'updateAppTimestamp' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'appInfo' => (object) [
        'listed' => true
      ],
      'setPassword' => (object) [
        'listed' => true
      ],
      'upgrade' => (object) [
        'listed' => true
      ],
      'extension' => (object) [
        'listed' => true
      ],
      'runJob' => (object) [
        'listed' => true,
        'allowedOptions' => [
          0 => 'job',
          1 => 'targetId',
          2 => 'targetType'
        ]
      ],
      'version' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'createAdminUser' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CreateAdminUser',
        'listed' => true
      ],
      'rebuildCategoryPaths' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\RebuildCategoryPaths',
        'listed' => true
      ],
      'populateArrayValues' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateArrayValues',
        'listed' => true
      ],
      'populateNumbers' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\PopulateNumbers',
        'listed' => false
      ],
      'checkFilePermissions' => (object) [
        'className' => 'Espo\\Classes\\ConsoleCommands\\CheckFilePermissions',
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrate' => (object) [
        'listed' => true,
        'noSystemUser' => true
      ],
      'migrationVersionStep' => (object) [
        'listed' => false,
        'noSystemUser' => true
      ],
      'inventoryAclCheck' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryAclCheck',
        'listed' => false
      ],
      'inventoryCompress' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryCompress',
        'listed' => true
      ],
      'inventoryDetach' => (object) [
        'className' => 'Espo\\Modules\\Sales\\Classes\\ConsoleCommands\\InventoryDetach',
        'listed' => true
      ]
    ],
    'containerServices' => (object) [
      'authTokenManager' => (object) [
        'className' => 'Espo\\Core\\Authentication\\AuthToken\\EspoManager'
      ],
      'ormMetadataData' => (object) [
        'className' => 'Espo\\Core\\Utils\\Metadata\\OrmMetadataData'
      ],
      'classFinder' => (object) [
        'className' => 'Espo\\Core\\Utils\\ClassFinder'
      ],
      'fileStorageManager' => (object) [
        'className' => 'Espo\\Core\\FileStorage\\Manager'
      ],
      'jobManager' => (object) [
        'className' => 'Espo\\Core\\Job\\JobManager'
      ],
      'webSocketSubmission' => (object) [
        'className' => 'Espo\\Core\\WebSocket\\Submission'
      ],
      'crypt' => (object) [
        'className' => 'Espo\\Core\\Utils\\Crypt'
      ],
      'passwordHash' => (object) [
        'className' => 'Espo\\Core\\Utils\\PasswordHash'
      ],
      'number' => (object) [
        'loaderClassName' => 'Espo\\Core\\Loaders\\NumberUtil'
      ],
      'selectBuilderFactory' => (object) [
        'className' => 'Espo\\Core\\Select\\SelectBuilderFactory'
      ],
      'selectManagerFactory' => (object) [
        'className' => 'Espo\\Core\\Select\\SelectManagerFactory'
      ],
      'serviceFactory' => (object) [
        'className' => 'Espo\\Core\\ServiceFactory'
      ],
      'recordServiceContainer' => (object) [
        'className' => 'Espo\\Core\\Record\\ServiceContainer'
      ],
      'templateFileManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\TemplateFileManager'
      ],
      'webhookManager' => (object) [
        'className' => 'Espo\\Core\\Webhook\\Manager'
      ],
      'hookManager' => (object) [
        'className' => 'Espo\\Core\\HookManager'
      ],
      'clientManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\ClientManager'
      ],
      'themeManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\ThemeManager'
      ],
      'fieldUtil' => (object) [
        'className' => 'Espo\\Core\\Utils\\FieldUtil'
      ],
      'emailSender' => (object) [
        'className' => 'Espo\\Core\\Mail\\EmailSender'
      ],
      'mailSender' => (object) [
        'className' => 'Espo\\Core\\Mail\\Sender'
      ],
      'htmlizerFactory' => (object) [
        'className' => 'Espo\\Core\\Htmlizer\\HtmlizerFactory'
      ],
      'fieldValidationManager' => (object) [
        'className' => 'Espo\\Core\\FieldValidation\\FieldValidationManager'
      ],
      'assignmentCheckerManager' => (object) [
        'className' => 'Espo\\Core\\Acl\\AssignmentChecker\\AssignmentCheckerManager'
      ],
      'hasher' => (object) [
        'className' => 'Espo\\Core\\Utils\\Hasher'
      ],
      'emailFilterManager' => (object) [
        'className' => 'Espo\\Core\\Utils\\EmailFilterManager'
      ],
      'externalAccountClientManager' => (object) [
        'className' => 'Espo\\Core\\ExternalAccount\\ClientManager'
      ],
      'formulaManager' => (object) [
        'className' => 'Espo\\Core\\Formula\\Manager'
      ],
      'user' => (object) [
        'settable' => true
      ],
      'streamService' => (object) [
        'className' => 'Espo\\Tools\\Stream\\Service'
      ],
      'workflowManager' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowManager'
      ],
      'workflowHelper' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\WorkflowHelper'
      ],
      'signalManager' => (object) [
        'loaderClassName' => 'Espo\\Modules\\Advanced\\Core\\Loaders\\SignalManager'
      ]
    ],
    'currency' => (object) [
      'symbolMap' => (object) [
        'AED' => 'د.إ',
        'AFN' => '؋',
        'ALL' => 'L',
        'ANG' => 'ƒ',
        'AOA' => 'Kz',
        'ARS' => '$',
        'AUD' => '$',
        'AWG' => 'ƒ',
        'AZN' => '₼',
        'BAM' => 'KM',
        'BBD' => '$',
        'BDT' => '৳',
        'BGN' => 'лв',
        'BHD' => '.د.ب',
        'BIF' => 'FBu',
        'BMD' => '$',
        'BND' => '$',
        'BOB' => 'Bs.',
        'BRL' => 'R$',
        'BSD' => '$',
        'BTN' => 'Nu.',
        'BWP' => 'P',
        'BYN' => 'Br',
        'BYR' => 'p.',
        'BZD' => 'BZ$',
        'CAD' => '$',
        'CDF' => 'FC',
        'CHF' => 'Fr.',
        'CLP' => '$',
        'CNY' => '¥',
        'COP' => '$',
        'CRC' => '₡',
        'CUC' => '$',
        'CUP' => '₱',
        'CVE' => '$',
        'CZK' => 'Kč',
        'DJF' => 'Fdj',
        'DKK' => 'kr',
        'DOP' => 'RD$',
        'DZD' => 'دج',
        'EEK' => 'kr',
        'EGP' => '£',
        'ERN' => 'Nfk',
        'ETB' => 'Br',
        'EUR' => '€',
        'FJD' => '$',
        'FKP' => '£',
        'GBP' => '£',
        'GEL' => '₾',
        'GGP' => '£',
        'GHC' => '₵',
        'GHS' => 'GH₵',
        'GIP' => '£',
        'GMD' => 'D',
        'GNF' => 'FG',
        'GTQ' => 'Q',
        'GYD' => '$',
        'HKD' => '$',
        'HNL' => 'L',
        'HRK' => 'kn',
        'HTG' => 'G',
        'HUF' => 'Ft',
        'IDR' => 'Rp',
        'ILS' => '₪',
        'IMP' => '£',
        'INR' => '₹',
        'IQD' => 'ع.د',
        'IRR' => '﷼',
        'ISK' => 'kr',
        'JEP' => '£',
        'JMD' => 'J$',
        'JPY' => '¥',
        'KES' => 'KSh',
        'KGS' => 'лв',
        'KHR' => '៛',
        'KMF' => 'CF',
        'KPW' => '₩',
        'KRW' => '₩',
        'KYD' => '$',
        'KZT' => '₸',
        'LAK' => '₭',
        'LBP' => '£',
        'LKR' => '₨',
        'LRD' => '$',
        'LSL' => 'M',
        'LTL' => 'Lt',
        'LVL' => 'Ls',
        'MAD' => 'MAD',
        'MDL' => 'lei',
        'MGA' => 'Ar',
        'MKD' => 'ден',
        'MMK' => 'K',
        'MNT' => '₮',
        'MOP' => 'MOP$',
        'MUR' => '₨',
        'MVR' => 'Rf',
        'MWK' => 'MK',
        'MXN' => '$',
        'MYR' => 'RM',
        'MZN' => 'MT',
        'NAD' => '$',
        'NGN' => '₦',
        'NIO' => 'C$',
        'NOK' => 'kr',
        'NPR' => '₨',
        'NZD' => '$',
        'OMR' => '﷼',
        'PAB' => 'B/.',
        'PEN' => 'S/.',
        'PGK' => 'K',
        'PHP' => '₱',
        'PKR' => '₨',
        'PLN' => 'zł',
        'PYG' => 'Gs',
        'QAR' => '﷼',
        'RMB' => '￥',
        'RON' => 'lei',
        'RSD' => 'Дин.',
        'RUB' => '₽',
        'RWF' => 'R₣',
        'SAR' => '﷼',
        'SBD' => '$',
        'SCR' => '₨',
        'SDG' => 'ج.س.',
        'SEK' => 'kr',
        'SGD' => '$',
        'SHP' => '£',
        'SLL' => 'Le',
        'SOS' => 'S',
        'SRD' => '$',
        'SSP' => '£',
        'STD' => 'Db',
        'SVC' => '$',
        'SYP' => '£',
        'SZL' => 'E',
        'THB' => '฿',
        'TJS' => 'SM',
        'TMT' => 'T',
        'TND' => 'د.ت',
        'TOP' => 'T$',
        'TRL' => '₤',
        'TRY' => '₺',
        'TTD' => 'TT$',
        'TVD' => '$',
        'TWD' => 'NT$',
        'TZS' => 'TSh',
        'UAH' => '₴',
        'UGX' => 'USh',
        'USD' => '$',
        'UYU' => '$U',
        'UZS' => 'лв',
        'VEF' => 'Bs',
        'VND' => '₫',
        'VUV' => 'VT',
        'WST' => 'WS$',
        'XAF' => 'FCFA',
        'XBT' => 'Ƀ',
        'XCD' => '$',
        'XOF' => 'CFA',
        'XPF' => '₣',
        'YER' => '﷼',
        'ZAR' => 'R',
        'ZWD' => 'Z$',
        'BTC' => '฿'
      ],
      'list' => [
        0 => 'AFN',
        1 => 'AED',
        2 => 'ALL',
        3 => 'ANG',
        4 => 'AOA',
        5 => 'ARS',
        6 => 'AUD',
        7 => 'BAM',
        8 => 'BDT',
        9 => 'BGN',
        10 => 'BHD',
        11 => 'BND',
        12 => 'BOB',
        13 => 'BRL',
        14 => 'BWP',
        15 => 'BYN',
        16 => 'CAD',
        17 => 'CHF',
        18 => 'CLP',
        19 => 'CNY',
        20 => 'COP',
        21 => 'CRC',
        22 => 'CVE',
        23 => 'CZK',
        24 => 'DKK',
        25 => 'DOP',
        26 => 'DZD',
        27 => 'EGP',
        28 => 'EUR',
        29 => 'FJD',
        30 => 'GBP',
        31 => 'GNF',
        32 => 'GTQ',
        33 => 'HKD',
        34 => 'HNL',
        35 => 'HRK',
        36 => 'HUF',
        37 => 'IDR',
        38 => 'ILS',
        39 => 'INR',
        40 => 'IRR',
        41 => 'JMD',
        42 => 'JOD',
        43 => 'JPY',
        44 => 'KES',
        45 => 'KRW',
        46 => 'KWD',
        47 => 'KYD',
        48 => 'KZT',
        49 => 'LBP',
        50 => 'LKR',
        51 => 'MAD',
        52 => 'MDL',
        53 => 'MKD',
        54 => 'MMK',
        55 => 'MUR',
        56 => 'MXN',
        57 => 'MYR',
        58 => 'MZN',
        59 => 'NAD',
        60 => 'NGN',
        61 => 'NIO',
        62 => 'NOK',
        63 => 'NPR',
        64 => 'NZD',
        65 => 'OMR',
        66 => 'PEN',
        67 => 'PGK',
        68 => 'PHP',
        69 => 'PKR',
        70 => 'PLN',
        71 => 'PYG',
        72 => 'QAR',
        73 => 'RON',
        74 => 'RSD',
        75 => 'RUB',
        76 => 'SAR',
        77 => 'SCR',
        78 => 'SEK',
        79 => 'SGD',
        80 => 'SLL',
        81 => 'SVC',
        82 => 'THB',
        83 => 'TND',
        84 => 'TRY',
        85 => 'TTD',
        86 => 'TWD',
        87 => 'TZS',
        88 => 'UAH',
        89 => 'UGX',
        90 => 'USD',
        91 => 'UYU',
        92 => 'UZS',
        93 => 'VND',
        94 => 'XAF',
        95 => 'YER',
        96 => 'ZAR',
        97 => 'ZMW',
        98 => 'ZWL'
      ]
    ],
    'currencyConversion' => (object) [
      'entityConverterClassNameMap' => (object) [
        'Quote' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'SalesOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Invoice' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'PurchaseOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'DeliveryOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReceiptOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'TransferOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'ReturnOrder' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Opportunity' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter',
        'Service' => 'Espo\\Modules\\Sales\\Classes\\EntityCurrencyConverters\\QuoteConverter'
      ]
    ],
    'databasePlatforms' => (object) [
      'Mysql' => (object) [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\MysqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\MysqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\MysqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\MysqlColumnPreparator',
        'preRebuildActionClassNameList' => [
          0 => 'Espo\\Core\\Utils\\Database\\Schema\\RebuildActions\\PrepareForFulltextIndex'
        ],
        'postRebuildActionClassNameList' => [],
        'dbalTypeClassNameMap' => (object) [
          'mediumtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\MediumtextType',
          'longtext' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\LongtextType',
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ],
      'Postgresql' => (object) [
        'detailsProviderClassName' => 'Espo\\Core\\Utils\\Database\\DetailsProviders\\PostgresqlDetailsProvider',
        'dbalConnectionFactoryClassName' => 'Espo\\Core\\Utils\\Database\\Dbal\\Factories\\PostgresqlConnectionFactory',
        'indexHelperClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\IndexHelpers\\PostgresqlIndexHelper',
        'columnPreparatorClassName' => 'Espo\\Core\\Utils\\Database\\Schema\\ColumnPreparators\\PostgresqlColumnPreparator',
        'dbalTypeClassNameMap' => (object) [
          'uuid' => 'Espo\\Core\\Utils\\Database\\Dbal\\Types\\UuidType'
        ]
      ]
    ],
    'dateTime' => (object) [
      'dateFormatList' => [
        0 => 'DD.MM.YYYY',
        1 => 'MM/DD/YYYY',
        2 => 'DD/MM/YYYY',
        3 => 'YYYY-MM-DD',
        4 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm',
        1 => 'hh:mma',
        2 => 'hh:mmA',
        3 => 'hh:mm A',
        4 => 'hh:mm a'
      ]
    ],
    'defaultDashboardLayouts' => (object) [
      'Standard' => [
        0 => (object) [
          'name' => 'My Espo',
          'layout' => [
            0 => (object) [
              'id' => 'defaultActivities',
              'name' => 'Activities',
              'x' => 2,
              'y' => 2,
              'width' => 2,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'defaultStream',
              'name' => 'Stream',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 4
            ],
            2 => (object) [
              'id' => 'defaultTasks',
              'name' => 'Tasks',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ]
          ]
        ]
      ]
    ],
    'defaultDashboardOptions' => (object) [
      'Standard' => (object) [
        'defaultStream' => (object) [
          'displayRecords' => 10
        ]
      ]
    ],
    'emailTemplate' => (object) [
      'placeholders' => (object) [
        'today' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Today',
          'order' => 0
        ],
        'now' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\Now',
          'order' => 1
        ],
        'currentYear' => (object) [
          'className' => 'Espo\\Tools\\EmailTemplate\\Placeholders\\CurrentYear',
          'order' => 2
        ]
      ]
    ],
    'entityManager' => (object) [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusCreateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventCreateHook'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\PlusDeleteHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\EventDeleteHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\DeleteHasChildrenLinks'
      ],
      'updateHookClassNameList' => [
        0 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\AssignedUsersUpdateHook',
        1 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\CollaboratorsUpdateHook',
        2 => 'Espo\\Tools\\EntityManager\\Hook\\Hooks\\StreamUpdateHook'
      ]
    ],
    'entityManagerParams' => (object) [
      'Global' => (object) [
        'stars' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'optimisticConcurrencyControl' => (object) [
          'location' => 'entityDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'preserveAuditLog' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Company' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@Person' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true
          ],
          'view' => 'views/admin/entity-manager/fields/acl-account-link'
        ]
      ],
      '@Base' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      '@BasePlus' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Account' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Contact' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Lead' => (object) [
        'updateDuplicateCheck' => (object) [
          'location' => 'recordDefs',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'duplicateCheckFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/duplicate-check-field-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Opportunity' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Document' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Case' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'KnowledgeBaseArticle' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'Meeting' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Call' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ]
      ],
      'Task' => (object) [
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      'TargetList' => (object) [
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ]
      ],
      '@Event' => (object) [
        'activityStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'historyStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'completedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'required' => true,
            'tooltip' => true,
            'view' => 'crm:views/admin/entity-manager/fields/status-list'
          ]
        ],
        'collaborators' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'assignedUsers' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'bool',
            'tooltip' => true
          ]
        ],
        'aclContactLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'contactLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-contact-link'
          ]
        ],
        'aclAccountLink' => (object) [
          'location' => 'aclDefs',
          'param' => 'accountLink',
          'fieldDefs' => (object) [
            'type' => 'enum',
            'tooltip' => true,
            'view' => 'views/admin/entity-manager/fields/acl-account-link'
          ]
        ]
      ],
      'Product' => (object) [
        'variantSyncFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/product-variant-sync-field-list',
            'tooltip' => 'productVariantSyncFieldList'
          ]
        ]
      ],
      'SalesOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderSoftReserveStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'salesOrderCanceledStatusList'
          ]
        ],
        'deliveryRequiredStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/sales-order-status-list',
            'tooltip' => 'deliveryRequiredStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'DeliveryOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/delivery-order-status-list',
            'tooltip' => 'deliveryOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'TransferOrder' => (object) [
        'softReserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderSoftReserveStatusList'
          ]
        ],
        'reserveStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderReserveStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderCanceledStatusList'
          ]
        ],
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderDoneStatusList'
          ]
        ],
        'failedStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/transfer-order-status-list',
            'tooltip' => 'transferOrderFailedStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'PurchaseOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/purchase-order-status-list',
            'tooltip' => 'purchaseOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReceiptOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/receipt-order-status-list',
            'tooltip' => 'receiptOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Quote' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/quote-status-list',
            'tooltip' => 'quoteCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'Invoice' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/invoice-status-list',
            'tooltip' => 'invoiceCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'ReturnOrder' => (object) [
        'doneStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderDoneStatusList'
          ]
        ],
        'canceledStatusList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'view' => 'sales:views/admin/entity-manager/fields/return-order-status-list',
            'tooltip' => 'returnOrderCanceledStatusList'
          ]
        ],
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ],
      'InventoryAdjustment' => (object) [
        'lockableFieldList' => (object) [
          'location' => 'scopes',
          'fieldDefs' => (object) [
            'type' => 'multiEnum',
            'tooltip' => 'lockableFieldList',
            'view' => 'sales:views/admin/entity-manager/fields/lockable-field-list'
          ]
        ]
      ]
    ],
    'entityTemplateList' => [
      0 => 'Base',
      1 => 'BasePlus',
      2 => 'Event',
      3 => 'Person',
      4 => 'Company'
    ],
    'entityTemplates' => (object) [
      'Base' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Base',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Base'
      ],
      'BasePlus' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\BasePlus',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\BasePlus'
      ],
      'Event' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Event',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Event'
      ],
      'Company' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Company',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Company'
      ],
      'Person' => (object) [
        'entityClassName' => 'Espo\\Core\\Templates\\Entities\\Person',
        'repositoryClassName' => 'Espo\\Core\\Templates\\Repositories\\Person'
      ]
    ],
    'export' => (object) [
      'formatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ],
      'formatDefs' => (object) [
        'csv' => (object) [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\Processor',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Csv\\AdditionalFieldsLoader',
          'mimeType' => 'text/csv',
          'fileExtension' => 'csv'
        ],
        'xlsx' => (object) [
          'processorClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\Processor',
          'processorParamsHandler' => 'Espo\\Tools\\Export\\Format\\Xlsx\\ParamsHandler',
          'additionalFieldsLoaderClassName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\AdditionalFieldsLoader',
          'mimeType' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
          'fileExtension' => 'xlsx',
          'cellValuePreparatorClassNameMap' => (object) [
            'link' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkOne' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'linkParent' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'file' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Link',
            'bool' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Boolean',
            'int' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Integer',
            'float' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Floating',
            'currency' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Currency',
            'currencyConverted' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\CurrencyConverted',
            'personName' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\PersonName',
            'date' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Date',
            'datetime' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTime',
            'datetimeOptional' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\DateTimeOptional',
            'linkMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'attachmentMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\LinkMultiple',
            'address' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Address',
            'duration' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Duration',
            'enum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\Enumeration',
            'multiEnum' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'array' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'checklist' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum',
            'urlMultiple' => 'Espo\\Tools\\Export\\Format\\Xlsx\\CellValuePreparators\\MultiEnum'
          ],
          'params' => (object) [
            'fields' => (object) [
              'lite' => (object) [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ],
              'recordLinks' => (object) [
                'type' => 'bool',
                'default' => false
              ],
              'title' => (object) [
                'type' => 'bool',
                'default' => false,
                'tooltip' => true
              ]
            ],
            'layout' => [
              0 => [
                0 => (object) [
                  'name' => 'lite'
                ],
                1 => (object) [
                  'name' => 'recordLinks'
                ],
                2 => (object) [
                  'name' => 'title'
                ]
              ]
            ],
            'dynamicLogic' => (object) [
              'recordLinks' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ],
              'title' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isFalse',
                      'attribute' => 'xlsxLite'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'gridReportFormatList' => [
        0 => 'xlsx',
        1 => 'csv'
      ]
    ],
    'fieldProcessing' => (object) [
      'readLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\Link\\HasOneLoader',
        1 => 'Espo\\Core\\FieldProcessing\\Link\\NotJoinedLoader',
        2 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\Loader',
        3 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        4 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Loader',
        5 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Loader',
        6 => 'Espo\\Core\\FieldProcessing\\Stream\\FollowersLoader',
        7 => 'Espo\\Core\\FieldProcessing\\Stars\\StarLoader',
        8 => 'Espo\\Modules\\EblaLinkPro\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'listLoaderClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\LinkParent\\Loader',
        1 => 'Espo\\Core\\FieldProcessing\\LinkMultiple\\ListLoader'
      ],
      'saverClassNameList' => [
        0 => 'Espo\\Core\\FieldProcessing\\EmailAddress\\Saver',
        1 => 'Espo\\Core\\FieldProcessing\\PhoneNumber\\Saver',
        2 => 'Espo\\Core\\FieldProcessing\\Relation\\Saver',
        3 => 'Espo\\Core\\FieldProcessing\\MultiEnum\\Saver',
        4 => 'Espo\\Core\\FieldProcessing\\File\\Saver',
        5 => 'Espo\\Core\\FieldProcessing\\Wysiwyg\\Saver'
      ]
    ],
    'file' => (object) [
      'extensionMimeTypeMap' => (object) [
        'aac' => [
          0 => 'audio/aac'
        ],
        'abw' => [
          0 => 'application/x-abiword'
        ],
        'arc' => [
          0 => 'application/x-freearc'
        ],
        'avif' => [
          0 => 'image/avif'
        ],
        'avi' => [
          0 => 'video/x-msvideo'
        ],
        'azw' => [
          0 => 'application/vnd.amazon.ebook'
        ],
        'bin' => [
          0 => 'application/octet-stream'
        ],
        'bmp' => [
          0 => 'image/bmp'
        ],
        'bz' => [
          0 => 'application/x-bzip'
        ],
        'bz2' => [
          0 => 'application/x-bzip2'
        ],
        'cda' => [
          0 => 'application/x-cdf'
        ],
        'csh' => [
          0 => 'application/x-csh'
        ],
        'css' => [
          0 => 'text/css'
        ],
        'csv' => [
          0 => 'text/csv'
        ],
        'doc' => [
          0 => 'application/msword'
        ],
        'docx' => [
          0 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
        ],
        'eot' => [
          0 => 'application/vnd.ms-fontobject'
        ],
        'epub' => [
          0 => 'application/epub+zip'
        ],
        'gz' => [
          0 => 'application/gzip'
        ],
        'gif' => [
          0 => 'image/gif'
        ],
        'htm' => [
          0 => 'text/html'
        ],
        'html' => [
          0 => 'text/html'
        ],
        'ico' => [
          0 => 'image/vnd.microsoft.icon'
        ],
        'ics' => [
          0 => 'text/calendar'
        ],
        'jar' => [
          0 => 'application/java-archive'
        ],
        'jpeg' => [
          0 => 'image/jpeg'
        ],
        'jpg' => [
          0 => 'image/jpeg'
        ],
        'js' => [
          0 => 'text/javascript'
        ],
        'json' => [
          0 => 'application/json'
        ],
        'jsonld' => [
          0 => 'application/ld+json'
        ],
        'mid' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'midi' => [
          0 => 'audio/midi',
          1 => 'audio/x-midi'
        ],
        'mjs' => [
          0 => 'text/javascript'
        ],
        'mp3' => [
          0 => 'audio/mpeg'
        ],
        'mp4' => [
          0 => 'video/mp4'
        ],
        'mpeg' => [
          0 => 'video/mpeg'
        ],
        'mpkg' => [
          0 => 'application/vnd.apple.installer+xml'
        ],
        'odp' => [
          0 => 'application/vnd.oasis.opendocument.presentation'
        ],
        'ods' => [
          0 => 'application/vnd.oasis.opendocument.spreadsheet'
        ],
        'odt' => [
          0 => 'application/vnd.oasis.opendocument.text'
        ],
        'oga' => [
          0 => 'audio/ogg'
        ],
        'ogv' => [
          0 => 'video/ogg'
        ],
        'ogx' => [
          0 => 'application/ogg'
        ],
        'opus' => [
          0 => 'audio/opus'
        ],
        'otf' => [
          0 => 'font/otf'
        ],
        'png' => [
          0 => 'image/png'
        ],
        'pdf' => [
          0 => 'application/pdf'
        ],
        'php' => [
          0 => 'application/x-httpd-php'
        ],
        'ppt' => [
          0 => 'application/vnd.ms-powerpoint'
        ],
        'pptx' => [
          0 => 'application/vnd.openxmlformats-officedocument.presentationml.presentation'
        ],
        'rar' => [
          0 => 'application/vnd.rar'
        ],
        'rtf' => [
          0 => 'application/rtf'
        ],
        'sh' => [
          0 => 'application/x-sh'
        ],
        'svg' => [
          0 => 'image/svg+xml'
        ],
        'swf' => [
          0 => 'application/x-shockwave-flash'
        ],
        'tar' => [
          0 => 'application/x-tar'
        ],
        'tif' => [
          0 => 'image/tiff'
        ],
        'tiff' => [
          0 => 'image/tiff'
        ],
        'ts' => [
          0 => 'video/mp2t'
        ],
        'ttf' => [
          0 => 'font/ttf'
        ],
        'txt' => [
          0 => 'text/plain'
        ],
        'vsd' => [
          0 => 'application/vnd.visio'
        ],
        'wav' => [
          0 => 'audio/wav'
        ],
        'weba' => [
          0 => 'audio/webm'
        ],
        'webm' => [
          0 => 'video/webm'
        ],
        'webp' => [
          0 => 'image/webp'
        ],
        'woff' => [
          0 => 'font/woff'
        ],
        'woff2' => [
          0 => 'font/woff2'
        ],
        'xhtml' => [
          0 => 'application/xhtml+xml'
        ],
        'xls' => [
          0 => 'application/vnd.ms-excel'
        ],
        'xlsx' => [
          0 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
        ],
        'xml' => [
          0 => 'application/xml'
        ],
        'xul' => [
          0 => 'application/vnd.mozilla.xul+xml'
        ],
        'zip' => [
          0 => 'application/zip'
        ],
        '3gp' => [
          0 => 'video/3gpp',
          1 => 'audio/3gpp'
        ],
        '3g2' => [
          0 => 'video/3gpp2',
          1 => 'audio/3gpp2'
        ],
        '7z' => [
          0 => 'application/x-7z-compressed'
        ],
        'md' => [
          0 => 'text/markdown'
        ]
      ],
      'inlineMimeTypeList' => [
        0 => 'application/pdf',
        1 => 'text/plain',
        2 => 'audio/wav',
        3 => 'audio/mpeg',
        4 => 'audio/ogg',
        5 => 'audio/webm',
        6 => 'video/mpeg',
        7 => 'video/mp4',
        8 => 'video/ogg',
        9 => 'video/webm',
        10 => 'image/jpeg',
        11 => 'image/png',
        12 => 'image/gif',
        13 => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
        14 => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        15 => 'application/vnd.ms-word',
        16 => 'application/vnd.ms-excel',
        17 => 'application/vnd.oasis.opendocument.text',
        18 => 'application/vnd.oasis.opendocument.spreadsheet',
        19 => 'application/msword',
        20 => 'application/msexcel'
      ]
    ],
    'fileStorage' => (object) [
      'implementationClassNameMap' => (object) [
        'EspoUploadDir' => 'Espo\\Core\\FileStorage\\Storages\\EspoUploadDir',
        'AwsS3' => 'Espo\\Core\\FileStorage\\Storages\\AwsS3'
      ]
    ],
    'formula' => (object) [
      'functionList' => [
        0 => (object) [
          'name' => 'ifThenElse',
          'insertText' => 'ifThenElse(CONDITION, CONSEQUENT, ALTERNATIVE)'
        ],
        1 => (object) [
          'name' => 'ifThen',
          'insertText' => 'ifThen(CONDITION, CONSEQUENT)'
        ],
        2 => (object) [
          'name' => 'list',
          'insertText' => 'list(ITEM_1, ITEM_2)',
          'returnType' => 'array'
        ],
        3 => (object) [
          'name' => 'string\\concatenate',
          'insertText' => 'string\\concatenate(STRING_1, STRING_2)',
          'returnType' => 'string'
        ],
        4 => (object) [
          'name' => 'string\\substring',
          'insertText' => 'string\\substring(STRING, START, LENGTH)',
          'returnType' => 'string'
        ],
        5 => (object) [
          'name' => 'string\\contains',
          'insertText' => 'string\\contains(STRING, NEEDLE)',
          'returnType' => 'bool'
        ],
        6 => (object) [
          'name' => 'string\\pos',
          'insertText' => 'string\\pos(STRING, NEEDLE)',
          'returnType' => 'int'
        ],
        7 => (object) [
          'name' => 'string\\pad',
          'insertText' => 'string\\pad(STRING, LENGTH, PAD_STRING)',
          'returnType' => 'string'
        ],
        8 => (object) [
          'name' => 'string\\test',
          'insertText' => 'string\\test(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'bool'
        ],
        9 => (object) [
          'name' => 'string\\length',
          'insertText' => 'string\\length(STRING)',
          'returnType' => 'int'
        ],
        10 => (object) [
          'name' => 'string\\trim',
          'insertText' => 'string\\trim(STRING)',
          'returnType' => 'string'
        ],
        11 => (object) [
          'name' => 'string\\lowerCase',
          'insertText' => 'string\\lowerCase(STRING)',
          'returnType' => 'string'
        ],
        12 => (object) [
          'name' => 'string\\upperCase',
          'insertText' => 'string\\upperCase(STRING)',
          'returnType' => 'string'
        ],
        13 => (object) [
          'name' => 'string\\match',
          'insertText' => 'string\\match(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string|null'
        ],
        14 => (object) [
          'name' => 'string\\matchAll',
          'insertText' => 'string\\matchAll(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        15 => (object) [
          'name' => 'string\\matchExtract',
          'insertText' => 'string\\matchExtract(STRING, REGULAR_EXPRESSION)',
          'returnType' => 'string[]|null'
        ],
        16 => (object) [
          'name' => 'string\\replace',
          'insertText' => 'string\\replace(STRING, SEARCH, REPLACE)',
          'returnType' => 'string'
        ],
        17 => (object) [
          'name' => 'string\\split',
          'insertText' => 'string\\split(STRING, SEPARATOR)',
          'returnType' => 'string[]'
        ],
        18 => (object) [
          'name' => 'datetime\\today',
          'insertText' => 'datetime\\today()',
          'returnType' => 'string'
        ],
        19 => (object) [
          'name' => 'datetime\\now',
          'insertText' => 'datetime\\now()',
          'returnType' => 'string'
        ],
        20 => (object) [
          'name' => 'datetime\\format',
          'insertText' => 'datetime\\format(VALUE)',
          'returnType' => 'string'
        ],
        21 => (object) [
          'name' => 'datetime\\date',
          'insertText' => 'datetime\\date(VALUE)',
          'returnType' => 'int'
        ],
        22 => (object) [
          'name' => 'datetime\\month',
          'insertText' => 'datetime\\month(VALUE)',
          'returnType' => 'int'
        ],
        23 => (object) [
          'name' => 'datetime\\year',
          'insertText' => 'datetime\\year(VALUE)',
          'returnType' => 'int'
        ],
        24 => (object) [
          'name' => 'datetime\\hour',
          'insertText' => 'datetime\\hour(VALUE)',
          'returnType' => 'int'
        ],
        25 => (object) [
          'name' => 'datetime\\minute',
          'insertText' => 'datetime\\minute(VALUE)',
          'returnType' => 'int'
        ],
        26 => (object) [
          'name' => 'datetime\\dayOfWeek',
          'insertText' => 'datetime\\dayOfWeek(VALUE)',
          'returnType' => 'int'
        ],
        27 => (object) [
          'name' => 'datetime\\addMinutes',
          'insertText' => 'datetime\\addMinutes(VALUE, MINUTES)',
          'returnType' => 'string'
        ],
        28 => (object) [
          'name' => 'datetime\\addHours',
          'insertText' => 'datetime\\addHours(VALUE, HOURS)',
          'returnType' => 'string'
        ],
        29 => (object) [
          'name' => 'datetime\\addDays',
          'insertText' => 'datetime\\addDays(VALUE, DAYS)',
          'returnType' => 'string'
        ],
        30 => (object) [
          'name' => 'datetime\\addWeeks',
          'insertText' => 'datetime\\addWeeks(VALUE, WEEKS)',
          'returnType' => 'string'
        ],
        31 => (object) [
          'name' => 'datetime\\addMonths',
          'insertText' => 'datetime\\addMonths(VALUE, MONTHS)',
          'returnType' => 'string'
        ],
        32 => (object) [
          'name' => 'datetime\\addYears',
          'insertText' => 'datetime\\addYears(VALUE, YEARS)',
          'returnType' => 'string'
        ],
        33 => (object) [
          'name' => 'datetime\\diff',
          'insertText' => 'datetime\\diff(VALUE_1, VALUE_2, INTERVAL_TYPE)',
          'returnType' => 'int'
        ],
        34 => (object) [
          'name' => 'datetime\\closest',
          'insertText' => 'datetime\\closest(VALUE, TYPE, TARGET, IS_PAST, TIMEZONE)',
          'returnType' => 'string'
        ],
        35 => (object) [
          'name' => 'number\\format',
          'insertText' => 'number\\format(VALUE)',
          'returnType' => 'string'
        ],
        36 => (object) [
          'name' => 'number\\abs',
          'insertText' => 'number\\abs(VALUE)'
        ],
        37 => (object) [
          'name' => 'number\\power',
          'insertText' => 'number\\power(VALUE, EXP)',
          'returnType' => 'int|float'
        ],
        38 => (object) [
          'name' => 'number\\round',
          'insertText' => 'number\\round(VALUE, PRECISION)',
          'returnType' => 'int|float'
        ],
        39 => (object) [
          'name' => 'number\\floor',
          'insertText' => 'number\\floor(VALUE)',
          'returnType' => 'int'
        ],
        40 => (object) [
          'name' => 'number\\ceil',
          'insertText' => 'number\\ceil(VALUE)',
          'returnType' => 'int'
        ],
        41 => (object) [
          'name' => 'number\\randomInt',
          'insertText' => 'number\\randomInt(MIN, MAX)',
          'returnType' => 'int'
        ],
        42 => (object) [
          'name' => 'number\\parseInt',
          'insertText' => 'number\\parseInt(STRING)',
          'returnType' => 'int'
        ],
        43 => (object) [
          'name' => 'number\\parseFloat',
          'insertText' => 'number\\parseFloat(STRING)',
          'returnType' => 'float'
        ],
        44 => (object) [
          'name' => 'entity\\isNew',
          'insertText' => 'entity\\isNew()',
          'returnType' => 'bool'
        ],
        45 => (object) [
          'name' => 'entity\\isAttributeChanged',
          'insertText' => 'entity\\isAttributeChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        46 => (object) [
          'name' => 'entity\\isAttributeNotChanged',
          'insertText' => 'entity\\isAttributeNotChanged(ATTRIBUTE)',
          'returnType' => 'bool'
        ],
        47 => (object) [
          'name' => 'entity\\attribute',
          'insertText' => 'entity\\attribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        48 => (object) [
          'name' => 'entity\\attributeFetched',
          'insertText' => 'entity\\attributeFetched(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        49 => (object) [
          'name' => 'entity\\setAttribute',
          'insertText' => 'entity\\setAttribute(ATTRIBUTE, VALUE)',
          'unsafe' => true
        ],
        50 => (object) [
          'name' => 'entity\\clearAttribute',
          'insertText' => 'entity\\clearAttribute(ATTRIBUTE)',
          'unsafe' => true
        ],
        51 => (object) [
          'name' => 'entity\\addLinkMultipleId',
          'insertText' => 'entity\\addLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        52 => (object) [
          'name' => 'entity\\hasLinkMultipleId',
          'insertText' => 'entity\\hasLinkMultipleId(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        53 => (object) [
          'name' => 'entity\\removeLinkMultipleId',
          'insertText' => 'entity\\removeLinkMultipleId(LINK, ID)',
          'unsafe' => true
        ],
        54 => (object) [
          'name' => 'entity\\getLinkColumn',
          'insertText' => 'entity\\getLinkColumn(LINK, ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        55 => (object) [
          'name' => 'entity\\setLinkMultipleColumn',
          'insertText' => 'entity\\setLinkMultipleColumn(LINK, ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        56 => (object) [
          'name' => 'entity\\isRelated',
          'insertText' => 'entity\\isRelated(LINK, ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        57 => (object) [
          'name' => 'entity\\sumRelated',
          'insertText' => 'entity\\sumRelated(LINK, FIELD, FILTER)',
          'returnType' => 'int|float',
          'unsafe' => true
        ],
        58 => (object) [
          'name' => 'entity\\countRelated',
          'insertText' => 'entity\\countRelated(LINK, FILTER)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        59 => (object) [
          'name' => 'record\\exists',
          'insertText' => 'record\\exists(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        60 => (object) [
          'name' => 'record\\count',
          'insertText' => 'record\\count(ENTITY_TYPE, KEY, VALUE)',
          'returnType' => 'int',
          'unsafe' => true
        ],
        61 => (object) [
          'name' => 'record\\attribute',
          'insertText' => 'record\\attribute(ENTITY_TYPE, ID, ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        62 => (object) [
          'name' => 'record\\findOne',
          'insertText' => 'record\\findOne(ENTITY_TYPE, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        63 => (object) [
          'name' => 'record\\findMany',
          'insertText' => 'record\\findMany(ENTITY_TYPE, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        64 => (object) [
          'name' => 'record\\findRelatedOne',
          'insertText' => 'record\\findRelatedOne(ENTITY_TYPE, ID, LINK, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        65 => (object) [
          'name' => 'record\\findRelatedMany',
          'insertText' => 'record\\findRelatedMany(ENTITY_TYPE, ID, LINK, LIMIT, ORDER_BY, ORDER, KEY1, VALUE1, KEY2, VALUE2)',
          'returnType' => 'string[]',
          'unsafe' => true
        ],
        66 => (object) [
          'name' => 'record\\fetch',
          'insertText' => 'record\\fetch(ENTITY_TYPE, ID)',
          'returnType' => '?object',
          'unsafe' => true
        ],
        67 => (object) [
          'name' => 'record\\relate',
          'insertText' => 'record\\relate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        68 => (object) [
          'name' => 'record\\unrelate',
          'insertText' => 'record\\unrelate(ENTITY_TYPE, ID, LINK, FOREIGN_ID)',
          'unsafe' => true
        ],
        69 => (object) [
          'name' => 'record\\create',
          'insertText' => 'record\\create(ENTITY_TYPE, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        70 => (object) [
          'name' => 'record\\update',
          'insertText' => 'record\\update(ENTITY_TYPE, ID, ATTRIBUTE1, VALUE1, ATTRIBUTE2, VALUE2)',
          'unsafe' => true
        ],
        71 => (object) [
          'name' => 'record\\delete',
          'insertText' => 'record\\delete(ENTITY_TYPE, ID)',
          'unsafe' => true
        ],
        72 => (object) [
          'name' => 'record\\relationColumn',
          'insertText' => 'record\\relationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        73 => (object) [
          'name' => 'record\\updateRelationColumn',
          'insertText' => 'record\\updateRelationColumn(ENTITY_TYPE, ID, LINK, FOREIGN_ID, COLUMN, VALUE)',
          'unsafe' => true
        ],
        74 => (object) [
          'name' => 'env\\userAttribute',
          'insertText' => 'env\\userAttribute(ATTRIBUTE)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        75 => (object) [
          'name' => 'util\\generateId',
          'insertText' => 'util\\generateId()',
          'returnType' => 'string'
        ],
        76 => (object) [
          'name' => 'util\\generateRecordId',
          'insertText' => 'util\\generateRecordId()',
          'returnType' => 'string'
        ],
        77 => (object) [
          'name' => 'util\\base64Encode',
          'insertText' => 'util\\base64Encode(STRING)',
          'returnType' => 'string'
        ],
        78 => (object) [
          'name' => 'util\\base64Decode',
          'insertText' => 'util\\base64Decode(STRING)',
          'returnType' => 'string'
        ],
        79 => (object) [
          'name' => 'object\\create',
          'insertText' => 'object\\create()',
          'returnType' => 'object'
        ],
        80 => (object) [
          'name' => 'object\\get',
          'insertText' => 'object\\get(OBJECT, KEY)',
          'returnType' => 'mixed'
        ],
        81 => (object) [
          'name' => 'object\\has',
          'insertText' => 'object\\has(OBJECT, KEY)',
          'returnType' => 'bool'
        ],
        82 => (object) [
          'name' => 'object\\set',
          'insertText' => 'object\\set(OBJECT, KEY, VALUE)'
        ],
        83 => (object) [
          'name' => 'object\\clear',
          'insertText' => 'object\\clear(OBJECT, KEY)',
          'returnType' => 'object'
        ],
        84 => (object) [
          'name' => 'object\\cloneDeep',
          'insertText' => 'object\\cloneDeep(OBJECT)',
          'returnType' => 'object'
        ],
        85 => (object) [
          'name' => 'password\\generate',
          'insertText' => 'password\\generate()',
          'returnType' => 'string'
        ],
        86 => (object) [
          'name' => 'password\\hash',
          'insertText' => 'password\\hash(PASSWORD)',
          'returnType' => 'string'
        ],
        87 => (object) [
          'name' => 'array\\includes',
          'insertText' => 'array\\includes(LIST, VALUE)',
          'returnType' => 'bool'
        ],
        88 => (object) [
          'name' => 'array\\push',
          'insertText' => 'array\\push(LIST, VALUE)'
        ],
        89 => (object) [
          'name' => 'array\\length',
          'insertText' => 'array\\length(LIST)',
          'returnType' => 'int'
        ],
        90 => (object) [
          'name' => 'array\\at',
          'insertText' => 'array\\at(LIST, INDEX)',
          'returnType' => 'mixed'
        ],
        91 => (object) [
          'name' => 'array\\join',
          'insertText' => 'array\\join(LIST, SEPARATOR)',
          'returnType' => 'string'
        ],
        92 => (object) [
          'name' => 'array\\indexOf',
          'insertText' => 'array\\indexOf(LIST, ELEMENT)',
          'returnType' => '?int'
        ],
        93 => (object) [
          'name' => 'array\\removeAt',
          'insertText' => 'array\\removeAt(LIST, INDEX)',
          'returnType' => 'array'
        ],
        94 => (object) [
          'name' => 'array\\unique',
          'insertText' => 'array\\unique(LIST)',
          'returnType' => 'array'
        ],
        95 => (object) [
          'name' => 'language\\translate',
          'insertText' => 'language\\translate(LABEL, CATEGORY, SCOPE)',
          'returnType' => 'string'
        ],
        96 => (object) [
          'name' => 'language\\translateOption',
          'insertText' => 'language\\translateOption(OPTION, FIELD, SCOPE)',
          'returnType' => 'string'
        ],
        97 => (object) [
          'name' => 'log\\info',
          'insertText' => 'log\\info(MESSAGE)',
          'unsafe' => true
        ],
        98 => (object) [
          'name' => 'log\\notice',
          'insertText' => 'log\\notice(MESSAGE)',
          'unsafe' => true
        ],
        99 => (object) [
          'name' => 'log\\warning',
          'insertText' => 'log\\warning(MESSAGE)',
          'unsafe' => true
        ],
        100 => (object) [
          'name' => 'log\\error',
          'insertText' => 'log\\error(MESSAGE)',
          'unsafe' => true
        ],
        101 => (object) [
          'name' => 'json\\retrieve',
          'insertText' => 'json\\retrieve(JSON, PATH)',
          'returnType' => 'mixed'
        ],
        102 => (object) [
          'name' => 'json\\encode',
          'insertText' => 'json\\encode(VALUE)',
          'returnType' => 'string'
        ],
        103 => (object) [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        104 => (object) [
          'name' => 'ext\\sms\\send',
          'insertText' => 'ext\\sms\\send(SMS_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        105 => (object) [
          'name' => 'ext\\email\\applyTemplate',
          'insertText' => 'ext\\email\\applyTemplate(EMAIL_ID, EMAIL_TEMPLATE_ID)',
          'unsafe' => true
        ],
        106 => (object) [
          'name' => 'ext\\markdown\\transform',
          'insertText' => 'ext\\markdown\\transform(STRING)',
          'returnType' => 'string'
        ],
        107 => (object) [
          'name' => 'ext\\pdf\\generate',
          'insertText' => 'ext\\pdf\\generate(ENTITY_TYPE, ENTITY_ID, TEMPLATE_ID, FILENAME)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        108 => (object) [
          'name' => 'ext\\workingTime\\addWorkingDays',
          'insertText' => 'ext\\workingTime\\addWorkingDays(DATE, DAYS)',
          'returnType' => 'string|null'
        ],
        109 => (object) [
          'name' => 'ext\\workingTime\\findClosestWorkingTime',
          'insertText' => 'ext\\workingTime\\findClosestWorkingTime(DATE)',
          'returnType' => 'string|null'
        ],
        110 => (object) [
          'name' => 'ext\\workingTime\\getSummedWorkingHours',
          'insertText' => 'ext\\workingTime\\getSummedWorkingHours(FROM, TO)',
          'returnType' => 'float'
        ],
        111 => (object) [
          'name' => 'ext\\workingTime\\getWorkingDays',
          'insertText' => 'ext\\workingTime\\getWorkingDays(FROM, TO)',
          'returnType' => 'int'
        ],
        112 => (object) [
          'name' => 'ext\\workingTime\\hasWorkingTime',
          'insertText' => 'ext\\workingTime\\hasWorkingTime(FROM, TO)',
          'returnType' => 'bool'
        ],
        113 => (object) [
          'name' => 'ext\\workingTime\\isWorkingDay',
          'insertText' => 'ext\\workingTime\\isWorkingDay(DATE)',
          'returnType' => 'bool'
        ],
        114 => (object) [
          'name' => 'ext\\user\\sendAccessInfo',
          'insertText' => 'ext\\user\\sendAccessInfo(USER_ID)',
          'unsafe' => true
        ],
        115 => (object) [
          'name' => 'ext\\email\\send',
          'insertText' => 'ext\\email\\send(EMAIL_ID)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        116 => (object) [
          'name' => 'ext\\currency\\convert',
          'insertText' => 'ext\\currency\\convert(AMOUNT, FROM_CODE)',
          'returnType' => 'string'
        ],
        117 => (object) [
          'name' => 'ext\\acl\\checkEntity',
          'insertText' => 'ext\\acl\\checkEntity(USER_ID, ENTITY_TYPE, ID, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        118 => (object) [
          'name' => 'ext\\acl\\checkScope',
          'insertText' => 'ext\\acl\\checkScope(USER_ID, SCOPE, ACTION)',
          'returnType' => 'bool',
          'unsafe' => true
        ],
        119 => (object) [
          'name' => 'ext\\acl\\getLevel',
          'insertText' => 'ext\\acl\\getLevel(USER_ID, SCOPE, ACTION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        120 => (object) [
          'name' => 'ext\\acl\\getPermissionLevel',
          'insertText' => 'ext\\acl\\getPermissionLevel(USER_ID, PERMISSION)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        121 => (object) [
          'name' => 'ext\\account\\findByEmailAddress',
          'insertText' => 'ext\\account\\findByEmailAddress(EMAIL_ADDRESS)',
          'returnType' => 'string'
        ],
        122 => (object) [
          'name' => 'ext\\calendar\\userIsBusy',
          'insertText' => 'ext\\calendar\\userIsBusy(USER_ID, FROM, TO)',
          'returnType' => 'bool'
        ],
        123 => (object) [
          'name' => 'report\\export',
          'insertText' => 'report\\export(REPORT_ID)',
          'returnType' => 'string',
          'unsafe' => true
        ],
        124 => (object) [
          'name' => 'report\\recordAttribute',
          'unsafe' => true
        ],
        125 => (object) [
          'name' => 'bpm\\processEntity\\attribute',
          'insertText' => 'bpm\\processEntity\\attribute(ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        126 => (object) [
          'name' => 'bpm\\targetEntity\\attribute',
          'insertText' => 'bpm\\targetEntity\\attribute(ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        127 => (object) [
          'name' => 'bpm\\createdEntity\\attribute',
          'insertText' => 'bpm\\createdEntity\\attribute(ALIAS_ID, ATTRIBUTE_NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ],
        128 => (object) [
          'name' => 'bpm\\broadcastSignal',
          'insertText' => 'bpm\\broadcastSignal(SIGNAL_NAME, [ENTITY_TYPE], [ENTITY_ID])',
          'unsafe' => true
        ],
        129 => (object) [
          'name' => 'bpm\\startProcess',
          'insertText' => 'bpm\\startProcess(FLOWCHART_ID, TARGET_TYPE, TARGET_ID)',
          'unsafe' => true
        ],
        130 => (object) [
          'name' => 'bpm\\caughtErrorCode',
          'insertText' => 'bpm\\caughtErrorCode()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        131 => (object) [
          'name' => 'bpm\\caughtErrorMessage',
          'insertText' => 'bpm\\caughtErrorMessage()',
          'returnType' => '?string',
          'unsafe' => true
        ],
        132 => (object) [
          'name' => 'workflow\\targetEntity\\attribute',
          'insertText' => 'workflow\\targetEntity\\attribute(ATTRIBUTE_NAME)',
          'unsafe' => true
        ],
        133 => (object) [
          'name' => 'workflow\\targetEntity\\attributeFetched',
          'insertText' => 'workflow\\targetEntity\\attributeFetched(ATTRIBUTE_NAME)',
          'unsafe' => true
        ],
        134 => (object) [
          'name' => 'workflow\\trigger',
          'insertText' => 'workflow\\trigger(ENTITY_TYPE, ID, WORKFLOW_ID)',
          'unsafe' => true
        ],
        135 => (object) [
          'name' => 'workflow\\lastHttpResponseBody',
          'insertText' => 'workflow\\lastHttpResponseBody()',
          'returnType' => 'string|null',
          'unsafe' => true
        ],
        136 => (object) [
          'name' => 'workflow\\lastHttpResponseCode',
          'insertText' => 'workflow\\lastHttpResponseCode()',
          'returnType' => 'int|null',
          'unsafe' => true
        ],
        137 => (object) [
          'name' => 'workflow\\signalParam',
          'insertText' => 'workflow\\signalParam(NAME)',
          'returnType' => 'mixed',
          'unsafe' => true
        ]
      ],
      'functionClassNameMap' => (object) [
        'log\\info' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\InfoType',
        'log\\notice' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\NoticeType',
        'log\\warning' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\WarningType',
        'log\\error' => 'Espo\\Core\\Formula\\Functions\\LogGroup\\ErrorType',
        'ext\\acl\\checkEntity' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckEntityType',
        'ext\\acl\\checkScope' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\CheckScopeType',
        'ext\\acl\\getLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetLevelType',
        'ext\\acl\\getPermissionLevel' => 'Espo\\Core\\Formula\\Functions\\ExtGroup\\AclGroup\\GetPermissionLevelType',
        'util\\base64Encode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64EncodeType',
        'util\\base64Decode' => 'Espo\\Core\\Formula\\Functions\\UtilGroup\\Base64DecodeType',
        'ext\\account\\findByEmailAddress' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\AccountGroup\\FindByEmailAddressType',
        'ext\\calendar\\userIsBusy' => 'Espo\\Modules\\Crm\\Classes\\FormulaFunctions\\ExtGroup\\CalendarGroup\\UserIsBusyType',
        'processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\broadcastSignal' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\BroadcastSignalType',
        'bpm\\processEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\ProcessEntityGroup\\AttributeType',
        'bpm\\createdEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CreatedEntityGroup\\AttributeType',
        'bpm\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'bpm\\startProcess' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\StartProcessType',
        'bpm\\caughtErrorMessage' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorMessage',
        'bpm\\caughtErrorCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\BpmGroup\\CaughtErrorCode',
        'targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'targetEntity\\isNew' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsNewType',
        'targetEntity\\isRelated' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsRelatedType',
        'targetEntity\\hasLinkMultipleId' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\HasLinkMultipleIdType',
        'workflow\\lastHttpResponseBody' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseBodyType',
        'workflow\\lastHttpResponseCode' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\LastHttpResponseCodeType',
        'workflow\\trigger' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\TriggerType',
        'workflow\\targetEntity\\attribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeType',
        'workflow\\targetEntity\\attributeFetched' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\AttributeFetchedType',
        'workflow\\targetEntity\\isAttributeChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeChangedType',
        'workflow\\targetEntity\\isAttributeNotChanged' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\TargetEntityGroup\\IsAttributeNotChangedType',
        'workflow\\signalParam' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\WorkflowGroup\\SignalParamType',
        'report\\recordAttribute' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\RecordAttribute',
        'report\\export' => 'Espo\\Modules\\Advanced\\Core\\Workflow\\Formula\\Functions\\ReportGroup\\Export',
        'ext\\priceRule\\productAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\ProductAttribute',
        'ext\\priceRule\\accountAttribute' => 'Espo\\Modules\\Sales\\Classes\\FormulaFunctions\\PriceRule\\AccountAttribute'
      ]
    ],
    'hook' => (object) [
      'suppressClassNameList' => []
    ],
    'image' => (object) [
      'allowedFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'resizableFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp'
      ],
      'fixOrientationFileTypeList' => [
        0 => 'image/jpeg'
      ],
      'previewFileTypeList' => [
        0 => 'image/jpeg',
        1 => 'image/png',
        2 => 'image/gif',
        3 => 'image/webp',
        4 => 'image/svg+xml'
      ],
      'sizes' => (object) [
        'xxx-small' => [
          0 => 18,
          1 => 18
        ],
        'xx-small' => [
          0 => 32,
          1 => 32
        ],
        'x-small' => [
          0 => 64,
          1 => 64
        ],
        'small' => [
          0 => 128,
          1 => 128
        ],
        'medium' => [
          0 => 256,
          1 => 256
        ],
        'large' => [
          0 => 512,
          1 => 512
        ],
        'x-large' => [
          0 => 864,
          1 => 864
        ],
        'xx-large' => [
          0 => 1024,
          1 => 1024
        ],
        'small-logo' => [
          0 => 181,
          1 => 44
        ]
      ]
    ],
    'jsLibs' => (object) [
      'jquery' => (object) [
        'exposeAs' => '$'
      ],
      'backbone' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'Backbone'
      ],
      'bullbone' => (object) [
        'exposeAs' => 'Bull'
      ],
      'handlebars' => (object) [
        'exposeAs' => 'Handlebars'
      ],
      'underscore' => (object) [
        'exposeAs' => '_'
      ],
      'marked' => (object) [],
      'dompurify' => (object) [
        'exposeAs' => 'DOMPurify'
      ],
      'js-base64' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'Base64'
      ],
      'moment' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'moment'
      ],
      'flotr2' => (object) [
        'path' => 'client/lib/flotr2.js',
        'devPath' => 'client/lib/original/flotr2.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Flotr',
        'sourceMap' => true,
        'aliases' => [
          0 => 'lib!Flotr'
        ]
      ],
      'espo-funnel-chart' => (object) [
        'path' => 'client/lib/espo-funnel-chart.js',
        'exportsTo' => 'window',
        'exportsAs' => 'EspoFunnel'
      ],
      'summernote' => (object) [
        'path' => 'client/lib/summernote.js',
        'devPath' => 'client/lib/original/summernote.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'summernote',
        'sourceMap' => true
      ],
      'jquery-ui' => (object) [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-ui-touch-punch' => (object) [
        'exportsTo' => '$',
        'exportsAs' => 'ui'
      ],
      'jquery-textcomplete' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'textcomplete'
      ],
      'autocomplete' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'autocomplete'
      ],
      'timepicker' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'timepicker'
      ],
      'bootstrap-datepicker' => (object) [
        'exportsTo' => '$.fn',
        'exportsAs' => 'datepicker'
      ],
      'selectize' => (object) [
        'path' => 'client/lib/selectize.js',
        'devPath' => 'client/lib/original/selectize.js',
        'exportsTo' => 'window',
        'exportsAs' => 'Selectize'
      ],
      'autonumeric' => (object) [],
      'intl-tel-input' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInput'
      ],
      'intl-tel-input-utils' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputUtils'
      ],
      'intl-tel-input-globals' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'intlTelInputGlobals'
      ],
      'cronstrue' => (object) [
        'path' => 'client/lib/cronstrue-i18n.js',
        'devPath' => 'client/lib/original/cronstrue-i18n.js',
        'sourceMap' => true
      ],
      'cropper' => (object) [
        'path' => 'client/lib/cropper.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'cropper',
        'sourceMap' => true
      ],
      'gridstack' => (object) [
        'exportsTo' => 'window',
        'exportsAs' => 'GridStack'
      ],
      'bootstrap-colorpicker' => (object) [
        'path' => 'client/lib/bootstrap-colorpicker.js',
        'exportsTo' => '$.fn',
        'exportsAs' => 'colorpicker',
        'aliases' => [
          0 => 'lib!Colorpicker'
        ]
      ],
      'exif-js' => (object) [
        'path' => 'client/lib/exif.js',
        'devPath' => 'client/lib/original/exif.js',
        'sourceMap' => true
      ],
      'jsbarcode' => (object) [
        'path' => 'client/lib/JsBarcode.all.js',
        'devPath' => 'client/lib/original/JsBarcode.all.js',
        'exportsTo' => 'window',
        'exportsAs' => 'JsBarcode',
        'sourceMap' => true
      ],
      'qrcodejs' => (object) [
        'path' => 'client/lib/qrcode.js',
        'exportsTo' => 'window',
        'exportsAs' => 'QRCode'
      ],
      'turndown' => (object) [
        'path' => 'client/lib/turndown.browser.umd.js',
        'devPath' => 'client/lib/turndown.browser.umd.js',
        'sourceMap' => true
      ],
      'ace' => (object) [
        'path' => 'client/lib/ace.js',
        'exportsTo' => 'window',
        'exportsAs' => 'ace'
      ],
      'ace-mode-css' => (object) [
        'path' => 'client/lib/ace-mode-css.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/css'
      ],
      'ace-mode-html' => (object) [
        'path' => 'client/lib/ace-mode-html.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/html'
      ],
      'ace-mode-handlebars' => (object) [
        'path' => 'client/lib/ace-mode-handlebars.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/handlebars'
      ],
      'ace-mode-javascript' => (object) [
        'path' => 'client/lib/ace-mode-javascript.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/mode/javascript'
      ],
      'ace-ext-language_tools' => (object) [
        'path' => 'client/lib/ace-ext-language_tools.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/ext/language_tools'
      ],
      'ace-theme-tomorrow_night' => (object) [
        'path' => 'client/lib/ace-theme-tomorrow_night.js',
        'exportsTo' => 'ace.require.define.modules',
        'exportsAs' => 'ace/theme/tomorrow_night'
      ],
      'fullcalendar' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar.js',
        'exportsTo' => 'window',
        'exportsAs' => 'FullCalendar',
        'sourceMap' => true
      ],
      '@fullcalendar/moment' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar-moment.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'Moment',
        'sourceMap' => true
      ],
      '@fullcalendar/moment-timezone' => (object) [
        'path' => 'client/modules/crm/lib/fullcalendar-moment-timezone.js',
        'devPath' => 'client/modules/crm/lib/original/fullcalendar-moment-timezone.js',
        'exportsTo' => 'FullCalendar',
        'exportsAs' => 'MomentTimezone',
        'sourceMap' => true
      ],
      'vis-timeline' => (object) [
        'path' => 'client/modules/crm/lib/vis-timeline.js',
        'devPath' => 'client/modules/crm/lib/original/vis-timeline.js',
        'sourceMap' => true
      ],
      'vis-data' => (object) [
        'path' => 'client/modules/crm/lib/vis-data.js',
        'devPath' => 'client/modules/crm/lib/original/vis-data.js',
        'aliases' => [
          0 => 'vis-data/peer/umd/vis-data.js'
        ],
        'sourceMap' => true
      ],
      'draggable-project' => (object) [
        'path' => 'client/custom/modules/project/lib/draggable-project.js'
      ],
      'vis-timeline-project' => (object) [
        'path' => 'client/custom/modules/project/lib/vis-timeline.js'
      ],
      'vis-data-project' => (object) [
        'path' => 'client/custom/modules/project/lib/vis-data.js'
      ],
      'swal' => (object) [
        'path' => 'client/custom/src/js/swal.js',
        'exportsTo' => 'window',
        'exportsAs' => 'swal',
        'sourceMap' => false
      ]
    ],
    'language' => (object) [
      'list' => [
        0 => 'en_US',
        1 => 'ar_AR',
        2 => 'bg_BG',
        3 => 'en_GB',
        4 => 'es_MX',
        5 => 'cs_CZ',
        6 => 'da_DK',
        7 => 'de_DE',
        8 => 'es_ES',
        9 => 'hr_HR',
        10 => 'hu_HU',
        11 => 'fa_IR',
        12 => 'fr_FR',
        13 => 'id_ID',
        14 => 'it_IT',
        15 => 'lt_LT',
        16 => 'lv_LV',
        17 => 'nb_NO',
        18 => 'nl_NL',
        19 => 'th_TH',
        20 => 'tr_TR',
        21 => 'sk_SK',
        22 => 'sl_SI',
        23 => 'sr_RS',
        24 => 'sv_SE',
        25 => 'ro_RO',
        26 => 'ru_RU',
        27 => 'pl_PL',
        28 => 'pt_BR',
        29 => 'pt_PT',
        30 => 'uk_UA',
        31 => 'vi_VN',
        32 => 'zh_CN',
        33 => 'zh_TW'
      ],
      'aclDependencies' => (object) [
        'Meeting' => (object) [
          'anyScopeList' => [
            0 => 'Call'
          ]
        ],
        'Workflow' => (object) [
          'anyScopeList' => [
            0 => 'BpmnProcess',
            1 => 'BpmnFlowchart'
          ]
        ],
        'BpmnFlowchart' => (object) [
          'anyScopeList' => [
            0 => 'BpmnProcess'
          ]
        ],
        'Opportunity' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder'
          ]
        ],
        'Quote' => (object) [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'Invoice',
            2 => 'Opportunity',
            3 => 'PurchaseOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'ReturnOrder',
            8 => 'InventoryAdjustment',
            9 => 'Product'
          ]
        ],
        'QuoteItem' => (object) [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'SalesOrder',
            2 => 'Invoice',
            3 => 'Opportunity',
            4 => 'PurchaseOrder',
            5 => 'DeliveryOrder',
            6 => 'ReceiptOrder',
            7 => 'TransferOrder',
            8 => 'ReturnOrder',
            9 => 'InventoryAdjustment'
          ]
        ],
        'SalesOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice'
          ]
        ],
        'Invoice' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'PurchaseOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'SalesOrder',
            3 => 'ReturnOrder'
          ]
        ],
        'ReturnOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder'
          ]
        ],
        'DeliveryOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'TransferOrder'
          ]
        ],
        'DeliveryOrderItem' => (object) [
          'anyScopeList' => [
            0 => 'ReceiptOrder'
          ]
        ],
        'ReceiptOrder' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'PurchaseOrder'
          ]
        ],
        'Account' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'Warehouse' => (object) [
          'anyScopeList' => [
            0 => 'SalesOrder',
            1 => 'DeliveryOrder',
            2 => 'ReceiptOrder',
            3 => 'PurchaseOrder',
            4 => 'TransferOrder',
            5 => 'InventoryAdjustment',
            6 => 'InventoryTransaction'
          ]
        ],
        'Product' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'Invoice',
            2 => 'PurchaseOrder',
            3 => 'SalesOrder',
            4 => 'DeliveryOrder',
            5 => 'ReceiptOrder',
            6 => 'TransferOrder',
            7 => 'InventoryTransaction',
            8 => 'InventoryAdjustment',
            9 => 'ReturnOrder',
            10 => 'Warehouse',
            11 => 'PriceBook',
            12 => 'Supplier'
          ]
        ],
        'PriceRule' => (object) [
          'anyScopeList' => [
            0 => 'Product',
            1 => 'ProductPrice',
            2 => 'SupplierProductPrice'
          ]
        ],
        'Service' => (object) [
          'anyScopeList' => [
            0 => 'Quote',
            1 => 'SalesOrder',
            2 => 'Invoice'
          ]
        ],
        'ProjectBoard' => (object) [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectGroup' => (object) [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectColumn' => (object) [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectTask' => (object) [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ],
        'ProjectRole' => (object) [
          'anyScopeList' => [
            0 => 'Project'
          ]
        ]
      ]
    ],
    'layouts' => (object) [],
    'linkManager' => (object) [
      'createHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListCreate'
      ],
      'deleteHookClassNameList' => [
        0 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\TargetListDelete',
        1 => 'Espo\\Tools\\LinkManager\\Hook\\Hooks\\ForeignFieldDelete'
      ]
    ],
    'mapProviders' => (object) [
      'Google' => (object) [
        'renderer' => 'handlers/map/google-maps-renderer'
      ]
    ],
    'massActions' => (object) [
      'convertCurrency' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassConvertCurrency'
      ],
      'follow' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassFollow'
      ],
      'unfollow' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUnfollow'
      ],
      'recalculateFormula' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassRecalculateFormula'
      ],
      'update' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassUpdate'
      ],
      'delete' => (object) [
        'implementationClassName' => 'Espo\\Core\\MassAction\\Actions\\MassDelete'
      ]
    ],
    'metadata' => (object) [
      'frontendHiddenPathList' => [
        0 => [
          0 => 'app',
          1 => 'metadata'
        ],
        1 => [
          0 => 'app',
          1 => 'containerServices'
        ],
        2 => [
          0 => 'app',
          1 => 'portalContainerServices'
        ],
        3 => [
          0 => 'app',
          1 => 'consoleCommands'
        ],
        4 => [
          0 => 'app',
          1 => 'formula',
          2 => 'functionClassNameMap'
        ],
        5 => [
          0 => 'app',
          1 => 'fileStorage',
          2 => 'implementationClassNameMap'
        ],
        6 => [
          0 => 'app',
          1 => 'client'
        ],
        7 => [
          0 => 'app',
          1 => 'language',
          2 => 'aclDependencies'
        ],
        8 => [
          0 => 'app',
          1 => 'templateHelpers'
        ],
        9 => [
          0 => 'app',
          1 => 'appParams'
        ],
        10 => [
          0 => 'app',
          1 => 'cleanup'
        ],
        11 => [
          0 => 'app',
          1 => 'authentication'
        ],
        12 => [
          0 => 'app',
          1 => 'pdfEngines',
          2 => '__ANY__',
          3 => 'implementationClassNameMap'
        ],
        13 => [
          0 => 'app',
          1 => 'addressFormats',
          2 => '__ANY__',
          3 => 'formatterClassName'
        ],
        14 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'loginClassName'
        ],
        15 => [
          0 => 'app',
          1 => 'authentication2FAMethods',
          2 => '__ANY__',
          3 => 'userSetupClassName'
        ],
        16 => [
          0 => 'app',
          1 => 'select'
        ],
        17 => [
          0 => 'app',
          1 => 'massActions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        18 => [
          0 => 'app',
          1 => 'actions',
          2 => '__ANY__',
          3 => 'implementationClassName'
        ],
        19 => [
          0 => 'app',
          1 => 'fieldProcessing'
        ],
        20 => [
          0 => 'app',
          1 => 'scheduledJobs'
        ],
        21 => [
          0 => 'app',
          1 => 'webSocket',
          2 => 'messagers'
        ],
        22 => [
          0 => 'app',
          1 => 'config'
        ],
        23 => [
          0 => 'app',
          1 => 'rebuild'
        ],
        24 => [
          0 => 'app',
          1 => 'smsProviders',
          2 => '__ANY__',
          3 => 'senderClassName'
        ],
        25 => [
          0 => 'app',
          1 => 'orm'
        ],
        26 => [
          0 => 'app',
          1 => 'relationships'
        ],
        27 => [
          0 => 'app',
          1 => 'linkManager'
        ],
        28 => [
          0 => 'app',
          1 => 'hook'
        ],
        29 => [
          0 => 'app',
          1 => 'api'
        ],
        30 => [
          0 => 'app',
          1 => 'databasePlatforms'
        ],
        31 => [
          0 => 'app',
          1 => 'recordId'
        ],
        32 => [
          0 => 'app',
          1 => 'currencyConversion'
        ],
        33 => [
          0 => 'selectDefs'
        ],
        34 => [
          0 => 'pdfDefs'
        ],
        35 => [
          0 => 'notificationDefs',
          1 => '__ANY__',
          2 => 'assignmentNotificatorClassName'
        ],
        36 => [
          0 => 'authenticationMethods',
          1 => '__ANY__',
          2 => 'implementationClassName'
        ],
        37 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'accessCheckerClassName'
        ],
        38 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalAccessCheckerClassName'
        ],
        39 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'ownershipCheckerClassName'
        ],
        40 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'portalOwnershipCheckerClassName'
        ],
        41 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'assignmentCheckerClassName'
        ],
        42 => [
          0 => 'aclDefs',
          1 => '__ANY__',
          2 => 'linkCheckerClassNameMap'
        ],
        43 => [
          0 => 'app',
          1 => 'calendar',
          2 => 'additionalAttributeList'
        ]
      ],
      'frontendNonAdminHiddenPathList' => [
        0 => [
          0 => 'recordDefs'
        ]
      ],
      'additionalBuilderClassNameList' => [
        0 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\Fields',
        1 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\FilterFields',
        2 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\DeleteIdField',
        3 => 'Espo\\Core\\Utils\\Metadata\\AdditionalBuilder\\StreamUpdatedAtField'
      ],
      'aclDependencies' => (object) []
    ],
    'orm' => (object) [
      'platforms' => (object) [
        'Mysql' => (object) [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\MysqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\MysqlPDOFactory',
          'functionConverterClassNameMap' => (object) [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ],
        'Postgresql' => (object) [
          'queryComposerClassName' => 'Espo\\ORM\\QueryComposer\\PostgresqlQueryComposer',
          'pdoFactoryClassName' => 'Espo\\ORM\\PDO\\PostgresqlPDOFactory',
          'functionConverterClassNameMap' => (object) [
            'ABS' => 'Espo\\Core\\ORM\\QueryComposer\\Part\\FunctionConverters\\Abs'
          ]
        ]
      ]
    ],
    'pdfEngines' => (object) [
      'Dompdf' => (object) [
        'implementationClassNameMap' => (object) [
          'entity' => 'Espo\\Tools\\Pdf\\Dompdf\\EntityPrinter'
        ],
        'fontFaceList' => [
          0 => 'Courier',
          1 => 'Helvetica',
          2 => 'Times',
          3 => 'Symbol',
          4 => 'ZapfDingbats',
          5 => 'DejaVu Sans',
          6 => 'DejaVu Serif',
          7 => 'DejaVu Sans Mono'
        ]
      ]
    ],
    'portalContainerServices' => (object) [
      'layoutProvider' => (object) [
        'className' => 'Espo\\Tools\\Layout\\PortalLayoutProvider'
      ],
      'themeManager' => (object) [
        'className' => 'Espo\\Core\\Portal\\Utils\\ThemeManager'
      ]
    ],
    'reactions' => (object) [
      'list' => [
        0 => (object) [
          'type' => 'Smile',
          'iconClass' => 'far fa-face-smile'
        ],
        1 => (object) [
          'type' => 'Surprise',
          'iconClass' => 'far fa-face-surprise'
        ],
        2 => (object) [
          'type' => 'Laugh',
          'iconClass' => 'far fa-face-laugh'
        ],
        3 => (object) [
          'type' => 'Meh',
          'iconClass' => 'far fa-face-meh'
        ],
        4 => (object) [
          'type' => 'Sad',
          'iconClass' => 'far fa-face-frown'
        ],
        5 => (object) [
          'type' => 'Love',
          'iconClass' => 'far fa-heart'
        ],
        6 => (object) [
          'type' => 'Like',
          'iconClass' => 'far fa-thumbs-up'
        ],
        7 => (object) [
          'type' => 'Dislike',
          'iconClass' => 'far fa-thumbs-down'
        ]
      ]
    ],
    'rebuild' => (object) [
      'actionClassNameList' => [
        0 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemUser',
        1 => 'Espo\\Core\\Rebuild\\Actions\\AddSystemData',
        2 => 'Espo\\Core\\Rebuild\\Actions\\CurrencyRates',
        3 => 'Espo\\Core\\Rebuild\\Actions\\ScheduledJobs',
        4 => 'Espo\\Core\\Rebuild\\Actions\\ConfigMetadataCheck',
        5 => 'Espo\\Core\\Rebuild\\Actions\\GenerateInstanceId'
      ]
    ],
    'record' => (object) [
      'selectApplierClassNameList' => [
        0 => 'Espo\\Core\\Select\\Applier\\AdditionalAppliers\\IsStarred'
      ]
    ],
    'recordId' => (object) [
      'length' => 24
    ],
    'regExpPatterns' => (object) [
      'noBadCharacters' => (object) [
        'pattern' => '[^<>=]+'
      ],
      'noAsciiSpecialCharacters' => (object) [
        'pattern' => '[^`~!@#$%^&*()_+={}\\[\\]|\\\\:;"\'<,>.?]+'
      ],
      'latinLetters' => (object) [
        'pattern' => '[A-Za-z]+'
      ],
      'latinLettersDigits' => (object) [
        'pattern' => '[A-Za-z0-9]+'
      ],
      'latinLettersDigitsWhitespace' => (object) [
        'pattern' => '[A-Za-z0-9 ]+'
      ],
      'latinLettersWhitespace' => (object) [
        'pattern' => '[A-Za-z ]+'
      ],
      'digits' => (object) [
        'pattern' => '[0-9]+'
      ],
      'id' => (object) [
        'pattern' => '[A-Za-z0-9_=\\-\\.]+',
        'isSystem' => true
      ],
      'phoneNumberLoose' => (object) [
        'pattern' => '[0-9A-Za-z_@:#\\+\\(\\)\\-\\. ]+',
        'isSystem' => true
      ],
      'uriOptionalProtocol' => (object) [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/)?[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ],
      'uri' => (object) [
        'pattern' => '([a-zA-Z0-9]+\\:\\/\\/){1}[a-zA-Z0-9%\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',]+\\.([a-zA-Z0-9%\\&\\.\\/\\?\\:@\\-_=#$!+*\\(\\)\',~])*',
        'isSystem' => true
      ]
    ],
    'relationships' => (object) [
      'attachments' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\Attachments'
      ],
      'emailEmailAddress' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EmailEmailAddress'
      ],
      'entityTeam' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityTeam'
      ],
      'entityUser' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityUser'
      ],
      'entityCollaborator' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\EntityCollaborator'
      ],
      'smsPhoneNumber' => (object) [
        'converterClassName' => 'Espo\\Core\\Utils\\Database\\Orm\\LinkConverters\\SmsPhoneNumber'
      ]
    ],
    'scheduledJobs' => (object) [
      'ProcessJobGroup' => (object) [
        'name' => 'Process Job Group',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobGroup',
        'preparatorClassName' => 'Espo\\Core\\Job\\Preparator\\Preparators\\ProcessJobGroupPreparator'
      ],
      'ProcessJobQueueQ0' => (object) [
        'name' => 'Process Job Queue q0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ0'
      ],
      'ProcessJobQueueQ1' => (object) [
        'name' => 'Process Job Queue q1',
        'isSystem' => true,
        'scheduling' => '*/1 * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueQ1'
      ],
      'ProcessJobQueueE0' => (object) [
        'name' => 'Process Job Queue e0',
        'isSystem' => true,
        'scheduling' => '* * * * *',
        'jobClassName' => 'Espo\\Core\\Job\\Job\\Jobs\\ProcessJobQueueE0'
      ],
      'Dummy' => (object) [
        'isSystem' => true,
        'scheduling' => '1 */12 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\Dummy'
      ],
      'CheckNewVersion' => (object) [
        'name' => 'Check for New Version',
        'isSystem' => true,
        'scheduling' => '15 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewVersion'
      ],
      'CheckNewExtensionVersion' => (object) [
        'name' => 'Check for New Versions of Installed Extensions',
        'isSystem' => true,
        'scheduling' => '25 5 * * *',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckNewExtensionVersion'
      ],
      'Cleanup' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\Cleanup'
      ],
      'AuthTokenControl' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\AuthTokenControl'
      ],
      'SendEmailNotifications' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendEmailNotifications'
      ],
      'ProcessWebhookQueue' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\ProcessWebhookQueue'
      ],
      'CheckEmailAccounts' => (object) [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckEmailAccounts',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckEmailAccounts'
      ],
      'CheckInboundEmails' => (object) [
        'preparatorClassName' => 'Espo\\Classes\\JobPreparators\\CheckInboundEmails',
        'jobClassName' => 'Espo\\Classes\\Jobs\\CheckInboundEmails'
      ],
      'SendScheduledEmails' => (object) [
        'jobClassName' => 'Espo\\Classes\\Jobs\\SendScheduledEmails'
      ],
      'AdvancedPack' => (object) [
        'isSystem' => true,
        'scheduling' => '3 3 * * *',
        'jobClassName' => 'Espo\\Modules\\Advanced\\Core\\App\\Job'
      ],
      'SalesJob' => (object) [
        'isSystem' => true,
        'scheduling' => '3 5 * * *',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\App\\Job'
      ],
      'InventoryCompress' => (object) [
        'scheduling' => '10 0 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryCompress'
      ],
      'NotActualOrderLocking' => (object) [
        'scheduling' => '10 1 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\NotActualOrderLocking'
      ],
      'InventoryDetach' => (object) [
        'scheduling' => '10 2 * * 6',
        'jobClassName' => 'Espo\\Modules\\Sales\\Classes\\Jobs\\InventoryDetach'
      ],
      'ProjectJob' => (object) [
        'isSystem' => true,
        'scheduling' => '0 2 * * *',
        'jobClassName' => 'Espo\\Modules\\Project\\Classes\\App\\Job'
      ]
    ],
    'select' => (object) [
      'whereItemConverterClassNameMap' => (object) [
        'inCategory' => 'Espo\\Core\\Select\\Where\\ItemConverters\\InCategory',
        'isUserFromTeams' => 'Espo\\Core\\Select\\Where\\ItemConverters\\IsUserFromTeams'
      ]
    ],
    'smsProviders' => (object) [],
    'templateHelpers' => (object) [
      'googleMapsImage' => 'Espo\\Classes\\TemplateHelpers\\GoogleMaps',
      'markdownText' => 'Espo\\Classes\\TemplateHelpers\\MarkdownText',
      'tableTag' => 'Espo\\Classes\\TemplateHelpers\\TableTag',
      'trTag' => 'Espo\\Classes\\TemplateHelpers\\TrTag',
      'tdTag' => 'Espo\\Classes\\TemplateHelpers\\TdTag',
      'reportTable' => 'Espo\\Modules\\Advanced\\Core\\TemplateHelpers\\Report'
    ],
    'templates' => (object) [
      'accessInfo' => (object) [
        'scope' => 'User'
      ],
      'accessInfoPortal' => (object) [
        'scope' => 'User'
      ],
      'assignment' => (object) [
        'scopeListConfigParam' => 'assignmentEmailNotificationsEntityList'
      ],
      'mention' => (object) [
        'scope' => 'Note'
      ],
      'noteEmailReceived' => (object) [
        'scope' => 'Note'
      ],
      'notePost' => (object) [
        'scope' => 'Note'
      ],
      'notePostNoParent' => (object) [
        'scope' => 'Note'
      ],
      'noteStatus' => (object) [
        'scope' => 'Note'
      ],
      'passwordChangeLink' => (object) [
        'scope' => 'User'
      ],
      'twoFactorCode' => (object) [
        'scope' => 'User'
      ],
      'invitation' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'cancellation' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call'
        ],
        'module' => 'Crm'
      ],
      'reminder' => (object) [
        'scopeList' => [
          0 => 'Meeting',
          1 => 'Call',
          2 => 'Task'
        ],
        'module' => 'Crm'
      ],
      'reportSendingGrid1' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingGrid2' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'reportSendingList' => (object) [
        'scope' => 'Report',
        'module' => 'Advanced'
      ],
      'salesEmailPdf' => (object) [
        'scopeList' => [
          0 => 'Quote',
          1 => 'SalesOrder',
          2 => 'Invoice',
          3 => 'PurchaseOrder',
          4 => 'DeliveryOrder',
          5 => 'ReceiptOrder',
          6 => 'TransferOrder',
          7 => 'ReturnOrder'
        ],
        'module' => 'Sales'
      ]
    ],
    'webSocket' => (object) [
      'categories' => (object) [
        'newNotification' => (object) [],
        'recordUpdate' => (object) [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=read'
        ],
        'streamUpdate' => (object) [
          'paramList' => [
            0 => 'scope',
            1 => 'id'
          ],
          'accessCheckCommand' => 'AclCheck --userId=:userId --scope=:scope --id=:id --action=stream'
        ],
        'popupNotifications.event' => (object) [],
        'inventoryQuantityUpdate' => (object) [
          'accessCheckCommand' => 'InventoryAclCheck --userId=:userId'
        ]
      ],
      'messagers' => (object) [
        'ZeroMQ' => (object) [
          'senderClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSender',
          'subscriberClassName' => 'Espo\\Core\\WebSocket\\ZeroMQSubscriber'
        ]
      ]
    ],
    'calendar' => (object) [
      'additionalAttributeList' => [
        0 => 'color'
      ]
    ],
    'popupNotifications' => (object) [
      'event' => (object) [
        'grouped' => true,
        'providerClassName' => 'Espo\\Modules\\Crm\\Tools\\Activities\\PopupNotificationsProvider',
        'useWebSocket' => true,
        'portalDisabled' => true,
        'view' => 'crm:views/meeting/popup-notification'
      ]
    ],
    'workflow' => (object) [
      'serviceActions' => (object) [
        'Meeting' => (object) [
          'sendEventInvitations' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Call' => (object) [
          'sendEventInvitations' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Meeting\\SendInvitations'
          ]
        ],
        'Contact' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Lead' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'Account' => (object) [
          'optOut' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\Person\\OptOut'
          ]
        ],
        'User' => (object) [
          'generateAndSendPassword' => (object) [
            'className' => 'Espo\\Modules\\Advanced\\Classes\\ServiceActions\\User\\GenerateAndSendPassword'
          ]
        ],
        'Quote' => (object) [
          'addQuoteItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Invoice' => (object) [
          'addInvoiceItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'SalesOrder' => (object) [
          'addSalesOrderItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ],
        'Opportunity' => (object) [
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ]
        ],
        'Service' => (object) [
          'addServiceItemList' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\AddItemList'
          ],
          'convertCurrency' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\ConvertCurrency'
          ],
          'sendInEmail' => (object) [
            'className' => 'Espo\\Modules\\Sales\\Classes\\ServiceActions\\Quote\\SendInEmail'
          ]
        ]
      ]
    ],
    'eInvoice' => (object) [
      'formatList' => [
        0 => 'Peppol',
        1 => 'XRechnung',
        2 => 'CiusAtGov',
        3 => 'CiusAtNat',
        4 => 'CiusEsFace',
        5 => 'CiusIt',
        6 => 'CiusRo',
        7 => 'Nlcius'
      ],
      'easCodeList' => [
        0 => '0002',
        1 => '0007',
        2 => '0009',
        3 => '0037',
        4 => '0060',
        5 => '0088',
        6 => '0096',
        7 => '0097',
        8 => '0106',
        9 => '0130',
        10 => '0135',
        11 => '0142',
        12 => '0147',
        13 => '0151',
        14 => '0170',
        15 => '0183',
        16 => '0184',
        17 => '0188',
        18 => '0190',
        19 => '0191',
        20 => '0192',
        21 => '0193',
        22 => '0194',
        23 => '0195',
        24 => '0196',
        25 => '0198',
        26 => '0199',
        27 => '0200',
        28 => '0201',
        29 => '0202',
        30 => '0203',
        31 => '0204',
        32 => '0205',
        33 => '0208',
        34 => '0209',
        35 => '0210',
        36 => '0211',
        37 => '0212',
        38 => '0213',
        39 => '0215',
        40 => '0216',
        41 => '0217',
        42 => '0218',
        43 => '0221',
        44 => '0225',
        45 => '0230',
        46 => '9901',
        47 => '9910',
        48 => '9913',
        49 => '9914',
        50 => '9915',
        51 => '9918',
        52 => '9919',
        53 => '9920',
        54 => '9922',
        55 => '9923',
        56 => '9924',
        57 => '9925',
        58 => '9926',
        59 => '9927',
        60 => '9928',
        61 => '9929',
        62 => '9930',
        63 => '9931',
        64 => '9932',
        65 => '9933',
        66 => '9934',
        67 => '9935',
        68 => '9936',
        69 => '9937',
        70 => '9938',
        71 => '9939',
        72 => '9940',
        73 => '9941',
        74 => '9942',
        75 => '9943',
        76 => '9944',
        77 => '9945',
        78 => '9946',
        79 => '9947',
        80 => '9948',
        81 => '9949',
        82 => '9950',
        83 => '9951',
        84 => '9952',
        85 => '9953',
        86 => '9957',
        87 => '9959',
        88 => 'AN',
        89 => 'AQ',
        90 => 'AS',
        91 => 'AU',
        92 => 'EM'
      ],
      'easNames' => (object) [
        9901 => 'Danish Ministry of the Interior and Health',
        9910 => 'Hungary VAT number',
        9913 => 'Business Registers Network',
        9914 => 'Österreichische Umsatzsteuer-Identifikationsnummer',
        9915 => 'Österreichisches Verwaltungs bzw. Organisationskennzeichen',
        9918 => 'SOCIETY FOR WORLDWIDE INTERBANK FINANCIAL, TELECOMMUNICATION S.W.I.F.T',
        9919 => 'Kennziffer des Unternehmensregisters',
        9920 => 'Agencia Española de Administración Tributaria',
        9922 => 'Andorra VAT number',
        9923 => 'Albania VAT number',
        9924 => 'Bosnia and Herzegovina VAT number',
        9925 => 'Belgium VAT number',
        9926 => 'Bulgaria VAT number',
        9927 => 'Switzerland VAT number',
        9928 => 'Cyprus VAT number',
        9929 => 'Czech Republic VAT number',
        9930 => 'Germany VAT number',
        9931 => 'Estonia VAT number',
        9932 => 'United Kingdom VAT number',
        9933 => 'Greece VAT number',
        9934 => 'Croatia VAT number',
        9935 => 'Ireland VAT number',
        9936 => 'Liechtenstein VAT number',
        9937 => 'Lithuania VAT number',
        9938 => 'Luxemburg VAT number',
        9939 => 'Latvia VAT number',
        9940 => 'Monaco VAT number',
        9941 => 'Montenegro VAT number',
        9942 => 'Macedonia, the former Yugoslav Republic of VAT number',
        9943 => 'Malta VAT number',
        9944 => 'Netherlands VAT number',
        9945 => 'Poland VAT number',
        9946 => 'Portugal VAT number',
        9947 => 'Romania VAT number',
        9948 => 'Serbia VAT number',
        9949 => 'Slovenia VAT number',
        9950 => 'Slovakia VAT number',
        9951 => 'San Marino VAT number',
        9952 => 'Turkey VAT number',
        9953 => 'Holy See (Vatican City State) VAT number',
        9957 => 'French VAT number',
        9959 => 'Employer Identification Number (EIN, USA)',
        '0002' => 'System Information et Repertoire des Entreprise et des Etablissements: SIRENE',
        '0007' => 'Organisationsnummer (Swedish legal entities)',
        '0009' => 'SIRET-CODE',
        '0037' => 'LY-tunnus',
        '0060' => 'Data Universal Numbering System (D-U-N-S Number)',
        '0088' => 'EAN Location Code',
        '0096' => 'DANISH CHAMBER OF COMMERCE Scheme (EDIRA compliant)',
        '0097' => 'FTI - Ediforum Italia, (EDIRA compliant)',
        '0106' => 'Vereniging van Kamers van Koophandel en Fabrieken in Nederland (Association of Chambers of Commerce and Industry in the Netherlands), Scheme (EDIRA compliant)',
        '0130' => 'Directorates of the European Commission',
        '0135' => 'SIA Object Identifiers',
        '0142' => 'SECETI Object Identifiers',
        '0147' => 'Standard Company Code',
        '0151' => 'Australian Business Number (ABN) Scheme',
        '0170' => 'Teikoku Company Code',
        '0183' => 'Numéro d\'identification suisse des enterprises (IDE), Swiss Unique Business Identification Number (UIDB)',
        '0184' => 'DIGSTORG',
        '0188' => 'Corporate Number of The Social Security and Tax Number System',
        '0190' => 'Dutch Originator\'s Identification Number',
        '0191' => 'Centre of Registers and Information Systems of the Ministry of Justice',
        '0192' => 'Enhetsregisteret ved Bronnoysundregisterne',
        '0193' => 'UBL.BE party identifier',
        '0194' => 'KOIOS Open Technical Dictionary',
        '0195' => 'Singapore UEN identifier',
        '0196' => 'Kennitala - Iceland legal id for individuals and legal entities',
        '0198' => 'ERSTORG',
        '0199' => 'Legal Entity Identifier (LEI)',
        '0200' => 'Legal entity code (Lithuania)',
        '0201' => 'Codice Univoco Unità Organizzativa iPA',
        '0202' => 'Indirizzo di Posta Elettronica Certificata',
        '0203' => 'eDelivery Network Participant identifier',
        '0204' => 'Leitweg-ID',
        '0205' => 'CODDEST',
        '0208' => 'Numero d\'entreprise / ondernemingsnummer / Unternehmensnummer',
        '0209' => 'GS1 identification keys',
        '0210' => 'CODICE FISCALE',
        '0211' => 'PARTITA IVA',
        '0212' => 'Finnish Organization Identifier',
        '0213' => 'Finnish Organization Value Add Tax Identifier',
        '0215' => 'Net service ID',
        '0216' => 'OVTcode',
        '0217' => 'The Netherlands Chamber of Commerce and Industry establishment number',
        '0218' => 'Unified registration number (Latvia)',
        '0221' => 'The registered number of the qualified invoice issuer',
        '0225' => 'FRCTC ELECTRONIC ADDRESS',
        '0230' => 'National e-Invoicing Framework',
        'AN' => 'O.F.T.P. (ODETTE File Transfer Protocol)',
        'AQ' => 'X.400 address for mail text',
        'AS' => 'AS2 exchange',
        'AU' => 'File Transfer Protocol',
        'EM' => 'Electronic mail'
      ]
    ]
  ],
  'authenticationMethods' => (object) [
    'ApiKey' => (object) [
      'api' => true,
      'credentialsHeader' => 'X-Api-Key'
    ],
    'Espo' => (object) [
      'portalDefault' => true,
      'settings' => (object) [
        'isAvailable' => true
      ]
    ],
    'Hmac' => (object) [
      'api' => true,
      'credentialsHeader' => 'X-Hmac-Authorization'
    ],
    'LDAP' => (object) [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Ldap\\LdapLogin',
      'portalDefault' => true,
      'settings' => (object) [
        'isAvailable' => true,
        'layout' => (object) [
          'label' => 'LDAP',
          'rows' => [
            0 => [
              0 => (object) [
                'name' => 'ldapHost'
              ],
              1 => (object) [
                'name' => 'ldapPort'
              ]
            ],
            1 => [
              0 => (object) [
                'name' => 'ldapAuth'
              ],
              1 => (object) [
                'name' => 'ldapSecurity'
              ]
            ],
            2 => [
              0 => (object) [
                'name' => 'ldapUsername',
                'fullWidth' => true
              ]
            ],
            3 => [
              0 => (object) [
                'name' => 'ldapPassword'
              ],
              1 => (object) [
                'name' => 'testConnection',
                'customLabel' => NULL,
                'view' => 'views/admin/authentication/fields/test-connection'
              ]
            ],
            4 => [
              0 => (object) [
                'name' => 'ldapUserNameAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserObjectClass'
              ]
            ],
            5 => [
              0 => (object) [
                'name' => 'ldapAccountCanonicalForm'
              ],
              1 => (object) [
                'name' => 'ldapBindRequiresDn'
              ]
            ],
            6 => [
              0 => (object) [
                'name' => 'ldapBaseDn',
                'fullWidth' => true
              ]
            ],
            7 => [
              0 => (object) [
                'name' => 'ldapUserLoginFilter',
                'fullWidth' => true
              ]
            ],
            8 => [
              0 => (object) [
                'name' => 'ldapAccountDomainName'
              ],
              1 => (object) [
                'name' => 'ldapAccountDomainNameShort'
              ]
            ],
            9 => [
              0 => (object) [
                'name' => 'ldapTryUsernameSplit'
              ],
              1 => (object) [
                'name' => 'ldapOptReferrals'
              ]
            ],
            10 => [
              0 => (object) [
                'name' => 'ldapCreateEspoUser'
              ],
              1 => false
            ],
            11 => [
              0 => (object) [
                'name' => 'ldapUserFirstNameAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserLastNameAttribute'
              ]
            ],
            12 => [
              0 => (object) [
                'name' => 'ldapUserTitleAttribute'
              ],
              1 => false
            ],
            13 => [
              0 => (object) [
                'name' => 'ldapUserEmailAddressAttribute'
              ],
              1 => (object) [
                'name' => 'ldapUserPhoneNumberAttribute'
              ]
            ],
            14 => [
              0 => (object) [
                'name' => 'ldapUserTeams'
              ],
              1 => (object) [
                'name' => 'ldapUserDefaultTeam'
              ]
            ],
            15 => [
              0 => (object) [
                'name' => 'ldapPortalUserLdapAuth'
              ],
              1 => false
            ],
            16 => [
              0 => (object) [
                'name' => 'ldapPortalUserPortals'
              ],
              1 => (object) [
                'name' => 'ldapPortalUserRoles'
              ]
            ]
          ]
        ],
        'fieldList' => [
          0 => 'ldapHost',
          1 => 'ldapPort',
          2 => 'ldapAuth',
          3 => 'ldapSecurity',
          4 => 'ldapUsername',
          5 => 'ldapPassword',
          6 => 'ldapBindRequiresDn',
          7 => 'ldapUserLoginFilter',
          8 => 'ldapBaseDn',
          9 => 'ldapAccountCanonicalForm',
          10 => 'ldapAccountDomainName',
          11 => 'ldapAccountDomainNameShort',
          12 => 'ldapAccountDomainName',
          13 => 'ldapAccountDomainNameShort',
          14 => 'ldapTryUsernameSplit',
          15 => 'ldapOptReferrals',
          16 => 'ldapCreateEspoUser',
          17 => 'ldapPortalUserLdapAuth'
        ],
        'dynamicLogic' => (object) [
          'fields' => (object) [
            'ldapHost' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserNameAttribute' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUserObjectClass' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'LDAP'
                  ]
                ]
              ]
            ],
            'ldapUsername' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapPassword' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'testConnection' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapAuth'
                  ]
                ]
              ]
            ],
            'ldapAccountDomainName' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapAccountDomainNameShort' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'in',
                    'attribute' => 'ldapAccountCanonicalForm',
                    'value' => [
                      0 => 'Backslash',
                      1 => 'Principal'
                    ]
                  ]
                ]
              ]
            ],
            'ldapUserTitleAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserFirstNameAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserLastNameAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserEmailAddressAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserPhoneNumberAttribute' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ],
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserTeams' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapUserDefaultTeam' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapCreateEspoUser'
                  ]
                ]
              ]
            ],
            'ldapPortalUserPortals' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ],
            'ldapPortalUserRoles' => (object) [
              'visible' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'ldapPortalUserLdapAuth'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Oidc' => (object) [
      'implementationClassName' => 'Espo\\Core\\Authentication\\Oidc\\Login',
      'logoutClassName' => 'Espo\\Core\\Authentication\\Oidc\\Logout',
      'login' => (object) [
        'handler' => 'handlers/login/oidc',
        'fallbackConfigParam' => 'oidcFallback'
      ],
      'provider' => (object) [
        'isAvailable' => true
      ],
      'settings' => (object) [
        'isAvailable' => true,
        'layout' => (object) [
          'label' => 'OIDC',
          'rows' => [
            0 => [
              0 => (object) [
                'name' => 'oidcClientId'
              ],
              1 => (object) [
                'name' => 'oidcClientSecret'
              ]
            ],
            1 => [
              0 => (object) [
                'name' => 'oidcAuthorizationRedirectUri',
                'view' => 'views/settings/fields/oidc-redirect-uri',
                'params' => (object) [
                  'readOnly' => true,
                  'copyToClipboard' => true
                ]
              ],
              1 => false
            ],
            2 => [
              0 => (object) [
                'name' => 'oidcAuthorizationEndpoint'
              ],
              1 => (object) [
                'name' => 'oidcTokenEndpoint'
              ]
            ],
            3 => [
              0 => (object) [
                'name' => 'oidcJwksEndpoint'
              ],
              1 => (object) [
                'name' => 'oidcJwtSignatureAlgorithmList'
              ]
            ],
            4 => [
              0 => (object) [
                'name' => 'oidcScopes'
              ],
              1 => (object) [
                'name' => 'oidcUsernameClaim'
              ]
            ],
            5 => [
              0 => (object) [
                'name' => 'oidcCreateUser'
              ],
              1 => (object) [
                'name' => 'oidcSync'
              ]
            ],
            6 => [
              0 => (object) [
                'name' => 'oidcTeams'
              ],
              1 => (object) [
                'name' => 'oidcGroupClaim'
              ]
            ],
            7 => [
              0 => (object) [
                'name' => 'oidcSyncTeams'
              ],
              1 => false
            ],
            8 => [
              0 => (object) [
                'name' => 'oidcFallback'
              ],
              1 => (object) [
                'name' => 'oidcAllowRegularUserFallback'
              ]
            ],
            9 => [
              0 => (object) [
                'name' => 'oidcAllowAdminUser'
              ],
              1 => (object) [
                'name' => 'oidcLogoutUrl'
              ]
            ],
            10 => [
              0 => (object) [
                'name' => 'oidcAuthorizationPrompt'
              ],
              1 => false
            ]
          ]
        ],
        'fieldList' => [
          0 => 'oidcClientId',
          1 => 'oidcClientSecret',
          2 => 'oidcAuthorizationEndpoint',
          3 => 'oidcTokenEndpoint',
          4 => 'oidcJwksEndpoint',
          5 => 'oidcJwtSignatureAlgorithmList',
          6 => 'oidcScopes',
          7 => 'oidcGroupClaim',
          8 => 'oidcCreateUser',
          9 => 'oidcUsernameClaim',
          10 => 'oidcTeams',
          11 => 'oidcSync',
          12 => 'oidcSyncTeams',
          13 => 'oidcAuthorizationRedirectUri',
          14 => 'oidcFallback',
          15 => 'oidcAllowRegularUserFallback',
          16 => 'oidcAllowAdminUser',
          17 => 'oidcLogoutUrl'
        ],
        'dynamicLogic' => (object) [
          'fields' => (object) [
            'oidcClientId' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcAuthorizationEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcTokenEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcUsernameClaim' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwtSignatureAlgorithmList' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ]
                ]
              ]
            ],
            'oidcJwksEndpoint' => (object) [
              'required' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'or',
                    'value' => [
                      0 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS256'
                      ],
                      1 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS384'
                      ],
                      2 => (object) [
                        'type' => 'contains',
                        'attribute' => 'oidcJwtSignatureAlgorithmList',
                        'value' => 'RS512'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'oidcAllowRegularUserFallback' => (object) [
              'invalid' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'isTrue',
                    'attribute' => 'oidcAllowRegularUserFallback'
                  ],
                  2 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ],
            'oidcAllowAdminUser' => (object) [
              'invalid' => (object) [
                'conditionGroup' => [
                  0 => (object) [
                    'type' => 'equals',
                    'attribute' => 'authenticationMethod',
                    'value' => 'Oidc'
                  ],
                  1 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcAllowAdminUser'
                  ],
                  2 => (object) [
                    'type' => 'isFalse',
                    'attribute' => 'oidcFallback'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ]
  ],
  'clientDefs' => (object) [
    'ActionHistoryRecord' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/action-history-record/record/list'
      ],
      'modalViews' => (object) [
        'detail' => 'views/action-history-record/modals/detail'
      ]
    ],
    'AddressCountry' => (object) [
      'controller' => 'controllers/record',
      'duplicateDisabled' => true,
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'name' => 'populateDefaults',
              'labelTranslation' => 'AddressCountry.strings.populateDefaults',
              'handler' => 'handlers/admin/address-country/populate-defaults',
              'actionFunction' => 'populate'
            ]
          ]
        ]
      ]
    ],
    'AddressMap' => (object) [
      'controller' => 'controllers/address-map'
    ],
    'ApiUser' => (object) [
      'controller' => 'controllers/api-user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/api-user/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'filterList' => [],
      'boolFilterList' => []
    ],
    'AppLogRecord' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/admin/app-log-record/record/list'
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'errors'
        ]
      ]
    ],
    'AppSecret' => (object) [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'Attachment' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/attachment/record/list',
        'detail' => 'views/attachment/record/detail'
      ],
      'modalViews' => (object) [
        'detail' => 'views/attachment/modals/detail'
      ],
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'AuthLogRecord' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/admin/auth-log-record/record/list',
        'detail' => 'views/admin/auth-log-record/record/detail',
        'detailSmall' => 'views/admin/auth-log-record/record/detail-small'
      ],
      'modalViews' => (object) [
        'detail' => 'views/admin/auth-log-record/modals/detail'
      ],
      'filterList' => [
        0 => 'accepted',
        1 => 'denied'
      ],
      'createDisabled' => true,
      'relationshipPanels' => (object) [
        'actionHistoryRecords' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthToken' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/admin/auth-token/record/list',
        'detail' => 'views/admin/auth-token/record/detail',
        'detailSmall' => 'views/admin/auth-token/record/detail-small'
      ],
      'modalViews' => (object) [
        'detail' => 'views/admin/auth-token/modals/detail'
      ],
      'filterList' => [
        0 => 'active',
        1 => 'inactive'
      ],
      'createDisabled' => true,
      'relationshipPanels' => (object) [
        'actionHistoryRecords' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-view-only'
        ]
      ]
    ],
    'AuthenticationProvider' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'views/authentication-provider/record/detail',
        'edit' => 'views/authentication-provider/record/edit'
      ],
      'searchPanelDisabled' => true,
      'inlineEditDisabled' => true,
      'duplicateDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true,
      'mergeDisabled' => true
    ],
    'Dashboard' => (object) [
      'controller' => 'controllers/dashboard',
      'iconClass' => 'fas fa-th-large'
    ],
    'DashboardTemplate' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'detail' => 'views/dashboard-template/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/dashboard-template/record/list'
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'action' => 'deployToUsers',
              'label' => 'Deploy to Users'
            ],
            1 => (object) [
              'action' => 'deployToTeam',
              'label' => 'Deploy to Team'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Dashboard Sets',
              'link' => '#DashboardSet',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'DashboardSet'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'DynamicLogic' => (object) [
      'itemTypes' => (object) [
        'and' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'and'
        ],
        'or' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-base',
          'operator' => 'or'
        ],
        'not' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/group-not',
          'operator' => 'not'
        ],
        'equals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '='
        ],
        'notEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ne;'
        ],
        'greaterThan' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&gt;'
        ],
        'lessThan' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&lt;'
        ],
        'greaterThanOrEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&ge;'
        ],
        'lessThanOrEquals' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-base',
          'operatorString' => '&le;'
        ],
        'isEmpty' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= &empty;'
        ],
        'isNotEmpty' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '&ne; &empty;'
        ],
        'isTrue' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 1'
        ],
        'isFalse' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-operator-only-base',
          'operatorString' => '= 0'
        ],
        'in' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&isin;'
        ],
        'notIn' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-multiple-values-base',
          'operatorString' => '&notin;'
        ],
        'isToday' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-is-today',
          'operatorString' => '='
        ],
        'inFuture' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-future',
          'operatorString' => '&isin;'
        ],
        'inPast' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-in-past',
          'operatorString' => '&isin;'
        ],
        'contains' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&niv;'
        ],
        'notContains' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-link',
          'operatorString' => '&notni;'
        ],
        'has' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&niv;'
        ],
        'notHas' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-enum',
          'operatorString' => '&notni;'
        ],
        'startsWith' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'endsWith' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ],
        'matches' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
        ]
      ],
      'fieldTypes' => (object) [
        'bool' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isTrue',
            1 => 'isFalse'
          ]
        ],
        'varchar' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'contains',
            5 => 'notContains',
            6 => 'startsWith',
            7 => 'endsWith',
            8 => 'matches'
          ],
          'conditionTypes' => (object) [
            'contains' => (object) [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ],
            'notContains' => (object) [
              'valueType' => 'field',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-base'
            ]
          ]
        ],
        'url' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'email' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'phone' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'text' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains',
            4 => 'matches'
          ],
          'conditionTypes' => (object) [
            'contains' => (object) [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ],
            'notContains' => (object) [
              'valueType' => 'varchar',
              'itemView' => 'views/admin/dynamic-logic/conditions-string/item-value-varchar'
            ]
          ]
        ],
        'int' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'float' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'currency' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals',
            4 => 'greaterThan',
            5 => 'lessThan',
            6 => 'greaterThanOrEquals',
            7 => 'lessThanOrEquals'
          ]
        ],
        'date' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast',
            5 => 'equals',
            6 => 'notEquals'
          ]
        ],
        'datetime' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'datetimeOptional' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/date',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'isToday',
            3 => 'inFuture',
            4 => 'inPast'
          ]
        ],
        'enum' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty',
            4 => 'in',
            5 => 'notIn'
          ]
        ],
        'link' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkOne' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'file' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'image' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'linkParent' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-parent',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'equals',
            3 => 'notEquals'
          ]
        ],
        'linkMultiple' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/link-multiple',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'contains',
            3 => 'notContains'
          ]
        ],
        'foreign' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/base',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals',
            2 => 'isEmpty',
            3 => 'isNotEmpty'
          ]
        ],
        'id' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'multiEnum' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'array' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'checklist' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty',
            2 => 'has',
            3 => 'notHas'
          ]
        ],
        'urlMultiple' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/multi-enum',
          'typeList' => [
            0 => 'isEmpty',
            1 => 'isNotEmpty'
          ]
        ],
        'currentUser' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user',
          'typeList' => [
            0 => 'equals',
            1 => 'notEquals'
          ]
        ],
        'currentUserTeams' => (object) [
          'view' => 'views/admin/dynamic-logic/conditions/field-types/current-user-teams',
          'typeList' => [
            0 => 'contains',
            1 => 'notContains'
          ]
        ]
      ],
      'conditionTypes' => (object) [
        'isTrue' => (object) [
          'valueType' => 'empty'
        ],
        'isFalse' => (object) [
          'valueType' => 'empty'
        ],
        'isEmpty' => (object) [
          'valueType' => 'empty'
        ],
        'isNotEmpty' => (object) [
          'valueType' => 'empty'
        ],
        'equals' => (object) [
          'valueType' => 'field'
        ],
        'notEquals' => (object) [
          'valueType' => 'field'
        ],
        'greaterThan' => (object) [
          'valueType' => 'field'
        ],
        'lessThan' => (object) [
          'valueType' => 'field'
        ],
        'greaterThanOrEquals' => (object) [
          'valueType' => 'field'
        ],
        'lessThanOrEquals' => (object) [
          'valueType' => 'field'
        ],
        'in' => (object) [
          'valueType' => 'field'
        ],
        'notIn' => (object) [
          'valueType' => 'field'
        ],
        'contains' => (object) [
          'valueType' => 'custom'
        ],
        'notContains' => (object) [
          'valueType' => 'custom'
        ],
        'inPast' => (object) [
          'valueType' => 'empty'
        ],
        'isFuture' => (object) [
          'valueType' => 'empty'
        ],
        'isToday' => (object) [
          'valueType' => 'empty'
        ],
        'has' => (object) [
          'valueType' => 'field'
        ],
        'notHas' => (object) [
          'valueType' => 'field'
        ],
        'startsWith' => (object) [
          'valueType' => 'varchar'
        ],
        'endsWith' => (object) [
          'valueType' => 'varchar'
        ],
        'matches' => (object) [
          'valueType' => 'varchar'
        ]
      ]
    ],
    'Email' => (object) [
      'controller' => 'controllers/email',
      'acl' => 'acl/email',
      'views' => (object) [
        'list' => 'views/email/list',
        'detail' => 'views/email/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/email/record/list',
        'detail' => 'views/email/record/detail',
        'edit' => 'views/email/record/edit',
        'editQuick' => 'views/email/record/edit-quick',
        'detailQuick' => 'views/email/record/detail-quick',
        'compose' => 'views/email/record/compose',
        'listRelated' => 'views/email/record/list-related'
      ],
      'modalViews' => (object) [
        'detail' => 'views/email/modals/detail',
        'compose' => 'views/modals/compose-email'
      ],
      'quickCreateModalType' => 'compose',
      'defaultSidePanelView' => 'views/email/record/panels/default-side',
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'event',
            'label' => 'Event',
            'view' => 'views/email/record/panels/event',
            'isForm' => true,
            'hidden' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Compose',
              'action' => 'composeEmail',
              'style' => 'danger',
              'acl' => 'create',
              'className' => 'btn-s-wide',
              'title' => 'Ctrl+Space'
            ]
          ],
          'dropdown' => [
            0 => (object) [
              'name' => 'archiveEmail',
              'label' => 'Archive Email',
              'link' => '#Email/create',
              'acl' => 'create'
            ],
            1 => (object) [
              'name' => 'importEml',
              'label' => 'Import EML',
              'handler' => 'handlers/email/list-actions',
              'checkVisibilityFunction' => 'checkImportEml',
              'actionFunction' => 'importEml'
            ],
            2 => false,
            3 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            4 => (object) [
              'label' => 'Folders',
              'link' => '#EmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ]
              ]
            ],
            5 => (object) [
              'label' => 'Group Folders',
              'link' => '#GroupEmailFolder',
              'configCheck' => '!emailFoldersDisabled',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ],
                1 => (object) [
                  'isAdminOnly' => true
                ]
              ]
            ],
            6 => (object) [
              'label' => 'Filters',
              'link' => '#EmailFilter',
              'accessDataList' => [
                0 => (object) [
                  'inPortalDisabled' => true
                ]
              ]
            ]
          ]
        ],
        'detail' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Reply',
              'action' => 'reply',
              'acl' => 'read'
            ],
            1 => (object) [
              'label' => 'Reply to All',
              'action' => 'replyToAll',
              'acl' => 'read'
            ],
            2 => (object) [
              'label' => 'Forward',
              'action' => 'forward',
              'acl' => 'read'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'selectHandler' => 'handlers/email/select-user'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'replied' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliedId',
                  'data' => (object) [
                    'field' => 'replied'
                  ]
                ]
              ]
            ]
          ],
          'replies' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'repliesIds',
                  'data' => (object) [
                    'field' => 'replies'
                  ]
                ]
              ]
            ]
          ],
          'folderString' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isUsers'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'groupFolderId'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'sendAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'event' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'icsEventDateStart'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [],
      'defaultFilterData' => (object) [],
      'boolFilterList' => [],
      'iconClass' => 'fas fa-envelope',
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutDetailDisabled' => true,
      'layoutDetailSmallDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true
    ],
    'EmailAccount' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/email-account/record/list',
        'detail' => 'views/email-account/record/detail',
        'edit' => 'views/email-account/record/edit'
      ],
      'views' => (object) [
        'list' => 'views/email-account/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => (object) [
        'storeSentEmails' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ],
              1 => (object) [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'sentFolder'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'sentFolder'
              ]
            ],
            1 => (object) [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'sentFolder'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'smtpUsername' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'active'
        ]
      ],
      'relationshipPanels' => (object) [
        'filters' => (object) [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailAddress' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'EmailFilter' => (object) [
      'controller' => 'controllers/email-filter',
      'dynamicHandler' => 'handlers/email-filter',
      'modalViews' => (object) [
        'edit' => 'views/email-filter/modals/edit'
      ],
      'recordViews' => (object) [
        'list' => 'views/email-filter/record/list'
      ],
      'inlineEditDisabled' => true,
      'searchPanelDisabled' => false,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'parent' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isFalse'
                ]
              ]
            ]
          ],
          'emailFolder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Folder'
                ]
              ]
            ]
          ],
          'groupEmailFolder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'action',
                  'type' => 'equals',
                  'value' => 'Move to Group Folder'
                ]
              ]
            ]
          ],
          'markAsRead' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ],
          'skipNotification' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'action' => [
            0 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'isGlobal',
                  'type' => 'isTrue'
                ]
              ],
              'optionList' => [
                0 => 'Skip'
              ]
            ],
            1 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'User'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Folder',
                2 => 'None'
              ]
            ],
            2 => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentType',
                  'type' => 'equals',
                  'value' => 'InboundEmail'
                ]
              ],
              'optionList' => [
                0 => 'Skip',
                1 => 'Move to Group Folder'
              ]
            ],
            3 => (object) [
              'conditionGroup' => [],
              'optionList' => [
                0 => 'Skip'
              ]
            ]
          ]
        ]
      ]
    ],
    'EmailFolder' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/email-folder/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Emails',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'EmailTemplate' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/email-template/list'
      ],
      'recordViews' => (object) [
        'edit' => 'views/email-template/record/edit',
        'detail' => 'views/email-template/record/detail',
        'editQuick' => 'views/email-template/record/edit-quick'
      ],
      'modalViews' => (object) [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'information',
            'label' => 'Info',
            'view' => 'views/email-template/record/panels/information'
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual'
      ],
      'placeholderList' => [
        0 => 'optOutUrl',
        1 => 'optOutLink'
      ],
      'iconClass' => 'fas fa-envelope-square'
    ],
    'EmailTemplateCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#EmailTemplateCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#EmailTemplateCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'emailTemplates' => (object) [
          'create' => false
        ],
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'ExternalAccount' => (object) [
      'controller' => 'controllers/external-account'
    ],
    'Global' => (object) [
      'detailActionList' => [
        0 => (object) [
          'name' => 'viewAuditLog',
          'label' => 'View Audit Log',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-audit-log',
          'groupIndex' => 4
        ],
        1 => (object) [
          'name' => 'viewUserAccess',
          'label' => 'View User Access',
          'actionFunction' => 'show',
          'checkVisibilityFunction' => 'isAvailable',
          'handler' => 'handlers/record/view-user-access',
          'groupIndex' => 4
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'dropdown' => [
            0 => (object) [
              'name' => 'startProcessGlobal',
              'action' => 'startProcessGlobal',
              'label' => 'Start Process',
              'acl' => 'create',
              'aclScope' => 'BpmnProcess',
              'hidden' => true,
              'data' => (object) [
                'handler' => 'advanced:start-process-action-handler'
              ],
              'initFunction' => 'init'
            ]
          ]
        ]
      ],
      'viewSetupHandlers' => (object) [
        'detail' => [
          0 => 'advanced:handlers/manual-workflow'
        ]
      ]
    ],
    'GlobalStream' => (object) [
      'controller' => 'controllers/global-stream',
      'iconClass' => 'fas fa-rss-square'
    ],
    'GroupEmailFolder' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'views/group-email-folder/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/group-email-folder/record/list',
        'editQuick' => 'views/email-folder/record/edit-small'
      ],
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'emails',
              'labelTranslation' => 'Global.scopeNamesPlural.Email',
              'link' => '#Email',
              'style' => 'default',
              'aclScope' => 'Email'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Home' => (object) [
      'iconClass' => 'fas fa-th-large'
    ],
    'Import' => (object) [
      'controller' => 'controllers/import',
      'acl' => 'acl/import',
      'recordViews' => (object) [
        'list' => 'views/import/record/list',
        'detail' => 'views/import/record/detail'
      ],
      'views' => (object) [
        'list' => 'views/import/list',
        'detail' => 'views/import/detail'
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'imported',
            'label' => 'Imported',
            'view' => 'views/import/record/panels/imported',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          1 => (object) [
            'name' => 'duplicates',
            'label' => 'Duplicates',
            'view' => 'views/import/record/panels/duplicates',
            'rowActionsView' => 'views/import/record/row-actions/duplicates',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ],
          2 => (object) [
            'name' => 'updated',
            'label' => 'Updated',
            'view' => 'views/import/record/panels/updated',
            'createDisabled' => true,
            'selectDisabled' => true,
            'unlinkDisabled' => true
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => (object) [
        'errors' => (object) [
          'unlinkDisabled' => true,
          'actionList' => [
            0 => (object) [
              'name' => 'export',
              'label' => 'Export',
              'handler' => 'handlers/import',
              'actionFunction' => 'errorExport'
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-import',
      'dateFormatList' => [
        0 => 'YYYY-MM-DD',
        1 => 'DD-MM-YYYY',
        2 => 'MM-DD-YYYY',
        3 => 'MM/DD/YYYY',
        4 => 'DD/MM/YYYY',
        5 => 'DD.MM.YYYY',
        6 => 'MM.DD.YYYY',
        7 => 'YYYY.MM.DD',
        8 => 'DD. MM. YYYY'
      ],
      'timeFormatList' => [
        0 => 'HH:mm:ss',
        1 => 'HH:mm',
        2 => 'hh:mm a',
        3 => 'hh:mma',
        4 => 'hh:mm A',
        5 => 'hh:mmA',
        6 => 'hh:mm:ss a',
        7 => 'hh:mm:ssa',
        8 => 'hh:mm:ss A',
        9 => 'hh:mm:ssA'
      ]
    ],
    'ImportError' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'acl/foreign',
      'searchPanelDisabled' => true,
      'createDisabled' => true,
      'editDisabled' => true
    ],
    'InboundEmail' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/inbound-email/record/detail',
        'edit' => 'views/inbound-email/record/edit',
        'list' => 'views/inbound-email/record/list'
      ],
      'inlineEditDisabled' => true,
      'formDependency' => (object) [
        'reply' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'replyEmailTemplate',
                  1 => 'replyFromAddress',
                  2 => 'replyFromName'
                ]
              ],
              1 => (object) [
                'action' => 'setRequired',
                'fields' => [
                  0 => 'replyEmailTemplate'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'replyEmailTemplate',
                1 => 'replyFromAddress',
                2 => 'replyFromName'
              ]
            ],
            1 => (object) [
              'action' => 'setNotRequired',
              'fields' => [
                0 => 'replyEmailTemplate'
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'smtpUsername' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'useSmtp'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'smtpAuth'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'fetchSince' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'fetchData'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'useImap'
                ]
              ]
            ]
          ],
          'isSystem' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true,
      'relationshipPanels' => (object) [
        'filters' => (object) [
          'select' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-edit-and-remove',
          'unlinkDisabled' => true
        ],
        'emails' => (object) [
          'select' => false,
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'unlinkDisabled' => true
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'detailSmall' => [],
        'edit' => [],
        'editSmall' => []
      ]
    ],
    'Job' => (object) [
      'modalViews' => (object) [
        'detail' => 'views/admin/job/modals/detail'
      ],
      'recordViews' => (object) [
        'list' => 'views/admin/job/record/list',
        'detailQuick' => 'views/admin/job/record/detail-small'
      ]
    ],
    'LastViewed' => (object) [
      'controller' => 'controllers/last-viewed',
      'views' => (object) [
        'list' => 'views/last-viewed/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/last-viewed/record/list'
      ]
    ],
    'LayoutSet' => (object) [
      'controller' => 'controllers/layout-set',
      'recordViews' => (object) [
        'list' => 'views/layout-set/record/list'
      ],
      'searchPanelDisabled' => true,
      'duplicateDisabled' => true,
      'relationshipPanels' => (object) [
        'teams' => (object) [
          'createDisabled' => true,
          'viewDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ]
    ],
    'LeadCapture' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'recordViews' => (object) [
        'detail' => 'views/lead-capture/record/detail',
        'list' => 'views/lead-capture/record/list'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'subscribeContactToTargetList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'subscribeToTargetList'
                ]
              ]
            ]
          ],
          'optInConfirmationLifetime' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'optInConfirmationSuccessMessage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'createLeadBeforeOptInConfirmation' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'smtpAccount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'skipOptInConfirmationIfSubscribed' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'optInConfirmation'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'targetListId',
                      'data' => (object) [
                        'field' => 'targetList'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'optInConfirmationEmailTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'optInConfirmation'
                ]
              ]
            ]
          ],
          'apiKey' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'phoneNumberCountry' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'fieldList',
                  'value' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'formSuccessText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formSuccessRedirectUrl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formLanguage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formFrameAncestors' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ],
          'formCaptcha' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'form' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'formEnabled'
                ]
              ]
            ]
          ]
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'request',
            'label' => 'Request',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/request',
            'notRefreshable' => true
          ],
          1 => (object) [
            'name' => 'form',
            'label' => 'Web Form',
            'isForm' => true,
            'view' => 'views/lead-capture/record/panels/form',
            'notRefreshable' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'logRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/view-and-remove',
          'layout' => 'listForLeadCapture',
          'select' => false,
          'create' => false
        ]
      ]
    ],
    'LeadCaptureLogRecord' => (object) [
      'modalViews' => (object) [
        'detail' => 'views/lead-capture-log-record/modals/detail'
      ]
    ],
    'Note' => (object) [
      'controller' => 'controllers/note',
      'collection' => 'collections/note',
      'recordViews' => (object) [
        'edit' => 'views/note/record/edit',
        'editQuick' => 'views/note/record/edit',
        'listRelated' => 'views/stream/record/list'
      ],
      'modalViews' => (object) [
        'edit' => 'views/note/modals/edit'
      ],
      'itemViews' => (object) [
        'Post' => 'views/stream/notes/post',
        'EventConfirmation' => 'crm:views/stream/notes/event-confirmation'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'handlers/note/record-detail-setup'
        ]
      ]
    ],
    'Notification' => (object) [
      'controller' => 'controllers/notification',
      'acl' => 'acl/notification',
      'aclPortal' => 'acl-portal/notification',
      'collection' => 'collections/note',
      'itemViews' => (object) [
        'System' => 'views/notification/items/system',
        'EmailInbox' => 'views/notification/items/email-inbox',
        'EventAttendee' => 'crm:views/notification/items/event-attendee'
      ]
    ],
    'PasswordChangeRequest' => (object) [
      'controller' => 'controllers/password-change-request'
    ],
    'PhoneNumber' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'exportDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => 'orphan'
      ]
    ],
    'Portal' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'views/portal/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only',
          'layout' => 'listSmall',
          'selectPrimaryFilterName' => 'activePortal'
        ],
        'authenticationProvider' => (object) [
          'createDisabled' => true
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'PortalRole' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/portal-role/record/detail',
        'edit' => 'views/portal-role/record/edit',
        'editQuick' => 'views/portal-role/record/edit',
        'list' => 'views/portal-role/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => (object) [
        'list' => 'views/portal-role/list'
      ]
    ],
    'PortalUser' => (object) [
      'controller' => 'controllers/portal-user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/portal-user/list'
      ],
      'recordViews' => (object) [
        'list' => 'views/user/record/list',
        'detail' => 'views/user/record/detail',
        'edit' => 'views/user/record/edit',
        'detailSmall' => 'views/user/record/detail-quick',
        'editSmall' => 'views/user/record/edit-quick'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'createdAt'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ]
        ]
      ],
      'filterList' => [
        0 => 'activePortal'
      ],
      'boolFilterList' => [],
      'selectDefaultFilters' => (object) [
        'filter' => 'activePortal'
      ],
      'iconClass' => 'far fa-user-circle'
    ],
    'Preferences' => (object) [
      'recordViews' => (object) [
        'edit' => 'views/preferences/record/edit'
      ],
      'views' => (object) [
        'edit' => 'views/preferences/edit'
      ],
      'acl' => 'acl/preferences',
      'aclPortal' => 'acl-portal/preferences',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'assignmentEmailNotificationsIgnoreEntityTypeList' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'receiveAssignmentEmailNotifications'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Role' => (object) [
      'recordViews' => (object) [
        'detail' => 'views/role/record/detail',
        'edit' => 'views/role/record/edit',
        'editQuick' => 'views/role/record/edit',
        'list' => 'views/role/record/list'
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ],
        'teams' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-unlink-only'
        ]
      ],
      'views' => (object) [
        'list' => 'views/role/list'
      ]
    ],
    'ScheduledJob' => (object) [
      'controller' => 'controllers/record',
      'relationshipPanels' => (object) [
        'log' => (object) [
          'readOnly' => true,
          'view' => 'views/scheduled-job/record/panels/log',
          'createDisabled' => true,
          'selectDisabled' => true,
          'viewDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'recordViews' => (object) [
        'list' => 'views/scheduled-job/record/list',
        'detail' => 'views/scheduled-job/record/detail'
      ],
      'views' => (object) [
        'list' => 'views/scheduled-job/list'
      ],
      'jobWithTargetList' => [
        0 => 'CheckEmailAccounts',
        1 => 'CheckInboundEmails'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'job' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ScheduledJobLogRecord' => (object) [
      'controller' => 'controllers/record'
    ],
    'Stream' => (object) [
      'controller' => 'controllers/stream',
      'iconClass' => 'fas fa-rss'
    ],
    'Team' => (object) [
      'acl' => 'acl/team',
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'createdAt'
        ]
      ],
      'relationshipPanels' => (object) [
        'users' => (object) [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'layout' => 'listForTeam',
          'selectPrimaryFilterName' => 'active',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ],
          'rowActionList' => [
            0 => 'changeTeamPosition'
          ],
          'selectMandatoryAttributeList' => [
            0 => 'teamRole'
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'views/team/record/detail',
        'edit' => 'views/team/record/edit',
        'list' => 'views/team/record/list'
      ],
      'modalViews' => (object) [
        'detail' => 'views/team/modals/detail'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-users'
    ],
    'Template' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'views/template/record/detail',
        'edit' => 'views/template/record/edit'
      ],
      'mergeDisabled' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'footer' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'footerPosition' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printFooter'
                ]
              ]
            ]
          ],
          'header' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'headerPosition' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'printHeader'
                ]
              ]
            ]
          ],
          'body' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'pageWidth' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ],
          'pageHeight' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'pageFormat',
                  'value' => 'Custom'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-file-pdf'
    ],
    'User' => (object) [
      'controller' => 'controllers/user',
      'model' => 'models/user',
      'acl' => 'acl/user',
      'views' => (object) [
        'detail' => 'views/user/detail',
        'list' => 'views/user/list'
      ],
      'recordViews' => (object) [
        'detail' => 'views/user/record/detail',
        'detailSmall' => 'views/user/record/detail-quick',
        'edit' => 'views/user/record/edit',
        'editSmall' => 'views/user/record/edit-quick',
        'list' => 'views/user/record/list'
      ],
      'modalViews' => (object) [
        'selectFollowers' => 'views/user/modals/select-followers',
        'detail' => 'views/user/modals/detail',
        'massUpdate' => 'views/user/modals/mass-update'
      ],
      'rowActionDefs' => (object) [
        'changeTeamPosition' => (object) [
          'labelTranslation' => 'User.actions.changePosition',
          'handler' => 'handlers/user/change-team-position-row-action',
          'groupIndex' => 3
        ],
        'changeProjectRole' => (object) [
          'labelTranslation' => 'Project.actions.changeRole',
          'handler' => 'modules/project/handlers/user/change-project-role-row-action'
        ]
      ],
      'defaultSidePanel' => (object) [
        'detail' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'detailSmall' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'edit' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ],
        'editSmall' => (object) [
          'name' => 'default',
          'label' => false,
          'view' => 'views/user/record/panels/default-side',
          'isForm' => true
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => 'avatar',
          1 => 'createdAt',
          2 => 'lastAccess',
          3 => 'auth2FA'
        ],
        'detailSmall' => [
          0 => 'avatar',
          1 => 'lastAccess'
        ],
        'edit' => [
          0 => 'avatar'
        ],
        'editSmall' => [
          0 => 'avatar'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks',
            'view' => 'crm:views/user/record/panels/tasks'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'migrations' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'migrationsaccountManager' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'processOwnerMigrations' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountSales' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cAccountSales' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountsBdms' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunities' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'layoutDefaultSidePanelDisabled' => true,
      'filterList' => [
        0 => 'active',
        1 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab1ec9e2cc5afe'
        ],
        2 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab1fb8382eba48'
        ],
        3 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter669ab2078ca7cc670'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMyTeam'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'selectRecords' => (object) [
        'orderBy' => 'userNameOwnFirst'
      ],
      'iconClass' => 'fas fa-user-circle',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'avatarColor' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'avatarId',
                  'value' => NULL,
                  'data' => (object) [
                    'field' => 'avatar'
                  ]
                ],
                1 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'regular',
                    1 => 'admin',
                    2 => 'api'
                  ]
                ]
              ]
            ]
          ],
          'mobileApp' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Mobile App',
                      'linkId' => '65492a0fbb9a2d5e6'
                    ]
                  ],
                  'value' => '65492a0fbb9a2d5e6'
                ]
              ]
            ]
          ],
          'configApp' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'mobileApp'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'authMethod' => [
            0 => (object) [
              'optionList' => [
                0 => 'ApiKey',
                1 => 'Hmac'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'api'
                ]
              ]
            ]
          ]
        ],
        'panels' => []
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'bottomPanels' => []
    ],
    'Webhook' => (object) [
      'controller' => 'controllers/record',
      'inlineEditDisabled' => true,
      'recordViews' => (object) [
        'list' => 'views/webhook/record/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.WebhookQueueItem',
              'link' => '#WebhookQueueItem',
              'aclScope' => 'WebhookQueueItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'event' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'secretKey' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WebhookQueueItem' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'editDisabled' => true,
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'textFilterDisabled' => true
    ],
    'WorkingTimeCalendar' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'iconClass' => 'fas fa-calendar-week',
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'ranges',
              'labelTranslation' => 'WorkingTimeCalendar.links.ranges',
              'link' => '#WorkingTimeRange'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'weekday0TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday0'
                ]
              ]
            ]
          ],
          'weekday1TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday1'
                ]
              ]
            ]
          ],
          'weekday2TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday2'
                ]
              ]
            ]
          ],
          'weekday3TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday3'
                ]
              ]
            ]
          ],
          'weekday4TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday4'
                ]
              ]
            ]
          ],
          'weekday5TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday5'
                ]
              ]
            ]
          ],
          'weekday6TimeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'weekday6'
                ]
              ]
            ]
          ],
          'teams' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'teamsIds'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkingTimeRange' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'record/edit' => [
          0 => 'handlers/working-time-range'
        ]
      ],
      'mergeDisabled' => true,
      'massUpdateDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'calendars',
              'label' => 'Calendars',
              'link' => '#WorkingTimeCalendar'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'timeRanges' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Working'
                ]
              ]
            ]
          ],
          'users' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'usersIds'
                    ],
                    2 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'calendarsIds'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual'
      ]
    ],
    'Account' => (object) [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/account',
      'views' => (object) [
        'detail' => 'crm:views/account/detail',
        'edit' => 'custom:views/Account/edit'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ],
          3 => (object) [
            'isReportPanel' => true,
            'name' => 'reportPanel6480aaffadaabae2e',
            'label' => 'Closed Won - Opportunities',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-side',
            'reportPanelId' => '6480aaffadaabae2e',
            'reportType' => 'Grid',
            'reportEntityType' => 'Opportunity',
            'displayType' => 'Table',
            'displayTotal' => true,
            'displayOnlyTotal' => true,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => (object) [
                'scope' => 'Opportunity'
              ]
            ],
            'column' => 'SUM:amountDiscountConverted'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => (object) [
            'isReportPanel' => true,
            'name' => 'reportPanel6724e9e56e840668c',
            'label' => 'Microsoft Recommendations in the next 90 days',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '6724e9e56e840668c',
            'reportType' => 'List',
            'reportEntityType' => 'SalesOrder',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => (object) [
                'scope' => 'SalesOrder'
              ]
            ],
            'order' => 7
          ],
          3 => (object) [
            'isReportPanel' => true,
            'name' => 'reportPanel667d7510ae2206004',
            'label' => 'Microsoft Renewals in the next 90 days',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '667d7510ae2206004',
            'reportType' => 'List',
            'reportEntityType' => 'SalesOrder',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => (object) [
                'scope' => 'SalesOrder'
              ]
            ],
            'order' => 7
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'filterList' => [
            0 => 'all',
            1 => 'accountActive'
          ],
          'layout' => NULL,
          'orderBy' => 'name',
          'createAttributeMap' => (object) [
            'billingAddressCity' => 'addressCity',
            'billingAddressStreet' => 'addressStreet',
            'billingAddressPostalCode' => 'addressPostalCode',
            'billingAddressState' => 'addressState',
            'billingAddressCountry' => 'addressCountry',
            'id' => 'accountId',
            'name' => 'accountName'
          ],
          'selectPrimaryFilterName' => NULL
        ],
        'opportunities' => (object) [
          'layout' => 'listForAccount',
          'createHandler' => 'sales:handlers/account/create-opportunity'
        ],
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => (object) [
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'quotes' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'salesOrders' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/account/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'purchaseOrders' => (object) [
          'createAction' => 'createRelatedPurchaseOrder',
          'view' => 'sales:views/account/record/panels/purchase-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'userSales' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cUserSales' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'renewalsMicrosoft' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cRenewalsMicrosoft' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'bdm' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'partnerAssessment' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'contactsAccount' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cContactsAccount' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'recentlyCreated'
        ],
        1 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter6660add1bf8c29edd'
        ],
        2 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter67c9a61c38980f876'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ]
      ],
      'color' => '#edc755',
      'iconClass' => 'fas fa-building',
      'kanbanViewMode' => false,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'surestepLevel' => (object) [
            'visible' => NULL
          ],
          'licenseType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'industry' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Argentina (Microsoft)',
                      'linkId' => '6217bac9e998125bd'
                    ]
                  ],
                  'value' => '6217bac9e998125bd'
                ]
              ]
            ]
          ],
          'region' => (object) [
            'visible' => NULL
          ],
          'teams' => (object) [
            'visible' => NULL,
            'readOnly' => NULL
          ],
          'assignedUser' => (object) [
            'visible' => NULL
          ],
          'sicCode' => (object) [
            'required' => NULL
          ],
          'website' => (object) [
            'invalid' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'website',
                  'value' => 'gmail.com'
                ]
              ]
            ],
            'visible' => NULL,
            'required' => NULL
          ],
          'accountParent' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'typeOfCompany',
                  'value' => 'Filial'
                ]
              ]
            ]
          ],
          'accounts' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'typeOfCompany',
                  'value' => 'Matriz'
                ]
              ]
            ]
          ],
          'sPMSID' => (object) [
            'visible' => NULL
          ],
          'cisCode' => (object) [
            'required' => NULL
          ],
          'cContactsAccount' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ],
                    1 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'country'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'billingAddressCity' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'billingAddressState' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'cPartnerFocus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'solutions' => [
            0 => (object) [
              'optionList' => [
                0 => 'Citrix'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Citrix',
                      'linkId' => '62e92c41cc79ab39c'
                    ]
                  ],
                  'value' => '62e92c41cc79ab39c'
                ]
              ]
            ]
          ],
          'country' => NULL
        ],
        'panels' => []
      ]
    ],
    'Activities' => (object) [
      'controller' => 'crm:controllers/activities'
    ],
    'Calendar' => (object) [
      'colors' => (object) [
        'Meeting' => '#558BBD',
        'Call' => '#CF605D',
        'Task' => '#70c173',
        'ProjectTask' => '#73c5c0'
      ],
      'scopeList' => [
        0 => 'Meeting',
        1 => 'Call',
        2 => 'Task'
      ],
      'allDayScopeList' => [
        0 => 'Task'
      ],
      'modeList' => [
        0 => 'month',
        1 => 'agendaWeek',
        2 => 'timeline',
        3 => 'agendaDay'
      ],
      'sharedViewModeList' => [
        0 => 'basicWeek',
        1 => 'month',
        2 => 'basicDay'
      ],
      'additionalColorList' => [
        0 => '#AB78AD',
        1 => '#CC9B45'
      ],
      'iconClass' => 'far fa-calendar-alt',
      'slotDuration' => 30
    ],
    'Call' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/call',
      'views' => (object) [
        'detail' => 'crm:views/call/detail'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/call/record/list',
        'detail' => 'crm:views/call/record/detail',
        'editSmall' => 'crm:views/call/record/edit-small'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 3
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'disabled' => false,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'planned'
        ],
        1 => (object) [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => (object) [
        'link' => 'calls',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => (object) [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => (object) [
        'bottomPanelsEditSmall' => (object) [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'iconClass' => 'fas fa-phone',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'leadCountry' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'leadId',
                  'data' => (object) [
                    'field' => 'lead'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Campaign' => (object) [
      'controller' => 'controllers/record',
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Target Lists',
              'link' => '#TargetList',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'TargetList'
            ]
          ],
          'dropdown' => [
            0 => (object) [
              'label' => 'Mass Emails',
              'link' => '#MassEmail',
              'acl' => 'read',
              'aclScope' => 'MassEmail'
            ],
            1 => (object) [
              'label' => 'Email Templates',
              'link' => '#EmailTemplate',
              'acl' => 'read',
              'aclScope' => 'EmailTemplate'
            ],
            2 => (object) [
              'label' => 'Tracking URLs',
              'labelTranslation' => 'Campaign.links.trackingUrls',
              'link' => '#CampaignTrackingUrl',
              'acl' => 'read',
              'aclScope' => 'CampaignTrackingUrl'
            ]
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/campaign/record/detail'
      ],
      'views' => (object) [
        'detail' => 'crm:views/campaign/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'statistics',
            'label' => 'Statistics',
            'view' => 'crm:views/campaign/record/panels/campaign-stats',
            'hidden' => false,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'view' => 'crm:views/campaign/record/panels/campaign-log-records',
          'layout' => 'listForCampaign',
          'rowActionsView' => 'views/record/row-actions/remove-only',
          'select' => false,
          'create' => false
        ],
        'massEmails' => (object) [
          'createAttributeMap' => (object) [
            'targetListsIds' => 'targetListsIds',
            'targetListsNames' => 'targetListsNames',
            'excludingTargetListsIds' => 'excludingTargetListsIds',
            'excludingTargetListsNames' => 'excludingTargetListsNames'
          ],
          'createHandler' => 'crm:handlers/campaign/mass-emails-create'
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetLists' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'excludingTargetLists' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Email'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Newsletter'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'type',
                      'value' => 'Mail'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'contactsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'leadsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'accountsTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'usersTemplate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ],
          'mailMergeOnlyWithAddress' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'mailMerge' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Mail'
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-line'
    ],
    'CampaignLogRecord' => (object) [
      'acl' => 'crm:acl/campaign-tracking-url'
    ],
    'CampaignTrackingUrl' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/campaign-tracking-url',
      'recordViews' => (object) [
        'edit' => 'crm:views/campaign-tracking-url/record/edit',
        'editQuick' => 'crm:views/campaign-tracking-url/record/edit-small'
      ],
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'url' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Redirect'
                ]
              ]
            ]
          ],
          'message' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'action',
                  'value' => 'Show Message'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Case' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'crm:views/case/record/detail'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'close',
          'label' => 'Close',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'close',
          'checkVisibilityFunction' => 'isCloseAvailable'
        ],
        1 => (object) [
          'name' => 'reject',
          'label' => 'Reject',
          'handler' => 'crm:handlers/case/detail-actions',
          'actionFunction' => 'reject',
          'checkVisibilityFunction' => 'isRejectAvailable'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/case/record/panels/activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'open'
        ],
        1 => (object) [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => (object) [
        'articles' => (object) [
          'createDisabled' => true,
          'editDisabled' => true,
          'removeDisabled' => true,
          'rowActionList' => [
            0 => 'sendInEmail'
          ]
        ],
        'contacts' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'open'
      ],
      'allowInternalNotes' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'number' => (object) [
            'visible' => NULL
          ],
          'other' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'solicitationEntity',
                  'value' => 'Other'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'solicitationEntity',
                  'value' => 'Other'
                ]
              ]
            ]
          ],
          'slaPrediction' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailPortal' => (object) [
          'type' => 'detail'
        ],
        'detailSmallPortal' => (object) [
          'type' => 'detail'
        ],
        'listPortal' => (object) [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-briefcase',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'Contact' => (object) [
      'controller' => 'controllers/record',
      'aclPortal' => 'crm:acl-portal/contact',
      'views' => (object) [
        'detail' => 'crm:views/contact/detail'
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/contact/record/detail',
        'detailQuick' => 'crm:views/contact/record/detail-small'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'opportunities' => (object) [
          'layout' => 'listForContact',
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'cases' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName',
            'id' => 'contactId',
            'name' => 'contactName'
          ],
          'selectHandler' => 'handlers/select-related/same-account'
        ],
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ],
        'marketing' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accounts' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountEndCustomer' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunityContactGoogle' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountContact' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cAccountContact' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'billingContactOpportunities' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ],
        'listForAccount' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'filterList' => [
        0 => 'portalUsers'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'title' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'accountId'
                ]
              ]
            ]
          ],
          'portalUser' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'portalUserId',
                  'data' => (object) [
                    'field' => 'portalUser'
                  ]
                ]
              ]
            ]
          ],
          'partnerID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Renewal'
                ]
              ]
            ]
          ],
          'customerID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Customer'
                ]
              ]
            ]
          ],
          'requestedContact' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'requestedContact'
                ]
              ]
            ]
          ],
          'source' => (object) [
            'visible' => NULL
          ],
          'cMarketing' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'source',
                  'value' => [
                    0 => 'Campaign',
                    1 => 'Manufacturer',
                    2 => 'Meetings'
                  ]
                ]
              ]
            ]
          ],
          'salesContact' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'salesContact'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#a4c5e0',
      'iconClass' => 'fas fa-id-badge',
      'kanbanViewMode' => false
    ],
    'Document' => (object) [
      'aclPortal' => 'crm:acl-portal/document',
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/document/list'
      ],
      'modalViews' => (object) [
        'select' => 'crm:views/document/modals/select-records'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'crm:view-setup-handlers/document/record-list-drag-n-drop'
        ]
      ],
      'filterList' => [
        0 => 'active',
        1 => 'draft'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'iconClass' => 'far fa-file-alt',
      'recordViews' => (object) [
        'editSmall' => 'custom:views/Document/record/edit-small'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'avisoEstimativa' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Demo',
                      'linkId' => '6785619145089d834'
                    ]
                  ],
                  'value' => '6785619145089d834'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'DocumentFolder' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#DocumentFolder/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#DocumentFolder',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Documents',
              'link' => '#Document',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'Document'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'EmailQueueItem' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/email-queue-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/email-queue-item/record/list'
      ],
      'createDisabled' => true,
      'mergeDisabled' => true,
      'massUpdateDisabled' => true
    ],
    'KnowledgeBaseArticle' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'crm:views/knowledge-base-article/list'
      ],
      'recordViews' => (object) [
        'editQuick' => 'crm:views/knowledge-base-article/record/edit-quick',
        'detailQuick' => 'crm:views/knowledge-base-article/record/detail-quick',
        'detail' => 'crm:views/knowledge-base-article/record/detail',
        'edit' => 'crm:views/knowledge-base-article/record/edit',
        'list' => 'crm:views/knowledge-base-article/record/list'
      ],
      'modalViews' => (object) [
        'select' => 'crm:views/knowledge-base-article/modals/select-records'
      ],
      'rowActionDefs' => (object) [
        'moveToTop' => (object) [
          'label' => 'Move to Top',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveUp' => (object) [
          'label' => 'Move Up',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveDown' => (object) [
          'label' => 'Move Down',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'moveToBottom' => (object) [
          'labelTranslation' => 'KnowledgeBaseArticle.labels.Move to Bottom',
          'handler' => 'crm:handlers/knowledge-base-article/move',
          'acl' => 'edit'
        ],
        'sendInEmail' => (object) [
          'label' => 'Send in Email',
          'handler' => 'crm:handlers/knowledge-base-article/send-in-email'
        ]
      ],
      'rowActionList' => [
        0 => 'moveToTop',
        1 => 'moveUp',
        2 => 'moveDown',
        3 => 'moveToBottom'
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'published',
          'accessDataList' => [
            0 => (object) [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => (object) [
          'name' => 'onlyMy',
          'accessDataList' => [
            0 => (object) [
              'inPortalDisabled' => true
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'cases' => (object) [
          'create' => false,
          'rowActionsView' => 'views/record/row-actions/relationship-view-and-unlink'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailPortal' => (object) [
          'type' => 'detail'
        ],
        'detailSmallPortal' => (object) [
          'type' => 'detail'
        ],
        'listPortal' => (object) [
          'type' => 'list'
        ]
      ],
      'iconClass' => 'fas fa-book',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'KnowledgeBaseCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#KnowledgeBaseCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#KnowledgeBaseCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Articles',
              'link' => '#KnowledgeBaseArticle',
              'acl' => 'read',
              'style' => 'default',
              'aclScope' => 'KnowledgeBaseArticle'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'children' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ]
    ],
    'Lead' => (object) [
      'controller' => 'crm:controllers/lead',
      'views' => (object) [
        'detail' => 'crm:views/lead/detail'
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/lead/record/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'activities',
            'reference' => 'activities'
          ],
          2 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          3 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'convertedTo',
            'label' => 'Converted To',
            'view' => 'crm:views/lead/record/panels/converted-to',
            'notRefreshable' => true,
            'hidden' => true,
            'style' => 'success',
            'isForm' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'campaignLogRecords' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'select' => false,
          'create' => false
        ],
        'targetLists' => (object) [
          'create' => false,
          'rowActionsView' => 'crm:views/record/row-actions/relationship-target',
          'layout' => 'listForTarget',
          'view' => 'crm:views/record/panels/target-lists'
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'converted',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'name' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'accountName'
                ],
                1 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'emailAddress'
                ],
                2 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'phoneNumber'
                ]
              ]
            ]
          ],
          'convertedAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'status',
                      'value' => 'Converted'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'convertedAt'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'createSurestep' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'createSurestep'
                ]
              ]
            ]
          ],
          'ciscoProjectWon' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'alreadyContacted' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cisco',
                      'linkId' => '6203cd650d9de63df'
                    ]
                  ],
                  'value' => '6203cd650d9de63df'
                ]
              ]
            ]
          ],
          'marketings' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'notEquals',
                      'attribute' => 'source',
                      'value' => NULL
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'convertedTo' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Converted'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'status' => NULL,
          'source' => NULL,
          'type' => [
            0 => (object) [
              'optionList' => [
                0 => 'Customer',
                1 => 'Reseller',
                2 => 'ISV',
                3 => 'Operadora/ISP',
                4 => 'Fabricante',
                5 => 'TD SYNNEX'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'ISV Experience (Roleta)',
                      'linkId' => '632cc1e1e69b213db'
                    ]
                  ],
                  'value' => '632cc1e1e69b213db'
                ]
              ]
            ]
          ]
        ]
      ],
      'color' => '#d6a2c9',
      'iconClass' => 'fas fa-address-card',
      'kanbanViewMode' => true
    ],
    'MassEmail' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/mass-email',
      'recordViews' => (object) [
        'detail' => 'crm:views/mass-email/record/detail',
        'edit' => 'crm:views/mass-email/record/edit',
        'editQuick' => 'crm:views/mass-email/record/edit-small'
      ],
      'views' => (object) [
        'detail' => 'crm:views/mass-email/detail'
      ],
      'defaultSidePanel' => (object) [
        'edit' => false,
        'editSmall' => false
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.EmailQueueItem',
              'link' => '#EmailQueueItem',
              'accessDataList' => [
                0 => (object) [
                  'isAdminOnly' => true
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'or',
                      'value' => [
                        0 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Complete'
                        ],
                        1 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'In Process'
                        ],
                        2 => (object) [
                          'type' => 'equals',
                          'attribute' => 'status',
                          'value' => 'Failed'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'status' => [
            0 => (object) [
              'optionList' => [
                0 => 'Draft',
                1 => 'Pending'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Draft',
                    1 => 'Pending'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'complete',
          'style' => 'success'
        ]
      ],
      'relationshipPanels' => (object) [
        'queueItems' => (object) [
          'unlinkDisabled' => true,
          'viewDisabled' => true,
          'editDisabled' => true
        ]
      ]
    ],
    'Meeting' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'crm:acl/meeting',
      'views' => (object) [
        'detail' => 'crm:views/meeting/detail'
      ],
      'recordViews' => (object) [
        'list' => 'crm:views/meeting/record/list',
        'detail' => 'crm:views/meeting/record/detail',
        'editSmall' => 'crm:views/meeting/record/edit-small'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/meeting/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/event/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/event/reminders-handler'
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'options' => (object) [
              'fieldList' => [
                0 => 'users',
                1 => 'contacts',
                2 => 'leads'
              ]
            ],
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'attendees',
            'label' => 'Attendees',
            'view' => 'crm:views/meeting/record/panels/attendees',
            'sticked' => true,
            'isForm' => true,
            'notRefreshable' => true
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 3
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ],
        'editSmall' => [
          0 => (object) [
            'name' => 'scheduler',
            'label' => 'Scheduler',
            'view' => 'crm:views/meeting/record/panels/scheduler',
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'planned'
        ],
        1 => (object) [
          'name' => 'held',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'activityDefs' => (object) [
        'link' => 'meetings',
        'activitiesCreate' => true,
        'historyCreate' => true
      ],
      'forcePatchAttributeDependencyMap' => (object) [
        'dateEnd' => [
          0 => 'dateStart'
        ],
        'dateEndDate' => [
          0 => 'dateStartDate'
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ]
      ],
      'additionalLayouts' => (object) [
        'bottomPanelsEditSmall' => (object) [
          'type' => 'bottomPanelsEditSmall'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'duration' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isAllDay'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-calendar-check'
    ],
    'Opportunity' => (object) [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'crm:handlers/opportunity/defaults-preparator',
      'views' => (object) [
        'detail' => 'custom:views/Opportunity/detail',
        'edit' => 'custom:views/Opportunity/edit'
      ],
      'recordViews' => (object) [
        'edit' => 'custom:views/Opportunity/record/edit',
        'editSmall' => 'crm:views/opportunity/record/edit-small',
        'list' => 'crm:views/opportunity/record/list',
        'kanban' => 'crm:views/opportunity/record/kanban',
        'detail' => 'custom:views/Opportunity/record/detail'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history'
          ],
          2 => (object) [
            'name' => 'tasks',
            'reference' => 'tasks'
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'reference' => 'activities',
            'disabled' => true,
            'view' => 'crm:views/opportunity/record/panels/activities'
          ],
          1 => (object) [
            'name' => 'history',
            'reference' => 'history',
            'disabled' => true
          ],
          2 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/opportunity/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true,
            'order' => 1
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'open'
        ],
        1 => (object) [
          'name' => 'won',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailConvert' => (object) [
          'type' => 'detail'
        ],
        'listForAccount' => (object) [
          'type' => 'listSmall'
        ],
        'listForContact' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'createHandler' => 'crm:handlers/opportunity/contacts-create',
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'contact' => (object) [
          'createAttributeMap' => (object) [
            'accountId' => 'accountId',
            'accountName' => 'accountName'
          ],
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'documents' => (object) [
          'selectHandler' => 'handlers/select-related/same-account-many'
        ],
        'quotes' => (object) [
          'createAction' => 'createRelatedQuote',
          'view' => 'sales:views/opportunity/record/panels/quotes',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'selectPrimaryFilterName' => NULL
        ],
        'salesOrders' => (object) [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/opportunity/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/opportunity/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'account' => (object) [
          'selectFieldHandler' => 'sales:handlers/opportunity/select-account',
          'selectMandatoryAttributeList' => [
            0 => 'priceBookId',
            1 => 'priceBookName'
          ]
        ],
        'quotesOpportunity' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunityGoogle' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'accountReseller' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'users' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'contactOpportunityGoogle' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'quoteReview' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cQuoteReview' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'billingContact' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'lastStage' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Lost'
                ]
              ]
            ]
          ],
          'licenseType' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '625f87f09223468fc'
                ],
                1 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google CCA',
                      'linkId' => '6434183de37dc38f3'
                    ]
                  ],
                  'value' => '6434183de37dc38f3'
                ],
                1 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google NOLA',
                      'linkId' => '6434182fafe7d4fe6'
                    ]
                  ],
                  'value' => '6434182fafe7d4fe6'
                ],
                2 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google SOLA',
                      'linkId' => '643417ce3ea5ac5c4'
                    ]
                  ],
                  'value' => '643417ce3ea5ac5c4'
                ]
              ]
            ]
          ],
          'solutionType' => (object) [
            'visible' => NULL,
            'required' => NULL
          ],
          'dollarType' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud (Microsoft)',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'amountCurrency',
                  'value' => 'BRL'
                ]
              ]
            ]
          ],
          'dollarCIS' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'dollarType',
                  'value' => 'Dólar CIS'
                ]
              ]
            ]
          ],
          'dollarIBM' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'dollarType',
                  'value' => 'Dólar IBM'
                ]
              ]
            ]
          ],
          'crmID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ]
          ],
          'region' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ]
          ],
          'amountDiscount' => (object) [
            'visible' => NULL
          ],
          'cdpOpportunityID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ]
          ],
          'lostReason' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Cancelada'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Closed Lost'
                    ]
                  ]
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'stage',
                  'value' => [
                    0 => 'Cancelada',
                    1 => 'Closed Lost'
                  ]
                ]
              ]
            ]
          ],
          'partnerResponsible' => (object) [
            'visible' => NULL
          ],
          'reason' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Cancelada'
                ]
              ]
            ]
          ],
          'productBrand' => (object) [
            'readOnly' => NULL,
            'required' => NULL
          ],
          'realAmount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Brasil (Microsoft)',
                      'linkId' => '63fe2e975c350b246'
                    ]
                  ],
                  'value' => '63fe2e975c350b246'
                ],
                1 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                2 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google Brasil',
                      'linkId' => '643418441fabd22dd'
                    ]
                  ],
                  'value' => '643418441fabd22dd'
                ],
                3 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google BR',
                      'linkId' => '64a4901d96801e7cc'
                    ]
                  ],
                  'value' => '64a4901d96801e7cc'
                ],
                4 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Brasil (Geral)',
                      'linkId' => '6217badb36ba2650e'
                    ]
                  ],
                  'value' => '6217badb36ba2650e'
                ]
              ]
            ]
          ],
          'marketing' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'sourceNew',
                  'value' => [
                    0 => 'Campanhas',
                    1 => 'Fabricante',
                    2 => 'Meetings'
                  ]
                ]
              ]
            ],
            'required' => NULL
          ],
          'sourceNew' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notEquals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'amount' => (object) [
            'visible' => NULL
          ],
          'newcustomer' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'or',
                      'value' => [
                        0 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Argentina (Microsoft)',
                              'linkId' => '6217bac9e998125bd'
                            ]
                          ],
                          'value' => '6217bac9e998125bd'
                        ],
                        1 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Bolivia (Microsoft)',
                              'linkId' => '6217bad3434b90c8e'
                            ]
                          ],
                          'value' => '6217bad3434b90c8e'
                        ],
                        2 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Caribe (Microsoft)',
                              'linkId' => '6217bae5d02a31c67'
                            ]
                          ],
                          'value' => '6217bae5d02a31c67'
                        ],
                        3 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'CCA (Microsoft)',
                              'linkId' => '6217baf6c5a88a957'
                            ]
                          ],
                          'value' => '6217baf6c5a88a957'
                        ],
                        4 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Chile (Microsoft)',
                              'linkId' => '6217bc1cdf861cab6'
                            ]
                          ],
                          'value' => '6217bc1cdf861cab6'
                        ],
                        5 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Colombia (Microsoft)',
                              'linkId' => '6217bc253e84db65c'
                            ]
                          ],
                          'value' => '6217bc253e84db65c'
                        ],
                        6 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Ecuador (Microsoft)',
                              'linkId' => '6217bc2db2c52349a'
                            ]
                          ],
                          'value' => '6217bc2db2c52349a'
                        ],
                        7 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Management (Microsoft)',
                              'linkId' => '64ff7607143543219'
                            ]
                          ],
                          'value' => '64ff7607143543219'
                        ],
                        8 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Mexico (Microsoft)',
                              'linkId' => '6216cf950b84911eb'
                            ]
                          ],
                          'value' => '6216cf950b84911eb'
                        ],
                        9 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Paraguay (Microsoft)',
                              'linkId' => '63c851e37c1d13fac'
                            ]
                          ],
                          'value' => '63c851e37c1d13fac'
                        ],
                        10 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Peru (Microsoft)',
                              'linkId' => '6217bc3d5744311c2'
                            ]
                          ],
                          'value' => '6217bc3d5744311c2'
                        ],
                        11 => (object) [
                          'type' => 'contains',
                          'attribute' => 'teamsIds',
                          'data' => (object) [
                            'field' => 'teams',
                            'values' => (object) [
                              'linkName' => 'Uruguay (Microsoft)',
                              'linkId' => '63c851ec4cf85a2e4'
                            ]
                          ],
                          'value' => '63c851ec4cf85a2e4'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'connectedAreas' => (object) [
            'required' => NULL,
            'visible' => NULL
          ],
          'connectedAreasStatus' => (object) [
            'visible' => NULL,
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'connectedAreas'
                ]
              ]
            ]
          ],
          'users' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ],
                    2 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Brasil (Geral)',
                          'linkId' => '6217badb36ba2650e'
                        ]
                      ],
                      'value' => '6217badb36ba2650e'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'discountValue' => (object) [
            'invalid' => NULL
          ],
          'createQuote' => (object) [
            'visible' => NULL,
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'quoteOppId',
                  'data' => (object) [
                    'field' => 'quoteOpp'
                  ]
                ]
              ]
            ]
          ],
          'quoteOpp' => (object) [
            'readOnly' => NULL,
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'quoteOppId',
                  'data' => (object) [
                    'field' => 'quoteOpp'
                  ]
                ]
              ]
            ]
          ],
          'billingContact' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'createQuote'
                ]
              ]
            ],
            'visible' => NULL,
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isFalse',
                  'attribute' => 'createQuote'
                ]
              ]
            ]
          ],
          'receipt' => (object) [
            'required' => NULL
          ],
          'presentQuoteEmail' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'presentQuoteEmail'
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'createQuote'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'billingContactID'
                    ]
                  ]
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'billingContactId',
                  'data' => (object) [
                    'field' => 'billingContact'
                  ]
                ]
              ]
            ]
          ],
          'quoteStatus' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'in',
                      'attribute' => 'quoteStatus',
                      'value' => [
                        0 => 'Canceled',
                        1 => 'Presented'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isFalse',
                      'attribute' => 'presentQuoteEmail'
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'quoteStatus'
                ]
              ]
            ]
          ],
          'billingContactID' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'billingContactId',
                  'data' => (object) [
                    'field' => 'billingContact'
                  ]
                ]
              ]
            ]
          ],
          'updated' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'quoteOppId',
                  'data' => (object) [
                    'field' => 'quoteOpp'
                  ]
                ]
              ]
            ]
          ],
          'proposalCode' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Won'
                ],
                1 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Google Brasil',
                          'linkId' => '643418441fabd22dd'
                        ]
                      ],
                      'value' => '643418441fabd22dd'
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'stage',
                  'value' => 'Closed Won'
                ],
                1 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Google Brasil',
                          'linkId' => '643418441fabd22dd'
                        ]
                      ],
                      'value' => '643418441fabd22dd'
                    ]
                  ]
                ]
              ]
            ],
            'invalid' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '-'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '='
                    ],
                    2 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '*'
                    ],
                    3 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '@'
                    ],
                    4 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '_'
                    ],
                    5 => (object) [
                      'type' => 'contains',
                      'attribute' => 'proposalCode',
                      'value' => '\''
                    ]
                  ]
                ]
              ]
            ]
          ],
          'migrationOrigin' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Migration'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Negotiation'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'stage',
                      'value' => 'Proposal'
                    ],
                    3 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'migrationOrigin'
                    ]
                  ]
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'equals',
                          'attribute' => 'productBrandId',
                          'data' => (object) [
                            'field' => 'productBrand',
                            'values' => (object) [
                              'productBrandName' => 'AWS'
                            ]
                          ],
                          'value' => '61c0b27f1ac2732b5'
                        ],
                        1 => (object) [
                          'type' => 'equals',
                          'attribute' => 'stage',
                          'value' => 'Migration'
                        ]
                      ]
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'equals',
                          'attribute' => 'productBrandId',
                          'data' => (object) [
                            'field' => 'productBrand',
                            'values' => (object) [
                              'productBrandName' => 'Microsoft'
                            ]
                          ],
                          'value' => '5f0b4703b1bafeb52'
                        ],
                        1 => (object) [
                          'type' => 'or',
                          'value' => [
                            0 => (object) [
                              'type' => 'equals',
                              'attribute' => 'stage',
                              'value' => 'Migration'
                            ]
                          ]
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'preSalesJira' => (object) [
            'visible' => NULL
          ],
          'commercialTerms' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'customer' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ]
              ]
            ]
          ],
          'customerEmail' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'customerEmail'
                ]
              ]
            ]
          ],
          'countryCustomer' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'addEndUser'
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'countryCustomer'
                ]
              ]
            ]
          ],
          'teams' => (object) [
            'visible' => NULL,
            'readOnly' => NULL
          ],
          'customerType' => (object) [
            'visible' => NULL,
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'DR' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ],
                    1 => (object) [
                      'type' => 'equals',
                      'attribute' => 'productBrandId',
                      'data' => (object) [
                        'field' => 'productBrand',
                        'values' => (object) [
                          'productBrandName' => 'Google'
                        ]
                      ],
                      'value' => '636d036e352aca8bc'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'cMassDiscount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ]
          ],
          'cSkuImporter' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ]
          ],
          'accountEmail' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'accountEmail'
                ]
              ]
            ]
          ],
          'country' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'country'
                ]
              ]
            ]
          ],
          'quotePageURL' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'billingContactID'
                ]
              ]
            ]
          ],
          'quoteApprovalDate' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'quoteOppId',
                  'data' => (object) [
                    'field' => 'quoteOpp'
                  ]
                ]
              ]
            ]
          ],
          'billingContactEmail' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'billingContactEmail'
                ]
              ]
            ]
          ],
          'cContactOpportunityGoogle' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ],
                1 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'discountRequest'
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ]
          ],
          'cCPartnumberimport' => (object) [
            'visible' => NULL
          ],
          'cQuoteReminder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'quoteStatus',
                  'value' => 'Presented'
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'cQuoteReminder'
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'solutionType' => NULL,
          'stage' => [
            0 => (object) [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Implementation',
                5 => 'Migration',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada',
                10 => 'In Review'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Implementation',
                5 => 'Migration',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada',
                10 => 'In Review'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud (Microsoft)',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Opportunity Technical Feasibility',
                5 => 'Opportunity Commercial Qualification',
                6 => 'Closed Won',
                7 => 'Closed Lost',
                8 => 'Stand-by',
                9 => 'Cancelada'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Argentina (Microsoft)',
                          'linkId' => '6217bac9e998125bd'
                        ]
                      ],
                      'value' => '6217bac9e998125bd'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Ecuador (Microsoft)',
                          'linkId' => '6217bc2db2c52349a'
                        ]
                      ],
                      'value' => '6217bc2db2c52349a'
                    ],
                    2 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Chile (Microsoft)',
                          'linkId' => '6217bc1cdf861cab6'
                        ]
                      ],
                      'value' => '6217bc1cdf861cab6'
                    ],
                    3 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Colombia (Microsoft)',
                          'linkId' => '6217bc253e84db65c'
                        ]
                      ],
                      'value' => '6217bc253e84db65c'
                    ],
                    4 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Peru (Microsoft)',
                          'linkId' => '6217bc3d5744311c2'
                        ]
                      ],
                      'value' => '6217bc3d5744311c2'
                    ]
                  ]
                ]
              ]
            ],
            3 => (object) [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Negotiation',
                4 => 'Closed Won',
                5 => 'Closed Lost',
                6 => 'Stand-by',
                7 => 'Cancelada'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Fortinet',
                      'linkId' => '62c2e5392de261577'
                    ]
                  ],
                  'value' => '62c2e5392de261577'
                ]
              ]
            ],
            4 => (object) [
              'optionList' => [
                0 => 'Prospecting',
                1 => 'Qualification',
                2 => 'Proposal',
                3 => 'Closed Won',
                4 => 'Closed Lost',
                5 => 'Stand-by',
                6 => 'Cancelada',
                7 => 'Negotiation'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google Partner Advantage',
                      'linkId' => '63e166ff7dab9d837'
                    ]
                  ],
                  'value' => '63e166ff7dab9d837'
                ]
              ]
            ]
          ],
          'lostReason' => [
            0 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Concorrente Tier 1',
                2 => 'Concorrente MOSP',
                3 => 'Concorrente (Outro Distribuidor)',
                4 => 'Concorrente EA',
                5 => 'Concorrente (Outro Fabricante)',
                6 => 'WO',
                7 => 'Cadastro Reprovado',
                8 => 'Crédito Reprovado',
                9 => 'Concorrente MPSA',
                10 => 'Concorrente ESD',
                11 => 'Prazo de Pagamento',
                12 => 'Cliente final desistiu da compra',
                13 => 'Fechado com outro Revendedor',
                14 => 'Sem retorno do Revendedor / Cliente final',
                15 => 'Contrato não efetivado (Stellr)',
                16 => 'Opp Duplicada'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Google Brasil',
                          'linkId' => '643418441fabd22dd'
                        ]
                      ],
                      'value' => '643418441fabd22dd'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Cloud Brasil',
                          'linkId' => '6320869fe404e348c'
                        ]
                      ],
                      'value' => '6320869fe404e348c'
                    ],
                    2 => (object) [
                      'type' => 'equals',
                      'attribute' => 'country',
                      'value' => 'Brasil'
                    ]
                  ]
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Otro proveedor',
                2 => 'Otro partner de Google',
                3 => 'Tiempo de vigencia de propuestaPrecio',
                4 => 'Más adelante',
                5 => 'Licitación perdida'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Google Brasil',
                      'linkId' => '643418441fabd22dd'
                    ]
                  ],
                  'value' => '643418441fabd22dd'
                ],
                2 => (object) [
                  'type' => 'notEquals',
                  'attribute' => 'country',
                  'value' => 'Brasil'
                ]
              ]
            ]
          ],
          'licenseType' => [
            0 => (object) [
              'optionList' => [
                0 => 'New Business',
                1 => 'Renewal',
                2 => 'Upgrade'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Google SOLA',
                          'linkId' => '643417ce3ea5ac5c4'
                        ]
                      ],
                      'value' => '643417ce3ea5ac5c4'
                    ],
                    1 => (object) [
                      'type' => 'contains',
                      'attribute' => 'teamsIds',
                      'data' => (object) [
                        'field' => 'teams',
                        'values' => (object) [
                          'linkName' => 'Google General',
                          'linkId' => '640f417f9bc453ac3'
                        ]
                      ],
                      'value' => '640f417f9bc453ac3'
                    ]
                  ]
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Azure',
                1 => 'M365',
                2 => 'Dynamics 365',
                3 => 'Software Subscription',
                4 => 'Software Perpetual',
                5 => 'CSP',
                6 => 'NCE',
                7 => 'Open Value',
                8 => 'SPLA',
                9 => 'ESA',
                10 => 'Marketplace',
                11 => 'Services'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Google Cloud Platform',
                1 => 'Google Workspace',
                2 => 'Commit - GCP',
                3 => 'Commit - WS',
                4 => 'Google Workspace Starter',
                5 => 'Google Workspace Business (1-300 Seats)',
                6 => 'Google Workspace Essentials',
                7 => 'Google Workspace Standard',
                8 => 'Google Workspace Plus',
                9 => 'Google Workspace AppSheet',
                10 => 'Cloud Identity',
                11 => 'Google Vault',
                12 => 'Google Voice',
                13 => 'Google Workspace Business',
                14 => 'Google Workspace Enterprise'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ],
            3 => (object) [
              'optionList' => [
                0 => 'Pay As You Go',
                1 => 'Marketplace'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'contains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'Cloud Brasil',
                      'linkId' => '6320869fe404e348c'
                    ]
                  ],
                  'value' => '6320869fe404e348c'
                ],
                1 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'AWS'
                    ]
                  ],
                  'value' => '61c0b27f1ac2732b5'
                ]
              ]
            ]
          ],
          'quoteStatus' => [
            0 => (object) [
              'optionList' => [
                0 => 'Draft',
                1 => 'Canceled',
                2 => 'Presented'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'quoteStatus',
                  'value' => [
                    0 => 'Draft'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Reviewed',
                1 => 'Canceled'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'quoteStatus',
                  'value' => 'In Review'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Canceled',
                1 => 'In Review',
                2 => 'Reviewed'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'quoteStatus',
                  'value' => 'Reviewed'
                ]
              ]
            ]
          ],
          'migrationOrigin' => [
            0 => (object) [
              'optionList' => [
                0 => '',
                1 => 'SSCloud (Jira)',
                2 => 'Stellr'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'AWS'
                    ]
                  ],
                  'value' => '61c0b27f1ac2732b5'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => '',
                1 => 'T1/DIST',
                2 => 'MOSP/EA',
                3 => 'Azure'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => '',
                1 => 'SSCloud (Jira)',
                2 => 'Stellr',
                3 => 'T1/DIST'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'productBrandId',
                  'data' => (object) [
                    'field' => 'productBrand',
                    'values' => (object) [
                      'productBrandName' => 'Google'
                    ]
                  ],
                  'value' => '636d036e352aca8bc'
                ]
              ]
            ]
          ]
        ],
        'panels' => []
      ],
      'color' => '#9fc77e',
      'iconClass' => 'fas fa-dollar-sign'
    ],
    'TargetList' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'optedOut',
            'label' => 'Opted Out',
            'view' => 'crm:views/target-list/record/panels/opted-out'
          ],
          1 => (object) [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'syncWithReports',
            'label' => 'Sync with Reports',
            'view' => 'advanced:views/target-list/record/panels/sync-with-reports',
            'notRefreshable' => true,
            'isForm' => true
          ]
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'crm:views/target-list/record/detail'
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'contacts'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'contacts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'leads' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'leads'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'leads'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'accounts' => (object) [
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'accounts'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'accounts'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'users' => (object) [
          'create' => false,
          'actionList' => [
            0 => (object) [
              'label' => 'Unlink All',
              'action' => 'unlinkAllRelated',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'users'
              ]
            ],
            1 => (object) [
              'label' => 'Populate from Report',
              'action' => 'populateFromReport',
              'acl' => 'edit',
              'data' => (object) [
                'link' => 'users'
              ]
            ]
          ],
          'rowActionsView' => 'crm:views/target-list/record/row-actions/default',
          'view' => 'advanced:views/target-list/record/panels/relationship',
          'removeDisabled' => true,
          'massSelect' => true
        ],
        'syncWithReports' => (object) [
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entryCount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'optedOutCount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-crosshairs',
      'formDependency' => (object) [
        'syncWithReportsEnabled' => (object) [
          'map' => (object) [
            'true' => [
              0 => (object) [
                'action' => 'show',
                'fields' => [
                  0 => 'syncWithReports',
                  1 => 'syncWithReportsUnlink'
                ]
              ]
            ]
          ],
          'default' => [
            0 => (object) [
              'action' => 'hide',
              'fields' => [
                0 => 'syncWithReports',
                1 => 'syncWithReportsUnlink'
              ]
            ]
          ]
        ]
      ]
    ],
    'Task' => (object) [
      'controller' => 'crm:controllers/task',
      'recordViews' => (object) [
        'list' => 'crm:views/task/record/list',
        'detail' => 'crm:views/task/record/detail'
      ],
      'views' => (object) [
        'list' => 'crm:views/task/list',
        'detail' => 'crm:views/task/detail'
      ],
      'modalViews' => (object) [
        'detail' => 'crm:views/task/modals/detail'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'crm:handlers/task/reminders-handler'
        ],
        'record/edit' => [
          0 => 'crm:handlers/task/reminders-handler'
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Complete',
              'name' => 'setCompletedMain',
              'iconHtml' => '<span class="fas fa-check fa-sm"></span>',
              'acl' => 'edit',
              'handler' => 'crm:handlers/task/menu',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'isCompleteAvailable'
            ]
          ]
        ]
      ],
      'modalDetailActionList' => [
        0 => (object) [
          'name' => 'complete',
          'label' => 'Complete',
          'acl' => 'edit',
          'handler' => 'crm:handlers/task/detail-actions',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'isCompleteAvailable'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'dateCompleted' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'cCompletionTime' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'todays'
        ],
        3 => (object) [
          'name' => 'overdue',
          'style' => 'danger'
        ],
        4 => (object) [
          'name' => 'deferred'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-tasks',
      'kanbanViewMode' => true,
      'eblaKanbanMultipleFields' => NULL,
      'color' => NULL
    ],
    'BpmnFlowNode' => (object) [
      'mergeDisabled' => true,
      'exportDisabled' => true,
      'massUpdateDisabled' => true,
      'massRemoveDisabled' => true
    ],
    'BpmnFlowchart' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-flowchart/record/detail',
        'edit' => 'advanced:views/bpmn-flowchart/record/edit'
      ],
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Processes',
              'link' => '#BpmnProcess',
              'acl' => 'read',
              'aclScope' => 'BpmnProcess'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'relationshipPanels' => (object) [
        'processes' => (object) [
          'create' => false,
          'select' => false,
          'unlinkDisabled' => true,
          'rowActionsView' => 'views/record/row-actions/view-only'
        ]
      ],
      'iconClass' => 'fas fa-project-diagram',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'targetType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'elements' => (object) [
        'eventStartConditional' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'triggerType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'afterRecordCreated',
                1 => 'afterRecordUpdated',
                2 => 'afterRecordSaved'
              ]
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'triggerType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'triggerType' => 'afterRecordCreated',
            'isInterrupting' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-conditional-edit'
        ],
        'eventStartTimer' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ],
            'targetReport' => (object) [
              'type' => 'link',
              'entity' => 'Report',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-report',
              'tooltip' => true
            ],
            'scheduling' => (object) [
              'type' => 'varchar',
              'maxLength' => 16,
              'tooltip' => true
            ],
            'schedulingApplyTimezone' => (object) [
              'type' => 'bool',
              'default' => false,
              'tooltip' => true
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'targetReport'
                  ],
                  1 => (object) [
                    'name' => 'scheduling'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => (object) [
                    'name' => 'schedulingApplyTimezone'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'isInterrupting' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL,
            'targetReportId' => NULL,
            'scheduling' => '0 0 * * *',
            'schedulingApplyTimezone' => false
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-timer-edit'
        ],
        'eventStartError' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartEscalation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartSignal' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'isInterrupting' => (object) [
              'type' => 'bool'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL,
            'isInterrupting' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'isInterrupting'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/event-start-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/event-start-signal-edit'
        ],
        'eventStart' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventStartCompensation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEnd' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndTerminate' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventEndError' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndEscalation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndSignal' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'activityId' => (object) [
              'type' => 'varchar',
              'maxLength' => 36,
              'trim' => true,
              'tooltip' => 'compensateActivityId'
            ]
          ],
          'defaults' => (object) [
            'activityId' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventEndCompensation' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'activityId' => (object) [
              'type' => 'varchar',
              'maxLength' => 36,
              'trim' => true,
              'tooltip' => 'compensateActivityId'
            ]
          ],
          'defaults' => (object) [
            'activityId' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text'
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'activityId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateMessageCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => (object) [
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'relatedTo' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationThrow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'escalationCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateCompensationBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateMessageBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => 'Email'
            ],
            'repliedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-replied-to'
            ],
            'relatedTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-related-to'
            ],
            'conditionsFormula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/message-conditions-formula'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false,
            'repliedTo' => NULL,
            'relatedTo' => NULL,
            'messageType' => 'Email'
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'repliedTo'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'relatedTo'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'conditionsFormula'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'relatedTo' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'repliedTo'
                    ]
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateSignalBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'signal' => (object) [
              'type' => 'varchar',
              'maxLength' => 200,
              'trim' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/signal'
            ]
          ],
          'defaults' => (object) [
            'signal' => NULL,
            'cancelActivity' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'signal'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateEscalationBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'escalationCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'escalationCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateErrorBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'errorCode' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'trim' => true
            ]
          ],
          'defaults' => (object) [
            'errorCode' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'errorCode'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateTimerBoundary' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'cancelActivity' => (object) [
              'type' => 'bool'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'defaults' => (object) [
            'cancelActivity' => false,
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'cancelActivity'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'eventIntermediateConditionalCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'conditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'label' => 'Conditions',
              'name' => 'conditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'conditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'eventIntermediateTimerCatch' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'timer' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/timer'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'timer',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'timerBase' => NULL,
            'timerShift' => 0,
            'timerShiftUnits' => 'minutes',
            'timerShiftOperator' => 'plus',
            'timerFormula' => NULL
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'gatewayExclusive' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'defaultFlowId' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayInclusive' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'defaultFlowId' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/default-flow-id'
            ],
            'flowsConditions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/flows-conditions'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'divergent',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'defaultFlowId'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'label' => 'Flows Conditions',
              'name' => 'flowsConditions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowsConditions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/gateway-exclusive-edit'
        ],
        'gatewayParallel' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ]
        ],
        'gatewayEventBased' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'task' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'actions' => (object) [
              'type' => 'base',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/actions',
              'actionTypeList' => [
                0 => 'createEntity',
                1 => 'createRelatedEntity',
                2 => 'updateEntity',
                3 => 'updateRelatedEntity',
                4 => 'updateCreatedEntity',
                5 => 'updateProcessEntity',
                6 => 'relateWithEntity',
                7 => 'unrelateFromEntity',
                8 => 'applyAssignmentRule',
                9 => 'createNotification',
                10 => 'makeFollowed',
                11 => 'triggerWorkflow',
                12 => 'runService',
                13 => 'sendRequest',
                14 => 'executeFormula'
              ]
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'label' => 'Actions',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'actions',
                    'fullWidth' => true,
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskScript' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'formula' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-script-formula'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'formula',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ],
        'taskUser' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'name' => (object) [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => 'userTaskName'
            ],
            'instructions' => (object) [
              'type' => 'text',
              'trim' => true,
              'tooltip' => 'userTaskInstructions'
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'actionType' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-action-type',
              'translation' => 'BpmnUserTask.options.actionType'
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-target',
              'tooltip' => true
            ],
            'assignmentType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'processAssignedUser',
                2 => 'specifiedUser',
                3 => 'rule:Round-Robin',
                4 => 'rule:Least-Busy'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-user-assignment-type'
            ],
            'targetUser' => (object) [
              'type' => 'link',
              'entity' => 'User'
            ],
            'targetTeam' => (object) [
              'type' => 'link',
              'entity' => 'Team'
            ],
            'targetUserPosition' => (object) [
              'type' => 'enum',
              'entity' => 'Report',
              'view' => 'advanced:views/workflow/fields/target-user-position'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'actionType'
                  ],
                  1 => (object) [
                    'name' => 'target'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'name'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'instructions'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'assignmentType'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'assignmentRule',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'targetUser'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'targetTeam'
                  ],
                  1 => (object) [
                    'name' => 'targetUserPosition'
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'defaults' => (object) [
            'actionType' => 'Approve',
            'assignmentType' => 'processAssignedUser',
            'instructions' => NULL,
            'name' => NULL,
            'targetTeamId' => NULL,
            'target' => ''
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-user-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-user-edit'
        ],
        'taskSendMessage' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'messageType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'Email'
              ]
            ],
            'from' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-from',
              'options' => [
                0 => 'system',
                1 => 'specifiedEmailAddress',
                2 => 'processAssignedUser'
              ]
            ],
            'to' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-to',
              'options' => [
                0 => 'processAssignedUser',
                1 => 'specifiedTeams',
                2 => 'specifiedUsers',
                3 => 'specifiedContacts',
                4 => 'specifiedEmailAddress'
              ]
            ],
            'replyTo' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'cc' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/task-send-message-reply-to',
              'options' => [
                0 => '',
                1 => 'system',
                2 => 'specifiedEmailAddress',
                3 => 'processAssignedUser'
              ]
            ],
            'fromEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'replyToEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'ccEmailAddress' => (object) [
              'type' => 'varchar',
              'tooltip' => 'taskSendMessageEmailAddress'
            ],
            'toSpecifiedTeams' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'Team'
            ],
            'toSpecifiedUsers' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'User'
            ],
            'toSpecifiedContacts' => (object) [
              'type' => 'linkMultiple',
              'entity' => 'Contact'
            ],
            'emailTemplate' => (object) [
              'type' => 'link',
              'entity' => 'EmailTemplate'
            ],
            'doNotStore' => (object) [
              'type' => 'bool'
            ],
            'optOutLink' => (object) [
              'type' => 'bool'
            ],
            'attachmentsVariable' => (object) [
              'type' => 'varchar',
              'maxLength' => 64,
              'noSpellCheck' => true
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'messageType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'from'
                  ],
                  1 => (object) [
                    'name' => 'fromEmailAddress'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'to'
                  ],
                  1 => (object) [
                    'name' => 'toEmailAddress'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'toSpecifiedTeams'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'toSpecifiedUsers'
                  ],
                  1 => false
                ],
                5 => [
                  0 => (object) [
                    'name' => 'toSpecifiedContacts'
                  ],
                  1 => false
                ],
                6 => [
                  0 => (object) [
                    'name' => 'cc'
                  ],
                  1 => (object) [
                    'name' => 'ccEmailAddress'
                  ]
                ],
                7 => [
                  0 => (object) [
                    'name' => 'replyTo'
                  ],
                  1 => (object) [
                    'name' => 'replyToEmailAddress'
                  ]
                ],
                8 => [
                  0 => (object) [
                    'name' => 'emailTemplate'
                  ],
                  1 => false
                ],
                9 => [
                  0 => (object) [
                    'name' => 'doNotStore'
                  ],
                  1 => (object) [
                    'name' => 'optOutLink'
                  ]
                ],
                10 => [
                  0 => (object) [
                    'name' => 'attachmentsVariable'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/task-send-message-edit',
          'defaults' => (object) [
            'doNotStore' => false,
            'from' => 'system',
            'to' => 'processAssignedUser',
            'replyTo' => NULL,
            'cc' => NULL,
            'messageType' => 'Email',
            'optOutLink' => false,
            'attachmentsVariable' => NULL
          ]
        ],
        'callActivity' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'callableType' => (object) [
              'type' => 'enum',
              'options' => [
                0 => 'Process'
              ],
              'required' => true
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-target',
              'tooltip' => true
            ],
            'targetIdExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnCollectionVariable' => (object) [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ]
            ],
            'isMultiInstance' => (object) [
              'type' => 'bool'
            ],
            'isSequential' => (object) [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchart' => (object) [
              'type' => 'link',
              'entity' => 'BpmnFlowchart',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/call-activity-flowchart'
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'callableType' => 'Process',
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'callableType'
                  ],
                  1 => false
                ],
                1 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => false
                ],
                2 => [
                  0 => (object) [
                    'name' => 'targetIdExpression'
                  ]
                ],
                3 => [
                  0 => (object) [
                    'name' => 'flowchart'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                5 => [
                  0 => (object) [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                6 => [
                  0 => (object) [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                7 => [
                  0 => (object) [
                    'name' => 'returnVariableList'
                  ],
                  1 => (object) [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'flowchart' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'returnVariableList' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'equals',
                      'attribute' => 'callableType',
                      'value' => 'Process'
                    ]
                  ]
                ]
              ],
              'loopCollectionExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/call-activity-edit'
        ],
        'subProcess' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => (object) [
              'type' => 'varchar'
            ],
            'targetIdExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/target-id-expression',
              'tooltip' => true
            ],
            'returnVariableList' => (object) [
              'type' => 'array',
              'noEmptyString' => true,
              'tooltip' => true
            ],
            'returnCollectionVariable' => (object) [
              'type' => 'varchar',
              'trim' => true,
              'tooltip' => true,
              'options' => [
                0 => 'resultCollection'
              ]
            ],
            'isExpanded' => (object) [
              'type' => 'bool'
            ],
            'triggeredByEvent' => (object) [
              'type' => 'bool'
            ],
            'isMultiInstance' => (object) [
              'type' => 'bool'
            ],
            'isSequential' => (object) [
              'type' => 'bool'
            ],
            'loopCollectionExpression' => (object) [
              'type' => 'formula',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/loop-collection-expression',
              'tooltip' => true
            ],
            'flowchartVisualization' => (object) [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => (object) [
              'type' => 'jsonArray'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'isExpanded' => true,
            'triggeredByEvent' => false,
            'loopCollectionExpression' => NULL,
            'dataList' => [],
            'target' => '',
            'returnVariableList' => [],
            'returnCollectionVariable' => NULL,
            'targetIdExpression' => NULL,
            'isMultiInstance' => false,
            'isSequential' => false
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => (object) [
                    'name' => 'targetType'
                  ]
                ],
                1 => [
                  0 => (object) [
                    'name' => 'targetIdExpression'
                  ]
                ],
                2 => [
                  0 => (object) [
                    'name' => 'isMultiInstance'
                  ],
                  1 => false
                ],
                3 => [
                  0 => (object) [
                    'name' => 'isSequential'
                  ],
                  1 => false
                ],
                4 => [
                  0 => (object) [
                    'name' => 'loopCollectionExpression'
                  ]
                ],
                5 => [
                  0 => (object) [
                    'name' => 'returnVariableList'
                  ],
                  1 => (object) [
                    'name' => 'returnCollectionVariable'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            4 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'id',
                    'options' => (object) [
                      'readOnly' => true
                    ]
                  ],
                  1 => false
                ]
              ]
            ]
          ],
          'dynamicLogic' => (object) [
            'fields' => (object) [
              'loopCollectionExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'returnCollectionVariable' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'isSequential' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isMultiInstance'
                    ]
                  ]
                ]
              ],
              'targetIdExpression' => (object) [
                'visible' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ],
                'required' => (object) [
                  'conditionGroup' => [
                    0 => (object) [
                      'type' => 'startsWith',
                      'attribute' => 'target',
                      'value' => 'record:'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'eventSubProcess' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'target' => (object) [
              'type' => 'enum',
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-target',
              'tooltip' => true
            ],
            'targetType' => (object) [
              'type' => 'varchar'
            ],
            'isExpanded' => (object) [
              'type' => 'bool'
            ],
            'triggeredByEvent' => (object) [
              'type' => 'bool'
            ],
            'flowchartVisualization' => (object) [
              'type' => 'base',
              'readOnly' => true,
              'view' => 'advanced:views/bpmn-flowchart-element/fields/sub-process-flowchart'
            ],
            'dataList' => (object) [
              'type' => 'jsonArray'
            ],
            'description' => (object) [
              'type' => 'text'
            ]
          ],
          'defaults' => (object) [
            'isExpanded' => true,
            'triggeredByEvent' => true,
            'dataList' => [],
            'target' => ''
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'target'
                  ],
                  1 => (object) [
                    'name' => 'targetType'
                  ]
                ]
              ]
            ],
            2 => (object) [
              'name' => 'flowchartVisualization',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'flowchartVisualization',
                    'noLabel' => true
                  ]
                ]
              ]
            ],
            3 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-detail',
          'recordEditView' => 'advanced:views/bpmn-flowchart-element/record/sub-process-edit'
        ],
        'flow' => (object) [
          'fields' => (object) [
            'text' => (object) [
              'type' => 'varchar',
              'trim' => true
            ],
            'description' => (object) [
              'type' => 'text'
            ],
            'startDirection' => (object) [
              'type' => 'enum',
              'options' => [
                0 => '',
                1 => 'r',
                2 => 'd',
                3 => 'l',
                4 => 'u'
              ],
              'view' => 'advanced:views/bpmn-flowchart-element/fields/start-direction'
            ]
          ],
          'layout' => [
            0 => (object) [
              'name' => 'text',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'text',
                    'fullWidth' => true
                  ]
                ]
              ]
            ],
            1 => (object) [
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'startDirection'
                  ],
                  1 => false
                ]
              ]
            ],
            2 => (object) [
              'name' => 'description',
              'rows' => [
                0 => [
                  0 => (object) [
                    'name' => 'description',
                    'fullWidth' => true
                  ]
                ]
              ]
            ]
          ],
          'recordDetailView' => 'advanced:views/bpmn-flowchart-element/record/detail'
        ]
      ]
    ],
    'BpmnProcess' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-process/record/detail',
        'edit' => 'advanced:views/bpmn-process/record/edit',
        'detailQuick' => 'advanced:views/bpmn-process/record/detail-quick',
        'editQuick' => 'advanced:views/bpmn-process/record/edit-quick',
        'list' => 'advanced:views/bpmn-process/record/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Flowcharts',
              'link' => '#BpmnFlowchart',
              'acl' => 'read',
              'aclScope' => 'BpmnFlowchart'
            ],
            1 => (object) [
              'label' => 'User Tasks',
              'link' => '#BpmnUserTask',
              'acl' => 'read',
              'aclScope' => 'BpmnUserTask'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'endedAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Ended'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'name' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parentProcess' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'parentProcessId',
                  'data' => (object) [
                    'field' => 'parentProcess'
                  ]
                ]
              ]
            ]
          ],
          'flowchartVisualization' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                1 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'notEquals',
                      'attribute' => 'status',
                      'value' => 'Created'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'targetType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'flowchart' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'target' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'targetType',
                      'data' => (object) [
                        'field' => 'targetType'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'flowNodes' => (object) [
          'rowActionsView' => 'advanced:views/bpmn-flow-node/record/row-actions/default',
          'recordListView' => 'advanced:views/bpmn-flow-node/record/list',
          'select' => false,
          'create' => false,
          'unlinkDisabled' => true,
          'view' => 'advanced:views/bpmn-process/record/panels/flow-nodes'
        ],
        'userTasks' => (object) [
          'rowActionsView' => 'views/record/row-actions/empty',
          'unlinkDisabled' => true,
          'select' => false,
          'create' => false
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => 'ended'
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cogs'
    ],
    'BpmnUserTask' => (object) [
      'controller' => 'controllers/record',
      'createDisabled' => true,
      'recordViews' => (object) [
        'detail' => 'advanced:views/bpmn-user-task/record/detail'
      ],
      'views' => (object) [
        'detail' => 'advanced:views/bpmn-user-task/detail'
      ],
      'dynamicLogic' => (object) [
        'options' => (object) [
          'resolution' => [
            0 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Approved',
                2 => 'Rejected'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Approve'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Reviewed'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Review'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => '',
                1 => 'Completed',
                2 => 'Failed'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'actionType',
                  'value' => 'Accomplish'
                ]
              ]
            ]
          ]
        ],
        'fields' => (object) [
          'resolution' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isResolved'
                    ],
                    1 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isCanceled'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'resolutionNote' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'resolution'
                ],
                1 => (object) [
                  'type' => 'isFalse',
                  'attribute' => 'isFailed'
                ]
              ]
            ]
          ],
          'instructions' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'instructions'
                ]
              ]
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'resolved',
          'style' => 'success'
        ],
        2 => (object) [
          'name' => 'canceled'
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-user-cog'
    ],
    'Report' => (object) [
      'controller' => 'advanced:controllers/report',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'boolFilters' => [
        0 => 'onlyMy'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report/record/list',
        'detail' => 'advanced:views/report/record/detail',
        'edit' => 'advanced:views/report/record/edit'
      ],
      'views' => (object) [
        'list' => 'advanced:views/report/list',
        'result' => 'advanced:views/report/result',
        'detail' => 'advanced:views/report/detail'
      ],
      'modalViews' => (object) [
        'select' => 'advanced:views/report/modals/select-records'
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ],
        'edit' => [
          0 => ':assignedUser',
          1 => 'teams',
          2 => 'portals'
        ]
      ],
      'createDisabled' => false,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Create Joint Grid Report',
              'link' => '#Report/create/type=JointGrid',
              'acl' => 'create'
            ],
            1 => (object) [
              'label' => 'Manage Categories',
              'link' => '#ReportCategory',
              'acl' => 'edit',
              'aclScope' => 'ReportCategory'
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'report',
            'label' => 'Report',
            'view' => 'advanced:views/report/record/panels/report'
          ]
        ]
      ],
      'filterList' => [
        0 => 'grid',
        1 => 'list'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'advanced:views/report/record/panels/email-sending',
            'options' => (object) [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'inlineEditDisabled' => true,
              'mode' => 'detail'
            ],
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'emailSending',
            'label' => 'EmailSending',
            'view' => 'views/record/panels/side',
            'options' => (object) [
              'fields' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'fieldList' => [
                0 => 'emailSendingInterval',
                1 => 'emailSendingSettingWeekdays',
                2 => 'emailSendingSettingDay',
                3 => 'emailSendingSettingMonth',
                4 => 'emailSendingTime',
                5 => 'emailSendingUsers',
                6 => 'emailSendingDoNotSendEmptyReport'
              ],
              'mode' => 'edit'
            ],
            'isForm' => true
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'applyAcl' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'type',
                  'value' => 'Grid'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-chart-bar'
    ],
    'ReportCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#ReportCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#ReportCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Reports',
              'link' => '#Report',
              'acl' => 'read',
              'aclScope' => 'Report',
              'style' => 'default'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'reports' => (object) [
          'create' => false
        ]
      ]
    ],
    'ReportFilter' => (object) [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-filter',
      'views' => (object) [
        'list' => 'advanced:views/report-filter/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report-filter/record/list',
        'edit' => 'advanced:views/report-filter/record/edit',
        'editSmall' => 'advanced:views/report-filter/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Rebuild Filters',
              'name' => 'rebuildFilters',
              'action' => 'rebuildFilters'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'report' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'ReportPanel' => (object) [
      'controller' => 'controllers/record',
      'dynamicHandler' => 'advanced:dynamic-handlers/report-panel',
      'views' => (object) [
        'list' => 'advanced:views/report-panel/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/report-panel/record/list',
        'edit' => 'advanced:views/report-panel/record/edit',
        'editSmall' => 'advanced:views/report-panel/record/edit-small'
      ],
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Rebuild Panels',
              'name' => 'rebuildPanels',
              'action' => 'rebuildPanels'
            ]
          ]
        ]
      ],
      'defaultSidePanelFieldLists' => (object) [
        'detail' => [],
        'edit' => [],
        'detailSmall' => [],
        'editSmall' => []
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'report' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'searchPanelDisabled' => true
    ],
    'Workflow' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'detail' => 'advanced:views/workflow/record/detail',
        'edit' => 'advanced:views/workflow/record/edit',
        'list' => 'advanced:views/workflow/record/list'
      ],
      'views' => (object) [
        'list' => 'advanced:views/workflow/list'
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Workflows Log',
              'link' => '#WorkflowLogRecord'
            ],
            1 => (object) [
              'label' => 'Manage Categories',
              'link' => '#WorkflowCategory',
              'acl' => 'edit',
              'aclScope' => 'WorkflowCategory'
            ]
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'entityType' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'type' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'signalName' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'signal'
                ]
              ]
            ]
          ],
          'manualLabel' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualTeams' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualDynamicLogic' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'entityType'
                ]
              ]
            ]
          ],
          'manualAccessRequired' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualElementType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmation' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ],
          'manualConfirmationText' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'manualConfirmation'
                ]
              ]
            ]
          ],
          'manualStyle' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ],
                1 => (object) [
                  'type' => 'in',
                  'attribute' => 'manualElementType',
                  'value' => 'Button'
                ]
              ]
            ]
          ],
          'schedulingApplyTimezone' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'scheduled'
                ]
              ]
            ]
          ],
          'processOrder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'afterRecordCreated',
                    1 => 'afterRecordUpdated',
                    2 => 'afterRecordSaved',
                    3 => 'scheduled',
                    4 => 'signal'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'manual' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => 'manual'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'WorkflowCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#WorkflowCategory/list',
              'acl' => 'read'
            ],
            1 => (object) [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#WorkflowCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Workflows',
              'labelTranslation' => 'Global.scopeNamesPlural.Workflow',
              'link' => '#Workflow',
              'acl' => 'read',
              'aclScope' => 'Workflow'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'workflows' => (object) [
          'create' => false
        ]
      ]
    ],
    'WorkflowLogRecord' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'advanced:views/workflow-log-record/list'
      ],
      'recordViews' => (object) [
        'list' => 'advanced:views/workflow-log-record/record/list'
      ]
    ],
    'DeliveryOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'DeliveryOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrderItem',
              'link' => '#DeliveryOrderItem',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'In Progress',
                            1 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ],
        'detailCreateFromSalesOrder' => (object) [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-shipping-fast'
    ],
    'DeliveryOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct',
          'selectOrderBy' => 'createdAt',
          'selectOrderDirection' => 'asc'
        ]
      ]
    ],
    'InventoryAdjustment' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'duplicateDisabled' => true,
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            1 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustmentItem',
              'link' => '#InventoryAdjustmentItem',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustmentItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isDone'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-plus-circle'
    ],
    'InventoryAdjustmentItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ],
        'listForProduct' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'selectLayout' => 'listForProduct',
          'createHandler' => 'sales:handlers/inventory-adjustment-item/create-inventory-number'
        ]
      ]
    ],
    'InventoryNumber' => (object) [
      'controller' => 'controllers/record',
      'mergeDisabled' => true,
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/inventory-number/setup-record-detail'
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'onHand'
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'viewHistory',
              'action' => 'viewHistory',
              'label' => 'View History',
              'data' => (object) [
                'handler' => 'sales:handlers/inventory-number/view-history-handler'
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/inventory-number/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'product' => (object) [
          'createDisabled' => true,
          'selectMandatoryAttributeList' => [
            0 => 'inventoryNumberType',
            1 => 'expirationDays'
          ],
          'selectHandler' => 'sales:handlers/inventory-number/select-product',
          'selectPrimaryFilterName' => 'available',
          'selectFieldHandler' => 'sales:handlers/inventory-number/select-field-product'
        ],
        'inventoryTransactions' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'createAttributeMap' => (object) [
            'productId' => 'productId',
            'productName' => 'productName'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listForProduct' => (object) [
          'type' => 'listSmall'
        ],
        'listForTemplateProduct' => (object) [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'dynamicLogic' => (object) [
        'panels' => (object) [
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'id',
                  'type' => 'isNotEmpty'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-barcode'
    ],
    'InventoryTransaction' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'relationshipPanels' => (object) [
        'product' => (object) [
          'selectPrimaryFilterName' => 'inventory',
          'createDisabled' => true
        ],
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/inventory-transaction/select-inventory-number'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'parent' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryNumber' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Transfer',
                    1 => 'Reserve'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'inlineEditDisabled' => true,
      'massUpdateDisabled' => true,
      'convertCurrencyDisabled' => true,
      'mergeDisabled' => true,
      'layoutMassUpdateDisabled' => true,
      'layoutBottomPanelsDetailDisabled' => true,
      'layoutSidePanelsDetailDisabled' => true,
      'layoutSidePanelsEditDisabled' => true,
      'layoutSidePanelsDetailSmallDisabled' => true,
      'layoutSidePanelsEditSmallDisabled' => true,
      'iconClass' => 'fas fa-retweet'
    ],
    'Invoice' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'paid',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/invoice/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Invoice',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => (object) [
          'name' => 'eInvoice',
          'label' => 'E-Invoice',
          'handler' => 'sales:handlers/invoice/e-invoice',
          'checkVisibilityFunction' => 'isAvailable',
          'actionFunction' => 'action',
          'groupIndex' => 6
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InvoiceItem',
              'link' => '#InvoiceItem',
              'acl' => 'read',
              'aclScope' => 'InvoiceItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'opportunityId',
                      'data' => (object) [
                        'field' => 'opportunity'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ],
                    2 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'salesOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'opportunity' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'salesOrderId',
                      'data' => (object) [
                        'field' => 'salesOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Confirmed',
                            1 => 'Paid'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-receipt'
    ],
    'InvoiceItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Invoices',
              'link' => '#Invoice',
              'acl' => 'read',
              'aclScope' => 'Invoice'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'OpportunityItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/opportunity-item',
      'createDisabled' => true,
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Opportunities',
              'link' => '#Opportunity',
              'acl' => 'read',
              'aclScope' => 'Opportunity'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'options' => (object) [
          'licenseType' => [
            0 => (object) [
              'optionList' => [
                0 => 'New Business',
                1 => 'Renewal',
                2 => 'Upgrade'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'Google'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Azure',
                1 => 'M365',
                2 => 'Services',
                3 => 'D365',
                4 => 'Power Platform',
                5 => 'O365/M365',
                6 => 'Software Perpetual',
                7 => 'Software Subscription',
                8 => 'Open Value Subscription',
                9 => 'OVS-ES',
                10 => 'School',
                11 => 'Open Value'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'Microsoft'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'AWS'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'AWS'
                ]
              ]
            ]
          ],
          'contractType' => [
            0 => (object) [
              'optionList' => [
                0 => 'CSP NCE',
                1 => 'Open Value',
                2 => 'SPLA',
                3 => '',
                4 => 'Professional Services'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'Microsoft'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Google Workspace'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brand',
                  'value' => 'Google'
                ]
              ]
            ]
          ],
          'solutionType' => NULL
        ],
        'fields' => (object) [
          'licenseType' => (object) [
            'visible' => NULL
          ],
          'amountDiscountItem' => (object) [
            'visible' => NULL
          ],
          'listPrice' => (object) [
            'visible' => NULL
          ],
          'cAdditionalDiscount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'licenseType',
                  'value' => [
                    0 => 'New Business',
                    1 => 'Renewal',
                    2 => 'Transfer'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'PriceBook' => (object) [
      'controller' => 'controllers/record',
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ProductPrice',
              'link' => '#ProductPrice',
              'acl' => 'read',
              'aclScope' => 'ProductPrice',
              'configCheck' => 'priceBooksEnabled'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'prices' => (object) [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'rules' => (object) [
          'layout' => 'listForPriceBook',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'mergeDisabled' => true,
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'PriceRule' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/price-rule',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'supplier' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'basedOn',
                  'value' => [
                    0 => 'Supplier'
                  ]
                ]
              ]
            ]
          ],
          'productCategory' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Product Category'
                  ]
                ]
              ]
            ]
          ],
          'conditionSelect' => (object) [
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'target',
                  'value' => [
                    0 => 'Conditional'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'mergeDisabled' => true
    ],
    'PriceRuleCondition' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'Product' => (object) [
      'controller' => 'controllers/record',
      'views' => (object) [
        'list' => 'sales:views/product/list'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/product/setup-record-detail'
        ]
      ],
      'modalViews' => (object) [
        'select' => 'views/modals/select-records-with-categories'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'viewPrice',
          'label' => 'View Price',
          'handler' => 'sales:handlers/product/view-price-action',
          'data' => (object) [
            'handler' => 'sales:handlers/product/view-price-action'
          ],
          'actionFunction' => 'process',
          'checkVisibilityFunction' => 'isVisible',
          'configCheck' => 'priceBooksEnabled'
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Categories',
              'link' => '#ProductCategory',
              'acl' => 'edit',
              'aclScope' => 'ProductCategory'
            ],
            1 => (object) [
              'label' => 'Brands',
              'link' => '#ProductBrand',
              'acl' => 'read',
              'aclScope' => 'ProductBrand'
            ],
            2 => (object) [
              'labelTranslation' => 'Product.links.attributes',
              'link' => '#ProductAttribute',
              'acl' => 'read',
              'aclScope' => 'ProductAttribute'
            ],
            3 => false,
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.PriceBook',
              'link' => '#PriceBook',
              'acl' => 'read',
              'aclScope' => 'PriceBook',
              'configCheck' => 'priceBooksEnabled'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            6 => false,
            7 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            8 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryNumber',
              'link' => '#InventoryNumber',
              'acl' => 'read',
              'aclScope' => 'InventoryNumber',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            9 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryAdjustment',
              'link' => '#InventoryAdjustment',
              'acl' => 'read',
              'aclScope' => 'InventoryAdjustment',
              'configCheck' => 'inventoryTransactionsEnabled'
            ],
            10 => false,
            11 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.InventoryTransaction',
              'link' => '#InventoryTransaction',
              'acl' => 'read',
              'aclScope' => 'InventoryTransaction',
              'configCheck' => 'inventoryTransactionsEnabled'
            ]
          ]
        ]
      ],
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Product'
        ]
      ],
      'filterList' => [
        0 => 'available'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'pricingFactor' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'pricingType',
                  'value' => [
                    0 => 'Discount from List',
                    1 => 'Markup over Cost',
                    2 => 'Profit Margin'
                  ]
                ]
              ]
            ]
          ],
          'unitPrice' => (object) [
            'readOnly' => NULL
          ],
          'inventoryNumberType' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'expirationDays' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'removalStrategy' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isInventory'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'inventoryNumberType'
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityReserved' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnHand' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantitySoftReserved' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityInTransit' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'quantityOnOrder' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'type' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'ciscoArchitecture' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brandId',
                  'data' => (object) [
                    'field' => 'brand',
                    'values' => (object) [
                      'brandName' => 'Cisco'
                    ]
                  ],
                  'value' => '61c0b2851be829762'
                ]
              ]
            ]
          ],
          'partNumber' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'brandId',
                  'data' => (object) [
                    'field' => 'brand',
                    'values' => (object) [
                      'brandName' => 'Microsoft'
                    ]
                  ],
                  'value' => '5f0b4703b1bafeb52'
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'inventoryNumbers' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryNumberType'
                ]
              ]
            ]
          ],
          'quantity' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ]
              ]
            ]
          ],
          'inventoryAdjustmentItems' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isInventory'
                ],
                1 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Template'
                  ]
                ]
              ]
            ]
          ]
        ],
        'options' => (object) [
          'type' => [
            0 => (object) [
              'optionList' => [
                0 => 'Regular',
                1 => 'Template'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'dynamicHandler' => 'sales:product-dynamic-handler',
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ],
          1 => (object) [
            'name' => 'orderItems',
            'label' => 'Orders',
            'view' => 'sales:views/product/record/panels/order-items',
            'recordListView' => 'sales:views/quote-item/record/list-union'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'warehousesQuantity',
            'label' => 'Warehouses',
            'view' => 'sales:views/product/record/panels/warehouses-quantity'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'prices' => (object) [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'createHandler' => 'sales:handlers/product/add-price',
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'supplierPrices' => (object) [
          'layout' => 'listForProduct',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ],
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryNumbers' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'onHand'
          ],
          'layout' => 'listForProduct',
          'view' => 'sales:views/product/record/panels/inventory-numbers',
          'createHandler' => 'sales:handlers/product/create-inventory-number'
        ],
        'variants' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listVariant',
          'view' => 'sales:views/product/record/panels/variants',
          'primaryFilter' => 'allVariants',
          'filterList' => [
            0 => 'allVariants',
            1 => 'availableVariants'
          ],
          'orderBy' => 'variantOrder'
        ],
        'inventoryAdjustmentItems' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'removeDisabled' => true,
          'primaryFilter' => 'completed',
          'layout' => 'listForProduct',
          'orderBy' => 'createdAt',
          'orderDirection' => 'desc'
        ]
      ],
      'iconClass' => 'fas fa-cube',
      'additionalLayouts' => (object) [
        'listForAdd' => (object) [
          'type' => 'listSmall'
        ],
        'listForAddInventory' => (object) [
          'type' => 'listSmall'
        ],
        'listForWarehouse' => (object) [
          'type' => 'listSmall'
        ],
        'listVariant' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'ProductAttribute' => (object) [
      'controller' => 'controllers/record',
      'recordViews' => (object) [
        'list' => 'sales:views/product-attribute/record/list'
      ],
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => (object) [
        'options' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'view' => 'sales:views/product-attribute/record/panels/options',
          'recordListView' => 'sales:views/product-attribute-option/record/list-for-attribute',
          'rowActionsView' => 'sales:views/product-attribute/record/row-actions/default',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForAttribute'
        ],
        'products' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'order' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductAttributeOption' => (object) [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'relationshipPanels' => (object) [
        'products' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ],
        'productVariants' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createDisabled' => true
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'order' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ProductBrand' => (object) [
      'controller' => 'controllers/record',
      'relationshipPanels' => (object) [
        'partnerAssessments' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'patchNotes' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cPatchNotes' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'ProductCategory' => (object) [
      'controller' => 'controllers/record-tree',
      'collection' => 'collections/tree',
      'menu' => (object) [
        'listTree' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'List View',
              'link' => '#ProductCategory/list',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ],
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Tree View',
              'link' => '#ProductCategory',
              'acl' => 'read',
              'style' => 'default'
            ],
            1 => (object) [
              'label' => 'Products',
              'link' => '#Product',
              'acl' => 'read',
              'aclScope' => 'Product',
              'style' => 'default'
            ]
          ]
        ]
      ]
    ],
    'ProductPrice' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/product-price',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'PriceBook'
        ]
      ]
    ],
    'PurchaseOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'PurchaseOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Supplier',
              'link' => '#Supplier',
              'acl' => 'read',
              'aclScope' => 'Supplier'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ],
            6 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.PurchaseOrderItem',
              'link' => '#PurchaseOrderItem',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Released',
                            1 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => (object) [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/purchase-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:purchase-order-calculation-handler',
      'iconClass' => 'fas fa-cart-plus fa-flip-horizontal'
    ],
    'PurchaseOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Purchase Orders',
              'link' => '#PurchaseOrder',
              'acl' => 'read',
              'aclScope' => 'PurchaseOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'Quote' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'approved',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'Quote',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.QuoteItem',
              'link' => '#QuoteItem',
              'acl' => 'read',
              'aclScope' => 'QuoteItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Approved'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => NULL
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Approved'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'version' => (object) [
            'visible' => NULL
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => (object) [
        'salesOrders' => (object) [
          'createAction' => 'createRelatedSalesOrder',
          'view' => 'sales:views/quote/record/panels/sales-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/quote/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ],
        'opportunity' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunityQuotes' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'opportunityQuoteReview' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'cOpportunityQuoteReview' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-file-invoice-dollar',
      'kanbanViewMode' => true,
      'color' => NULL
    ],
    'QuoteItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Quotes',
              'link' => '#Quote',
              'acl' => 'read',
              'aclScope' => 'Quote'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'cAdditionalDiscount' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'licenseType',
                  'value' => [
                    0 => 'New Business',
                    1 => 'Renewal',
                    2 => 'Transfer'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ReceiptOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'ReceiptOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ],
        2 => (object) [
          'handler' => 'sales:handlers/receipt-order/import-serial-numbers-button',
          'name' => 'importSerialNumbers',
          'label' => 'Import Serial Numbers',
          'acl' => 'edit',
          'checkVisibilityFunction' => 'isVisible'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ],
          1 => (object) [
            'name' => 'receivedItems',
            'label' => 'Received Inventory',
            'view' => 'sales:views/receipt-order/record/panels/received-items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrderItem',
              'link' => '#ReceiptOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'returnOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'id'
                    ],
                    1 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    2 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'supplierId',
                      'data' => (object) [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ],
                    1 => (object) [
                      'type' => 'isEmpty',
                      'attribute' => 'supplierId',
                      'data' => (object) [
                        'field' => 'supplier'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'supplier' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'purchaseOrderId',
                      'data' => (object) [
                        'field' => 'purchaseOrder'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => (object) [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'purchaseOrder' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ],
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isEmpty',
                  'attribute' => 'returnOrderId',
                  'data' => (object) [
                    'field' => 'returnOrder'
                  ]
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ],
                        2 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'receivedItemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Completed'
                  ]
                ],
                1 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ],
                2 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isDone'
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ],
        'detailCreateFromPurchaseOrder' => (object) [
          'type' => 'detail',
          'allFields' => true
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-truck-loading'
    ],
    'ReceiptOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReceiptOrder',
              'link' => '#ReceiptOrder',
              'acl' => 'read',
              'aclScope' => 'ReceiptOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ]
    ],
    'ReturnOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'ReturnOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createReceipt',
              'action' => 'createReceipt',
              'label' => 'Create Receipt',
              'acl' => 'create',
              'aclScope' => 'ReceiptOrder',
              'iconHtml' => '<span class="fas fa-dolly-flatbed"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/purchase-order/receipt-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrderItem',
              'link' => '#ReturnOrderItem',
              'acl' => 'read',
              'aclScope' => 'ReturnOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Released',
                            1 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'receiptOrders' => (object) [
          'createAction' => 'createRelatedReceiptOrder',
          'view' => 'sales:views/return-order/record/panels/receipt-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-arrow-alt-circle-left'
    ],
    'ReturnOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ReturnOrder',
              'link' => '#ReturnOrder',
              'acl' => 'read',
              'aclScope' => 'ReturnOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/return-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'SalesOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ],
        2 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0b06517450b14'
        ],
        3 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0e340882520f7'
        ],
        4 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0e6ceb98d29e4'
        ],
        5 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0eba732cf5106'
        ],
        6 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d0fd3e3ead8274'
        ],
        7 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d101ecb1f34383'
        ],
        8 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664d1038e67c31c3c'
        ],
        9 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664dfdebb84637a58'
        ],
        10 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter664e33d0e85544c6c'
        ],
        11 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter66831cbe23b6204fe'
        ],
        12 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter669153f230b85ba6a'
        ],
        13 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter66916dc409c1b86f7'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'SalesOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'createDelivery',
              'action' => 'createDelivery',
              'label' => 'Create Delivery',
              'acl' => 'create',
              'aclScope' => 'DeliveryOrder',
              'iconHtml' => '<span class="fas fa-shipping-fast"></span>',
              'data' => (object) [
                'handler' => 'sales:handlers/sales-order/delivery-button'
              ],
              'initFunction' => 'init'
            ]
          ]
        ],
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Template',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Tax',
              'link' => '#Tax',
              'acl' => 'read',
              'aclScope' => 'Tax'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.DeliveryOrder',
              'link' => '#DeliveryOrder',
              'acl' => 'read',
              'aclScope' => 'DeliveryOrder',
              'configCheck' => 'deliveryOrdersEnabled'
            ],
            5 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.SalesOrderItem',
              'link' => '#SalesOrderItem',
              'acl' => 'read',
              'aclScope' => 'SalesOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'dateInvoiced' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'status',
                  'value' => 'Completed'
                ]
              ]
            ]
          ],
          'account' => (object) [
            'readOnly' => NULL
          ],
          'opportunity' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'quoteId',
                      'data' => (object) [
                        'field' => 'quote'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'quote' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ],
          'isDeliveryCreated' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'contractEndDateDays' => (object) [
            'visible' => NULL
          ],
          'contractLastRenovation' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'contractLastRenovation'
                ]
              ]
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'relationshipPanels' => (object) [
        'invoices' => (object) [
          'createAction' => 'createRelatedInvoice',
          'view' => 'sales:views/sales-order/record/panels/invoices',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'deliveryOrders' => (object) [
          'createAction' => 'createRelatedDeliveryOrder',
          'view' => 'sales:views/sales-order/record/panels/delivery-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'returnOrders' => (object) [
          'createAction' => 'createRelatedReturnOrder',
          'view' => 'sales:views/sales-order/record/panels/return-orders',
          'layout' => 'listForAccount',
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ],
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ],
        'tax' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'rate'
          ]
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-clipboard-list',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'SalesOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Sales Orders',
              'link' => '#SalesOrder',
              'acl' => 'read',
              'aclScope' => 'SalesOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => NULL
    ],
    'ShippingProvider' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false
    ],
    'Supplier' => (object) [
      'controller' => 'controllers/record',
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.SupplierProductPrice',
              'link' => '#SupplierProductPrice',
              'acl' => 'read',
              'aclScope' => 'SupplierProductPrice'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'purchaseOrders' => (object) [
          'layout' => 'listForAccount',
          'unlinkDisabled' => true,
          'selectDisabled' => true
        ],
        'prices' => (object) [
          'layout' => 'listForSupplier',
          'unlinkDisabled' => true,
          'selectDisabled' => true,
          'filterList' => [
            0 => 'all',
            1 => 'active'
          ]
        ]
      ],
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ]
    ],
    'SupplierProductPrice' => (object) [
      'controller' => 'controllers/record',
      'filterList' => [
        0 => 'active'
      ],
      'textFilterDisabled' => true,
      'mergeDisabled' => true,
      'massActionList' => [
        0 => 'updatePrice'
      ],
      'checkAllResultMassActionList' => [
        0 => 'updatePrice'
      ],
      'massActionDefs' => (object) [
        'updatePrice' => (object) [
          'handler' => 'sales:handlers/product-price/mass-update-price',
          'initFunction' => 'init',
          'actionFunction' => 'process',
          'acl' => 'edit',
          'aclScope' => 'Supplier'
        ]
      ]
    ],
    'Tax' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => true
    ],
    'TransferOrder' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'filterList' => [
        0 => 'actual',
        1 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ]
      ],
      'recordViews' => (object) [
        'detail' => 'sales:views/quote/record/detail',
        'edit' => 'sales:views/quote/record/edit',
        'detailSmall' => 'sales:views/quote/record/detail-small',
        'editSmall' => 'sales:views/quote/record/edit-small'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ],
        'record/edit' => [
          0 => 'sales:handlers/quote/setup-record-detail'
        ]
      ],
      'massActionDefs' => (object) [
        'lock' => (object) [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionLock',
          'initFunction' => 'initLock'
        ],
        'unlock' => (object) [
          'aclScope' => 'TransferOrder',
          'acl' => 'edit',
          'handler' => 'sales:handlers/quote/lock-mass-action',
          'actionFunction' => 'actionUnlock',
          'initFunction' => 'initUnlock'
        ]
      ],
      'massActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'checkAllResultMassActionList' => [
        0 => 'lock',
        1 => 'unlock'
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'lock',
          'acl' => 'edit',
          'label' => 'Lock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeLocked',
          'actionFunction' => 'actionLock'
        ],
        1 => (object) [
          'name' => 'unlock',
          'acl' => 'edit',
          'label' => 'Unlock',
          'handler' => 'sales:handlers/quote/lock-action',
          'data' => (object) [
            'handler' => 'sales:handlers/quote/lock-action'
          ],
          'checkVisibilityFunction' => 'canBeUnlocked',
          'actionFunction' => 'actionUnlock'
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ],
        'edit' => [
          0 => (object) [
            'name' => 'items',
            'label' => 'Items',
            'view' => 'sales:views/quote/record/panels/items',
            'notRefreshable' => true,
            'sticked' => true,
            'isForm' => true
          ]
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Quote.labels.Templates',
              'link' => '#Template',
              'acl' => 'read',
              'aclScope' => 'Template'
            ],
            1 => false,
            2 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.ShippingProvider',
              'link' => '#ShippingProvider',
              'acl' => 'read',
              'aclScope' => 'ShippingProvider'
            ],
            3 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.Warehouse',
              'link' => '#Warehouse',
              'acl' => 'read',
              'aclScope' => 'Warehouse',
              'configCheck' => 'warehousesEnabled'
            ],
            4 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrderItem',
              'link' => '#TransferOrderItem',
              'acl' => 'read',
              'aclScope' => 'TransferOrderItem'
            ]
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'isLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isNotActual'
                ]
              ]
            ]
          ],
          'isHardLocked' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isHardLocked'
                ]
              ]
            ]
          ],
          'status' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isTrue',
                  'attribute' => 'isLocked'
                ]
              ]
            ]
          ],
          'itemList' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isTrue',
                      'attribute' => 'isLocked'
                    ],
                    1 => (object) [
                      'type' => 'and',
                      'value' => [
                        0 => (object) [
                          'type' => 'in',
                          'attribute' => 'status',
                          'value' => [
                            0 => 'Completed'
                          ]
                        ],
                        1 => (object) [
                          'type' => 'isNotEmpty',
                          'attribute' => 'id'
                        ],
                        2 => (object) [
                          'type' => 'isTrue',
                          'attribute' => 'isDone'
                        ]
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'number' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ],
          'inventoryStatus' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'inventoryStatus'
                ]
              ]
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForOrder'
        ]
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'list'
        ]
      ],
      'calculationHandler' => 'sales:quote-calculation-handler',
      'iconClass' => 'fas fa-dolly fa-flip-horizontal'
    ],
    'TransferOrderItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'sales:acl/quote-item',
      'views' => (object) [
        'list' => 'sales:views/quote-item/list'
      ],
      'recordViews' => (object) [
        'list' => 'sales:views/quote-item/record/list'
      ],
      'mergeDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'widthComplex',
            3 => 'width',
            4 => 'widthPx',
            5 => 'link',
            6 => 'view',
            7 => 'customLabel'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryNumber' => (object) [
          'selectHandler' => 'sales:handlers/delivery-order-item/select-inventory-number',
          'createDisabled' => true,
          'selectLayout' => 'listForProduct'
        ]
      ]
    ],
    'Warehouse' => (object) [
      'controller' => 'controllers/record',
      'searchPanelDisabled' => false,
      'filterList' => [
        0 => 'active'
      ],
      'selectDefaultFilters' => (object) [
        'filter' => 'active'
      ],
      'viewSetupHandlers' => (object) [
        'list' => [
          0 => 'sales:handlers/info'
        ],
        'record/detail' => [
          0 => 'sales:handlers/warehouse/setup-record-detail'
        ]
      ],
      'mergeDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'labelTranslation' => 'Global.scopeNamesPlural.TransferOrder',
              'link' => '#TransferOrder',
              'acl' => 'read',
              'aclScope' => 'TransferOrder'
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'products',
            'view' => 'sales:views/warehouse/record/panels/products'
          ],
          1 => (object) [
            'name' => 'inventoryNumbers',
            'view' => 'sales:views/warehouse/record/panels/inventory-numbers'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'inventoryTransactions' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true
        ]
      ],
      'iconClass' => 'fas fa-warehouse'
    ],
    'App' => (object) [
      'navbarView' => 'dubas-custom:views/site/navbar'
    ],
    'DashboardSet' => (object) [
      'controller' => 'controllers/record',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'iconClass' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Service' => (object) [
      'controller' => 'controllers/record',
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/opportunity/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ]
      ],
      'filterList' => [],
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'additionalLayouts' => (object) [
        'detailBottomTotal' => (object) [
          'type' => 'list',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'view',
            2 => 'customLabel'
          ]
        ],
        'listForAccount' => (object) [
          'type' => 'listSmall'
        ]
      ],
      'kanbanViewMode' => true,
      'color' => '#9fc77e',
      'iconClass' => 'fas fa-cube',
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'cancelReason' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'stage',
                  'value' => [
                    0 => 'Criação Indevida',
                    1 => 'Perdido / Cancelado'
                  ]
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'ServiceItem' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'dubas-custom:acl/service-item',
      'createDisabled' => true,
      'convertCurrencyDisabled' => true,
      'menu' => (object) [
        'list' => (object) [
          'buttons' => [
            0 => (object) [
              'label' => 'Services',
              'link' => '#Service',
              'acl' => 'read',
              'aclScope' => 'Service'
            ]
          ]
        ]
      ],
      'additionalLayouts' => (object) [
        'listItem' => (object) [
          'type' => 'listSmall',
          'dataAttributeList' => [
            0 => 'name',
            1 => 'align',
            2 => 'width',
            3 => 'link',
            4 => 'view',
            5 => 'customLabel'
          ]
        ]
      ]
    ],
    'Project' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project',
      'detailViewModeList' => [
        0 => 'detail',
        1 => 'plan',
        2 => 'board',
        3 => 'gantt'
      ],
      'detailViewModeIsStorable' => true,
      'detailActionList' => [
        0 => (object) [
          'name' => 'viewSettings',
          'acl' => 'edit',
          'label' => 'Settings',
          'groupIndex' => 8,
          'handler' => 'modules/project/handlers/project/detail-action',
          'actionFunction' => 'viewSettings'
        ],
        1 => (object) [
          'name' => 'cloneProject',
          'label' => 'Clone',
          'groupIndex' => 9,
          'handler' => 'modules/project/handlers/project/detail-action',
          'actionFunction' => 'clone',
          'checkVisibilityFunction' => 'hasClone'
        ]
      ],
      'mergeDisabled' => true,
      'duplicateDisabled' => true,
      'recordViews' => (object) [
        'plan' => 'modules/project/views/project/record/plan',
        'board' => 'modules/project/views/project/record/board',
        'gantt' => 'modules/project/views/project/record/gantt'
      ],
      'viewSetupHandlers' => (object) [
        'detail' => [
          0 => 'modules/project/handlers/project/detail'
        ]
      ],
      'menu' => (object) [
        'list' => (object) [
          'dropdown' => [
            0 => (object) [
              'label' => 'Boards',
              'link' => '#ProjectBoard',
              'aclScope' => 'ProjectBoard'
            ],
            1 => (object) [
              'label' => 'Roles',
              'link' => '#ProjectRole',
              'aclScope' => 'ProjectRole'
            ]
          ]
        ]
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ],
        'detailSmall' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ]
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'closed',
          'style' => 'success'
        ]
      ],
      'boolFilterList' => [
        0 => 'own',
        1 => 'member'
      ],
      'relationshipPanels' => (object) [
        'board' => (object) [
          'selectPrimaryFilterName' => 'actual'
        ],
        'activeGroup' => (object) [
          'createDisabled' => true,
          'selectHandler' => 'modules/project/handlers/project/relationships/select-active-group',
          'selectLayout' => 'listForSelect'
        ],
        'members' => (object) [
          'selectHandler' => 'modules/project/handlers/project/select-members',
          'selectDisabled' => true,
          'createDisabled' => true,
          'removeDisabled' => true,
          'editDisabled' => true,
          'actionList' => [
            0 => (object) [
              'name' => 'selectWithRole',
              'label' => 'Select',
              'handler' => 'modules/project/handlers/project/select-members-action',
              'actionFunction' => 'select',
              'acl' => 'edit'
            ]
          ],
          'rowActionList' => [
            0 => 'changeProjectRole'
          ],
          'layout' => 'listForProject',
          'orderBy' => 'projectRole'
        ],
        'tasks' => (object) [
          'createDisabled' => true,
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listSmallForProject',
          'filterList' => [
            0 => 'all',
            1 => 'actual',
            2 => 'completed',
            3 => 'actualParent',
            4 => 'completedParent'
          ]
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'activeGroup' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'id'
                ]
              ]
            ]
          ]
        ]
      ],
      'iconClass' => 'fas fa-list-alt',
      'color' => NULL,
      'kanbanViewMode' => false
    ],
    'ProjectBoard' => (object) [
      'controller' => 'controllers/record',
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ]
      ],
      'relationshipPanels' => (object) [
        'columns' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'layout' => 'listForBoard',
          'rowActionList' => [
            0 => 'moveUp',
            1 => 'moveDown'
          ]
        ]
      ]
    ],
    'ProjectColumn' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project-column',
      'createDisabled' => true,
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'rowActionDefs' => (object) [
        'moveUp' => (object) [
          'label' => 'Move Up',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-column/row-actions/move-up'
        ],
        'moveDown' => (object) [
          'label' => 'Move Down',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-column/row-actions/move-down'
        ]
      ]
    ],
    'ProjectGroup' => (object) [
      'controller' => 'controllers/record',
      'acl' => 'modules/project/acl/project-group',
      'createDisabled' => true,
      'massRemoveDisabled' => true,
      'massUpdateDisabled' => true,
      'mergeDisabled' => true
    ],
    'ProjectRole' => (object) [
      'controller' => 'controllers/record',
      'massUpdateDisabled' => true,
      'mergeDisabled' => true,
      'massRemoveDisabled' => true,
      'viewSetupHandlers' => (object) [
        'record/edit' => [
          0 => 'modules/project/handlers/project-role/setup-record-edit'
        ]
      ]
    ],
    'ProjectTask' => (object) [
      'controller' => 'controllers/record',
      'modelDefaultsPreparator' => 'modules/project/handlers/project-task/defaults-preparator',
      'acl' => 'modules/project/acl/project-task',
      'mergeDisabled' => true,
      'viewSetupHandlers' => (object) [
        'record/list' => [
          0 => 'modules/project/handlers/project-task/record-list'
        ],
        'record/detail' => [
          0 => 'modules/project/handlers/project-task/record'
        ],
        'record/edit' => [
          0 => 'modules/project/handlers/project-task/record'
        ]
      ],
      'filterList' => [
        0 => (object) [
          'name' => 'actual'
        ],
        1 => (object) [
          'name' => 'actualParent'
        ],
        2 => (object) [
          'name' => 'completed',
          'style' => 'success'
        ],
        3 => (object) [
          'name' => 'completedParent',
          'style' => 'success'
        ],
        4 => (object) [
          'name' => 'todays'
        ],
        5 => (object) [
          'name' => 'overdue',
          'style' => 'danger'
        ]
      ],
      'additionalLayouts' => (object) [
        'listForProject' => (object) [
          'type' => 'list'
        ],
        'listForTask' => (object) [
          'type' => 'list'
        ],
        'listSmallForProject' => (object) [
          'type' => 'list'
        ],
        'kanbanForProject' => (object) [
          'type' => 'kanban'
        ]
      ],
      'detailActionList' => [
        0 => (object) [
          'name' => 'setCompleted',
          'label' => 'Complete',
          'groupIndex' => 1,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'hasComplete'
        ],
        1 => (object) [
          'name' => 'setCanceled',
          'label' => 'Cancel',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'cancel',
          'checkVisibilityFunction' => 'hasCancel'
        ],
        2 => (object) [
          'name' => 'changeColumn',
          'label' => 'Change Column',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'changeColumn',
          'checkVisibilityFunction' => 'hasChangeColumn'
        ],
        3 => (object) [
          'name' => 'selfAssign',
          'label' => 'Self-Assign',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'selfAssign',
          'checkVisibilityFunction' => 'hasSelfAssign'
        ]
      ],
      'modalDetailActionList' => [
        0 => (object) [
          'name' => 'setCompleted',
          'label' => 'Complete',
          'groupIndex' => 1,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'complete',
          'checkVisibilityFunction' => 'hasComplete'
        ],
        1 => (object) [
          'name' => 'setCanceled',
          'label' => 'Cancel',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'cancel',
          'checkVisibilityFunction' => 'hasCancel'
        ],
        2 => (object) [
          'name' => 'changeColumn',
          'label' => 'Change Column',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'changeColumn',
          'checkVisibilityFunction' => 'hasChangeColumn'
        ],
        3 => (object) [
          'name' => 'selfAssign',
          'label' => 'Self-Assign',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/record-action',
          'actionFunction' => 'selfAssign',
          'checkVisibilityFunction' => 'hasSelfAssign'
        ],
        4 => (object) [
          'name' => 'remove',
          'label' => 'Remove',
          'groupIndex' => 3,
          'acl' => 'delete'
        ]
      ],
      'rowActionList' => [
        0 => 'complete'
      ],
      'rowActionDefs' => (object) [
        'complete' => (object) [
          'labelTranslation' => 'ProjectTask.actions.complete',
          'groupIndex' => 2,
          'handler' => 'modules/project/handlers/project-task/row-action-complete'
        ],
        'changeColumn' => (object) [
          'labelTranslation' => 'ProjectTask.actions.changeColumn',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-task/row-action-change-column'
        ],
        'selfAssign' => (object) [
          'label' => 'Self-Assign',
          'groupIndex' => 3,
          'handler' => 'modules/project/handlers/project-task/row-action-self-assign'
        ],
        'moveToTop' => (object) [
          'labelTranslation' => 'ProjectTask.actions.moveToTop',
          'acl' => 'edit',
          'groupIndex' => 4,
          'handler' => 'modules/project/handlers/project-task/row-action-move'
        ],
        'moveToBottom' => (object) [
          'labelTranslation' => 'ProjectTask.actions.moveToBottom',
          'acl' => 'edit',
          'groupIndex' => 4,
          'handler' => 'modules/project/handlers/project-task/row-action-move'
        ]
      ],
      'massActionList' => [
        0 => 'complete'
      ],
      'massActionDefs' => (object) [
        'complete' => (object) [
          'acl' => 'edit',
          'handler' => 'modules/project/handlers/project-task/mass-action',
          'actionFunction' => 'complete',
          'groupIndex' => 1
        ]
      ],
      'menu' => (object) [
        'detail' => (object) [
          'buttons' => [
            0 => (object) [
              'name' => 'setCompleted',
              'label' => 'Complete',
              'iconClass' => 'fas fa-check fa-sm',
              'handler' => 'modules/project/handlers/project-task/record-action',
              'actionFunction' => 'complete',
              'checkVisibilityFunction' => 'hasComplete'
            ]
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'project' => (object) [
          'selectMandatoryAttributeList' => [
            0 => 'boardId',
            1 => 'firstColumnId'
          ],
          'selectFieldHandler' => 'modules/project/handlers/project-task/select-project'
        ],
        'group' => (object) [
          'selectHandler' => 'modules/project/handlers/project-task/select-group',
          'selectLayout' => 'listForSelect'
        ],
        'parentTask' => (object) [
          'createDisabled' => true
        ],
        'subTasks' => (object) [
          'selectDisabled' => true,
          'unlinkDisabled' => true,
          'createRequiredAccess' => 'edit',
          'createAttributeMap' => (object) [
            'projectId' => 'projectId',
            'projectName' => 'projectName'
          ],
          'rowActionList' => [
            0 => 'complete',
            1 => 'changeColumn',
            2 => 'selfAssign'
          ],
          'createHandler' => 'modules/project/handlers/project-task/create-sub-task',
          'orderBy' => 'order',
          'orderDirection' => 'asc',
          'layout' => 'listForTask',
          'filterList' => [
            0 => 'all',
            1 => 'actual'
          ]
        ],
        'fromTasks' => (object) [
          'createDisabled' => true,
          'selectHandler' => 'modules/project/handlers/project-task/select-from-tasks',
          'selectPrimaryFilterName' => 'actual',
          'selectOrderBy' => 'combinedOrder',
          'selectOrderDirection' => 'asc'
        ],
        'owner' => (object) [
          'selectHandler' => 'modules/project/handlers/project-task/select-owner'
        ],
        'assignedUser' => (object) [
          'selectHandler' => 'modules/project/handlers/project-task/select-owner'
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'parentTask' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'attribute' => 'parentTaskId',
                      'type' => 'isNotEmpty',
                      'data' => (object) [
                        'field' => 'parentTask'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'group' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'and',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'projectId',
                      'data' => (object) [
                        'field' => 'project'
                      ]
                    ]
                  ]
                ]
              ]
            ],
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'or',
                  'value' => [
                    0 => (object) [
                      'type' => 'isNotEmpty',
                      'attribute' => 'parentTaskId',
                      'data' => (object) [
                        'field' => 'parentTask'
                      ]
                    ]
                  ]
                ]
              ]
            ]
          ],
          'column' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'projectId',
                  'data' => (object) [
                    'field' => 'project'
                  ]
                ]
              ]
            ]
          ],
          'hours' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'points' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'priority' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notIn',
                  'attribute' => 'type',
                  'value' => [
                    0 => 'Milestone'
                  ]
                ]
              ]
            ]
          ],
          'completedAt' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'in',
                  'attribute' => 'status',
                  'value' => [
                    0 => 'Completed'
                  ]
                ]
              ]
            ]
          ]
        ],
        'panels' => (object) [
          'subTasks' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'attribute' => 'parentTaskId',
                  'type' => 'isEmpty',
                  'data' => (object) [
                    'field' => 'parentTask'
                  ]
                ]
              ]
            ]
          ]
        ]
      ],
      'boolFilterList' => [
        0 => 'onlyMy',
        1 => 'own'
      ],
      'iconClass' => 'fas fa-check-double',
      'color' => NULL,
      'kanbanViewMode' => false
    ],
    'AWS' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => (object) [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-cloud',
      'color' => '#ff9a00',
      'dynamicLogic' => (object) [
        'options' => (object) [
          'tier' => NULL,
          'levelCheck' => [
            0 => (object) [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheck',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ],
          'levelCheckThinkBig' => [
            0 => (object) [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccessThinkBig' => [
            0 => (object) [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccessThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckExperience' => [
            0 => (object) [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Ready to Premium'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperience',
                  'value' => 'Ready to Premium'
                ]
              ]
            ]
          ],
          'levelCheckExperienceThinkBig' => [
            0 => (object) [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperienceThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckExperienceThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckKnowledge' => [
            0 => (object) [
              'optionList' => [
                0 => 'Ready to Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            2 => (object) [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledge',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ],
          'levelCheckKnowledgeThinkBig' => [
            0 => (object) [
              'optionList' => [
                0 => 'Think Big for Select'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledgeThinkBig',
                  'value' => 'Think Big for Select'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Think Big for Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckKnowledgeThinkBig',
                  'value' => 'Think Big for Advanced'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccess' => [
            0 => (object) [
              'optionList' => [
                0 => 'Ready to Advanced'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccess',
                  'value' => 'Ready to Advanced'
                ]
              ]
            ],
            1 => (object) [
              'optionList' => [
                0 => 'Ready to Premier'
              ],
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'has',
                  'attribute' => 'levelCheckCustomerSuccess',
                  'value' => 'Ready to Premier'
                ]
              ]
            ]
          ]
        ],
        'fields' => (object) [
          'aWSTechnicalCertifiedIndividualsAssociate' => (object) [
            'visible' => NULL
          ],
          'aWSTechnicalCertifiedIndividualsProOrSpecialty' => (object) [
            'visible' => NULL
          ],
          'countCompetency' => (object) [
            'visible' => NULL
          ],
          'levelCheckCustomerSuccessThinkBig' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckCustomerSuccessThinkBig'
                ]
              ]
            ]
          ],
          'levelCheck' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheck'
                ]
              ]
            ]
          ],
          'levelCheckCustomerSuccess' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckCustomerSuccess'
                ]
              ]
            ]
          ],
          'levelCheckExperience' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckExperience'
                ]
              ]
            ]
          ],
          'levelCheckExperienceThinkBig' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckExperienceThinkBig'
                ]
              ]
            ]
          ],
          'levelCheckKnowledge' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckKnowledge'
                ]
              ]
            ]
          ],
          'levelCheckKnowledgeThinkBig' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckKnowledgeThinkBig'
                ]
              ]
            ]
          ],
          'levelCheckThinkBig' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'levelCheckThinkBig'
                ]
              ]
            ]
          ],
          'specialities' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'specialities'
                ]
              ]
            ]
          ],
          'competency' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'isNotEmpty',
                  'attribute' => 'competency'
                ]
              ]
            ]
          ]
        ]
      ],
      'bottomPanels' => (object) [
        'detail' => [
          0 => (object) [
            'isReportPanel' => true,
            'name' => 'reportPanel6679c7a81d16a904c',
            'label' => 'Cuentas - AWS',
            'view' => 'advanced:views/report-panel/record/panels/report-panel-bottom',
            'reportPanelId' => '6679c7a81d16a904c',
            'reportType' => 'List',
            'reportEntityType' => 'Account',
            'displayType' => 'List',
            'displayTotal' => false,
            'displayOnlyTotal' => false,
            'useSiMultiplier' => true,
            'accessDataList' => [
              0 => (object) [
                'scope' => 'Account'
              ]
            ],
            'order' => 7
          ]
        ]
      ],
      'kanbanViewMode' => false
    ],
    'AWSVersions' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-align-left'
    ],
    'AccountVBM' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-caret-square-right'
    ],
    'Analytics' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-pie',
      'views' => (object) [
        'detail' => 'custom:views/Analytics/detail'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'teams' => (object) [
            'visible' => NULL
          ]
        ]
      ]
    ],
    'AssesmentCompany' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => (object) [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ]
    ],
    'BillingVendor' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'BucketTimer' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'CAccountEndCustomer' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => (object) [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'relationshipPanels' => (object) [
        'contacts' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ]
    ],
    'CPB' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-clipboard-list',
      'kanbanViewMode' => false,
      'color' => '#08bed5'
    ],
    'CPartnerAssessment' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'sidePanels' => (object) [
        'detail' => [
          0 => (object) [
            'name' => 'activities',
            'label' => 'Activities',
            'view' => 'crm:views/record/panels/activities',
            'aclScope' => 'Activities'
          ],
          1 => (object) [
            'name' => 'history',
            'label' => 'History',
            'view' => 'crm:views/record/panels/history',
            'aclScope' => 'Activities'
          ],
          2 => (object) [
            'name' => 'tasks',
            'label' => 'Tasks',
            'view' => 'crm:views/record/panels/tasks',
            'aclScope' => 'Task'
          ]
        ]
      ],
      'iconClass' => 'fas fa-align-justify',
      'relationshipPanels' => (object) [
        'account' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ],
        'productBrand' => (object) [
          'layout' => NULL,
          'selectPrimaryFilterName' => NULL
        ]
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'gtmAssessment' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ],
          'commercialTechnicalAssessment' => (object) [
            'readOnly' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'notContains',
                  'attribute' => 'teamsIds',
                  'data' => (object) [
                    'field' => 'teams',
                    'values' => (object) [
                      'linkName' => 'eNUBE',
                      'linkId' => '614487be03abac1db'
                    ]
                  ],
                  'value' => '614487be03abac1db'
                ]
              ]
            ]
          ]
        ]
      ]
    ],
    'Cisco' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-bars'
    ],
    'CiscoDMP' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-tasks'
    ],
    'Citrix' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'dynamicLogic' => (object) [
        'fields' => (object) [
          'product' => (object) [
            'visible' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'project',
                  'value' => 'Social Selling'
                ]
              ]
            ],
            'required' => (object) [
              'conditionGroup' => [
                0 => (object) [
                  'type' => 'equals',
                  'attribute' => 'project',
                  'value' => 'Social Selling'
                ]
              ]
            ]
          ]
        ]
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-angle-right'
    ],
    'CloudConsumption' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-cloud-upload-alt',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Contract' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'kanbanViewMode' => false,
      'color' => NULL,
      'iconClass' => 'fas fa-file-invoice',
      'filterList' => [
        0 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eac9c5a60065c',
          'accessDataList' => [
            0 => (object) [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        1 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter6686ead1b861b28d9',
          'accessDataList' => [
            0 => (object) [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        2 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eae14885b6a3a',
          'accessDataList' => [
            0 => (object) [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ],
        3 => (object) [
          'isReportFilter' => true,
          'name' => 'reportFilter6686eae8f245d4139',
          'accessDataList' => [
            0 => (object) [
              'teamIdList' => [
                0 => '614487be03abac1db'
              ]
            ]
          ]
        ]
      ]
    ],
    'ContractGoals' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-crosshairs',
      'kanbanViewMode' => false,
      'color' => NULL
    ],
    'Country' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'DSET' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ]
    ],
    'DashboardAccess' => (object) [
      'controller' => 'controllers/record',
      'boolFilterList' => [
        0 => 'onlyMy'
      ],
      'iconClass' => 'fas fa-chart-pie'
    ],
    'DashboardSet1' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'General',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d609509',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d293187',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d846599',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d939205',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d42111',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d173351',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d149911',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d830024',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d651660',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d874496',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d640160',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d452535',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d456188',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d280034',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d355040',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d28428',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d693074',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d942136',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet1__d452916',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 2,
              'height' => 2
            ],
            19 => (object) [
              'id' => 'DashboardSet1__d417414',
              'name' => 'Report',
              'x' => 2,
              'y' => 11,
              'width' => 2,
              'height' => 2
            ],
            20 => (object) [
              'id' => 'DashboardSet1__d526076',
              'name' => 'Report',
              'x' => 0,
              'y' => 13,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '3338749'
        ],
        1 => (object) [
          'name' => 'COL',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d862743',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d339093',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d697124',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d300459',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d554084',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d430105',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d772360',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d38631',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d599815',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d618387',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d79088',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d67037',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d357517',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d402339',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d154618',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d671406',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d482280',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d29798',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '4882459'
        ],
        2 => (object) [
          'name' => 'CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d278529',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d920497',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d846560',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d425806',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d288206',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d802184',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d409685',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d114486',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d177953',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d678655',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d298970',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d389733',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d579436',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d383388',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d282205',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d627986',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d10339',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d845218',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '1213852'
        ],
        3 => (object) [
          'name' => 'ARG',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d263621',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d531687',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d573720',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d210984',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d752429',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d391377',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d153424',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d798695',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d556849',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d467957',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d318042',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d435896',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d463429',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d944769',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d398354',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d862494',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 4
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d788624',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d688865',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '6101018'
        ],
        4 => (object) [
          'name' => 'ECU',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d264550',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d341949',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d131487',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d889061',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d677661',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d84116',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d575220',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d547943',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d160838',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d694230',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d802556',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d890576',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d73145',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d584072',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d142611',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d410719',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d165231',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d373947',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '5265890'
        ],
        5 => (object) [
          'name' => 'CHI',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d468474',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d658024',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d604276',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d680599',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d962067',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d343475',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d33273',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d320146',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d997705',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d785734',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d258384',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d757953',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d204793',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d491211',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d12153',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d148662',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d955473',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d318087',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '1916586'
        ],
        6 => (object) [
          'name' => 'PER',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d904397',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d101882',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d456556',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d967189',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d816185',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d611563',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d110788',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d947082',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d775990',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d174667',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d625424',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d144679',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d494724',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d248244',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d920892',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d363241',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d437362',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d204575',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '5966908'
        ],
        7 => (object) [
          'name' => 'BRA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d528697',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d573882',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d550727',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d8446',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d112701',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d135929',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d994686',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d295691',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d193311',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d891367',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d563436',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d548132',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d417304',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d167832',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d122112',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d706508',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d493933',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d848261',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ]
          ],
          'id' => '9540893'
        ],
        8 => (object) [
          'name' => 'MEX',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet1__d166246',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet1__d379283',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet1__d535825',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet1__d210451',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet1__d386768',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet1__d879754',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet1__d483229',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet1__d574123',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet1__d59022',
              'name' => 'Report',
              'x' => 2,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet1__d391783',
              'name' => 'Report',
              'x' => 3,
              'y' => 3,
              'width' => 1,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet1__d607904',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet1__d176462',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet1__d14803',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet1__d52429',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet1__d582326',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet1__d734813',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 2,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet1__d981966',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            17 => (object) [
              'id' => 'DashboardSet1__d482005',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ]
          ],
          'id' => '5180238'
        ]
      ]
    ],
    'DashboardSet10' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Cloud Practice Builder',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet10__d828667',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet10__d643186',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 1,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet10__d956113',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 4,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet10__d409248',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet10__d377624',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet10__d425593',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet10__d274388',
              'name' => 'Report',
              'x' => 2,
              'y' => 7,
              'width' => 2,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet10__d187010',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet10__d944443',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 9,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet10__d800214',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ]
          ],
          'id' => '3490098'
        ]
      ]
    ],
    'DashboardSet11' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Cloud Practice Builder',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet11__d828667',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet11__d643186',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet11__d956113',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet11__d409248',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet11__d377624',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet11__d425593',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet11__d274388',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet11__d187010',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet11__d944443',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 8,
              'width' => 3.3333333333333335,
              'height' => 2
            ]
          ],
          'id' => '3490098'
        ],
        1 => (object) [
          'name' => 'Assessment',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet11__d770267',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '4241873'
        ]
      ]
    ],
    'DashboardSet12' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Cloud Practice Builder',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet12__d828667',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet12__d643186',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet12__d956113',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet12__d409248',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet12__d377624',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet12__d425593',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet12__d274388',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet12__d187010',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet12__d944443',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 8,
              'width' => 3.3333333333333335,
              'height' => 2
            ]
          ],
          'id' => '3490098'
        ],
        1 => (object) [
          'name' => 'Assesment',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet12__d53152',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '4325143'
        ]
      ]
    ],
    'DashboardSet13' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Oportunidades ',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet13__d536975',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => (object) [
              'id' => 'DashboardSet13__d429999',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => (object) [
              'id' => 'DashboardSet13__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => (object) [
              'id' => 'DashboardSet13__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => (object) [
              'id' => 'DashboardSet13__d902640',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => (object) [
              'id' => 'DashboardSet13__d28811',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => (object) [
              'id' => 'DashboardSet13__d843929',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => (object) [
              'id' => 'DashboardSet13__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 3,
              'height' => '2'
            ],
            8 => (object) [
              'id' => 'DashboardSet13__d905801',
              'name' => 'Report',
              'x' => 3,
              'y' => '2',
              'width' => 1,
              'height' => '2'
            ],
            9 => (object) [
              'id' => 'DashboardSet13__d257209',
              'name' => 'Report',
              'x' => 0,
              'y' => '4',
              'width' => 3,
              'height' => '2'
            ],
            10 => (object) [
              'id' => 'DashboardSet13__d983820',
              'name' => 'Report',
              'x' => 3,
              'y' => '4',
              'width' => 1,
              'height' => '2'
            ],
            11 => (object) [
              'id' => 'DashboardSet13__d808264',
              'name' => 'Report',
              'x' => 0,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            12 => (object) [
              'id' => 'DashboardSet13__d856827',
              'name' => 'Report',
              'x' => 2,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '5152227'
        ],
        1 => (object) [
          'name' => 'Oportunidades Nuevas ',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet13__d706527',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet13__d2564',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet13__d530584',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 3,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet13__d89847',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet13__d104922',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 3,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet13__d662183',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 1,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet13__d202036',
              'name' => 'Report',
              'x' => 1,
              'y' => 5,
              'width' => 3,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet13__d971712',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet13__d980843',
              'name' => 'Report',
              'x' => 1,
              'y' => 7,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '7747188'
        ],
        2 => (object) [
          'name' => 'Partner Program X Opps ',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet13__d246985',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '4371976'
        ]
      ]
    ],
    'DashboardSet14' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Canales',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet14__d188367',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet14__d240377',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet14__d837203',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet14__d845131',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet14__d464894',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet14__d630874',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet14__d638983',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 3
            ],
            7 => (object) [
              'id' => 'DashboardSet14__d903216',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet14__d776187',
              'name' => 'Report',
              'x' => 2,
              'y' => 5,
              'width' => 2,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet14__d100687',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 3
            ],
            10 => (object) [
              'id' => 'DashboardSet14__d904570',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 3
            ]
          ],
          'id' => '1283282'
        ]
      ]
    ],
    'DashboardSet15' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'General',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d28811',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d843929',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d225799',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d313587',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d118315',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d553674',
              'name' => 'Report',
              'x' => 2,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d283535',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            12 => (object) [
              'id' => 'DashboardSet15__d690932',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => '2',
              'width' => 0.6666666666666666,
              'height' => '1'
            ],
            13 => (object) [
              'id' => 'DashboardSet15__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => '3',
              'width' => 3,
              'height' => '2'
            ],
            14 => (object) [
              'id' => 'DashboardSet15__d875879',
              'name' => 'Report',
              'x' => 3,
              'y' => '3',
              'width' => 1,
              'height' => '2'
            ],
            15 => (object) [
              'id' => 'DashboardSet15__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => '5',
              'width' => 3,
              'height' => '2'
            ],
            16 => (object) [
              'id' => 'DashboardSet15__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => '5',
              'width' => 1,
              'height' => '2'
            ],
            17 => (object) [
              'id' => 'DashboardSet15__d995949',
              'name' => 'Report',
              'x' => 0,
              'y' => '7',
              'width' => 2,
              'height' => '2'
            ],
            18 => (object) [
              'id' => 'DashboardSet15__d615645',
              'name' => 'Report',
              'x' => 2,
              'y' => '7',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '5152227'
        ],
        1 => (object) [
          'name' => 'SOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d917969',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d482080',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d968539',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 2,
              'height' => '1'
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d595668',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d399031',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d296342',
              'name' => 'Report',
              'x' => 2,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d945567',
              'name' => 'Report',
              'x' => 3,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d310450',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 3,
              'height' => '2'
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d802816',
              'name' => 'Report',
              'x' => 3,
              'y' => '2',
              'width' => 1,
              'height' => '2'
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d661002',
              'name' => 'Report',
              'x' => 0,
              'y' => '4',
              'width' => 3,
              'height' => '2'
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d892543',
              'name' => 'Report',
              'x' => 3,
              'y' => '4',
              'width' => 1,
              'height' => '2'
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d630732',
              'name' => 'Report',
              'x' => 0,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ],
            12 => (object) [
              'id' => 'DashboardSet15__d557297',
              'name' => 'Report',
              'x' => 2,
              'y' => '6',
              'width' => 2,
              'height' => '2'
            ]
          ],
          'id' => '1820250'
        ],
        2 => (object) [
          'name' => 'NOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d487422',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d766440',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d974316',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d471625',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d575051',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d586221',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d875389',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d368232',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d774535',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d574213',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d209469',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d627525',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet15__d352356',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1382877'
        ],
        3 => (object) [
          'name' => 'CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d160278',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d743127',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d771137',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d566169',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d528378',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d363875',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d854265',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d387787',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d64136',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d691113',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d518116',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d719542',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet15__d460692',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '4950620'
        ],
        4 => (object) [
          'name' => 'Brasil',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d262135',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d282587',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d343819',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d462673',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d273107',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d852791',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d625585',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d913949',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d506927',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d325506',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d821142',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d308077',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '8757484'
        ],
        5 => (object) [
          'name' => 'Mexico',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d168758',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet15__d539406',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet15__d601536',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet15__d543351',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet15__d996045',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet15__d944582',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet15__d637081',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet15__d805702',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet15__d163586',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet15__d815644',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet15__d986899',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet15__d596881',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5571679'
        ],
        6 => (object) [
          'name' => 'Partner Program X Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet15__d871824',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7226320'
        ]
      ]
    ],
    'DashboardSet16' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'AWS – Canales',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet16__d212215',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet16__d136119',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet16__d467471',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet16__d322754',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet16__d637722',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet16__d184968',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet16__d765870',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet16__d181494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet16__d373248',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet16__d422019',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet16__d169757',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet16__d30732',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet16__d31895',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet16__d328354',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => (object) [
              'id' => 'DashboardSet16__d942506',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => (object) [
              'id' => 'DashboardSet16__d482881',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet16__d758569',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => (object) [
              'id' => 'DashboardSet16__d182068',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet16__d72577',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => (object) [
              'id' => 'DashboardSet16__d163067',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => (object) [
              'id' => 'DashboardSet16__d709671',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet16__d567514',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '7696764'
        ],
        1 => (object) [
          'name' => 'Partner Program x Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet16__d321581',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 6
            ]
          ],
          'id' => '9679440'
        ]
      ]
    ],
    'DashboardSet2' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Opps LAC',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d629804',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d526240',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d683869',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d647437',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d469632',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d343697',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d412085',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d891781',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d28874',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d19878',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d550027',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d816010',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d159456',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d526300',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet2__d156097',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            15 => (object) [
              'id' => 'DashboardSet2__d740741',
              'name' => 'Report',
              'x' => 2,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet2__d625559',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet2__d129675',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            18 => (object) [
              'id' => 'DashboardSet2__d694276',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            19 => (object) [
              'id' => 'DashboardSet2__d10632',
              'name' => 'Report',
              'x' => 2,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            20 => (object) [
              'id' => 'DashboardSet2__d581688',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet2__d801458',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            22 => (object) [
              'id' => 'DashboardSet2__d216988',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 4,
              'height' => 3
            ],
            23 => (object) [
              'id' => 'DashboardSet2__d796503',
              'name' => 'Report',
              'x' => 0,
              'y' => 15,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4707271'
        ],
        1 => (object) [
          'name' => 'Arg',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d423396',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d479155',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d878076',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d180575',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d2604',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d895558',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d860370',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d379186',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d859520',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d826472',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d789014',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d495550',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d512454',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d778329',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '6858189'
        ],
        2 => (object) [
          'name' => 'Bol',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d616467',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d171583',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d379603',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d829530',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d802211',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d796138',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d268027',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d766491',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d429605',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d774217',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d183747',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d844224',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d545051',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d853472',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4908674'
        ],
        3 => (object) [
          'name' => 'Bra',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d951918',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d889850',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d202635',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d317728',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d29031',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d304980',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d992768',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d774597',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d234460',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d518108',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d776535',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d606526',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d935494',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d443790',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '3190606'
        ],
        4 => (object) [
          'name' => 'CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d358086',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d252806',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d352130',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d507537',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d304255',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d51476',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d753032',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d383120',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d628214',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d705586',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d331429',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d377039',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d108704',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d275780',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '8229566'
        ],
        5 => (object) [
          'name' => 'Chi',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d13403',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d771952',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d36589',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d247281',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d649353',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d956628',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d998346',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d116155',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d31951',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d667347',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d841861',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d362938',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d174415',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d888084',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4295488'
        ],
        6 => (object) [
          'name' => 'Col',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d917187',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d816238',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d406322',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d804561',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d725049',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d278154',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d106753',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d631420',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d234717',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d616862',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d676829',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d979209',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d213406',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d693098',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '2076232'
        ],
        7 => (object) [
          'name' => 'Ecu',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d254568',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d230370',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d940583',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d783814',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d507505',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d873855',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d507930',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d455727',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d898128',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d231366',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d443499',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d83665',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d386675',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d743659',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '5568369'
        ],
        8 => (object) [
          'name' => 'Uru',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d806809',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d901530',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d923512',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d780356',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d584738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d446444',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d114305',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d554959',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d2519',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d656565',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d165886',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d955940',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d731374',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d406395',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '6294014'
        ],
        9 => (object) [
          'name' => 'Par',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d878128',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ],
            1 => (object) [
              'id' => 'DashboardSet2__d714759',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet2__d912682',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet2__d959941',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet2__d909732',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet2__d987900',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet2__d999384',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet2__d518175',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet2__d436987',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet2__d821902',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet2__d807288',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet2__d554539',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet2__d831355',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet2__d591433',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '8804820'
        ],
        10 => (object) [
          'name' => 'Opps LAC & Surestep',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet2__d349397',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '3852770'
        ]
      ]
    ],
    'DashboardSet28' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Oportunidades',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet28__d767476',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet28__d920219',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet28__d95779',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet28__d689950',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet28__d885007',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet28__d261850',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet28__d61923',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet28__d335596',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet28__d183545',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '2063684'
        ],
        1 => (object) [
          'name' => 'Surestep x Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet28__d348271',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7404505'
        ]
      ]
    ],
    'DashboardSet33' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Opps LAC',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d629804',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d526240',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d683869',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d647437',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d469632',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d343697',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d412085',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d891781',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d28874',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d19878',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d550027',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d816010',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d159456',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d526300',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet33__d156097',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            15 => (object) [
              'id' => 'DashboardSet33__d740741',
              'name' => 'Report',
              'x' => 2,
              'y' => 8,
              'width' => 2,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet33__d625559',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet33__d129675',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            18 => (object) [
              'id' => 'DashboardSet33__d694276',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            19 => (object) [
              'id' => 'DashboardSet33__d10632',
              'name' => 'Report',
              'x' => 2,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            20 => (object) [
              'id' => 'DashboardSet33__d581688',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet33__d801458',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 11,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            22 => (object) [
              'id' => 'DashboardSet33__d216988',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 4,
              'height' => 3
            ],
            23 => (object) [
              'id' => 'DashboardSet33__d796503',
              'name' => 'Report',
              'x' => 0,
              'y' => 15,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4707271'
        ],
        1 => (object) [
          'name' => 'Arg',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d423396',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d479155',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d878076',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d180575',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d2604',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d895558',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d860370',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d379186',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d859520',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d826472',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d789014',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d495550',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d512454',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d778329',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '6858189'
        ],
        2 => (object) [
          'name' => 'Bol',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d616467',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d171583',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d379603',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d829530',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d802211',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d796138',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d268027',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d766491',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d429605',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d774217',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d183747',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d844224',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d545051',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d853472',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4908674'
        ],
        3 => (object) [
          'name' => 'Bra',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d951918',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d889850',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d202635',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d317728',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d29031',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d304980',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d992768',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d774597',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d234460',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d518108',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d776535',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d606526',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d935494',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d443790',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '3190606'
        ],
        4 => (object) [
          'name' => 'CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d358086',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d252806',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d352130',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d507537',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d304255',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d51476',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d753032',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d383120',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d628214',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d705586',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d331429',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d377039',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d108704',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d275780',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '8229566'
        ],
        5 => (object) [
          'name' => 'Chi',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d13403',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d771952',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d36589',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d247281',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d649353',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d956628',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d998346',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d116155',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d31951',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d667347',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d841861',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d362938',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d174415',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d888084',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '4295488'
        ],
        6 => (object) [
          'name' => 'Col',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d917187',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d816238',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d406322',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d804561',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d725049',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d278154',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d106753',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d631420',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d234717',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d616862',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d676829',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d979209',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d213406',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d693098',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '2076232'
        ],
        7 => (object) [
          'name' => 'Ecu',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d254568',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d230370',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d940583',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d783814',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d507505',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d873855',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d507930',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d455727',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d898128',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d231366',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d443499',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d83665',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d386675',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d743659',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '5568369'
        ],
        8 => (object) [
          'name' => 'Uru',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d806809',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d901530',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d923512',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d780356',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d584738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d446444',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d114305',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d554959',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d2519',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d656565',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d165886',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d955940',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d731374',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d406395',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '6294014'
        ],
        9 => (object) [
          'name' => 'Par',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d878128',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 4
            ],
            1 => (object) [
              'id' => 'DashboardSet33__d714759',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet33__d912682',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet33__d959941',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet33__d909732',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet33__d987900',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet33__d999384',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet33__d518175',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet33__d436987',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet33__d821902',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet33__d807288',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet33__d554539',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet33__d831355',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet33__d591433',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ]
          ],
          'id' => '8804820'
        ],
        10 => (object) [
          'name' => 'Opps LAC & Surestep',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet33__d349397',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '3852770'
        ]
      ]
    ],
    'DashboardSet34' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Surestep',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d410610',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d774213',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d384224',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d41068',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d273153',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d45629',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d892037',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d468356',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d34363',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet34__d530335',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 3,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet34__d644120',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '8856502'
        ],
        1 => (object) [
          'name' => 'Arg',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d252758',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d760480',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d318481',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d511220',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d212462',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d186584',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d720120',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d365108',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d426064',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '1810792'
        ],
        2 => (object) [
          'name' => 'Bol',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d901660',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d861901',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d625989',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d355808',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d585575',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d306512',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d42967',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d918586',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d855242',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8519274'
        ],
        3 => (object) [
          'name' => 'Bra',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d812471',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d301665',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d450290',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d341647',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d434542',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d698954',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d473819',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d975044',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d14781',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '6019153'
        ],
        4 => (object) [
          'name' => 'CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d200442',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d155528',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d536511',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d405784',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d955152',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d994024',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d252263',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d92104',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d741587',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet34__d871706',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '1960430'
        ],
        5 => (object) [
          'name' => 'Chi',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d295819',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d261655',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d886099',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d863748',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d995203',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d994428',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d31050',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d546417',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d526505',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8374551'
        ],
        6 => (object) [
          'name' => 'Col',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d730589',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d282730',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d460605',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d87769',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d538177',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d349823',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d864232',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d589644',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d113843',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '9151116'
        ],
        7 => (object) [
          'name' => 'Ecu',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d357644',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d46613',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d686015',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d527351',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d140150',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d936286',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d431512',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d618043',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d912452',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '3622865'
        ],
        8 => (object) [
          'name' => 'Mex',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet34__d57175',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet34__d866483',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet34__d422017',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet34__d370298',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet34__d623625',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet34__d591590',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet34__d424351',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet34__d694719',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet34__d28487',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ]
          ],
          'id' => '8678416'
        ]
      ]
    ],
    'DashboardSet35' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Surestep',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet35__d410610',
              'name' => 'Report',
              'x' => 0,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            1 => (object) [
              'id' => 'DashboardSet35__d774213',
              'name' => 'Report',
              'x' => 1,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            2 => (object) [
              'id' => 'DashboardSet35__d384224',
              'name' => 'Report',
              'x' => 2,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            3 => (object) [
              'id' => 'DashboardSet35__d41068',
              'name' => 'Report',
              'x' => 3,
              'y' => '0',
              'width' => 1,
              'height' => '1'
            ],
            4 => (object) [
              'id' => 'DashboardSet35__d34363',
              'name' => 'Report',
              'x' => 0,
              'y' => '1',
              'width' => 1,
              'height' => '1'
            ],
            5 => (object) [
              'id' => 'DashboardSet35__d530335',
              'name' => 'Report',
              'x' => 1,
              'y' => '1',
              'width' => 3,
              'height' => '1'
            ],
            6 => (object) [
              'id' => 'DashboardSet35__d644120',
              'name' => 'Report',
              'x' => 0,
              'y' => '2',
              'width' => 4,
              'height' => '2'
            ],
            7 => (object) [
              'id' => 'DashboardSet35__d165960',
              'name' => 'Report',
              'x' => 0,
              'y' => '4',
              'width' => 1,
              'height' => '2'
            ],
            8 => (object) [
              'id' => 'DashboardSet35__d307807',
              'name' => 'Report',
              'x' => 1,
              'y' => '4',
              'width' => 3,
              'height' => '2'
            ]
          ],
          'id' => '8856502'
        ]
      ]
    ],
    'DashboardSet36' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Arg',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet36__d833051',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '5355868'
        ]
      ]
    ],
    'DashboardSet37' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket Brasil',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet37__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet38' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket CCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet38__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet39' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket Chile',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet39__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet4' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Surestep',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet4__d410610',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet4__d774213',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet4__d384224',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet4__d41068',
              'name' => 'Report',
              'x' => 3,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet4__d191817',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet4__d212599',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet4__d596881',
              'name' => 'Report',
              'x' => 3,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet4__d45629',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet4__d892037',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet4__d273153',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet4__d468356',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet4__d34363',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet4__d530335',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 3,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet4__d644120',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            14 => (object) [
              'id' => 'DashboardSet4__d772391',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 1,
              'height' => 2
            ],
            15 => (object) [
              'id' => 'DashboardSet4__d548306',
              'name' => 'Report',
              'x' => 1,
              'y' => 12,
              'width' => 3,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet4__d725149',
              'name' => 'Report',
              'x' => 0,
              'y' => 14,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '8856502'
        ]
      ]
    ],
    'DashboardSet40' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket Colombia',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet40__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet41' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket Ecuador',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet41__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet42' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket ',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet42__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ],
        1 => (object) [
          'name' => 'Rocket Top 10 Resellers',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet42__d383500',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 9
            ]
          ],
          'id' => '1971746'
        ]
      ]
    ],
    'DashboardSet43' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Rocket Peru',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet43__d436024',
              'name' => 'Rocket',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 18
            ]
          ],
          'id' => '8724280'
        ]
      ]
    ],
    'DashboardSet44' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Practice Builder General Data',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet44__d880633',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet44__d686477',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet44__d848671',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 3,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet44__d402741',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 1,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet44__d825190',
              'name' => 'Report',
              'x' => 1,
              'y' => 3,
              'width' => 3,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet44__d462376',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 1,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet44__d695820',
              'name' => 'Report',
              'x' => 1,
              'y' => 5,
              'width' => 3,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet44__d949049',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet44__d676306',
              'name' => 'Report',
              'x' => 1,
              'y' => 7,
              'width' => 3,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet44__d639015',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet44__d244799',
              'name' => 'Report',
              'x' => 1,
              'y' => 9,
              'width' => 3,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet44__d128345',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 1,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet44__d22473',
              'name' => 'Report',
              'x' => 1,
              'y' => 11,
              'width' => 3,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet44__d727792',
              'name' => 'Report',
              'x' => 0,
              'y' => 13,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '2816285'
        ],
        1 => (object) [
          'name' => 'Dashboard - Cloud',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet44__d211532',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '1942151'
        ],
        2 => (object) [
          'name' => 'Dashboard - Data IA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet44__d125535',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 4
            ]
          ],
          'id' => '4759029'
        ],
        3 => (object) [
          'name' => 'Dashboard - Cybersecurity',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet44__d92005',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '7472153'
        ]
      ]
    ],
    'DashboardSet45' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'MSFT - ARG',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet45__d695019',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet45__d7707',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet45__d584798',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet45__d325073',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet45__d838341',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet45__d381834',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet45__d504622',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet45__d277566',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet45__d543413',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 4,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet45__d142438',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet45__d139171',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet45__d361560',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet45__d626119',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet45__d935605',
              'name' => 'Report',
              'x' => 0,
              'y' => 11,
              'width' => 4,
              'height' => 3
            ],
            14 => (object) [
              'id' => 'DashboardSet45__d862098',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 2,
              'height' => 3
            ],
            15 => (object) [
              'id' => 'DashboardSet45__d55916',
              'name' => 'Report',
              'x' => 2,
              'y' => 6,
              'width' => 2,
              'height' => 3
            ],
            16 => (object) [
              'id' => 'DashboardSet45__d75594',
              'name' => 'Report',
              'x' => 0,
              'y' => 9,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '3573359'
        ],
        1 => (object) [
          'name' => 'Renewals',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet45__d974962',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet45__d402420',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 3,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet45__d701273',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet45__d690647',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet45__d514201',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet45__d26271',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet45__d365702',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet45__d608399',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet45__d690092',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ]
          ],
          'id' => '6076175'
        ],
        2 => (object) [
          'name' => 'Surestep x Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet45__d131497',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '8229885'
        ]
      ]
    ],
    'DashboardSet46' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Level Up',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet46__d388583',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet46__d465884',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet46__d883813',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet46__d581332',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet46__d101197',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 6,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet46__d356005',
              'name' => 'Report',
              'x' => 2,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet46__d265559',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet46__d214642',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5532792'
        ]
      ]
    ],
    'DashboardSet47' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'Oportunidades',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet47__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet47__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet47__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet47__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet47__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet47__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet47__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet47__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet47__d51703',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet47__d615645',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet47__d336598',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet47__d231313',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet47__d756242',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet47__d285244',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5152227'
        ]
      ]
    ],
    'DashboardSet48' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'LAC',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet48__d57190',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet48__d965489',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet48__d79262',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet48__d385605',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet48__d975738',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet48__d32063',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet48__d258643',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet48__d317494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet48__d51703',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet48__d615645',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet48__d336598',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet48__d231313',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet48__d756242',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet48__d285244',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '5152227'
        ],
        1 => (object) [
          'name' => 'MCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet48__d274234',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet48__d388961',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet48__d501079',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet48__d888540',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet48__d67287',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet48__d889914',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet48__d414549',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet48__d206979',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet48__d91521',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet48__d672283',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet48__d251826',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet48__d26260',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet48__d977578',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet48__d30377',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '518485'
        ],
        2 => (object) [
          'name' => 'SOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet48__d917969',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet48__d482080',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet48__d745400',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet48__d595668',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet48__d399031',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet48__d310450',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet48__d802816',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet48__d661002',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet48__d892543',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet48__d998703',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet48__d630732',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet48__d159989',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet48__d109271',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet48__d557297',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1820250'
        ],
        3 => (object) [
          'name' => 'NOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet48__d487422',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet48__d766440',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet48__d974316',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet48__d471625',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet48__d575051',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet48__d368232',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet48__d774535',
              'name' => 'Report',
              'x' => 3,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet48__d574213',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet48__d209469',
              'name' => 'Report',
              'x' => 3,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet48__d627525',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet48__d746898',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet48__d586221',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet48__d352356',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet48__d875389',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ]
          ],
          'id' => '1382877'
        ],
        4 => (object) [
          'name' => 'Partner Program X Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet48__d854023',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '166980'
        ]
      ]
    ],
    'DashboardSet49' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'MSFT - MEX',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet49__d256276',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet49__d647758',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 1,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet49__d634114',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 2,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet49__d346942',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet49__d973927',
              'name' => 'Report',
              'x' => 1,
              'y' => 1,
              'width' => 1,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet49__d242947',
              'name' => 'Report',
              'x' => 2,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet49__d860559',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet49__d105327',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 1,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet49__d798542',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            9 => (object) [
              'id' => 'DashboardSet49__d822163',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 2,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            10 => (object) [
              'id' => 'DashboardSet49__d606174',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 2.6666666666666665,
              'height' => 2
            ],
            11 => (object) [
              'id' => 'DashboardSet49__d749773',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 4,
              'width' => 1.3333333333333333,
              'height' => 2
            ],
            12 => (object) [
              'id' => 'DashboardSet49__d675991',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 4,
              'height' => 2
            ],
            13 => (object) [
              'id' => 'DashboardSet49__d957650',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 3
            ]
          ],
          'id' => '7583472'
        ],
        1 => (object) [
          'name' => 'Renewals',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet49__d112570',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            1 => (object) [
              'id' => 'DashboardSet49__d854252',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 1,
              'height' => 2
            ],
            2 => (object) [
              'id' => 'DashboardSet49__d280343',
              'name' => 'Report',
              'x' => 1,
              'y' => 6,
              'width' => 3,
              'height' => 2
            ],
            3 => (object) [
              'id' => 'DashboardSet49__d242754',
              'name' => 'Report',
              'x' => 1,
              'y' => 4,
              'width' => 3,
              'height' => 2
            ],
            4 => (object) [
              'id' => 'DashboardSet49__d315216',
              'name' => 'Report',
              'x' => 1,
              'y' => 2,
              'width' => 3,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet49__d713797',
              'name' => 'Report',
              'x' => 1,
              'y' => 0,
              'width' => 3,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet49__d450641',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 1,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet49__d66052',
              'name' => 'Report',
              'x' => 0,
              'y' => 2,
              'width' => 1,
              'height' => 2
            ],
            8 => (object) [
              'id' => 'DashboardSet49__d218146',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 1,
              'height' => 2
            ]
          ],
          'id' => '7392476'
        ],
        2 => (object) [
          'name' => 'Surestep x Opps',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet49__d961521',
              'name' => 'Iframe',
              'x' => 0,
              'y' => 0,
              'width' => 4,
              'height' => 5
            ]
          ],
          'id' => '6829767'
        ]
      ]
    ],
    'DashboardSet5' => (object) [
      'controller' => 'dubas-custom:controllers/dashboard-set',
      'acl' => 'dubas-custom:acl/dashboard-set',
      'iconClass' => 'fas fa-th-large',
      'dashboardLayout' => [
        0 => (object) [
          'name' => 'LAC',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet5__d609168',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet5__d212215',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet5__d136119',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet5__d467471',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet5__d322754',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet5__d125778',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet5__d637722',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            7 => (object) [
              'id' => 'DashboardSet5__d184968',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet5__d765870',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet5__d181494',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet5__d373248',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet5__d662372',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet5__d477371',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet5__d30732',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => (object) [
              'id' => 'DashboardSet5__d31895',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => (object) [
              'id' => 'DashboardSet5__d328354',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            16 => (object) [
              'id' => 'DashboardSet5__d942506',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            17 => (object) [
              'id' => 'DashboardSet5__d434684',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 1,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet5__d626237',
              'name' => 'Report',
              'x' => 1,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            19 => (object) [
              'id' => 'DashboardSet5__d31322',
              'name' => 'Report',
              'x' => 2,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            20 => (object) [
              'id' => 'DashboardSet5__d987303',
              'name' => 'Report',
              'x' => 3,
              'y' => 8,
              'width' => 1,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet5__d785880',
              'name' => 'Report',
              'x' => 1,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            22 => (object) [
              'id' => 'DashboardSet5__d816388',
              'name' => 'Report',
              'x' => 2,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            23 => (object) [
              'id' => 'DashboardSet5__d19415',
              'name' => 'Report',
              'x' => 3,
              'y' => 9,
              'width' => 1,
              'height' => 1
            ],
            24 => (object) [
              'id' => 'DashboardSet5__d747656',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 2,
              'height' => 2
            ],
            25 => (object) [
              'id' => 'DashboardSet5__d627864',
              'name' => 'Report',
              'x' => 2,
              'y' => 10,
              'width' => 2,
              'height' => 2
            ],
            26 => (object) [
              'id' => 'DashboardSet5__d322454',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            27 => (object) [
              'id' => 'DashboardSet5__d230806',
              'name' => 'Report',
              'x' => 2,
              'y' => 12,
              'width' => 2,
              'height' => 2
            ],
            28 => (object) [
              'id' => 'DashboardSet5__d482881',
              'name' => 'Report',
              'x' => 0,
              'y' => 14,
              'width' => 2,
              'height' => 2
            ],
            29 => (object) [
              'id' => 'DashboardSet5__d648871',
              'name' => 'Report',
              'x' => 2,
              'y' => 14,
              'width' => 2,
              'height' => 2
            ],
            30 => (object) [
              'id' => 'DashboardSet5__d72577',
              'name' => 'Report',
              'x' => 0,
              'y' => 16,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            31 => (object) [
              'id' => 'DashboardSet5__d260622',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 16,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            32 => (object) [
              'id' => 'DashboardSet5__d758569',
              'name' => 'Report',
              'x' => 0,
              'y' => 18,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            33 => (object) [
              'id' => 'DashboardSet5__d930104',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 18,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            34 => (object) [
              'id' => 'DashboardSet5__d295112',
              'name' => 'Report',
              'x' => 0,
              'y' => 20,
              'width' => 4,
              'height' => 1
            ]
          ],
          'id' => '7696764'
        ],
        1 => (object) [
          'name' => 'MCA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet5__d165463',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet5__d976807',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet5__d3339',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet5__d642140',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet5__d94116',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            5 => (object) [
              'id' => 'DashboardSet5__d575664',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            6 => (object) [
              'id' => 'DashboardSet5__d641576',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet5__d868442',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet5__d909543',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet5__d13973',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet5__d517145',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet5__d871098',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet5__d552250',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet5__d446964',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            14 => (object) [
              'id' => 'DashboardSet5__d651789',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            15 => (object) [
              'id' => 'DashboardSet5__d149835',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            16 => (object) [
              'id' => 'DashboardSet5__d828716',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            17 => (object) [
              'id' => 'DashboardSet5__d92384',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet5__d605709',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            19 => (object) [
              'id' => 'DashboardSet5__d530501',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            20 => (object) [
              'id' => 'DashboardSet5__d974453',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            21 => (object) [
              'id' => 'DashboardSet5__d167388',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '8798178'
        ],
        2 => (object) [
          'name' => 'SOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet5__d788396',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet5__d194506',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet5__d472866',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet5__d781222',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet5__d88428',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet5__d329914',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet5__d590840',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet5__d421031',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet5__d318408',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet5__d429511',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet5__d396350',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet5__d787437',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet5__d247188',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet5__d200847',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => (object) [
              'id' => 'DashboardSet5__d891294',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => (object) [
              'id' => 'DashboardSet5__d765274',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet5__d201290',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => (object) [
              'id' => 'DashboardSet5__d388109',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet5__d469617',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => (object) [
              'id' => 'DashboardSet5__d715433',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => (object) [
              'id' => 'DashboardSet5__d687945',
              'name' => 'Report',
              'x' => 0,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet5__d257502',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ]
          ],
          'id' => '9961055'
        ],
        3 => (object) [
          'name' => 'NOLA',
          'layout' => [
            0 => (object) [
              'id' => 'DashboardSet5__d49937',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            1 => (object) [
              'id' => 'DashboardSet5__d597323',
              'name' => 'Report',
              'x' => 1.3333333333333333,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            2 => (object) [
              'id' => 'DashboardSet5__d800139',
              'name' => 'Report',
              'x' => 2,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            3 => (object) [
              'id' => 'DashboardSet5__d528640',
              'name' => 'Report',
              'x' => 2.6666666666666665,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            4 => (object) [
              'id' => 'DashboardSet5__d323207',
              'name' => 'Report',
              'x' => 0,
              'y' => 1,
              'width' => 4,
              'height' => 2
            ],
            5 => (object) [
              'id' => 'DashboardSet5__d137854',
              'name' => 'Report',
              'x' => 0,
              'y' => 3,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            6 => (object) [
              'id' => 'DashboardSet5__d253042',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 3,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            7 => (object) [
              'id' => 'DashboardSet5__d747449',
              'name' => 'Report',
              'x' => 0,
              'y' => 4,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            8 => (object) [
              'id' => 'DashboardSet5__d12112',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 4,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            9 => (object) [
              'id' => 'DashboardSet5__d720675',
              'name' => 'Report',
              'x' => 0,
              'y' => 5,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            10 => (object) [
              'id' => 'DashboardSet5__d999254',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 5,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            11 => (object) [
              'id' => 'DashboardSet5__d709792',
              'name' => 'Report',
              'x' => 0,
              'y' => 6,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            12 => (object) [
              'id' => 'DashboardSet5__d957873',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 6,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            13 => (object) [
              'id' => 'DashboardSet5__d79883',
              'name' => 'Report',
              'x' => 0,
              'y' => 7,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            14 => (object) [
              'id' => 'DashboardSet5__d813104',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 7,
              'width' => 3.3333333333333335,
              'height' => 1
            ],
            15 => (object) [
              'id' => 'DashboardSet5__d264062',
              'name' => 'Report',
              'x' => 0,
              'y' => 8,
              'width' => 4,
              'height' => 2
            ],
            16 => (object) [
              'id' => 'DashboardSet5__d707794',
              'name' => 'Report',
              'x' => 0,
              'y' => 10,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            17 => (object) [
              'id' => 'DashboardSet5__d689210',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 10,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            18 => (object) [
              'id' => 'DashboardSet5__d758453',
              'name' => 'Report',
              'x' => 0,
              'y' => 12,
              'width' => 0.6666666666666666,
              'height' => 2
            ],
            19 => (object) [
              'id' => 'DashboardSet5__d41877',
              'name' => 'Report',
              'x' => 0.6666666666666666,
              'y' => 12,
              'width' => 3.3333333333333335,
              'height' => 2
            ],
            20 => (object) [
              'id' => 'DashboardSet5__d395095',
              'name' => 'Report',
              'x' => 3.3333333333333335,
              'y' => 0,
              'width' => 0.6666666666666666,
              'height' => 1
            ],
            21 => (object) [
              'id' => 'DashboardSet5__d813696',
        