<?php
return [
  'ActionHistoryRecord' => [
    'fields' => [
      'user' => 'Usuário',
      'action' => 'Ação',
      'createdAt' => 'Data',
      'userType' => 'Tipo de Usuário',
      'target' => 'Alvo',
      'targetType' => 'Tipo de Alvo',
      'authToken' => 'Token de Autenticação',
      'ipAddress' => 'Endereço IP',
      'authLogRecord' => 'Registro de Log de Autorização'
    ],
    'links' => [
      'authToken' => 'Token de Autenticação',
      'authLogRecord' => 'Registro de Log de Autorização',
      'user' => 'Usuário',
      'target' => 'Alvo'
    ],
    'presetFilters' => [
      'onlyMy' => 'Apenas Meu'
    ],
    'options' => [
      'action' => [
        'read' => 'Ler',
        'update' => 'Atualizar',
        'delete' => 'Excluir',
        'create' => 'Criar'
      ]
    ]
  ],
  'AddressCountry' => [
    'labels' => [
      'Create AddressCountry' => 'Create Address Country',
      'Populate' => 'Populate'
    ],
    'fields' => [
      'code' => 'Code',
      'isPreferred' => 'Is Preferred'
    ],
    'tooltips' => [
      'code' => 'ISO 3166-1 alpha-2 code.',
      'isPreferred' => 'Preferred countries appear first in the picklist.'
    ],
    'messages' => [
      'confirmPopulateDefaults' => 'All existing countries will be deleted, the default country list will be created. It won\'t be possible to revert the operation.

Are you sure?'
    ],
    'strings' => [
      'populateDefaults' => 'Populate with default country list'
    ]
  ],
  'Admin' => [
    'labels' => [
      'Enabled' => 'Habilitado',
      'Disabled' => 'Desabilitado',
      'System' => 'Sistema',
      'Users' => 'Usuários',
      'Email' => 'E-mail',
      'Messaging' => 'Mensagem',
      'Data' => 'Data',
      'Misc' => 'Misc',
      'Setup' => 'Setup',
      'Customization' => 'Personalização',
      'Available Fields' => 'Campos Disponíveis',
      'Layout' => 'Layout',
      'Entity Manager' => 'Gerenciador de Entidades',
      'Add Panel' => 'Adicionar Painel',
      'Add Field' => 'Adicionar Campo',
      'Settings' => 'Preferências',
      'Scheduled Jobs' => 'Tarefas agendadas',
      'Upgrade' => 'Atualização',
      'Clear Cache' => 'Limpar Cache',
      'Rebuild' => 'Reconstruir',
      'Teams' => 'Times',
      'Roles' => 'Regras',
      'Portal' => 'Portal',
      'Portals' => 'Portais',
      'Portal Roles' => 'Regras de Portal',
      'Portal Users' => 'Usuários do Portal',
      'API Users' => 'Usuários da API',
      'Outbound Emails' => 'E-mails de Saída',
      'Group Email Accounts' => 'Contas de Email de Grupo',
      'Personal Email Accounts' => 'Contas de Emails Pessoais',
      'Inbound Emails' => 'E-mails de Entrada',
      'Email Templates' => 'Templates dos E-mails',
      'Import' => 'Importar',
      'Layout Manager' => 'Gerenciar Layout',
      'User Interface' => 'Interface do Usuário',
      'Auth Tokens' => 'Tokens de Autenticação',
      'Auth Log' => 'Log de Autorização',
      'App Log' => 'App Log',
      'App Secrets' => 'App Secrets',
      'Authentication' => 'Autenticação',
      'Currency' => 'Moeda',
      'Integrations' => 'Integrações',
      'Extensions' => 'Extensões',
      'Webhooks' => 'Webhooks',
      'Dashboard Templates' => 'Modelos de Dashboard',
      'Upload' => 'Upload',
      'Installing...' => 'Instalando...',
      'Upgrading...' => 'Atualizando...',
      'Upgraded successfully' => 'Atualizado com sucesso',
      'Installed successfully' => 'Instalado com sucesso',
      'Ready for upgrade' => 'Pronto para a atualização',
      'Run Upgrade' => 'Rodar atualização',
      'Install' => 'Instalar',
      'Ready for installation' => 'Pronto para a instalação',
      'Uninstalling...' => 'Desinstalando...',
      'Uninstalled' => 'Desinstalado',
      'Create Entity' => 'Criar Entidade',
      'Edit Entity' => 'Editar Entidade',
      'Create Link' => 'Criar Link',
      'Edit Link' => 'Editar Link',
      'Notifications' => 'Notificações',
      'Jobs' => 'Tarefas',
      'Job Settings' => 'Config. de Trabalho',
      'Reset to Default' => 'Redefinir para Padrão',
      'Email Filters' => 'Filtros de Email',
      'Action History' => 'Histórico de Ações',
      'Label Manager' => 'Gerenciador de Rótulos',
      'Template Manager' => 'Gerenciador de Modelos',
      'Lead Capture' => 'Captura de Lead',
      'Attachments' => 'Anexos',
      'System Requirements' => 'Requisitos de sistema',
      'PDF Templates' => 'Modelos PDF',
      'PHP Settings' => 'Configurações do PHP',
      'Database Settings' => 'Configurações do banco de dados',
      'Permissions' => 'Permissões',
      'Email Addresses' => 'Endereço de Email',
      'Phone Numbers' => 'Números de Telefone',
      'Layout Sets' => 'Conjunto de Layouts',
      'Working Time Calendars' => 'Working Time Calendars',
      'Group Email Folders' => 'Group Email Folders',
      'Authentication Providers' => 'Authentication Providers',
      'Address Countries' => 'Address Countries',
      'Success' => 'Sucesso',
      'Fail' => 'Falha',
      'Configuration Instructions' => 'Instruções de Configuração',
      'Formula Sandbox' => 'Sandbox de Fórmula',
      'is recommended' => 'é recomendado',
      'extension is missing' => 'faltando extensão',
      'Workflow Manager' => 'Workflows',
      'Flowcharts' => 'Flowcharts',
      'Processes' => 'Processes',
      'Business Process Management' => 'Business Process Management',
      'Report Filters' => 'Report Filters',
      'Report Panels' => 'Report Panels',
      'Price Rule Conditions' => 'Price Rule Conditions'
    ],
    'layouts' => [
      'list' => 'Lista',
      'detail' => 'Detalhe',
      'listSmall' => 'Lista (Pequeno)',
      'detailSmall' => 'Detalhe (Pequeno)',
      'detailPortal' => 'Detalhe (Portal)',
      'detailSmallPortal' => 'Detalhe (Pequeno, Portal)',
      'listSmallPortal' => 'Lista (Pequena, Portal)',
      'listPortal' => 'Lista (Portal)',
      'relationshipsPortal' => 'Painéis de Relacionamento (Portal)',
      'filters' => 'Filtros de Busca',
      'massUpdate' => 'Atualização em massa',
      'relationships' => 'Relacionamentos',
      'defaultSidePanel' => 'Painéis Laterais (Campos)',
      'bottomPanelsDetail' => 'Painéis Inferiores',
      'bottomPanelsEdit' => 'Painéis Inferiores (Editar)',
      'bottomPanelsDetailSmall' => 'Painéis Inferiores (Detalhe Pequeno)',
      'bottomPanelsEditSmall' => 'Painéis Inferiores (Editar Pequeno)',
      'sidePanelsDetail' => 'Painéis Laterais (Pequeno)',
      'sidePanelsEdit' => 'Painéis Laterais (Editar)',
      'sidePanelsDetailSmall' => 'Painéis Laterais (Detalhe Pequeno)',
      'sidePanelsEditSmall' => 'Painéis Laterais (Editar Pequeno)',
      'kanban' => 'Kanban',
      'detailConvert' => 'Converter Lead',
      'listForAccount' => 'Lista (para Contas)',
      'listForContact' => 'Lista (para Contato)',
      'listItem' => 'List (Item)',
      'detailBottomTotal' => 'Bottom Total',
      'listForAdd' => 'List (Select for Item)',
      'listForAddInventory' => 'List (Select Inventory)',
      'detailCreateFromSalesOrder' => 'Create from Sales Order',
      'detailCreateFromPurchaseOrder' => 'Create from Purchase Order',
      'listForProduct' => 'List for Product',
      'listForTemplateProduct' => 'List for Template Product',
      'listForWarehouse' => 'List for Warehouse',
      'listVariant' => 'List Variants',
      'listForProject' => 'List (for Project)',
      'listForTask' => 'List (Sub-Task)',
      'listSmallForProject' => 'List (Small, for Project)',
      'kanbanForProject' => 'Board (for Project)'
    ],
    'fieldTypes' => [
      'address' => 'Endereço',
      'array' => 'Matriz',
      'foreign' => 'Relacionamento',
      'duration' => 'Duração',
      'password' => 'Senha',
      'personName' => 'Nome da Pessoa',
      'autoincrement' => 'Auto-incremento',
      'bool' => 'Booleano',
      'currency' => 'Moeda',
      'currencyConverted' => 'Moeda (Convertida)',
      'date' => 'Data',
      'datetime' => 'Data e Hora',
      'datetimeOptional' => 'Data/Data e Hora',
      'email' => 'E-mail',
      'enum' => 'Lista',
      'enumInt' => 'Lista (Número)',
      'enumFloat' => 'Lista (Float)',
      'float' => 'Float',
      'int' => 'Número',
      'link' => 'Link',
      'linkMultiple' => 'Link Multiplo',
      'linkParent' => 'Link Pai',
      'linkOne' => 'Link One',
      'phone' => 'Telefone',
      'text' => 'Texto',
      'url' => 'Url',
      'urlMultiple' => 'Url Multiple',
      'varchar' => 'Varchar',
      'file' => 'Arquivo',
      'image' => 'Imagem',
      'multiEnum' => 'Lista múltipla',
      'attachmentMultiple' => 'Múltiplos Anexos',
      'rangeInt' => 'Variação de Integer',
      'rangeFloat' => 'Variação de Float',
      'rangeCurrency' => 'Variação de Moeda',
      'wysiwyg' => 'Wysiwyg',
      'map' => 'Mapa',
      'number' => 'Número (incremento automático)',
      'colorpicker' => 'Selecionador de Cor',
      'checklist' => 'Checklist',
      'barcode' => 'Código de Barras',
      'jsonArray' => 'Matriz Json',
      'jsonObject' => 'Objeto Json',
      'inlineRelationList' => 'Inline Relation List'
    ],
    'fields' => [
      'type' => 'Tipo',
      'name' => 'Nome',
      'label' => 'Rótulo',
      'tooltipText' => 'Texto Tooltip',
      'required' => 'Obrigatório',
      'default' => 'Padrão',
      'maxLength' => 'Tamanho máximo',
      'options' => 'Opções (valores raw, não traduzíveis)',
      'optionsReference' => 'Options Reference',
      'after' => 'Antes (field)',
      'before' => 'Após (field)',
      'link' => 'Link',
      'field' => 'Campo',
      'min' => 'Mín',
      'max' => 'Máx',
      'translation' => 'Tradução',
      'previewSize' => 'Tamanho do Preview',
      'listPreviewSize' => 'Tam. da Pré-visualização na Lista de Visualização',
      'noEmptyString' => 'Nenhuma seqüência de caracteres vazia',
      'defaultType' => 'Tipo Padrão',
      'seeMoreDisabled' => 'Desativar corte de texto.',
      'cutHeight' => 'Cut Height (px)',
      'entityList' => 'Lista de Entidades',
      'isSorted' => 'Ordenado (alfabeticamente)',
      'audited' => 'Auditado',
      'trim' => 'Aparar',
      'height' => 'Altura (px)',
      'minHeight' => 'Altura Mín (px)',
      'provider' => 'Provedor',
      'typeList' => 'Lista de Tipo',
      'rows' => 'Número de linhas da áreadetexto',
      'lengthOfCut' => 'Extensão do corte',
      'sourceList' => 'Lista fonte',
      'prefix' => 'Prefixo',
      'nextNumber' => 'Próximo Número',
      'padLength' => 'Pad Length',
      'disableFormatting' => 'Desativar formatação',
      'dynamicLogicVisible' => 'Condições que tornam o campo visível',
      'dynamicLogicReadOnly' => 'Condições que tornam o campo somente leitura',
      'dynamicLogicRequired' => 'Condições que tornam o campo obrigatório',
      'dynamicLogicOptions' => 'Opções condicionais',
      'dynamicLogicInvalid' => 'Condições que tornam o campo inválido',
      'probabilityMap' => 'Probabilidades do Estágio (%)',
      'notActualOptions' => 'Not Actual Options',
      'activeOptions' => 'Active Options',
      'readOnly' => 'Somente de Leitura',
      'readOnlyAfterCreate' => 'Read-only After Create',
      'preview' => 'Preview',
      'attachmentField' => 'Attachment Field',
      'maxFileSize' => 'Tam. máximo do arquivo (Mb)',
      'isPersonalData' => 'É Dado Pessoal',
      'useIframe' => 'Usar Iframe',
      'useNumericFormat' => 'Usar formato numérico',
      'strip' => 'Strip',
      'minuteStep' => 'Minutes Step',
      'inlineEditDisabled' => 'Desativar Edição em linha',
      'allowCustomOptions' => 'Permitir opções Personalizadas',
      'displayAsLabel' => 'Mostrar como Rótulo',
      'displayAsList' => 'Mostrar como Lista',
      'labelType' => 'Label Type',
      'maxCount' => 'Contagem máxima de itens',
      'accept' => 'Aceitar',
      'viewMap' => 'View Map Button',
      'codeType' => 'Tipo de Código',
      'lastChar' => 'Último Caractere',
      'onlyDefaultCurrency' => 'Apenas moeda padrão',
      'decimal' => 'Decimal',
      'displayRawText' => 'Exibir texto puro (sem markdown)',
      'conversionDisabled' => 'Desativar Conversão',
      'decimalPlaces' => 'Casas Decimais',
      'pattern' => 'Pattern',
      'globalRestrictions' => 'Global Restrictions',
      'copyToClipboard' => 'Copy to clipboard button',
      'createButton' => 'Create Button',
      'autocompleteOnEmpty' => 'Autocomplete on empty input',
      'relateOnImport' => 'Relate on Import',
      'aclScope' => 'ACL Scope',
      'onlyAdmin' => 'Only for Admin',
      'enableForm' => 'Enable Form',
      'rowActionItems' => 'Row Action Items',
      'buttonsPosition' => 'Buttons Position (Add & Select)',
      'enableSelect' => 'Enable Select Button',
      'enableAdd' => 'Enable Add Row Button',
      'enableCreateInModal' => 'Enable Create In Modal Button',
      'enableAddMultiple' => 'Enable Add Multiple Button',
      'footerSumFields' => 'Footer Sum Fields',
      'footerSumFieldsMap' => 'Footer Sum Fields Map',
      'middleLink' => 'Middle Link (Act As Middle Entity)',
      'isMiddleLinkUnique' => 'Is Middle Link Unique',
      'layout' => 'Detail Layout',
      'editLayout' => 'Edit Layout',
      'customLayout' => 'Custom Layout',
      'editLayoutLink' => 'Custom Edit Layout',
      'readOnlyFields' => 'Readonly Fields',
      'noEditAccessRequiredForUnLink' => 'No Child Edit Access Required for Link/Unlink',
      'copyFields' => 'Copy Fields',
      'orderBy' => 'Order By',
      'useAutoincrement' => 'Auto-Increment',
      'copyFieldList' => 'Fields to Copy'
    ],
    'strings' => [
      'rebuildRequired' => 'Reconstrução é necessária'
    ],
    'messages' => [
      'cacheIsDisabled' => 'Cache is disabled, the application will run slow. Enable cache in the [settings](#Admin/settings).',
      'formulaFunctions' => 'Mais funções podem ser encontradas em [documentação]({documentationUrl}).',
      'rebuildRequired' => 'Você precisa executar a reconstrução da CLI.',
      'upgradeVersion' => 'TD SYNNEX será atualizado para a versão **{version}**. Seja paciente, pois isso pode demorar um pouco.',
      'upgradeDone' => 'TD SYNNEX foi atualizado para a versão **{version}**.',
      'upgradeBackup' => 'Nós recomendamos que você faça um backup dos arquivos e dados do TD SYNNEX antes de atualizar.',
      'thousandSeparatorEqualsDecimalMark' => 'O separador de milhar não pode ser o mesmo do separador decimal',
      'userHasNoEmailAddress' => 'Usuário não possui endereço de e-mail.',
      'selectEntityType' => 'Escolha o tipo de entidade no menu a esquerda.',
      'selectUpgradePackage' => 'Selecione o pacote de atualização',
      'downloadUpgradePackage' => 'Baixe o(s) pacote(s) de atualização [aqui]({url}).',
      'selectLayout' => 'Selecione o layout necessário no meu a esquerda e edite ele.',
      'selectExtensionPackage' => 'Selecione o pacote de extensão',
      'extensionInstalled' => 'A extensão {name} {version} foi instalada.',
      'installExtension' => 'A extensão {name} {version} está pronta para instalação.',
      'cronIsDisabled' => 'Cron is disabled, the application is not fully functional. Enable cron in the [settings](#Admin/settings).',
      'cronIsNotConfigured' => 'Os trabalhos agendados não estão em execução. Portanto, e-mails de entrada, notificações e lembretes não estão funcionando. Siga as [instruções](https://www.espocrm.com/documentation/administration/server-configuration/#user-content-setup-a-crontab) para configurar o cron job.',
      'newVersionIsAvailable' => 'A nova versão do TD SYNNEX {latestVersion} está disponível. Siga as [instruções](https://www.espocrm.com/documentation/administration/upgrading/) para atualizar sua instância.',
      'newExtensionVersionIsAvailable' => 'A nova versão de {extensionName} {latestVersion} está disponível.',
      'uninstallConfirmation' => 'Tem certeza de que deseja desinstalar a extensão?',
      'upgradeInfo' => 'Verifique a [documentação]({url}) sobre como atualizar sua instância TD SYNNEX.',
      'upgradeRecommendation' => 'Esta forma de atualização não é recomendada. É melhor atualizar do CLI.',
      'newAdvancedPackVersionIsAvailable' => 'New Advanced Pack version {latestVersion} is available. It can be downloaded on the customer portal.'
    ],
    'descriptions' => [
      'settings' => 'Configurações gerais do aplicativo.',
      'scheduledJob' => 'Tarefas agendadas que serão executadas pelo cron.',
      'jobs' => 'Trabalhos executam tarefas em segundo plano.',
      'upgrade' => 'Atualizar o TD SYNNEX.',
      'clearCache' => 'Limpar todo o cache do backend.',
      'rebuild' => 'Reconstruir o backend e limpar o cache.',
      'users' => 'Manutenção de usuários.',
      'teams' => 'Manutenção de Times.',
      'roles' => 'Manutenção de Regras.',
      'portals' => 'Gerenciar Portais.',
      'portalRoles' => 'Regras para portal.',
      'portalUsers' => 'Usuários do portal.',
      'outboundEmails' => 'Configuração SMTP para envio de e-mails.',
      'groupEmailAccounts' => 'Agrupe contas de email IMAP. Importação de email e Email-to-Case.',
      'personalEmailAccounts' => 'Contas de email de usuários.',
      'emailTemplates' => 'Templates para envio de e-mails.',
      'import' => 'Importar dados de arquivo CSV.',
      'layoutManager' => 'Personalizar layouts (listas, detalhes, edição, busca, atualização em massa).',
      'entityManager' => 'Crie e edite entidades personalizadas. Gerencie campos e relacionamentos.',
      'userInterface' => 'Configurar a interface gráfica.',
      'authTokens' => 'Sessões autenticadas ativas. Endereço de IP e última data de acesso.',
      'authentication' => 'Configurações de autenticação.',
      'currency' => 'Configurações de moeda e taxas.',
      'extensions' => 'Instalar ou desinstalar extensões.',
      'integrations' => 'Integração com serviços de terceiros.',
      'notifications' => 'Configurações de notificações "in-app" e e-mail.',
      'inboundEmails' => 'Grupo de contas de e-mail IMAP. Importação de e-mail Email-to-Case.',
      'emailFilters' => 'As mensagens de email que correspondem ao filtro especificado não serão importadas.',
      'groupEmailFolders' => 'Email folders shared for teams.',
      'actionHistory' => 'Log de ações do usuário.',
      'labelManager' => 'Personalizar os rótulos da aplicação.',
      'templateManager' => 'Personalizar os modelos de mensagens.',
      'authLog' => 'Histórico de Login.',
      'appLog' => 'Application log.',
      'appSecrets' => 'Store sensitive information like API keys, passwords, and other secrets.',
      'leadCapture' => 'Pontos de entrada da API para Web-to-Lead.',
      'attachments' => 'Todos os anexos de arquivo armazenados no sistema.',
      'systemRequirements' => 'Requisitos de sistema para TD SYNNEX',
      'apiUsers' => 'Separe os usuários para fins de integração.',
      'webhooks' => 'Gerenciar webhooks.',
      'authenticationProviders' => 'Additional authentication providers for portals.',
      'emailAddresses' => 'Todos os endereços de email armazenados no sistema.',
      'phoneNumbers' => 'Todos os números de telefone armazenados no sistema.',
      'dashboardTemplates' => 'Implante painéis para usuários.',
      'layoutSets' => 'Coleções de layouts que podem ser atribuídos a times e portais.',
      'workingTimeCalendars' => 'Working schedule.',
      'jobsSettings' => 'Configurações de processamento de trabalho. Os trabalhos executam tarefas em segundo plano.',
      'sms' => 'Configurações de SMS.',
      'pdfTemplates' => 'Modelos para impressão em PDF.',
      'formulaSandbox' => 'Escreva e teste scripts de fórmula.',
      'addressCountries' => 'Countries available for address fields.',
      'workflowManager' => 'Configure Workflow rules.',
      'bpmnFlowcharts' => 'Definitions of business processes.',
      'bpmnProcesses' => 'Instances of business processes.',
      'reportFilters' => 'Custom list view filters based on reports.',
      'reportPanels' => 'Detail view panels showing report results.',
      'salesPackSettings' => 'Parameters for sales & purchase functionality.',
      'priceRuleConditions' => 'Formula conditions for price rules.'
    ],
    'keywords' => [
      'settings' => 'sistema',
      'userInterface' => 'ui,tema,guias,logotipo,painel',
      'authentication' => 'senha,segurança,ldap',
      'scheduledJob' => 'cron,tarefas (jobs)',
      'integrations' => 'google,mapas,google maps',
      'authLog' => 'log,histórico',
      'authTokens' => 'histórico,acesso,log',
      'entityManager' => 'campos,relações,relacionamentos',
      'templateManager' => 'notificações',
      'jobs' => 'cron',
      'labelManager' => 'language,translation',
      'appSecrets' => 'key,keys,password',
      'leadCapture' => 'web forms',
      'bpmnFlowcharts' => 'bpm',
      'bpmnProcesses' => 'bpm',
      'salesPack' => 'price,price book,price books'
    ],
    'options' => [
      'previewSize' => [
        '' => 'Padrão',
        'x-small' => 'Mínimo',
        'small' => 'Pequeno',
        'medium' => 'Médio',
        'large' => 'Grande'
      ],
      'labelType' => [
        'state' => 'State',
        'regular' => 'Regular'
      ],
      'order' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ],
      'buttonsPosition' => [
        'top' => 'Top',
        'bottom' => 'Bottom'
      ],
      'rowActionItems' => [
        'edit' => 'Edit',
        'view' => 'View',
        'remove' => 'Remove',
        'unlink' => 'Unlink'
      ]
    ],
    'logicalOperators' => [
      'and' => 'E',
      'or' => 'OU',
      'not' => 'NÃO'
    ],
    'systemRequirements' => [
      'requiredPhpVersion' => 'Versão do PHP',
      'requiredMysqlVersion' => 'Versão do MySQL',
      'requiredMariadbVersion' => 'Versão MariaDB',
      'requiredPostgresqlVersion' => 'PostgreSQL version',
      'host' => 'Nome de anfitrião',
      'dbname' => 'Nome do banco de dados',
      'user' => 'Nome de Usuário',
      'writable' => 'Permite Gravação',
      'readable' => 'Permite Leitura'
    ],
    'templates' => [
      'twoFactorCode' => 'Código 2FA',
      'accessInfo' => 'Informações de acesso',
      'accessInfoPortal' => 'Informações de Acesso para Portais',
      'assignment' => 'Assignment',
      'mention' => 'Menção',
      'noteEmailReceived' => 'Nota sobre Email Recebido',
      'notePost' => 'Nota sobre a Postagem',
      'notePostNoParent' => 'Nota sobre a Postagem (sem Pai)',
      'noteStatus' => 'Nota sobre a Atualização de Status',
      'passwordChangeLink' => 'Link para alteração de senha',
      'invitation' => 'Convite',
      'cancellation' => 'Cancellation',
      'reminder' => 'Lembrete',
      'reportSendingGrid1' => 'Report Grid-1',
      'reportSendingGrid2' => 'Report Grid-2',
      'reportSendingList' => 'Report List',
      'salesEmailPdf' => 'Email PDF (Sales)'
    ]
  ],
  'ApiUser' => [
    'labels' => [
      'Create ApiUser' => 'Criar API de usuário'
    ]
  ],
  'AppLogRecord' => [
    'fields' => [
      'message' => 'Message',
      'code' => 'Code',
      'level' => 'Level',
      'exceptionClass' => 'Exception Class',
      'file' => 'File',
      'line' => 'Line',
      'requestMethod' => 'Request Method',
      'requestResourcePath' => 'Request Resource Path'
    ],
    'presetFilters' => [
      'errors' => 'Errors'
    ]
  ],
  'AppSecret' => [
    'labels' => [
      'Create AppSecret' => 'Create Secret'
    ],
    'fields' => [
      'value' => 'Value'
    ],
    'tooltips' => [
      'name' => 'Allowed characters:
* `[a-z]`
* `[A-Z]`
* `[0-9]`
* `_`'
    ]
  ],
  'Attachment' => [
    'fields' => [
      'role' => 'Regra',
      'related' => 'Related',
      'file' => 'Arquivo',
      'type' => 'Tipo',
      'field' => 'Campo',
      'sourceId' => 'Source ID',
      'storage' => 'Armazenamento',
      'size' => 'Tam. (bytes)',
      'isBeingUploaded' => 'Is Being Uploaded'
    ],
    'options' => [
      'role' => [
        'Attachment' => 'Anexo',
        'Inline Attachment' => 'Anexo Inline',
        'Import File' => 'Importar Arquivo',
        'Export File' => 'Exportar Arquivo',
        'Mail Merge' => 'Mala Direta',
        'Mass Pdf' => 'PDF em Massa'
      ]
    ],
    'insertFromSourceLabels' => [
      'Document' => 'Inserir Documento'
    ],
    'presetFilters' => [
      'orphan' => 'Órfão'
    ]
  ],
  'AuthLogRecord' => [
    'fields' => [
      'username' => 'Username',
      'ipAddress' => 'Endereço IP',
      'requestTime' => 'Hora da Solicitação',
      'createdAt' => 'Requisitado Em',
      'isDenied' => 'Negado',
      'denialReason' => 'Motivo da Negação',
      'portal' => 'Portal',
      'user' => 'Usuário',
      'authToken' => 'Token de autenticação criado',
      'requestUrl' => 'URL de Solicitação',
      'requestMethod' => 'Método de Requisição',
      'authTokenIsActive' => 'Token de Autenticação está Ativo',
      'authenticationMethod' => 'Método de autenticação'
    ],
    'links' => [
      'authToken' => 'Token de Autenticação Criado',
      'user' => 'Usuário',
      'portal' => 'Portal',
      'actionHistoryRecords' => 'Histórico de Ações'
    ],
    'presetFilters' => [
      'denied' => 'Negado',
      'accepted' => 'Aceito'
    ],
    'options' => [
      'denialReason' => [
        'CREDENTIALS' => 'Credenciais inválidas',
        'WRONG_CODE' => 'Wrong code',
        'INACTIVE_USER' => 'Usuário inativo',
        'IS_PORTAL_USER' => 'Usuário do Portal',
        'IS_NOT_PORTAL_USER' => 'Não um Usuário do Portal',
        'USER_IS_NOT_IN_PORTAL' => 'Usuário não está relacionado ao portal',
        'IS_SYSTEM_USER' => 'Is system user',
        'FORBIDDEN' => 'Forbidden'
      ]
    ]
  ],
  'AuthToken' => [
    'fields' => [
      'user' => 'Usuário',
      'ipAddress' => 'Endereço de IP',
      'lastAccess' => 'Último acesso',
      'createdAt' => 'Data do login',
      'isActive' => 'Está Ativo',
      'portal' => 'Portal'
    ],
    'links' => [
      'actionHistoryRecords' => 'Histórico de Ações'
    ],
    'presetFilters' => [
      'active' => 'Ativo',
      'inactive' => 'Inativo'
    ],
    'labels' => [
      'Set Inactive' => 'Definir Inativo'
    ],
    'massActions' => [
      'setInactive' => 'Definir Inativo'
    ]
  ],
  'AuthenticationProvider' => [
    'fields' => [
      'method' => 'Method'
    ],
    'labels' => [
      'Create AuthenticationProvider' => 'Create Provider'
    ]
  ],
  'Currency' => [
    'names' => [
      'AED' => 'Dirham dos Emirados Árabes Unidos',
      'AFN' => 'Afegane Afegão',
      'ALL' => 'Lek Albanês',
      'AMD' => 'Dram Armênio',
      'ANG' => 'Guilder das Antilhas Holandesas',
      'AOA' => 'Kwanza Angolano',
      'ARS' => 'Peso Argentino',
      'AUD' => 'Dólar Australiano',
      'AWG' => 'Florim Arubano',
      'AZN' => 'Manat Azerbaijano',
      'BAM' => 'Marco Conversível da Bósnia-Herzegovina',
      'BBD' => 'Dólar Barbadence',
      'BDT' => 'Taka Bengali',
      'BGN' => 'Lev Búlgaro',
      'BHD' => 'Dinar Bareinita',
      'BIF' => 'Franco Burundinese',
      'BMD' => 'Dólar Bermudense',
      'BND' => 'Dólar Bruneano',
      'BOB' => 'Boliviano da Bolívia',
      'BOV' => 'Mvdol Boliviano',
      'BRL' => 'Real Brasileiro',
      'BSD' => 'Dólar Bahamense',
      'BTN' => 'Ngultrum Butanês',
      'BWP' => 'Pula Botsuanesa',
      'BYN' => 'Rublo Bielorrusso',
      'BZD' => 'Dólar Belizenho',
      'CAD' => 'Dólar Canadense',
      'CDF' => 'Franco Congolês',
      'CHE' => 'WIR Euro',
      'CHF' => 'Franco Suíço',
      'CHW' => 'WIR Franc',
      'CLF' => 'Chilean Unit of Account (UF)',
      'CLP' => 'Peso Chileno',
      'CNH' => 'Yuan Chinês (offshore)',
      'CNY' => 'Yuan Chinês',
      'COP' => 'Peso Colombiano',
      'COU' => 'Unidade de Valor Real Colombiano',
      'CRC' => 'Costa Costarriquenho',
      'CUC' => 'Peso Cubano Conversível',
      'CUP' => 'Peso Cubano',
      'CVE' => 'Escudo Cabo-verdiano',
      'CZK' => 'Coroa Tcheca',
      'DJF' => 'Franco do Djibouti',
      'DKK' => 'Coroa Dinamarquesa',
      'DOP' => 'Peso Dominicano',
      'DZD' => 'Dinar Argelino',
      'EGP' => 'Libra Egípicia',
      'ERN' => 'Nakfa da Eritreia',
      'ETB' => 'Birr Etíope',
      'EUR' => 'Euro',
      'FJD' => 'Dólar Figiano',
      'FKP' => 'Libra das Ilhas Malvinas',
      'GBP' => 'Libra Esterlina',
      'GEL' => 'Lari Georgiano',
      'GHS' => 'Cedi Ganês',
      'GIP' => 'Libra de Gibraltar',
      'GMD' => 'Dalasi Gambiano',
      'GNF' => 'Franco Guineano',
      'GTQ' => 'Quetzal Guatemalteco',
      'GYD' => 'Dólar Guianense',
      'HKD' => 'Dólar de Hong Kong',
      'HNL' => 'Lempira Hondurenha',
      'HRK' => 'Kuna Kroata',
      'HTG' => 'Gourde Haitiano',
      'HUF' => 'Florim Húngaro',
      'IDR' => 'Rupia Indonésia',
      'ILS' => 'Novo Shekel Israelense',
      'INR' => 'Rupia Indiana',
      'IQD' => 'Dinar Iraquiano',
      'IRR' => 'Rial Iraniano',
      'ISK' => 'Coroa Islandesa',
      'JMD' => 'Dólar Jamaicano',
      'JOD' => 'Dinar Jordaniano',
      'JPY' => 'Yen Japonês',
      'KES' => 'Xelim Queniano',
      'KGS' => 'Som Quirguiz',
      'KHR' => 'Riel Cambojano',
      'KMF' => 'Franco Comoriano',
      'KPW' => 'Won Norte-Coreano',
      'KRW' => 'Won Sul-Coreano',
      'KWD' => 'Dinar Kuwaitiano',
      'KYD' => 'Dólar das Ilhas Cayman',
      'KZT' => 'Tenge Cazaque',
      'LAK' => 'Kip Laosiano',
      'LBP' => 'Libra Libanesa',
      'LKR' => 'Rupia do Sri Lanka',
      'LRD' => 'Dólar Liberiano',
      'LSL' => 'Loti Lesotiano',
      'LYD' => 'Dinar Líbio',
      'MAD' => 'Dirham Marroquino',
      'MDL' => 'Leu Moldávio',
      'MGA' => 'Ariary Malgaxe',
      'MKD' => 'Dinar Macedônio',
      'MMK' => 'Kyat de Mianmar',
      'MNT' => 'Tugrik da Mongólia',
      'MOP' => 'Pataca Macaense',
      'MRO' => 'Mauritanian Ouguiya',
      'MUR' => 'Rupia Mauriciana',
      'MWK' => 'Kwacha do Malawi',
      'MXN' => 'Peso Mexicano',
      'MXV' => 'Unidade de Investimento Mexicana',
      'MYR' => 'Ringgit Malaio',
      'MZN' => 'Metical Moçambicano',
      'NAD' => 'Dólar Namibiano',
      'NGN' => 'Naira Nigeriana',
      'NIO' => 'Córdoba da Nicarágua',
      'NOK' => 'Coroa Norueguesa',
      'NPR' => 'Rupia Nepalesa',
      'NZD' => 'Dólar da Nova Zelândia',
      'OMR' => 'Rial de Omã',
      'PAB' => 'Balboa Panamenho',
      'PEN' => 'Sol Peruano',
      'PGK' => 'Papua Nova Guiné Kina',
      'PHP' => 'Piso Filipino',
      'PKR' => 'Rupia Paquistanesa',
      'PLN' => 'Zloty Polonês',
      'PYG' => 'Guarani Paraguaio',
      'QAR' => 'Rial Catarense',
      'RON' => 'Leu Romeno',
      'RSD' => 'Dinar Sérvio',
      'RUB' => 'Rublo Russo',
      'RWF' => 'Franco Ruandês',
      'SAR' => 'Rial Saudita',
      'SBD' => 'Dólar das Ilhas Salomão',
      'SCR' => 'Rúpia Seichelense',
      'SDG' => 'Libra Sudanesa',
      'SEK' => 'Coroa Sueca',
      'SGD' => 'Dólar de Singapura',
      'SHP' => 'Libra de Santa Helena',
      'SLL' => 'Leone de Serra Leoa',
      'SOS' => 'Xelim da Somália',
      'SRD' => 'Dólar do Suriname',
      'SSP' => 'Libra Sul-Sudanesa',
      'STN' => 'São Tomé e Príncipe Dobra (2018)',
      'SYP' => 'Libra Síria',
      'SZL' => 'Suazi Lilangeni',
      'SVC' => 'Colón Salvadorenho',
      'THB' => 'Baht Tailandês',
      'TJS' => 'Tajiquistão Somoni',
      'TND' => 'Dinar Tunisiano',
      'TOP' => 'Tonga Pa\'anga',
      'TRY' => 'Lira Turca',
      'TTD' => 'Dólar de Trinidad e Tobago',
      'TWD' => 'Novo Dólar Taiwanês',
      'TZS' => 'Xelim da Tanzânia',
      'UAH' => 'Hryvnia Ucraniano',
      'UGX' => 'Xelim de Uganda',
      'USD' => 'Dólar Americano',
      'USN' => 'Dólar Americano (Dia seguinte)',
      'UYI' => 'Peso Uruguaio (Unidades Indexadas)',
      'UYU' => 'Peso Uruguaio',
      'UZS' => 'Som do Uzbequistão',
      'VEF' => 'Bolívar Venezuelano',
      'VND' => 'Dong Vietnamita',
      'VUV' => 'Vanuatu Vatu',
      'WST' => 'Tala Samoano',
      'XAF' => 'Franco CFA da África Central',
      'XCD' => 'Dólar do Caribe Oriental',
      'XOF' => 'Franco CFA da África Ocidental',
      'XPF' => 'Franco CFP',
      'YER' => 'Rial Iemenita',
      'ZAR' => 'Rand Sul-Africano',
      'ZMW' => 'Kwacha da Zâmbia',
      'ZWL' => 'Dólar do Zimbábue'
    ]
  ],
  'DashboardTemplate' => [
    'fields' => [
      'layout' => 'Layout',
      'append' => 'Append (don\'t remove user\'s tabs)'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardTemplate' => 'Criar Modelo',
      'Deploy to Users' => 'Distribuir para Usuários',
      'Deploy to Team' => 'Distribuir para o Time'
    ]
  ],
  'DashletOptions' => [
    'fields' => [
      'title' => 'Título',
      'dateFrom' => 'Desde',
      'dateTo' => 'Até a data',
      'autorefreshInterval' => 'Intervalo para auto-atualização',
      'displayRecords' => 'Exibir Registros',
      'isDoubleHeight' => 'Altura 2x',
      'mode' => 'Modo',
      'enabledScopeList' => 'O que exibir',
      'users' => 'Usuários',
      'entityType' => 'Tipo da Entidade',
      'primaryFilter' => 'Filtro Primário',
      'boolFilterList' => 'Filtros Adicionais',
      'sortBy' => 'Ordem (campo)',
      'sortDirection' => 'Ordem (direção)',
      'expandedLayout' => 'Layout',
      'skipOwn' => 'Não mostrar os próprios registros',
      'url' => 'URL',
      'dateFilter' => 'Filtro por Data',
      'text' => 'Text',
      'folder' => 'Folder',
      'includeShared' => 'Include Shared',
      'team' => 'Time',
      'futureDays' => 'Próximos X Dias',
      'useLastStage' => 'Agrupar por último estágio alcançado',
      'report' => 'Report',
      'column' => 'Summation Column',
      'displayOnlyCount' => 'Display Only Total',
      'displayTotal' => 'Display Total',
      'useSiMultiplier' => 'SI Multiplier',
      'displayType' => 'What to display'
    ],
    'options' => [
      'mode' => [
        'agendaWeek' => 'Semana (agenda)',
        'basicWeek' => 'Semana',
        'month' => 'Mês',
        'basicDay' => 'Dia',
        'agendaDay' => 'Dia (agenda)',
        'timeline' => 'Linha do Tempo'
      ],
      'sortDirection' => [
        'asc' => 'Ascending',
        'desc' => 'Descending'
      ]
    ],
    'messages' => [
      'selectEntityType' => 'Selecione Tipo de Entidade nas opções do painel.'
    ],
    'tooltips' => [
      'skipOwn' => 'As ações feitas pela sua conta de usuário não serão exibidas.'
    ]
  ],
  'DynamicLogic' => [
    'labels' => [
      'Field' => 'Campo'
    ],
    'options' => [
      'operators' => [
        'equals' => 'Igual',
        'notEquals' => 'Não igual',
        'greaterThan' => 'Maior que',
        'lessThan' => 'Menor que',
        'greaterThanOrEquals' => 'Maior que ou Igual',
        'lessThanOrEquals' => 'Menor ou igual',
        'in' => 'Em',
        'notIn' => 'Não em',
        'inPast' => 'No passado',
        'inFuture' => 'É Futuro',
        'isToday' => 'É Hoje',
        'isTrue' => 'É verdadeiro',
        'isFalse' => 'É falso',
        'isEmpty' => 'É vazio',
        'isNotEmpty' => 'Não Está Vazio',
        'contains' => 'Contém',
        'notContains' => 'Não contém',
        'has' => 'Contém',
        'notHas' => 'Não contém',
        'startsWith' => 'Começa Com',
        'endsWith' => 'Termina Com',
        'matches' => 'Correspondências (regex)'
      ]
    ]
  ],
  'Email' => [
    'fields' => [
      'name' => 'Assunto',
      'parent' => 'Origem',
      'status' => 'Status',
      'dateSent' => 'Data do envio',
      'from' => 'De',
      'to' => 'Para',
      'cc' => 'CC',
      'bcc' => 'BCC',
      'replyTo' => 'Responder Para',
      'replyToString' => 'Responder Para (String)',
      'personStringData' => 'Dados do String da Pessoa',
      'isHtml' => 'Html',
      'body' => 'Corpo',
      'bodyPlain' => 'Corpo (Plano)',
      'subject' => 'Assunto',
      'attachments' => 'Anexos',
      'selectTemplate' => 'Escolher Template',
      'fromEmailAddress' => 'Do Endereço (link)',
      'emailAddress' => 'Endereço de E-mail',
      'deliveryDate' => 'Data de envio',
      'account' => 'Conta',
      'users' => 'Usuários',
      'replied' => 'Respondido',
      'replies' => 'Respostas',
      'isRead' => 'Está lido',
      'isNotRead' => 'Não está lido',
      'isImportant' => 'É importante',
      'isReplied' => 'Foi Respondido',
      'isNotReplied' => 'Não Foi Respondido',
      'isUsers' => 'É usuário',
      'isUsersSent' => 'Is User\'s Sent',
      'inTrash' => 'Na Lixeira',
      'inArchive' => 'In Archive',
      'folder' => 'Pasta',
      'inboundEmails' => 'Contas de Grupo',
      'emailAccounts' => 'Contas Pessoais',
      'hasAttachment' => 'Tem anexo',
      'assignedUsers' => 'Usuários Designados',
      'sentBy' => 'Enviado Por',
      'toEmailAddresses' => 'To EmailAddresses',
      'ccEmailAddresses' => 'Endereços de email CC',
      'bccEmailAddresses' => 'BCC EmailAddresses',
      'replyToEmailAddresses' => 'Reply-To EmailAddresses',
      'messageId' => 'Id da Mensagem',
      'messageIdInternal' => 'Id da Mensagem (Interno)',
      'folderId' => 'Id da Pasta',
      'folderString' => 'Folder',
      'fromName' => 'Do Nome',
      'fromString' => 'Do String',
      'fromAddress' => 'E-mail do rementente',
      'replyToName' => 'Reply-To Name',
      'replyToAddress' => 'Reply-To Address',
      'isSystem' => 'É Sistema',
      'icsContents' => 'ICS Contents',
      'icsEventData' => 'ICS Event Data',
      'icsEventUid' => 'ICS Event UID',
      'createdEvent' => 'Evento criado',
      'event' => 'Evento',
      'icsEventDateStart' => 'Data de Início do Evento ICS',
      'groupFolder' => 'Group Folder',
      'groupStatusFolder' => 'Group Status Folder',
      'sendAt' => 'Send At',
      'tasks' => 'Tarefas',
      'emailContent' => 'Email Content'
    ],
    'links' => [
      'replied' => 'Respondido',
      'replies' => 'Respostas',
      'inboundEmails' => 'Contas de Grupo',
      'emailAccounts' => 'Contas Pessoais',
      'assignedUsers' => 'Usuários Designados',
      'sentBy' => 'Enviado Por',
      'attachments' => 'Anexos',
      'fromEmailAddress' => 'Do Endereço de Email',
      'toEmailAddresses' => 'To Email Addresses',
      'ccEmailAddresses' => 'CC Email Addresses',
      'bccEmailAddresses' => 'BCC Email Addresses',
      'replyToEmailAddresses' => 'Reply-To Email Addresses',
      'createdEvent' => 'Created Event',
      'groupFolder' => 'Group Folder',
      'emailContent' => 'Email Content'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Rascunho',
        'Sending' => 'Enviando',
        'Sent' => 'Enviado',
        'Archived' => 'Arquivado',
        'Received' => 'Recebido',
        'Failed' => 'Falhado'
      ],
      'groupStatusFolder' => [
        'Archive' => 'Archive',
        'Trash' => 'Trash'
      ]
    ],
    'labels' => [
      'Create Email' => 'Arquivar e-mail',
      'Archive Email' => 'Arquivar e-mail',
      'Import EML' => 'Import EML',
      'Compose' => 'Compor',
      'Reply' => 'Responder',
      'Reply to All' => 'Responder a Todos',
      'Forward' => 'Encaminhar',
      'Insert Field' => 'Inserir Campo',
      'Original message' => 'Mensagem original',
      'Forwarded message' => 'Mensagem encaminhada',
      'Email Accounts' => 'Contas de e-mail',
      'Inbound Emails' => 'Agrupar contas de e-mail',
      'Email Templates' => 'Templates de email',
      'Send Test Email' => 'Enviar e-mail de teste',
      'Send' => 'Enviar',
      'Email Address' => 'Endereço de E-mail',
      'Mark Read' => 'Marcar como lido',
      'Sending...' => 'Enviando...',
      'Save Draft' => 'Salvar rascunho',
      'Mark all as read' => 'Marcar tudo como lido',
      'Show Plain Text' => 'Exibir em texto puro',
      'Mark as Important' => 'Marcar como Importante',
      'Unmark Importance' => 'Desmarcar Importância',
      'Move to Trash' => 'Mover para a Lixeira',
      'Retrieve from Trash' => 'Recuperar da lixeira',
      'Move to Folder' => 'Mover para Pasta',
      'Moved to Archive' => 'Moved to Archive',
      'No Records Moved' => 'No Records Moved',
      'Filters' => 'Filtros',
      'Folders' => 'Pastas',
      'Group Folders' => 'Group Folders',
      'No Subject' => 'Sem Assunto',
      'View Users' => 'Visualizar Usuários',
      'Event' => 'Evento',
      'View Attachments' => 'View Attachments',
      'Moved to Trash' => 'Moved to Trash',
      'Retrieved from Trash' => 'Retrieved from Trash',
      'Schedule Send' => 'Schedule Send',
      'Create Lead' => 'Criar lead',
      'Create Contact' => 'Criar contato',
      'Add to Contact' => 'Adicionar ao Contato',
      'Add to Lead' => 'Adicionar ao Lead',
      'Create Task' => 'Criar Tarefa',
      'Create Case' => 'Criar caso'
    ],
    'strings' => [
      'sendingFailed' => 'Falha no envio de email',
      'group' => 'Group'
    ],
    'messages' => [
      'confirmSend' => 'Send the email?',
      'couldNotSentScheduledEmail' => 'Could not send scheduled [email]({link})',
      'notEditAccess' => 'No edit access to email.',
      'groupFolderNoAccess' => 'No access to group folder.',
      'groupMoveOutNoEditAccess' => 'Cannot move out from group folder. No edit access to email.',
      'groupMoveToNoEditAccess' => 'Cannot move to group folder. No edit access to email.',
      'groupMoveToTrashNoEditAccess' => 'Cannot move email from group folder to trash. No edit access to email.',
      'groupMoveToArchiveNoEditAccess' => 'Cannot move from group folder to Archive. No edit access to email.',
      'alreadyImported' => 'The [email]({link}) already exists in the system.',
      'invalidCredentials' => 'Invalid credentials.',
      'unknownError' => 'Unknown error.',
      'recipientAddressRejected' => 'Recipient address rejected.',
      'noSmtpSetup' => 'SMTP não está configurado: {link}',
      'testEmailSent' => 'O e-mail de teste enviado',
      'emailSent' => 'O e-mail foi enviado',
      'savedAsDraft' => 'Salvar como rascunho',
      'sendConfirm' => 'Enviar o e-mail?',
      'removeSelectedRecordsConfirmation' => 'Tem certeza de que deseja remover os emails selecionados?

Eles serão removidos para outros usuários também.',
      'removeRecordConfirmation' => 'Tem certeza de que deseja remover o email?

Ele será removido para outros usuários também.',
      'confirmInsertTemplate' => 'O corpo do e-mail será perdido. Tem certeza de que deseja inserir o modelo?'
    ],
    'presetFilters' => [
      'sent' => 'Enviado',
      'archived' => 'Arquivado',
      'inbox' => 'Caixa de entrada',
      'drafts' => 'Rascunhos',
      'trash' => 'Lixo',
      'archive' => 'Archive',
      'important' => 'Importante'
    ],
    'actions' => [
      'moveToArchive' => 'Archive'
    ],
    'massActions' => [
      'markAsRead' => 'Marcar como lido',
      'markAsNotRead' => 'Marcar como não lido',
      'markAsImportant' => 'Marcar como importante',
      'markAsNotImportant' => 'Desmarcar destaque',
      'moveToTrash' => 'Mover para lixeira',
      'moveToFolder' => 'Mover para Pasta',
      'moveToArchive' => 'Archive',
      'retrieveFromTrash' => 'Recuperar da Lixeira'
    ],
    'otherFields' => [
      'file' => 'File'
    ]
  ],
  'EmailAccount' => [
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'host' => 'Host',
      'username' => 'Usuário',
      'password' => 'Senha',
      'port' => 'Porta',
      'monitoredFolders' => 'Pastas monitoradas',
      'security' => 'Segurança',
      'fetchSince' => 'Recuperar desde',
      'emailAddress' => 'Endereço de E-mail',
      'sentFolder' => 'Enviar pasta',
      'storeSentEmails' => 'Armazenar emails enviados',
      'keepFetchedEmailsUnread' => 'Manter e-mails buscados como não lidos',
      'emailFolder' => 'Colocar na Pasta',
      'connectedAt' => 'Connected At',
      'useImap' => 'Buscar emails',
      'useSmtp' => 'Usar SMTP',
      'smtpHost' => 'Host SMTP',
      'smtpPort' => 'Porta SMTP',
      'smtpAuth' => 'Autenticação SMTP',
      'smtpSecurity' => 'Segurança SMTP',
      'smtpAuthMechanism' => 'Mecanismo de Autenticação SMTP',
      'smtpUsername' => 'Usuário SMTP',
      'smtpPassword' => 'Senha SMTP'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Emails'
    ],
    'options' => [
      'status' => [
        'Active' => 'Ativa',
        'Inactive' => 'Inativa'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create EmailAccount' => 'Criar conta de e-mail',
      'IMAP' => 'IMAP',
      'Main' => 'Principal',
      'Test Connection' => 'Testar conexão',
      'Send Test Email' => 'Enviar Email de Teste',
      'SMTP' => 'SMTP'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'Não foi possível conectar ao servidor IMAP',
      'connectionIsOk' => 'Conexão está OK',
      'imapNotConnected' => 'Could not connect to [IMAP account](#EmailAccount/view/{id}).'
    ],
    'tooltips' => [
      'useSmtp' => 'A capacidade de enviar emails.',
      'emailAddress' => 'O registro do usuário (usuário designado) deve ter o mesmo endereço de email para poder usar esta conta de email para envio.',
      'monitoredFolders' => 'Várias pastas devem ser separadas por vírgula.

Você pode adicionar uma pasta \'Enviados\' para sincronizar emails enviados de um cliente de email externo.',
      'storeSentEmails' => 'Os emails enviados serão armazenados no servidor IMAP. O campo Endereço de email deve corresponder ao endereço de onde os emails serão enviados.'
    ]
  ],
  'EmailAddress' => [
    'labels' => [
      'Primary' => 'Primário',
      'Opted Out' => 'Cancelou (opt-out)',
      'Invalid' => 'Inválido'
    ],
    'fields' => [
      'optOut' => 'Cancelado',
      'invalid' => 'Inválido'
    ],
    'presetFilters' => [
      'orphan' => 'Órfão'
    ]
  ],
  'EmailFilter' => [
    'fields' => [
      'from' => 'De',
      'to' => 'Para',
      'subject' => 'Assunto',
      'bodyContains' => 'Corpo contém',
      'bodyContainsAll' => 'Body Contains All',
      'action' => 'Ação',
      'isGlobal' => 'É Global',
      'emailFolder' => 'Pasta',
      'groupEmailFolder' => 'Group Email Folder',
      'markAsRead' => 'Mark as Read',
      'skipNotification' => 'Skip Notification'
    ],
    'links' => [
      'emailFolder' => 'Folder',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'labels' => [
      'Create EmailFilter' => 'Criar filtro de email',
      'Emails' => 'Emails'
    ],
    'options' => [
      'action' => [
        'None' => 'None',
        'Skip' => 'Ignorar',
        'Move to Folder' => 'Colocar na Pasta',
        'Move to Group Folder' => 'Put in Group Folder'
      ]
    ],
    'tooltips' => [
      'name' => 'Dê ao filtro um nome descritivo.',
      'subject' => 'Use um wildcard *:

* `texto*` – inicia com texto,
* `*texto*` – contém texto,
* `*texto` – termina com texto.',
      'bodyContains' => 'O corpo do e-mail contém qualquer uma das palavras ou frases especificadas.',
      'bodyContainsAll' => 'An email body contains all specified words or phrases.',
      'from' => 'E-mails sendo enviados através das contas especificadas. Deixar em branco se desnecessário. Você pode usar wildcard *.',
      'to' => 'Enviando e-mails através das contas especificadas. Deixar em branco se desnecessário. Você pode usar wildcard *.',
      'isGlobal' => 'Aplica este filtro a todos os emails que chegam ao sistema.'
    ]
  ],
  'EmailFolder' => [
    'fields' => [
      'skipNotifications' => 'Pular notificações'
    ],
    'labels' => [
      'Create EmailFolder' => 'Criar pasta',
      'Manage Folders' => 'Gerenciar Pastas',
      'Emails' => 'Emails'
    ]
  ],
  'EmailTemplate' => [
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'isHtml' => 'Html',
      'body' => 'Conteúdo',
      'subject' => 'Assunto',
      'attachments' => 'Anexos',
      'oneOff' => 'One-off',
      'category' => 'Categorias',
      'insertField' => 'Espaços Reservados'
    ],
    'links' => [],
    'labels' => [
      'Create EmailTemplate' => 'Criar Template de E-mail',
      'Info' => 'Info',
      'Available placeholders' => 'Espaços reservados disponíveis'
    ],
    'messages' => [
      'infoText' => 'Marcadores de posição disponíveis:

{optOutUrl} &#8211; URL para um link de cancelamento de assinatura;

{optOutLink} &#8211; um link de cancelamento de inscrição.'
    ],
    'tooltips' => [
      'oneOff' => 'Verifique se você vai usar este template apenas uma vez. Ex: para e-mail em massa.'
    ],
    'presetFilters' => [
      'actual' => 'Atual'
    ],
    'placeholderTexts' => [
      'today' => 'Data de hoje',
      'now' => 'Data e hora atuais',
      'currentYear' => 'Ano Atual',
      'optOutUrl' => 'URL para um link de cancelamento de assinatura',
      'optOutLink' => 'link de cancelamento de inscrição'
    ]
  ],
  'EmailTemplateCategory' => [
    'labels' => [
      'Create EmailTemplateCategory' => 'Criar categoria',
      'Manage Categories' => 'Gerenciar Categorias',
      'EmailTemplates' => 'Modelos de Email'
    ],
    'fields' => [
      'order' => 'Ordem',
      'childList' => 'Lista Filha'
    ],
    'links' => [
      'emailTemplates' => 'Modelos de Email'
    ]
  ],
  'EntityManager' => [
    'labels' => [
      'Fields' => 'Campos',
      'Relationships' => 'Relacionamentos',
      'Layouts' => 'Layouts',
      'Schedule' => 'Agendamento',
      'Log' => 'Log',
      'Formula' => 'Fórmula',
      'Parameters' => 'Parameters'
    ],
    'fields' => [
      'name' => 'Nome',
      'type' => 'Tipo',
      'labelSingular' => 'Rótulo Singular',
      'labelPlural' => 'Rótulo Plural',
      'stream' => 'Fluxo',
      'label' => 'Rótulo',
      'linkType' => 'Tipo de Link',
      'entity' => 'Entidade',
      'entityForeign' => 'Entidade Estrangeira',
      'linkForeign' => 'Link Estrangeiro',
      'link' => 'Link',
      'labelForeign' => 'Rótulo Estrangeiro',
      'sortBy' => 'Ordem Padrão (campo)',
      'sortDirection' => 'Ordem Padrão (direção)',
      'relationName' => 'Nome Tabela Intermediária',
      'linkMultipleField' => 'Link Multiple Field',
      'linkMultipleFieldForeign' => 'Foreign Link Multiple Field',
      'disabled' => 'Desabilitado',
      'textFilterFields' => 'Campos de Filtro de Texto',
      'audited' => 'Auditado',
      'auditedForeign' => 'Foreign Audited',
      'statusField' => 'Campo de Status',
      'beforeSaveCustomScript' => 'Script Personalizado Antes de Salvar',
      'beforeSaveApiScript' => 'API Before Save Script',
      'color' => 'Cor',
      'kanbanViewMode' => 'Visualização Kanban',
      'kanbanStatusIgnoreList' => 'Grupos ignorados na visualização Kanban',
      'iconClass' => 'Ícone',
      'countDisabled' => 'Desabilitar contagem de registros',
      'fullTextSearch' => 'Pesquisa de Texto Completa',
      'parentEntityTypeList' => 'Tipos de Entidade Pai',
      'foreignLinkEntityTypeList' => 'Chaves estrangeiras',
      'optimisticConcurrencyControl' => 'Controle de concorrência otimista',
      'preserveAuditLog' => 'Preserve Audit Log',
      'updateDuplicateCheck' => 'Duplicate check on update',
      'duplicateCheckFieldList' => 'Duplicate check fields',
      'stars' => 'Stars',
      'layout' => 'Layout',
      'selectFilter' => 'Select Filter',
      'author' => 'Author',
      'module' => 'Module',
      'version' => 'Version',
      'primaryFilters' => 'Primary Filters',
      'assignedUsers' => 'Multiple Assigned Users',
      'collaborators' => 'Collaborators',
      'aclContactLink' => 'ACL Contact Link',
      'aclAccountLink' => 'ACL Account Link',
      'activityStatusList' => 'Activity Statuses',
      'historyStatusList' => 'History Statuses',
      'completedStatusList' => 'Completed Statuses',
      'canceledStatusList' => 'Canceled Statuses',
      'variantSyncFieldList' => 'Variant sync fields',
      'doneStatusList' => 'Done Statuses',
      'softReserveStatusList' => 'Soft Reserve Statuses',
      'reserveStatusList' => 'Reserve Statuses',
      'failedStatusList' => 'Failed Statuses',
      'deliveryRequiredStatusList' => 'Delivery Required Statuses',
      'lockableFieldList' => 'Lock Fields'
    ],
    'options' => [
      'type' => [
        '' => 'Nenhum',
        'Base' => 'Base',
        'Person' => 'Pessoa',
        'CategoryTree' => 'Árvore de Categoria',
        'Event' => 'Evento',
        'BasePlus' => 'Base Plus',
        'Company' => 'Empresa'
      ],
      'linkType' => [
        'manyToMany' => 'Muitos-para-Muitos',
        'oneToMany' => 'Um-para-Muitos',
        'manyToOne' => 'Muitos-para-Um',
        'oneToOneRight' => 'One-to-One Right',
        'oneToOneLeft' => 'One-to-One Left',
        'parentToChildren' => 'Parent-to-Children',
        'childrenToParent' => 'Children-to-Parent'
      ],
      'sortDirection' => [
        'asc' => 'Ascendente',
        'desc' => 'Descentente'
      ],
      'module' => [
        'Custom' => 'Custom'
      ]
    ],
    'messages' => [
      'urlHashCopiedToClipboard' => 'A URL fragment for the *{name}* filter is copied to the clipboard. You can add it to the navbar.',
      'confirmRemoveLink' => 'Are you sure you want to remove the *{link}* relationship?',
      'nameIsAlreadyUsed' => 'Name \'{name}\' is already used.',
      'nameIsNotAllowed' => 'Name \'{name}\' is not allowed.',
      'nameIsTooLong' => 'Name is too long.',
      'confirmRemove' => 'Tem certeza de que deseja remover o tipo de entidade do sistema?',
      'entityCreated' => 'A entidade foi criada',
      'linkAlreadyExists' => 'Conflito: o link já existe.',
      'linkConflict' => 'Conflito de nome: link ou campo com o mesmo nome já existe.',
      'beforeSaveCustomScript' => 'A script called every time before an entity is saved. Use for setting calculated fields.',
      'beforeSaveApiScript' => 'A script called on create and update API requests before an entity is saved. Use for custom validation and duplicate checking.'
    ],
    'tooltips' => [
      'aclContactLink' => 'The link with Contact to use when applying access control for portal users.',
      'aclAccountLink' => 'The link with Account to use when applying access control for portal users.',
      'collaborators' => 'The ability to share records with specific users.',
      'assignedUsers' => 'The ability to assign multiple users to a record.

Note that after enabling the parameter, existing assigned users won\'t be transferred to the new *Assigned Users* field.',
      'duplicateCheckFieldList' => 'Which fields to check when performing checking for duplicates.',
      'updateDuplicateCheck' => 'Perform checking for duplicates when updating a record.',
      'optimisticConcurrencyControl' => 'Evita conflitos de escrita.',
      'preserveAuditLog' => 'Disables cleanup of the audit log. This parameter is applicable only if Stream is disabled. As if Stream is enabled, audit log records are not being deleted.',
      'stars' => 'The ability to star records. Stars can be used by users to bookmark records.',
      'statusField' => 'As atualizações deste campo são registradas no stream.',
      'textFilterFields' => 'Campos usados pela pesquisa de texto.',
      'stream' => 'Se a entidade tem um Stream.',
      'disabled' => 'Verifique se você não precisa dessa entidade em seu sistema.',
      'linkAudited' => 'Criar registro relacionado e vincular com registro existente será registrado no Stream.',
      'linkMultipleField' => 'O campo Link Múltiplo fornece uma maneira prática de editar relações. Não use se você tiver um grande número de registros relacionados.',
      'linkSelectFilter' => 'A primary filter to apply by default when selecting a record.',
      'entityType' => 'Base Plus - possui painéis de Atividades, Histórico e Tarefas.

Evento - disponível nos painéis de Calendário e Atividades',
      'countDisabled' => 'O número total não será exibido na list view. Pode diminuir o tempo de carregamento quando a tabela no DB é grande.',
      'fullTextSearch' => 'A reconstrução em execução é necessária.',
      'linkParamReadOnly' => 'A read-only link cannot be edited via the *link* and *unlink* API requests. It won\'t be possible to relate and unrelate records via the relationship panel. It still possible to edit read-only links via link and link-multiple fields.',
      'activityStatusList' => 'Status values determining that an activity record should be displayed in the Activity panel and considered as actual.',
      'historyStatusList' => 'Status values determining that an activity record should be displayed in the History panel.',
      'completedStatusList' => 'Status values determining that an activity is completed.',
      'canceledStatusList' => 'Status values determining that an activity is canceled and won\'t be taken into account in free/busy ranges.',
      'lockableFieldList' => 'Fields that become read-only when an order is locked.',
      'productVariantSyncFieldList' => 'Fields that are synced from a template to product variants.',
      'salesOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'salesOrderDoneStatusList' => 'Statuses indicating that a sales order is done.',
      'purchaseOrderDoneStatusList' => 'Statuses indicating that a purchase order is done.',
      'purchaseOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'receiptOrderDoneStatusList' => 'Statuses indicating that a receipt order is done.',
      'receiptOrderCanceledStatusList' => 'Statuses indicating that a receipt order is canceled.',
      'salesOrderCanceledStatusList' => 'Statuses indicating that an order is canceled.',
      'invoiceDoneStatusList' => 'Statuses indicating that an invoice is done.',
      'invoiceCanceledStatusList' => 'Statuses indicating that an invoice is canceled.',
      'quoteDoneStatusList' => 'Statuses indicating that a quote is done.',
      'quoteCanceledStatusList' => 'Statuses indicating that a quote is canceled.',
      'deliveryRequiredStatusList' => 'Statuses on which a delivery order should be created.',
      'deliveryOrderCanceledStatusList' => 'Statuses indicating that a delivery order is canceled. Inventory is automatically returned to stock.',
      'deliveryOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'deliveryOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'deliveryOrderFailedStatusList' => 'Statuses indicating that a delivery order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'deliveryOrderDoneStatusList' => 'Statuses indicating that a delivery order is done.',
      'transferOrderCanceledStatusList' => 'Statuses indicating that a transfer order is canceled. Inventory is automatically returned to stock.',
      'transferOrderReserveStatusList' => 'Statuses on which inventory is reserved.',
      'transferOrderSoftReserveStatusList' => 'Statuses on which inventory is soft reserved.',
      'transferOrderFailedStatusList' => 'Statuses indicating that a transfer order could not be delivered. Inventory is not automatically returned to stock. Manual intervention might be required.',
      'transferOrderDoneStatusList' => 'Statuses indicating that a transfer order is done.',
      'returnOrderDoneStatusList' => 'Statuses indicating that a return order is done.',
      'returnOrderCanceledStatusList' => 'Statuses indicating that a return order is canceled.'
    ]
  ],
  'Export' => [
    'fields' => [
      'exportAllFields' => 'Exportar todos os campos',
      'fieldList' => 'Lista de Campos',
      'format' => 'Formato',
      'status' => 'Status',
      'xlsxLite' => 'Lite',
      'xlsxRecordLinks' => 'Record Links',
      'xlsxTitle' => 'Title'
    ],
    'options' => [
      'format' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'status' => [
        'Pending' => 'Pendente',
        'Running' => 'Rodando',
        'Success' => 'Sucesso',
        'Failed' => 'Falhou'
      ]
    ],
    'tooltips' => [
      'xlsxLite' => 'Consumes much less memory. Recommended if a big number of records is exported.',
      'xlsxTitle' => 'Print a title and current date in the header.'
    ],
    'messages' => [
      'exportProcessed' => 'A exportação foi processada. Baixe o  [file]({url}).',
      'infoText' => 'A exportação está sendo processada em modo inativo pelo cron. Pode levar algum tempo para terminar. Fechar esta caixa de diálogo modal não afetará o processo de execução.'
    ]
  ],
  'Extension' => [
    'fields' => [
      'name' => 'Nome',
      'version' => 'Versão',
      'description' => 'Descrição',
      'isInstalled' => 'Instalada',
      'checkVersionUrl' => 'Uma URL para verificar novas versões'
    ],
    'labels' => [
      'Uninstall' => 'Desinstalar',
      'Install' => 'Instalar'
    ],
    'messages' => [
      'uninstalled' => 'A extensão {name} foi desinstalada',
      'fileExceedsMaxUploadSize' => 'The file size exceeds the max upload size {maxSize}. Consider increasing `post_max_size` or install the extension via CLI.'
    ]
  ],
  'ExternalAccount' => [
    'labels' => [
      'Connect' => 'Conectar',
      'Disconnect' => 'Desconectar',
      'Disconnected' => 'Desconectado',
      'Connected' => 'Conectado'
    ],
    'help' => [],
    'messages' => [
      'externalAccountNoConnectDisabled' => 'External account for integration \'{integration}\' has been disabled due not being able to connect.'
    ]
  ],
  'FieldManager' => [
    'labels' => [
      'Dynamic Logic' => 'Lógica Dinâmica',
      'Name' => 'Nome',
      'Label' => 'Rótulo',
      'Type' => 'Tipo'
    ],
    'options' => [
      'dateTimeDefault' => [
        '' => 'Nenhum',
        'javascript: return this.dateTime.getNow(1);' => 'Agora',
        'javascript: return this.dateTime.getNow(5);' => 'Agora (5m)',
        'javascript: return this.dateTime.getNow(15);' => 'Agora (15m)',
        'javascript: return this.dateTime.getNow(30);' => 'Agora (30m)',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'hours\', 15);' => '+1 hora',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'hours\', 15);' => '+2 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'hours\', 15);' => '+3 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'hours\', 15);' => '+4 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'hours\', 15);' => '+5 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'hours\', 15);' => '+6 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(7, \'hours\', 15);' => '+7 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(8, \'hours\', 15);' => '+8 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(9, \'hours\', 15);' => '+9 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(10, \'hours\', 15);' => '+10 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(11, \'hours\', 15);' => '+11 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(12, \'hours\', 15);' => '+12 horas',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'days\', 15);' => '+1 dia',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(2, \'days\', 15);' => '+2 dias',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(3, \'days\', 15);' => '+3 dias',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(4, \'days\', 15);' => '+4 dias',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(5, \'days\', 15);' => '+5 dias',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(6, \'days\', 15);' => '+6 dias',
        'javascript: return this.dateTime.getDateTimeShiftedFromNow(1, \'week\', 15);' => '+1 semana'
      ],
      'dateDefault' => [
        '' => 'Nenhum',
        'javascript: return this.dateTime.getToday();' => 'Hoje',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'days\');' => '+1 dia',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'days\');' => '+2 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'days\');' => '+3 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'days\');' => '+4 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'days\');' => '+5 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'days\');' => '+6 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'days\');' => '+7 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'days\');' => '+8 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'days\');' => '+9 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'days\');' => '+10 dias',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'weeks\');' => '+1 semana',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'weeks\');' => '+2 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'weeks\');' => '+3 semanas',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'months\');' => '+1 mês',
        'javascript: return this.dateTime.getDateShiftedFromToday(2, \'months\');' => '+2 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(3, \'months\');' => '+3 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(4, \'months\');' => '+4 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(5, \'months\');' => '+5 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(6, \'months\');' => '+6 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(7, \'months\');' => '+7 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(8, \'months\');' => '+8 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(9, \'months\');' => '+9 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(10, \'months\');' => '+10 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(11, \'months\');' => '+11 meses',
        'javascript: return this.dateTime.getDateShiftedFromToday(1, \'year\');' => '+1 ano'
      ],
      'barcodeType' => [
        'EAN13' => 'EAN-13',
        'EAN8' => 'EAN-8',
        'EAN5' => 'EAN-5',
        'EAN2' => 'EAN-2',
        'UPC' => 'UPC (A)',
        'UPCE' => 'UPC (E)',
        'pharmacode' => 'Código Farmacêutico',
        'QRcode' => 'Código QR'
      ],
      'globalRestrictions' => [
        'forbidden' => 'Forbidden',
        'internal' => 'Internal',
        'onlyAdmin' => 'Admin-only',
        'readOnly' => 'Read-only',
        'nonAdminReadOnly' => 'Non-admin read-only'
      ]
    ],
    'tooltips' => [
      'optionsReference' => 'Re-use options from another field.',
      'currencyDecimal' => 'Use the Decimal DB type. In the app, values will be represented as strings. Check this parameter if precision is required.',
      'cutHeight' => 'A text higher then a specified value will be cut with a \'show more\' button displayed.',
      'urlStrip' => 'Strip a protocol and a trailing slash.',
      'audited' => 'As atualizações serão registradas no stream.',
      'required' => 'Campo será obrigatório. Não pode ficar vazio.',
      'default' => 'O valor será definido por padrão na criação.',
      'min' => 'Valor mínimo aceitável.',
      'max' => 'Valor máximo aceitável.',
      'seeMoreDisabled' => 'Se não estiver marcado, os textos longos serão encurtados.',
      'lengthOfCut' => 'Qual o tamanho do texto antes de ser cortado.',
      'maxLength' => 'Comprimento máximo aceitável do texto.',
      'before' => 'O valor de data deve ser anterior ao valor de data do campo especificado.',
      'after' => 'O valor de data deve ser posterior ao valor de data do campo especificado.',
      'readOnly' => 'O valor do campo não pode ser especificado pelo usuário. Mas pode ser calculado pela fórmula.',
      'readOnlyAfterCreate' => 'The field value can be specified when creating a new record. After that, the field becomes read-only. It can still be calculated by formula.',
      'preview' => 'Show the preview button. Applicable if Markdown is enabled.',
      'fileAccept' => 'Quais tipos de arquivo aceitar. É possível adicionar itens personalizados.',
      'barcodeLastChar' => 'Para o tipo EAN-13',
      'maxFileSize' => 'Se vazio ou 0, não há limite.',
      'conversionDisabled' => 'A ação de conversão de moeda não será aplicada a este campo.',
      'pattern' => 'A regular expression to check a field value against. Define an expression or select a predefined one.',
      'options' => 'A list of possible values and their labels.',
      'optionsArray' => 'A list of possible values and their labels. If empty, the field will allow entering custom values.',
      'maxCount' => 'Maximum number of items allowed to be selected.',
      'displayAsList' => 'Each item in a new line.',
      'optionsVarchar' => 'A list of autocomplete values.',
      'linkReadOnly' => 'Field value can\'t be specified by user. But can be calculated by formula.

It will also disable the ability to create a related record from relationship panels.',
      'relateOnImport' => 'When importing with this field, it will automatically relate a record with a matching foreign record. Use this functionality only if the foreign field is considered as unique.'
    ],
    'fieldParts' => [
      'address' => [
        'street' => 'Rua',
        'city' => 'Cidade',
        'state' => 'Estado',
        'country' => 'País',
        'postalCode' => 'Código Postal',
        'map' => 'Mapa'
      ],
      'personName' => [
        'salutation' => 'Saudação',
        'first' => 'Primeiro',
        'middle' => 'Meio',
        'last' => 'Último'
      ],
      'currency' => [
        'converted' => '(Convertido)',
        'currency' => '(Moeda)'
      ],
      'datetimeOptional' => [
        'date' => 'Data'
      ]
    ],
    'fieldInfo' => [
      'varchar' => 'Texto de linha única.',
      'enum' => 'Selectbox, só um valor pode ser selecionado.',
      'text' => 'Um texto de várias linhas com suporte a markdown.',
      'date' => 'Data sem hora.',
      'datetime' => 'Data e hora',
      'currency' => 'Um valor de moeda. Um número flutuante com um código de moeda.',
      'int' => 'Um número inteiro.',
      'float' => 'Um número com casa decimal.',
      'bool' => 'Um checkbox. Dois valores possíveis: verdadeiro e falso.',
      'multiEnum' => 'Uma lista de valores, vários valores podem ser selecionados. A lista está ordenada.',
      'checklist' => 'Uma lista de checkboxes.',
      'array' => 'A list of values, similar to Multi-Enum field.',
      'address' => 'Um endereço com rua, cidade, estado, código postal e país.',
      'url' => 'Para armazenar links.',
      'urlMultiple' => 'Multiple links.',
      'wysiwyg' => 'Um texto com suporte HTML.',
      'file' => 'Para upload de arquivos.',
      'image' => 'Para upload de imagens.',
      'attachmentMultiple' => 'Permite upload de vários arquivos.',
      'number' => 'Um número de incremento automático do tipo de string com um possível prefixo e comprimento determinado.',
      'autoincrement' => 'Um número inteiro de incremento automático gerado somente leitura.',
      'barcode' => 'Um código de barras. Pode ser impresso em PDF.',
      'email' => 'A set of email addresses with their parameters: Opted-out, Invalid, Primary.',
      'phone' => 'A set of phone numbers with their parameters: Type, Opted-out, Invalid, Primary.',
      'foreign' => 'Um campo de um registro relacionado. Somente leitura.',
      'link' => 'A record related through Belongs-To (many-to-one or one-to-one) relationship.',
      'linkParent' => 'A record related through Belongs-To-Parent relationship. Can be of different entity types.',
      'linkMultiple' => 'Um conjunto de registros relacionados por meio do relacionamento Has-Many (many-to-many ou one-to-manys). Nem todos os relacionamentos têm seus campos de links múltiplos. Somente aqueles fazem isso, onde o(s) parâmetro(s) Link-Multiple está(ão) habilitado(s).'
    ],
    'messages' => [
      'fieldCreatedAddToLayouts' => 'Field has been created. Now, you can add it to [layouts]({link})',
      'confirmRemove' => 'Are you sure you want to remove the *{field}* field?

Field removal does not remove data from the database. Data from the database will be removed if you run hard rebuild.',
      'fieldNameIsNotAllowed' => 'Field name \'{field}\' is not allowed.',
      'fieldAlreadyExists' => 'Field \'{field}\' already exists in \'{entityType}\'.',
      'linkWithSameNameAlreadyExists' => 'Link with the name \'{field}\' already exists in \'{entityType}\'.',
      'namingFieldLinkConflict' => 'Name \'{field}\' conflicts with link.'
    ]
  ],
  'Formula' => [
    'labels' => [
      'Check Syntax' => 'Verificar Sintaxe',
      'Run' => 'Execute'
    ],
    'fields' => [
      'target' => 'Alvo',
      'targetType' => 'Tipo do Alvo ',
      'script' => 'Script',
      'output' => 'Saída',
      'error' => 'Erro'
    ],
    'messages' => [
      'runSuccess' => 'Executado com sucesso.',
      'runError' => 'Erro.',
      'checkSyntaxSuccess' => 'Sintaxe está correta.',
      'checkSyntaxError' => 'Erro de sintaxe.',
      'emptyScript' => 'Script está vazio.'
    ],
    'tooltips' => [
      'output' => 'Imprima valores com a função `output\\printLine`.'
    ]
  ],
  'Global' => [
    'scopeNames' => [
      'Note' => 'Note',
      'Email' => 'E-mail',
      'User' => 'Usuário',
      'Team' => 'Time',
      'Role' => 'Regra',
      'EmailTemplate' => 'Template de E-mail',
      'EmailTemplateCategory' => 'Categorias de Modelos de Email',
      'EmailAccount' => 'Conta de e-mail',
      'EmailAccountScope' => 'Conta de e-mail',
      'OutboundEmail' => 'E-mail de Saída',
      'ScheduledJob' => 'Tarefa Agendada',
      'ExternalAccount' => 'Conta externa',
      'Extension' => 'Extensão',
      'Dashboard' => 'Dashboard',
      'InboundEmail' => 'E-mail de Entrada',
      'Stream' => 'Fluxo',
      'Import' => 'Importar',
      'ImportError' => 'Import Error',
      'Template' => 'Template',
      'Job' => 'Tarefas',
      'EmailFilter' => 'Filtro de Email',
      'Portal' => 'Portal',
      'PortalRole' => 'Regra de Portal',
      'Attachment' => 'Anexo',
      'EmailFolder' => 'Pasta de Email',
      'GroupEmailFolder' => 'Group Email Folder',
      'PortalUser' => 'Usuário do Portal',
      'ApiUser' => 'API de Usuário',
      'ScheduledJobLogRecord' => 'Registro de Log de Trabalho Agendado',
      'PasswordChangeRequest' => 'Solicitação de Alteração de Senha',
      'ActionHistoryRecord' => 'Registro de Histórico de Ações',
      'AuthToken' => 'Token de Autenticação',
      'UniqueId' => 'ID Único',
      'LastViewed' => 'Visto por Último',
      'Settings' => 'Configurações',
      'FieldManager' => 'Gerenciar Campo',
      'Integration' => 'Integração',
      'LayoutManager' => 'Gerenciar Layout',
      'EntityManager' => 'Gerenciar de Entidade',
      'Export' => 'Exportar',
      'DynamicLogic' => 'Lógica Dinâmica',
      'DashletOptions' => 'Opções do painel',
      'Admin' => 'Admin',
      'Global' => 'Global',
      'Preferences' => 'Preferências',
      'EmailAddress' => 'Endereço de Email',
      'PhoneNumber' => 'Número de Telefone',
      'AppLogRecord' => 'App Log Record',
      'AuthLogRecord' => 'Registro de Log de Autorização',
      'AuthFailLogRecord' => 'Registro de Log de Falha de Autenticação',
      'LeadCapture' => 'Ponto de Entrada de Captura de Leads',
      'LeadCaptureLogRecord' => 'Registro de Log de Captura de Leads',
      'ArrayValue' => 'Valor em Array',
      'DashboardTemplate' => 'Modelo de Dashboard',
      'Currency' => 'Moeda',
      'LayoutSet' => 'Conjunto de layout',
      'Webhook' => 'Webhook',
      'WebhookQueueItem' => 'Webhook Queue Item',
      'Mass Action' => 'Ação em massa',
      'WorkingTimeCalendar' => 'Working Time Calendar',
      'WorkingTimeRange' => 'Working Time Exception',
      'AuthenticationProvider' => 'Authentication Provider',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Country',
      'AppSecret' => 'App Secret',
      'Account' => 'Conta',
      'Contact' => 'Contato',
      'Lead' => 'Lead',
      'Target' => 'Alvo',
      'Opportunity' => 'Oportunidade',
      'Meeting' => 'Reunião',
      'Calendar' => 'Calendário',
      'Call' => 'Ligação',
      'Task' => 'Tarefa',
      'Case' => 'Suporte',
      'Document' => 'Documento',
      'DocumentFolder' => 'Pasta de Documentos',
      'Campaign' => 'Campanha',
      'TargetList' => 'Lista de Alvos',
      'MassEmail' => 'E-mail em Massa',
      'EmailQueueItem' => 'Item da Fila de Email',
      'CampaignTrackingUrl' => 'URL de Rastreamento',
      'Activities' => 'Atividades',
      'KnowledgeBaseArticle' => 'Tutorial',
      'KnowledgeBaseCategory' => 'Categoria da Base de Conhecimento',
      'CampaignLogRecord' => 'Registro de Log de Campanha',
      'Workflow' => 'Workflow',
      'Report' => 'Report',
      'ReportCategory' => 'Report Category',
      'WorkflowLogRecord' => 'Workflow Log Record',
      'WorkflowCategory' => 'Workflow Category',
      'BpmnFlowchart' => 'Process Flowchart',
      'BpmnProcess' => 'Process',
      'BpmnUserTask' => 'Process User Task',
      'ReportFilter' => 'Report Filter',
      'ReportPanel' => 'Report Panel',
      'Product' => 'Product',
      'ProductCategory' => 'Product Category',
      'ProductBrand' => 'Product Brand',
      'ProductAttribute' => 'Product Attribute',
      'ProductAttributeOption' => 'Product Attribute Option',
      'Quote' => 'Cotação',
      'QuoteItem' => 'Quote Item',
      'SalesOrder' => 'Sales Order',
      'SalesOrderItem' => 'Sales Order Item',
      'Invoice' => 'Invoice',
      'InvoiceItem' => 'Invoice Item',
      'DeliveryOrder' => 'Delivery Order',
      'DeliveryOrderItem' => 'Delivery Order Item',
      'ReceiptOrder' => 'Receipt Order',
      'ReceiptOrderItem' => 'Receipt Order Item',
      'TransferOrder' => 'Transfer Order',
      'TransferOrderItem' => 'Transfer Order Item',
      'Tax' => 'Tax',
      'ShippingProvider' => 'Shipping Provider',
      'OpportunityItem' => 'Opportunity Item',
      'PurchaseOrder' => 'Purchase Order',
      'PurchaseOrderItem' => 'Purchase Order Item',
      'ReturnOrder' => 'Return Order',
      'ReturnOrderItem' => 'Return Order Item',
      'Supplier' => 'Supplier',
      'ProductPrice' => 'Product Price',
      'SupplierProductPrice' => 'Supplier Product Price',
      'PriceBook' => 'PriceBook',
      'PriceRule' => 'Price Rule',
      'PriceRuleCondition' => 'Price Rule Condition',
      'Warehouse' => 'Warehouse',
      'InventoryTransaction' => 'Inventory Transaction',
      'InventoryNumber' => 'Inventory Number',
      'InventoryAdjustment' => 'Inventory Adjustment',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Item',
      'DashboardSet' => 'Dashboard Set',
      'Service' => 'Oportunidade de Serviço',
      'ServiceItem' => 'Service Item',
      'Project' => 'Project',
      'ProjectTask' => 'Project Task',
      'ProjectBoard' => 'Project Board',
      'ProjectGroup' => 'Project Group',
      'ProjectColumn' => 'Project Board Column',
      'ProjectRole' => 'Project Role',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'Surestep',
      'Portfolio' => 'Portfolio (Calculadora)',
      'KNOW' => 'Cisco Programs',
      'ISVExperience' => 'ISV Experience',
      'CiscoDMP' => 'Cisco DMP',
      'AssesmentCompany' => 'AssesmentCompany',
      'Citrix' => 'Citrix',
      'Services' => 'Services (Old)',
      'ServicesVersions' => 'Versões de Serviço',
      'ServicesBilling' => 'Faturamento',
      'NurturingForm' => 'Nurturing Form',
      'CloudConsumption' => 'Cloud Consumption',
      'CPB' => 'Practice Builder - Lista',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programa',
      'AWS' => 'Partner Program - Lista',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'Partner Program - Lista',
      'ExternalFormPost' => 'ExternalFormPost',
      'LevelUp' => 'Level Up',
      'LevelUpActivities' => 'Ação Level Up',
      'Distributor' => 'Distributor',
      'BillingVendor' => 'BillingVendor',
      'IncentivesVendor' => 'IncentivesVendor',
      'VendorContract' => 'VendorContract',
      'Earn' => 'Earn',
      'PrizeRoulette' => 'Roleta de Prêmio',
      'Contract' => 'Contrato',
      'Orders' => 'Orders',
      'Notifications' => 'Notification',
      'DSET' => 'DSET',
      'VendorCloudConsumption' => 'Cloud Consumption Revenue',
      'DashboardSet1' => 'Cloud Consumption',
      'DashboardSet2' => 'Report - Opportunities',
      'DashboardSet4' => 'Partner Program - Dashboard',
      'DashboardSet5' => 'Partner Program - Management - Dashboard',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket - Dashboard',
      'DashboardSet8' => 'FinOps',
      'DashboardSet9' => 'Partner Program - Management - Dashboard',
      'DashboardSet10' => 'Cloud Practice Builder - Dashboard',
      'DashboardSet11' => 'Cloud Practice Builder - Progress',
      'DashboardSet12' => 'Dashboard - Cloud Practice Builder',
      'DashboardSet13' => 'Oportunidades - Dashboard',
      'DashboardSet14' => 'Partner Program - Dashboard',
      'DashboardSet15' => 'Oportunidades - Management - Dashboard',
      'DashboardSet16' => 'Partner Program - Dashboard',
      'PBGeral' => 'Practice Builder High Growth - List',
      'DashboardSet28' => 'Oportunidades - Dashboard',
      'DashboardSet33' => 'Oportunidades - Management - Dashboard',
      'DashboardSet34' => 'Partner Program - Management - Dashboard',
      'DashboardSet35' => 'Partner Program - Dashboard',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth Practice Builder',
      'DashboardSet45' => 'Oportunidades - Argentina - Dashboard',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Origens',
      'VendorSubscription' => 'VendorSubscription',
      'DashboardSet46' => 'Level Up - Dashboard',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dashboard',
      'DashboardSet48' => 'Oportunidades - Management - Dashboard',
      'DashboardSet49' => 'Oportunidades - Mexico - Dashboard',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet51' => 'Dashboardset teste',
      'DashboardSet52' => 'Microsoft - Colombia - Renewals',
      'DashboardSet53' => 'Practice Builder Entrenamientos - Dashboard',
      'VendorAccount' => 'VendorAccount',
      'DashboardSet54' => 'Rebates Microsoft',
      'Cisco' => 'Cisco',
      'DashboardSet55' => 'Oportunidades - Partner Center',
      'Country' => 'Country',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales - Dashboard',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContent',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud Practice Builder – Dashboard',
      'ContractGoals' => 'Meta',
      'AccountVMB' => 'Account VMB',
      'AccountVBM' => 'Account VBM',
      'TechnicalSupport' => 'TechnicalSupport',
      'DashboardSet59' => 'Oportunidades - Paraguay - Dashboard',
      'DashboardSet60' => 'Oportunidades - Uruguay - Dashboard',
      'DashboardSet61' => 'Assessment Google',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Dashboard - Destination AI',
      'Migrations' => 'Migrações',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Mensageria',
      'PatchNotes' => 'Atualizações do CDP',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet63' => 'Microsoft - Revenue',
      'DashboardSet64' => 'Cloud Pipeline',
      'DashboardSet65' => 'Google Dashboard',
      'DashboardSet66' => 'AWS Dashboard',
      'DashboardSet68' => 'Sales Quotes',
      'DashboardSet69' => 'Migrações AWS',
      'DashboardSet70' => 'Google Assessment',
      'DashboardSet71' => 'Dashboard - Cybersecurity',
      'DashboardSet72' => 'Cloud Practice Builder',
      'Renewals' => 'Renewal',
      'DashboardSet73' => 'Microsoft - Renewals',
      'DashboardSet74' => 'Microsoft - Renewals',
      'CAccountEndCustomer' => 'Account End Customer',
      'DashboardSet75' => 'Dashboard - Partner Advantage - Brasil',
      'DashboardSet76' => 'Dashboard - Partner Advantage - Mexico',
      'CPartnerAssessment' => 'Partner Assessment',
      'DashboardSet77' => 'Migrações Microsoft',
      'DashboardSet78' => 'Pipeline - Oportunidades Google',
      'DashboardSet3' => 'Rebates - Dashboard',
      'DashboardSet21' => 'Oportunidades - Bolivia - Dashboard',
      'DashboardSet22' => 'Oportunidades - Brasil - Dashboard',
      'DashboardSet24' => 'Oportunidades - CCA - Dashboard',
      'DashboardSet26' => 'Oportunidades - Chile - Dashboard',
      'DashboardSet31' => 'Oportunidades - Ecuador - Dashboard',
      'DashboardSet67' => 'Rebates'
    ],
    'scopeNamesPlural' => [
      'Note' => 'Notes',
      'Email' => 'E-mails',
      'User' => 'Usuários',
      'Team' => 'Times',
      'Role' => 'Regras',
      'EmailTemplate' => 'Templates de E-mail',
      'EmailTemplateCategory' => 'Categorias de Modelos de Email',
      'EmailAccount' => 'Contas de e-mail',
      'EmailAccountScope' => 'Contas de e-mail',
      'OutboundEmail' => 'E-mails de Saída',
      'ScheduledJob' => 'Tarefas Agendadas',
      'ExternalAccount' => 'Contas externas',
      'Extension' => 'Extensões',
      'Dashboard' => 'Dashboard',
      'InboundEmail' => 'E-mails de Entrada',
      'EmailAddress' => 'Endereços de E-mail',
      'PhoneNumber' => 'Números de Telefone',
      'Stream' => 'Fluxo',
      'Import' => 'Importar',
      'ImportError' => 'Import Errors',
      'Template' => 'Templates',
      'Job' => 'Tarefas',
      'EmailFilter' => 'Filtros de Email',
      'Portal' => 'Portais',
      'PortalRole' => 'Regras de Portal',
      'Attachment' => 'Anexos',
      'EmailFolder' => 'Pastas de Email',
      'GroupEmailFolder' => 'Group Email Folders',
      'PortalUser' => 'Usuários do Portal',
      'ApiUser' => 'API de Usuários',
      'ScheduledJobLogRecord' => 'Registros de Log de Trabalho Agendado',
      'PasswordChangeRequest' => 'Solicitações de alteração de senha',
      'ActionHistoryRecord' => 'Histórico de Ações',
      'AuthToken' => 'Tokens de Autenticação',
      'UniqueId' => 'IDs Únicos',
      'LastViewed' => 'Visto por Último',
      'AppLogRecord' => 'App Log',
      'AuthLogRecord' => 'Log de Autorização',
      'AuthFailLogRecord' => 'Log de Falha de Autenticação',
      'LeadCapture' => 'Captura de Lead',
      'LeadCaptureLogRecord' => 'Log de Captura de Lead',
      'ArrayValue' => 'Valores em Array',
      'DashboardTemplate' => 'Modelos de Dashboard',
      'Currency' => 'Moeda',
      'LayoutSet' => 'Conjunto de Layouts',
      'Webhook' => 'Webhooks',
      'WebhookQueueItem' => 'Webhook Queue Items',
      'WorkingTimeCalendar' => 'Working Time Calendars',
      'WorkingTimeRange' => 'Working Time Exceptions',
      'AuthenticationProvider' => 'Authentication Providers',
      'GlobalStream' => 'Global Stream',
      'AddressCountry' => 'Address Countries',
      'AppSecret' => 'App Secrets',
      'Account' => 'Contas',
      'Contact' => 'Contatos',
      'Lead' => 'Leads',
      'Target' => 'Alvos',
      'Opportunity' => 'Oportunidades',
      'Meeting' => 'Reuniões',
      'Calendar' => 'Calendário',
      'Call' => 'Ligações',
      'Task' => 'Tarefas',
      'Case' => 'Suporte',
      'Document' => 'Documentos',
      'DocumentFolder' => 'Pastas de Documentos ',
      'Campaign' => 'Campanhas',
      'TargetList' => 'Listas de Alvo',
      'MassEmail' => 'E-mails em Massa',
      'EmailQueueItem' => 'Itens da Fila de Email',
      'CampaignTrackingUrl' => 'URLs de Rastreamento',
      'Activities' => 'Atividades',
      'KnowledgeBaseArticle' => 'Tutoriais',
      'KnowledgeBaseCategory' => 'Categorias da base de conhecimento',
      'CampaignLogRecord' => 'Registros de Log de Campanha',
      'Workflow' => 'Workflows',
      'Report' => 'Reports',
      'ReportCategory' => 'Report Categories',
      'WorkflowLogRecord' => 'Workflows Log',
      'WorkflowCategory' => 'Workflow Categories',
      'BpmnFlowchart' => 'Process Flowcharts',
      'BpmnProcess' => 'Processes',
      'BpmnUserTask' => 'Process User Tasks',
      'ReportFilter' => 'Report Filters',
      'ReportPanel' => 'Report Panels',
      'Product' => 'Products',
      'ProductCategory' => 'Product Categories',
      'ProductBrand' => 'Product Brands',
      'ProductAttribute' => 'Product Attributes',
      'ProductAttributeOption' => 'Product Attribute Options',
      'OpportunityItem' => 'Opportunity Items',
      'Quote' => 'Cotações',
      'QuoteItem' => 'Quote Items',
      'SalesOrder' => 'Sales Orders',
      'SalesOrderItem' => 'Sales Order Items',
      'Invoice' => 'Invoices',
      'InvoiceItem' => 'Invoice Items',
      'PurchaseOrder' => 'Purchase Orders',
      'PurchaseOrderItem' => 'Purchase Order Items',
      'ReturnOrder' => 'Return Orders',
      'ReturnOrderItem' => 'Return Order Items',
      'DeliveryOrder' => 'Delivery Orders',
      'DeliveryOrderItem' => 'Delivery Order Items',
      'ReceiptOrder' => 'Receipt Orders',
      'ReceiptOrderItem' => 'Receipt Order Items',
      'TransferOrder' => 'Transfer Orders',
      'TransferOrderItem' => 'Transfer Order Items',
      'Tax' => 'Taxes',
      'ShippingProvider' => 'Shipping Providers',
      'Supplier' => 'Suppliers',
      'ProductPrice' => 'Product Prices',
      'SupplierProductPrice' => 'Supplier Product Prices',
      'PriceBook' => 'PriceBooks',
      'PriceRule' => 'Price Rules',
      'PriceRuleCondition' => 'Price Rule Conditions',
      'Warehouse' => 'Warehouses',
      'InventoryTransaction' => 'Inventory Transactions',
      'InventoryNumber' => 'Inventory Numbers',
      'InventoryAdjustment' => 'Inventory Adjustments',
      'InventoryAdjustmentItem' => 'Inventory Adjustment Items',
      'DashboardSet' => 'Dashboard Sets',
      'Service' => 'Oportunidades de Serviços',
      'ServiceItem' => 'Service Items',
      'Project' => 'Projects',
      'ProjectTask' => 'Project Tasks',
      'ProjectBoard' => 'Project Boards',
      'ProjectGroup' => 'Project Groups',
      'ProjectColumn' => 'Project Board Stages',
      'ProjectRole' => 'Project Roles',
      'Analytics' => 'Analytics',
      'LeadsPartnerCenter' => 'Leads Partner Center',
      'PartnerID' => 'Partner ID',
      'Surestep' => 'Surestep',
      'Portfolio' => 'Portfolios (Calculadoras)',
      'KNOW' => 'Cisco Programs',
      'ISVExperience' => 'ISV Experience',
      'CiscoDMP' => 'Cisco DMPs',
      'AssesmentCompany' => 'AssesmentCompanies',
      'Citrix' => 'Citrix',
      'Services' => 'Services (Old)',
      'ServicesVersions' => 'Versões de Serviços',
      'ServicesBilling' => 'Faturamentos',
      'NurturingForm' => 'Nurturing Forms',
      'CloudConsumption' => 'Cloud Consumptions',
      'CPB' => 'Cloud Practice Builder - Lista',
      'GooglePartnerAdvantage' => 'Google Partner Advantage',
      'Program' => 'Programas',
      'AWS' => 'Partner Program - Lista',
      'DsetAws' => 'DSET AWS',
      'DataAnalyticsReport' => 'Data Analytics Report',
      'PartnersGoogleCloud' => 'Partner Program - Lista',
      'ExternalFormPost' => 'ExternalFormPosts',
      'LevelUp' => 'Level Up',
      'LevelUpActivities' => 'Ações Level Up',
      'Distributor' => 'Distributors',
      'BillingVendor' => 'BillingVendors',
      'IncentivesVendor' => 'IncentivesVendors',
      'VendorContract' => 'VendorContracts',
      'Earn' => 'Earns',
      'PrizeRoulette' => 'Roleta de Prêmios',
      'Contract' => 'Contratos',
      'Orders' => 'Orderses',
      'Notifications' => 'Notifications',
      'DSET' => 'DSETs',
      'VendorCloudConsumption' => 'Cloud Consumptions Revenue',
      'DashboardSet1' => 'Cloud Consumption',
      'DashboardSet2' => 'Report - Opportunities',
      'DashboardSet4' => 'Partner Program - Dashboard',
      'DashboardSet5' => 'Partner Program - Management - Dashboard',
      'DashboardSet6' => 'Rocket - Dashboard',
      'DashboardSet7' => 'Rocket- Dashboard',
      'DashboardSet8' => 'FinOps',
      'DashboardSet9' => 'Partner Program - Management - Dashboard',
      'DashboardSet10' => 'Cloud Practice Builder - Dashboard',
      'DashboardSet11' => 'Cloud Practice Builder - Progress',
      'DashboardSet12' => 'Dashboard - Cloud Practice Builder',
      'DashboardSet13' => 'Oportunidades  - Dashboard',
      'DashboardSet14' => 'Partner Program - Dashboard',
      'DashboardSet15' => 'Oportunidades - Management - Dashboard',
      'DashboardSet16' => 'Partner Program - Dashboard',
      'PBGeral' => 'Practice Builder General - Lista',
      'DashboardSet28' => 'Oportunidades - Dashboard',
      'DashboardSet33' => 'Oportunidades - Management - Dashboard',
      'DashboardSet34' => 'Partner Program - Management - Dashboard',
      'DashboardSet35' => 'Partner Program - Dashboard',
      'DashboardSet36' => 'Rocket - Argentina - Dashboard',
      'DashboardSet37' => 'Rocket - Brasil - Dashboard',
      'DashboardSet38' => 'Rocket - CCA - Dashboard',
      'DashboardSet39' => 'Rocket - Chile - Dashboard',
      'DashboardSet40' => 'Rocket - Colombia - Dashboard',
      'DashboardSet41' => 'Rocket - Ecuador - Dashboard',
      'DashboardSet42' => 'Rocket - Mexico - Dashboard',
      'DashboardSet43' => 'Rocket - Peru - Dashboard',
      'DashboardSet44' => 'High Growth Practice Builder',
      'DashboardSet45' => 'Oportunidades - Argentina - Dashboard',
      'AWSVersions' => 'AWS Versions',
      'Marketing' => 'Marketing',
      'VendorSubscription' => 'VendorSubscriptions',
      'DashboardSet46' => 'Level Up - Dashboard',
      'Importer' => 'Importador',
      'DashboardSet47' => 'Oportunidades - Dashboard',
      'DashboardSet48' => 'Oportunidades - Management - Dashboard',
      'DashboardSet49' => 'Oportunidades - Mexico - Dashboard',
      'DashboardSet50' => 'Rocket - Uruguay - Dashboard',
      'DashboardSet51' => 'Dashboardset teste',
      'DashboardSet52' => 'Microsoft - Colombia - Renewals',
      'DashboardSet53' => 'Practice Builder Entrenamientos - Dashboard',
      'VendorAccount' => 'VendorAccounts',
      'DashboardSet54' => 'Rebates Microsoft',
      'Cisco' => 'Cisco',
      'DashboardSet55' => 'Oportunidades - Partner Center',
      'Country' => 'Countries',
      'DashboardAccess' => 'Dashboard Access',
      'DashboardSet56' => 'Facturación Canales - Dashboard',
      'DashboardSet57' => 'DSET AWS',
      'TourContent' => 'TourContents',
      'EmailContent' => 'Email Content',
      'DashboardSet58' => 'Cloud Practice Builder – Dashboard',
      'ContractGoals' => 'Metas',
      'AccountVMB' => 'Account VMBs',
      'AccountVBM' => 'Account VBMs',
      'TechnicalSupport' => 'TechnicalSupports',
      'DashboardSet59' => 'Oportunidades - Paraguay - Dashboard',
      'DashboardSet60' => 'Oportunidades - Uruguay - Dashboard',
      'DashboardSet61' => 'Assessment Google',
      'RocketMargins' => 'Margens Rocket',
      'DashboardSet62' => 'Dashboard - Destination AI',
      'Migrations' => 'Migrações',
      'BucketTimer' => 'Duração do Bucket',
      'Messenger' => 'Mensageria',
      'PatchNotes' => 'Atualizações do CDP',
      'Sources' => 'Sources',
      'OpportunityAWS' => 'Opportunity AWS',
      'OpportunityGoogle' => 'Opportunity Google',
      'DashboardSet63' => 'Microsoft - Revenue',
      'DashboardSet64' => 'Cloud Pipeline',
      'DashboardSet65' => 'Google Dashboard',
      'DashboardSet66' => 'AWS Dashboard',
      'DashboardSet68' => 'Sales Quotes',
      'DashboardSet69' => 'Migrações AWS',
      'DashboardSet70' => 'Google Assessment',
      'DashboardSet71' => 'Dashboard - Cybersecurity',
      'DashboardSet72' => 'Cloud Practice Builder',
      'Renewals' => 'Renewals',
      'DashboardSet73' => 'Microsoft - Renewals',
      'DashboardSet74' => 'Microsoft - Renewals',
      'CAccountEndCustomer' => 'Account End Customers',
      'DashboardSet75' => 'Dashboard - Partner Advantage - Brasil',
      'DashboardSet76' => 'Dashboard - Partner Advantage - Mexico',
      'CPartnerAssessment' => 'Partner Assessments',
      'DashboardSet77' => 'Migrações Microsoft',
      'DashboardSet78' => 'Pipeline - Oportunidades Google',
      'DashboardSet3' => 'Rebates - Dashboard',
      'DashboardSet21' => 'Oportunidades - Bolivia - Dashboard',
      'DashboardSet22' => 'Oportunidades - Brasil - Dashboard',
      'DashboardSet24' => 'Oportunidades - CCA - Dashboard',
      'DashboardSet26' => 'Oportunidades - Chile - Dashboard',
      'DashboardSet31' => 'Oportunidades - Ecuador - Dashboard',
      'DashboardSet67' => 'Rebates'
    ],
    'labels' => [
      'Previous Page' => 'Previous Page',
      'Next Page' => 'Next Page',
      'First Page' => 'First Page',
      'Last Page' => 'Last Page',
      'Page' => 'Page',
      'Sort' => 'Sort',
      'Column Resize' => 'Column Resize',
      'Misc' => 'Misc',
      'General' => 'General',
      'Merge' => 'Mesclar',
      'None' => 'Nenhum',
      'Home' => 'Início',
      'by' => 'por',
      'Proceed' => 'Prosseguir',
      'Saved' => 'Salvo',
      'Error' => 'Erro',
      'Select' => 'Selecionar',
      'Not valid' => 'Inválido',
      'Please wait...' => 'Aguarde...',
      'Please wait' => 'Aguarde',
      'Attached' => 'Anexado',
      'Loading...' => 'Carregando...',
      'Uploading...' => 'Enviando...',
      'Sending...' => 'Enviando...',
      'Send' => 'Send',
      'Merged' => 'Mesclado',
      'Removed' => 'Removido',
      'Posted' => 'Postado',
      'Linked' => 'Relacionado',
      'Unlinked' => 'Relacionamento removido',
      'Done' => 'Feito',
      'Access denied' => 'Acesso negado',
      'Not found' => 'Não encontrado',
      'Access' => 'Acesso',
      'Timeout' => 'Timeout',
      'No internet' => 'No internet',
      'Are you sure?' => 'Você confirma?',
      'Record has been removed' => 'Registro removido',
      'Wrong username/password' => 'Usuário/senha incorretos',
      'Post cannot be empty' => 'A postagem não pode estar vazia',
      'Username can not be empty!' => 'O nome de usuário não pode estar vazio!',
      'Cache is not enabled' => 'O cache não está habilitado',
      'Cache has been cleared' => 'Cache limpo',
      'Rebuild has been done' => 'Reconstrução concluída',
      'Return to Application' => 'Retornar para Aplicação',
      'Modified' => 'Modificado',
      'Created' => 'Criado',
      'Create' => 'Criar',
      'create' => 'criar',
      'Scheduled' => 'Scheduled',
      'Overview' => 'Visão Geral',
      'Details' => 'Detalhes',
      'Add Field' => 'Adicionar Campo',
      'Add Dashlet' => 'Adicionar Painel',
      'Filter' => 'Filtro',
      'Edit Dashboard' => 'Editar Dashboard',
      'Add' => 'Adicionar',
      'Add Item' => 'Adicionar Item',
      'Reset' => 'Resetar',
      'Menu' => 'Menu',
      'More' => 'Mais',
      'Search' => 'Busca',
      'Only My' => 'Apenas meus',
      'Open' => 'Aberto',
      'Admin' => 'Admin',
      'About' => 'Sobre',
      'Refresh' => 'Recarregar',
      'Remove' => 'Remover',
      'Restore' => 'Restaurar',
      'Options' => 'Opções',
      'Username' => 'Usuário (E-mail)',
      'Password' => 'Senha',
      'Login' => 'Login',
      'Log Out' => 'Sair',
      'Log in' => 'Log in',
      'Log in as' => 'Log in as',
      'Sign in' => 'Sign in',
      'Preferences' => 'Preferências',
      'State' => 'Estado',
      'Street' => 'Logradouro',
      'Country' => 'País',
      'City' => 'Cidade',
      'PostalCode' => 'CEP',
      'Star' => 'Star',
      'Unstar' => 'Unstar',
      'Starred' => 'Starred',
      'Followed' => 'Seguido',
      'Follow' => 'Seguir',
      'Followers' => 'Seguidores',
      'Clear Local Cache' => 'Limpar Cache Local',
      'Actions' => 'Ações',
      'Delete' => 'Excluir',
      'Update' => 'Atualizar',
      'Save' => 'Salvar',
      'Edit' => 'Editar',
      'View' => 'Ver',
      'Cancel' => 'Cancelar',
      'Apply' => 'Aplicar',
      'Unlink' => 'Remover ligação',
      'Mass Update' => 'Atualização em Massa',
      'Export' => 'Exportar',
      'No Data' => 'Sem dados',
      'No Access' => 'Sem acesso',
      'All' => 'Tudo',
      'Active' => 'Ativo',
      'Inactive' => 'Inativo',
      'Write your comment here' => 'Escreva seu comentário aqui',
      'Post' => 'Postar',
      'Stream' => 'Fluxo',
      'Show more' => 'Exibir mais',
      'Dashlet Options' => 'Opções do Painel',
      'Full Form' => 'Formulário Completo',
      'Insert' => 'Inserir',
      'Person' => 'Pessoa',
      'First Name' => 'Nome',
      'Last Name' => 'Sobrenome',
      'Middle Name' => 'Nome do Meio',
      'Original' => 'Original',
      'You' => 'Você',
      'you' => 'você',
      'change' => 'modificar',
      'Change' => 'Modificar',
      'Primary' => 'Primário',
      'Save Filter' => 'Salvar Filtro',
      'Remove Filter' => 'Remove Filter',
      'Ready' => 'Ready',
      'Administration' => 'Administração',
      'Run Import' => 'Executar Importação',
      'Duplicate' => 'Duplicar',
      'Notifications' => 'Notificações',
      'Mark all read' => 'Marcar tudo como lido',
      'See more' => 'Ver mais',
      'Today' => 'Hoje',
      'Tomorrow' => 'Amanhã',
      'Yesterday' => 'Ontem',
      'Now' => 'Now',
      'Submit' => 'Enviar',
      'Close' => 'Fechar',
      'Yes' => 'Sim',
      'No' => 'Não',
      'Select All Results' => 'Selecionar todos',
      'Value' => 'Valor',
      'Current version' => 'Versão atual',
      'List View' => 'Visualização em Lista',
      'Tree View' => 'Visão em árvore',
      'Unlink All' => 'Desmarcar Todos',
      'Total' => 'Total',
      'Print' => 'Print',
      'Print to PDF' => 'Imprimir em PDF',
      'Default' => 'Padrão',
      'Number' => 'Número',
      'From' => 'De',
      'To' => 'Para',
      'Create Post' => 'Criar Post',
      'Previous Entry' => 'Entrada Anterior',
      'Next Entry' => 'Próxima Entrada',
      'View List' => 'Visão em lista',
      'Attach File' => 'Anexar Arquivo',
      'Skip' => 'Pular',
      'Attribute' => 'Atributo',
      'Function' => 'Função',
      'Self-Assign' => 'Self-Assign',
      'Self-Assigned' => 'Self-Assigned',
      'Expand' => 'Expandir',
      'Collapse' => 'Recolher',
      'Expanded' => 'Expanded',
      'Collapsed' => 'Collapsed',
      'Top Level' => 'Top Level',
      'New notifications' => 'Novas notificações',
      'Manage Categories' => 'Gerenciar Categorias',
      'Manage Folders' => 'Gerenciar Pastas',
      'Convert to' => 'Converter para',
      'View Personal Data' => 'Ver dados pessoais',
      'Personal Data' => 'Dados Pessoais',
      'Erase' => 'Apagar',
      'View Followers' => 'Ver Seguidores',
      'Convert Currency' => 'Converter Moeda',
      'View on Map' => 'Ver no Mapa',
      'Preview' => 'Pré-visualização',
      'Move Over' => 'Mover Sobre',
      'Up' => 'Acima',
      'Save & Continue Editing' => 'Salvar e Continuar Editando',
      'Save & New' => 'Salvar e Novo',
      'Field' => 'Campo',
      'Fields' => 'Fields',
      'Resolution' => 'Resolução',
      'Resolve Conflict' => 'Resolver Conflito',
      'Download' => 'Download',
      'Global Search' => 'Global Search',
      'Navigation Panel' => 'Show Navigation Panel',
      'Copy to Clipboard' => 'Copy to Clipboard',
      'Copied to clipboard' => 'Copied to clipboard',
      'Audit Log' => 'Audit Log',
      'View Audit Log' => 'View Audit Log',
      'View User Access' => 'View User Access',
      'Reacted' => 'Reacted',
      'Reaction Removed' => 'Reaction Removed',
      'Reactions' => 'Reactions',
      'Create In Modal' => 'Create In Modal',
      'Add row' => 'Add Row',
      'Schedule' => 'Schedule',
      'Log' => 'Log',
      'Scheduler' => 'Agendador',
      'Create InboundEmail' => 'Criar E-mail de Entrada',
      'Activities' => 'Atividades',
      'History' => 'Histórico',
      'Attendees' => 'participantes',
      'Schedule Meeting' => 'Agendar Reunião',
      'Schedule Call' => 'Agendar Ligação',
      'Compose Email' => 'Compor E-mail',
      'Log Meeting' => 'Logar Reunião',
      'Log Call' => 'Logar Ligação',
      'Archive Email' => 'Arquivar E-mail',
      'Create Task' => 'Criar Tarefa',
      'Tasks' => 'Tarefas',
      'Start Process' => 'Start Process',
      'Lock' => 'Lock',
      'Unlock' => 'Unlock',
      'kanbanStatusFields' => 'Kanban Status Fields',
      'Merging...' => 'Mesclando...',
      'Removing...' => 'Removendo...',
      'Unlinking...' => 'Removendo relacionamento...',
      'Posting...' => 'Postando...',
      'Saving...' => 'Salvando...'
    ],
    'messages' => [
      'pleaseWait' => 'Por favor aguarde...',
      'loading' => 'Carregando...',
      'saving' => 'Salvando...',
      'confirmLeaveOutMessage' => 'Você tem certeza que quer abandonar o formulário?',
      'notModified' => 'Você não modificou o registro',
      'duplicate' => 'O registro que você está criando parece estar duplicado',
      'dropToAttach' => 'Solte para anexar',
      'pageNumberIsOutOfBound' => 'Page number is out of bound',
      'fieldUrlExceedsMaxLength' => 'Encoded URL exceeds max length of {maxLength}',
      'fieldNotMatchingPattern' => '{field} does not match the pattern `{pattern}`',
      'fieldNotMatchingPattern$noBadCharacters' => '{field} contains not allowed characters',
      'fieldNotMatchingPattern$noAsciiSpecialCharacters' => '{field} should not contain ASCII special characters',
      'fieldNotMatchingPattern$latinLetters' => '{field} can contain only latin letters',
      'fieldNotMatchingPattern$latinLettersDigits' => '{field} can contain only latin letters and digits',
      'fieldNotMatchingPattern$latinLettersDigitsWhitespace' => '{field} can contain only latin letters, digits and whitespace',
      'fieldNotMatchingPattern$latinLettersWhitespace' => '{field} can contain only latin letters and whitespace',
      'fieldNotMatchingPattern$digits' => '{field} can contain only digits',
      'fieldNotMatchingPattern$uriOptionalProtocol' => '{field} must be a valid URL',
      'fieldNotMatchingPattern$phoneNumberLoose' => '{field} contains characters not allowed in a phone number',
      'fieldInvalid' => '{field} é inválido',
      'fieldIsRequired' => '{field} é obrigatório',
      'fieldPhoneInvalid' => '{field} is invalid',
      'fieldPhoneInvalidCode' => 'Invalid country code',
      'fieldPhoneTooShort' => '{field} is too short',
      'fieldPhoneTooLong' => '{field} is too long',
      'fieldPhoneInvalidCharacters' => 'Only digits, latin letters and characters `-+_@:#().` are allowed',
      'fieldPhoneExtensionTooLong' => 'Extension should not be longer than {maxLength}',
      'fieldShouldBeEmail' => '{field} deve ser um e-mail válido',
      'fieldShouldBeFloat' => '{field} deve ser um float válido',
      'fieldShouldBeInt' => '{field} deve ser um valor inteiro',
      'fieldShouldBeNumber' => '{field} should be a valid number',
      'fieldShouldBeDate' => '{field} deve ser uma data válida',
      'fieldShouldBeDatetime' => '{field} deve ser uma data/hora válida',
      'fieldShouldAfter' => '{field} deve ser depois de {otherField}',
      'fieldShouldBefore' => '{field} deve ser antes de {otherField}',
      'fieldShouldBeBetween' => '{field} deve estar entre {min} e {max}',
      'fieldShouldBeLess' => '{field} deve ser menos que {value}',
      'fieldShouldBeGreater' => '{field} deve ser maior que {value}',
      'fieldBadPasswordConfirm' => '{field} confirmado impropriamente',
      'fieldMaxFileSizeError' => 'O arquivo não deve exceder {max} Mb',
      'fieldValueDuplicate' => 'Valor Duplicado',
      'fieldIsUploading' => 'Upload em andamento',
      'fieldExceedsMaxCount' => 'A contagem excede o máximo permitido {maxCount}',
      'barcodeInvalid' => '{field} is not valid {type}',
      'arrayItemMaxLength' => 'Item shouldn\'t be longer than {max} characters',
      'resetPreferencesDone' => 'As preferências foram redefinidas para o padrão',
      'confirmation' => 'Você tem certeza?',
      'unlinkAllConfirmation' => 'Você tem certeza que quer desvincular todos os registros relacionados?',
      'resetPreferencesConfirmation' => 'Você gostaria mesmo de redefinir as preferências para o padrão?',
      'removeRecordConfirmation' => 'Você gostaria mesmo de remover este registro?',
      'unlinkRecordConfirmation' => 'Você gostaria mesmo de desfazer este relacionamento?',
      'removeSelectedRecordsConfirmation' => 'Você gostaria mesmo de remover os registros selecionados?',
      'unlinkSelectedRecordsConfirmation' => 'Tem certeza de que deseja desvincular os registros selecionados?',
      'massUpdateResult' => '{count} registros foram atualizados',
      'massUpdateResultSingle' => '{count} registro foi atualizado',
      'recalculateFormulaConfirmation' => 'Tem certeza de que deseja recalcular a fórmula para os registros selecionados?',
      'noRecordsUpdated' => 'Nenhum registro foi atualizado',
      'massRemoveResult' => '{count} registros foram removidos',
      'massRemoveResultSingle' => '{count} registro foi removido',
      'noRecordsRemoved' => 'Nenhum registro foi removido',
      'clickToRefresh' => 'Clique para atualizar',
      'writeYourCommentHere' => 'Escreva seu comentário aqui',
      'writeMessageToUser' => 'Escreva uma mensagem para {user}',
      'writeMessageToSelf' => 'Escreva uma mensagem no seu stream',
      'typeAndPressEnter' => 'Digite & pressione enter',
      'checkForNewNotifications' => 'Verificar por novas notificações',
      'checkForNewNotes' => 'Verifique se há atualizações de stream',
      'internalPost' => 'A postagem será vista apenas por usuários internos',
      'internalPostTitle' => 'A postagem é vista apenas por usuários internos',
      'done' => 'Feito',
      'notUpdated' => 'Não atualizado',
      'confirmMassUpdate' => 'Are you sure you want to mass-update selected records?',
      'confirmMassFollow' => 'Tem certeza de que deseja seguir os registros selecionados?',
      'confirmMassUnfollow' => 'Tem certeza de que deseja deixar de seguir os registros selecionados?',
      'massFollowResult' => '{count} registros agora são seguidos',
      'massUnfollowResult' => '{count} registros agora não são seguidos',
      'massFollowResultSingle' => '{count} registro agora é seguido',
      'massUnfollowResultSingle' => '{count} registro agora não é seguido',
      'massFollowZeroResult' => 'Nada foi seguido',
      'massUnfollowZeroResult' => 'Nada deixou de ser seguido',
      'erasePersonalDataConfirmation' => 'Os campos marcados serão apagados permanentemente. Tem certeza?',
      'maintenanceModeError' => 'The application currently is in maintenance mode.',
      'maintenanceMode' => 'O aplicativo está atualmente em modo de manutenção. Somente usuários administradores têm acesso.

O modo de manutenção pode ser desabilitado em Administração → Configurações.',
      'resolveSaveConflict' => 'O registro foi modificado. Você precisa resolver o conflito antes de salvar o registro.',
      'massPrintPdfMaxCountError' => 'Não é possível imprimir mais de {maxCount} registros.',
      'massActionProcessed' => 'Ação em massa foi processada.',
      'validationFailure' => 'Backend validation failure.

Field: `{field}`
Validation: `{type}`',
      'extensionLicenseInvalid' => 'Invalid \'{name}\' extension license.',
      'extensionLicenseExpired' => 'The \'{name}\' extension license subscription has expired.',
      'extensionLicenseSoftExpired' => 'The \'{name}\' extension license subscription has expired.',
      'confirmAppRefresh' => 'The application has been updated. It is recommended to refresh the page to ensure the proper functioning.',
      'loggedOutLeaveOut' => 'Logged out. The session is inactive. You may lose unsaved form data after page refresh. You may need to make a copy.',
      'noAccessToRecord' => 'Operation requires `{action}` access to record.',
      'noAccessToForeignRecord' => 'Operation requires `{action}` access to foreign record.',
      'noLinkAccess' => 'Can\'t relate with {foreignEntityType} record through the link \'{link}\'. No access.',
      'cannotUnrelateRequiredLink' => 'Can\'t unrelate required link.',
      'cannotRelateNonExisting' => 'Can\'t relate with non-existing {foreignEntityType} record.',
      'cannotRelateForbidden' => 'Can\'t relate with forbidden {foreignEntityType} record. `{action}` access required.',
      'cannotRelateForbiddenLink' => 'No access to link \'{link}\'.',
      'cannotLinkAlreadyLinked' => 'Cannot link an already linked record.',
      'error404' => 'The url you requested can\'t be handled.',
      'error403' => 'You don\'t have access to this area.',
      'emptyMassUpdate' => 'No fields available for Mass Update.',
      'attemptIntervalFailure' => 'The operation is not allowed during a specific time interval. Wait for some time before the next attempt.',
      'confirmRestoreFromAudit' => 'The previous values will be set in a form. Then you can save the record to restore the previous values.',
      'starsLimitExceeded' => 'The number of stars exceeded the limit.',
      'select2OrMoreRecords' => 'Select 2 or more records',
      'selectNotMoreThanNumberRecords' => 'Select not more than {number} records',
      'selectAtLeastOneRecord' => 'Select at least one record',
      'duplicateConflict' => 'A record already exists.',
      'cannotRemoveCategoryWithChildCategory' => 'Cannot remove a category that has a child category.',
      'cannotRemoveNotEmptyCategory' => 'Cannot remove a non-empty category.',
      'posting' => 'Postando...'
    ],
    'boolFilters' => [
      'onlyMy' => 'Meus',
      'onlyMyTeam' => 'Meu Time',
      'followed' => 'Seguido',
      'shared' => 'Shared'
    ],
    'presetFilters' => [
      'followed' => 'Seguido',
      'all' => 'Todos',
      'starred' => 'Starred'
    ],
    'massActions' => [
      'delete' => 'Delete',
      'remove' => 'Remover',
      'merge' => 'Mesclar',
      'update' => 'Atualizar',
      'massUpdate' => 'Atualização em Massa',
      'unlink' => 'Desvincular',
      'export' => 'Exportar',
      'follow' => 'Seguir',
      'unfollow' => 'Deixar de Seguir',
      'convertCurrency' => 'Converter Moeda',
      'recalculateFormula' => 'Recalcular Fórmula',
      'printPdf' => 'Imprimir para PDF',
      'lock' => 'Lock',
      'unlock' => 'Unlock'
    ],
    'fields' => [
      'name' => 'Nome',
      'firstName' => 'Primeiro Nome',
      'lastName' => 'Sobrenome',
      'middleName' => 'Nome do Meio',
      'salutationName' => 'Saudação',
      'assignedUser' => 'Usuário Designado',
      'assignedUsers' => 'Usuários Designados',
      'collaborators' => 'Collaborators',
      'emailAddress' => 'E-mail',
      'emailAddressData' => 'Dados de Endereço de Email',
      'emailAddressIsOptedOut' => 'Email Address is Opted-Out',
      'emailAddressIsInvalid' => 'Email Address is Invalid',
      'assignedUserName' => 'Nome de Usuário Designado',
      'teams' => 'Times',
      'users' => 'Users',
      'createdAt' => 'Criado em',
      'modifiedAt' => 'Modificado em',
      'createdBy' => 'Criado por',
      'modifiedBy' => 'Modificado por',
      'streamUpdatedAt' => 'Stream Updated At',
      'description' => 'Descrição',
      'address' => 'Endereço',
      'phoneNumber' => 'Telefone',
      'phoneNumberMobile' => 'Telefone (Móvel)',
      'phoneNumberHome' => 'Telefone (Casa)',
      'phoneNumberFax' => 'Telefone (Fax)',
      'phoneNumberOffice' => 'Telefone (Escritório)',
      'phoneNumberOther' => 'Telefone (Outro)',
      'phoneNumberData' => 'Dados do Número de Telefone',
      'phoneNumberIsOptedOut' => 'Phone Number is Opted-Out',
      'phoneNumberIsInvalid' => 'Phone Number is Invalid',
      'order' => 'Pedido',
      'parent' => 'Pai',
      'children' => 'Criança',
      'id' => 'ID',
      'ids' => 'IDs',
      'type' => 'Tipo',
      'names' => 'Nomes',
      'types' => 'Tipos',
      'targetListIsOptedOut' => 'É Cancelado (Lista de Alvo)',
      'childList' => 'Child List',
      'billingAddressCity' => 'Cidade',
      'billingAddressCountry' => 'País',
      'billingAddressPostalCode' => 'CEP',
      'billingAddressState' => 'Estado',
      'billingAddressStreet' => 'Logradouro',
      'billingAddressMap' => 'Mapa',
      'addressCity' => 'Cidade',
      'addressStreet' => 'Logradouro',
      'addressCountry' => 'País',
      'addressState' => 'Estado',
      'addressPostalCode' => 'CEP',
      'addressMap' => 'Mapa',
      'shippingAddressCity' => 'Cidade (Envio)',
      'shippingAddressStreet' => 'Logradouro (Envio)',
      'shippingAddressCountry' => 'País (Envio)',
      'shippingAddressState' => 'Estado (Envio)',
      'shippingAddressPostalCode' => 'CEP (Envio)',
      'shippingAddressMap' => 'Mapa (Envio)',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'productType' => 'Product Type',
      'isDone' => 'Is Done',
      'isNotActual' => 'Is Not Actual',
      'isLocked' => 'Locked',
      'isHardLocked' => 'Hard-Locked',
      'KanbanViewFields' => 'Kanban Status Fields'
    ],
    'links' => [
      'assignedUser' => 'Usuário Designado',
      'assignedUsers' => 'Assigned Users',
      'collaborators' => 'Collaborators',
      'createdBy' => 'Criado por',
      'modifiedBy' => 'Modificado por',
      'team' => 'Time',
      'roles' => 'Regras',
      'teams' => 'Times',
      'users' => 'Usuários',
      'parent' => 'Pai',
      'children' => 'Criança',
      'contacts' => 'Contatos',
      'opportunities' => 'Oportunidades',
      'leads' => 'Leads',
      'meetings' => 'Reuniões',
      'calls' => 'Ligações',
      'tasks' => 'Tarefas',
      'emails' => 'E-mails',
      'accounts' => 'Contas',
      'cases' => 'Atendimentos',
      'documents' => 'Documentos',
      'account' => 'Conta',
      'opportunity' => 'Oportunidade',
      'contact' => 'Contato'
    ],
    'dashlets' => [
      'Stream' => 'Fluxo',
      'Emails' => 'Minha Caixa de Entrada',
      'Iframe' => 'Iframe',
      'Records' => 'Lista de Registro',
      'Memo' => 'Memo',
      'Leads' => 'Meus Leads',
      'Opportunities' => 'Minhas Oportunidades',
      'Tasks' => 'Minhas Tarefas',
      'Cases' => 'Meus Atendimentos',
      'Calendar' => 'Calendário',
      'Calls' => 'Minhas Ligações',
      'Meetings' => 'Minhas Reuniões',
      'OpportunitiesByStage' => 'Oportunidades por Estágio',
      'OpportunitiesByLeadSource' => 'Oportunidades por Origem do Lead',
      'SalesByMonth' => 'Vendas Por Mês',
      'SalesPipeline' => 'Funil de Vendas',
      'Activities' => 'Minhas Atividades',
      'Report' => 'Report',
      'BpmnUserTasks' => 'Process User Tasks',
      'ProjectTask' => 'My Project Tasks'
    ],
    'notificationMessages' => [
      'assign' => '{entityType} {entity} foi atribuído à você',
      'emailReceived' => 'Email recebido de {from}',
      'entityRemoved' => '{user} removido {entityType} {entity}',
      'emailInbox' => '{user} added email {entity} to your inbox',
      'userPostReaction' => '{user} reacted to your {post}',
      'userPostInParentReaction' => '{user} reacted to your {post} in {entityType} {entity}',
      'eventAttendee' => '{user} added you to {entityType} {entity}'
    ],
    'streamMessages' => [
      'post' => '{user} postou em {entityType} {entity}',
      'attach' => '{user} anexou em {entityType} {entity}',
      'status' => '{user} atualizou {field} em {entityType} {entity}',
      'update' => '{user} atualizou {entityType} {entity}',
      'postTargetTeam' => '{user} postou para o time {target}',
      'postTargetTeams' => '{user} postou para os times {target}',
      'postTargetPortal' => '{user} postou para portal {target}',
      'postTargetPortals' => '{user} postou para os portais {target}',
      'postTarget' => '{user} postou para {target}',
      'postTargetYou' => '{user} postou para você',
      'postTargetYouAndOthers' => '{user} postou para {target} e para você',
      'postTargetAll' => '{user} postou para todos',
      'postTargetSelf' => '{user} auto-postado',
      'postTargetSelfAndOthers' => '{user} postaram em {target} neles mesmos',
      'mentionInPost' => '{user} mencionado {mentioned} em {entityType} {entity}',
      'mentionYouInPost' => '{user} mencionou você em {entityType} {entity}',
      'mentionInPostTarget' => '{user} mencionou {mentioned} na postagem',
      'mentionYouInPostTarget' => '{user} mencionou você na postagem para {target}',
      'mentionYouInPostTargetAll' => '{user} mencionou você na postagem para todos',
      'mentionYouInPostTargetNoTarget' => '{user} mencionou você na postagem',
      'create' => '{user} criou {entityType} {entity}',
      'createThis' => '{user} criou {entityType}',
      'createAssignedThis' => '{user} criou {entityType} atribuído a {assignee}',
      'createAssigned' => '{user} criou {entityType} {entity} atribuído a {assignee}',
      'createAssignedYou' => '{user} criou {entityType} {entity} atribuído a você.',
      'createAssignedThisSelf' => '{user} criou este {entityType} auto-atribuído',
      'createAssignedSelf' => '{user} criou {entityType} {entity} auto-atribuído',
      'assign' => '{user} atribuiu {entityType} {entity} a {assignee}',
      'assignThis' => '{user} atribuiu {entityType} a {assignee}',
      'assignYou' => '{user} atribuiu {entityType} {entity} a você',
      'assignThisVoid' => '{user} cancelou a atribuição deste {entityType}',
      'assignVoid' => '{user} não atribuído {entityType} {entity}',
      'assignThisSelf' => '{user} auto-atribuiu este {entityType}',
      'assignSelf' => '{user} auto-atribuído {entityType} {entity}',
      'assignMultiAdd' => '{user} assigned {entity} to {assignee}',
      'assignMultiRemove' => '{user} unassigned {entity} from {removedAssignee}',
      'assignMultiAddRemove' => '{user} assigned {entity} to {assignee} and unassigned from {removedAssignee}',
      'assignMultiAddThis' => '{user} assigned this {entityType} to {assignee}',
      'assignMultiRemoveThis' => '{user} unassigned this {entityType} from {removedAssignee}',
      'assignMultiAddRemoveThis' => '{user} assigned this {entityType} to {assignee} and unassigned from {removedAssignee}',
      'postThis' => '{user} postou',
      'attachThis' => '{user} anexou',
      'statusThis' => '{user} atualizou {field}',
      'updateThis' => '{user} atualizou {entityType}',
      'createRelatedThis' => '{user} criou {relatedEntityType} {relatedEntity} relacionado a {entityType}',
      'createRelated' => '{user} criou {relatedEntityType} {relatedEntity} atribuido a {entityType} {entity}',
      'relate' => '{user} vinculado {relatedEntityType} {relatedEntity} com {entityType} {entity}',
      'relateThis' => '{user} vinculado {relatedEntityType} {relatedEntity} com essa {entityType}',
      'unrelate' => '{user} unlinked {relatedEntityType} {relatedEntity} from {entityType} {entity}',
      'unrelateThis' => '{user} unlinked {relatedEntityType} {relatedEntity} from this {entityType}',
      'emailReceivedFromThis' => 'O e-mail {email} foi recebido de {from}',
      'emailReceivedInitialFromThis' => 'O e-mail {email} foi recebido de e {from} e criou um(a) {entityType}',
      'emailReceivedThis' => 'O e-mail {email} foi recebido',
      'emailReceivedInitialThis' => 'O e-mail {email} foi recebido e criou um(a) {entityType}',
      'emailReceivedFrom' => 'O e-mail {email} relacionado a {entityType} {entity} foi recebido por {from}',
      'emailReceivedFromInitial' => 'O e-mail {email} foi recebido de {from} e criou {entityType} {entity}',
      'emailReceived' => 'O e-mail {email} relacionado a {entityType} {entity} foi recebido',
      'emailReceivedInitial' => 'O e-mail {email} foi recebido e criou {entityType} {entity}',
      'emailReceivedInitialFrom' => 'O e-mail {email} foi recebido de {from} e criou {entityType} {entity}',
      'emailSent' => '{by} enviou o e-mail {email} relacionado a {entityType} {entity}',
      'emailSentThis' => '{by} enviou o e-mail {email}',
      'eventConfirmationAccepted' => '{invitee} accepted participation in {entityType} {entity}',
      'eventConfirmationDeclined' => '{invitee} declined participation in {entityType} {entity}',
      'eventConfirmationTentative' => '{invitee} is tentative about participation in {entityType} {entity}',
      'eventConfirmationAcceptedThis' => '{invitee} accepted participation',
      'eventConfirmationDeclinedThis' => '{invitee} declined participation',
      'eventConfirmationTentativeThis' => '{invitee} is tentative about participation'
    ],
    'streamMessagesMale' => [
      'postTargetSelfAndOthers' => '{user} postou em {target} e em si mesmo'
    ],
    'streamMessagesFemale' => [
      'postTargetSelfAndOthers' => '{user} postou em {target} e nela mesma'
    ],
    'lists' => [
      'monthNames' => [
        0 => 'Janeiro',
        1 => 'Fevereiro',
        2 => 'Março',
        3 => 'Abril',
        4 => 'Maio',
        5 => 'Junho',
        6 => 'Julho',
        7 => 'Agosto',
        8 => 'Setembro',
        9 => 'Outubro',
        10 => 'Novembro',
        11 => 'Dezembro'
      ],
      'monthNamesShort' => [
        0 => 'Jan',
        1 => 'Fev',
        2 => 'Mar',
        3 => 'Abr',
        4 => 'Mai',
        5 => 'Jun',
        6 => 'Jul',
        7 => 'Ago',
        8 => 'Set',
        9 => 'Out',
        10 => 'Nov',
        11 => 'Dez'
      ],
      'dayNames' => [
        0 => 'Domingo',
        1 => 'Segunda',
        2 => 'Terça',
        3 => 'Quarta',
        4 => 'Quinta',
        5 => 'Sexta',
        6 => 'Sábado'
      ],
      'dayNamesShort' => [
        0 => 'Dom',
        1 => 'Seg',
        2 => 'Ter',
        3 => 'Qua',
        4 => 'Qui',
        5 => 'Sex',
        6 => 'Sáb'
      ],
      'dayNamesMin' => [
        0 => 'D',
        1 => 'S',
        2 => 'T',
        3 => 'Q',
        4 => 'Q',
        5 => 'S',
        6 => 'S'
      ]
    ],
    'durationUnits' => [
      'd' => 'd',
      'h' => 'h',
      'm' => 'm',
      's' => 's'
    ],
    'options' => [
      'salutationName' => [
        'Mr.' => 'Sr.',
        'Mrs.' => 'Sra.',
        'Ms.' => 'Srta.',
        'Dr.' => 'Dr.'
      ],
      'language' => [
        'ar_AR' => 'Arabic',
        'af_ZA' => 'Afrikaans',
        'az_AZ' => 'Azerbaijani',
        'be_BY' => 'Belarusian',
        'bg_BG' => 'Bulgarian',
        'bn_IN' => 'Bengali',
        'bs_BA' => 'Bosnian',
        'ca_ES' => 'Catalan',
        'cs_CZ' => 'Czech',
        'cy_GB' => 'Welsh',
        'da_DK' => 'Danish',
        'de_DE' => 'German',
        'el_GR' => 'Greek',
        'en_GB' => 'English (UK)',
        'es_MX' => 'Spanish (Mexico)',
        'en_US' => 'English (US)',
        'es_ES' => 'Spanish (Spain)',
        'et_EE' => 'Estonian',
        'eu_ES' => 'Basque',
        'fa_IR' => 'Persian',
        'fi_FI' => 'Finnish',
        'fo_FO' => 'Faroese',
        'fr_CA' => 'French (Canada)',
        'fr_FR' => 'French (France)',
        'ga_IE' => 'Irish',
        'gl_ES' => 'Galician',
        'gn_PY' => 'Guarani',
        'he_IL' => 'Hebrew',
        'hi_IN' => 'Hindi',
        'hr_HR' => 'Croatian',
        'hu_HU' => 'Hungarian',
        'hy_AM' => 'Armenian',
        'id_ID' => 'Indonesian',
        'is_IS' => 'Icelandic',
        'it_IT' => 'Italian',
        'ja_JP' => 'Japanese',
        'ka_GE' => 'Georgian',
        'km_KH' => 'Khmer',
        'ko_KR' => 'Korean',
        'ku_TR' => 'Kurdish',
        'lt_LT' => 'Lithuanian',
        'lv_LV' => 'Latvian',
        'mk_MK' => 'Macedonian',
        'ml_IN' => 'Malayalam',
        'ms_MY' => 'Malay',
        'nb_NO' => 'Norwegian Bokmål',
        'nn_NO' => 'Norwegian Nynorsk',
        'ne_NP' => 'Nepali',
        'nl_NL' => 'Dutch',
        'pa_IN' => 'Punjabi',
        'pl_PL' => 'Polish',
        'ps_AF' => 'Pashto',
        'pt_BR' => 'Portuguese (Brazil)',
        'pt_PT' => 'Portuguese (Portugal)',
        'ro_RO' => 'Romanian',
        'ru_RU' => 'Russian',
        'sk_SK' => 'Slovak',
        'sl_SI' => 'Slovene',
        'sq_AL' => 'Albanian',
        'sr_RS' => 'Serbian',
        'sv_SE' => 'Swedish',
        'sw_KE' => 'Swahili',
        'ta_IN' => 'Tamil',
        'te_IN' => 'Telugu',
        'th_TH' => 'Thai',
        'tl_PH' => 'Tagalog',
        'tr_TR' => 'Turkish',
        'uk_UA' => 'Ukrainian',
        'ur_PK' => 'Urdu',
        'vi_VN' => 'Vietnamese',
        'zh_CN' => 'Simplified Chinese (China)',
        'zh_HK' => 'Traditional Chinese (Hong Kong)',
        'zh_TW' => 'Traditional Chinese (Taiwan)'
      ],
      'dateSearchRanges' => [
        'on' => 'Em',
        'notOn' => 'Menos em',
        'after' => 'Posterior',
        'before' => 'Anterior',
        'between' => 'Entre',
        'today' => 'Hoje',
        'past' => 'Passado',
        'future' => 'Futuro',
        'currentMonth' => 'Mês corrente',
        'lastMonth' => 'Último mês',
        'nextMonth' => 'Próximo Mês',
        'currentQuarter' => 'Trimestre corrente',
        'lastQuarter' => 'Último trimestre',
        'currentYear' => 'Ano corrente',
        'lastYear' => 'Último ano',
        'lastSevenDays' => 'Últimos 7 Dias',
        'lastXDays' => 'Últimos X Dias',
        'nextXDays' => 'Próximos X Dias',
        'ever' => 'Sempre',
        'isEmpty' => 'É Vazio',
        'olderThanXDays' => 'Mais de X Dias',
        'afterXDays' => 'Após X Dias',
        'currentFiscalYear' => 'Ano Fiscal Atual',
        'lastFiscalYear' => 'Último Ano Fiscal',
        'currentFiscalQuarter' => 'Trimestre Fiscal Atual',
        'lastFiscalQuarter' => 'Último Trimestre Fiscal'
      ],
      'searchRanges' => [
        'is' => 'É',
        'isEmpty' => 'Está Vazio',
        'isNotEmpty' => 'Não Está Vazio',
        'isOneOf' => 'Qualquer',
        'isFromTeams' => 'É do Time',
        'isNot' => 'Não É',
        'isNotOneOf' => 'Nenhum',
        'anyOf' => 'Qualquer',
        'allOf' => 'Todos De',
        'noneOf' => 'Nenhum',
        'any' => 'Qualquer'
      ],
      'varcharSearchRanges' => [
        'equals' => 'Iguais',
        'like' => 'É Como (%)',
        'notLike' => 'Não é Como (%)',
        'startsWith' => 'Inicia Com',
        'endsWith' => 'Termina Com',
        'contains' => 'Contém',
        'notContains' => 'Não Contém',
        'isEmpty' => 'Está Vazio',
        'isNotEmpty' => 'Não Está Vazio',
        'notEquals' => 'Não é Igual'
      ],
      'intSearchRanges' => [
        'equals' => 'Igual',
        'notEquals' => 'Diferente',
        'greaterThan' => 'Maior que',
        'lessThan' => 'Menor que',
        'greaterThanOrEquals' => 'Maior ou igual',
        'lessThanOrEquals' => 'Menor ou igual',
        'between' => 'Entre',
        'isEmpty' => 'É Vazio',
        'isNotEmpty' => 'Não Está Vazio'
      ],
      'autorefreshInterval' => [
        0 => 'Nenhum',
        '0.5' => '30 segundos',
        1 => '1 minuto',
        2 => '2 minutos',
        5 => '5 minutos',
        10 => '10 minutos'
      ],
      'phoneNumber' => [
        'Mobile' => 'Celular',
        'Office' => 'Comercial',
        'Fax' => 'Fax',
        'Home' => 'Residencial',
        'Other' => 'Outro'
      ],
      'saveConflictResolution' => [
        'current' => 'Atual',
        'actual' => 'Real',
        'original' => 'Original'
      ],
      'reminderTypes' => [
        'Popup' => 'Popup',
        'Email' => 'Email'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'sets' => [
      'summernote' => [
        'NOTICE' => 'You can find translation here: https://github.com/HackerWins/summernote/tree/master/lang',
        'font' => [
          'bold' => 'Negrito',
          'italic' => 'Itálico',
          'underline' => 'Sublinhado',
          'strike' => 'Strike',
          'clear' => 'Remover estilo da fonte',
          'height' => 'Altura da linha',
          'name' => 'Família da Fonte',
          'size' => 'Tamanho da fonte'
        ],
        'image' => [
          'image' => 'Imagem',
          'insert' => 'Inserir imagem',
          'resizeFull' => 'Resize Full',
          'resizeHalf' => 'Resize Half',
          'resizeQuarter' => 'Resize Quarter',
          'floatLeft' => 'Float Left',
          'floatRight' => 'Float Right',
          'floatNone' => 'Float None',
          'dragImageHere' => 'Arraste uma imagem para cá',
          'selectFromFiles' => 'Selecione a partir dos arquivos',
          'url' => 'URL da image',
          'remove' => 'Remover imagem'
        ],
        'link' => [
          'link' => 'Link',
          'insert' => 'Inserir link',
          'unlink' => 'Remover link',
          'edit' => 'Editar',
          'textToDisplay' => 'Texto para exibir',
          'url' => 'Para qual URL esse link leva?',
          'openInNewWindow' => 'Abrir em uma nova janela'
        ],
        'video' => [
          'video' => 'Vídeo',
          'videoLink' => 'Link para vídeo',
          'insert' => 'Inserir vídeo',
          'url' => 'URL do vídeo?',
          'providers' => '(YouTube, Vimeo, Vine, Instagram, DailyMotion, ou Youku)'
        ],
        'table' => [
          'table' => 'Tabela'
        ],
        'hr' => [
          'insert' => 'Inserir linha horizontal'
        ],
        'style' => [
          'style' => 'Estilo',
          'normal' => 'Normal',
          'blockquote' => 'Citação',
          'pre' => 'Código',
          'h1' => 'Título 1',
          'h2' => 'Título 2',
          'h3' => 'Título 3',
          'h4' => 'Título 4',
          'h5' => 'Título 5',
          'h6' => 'Título 6'
        ],
        'lists' => [
          'unordered' => 'Lista com marcadores',
          'ordered' => 'Lista numerada'
        ],
        'options' => [
          'help' => 'Ajuda',
          'fullscreen' => 'Tela cheia',
          'codeview' => 'Ver código-fonte'
        ],
        'paragraph' => [
          'paragraph' => 'Parágrafo',
          'outdent' => 'Outdent',
          'indent' => 'Indent',
          'left' => 'Alinhar à esquerda',
          'center' => 'Alinhar ao centro',
          'right' => 'Alinhar à direita',
          'justify' => 'Justify full'
        ],
        'color' => [
          'recent' => 'Cor recente',
          'more' => 'Mais cores',
          'background' => 'Fundo',
          'foreground' => 'Fonte',
          'transparent' => 'Transparente',
          'setTransparent' => 'Fundo transparente',
          'reset' => 'Restaurar',
          'resetToDefault' => 'Restaurar padrão'
        ],
        'shortcut' => [
          'shortcuts' => 'Atalhos do teclado',
          'close' => 'Fechar',
          'textFormatting' => 'Formatação de texto',
          'action' => 'Ação',
          'paragraphFormatting' => 'Formatação de parágrafo',
          'documentStyle' => 'Estilo de documento'
        ],
        'history' => [
          'undo' => 'Desfazer',
          'redo' => 'Refazer'
        ]
      ]
    ],
    'listViewModes' => [
      'list' => 'Lista',
      'kanban' => 'Kanban'
    ],
    'themes' => [
      'Dark' => 'Escuro',
      'Light' => 'Light',
      'Espo' => 'Espo',
      'EspoRtl' => 'RTL',
      'Sakura' => 'Sakura',
      'Violet' => 'Violeta',
      'Hazyblue' => 'Azul Nebuloso',
      'Glass' => 'Glass'
    ],
    'themeNavbars' => [
      'side' => 'Side Navbar',
      'top' => 'Top Navbar'
    ],
    'fieldValidations' => [
      'required' => 'Required',
      'maxCount' => 'Max Count',
      'maxLength' => 'Max Length',
      'pattern' => 'Pattern Matching',
      'emailAddress' => 'Valid Email Address',
      'phoneNumber' => 'Valid Phone Number',
      'array' => 'Array',
      'arrayOfString' => 'Array of Strings',
      'valid' => 'Validity',
      'noEmptyString' => 'No Empty String',
      'max' => 'Max Value',
      'min' => 'Min Value'
    ],
    'fieldValidationExplanations' => [
      'valid' => 'Invalid value.',
      'maxLength' => 'Value length exceeds maximum value.',
      'phone_valid' => 'Phone number is not valid. May be caused by a wrong or empty country code.',
      'url_valid' => 'Invalid URL value.',
      'currency_valid' => 'Invalid amount value.',
      'currency_validCurrency' => 'The currency code value is invalid or not allowed.',
      'varchar_pattern' => 'Likely, the value contains not allowed characters.',
      'email_emailAddress' => 'Invalid email address value.',
      'phone_phoneNumber' => 'Invalid phone number value.',
      'datetimeOptional_valid' => 'Invalid date-time value.',
      'datetime_valid' => 'Invalid date-time value.',
      'date_valid' => 'Invalid date value.',
      'enum_valid' => 'Invalid enum value. The value must be one of defined enum options. An empty value is allowed only if the field has an empty option.',
      'int_valid' => 'Invalid integer number value.',
      'float_valid' => 'Invalid number value.',
      'multiEnum_valid' => 'Invalid multi-enum value. Values must be one of defined field options.'
    ],
    'navbarTabs' => [
      'Business' => 'Business',
      'Marketing' => 'Marketing',
      'Support' => 'Support',
      'CRM' => 'CRM',
      'Activities' => 'Activities',
      'SalesPack' => 'Sales & Purchase'
    ],
    'wysiwygLabels' => [
      'cell' => 'Cell',
      'align' => 'Align',
      'width' => 'Width',
      'height' => 'Height',
      'borderWidth' => 'Border Width',
      'borderColor' => 'Border Color',
      'cellPadding' => 'Cell Padding',
      'backgroundColor' => 'Background Color',
      'verticalAlign' => 'Vertical Align'
    ],
    'wysiwygOptions' => [
      'align' => [
        'left' => 'Left',
        'center' => 'Center',
        'right' => 'Right'
      ],
      'verticalAlign' => [
        'top' => 'Top',
        'middle' => 'Middle',
        'bottom' => 'Bottom'
      ]
    ],
    'detailViewModes' => [
      'detail' => 'Detail'
    ],
    'strings' => [
      'yesterdayShort' => 'Yest'
    ],
    'reactions' => [
      'Smile' => 'Smile',
      'Surprise' => 'Surprise',
      'Laugh' => 'Laugh',
      'Meh' => 'Meh',
      'Sad' => 'Sad',
      'Love' => 'Love',
      'Like' => 'Like',
      'Dislike' => 'Dislike'
    ],
    'recordActions' => [
      'create' => 'Create',
      'read' => 'Read',
      'edit' => 'Edit',
      'delete' => 'Delete',
      'stream' => 'Stream'
    ],
    'tabs' => [
      'Stream' => 'Stream'
    ],
    'featureEnableInfo' => [
      'PriceBooks' => 'The *Price Books* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'Warehouses' => 'The *Warehouses* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).',
      'InventoryTransactions' => 'The *Inventory Transactions* feature is not enabled. You can enable it at Administration > Sales Pack > [Settings](#Admin/salesPackSettings).'
    ]
  ],
  'GroupEmailFolder' => [
    'links' => [
      'emails' => 'Emails'
    ],
    'labels' => [
      'Create GroupEmailFolder' => 'Create Folder'
    ]
  ],
  'Import' => [
    'labels' => [
      'New import with same params' => 'Nova importação com os mesmos parâmetros',
      'Revert Import' => 'Reverter Importar',
      'Return to Import' => 'Retornar a Importação',
      'Run Import' => 'Executar importação',
      'Back' => 'Voltar',
      'Field Mapping' => 'Mapeamento de Campos',
      'Default Values' => 'Valores Padrão',
      'Add Field' => 'Adicionar Campo',
      'Created' => 'Criado',
      'Updated' => 'Atualizado',
      'Result' => 'Resultado',
      'Show records' => 'Exibir Registros',
      'Remove Duplicates' => 'Remover Duplicados',
      'importedCount' => 'Importados (Quant.)',
      'duplicateCount' => 'Duplicados (Quant.)',
      'updatedCount' => 'Atualizados (Quant.)',
      'Create Only' => 'Criar Apenas',
      'Create and Update' => 'Criar & Atualizar',
      'Update Only' => 'Somente Atualizar',
      'Update by' => 'Atualizado por',
      'Set as Not Duplicate' => 'Marcar como não duplicado',
      'File (CSV)' => 'Arquivo (CSV)',
      'First Row Value' => 'Valor Primeira Linha',
      'Skip' => 'Pular',
      'Header Row Value' => 'Valor Linha do Cabeçalho',
      'Field' => 'Campo',
      'What to Import?' => 'O que Importar?',
      'Entity Type' => 'Tipo de Entidade',
      'What to do?' => 'O que fazer?',
      'Properties' => 'Propriedades',
      'Header Row' => 'Linha do Cabeçalho',
      'Person Name Format' => 'Formato Nome da Pessoa',
      'John Smith' => 'João Silva',
      'Smith John' => 'Silva João',
      'Smith, John' => 'Silva, João',
      'Field Delimiter' => 'Delimitar Campo',
      'Date Format' => 'Formato da Data',
      'Decimal Mark' => 'Ponto Decimal',
      'Text Qualifier' => 'Qualificador de Texto',
      'Time Format' => 'Formato de data',
      'Currency' => 'Moeda',
      'Preview' => 'Anterior',
      'Next' => 'Próximo',
      'Step 1' => 'Passo 1',
      'Step 2' => 'Passo 2',
      'Double Quote' => 'Aspas Duplas',
      'Single Quote' => 'Aspas Simples',
      'Imported' => 'Importado',
      'Duplicates' => 'Duplicados',
      'Skip searching for duplicates' => 'Pular a busca por duplicatas',
      'Timezone' => 'Fuso Horário',
      'Remove Import Log' => 'Remover Log de Importação',
      'New Import' => 'Nova Importação',
      'Import Results' => 'Resultados da Importação',
      'Run Manually' => 'Executar Manualmente',
      'Silent Mode' => 'Modo silencioso',
      'Export' => 'Export'
    ],
    'messages' => [
      'importRunning' => 'Import running...',
      'noErrors' => 'No errors',
      'utf8' => 'Deve estar codificado com UTF-8',
      'duplicatesRemoved' => 'Duplicados removidos',
      'inIdle' => 'Executar em modo inativo (para big data; via cron)',
      'revert' => 'Isso removerá todos os registros importados permanentemente.',
      'removeDuplicates' => 'Isso removerá permanentemente todos os registros importados que foram reconhecidos como duplicados.',
      'confirmRevert' => 'Isso removerá todos os registros importados permanentemente. Tem certeza?',
      'confirmRemoveDuplicates' => 'Isso removerá permanentemente todos os registros importados que foram reconhecidos como duplicados. Tem certeza?',
      'confirmRemoveImportLog' => 'Isso removerá o log de importação. Todos os registros importados serão mantidos. Você não poderá reverter os resultados da importação. Tem certeza?',
      'removeImportLog' => 'Isso removerá o log de importação. Todos os registros importados serão mantidos. Use-o se tiver certeza de que a importação está correta.'
    ],
    'params' => [
      'phoneNumberCountry' => 'Telephone country code'
    ],
    'fields' => [
      'file' => 'Arquivo',
      'entityType' => 'Tipo de Entidade',
      'imported' => 'Registros Importados',
      'duplicates' => 'Registros Duplicados',
      'updated' => 'Registros Atualizados',
      'status' => 'Status'
    ],
    'links' => [
      'errors' => 'Errors'
    ],
    'options' => [
      'status' => [
        'Failed' => 'Falhou',
        'Standby' => 'Em Espera',
        'Pending' => 'Pendente',
        'In Process' => 'Em Processo',
        'Complete' => 'Completo'
      ],
      'personNameFormat' => [
        'f l' => 'Primeiro Último',
        'l f' => 'Último Primeiro',
        'f m l' => 'Primeiro Meio Último',
        'l f m' => 'Último Primeiro Meio',
        'l, f' => 'Último, Primeiro'
      ]
    ],
    'strings' => [
      'commandToRun' => 'Comando para executar (da CLI)',
      'saveAsDefault' => 'Salvar como padrão'
    ],
    'tooltips' => [
      'manualMode' => 'Se marcado, você precisará executar a importação manualmente da CLI. O comando será mostrado após configurar a importação.',
      'silentMode' => 'A maioria dos scripts pós-salvamento será ignorada, as notas de transmissão não serão criadas. A importação será executada mais rapidamente.'
    ]
  ],
  'ImportError' => [
    'fields' => [
      'type' => 'Type',
      'validationFailures' => 'Validation Failures',
      'import' => 'Import',
      'rowIndex' => 'Row Index',
      'exportRowIndex' => 'Export Row Index',
      'lineNumber' => 'Line Number',
      'exportLineNumber' => 'Export Line Number',
      'row' => 'Row',
      'entityType' => 'Entity Type'
    ],
    'options' => [
      'type' => [
        'Validation' => 'Validation',
        'Access' => 'Access',
        'Not-Found' => 'Not-Found'
      ]
    ],
    'tooltips' => [
      'lineNumber' => 'A line number in the original CSV.',
      'exportLineNumber' => 'A line number in the export CSV.'
    ]
  ],
  'InboundEmail' => [
    'fields' => [
      'name' => 'Nome',
      'emailAddress' => 'Endereço de Email',
      'team' => 'Time',
      'status' => 'Status',
      'assignToUser' => 'Atribuído a',
      'host' => 'Host',
      'username' => 'Usuário',
      'password' => 'Senha',
      'port' => 'Porta',
      'monitoredFolders' => 'Pastas Monitoradas',
      'trashFolder' => 'Pasta da Lixeira',
      'security' => 'Segurança',
      'createCase' => 'Criar Atendimento',
      'reply' => 'Responder',
      'caseDistribution' => 'Distribuição do Atendimento',
      'replyEmailTemplate' => 'Template do E-mail de Resposta',
      'replyFromAddress' => 'E-mail de Resposta (From)',
      'replyToAddress' => 'Responder para o Endereço',
      'replyFromName' => 'Nome de Resposta (FromName)',
      'targetUserPosition' => 'Posição do usuário alvo',
      'fetchSince' => 'Buscados Desde',
      'addAllTeamUsers' => 'Para todos os usuários do time',
      'teams' => 'Times',
      'sentFolder' => 'Pasta Enviados',
      'storeSentEmails' => 'Guardar Emails Enviados',
      'keepFetchedEmailsUnread' => 'Manter Emails Buscados Não Lidos',
      'connectedAt' => 'Connected At',
      'excludeFromReply' => 'Exclude from Reply',
      'useImap' => 'Buscar emails',
      'useSmtp' => 'Usar SMTP',
      'smtpHost' => 'Servidor SMTP',
      'smtpPort' => 'Porta SMTP',
      'smtpAuth' => 'Auth SMTP',
      'smtpSecurity' => 'Segurança SMTP',
      'smtpAuthMechanism' => 'Mecanismo de autenticação SMTP',
      'smtpUsername' => 'Nome de Usuário SMTP',
      'smtpPassword' => 'Senha SMTP',
      'fromName' => 'De Nome',
      'smtpIsShared' => 'SMTP é Compartilhado',
      'smtpIsForMassEmail' => 'SMTP é para email em massa',
      'groupEmailFolder' => 'Group Email Folder',
      'isSystem' => 'Is System',
      'ssl' => 'SSL'
    ],
    'tooltips' => [
      'isSystem' => 'Is the system email account.',
      'useSmtp' => 'A capacidade de enviar e-mails.',
      'reply' => 'Notificar rementente que seus e-mails foram recebidos.',
      'createCase' => 'Criar automaticamente um atendimento para os e-mais recebidos.',
      'replyToAddress' => 'Especifique o endereço de e-mail desta caixa postal para que as respostas cheguem aqui.',
      'caseDistribution' => 'Como os atendimentos serão distribuídos. Assinados diretamente ao usuário ou entregues ao time.',
      'assignToUser' => 'Usuário responsável pelos e-mails/atendimentos.',
      'team' => 'Time que será relacionado aos e-mails/atendimentos.',
      'teams' => 'Os emails do Time serão atribuídos.',
      'targetUserPosition' => 'Define a posição dos usuários para quem serão distribuídos os atendimentos.',
      'addAllTeamUsers' => 'Os emails aparecerão na caixa de entrada de todos os usuários dos times especificados.',
      'monitoredFolders' => 'Várias pastas devem ser separadas por vírgula.',
      'smtpIsShared' => 'Se marcado, os usuários poderão enviar e-mails usando este SMTP. A disponibilidade é controlada por Regras por meio da permissão Conta de Email do Grupo.',
      'smtpIsForMassEmail' => 'Se marcado, o SMTP estará disponível para email em massa.',
      'storeSentEmails' => 'Os emails enviados serão armazenados no servidor IMAP.',
      'groupEmailFolder' => 'Put incoming emails in a group folder.',
      'excludeFromReply' => 'When replying on emails sent to this account\'s email address, its email address won\'t be added to CC.

Note that by enabling this parameter, the email address of this account will be exposed to users who have access to send Emails.'
    ],
    'links' => [
      'filters' => 'Filtros',
      'emails' => 'Emails',
      'assignToUser' => 'Atribuir ao Usuário',
      'groupEmailFolder' => 'Group Email Folder'
    ],
    'options' => [
      'status' => [
        'Active' => 'Ativo',
        'Inactive' => 'Inativo'
      ],
      'caseDistribution' => [
        '' => 'Nenhum',
        'Direct-Assignment' => 'Atribuição Direta',
        'Round-Robin' => 'Rodízio',
        'Least-Busy' => 'Menos Ocupado'
      ],
      'smtpAuthMechanism' => [
        'plain' => 'PLAIN',
        'login' => 'LOGIN',
        'crammd5' => 'CRAM-MD5'
      ]
    ],
    'labels' => [
      'Create InboundEmail' => 'Criar E-mail de Entrada',
      'IMAP' => 'IMAP',
      'Actions' => 'Ações',
      'Main' => 'Principal'
    ],
    'messages' => [
      'couldNotConnectToImap' => 'Não foi possível conectar ao servidor IMAP',
      'imapNotConnected' => 'Could not connect to group [IMAP account](#InboundEmail/view/{id}).'
    ]
  ],
  'Integration' => [
    'fields' => [
      'enabled' => 'Habilitado',
      'clientId' => 'Client ID',
      'clientSecret' => 'Client Secret',
      'redirectUri' => 'URL de Redirecionamento',
      'apiKey' => 'Chave de API',
      'siteKey' => 'Site Key',
      'secretKey' => 'Secret Key',
      'scoreThreshold' => 'Score Threshold'
    ],
    'titles' => [
      'GoogleMaps' => 'Google Maps',
      'GoogleReCaptcha' => 'Google reCAPTCHA'
    ],
    'messages' => [
      'selectIntegration' => 'Selecione uma integração no menu.',
      'noIntegrations' => 'Nenhuma integração disponível.'
    ],
    'help' => [
      'GoogleReCaptcha' => 'Obtain the Site Key and Secret Key from [Google](https://www.google.com/recaptcha/).',
      'Google' => '**Obtenha as credenciais do OAuth 2.0 no Google Developers Console.**

Visite o [Google Developers Console](https://console.developers.google.com/project) para obter credenciais do OAuth 2.0, como um ID do cliente e um "Client Secret", que são conhecidos pelo aplicativo do Google e do TD SYNNEX.',
      'GoogleMaps' => 'Obtenha a chave de API [aqui] (https://developers.google.com/maps/documentation/javascript/get-api-key).'
    ]
  ],
  'Job' => [
    'fields' => [
      'status' => 'Estado',
      'executeTime' => 'Executar Em',
      'executedAt' => 'Executado Em',
      'startedAt' => 'Iniciado Em',
      'attempts' => 'Tentativas Restantes',
      'failedAttempts' => 'Tentativas Falhas',
      'serviceName' => 'Serviço',
      'method' => 'Método (obsoleto)',
      'methodName' => 'Método',
      'scheduledJob' => 'Tarefas agendadas',
      'scheduledJobJob' => 'Nome Tarefa Agendada',
      'data' => 'Dado',
      'targetType' => 'Tipo de Alvo',
      'targetId' => 'ID do Alvo',
      'number' => 'Número',
      'queue' => 'Fila',
      'group' => 'Grupo',
      'className' => 'Nome da Classe',
      'targetGroup' => 'Grupo Alvo',
      'job' => 'Trabalho (Job)'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendente',
        'Success' => 'Sucesso',
        'Running' => 'Executando',
        'Failed' => 'Falhado'
      ]
    ]
  ],
  'LayoutManager' => [
    'fields' => [
      'width' => 'Largura (%)',
      'link' => 'Link',
      'notSortable' => 'Não Classificável',
      'align' => 'Alinhar',
      'panelName' => 'Nome do Painel',
      'style' => 'Estilo',
      'sticked' => 'Stick to top',
      'isMuted' => 'Muted color',
      'isLarge' => 'Tamanho de fonte grande',
      'hidden' => 'Oculto',
      'noLabel' => 'No Label',
      'dynamicLogicVisible' => 'Condições que tornam o painel visível',
      'dynamicLogicStyled' => 'Condições que fazem o estilo aplicado',
      'tabLabel' => 'Tab Label',
      'tabBreak' => 'Tab-Break',
      'noteText' => 'Note Text',
      'noteStyle' => 'Note Style'
    ],
    'options' => [
      'align' => [
        'left' => 'Esquerda',
        'right' => 'Direita'
      ],
      'style' => [
        'default' => 'Padrão',
        'success' => 'Sucesso',
        'danger' => 'Perigo',
        'info' => 'Info',
        'warning' => 'Aviso',
        'primary' => 'Primário'
      ]
    ],
    'labels' => [
      'New panel' => 'Novo Painel',
      'Layout' => 'Layout'
    ],
    'messages' => [
      'alreadyExists' => 'Layout `{name}` already exists.',
      'createInfo' => 'Custom list layouts can be used by relationship panels.',
      'cantBeEmpty' => 'O layout não pode estar vazio.',
      'fieldsIncompatible' => 'Os campos não podem estar juntos no layout: {fields}.'
    ],
    'tooltips' => [
      'noteText' => 'A text to be displayed in the panel. Markdown is supported.',
      'tabBreak' => 'A separate tab for the panel and all following panels until the next tab-break.',
      'noLabel' => 'Don\'t display a column label in the header.',
      'notSortable' => 'Disables the ability to sort by the column.',
      'width' => 'A column width. It\'s recommended to have one column without specified width, usually it should be the *Name* field.',
      'sticked' => 'O painel será colado no painel acima. Sem folga entre os painéis.',
      'hiddenPanel' => 'Precisa clicar em \'mostrar mais\' para ver o painel.',
      'panelStyle' => 'Uma cor do painel.',
      'dynamicLogicVisible' => 'Se definido, o painel ficará oculto, a menos que a condição seja atendida.',
      'dynamicLogicStyled' => 'Uma cor será aplicada se uma condição específica for atendida. A cor é definida pelo parâmetro *Estilo*.',
      'link' => 'Se marcado, um valor de campo será exibido como um link apontando para a visualização de detalhes do registro. Normalmente é usado para campos *Nome*.'
    ]
  ],
  'LayoutSet' => [
    'fields' => [
      'layoutList' => 'Layouts'
    ],
    'labels' => [
      'Create LayoutSet' => 'Criar Conjunto de Layout',
      'Edit Layouts' => 'Editar Layouts'
    ],
    'tooltips' => []
  ],
  'LeadCapture' => [
    'fields' => [
      'name' => 'Nome',
      'campaign' => 'Campanha',
      'isActive' => 'Está Ativo',
      'subscribeToTargetList' => 'Inscrito na Lista de Alvo',
      'subscribeContactToTargetList' => 'Inscrever Contato caso existir',
      'targetList' => 'Lista de Alvo',
      'fieldList' => 'Payload Fields',
      'optInConfirmation' => 'Double Opt-In',
      'optInConfirmationEmailTemplate' => 'Opt-in confirmation email template',
      'optInConfirmationLifetime' => 'Opt-in confirmation lifetime (hours)',
      'optInConfirmationSuccessMessage' => 'Text to show after opt-in confirmation',
      'leadSource' => 'Origem do Lead',
      'apiKey' => 'Chave de API',
      'targetTeam' => 'Time Alvo',
      'exampleRequestMethod' => 'Método',
      'exampleRequestUrl' => 'URL',
      'exampleRequestPayload' => 'Payload',
      'exampleRequestHeaders' => 'Headers',
      'createLeadBeforeOptInConfirmation' => 'Criar Lead antes da confirmação',
      'skipOptInConfirmationIfSubscribed' => 'Pule a confirmação se o lead já estiver na lista de destino',
      'smtpAccount' => 'Conta SMTP',
      'inboundEmail' => 'Conta de Email do Grupo',
      'duplicateCheck' => 'Verificar Duplicados',
      'phoneNumberCountry' => 'Telephone country code',
      'fieldParams' => 'Field Params',
      'formId' => 'Form ID',
      'formEnabled' => 'Web Form',
      'formUrl' => 'Form URL',
      'formSuccessText' => 'Text to display after form submission',
      'formText' => 'Text to display on form',
      'formSuccessRedirectUrl' => 'URL to redirect to after form submission',
      'formLanguage' => 'Language used on form',
      'formFrameAncestors' => 'Allowed hosts for form embedding',
      'formCaptcha' => 'Use Captcha'
    ],
    'links' => [
      'targetList' => 'Lista de Alvo',
      'campaign' => 'Campanha',
      'optInConfirmationEmailTemplate' => 'Opt-in confirmation email template',
      'targetTeam' => 'Time Alvo',
      'inboundEmail' => 'Conta de Email do Grupo',
      'logRecords' => 'Log'
    ],
    'labels' => [
      'Create LeadCapture' => 'Criar Ponto de Entrada',
      'Generate New API Key' => 'Gerar Nova Chave de API',
      'Request' => 'Solicitação',
      'Confirm Opt-In' => 'Confirm Opt-In',
      'Generate New Form ID' => 'Generate New Form ID',
      'Web Form' => 'Web Form'
    ],
    'messages' => [
      'generateApiKey' => 'Criar Nova Chave de API',
      'optInConfirmationExpired' => 'Opt-in confirmation link is expired.',
      'optInIsConfirmed' => 'Opt-in is confirmed.'
    ],
    'tooltips' => [
      'formCaptcha' => 'To be able to use Captcha, you need to configure it under **Administration** > **Integrations**.',
      'optInConfirmationSuccessMessage' => 'Markdown é suportado.'
    ]
  ],
  'LeadCaptureLogRecord' => [
    'fields' => [
      'number' => 'Número',
      'data' => 'Data',
      'target' => 'Alvo',
      'leadCapture' => 'Captura de Lead',
      'createdAt' => 'Inserido Em',
      'isCreated' => 'É Lead Criado'
    ],
    'links' => [
      'leadCapture' => 'Captura de Lead',
      'target' => 'Alvo'
    ]
  ],
  'MassAction' => [
    'fields' => [
      'status' => 'Status',
      'processedCount' => 'Contagem processada'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendente',
        'Running' => 'Executando',
        'Success' => 'Sucesso',
        'Failed' => 'Falhou'
      ]
    ],
    'messages' => [
      'infoText' => 'A ação em massa está sendo processada em modo inativo pelo cron. Pode levar algum tempo para terminar. Fechar esta caixa de diálogo modal não afetará o processo de execução.'
    ]
  ],
  'Note' => [
    'fields' => [
      'post' => 'Postagem',
      'attachments' => 'Anexos',
      'targetType' => 'Alvo',
      'teams' => 'Times',
      'users' => 'Usuários',
      'portals' => 'Portais',
      'type' => 'Tipo',
      'isGlobal' => 'É Global',
      'isInternal' => 'É interno (para usuários internos)',
      'isPinned' => 'Is Pinned',
      'related' => 'Relacionado',
      'createdByGender' => 'Criado por Gênero',
      'data' => 'Dado',
      'number' => 'Número'
    ],
    'filters' => [
      'all' => 'Todos',
      'posts' => 'Posts',
      'updates' => 'Atualizações',
      'activity' => 'Activity'
    ],
    'options' => [
      'targetType' => [
        'self' => 'para mim',
        'users' => 'para determinado(s) usuário(s)',
        'teams' => 'para determinado(s) time(s)',
        'all' => 'para todos os usuários internos',
        'portals' => 'para usuários do portal'
      ],
      'type' => [
        'Post' => 'Postagem',
        'Create' => 'Create',
        'CreateRelated' => 'Create Related',
        'Update' => 'Update',
        'Status' => 'Status',
        'Assign' => 'Assign',
        'Relate' => 'Relate',
        'Unrelate' => 'Unrelate',
        'EmailReceived' => 'Email Received',
        'EmailSent' => 'Email Sent'
      ]
    ],
    'labels' => [
      'View Posts' => 'View Posts',
      'View Activity' => 'View Activity',
      'Pin' => 'Pin',
      'Unpin' => 'Unpin',
      'Pinned' => 'Pinned',
      'Quote Reply' => 'Quote Reply'
    ],
    'messages' => [
      'writeMessage' => 'Escreva sua mensagem aqui',
      'pinnedMaxCountExceeded' => 'Cannot pin more notes. Max allowed number is {count}.'
    ],
    'links' => [
      'portals' => 'Portals',
      'attachments' => 'Attachments',
      'superParent' => 'Super Parent',
      'related' => 'Relacionado'
    ]
  ],
  'PhoneNumber' => [
    'fields' => [
      'type' => 'Tipo',
      'optOut' => 'Cancelado',
      'invalid' => 'Inválido',
      'numeric' => 'Numeric Value'
    ],
    'presetFilters' => [
      'orphan' => 'Órfão'
    ]
  ],
  'Portal' => [
    'fields' => [
      'name' => 'Nome',
      'logo' => 'Logo',
      'url' => 'URL',
      'portalRoles' => 'Regras',
      'isActive' => 'Está Ativo',
      'isDefault' => 'É padrão',
      'tabList' => 'Lista de Aba',
      'applicationName' => 'Application Name',
      'quickCreateList' => 'Criar Lista Rápida',
      'companyLogo' => 'Logo',
      'theme' => 'Tema',
      'language' => 'Linguagem',
      'dashboardLayout' => 'Layout do Dashboard',
      'dateFormat' => 'Formato de data',
      'timeFormat' => 'Formato de hora',
      'timeZone' => 'Fuso Horário',
      'weekStart' => 'Primeiro Dia da Semana',
      'defaultCurrency' => 'Moeda Padrão',
      'layoutSet' => 'Conjunto de Layout',
      'authenticationProvider' => 'Authentication Provider',
      'customUrl' => 'URL Personalizada',
      'customId' => 'ID Personalizada',
      'authTokenLifetime' => 'Auth Token Lifetime (hours)',
      'authTokenMaxIdleTime' => 'Auth Token Max Idle Time (hours)'
    ],
    'links' => [
      'users' => 'Usuários',
      'portalRoles' => 'Regras',
      'layoutSet' => 'Conjunto de Layout',
      'authenticationProvider' => 'Authentication Provider',
      'notes' => 'Notas',
      'articles' => 'Artigos da Base de Conhecimento'
    ],
    'tooltips' => [
      'layoutSet' => 'Fornece a capacidade de ter layouts que diferem dos padrões.',
      'portalRoles' => 'As Regras de Portal especificadas serão aplicadas a todos os usuários deste portal.'
    ],
    'labels' => [
      'Create Portal' => 'Criar portal',
      'User Interface' => 'Interface do Usuário',
      'General' => 'Geral',
      'Settings' => 'Configurações'
    ]
  ],
  'PortalRole' => [
    'fields' => [
      'exportPermission' => 'Exportar Permissão',
      'massUpdatePermission' => 'Permissão de Atualização em Massa',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuários'
    ],
    'labels' => [
      'Access' => 'Acesso',
      'Create PortalRole' => 'Criar Regra de Portal',
      'Scope Level' => 'Nível do Escopo',
      'Field Level' => 'Nível do Campo'
    ],
    'tooltips' => [
      'exportPermission' => 'Define se os usuários do portal têm a capacidade de exportar registros.',
      'massUpdatePermission' => 'Define se os usuários do portal têm a capacidade de fazer atualização em massa de registros.'
    ]
  ],
  'PortalUser' => [
    'labels' => [
      'Create PortalUser' => 'Criar Usuário do Portal'
    ]
  ],
  'Preferences' => [
    'fields' => [
      'dateFormat' => 'Formato da Data',
      'timeFormat' => 'Formato da Hora',
      'timeZone' => 'Time Zone',
      'weekStart' => 'Primeiro dia da Semana',
      'thousandSeparator' => 'Separador de milhar',
      'decimalMark' => 'Separador decimal',
      'defaultCurrency' => 'Moeda Padrão',
      'currencyList' => 'Moedas Disponíveis',
      'language' => 'Idioma',
      'exportDelimiter' => 'Delimitador de Exportação',
      'receiveAssignmentEmailNotifications' => 'Receber e-mail de notificação quando designado',
      'receiveMentionEmailNotifications' => 'Notificações por email sobre menções em postagens',
      'receiveStreamEmailNotifications' => 'Notificações por email sobre postagens e atualizações de status',
      'assignmentNotificationsIgnoreEntityTypeList' => 'Notificações de Atribuição no Aplicativo',
      'assignmentEmailNotificationsIgnoreEntityTypeList' => 'Notificações de atribuição de email',
      'reactionNotifications' => 'In-app notifications about reactions',
      'autoFollowEntityTypeList' => 'Auto-Seguir',
      'signature' => 'Assinatura do E-mail',
      'dashboardTabList' => 'Lista de Aba',
      'defaultReminders' => 'Lembretes Padrão',
      'defaultRemindersTask' => 'Default Reminders for Tasks',
      'theme' => 'Tema',
      'useCustomTabList' => 'Personalizar Lista de Aba',
      'addCustomTabs' => 'Add Custom Tabs',
      'tabList' => 'Lista de Aba',
      'emailReplyToAllByDefault' => 'Resposta por Email para todos por padrão',
      'dashboardLayout' => 'Layout de Dashboard',
      'dashboardLocked' => 'Lock Dashboard',
      'emailReplyForceHtml' => 'Resposta de Email em HTML',
      'doNotFillAssignedUserIfNotRequired' => 'Não preencha previamente o usuário designado na criação do registro',
      'followEntityOnStreamPost' => 'Auto-follow record after posting in Stream',
      'followCreatedEntities' => 'Seguir automaticamente registros criados',
      'followCreatedEntityTypeList' => 'Auto-follow created records of specific entity types',
      'emailUseExternalClient' => 'Use um cliente de email externo',
      'textSearchStoringDisabled' => 'Disable text filter storing',
      'calendarSlotDuration' => 'Calendar Slot Duration',
      'calendarScrollHour' => 'Calendar Scroll to Hour',
      'scopeColorsDisabled' => 'Desativar cores do escopo'
    ],
    'links' => [],
    'options' => [
      'weekStart' => [
        0 => 'Domingo',
        1 => 'Segunda'
      ]
    ],
    'labels' => [
      'Notifications' => 'Notificações',
      'User Interface' => 'Interface de Usuário',
      'Misc' => 'Misc',
      'Locale' => 'Local',
      'Reset Dashboard to Default' => 'Redefinir Dashboard para o padrão'
    ],
    'tooltips' => [
      'addCustomTabs' => 'If checked, custom tabs will be appended to default tabs. Otherwise, custom tabs will be used instead of default tabs.',
      'autoFollowEntityTypeList' => 'O usuário seguirá automaticamente todos os novos registros das entidades selecionadas, verá informações no fluxo e receberá notificações.',
      'doNotFillAssignedUserIfNotRequired' => 'Ao criar o registro, o usuário desginado não será preenchido com o próprio usuário, a menos que o campo seja obrigatório.',
      'followCreatedEntities' => 'Ao criar novos registros, eles serão seguidos automaticamente mesmo que atribuídos a outro usuário.',
      'followCreatedEntityTypeList' => 'Ao criar novos registros de tipos de entidade selecionados, eles serão seguidos automaticamente mesmo se atribuídos a outro usuário.'
    ],
    'tabFields' => [
      'label' => 'Label',
      'iconClass' => 'Icon',
      'color' => 'Color'
    ]
  ],
  'Role' => [
    'fields' => [
      'name' => 'Nome',
      'roles' => 'Regras',
      'assignmentPermission' => 'Atribuição de Permissões',
      'userPermission' => 'Permissão de Usuário',
      'messagePermission' => 'Message Permission',
      'portalPermission' => 'Permissão de Portal',
      'groupEmailAccountPermission' => 'Permissão da Conta de Email do Grupo',
      'exportPermission' => 'Exportar Permissão',
      'massUpdatePermission' => 'Permissão de Atualização em Massa',
      'followerManagementPermission' => 'Permissão de Gerenciamento de Seguidores',
      'dataPrivacyPermission' => 'Permissão de Privacidade de Dados',
      'auditPermission' => 'Audit Permission',
      'mentionPermission' => 'Mention Permission',
      'userCalendarPermission' => 'User Calendar Permission',
      'data' => 'Data',
      'fieldData' => 'Field Data'
    ],
    'links' => [
      'users' => 'Usuários',
      'teams' => 'Times'
    ],
    'tooltips' => [
      'messagePermission' => 'Allows to send messages to other users.

* all – can send to all
* team – can send only to teammates
* no – cannot send',
      'assignmentPermission' => 'Permite restringir a habilidade para usuários atribuírem registros para outros usuários.

tudo - nenhuma restrição

time - pode atribuir para usuários do seu time

nenhum - pode atribuir apenas para si mesmo',
      'userPermission' => 'Permite restringir a habilidade para usuários visualizarem atividades, calendários e fluxos de outros usuários.

tudo - nenhuma restrição

time - pode ver atividades dos colegas de time apenas

nenhum - não pode visualizar',
      'userCalendarPermission' => 'Allows to view calendars of other users.',
      'portalPermission' => 'Define um acesso às informações do portal, capacidade de postar mensagens para usuários do portal.',
      'groupEmailAccountPermission' => 'Define um acesso às contas de e-mail do grupo, uma capacidade de enviar e-mails do grupo SMTP.',
      'exportPermission' => 'Define se os usuários têm a capacidade de exportar registros.',
      'massUpdatePermission' => 'Define se os usuários têm a capacidade de fazer atualização em massa de registros.',
      'followerManagementPermission' => 'Permite gerenciar seguidores de registros específicos.',
      'dataPrivacyPermission' => 'Permite visualizar e apagar dados pessoais.',
      'auditPermission' => 'Allows to view the audit log.',
      'mentionPermission' => 'Allows to mention other users in the Stream.

* all – can mention all
* team – can mention only teammates
* no – cannot mention'
    ],
    'labels' => [
      'Access' => 'Acesso',
      'Create Role' => 'Criar Regra',
      'Scope Level' => 'Nível do Escopo',
      'Field Level' => 'Nível do Campo'
    ],
    'options' => [
      'accessList' => [
        'not-set' => 'indefinido',
        'enabled' => 'habilitado',
        'disabled' => 'desabilitado'
      ],
      'levelList' => [
        'all' => 'tudo',
        'team' => 'time',
        'account' => 'conta',
        'contact' => 'contato',
        'own' => 'próprio',
        'no' => 'nenhum',
        'yes' => 'sim',
        'not-set' => 'indefinido'
      ]
    ],
    'actions' => [
      'read' => 'Ler',
      'edit' => 'Editar',
      'delete' => 'Excluir',
      'stream' => 'Fluxo',
      'create' => 'Criar'
    ],
    'messages' => [
      'changesAfterClearCache' => 'Todas as modificações no controle de acesso serão aplicadas após a limpeza do cache.'
    ]
  ],
  'ScheduledJob' => [
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'job' => 'Tarefa',
      'scheduling' => 'Agendando (notação do crontab)'
    ],
    'links' => [
      'log' => 'Log'
    ],
    'labels' => [
      'As often as possible' => 'O mais frequente possível',
      'Create ScheduledJob' => 'Agendar Tarefa'
    ],
    'options' => [
      'job' => [
        'Cleanup' => 'Limpar',
        'CheckInboundEmails' => 'Verificar e-mails recebidos',
        'CheckEmailAccounts' => 'Verificar contas de e-mail pessoais',
        'SendEmailReminders' => 'Enviar lembretes por e-mail',
        'AuthTokenControl' => 'Controle de token de autenticação',
        'SendEmailNotifications' => 'Enviar notificações por email',
        'CheckNewVersion' => 'Verifique se há Nova Versão',
        'ProcessWebhookQueue' => 'Processar Fila de Webhook',
        'SendScheduledEmails' => 'Send Scheduled Emails',
        'ProcessMassEmail' => 'Enviar Emails em Massa',
        'ControlKnowledgeBaseArticleStatus' => 'Controlar Status dos Artigo da Base de Conhecimento',
        'ReportTargetListSync' => 'Sync Target Lists with Reports',
        'ScheduleReportSending' => 'Schedule Report Sending',
        'RunScheduledWorkflows' => 'Run Scheduled Workflows',
        'ProcessPendingProcessFlows' => 'Process Pending Flows',
        'InventoryCompress' => 'Inventory Transaction Compress',
        'NotActualOrderLocking' => 'Lock Not Actual Orders',
        'InventoryDetach' => 'Inventory Transaction Detaching'
      ],
      'cronSetup' => [
        'linux' => 'Nota: Adicione esta linha ao arquivo de crontab para executar as tarefas agendadas do Espo:',
        'mac' => 'Nota: Adicione esta linha ao arquivo de crontab para executar as tarefas agendadas do Espo:',
        'windows' => 'Nota: Crie um arquivo em lote com os seguintes comandos para executar as tarefas agendadas do TD SYNNEX no agendador de tarefas do Windows:',
        'default' => 'Nota: Adicione este comando Cron Job (Tarefa agendada):'
      ],
      'status' => [
        'Active' => 'Ativo',
        'Inactive' => 'Inativo'
      ]
    ],
    'tooltips' => [
      'scheduling' => 'Notação crontab. Define a frequência de execuções de trabalhos.

`*/5 * * * *` - a cada 5 minutos

`0 */2 * * *` - a cada 2 horas

`30 1 * * *` - às 01:30 uma vez por dia

`0 0 1 * *` - no primeiro dia do mês'
    ]
  ],
  'ScheduledJobLogRecord' => [
    'fields' => [
      'status' => 'Status',
      'executionTime' => 'Tempo de execução',
      'target' => 'Alvo'
    ]
  ],
  'Settings' => [
    'fields' => [
      'useCache' => 'Usar Cache',
      'dateFormat' => 'Formato da Data',
      'timeFormat' => 'Formato da Hora',
      'timeZone' => 'Time Zone',
      'weekStart' => 'Primeiro dia da Semana',
      'thousandSeparator' => 'Separador de Milhar',
      'decimalMark' => 'Deparador Decimal',
      'defaultCurrency' => 'Moeda Padrão',
      'baseCurrency' => 'Moeda Base',
      'currencyRates' => 'Conversão de Moedas',
      'currencyList' => 'Moedas Disponíveis',
      'language' => 'Idioma',
      'companyLogo' => 'Logo da Empresa',
      'smsProvider' => 'Provedor de SMS',
      'outboundSmsFromNumber' => 'SMS do número',
      'smtpServer' => 'Servidor',
      'smtpPort' => 'Porta',
      'smtpAuth' => 'Auth',
      'smtpSecurity' => 'Segurança',
      'smtpUsername' => 'Usuário',
      'emailAddress' => 'E-mail',
      'smtpPassword' => 'Senha',
      'outboundEmailFromName' => 'Nome do rementente',
      'outboundEmailFromAddress' => 'E-mail do rementente',
      'outboundEmailIsShared' => 'Compartilhado',
      'emailAddressLookupEntityTypeList' => 'Email address look-up scopes',
      'emailAddressSelectEntityTypeList' => 'Email address select scopes',
      'recordsPerPage' => 'Registros por Página',
      'recordsPerPageSmall' => 'Registros por Página (Menor)',
      'recordsPerPageSelect' => 'Registros por página (selecione)',
      'recordsPerPageKanban' => 'Records Per Page (Kanban)',
      'tabList' => 'Lista de abas',
      'quickCreateList' => 'Lista de Criação Rápida',
      'exportDelimiter' => 'Delimitador de exportação',
      'globalSearchEntityList' => 'Pesquisa Global de Entidades',
      'authenticationMethod' => 'Método de Autenticação',
      'ldapHost' => 'Host',
      'ldapPort' => 'Porta',
      'ldapAuth' => 'Auth',
      'ldapUsername' => 'Usuário',
      'ldapPassword' => 'Senha',
      'ldapBindRequiresDn' => 'Ligação exige Dn',
      'ldapBaseDn' => 'Dn Base',
      'ldapAccountCanonicalForm' => 'Formulário Canônico de Conta',
      'ldapAccountDomainName' => 'Nome de Domínio da Conta',
      'ldapTryUsernameSplit' => 'Tentar dividir o Nome de Usuário',
      'ldapPortalUserLdapAuth' => 'Use a autenticação LDAP para usuários do portal',
      'ldapCreateEspoUser' => 'Criar usuário no TD SYNNEX',
      'ldapSecurity' => 'Segurança',
      'ldapUserLoginFilter' => 'Filtro para Login de Usuário',
      'ldapAccountDomainNameShort' => 'Nome curto do Domínio da Conta',
      'ldapOptReferrals' => 'Referências Opt',
      'ldapUserNameAttribute' => 'Atributo Username',
      'ldapUserObjectClass' => 'ObjectClass do Usuário',
      'ldapUserTitleAttribute' => 'Atributo de Título de Usuário',
      'ldapUserFirstNameAttribute' => 'Atributo Primeiro Nome de Usuário',
      'ldapUserLastNameAttribute' => 'Atributo de Último Nome do Usuário',
      'ldapUserEmailAddressAttribute' => 'Atributo Endereço de Email de Usuário',
      'ldapUserTeams' => 'Times de Usuários',
      'ldapUserDefaultTeam' => 'Time padrão do usuário',
      'ldapUserPhoneNumberAttribute' => 'Atributo de Número de Telefone de Usuário',
      'ldapPortalUserPortals' => 'Portais Padrão para um Usuário do Portal',
      'ldapPortalUserRoles' => 'Regras Padrão para um Usuário do Portal',
      'exportDisabled' => 'Desabilitar exportação (permitido apenas para administradores)',
      'assignmentNotificationsEntityList' => 'Entidades a serem notificadas sobre a atribuição',
      'assignmentEmailNotifications' => 'Enviar notificações sobre as designações por e-mail',
      'assignmentEmailNotificationsEntityList' => 'Entidades para notificar',
      'streamEmailNotifications' => 'Notificações sobre atualizações no Stream para usuários internos',
      'portalStreamEmailNotifications' => 'Notificações sobre atualizações no Stream para usuários do portal',
      'streamEmailNotificationsEntityList' => 'Escopos de notificações por e-mail de stream',
      'streamEmailNotificationsTypeList' => 'Sobre o que notificar',
      'streamEmailWithContentEntityTypeList' => 'Entities with email body in stream notes',
      'emailNotificationsDelay' => 'Atraso de notificações por e-mail (em segundos)',
      'b2cMode' => 'Modo B2C',
      'avatarsDisabled' => 'Desabilitar Avatares',
      'followCreatedEntities' => 'Seguir os registros criados',
      'displayListViewRecordCount' => 'Exibir Contagem Total (na lista de exibição)',
      'theme' => 'Tema',
      'userThemesDisabled' => 'Desabilitar temas de usuários',
      'attachmentUploadMaxSize' => 'Upload Max Size (Mb)',
      'attachmentUploadChunkSize' => 'Upload Chunk Size (Mb)',
      'emailMessageMaxSize' => 'Tamanho Máx. E-mail (Mb)',
      'massEmailMaxPerHourCount' => 'Número máximo de e-mails enviados por hora',
      'massEmailMaxPerBatchCount' => 'Max number of emails sent per batch',
      'personalEmailMaxPortionSize' => 'Tamanho máximo da porção de email para busca de conta pessoal',
      'inboundEmailMaxPortionSize' => 'Tamanho máximo da porção de e-mail para busca de conta de grupo',
      'maxEmailAccountCount' => 'Número máx. de contas de email pessoais por usuário',
      'emailScheduledBatchCount' => 'Max number of scheduled emails sent per batch',
      'authTokenLifetime' => 'Vida útil do Token de Autenticação (horas)',
      'authTokenMaxIdleTime' => 'Tempo Máx. de Inatividade do Token de Autenticação (horas)',
      'dashboardLayout' => 'Layout Dashboard (padrão)',
      'siteUrl' => 'URL do Site',
      'addressPreview' => 'Visualização de Endereço',
      'addressFormat' => 'Formato Endereço',
      'personNameFormat' => 'Formato do nome da pessoa',
      'notificationSoundsDisabled' => 'Desativar notificações sonoras',
      'newNotificationCountInTitle' => 'Exibir novo número de notificação no título da página',
      'applicationName' => 'Nome Aplicação',
      'calendarEntityList' => 'Lista de Entidades do Calendário',
      'busyRangesEntityList' => 'Lista de entidades livres/ocupadas',
      'mentionEmailNotifications' => 'Enviar notificações por email sobre menções em postagens',
      'massEmailDisableMandatoryOptOutLink' => 'Desativar link de cancelamento obrigatório',
      'massEmailOpenTracking' => 'Rastreamento de abertura de Email',
      'massEmailVerp' => 'Usar VERP',
      'activitiesEntityList' => 'Lista das Atividades da ',
      'historyEntityList' => 'Lista do Histórico de Entidades',
      'currencyFormat' => 'Formato da Moeda',
      'currencyDecimalPlaces' => 'Casas Decimais Moeda',
      'aclAllowDeleteCreated' => 'Permitir remover registros criados',
      'adminNotifications' => 'Notificações do sistema no painel de administração',
      'adminNotificationsNewVersion' => 'Mostrar notificação quando a nova versão do TD SYNNEX estiver disponível',
      'adminNotificationsNewExtensionVersion' => 'Mostrar notificação quando novas versões de extensões estiverem disponíveis',
      'textFilterUseContainsForVarchar' => 'Use o operador \'contém\' ao filtrar campos varchar',
      'phoneNumberNumericSearch' => 'Numeric phone number search',
      'phoneNumberInternational' => 'International phone numbers',
      'phoneNumberExtensions' => 'Phone number extensions',
      'phoneNumberPreferredCountryList' => 'Preferred telephone country codes',
      'authTokenPreventConcurrent' => 'Apenas um token de autenticação por usuário',
      'scopeColorsDisabled' => 'Disable scope colors',
      'tabColorsDisabled' => 'Disable tab colors',
      'tabIconsDisabled' => 'Disable tab icons',
      'emailAddressIsOptedOutByDefault' => 'Mark new email addresses as opted-out',
      'outboundEmailBccAddress' => 'BCC address for external clients',
      'cleanupDeletedRecords' => 'Limpar registros excluídos',
      'addressCityList' => 'Lista de preenchimento automático da cidade do endereço ',
      'addressStateList' => 'Lista de Preenchimento Automático de Estados no Endereço',
      'fiscalYearShift' => 'Início do Ano Fiscal',
      'jobRunInParallel' => 'Trabalhos (Jobs) Executados em Paralelo',
      'jobMaxPortion' => 'Porção Máxima de Trabalhos (Jobs)',
      'jobPoolConcurrencyNumber' => 'Número de Simultaneidade do Pool de Trabalhos',
      'jobForceUtc' => 'Force UTC Time Zone',
      'daemonInterval' => 'Intervalo de Daemon',
      'daemonMaxProcessNumber' => 'Número Máx. de Processo do Daemon',
      'daemonProcessTimeout' => 'Timeout do Processo Daemon',
      'cronDisabled' => 'Desativar Cron',
      'maintenanceMode' => 'Modo de manutenção',
      'useWebSocket' => 'Usar WebSocket',
      'passwordRecoveryDisabled' => 'Desativar recuperação de senha',
      'passwordRecoveryForAdminDisabled' => 'Desative a recuperação de senha para usuários administradores',
      'passwordRecoveryForInternalUsersDisabled' => 'Desativar a recuperação de senha para usuários internos',
      'passwordRecoveryNoExposure' => 'Impedir a exposição do endereço de e-mail no formulário de recuperação de senha',
      'passwordGenerateLength' => 'Comprimento das senhas geradas',
      'passwordStrengthLength' => 'Tamanho mínimo de senha',
      'passwordStrengthLetterCount' => 'Número de letras exigidas na senha',
      'passwordStrengthNumberCount' => 'Número de dígitos exigidos na senha',
      'passwordStrengthBothCases' => 'A senha deve conter letras maiúsculas e minúsculas',
      'passwordStrengthSpecialCharacterCount' => 'Number of special character required in password',
      'auth2FA' => 'Ativar Autenticação de 2 fatores',
      'auth2FAForced' => 'Forçar usuários regulares a configurar 2FA',
      'auth2FAMethodList' => 'Métodos 2FA disponíveis',
      'auth2FAInPortal' => 'Allow 2FA in portals',
      'workingTimeCalendar' => 'Working Time Calendar',
      'oidcClientId' => 'OIDC Client ID',
      'oidcClientSecret' => 'OIDC Client Secret',
      'oidcAuthorizationRedirectUri' => 'OIDC Authorization Redirect URI',
      'oidcAuthorizationEndpoint' => 'OIDC Authorization Endpoint',
      'oidcTokenEndpoint' => 'OIDC Token Endpoint',
      'oidcJwksEndpoint' => 'OIDC JSON Web Key Set Endpoint',
      'oidcJwtSignatureAlgorithmList' => 'OIDC JWT Allowed Signature Algorithms',
      'oidcScopes' => 'OIDC Scopes',
      'oidcGroupClaim' => 'OIDC Group Claim',
      'oidcCreateUser' => 'OIDC Create User',
      'oidcUsernameClaim' => 'OIDC Username Claim',
      'oidcTeams' => 'OIDC Teams',
      'oidcSync' => 'OIDC Sync',
      'oidcSyncTeams' => 'OIDC Sync Teams',
      'oidcFallback' => 'OIDC Fallback Login',
      'oidcAllowRegularUserFallback' => 'OIDC Allow fallback login for regular users',
      'oidcAllowAdminUser' => 'OIDC Allow OIDC login for admin users',
      'oidcLogoutUrl' => 'OIDC Logout URL',
      'oidcAuthorizationPrompt' => 'OIDC Authorization Prompt',
      'pdfEngine' => 'PDF Engine',
      'quickSearchFullTextAppendWildcard' => 'Append wildcard in quick search',
      'authIpAddressCheck' => 'Restrict access by IP address',
      'authIpAddressWhitelist' => 'IP Address Whitelist',
      'authIpAddressCheckExcludedUsers' => 'Users excluded from check',
      'availableReactions' => 'Available Reactions',
      'priceBooksEnabled' => 'Price Books',
      'defaultPriceBook' => 'Default Price Book',
      'inventoryTransactionsEnabled' => 'Inventory Transactions',
      'warehousesEnabled' => 'Warehouses',
      'deliveryOrdersEnabled' => 'Delivery Orders',
      'receiptOrdersEnabled' => 'Receipt Orders',
      'eInvoiceFormat' => 'Default Format',
      'sellerCompanyName' => 'Company Name',
      'sellerElectronicAddressScheme' => 'Electronic Address Scheme',
      'sellerElectronicAddressIdentifier' => 'Electronic Address Identifier',
      'sellerVatNumber' => 'VAT Number',
      'sellerTaxRegistrationScheme' => 'Tax Registration Scheme',
      'sellerTaxRegistrationIdentifier' => 'Tax Registration Identifier',
      'sellerAddress' => 'Company Address',
      'sellerContactName' => 'Contact Name',
      'sellerContactEmailAddress' => 'Contact Email Address',
      'sellerContactPhoneNumber' => 'Contact Phone Number',
      'salesForbidOrderUnlock' => 'Forbid order unlocking',
      'addressCountryList' => 'Lista de Preenchimento Automático de Países no Endereço'
    ],
    'options' => [
      'authenticationMethod' => [
        'Oidc' => 'OIDC'
      ],
      'currencyFormat' => [
        1 => '10 BRL',
        2 => 'R$10'
      ],
      'personNameFormat' => [
        'firstLast' => 'Primeiro Último',
        'lastFirst' => 'Último Primeiro',
        'firstMiddleLast' => 'Primeiro Meio Último',
        'lastFirstMiddle' => 'Último Primeiro Meio'
      ],
      'streamEmailNotificationsTypeList' => [
        'Post' => 'Postagens',
        'Status' => 'Atualizações de Status',
        'EmailReceived' => 'Emails recebidos'
      ],
      'auth2FAMethodList' => [
        'Totp' => 'TOTP',
        'Email' => 'Email',
        'Sms' => 'SMS'
      ]
    ],
    'tooltips' => [
      'authIpAddressCheckExcludedUsers' => 'Users that will be able to log in regardless whether their IP address is in the whitelist.',
      'authIpAddressWhitelist' => 'A list of IP addresses or ranges in CIDR notation.

Portals are not affected by restriction.',
      'workingTimeCalendar' => 'A working time calendar that will be applied to all users by default.',
      'displayListViewRecordCount' => 'Um número total de registros será mostrado na exibição de lista.',
      'currencyList' => 'Quais moedas estarão disponíveis no sistema.',
      'activitiesEntityList' => 'Quais registros estarão disponíveis no painel Atividades.',
      'historyEntityList' => 'Quais registros estarão disponíveis no painel Histórico.',
      'calendarEntityList' => 'Quais registros estarão disponíveis no calendário.',
      'addressStateList' => 'Sugestões de Estados para campos de endereço.',
      'addressCityList' => 'Sugestões de Cidades para campos de endereço.',
      'addressCountryList' => 'Sugestões de Países para campos de endereço.',
      'exportDisabled' => 'Os usuários não tem permissão para exportar registros. Apenas o admin tem permissão.',
      'globalSearchEntityList' => 'Quais registros podem ser pesquisados com a Pesquisa Global.',
      'siteUrl' => 'Uma URL desta instância do TD SYNNEX. Você precisa alterá-la se mudar para outro domínio.',
      'useCache' => 'Não é recomendado desativar, a menos para fins de desenvolvimento.',
      'useWebSocket' => 'O WebSocket permite a comunicação interativa bidirecional entre um servidor e um navegador. Requer a configuração do daemon WebSocket em seu servidor. Verifique a documentação para mais informações.',
      'passwordRecoveryForInternalUsersDisabled' => 'Apenas usuários do portal poderão recuperar a senha.',
      'passwordRecoveryNoExposure' => 'Não será possível determinar se um endereço de e-mail específico está cadastrado no sistema.',
      'emailAddressLookupEntityTypeList' => 'Para preenchimento automático de endereços de e-mail.',
      'emailAddressSelectEntityTypeList' => 'Entity types available when searching for an email address from a modal.',
      'emailNotificationsDelay' => 'Uma mensagem pode ser editada dentro do período de tempo especificado antes que a notificação seja enviada. ',
      'outboundEmailFromAddress' => 'Endereço de e-mail do sistema.',
      'smtpServer' => 'Se estiver vazio, será usada a Conta de Email do Grupo com o endereço de email correspondente.',
      'busyRangesEntityList' => 'O que será levado em consideração ao mostrar intervalos de tempo ocupado no agendador e linha do tempo.',
      'massEmailVerp' => 'Caminho de retorno de envelope variável. Para um melhor tratamento de mensagens devolvidas. Certifique-se de que seu provedor SMTP oferece suporte.',
      'recordsPerPage' => 'Número de registros exibidos inicialmente nas visualizações de lista.',
      'recordsPerPageSmall' => 'Contar registros nos painéis de relacionamento.',
      'recordsPerPageSelect' => 'Número de registros mostrados inicialmente quando selecionando registros.',
      'recordsPerPageKanban' => 'Number of records initially displayed in kanban columns.',
      'outboundEmailIsShared' => 'Permitir que os usuários enviem e-mails deste endereço.',
      'followCreatedEntities' => 'Os usuários seguirão automaticamente os registros que criaram.',
      'emailMessageMaxSize' => 'Todos os emails de entrada que excederem um tamanho especificado serão buscados sem corpo e anexos.',
      'authTokenLifetime' => 'Define por quanto tempo os tokens podem existir.
0 - significa sem expiração.',
      'authTokenMaxIdleTime' => 'Define quanto tempo desde que os últimos tokens de acesso podem existir.
0 - significa sem expiração.',
      'userThemesDisabled' => 'Se marcada, os usuários não poderão selecionar outro tema.',
      'ldapUsername' => 'O DN completo do usuário do sistema que permite pesquisar outros usuários. Por exemplo. "CN=LDAP System User,OU=users,OU=espocrm, DC=test,DC=lan".',
      'ldapPassword' => 'A senha para acessar o servidor LDAP.',
      'ldapAuth' => 'Credenciais de acesso para o servidor LDAP.',
      'ldapUserNameAttribute' => 'O atributo para identificar o usuário.
Ex: "userPrincipalName" ou "sAMAccountName" para o Active Directory, "uid" para o OpenLDAP.',
      'ldapUserObjectClass' => 'Atributo ObjectClass para pesquisar usuários. Ex: "person" para AD, "inetOrgPerson" para OpenLDAP.',
      'ldapAccountCanonicalForm' => 'O tipo de formulário canônico da sua conta. Existem 4 opções:

- \'Dn\' - o formulário no formato \'CN=tester,OU=espocrm,DC=teste, DC=lan\'.

- \'Username\' - o formulário \'tester\'.

- \'Backslash\' - o formulário \'COMPANY\\tester\'.

- \'Principal\' - o formulário \'tester@company.com\'.',
      'ldapBindRequiresDn' => 'A opção de formatar o username no formato DN.',
      'ldapBaseDn' => 'O DN base padrão usado para pesquisar usuários. Ex: "OU=users,OU=espocrm,DC=test, DC=lan".',
      'ldapTryUsernameSplit' => 'A opção de dividir um username com o domínio.',
      'ldapOptReferrals' => 'se as referências devem ser seguidas para o cliente LDAP.',
      'ldapPortalUserLdapAuth' => 'Permitir que os usuários do portal usem a autenticação LDAP em vez da autenticação do Espo.',
      'ldapCreateEspoUser' => 'Esta opção permite que o TD SYNNEX crie um usuário a partir do LDAP.',
      'ldapUserFirstNameAttribute' => 'Atributo LDAP que é usado para determinar o nome do usuário. Ex: "givenname".',
      'ldapUserLastNameAttribute' => 'Atributo LDAP que é usado para determinar o sobrenome. Ex: "sn".',
      'ldapUserTitleAttribute' => 'Atributo LDAP que é usado para determinar o título do usuário. Ex: "title".',
      'ldapUserEmailAddressAttribute' => 'Atributo LDAP que é usado para determinar o endereço de email do usuário. Ex: "mail".',
      'ldapUserPhoneNumberAttribute' => 'Atributo LDAP que é usado para determinar o número de telefone do usuário. Ex: "telephoneNumber".',
      'ldapUserLoginFilter' => 'O filtro que permite restringir os usuários que podem utilizar o TD SYNNEX. Ex:  "memberOf=CN=espoGroup, OU=groups,OU=espocrm, DC=test,DC=lan".',
      'ldapAccountDomainName' => 'O domínio que é usado para autorização ao servidor LDAP.',
      'ldapAccountDomainNameShort' => 'O domínio curto que é usado para autorização ao servidor LDAP.',
      'ldapUserTeams' => 'Times para usuário criado. Para saber mais, consulte o perfil do usuário.',
      'ldapUserDefaultTeam' => 'Time padrão para o usuário criado. Para saber mais, consulte o perfil do usuário.',
      'ldapPortalUserPortals' => 'Portais Padrão para o Usuário do Portal criado',
      'ldapPortalUserRoles' => 'Regras Padrão para o Usuário do Portal criado',
      'b2cMode' => 'Por padrão, o TD SYNNEX é adaptado para B2B. Você pode mudar para B2C.',
      'currencyDecimalPlaces' => 'Número de casas decimais. Se estiver vazio, todas as casas decimais não vazias serão exibidas.',
      'aclStrictMode' => 'Habilitado: O acesso aos escopos será proibido se não estiver especificado nas regras.

Desabilitado: O acesso aos escopos será permitido se não for especificado nas regras.',
      'aclAllowDeleteCreated' => 'Os usuários poderão remover os registros que criaram mesmo que não tenham acesso de exclusão.',
      'textFilterUseContainsForVarchar' => 'Se não estiver marcado, o operador \'começa com\' é usado. Você pode usar o curinga \'%\'.',
      'streamEmailNotificationsEntityList' => 'Notificações por email sobre atualizações de fluxo de registros seguidos. Os usuários receberão notificações por email apenas para tipos de entidade especificados.',
      'authTokenPreventConcurrent' => 'Os usuários não poderão fazer login em vários dispositivos simultaneamente.',
      'emailAddressIsOptedOutByDefault' => 'Ao criar um novo endereço de e-mail de registro será marcado como desativado.',
      'cleanupDeletedRecords' => 'Os registros removidos serão excluídos do banco de dados após um tempo.',
      'jobRunInParallel' => 'Os trabalhos (jobs) serão executados em processos paralelos.',
      'jobPoolConcurrencyNumber' => 'Número máximo de processos executados simultaneamente.',
      'jobMaxPortion' => 'Número máximo de trabalhos (jobs) processados por uma execução.',
      'jobForceUtc' => 'Use the UTC time zone for scheduled jobs. Otherwise, the time zone set in settings will be used.',
      'daemonInterval' => 'Intervalo em segundos entre as execuções dos processos crons.',
      'daemonMaxProcessNumber' => 'Número máximo de processos cron executados simultaneamente.',
      'daemonProcessTimeout' => 'Tempo máximo de execução (em segundos) alocado para um único processo cron.',
      'cronDisabled' => 'Cron não será executado.',
      'maintenanceMode' => 'Somente administradores terão acesso ao sistema.',
      'oidcGroupClaim' => 'A claim to use for team mapping.',
      'oidcFallback' => 'Allow login by username/password.',
      'oidcCreateUser' => 'Create a new user in Espo when no matching user found.',
      'oidcSync' => 'Sync user data (on every login).',
      'oidcSyncTeams' => 'Sync user teams (on every login).',
      'oidcUsernameClaim' => 'A claim to use for a username (for user matching and creation).',
      'oidcTeams' => 'Espo teams mapped against groups/teams/roles of the identity provider. Teams with an empty mapping value will be always assigned to a user (when creating or syncing).',
      'oidcLogoutUrl' => 'An URL the browser will redirect to after logging out from Espo. Intended for clearing the session information in the browser and doing logging out on the provider side. Usually the URL contains a redirect-URL parameter, to return back to Espo.

Available placeholders:
* `{siteUrl}`
* `{clientId}`',
      'quickSearchFullTextAppendWildcard' => 'Append a wildcard to an autocomplete search query when Full-Text search is enabled. Reduces search performance.',
      'salesForbidOrderUnlock' => 'Once an order is locked, it can only be unlocked by an administrator.'
    ],
    'labels' => [
      'Group Tab' => 'Aba Grupo',
      'Divider' => 'Divider',
      'System' => 'Sistema',
      'Locale' => 'Idioma',
      'Search' => 'Pesquisa',
      'Misc' => 'Misc',
      'SMTP' => 'SMTP',
      'General' => 'General',
      'Phone Numbers' => 'Phone Numbers',
      'Navbar' => 'Navbar',
      'Dashboard' => 'Dashboard',
      'Configuration' => 'Configuração',
      'In-app Notifications' => 'In-app Notifications',
      'Email Notifications' => 'Notificações de Email',
      'Currency Settings' => 'Configurações de Moeda',
      'Currency Rates' => 'Conversão de moedas',
      'Mass Email' => 'E-mail em Massa',
      'Scheduled Send' => 'Scheduled Send',
      'Test Connection' => 'Testar conexão',
      'Connecting' => 'Conectando...',
      'Activities' => 'Atividades',
      'Admin Notifications' => 'Administrar Notificações',
      'Passwords' => 'Senhas',
      '2-Factor Authentication' => 'Autenticação de 2 Fatores',
      'Attachments' => 'Attachments',
      'IdP Group' => 'IdP Group',
      'Access' => 'Access',
      'Strength' => 'Strength',
      'Recovery' => 'Recovery',
      'Electronic Invoicing' => 'Electronic Invoicing',
      'Seller Information' => 'Seller Information'
    ],
    'messages' => [
      'ldapTestConnection' => 'A conexão foi estabelecida com sucesso.'
    ]
  ],
  'Stream' => [
    'messages' => [
      'infoMention' => 'Digite **@username** para mencionar o usuário na postagem.',
      'infoSyntax' => 'Sintaxe de markdown disponível',
      'couldNotAddFollowerUserHasNoAccessToStream' => 'Não foi possível adicionar o usuário \'{userName}\' aos seguidores. O usuário não tem acesso \'stream\' ao registro'
    ],
    'syntaxItems' => [
      'code' => 'código',
      'multilineCode' => 'código de várias linhas',
      'strongText' => 'strong text',
      'emphasizedText' => 'emphasized text',
      'deletedText' => 'Texto excluído',
      'blockquote' => 'blockquote',
      'link' => 'link text'
    ]
  ],
  'Team' => [
    'fields' => [
      'name' => 'Nome',
      'roles' => 'Regras',
      'layoutSet' => 'Conjunto de Layout',
      'workingTimeCalendar' => 'Working Time Calendar',
      'positionList' => 'Lista de Posições',
      'userRole' => 'User Role',
      'country' => 'Country',
      'subTeams' => 'Sub time',
      'brand' => 'Brand',
      'teamParent' => 'Time principal'
    ],
    'links' => [
      'users' => 'Usuários',
      'notes' => 'Notas',
      'roles' => 'Regras',
      'layoutSet' => 'Conjunto de Layout',
      'workingTimeCalendar' => 'Working Time Calendar',
      'inboundEmails' => 'Contas de Email do Grupo',
      'groupEmailFolders' => 'Group Email Folders',
      'teamParent' => 'Time principal',
      'subTeams' => 'Sub time'
    ],
    'tooltips' => [
      'workingTimeCalendar' => 'A calendar will be applied to users who have this team set as a Default Team.',
      'layoutSet' => 'Fornece a capacidade de ter layouts que diferem dos padrões. O Conjunto de Layout será aplicado aos usuários que têm esse time definido como Time Padrão (Default Team).',
      'roles' => 'Todos os usuários deste time terão acesso as configurações das regras selecionadas.',
      'positionList' => 'Posições disponíveis neste time. E.g. Vendedor, Gerente.'
    ],
    'labels' => [
      'Create Team' => 'Criar Time'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'CCA' => 'CCA',
        'Bolivia' => 'Bolivia',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Panama' => 'Panama'
      ],
      'brand' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'Template' => [
    'fields' => [
      'name' => 'Nome',
      'body' => 'Corpo',
      'entityType' => 'Tipo de Entidade',
      'header' => 'Cabeçalho',
      'footer' => 'Rodapé',
      'leftMargin' => 'Margem Esquerda',
      'topMargin' => 'Margem Superior',
      'rightMargin' => 'Margem Direita',
      'bottomMargin' => 'Margem Inferior',
      'printFooter' => 'Imprimir Rodapé',
      'printHeader' => 'Cabeçalho de Impressão',
      'footerPosition' => 'Posição do Rodapé',
      'headerPosition' => 'Posição do Cabeçalho',
      'variables' => 'Espaços Reservados Disponíveis',
      'pageOrientation' => 'Orientação de Página',
      'pageFormat' => 'Formato do Papél',
      'pageWidth' => 'Larg. da página (mm)',
      'pageHeight' => 'Altura da Página (mm)',
      'fontFace' => 'Fonte',
      'title' => 'Título',
      'style' => 'Style'
    ],
    'links' => [],
    'labels' => [
      'Create Template' => 'Criar template'
    ],
    'options' => [
      'pageOrientation' => [
        'Portrait' => 'Retrato',
        'Landscape' => 'Paisagem'
      ],
      'pageFormat' => [
        'Custom' => 'Personalizado'
      ],
      'placeholders' => [
        'pagebreak' => 'Quebra de página',
        'today' => 'Hoje (data)',
        'now' => 'Agora (Data e Hora)'
      ],
      'fontFace' => []
    ],
    'tooltips' => [
      'footer' => 'Use {pageNumber} para imprimir o número da página.',
      'variables' => 'Necessário espaço reservado no Cabeçalho, Corpo ou Rodapé para copiar e colar.'
    ]
  ],
  'User' => [
    'fields' => [
      'name' => 'Nome',
      'userName' => 'Nome de Usuário',
      'title' => 'Título',
      'type' => 'Tipo',
      'isAdmin' => 'Administrador',
      'defaultTeam' => 'Time Padrão',
      'emailAddress' => 'E-mail',
      'phoneNumber' => 'Telefone',
      'roles' => 'Regras',
      'portals' => 'Portais',
      'portalRoles' => 'Regras de Portal',
      'teamRole' => 'Posição',
      'password' => 'Senha',
      'currentPassword' => 'Senha Atual',
      'passwordConfirm' => 'Confirmação da Senha',
      'newPassword' => 'Nova senha',
      'newPasswordConfirm' => 'Confirme a nova senha',
      'yourPassword' => 'Sua senha atual',
      'avatar' => 'Avatar',
      'avatarColor' => 'Avatar Color',
      'isActive' => 'Está ativo',
      'isPortalUser' => 'É Usuário do Portal',
      'contact' => 'Contato',
      'accounts' => 'Contas',
      'account' => 'Conta (Primária)',
      'sendAccessInfo' => 'Enviar e-mail com informações de acesso ao usuário',
      'portal' => 'Portal',
      'gender' => 'Gênero',
      'position' => 'Position',
      'ipAddress' => 'Endereço IP',
      'passwordPreview' => 'Pré-visualização de senha',
      'isSuperAdmin' => 'É Super Admin',
      'lastAccess' => 'Último Acesso',
      'apiKey' => 'Chave de API',
      'secretKey' => 'Chave Secreta',
      'dashboardTemplate' => 'Modelo de Dashboard',
      'workingTimeCalendar' => 'Working Time Calendar',
      'auth2FA' => '2FA',
      'authMethod' => 'Método de autenticação',
      'auth2FAEnable' => 'Ativar Autenticação de 2 Fatores',
      'auth2FAMethod' => 'Método 2FA',
      'auth2FATotpSecret' => 'Segredo 2FA TOTP',
      'layoutSet' => 'Layout Set',
      'acceptanceStatus' => 'Status de Aceitação',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Status de Aceitação (Ligações)',
      'projects' => 'Projects',
      'projectRole' => 'Project Role',
      'projectRoleId' => 'Project Role ID',
      'country' => 'Country',
      'userType' => 'User Type',
      'partner' => 'Account',
      'clientid' => 'Rocket Client ID',
      'clientsecret' => 'Rocket Client Secret',
      'lead' => 'Lead',
      'contact1' => 'Contact1',
      'productBrand' => 'Fabricantes',
      'awsClientId' => 'AwsClientId',
      'awsClientSecret' => 'AwsClientSecret',
      'lastAccessDate' => 'Last Access Date',
      'teamCountry' => 'Team Country',
      'countryList' => 'Country List',
      'vbmAccount' => 'Conta',
      'opportunities' => 'Oportunidades',
      'userPosition' => 'Cargo',
      'accountVMB' => 'Account VMB',
      'mobileApp' => 'Mobile App',
      'configApp' => 'ConfigApp',
      'accountbdm' => 'Conta',
      'accounts1' => 'Contas',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'salesTerritory' => 'Sales Territory',
      'bDM' => 'VBA/BDR/BDM',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs'
    ],
    'links' => [
      'defaultTeam' => 'Time Padrão',
      'teams' => 'Times',
      'roles' => 'Regras',
      'notes' => 'Notas',
      'portals' => 'Portais',
      'portalRoles' => 'Regras de Portal',
      'contact' => 'Contato',
      'accounts' => 'Contas',
      'account' => 'Conta (Primária)',
      'tasks' => 'Tarefas',
      'userData' => 'Dados do Usuário',
      'dashboardTemplate' => 'Modelo de Dashboard',
      'workingTimeCalendar' => 'Working Time Calendar',
      'workingTimeRanges' => 'Working Time Exceptions',
      'layoutSet' => 'Layout Set',
      'targetLists' => 'Lista de alvos',
      'projects' => 'Projects',
      'partner' => 'Account',
      'lead' => 'Lead',
      'contact1' => 'Contact1',
      'vbmAccount' => 'Conta',
      'opportunities' => 'Oportunidades',
      'accountVMB' => 'Account VMB',
      'accountbdm' => 'Conta',
      'accounts1' => 'Contas',
      'accountsBdms' => 'Carteira de Clientes - BDMs',
      'migrationsaccountManager' => 'Migrações (Account Manager)',
      'migrations' => 'Migrações (BDM Cloud)',
      'processOwnerMigrations' => 'Migrações (Process Owner)',
      'cAccountSales' => 'Carteira de Clientes - AMs'
    ],
    'labels' => [
      'Create User' => 'Criar Usuário',
      'Generate' => 'Gerar',
      'Access' => 'Acesso',
      'Preferences' => 'Preferências',
      'Change Password' => 'Trocar Senha',
      'Teams and Access Control' => 'Times e controle de acesso',
      'Forgot Password?' => 'Esqueceu a senha?',
      'Password Change Request' => 'Solicitar troca da senha',
      'Email Address' => 'Endereço de e-mail',
      'External Accounts' => 'Contas externas',
      'Email Accounts' => 'Contas de e-mail',
      'Portal' => 'Portal',
      'Create Portal User' => 'Criar Usuário de Portal',
      'Proceed w/o Contact' => 'Prossiga sem Contato',
      'Generate New API Key' => 'Gerar Nova Chave de API',
      'Generate New Password' => 'Gerar Nova Senha',
      'Send Password Change Link' => 'Enviar link de alteração de senha',
      'Back to login form' => 'Voltar ao formulário de login',
      'Requirements' => 'Requisitos',
      'Security' => 'Segurança',
      'Reset 2FA' => 'Reiniciar 2FA',
      'Code' => 'Código',
      'Secret' => 'Segredo',
      'Send Code' => 'Enviar código',
      'Login Link' => 'Login Link'
    ],
    'tooltips' => [
      'defaultTeam' => 'Todos os registros criados por este usuário serão relacionados e este time por padrão.',
      'userName' => 'Letras a-z, números 0-9 e underscores são permitidos.',
      'isAdmin' => 'Usuário Admin pode acessar tudo.',
      'isActive' => 'Se desmarcado, o usuário não conseguirá logar.',
      'teams' => 'Times aos quais este usuário pertence. O controle de acesso é herdado das regras do time.',
      'roles' => 'Regras de acesso adicionais. Use se o usuário não pertence a nenhum time ou se for necessário extender o controle de acesso deste usuário.',
      'portalRoles' => 'Regras adicionais do portal. Use-o para estender o nível de controle de acesso exclusivamente para este usuário.',
      'portals' => 'Portais aos quais este usuário tem acesso.',
      'layoutSet' => 'Layouts from a specified set will be applied for the user instead of default ones.',
      'productBrand' => 'determina quais fabricantes o usuário acessará nas telas de oportunidades e leads.'
    ],
    'messages' => [
      '2faMethodNotConfigured' => 'The 2FA method is not fully configured in the system.',
      'loginAs' => 'Open the login link in an incognito window to preserve your current session. Use your admin credentials to log in.',
      'sendPasswordChangeLinkConfirmation' => 'Um e-mail com um link exclusivo será enviado ao usuário permitindo que ele altere sua senha. O link expirará após um determinado período de tempo.',
      'passwordRecoverySentIfMatched' => 'Supondo que os dados inseridos correspondam a qualquer conta de usuário.',
      'passwordStrengthLength' => 'Deve ter pelo menos {length} caracteres.',
      'passwordStrengthLetterCount' => 'Deve conter pelo menos {count} letra(s).',
      'passwordStrengthNumberCount' => 'Deve conter pelo menos {count} dígito(s).',
      'passwordStrengthSpecialCharacterCount' => 'Must contain at least {count} special character(s).',
      'passwordStrengthBothCases' => 'Deve conter letras maiúsculas e minúsculas.',
      'passwordWillBeSent' => 'A senha será enviada para o email do usuário.',
      'passwordChanged' => 'A senha foi atualizada',
      'userCantBeEmpty' => 'O nome de usuário deve ser informado',
      'wrongUsernamePassword' => 'Usuário / senha incorretos',
      'failedToLogIn' => 'Failed to log in',
      'emailAddressCantBeEmpty' => 'O endereço de e-mail deve ser informado',
      'userNameEmailAddressNotFound' => 'Usuário / E-mail não localizados',
      'forbidden' => 'Proibido, por favor tente mais tarde',
      'uniqueLinkHasBeenSent' => 'Um link único foi enviado para o endereço de e-mail informado.',
      'passwordChangedByRequest' => 'A senha foi atualizada.',
      'setupSmtpBefore' => 'Você precisa configurar [configurações SMTP]({url}) para que o sistema possa enviar a senha por e-mail.',
      'userNameExists' => 'Nome de Usuário',
      'loginError' => 'Error occurred',
      'wrongCode' => 'Código Errado',
      'codeIsRequired' => 'Código é obrigatório',
      'yourAuthenticationCode' => 'Seu código de autenticação: {code}.',
      'choose2FaSmsPhoneNumber' => 'Selecione um número de telefone que será usado para 2FA.',
      'choose2FaEmailAddress' => 'Selecione um endereço de e-mail que será usado para 2FA. É altamente recomendável usar um endereço de e-mail não principal.',
      'enterCodeSentInEmail' => 'Digite o código enviado para o seu endereço de e-mail.',
      'enterCodeSentBySms' => 'Digite o código enviado por SMS para o seu número de telefone.',
      'enterTotpCode' => 'Entre com o código de seu app autenticador.',
      'verifyTotpCode' => 'Digitalize o código QR com seu aplicativo autenticador móvel. Se você tiver problemas com a digitalização, poderá inserir o segredo manualmente. Depois disso, você verá um código de 6 dígitos em seu aplicativo. Digite este código no campo abaixo.',
      'generateAndSendNewPassword' => 'Uma nova senha será gerada e enviada para o endereço de email do usuário.',
      'security2FaResetConfirmation' => 'Tem certeza de que deseja redefinir as configurações atuais de 2FA?',
      'auth2FARequiredHeader' => 'Autenticação de 2 fatores necessária',
      'auth2FARequired' => 'Você precisa configurar a autenticação de 2 fatores. Use um aplicativo autenticador em seu celular (ex: Google Authenticator).',
      'ldapUserInEspoNotFound' => 'O usuário não foi encontrado no TD SYNNEX. Entre em contato com o administrador para criar o usuário.',
      'passwordChangeRequestNotFound' => 'A solicitação de alteração de senha não foi encontrada. Pode estar expirada. Tente iniciar uma nova recuperação de senha a partir do [login page]({url}).',
      'defaultTeamIsNotUsers' => 'Default Team should be one of user\'s Teams'
    ],
    'options' => [
      'gender' => [
        '' => 'Não Informado',
        'Male' => 'Masculino',
        'Female' => 'Feminino',
        'Neutral' => 'Neutro'
      ],
      'type' => [
        'regular' => 'Regular',
        'admin' => 'Administrador',
        'portal' => 'Portal',
        'system' => 'Sistema',
        'super-admin' => 'Super Admin',
        'api' => 'API'
      ],
      'authMethod' => [
        'ApiKey' => 'Chave de API',
        'Hmac' => 'HMAC'
      ],
      'projectRole' => [
        '' => 'Member',
        'Editor' => 'Editor',
        'Owner' => 'Owner'
      ],
      'userType' => [
        'Reseller' => 'Reseller',
        'Customer' => 'Customer',
        'Internal team' => 'Internal team',
        ' ' => ' ',
        'Synnex Staff' => 'TD SYNNEX'
      ],
      'productBrand' => [
        'AWS' => 'AWS',
        'Cisco' => 'Cisco',
        'Enterprise' => 'Enterprise',
        'Fortinet' => 'Fortinet',
        'IBM' => 'IBM',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'IBM Cloud' => 'IBM Cloud'
      ],
      'countryList' => [
        'Brasil' => 'Brasil',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Colombia' => 'Colombia',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Caribe' => 'Caribe',
        'Chile' => 'Chile',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay'
      ],
      'configApp' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'Azure' => 'Azure'
      ],
      'salesTerritory' => [
        'Accelerate' => 'Accelerate',
        'CA&A' => 'CA&A',
        'Cisco Solutions 1' => 'Cisco Solutions 1',
        'Cisco Solutions 2' => 'Cisco Solutions 2',
        'Cloud XaaS' => 'Cloud XaaS',
        'Infra' => 'Infra',
        'Marketing Cloud' => 'Marketing Cloud',
        'Sales Support Cloud' => 'Sales Support Cloud',
        'Security' => 'Security',
        'Service Providers 1' => 'Service Providers 1',
        'Service Providers 2' => 'Service Providers 2',
        'Specialized Solutions - IBM/Oracle' => 'Specialized Solutions - IBM/Oracle',
        'Specialized Solutions - Regional' => 'Specialized Solutions - Regional',
        'VBM Cloud' => 'VBM Cloud',
        'VP, General Manager' => 'VP, General Manager'
      ]
    ],
    'boolFilters' => [
      'onlyMyTeam' => 'Apenas meu time',
      'onlyMe' => 'OnlyMe'
    ],
    'presetFilters' => [
      'active' => 'Ativo',
      'activePortal' => 'Portal Ativo',
      'activeApi' => 'API Ativa',
      'reportFilter669ab1ec9e2cc5afe' => 'BDM Users: AWS',
      'reportFilter669ab1fb8382eba48' => 'BDM Users: Microsoft',
      'reportFilter669ab2078ca7cc670' => 'BDM Users: Google'
    ],
    'actions' => [
      'changePosition' => 'Change Position'
    ]
  ],
  'Webhook' => [
    'labels' => [
      'Create Webhook' => 'Criar Webhook'
    ],
    'fields' => [
      'event' => 'Evento',
      'url' => 'URL',
      'isActive' => 'Está Ativo',
      'user' => 'API de Usuário',
      'entityType' => 'Tipo de Entidade',
      'field' => 'Campo',
      'secretKey' => 'Chave Secreta'
    ],
    'links' => [
      'user' => 'Usuário'
    ]
  ],
  'WebhookQueueItem' => [
    'fields' => [
      'event' => 'Event',
      'webhook' => 'Webhook',
      'target' => 'Target',
      'data' => 'Data',
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'attempts' => 'Attempts',
      'processAt' => 'Process At'
    ],
    'links' => [
      'webhook' => 'Webhook'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pending',
        'Success' => 'Success',
        'Failed' => 'Failed'
      ]
    ]
  ],
  'WorkingTimeCalendar' => [
    'labels' => [
      'Create WorkingTimeCalendar' => 'Create Calendar'
    ],
    'fields' => [
      'timeZone' => 'Time Zone',
      'timeRanges' => 'Workday Schedule',
      'weekday0' => 'Sun',
      'weekday1' => 'Mon',
      'weekday2' => 'Tue',
      'weekday3' => 'Wed',
      'weekday4' => 'Thu',
      'weekday5' => 'Fri',
      'weekday6' => 'Sat',
      'weekday0TimeRanges' => 'Sun Schedule',
      'weekday1TimeRanges' => 'Mon Schedule',
      'weekday2TimeRanges' => 'Tue Schedule',
      'weekday3TimeRanges' => 'Wed Schedule',
      'weekday4TimeRanges' => 'Thu Schedule',
      'weekday5TimeRanges' => 'Fri Schedule',
      'weekday6TimeRanges' => 'Sat Schedule'
    ],
    'links' => [
      'ranges' => 'Exceptions'
    ]
  ],
  'WorkingTimeRange' => [
    'labels' => [
      'Create WorkingTimeRange' => 'Create Exception',
      'Calendars' => 'Calendars'
    ],
    'fields' => [
      'timeRanges' => 'Schedule',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'type' => 'Type',
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'links' => [
      'calendars' => 'Calendars',
      'users' => 'Users'
    ],
    'options' => [
      'type' => [
        'Non-working' => 'Non-working',
        'Working' => 'Working'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Actual'
    ],
    'tooltips' => [
      'calendars' => 'Calendars to apply the exception to. The exception will be applied to all users of selected calendars.

Leave the field empty if you need to apply the exception only for specific users.',
      'users' => 'Specific users to apply the exception to.'
    ]
  ],
  'Account' => [
    'fields' => [
      'name' => 'Nome',
      'emailAddress' => 'E-mail Institucional',
      'website' => 'Domínio',
      'phoneNumber' => 'Telefone',
      'billingAddress' => 'Endereço de Cobrança',
      'shippingAddress' => 'Endereço de Entrega',
      'description' => 'Descrição',
      'sicCode' => 'Número de identificação fiscal: (NIF/NIT/RUC/CNPJ)',
      'industry' => 'Ramo de Atividade',
      'type' => 'Tipo',
      'contactRole' => 'Regra',
      'contactIsInactive' => 'Inativo',
      'campaign' => 'Campanha',
      'targetLists' => 'Listas de Alvo',
      'targetList' => 'Lista de Alvo',
      'originalLead' => 'Lead Original',
      'priceBook' => 'Price Book',
      'electronicAddressScheme' => 'Electronic Address Scheme',
      'electronicAddressIdentifier' => 'Electronic Address Identifier',
      'updateField' => 'Update Field',
      'leads' => 'Leads',
      'logo' => 'Logo',
      'renewalresponsible' => 'Account Responsible (User)',
      'companyID' => 'TD SYNNEX ID',
      'country' => 'País',
      'partnerIDs' => 'IDs no fabricante',
      'surestepLevel' => 'Surestep Level Old',
      'surestep' => 'Surestep',
      'surestepLevel1' => 'Surestep Level',
      'solutions' => 'Solutions',
      'externalID' => 'ExternalID',
      'ciscoJourney' => 'Cisco Journey',
      'programs' => 'Programs',
      'billingAmount' => 'Valor de Faturamento',
      'billingAmountCurrency' => 'Valor de Faturamento (Currency)',
      'billingAmountConverted' => 'Valor de Faturamento (Converted)',
      'billingAmountRebait' => 'Valor de Faturamento (Com Rebait)',
      'billingAmountRebaitCurrency' => 'Valor de Faturamento (Com Rebait) (Currency)',
      'billingAmountRebaitConverted' => 'Valor de Faturamento (Com Rebait) (Converted)',
      'iSVExperience' => 'ISV Experience',
      'opps' => 'Oportunidades',
      'ciscoDMP' => 'Cisco DMP',
      'citrix' => 'Citrix',
      'services' => 'Oportunidades (Serviços) - Operadora / Revenda',
      'servicesPartner' => 'Oportunidades (Serviços) - Parceiro Executor',
      'servicesVersions' => 'Service Versions',
      'servicesVersionsPartner' => 'Service Versions',
      'serviceProvision' => 'Oportunidades (Serviços) - Provedor de Serviço',
      'endUserServices' => 'Oportunidades (Serviços) - Cliente Final',
      'servicesEndUser' => 'Oportunidades (Serviços) - Cliente Final',
      'servicesBillings' => 'Faturamentos',
      'servicesVersionss' => 'Versoes Serviços (End User)',
      'servicesVersionss1' => 'Versões Serviços',
      'partnerPrograms' => 'Programas de Parceiros',
      'cloudConsumptions' => 'Consumos em cloud',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Programa',
      'typeOfBusiness' => 'Tipo de Negocio',
      'aWS' => 'AWS',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'levelUp' => 'Level Up',
      'statusCPB' => 'Status CPB',
      'categoriaCPB' => 'CPB Category',
      'dSETAWS' => 'DSET AWS',
      'programaGoogleCloud' => 'Programa Google Cloud',
      'region' => 'Region',
      'progresspartner' => 'Partner Progress',
      'partnersGoogleCloud' => 'Partner Progress',
      'programaCloudPracticeBuilder' => 'Program - Cloud Practice Builder',
      'programSurestep' => 'Program - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'iSVExperiences' => 'Program ISV Experiences',
      'consumoSurestep' => 'Surestep Consumption',
      'cPBs' => 'CPBs',
      'fabricanteActivo' => 'Active Producer',
      'fabricanteActivated' => 'Producer Activated',
      'prizeRoulettes' => 'Roleta de Prêmios',
      'prizeRoulette' => 'Roleta de Prêmios',
      'updated' => 'Updated',
      'externalIDcdp' => 'External ID cdp',
      'events' => 'Events',
      'sPMSID' => 'SPMSID',
      'aWSs' => 'AWS',
      'aws' => 'Partner Program - AWS',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Matriz',
      'accounts' => 'Filial',
      'typeOfCompany' => 'Tipo de Empresa',
      'services1' => 'Oportunidades (Serviços) - Cliente Final',
      'partnerServices' => 'Oportunidades (Serviços) - Parceiro Executor',
      'servicesProvision' => 'Oportunidades (Serviços) - Provedor de Serviço',
      'vendorAccounts' => 'Vendor Accounts',
      'ciscos' => 'Cisco',
      'dSAStartDate' => 'DSA start date',
      'externalIDCIS' => 'ExternalIDCIS',
      'user' => 'Usuário VBM',
      'isv' => 'ISV',
      'unity' => 'Unidade',
      'dSAStatus' => 'DSA Status',
      'reports' => 'Reports',
      'renewals' => 'Microsoft Renewals - next 90 days',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Account VMB',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'VBA/BDR/BDM',
      'cloudsolvSSAID' => 'CloudsolvSSAID',
      'hasRenewals' => 'hasRenewals',
      'cisCode' => 'CIS Code',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations - next 90 days',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Mensageria',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals',
      'cPartnerAssessment' => 'Partner Assessment',
      'cPartnerAssessmentCategory' => 'Categoria do Parceiro',
      'cContactsAccount' => 'Lista de Contatos',
      'cVertical' => 'Vertical',
      'cPerfil' => 'Perfil',
      'cPotencial' => 'Potencial',
      'cExpectativa' => 'Expectativa',
      'cCurva' => 'Curva',
      'cPartnerFocus' => 'Foco do Parceiro',
      'cChecklistAWS' => 'Checklist Onboarding AWS',
      'cuit' => 'CUIT',
      'accountType' => 'Tipo de Cuenta',
      'vertical' => 'Vertical',
      'salesOrders' => 'Vendas',
      'salesOrderItems' => 'Item de pedido',
      'billingAddressCountry' => 'País (Billing)',
      'collaborators' => 'Backup'
    ],
    'links' => [
      'contacts' => 'Contatos',
      'contactsPrimary' => 'Contatos (primário)',
      'opportunities' => 'Oportunidades',
      'cases' => 'Atendimentos',
      'documents' => 'Documentos',
      'meetingsPrimary' => 'Reuniões (Interno)',
      'callsPrimary' => 'Ligações (Interno)',
      'tasksPrimary' => 'Tarefas (Interno)',
      'emailsPrimary' => 'Emails (expandido)',
      'targetLists' => 'Lista de Alvos',
      'campaignLogRecords' => 'Log da Campanha',
      'campaign' => 'Campanha',
      'portalUsers' => 'Usuários do Portal',
      'originalLead' => 'Lead Original',
      'priceBook' => 'Price Book',
      'supplier' => 'Supplier',
      'quotes' => 'Quotes',
      'quoteItems' => 'Quote Items',
      'salesOrders' => 'Vendas',
      'salesOrderItems' => 'Item de pedido',
      'invoices' => 'Invoices',
      'invoiceItems' => 'Invoice Items',
      'purchaseOrders' => 'Purchase Orders',
      'purchaseOrderItems' => 'Purchase Order Items',
      'deliveryOrders' => 'Delivery Orders',
      'deliveryOrderItems' => 'Delivery Order Items',
      'receiptOrders' => 'Receipt Orders',
      'receiptOrderItems' => 'Receipt Order Items',
      'returnOrders' => 'Return Orders',
      'returnOrderItems' => 'Return Order Items',
      'leads' => 'Leads',
      'renewalresponsible' => 'Renewal Responsible',
      'partnerIDs' => 'IDs no fabricante',
      'surestep' => 'Surestep',
      'ciscoJourney' => 'Cisco Journey',
      'programs' => 'Programs',
      'iSVExperience' => 'ISV Experience',
      'opps' => 'Oportunidades',
      'ciscoDMP' => 'Cisco DMP',
      'citrix' => 'Citrix',
      'services' => 'Oportunidades (Serviços) - Operadora / Revenda',
      'servicesPartner' => 'Oportunidades (Serviços) - Parceiro Executor',
      'servicesVersions' => 'Service Versions',
      'servicesVersionsPartner' => 'Service Versions',
      'serviceProvision' => 'Oportunidades (Serviços) - Provedor de Serviço',
      'endUserServices' => 'Oportunidades (Serviços) - Cliente Final',
      'servicesEndUser' => 'Oportunidades (Serviços) - Cliente Final',
      'servicesBillings' => 'Faturamentos',
      'servicesVersionss' => 'Versoes Serviços (End User)',
      'servicesVersionss1' => 'Versões Serviços',
      'partnerPrograms' => 'Programas de Parceiros',
      'cloudConsumptions' => 'Consumos em cloud',
      'cpb' => 'Cloud Practice Builder',
      'programs1' => 'Programa',
      'aWS' => 'AWS',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'googleClouds' => 'Google Clouds',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'levelUp' => 'Level Up',
      'programaGoogleCloud' => 'Programa Google Cloud',
      'region' => 'Region',
      'country' => 'Country',
      'progresspartner' => 'Partner Progress',
      'partnersGoogleCloud' => 'Partner Progress',
      'programaAWS' => 'Programs - AWS',
      'programaCloudPracticeBuilder' => 'Program Cloud Practice Builder',
      'programSurestep' => 'Program - Surestep',
      'iSVExperience1' => 'Programa ISV Experience',
      'iSVExperiences' => 'Program ISV Experiences',
      'cPBs' => 'CPBs',
      'prizeRoulettes' => 'Roleta de Prêmios',
      'prizeRoulette' => 'Roleta de Prêmios',
      'events' => 'Events',
      'aWSs' => 'AWS',
      'aws' => 'Partner Program - AWS',
      'dSETs' => 'DSET',
      'cpbIoTFinancial' => 'CPB IoT Financial',
      'cpbIoTStrategy' => 'CPB IoT Strategy',
      'cPBIoTAnalytic' => 'CPB IoT Analytic',
      'cPBIoTMarketing' => 'CPB IoT Marketing',
      'cPBIoTTechnology' => 'CPB IoT Technology',
      'pBGeral' => 'PBGeral',
      'vendorSubscriptions' => 'Vendor Subscriptions',
      'accountParent' => 'Matriz',
      'accounts' => 'Filial',
      'services1' => 'Oportunidades (Serviços) - Cliente Final',
      'partnerServices' => 'Oportunidades (Serviços) - Parceiro Executor',
      'servicesProvision' => 'Oportunidades (Serviços) - Provedor de Serviço',
      'vendorAccounts' => 'Vendor Accounts',
      'ciscos' => 'Cisco',
      'user' => 'Usuário VBM',
      'reports' => 'Reports',
      'renewals' => 'Microsoft Renewals - next 90 days',
      'emailContent' => 'Email Content',
      'accountVMB' => 'Account VMB',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'top5Customers' => 'Top 5 Customers',
      'reservedInstances' => 'Reserved Instances',
      'bdm' => 'BDMs',
      'users' => 'BDMs',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesOrdersRecommendations' => 'Microsoft Recommendations - next 90 days',
      'accountContent' => 'Account Content',
      'messenger' => 'Messenger',
      'messengers' => 'Mensageria',
      'renewalsMicrosoft' => 'Microsoft Renewals',
      'cUserSales' => 'AM',
      'cRenewalsMicrosoft' => 'Microsoft Renewals',
      'cPartnerAssessment' => 'Partner Assessment',
      'cContactsAccount' => 'Lista de Contatos'
    ],
    'options' => [
      'type' => [
        'Customer' => 'Cliente',
        'Investor' => 'Investidor',
        'Partner' => 'Parceiro',
        'Reseller' => 'Revendedor',
        '' => '',
        'ISV' => 'ISV',
        'Enterprise' => 'Enterprise',
        'Consulting' => 'Consulting',
        'Technology' => 'Technology',
        'Socio	' => 'Partner',
        'Service Provider' => 'Service Provider',
        'Manufacturer' => 'Fabricante'
      ],
      'industry' => [
        'Aerospace' => 'Aeroespacial',
        'Agriculture' => 'Agricultura',
        'Advertising' => 'Publicidade',
        'Apparel & Accessories' => 'Apparel & Accessories',
        'Architecture' => 'Arquitetura',
        'Automotive' => 'Automotiva',
        'Banking' => 'Banco',
        'Biotechnology' => 'Biotecnologia',
        'Building Materials & Equipment' => 'Materiais de Construção e Equipamento',
        'Chemical' => 'Química',
        'Construction' => 'Construção',
        'Computer' => 'Computadores',
        'Defense' => 'Defense',
        'Creative' => 'Criativa',
        'Culture' => 'Cultura',
        'Consulting' => 'Consultoria',
        'Education' => 'Educação',
        'Electronics' => 'Eletrônicos',
        'Electric Power' => 'Energia Elétrica',
        'Energy' => 'Energia',
        'Entertainment & Leisure' => 'Entretenimento e Laser',
        'Finance' => 'Finanças',
        'Food & Beverage' => 'Alimentação',
        'Grocery' => 'Mercearia',
        'Hospitality' => 'Hotelaria',
        'Healthcare' => 'Plano de Saúde',
        'Insurance' => 'Insurance',
        'Legal' => 'Jurídico',
        'Manufacturing' => 'Manufatura',
        'Mass Media' => 'Mídia de Massa',
        'Mining' => 'Mineração',
        'Music' => 'Musica',
        'Marketing' => 'Marketing',
        'Publishing' => 'Publicações',
        'Petroleum' => 'Petróleo',
        'Real Estate' => 'Real Estate',
        'Retail' => 'Varejo',
        'Shipping' => 'Navegação',
        'Service' => 'Serviços',
        'Support' => 'Suporte',
        'Sports' => 'Esportes',
        'Software' => 'Software',
        'Technology' => 'Tecnologia',
        'Telecommunications' => 'Telecommunications',
        'Television' => 'Televisão',
        'Testing, Inspection & Certification' => 'Testes, Inspeção e Certificação',
        'Transportation' => 'Transportes',
        'Travel' => 'Viagem',
        'Venture Capital' => 'Capital de Risco',
        'Wholesale' => 'Atacado',
        'Water' => 'Água',
        '' => 'N/A',
        'Capital Markets' => 'Capital Markets',
        'Consumer Goods' => 'Consumer Goods',
        'Critical Infrastructure' => 'Critical Infrastructure',
        'Discrete Manufacturing' => 'Discrete Manufacturing',
        'Health & Human Services' => 'Health & Human Services',
        'Health Payor' => 'Health Payor',
        'Health Provider' => 'Health Provider',
        'Higher Education' => 'Higher Education',
        'Media & Entertainment' => 'Media & Entertainment',
        'Nonprofit & IGO' => 'Nonprofit & IGO',
        'Other - Unsegmented' => 'Other - Unsegmented',
        'Other Government' => 'Other Government',
        'Partner Professional Services' => 'Partner Professional Services',
        'Pharma & Life Sciences' => 'Pharma & Life Sciences',
        'Primary & Secondary Edu/K-12' => 'Primary & Secondary Edu/K-12',
        'Process Manufacturing & Agriculture' => 'Process Manufacturing & Agriculture',
        'Professional Services' => 'Professional Services',
        'Public Safety & Justice' => 'Public Safety & Justice',
        'Retailers' => 'Retailers',
        'Tax, Revenue & Finance' => 'Tax, Revenue & Finance',
        'Travel, Tpt, Lgstcs & Hosp' => 'Travel, Tpt, Lgstcs & Hosp',
        'ISV - Digital Native Company' => 'ISV - Digital Native Company'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'CALA' => 'CALA',
        'Caribe' => 'Caribe',
        'Centro' => 'Centro',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Equador' => 'Ecuador',
        'México' => 'Mexico',
        'Perú' => 'Peru',
        'South' => 'Sul',
        'Amer.Virgin Is.' => 'Amer.Virgin Is.',
        'Antigua/Barbuda' => 'Antigua/Barbuda',
        'Aruba' => 'Aruba',
        'Bahamas' => 'Bahamas',
        'Barbados' => 'Barbados',
        'Bermuda' => 'Bermuda',
        'Bolivia' => 'Bolivia',
        'BQ' => 'BQ',
        'Brit.Virgin Is.' => 'Brit.Virgin Is.',
        'Cayman Islands' => 'Cayman Islands',
        'Costa Rica' => 'Costa Rica',
        'CW' => 'CW',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Grenada' => 'Grenada',
        'Guadeloupe' => 'Guadeloupe',
        'Guyana' => 'Guyana',
        'Honduras' => 'Honduras',
        'Jamaica' => 'Jamaica',
        'Nicaragua' => 'Nicaragua',
        'Panama' => 'Panama',
        'St. Lucia' => 'St. Lucia',
        'St. Vincent' => 'St. Vincent',
        'Suriname' => 'Suriname',
        'SX' => 'SX',
        'Trinidad Tobago' => 'Trinidad Tobago',
        'USA' => 'USA',
        'CCA' => 'CCA',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'Brazil' => 'Brazil',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Paraguay' => 'Paraguay',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador ' => 'Ecuador',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'United States' => 'United States',
        'Brasil (teste)' => 'Brasil (teste)'
      ],
      'surestepLevel' => [
        '' => '',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'Top SKR' => 'Top SKR',
        'TopSKR' => 'TopSKR',
        'New Partner' => 'New Partner',
        'In Process' => 'In Process to Activate'
      ],
      'solutions' => [
        'Azure' => 'Azure',
        'Modern Workplace' => 'Modern Workplace',
        'Dynamics 365' => 'Dynamics 365',
        'Surestep' => 'Surestep',
        'Cisco' => 'Cisco',
        'Cisco BlackBelt' => 'Cisco BlackBelt',
        'Citrix' => 'Citrix'
      ],
      'statusCPB' => [
        '' => '',
        'Concluido' => 'Done',
        'Desenvolvimento' => 'Development',
        'Iniciado' => 'Started'
      ],
      'categoriaCPB' => [
        '' => '',
        'SemCategoria' => 'SemCategoria',
        'Accelerator' => 'Accelerator',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Sem Categoria' => 'N/A'
      ],
      'dSETAWS' => [
        '' => '',
        'Principiante' => 'Beginner',
        'Intermedio' => 'Intermediate',
        'Avanzado' => 'Advanced'
      ],
      'region' => [
        '' => '',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA',
        'Mexico' => 'Mexico',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'None LAC' => 'None LAC'
      ],
      'fabricanteActivated' => [
        'ISV Experience' => 'ISV Experience'
      ],
      'typeOfCompany' => [
        '' => '',
        'Matriz' => 'Matriz',
        'Filial' => 'Filial'
      ],
      'isv' => [
        '' => 'Não',
        'Sim' => 'Sim'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Valor' => 'Valor',
        'Telco' => 'Telco'
      ],
      'dSAStatus' => [
        '' => '',
        'Cancelled' => 'Cancelled',
        'Executed' => 'Executed',
        'In Progress' => 'In Progress',
        'Inactive' => 'Inactive',
        'Pending DSA Signature' => 'Pending DSA Signature',
        'Rejected' => 'Rejected'
      ],
      'cVertical' => [
        '' => '',
        'Governo' => 'Governo',
        'Saúde' => 'Saúde',
        'Educação' => 'Educação',
        'Corporativo' => 'Corporativo'
      ],
      'cPerfil' => [
        '' => '',
        'Desenvolvimento' => 'Desenvolvimento',
        'Retenção' => 'Retenção',
        'Aquisição' => 'Aquisição',
        'Onboarding' => 'Onboarding',
        'Ativação' => 'Ativação',
        'TOP Partner' => 'TOP Partner'
      ],
      'cPotencial' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'cExpectativa' => [
        '' => '',
        'Curto Prazo' => 'Curto Prazo',
        'Médio Prazo' => 'Médio Prazo',
        'Longo Prazo' => 'Longo Prazo'
      ],
      'cCurva' => [
        '' => '',
        'A' => 'A',
        'B' => 'B',
        'C' => 'C'
      ],
      'cPartnerFocus' => [
        'AWS' => 'AWS',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'IBM' => 'IBM',
        'Oracle Cloud' => 'Oracle Cloud',
        'Outros' => 'Outros'
      ],
      'cChecklistAWS' => [
        'Aprovação de Limite de Crédito ao Cliente final, sujeito a análise de documentação financeira' => 'Aprovação de Limite de Crédito ao Cliente final, sujeito a análise de documentação financeira',
        'A Politica de concessão de crédito TDSYNNEX não aprova clientes com menos de 6 meses de CNPJ Ativo' => 'A Politica de concessão de crédito TDSYNNEX não aprova clientes com menos de 6 meses de CNPJ Ativo',
        'Efetuar o Cadastro do cliente final no Stream One' => 'Efetuar o Cadastro do cliente final no Stream One',
        'Agendar previamente com o time “SSCloud” antes de iniciarmos uma migração' => 'Agendar previamente com o time “SSCloud” antes de iniciarmos uma migração',
        'Antes de iniciarmos a migração de uma conta AWS, validar se há consumo de serviços na Conta Payer' => 'Antes de iniciarmos a migração de uma conta AWS, validar se há consumo de serviços na Conta Payer',
        'Validar se há risco de Share Shift para contas maiores que U$ 50K' => 'Validar se há risco de Share Shift para contas maiores que U$ 50K',
        'Migrações após o dia 20 estão sujeitas a não ter o desconto de Parceria repassado pela AWS' => 'Migrações após o dia 20 estão sujeitas a não ter o desconto de Parceria repassado pela AWS',
        'Movimentação de contas já migradas anteriormente para a TDSYYNEX' => 'Movimentação de contas já migradas anteriormente para a TDSYYNEX',
        'Créditos lançados pela AWS no console do cliente são aplicados a partir do 2nd mês após a migração' => 'Créditos lançados pela AWS no console do cliente são aplicados a partir do 2nd mês após a migração',
        'Atenção ao Custo do Console VS Valores Faturados | “AWS Distribution Program Discount”' => 'Atenção ao Custo do Console VS Valores Faturados | “AWS Distribution Program Discount”',
        'Consumo de Marketplace possui incidência de Withholding Tax “15%” | Serviços adquiridos nos EUA' => 'Consumo de Marketplace possui incidência de Withholding Tax “15%” | Serviços adquiridos nos EUA',
        'Não há “comissão” para serviços de Marketplace - Solicitar a inclusão de Mkup' => 'Não há “comissão” para serviços de Marketplace - Solicitar a inclusão de Mkup',
        'Dólar diferente do Console AWS para serviços de Market Place, TDSYNNEX faz Hedge de dólar' => 'Dólar diferente do Console AWS para serviços de Market Place, TDSYNNEX faz Hedge de dólar',
        'Notas fiscais da TDSYNNEX suportam até 10 linhas de Produtos, Serviços' => 'Notas fiscais da TDSYNNEX suportam até 10 linhas de Produtos, Serviços',
        'NFs de Serviços AWS são emitidas separadamente das NFs para serviços de Market Place' => 'NFs de Serviços AWS são emitidas separadamente das NFs para serviços de Marketplace',
        'DSA (Distribution Seller Agreement)' => 'DSA (Distribution Seller Agreement)',
        'Desconto de Parceria' => 'Desconto de Parceria',
        'Dólar / Impostos - Serviços AWS' => 'Dólar / Impostos - Serviços AWS',
        'Dólar / Impostos - Marketplace' => 'Dólar / Impostos - Marketplace',
        'Ferramentas TD SYNNEX (agendar previamente (AM): EC Express e Stellr (SS Cloud), definição dos roles' => 'Ferramentas TD SYNNEX (agendar previamente (AM): EC Express e Stellr (SS Cloud), definição dos roles'
      ],
      'accountType' => [
        '' => '',
        'VAR' => 'VAR',
        'DNC' => 'DNC',
        'Cliente Final' => 'Cliente Final'
      ],
      'vertical' => [
        '' => '',
        'Accommodation' => 'Accommodation',
        'Accounting & Consulting' => 'Accounting & Consulting',
        'Advertising' => 'Advertising',
        'Agriculture' => 'Agriculture',
        'Architecture & Engineering' => 'Architecture & Engineering',
        'Banking' => 'Banking',
        'Broadcasters' => 'Broadcasters',
        'Capital Markets/Securities' => 'Capital Markets/Securities',
        'Chemicals' => 'Chemicals',
        'Cities & Regions' => 'Cities & Regions',
        'Comms&Ntwrk Equip Providers' => 'Comms&Ntwrk Equip Providers',
        'Comms&Ntwrk Service Providers' => 'Comms&Ntwrk Service Providers',
        'Construction' => 'Construction',
        'Consumer Goods' => 'Consumer Goods',
        'Defense' => 'Defense',
        'Food Service' => 'Food Service',
        'General Merchandise' => 'General Merchandise',
        'Government Social Programs' => 'Government Social Programs',
        'Grocery' => 'Grocery',
        'Health Payor' => 'Health Payor',
        'Health Provider' => 'Health Provider',
        'High Tech & Electronics' => 'High Tech & Electronics',
        'Higher Education' => 'Higher Education',
        'IndstrlEquip&Aerospc&FarmEquip' => 'IndstrlEquip&Aerospc&FarmEquip',
        'Insurance Direct' => 'Insurance Direct',
        'Insurance Other' => 'Insurance Other',
        'IT Services' => 'IT Services',
        'Justice' => 'Justice',
        'Legal Services' => 'Legal Services',
        'Logistics & Trucking' => 'Logistics & Trucking',
        'Membership Organizations' => 'Membership Organizations',
        'Mining' => 'Mining',
        'Mobility Service Provider' => 'Mobility Service Provider',
        'Other - Unsegmented' => 'Other - Unsegmented',
        'Other Services' => 'Other Services',
        'Outsourced Services' => 'Outsourced Services',
        'Pharma & Life Sciences' => 'Pharma & Life Sciences',
        'Power & Utilities' => 'Power & Utilities',
        'Primary & Secondary Edu/ K-12' => 'Primary & Secondary Edu/ K-12',
        'Public Administration' => 'Public Administration',
        'Public Safety' => 'Public Safety',
        'Public Works & Services' => 'Public Works & Services',
        'Publishing' => 'Publishing',
        'Resources & Environment' => 'Resources & Environment',
        'Software' => 'Software',
        'Specialty Retail' => 'Specialty Retail',
        'Tax & Revenue' => 'Tax & Revenue',
        'Transport Services' => 'Transport Services',
        'Unknown' => 'Unknown',
        'Water & Sewage' => 'Water & Sewage',
        'Wholesale Distribution' => 'Wholesale Distribution'
      ]
    ],
    'labels' => [
      'Create Account' => 'Criar Conta',
      'Copy Billing' => 'Copiar Cobrança',
      'Set Primary' => 'Definir Primário'
    ],
    'presetFilters' => [
      'customers' => 'Clientes',
      'partners' => 'Parceiros',
      'recentlyCreated' => 'Criado Recentemente',
      'reportFilter6660add1bf8c29edd' => 'Renewals Notification: Account',
      'reportFilter67c9a61c38980f876' => 'Contas - Brasil'
    ],
    'tabs' => [
      'Account' => 'Account',
      'Support' => 'Support'
    ],
    'tooltips' => [
      'cPerfil' => '**Onboarding:** Processo de boas-vindas e capacitação inicial para revendedores e clientes, com foco em apresentar as soluções cloud, proposta de valor TDSYNNEX, ferramentas e sistema, programa de canais dos respectivos fabricantes de interesse, Plataformas de Suporte, Pós-Vendas, Noc.
 
**Ativação:** Foco na ativação de canais sem consumo.
 
**Desenvolvimento:** Acompanhamento contínuo sobre a evolução do canal, Receita e Capacitação.
 
**TOP Partner:** Foco na fidelização de parceiros com alta performance em vendas, engajamento e excelência no atendimento.',
      'cExpectativa' => '**Curto Prazo (até 3 meses):**
 • Aumentar as Vendas
 • Expandir a Base de Clientes, trazendo volume de vendas mensais e taxa de conversão;
 • Estabelecer uma Comunicação Eficiente: Manter uma comunicação clara e constante com o distribuidor para resolver rapidamente quaisquer problemas ou dúvidas (criar conexão com o parceiro).

**Médio Prazo (3 a 4 meses):**
 • Estabelecer Relacionamentos Sólidos
 • Expandir a Linha de Produtos
 • Aprimorar o Marketing Conjunto: Colaborar com o distribuidor em campanhas de marketing e promoções para aumentar a visibilidade e as vendas de ambos.
 • Expandir a base de clientes e fortalecer a marca.
 • Crescimento anual de vendas e participação de mercado.

**Longo Prazo (4 meses ou mais):**
 • Crescimento de Mercado: Expandir a presença no mercado, alcançando novos clientes e aumentando a participação de mercado.
 • Expandir a base de clientes e fortalecer a marca.
 • Desenvolvimento de novos produtos e tecnologias e diversificação de  portfólio, como serviços e treinamentos junto a TD SYNNEX.',
      'cCurva' => '**A** -> **Acima** de U$ 12K
**B** -> **Abaixo** de U$ 12K
**C** -> **Sem Base Line**',
      'emailAddress' => 'Ex: contato@empresa.com'
    ]
  ],
  'Calendar' => [
    'modes' => [
      'month' => 'Mês',
      'week' => 'Semana',
      'day' => 'Dia',
      'agendaWeek' => 'Semana',
      'agendaDay' => 'Dia',
      'timeline' => 'Linha do Tempo'
    ],
    'labels' => [
      'Today' => 'Hoje',
      'Create' => 'Criar',
      'Shared' => 'Compartilhado',
      'Add User' => 'Adicionar Usuário',
      'current' => 'atual',
      'time' => 'tempo',
      'User List' => 'Lista de Usuário',
      'Manage Users' => 'Gerenciar Usuários',
      'View Calendar' => 'Ver Calendário',
      'Create Shared View' => 'Criar Visualização Compartilhada'
    ]
  ],
  'Call' => [
    'fields' => [
      'name' => 'Nome',
      'parent' => 'Relação',
      'status' => 'Status',
      'dateStart' => 'Data de Início',
      'dateEnd' => 'Data Final',
      'direction' => 'Direção',
      'duration' => 'Duração',
      'description' => 'Descrição',
      'users' => 'Usuários',
      'contacts' => 'Contatos',
      'leads' => 'Leads',
      'reminders' => 'Lembretes',
      'account' => 'Conta',
      'acceptanceStatus' => 'Status de Aceitação',
      'uid' => 'UID',
      'insideSales' => 'Inside Sales?',
      'impossibleContact' => 'Impossible to Contact',
      'leads1' => 'Leads',
      'lead' => 'Lead',
      'solution' => 'Solution',
      'source' => 'Source',
      'leadCountry' => 'Lead Country',
      'citrix' => 'Citrix'
    ],
    'links' => [
      'leads1' => 'Leads',
      'lead' => 'Lead',
      'citrix' => 'Citrix'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planejado',
        'Held' => 'Atendida',
        'Not Held' => 'Não atendida'
      ],
      'direction' => [
        'Outbound' => 'Saída',
        'Inbound' => 'Entrada'
      ],
      'acceptanceStatus' => [
        'None' => 'Nenhum',
        'Accepted' => 'Aceita',
        'Declined' => 'Rejeitada',
        'Tentative' => 'Tentativa'
      ],
      'insideSales' => [
        'Yes' => 'Sim',
        'No' => 'Não',
        ' ' => ' '
      ],
      'impossibleContact' => [
        '' => '',
        'No number' => 'No number',
        'Invalid number' => 'Invalid number'
      ],
      'source' => [
        'Microsoft Surestep' => 'Microsoft Surestep',
        'Security' => 'Security',
        'Modern Workplace' => 'Modern Workplace',
        '' => '',
        'Other' => 'Other'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar para Realizar',
      'setNotHeld' => 'Marcar Não Realizado'
    ],
    'labels' => [
      'Create Call' => 'Criar Ligação',
      'Set Held' => 'Marcar como Realizada',
      'Set Not Held' => 'Marcar como não realizada',
      'Send Invitations' => 'Enviar Convites'
    ],
    'presetFilters' => [
      'planned' => 'Planejado',
      'held' => 'Realizado',
      'todays' => 'Hoje'
    ]
  ],
  'Campaign' => [
    'fields' => [
      'name' => 'Nome',
      'description' => 'Descrição',
      'status' => 'Status',
      'type' => 'Tipo',
      'startDate' => 'Data de início',
      'endDate' => 'Data de fim',
      'targetLists' => 'Lista de Alvos',
      'excludingTargetLists' => 'Excluindo Lista de Alvos',
      'sentCount' => 'Enviar',
      'openedCount' => 'Abertos',
      'clickedCount' => 'Clicados',
      'optedOutCount' => 'Cancelamentos',
      'bouncedCount' => 'Bounces',
      'optedInCount' => 'Opted In',
      'hardBouncedCount' => 'Hard Bounce',
      'softBouncedCount' => 'Soft Bounce',
      'leadCreatedCount' => 'Leads Criados',
      'revenue' => 'Receita',
      'revenueConverted' => 'Revenda (convertida)',
      'budget' => 'Orçamento',
      'budgetConverted' => 'Orçamento (convertido)',
      'budgetCurrency' => 'Moeda do Budget',
      'contactsTemplate' => 'Modelo de Contatos',
      'leadsTemplate' => 'Modelo de Leads',
      'accountsTemplate' => 'Modelo de Contas',
      'usersTemplate' => 'Modelo de Usuários',
      'mailMergeOnlyWithAddress' => 'Pular registros sem endereço preenchido'
    ],
    'links' => [
      'targetLists' => 'Lista de alvos',
      'excludingTargetLists' => 'Excluindo Lista de Alvos',
      'accounts' => 'Contas',
      'contacts' => 'Contatos',
      'leads' => 'Leads',
      'opportunities' => 'Oportunidades',
      'campaignLogRecords' => 'Log',
      'massEmails' => 'Email em Massa',
      'trackingUrls' => 'URLs de Rastreio',
      'contactsTemplate' => 'Modelo de Contatos',
      'leadsTemplate' => 'Modelo de Leads',
      'accountsTemplate' => 'Modelo de Contas',
      'usersTemplate' => 'Modelo de Usuários'
    ],
    'options' => [
      'type' => [
        'Email' => 'E-mail',
        'Web' => 'Web',
        'Television' => 'Televisão',
        'Radio' => 'Rádio',
        'Newsletter' => 'Newsletter',
        'Mail' => 'Correio'
      ],
      'status' => [
        'Planning' => 'Planejamento',
        'Active' => 'Ativa',
        'Inactive' => 'Inativa',
        'Complete' => 'Completa'
      ]
    ],
    'labels' => [
      'Create Campaign' => 'Criar Campanha',
      'Target Lists' => 'Lista de Alvos',
      'Statistics' => 'Estatísticas',
      'hard' => 'hard',
      'soft' => 'soft',
      'Unsubscribe' => 'Cancelar Subscrição',
      'Mass Emails' => 'Emails em Massa',
      'Email Templates' => 'Templates de email',
      'Unsubscribe again' => 'Cancelar inscrição novamente',
      'Subscribe again' => 'Inscreva-se novamente',
      'Create Target List' => 'Criar Lista de Alvo',
      'Mail Merge' => 'Mala Direta',
      'Generate Mail Merge PDF' => 'Gerar PDF de mala direta'
    ],
    'presetFilters' => [
      'active' => 'Ativa'
    ],
    'messages' => [
      'unsubscribed' => 'Você foi descadastrado de nossa lista de emails.',
      'subscribedAgain' => 'Você está inscrito novamente.'
    ],
    'tooltips' => [
      'targetLists' => 'Alvos que devem receber mensagens.',
      'excludingTargetLists' => 'Alvos que não devem receber mensagens.'
    ]
  ],
  'CampaignLogRecord' => [
    'fields' => [
      'action' => 'Ação',
      'actionDate' => 'Data',
      'data' => 'Dados',
      'campaign' => 'Campanha',
      'parent' => 'Alvo',
      'object' => 'Objeto',
      'application' => 'Aplicação',
      'queueItem' => 'Queue Item',
      'stringData' => 'Dados String',
      'stringAdditionalData' => 'Dados Adicionais String',
      'isTest' => 'É Teste'
    ],
    'links' => [
      'queueItem' => 'Queue Item',
      'parent' => 'Parent',
      'object' => 'Assunto',
      'campaign' => 'Campanha'
    ],
    'options' => [
      'action' => [
        'Sent' => 'Enviado',
        'Opened' => 'Aberto',
        'Opted Out' => 'Cancelado',
        'Bounced' => 'Bounced',
        'Clicked' => 'Clicado',
        'Lead Created' => 'Lead Criado',
        'Opted In' => 'Opted In'
      ]
    ],
    'labels' => [
      'All' => 'Tudo'
    ],
    'presetFilters' => [
      'sent' => 'Enviado',
      'opened' => 'Aberto',
      'optedOut' => 'Cancelado',
      'optedIn' => 'Opted In',
      'bounced' => 'Bounced',
      'clicked' => 'Clicado',
      'leadCreated' => 'Lead criado'
    ]
  ],
  'CampaignTrackingUrl' => [
    'fields' => [
      'url' => 'URL',
      'action' => 'Ação',
      'urlToUse' => 'Código para inserir em vez de URL',
      'message' => 'Mensagem',
      'campaign' => 'Campanha'
    ],
    'links' => [
      'campaign' => 'Campanha'
    ],
    'labels' => [
      'Create CampaignTrackingUrl' => 'Criar URL de rastreamento'
    ],
    'options' => [
      'action' => [
        'Redirect' => 'Redirecionar',
        'Show Message' => 'Mostrar Mensagem'
      ]
    ],
    'tooltips' => [
      'url' => 'O destinatário será redirecionado para este local depois de seguir o link.',
      'message' => 'A mensagem será mostrada ao destinatário depois que ele seguir o link. Markdown é suportado.'
    ]
  ],
  'Case' => [
    'fields' => [
      'name' => 'Nome',
      'number' => 'Número',
      'status' => 'Estágio',
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos',
      'priority' => 'Prioridade',
      'type' => 'Tipo',
      'description' => 'Descrição',
      'inboundEmail' => 'E-mail de Entrada',
      'lead' => 'Lead',
      'attachments' => 'Anexos',
      'originalEmail' => 'Original Email',
      'isInternal' => 'Hidden from Portal',
      'solicitationType' => 'Minha solicitação trata de:',
      'solicitationEntity' => 'Entidade de solicitação',
      'testField' => 'Campo de teste',
      'other' => 'Especifique a entidade',
      'url' => 'URL do Registro',
      'slaPrediction' => 'Previsão',
      'cRegion' => 'Região',
      'assignedUser' => 'Usuário Atribuído',
      'createdAt' => 'Criado em',
      'createdBy' => 'Criado por',
      'modifiedAt' => 'Modificado em',
      'teams' => 'Equipes'
    ],
    'links' => [
      'inboundEmail' => 'E-mail de Entrada',
      'account' => 'Conta',
      'contact' => 'Contato (Primário)',
      'Contacts' => 'Contatos',
      'meetings' => 'Reuniões',
      'calls' => 'Ligações',
      'tasks' => 'Tarefas',
      'emails' => 'Emails',
      'articles' => 'Artigos da Base de Conhecimento',
      'lead' => 'Lead',
      'attachments' => 'Anexos',
      'assignedUser' => 'Usuário Atribuído',
      'contacts' => 'Contatos',
      'createdBy' => 'Criado por',
      'teams' => 'Equipes'
    ],
    'options' => [
      'status' => [
        'New' => 'Novo',
        'Assigned' => 'Em progresso',
        'Pending' => 'Pendente',
        'Closed' => 'Fechado',
        'Rejected' => 'Rejeitado',
        'Duplicate' => 'Duplicado'
      ],
      'priority' => [
        'Low' => 'Baixa',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ],
      'type' => [
        'Question' => 'Pergunta',
        'Incident' => 'Incidente',
        'Problem' => 'Problema'
      ],
      'solicitationType' => [
        'Select an option.' => 'Selecione uma opção.',
        'Trouble with 404 error.' => 'Problema com o erro 404.',
        'Trouble with 500 error.' => 'Problema com o erro 500.',
        'I need help with one or more fields.' => 'Preciso de ajuda com um ou mais campos.',
        'My data is not updated.' => 'Meus dados não estão atualizados.',
        'My data is wrong.' => 'Meus dados estão incorretos.',
        'My list is outdated.' => 'Minha lista está desatualizada.',
        'I can\'t create reports.' => 'Não posso criar relatórios.',
        'I can\'t create calls.' => 'Não posso criar Ligações.',
        'I can\'t create meetings.' => 'Não posso criar reuniões.',
        'I can\'t create tasks.' => 'Não posso criar tarefas.',
        'I can\'t create reminders.' => 'Não posso criar lembretes.',
        'I can\'t make edits.' => 'Não posso fazer edições.',
        'I can\'t make updates.' => 'Não posso fazer atualizações.',
        'I can\'t access the Kanban view.' => 'Não consigo acessar a vista Kanban.',
        'I can\'t see my data in the list.' => 'Não consigo ver meus dados na lista.',
        'I can\'t see my data in the dashboards.' => 'Não consigo ver meus dados nos Dashboards.',
        'I couldn\'t understand a tutorial.' => 'Eu não consegui entender um tutorial.',
        'There is no tutorials for my specific need.' => 'Não há tutoriais para minha necessidade específica.',
        'I am not finding a specific data/information (Requires description).' => 'Não encontro dados/informações específicos (requere descrição).',
        'I can\'t see my history.' => 'Não consigo ver meu histórico.',
        'I can\'t see my activities.' => 'Não posso ver minhas atividades.',
        'I can\'t see my tasks.' => 'Não consigo ver minhas tarefas.',
        'I can\'t see my dashboards.' => 'Não posso ver meus Dashboards.',
        'Other.' => 'Outro.'
      ],
      'solicitationEntity' => [
        'Select an option.' => 'Selecione uma opção',
        'Accounts' => 'Contas',
        'Calls' => 'Ligações',
        'Contacts' => 'Contatos',
        'Leads' => 'Leads',
        'Meetings' => 'Reuniões',
        'Opportunities' => 'Oportunidades',
        'Reports' => 'Relatorios',
        'Tasks' => 'Tarefas',
        'Users' => 'Usuários',
        'Quotes' => 'Cotações',
        '' => '',
        'Other' => 'Outro',
        'Partner Program' => 'Partner Program'
      ],
      'cRegion' => [
        '' => '',
        'Brasil' => 'Brasil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Case' => 'Criar suporte',
      'Close' => 'Fechar',
      'Reject' => 'Reject',
      'Closed' => 'Fechado',
      'Rejected' => 'Rejected'
    ],
    'presetFilters' => [
      'open' => 'Aberto',
      'closed' => 'Fechado'
    ],
    'tooltips' => [
      'solicitationType' => 'Aqui você encontrará algumas opções para abrir um ticket. Se não encontrar a que precisa, selecione a opção: \'Outro\' e descreva no campo \'Descrição\'.',
      'solicitationEntity' => 'Para abrir uma solicitação de suporte, por favor, selecione com qual entidade você precisa de ajuda.',
      'url' => 'Insira a URL do registro.',
      'attachments' => 'Por favor, insira uma imagem, arquivo ou qualquer informação que ajude na descrição de sua solicitação.'
    ]
  ],
  'Contact' => [
    'fields' => [
      'name' => 'Nome',
      'emailAddress' => 'E-mail',
      'title' => 'Titulo da Conta',
      'account' => 'Conta',
      'accounts' => 'Contas',
      'phoneNumber' => 'Telefone',
      'accountType' => 'Tipo de Conta',
      'doNotCall' => 'Não Ligar',
      'address' => 'Endereço',
      'opportunityRole' => 'Regra de Oportunidade',
      'accountRole' => 'Regra',
      'description' => 'Descrição',
      'campaign' => 'Campanha',
      'targetLists' => 'Listas de Alvo',
      'targetList' => 'Lista de Alvo',
      'portalUser' => 'Usuário do Portal',
      'hasPortalUser' => 'Tem Usuário do Portal',
      'originalLead' => 'Lead Original',
      'acceptanceStatus' => 'Status de Aceitação',
      'accountIsInactive' => 'Conta Inativa',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Status de Aceitação (Ligações)',
      'originalEmail' => 'Original Email',
      'analytics' => 'Analytics',
      'customerID' => 'Customer ID',
      'partnerID' => 'Partner ID',
      'type' => 'Tipo',
      'updateField' => 'Update Field',
      'lead' => 'Lead',
      'user' => 'BDM User',
      'bdmuser' => 'BDM User',
      'requestedContact' => 'Requested contact',
      'nurturingProfile' => 'Nurturing Profile',
      'nurturingLinkProfile' => 'Nurturing Link profile',
      'archivosDeIntereses' => 'Archivos de intereses',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Programa Google Cloud',
      'programGoogleClouds' => 'Programa Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'position' => 'Cargo',
      'quotes' => 'Cotações',
      'opportunity' => 'Oportunidade',
      'billingContactOpportunities' => 'Oportunidades (Billing Contact)',
      'accountVBM' => 'Account VBM',
      'source' => 'Origem',
      'externalIDcdp' => 'ExternalIDcdp',
      'emailContents' => 'Email Contents',
      'hasRenewals' => 'Contato Renovações',
      'dataAIAssessment' => 'Data AI Assessment',
      'salesContact' => 'Sales Contact',
      'accountCountry' => 'País (Conta)',
      'cMarketing' => 'Marketing',
      'cAccountEndCustomer' => 'Account End Customer',
      'cOpportunityContactGoogle' => 'Oportunidade',
      'cAccountContact' => 'Empresa',
      'cAccountCountry' => 'Account Country',
      'countryList' => 'Country (Account)',
      'leadCountry' => 'Country (Lead)',
      'countryOriginalLead' => 'Country (Original Lead)',
      'salesOrdersBilling' => 'Pedido de venda (Billing)',
      'salesOrdersShipping' => 'Pedido de venda (Shipping)',
      'pais' => 'País (Empresa)'
    ],
    'links' => [
      'opportunities' => 'Oportunidades',
      'cases' => 'Atendimento',
      'targetLists' => 'Listas de Alvos',
      'campaignLogRecords' => 'Log das Campanhas',
      'campaign' => 'Campanha',
      'account' => 'Conta (Primária)',
      'accounts' => 'Contas',
      'casesPrimary' => 'Casos (Primários)',
      'tasksPrimary' => 'Tarefas (expandido)',
      'opportunitiesPrimary' => 'Oportunidades (Primárias)',
      'portalUser' => 'Usuário do Portal',
      'originalLead' => 'Lead Original',
      'documents' => 'Documentos',
      'quotesBilling' => 'Quotes (Billing)',
      'quotesShipping' => 'Quotes (Shipping)',
      'salesOrdersBilling' => 'Pedido de venda (Billing)',
      'salesOrdersShipping' => 'Pedido de venda (Shipping)',
      'invoicesBilling' => 'Invoices (Billing)',
      'invoicesShipping' => 'Invoices (Shipping)',
      'purchaseOrdersBilling' => 'Purchase Orders (Billing)',
      'purchaseOrdersShipping' => 'Purchase Orders (Shipping)',
      'deliveryOrdersShipping' => 'Delivery Orders (Shipping)',
      'returnOrdersBilling' => 'Return Orders (Billing)',
      'returnOrdersShipping' => 'Return Orders (Shipping)',
      'receiptOrdersShipping' => 'Receipt Orders (Shipping)',
      'analytics' => 'Analytics',
      'lead' => 'Lead',
      'user' => 'BDM User',
      'bdmuser' => 'BDM User',
      'partnersGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'programGoogleCloud' => 'Programa Google Cloud',
      'programGoogleClouds' => 'Programa Google Clouds',
      'cPB' => 'CPB',
      'dSET' => 'DSET',
      'quotes' => 'Cotações',
      'opportunity' => 'Oportunidade',
      'billingContactOpportunities' => 'Oportunidades (Billing Contact)',
      'accountVBM' => 'Account VBM',
      'emailContents' => 'Email Contents',
      'dataAIAssessment' => 'Data AI Assessment',
      'cMarketing' => 'Marketing',
      'cAccountEndCustomer' => 'Account End Customer',
      'cOpportunityContactGoogle' => 'Oportunidade',
      'cAccountContact' => 'Empresa'
    ],
    'labels' => [
      'Create Contact' => 'Criar Contato'
    ],
    'options' => [
      'opportunityRole' => [
        '' => '',
        'Decision Maker' => 'Tomador de Decisão',
        'Evaluator' => 'Avaliador',
        'Influencer' => 'Influenciador'
      ],
      'type' => [
        '' => '',
        'Revenda' => 'Revenda',
        'Cliente Final' => 'Cliente Final',
        'ISV' => 'ISV',
        'Renewal' => 'Renewal',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'Primary' => 'Primary Contact',
        'Finance' => 'Finance',
        'Sales' => 'Sales'
      ],
      'archivosDeIntereses' => [
        'SMB Sales Scenarios - FY22' => 'SMB Sales Scenarios - FY22',
        'Azure App Modernization PDF' => 'Azure App Modernization PDF',
        'Azure Open Source PDF' => 'Azure Open Source PDF',
        'Azure Virtual Desktop PDF' => 'Azure Virtual Desktop PDF',
        'Azure Analytics PDF' => 'Azure Analytics PDF',
        'Azure Migration PDF' => 'Azure Migration PDF',
        'Azure Fundamental Guide PDF' => 'Azure Fundamental Guide PDF',
        'SPA Security PDF' => 'SPA Security PDF',
        'Latam Partner One :: Step by Step' => 'Latam Partner One :: Step by Step'
      ],
      'source' => [
        '' => '',
        'CloudSolv' => 'CloudSolv',
        'Campaign' => 'Campaign',
        'Commercial Portfolio' => 'Commercial Portfolio',
        'Manufacturer' => 'Manufacturer',
        'Meetings' => 'Meetings'
      ]
    ],
    'presetFilters' => [
      'portalUsers' => 'Usuários do Portal',
      'notPortalUsers' => 'Não Usuários do Portal',
      'accountActive' => 'Ativo'
    ]
  ],
  'Document' => [
    'labels' => [
      'Create Document' => 'Criar Documento',
      'Details' => 'Detalhes'
    ],
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'file' => 'Arquivo',
      'type' => 'Tipo',
      'publishDate' => 'Data de Publicação',
      'expirationDate' => 'Data de expiração',
      'description' => 'Descrição',
      'accounts' => 'Contas',
      'folder' => 'Pasta',
      'services' => 'Serviços',
      'servicesVersions' => 'Versoes Serviços',
      'service' => 'Serviços',
      'importers' => 'Importers',
      'quote' => 'Cotação',
      'quotes' => 'Cotações',
      'avisoEstimativa' => 'Aviso'
    ],
    'links' => [
      'accounts' => 'Contas',
      'opportunities' => 'Oportunidades',
      'folder' => 'Pasta',
      'leads' => 'Leads',
      'contacts' => 'Contatos',
      'services' => 'Serviços',
      'servicesVersions' => 'Versoes Serviços',
      'service' => 'Serviços',
      'importers' => 'Importers',
      'quote' => 'Cotação',
      'quotes' => 'Cotações'
    ],
    'options' => [
      'status' => [
        'Active' => 'Ativo',
        'Draft' => 'Rascunho',
        'Expired' => 'Expirado',
        'Canceled' => 'Cancelado'
      ],
      'type' => [
        '' => 'Selecione',
        'Contract' => 'Contract',
        'NDA' => 'NDA',
        'EULA' => 'EULA',
        'License Agreement' => 'License Agreement',
        'Cotação' => 'Cotação Google',
        'Estimativa' => 'Estimativa',
        'Other' => 'Outro'
      ]
    ],
    'presetFilters' => [
      'active' => 'Ativo',
      'draft' => 'Rascunho'
    ],
    'tooltips' => [
      'type' => '(PT-BR) Ao selecionar o tipo "Estimativa", este documento ficará disponível para download do cliente na tela de propostas quando uma cotação for criada e atribuída a um contato de Billing. 

Qualquer cliente que tenha a "Chave de Acesso" da cotação poderá visualizar este documento.'
    ]
  ],
  'DocumentFolder' => [
    'labels' => [
      'Create DocumentFolder' => 'Criar Pasta de Documentos',
      'Manage Categories' => 'Gerenciar Pastas',
      'Documents' => 'Documentos'
    ],
    'links' => [
      'documents' => 'Documentos'
    ]
  ],
  'EmailQueueItem' => [
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'target' => 'Alvo',
      'sentAt' => 'Data enviada',
      'attemptCount' => 'Tentativas',
      'emailAddress' => 'Endereço de E-mail',
      'massEmail' => 'E-mail em Massa',
      'isTest' => 'É teste'
    ],
    'links' => [
      'target' => 'Alvo',
      'massEmail' => 'E-mail em Massa'
    ],
    'options' => [
      'status' => [
        'Pending' => 'Pendente',
        'Sent' => 'Enviado',
        'Failed' => 'Falhou',
        'Sending' => 'Enviando'
      ]
    ],
    'presetFilters' => [
      'pending' => 'Pendente',
      'sent' => 'Enviado',
      'failed' => 'Falhou'
    ]
  ],
  'KnowledgeBaseArticle' => [
    'labels' => [
      'Create KnowledgeBaseArticle' => 'Criar Tutorial',
      'Any' => 'Qualquer',
      'Send in Email' => 'Enviar por e-mail',
      'Move Up' => 'Mover para Cima',
      'Move Down' => 'Mover para Baixo',
      'Move to Top' => 'Mover para o Topo',
      'Move to Bottom' => 'Mover para o Fundo'
    ],
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'type' => 'Tipo',
      'attachments' => 'Anexos',
      'publishDate' => 'Data de publicação',
      'expirationDate' => 'Data de validade',
      'description' => 'Descrição',
      'body' => 'Corpo',
      'categories' => 'Categorias',
      'language' => 'Linguagem',
      'portals' => 'Portais'
    ],
    'links' => [
      'cases' => 'Casos',
      'opportunities' => 'Oportunidades',
      'categories' => 'Categorias',
      'portals' => 'Portais'
    ],
    'options' => [
      'status' => [
        'In Review' => 'Em Revisão',
        'Draft' => 'Rascunho',
        'Archived' => 'Arquivado',
        'Published' => 'Publicado'
      ],
      'type' => [
        'Article' => 'Artigo'
      ]
    ],
    'tooltips' => [
      'portals' => 'O artigo estará disponível apenas em portais especificados.'
    ],
    'presetFilters' => [
      'published' => 'Publicado'
    ]
  ],
  'KnowledgeBaseCategory' => [
    'labels' => [
      'Create KnowledgeBaseCategory' => 'Criar categoria',
      'Manage Categories' => 'Gerenciar categorias',
      'Articles' => 'Artigos'
    ],
    'links' => [
      'articles' => 'Artigos'
    ]
  ],
  'Lead' => [
    'labels' => [
      'Converted To' => 'Convertido Para',
      'Create Lead' => 'Criar Lead',
      'Convert' => 'Converter',
      'convert' => 'converter'
    ],
    'fields' => [
      'name' => 'Nome',
      'emailAddress' => 'E-mail',
      'title' => 'Title',
      'website' => 'Website',
      'phoneNumber' => 'Telefone',
      'accountName' => 'Conta',
      'doNotCall' => 'Não Ligar',
      'address' => 'Endereço',
      'status' => 'Status',
      'source' => 'Origem',
      'opportunityAmount' => 'Valor da Oportunidade',
      'opportunityAmountConverted' => 'Valor da Oportunidade (convertido)',
      'description' => 'Descrição',
      'createdAccount' => 'Conta',
      'createdContact' => 'Contato',
      'createdOpportunity' => 'Oportunidade',
      'convertedAt' => 'Convertido Em',
      'campaign' => 'Campanha',
      'targetLists' => 'Listas de Alvo',
      'targetList' => 'Lista Alvo',
      'industry' => 'Ramo de Atividade',
      'acceptanceStatus' => 'Status de Aceitação',
      'opportunityAmountCurrency' => 'Moeda do Valor da Oportunidade',
      'acceptanceStatusMeetings' => 'Acceptance Status (Meetings)',
      'acceptanceStatusCalls' => 'Status de Aceitação (Ligações)',
      'originalEmail' => 'Original Email',
      'parceiros' => 'Company (OLD)',
      'type' => 'Type',
      'countryList' => 'Country',
      'user' => 'BDM User',
      'contact' => 'Contact',
      'externalId' => 'ExternalId',
      'engagementId' => 'EngagementId',
      'expirationDateTime' => 'Expira em:',
      'calls1' => 'Calls',
      'industria' => 'MX Industry',
      'nurturingProfile' => 'Nurturing Profile',
      'createSurestep' => 'Convert Lead and Create Surestep',
      'surestep' => 'Surestep',
      'know' => 'Cisco Programs',
      'iDSynnex' => 'ID SYNNEX',
      'ciscoProjectWon' => 'Project Closed?',
      'ciscoPrograms' => 'Cisco Programs',
      'alreadyContacted' => 'Contacted?',
      'cnpj' => 'CNPJ',
      'brand' => 'Brands',
      'brands' => 'Brands',
      'citrix' => 'Citrix',
      'opportunities' => 'Oportunidades',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'createdAtVendor' => 'CreatedAtVendor',
      'conversionForecast' => 'Previsão de Conversão de Lead',
      'marketings' => 'Especifique a origem',
      'subStatus' => 'SubStatus',
      'qualification' => 'Qualification',
      'typePC' => 'TypePC',
      'acceptedDateTime' => 'AcceptedDateTime',
      'saleStage' => 'SaleStage',
      'campaignId' => 'CampaignId',
      'statusReason' => 'StatusReason',
      'position' => 'Cargo',
      'brandSelection' => 'Brand (Varchar)',
      'information' => 'Information',
      'isPartnerSYNNEX' => 'Parceiro SYNNEX?',
      'leadCertifications' => 'Lead possui certificações?',
      'brandPartner' => 'Lead Parceiro (Fabricante)',
      'phoneContact' => 'Contato efetuado?',
      'solution' => 'Solução',
      'sourceNew' => 'Origem'
    ],
    'links' => [
      'targetLists' => 'Lista de Alvos',
      'campaignLogRecords' => 'Logs das Campanhas',
      'campaign' => 'Campanha',
      'createdAccount' => 'Conta',
      'createdContact' => 'Contato',
      'createdOpportunity' => 'Oportunidade',
      'cases' => 'Casos',
      'documents' => 'Documentos',
      'parceiros' => 'Empresa (OLD)',
      'user' => 'BDM User',
      'contact' => 'Contact',
      'calls1' => 'Calls',
      'surestep' => 'Surestep',
      'know' => 'Cisco Programs',
      'ciscoPrograms' => 'Cisco Programs',
      'brand' => 'Brands',
      'brands' => 'Brands',
      'citrix' => 'Citrix',
      'opportunities' => 'Oportunidades',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'marketings' => 'Marketings'
    ],
    'options' => [
      'status' => [
        'New' => 'Novo',
        'Assigned' => 'Atribuído',
        'In Process' => 'Em Processo',
        'Converted' => 'Convertido',
        'Recycled' => 'Reciclado',
        'Dead' => 'Perdido',
        'Ready to contact' => 'Pronto para Contatar',
        'Approved to follow' => 'Aprovado para Follow',
        'Approved to Follow' => 'Aprovado para seguir',
        'Duplicated' => 'Duplicated',
        'Bad Data' => 'Bad Data'
      ],
      'source' => [
        'Call' => 'Ligação',
        'Email' => 'E-mail',
        'Existing Customer' => 'Cliente Existente',
        'Partner' => 'Parceiro',
        'Public Relations' => 'Relacionamento',
        'Web Site' => 'Website',
        'Campaign' => 'Campanha',
        'Other' => 'Outro',
        '' => 'None',
        'Microsoft' => 'Microsoft',
        'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)' => 'MICROSOFT | Projeto Social Selling ISV\'s (Data to Go)',
        'IBM | Projeto Social Selling (Data to Go)' => 'IBM | Projeto Social Selling (Data to Go)',
        'Microsoft MPC' => 'Microsoft MPC',
        'Social Selling Microsoft CSP' => 'Social Selling Microsoft CSP',
        'Microsoft | Captação novos canais Linkedin' => 'Microsoft | Captação novos canais Linkedin',
        'SYNNEX' => 'TD SYNNEX',
        'EDGE for Cloud' => 'EDGE for Cloud',
        'ISV Experience' => 'ISV Experience',
        'MSFTPartnerCenter' => 'MSFT Partner Center',
        'Geração de Oportunidade - F5' => 'Geração de Oportunidade - F5',
        'Campanha LGPD - 2022' => 'Campanha LGPD - 2022',
        'Microsoft Surestep Recruitment' => 'Surestep Recruitment',
        'Derivaciones Leads Microsoft Argentina - FY21' => 'Derivaciones Leads Microsoft Argentina - FY21',
        'DG Partner Acquisition Banner IT Sitio Q3FY21' => 'DG Partner Acquisition Banner IT Sitio Q3FY21',
        'Partner Acquisition ISV Q2FY22' => 'Partner Acquisition ISV Q2FY22',
        'CISCO' => 'CISCO',
        'K.NOW' => 'K.NOW',
        'Accelerate' => 'Journey Accelerate',
        'DMP' => 'DMP Cisco',
        'Levantamiento de datos de clientes finales de DATA/IA Segmento corportate' => 'Levantamiento de datos de clientes finales de DATA/IA Segmento corportate',
        'Lean Sales - Cisco' => 'Lean Sales - Cisco',
        'Telemarketing - Cisco' => 'Telemarketing - Cisco',
        'Select - Cisco' => 'Select - Cisco',
        'Cisco Radius LATAM Q1FY22 Comstor BRA' => 'Cisco Radius LATAM Q1FY22 Comstor BRA',
        'Cisco Radius LATAM Q2FY22 Comstor BRA' => 'Cisco Radius LATAM Q2FY22 Comstor BRA',
        'Cisco Radius LATAM Q3FY22 Comstor BRA' => 'Cisco Radius LATAM Q3FY22 Comstor BRA',
        'Download Content - Surestep' => 'Download Content - Surestep',
        'Submit Form - Surestep' => 'Surestep - Submit Form',
        'Surestep - Activate Campaign' => 'Surestep - Activate Campaign',
        'Surestep - Azure Development' => 'Surestep - Azure Development',
        'Surestep - Azure Recruitment' => 'Surestep - Azure Recruitment',
        'Surestep - Inspire Campaign' => 'Surestep - Inspire Campaign',
        'Surestep - Skyrocket Campaign' => 'Surestep - Skyrocket Campaign',
        'Evento - Terça nas Nuvens' => 'Evento - Terça nas Nuvens',
        'Surestep Recruitment' => 'Surestep Recruitment',
        'Cisco Radius' => 'Cisco Radius',
        'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage' => 'Cisco - Synnex Westcon Comstor - Cisco & Pure Storage',
        'Cisco - HYPE Solutions & TD Synnex' => 'Cisco - HYPE Solutions & TD Synnex',
        'Cisco - DAP: Goahead Demand Generation' => 'Cisco - DAP: Goahead Demand Generation',
        'Cisco - DAP: Think Digital Demand Generation' => 'Cisco - DAP: Think Digital Demand Generation',
        'Cisco - Social Selling ' => 'Cisco - Social Selling ',
        'Cisco - SCALE: Demand Generation Collaboration' => 'Cisco - SCALE: Demand Generation Collaboration',
        'Cisco - DAP: Cisco Unified Campaign Demand Generation' => 'Cisco - DAP: Cisco Unified Campaign Demand Generation',
        'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ' => 'Cisco - DAP: HYPE & Cisco Hyperflex Tech Experience ',
        'Cisco - DAP: Evento 12 CIOs Interatell ' => 'Cisco - DAP: Evento 12 CIOs Interatell ',
        'Cisco - DAP: Plano de ações ND&C ' => 'Cisco - DAP: Plano de ações ND&C ',
        'Cisco - DAP: Plano de Ações da NEXA ' => 'Cisco - DAP: Plano de Ações da NEXA ',
        'Cisco & Synnex Comstor - Secure Remote Work' => 'Cisco & Synnex Comstor - Secure Remote Work',
        'Cisco & Synnex Comstor - MIT SLOAN' => 'Cisco & Synnex Comstor - MIT SLOAN',
        'Cisco & Veeam Synnex - Pós Evento' => 'Cisco & Veeam Synnex - Pós Evento',
        'Cisco & Veeam & Synnex Westcon Comstor' => 'Cisco & Veeam & Synnex Westcon Comstor',
        'Cisco & Synnex Comstor - MVC' => 'Cisco & Synnex Comstor - MVC',
        'Cisco & TD Synnex - Lead Gen' => 'Cisco & TD Synnex - Lead Gen',
        'MW - Assessment de Migración' => 'MW - Assessment de Migración',
        'MW - Incentivos de venta para cierres de MS365' => 'MW - Incentivos de venta para cierres de MS365',
        'MW - Incentivo a la primera venta' => 'MW - Incentivo a la primera venta',
        'MW - XPND (Azure & MWP)' => 'MW - XPND (Azure & MWP)',
        'MW - Capacitación Herramientas colaborativas' => 'MW - Capacitación Herramientas colaborativas',
        'Azure - Pruebas de concepto' => 'Azure - Pruebas de concepto',
        'Azure - Incentivos para nuevos NACs' => 'Azure - Incentivos para nuevos NACs',
        'Azure - Webinar AZURE' => 'Azure - Webinar AZURE',
        'MW - Webinar MW' => 'MW - Webinar MW',
        'Azure - Referido Microsoft ' => 'Azure - Referido Microsoft ',
        'Azure - Partner Center' => 'Azure - Partner Center',
        'Azure - Alianza ruta N' => 'Azure - Alianza ruta N',
        'Azure - Alianza Rockstart' => 'Azure - Alianza Rockstart',
        'Azure - Evento StartCo' => 'Azure - Evento StartCo',
        'Azure - Base Edtech/Legaltech/Proptech' => 'Azure - Base Edtech/Legaltech/Proptech',
        'Azure / MW - Partner' => 'Azure / MW - Partner',
        'Microsoft AR - Agencia Novaz' => 'Microsoft AR - Agencia Novaz',
        'Microsoft AR - Agencia Marco Marketing' => 'Microsoft AR - Agencia Marco Marketing',
        'Microsoft AR - Leads Generados Mediaware (Enfasys)' => 'Microsoft AR - Leads Generados Mediaware (Enfasys)',
        'Microsoft AR - Webinars' => 'Microsoft AR - Webinars',
        'Microsoft AR - SureStep Programs' => 'Microsoft AR - SureStep Programs',
        'Microsoft AR – Prensa' => 'Microsoft AR – Prensa',
        'Microsoft AR – IT SITIO' => 'Microsoft AR – IT SITIO',
        'Microsoft AR – Corefone' => 'Microsoft AR – Corefone',
        'CO-MW-Assessment de Migración' => 'CO-MW-Assessment de Migración',
        'CO-MW-Incentivo venta para cierres MW' => 'CO-MW-Incentivo venta para cierres MW',
        'CO-MW-Incentivo ventas mensuales MW' => 'CO-MW-Incentivo ventas mensuales MW',
        'CO-MW-Incentivo primera Venta' => 'CO-MW-Incentivo primera Venta',
        'CO-MW-Capacitación Herramientas colaborativas' => 'CO-MW-Capacitación Herramientas colaborativas',
        'EC-MW-Incentivo venta para cierres MW' => 'EC-MW-Incentivo venta para cierres MW',
        'EC-MW-Incentivo ventas mensuales MW' => 'EC-MW-Incentivo ventas mensuales MW',
        'EC-MW-Incentivo primera Venta' => 'EC-MW-Incentivo primera Venta',
        'Atividades de Marketing' => 'Atividades de Marketing',
        'Microsoft – Evento CCE (FIESP)' => 'Microsoft – Evento CCE (FIESP)',
        'Microsoft CCE - Comunicação ' => 'Microsoft CCE - Comunicação ',
        'Nuvens Carregadas Opp' => 'Nuvens Carregadas Opp',
        'Microsoft AR – Spinnel' => 'Microsoft AR – Spinnel',
        'Digital Campaign 7748' => 'Digital Campaign 7748',
        'MS Paid Media - #1 StreamOne' => 'MS Paid Media - #1 StreamOne',
        'Cloud Practice Builder' => 'Cloud Practice Builder',
        'Surestep' => 'Surestep',
        'Roadshow' => 'Roadshow - Convidado não Participante',
        'Roadshow - Participante' => 'Roadshow - Participante',
        'AWS - TechShift' => 'AWS - TechShift',
        'Microsoft Copilot 12x' => 'Microsoft Copilot 12x',
        'Marketing' => 'Marketing',
        'Lead Routing - Public Sector' => 'Lead Routing - Public Sector'
      ],
      'type' => [
        '' => '',
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISV' => 'ISV',
        'Operadora/ISP' => 'Operadora/ISP',
        'Fabricante' => 'Fabricante',
        'TD SYNNEX' => 'TD SYNNEX',
        'ISV / Startup Parceira TD SYNNEX' => 'ISV / Startup Parceira TD SYNNEX',
        'ISV / Startup não Parceira TD SYNNEX' => 'ISV / Startup não Parceira TD SYNNEX',
        'Revenda de TI Parceira TD SYNNEX' => 'Revenda de TI Parceira TD SYNNEX',
        'Revenda de TI não Parceira TD SYNNEX' => 'Revenda de TI não Parceira TD SYNNEX'
      ],
      'countryList' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'Caribe' => 'Caribe',
        'CALA' => 'CALA',
        'Centro' => 'Centro',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Ecuador' => 'Ecuador',
        'Perú' => 'Perú',
        'Mexico' => 'Mexico',
        'Dominican Republic' => 'Dominican Republic',
        'Bolivia' => 'Bolivia',
        'CCA' => 'CCA',
        'Peru' => 'Peru',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay'
      ],
      'industria' => [
        'Aeroespacial' => 'Aerospace',
        'Agricultura' => 'Agriculture',
        'Agua' => 'Water',
        'Alimentación y bebidas' => 'Food and beverages',
        'Arquitectura' => 'Architecture',
        'Automotriz' => 'Automotive',
        'Banca' => 'Banking',
        'Bienes Raices' => 'Real estate',
        'Biotecnología' => 'Biotechnology',
        'Capital de Riesgo' => 'Venture Capital',
        'Comestibles' => 'Groceries',
        'Compra Total' => 'Purchasing',
        'Computación' => 'Computing',
        'Construcción' => 'Construction',
        'Consultando' => 'Consulting',
        'Creativo' => 'Creative',
        'Cuidado de la Salud' => 'Health Care',
        ' Cultura' => ' Cultura',
        'Defensa' => 'Defense',
        'Deportes' => 'Sports',
        'Educación' => 'Education',
        'Electrónicos' => 'Electronics',
        'Energía' => 'Energy',
        'Energía Eléctrica' => 'Electrical energy',
        'Entrega' => 'Delivery',
        'Entretenimiento y Ocio' => 'Entertainment and Leisure',
        ' Fabricación' => 'Manufacturing',
        ' Finanzas' => 'Finance',
        'Hospitalidad' => 'Hospitality',
        'Jurídico' => 'Legal',
        'Marketing' => 'Marketing',
        'Materiales de construcción y equipamiento' => 'Construction materials and equipment',
        'Medios masivos' => 'Mass media',
        'Menudeo' => 'Retail',
        'Minería' => 'Mining',
        ' Música' => 'Music',
        'Petróleo' => 'Petroleum',
        'Prueba, Inspección y Certificación' => 'Testing, Inspection and Certification',
        'Publicaciones' => 'Publications',
        'Publicidad' => 'Advertising',
        ' Química' => 'Chemistry',
        'Ropa y Accesorios' => 'Clothing and Accessories',
        'Seguros' => 'Insurance',
        'Servicios' => 'Services',
        'Software' => 'Software',
        'Soporte' => 'Support',
        'Tecnología' => 'Technology',
        'Telecomunicaciones' => 'Telecommunications',
        'Televisión' => 'Television',
        'Transporte' => 'Transport',
        'Viaje' => 'ViajeTransport',
        '' => ''
      ],
      'ciscoProjectWon' => [
        'Não' => 'No',
        'Sim' => 'Yes'
      ],
      'alreadyContacted' => [
        '' => '',
        'No' => 'No',
        'Si' => 'Yes',
        'En Curso' => 'In Progress'
      ],
      'conversionForecast' => [
        '' => 'Sem previsão',
        'Immediate' => 'Imediata',
        '1 Month' => '1 mês',
        '3 Months' => '3 meses',
        '6 Months' => '6 meses',
        '2 Months' => '2 meses',
        '4 Months' => '4 meses',
        '5 Months' => '5 meses'
      ],
      'subStatus' => [
        'Accepted' => 'Accepted',
        '' => ''
      ],
      'solution' => [
        '' => '',
        'O365' => 'O365',
        'Azure' => 'Azure',
        'Modern Workplace' => 'Modern Workplace',
        'Canales MSFT' => 'Canais MSFT',
        'Cisco' => 'Cisco',
        'Microsoft 365' => 'Microsoft 365',
        'Surestep' => 'Surestep',
        'Latam Partner One' => 'Latam Partner One',
        'Outro' => 'Outro',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Copilot' => 'Copilot'
      ],
      'isPartnerSYNNEX' => [
        '' => 'Sem informação',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'leadCertifications' => [
        '' => 'Sem informação',
        'Não' => 'Não',
        'Sim' => 'Sim'
      ],
      'brandPartner' => [
        'IBM' => 'IBM',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Fortinet' => 'Fortinet',
        'Microsoft' => 'Microsoft',
        'Cisco' => 'Cisco',
        'Citrix' => 'Citrix'
      ],
      'phoneContact' => [
        '' => '',
        'Yes' => 'Sim',
        'No' => 'Não'
      ],
      'sourceNew' => [
        '' => '',
        'Campanhas' => 'Campaigns',
        'Carteira Comercial' => 'Carteira Comercial',
        'Fabricante' => 'Vendor',
        'Meetings' => 'Meetings'
      ]
    ],
    'presetFilters' => [
      'active' => 'Ativo',
      'actual' => 'Atual',
      'converted' => 'Convertido'
    ],
    'tooltips' => [
      'createSurestep' => 'This button allows the user to create data in the Surestep Entity. This also converts the Lead into a Contact and creates the Account in both entities. Please, make sure that this Contact or Account does not exist before continuing.

This action can not be undone.'
    ]
  ],
  'MassEmail' => [
    'fields' => [
      'name' => 'Nome',
      'status' => 'Status',
      'storeSentEmails' => 'Armazenar emails enviados',
      'startAt' => 'Data de Início',
      'fromAddress' => 'Do Endereço',
      'fromName' => 'De Nome',
      'replyToAddress' => 'Endereço de Resposta',
      'replyToName' => 'Responder para Nome',
      'campaign' => 'Campanha',
      'emailTemplate' => 'Template de email',
      'inboundEmail' => 'Conta de Email',
      'targetLists' => 'Listas de Alvo',
      'excludingTargetLists' => 'Excluindo Listas de Alvo',
      'optOutEntirely' => 'Cancelado Completamente',
      'smtpAccount' => 'Conta SMTP'
    ],
    'links' => [
      'targetLists' => 'Listas de Alvo',
      'excludingTargetLists' => 'Excluindo Listas de Alvos',
      'queueItems' => 'Itens da Fila',
      'campaign' => 'Campanha',
      'emailTemplate' => 'Modelo de Email',
      'inboundEmail' => 'Conta de Email'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Rascunho',
        'Pending' => 'Pendente',
        'In Process' => 'Em processo',
        'Complete' => 'Completo',
        'Canceled' => 'Cancelado',
        'Failed' => 'Falhou'
      ]
    ],
    'labels' => [
      'Create MassEmail' => 'Criar email em massa',
      'Send Test' => 'Enviar Teste',
      'System SMTP' => 'SMTP do sistema',
      'system' => 'sistema',
      'group' => 'grupo'
    ],
    'messages' => [
      'selectAtLeastOneTarget' => 'Selecione pelo menos um destino.',
      'testSent' => 'Email(s) de teste que devem ser enviados'
    ],
    'tooltips' => [
      'optOutEntirely' => 'Os endereços de e-mail de destinatários que cancelaram a assinatura serão marcados como desativados e não receberão mais e-mails em massa.',
      'targetLists' => 'Destinos que devem receber mensagens.',
      'excludingTargetLists' => 'Destinos que não devem receber mensagens.',
      'storeSentEmails' => 'Os emails serão armazenados no CRM.'
    ],
    'presetFilters' => [
      'actual' => 'Real',
      'complete' => 'Completo'
    ]
  ],
  'Meeting' => [
    'fields' => [
      'name' => 'Nome',
      'parent' => 'Relação',
      'status' => 'Status',
      'dateStart' => 'Data de Início',
      'dateEnd' => 'Data Final',
      'duration' => 'Duração',
      'description' => 'Descrição',
      'users' => 'Usuários',
      'contacts' => 'Contatos',
      'leads' => 'Leads',
      'reminders' => 'Lembretes',
      'account' => 'Conta',
      'acceptanceStatus' => 'Status de Aceitação',
      'dateStartDate' => 'Data de Início (dia todo)',
      'dateEndDate' => 'Data Final (dia todo)',
      'isAllDay' => 'É o Dia Todo',
      'sourceEmail' => 'E-mail de origem',
      'uid' => 'UID',
      'joinUrl' => 'Join URL',
      'Acceptance' => 'Aceitação'
    ],
    'links' => [],
    'options' => [
      'status' => [
        'Planned' => 'Planejada',
        'Held' => 'Realizada',
        'Not Held' => 'Não Realizada'
      ],
      'acceptanceStatus' => [
        'None' => 'Nenhum',
        'Accepted' => 'Aceita',
        'Declined' => 'Rejeitada',
        'Tentative' => 'Tentativa'
      ]
    ],
    'massActions' => [
      'setHeld' => 'Marcar Realizada',
      'setNotHeld' => 'Marcar Não Realizada'
    ],
    'labels' => [
      'Create Meeting' => 'Criar Reunião',
      'Set Held' => 'Marcar como Realizada',
      'Set Not Held' => 'Marcar como não realizada',
      'Send Invitations' => 'Enviar convites',
      'Send Cancellation' => 'Send Cancellation',
      'on time' => 'na hora',
      'before' => 'antes',
      'All-Day' => 'Dia Todo',
      'Acceptance' => 'Acceptance'
    ],
    'presetFilters' => [
      'planned' => 'Planejada',
      'held' => 'Realizada',
      'todays' => 'Hoje'
    ],
    'messages' => [
      'sendInvitationsToSelectedAttendees' => 'Invitation emails will be sent to the selected attendees.',
      'sendCancellationsToSelectedAttendees' => 'Cancellation emails will be sent to the selected attendees.',
      'selectAcceptanceStatus' => 'Defina seu status de aceitação.',
      'nothingHasBeenSent' => 'Nada foi enviado'
    ]
  ],
  'Opportunity' => [
    'fields' => [
      'name' => 'Nome',
      'account' => 'Parceiro',
      'stage' => 'Estágio',
      'amount' => 'Valor',
      'probability' => 'Probabilidade, %',
      'leadSource' => 'Origem do Lead',
      'doNotCall' => 'Não ligar',
      'closeDate' => 'Data de Fechamento',
      'contacts' => 'Contatos',
      'contact' => 'Contato (Primário)',
      'description' => 'Descrição Interna (TD SYNNEX)',
      'amountConverted' => 'Valor (convertido)',
      'amountWeightedConverted' => 'Valor Quantificado',
      'campaign' => 'Campanha',
      'originalLead' => 'Lead Original',
      'amountCurrency' => 'Valor em Moeda',
      'contactRole' => 'Regra Contato',
      'lastStage' => 'Último Estágio',
      'itemList' => 'Item List',
      'priceBook' => 'Price Book',
      'licenseType' => 'Tipo de Licença',
      'partnerResponsible' => 'Partner Responsible',
      'customerType' => 'Tipo de Oportunidade',
      'productBrand' => 'Fabricante',
      'country' => 'País (Parceiro)',
      'solutionType' => 'Billing',
      'quarter' => 'Quarter',
      'endUser' => 'Customer',
      'customer' => 'End User (Link)',
      'proposalCode' => 'Número do Contrato',
      'sources' => 'Sources',
      'oppSource' => 'Origem (Marketing)',
      'citrix' => 'Citrix',
      'dollarIBM' => 'Dólar IBM',
      'dollarIBMCurrency' => 'Dólar IBM (Currency)',
      'dollarIBMConverted' => 'Dólar IBM (Converted)',
      'dollarCIS' => 'Dólar CIS',
      'dollarCISCurrency' => 'Dólar CIS (Currency)',
      'dollarCISConverted' => 'Dólar CIS (Converted)',
      'dollarAmount' => 'Total (USD)',
      'dollarAmountCurrency' => 'Total (Dólar) (Currency)',
      'dollarAmountConverted' => 'Total (Dólar) (Converted)',
      'dollarType' => 'Tipo de Dólar',
      'requests' => 'Pedidos',
      'technicalSupports' => 'Apoio Técnico',
      'technicalSupport' => 'Technical Support',
      'techSupport' => 'Necessário Apoio Técnico',
      'techSupportDescription' => 'Descrição (Apoio Técnico)',
      'endDate' => 'Data de Expiração da Licença',
      'accountEmail' => 'E-mail (Parceiro)',
      'buyDate' => 'Date of purchase',
      'lead' => 'Lead',
      'leadCountry' => 'Country (Lead)',
      'leadEmail' => 'E-mail (Lead)',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'crmID' => 'ID (CRM Cloud Analytics)',
      'externalId' => 'ExternalId',
      'region' => 'Region',
      'partnerGoogleCloud' => 'Partners Google Cloud',
      'amountDiscount' => 'Valor Total (Com Desconto)',
      'amountDiscountCurrency' => 'Valor Total (Com Desconto) (Currency)',
      'amountDiscountConverted' => 'Amount with Discount (Converted)',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'partnersGoogleCloud' => 'Programa Google Cloud',
      'partnerLevel' => 'Partner Level',
      'products' => 'Products',
      'statusSynced' => 'Status Synced',
      'customerEmail' => 'E-mail (End User)',
      'countryCustomer' => 'País (End User)',
      'progresoPartner' => 'Partner Progress',
      'googleCalculator' => 'Google calculator link',
      'cdpOpportunityID' => 'Opportunity ID (CDP)',
      'lostReason' => 'Motivo de Perda / Cancelamento',
      'realAmount' => 'Total (Real)',
      'realAmountCurrency' => 'Total (Reais) (Currency)',
      'realAmountConverted' => 'Total (Reais) (Converted)',
      'realAmountFloat' => 'Total (BRL)',
      'amountproxconsumo' => 'Approximate Amount of Annual Consumption',
      'reason' => 'Reason for Cancellation',
      'externalIDcdp' => 'ExternalIDcdp',
      'updated' => 'Sincronizar Cotação',
      'cpb' => 'CPB',
      'submissionID' => 'Submission ID',
      'marketing' => 'Especifique a origem',
      'sourceNew' => 'Origem',
      'aws' => 'AWS - Partner Program',
      'emailEndUser' => 'E-mail Customer',
      'paisDelClienteFinal' => 'Customer Country',
      'newcustomer' => 'New Customer',
      'priceBooks' => 'Price Books',
      'stageUpdateAWS' => 'Stage Update AWS',
      'connectedAreas' => 'Áreas Conectadas',
      'connectedAreasStatus' => 'Status (Áreas Conectadas)',
      'createQuote' => 'Gerar Cotação',
      'receipt' => 'Nota Fiscal',
      'commercialTerms' => 'Condições Comerciais',
      'users' => 'VBA/BDR/BDM',
      'discountValue' => 'Desconto Total',
      'discountValueCurrency' => 'Desconto Total (Currency)',
      'discountValueConverted' => 'Valor de Desconto (Converted)',
      'quoteOpp' => 'Cotação Aprovada',
      'quoteStatus' => 'Status da Cotação',
      'billingContact' => 'Contato de Billing',
      'presentQuoteEmail' => 'Enviar Cotação ao Contato (E-mail / Book)',
      'linkOppPartnerCenter' => 'LinkOppPartnerCenter',
      'quoteVersion' => 'Versão da Cotação',
      'billingContactEmail' => 'E-mail do Contato de Billing',
      'addEndUser' => 'Adicionar Cliente Final',
      'billingContactID' => 'Chave de Acesso da Cotação',
      'quoteNumber' => 'Número da Cotação',
      'avisoItens' => 'Aviso',
      'quotesOpportunity' => 'DESATIVADO QUOTE',
      'migrations' => 'Migração',
      'migrationOrigin' => 'Tipo de Migração',
      'quotePageURL' => 'Página de Cotações',
      'discountRequest' => 'Solicitar Desconto',
      'quoteApprovalDate' => 'Data de Aprovação da Cotação',
      'messengers' => 'Mensageria',
      'createQuoteList' => 'Cotação Enviada',
      'update' => 'Update',
      'opportunityAWS' => 'Opportunity AWS',
      'useCase' => 'Use Case',
      'opportunityID' => 'Opportunity ID (AWS)',
      'aWSAccountID' => 'AWS Account ID',
      'sPMSID' => 'SPMS ID',
      'stageAWS' => 'Etapa AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'segment' => 'Segment',
      'estimatedRevenue' => 'Estimated Monthly Revenue',
      'marketplace' => 'Marketplace',
      'preSalesJira' => 'Jira - Pré-vendas',
      'cOpportunityGoogle' => 'Opportunity Google',
      'cNDealRegistration' => 'N° Deal Registration (Si aplica)',
      'cCategoryGoogle' => 'Category',
      'DR' => 'Deal Registration (DR)',
      'cMassDiscount' => 'Desconto de Itens (%)',
      'cProductImported' => 'Product Imported',
      'cSkuImporter' => 'Importador de Part Number',
      'cContactOpportunityGoogle' => 'Contato (Google)',
      'cCPartnumberimport' => 'Deseja importar os produtos pelo Partnumber?',
      'cQuoteReviewDate' => 'Data de Revisão da Cotação',
      'cQuoteReview' => 'Cotação em Revisão',
      'cQuoteReminder' => 'Enviar Lembrete: Cotação Pendente de Validação',
      'cQuoteIdleTime' => 'Tempo Ocioso da Cotação',
      'salesOrders' => 'Pedido de venda',
      'baseMsft' => 'Cliente já é da base Microsoft?',
      'rebatesGoogle' => 'Rebates',
      'productoGoogle' => 'Categoria',
      'contratoATiempoGoogle' => 'Contrato A Tiempo',
      'amountProxConsumoGoogle' => 'Amount Prox Consumo',
      'amountProxConsumoGoogleCurrency' => 'Amount Prox Consumo (Currency)',
      'amountProxConsumoGoogleConverted' => 'Amount Prox Consumo (Converted)',
      'productosAConsumirGoogle' => 'Sub Producto GCP',
      'discountGoogle' => 'Discount (%)',
      'regiones' => 'Region',
      'backendgoogle' => 'Backend %',
      'nombreDelProyectoGoogle' => 'Nombre Del Proyecto',
      'subProductWorkspace' => 'Sub Producto',
      'cantidadDeLicenciasGoogle' => 'Cantidad de Licencias',
      'status' => 'Status',
      'oppCountry' => 'País',
      'quotes' => 'Cotações',
      'googleFormDescription' => 'Google Form Description',
      'charged' => 'Parceiro Cobrado?',
      'discountAmount' => 'Desconto - OLD (Não usar)',
      'discountAmountCurrency' => 'Valor Descontado (Currency)',
      'discountAmountConverted' => 'Valor Descontado (Converted)',
      'clientbudget' => 'Qual é o orçamento disponível do cliente (Budget)?',
      'customerneedGoogleSolution' => 'Qual é a necessidade/projeto do cliente que a solução do Google resolve?',
      'decisionMakingAuthority' => 'Quem é a autoridade responsável pela tomada de decisões?',
      'reviewDate' => 'Data de Revisão',
      'cDR' => 'DR',
      'collaborators' => 'Backup'
    ],
    'links' => [
      'contacts' => 'Contatos',
      'contact' => 'Contato (Primário)',
      'documents' => 'Documentos',
      'campaign' => 'Campanha',
      'originalLead' => 'Lead Original',
      'quotes' => 'Cotações',
      'salesOrders' => 'Pedido de venda',
      'invoices' => 'Invoices',
      'items' => 'Items',
      'priceBook' => 'Price Book',
      'productBrand' => 'Fabricante',
      'customer' => 'Cliente Final',
      'sources' => 'Source',
      'oppSource' => 'Origem (Marketing)',
      'citrix' => 'Citrix',
      'technicalSupports' => 'Apoio Técnico',
      'technicalSupport' => 'Technical Support',
      'lead' => 'Lead',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'regiones' => 'Region',
      'partnerGoogleCloud' => 'Partners Google Cloud',
      'partnersGoogleClouds' => 'Program Google Clouds',
      'partnersGoogleCloud' => 'Programa Google Cloud',
      'products' => 'Products',
      'progresoPartner' => 'Progress Partner',
      'cpb' => 'CPB',
      'marketing' => 'Marketings',
      'aws' => 'AWS - Partner Program',
      'priceBooks' => 'Price Books',
      'users' => 'BDM User',
      'quoteOpp' => 'Cotação Aprovada',
      'billingContact' => 'Billing Contact',
      'quotesOpportunity' => 'DESATIVADO QUOTE',
      'migrations' => 'Migração',
      'messengers' => 'Mensageria',
      'opportunityAWS' => 'Opportunity AWS',
      'cOpportunityGoogle' => 'Opportunity Google',
      'cContactOpportunityGoogle' => 'Contato (Google)',
      'cQuoteReview' => 'Cotação em Revisão',
      'account' => 'Parceiro'
    ],
    'options' => [
      'stage' => [
        'Prospecting' => 'Prospectando',
        'Qualification' => 'Qualificação',
        'Proposal' => 'Proposta',
        'Negotiation' => 'Negociação',
        'Needs Analysis' => 'Necessita de Análise',
        'Value Proposition' => 'Proposta de Valor',
        'Id. Decision Makers' => 'Identificação dos Decisores',
        'Perception Analysis' => 'Análise da Percepção',
        'Proposal/Price Quote' => 'Proposta/Cotação',
        'Negotiation/Review' => 'Negociação/Revisão',
        'Closed Won' => 'Ganho | Concluido',
        'Closed Lost' => 'Perdida',
        'Opportunity Technical Feasibility' => 'Opportunity Technical Feasibility',
        'Opportunity Commercial Qualification' => 'Opportunity Commercial Qualification',
        'Implementation' => 'Fechado | Implementação',
        'Cancelada' => 'Cancelada',
        'Migration' => 'Fechado | Migração',
        'Stand-by' => 'Stand-by',
        'In Review' => 'Em Revisão'
      ],
      'licenseType' => [
        '' => '',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'AWS' => 'AWS',
        'Azure' => 'Azure',
        'M365' => 'M365 Monthly',
        'Renewal' => 'Renewal',
        'Services' => 'Services',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'M365 Annual' => 'M365 Annual',
        'Modern Workplace' => 'Modern Workplace',
        'Azure IR' => 'Azure IR',
        'NCE' => 'NCE',
        'Open Value SA' => 'Open Value SA',
        'Open Value Subscription 1 Ano' => 'Open Value Subscription 1 Ano',
        'Open Value Subscription 3 Anos' => 'Open Value Subscription 3 Anos',
        'Open Value' => 'Open Value',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Renovações' => 'Renovações',
        'SPLA' => 'SPLA',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1 Ano',
        'SW Subscription 3 Anos' => 'SW Subscription 3 Anos',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Pay As You Go' => 'Pay As You Go',
        'New Business' => 'New Business',
        'Upgrade' => 'Upgrade',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'Commit - GCP' => 'Commit - GCP',
        'Commit - WS' => 'Commit - WS',
        'Google Workspace Starter' => 'Google Workspace Starter',
        'Google Workspace Business (1-300 Seats)' => 'Google Workspace Business (1-300 Seats)',
        'Google Workspace Essentials' => 'Google Workspace Essentials',
        'Google Workspace Standard' => 'Google Workspace Standard',
        'Google Workspace Plus' => 'Google Workspace Plus',
        'Google Workspace AppSheet' => 'Google Workspace AppSheet',
        'Cloud Identity' => 'Cloud Identity',
        'Google Vault' => 'Google Vault',
        'Google Voice' => 'Google Voice',
        'Google Workspace Business' => 'Google Workspace Business',
        'Google Workspace Enterprise' => 'Google Workspace Enterprise'
      ],
      'customerType' => [
        'Enterprise' => 'Enterprise',
        'ISV' => 'ISV',
        'SMB' => 'SMB',
        '' => '',
        'Public' => 'Public',
        'Corporate' => 'Corporativo',
        'Government' => 'Governo',
        'Public Sector' => 'Setor Público'
      ],
      'solutionType' => [
        '' => '',
        'Modern Workplace (Annual)' => 'Modern Workplace (Annual)',
        'Modern Workplace (Monthly)' => 'Modern Workplace (Monthly)',
        'Software (Perpetual)' => 'Software (Perpetual)',
        'Software (Subscription)' => 'Software (Subscription)',
        'Modern Workplace (3 Years)' => 'Modern Workplace (3 Years)',
        'Reserved Instances (1 Year)' => 'Reserved Instances (1 Year)',
        'Reserved Instances (3 Years)' => 'Reserved Instances (3 Years)',
        'Monthly' => 'Mensal',
        'Annual' => 'Anual - 1 ano',
        '3 Years' => '3 anos',
        'Perpetual' => 'One Time (Perpétuo)',
        'Annual - 3 Years' => 'Anual - 3 anos',
        'One Time' => 'One Time',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Value Subscription 1 Year' => 'Open Value Subscription 1 Year',
        'Open Value Subscription 3 Years' => 'Open Value Subscription 3 Years',
        'SW Perpétuo' => 'SW Perpétuo',
        'SW Subscription 1 ano' => 'SW Subscription 1 ano',
        '2 Years' => '2 anos',
        'Annual - Monthly Payment' => 'Anual - Pagamento Mensal',
        'Flexible' => 'Flexível',
        'Trial' => 'Trial',
        'Pay as you go' => 'Pay as you go',
        'Upfront' => 'Upfront'
      ],
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'dollarType' => [
        '' => '',
        'Dólar CIS' => 'Dólar CIS',
        'Dólar IBM' => 'Dólar IBM'
      ],
      'requests' => [
        '' => '',
        'VBM Enterprise' => 'VBM Enterprise',
        'Cloud' => 'Cloud',
        'On Premise' => 'On Premise'
      ],
      'lostReason' => [
        '' => '',
        'Otro proveedor' => 'Otro proveedor',
        'Otro partner de Google' => 'Otro partner de Google',
        'Tiempo de vigencia de propuestaPrecio' => 'Tiempo de vigencia de propuestaPrecio',
        'Más adelante' => 'Más adelante',
        'Licitación perdida' => 'Licitación perdida',
        'Concorrente Tier 1' => 'Concorrente Tier 1',
        'Concorrente MOSP' => 'Concorrente MOSP',
        'Concorrente (Outro Distribuidor)' => 'Concorrente (Outro Distribuidor)',
        'Concorrente EA' => 'Concorrente EA',
        'Concorrente (Outro Fabricante)' => 'Concorrente (Outro Fabricante)',
        'WO' => 'WO',
        'Cadastro Reprovado' => 'Cadastro Reprovado',
        'Crédito Reprovado' => 'Crédito Reprovado',
        'Concorrente MPSA' => 'Concorrente MPSA',
        'Concorrente ESD' => 'Concorrente ESD',
        'Prazo de Pagamento' => 'Prazo de Pagamento',
        'Cliente final desistiu da compra' => 'Cliente final desistiu da compra',
        'Opp Duplicada' => 'Oportunidade Duplicada',
        'Fechado com outro Revendedor' => 'Fechado com outro Revendedor',
        'Sem retorno do Revendedor / Cliente final' => 'Sem retorno do Revendedor / Cliente final',
        'Contrato não efetivado (Stellr)' => 'Contrato não efetivado (Stellr)',
        'Cancelada por falta de atualização interna' => 'Cancelada por falta de atualização interna'
      ],
      'reason' => [
        'O cliente não tinha um orçamento' => 'The client does not have an ornament',
        'Cliente/oportunidade muito pequena' => 'Very small client/opportunity',
        'O cliente não respondeu' => 'The client did not respond',
        'O cliente escolheu outro fornecedor' => 'The client chooses another supplier',
        'Minha solução ou serviços não é um ajuste' => 'My solution or services is not an adjustment',
        'Não é cliente' => 'I\'m not a client',
        'Linha de tempo proposta muito curta' => 'Line of time proposed very short',
        'Relatar como abuso, phishing' => 'Report as abuse, phishing',
        'Outro' => 'Other'
      ],
      'sourceNew' => [
        '' => '',
        'Campanhas' => 'Campaigns',
        'Meetings' => 'Meetings',
        'Carteira do BDM' => 'Carteira do BDM',
        'Fabricante' => 'Vendor',
        'Carteira Comercial ' => 'Carteira Comercial'
      ],
      'newcustomer' => [
        'New customer' => 'New Customer'
      ],
      'connectedAreas' => [
        'COE' => 'COE',
        'Pre Sales' => 'Pré Vendas',
        'Services' => 'Serviços',
        'Movimentação' => 'Movimentação',
        'N/A' => 'N/A'
      ],
      'connectedAreasStatus' => [
        '' => '',
        'Envolvido' => 'Envolvido',
        'Pendente' => 'Pendente',
        'Respondido' => 'Respondido',
        'Aguardando Retorno' => 'Aguardando Retorno',
        'BDM' => 'BDM',
        'Movimentação' => 'Movimentação',
        'N/A' => 'N/A'
      ],
      'quoteStatus' => [
        'Draft' => 'Rascunho',
        'In Review' => 'Em Revisão',
        'Approved' => 'Aprovada',
        'Canceled' => 'Cancelada',
        'Apresentada' => 'Apresentada',
        'Presented' => 'Apresentada',
        'Reviewed' => 'Revisada',
        'Criar Versão (DESENVOLVIMENTO)' => 'Criar Versão (DESENVOLVIMENTO)',
        '' => ''
      ],
      'migrationOrigin' => [
        '' => 'Selecione',
        'CSC | SSCloud' => 'CSC | SSCloud',
        'Stellr' => 'Stellr',
        'Organization' => 'Organization',
        'SSCloud (Jira)' => 'SSCloud (Jira)',
        'T1/DIST' => 'T1/DIST',
        'MOSP/EA' => 'MOSP/EA',
        'Azure' => 'Migração Azure'
      ],
      'createQuoteList' => [
        'Cotação Enviada' => 'Cotação Enviada',
        'Cotação não Enviada' => 'Cotação não Enviada'
      ],
      'baseMsft' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'rebatesGoogle' => [
        'No' => 'No',
        'Si' => 'Si'
      ],
      'productoGoogle' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ],
      'contratoATiempoGoogle' => [
        '' => '',
        'Plan Flexible' => 'Plan Flexible',
        'Plan a 12 meses de contrato' => 'Plan a 12 meses de contrato',
        'Plan a 24 meses de contrato' => 'Plan a 24 meses de contrato',
        'Plan a 36 meses de contrato' => 'Plan a 36 meses de contrato',
        'Versión de prueba' => 'Versión de prueba'
      ],
      'productosAConsumirGoogle' => [
        '' => '',
        'Cloud Storage' => 'Cloud Storage',
        'VM' => 'VM',
        'GCP' => 'GCP',
        'Recaptcha' => 'Recaptcha',
        'Looker Platform Standard' => 'Looker Platform Standard',
        'Looker Platform Advanced' => 'Looker Platform Advanced',
        'Looker Platform Elite' => 'Looker Platform Elite',
        'Looker Platform Standard (Powered by Looker)' => 'Looker Platform Standard (Powered by Looker)',
        'Looker Platform Advanced (Powered by Looker)' => 'Looker Platform Advanced (Powered by Looker)',
        'Looker Platform Elite (Powered by Looker)' => 'Looker Platform Elite (Powered by Looker)',
        'Looker Viewer User' => 'Looker Viewer User',
        'Looker Standard User' => 'Looker Standard User',
        'Looker Developer User' => 'Looker Developer User',
        'Looker Viewer User (Powered by Looker)' => 'Looker Viewer User (Powered by Looker)',
        'Looker Standard User (Powered by Looker)' => 'Looker Standard User (Powered by Looker)',
        'Looker Client License (Powered by Looker)' => 'Looker Client License (Powered by Looker)',
        'Looker Add-On Instance' => 'Looker Add-On Instance',
        'Looker Add-On White Label' => 'Looker Add-On White Label',
        'BeyondCorp Enterprise Essentials (per user per month)' => 'BeyondCorp Enterprise Essentials (per user per month)',
        'reCAPTCHA Enterprise' => 'reCAPTCHA Enterprise',
        'Cloud Security Command Center Premium' => 'Cloud Security Command Center Premium',
        'Preemptible Compute' => 'Preemptible Compute',
        'Business Application Platform : Apigee' => 'Business Application Platform : Apigee',
        'Compute Solutions' => 'Compute Solutions',
        'Committed Compute' => 'Committed Compute',
        'Data Analytics' => 'Data Analytics',
        'Databases' => 'Databases',
        'Support' => 'Support',
        'Operations Tools' => 'Operations Tools',
        'On-Demand Compute' => 'On-Demand Compute',
        'Web Risk FMF' => 'Web Risk FMF',
        'BeyondCorp Enterprise' => 'BeyondCorp Enterprise',
        'Elite System Activity' => 'Elite System Activity'
      ],
      'subProductWorkspace' => [
        '' => '',
        'Frontline' => 'Frontline',
        'Google Workspace Business Starter' => 'Google Workspace Business Starter',
        'Google Workspace Business Standard' => 'Google Workspace Business Standard',
        'Google Workspace Business Plus' => 'Google Workspace Business Plus',
        'Google Workspace Enterprise Starter' => 'Google Workspace Enterprise Starter',
        'Google Workspace Enterprise Stadard' => 'Google Workspace Enterprise Stadard',
        'Google Workspace Enterprise Plus' => 'Google Workspace Enterprise Plus',
        'Google Workspace AppSheet Core' => 'Google Workspace AppSheet Core',
        'Google Workspace AppSheet Enterprise Standard' => 'Google Workspace AppSheet Enterprise Standard',
        'Google Workspace AppSheet Enterprise Plus' => 'Google Workspace AppSheet Enterprise Plus',
        'Google Workspace for Education' => 'Google Workspace for Education'
      ],
      'status' => [
        '' => '',
        'New' => 'New'
      ],
      'oppCountry' => [
        '' => '',
        'Brasil' => 'Brasil',
        'Peru' => 'Peru',
        'Colombia' => 'Colombia',
        'Ecuador' => 'Ecuador',
        'Bolivia' => 'Bolivia',
        'Argentina' => 'Argentina',
        'CCA' => 'CCA',
        'Chile' => 'Chile',
        'Uruguay' => 'Uruguay'
      ],
      'stageAWS' => [
        '' => '',
        'Technical Validation' => 'Technical Validation',
        'Committed' => 'Committed',
        'Qualified' => 'Qualified',
        'Prospect' => 'Prospect',
        'Business Validation' => 'Business Validation',
        'Closed Lost' => 'Closed Lost',
        'Launched' => 'Launched',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'labels' => [
      'Create Opportunity' => 'Criar Oportunidade',
      'Items' => 'Items',
      'Select Product' => 'Select Product',
      'Add Item' => 'Add Item',
      'Add Products' => 'Add Products'
    ],
    'presetFilters' => [
      'open' => 'Aberta',
      'won' => 'Ganha',
      'lost' => 'Perdida'
    ],
    'panels' => [
      'items' => 'Items'
    ],
    'tooltips' => [
      'createQuote' => 'Ao selecionar este campo, uma cotação será criada e relacionada a esta oportunidade.',
      'discountValue' => '(PT- BR) 
O valor inserido deve ser zero ou negativo. 
Se este valor não for atualizado após o salvamento da oportunidade, por favor, recarregue a página (Pressione F5).

(Español) 
El valor ingresado debe ser cero o negativo.
Si este valor no se actualiza después de guardar la oportunidad, por favor, recargue la página (Presione F5).',
      'presentQuoteEmail' => 'Ao selecionar esta opção, as cotações ficarão disponíveis para o cliente na página de cotações e poderão ser acessadas por qualquer usuário que tenha uma "Chave de Acesso".',
      'billingContactID' => 'A Chave de Acesso da Cotação só ficará disponível quando a oportunidade for salva com um "Contato de Billing".',
      'updated' => 'Caso a sua cotação não esteja atualizada com os valores da oportunidade, utilize este campo para sincronizar os dois registros.

Ao utilizar a função de "Sincronizar Cotação", uma nova versão da cotação será criada.',
      'cMassDiscount' => 'O desconto inserido será aplicado a todos os produtos da oportunidade e poderá ser ajustado individualmente após a finalização da importação.
Insira um número apenas, sem "%".',
      'cSkuImporter' => 'Insira os Part Numbers desejados para adicionar os produtos à oportunidade.

Os Part Numbers devem seguir o formato da planilha de cotações: um item por linha, separado pelo \'Enter\'.

Exemplo:
MST-CFQ7TTC0HL8Z-0004-1M-BR
MST-CFQ7TTC0HL8Z-0005-1Y1M-BR
MST-CFQ7TTC0HL8Z-0005-1Y-BR',
      'proposalCode' => 'Insira apenas números ou o número do contrato registrado no CIS/Stellr.
Evite letras, espaços ou caracteres especiais.',
      'cCPartnumberimport' => 'Caso não deseje fazer uma importação em massa pelos Part Numbers, adicione os produtos manualmente clicando no botão "+".',
      'cQuoteReminder' => 'Realiza o envio de um e-mail de lembrete para o parceiro quando a cotação já foi apresentada, mas ainda não recebeu nenhuma interação.',
      'customerType' => '**Setor Público**
Governo | Saúde Pública | Educação | Organizações sem fins lucrativos (ONGs).

**Governo**
Ministérios | Secretarias estaduais e municipais | Prefeituras e governos estaduais | Empresas Estatais e Autarquias | Forças Armadas e Segurança Pública | Universidades federais e estaduais (como USP, UFRJ, UNICAMP) | Institutos federais (IFs) | Hospitais Públicos e SUS.

**ISV**
ISV significa Independent Software Vendor (ou Fornecedor Independente de Software, em português). Esses são parceiros que desenvolvem, comercializam e vendem suas próprias soluções de software.

**Enterprise**
Grandes empresas, contratos personalizados.

**SMB**
Pequenas e médias empresas, soluções padronizadas (significa Small and Medium Business.',
      'discountGoogle' => '(PT - BR) O desconto será aplicado após o salvamento da oportunidade.

(Español) El descuento se aplicará una vez guardada la oportunidad.',
      'discountAmount' => 'Este campo será preenchido quando houver desconto aplicado dentro dos "Itens", selecionando os produtos e atribuindo um valor de desconto.',
      'amount' => '(PT-BR) Este é o valor total, sem desconto aplicado.

(Español) Este es el valor total, sin descuento aplicado.',
      'collaborators' => 'O usuário de backup é definido dentro da Conta. Para alterar o usuário de backup, substitua a conta no campo "Parceiro" ou faça o ajuste necessário dentro da conta.'
    ]
  ],
  'TargetList' => [
    'fields' => [
      'name' => 'Nome',
      'description' => 'Descrição',
      'entryCount' => 'Contagem de entrada',
      'optedOutCount' => 'Quant. Desistentes',
      'campaigns' => 'Campanhas',
      'endDate' => 'Data final',
      'targetLists' => 'Lista de alvos',
      'includingActionList' => 'Incluindo',
      'excludingActionList' => 'Excluindo',
      'targetStatus' => 'Statos do Alvo',
      'isOptedOut' => 'É Cancelado',
      'sourceCampaign' => 'Source Campaign',
      'syncWithReports' => 'Reports',
      'syncWithReportsEnabled' => 'Enabled',
      'syncWithReportsUnlink' => 'Unlink'
    ],
    'links' => [
      'accounts' => 'Contas',
      'contacts' => 'Contatos',
      'leads' => 'Leads',
      'campaigns' => 'Campanhas',
      'massEmails' => 'Emails em Massa',
      'syncWithReports' => 'Sync with Reports'
    ],
    'options' => [
      'type' => [
        'Email' => 'E-mail',
        'Web' => 'Web',
        'Television' => 'Televisão',
        'Radio' => 'Rádio',
        'Newsletter' => 'Newsletter'
      ],
      'targetStatus' => [
        'Opted Out' => 'Cancelado',
        'Listed' => 'Listado'
      ]
    ],
    'labels' => [
      'Create TargetList' => 'Criar Lista de Alvos',
      'Opted Out' => 'Cancelado',
      'Cancel Opt-Out' => 'Cancelar Cancelamento',
      'Opt-Out' => 'Cancelar',
      'Sync with Reports' => 'Sync with Reports'
    ],
    'tooltips' => [
      'syncWithReportsEnabled' => 'Enable auto-sync with a list report.',
      'syncWithReportsUnlink' => 'Entries which are not contained in report results will be unlinked from Target List.',
      'syncWithReports' => 'Target List will be synced with results of selected reports.'
    ]
  ],
  'Task' => [
    'fields' => [
      'name' => 'Nome',
      'parent' => 'Relação',
      'status' => 'Status',
      'dateStart' => 'Data de Início',
      'dateEnd' => 'Até a Data',
      'dateStartDate' => 'Data de Início (dia todo)',
      'dateEndDate' => 'Data Final (dia todo)',
      'priority' => 'Prioridade',
      'description' => 'Descrição',
      'isOverdue' => 'Atrasada',
      'account' => 'Conta',
      'dateCompleted' => 'Date Completed',
      'attachments' => 'Anexos',
      'reminders' => 'Lembretes',
      'contact' => 'Contato',
      'originalEmail' => 'Original Email',
      'emailUser' => 'Email User',
      'tarea' => 'Task',
      'productBrands' => 'Fabricante',
      'country' => 'Country',
      'region' => 'Region',
      'fabricante' => 'Product Brand',
      'productBrand' => 'Product Brand',
      'tag' => 'Tag',
      'countryTask' => 'País',
      'cCreateProjectTask' => 'CreateProjectTask',
      'cCompletionTime' => 'Tempo de Conclusão (Dias)',
      'cCisCode' => 'CIS Code',
      'assignedUser' => 'Atribuído ao Usuário'
    ],
    'links' => [
      'attachments' => 'Anexos',
      'account' => 'Conta',
      'contact' => 'Contato',
      'email' => 'Email',
      'productBrands' => 'Fabricante',
      'fabricante' => 'Fabricante',
      'productBrand' => 'Product Brand'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Não Iniciada',
        'Started' => 'Iniciada',
        'Completed' => 'Completa',
        'Canceled' => 'Cancelada',
        'Deferred' => 'Adiada',
        'Recibida' => 'Recebida',
        'Em curso' => 'Em curso'
      ],
      'priority' => [
        'Low' => 'Baixa',
        'Normal' => 'Normal',
        'High' => 'Alta',
        'Urgent' => 'Urgente'
      ],
      'tarea' => [
        1 => '1',
        '' => ''
      ],
      'tag' => [
        '' => '',
        'Ready for test' => 'Ready for Test',
        'Ready for deploy' => 'Ready for deploy',
        'Stand-by' => 'Stand-by',
        'Blocked' => 'Blocked',
        'In Approval' => 'In Approval',
        'Recurrent' => 'Recorrente'
      ],
      'countryTask' => [
        '' => '',
        'Brasil' => 'Brasil',
        'MCA' => 'MCA'
      ]
    ],
    'labels' => [
      'Create Task' => 'Criar Tarefa',
      'Complete' => 'Concluída',
      'overdue' => 'atrasado'
    ],
    'presetFilters' => [
      'actual' => 'Atual',
      'completed' => 'Completa',
      'deferred' => 'Adiada',
      'todays' => 'Hoje',
      'overdue' => 'Atrasada'
    ],
    'nameOptions' => [
      'replyToEmail' => 'Responder ao e-mail'
    ]
  ],
  'BpmnFlowNode' => [
    'labels' => [
      'Reset' => 'Reset'
    ],
    'fields' => [
      'status' => 'Status',
      'processedAt' => 'Processed At',
      'elementType' => 'Element Type',
      'element' => 'Element'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Pending' => 'Pending',
        'In Process' => 'In Process',
        'Standby' => 'Standby',
        'Processed' => 'Processed',
        'Rejected' => 'Rejected',
        'Failed' => 'Failed',
        'Interrupted' => 'Interrupted'
      ]
    ]
  ],
  'BpmnFlowchart' => [
    'labels' => [
      'Create BpmnFlowchart' => 'Create Flowchart',
      'Hand tool' => 'Hand tool',
      'Create Event tool' => 'Create Event tool',
      'Create Gateway tool' => 'Create Event tool',
      'Create Activity tool' => 'Create Activity tool',
      'Connect tool' => 'Connect tool',
      'Erase tool' => 'Erase tool',
      'Full Screen' => 'Full Screen',
      'Processes' => 'Processes',
      'data' => 'Data',
      'Zoom In' => 'Zoom In',
      'Zoom Out' => 'Zoom Out',
      'Error' => 'Error',
      'Events' => 'Events',
      'Activities' => 'Activities',
      'Gateways' => 'Gateways'
    ],
    'fields' => [
      'isActive' => 'Is Active',
      'targetType' => 'Target Entity Type',
      'data' => 'Data',
      'hasNoneStartEvent' => 'Has Start Event of None type'
    ],
    'links' => [
      'processes' => 'Processes'
    ],
    'elements' => [
      'eventStartConditional' => 'Conditional Start Event',
      'eventStartTimer' => 'Timer Start Event',
      'eventStartError' => 'Error Start Event',
      'eventStartEscalation' => 'Escalation Start Event',
      'eventStartSignal' => 'Signal Start Event',
      'eventStart' => 'Start Event',
      'eventStartCompensation' => 'Compensation Start Event',
      'eventStartConditionalEventSubProcess' => 'Sub-Process Conditional Start Event',
      'eventStartTimerEventSubProcess' => 'Sub-Process Timer Start Event',
      'eventStartSignalEventSubProcess' => 'Sub-Process Signal Start Event',
      'eventIntermediateTimerCatch' => 'Timer Intermediate Event (Catching)',
      'eventIntermediateConditionalCatch' => 'Conditional Intermediate Event (Catching)',
      'eventIntermediateEscalationThrow' => 'Escalation Intermediate Event (Throwing)',
      'eventIntermediateSignalThrow' => 'Signal Intermediate Event (Throwing)',
      'eventIntermediateCompensationThrow' => 'Compensation Intermediate Event (Throwing)',
      'eventIntermediateSignalCatch' => 'Signal Intermediate Event (Catching)',
      'eventIntermediateMessageCatch' => 'Message Intermediate Event (Catching)',
      'eventEnd' => 'End Event',
      'eventEndTerminate' => 'Terminate End Event',
      'eventEndError' => 'Error End Event',
      'eventEndEscalation' => 'Escalation End Event',
      'eventEndSignal' => 'Signal End Event',
      'eventEndCompensation' => 'Compensation End Event',
      'eventIntermediateErrorBoundary' => 'Error Intermediate Event (Boundary)',
      'eventIntermediateTimerBoundary' => 'Timer Intermediate Event (Boundary)',
      'eventIntermediateConditionalBoundary' => 'Conditional Intermediate Event (Boundary)',
      'eventIntermediateEscalationBoundary' => 'Escalation Intermediate Event (Boundary)',
      'eventIntermediateSignalBoundary' => 'Signal Intermediate Event (Boundary)',
      'eventIntermediateMessageBoundary' => 'Message Intermediate Event (Boundary)',
      'eventIntermediateCompensationBoundary' => 'Compensation Intermediate Event (Boundary)',
      'gatewayExclusive' => 'Exclusive Gateway',
      'gatewayInclusive' => 'Inclusive Gateway',
      'gatewayParallel' => 'Parallel Gateway',
      'gatewayEventBased' => 'Event Based Gateway',
      'taskSendMessage' => 'Send Message Task',
      'taskScript' => 'Script Task',
      'taskBusinessRule' => 'Business Rule Task',
      'taskUser' => 'User Task',
      'task' => 'Task',
      'callActivity' => 'Call Activity',
      'subProcess' => 'Sub-Process',
      'eventSubProcess' => 'Event Sub-Process',
      'flow' => 'Sequence Flow'
    ],
    'presetFilters' => [
      'isManuallyStartable' => 'Manually Startable',
      'activeHasNoneStartEvent' => 'Active w/ None Start Event',
      'active' => 'Active'
    ]
  ],
  'BpmnFlowchartElement' => [
    'fields' => [
      'text' => 'Text',
      'triggerType' => 'Trigger Type',
      'timer' => 'Timer Parameters',
      'defaultFlowId' => 'Default Flow',
      'from' => 'From',
      'to' => 'To',
      'replyTo' => 'Reply-To',
      'cc' => 'CC',
      'fromEmailAddress' => 'From Email Address',
      'toEmailAddress' => 'To Email Address',
      'replyToEmailAddress' => 'Reply-To Email Address',
      'ccEmailAddress' => 'CC Email Address',
      'toSpecifiedTeams' => 'To Teams',
      'toSpecifiedUsers' => 'To Users',
      'toSpecifiedContacts' => 'To Contacts',
      'attachmentsVariable' => 'Attachments Variable',
      'emailTemplate' => 'Email Template',
      'doNotStore' => 'Do not store sent email',
      'actions' => 'Actions',
      'formula' => 'Formula (script)',
      'actionType' => 'Action Type',
      'targetUser' => 'Target User',
      'assignmentType' => 'Assignment',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'startDirection' => 'Start Direction',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'messageType' => 'Message Type',
      'canBeFailed' => 'Can be Failed',
      'target' => 'Target',
      'callableType' => 'Callable Type',
      'errorCode' => 'Error Code',
      'escalationCode' => 'Escalation Code',
      'cancelActivity' => 'Is Interrupting',
      'isInterrupting' => 'Is Interrupting',
      'targetType' => 'Target Entity Type',
      'flowchartVisualization' => 'Flowchart',
      'flowchart' => 'Flowchart',
      'signal' => 'Signal',
      'returnVariableList' => 'Return Variables',
      'returnCollectionVariable' => 'Return Collection Variable',
      'repliedTo' => 'Reply To',
      'relatedTo' => 'Related To',
      'instructions' => 'Instructions',
      'conditionsFormula' => 'Conditions Formula',
      'optOutLink' => 'Opt-Out Link',
      'isMultiInstance' => 'Multi-Instance',
      'isSequential' => 'Sequential',
      'loopCollectionExpression' => 'Collection Expression',
      'targetIdExpression' => 'Target ID Expression',
      'activityId' => 'Activity ID'
    ],
    'labels' => [
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'Field' => 'Field',
      'Flows Conditions' => 'Flows Conditions'
    ],
    'tooltips' => [
      'compensateActivityId' => 'An ID of an activity to compensate. If omitted, all completed compensable activities will be compensated.',
      'targetIdExpression' => 'The expression defining an ID of the target record.',
      'returnCollectionVariable' => 'Specify a variable name for data that will be returned from the multi-instance sub-process. The variable will contain an array of objects. Each object will contain return-variables of each sub-process instance.',
      'loopCollectionExpression' => 'The expression defining a list of values. Each value will instantiate a separate sub-process. The value will be available in the variable `$inputItem`.',
      'taskSendMessageEmailAddress' => 'Available placeholders:

* `{$$variable}`',
      'targetReport' => 'Records from the list report will be passed to the new process.',
      'target' => 'Select which record will be used as a target.',
      'userTaskName' => 'A name of User Task record that will be created.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'userTaskInstructions' => 'Instructions for a user. Markdown is supported.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'returnVariableList' => 'Specify formula variables that will be copied from the sub-process to the parent process once the sub-process successfully ends.',
      'scheduling' => 'Crontab notation. Defines frequency.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.'
    ],
    'options' => [
      'emailAddress' => [
        'system' => 'System',
        'currentUser' => 'Current User',
        'specifiedEmailAddress' => 'Specified Email Address',
        'assignedUser' => 'Assigned User',
        'followers' => 'Followers',
        'specifiedContacts' => 'Specified Contacts',
        'specifiedUsers' => 'Specified Users',
        'specifiedTeams' => 'Specified Teams',
        'followersExcludingAssignedUser' => 'Followers excluding Assigned User',
        'processAssignedUser' => 'User assigned to Process',
        'targetEntity' => 'Target Record',
        '' => 'None'
      ],
      'triggerType' => [
        'afterRecordCreated' => 'After record created',
        'afterRecordSaved' => 'After record saved',
        'afterRecordUpdated' => 'After record updated',
        'sequential' => 'Sequential'
      ],
      'timerShiftOperator' => [
        'plus' => 'plus',
        'minus' => 'minus'
      ],
      'timerShiftUnits' => [
        'minutes' => 'minutes',
        'hours' => 'hours',
        'days' => 'days',
        'months' => 'months',
        'seconds' => 'seconds'
      ],
      'timerBase' => [
        'moment' => 'Moment when event triggered',
        'formula' => 'Calculated by formula'
      ],
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review'
      ],
      'assignmentType' => [
        '' => 'None',
        'processAssignedUser' => 'User assigned to Process',
        'specifiedUser' => 'Specified User',
        'rule:Round-Robin' => 'Round-Robin',
        'rule:Least-Busy' => 'Least-Busy'
      ],
      'startDirection' => [
        '' => 'Auto',
        'r' => 'Right',
        'd' => 'Down',
        'u' => 'Up',
        'l' => 'Left'
      ],
      'messageType' => [
        'Email' => 'Email'
      ]
    ]
  ],
  'BpmnProcess' => [
    'labels' => [
      'Create BpmnProcess' => 'Start Process',
      'Stop Process' => 'Stop Process',
      'User Tasks' => 'User Tasks',
      'Flowcharts' => 'Flowcharts',
      'Interrupt' => 'Interrupt',
      'Reject' => 'Reject',
      'Start flow from here' => 'Start flow from here',
      'Reactivate' => 'Reactivate',
      'View Variables' => 'View Variables',
      'View Error' => 'View Error',
      'Error Message' => 'Error Message'
    ],
    'fields' => [
      'status' => 'Status',
      'targetType' => 'Target Entity Type',
      'target' => 'Target',
      'createdEntitiesData' => 'Created Entities Data',
      'flowchartData' => 'Flowchart Data',
      'flowchart' => 'Flowchart',
      'flowchartVisualization' => 'Flowchart (visualization)',
      'flowchartElementsDataHash' => 'Flowchart Elements',
      'variables' => 'Variables',
      'endedAt' => 'Ended At',
      'startElementId' => 'Start Element',
      'workflowId' => 'Workflow ID',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'links' => [
      'flowchart' => 'Flowchart',
      'target' => 'Target',
      'flowNodes' => 'Flow Log',
      'userTasks' => 'Process User Tasks',
      'childProcesses' => 'Child Processes',
      'parentProcess' => 'Parent Process',
      'parentProcessFlowNode' => 'Parent Process Flow Node',
      'rootProcess' => 'Root Process'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Started' => 'Started',
        'Ended' => 'Ended',
        'Paused' => 'Paused',
        'Stopped' => 'Stopped',
        'Interrupted' => 'Interrupted'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Active',
      'ended' => 'Ended'
    ]
  ],
  'BpmnUserTask' => [
    'labels' => [
      'Resolve' => 'Resolve'
    ],
    'fields' => [
      'actionType' => 'Action Type',
      'resolution' => 'Resolution',
      'target' => 'Target',
      'process' => 'Process',
      'isResolved' => 'Is Resolved',
      'resolutionNote' => 'Resolution Note',
      'instructions' => 'Instructions',
      'isCanceled' => 'Is Canceled'
    ],
    'links' => [
      'process' => 'Process',
      'target' => 'Target',
      'flowNode' => 'Flow Node'
    ],
    'options' => [
      'actionType' => [
        'Approve' => 'Approve',
        'Review' => 'Review',
        'Accomplish' => 'Accomplish'
      ],
      'resolution' => [
        '' => 'None',
        'Approved' => 'Approved',
        'Rejected' => 'Rejected',
        'Reviewed' => 'Reviewed',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'resolved' => 'Resolved',
      'canceled' => 'Canceled'
    ]
  ],
  'Report' => [
    'labels' => [
      'Create Report' => 'Create Report',
      'Run' => 'Executar',
      'Total' => 'Total',
      'Group Total' => 'Group Total',
      '-Empty-' => 'Vazio',
      'Parameters' => 'Parâmetros',
      'Filters' => 'Filters',
      'Chart' => 'Chart',
      'List Report' => 'List Report',
      'Grid Report' => 'Grid Report',
      'days' => 'days',
      'never' => 'never',
      'Get Csv' => 'Get Csv',
      'EmailSending' => 'Email Sending',
      'View Report' => 'Ver Relatório',
      'Report' => 'Relatório',
      'AND' => 'AND',
      'OR' => 'OR',
      'NOT' => 'NOT IN',
      'IN' => 'IN',
      'Complex expression' => 'Complex expression',
      'Having' => 'Having',
      'Add AND group' => 'Add AND group',
      'Add OR group' => 'Add OR group',
      'Add NOT group' => 'Add NOT group',
      'Add IN group' => 'Add IN group',
      'Add Having group' => 'Add Having group',
      'Add Complex expression' => 'Add Complex expression',
      'Columns' => 'Columns',
      'Send Email' => 'Enviar E-mail',
      'Results View' => 'Results View',
      'Create Joint Grid Report' => 'Create Joint Grid Report',
      'Label' => 'Label',
      'Type' => 'Tipo',
      'Decimal Places' => 'Decimal Places'
    ],
    'fields' => [
      'type' => 'Type',
      'entityType' => 'Entity Type',
      'description' => 'Description',
      'groupBy' => 'Group by',
      'columns' => 'Columns',
      'orderBy' => 'Order by',
      'filters' => 'Filters',
      'runtimeFilters' => 'Runtime Filters',
      'chartType' => 'Chart Type',
      'emailSendingInterval' => 'Interval',
      'emailSendingTime' => 'Time',
      'emailSendingUsers' => 'Users',
      'emailSendingSettingDay' => 'Day',
      'emailSendingSettingMonth' => 'Month',
      'emailSendingSettingWeekdays' => 'Days',
      'emailSendingDoNotSendEmptyReport' => 'Don\'t send if report is empty',
      'chartColorList' => 'Colors',
      'chartColor' => 'Color',
      'chartOneColumns' => 'Chart Columns',
      'chartOneY2Columns' => 'Chart Secondary Axis Columns',
      'orderByList' => 'List Order',
      'column' => 'Column',
      'exportFormat' => 'Format',
      'category' => 'Category',
      'applyAcl' => 'Apply ACL',
      'portals' => 'Portals',
      'joinedReports' => 'Sub-Reports',
      'joinedReportLabel' => 'Sub-Report Label',
      'filtersDataList' => 'Filters Data List',
      'columnsData' => 'Columns Data',
      'filtersData' => 'Filters Data',
      'accounts' => 'Accounts'
    ],
    'tooltips' => [
      'emailSendingUsers' => 'Users report result will be sent to',
      'chartColorList' => 'Custom colors for specific groups.',
      'applyAcl' => 'Report results will depend on the user\'s access.',
      'groupBy' => 'Data will be aggregated by one or two groups. If empty, then data will not be aggregated, only totals will be displayed.

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'columns' => 'What data to display. 

[Complex expressions](https://www.espocrm.com/documentation/user-guide/complex-expressions/) can be used.',
      'runtimeFilters' => 'Additional filters that will be available on the report view.',
      'portals' => 'Report will be available only in specified portals.'
    ],
    'functions' => [
      'COUNT' => 'Quantidade',
      'SUM' => 'Sum',
      'AVG' => 'Avg',
      'MIN' => 'Min',
      'MAX' => 'Max',
      'YEAR' => 'Year',
      'QUARTER' => 'Quarter',
      'MONTH' => 'Month',
      'DAY' => 'Day',
      'WEEK' => 'Week',
      'YEAR_FISCAL' => 'Fiscal Year',
      'QUARTER_FISCAL' => 'Fiscal Quarter'
    ],
    'orders' => [
      'ASC' => 'ASC',
      'DESC' => 'DESC',
      'LIST' => 'LIST'
    ],
    'options' => [
      'dashletDisplayType' => [
        '' => '',
        'Chart' => 'Chart',
        'List' => 'List',
        'Chart-Total' => 'Chart & Total',
        'Total' => 'Total',
        'Table' => 'Table'
      ],
      'chartType' => [
        'BarHorizontal' => 'Bar (horizontal)',
        'BarVertical' => 'Bar (vertical)',
        'BarGroupedHorizontal' => 'Bar Grouped (horizontal)',
        'BarGroupedVertical' => 'Bar Grouped (vertical)',
        'Pie' => 'Pie',
        'Line' => 'Line',
        'Radar' => 'Radar'
      ],
      'emailSendingInterval' => [
        '' => 'None',
        'Daily' => 'Daily',
        'Weekly' => 'Weekly',
        'Monthly' => 'Monthly',
        'Yearly' => 'Yearly'
      ],
      'emailSendingSettingDay' => [
        32 => 'Last day of month'
      ],
      'type' => [
        'Grid' => 'Grid',
        'List' => 'List',
        'JointGrid' => 'Joint Grid'
      ],
      'function' => [
        '' => 'No Function',
        'custom' => 'Expression',
        'customWithOperator' => 'Expression w/ Operator',
        'DATE_NUMBER' => 'DATE',
        'MONTH_NUMBER' => 'MONTH',
        'YEAR_NUMBER' => 'YEAR',
        'QUARTER_NUMBER' => 'QUARTER',
        'DAYOFWEEK_NUMBER' => 'DAYOFWEEK',
        'HOUR_NUMBER' => 'HOUR',
        'MINUTE_NUMBER' => 'MINUTE',
        'LOWER' => 'LOWER',
        'UPPER' => 'UPPER',
        'TRIM' => 'TRIM',
        'LENGTH' => 'LENGTH',
        'WEEK_NUMBER_0' => 'WEEK (Sunday)',
        'WEEK_NUMBER_1' => 'WEEK (Monday)',
        'COUNT' => 'COUNT',
        'SUM' => 'SUM',
        'AVG' => 'AVG',
        'MAX' => 'MAX',
        'MIN' => 'MIN'
      ],
      'operator' => [
        'equals' => 'Equals',
        'notEquals' => 'Not Equals',
        'greaterThan' => 'Greater Than',
        'lessThan' => 'Less Than',
        'greaterThanOrEquals' => 'Greater Than or Equals',
        'lessThanOrEquals' => 'Less Than or Equals',
        'in' => 'In',
        'notIn' => 'Not In',
        'isTrue' => 'Is True',
        'isFalse' => 'Is False',
        'isNull' => 'Is Null',
        'isNotNull' => 'Is Not Null',
        'like' => 'Like'
      ],
      'exportFormat' => [
        'csv' => 'CSV',
        'xlsx' => 'XLSX (Excel)'
      ],
      'layoutAlign' => [
        'left' => 'Left',
        'right' => 'Right'
      ],
      'columnType' => [
        '' => 'Auto',
        'Summary' => 'Summary'
      ]
    ],
    'messages' => [
      'emailTemplateParsingError' => 'Error while parsing template `{template}`.',
      'executionError' => 'Could not run the report. Check the report parameters. Find more details in the log file.',
      'emptyStringGroupExcluded' => 'A group with an empty string value is excluded from the results.',
      'notAllowedFormulaInFilter' => 'Formula expression in filters contains a not allowed function.',
      'validateMaxCount' => 'Count should not be greater than {maxCount}',
      'havingFilterWithoutGroupByError' => 'Having filter can\'t be used without Group-By.',
      'gridReportDescription' => 'Group by one or two columns and see summations. Can be displayed as a chart.',
      'listReportDescription' => 'Simple list of records which meet filters criteria.',
      'invalidColumnError' => 'Invalid column name. Check the report parameters.',
      'sqlSyntaxError' => 'Could not compose a valid SQL from report parameters.',
      'onlyFullGroupByError' => 'Unsupported report parameters. Either change parameters or disable `ONLY_FULL_GROUP_BY` SQL mode in the database config.'
    ],
    'presetFilters' => [
      'list' => 'List',
      'grid' => 'Grid',
      'listTargets' => 'List (Targets)',
      'listAccounts' => 'List (Accounts)',
      'listContacts' => 'List (Contacts)',
      'listLeads' => 'List (Leads)',
      'listUsers' => 'List (Users)'
    ],
    'errorMessages' => [
      'error' => 'Error',
      'noChart' => 'No chart selected for the report.',
      'selectReport' => 'Select a report in the dashlet options.'
    ],
    'filtersGroupTypes' => [
      'or' => 'OR',
      'and' => 'AND',
      'not' => 'NOT IN',
      'subQueryIn' => 'IN',
      'having' => 'Having'
    ],
    'layoutFields' => [
      'link' => 'Link',
      'width' => 'Width',
      'notSortable' => 'Not Sortable',
      'exportOnly' => 'Exportar Somente',
      'align' => 'Alinhar'
    ],
    'links' => [
      'accounts' => 'Accounts'
    ]
  ],
  'ReportCategory' => [
    'labels' => [
      'Create ReportCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Reports' => 'Reports'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'reports' => 'Reports'
    ]
  ],
  'ReportFilter' => [
    'labels' => [
      'Create ReportFilter' => 'Create Filter',
      'Rebuild Filters' => 'Rebuild Filters'
    ],
    'fields' => [
      'order' => 'Order',
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the filter will be available for. If no teams specified then no restriction by team will be applied.',
      'report' => 'List Report that will be used for the filter.'
    ]
  ],
  'ReportPanel' => [
    'labels' => [
      'Create ReportPanel' => 'Create Panel',
      'Rebuild Panels' => 'Rebuild Panels'
    ],
    'fields' => [
      'report' => 'Report',
      'entityType' => 'Entity Type',
      'isActive' => 'Is Enabled',
      'type' => 'Type',
      'reportType' => 'Report Type',
      'displayTotal' => 'Display Total',
      'displayOnlyTotal' => 'Display Only Total',
      'column' => 'Column',
      'reportEntityType' => 'Report Entity Type',
      'columnList' => 'Column List',
      'dynamicLogicVisible' => 'Conditions making panel visible',
      'order' => 'Order',
      'displayType' => 'What to display',
      'useSiMultiplier' => 'SI Multiplier'
    ],
    'links' => [
      'report' => 'Report'
    ],
    'tooltips' => [
      'teams' => 'Teams the panel will be displayed for. If no teams specified then no restriction by team will be applied.',
      'report' => 'Report that will be used for the panel.',
      'order' => '[0..1] - before Stream panel;
[3..4] - before relationship panels;
[6..] - after relationship panels.'
    ],
    'options' => [
      'type' => [
        'side' => 'Side',
        'bottom' => 'Bottom'
      ]
    ]
  ],
  'Workflow' => [
    'fields' => [
      'Name' => 'Name',
      'entityType' => 'Target Entity',
      'type' => 'Trigger Type',
      'isActive' => 'Active',
      'description' => 'Description',
      'usersToMakeToFollow' => 'Users to make to follow the record',
      'whatToFollow' => 'What to follow',
      'portalOnly' => 'Portal Only',
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'scheduling' => 'Scheduling',
      'schedulingApplyTimezone' => 'Apply timezone',
      'methodName' => 'Service Method',
      'assignmentRule' => 'Assignment Rule',
      'targetTeam' => 'Target Team',
      'targetUserPosition' => 'Target User Position',
      'listReport' => 'List Report',
      'linkList' => 'Link with Target Entity through relationships',
      'linkListShort' => 'Links',
      'target' => 'Target',
      'whoFollow' => 'Who make to follow',
      'signalName' => 'Signal',
      'requestType' => 'Request Type',
      'requestUrl' => 'URL',
      'requestContentType' => 'Content Type',
      'requestContent' => 'Payload',
      'requestContentVariable' => 'Payload from variable',
      'optOutLink' => 'Opt-Out Link',
      'headers' => 'Headers',
      'manualLabel' => 'Manual Label',
      'manualDynamicLogic' => 'Manual Dynamic-Logic',
      'manualTeams' => 'Manual Teams',
      'manualAccessRequired' => 'Manual Access Required',
      'manualElementType' => 'Manual Element Type',
      'manualElementTypeInForm' => 'Element Type',
      'manualLabelInForm' => 'Label',
      'manualAccessRequiredInForm' => 'Access Required',
      'manualTeamsInForm' => 'For Teams',
      'manualDynamicLogicInForm' => 'Conditions',
      'manualConfirmation' => 'Manual Confirmation',
      'manualConfirmationInForm' => 'Confirmation Dialog',
      'manualConfirmationText' => 'Manual Confirmation Text',
      'manualConfirmationTextInForm' => 'Confirmation Text',
      'manualStyle' => 'Manual Button Style',
      'manualStyleInForm' => 'Button Style',
      'category' => 'Category',
      'conditionsAll' => 'Conditions All',
      'conditionsAny' => 'Conditions Any',
      'conditionsFormula' => 'Conditions Formula',
      'actions' => 'Actions',
      'processOrder' => 'Process Order',
      'attachmentsVariable' => 'Attachments Variable'
    ],
    'links' => [
      'portal' => 'Portal',
      'targetReport' => 'Target Report',
      'workflowLogRecords' => 'Log',
      'category' => 'Category'
    ],
    'tooltips' => [
      'processOrder' => 'Multiple workflow rules for the same target will be processed according their order. The lower the order value, the sooner a rule runs.',
      'manualConfirmation' => 'To display a confirmation dialog before running the workflow.',
      'manualConfirmationText' => 'A text to show to a user when confirming workflow start.',
      'schedulingApplyTimezone' => 'Apply the system default timezone to scheduling. Otherwise, UTC will be used.',
      'manualDynamicLogic' => 'Conditions making the workflow available for a record.',
      'manualTeams' => 'Teams who will have access to run the workflow. If empty, only admin will have access.',
      'manualAccessRequired' => 'Access to a record required to be able run the workflow.',
      'manualLabel' => 'A UI element label text.',
      'requestUrl' => 'Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestHeaders' => 'Additional headers.

Format:
```key: value```

Available placeholders:
* `{$attribute}`
* `{$$variable}`
* `{#secrets.name}`',
      'requestContent' => 'In JSON format.

Available placeholders:
* `{$attribute}`
* `{$$variable}`',
      'requestContentVariable' => 'A variable name. If specified, payload will be taken from the variable.',
      'portalOnly' => 'If checked workflow will be triggered only in portal.',
      'portal' => 'Specific portal where workflow will be triggered. Leave empty if you need it to work in any portal.',
      'scheduling' => 'Crontab notation. Defines frequency of workflow rule runs.

`*/5 * * * *` – every 5 minutes

`0 */2 * * *` – every 2 hours

`30 1 * * *` – at 01:30 once a day

`0 0 1 * *` – on the first day of the month'
    ],
    'labels' => [
      'Create Workflow' => 'Create Rule',
      'General' => 'General',
      'Manual Trigger' => 'Manual Trigger',
      'Conditions' => 'Conditions',
      'Actions' => 'Actions',
      'All' => 'All',
      'Any' => 'Any',
      'Formula' => 'Formula',
      'Email Address' => 'Email Address',
      'Email Template' => 'Email Template',
      'From' => 'From',
      'To' => 'To',
      'immediately' => 'Immediately',
      'Reply-To' => 'Reply-To',
      'CC' => 'CC',
      'later' => 'Later',
      'today' => 'today',
      'plus' => 'plus',
      'minus' => 'minus',
      'days' => 'days',
      'hours' => 'hours',
      'months' => 'months',
      'minutes' => 'minutes',
      'Link' => 'Link',
      'Add Field' => 'Add Field',
      'equals' => 'equals',
      'wasEqual' => 'was equal',
      'notEquals' => 'not equals',
      'wasNotEqual' => 'was not equal',
      'changed' => 'changed',
      'notChanged' => 'not changed',
      'notEmpty' => 'not empty',
      'isEmpty' => 'empty',
      'value' => 'value',
      'field' => 'field',
      'true' => 'true',
      'false' => 'false',
      'greaterThan' => 'greater than',
      'lessThan' => 'less than',
      'greaterThanOrEquals' => 'greater than or equals',
      'lessThanOrEquals' => 'less than or equals',
      'between' => 'between',
      'on' => 'on',
      'before' => 'before',
      'after' => 'after',
      'beforeToday' => 'before today',
      'afterToday' => 'after today',
      'recipient' => 'Recipient',
      'has' => 'has',
      'notHas' => 'not has',
      'contains' => 'contains',
      'notContains' => 'not contains',
      'messageTemplate' => 'Message Template',
      'users' => 'Users',
      'Target Entity' => 'Target Entity',
      'Current' => 'Current',
      'Workflow' => 'Workflow',
      'Workflows Log' => 'Workflows Log',
      'methodName' => 'Service Method',
      'additionalParameters' => 'Additional Parameters (JSON format)',
      'doNotStore' => 'Do not store sent email',
      'Related' => 'Related',
      'Entity Type' => 'Entity Type',
      'Workflow Rule' => 'Workflow Rule',
      'Add Condition' => 'Add Condition',
      'Add Action' => 'Add Action',
      'Created' => 'Created',
      'Field' => 'Field',
      'Entity' => 'Entity',
      'Process' => 'Process'
    ],
    'emailAddressOptions' => [
      '' => 'None',
      'currentUser' => 'Current user',
      'specifiedEmailAddress' => 'Specified email address',
      'assignedUser' => 'Assigned user',
      'targetEntity' => 'Target record',
      'specifiedUsers' => 'Specified users',
      'specifiedContacts' => 'Specified contacts',
      'teamUsers' => 'Users of teams related to target record',
      'followers' => 'Followers of target record',
      'followersExcludingAssignedUser' => 'Followers excluding assigned user',
      'specifiedTeams' => 'Users of specified teams',
      'system' => 'System',
      'fromOrReplyTo' => 'From/Reply-To address'
    ],
    'options' => [
      'type' => [
        'afterRecordSaved' => 'After record saved (created or updated)',
        'afterRecordCreated' => 'After record created',
        'afterRecordUpdated' => 'After record updated',
        'manual' => 'Manual',
        'scheduled' => 'Scheduled',
        'sequential' => 'Sequential',
        'signal' => 'Signal'
      ],
      'subjectType' => [
        'value' => 'value',
        'field' => 'field',
        'today' => 'today/now',
        'typeOf' => 'type of'
      ],
      'assignmentRule' => [
        'Round-Robin' => 'Round-Robin',
        'Least-Busy' => 'Least-Busy'
      ],
      'manualAccessRequired' => [
        'read' => 'read',
        'edit' => 'edit',
        'admin' => 'admin'
      ],
      'manualElementType' => [
        'Button' => 'Button',
        'Dropdown-Item' => 'Dropdown Item'
      ]
    ],
    'actionTypes' => [
      'sendEmail' => 'Send Email',
      'createEntity' => 'Create Record',
      'createRelatedEntity' => 'Create Related Record',
      'updateEntity' => 'Update Target Record',
      'updateRelatedEntity' => 'Update Related Record',
      'relateWithEntity' => 'Link with Another Record',
      'unrelateFromEntity' => 'Unlink from Another Record',
      'makeFollowed' => 'Make Followed',
      'createNotification' => 'Create Notification',
      'triggerWorkflow' => 'Trigger Another Workflow Rule',
      'runService' => 'Run Service Action',
      'applyAssignmentRule' => 'Apply Assignment Rule',
      'updateCreatedEntity' => 'Update Created Record',
      'updateProcessEntity' => 'Update Process Record',
      'startBpmnProcess' => 'Start BPM Process',
      'sendRequest' => 'Send HTTP Request',
      'executeFormula' => 'Execute Formula Script'
    ],
    'texts' => [
      'allMustBeMet' => 'All must be met',
      'atLeastOneMustBeMet' => 'At least one must be met',
      'formulaInfo' => 'Conditions of any complexity in espo-formula language'
    ],
    'messages' => [
      'jsonInvalid' => 'Is not valid JSON.',
      'loopNotice' => 'Be careful about a possible looping through two or more workflow rules continuously.',
      'messageTemplateHelpText' => 'Available placeholders:

* `{entity}` – target record
* `{user}` – current user
* `{$$variable}` – formula variable'
    ],
    'serviceActions' => [
      'sendEventInvitations' => 'Send Invitations',
      'addQuoteItemList' => 'Add Quote Items',
      'addInvoiceItemList' => 'Add Invoice Items',
      'addSalesOrderItemList' => 'Add Sales Order Items',
      'convertCurrency' => 'Convert Currency',
      'sendInEmail' => 'Send In Email',
      'optOut' => 'Opt-out',
      'generateAndSendPassword' => 'Generate Password'
    ],
    'serviceActionsHelp' => [
      'generateAndSendPassword' => 'A new password will be generated and sent to the user\'s email address.',
      'optOut' => 'Optional parameter: targetListId. If not specified, then marks an email address opted-out.

 Example:
```{"targetListId": "TARGET_LIST_ID"}```',
      'convertCurrency' => 'Optional parameter: targetCurrency. If not specified, then it will convert to the default currency.',
      'sendInEmail' => 'Parameters:
* templateId - ID of PDF template
* emailTemplateId - ID of email template
* to - recipient (optional parameter); by default will be sent to billing contact or account; example: `link:account.assignedUser`

Example:

```{
    "templateId": "TEMPLATE_ID",
    "emailTemplateId": "EMAIL_TEMPLATE_ID",
    "to": "link:billingContact"
}```',
      'addQuoteItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addInvoiceItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```',
      'addSalesOrderItemList' => 'Example: 

```{
  "itemList": [
     {
      "quantity": 1, "procuctId": "productId", "name": "Product Name", "listPrice": 100, "unitPrice": 100
     }
  ]
}```'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'WorkflowCategory' => [
    'labels' => [
      'Create WorkflowCategory' => 'Create Category'
    ],
    'fields' => [
      'order' => 'Order'
    ],
    'links' => [
      'workflows' => 'Workflows'
    ]
  ],
  'WorkflowLogRecord' => [
    'labels' => [],
    'fields' => [
      'target' => 'Target',
      'workflow' => 'Workflow'
    ]
  ],
  'DeliveryOrder' => [
    'labels' => [
      'Create DeliveryOrder' => 'Create Delivery Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'shippingAddress' => 'Shipping Address',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'salesOrder' => 'Sales Order',
      'account' => 'Account',
      'tax' => 'Tax',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'notAvailableInventory' => 'Not enough inventory is available.',
      'notAvailableInventoryStatusChanged' => 'Not enough inventory is available. Cannot change the status.'
    ],
    'texts' => [
      'itemTooMany' => '{number} extra needs to be removed.',
      'itemTooFew' => '{number} more needs to be added.'
    ]
  ],
  'DeliveryOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'deliveryOrder' => 'Delivery Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'deliveryOrderStatus' => 'Delivery Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'deliveryOrder' => 'Delivery Order',
      'product' => 'Product',
      'account' => 'Account',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'InventoryAdjustment' => [
    'labels' => [
      'Create InventoryAdjustment' => 'Create Adjustment',
      'Add Item' => 'Add Item',
      'Items' => 'Items'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'amount' => 'Amount',
      'itemList' => 'Item List',
      'date' => 'Date',
      'reason' => 'Reason',
      'warehouse' => 'Warehouse',
      'isDone' => 'Is Done',
      'doneAt' => 'Done At'
    ],
    'links' => [
      'items' => 'Items',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ],
      'reason' => [
        'Stocktaking' => 'Stocktaking',
        'Write-off' => 'Write-off',
        'Waste' => 'Waste',
        'Shrinkage' => 'Shrinkage',
        'Damage' => 'Damage',
        'Internal' => 'Internal'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'itemProductIsNotInventory' => 'Product {name} is not inventory.',
      'emptyNewQuantityInItem' => 'On-hand quantity is not specified for an item.',
      'sameItemsInAnotherAdjustment' => 'The same items are in another started adjustment.',
      'duplicateItems' => 'Can\'t have the same items in an adjustment.'
    ]
  ],
  'InventoryAdjustmentItem' => [
    'fields' => [
      'name' => 'Name',
      'newQtyOnHand' => 'On-Hand Qty',
      'qty' => 'Adjusted',
      'newQuantityOnHand' => 'New On-Hand Quantity ',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'inventoryAdjustment' => 'Adjustment',
      'description' => 'Description',
      'inventoryAdjustmentStatus' => 'Inventory Adjustment Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'warehouse' => 'Warehouse'
    ],
    'links' => [
      'inventoryAdjustment' => 'Adjustment',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ],
    'presetFilters' => [
      'completed' => 'Completed'
    ]
  ],
  'InventoryNumber' => [
    'labels' => [
      'Create InventoryNumber' => 'Create Number',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Inventory History' => 'Inventory History',
      'View History' => 'View History',
      'Received' => 'Received',
      'Shipped' => 'Shipped'
    ],
    'fields' => [
      'type' => 'Type',
      'product' => 'Product',
      'quantityOnHand' => 'On Hand',
      'quantityReserved' => 'Reserved',
      'quantityInTransit' => 'In Transit',
      'incomingDate' => 'Incoming Date',
      'productionDate' => 'Production Date',
      'expirationDate' => 'Expiration Date',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'deleteId' => 'Delete ID',
      'number' => 'Internal Number',
      'orderFifo' => 'Order FIFO',
      'orderFefo' => 'Order FEFO',
      'orderLifo' => 'Order LIFO',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse'
    ],
    'links' => [
      'product' => 'Product',
      'inventoryTransactions' => 'Inventory Transactions'
    ],
    'presetFilters' => [
      'onHand' => 'On Hand',
      'notOnHand' => 'Not On Hand'
    ],
    'messages' => [
      'alreadyExists' => 'The same inventory number already exists.'
    ]
  ],
  'InventoryTransaction' => [
    'labels' => [
      'Create InventoryTransaction' => 'Create Transaction'
    ],
    'fields' => [
      'number' => 'Number',
      'type' => 'Type',
      'parent' => 'Parent',
      'quantity' => 'Quantity',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'links' => [
      'parent' => 'Parent',
      'product' => 'Product',
      'warehouse' => 'Warehouse',
      'inventoryNumber' => 'Inventory Number'
    ],
    'options' => [
      'type' => [
        'Transfer' => 'Transfer',
        'Reserve' => 'Reserve',
        'Soft Reserve' => 'Soft Reserve'
      ]
    ]
  ],
  'Invoice' => [
    'labels' => [
      'Create Invoice' => 'Create Invoice',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Invoice Items' => 'Invoice Items',
      'E-Invoice' => 'E-Invoice',
      'Validate' => 'Validate'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'opportunity' => 'Opportunity',
      'quote' => 'Quote',
      'salesOrder' => 'Pedido de venda',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateInvoiced' => 'Date Invoiced',
      'dateDue' => 'Due Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'buyerReference' => 'Buyer Reference'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Opportunity',
      'account' => 'Account',
      'tax' => 'Tax',
      'quote' => 'Quote',
      'salesOrder' => 'Pedido de venda',
      'priceBook' => 'Price Book'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Sent' => 'Sent',
        'In Review' => 'In Review',
        'Confirmed' => 'Confirmed',
        'Paid' => 'Paid',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled'
      ],
      'eInvoiceFormats' => [
        'CiusRo' => 'CIUS-RO e-Factura',
        'CiusIt' => 'CIUS-IT',
        'CiusAtGov' => 'CIUS-AT-GOV',
        'CiusAtNat' => 'CIUS-AT-NAT',
        'Peppol' => 'PEPPOL BIS Billing 3.0',
        'CiusEsFace' => 'CIUS-ES-FACE',
        'Nlcius' => 'NLCIUS',
        'XRechnung' => 'XRechnung'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'paid' => 'Paid'
    ],
    'messages' => [
      'invoiceIsValid' => 'Invoice is valid',
      'ublRuleValidationFailure' => 'Invalid invoice.

Failed rule ID: `{ruleId}`

{message}'
    ],
    'eInvoiceFields' => [
      'eInvoiceFormat' => 'E-Invoice Format',
      'format' => 'Format'
    ]
  ],
  'InvoiceItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'invoice' => 'Invoice',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'invoiceStatus' => 'Invoice Status'
    ],
    'links' => [
      'invoice' => 'Invoice',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Invoices' => 'Invoices'
    ]
  ],
  'OpportunityItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qtd',
      'quantity' => 'Qtd',
      'quantityInt' => 'Quantity (Int)',
      'unitPrice' => 'Preço Unitário',
      'amount' => 'Valor',
      'amountCurrency' => 'Amount (Currency)',
      'unitPriceCurrency' => 'Unit Price (Currency)',
      'product' => 'Product/ SKU',
      'order' => 'Line Number',
      'opportunity' => 'Opportunity',
      'description' => 'Description',
      'discount' => 'Desc %',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPrice' => 'List Price',
      'listPriceConverted' => 'List Price (Converted)',
      'listPriceCurrency' => 'List Price (Currency)',
      'opportunityStage' => 'Stage',
      'licenseType' => 'Licença',
      'services' => 'Oportunidade de Serviço',
      'brand' => 'Brand',
      'timeContract' => 'Período',
      'productBrand' => 'Product Brand',
      'amountDiscountItem' => 'Valor c/ Desconto',
      'amountDiscountItemCurrency' => 'Unit Discounted (Currency)',
      'amountDiscountItemConverted' => 'Unit Discounted (Converted)',
      'contractType' => 'Contrato',
      'region' => 'Region',
      'priceBooks' => 'Price Books',
      'update' => 'Reprocessar',
      'editAmount' => 'Editar Valor',
      'margin' => 'Margin',
      'productSKU' => 'SKU',
      'cSolutionType' => 'Facturación',
      'cItem1' => 'Item1',
      'solutionType' => 'Billing',
      'cAdditionalDiscount' => 'Desc Add (%)',
      'googleCategory' => 'Google Category'
    ],
    'links' => [
      'opportunity' => 'Opportunity',
      'product' => 'Product',
      'services' => 'Oportunidade de Serviço',
      'productBrand' => 'Product Brand',
      'priceBooks' => 'Price Books'
    ],
    'labels' => [
      'Opportunities' => 'Opportunities'
    ],
    'options' => [
      'licenseType' => [
        '' => '',
        'Azure' => 'Azure',
        'Microsoft 365 - Montlhy' => 'Microsoft 365 - Montlhy',
        'Microsoft 365 - Annual' => 'Microsoft 365 - Annual',
        'Dynamics 365' => 'Dynamics 365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'CSP' => 'CSP',
        'AWS' => 'AWS',
        'NCE' => 'NCE',
        'Azure IR' => 'Azure IR',
        'Open' => 'Open',
        'Open Value Perpetual' => 'Open Value Perpetual',
        'Open Valeu SA' => 'Open Value SA',
        'Open Valeu Subscription 1 Ano' => 'Open Value Subscription 1 Ano',
        'Open Valeu Subscription 3 Anos' => 'Open Value Subscription 3 Anos',
        'SW Perpetual' => 'SW Perpetual',
        'SW Subscription 1 Ano' => 'SW Subscription 1 Ano',
        'SW Subscription 3 Anos' => 'SW Subscription 3 Anos',
        'ESA' => 'ESA',
        'Marketplace' => 'Marketplace',
        'Subscription' => 'Subscription',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade',
        'M365' => 'M365',
        'Services' => 'Services',
        'Open Value ' => 'Open Value ',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'School' => 'School',
        'O365/M365' => 'O365/M365',
        'Transfer' => 'Transfer',
        'Open Value' => 'Open Value'
      ],
      'brand' => [
        'Google' => 'Google',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        '' => ''
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Mês',
        '1 Year' => '1 Ano',
        '2 Years' => '2 Anos',
        '3 Years' => '3 Anos',
        'Perpetual' => 'Perpétuo',
        'Pay as you go' => 'Pay as you go',
        '1 month' => '1 Mes'
      ],
      'contractType' => [
        '' => '',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'Services Pofesionals' => 'Services Pofesionals',
        'CSP' => 'CSP',
        'Professional Services' => 'Professional Services',
        'NCE' => 'NCE',
        'CSP NCE' => 'CSP NCE',
        'Open Value' => 'Open Value',
        'Google Workspace' => 'Google Workspace',
        'Google' => 'Google'
      ],
      'region' => [
        '' => '',
        'BRA' => 'BRA',
        'MCA' => 'MCA'
      ],
      'cSolutionType' => [
        '' => '',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual',
        'Flexible' => 'Flexible',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'One time' => 'One time'
      ],
      'solutionType' => [
        '' => '',
        'Flexible' => 'Flexível',
        'Pay as you go' => 'Pay as you go',
        'Trial version' => 'Trial version',
        'onetime' => 'One Time',
        'annually' => 'Anual',
        'monthly' => 'Mensal',
        'Monthly' => 'Monthly',
        'Annual' => 'Annual',
        '3 Years' => '3 Anos',
        'Perpetual' => 'Perpétuo',
        'Trial' => 'Trial',
        '2 Years' => '2 Anos',
        'Quote ' => 'Quote ',
        'Annual - Monthly Payment' => 'Anual - Pagamento Mensal',
        '1 Month' => '1 Mês',
        '1 Year' => '1 Ano',
        'Trial Version' => 'Trial',
        'Up front' => 'Up front'
      ]
    ]
  ],
  'PriceBook' => [
    'labels' => [
      'Create PriceBook' => 'Criar PriceBook'
    ],
    'fields' => [
      'parentPriceBook' => 'Parent Price Book',
      'status' => 'Status',
      'country' => 'Country',
      'opportunity' => 'Opportunity',
      'opportunityItem' => 'Opportunity Item',
      'product' => 'Product',
      'unitPrice' => 'UnitPrice',
      'unitPriceCurrency' => 'UnitPrice (Currency)',
      'unitPriceConverted' => 'UnitPrice (Converted)',
      'countryLabel' => 'CountryLabel',
      'productUnitPrice' => 'ProductUnitPrice',
      'productUnitPriceCurrency' => 'ProductUnitPrice (Moeda)',
      'productUnitPriceConverted' => 'ProductUnitPrice (Convertido)'
    ],
    'links' => [
      'products' => 'Products',
      'parentPriceBook' => 'Parent Price Book',
      'accounts' => 'Accounts',
      'prices' => 'Prices',
      'rules' => 'Rules',
      'childPriceBooks' => 'Child Price Books',
      'country' => 'Country',
      'opportunity' => 'Opportunity',
      'opportunityItem' => 'Opportunity Item',
      'product' => 'Product'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'PriceRule' => [
    'labels' => [
      'Create PriceRule' => 'Create Rule'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'productCategory' => 'Product Category',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'percentage' => 'Percentage',
      'discount' => 'Discount',
      'target' => 'Target',
      'condition' => 'Condition',
      'conditionSelect' => 'Condition Select',
      'roundingMethod' => 'Rounding Method',
      'roundingFactor' => 'Rounding Factor',
      'surcharge' => 'Surcharge',
      'currency' => 'Currency',
      'basedOn' => 'Based On',
      'supplier' => 'Supplier'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'productCategory' => 'Product Category',
      'condition' => 'Condition',
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ],
      'basedOn' => [
        'Unit' => 'Unit',
        'Price Book' => 'Price Book',
        'Supplier' => 'Supplier',
        'Cost' => 'Cost'
      ],
      'basedOnShort' => [
        'Unit' => 'U',
        'Price Book' => 'PB',
        'Supplier' => 'S',
        'Cost' => 'C'
      ],
      'target' => [
        'All' => 'All',
        'Product Category' => 'Product Category',
        'Conditional' => 'Conditional'
      ],
      'percentageType' => [
        'Discount' => 'Discount',
        'Markup' => 'Markup'
      ],
      'roundingFactor' => [
        'Half Up' => 'Half Up',
        'Up' => 'Up',
        'Down' => 'Down'
      ]
    ],
    'tooltips' => [
      'minQuantity' => 'The rule will be applied only if the quantity of items being sold exceeds the specified value.',
      'currency' => 'The amount will be converted to the specified currency before rounding. Also defines the currency of the surcharge.',
      'basedOn' => 'What to use as a base price.

* Unit – the unit price defined in the Price Book or defined in the Product record; Price Book rules are not applied;
* Price Book – is obtained from the same Price Book; rules are applied;
* Supplier – the price of the Supplier;
* Cost – the cost specified in the Product record.',
      'surcharge' => 'An amount to add after percentage and rounding are applied. Use a negative number to subtract.',
      'roundingFactor' => 'The amount will be round off to the multiple of the specified value.',
      'percentage' => 'A percentage of the standard price to deduct or add.'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'PriceRuleCondition' => [
    'labels' => [
      'Create PriceRuleCondition' => 'Create Condition'
    ],
    'fields' => [
      'condition' => 'Condition'
    ],
    'tooltips' => [
      'condition' => 'A formula expression. Should return true or false.'
    ]
  ],
  'Product' => [
    'labels' => [
      'Create Product' => 'Create Product',
      'Price' => 'Price',
      'Brands' => 'Brands',
      'Categories' => 'Categories',
      'Price Books' => 'Price Books',
      'Quantity' => 'Quantity',
      'Warehouses' => 'Warehouses',
      'Generate' => 'Generate',
      'Orders' => 'Orders',
      'Select Variant' => 'Select Variant',
      'Select Variants' => 'Select Variants',
      'Select Template' => 'Select Template',
      'View Price' => 'View Price'
    ],
    'fields' => [
      'status' => 'Status',
      'brand' => 'Fabricante',
      'partNumber' => 'Part Number (Offer ID)',
      'category' => 'Categoria',
      'pricingType' => 'Pricing Type',
      'pricingFactor' => 'Pricing Factor',
      'costPrice' => 'Preço de Custo',
      'listPrice' => 'Preço de Lista',
      'unitPrice' => 'Preço Unitário',
      'costPriceCurrency' => 'Cost Price Currency',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'costPriceConverted' => 'Cost Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'url' => 'URL',
      'isTaxFree' => 'Tax-free',
      'weight' => 'Weight',
      'suppliers' => 'Suppliers',
      'unitPriceSelect' => 'Unit Price (Select)',
      'unitPriceSelectCurrency' => 'Unit Price (Select) (Currency)',
      'allowFractionalQuantity' => 'Allow Fractional Quantity',
      'quantity' => 'Available',
      'quantityReserved' => 'Reserved',
      'quantitySoftReserved' => 'Soft-Reserved',
      'quantityOnHand' => 'On Hand',
      'quantityInTransit' => 'In Transit',
      'quantityOnOrder' => 'On Order',
      'quantityWarehouse' => 'Available in Warehouse',
      'quantityWarehouseOnHand' => 'On Hand in Warehouse',
      'quantityWarehouseReserved' => 'Reserved in Warehouse',
      'qty' => 'Qty',
      'isInventory' => 'Is Inventory',
      'inventoryNumberType' => 'Inventory Number Type',
      'warehousesOnHand' => 'Warehouses (On Hand)',
      'type' => 'Type',
      'template' => 'Template',
      'attributes' => 'Attributes',
      'variantAttributeOptions' => 'Attribute Values',
      'variantOrder' => 'Variant Order',
      'expirationDays' => 'Expiration Days',
      'removalStrategy' => 'Removal Strategy',
      'ciscoArchitecture' => 'Architecture (Cisco)',
      'sku' => 'SKU#',
      'offerModel' => 'Modelo da Oferta',
      'enduserType' => 'Usuário Final (Tipo)',
      'billingType' => 'Modelo de Faturamento',
      'subCategory' => 'Sub-Categoria',
      'partNumberDescription' => 'Part Number (Descrição)',
      'categoryType' => 'Tipo de Contrato',
      'services' => 'Oportunidade de Serviço',
      'opportunitiesProduct' => 'Opportunities Product',
      'opportunitys' => 'Opportunitys',
      'isnewcommerce' => 'Isnewcommerce',
      'billingCycle' => 'Billing',
      'offerID' => 'OfferID',
      'formID' => 'FormID',
      'skuID' => 'SkuID',
      'identityID' => 'IdentityID',
      'lastUpdate' => 'LastUpdate',
      'duration' => 'Duração',
      'region' => 'Region',
      'instanceKey' => 'InstanceKey',
      'isReservedInstances' => 'IsReservedInstances',
      'culture' => 'Culture',
      'bestSeller' => 'BestSeller',
      'licenseType' => 'Licença',
      'timeContract' => 'Período',
      'termDuration' => 'Termo',
      'priceBooks' => 'Price Books',
      'sku2' => 'SKU#2',
      'sku3' => 'SKU#3',
      'productCategory' => 'Categoria do Produto',
      'update' => 'Update',
      'description' => 'Descrição'
    ],
    'links' => [
      'brand' => 'Brand',
      'category' => 'Category',
      'prices' => 'Prices',
      'supplierPrices' => 'Supplier Prices',
      'inventoryNumbers' => 'Inventory Numbers',
      'inventoryTransactions' => 'Inventory Transactions',
      'attributes' => 'Attributes',
      'attributeOptions' => 'Attribute Options',
      'variantAttributeOptions' => 'Variant Attribute Options',
      'template' => 'Template',
      'variants' => 'Variants',
      'variantInventoryNumbers' => 'Variant Inventory Numbers',
      'inventoryAdjustmentItems' => 'Adjustments',
      'services' => 'Oportunidade de Serviço',
      'opportunitiesProduct' => 'Opportunities Product',
      'opportunitys' => 'Opportunities',
      'priceBooks' => 'Price Books'
    ],
    'options' => [
      'pricingType' => [
        'Same as List' => 'Same as List',
        'Fixed' => 'Fixed',
        'Discount from List' => 'Discount from List',
        'Markup over Cost' => 'Markup over Cost',
        'Profit Margin' => 'Profit Margin'
      ],
      'inventoryNumberType' => [
        'Batch' => 'Batch',
        'Serial' => 'Serial'
      ],
      'type' => [
        'Regular' => 'Regular',
        'Template' => 'Template',
        'Variant' => 'Variant',
        'ADDON' => 'ADDON'
      ],
      'removalStrategy' => [
        'FIFO' => 'FIFO',
        'FEFO' => 'FEFO',
        'LIFO' => 'LIFO'
      ],
      'ciscoArchitecture' => [
        '' => '',
        'Collab' => 'Collab',
        'Data Center' => 'Data Center',
        'Enterprise' => 'Enterprise',
        'Meraki' => 'Meraki',
        'Security' => 'Security'
      ],
      'enduserType' => [
        '' => '',
        'Charity' => 'Charity',
        'Educational' => 'Educational',
        'Corporate' => 'Corporate',
        'Commercial' => 'Commercial'
      ],
      'billingType' => [
        '' => '',
        'Anual (Pagamento Anual)' => 'Anual (Pagamento Anual)',
        'Anual (Pagamento Mensal)' => 'Anual (Pagamento Mensal)',
        'Anual (Pagamento Upfront)' => 'Anual (Pagamento Upfront)',
        'Mensal' => 'Mensal',
        'One Time' => 'One Time',
        'Trianual (Pagamento Upfront)' => 'Trianual (Pagamento Upfront)',
        'Único' => 'Único',
        'Upfront' => 'Upfront',
        'License' => 'License'
      ],
      'subCategory' => [
        '' => '',
        'Access' => 'Access',
        'BizTalk Server' => 'BizTalk Server',
        'Excel' => 'Excel',
        'Exchange Server' => 'Exchange Server',
        'Office' => 'Office',
        'Outlook' => 'Outlook',
        'PowerPoint' => 'PowerPoint',
        'Project' => 'Project',
        'Publisher' => 'Publisher',
        'SharePoint' => 'SharePoint',
        'Skype for Business Server' => 'Skype for Business Server',
        'SQL Server' => 'SQL Server',
        'Visio' => 'Visio',
        'Visual Studio' => 'Visual Studio',
        'Windows' => 'Windows',
        'Windows GGWA' => 'Windows GGWA',
        'Windows Server' => 'Windows Server',
        'Word' => 'Word',
        'Azure SQL Edge' => 'Azure SQL Edge',
        'Power Platform' => 'Power Platform',
        'Connectivity & Sharing' => 'Connectivity & Sharing',
        'Windows Server 2022' => 'Windows Server 2022',
        'Windows 7 Extended Security' => 'Windows 7 Extended Security',
        'Productivity & End user computing' => 'Productivity & End User Computing'
      ],
      'categoryType' => [
        '' => '',
        'O365/M365' => 'O365/M365',
        'D365/Power Platform' => 'D365/Power Platform',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetuo' => 'Software Perpetuo',
        'CSP' => 'CSP',
        'Open' => 'Open',
        'SPLA' => 'SPLA',
        'CSP NCE' => 'CSP NCE',
        'Open Value - 1 Ano' => 'Open Value - 1 Ano',
        'Open Value - 2 Anos' => 'Open Value - 2 Anos',
        'Open Value - 3 Anos' => 'Open Value - 3 Anos',
        'Open Value' => 'Open Value',
        'Google Workspace' => 'Google Workspace',
        'Google' => 'Google'
      ],
      'billingCycle' => [
        'monthly' => 'Mensal',
        'annually' => 'Anual',
        'onetime' => 'One Time',
        '' => '',
        'Flexible' => 'Flexível'
      ],
      'licenseType' => [
        'M365' => 'M365',
        'Software Subscription' => 'Software Subscription',
        'Software Perpetual' => 'Software Perpetual',
        'Open Value' => 'Open Value',
        'Azure' => 'Azure',
        '' => '',
        'D365' => 'D365',
        'Power Platform' => 'Power Platform',
        'Open Value Subscription' => 'Open Value Subscription',
        'OVS-ES' => 'OVS-ES',
        'O365/M365' => 'O365/M365',
        'School' => 'School',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Transfer' => 'Transfer',
        'Upgrade' => 'Upgrade'
      ],
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Month',
        '1 Year' => '1 Year',
        '2 Years' => '2 Years',
        '3 Years' => '3 Years',
        'Perpetual' => 'Perpetual',
        'Pay as you go' => 'Pay as you go'
      ],
      'productCategory' => [
        '' => '',
        'Charity' => 'Charity',
        'Education' => 'Education',
        'Commercial' => 'Commercial',
        'Government' => 'Government',
        'Corporate' => 'Corporate',
        'Academic' => 'Academic',
        'School' => 'School'
      ]
    ],
    'presetFilters' => [
      'available' => 'Available',
      'inventory' => 'Inventory',
      'allVariants' => 'All Variants',
      'availableVariants' => 'Available Variants'
    ],
    'tabs' => [
      'inventory' => 'Inventory',
      'prices' => 'Prices',
      'variants' => 'Variants',
      'template' => 'Template',
      'orders' => 'Orders'
    ],
    'messages' => [
      'generateVariantsConfirmation' => 'Generate all possible variant combinations?',
      'variantsGenerated' => 'Done. {count} variants generated.',
      'attributesRequired' => 'At least one attribute is required',
      'optionsRequired' => 'Options are required'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'ProductAttribute' => [
    'labels' => [
      'Create ProductAttribute' => 'Create Attribute',
      'Move to Top' => 'Move to Top',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down',
      'Move to Bottom' => 'Move to Bottom'
    ],
    'fields' => [
      'order' => 'Order',
      'options' => 'Options'
    ],
    'links' => [
      'options' => 'Options',
      'products' => 'Products'
    ]
  ],
  'ProductAttributeOption' => [
    'labels' => [
      'Create ProductAttributeOption' => 'Create Option'
    ],
    'fields' => [
      'order' => 'Order',
      'attribute' => 'Attribute',
      'color' => 'Color',
      'attributeOrder' => 'Attribute Order'
    ],
    'links' => [
      'attribute' => 'Attribute',
      'products' => 'Products',
      'productVariants' => 'Product Variants'
    ]
  ],
  'ProductBrand' => [
    'labels' => [
      'Create ProductBrand' => 'Create Product Brand'
    ],
    'fields' => [
      'website' => 'Website',
      'opportunities' => 'Oportunidades',
      'partnerIDs' => 'ID no fabricante',
      'sources' => 'Sources',
      'services' => 'Serviços',
      'servicesVersionsBrand' => 'Service Versions',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Programas de parceiros',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Programa',
      'aWSs' => 'AWS',
      'events' => 'Evento',
      'task' => 'Tarefa',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tasks',
      'campanas' => 'Campaigns',
      'marketing' => 'Campaigns',
      'marketings' => 'Marketing',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Serviços',
      'vendorAccounts' => 'Vendor Accounts',
      'cPartnerAssessments' => 'Partner Assessments',
      'cPatchNotes' => 'Patch Notes'
    ],
    'links' => [
      'products' => 'Products',
      'opportunities' => 'Oportunidades',
      'partnerIDs' => 'ID no fabricante',
      'sources' => 'Sources',
      'services' => 'Serviços',
      'servicesVersionsBrand' => 'Service Versions',
      'lead' => 'Lead',
      'leads' => 'Leads',
      'partnerPrograms' => 'Programas de parceiros',
      'cpb' => 'Cloud Practice Builder',
      'googlePartnerAdvantage' => 'Google Partner Advantage',
      'programs' => 'Programa',
      'aWSs' => 'AWS',
      'events' => 'Evento',
      'task' => 'Tarefa',
      'dSET' => 'DSET',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'tasks' => 'Tasks',
      'campanas' => 'Campaigns',
      'marketing' => 'Marketing Campaigns',
      'marketings' => 'Marketing',
      'opportunityItem' => 'Opportunity Item',
      'service' => 'Serviços',
      'vendorAccounts' => 'Vendor Accounts',
      'cPartnerAssessments' => 'Partner Assessments',
      'cPatchNotes' => 'Patch Notes'
    ]
  ],
  'ProductCategory' => [
    'labels' => [
      'Create ProductCategory' => 'Create Category',
      'Manage Categories' => 'Manage Categories',
      'Products' => 'Products'
    ],
    'fields' => [
      'order' => 'Order',
      'childList' => 'Child List'
    ],
    'links' => [
      'products' => 'Products'
    ]
  ],
  'ProductPrice' => [
    'labels' => [
      'Create ProductPrice' => 'Create Price'
    ],
    'fields' => [
      'priceBook' => 'Price Book',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'priceBook' => 'Price Book',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'tooltips' => [
      'minQuantity' => 'The price will be used only when the quantity of items being sold exceeds the specified value.'
    ],
    'messages' => [
      'priceMassUpdated' => 'Prices updated, count: {count}'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'PurchaseOrder' => [
    'labels' => [
      'Create PurchaseOrder' => 'Create Purchase Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Purchase Order Items' => 'Purchase Order Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'supplierAddress' => 'Supplier Address',
      'supplierAddressStreet' => 'Street (Supplier)',
      'supplierAddressCity' => 'City (Supplier)',
      'supplierAddressState' => 'State (Supplier)',
      'supplierAddressCountry' => 'Country (Supplier)',
      'supplierAddressPostalCode' => 'Postal Code (Supplier)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'PurchaseOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'purchaseOrder' => 'Purchase Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'purchaseOrderStatus' => 'Purchase Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'purchaseOrder' => 'Purchase Order',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Purchase Orders' => 'Purchase Orders'
    ]
  ],
  'Quote' => [
    'labels' => [
      'Create Quote' => 'Criar Cotação',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Quote Items' => 'Quote Items',
      'Apply Price Book' => 'Apply Price Book',
      'Locked' => 'Locked',
      'Unlocked' => 'Unlocked',
      'Send in Email' => 'Send in Email'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Número da Cotação',
      'numberA' => 'Quote Number (auto-incremented)',
      'invoiceNumber' => 'Invoice Number',
      'account' => 'Conta',
      'opportunity' => 'Oportunidade',
      'billingAddress' => 'Billing Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Contato de Billing',
      'shippingContact' => 'Shipping Contact',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'discountAmount',
      'amount' => 'Valor Total',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Itens',
      'dateQuoted' => 'Data da Cotação',
      'dateOrdered' => 'Data de Fechamento (Prazo)',
      'dateInvoiced' => 'Data de Aprovação da Cotação',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done',
      'amountDiscounted' => 'Valor Total Descontado',
      'amountDiscountedCurrency' => 'Valor Total Descontado (Currency)',
      'amountDiscountedConverted' => 'Valor Total Descontado (Converted)',
      'quoteAccessKey' => 'Chave de Acesso da Cotação',
      'receipt' => 'Nota Fiscal',
      'quotePage' => 'Página de Cotações',
      'reply' => 'Revisão de Cotação',
      'billingContactEmail' => 'E-mail do Contato de Billing',
      'oppStage' => 'Estágio da Oportunidade',
      'commercialConditions' => 'Condições Comerciais',
      'contacts' => 'Contatos',
      'documents' => 'Documentos',
      'sendEmail' => 'Enviar Email ao Contato de Billing',
      'oppQuote' => 'Oportunidade (Cotação Aprovada)',
      'reviewDate' => 'Data de Revisão',
      'amountWithDiscount' => 'Valor Total (Com Desconto)',
      'amountWithDiscountCurrency' => 'Valor Total (Com Desconto) (Currency)',
      'amountWithDiscountConverted' => 'Valor Total (Com Desconto) (Converted)',
      'quotes' => 'Versões',
      'quoteParent' => 'Cotação',
      'version' => 'Versão',
      'opportunityQuotes' => 'DESATIVADO OPP',
      'cOpportunityQuoteReview' => 'Cotação em Revisão',
      'cDisplayProducts' => 'Exibir Produtos na Oportunidade',
      'salesOrders' => 'Pedido de venda',
      'description' => 'Descrições Internas'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Oportunidade',
      'account' => 'Account',
      'tax' => 'Tax',
      'salesOrders' => 'Pedido de venda',
      'invoices' => 'Invoices',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'contacts' => 'Contatos',
      'documents' => 'Documentos',
      'oppQuote' => 'Oportunidade (One)',
      'quotes' => 'Versões',
      'quoteParent' => 'Cotação',
      'opportunityQuotes' => 'DESATIVADO OPP',
      'cOpportunityQuoteReview' => 'Cotação em Revisão'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Rascunho',
        'In Review' => 'Em Revisão',
        'Presented' => 'Apresentada',
        'Approved' => 'Aprovada',
        'Rejected' => 'Rejeitada',
        'Canceled' => 'Cancelada',
        'Stand-By' => 'Stand-By'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'approved' => 'Approved'
    ],
    'messages' => [
      'cannotRemoveLockedRecord' => 'Cannot remove the locked record.',
      'massLockDone' => '{count} locked',
      'massUnlockDone' => '{count} unlocked',
      'confirmMassLock' => 'Are you sure you want to lock selected records?',
      'confirmMassUnlock' => 'Are you sure you want to unlock selected records?',
      'cantModifyLocked' => 'Cannot modify *{field}* in the locked record.',
      'productTemplateCannotBeSelected' => 'A product template cannot be selected in an item. *{name}* is a template.',
      'fieldCannotBeFractional' => 'Quantity cannot be fractional for this product',
      'invalidItems' => 'Invalid items.',
      'requiredInventoryNumber' => 'Inventory Number is required.',
      'requiredQuantityReceived' => 'Quantity Received is required.',
      'notEnoughQuantity' => 'Not enough quantity is available.',
      'enoughQuantity' => 'Enough quantity is available.',
      'softNotEnoughQuantity' => 'Enough quantity is on hand but some items are soft-reserved.',
      'applyNewPriceConfirmation' => 'A different price is available for the specified quantity. Would you like to apply it?',
      'cannotUnlockByRegularUser' => 'Cannot unlock. Only an administrator is permitted.'
    ],
    'texts' => [
      'onHandQuantityInfo' => 'On hand',
      'availableQuantityInfo' => 'Available',
      'lackingQuantityInfo' => 'Lacking',
      'totalAvailableQuantityInfo' => 'In all warehouses',
      'totalOnHandQuantityInfo' => 'On hand in all warehouses',
      'onHandInventoryNumberInfo' => 'Inv. number on hand',
      'onHandBatchInfo' => 'On hand in batch',
      'onHandSerialInfo' => 'Serial on hand'
    ],
    'tooltips' => [
      'quoteAccessKey' => 'Para gerar uma Chave de Acesso, por favor, selecione o "Contato de Billing". ',
      'cDisplayProducts' => 'Ao selecionar esta opção, você estará alterando os itens exibidos na oportunidade de origem da cotação, e o valor na página do book.',
      'billingContact' => 'O Contato de Billing é o responsável pela Cotação. Ao selecionar o contato de Billing, uma chave de acesso é gerada para que seja possível acessar a "Página de Cotações" e gerenciar todas as cotações relacionadas com este contato.'
    ]
  ],
  'QuoteItem' => [
    'fields' => [
      'name' => 'Nome (Produto)',
      'qty' => 'Qtd',
      'quantity' => 'Quantidade',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Preço Unitário',
      'amount' => 'Valor Total',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'order' => 'Line Number',
      'quote' => 'Quote',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Desconto (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'quoteStatus' => 'Quote Status',
      'discountAmount' => 'Valor c/ Desconto',
      'discountAmountCurrency' => 'Valor Total (Com Desconto) (Currency)',
      'discountAmountConverted' => 'Valor Total (Com Desconto) (Converted)',
      'timeContract' => 'Período',
      'solutionType' => 'Billing',
      'discountItem' => 'Desc (%)',
      'licenseType' => 'Licença',
      'contractType' => 'Contrato',
      'cAdditionalDiscount' => 'Desc Add (%)'
    ],
    'links' => [
      'quote' => 'Quote',
      'product' => 'Product',
      'account' => 'Account'
    ],
    'labels' => [
      'Quotes' => 'Quotes'
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'options' => [
      'timeContract' => [
        '' => '',
        '1 Month' => '1 Mês',
        '1 Year' => '1 Ano',
        '2 Years' => '2 Anos',
        '3 Years' => '3 Anos',
        'Perpetual' => 'Perpétuo',
        'Pay as you go' => 'Pay as you go'
      ],
      'solutionType' => [
        '' => '',
        '1 Month' => '1 Mês',
        '1 Year' => '1 Ano',
        'Monthly' => 'Mensal',
        'Annual' => 'Anual',
        'Up Front' => 'Up Front',
        '2 Years' => '2 Anos',
        '3 Years' => '3 Anos',
        'Flexible' => 'Flexível',
        'Perpetual' => 'Perpétuo',
        'Pay as you go' => 'Pay as you go',
        'Quote' => 'Quote',
        'Annual - Monthly Payment' => 'Anual - Pagamento Mensal',
        'Trial Version' => 'Trial ',
        'onetime' => 'One Time'
      ],
      'licenseType' => [
        'AWS' => 'AWS',
        'Azure' => 'Azure',
        'M365' => 'M365',
        'D365' => 'D365',
        'O365/M365' => 'O365/M365',
        'Power Platform' => 'Power Platform',
        'Services' => 'Services',
        'Software Perpetual' => 'Software Perpetual',
        'Software Subscription' => 'Software Subscription',
        'Open Values Subscription' => 'Open Values Subscription',
        'OVS-ES' => 'OVS-ES',
        'Open Value' => 'Open Value',
        'School' => 'School',
        'New Business' => 'New Business',
        'Renewal' => 'Renewal',
        'Upgrade' => 'Upgrade',
        'Transfer' => 'Transfer',
        '' => ''
      ],
      'contractType' => [
        '' => '',
        'NCE' => 'NCE',
        'CSP NCE' => 'CSP NCE',
        'CSP' => 'CSP',
        'Open Value' => 'Open Value',
        'SPLA' => 'SPLA',
        'Professional Services' => 'Professional Services',
        'Googles Workspace' => 'Googles Workspace',
        'Google Workspace' => 'Google Workspace'
      ]
    ]
  ],
  'ReceiptOrder' => [
    'labels' => [
      'Create ReceiptOrder' => 'Create Receipt Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Received Inventory' => 'Received Inventory',
      'Import Serial Numbers' => 'Import Serial Numbers',
      'CSV File' => 'CSV File'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'shippingContact' => 'Shipping Contact',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingProvider' => 'Shipping Provider',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'itemList' => 'Item List',
      'receivedItemList' => 'Received Item List',
      'dateOrdered' => 'Date Ordered',
      'dateReceived' => 'Date Received',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'isDone' => 'Is Done',
      'warehouse' => 'Warehouse',
      'fieldDelimiter' => 'Field Delimiter',
      'textQualifier' => 'Text Qualifier',
      'headerRow' => 'Header Row',
      'columnNumber' => 'Column Number',
      'preview' => 'Preview'
    ],
    'links' => [
      'items' => 'Items',
      'receivedItems' => 'Received Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'purchaseOrder' => 'Purchase Order',
      'returnOrder' => 'Return Order',
      'account' => 'Account',
      'supplier' => 'Supplier',
      'inventoryTransactions' => 'Inventory Transactions',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'inventoryIsInAdjustment' => 'Can\'t save as inventory is currently in a started adjustment.',
      'serialNumbersExists' => 'Some serial numbers already exists.

{numbers}',
      'serialNumberImportLimitExceeded' => 'Cannot import more than {maxSize} serial numbers.',
      'serialNumberAlreadyInStock' => 'Serial number already in stock.

{numbers}',
      'receivedSerialNumberNotOne' => 'Quantity of a received item with a serial number should be one.',
      'receivedInventoryNumberProductMismatch' => 'Inventory number does not correspond to the product.',
      'receivedInventoryNumberIsEmpty' => 'Not specified inventory number.',
      'receivedQuantityMismatch' => 'Received quantity mismatch.',
      'emptyQuantityReceived' => 'Need to specify Quantity Received before completing the order.'
    ]
  ],
  'ReceiptOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'receiptOrder' => 'Receipt Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'account' => 'Account',
      'receiptOrderStatus' => 'Receipt Order Status',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'receiptOrder' => 'Receipt Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'ReturnOrder' => [
    'labels' => [
      'Create ReturnOrder' => 'Create Return Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Create Receipt' => 'Create Receipt'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'billingAddress' => 'Billing Address',
      'fromAddress' => 'Ship from Address',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'fromAddressStreet' => 'Street (from)',
      'fromAddressCity' => 'City (from)',
      'fromAddressState' => 'State (from)',
      'fromAddressCountry' => 'Country (from)',
      'fromAddressPostalCode' => 'Postal Code (from)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount Amount',
      'amount' => 'Amount',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'supplier' => 'Supplier',
      'warehouse' => 'Ship to Warehouse',
      'isReceiptFullyCreated' => 'Receipt Fully Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'billingContact' => 'Billing Contact',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'account' => 'Account',
      'salesOrder' => 'Sales Order',
      'tax' => 'Tax',
      'supplier' => 'Supplier',
      'receiptOrders' => 'Receipt Orders',
      'warehouse' => 'Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Released' => 'Released',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'cannotCreateReceiptInEditMode' => 'Cannot create receipt orders while in edit mode.'
    ]
  ],
  'ReturnOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Amount',
      'taxRate' => 'Tax Rate',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number',
      'order' => 'Line Number',
      'returnOrder' => 'Return Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Account',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'returnOrderStatus' => 'Return Order Status',
      'inventoryNumberType' => 'Inventory Number Type'
    ],
    'links' => [
      'returnOrder' => 'Return Order',
      'product' => 'Product',
      'account' => 'Account'
    ]
  ],
  'SalesOrder' => [
    'labels' => [
      'Create SalesOrder' => 'Criar Sales Order',
      'Taxes' => 'Taxes',
      'Shipping Providers' => 'Shipping Providers',
      'Add Item' => 'Add Item',
      'Templates' => 'Templates',
      'Items' => 'Items',
      'Sales Order Items' => 'Sales Order Items',
      'Create Delivery' => 'Create Delivery',
      'Add Delivery' => 'Add Delivery',
      'Not Created' => 'Not Created'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'ERP Number',
      'numberA' => 'Number (auto-incremented)',
      'account' => 'Conta',
      'opportunity' => 'Oportunidade',
      'quote' => 'Cotação',
      'billingAddress' => 'Endereço',
      'shippingAddress' => 'Shipping Address',
      'billingContact' => 'Contato (Billing)',
      'shippingContact' => 'Cointat (Shipping)',
      'tax' => 'Tax',
      'taxRate' => 'Tax Rate',
      'shippingCost' => 'Shipping Cost',
      'shippingProvider' => 'Shipping Provider',
      'taxAmount' => 'Tax Amount',
      'discountAmount' => 'Discount',
      'amount' => 'Valor (FOB)',
      'preDiscountedAmount' => 'Pre-Discount Amount',
      'grandTotalAmount' => 'Grand Total Amount',
      'itemList' => 'Item List',
      'dateOrdered' => 'Data do Pedido',
      'dateInvoiced' => 'Date Invoiced',
      'weight' => 'Weight',
      'amountConverted' => 'Amount (converted)',
      'taxAmountConverted' => 'Tax Amount (converted)',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'preDiscountedAmountConverted' => 'Pre-Discount Amount (converted)',
      'discountAmountConverted' => 'Discount Amount (converted)',
      'grandTotalAmountConverted' => 'Grand Total Amount (converted)',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'taxAmountCurrency' => 'Tax Amount Currency',
      'discountAmountCurrency' => 'Discount Amount Currency',
      'amountCurrency' => 'Amount Currency',
      'preDiscountedAmountCurrency' => 'Pre-Discount Amount Currency',
      'grandTotalAmountCurrency' => 'Grand Total Amount Currency',
      'currency' => 'Currency',
      'priceBook' => 'Price Book',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDeliveryCreated' => 'Delivery Created',
      'hasInventoryItems' => 'Has Inventory Items',
      'isDone' => 'Is Done',
      'partnerID' => 'ID no fabricante',
      'quantity' => 'Qtd.',
      'cloudsolvSSAID' => 'ID no CloudsolvSSA',
      'contractEndDateVendor' => 'Data de Vencimento',
      'subscriptionAutomaticRenew' => 'Renovação automática',
      'orderDetail' => 'Detalhe do pedido',
      'subscriptionID' => 'SubscriptionID',
      'billingCycle' => 'BillingCycle',
      'endUserAmount' => 'CF',
      'endUserAmountCurrency' => 'EndUserAmount (Currency)',
      'endUserAmountConverted' => 'EndUserAmount (Converted)',
      'subscriptionAmount' => 'RV',
      'subscriptionAmountCurrency' => 'SubscriptionAmount (Currency)',
      'subscriptionAmountConverted' => 'SubscriptionAmount (Converted)',
      'listPrice' => 'ListPrice',
      'discountPricingRules' => 'DiscountPricingRules',
      'markupPricingRules' => 'MarkupPricingRules',
      'pricingInfo' => 'PricingInfo',
      'contractIdExternal' => 'ContractIdExternal',
      'directbilling' => 'Directbilling',
      'contractLastRenovation' => 'Última Renovação',
      'termDuration' => 'TermDuration',
      'profit' => 'Lucro',
      'profitCurrency' => 'Lucro (Currency)',
      'profitConverted' => 'Lucro (Converted)',
      'countryExternal' => 'País',
      'accountNameExternal' => 'Cliente Final',
      'accountParentNameExternal' => 'Revenda',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'vendorAccountName' => 'VendorAccountName',
      'cloudConsumption' => 'Cloud Consumption',
      'productSSA' => 'Produto (CloudsolvSSA)',
      'reseller' => 'Reseller (Renewals)',
      'microsoftRecommendations' => 'Recomendações Microsoft',
      'microsoftRecommendationsText' => 'Recomendações',
      'top5Customers' => 'Cliente Top 5',
      'accountTop5' => 'Account Top 5',
      'accountReservedInstances' => 'Account (Reserved Instances)',
      'accountRecommendation' => 'Account (Recommendations)',
      'product' => 'Produto',
      'converterQuantity' => 'Qtd.',
      'microsoftRecommendationsEmail' => 'Recommendation (Email)',
      'contractEndDateDays' => 'Vencimento em (dias)',
      'items' => 'Item de pedido',
      'description' => 'Descrição'
    ],
    'links' => [
      'items' => 'Item de pedido',
      'billingContact' => 'Contato (Billing)',
      'shippingContact' => 'Cointat (Shipping)',
      'shippingProvider' => 'Shipping Provider',
      'opportunity' => 'Oportunidade',
      'account' => 'Conta',
      'tax' => 'Tax',
      'quote' => 'Cotação',
      'invoices' => 'Invoices',
      'deliveryOrders' => 'Delivery Orders',
      'returnOrders' => 'Return Orders',
      'priceBook' => 'Price Book',
      'inventoryTransactions' => 'Inventory Transactions',
      'partnerID' => 'ID no fabricante',
      'vendorCloudConsumption' => 'Vendor Cloud Consumption',
      'cloudConsumption' => 'Cloud Consumption',
      'reseller' => 'Reseller (Renewals)',
      'accountTop5' => 'Account Top 5',
      'accountReservedInstances' => 'Account (Reserved Instances)',
      'accountRecommendation' => 'Account (Recommendations)',
      'service' => 'Service'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'Active' => 'Active',
        'Approved' => 'Approved',
        'Completed' => 'Completed',
        'Rejected' => 'Rejected',
        'Canceled' => 'Canceled',
        'Suspended' => 'Suspended',
        'under analysis' => 'under analysis',
        '' => '',
        'Pending' => 'Pending'
      ],
      'billingCycle' => [
        'Monthly' => 'Monthly',
        'Annualy' => 'Annualy',
        'Annually' => 'Annually',
        'OneTime' => 'OneTime',
        '' => 'Empty'
      ],
      'countryExternal' => [
        'BR' => 'BR',
        'CL' => 'CL',
        'CO' => 'CO',
        'AR' => 'AR',
        'EC' => 'EC',
        'CH' => 'CH',
        'PE' => 'PE',
        'PA' => 'PA',
        '' => '',
        'MX' => 'MX'
      ],
      'microsoftRecommendations' => [
        'Copilot M365' => 'Copilot M365',
        'EMS E3' => 'EMS E3',
        'EMS E5' => 'EMS E5',
        'Microsoft 365 Business Premium' => 'Microsoft 365 Business Premium',
        'Microsoft 365 Business Standard' => 'Microsoft 365 Business Standard',
        'Microsoft 365 A3' => 'Microsoft 365 A3',
        'Microsoft 365 A5' => 'Microsoft 365 A5',
        'Office 365 E1' => 'Office 365 E1',
        'Office 365 E3' => 'Office 365 E3',
        'Office 365 E5' => 'Office 365 E5',
        'Windows E3' => 'Windows E3',
        'Windows E5' => 'Windows E5',
        'None' => 'None',
        'Microsoft 365 Business Standard + Copilot M365' => 'Microsoft 365 Business Standard + Copilot M365',
        'Office 365 E3 + Copilot M365' => 'Office 365 E3 + Copilot M365'
      ],
      'productSSA' => [
        'Selecione' => 'Selecione'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed',
      'reportFilter664d0b06517450b14' => 'Renewals - Next 30 days',
      'reportFilter664d0e340882520f7' => 'Renewals - 31 to 60 days',
      'reportFilter664d0e6ceb98d29e4' => 'Renewals - 61 to 90 days',
      'reportFilter664d0eba732cf5106' => 'Renewals Reserved Instance - 90 days',
      'reportFilter664d0fd3e3ead8274' => 'Renewals Auto OFF - Next 30 days',
      'reportFilter664d101ecb1f34383' => 'Renewals Auto OFF - 31 to 60 days',
      'reportFilter664d1038e67c31c3c' => 'Renewals Auto OFF - 61 to 90 days',
      'reportFilter664dfdebb84637a58' => 'Renewals - next 90 days',
      'reportFilter664e33d0e85544c6c' => 'Renewals Recommendation Copilot M365',
      'reportFilter66831cbe23b6204fe' => 'Count Renewals Recommendation Microsoft',
      'reportFilter669153f230b85ba6a' => 'Renewals - Top 5 Customers',
      'reportFilter66916dc409c1b86f7' => 'Renewals - Reserved Instance'
    ],
    'messages' => [
      'cannotCreateDeliveryInEditMode' => 'Cannot create delivery orders while in edit mode.'
    ],
    'tooltips' => [
      'number' => 'Applications, CIS, Stellr, etc'
    ]
  ],
  'SalesOrderItem' => [
    'fields' => [
      'name' => 'Nome',
      'qty' => 'Qty',
      'quantity' => 'Quantidade',
      'quantityInt' => 'Quantity (Int)',
      'listPrice' => 'List Price',
      'unitPrice' => 'Unit Price',
      'amount' => 'Valor',
      'taxRate' => 'Tax Rate',
      'product' => 'Produto',
      'order' => 'Line Number',
      'salesOrder' => 'Pedido de venda',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'discount' => 'Discount (%)',
      'amountConverted' => 'Amount (Converted)',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'listPriceConverted' => 'List Price (Converted)',
      'account' => 'Conta',
      'listPriceCurrency' => 'List Price Currency',
      'unitPriceCurrency' => 'Unit Price Currency',
      'amountCurrency' => 'Amount Currency',
      'salesOrderStatus' => 'Status do pedido de venda',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory',
      'services' => 'Services'
    ],
    'links' => [
      'salesOrder' => 'Pedido de venda',
      'product' => 'Product',
      'account' => 'Conta',
      'services' => 'Services'
    ],
    'labels' => [
      'Sales Orders' => 'Sales Orders'
    ]
  ],
  'ShippingProvider' => [
    'labels' => [
      'Create ShippingProvider' => 'Create Shipping Provider'
    ],
    'fields' => [
      'website' => 'Website'
    ]
  ],
  'Supplier' => [
    'labels' => [
      'Create Supplier' => 'Create Supplier'
    ],
    'fields' => [
      'account' => 'Account',
      'status' => 'Status'
    ],
    'links' => [
      'account' => 'Account',
      'prices' => 'Prices',
      'purchaseOrders' => 'Purchase Orders'
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ]
  ],
  'SupplierProductPrice' => [
    'labels' => [
      'Create SupplierProductPrice' => 'Create Supplier Price'
    ],
    'fields' => [
      'supplier' => 'Supplier',
      'status' => 'Status',
      'product' => 'Product',
      'minQuantity' => 'Min. Quantity',
      'price' => 'Price',
      'priceCurrency' => 'Price Currency',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'minQty' => 'Min. Qty',
      'partNumber' => 'Part Number',
      'priceConverted' => 'Price Converted'
    ],
    'links' => [
      'supplier' => 'Supplier',
      'product' => 'Product'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ],
    'massActions' => [
      'updatePrice' => 'Update Price'
    ]
  ],
  'Tax' => [
    'labels' => [
      'Create Tax' => 'Create Tax'
    ],
    'fields' => [
      'rate' => 'Rate'
    ]
  ],
  'TransferOrder' => [
    'labels' => [
      'Create TransferOrder' => 'Create Transfer Order',
      'Add Item' => 'Add Item',
      'Items' => 'Items',
      'Valid' => 'Valid',
      'Invalid' => 'Invalid',
      'Show Availability' => 'Show Availability',
      'Availability' => 'Availability',
      'Total' => 'Total'
    ],
    'fields' => [
      'status' => 'Status',
      'number' => 'Number',
      'numberA' => 'Number (auto-incremented)',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse',
      'fromAddress' => 'Ship from Address',
      'toAddress' => 'Ship to Address',
      'shippingCost' => 'Shipping Cost',
      'amount' => 'Amount',
      'shippingCostCurrency' => 'Shipping Cost Currency',
      'amountCurrency' => 'Amount Currency',
      'shippingProvider' => 'Shipping Provider',
      'itemList' => 'Item List',
      'dateOrdered' => 'Date Ordered',
      'shippingDate' => 'Shipping Date',
      'deliveryDate' => 'Delivery Date',
      'weight' => 'Weight',
      'shippingCostConverted' => 'Shipping Cost (converted)',
      'currency' => 'Currency',
      'inventoryData' => 'Inventory Data',
      'inventoryStatus' => 'Inventory Status',
      'isDone' => 'Is Done'
    ],
    'links' => [
      'items' => 'Items',
      'shippingContact' => 'Shipping Contact',
      'shippingProvider' => 'Shipping Provider',
      'inventoryTransactions' => 'Inventory Transactions',
      'fromWarehouse' => 'From Warehouse',
      'toWarehouse' => 'To Warehouse'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Ready' => 'Ready',
        'In Progress' => 'In Progress',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Failed' => 'Failed'
      ],
      'inventoryStatus' => [
        'Available' => 'Available',
        'On Hand' => 'On Hand',
        'Not Available' => 'Not Available'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed'
    ],
    'messages' => [
      'warehousesAreSame' => 'Warehouses must be different'
    ]
  ],
  'TransferOrderItem' => [
    'fields' => [
      'name' => 'Name',
      'qty' => 'Qty',
      'qtyReceived' => 'Qty Rcv',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'quantityReceived' => 'Quantity Received',
      'quantityReceivedInt' => 'Quantity Received (Int)',
      'product' => 'Product',
      'order' => 'Line Number',
      'transferOrder' => 'Transfer Order',
      'weight' => 'Weight',
      'unitWeight' => 'Unit Weight',
      'description' => 'Description',
      'transferOrderStatus' => 'Transfer Order Status',
      'inventoryNumber' => 'Inventory Number',
      'inventoryNumberType' => 'Inventory Number Type',
      'isInventory' => 'Is Inventory'
    ],
    'links' => [
      'transferOrder' => 'Transfer Order',
      'product' => 'Product',
      'inventoryNumber' => 'Inventory Number'
    ]
  ],
  'Warehouse' => [
    'labels' => [
      'Create Warehouse' => 'Create Warehouse'
    ],
    'fields' => [
      'status' => 'Status',
      'isAvailableForStock' => 'Available for Stock',
      'isStock' => 'Stock'
    ],
    'links' => [
      'inventoryTransactions' => 'Inventory Transactions',
      'products' => 'Products',
      'inventoryNumbers' => 'Inventory Numbers'
    ],
    'options' => [
      'status' => [
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'presetFilters' => [
      'active' => 'Active'
    ]
  ],
  'DashboardSet' => [
    'fields' => [
      'dashboardTemplate' => 'Dashboard Template',
      'iconClass' => 'Icon',
      'number' => 'Number'
    ],
    'labels' => [
      'Create DashboardSet' => 'Create Dashboard Set'
    ],
    'links' => [
      'dashboardTemplate' => 'Dashboard Template'
    ]
  ],
  'Service' => [
    'fields' => [
      'account' => 'Operadora / Revenda',
      'amount' => 'Amount',
      'amountConverted' => 'Amount (converted)',
      'amountCurrency' => 'Amount Currency',
      'description' => 'Nome da Proposta',
      'itemList' => 'Item List',
      'name' => 'Nome da Oportunidade (Projeto)',
      'billingSituation' => 'Situação Financeira',
      'billingType' => 'Tipo de Faturamento',
      'cancelReason' => 'Motivo de Cancelamento',
      'stage' => 'Status',
      'consumptionEstimate' => 'Estimativa de Consumo (Mensal)',
      'consumptionEstimateCurrency' => 'Estimativa de Consumo (Mensal) (Currency)',
      'consumptionEstimateConverted' => 'Estimativa de Consumo (Mensal) (Converted)',
      'costVSReceipt' => 'Lucro',
      'costVSReceiptCurrency' => 'Lucro (Currency)',
      'costVSReceiptConverted' => 'Lucro (Converted)',
      'custo' => 'Custo',
      'custoCurrency' => 'Custo (Currency)',
      'custoConverted' => 'Custo (Converted)',
      'custoUSD' => 'Custo (Convertido)',
      'custoUSDCurrency' => 'Custo (Convertido) (Currency)',
      'custoUSDConverted' => 'Custo (Convertido) (Converted)',
      'documents' => 'Documentos',
      'endUser' => 'Cliente Final',
      'partner' => 'Parceiro Executor',
      'productBrand' => 'Fabricante',
      'serviceProvider' => 'Provedor de Serviço',
      'servicesBillings' => 'Faturamentos',
      'servicesVersionses' => 'Service Versions',
      'dollarAmount' => 'Cotação do Dólar',
      'endDate' => 'Data de Conclusão',
      'endUserEmail' => 'Cliente Final (E-mail)',
      'faturamento' => 'Faturamento',
      'followup' => 'Follow Up',
      'installationCost' => 'Custo de Instalação',
      'installationCostCurrency' => 'Custo de Instalação (Currency)',
      'installationCostConverted' => 'Custo de Instalação (Converted)',
      'serviceType' => 'Tipo de Serviço',
      'installationMarkupPercentage' => 'Markup Instalação / Implementação (%)',
      'installationRevenue' => 'Receita em Instalação / Implementação',
      'installationRevenueCurrency' => 'Receita em Instalação / Implementação (Currency)',
      'installationRevenueConverted' => 'Receita em Instalação / Implementação (Converted)',
      'margem' => 'Margem (%)',
      'mso' => 'MSO',
      'nfParceiro' => 'NF Parceiro',
      'nfSYNNEX' => 'NF TD SYNNEX',
      'netRevenueCloud' => 'Receita Líquida (Com Impostos)',
      'netRevenueCloudCurrency' => 'Receita Líquida (Com Impostos) (Currency)',
      'netRevenueCloudConverted' => 'Receita Líquida (Com Impostos) (Converted)',
      'notes' => 'Observações',
      'number' => 'Número',
      'opportunityType' => 'Tipo de Oportunidade',
      'order' => 'Order',
      'pO' => 'PO',
      'pOID' => 'PO ID',
      'partnerCommission' => 'Comissão da Revenda',
      'partnerCommissionCurrency' => 'Comissão da Revenda (Currency)',
      'partnerCommissionConverted' => 'Comissão da Revenda (Converted)',
      'operadoraRevendaEmail' => 'Operadora / Revenda (Email)',
      'partnerNumber' => 'Partner Number',
      'projectType' => 'Tipo do Projeto',
      'receita' => 'Receita',
      'receitaCurrency' => 'Receita (Currency)',
      'receitaConverted' => 'Receita (Converted)',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'sellingDate' => 'Data de Venda',
      'sendingDate' => 'Data de Envio',
      'serviceActivity' => 'Atividade do Serviço',
      'serviceAmountTotal' => 'Valor Bruto do Serviço (BRL)',
      'serviceAmountTotalCurrency' => 'Valor Bruto do Serviço (BRL) (Currency)',
      'serviceAmountTotalConverted' => 'Valor Bruto do Serviço (BRL) (Converted)',
      'serviceAmountTotalUSD' => 'Valor Bruto do Serviço (USD)',
      'serviceAmountTotalUSDCurrency' => 'Valor Bruto do Serviço (USD) (Currency)',
      'serviceAmountTotalUSDConverted' => 'Valor Bruto do Serviço (USD) (Converted)',
      'servicesVersions' => 'Service Versions',
      'servicePartnerValue' => 'Valor do Parceiro de Serviço',
      'servicePartnerValueCurrency' => 'Valor do Parceiro de Serviço (Currency)',
      'servicePartnerValueConverted' => 'Valor do Parceiro de Serviço (Converted)',
      'serviceProviderVarchar' => 'Prestador de Serviços',
      'solicitationDate' => 'Data da Solicitação do Serviço',
      'startDate' => 'Data de Início',
      'supportCost' => 'Custo de Suporte',
      'supportCostCurrency' => 'Custo de Suporte (Currency)',
      'supportCostConverted' => 'Custo de Suporte (Converted)',
      'supportMarkupPercentage' => 'Markup Suporte (%)',
      'supportRevenue' => 'Receita em Suporte',
      'supportRevenueCurrency' => 'Receita em Suporte (Currency)',
      'supportRevenueConverted' => 'Receita em Suporte (Converted)',
      'ticket' => 'Ticket',
      'accountType' => 'Tipo de Parceiro',
      'totalCost' => 'Custo Total',
      'totalCostCurrency' => 'Custo Total (Currency)',
      'totalCostConverted' => 'Custo Total (Converted)',
      'totalRevenue' => 'Receita Total',
      'totalRevenueCurrency' => 'Receita Total (Currency)',
      'totalRevenueConverted' => 'Receita Total (Converted)',
      'type' => 'Serviços Prestados',
      'update' => 'Update',
      'version' => 'Versão',
      'winProbability' => 'Probabilidade de Fechamento',
      'tax' => 'Impostos (%)',
      'proposalDueDate' => 'Data Limite (Envio da Proposta)',
      'createVersion' => 'Criar Versão',
      'requester' => 'Solicitante',
      'createBilling' => 'Criar Faturamento',
      'billing' => 'Faturamento'
    ],
    'labels' => [
      'Add Item' => 'Add Item',
      'Add Products' => 'Add Products',
      'Create Service' => 'Criar Oportunidade de Serviço',
      'Items' => 'Items',
      'Select Product' => 'Select Product'
    ],
    'links' => [
      'invoices' => 'Invoices',
      'items' => 'Items',
      'quotes' => 'Quotes',
      'salesOrders' => 'Sales Orders',
      'documents' => 'Documentos',
      'endUser' => 'Cliente Final',
      'partner' => 'Parceiro Executor',
      'productBrand' => 'Fabricante',
      'serviceProvider' => 'Provedor de Serviço',
      'servicesBillings' => 'Faturamentos',
      'servicesVersionses' => 'Service Versions',
      'servicesVersions' => 'Service Versions'
    ],
    'options' => [
      'billingSituation' => [
        'Aguardando para Faturar' => 'Aguardando para Faturar',
        'Em Faturamento' => 'Em Faturamento',
        'Faturado' => 'Faturado',
        'Serviço Free' => 'Free'
      ],
      'billingType' => [
        '' => '',
        'Cliente' => 'Cliente',
        'Revenda' => 'Revenda'
      ],
      'stage' => [
        '' => '',
        'Pendente de informação' => 'Pendente de informação',
        'Enviada' => 'Enviada',
        'Possível' => 'Em negociação',
        'Revisado' => 'Revisado',
        'Em vias de fechamento' => 'Em vias de fechamento',
        'Ganho' => 'Ganho',
        'Perdido / Cancelado' => 'Perdido / Cancelado',
        'Criação Indevida' => 'Criação Indevida',
        'Ainda temos chance' => 'Ainda temos chance',
        'Faturado' => 'Faturado',
        'A faturar' => 'A faturar',
        'Aguardando Checklist' => 'Aguardando Checklist',
        'Pré Vendas' => 'Pré Vendas',
        'Serviço WIP' => 'Serviço WIP',
        'Serviço Finalizado' => 'Serviço Finalizado'
      ],
      'faturamento' => [
        '' => '',
        'Faturado' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando Pedido' => 'Aguardando Pedido',
        'Em negociação' => 'Em negociação'
      ],
      'serviceType' => [
        '' => '',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Serviços Cloud' => 'Serviços Cloud',
        'Treinamento' => 'Treinamentos'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento (Venda)' => 'Recebimento (Venda)'
      ],
      'projectType' => [
        '' => '',
        'Partner to Partner' => 'Partner to Partner',
        'Ficha de Oferta' => 'Ficha de Oferta',
        'MOSP para CSP' => 'MOSP para CSP'
      ],
      'serviceActivity' => [
        '' => '',
        'Serviço de DNS' => 'Serviço de DNS',
        'Migração de recursos do Azure entre Tenants' => 'Migração de recursos do Azure entre Tenants',
        'Migração de VM' => 'Migração de VM',
        'Suporte' => 'Suporte',
        'Implementação de Serviço de DLP' => 'Implementação de Serviço de DLP',
        'Implementação' => 'Implementação'
      ],
      'type' => [
        'Cloud' => 'Cloud',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Treinamento' => 'Treinamento',
        'Suporte' => 'Suporte',
        'Educação' => 'Educação'
      ],
      'winProbability' => [
        0 => '0',
        10 => '10%',
        20 => '20%',
        40 => '40%',
        80 => '80%',
        100 => '100%'
      ]
    ],
    'presetFilters' => [],
    'tooltips' => [
      'installationMarkupPercentage' => 'Valores entre 0-100.'
    ]
  ],
  'ServiceItem' => [
    'fields' => [
      'amount' => 'Amount',
      'amountConverted' => 'Amount (Converted)',
      'amountCurrency' => 'Amount (Currency)',
      'description' => 'Description',
      'name' => 'Name',
      'order' => 'Line Number',
      'product' => 'Product',
      'qty' => 'Qty',
      'quantity' => 'Quantity',
      'quantityInt' => 'Quantity (Int)',
      'service' => 'Service',
      'unitPrice' => 'Unit Price',
      'unitPriceConverted' => 'Unit Price (Converted)',
      'unitPriceCurrency' => 'Unit Price (Currency)'
    ],
    'labels' => [
      'Services' => 'Services'
    ],
    'links' => [
      'product' => 'Product',
      'service' => 'Service'
    ]
  ],
  'Project' => [
    'labels' => [
      'Create Project' => 'Create Project',
      'Boards' => 'Boards',
      'Roles' => 'Roles',
      'Select Role' => 'Select Role',
      'Settings' => 'Settings',
      'Show Completed' => 'Show Completed',
      'Clone' => 'Clone'
    ],
    'fields' => [
      'board' => 'Board',
      'status' => 'Status',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'account' => 'Account',
      'activeGroup' => 'Active Group',
      'members' => 'Members',
      'memberRole' => 'Member Role',
      'ganttView' => 'Gantt View'
    ],
    'links' => [
      'board' => 'Board',
      'tasks' => 'Tasks',
      'groups' => 'Groups',
      'activeGroup' => 'Active Group',
      'account' => 'Account',
      'meetings' => 'Meetings',
      'calls' => 'Calls',
      'emails' => 'Emails',
      'members' => 'Members',
      'memberRole' => 'Member Role'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Active' => 'Active',
        'Closed' => 'Closed',
        'Paused' => 'Paused',
        'Canceled' => 'Canceled'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'closed' => 'Closed'
    ],
    'boolFilters' => [
      'own' => 'Owned',
      'member' => 'Participating In'
    ],
    'messages' => [
      'cloned' => 'Cloned project [{name}]({link}) has been created.',
      'ganttViewDisabled' => 'Gantt view is disabled for the project.',
      'holdCtrlToSelectMultiple' => 'Hold CTRL to select multiple tasks',
      'cannotRemoveUsedInTask' => 'Cannot remove the project as there are related tasks.'
    ],
    'detailViewModes' => [
      'plan' => 'Plan',
      'board' => 'Board',
      'gantt' => 'Gantt'
    ],
    'tabs' => [
      'stream' => 'Stream',
      'team' => 'Team',
      'tasks' => 'Tasks'
    ],
    'otherPanels' => [
      'include' => 'Include'
    ],
    'otherFields' => [
      'role' => 'Role',
      'withTasks' => 'Tasks',
      'withMembers' => 'Members',
      'withOwners' => 'Task Owners',
      'withAssignees' => 'Task Assignees',
      'withAttachments' => 'Attachments'
    ],
    'actions' => [
      'changeRole' => 'Change Role'
    ],
    'ganttScales' => [
      'week' => 'Week',
      'twoWeeks' => 'Two Weeks',
      'month' => 'Month',
      'twoMonths' => 'Two Months',
      'sixMonths' => 'Six Months',
      'year' => 'Year'
    ]
  ],
  'ProjectBoard' => [
    'labels' => [
      'Create ProjectBoard' => 'Create Board'
    ],
    'fields' => [
      'status' => 'Status'
    ],
    'links' => [
      'columns' => 'Stages',
      'projects' => 'Projects'
    ],
    'options' => [
      'status' => [
        'Draft' => 'Draft',
        'Active' => 'Active',
        'Inactive' => 'Inactive'
      ]
    ],
    'messages' => [
      'cannotRemoveUsed' => 'Cannot remove the board as it\'s used in a project.',
      'cannotRemoveUsedInTask' => 'Cannot remove the board as there are tasks that use it.'
    ],
    'presetFilters' => [
      'actual' => 'Open'
    ]
  ],
  'ProjectColumn' => [
    'labels' => [
      'Create ProjectColumn' => 'Create Stage',
      'Move Up' => 'Move Up',
      'Move Down' => 'Move Down'
    ],
    'fields' => [
      'board' => 'Board',
      'order' => 'Order',
      'mappedStatus' => 'Mapped Status'
    ],
    'links' => [
      'board' => 'board',
      'tasks' => 'Tasks'
    ],
    'options' => [
      'name' => [
        'To Do' => 'To Do',
        'In Progress' => 'In Progress',
        'Review' => 'Review',
        'Done' => 'Done'
      ]
    ],
    'messages' => [
      'cannotRemoveUsedInTask' => 'Cannot remove the column as there are tasks that use it.'
    ]
  ],
  'ProjectGroup' => [
    'labels' => [
      'Create ProjectGroup' => 'Create Group',
      'Edit Group' => 'Edit Group',
      'Remove Group' => 'Remove Group',
      'Reorder Groups' => 'Reorder Groups'
    ],
    'fields' => [
      'project' => 'Project',
      'order' => 'Order',
      'color' => 'Color',
      'taskPlacement' => 'New Task Placement'
    ],
    'links' => [
      'project' => 'Project',
      'tasks' => 'Tasks'
    ],
    'strings' => [
      'defaultGroupName' => 'Group'
    ],
    'messages' => [
      'cannotRemoveUsedInTask' => 'Cannot remove a group with tasks in it.'
    ]
  ],
  'ProjectRole' => [
    'labels' => [
      'Create ProjectRole' => 'Create Project Role',
      'Task' => 'Task'
    ],
    'fields' => [
      'taskCreate' => 'Task Create',
      'taskRead' => 'Task Read',
      'taskStream' => 'Task Stream',
      'taskEdit' => 'Task Edit',
      'taskColumnEdit' => 'Task Stage Edit',
      'taskDelete' => 'Task Delete',
      'taskAssignment' => 'Task Assignment',
      'create' => 'Create',
      'read' => 'Read',
      'stream' => 'Stream',
      'edit' => 'Edit',
      'columnEdit' => 'Stage Edit',
      'delete' => 'Delete',
      'cancel' => 'Cancel',
      'assignment' => 'Assignment'
    ],
    'options' => [
      'levelList' => [
        'yes' => 'yes',
        'assigned' => 'assigned',
        'own' => 'own',
        'no' => 'no'
      ]
    ]
  ],
  'ProjectTask' => [
    'labels' => [
      'Create ProjectTask' => 'Create Task',
      'Create Milestone' => 'Create Milestone',
      'Complete' => 'Complete',
      'Cancel' => 'Cancel',
      'Change Column' => 'Change Stage',
      'Moving' => 'Moving',
      'Moved to Group' => 'Moved to Group',
      'Moved' => 'Moved',
      'Add Dependency' => 'Add Dependency',
      'Remove Dependency' => 'Remove Dependency',
      'Sub-Task' => 'Sub-Task',
      'Completed' => 'Completed'
    ],
    'fields' => [
      'project' => 'Project',
      'fromTasks' => 'Dependent On',
      'parentTask' => 'Parent Task',
      'subTasks' => 'Sub-Tasks',
      'dependencyTaskType' => 'Dependency Type',
      'group' => 'Group',
      'groupColor' => 'Group Color',
      'groupOrder' => 'Group Order',
      'status' => 'Status',
      'column' => 'Stage',
      'priority' => 'Priority',
      'order' => 'Order',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'points' => 'Points',
      'hours' => 'Hours',
      'attachments' => 'Attachments',
      'timeline' => 'Timeline',
      'owner' => 'Owner',
      'combinedOrder' => 'Combined Order',
      'boardOrder' => 'Board Order',
      'type' => 'Type',
      'completedAt' => 'Completed At',
      'assignedUser' => 'Assignee',
      'actualSubTaskCount' => 'Number of actual sub-tasks',
      'cTeam' => 'Team',
      'cCountry' => 'País',
      'cTag' => 'Tag'
    ],
    'links' => [
      'project' => 'Project',
      'fromTasks' => 'From Tasks',
      'toTasks' => 'To Tasks',
      'parentTask' => 'Parent Task',
      'subTasks' => 'Sub-Tasks',
      'group' => 'Group',
      'column' => 'Stage',
      'owner' => 'Owner'
    ],
    'options' => [
      'status' => [
        'Not Started' => 'Not Started',
        'Started' => 'Started',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Deferred' => 'Deferred'
      ],
      'priority' => [
        'Low' => 'Low',
        'Normal' => 'Normal',
        'High' => 'High',
        'Urgent' => 'Urgent'
      ],
      'dependencyTaskType' => [
        'fs' => 'Finish to Start',
        'ss' => 'Start to Start',
        'ff' => 'Finish to Finish',
        'sf' => 'Start to Finish'
      ],
      'dependencyTaskTypeShort' => [
        'fs' => 'FS',
        'ss' => 'SS',
        'ff' => 'FF',
        'sf' => 'SF'
      ],
      'type' => [
        'Task' => 'Task',
        'Milestone' => 'Milestone'
      ],
      'cTeam' => [
        'Microsoft' => 'Microsoft',
        'AWS' => 'AWS',
        'Google' => 'Google'
      ],
      'cCountry' => [
        'Brasil' => 'Brasil',
        'MCA' => 'MCA'
      ],
      'cTag' => [
        'Ready for Test' => 'Ready for Test',
        'Ready for Deploy' => 'Ready for Deploy',
        'Blocked' => 'Bloqueado',
        'Ready to deploy' => 'Ready to deploy',
        'Ready to test' => 'Ready to test',
        'Recurring' => 'Recorrente'
      ]
    ],
    'presetFilters' => [
      'actual' => 'Open',
      'completed' => 'Completed',
      'actualParent' => 'Open Parent-Level',
      'completedParent' => 'Completed Parent-Level',
      'planParent' => 'Plan Parent-Level',
      'todays' => 'Today\'s',
      'overdue' => 'Overdue'
    ],
    'boolFilters' => [
      'own' => 'Owned'
    ],
    'actions' => [
      'complete' => 'Complete',
      'changeColumn' => 'Change Stage',
      'moveToTop' => 'Move to Top',
      'moveToBottom' => 'Move to Bottom'
    ],
    'massActions' => [
      'complete' => 'Complete'
    ],
    'messages' => [
      'movedToTop' => 'Moved to Top',
      'movedToBottom' => 'Moved to Bottom',
      'massCompleteDone' => '{count} tasks completed',
      'massCompleteConfirmation' => 'Are you sure you want to complete selected tasks?',
      'noEditAccess' => 'No edit access.',
      'cancelConfirmation' => 'Are you sure you want to cancel the task?',
      'cannotCreateSubTaskInCompletedTask' => 'Cannot create a sub-task in a completed task.',
      'cannotCreateSubTaskInCanceledTask' => 'Cannot create a sub-task in a canceled task.',
      'cannotChangeSubTaskGroup' => 'A sub-task\'s group cannot be changed without a parent task.',
      'cannotDeleteSubTaskNotCompleted' => 'Cannot delete a task with non-completed sub-tasks.',
      'cannotCompleteSubTaskNotCompleted' => 'Cannot complete a task without completing all sub-tasks.',
      'cannotCompleteAlreadyCompleted' => 'The task is already completed.',
      'cannotCompleteAlreadyCanceled' => 'The task is already canceled.',
      'cannotCompleteFromTaskNotStarted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **started** before this task can be completed.',
      'cannotCompleteFromTaskNotCompleted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **completed** before this task can be completed.',
      'cannotStartFromTaskNotStarted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **started** before this task can be started.',
      'cannotStartFromTaskNotCompleted' => '[{fromName}](#ProjectTask/view/{fromId}) needs to be **completed** before this task can be started.'
    ],
    'strings' => [
      'hasSubTasks' => 'Has Sub-Tasks'
    ]
  ],
  'AWS' => [
    'fields' => [
      'tier' => 'Tier',
      'account' => 'Account',
      'productBrand' => 'Product Brand',
      'sumSelect' => 'SumSelect',
      'partnerType' => 'Partner Type',
      'competency' => 'Competency',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'accountCountry' => 'account Country',
      'city' => 'Ciudad',
      'region' => 'Region',
      'country' => 'Pais',
      'levelCheck' => 'Level Check',
      'accounts' => '-',
      'aWSAccreditedProfessionalsBussines' => 'AWS Accredited Professionals - Business',
      'aWSAccreditedProfessionalsTechnical' => 'AWS Accredited Professionals - Technical',
      'aWSFoundationalCertifiedIndividuals' => 'AWS Foundational Certified individuals',
      'aWSTechnicalCertifiedIndividuals' => 'AWS Technical Certified individuals',
      'aWSTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'aWSTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'launchedOppsCount' => 'Launched Opps Count',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'account1' => 'Accounts',
      'specialities' => 'Especialidades',
      'countCompetency' => 'Conteo de Competencias',
      'countEspecialidades' => 'Conteo de Especialidades',
      'lastupdate' => 'AVT Report',
      'awsVersions' => 'AWS Versions',
      'technicalprogram' => 'Technical Program Validations',
      'opportunities' => 'Opportunities',
      'update' => 'Create Version',
      'accountsAWS' => 'Cuentas AWS',
      'levelCheckCustomerSuccessThinkBig' => 'Level Check - Customer Success (Think Big)',
      'levelCheckExperienceThinkBig' => 'Level Check - Experience (Think Big)',
      'levelCheckKnowledgeThinkBig' => 'Level Check - Knowledge (Think Big)',
      'levelCheckThinkBig' => 'Level Check (Think Big)',
      'levelCheckCustomerSuccess' => 'LevelCheck -  Customer Success',
      'levelCheckExperience' => 'LevelCheck - Experience',
      'levelCheckKnowledge' => 'LevelCheck - Knowledge',
      'sumselectCustomerSuccess' => 'Sumselect - Customer Success',
      'sumselectExperience' => 'Sumselect - Experience',
      'sumselectKnowledge' => 'Sumselect - Knowledge',
      'dataAnalytics' => 'Data & Analytics',
      'oracle' => 'Oracle',
      'devOps' => 'DevOps',
      'security' => 'Security',
      'networkingConsultingCompetency' => 'Networking Consulting Competency',
      'government' => 'Government',
      'education' => 'Education',
      'sAP' => 'SAP',
      'financialServices' => 'Financial Services',
      'storage' => 'Storage',
      'migration' => 'Migration',
      'machineLearningConsultingPartner' => 'Machine Learning Consulting Partner',
      'publicSafetyServicesCompetency' => 'Public Safety Services Competency',
      'cloudOperationsServicesCompetency' => 'Cloud Operations Services Competency',
      'travelAndHospitality' => 'Travel and Hospitality',
      'resilienceServicesCompetency' => 'Resilience Services Competency',
      'level1MSSP' => 'Level 1 MSSP',
      'retail' => 'Retail',
      'advertisingAndMarketingTechnologyServicesCompetency' => 'Advertising and Marketing Technology Services Competency',
      'ioTConsulting' => 'IoT Consulting',
      'microsoftWorkloads' => 'Microsoft Workloads',
      'nonprofit' => 'Nonprofit',
      'migrationAndModernizationISVPartner' => 'Migration and Modernization ISV Partner',
      'digitalWorkplace' => 'Digital Workplace',
      'smallAndMediumBusinessServicesCompetency' => 'Small and Medium Business Services Competency',
      'amazonEC2ForWindowsServer' => 'Amazon EC2 for Windows Server',
      'amazonCloudFront' => 'Amazon CloudFront',
      'amazonEKSDelivery' => 'Amazon EKS Delivery',
      'amazonRedshift' => 'Amazon Redshift',
      'amazonRDS' => 'Amazon RDS',
      'aWSWAF' => 'AWS WAF',
      'amazonAPIGateway' => 'Amazon API Gateway',
      'aWSGlueDelivery' => 'AWS Glue Delivery',
      'amazonEC2SystemsManager' => 'Amazon EC2 Systems Manager',
      'aWSControlTowerDelivery' => 'AWS Control Tower Delivery',
      'amazonEMR' => 'Amazon EMR',
      'amazonQuickSight' => 'Amazon QuickSight',
      'aWSCloudFormation' => 'AWS CloudFormation',
      'amazonConnect' => 'Amazon Connect',
      'aWSLambda' => 'AWS Lambda',
      'aWSServerMigrationService' => 'AWS Server Migration Service',
      'amazonKinesis' => 'Amazon Kinesis',
      'aWSConfig' => 'AWS Config',
      'amazonDynamoDB' => 'Amazon DynamoDB',
      'aWSDirectConnect' => 'AWS Direct Connect',
      'aWSDatabaseMigrationService' => 'AWS Database Migration Service',
      'noLevel' => 'Without level',
      'accountsdSA' => 'Tiene DSA',
      'sPMSID' => 'SPMS ID',
      'sPMSIDCountry' => 'SPMS ID Pais',
      'aWSGravitonDelivery' => 'AWS Graviton Delivery',
      'amazonECSDelivery' => 'Amazon ECS Delivery',
      'amazonMSKDelivery' => 'Amazon MSK Delivery',
      'amazonOpenSearchServiceDelivery' => 'Amazon OpenSearch Service Delivery',
      'saaS' => 'SaaS',
      'mediaEntertainmentServicesCompetency' => 'Media & Entertainment Services Competency',
      'generativeAIServicesCompetency' => 'Generative AI Services Competency',
      'consumerGoodsServicesCompetency' => 'Consumer Goods Services Competency',
      'aWSTransferFamilyDelivery' => 'AWS Transfer Family Delivery',
      'segment' => 'Segmento',
      'focus' => 'Focus',
      'pais' => 'Pais',
      'createdAt' => 'Creado en',
      'createdBy' => 'Creado por',
      'description' => 'Descripción',
      'modifiedAt' => 'Modificado en',
      'modifiedBy' => 'Modificado por',
      'name' => 'Nombre',
      'teams' => 'Teams',
      'assignedUser' => 'Atribuido al usuário'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'productBrand' => 'Product Brand',
      'accountCountry' => 'account Country',
      'accounts' => 'Cuentas',
      'account1' => 'Accounts',
      'awsVersions' => 'AWS Versions',
      'opportunities' => 'Opportunities',
      'accountsAWS' => 'Cuentas AWS'
    ],
    'labels' => [
      'Create AWS' => 'Criar AWS'
    ],
    'options' => [
      'tier' => [
        '' => '',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier',
        'Registered' => 'Registered',
        'Sin Nivel' => 'Sin Nivel'
      ],
      'competency' => [
        'Vacio' => 'Vacio',
        'Data & Analytics' => 'Data & Analytics',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency',
        'Cloud Operations Services Competency' => 'Cloud Operations Services Competency',
        'Travel and Hospitality' => 'Travel and Hospitality',
        'Resilience Services Competency' => 'Resilience Services Competency',
        'Level 1 MSSP' => 'Level 1 MSSP',
        'Retail' => 'Retail',
        'Advertising and Marketing Technology Services Competency' => 'Advertising and Marketing Technology Services Competency',
        'IoT Consulting' => 'IoT Consulting',
        'Microsoft Workloads' => 'Microsoft Workloads',
        'Nonprofit' => 'Nonprofit',
        'Migration and Modernization ISV Partner' => 'Migration and Modernization ISV Partner',
        'Digital Workplace' => 'Digital Workplace',
        'Small and Medium Business Services Competency' => 'Small and Medium Business Services Competency',
        'SaaS' => 'SaaS',
        'Media & Entertainment Services Competency' => 'Media & Entertainment Services Competency',
        'Generative AI Services Competency' => 'Generative AI Services Competency',
        'Consumer Goods Services Competency' => 'Consumer Goods Services Competency',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'levelCheck' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service',
        'AWS Graviton Delivery' => 'AWS Graviton Delivery',
        'AWS Transfer Family Delivery' => 'AWS Transfer Family Delivery',
        ' Amazon ECS Delivery' => ' Amazon ECS Delivery',
        'Amazon MSK Delivery' => 'Amazon MSK Delivery',
        'Amazon OpenSearch Service Delivery' => 'Amazon OpenSearch Service Delivery'
      ],
      'levelCheckCustomerSuccessThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckExperienceThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckKnowledgeThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckThinkBig' => [
        'Think Big for Select' => 'Think Big for Select',
        'Think Big for Advanced' => 'Think Big for Advanced'
      ],
      'levelCheckCustomerSuccess' => [
        'Think Big for Advanced' => 'Think Big for Advanced',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier',
        'Ready to Select' => 'Ready to Select'
      ],
      'levelCheckExperience' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premium' => 'Ready to Premium'
      ],
      'levelCheckKnowledge' => [
        'Ready to Select' => 'Ready to Select',
        'Ready to Advanced' => 'Ready to Advanced',
        'Ready to Premier' => 'Ready to Premier'
      ],
      'segment' => [
        '' => '',
        'PS' => 'PS',
        'CS' => 'CS'
      ],
      'region' => [
        'SSA' => 'SSA',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'LAC' => 'LAC',
        'AMERICAS ' => 'AMERICAS ',
        'LMIA' => 'LMIA',
        'APAC' => 'APAC',
        'Mexico' => 'Mexico',
        'Brasil' => 'Brasil'
      ],
      'pais' => [
        'Vacio' => 'Vacio',
        'Argentina' => 'Argentina',
        'Brasil' => 'Brasil',
        'Chile ' => 'Chile ',
        'Colombia ' => 'Colombia ',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador ' => 'Ecuador ',
        'El Salvador' => 'El Salvador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico ' => 'Mexico ',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela'
      ]
    ],
    'tooltips' => [
      'update' => '(PT-BR) Após selecionar esta opção, clique em "Salvar" ou "Atualizar" e atualize a sua página (F5) para que a versão apareça na aba de registro de versões.

(Español) Después de seleccionar esta opción, haga clic en "Guardar" o "Actualizar" y actualice su página (F5) para que la versión aparezca en la pestaña de registro de versiones.',
      'noLevel' => '(English) After selecting this option, click "Save" to update the level.',
      'accountsdSA' => '(PT-BR) Selecione se a conta tem DSA

(Español) Seleccione si la cuenta tiene DSA

(English) Select if the account has DSA',
      'levelCheck' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckCustomerSuccess' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckExperience' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.',
      'levelCheckKnowledge' => '(PT-BR) Verificação para saber se você está pronto para avançar para o próximo nível.

(Español) Verificación para saber si esta listo para avanzar de nivel.

(English) Check to see if you are ready to advance to the next level.'
    ]
  ],
  'AWSVersions' => [
    'links' => [
      'aws' => 'AWS Partner Program'
    ],
    'labels' => [
      'Create AWSVersions' => 'Criar AWS Versions'
    ],
    'fields' => [
      'awsAccreditedProfessionalsBussines' => 'AWS Accredited Professionals - Business',
      'awsAccreditedProfessionalsTechnical' => 'AWS Accredited Professionals - Technical',
      'awsFoundationalCertifiedIndividuals' => 'AWS Foundational Certified individuals',
      'awsTechnicalCertifiedIndividuals' => 'AWS Technical Certified individuals',
      'awsTechnicalCertifiedIndividualsAssociate' => 'Technical Certified Individuals - Associate',
      'awsTechnicalCertifiedIndividualsProOrSpecialty' => 'Technical Certified Individuals - Pro or Specialt',
      'competency' => 'Competency',
      'countCompetency' => 'Conteo de Competencias',
      'countEspecialidades' => 'Conteo de Especialidades',
      'customerSatisfactionResponses' => 'Customer Satisfaction Responses',
      'lastupdate' => 'AVT Report',
      'launchedOppsAmount' => 'Launched Opps Amount',
      'launchedOppsAmountCurrency' => 'Launched Opps Amount (Currency)',
      'launchedOppsAmountConverted' => 'Launched Opps Amount (Converted)',
      'launchedOppsCount' => 'Launched Opps Count',
      'partnerBusinessPlan' => 'Partner Business Plan',
      'partnerType' => 'Partner Type',
      'publiclyReferenceableCustomers' => 'Publicly Referenceable Customers',
      'tier' => 'Tier',
      'specialities' => 'Especialidades',
      'aws' => 'AWS Partner Program',
      'technicalprogram' => 'Technical Program Validations',
      'dSA' => 'DSA',
      'dataCompetencias' => 'Date Skills',
      'dataEspecialidades' => 'Date Specialties',
      'sPMSID' => 'SPMS ID'
    ],
    'options' => [
      'competency' => [
        'Data & Analytics' => 'Data & Analytics',
        'Oracle' => 'Oracle',
        'DevOps' => 'DevOps',
        'Security' => 'Security',
        'Networking Consulting Competency' => 'Networking Consulting Competency',
        'Government' => 'Government',
        'Education' => 'Education',
        'SAP' => 'SAP',
        'Financial Services' => 'Financial Services',
        'Storage' => 'Storage',
        'Migration' => 'Migration',
        'Machine Learning Consulting Partner' => 'Machine Learning Consulting Partner',
        'Public Safety Services Competency' => 'Public Safety Services Competency'
      ],
      'partnerBusinessPlan' => [
        0 => '0',
        1 => '1'
      ],
      'tier' => [
        '' => '',
        'Registered' => 'Registered',
        'Select' => 'Select',
        'Advanced' => 'Advanced',
        'Premier' => 'Premier'
      ],
      'specialities' => [
        'Amazon EC2 for Windows Server' => 'Amazon EC2 for Windows Server',
        'Amazon CloudFront' => 'Amazon CloudFront',
        'Amazon EKS Delivery' => 'Amazon EKS Delivery',
        'Amazon Redshift' => 'Amazon Redshift',
        'Amazon RDS' => 'Amazon RDS',
        'AWS WAF' => 'AWS WAF',
        'Amazon API Gateway' => 'Amazon API Gateway',
        'AWS Glue Delivery' => 'AWS Glue Delivery',
        'Amazon EC2 Systems Manager' => 'Amazon EC2 Systems Manager',
        'AWS Control Tower Delivery' => 'AWS Control Tower Delivery',
        'Amazon EMR' => 'Amazon EMR',
        'Amazon QuickSight' => 'Amazon QuickSight',
        'AWS CloudFormation' => 'AWS CloudFormation',
        'Amazon Connect' => 'Amazon Connect',
        'AWS Lambda' => 'AWS Lambda',
        'AWS Server Migration Service' => 'AWS Server Migration Service',
        'Amazon Kinesis' => 'Amazon Kinesis',
        'AWS Config' => 'AWS Config',
        'Amazon DynamoDB' => 'Amazon DynamoDB',
        'AWS Direct Connect' => 'AWS Direct Connect',
        'AWS Database Migration Service' => 'AWS Database Migration Service'
      ],
      'dSA' => [
        'Si' => 'Si'
      ]
    ]
  ],
  'AccountContent' => [
    'fields' => [
      'account' => 'Account',
      'sourceContent' => 'Source Content'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create AccountContent' => 'Criar Account content'
    ],
    'options' => [
      'sourceContent' => [
        '' => '',
        'Renewals' => 'Renewals',
        'AI Content' => 'AI Content'
      ]
    ]
  ],
  'AccountVBM' => [
    'fields' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'contracts' => 'Contracts',
      'iSV' => 'ISV',
      'msftProgram' => 'Microsoft Program',
      'unity' => 'Unity',
      'reseller' => 'Reseller',
      'country' => 'Country',
      'paises' => 'País'
    ],
    'links' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'contracts' => 'Contracts'
    ],
    'labels' => [
      'Create AccountVBM' => 'Criar Account VBM'
    ],
    'options' => [
      'iSV' => [
        '' => 'No',
        'Yes' => 'Yes'
      ],
      'msftProgram' => [
        '' => 'Not apply',
        'CSU' => 'CSU',
        'CSU y TCO' => 'CSU y TCO',
        'CSU & TCO' => 'CSU & TCO'
      ],
      'unity' => [
        '' => '',
        'Velocity' => 'Velocity',
        'Worth' => 'Worth',
        'Telco' => 'Telco'
      ]
    ]
  ],
  'Analytics' => [
    'fields' => [
      'url' => 'Url',
      'contacts' => 'Contacts',
      'name' => 'Name',
      'appId' => 'App ID',
      'clientId' => 'Client Id',
      'clientsecret' => 'Client Secret',
      'params' => 'Params',
      'ratio' => 'Aspect Ratio',
      'reportId' => 'Report Id',
      'rocket' => 'Rocket',
      'workspace' => 'Workspace',
      'iframerate' => 'Iframe Rate',
      'embedParamCheck' => 'Embed Parameters Check',
      'description' => 'Descrição'
    ],
    'links' => [
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Analytics' => 'Criar Analytics'
    ]
  ],
  'AssesmentCompany' => [
    'fields' => [
      'billingAddress' => 'Endereço de Cobrança',
      'shippingAddress' => 'Endereço de Entrega',
      'website' => 'Website',
      'domain' => 'Domain',
      'assesmentStep' => 'AssesmentStep',
      'language' => 'Language'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas'
    ],
    'labels' => [
      'Create AssesmentCompany' => 'Criar AssesmentCompany'
    ],
    'options' => [
      'assesmentStep' => [
        '' => '',
        'organizational' => 'organizational',
        'financial' => 'financial',
        'strategy' => 'strategy',
        'technology' => 'technology',
        'salesandmarketing' => 'salesandmarketing',
        'contact' => 'contact'
      ]
    ]
  ],
  'Aws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Aws' => 'Criar AWS'
    ]
  ],
  'BillingVendor' => [
    'fields' => [
      'source' => 'Source',
      'customerID' => 'CustomerID',
      'country' => 'Country',
      'invoiceVendor' => 'InvoiceVendor',
      'issuedate' => 'Issue_date',
      'customerCode' => 'CustomerCode',
      'customer' => 'Customer',
      'taxId' => 'TaxId',
      'euMarkup' => 'EuMarkup',
      'netValueNoTax' => 'NetValueNoTax',
      'netValueUsdNoTax' => 'NetValueUsdNoTax',
      'netValue' => 'NetValue',
      'period' => 'Period',
      'invoiceVendorStatus' => 'InvoiceVendorStatus',
      'netValuUsd' => 'NetValuUsd',
      'productMarkup' => 'ProductMarkup',
      'partNumber' => 'PartNumber',
      'taxRate' => 'TaxRate',
      'discount' => 'Discount',
      'invoiceId' => 'InvoiceId',
      'distributorDiscount' => 'DistributorDiscount',
      'tier2MpnId' => 'Tier2MpnId',
      'totalResellerUsd' => 'TotalResellerUsd',
      'resellerCredit' => 'ResellerCredit',
      'commissionPercentage' => 'CommissionPercentage',
      'commission' => 'Commission',
      'commissionUsd' => 'CommissionUsd',
      'reseller' => 'Reseller',
      'resellerTaxId' => 'ResellerTaxId',
      'contractNumber' => 'ContractNumber',
      'subscriptionID' => 'SubscriptionID',
      'customerTenantID' => 'CustomerTenantID',
      'resellerMarkup' => 'ResellerMarkup',
      'resellerDiscount' => 'ResellerDiscount',
      'increase' => 'Increase',
      'customerPhone' => 'CustomerPhone',
      'customerEmail1' => 'CustomerEmail1',
      'customerEmail2' => 'CustomerEmail2',
      'resellerPhone' => 'ResellerPhone',
      'resellerEmail1' => 'ResellerEmail1',
      'resellerEmail2' => 'ResellerEmail2',
      'usdRate' => 'UsdRate',
      'contractBillingType' => 'ContractBillingType',
      'distMarkup' => 'DistMarkup',
      'vendor' => 'Vendor'
    ],
    'links' => [],
    'labels' => [
      'Create BillingVendor' => 'Criar BillingVendor'
    ],
    'options' => [
      'source' => [
        'applications' => 'applications',
        'cloudsolvssa' => 'cloudsolvssa',
        'steller' => 'steller'
      ],
      'country' => [
        'COLOMBIA' => 'COLOMBIA',
        'ARGENTINA' => 'ARGENTINA',
        'PERU' => 'PERU',
        'CHILE' => 'CHILE',
        'CALA' => 'CALA',
        'ECUADOR' => 'ECUADOR',
        'BRAZIL' => 'BRAZIL'
      ],
      'invoiceVendorStatus' => [
        'ISSUED' => 'ISSUED',
        'RETURNED' => 'RETURNED'
      ]
    ]
  ],
  'BucketTimer' => [
    'fields' => [
      'migrations' => 'Migração',
      'bucket' => 'Bucket',
      'duration' => 'Duração',
      'endDate' => 'Data Final',
      'startDate' => 'Data de InÍcio',
      'label' => 'Rótulo',
      'description' => 'Descrição'
    ],
    'links' => [
      'migrations' => 'Migração'
    ],
    'labels' => [
      'Create BucketTimer' => 'Criar Duração do Bucket'
    ],
    'options' => [
      'bucket' => [
        'Upside Pipeline' => 'Upside | Pipeline',
        'Sales | BDM' => 'Sales | BDM (Pendências)',
        'Pre - Sales' => 'Pre - Sales',
        'CSC | SSCloud' => 'CSC | SSCloud',
        'Geração Consumo' => 'Geração Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        'Fechado | Movimentação de Billing' => 'Fechado | Movimentação de Billing',
        'Validação Pré-vendas | CoE' => 'Validação Pré-vendas | CoE',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Criação / Migração Organization)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo'
      ]
    ]
  ],
  'CAccountEndCustomer' => [
    'fields' => [
      'billingAddress' => 'Endereço de Cobrança',
      'shippingAddress' => 'Endereço de Entrega',
      'website' => 'Website',
      'country' => 'Country',
      'sicCode' => 'Número de identificación fiscal: (TAX ID / NIT / RUC / CNPJ)',
      'region' => 'Region',
      'contacts' => 'Contacts'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Ligações',
      'tasks' => 'Tarefas',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create CAccountEndCustomer' => 'Criar Account End Customer'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'United States' => 'United States',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico',
        'CCA' => 'CCA',
        'None LAC' => 'None LAC'
      ]
    ]
  ],
  'CDPSecurity' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CDPSecurity' => 'Criar CDP Security'
    ]
  ],
  'CPB' => [
    'fields' => [
      'account' => 'Cuenta',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Brands',
      'accounts' => 'Accounts',
      'categoriaCPB' => 'CPB Category',
      'statusCPB' => 'CPB status',
      'dSETAWS' => 'DSET AWS',
      'vendor' => 'Vendor',
      'country' => 'País',
      'region' => 'Region',
      'contacts' => 'Contacts',
      'accountsCPB' => 'Accounts CPB',
      'contact' => 'Contact',
      'submissionID' => 'Submission ID',
      'language' => 'Idioma',
      'oportunidad' => 'Opportunities',
      'forms' => 'Formulário',
      'question' => 'Pergunta',
      'answer' => 'Resposta',
      'respondentid' => 'Respondent_id',
      'percentage' => 'Percentage (%)',
      'description' => 'Description'
    ],
    'links' => [
      'account' => 'Cuenta',
      'suresteps' => 'Suresteps',
      'productBrands' => 'Brands',
      'accounts' => 'Accounts',
      'contacts' => 'Contacts',
      'accountsCPB' => 'Accounts CPB',
      'contact' => 'Contact',
      'oportunidad' => 'Opportunities'
    ],
    'labels' => [
      'Create CPB' => 'Criar Cloud Practice Builder'
    ],
    'options' => [
      'categoriaCPB' => [
        'Accelerator' => 'Accelerator',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        '' => '',
        '	Sem Categoria' => 'N/A'
      ],
      'statusCPB' => [
        'Concluido' => 'Concluded',
        'No Concluido ' => 'Not Concluded'
      ],
      'dSETAWS' => [
        'Concluido ' => 'Concluded',
        'No Concluido ' => 'Not Concluded'
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ],
      'country' => [
        'Argentina ' => 'Argentina ',
        'Colombia ' => 'Colombia ',
        '' => '',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Colombia' => 'Colombia',
        'Caribe' => 'Caribe',
        'Argentina' => 'Argentina',
        'Costa Rica' => 'Costa Rica',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Puerto Rico' => 'Puerto Rico'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'Mexico' => 'Mexico'
      ],
      'language' => [
        'Português' => 'pt',
        'English' => 'en',
        'Español' => 'es',
        '' => '',
        'pt' => 'Português',
        'en' => 'English',
        'es' => 'Espanõl'
      ],
      'forms' => [
        'Surestep' => 'Surestep',
        'Splunk' => 'Splunk',
        'Cloud Practice Builder' => 'Cloud Practice Builder'
      ],
      'question' => [
        'New Partner to Activate' => 'New Partner to Activate',
        'Activate to Inspire' => 'Activate to Inspire',
        '' => '',
        '¿Cómo evaluaría su nivel de conocimiento en AWS?' => '¿Cómo evaluaría su nivel de conocimiento en AWS?',
        'Cómo evaluaría su nivel de conocimiento en AWS?' => 'Cómo evaluaría su nivel de conocimiento en AWS?',
        'Conocimento AWS' => '¿Cómo evaluaría su nivel de conocimiento en AWS?',
        '¿Cuál es tu súper poder?' => '¿Cuál es tu súper poder?',
        '¿Con qué séctor o industrias trabajas principalmente?' => '¿Con qué séctor o industrias trabajas principalmente?',
        '¿En qué te gustaría especializarte en AWS?' => '¿En qué te gustaría especializarte en AWS?',
        '¿Tiene pensado en invertir en AWS en el 2022?' => '¿Tiene pensado en invertir en AWS en el 2022?',
        '¿Te interesa…?' => '¿Te interesa…?',
        '¿Cuentas con alguna oferta o solución, la cuál pueda ser ejecutada en la nube de AWS?' => '¿Cuentas con alguna oferta o solución, la cuál pueda ser ejecutada en la nube de AWS?',
        'Considerando el 100% de tu ingreso, ¿Qué distribución estimada tienen los siguientes rubros?' => 'Considerando el 100% de tu ingreso, ¿Qué distribución estimada tienen los siguientes rubros?',
        '¿Cuéntas con un área de servicios propia?' => '¿Cuéntas con un área de servicios propia?'
      ],
      'answer' => [
        'Contact Form Completed' => 'Contact Form Completed',
        '1:1 Meeting with Surestep Ambassador' => '1:1 Meeting with Surestep Ambassador',
        'Skill Mapping (Assessment)' => 'Skill Mapping (Assessment)',
        'TD / SYNNEX Account Number' => 'TD / SYNNEX Account Number',
        'MPN ID' => 'MPN ID',
        'Partner Center Complete Training' => 'Partner Center Complete Training',
        'One Consumption (Last 3 Months)' => 'One Consumption (Last 3 Months)',
        '' => '',
        0 => '0',
        'Otro' => 'Otro',
        'Intermedio' => 'Intermedio',
        'Avanzado' => 'Avanzado',
        'Principiante' => 'Principiante'
      ],
      'percentage' => []
    ]
  ],
  'CPBIoTAnalytic' => [
    'fields' => [
      'revenueIoTDigitisation' => '1. What percentage of your revenue accounts for IoT / Digitisation?',
      'revenueanalytics' => '2. What percentage of your revenue accounts for analytics?',
      'practiceforIoTData' => '3. How would you describe the position of your practice for IoT/Data?',
      'technologystack' => '4. In a typical IoT/analytics customer discussion or solution delivery, which vendors would be included in the technology stack?',
      'organisationdelivered' => '5. In a typical IoT/analytics solution delivery, which technologies and/or services has your organisation delivered?',
      'relationtoIoTdigitization' => '6. Which of the following are in progress or completed at your organisation in relation to IoT/digitization adoption activities?',
      'supportdevelopcapability' => '7. Please indicate which data solution components, your organisation needs support develop capability for. (select all that apply)',
      'businessmostbenefit' => '8. Where would your business most benefit from support to enable your IoT/Data strategy? (select all that apply)',
      'investinAnalytics' => '9. To meet your strategy, in what timeframe are you currently expecting to invest in Analytics?',
      'drivesyoursales' => '10. What drives your sales strategy for IoT/Digitisation?',
      'partoftheirecosystem' => '11. Are you engaging with any organisations who specialise in IoT with the aim of becoming part of their eco-system?',
      'solutionsinIoTDigitisation' => '12. Within your organisation is what is the sales pipeline stage for the majority of solutions in IoT/Digitisation?',
      'sizeforIoTdigitisation' => '13. What is your average deal size for IoT/digitisation?',
      'solutiondeliveryforIoT' => '14. In what areas have you established case studies that evidence your organisation\'s solution delivery for IoT?',
      'consultancyservicesforAnalytics' => '15. How do you deliver your professional consultancy services for Analytics & IoT/ Digitisation Solutions?',
      'designservicesforIoTDigitisation' => '16. How would you rate your design services for IoT/Digitisation?',
      'servicesforAnalytics' => '17. How would you rate your design services for Analytics?',
      'proofofconceptservicesforIoTDigitisation' => '18. How would you rate your proof of concept services for IoT/Digitisation?',
      'conceptservicesforAnalytics' => '19. How would you rate your proof of concept services for Analytics?',
      'implementationservicesforIoTDigitisation' => '20. How would you rate your implementation services for IoT/Digitisation?',
      'implementationservicesforAnalytics' => '21. How would you rate your implementation services for Analytics?',
      'solutionbyyourselfforIoT' => '22. In a typical solution delivery are you able to deliver the entire solution by yourself for IoT?',
      'resourceorganisationforIoTdata' => '23. Please indicate what resource you currently have in your organisation for IoT/data.',
      'analyticsadoptionactivities' => '24. Which of the following are in progress or completed at your organisation in relation to analytics adoption activities?',
      'dataintegrationqualitygovernancemarket' => '25. How would describe your organisation\'s awareness and knowledge of the data integration/quality/governance market?',
      'customersengagementIoTdigitisation' => '26. How would you describe your customers\' engagement with IoT/digitisation?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTAnalytic' => 'Criar CPB IoT Analytic'
    ],
    'options' => [
      'revenueIoTDigitisation' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'revenueanalytics' => [
        '' => '',
        '>50%' => '>50%',
        '26% to 50%' => '26% to 50%',
        '11% to 25%' => '11% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%',
        'Prefer not to disclose' => 'Prefer not to disclose'
      ],
      'practiceforIoTData' => [
        '' => '',
        'At inception' => 'At inception',
        'Developing strategy' => 'Developing strategy',
        'Investment budgeted' => 'Investment budgeted',
        'Developing' => 'Developing',
        'Optimising' => 'Optimising',
        'Mature' => 'Mature',
        'Not planning to have one' => 'Not planning to have one'
      ],
      'technologystack' => [
        '' => '',
        'Advantech' => 'Advantech',
        'Panduit' => 'Panduit',
        'Keonn' => 'Keonn',
        'Relayr' => 'Relayr',
        'Episensor' => 'Episensor',
        'Nexiona' => 'Nexiona',
        'IFM' => 'IFM',
        'Worldsensing' => 'Worldsensing',
        'Actility' => 'Actility',
        'Schneider Electric' => 'Schneider Electric',
        'Siemens' => 'Siemens',
        'Sigfox' => 'Sigfox',
        'Vodafone' => 'Vodafone',
        'Dell' => 'Dell',
        'Microsoft' => 'Microsoft',
        'IBM' => 'IBM',
        'HPE' => 'HPE',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS',
        'Oracle' => 'Oracle',
        'Other' => 'Other'
      ],
      'organisationdelivered' => [
        '' => '',
        'Device connectivity' => 'Device connectivity',
        'Data forwarding' => 'Data forwarding',
        'Real-time monitoring' => 'Real-time monitoring',
        'GPS' => 'GPS',
        'Security' => 'Security',
        'Communication gateways' => 'Communication gateways',
        'Cloud management' => 'Cloud management',
        'Data design' => 'Data design',
        'Data analytics' => 'Data analytics',
        'Automation' => 'Automation',
        'Machine learning' => 'Machine learning',
        'Business intelligence' => 'Business intelligence',
        'Design' => 'Design',
        'Proof of concepts' => 'Proof of concepts',
        'Hosting' => 'Hosting',
        'Consultancy' => 'Consultancy',
        'Service management' => 'Service management',
        'Support' => 'Support'
      ],
      'relationtoIoTdigitization' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'supportdevelopcapability' => [
        '' => '',
        'IoT sensors' => 'IoT sensors',
        'Edge compute' => 'Edge compute',
        'Connectivity' => 'Connectivity',
        'IoT Platforms' => 'IoT Platforms',
        'Data Integration' => 'Data Integration',
        'Data Repository' => 'Data Repository',
        'Data Quality' => 'Data Quality',
        'Data Governance' => 'Data Governance',
        'Business Intelligence Reporting/Visualisation' => 'Business Intelligence Reporting/Visualisation',
        'Business Logic/Workflow' => 'Business Logic/Workflow',
        'AI/Cognitive/ML' => 'AI/Cognitive/ML',
        'Data Security' => 'Data Security'
      ],
      'businessmostbenefit' => [
        '' => '',
        'Sales & marketing' => 'Sales & marketing',
        'Expert to join visits' => 'Expert to join visits',
        'Lead generation' => 'Lead generation',
        'Lead qualification' => 'Lead qualification',
        'Recruitment' => 'Recruitment',
        'Training' => 'Training',
        'Finance & billing' => 'Finance & billing',
        'Solution design' => 'Solution design',
        'Solution implementation' => 'Solution implementation'
      ],
      'investinAnalytics' => [
        '' => '',
        'Underway' => 'Underway',
        '1-3 months' => '1-3 months',
        '4-6 months' => '4-6 months',
        '7-9 months' => '7-9 months',
        '10-12 months' => '10-12 months',
        '>12 months' => '>12 months',
        'None' => 'None'
      ],
      'drivesyoursales' => [
        '' => '',
        'New revenue streams through diversification' => 'New revenue streams through diversification',
        'New sales growth' => 'New sales growth',
        'Replace legacy business' => 'Replace legacy business'
      ],
      'partoftheirecosystem' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'solutionsinIoTDigitisation' => [
        '' => '',
        'Tentative discussions' => 'Tentative discussions',
        'Pre-sales or earlier' => 'Pre-sales or earlier',
        'At qualification or earlier' => 'At qualification or earlier',
        'At solution design or earlier' => 'At solution design or earlier',
        'At evaluation or earlier' => 'At evaluation or earlier',
        'At negotiation or earlier' => 'At negotiation or earlier',
        'At final stage or earlier' => 'At final stage or earlier',
        'No pipeline in place' => 'No pipeline in place'
      ],
      'sizeforIoTdigitisation' => [
        '' => '',
        '£0' => '£0',
        '<£10k' => '<£10k',
        '£10k-£50k' => '£10k-£50k',
        '£51k-100k' => '£51k-100k',
        '£101k-£200k' => '£101k-£200k',
        '£201k-£300k' => '£201k-£300k',
        '>£300k' => '>£300k'
      ],
      'solutiondeliveryforIoT' => [
        '' => '',
        'POC' => 'POC',
        'Pilots' => 'Pilots',
        'End-to-end' => 'End-to-end',
        'Design' => 'Design',
        'Implementation' => 'Implementation',
        'Meeting business outcomes' => 'Meeting business outcomes',
        'Others' => 'Others',
        'None' => 'None'
      ],
      'consultancyservicesforAnalytics' => [
        '' => '',
        'Outsourced' => 'Outsourced',
        'Vendor support' => 'Vendor support',
        'Through partnerships' => 'Through partnerships',
        'With associates/contractors' => 'With associates/contractors',
        'Business unit' => 'Business unit',
        'Department in house' => 'Department in house',
        'Not providing' => 'Not providing'
      ],
      'designservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'servicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'proofofconceptservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'conceptservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforIoTDigitisation' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'implementationservicesforAnalytics' => [
        '' => '',
        'Not offered' => 'Not offered',
        'Good' => 'Good',
        'Market Leading' => 'Market Leading'
      ],
      'solutionbyyourselfforIoT' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Yes through partnerships' => 'Yes through partnerships'
      ],
      'resourceorganisationforIoTdata' => [
        '' => '',
        'Solutions Architecture' => 'Solutions Architecture',
        'Sales & marketing' => 'Sales & marketing',
        'Finance & billing' => 'Finance & billing',
        'Installation' => 'Installation',
        'Implementation' => 'Implementation',
        'Configuration' => 'Configuration',
        'Technical support' => 'Technical support'
      ],
      'analyticsadoptionactivities' => [
        '' => '',
        'Exploring' => 'Exploring',
        'Early stage set-up' => 'Early stage set-up',
        'Building resource' => 'Building resource',
        'Training & skills development' => 'Training & skills development',
        'Leveraging internally' => 'Leveraging internally',
        'Defining value proposition' => 'Defining value proposition',
        'Developing sales strategy' => 'Developing sales strategy',
        'Going to market' => 'Going to market',
        'Delivering solutions' => 'Delivering solutions',
        'Reviewing & refining' => 'Reviewing & refining'
      ],
      'dataintegrationqualitygovernancemarket' => [
        '' => '',
        'Not started' => 'Not started',
        'Early stages' => 'Early stages',
        'Developing' => 'Developing',
        'Expert' => 'Expert',
        'Not part of our strategy' => 'Not part of our strategy'
      ],
      'customersengagementIoTdigitisation' => [
        '' => '',
        'Early adopter' => 'Early adopter',
        'Exploring' => 'Exploring',
        'Actively engaged' => 'Actively engaged',
        'Disengaging' => 'Disengaging',
        'Not engaged' => 'Not engaged'
      ]
    ]
  ],
  'CPBIoTFinancial' => [
    'fields' => [
      'businessDescription' => '1. How would your customers describe your business?',
      'keyAreas' => '2. What are the key areas that make up your solution offerings? (select all that apply)',
      'threeYearStrategy' => '3. Does your organisation have a 3 year strategy and defined goals?',
      'businessLength' => '4. How long have you been in business?',
      'numberOfEmployees' => '5. How many employees do you have?',
      'firstStatement' => '6. To what extent do you agree with the following statement: "All senior leaders and executives are aligned with a 3 year strategy and goals."',
      'secondStatement' => '7. To what extent do you agree with the following statement: "We have already presented our vision to our employees and have their buy-in."',
      'businessPlanRate' => '8. How would you rate your organisation\'s ability to execute on a business plan or transition plan?',
      'organisationGaps' => '10. What are your organisation\'s biggest gaps/challenges to building the solutions practice you would like to build? (select all that apply)',
      'preSalesRate' => '9. How would you rate your organisation\'s pre-sales function and relevant technical expertise to support your transition?',
      'organisationRevenue' => '11. What was your organisation\'s total revenue for your last Fiscal Year?',
      'organisationGrowth' => '12. What was your organisation\'s Year Over Year revenue growth for your last Fiscal year?',
      'grossProfit' => '13. How does your current gross profit figure compare to the past 3 years?',
      'organisationFinancialPerformance' => '14. Considering the last 3 Fiscal Years, which areas have contributed most to your organisation\'s financial performance? (select all that apply)',
      'hardwareRevenuePercentage' => '15. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Hardware?',
      'softwareRevenuePercentage' => '16. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Software?',
      'servicesRevenuePercentage' => '17. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Professional Services?',
      'recurringRevenueStreamsPercentage' => '18. What percentage of your revenue was from recurring revenue streams in the last financial year?',
      'mostProfitableArea' => '19. Considering your entire business, what area was most profitable in the last financial year?',
      'averageProductGrossMargin' => '20. What is the average product gross margin retained by your organisation, excluding rebates and other incentives, from the resale of hardware/software?',
      'organisationCombinedGrossMargin' => '21. What is your organisation\'s combined gross margin, including services?',
      'servicesMarginOverview' => '22. Looking at your current Fiscal Year, how would you describe your Services margin compared to previous years?',
      'organisationEBIT' => '23. What was your organisation\'s Operating Profit (EBIT) during the last Fiscal Year?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTFinancial' => 'Criar CPB IoT Financial'
    ],
    'options' => [
      'businessDescription' => [
        '' => '',
        'Solution Provider' => 'Solution Provider',
        'Managed Service Provider' => 'Managed Service Provider',
        'Independent Software Vendor' => 'Independent Software Vendor',
        'Systems Integrator' => 'Systems Integrator',
        'Hybrid Cloud Enabler/Provider' => 'Hybrid Cloud Enabler/Provider',
        'Reseller/VAR' => 'Reseller/VAR',
        'IT Supplier' => 'IT Supplier',
        'Direct Market Reseller' => 'Direct Market Reseller'
      ],
      'keyAreas' => [
        '' => '',
        'Cloud/Hybrid Cloud' => 'Cloud/Hybrid Cloud',
        'Data Analytics' => 'Data Analytics',
        'IoT' => 'IoT',
        'Security' => 'Security',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Managed Services' => 'Managed Services',
        'Professional Services' => 'Professional Services'
      ],
      'threeYearStrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'Being Developed' => 'Being Developed',
        'No' => 'No'
      ],
      'businessLength' => [
        '' => '',
        'Less than 1 year' => 'Less than 1 year',
        '1 - 2 years' => '1 - 2 years',
        '3 - 5 years' => '3 - 5 years',
        '6 - 10 years' => '6 - 10 years',
        'Over 10 years' => 'Over 10 years'
      ],
      'numberOfEmployees' => [
        '' => '',
        'Less than 5 employees' => 'Less than 5 employees',
        '5 - 9 employees' => '5 - 9 employees',
        '10 - 49 employees' => '10 - 49 employees',
        '50+ employees' => '50+ employees'
      ],
      'firstStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'secondStatement' => [
        '' => '',
        'Strongly Agree' => 'Strongly Agree',
        'Agree' => 'Agree',
        'Undecided' => 'Undecided',
        'Disagree' => 'Disagree',
        'Strongly Disagree' => 'Strongly Disagree'
      ],
      'businessPlanRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationGaps' => [
        'Capabilities' => 'Capabilities',
        'Skills' => 'Skills',
        'Training' => 'Training',
        'Domain expertise' => 'Domain expertise',
        'Lead Generation' => 'Lead Generation',
        'Sales' => 'Sales',
        'Other' => 'Other'
      ],
      'preSalesRate' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'organisationRevenue' => [
        '' => '',
        '$10 million +' => '$10 million +',
        '$5 million +' => '$5 million +',
        '$1 million +' => '$1 million +',
        '< $1 million' => '< $1 million'
      ],
      'organisationGrowth' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'grossProfit' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationFinancialPerformance' => [
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Company Acquisition/Merger' => 'Company Acquisition/Merger',
        'Software' => 'Software',
        'Hardware' => 'Hardware',
        'Other' => 'Other'
      ],
      'hardwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'softwareRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'servicesRevenuePercentage' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'recurringRevenueStreamsPercentage' => [
        '' => '',
        'More than 60%' => 'More than 60%',
        '40% to 60%' => '40% to 60%',
        '20% to 40%' => '20% to 40%',
        '10% to 20%' => '10% to 20%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'mostProfitableArea' => [
        '' => '',
        'Hardware' => 'Hardware',
        'Software' => 'Software',
        'Services' => 'Services',
        'IoT, Big Data, Mobility, Social Business' => 'IoT, Big Data, Mobility, Social Business',
        'Cloud/Consumption' => 'Cloud/Consumption',
        'None of the above' => 'None of the above'
      ],
      'averageProductGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'organisationCombinedGrossMargin' => [
        '' => '',
        '25%+' => '25%+',
        '15% to 25%' => '15% to 25%',
        '10% to 15%' => '10% to 15%',
        '5% to 10%' => '5% to 10%',
        'Less than 5%' => 'Less than 5%'
      ],
      'servicesMarginOverview' => [
        '' => '',
        'Increasing' => 'Increasing',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ],
      'organisationEBIT' => [
        '' => '',
        'More than 10%' => 'More than 10%',
        '5% to 10%' => '5% to 10%',
        '0% to 5%' => '0% to 5%',
        'Flat' => 'Flat',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CPBIoTMarketing' => [
    'fields' => [
      'linesofBusiness' => '1. Can your sales team effectively sell to Lines of Business within your end user customers?',
      'salesreps' => '2. How many sales reps do you have?',
      'salesrepscarryServices' => '3. Do your sales reps carry Services quotas or accelerators?',
      'describeyouorganisation' => '4. How would you describe you organisation\'s ability to successfully implement a marketing strategy?',
      'areaofyourbusiness' => '5. What is an area of your business in which you could use marketing support? (please select all that apply)',
      'solutionsthatyoursales' => '6. Select all solutions that your sales team typically propose to your customers. (select all that apply)',
      'salesgeneratedHardware' => '7. Considering all of your sales generated in the past 12 months, what percentage was led by Hardware?',
      'salesgeneratedSoftware' => '8. Considering all of your sales generated in the past 12 months, what percentage was led by Software?',
      'salesgeneratedServices' => '9. Considering all of your sales generated in the past 12 months, what percentage was led by Services?',
      'salesteamleadgeneration' => '10. How would you rate your sales team\'s lead generation engine?',
      'businessoutcomes' => '11. Do you have a detailed sales approach that shows how your offerings achieve customers\' desired business outcomes?',
      'monthlyRecurringRevenue' => '13. Does your organisation have an employee compensation plan that supports Monthly Recurring Revenue (MRR)?',
      'newbusinesstargets' => '14. Do you have new business targets that include new technologies and/or customers?',
      'horizontalsegments' => '15. What horizontal segments do you sell into?',
      'typicalsalesengagement' => '16. In a typical sales engagement, which departments do you currently involve in the decision making process?',
      'verticalssell' => '17. What verticals do you sell into?',
      'deployyoursolutions' => '18. In regards to the environment on which your end users deploy your solutions - which is the most relevant?',
      'account' => 'Account',
      'servicesversusproductsales' => '12. Does your organisation have an employee compensation plan for services versus product sales?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTMarketing' => 'Criar CPB IoT Marketing'
    ],
    'options' => [
      'linesofBusiness' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'Not Sure' => 'Not Sure'
      ],
      'salesreps' => [
        '' => '',
        'Less than 3 reps' => 'Less than 3 reps',
        '3 - 5 reps' => '3 - 5 reps',
        '6 - 10 reps' => '6 - 10 reps',
        '11 - 49 reps' => '11 - 49 reps',
        'More than 50 reps' => 'More than 50 reps'
      ],
      'salesrepscarryServices' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'describeyouorganisation' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Needs Improvement' => 'Needs Improvement',
        'Poor' => 'Poor',
        'Not Sure' => 'Not Sure'
      ],
      'areaofyourbusiness' => [
        '' => '',
        'Digital/Online Presence' => 'Digital/Online Presence',
        'Content Creation' => 'Content Creation',
        'Value Proposition Creation' => 'Value Proposition Creation',
        'Lead Generation' => 'Lead Generation',
        'Marketing Plan Creation' => 'Marketing Plan Creation',
        'Outsource Marketing' => 'Outsource Marketing',
        'Not Sure' => 'Not Sure',
        'We\'ve Mastered Our Marketing Engine' => 'We\'ve Mastered Our Marketing Engine'
      ],
      'solutionsthatyoursales' => [
        '' => '',
        'IoT' => 'IoT',
        'Managed Services' => 'Managed Services',
        'Public Cloud' => 'Public Cloud',
        'Private / Hybrid Cloud' => 'Private / Hybrid Cloud',
        'Software' => 'Software',
        'Hardware / Infrastructure' => 'Hardware / Infrastructure',
        'Back up & Data Recovery' => 'Back up & Data Recovery',
        'Maintenance Services' => 'Maintenance Services',
        'Professional Services' => 'Professional Services',
        'Other' => 'Other'
      ],
      'salesgeneratedHardware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedSoftware' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesgeneratedServices' => [
        '' => '',
        '50% or above' => '50% or above',
        '40% - 49%' => '40% - 49%',
        '20% - 39%' => '20% - 39%',
        '10% - 19%' => '10% - 19%',
        'Less than 10%' => 'Less than 10%'
      ],
      'salesteamleadgeneration' => [
        '' => '',
        'Excellent' => 'Excellent',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Very Poor' => 'Very Poor'
      ],
      'businessoutcomes' => [
        '' => '',
        'Yes' => 'Yes',
        'In progress' => 'In progress',
        'No' => 'No'
      ],
      'monthlyRecurringRevenue' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ],
      'newbusinesstargets' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'horizontalsegments' => [
        '' => '',
        'Large (500+ employed)' => 'Large (500+ employed)',
        'Mid (100 to 499 employed)' => 'Mid (100 to 499 employed)',
        'Small (1 to 99 employed)' => 'Small (1 to 99 employed)'
      ],
      'typicalsalesengagement' => [
        '' => '',
        'IT' => 'IT',
        'Digital/Innovation' => 'Digital/Innovation',
        'Finance' => 'Finance',
        'Operations' => 'Operations',
        'Procurement' => 'Procurement',
        'HR' => 'HR',
        'Sales & Marketing' => 'Sales & Marketing',
        'Customer Service' => 'Customer Service',
        'Other' => 'Other'
      ],
      'verticalssell' => [
        '' => '',
        'Manufacturing' => 'Manufacturing',
        'Legal' => 'Legal',
        'Retail' => 'Retail',
        'Healthcare' => 'Healthcare',
        'Finance' => 'Finance',
        'Banking' => 'Banking',
        'Education' => 'Education',
        'Government' => 'Government',
        'Smart Space' => 'Smart Space',
        'Logistics' => 'Logistics',
        'Transport' => 'Transport',
        'Energy' => 'Energy',
        'Utilities' => 'Utilities',
        'Pharmaceutical' => 'Pharmaceutical',
        'Other' => 'Other'
      ],
      'deployyoursolutions' => [
        '' => '',
        'On premise' => 'On premise',
        'Hybrid' => 'Hybrid',
        'Single Tenant Platform' => 'Single Tenant Platform',
        'Multi Tenant Platform' => 'Multi Tenant Platform'
      ],
      'servicesversusproductsales' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No'
      ]
    ]
  ],
  'CPBIoTStrategy' => [
    'fields' => [
      'account' => 'Account',
      'analystConsulting' => '1. Do you regularly consult with analysts (in-house or externally) in order to realise your organisation\'s goals and transition business models?',
      'organisationBenchmark' => '2. Does your organisation benchmark itself against other partners in your field?',
      'cashFlowManagePlan' => '3. If change is involved in your business goals, do you have a plan to manage your cash flow?',
      'organisationInvestingAreas' => '4. Select the areas in which you see your organisation investing over the next 3 years. (select all that apply)',
      'asAServiceSolutions' => '5. Do you provide any Software/Infrastucture as a Service offerings, or do you have any solutions that will move to SaaS/IaaS based in the future?',
      'ownSolutionEngagement' => '6. Are you engaging with any vendors, partners or solution providers to build out your own solution stack?',
      'highestGrowthAreas' => '7. Which areas do you see as the highest growth potential in the next 12 months?',
      'dataLifecycle' => '8. Where in the data lifecycle are your focus points?'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTStrategy' => 'Criar CPB IoT Strategy'
    ],
    'options' => [
      'analystConsulting' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationBenchmark' => [
        '' => '',
        'Frequently' => 'Frequently',
        'Occasionally' => 'Occasionally',
        'Unsure how' => 'Unsure how',
        'Not interested' => 'Not interested'
      ],
      'cashFlowManagePlan' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'organisationInvestingAreas' => [
        '' => '',
        'Data center' => 'Data center',
        'Employees' => 'Employees',
        'Service offerings' => 'Service offerings',
        'Technology development' => 'Technology development',
        'Systems' => 'Systems',
        'Other' => 'Other',
        'No funds to invest' => 'No funds to invest'
      ],
      'asAServiceSolutions' => [
        '' => '',
        'Yes, we currently offer SaaS/IaaS' => 'Yes, we currently offer SaaS/IaaS',
        'Solutions identified for move to SaaS/IaaS' => 'Solutions identified for move to SaaS/IaaS',
        'No, we do not intend to offer SaaS solutions' => 'No, we do not intend to offer SaaS solutions'
      ],
      'ownSolutionEngagement' => [
        '' => '',
        'Yes' => 'Yes',
        'Planned' => 'Planned',
        'No' => 'No'
      ],
      'highestGrowthAreas' => [
        '' => '',
        'IoT' => 'IoT',
        'Analytics' => 'Analytics',
        'Managed Workspace' => 'Managed Workspace',
        'Cyber Security' => 'Cyber Security',
        'Social Platforms' => 'Social Platforms',
        'Big Data' => 'Big Data',
        'Mobile' => 'Mobile',
        'Cloud/Hybrid' => 'Cloud/Hybrid',
        'Physical Infrastructure' => 'Physical Infrastructure',
        'Automation & Orchestration ' => 'Automation & Orchestration ',
        'Business Intelligence' => 'Business Intelligence',
        'Consumption-as-a-Service' => 'Consumption-as-a-Service',
        'Other' => 'Other'
      ],
      'dataLifecycle' => [
        '' => '',
        'Generate' => 'Generate',
        'Collect' => 'Collect',
        'Analyse' => 'Analyse',
        'React' => 'React',
        'Predict' => 'Predict'
      ]
    ]
  ],
  'CPBIoTTechnology' => [
    'fields' => [
      'salesrevenue' => '1. In the last financial year, what percentage of your organisation\'s overall sales revenue came from Managed Services?',
      'managedservicessolution' => '2. Have you hired specialised managed services/solution sales expertise or retrained product focused sales people to sell services and solutions?',
      'documentedstrategy' => '3. Do you have a well defined and documented strategy for your managed services?',
      'managedServicesprocesses' => '4. How would you rate your Managed Services processes, systems, tools and SLA\'s?',
      'transformAndhost' => '5. For your managed services do you offer a standard catalogue that includes monitor, operate, optimise, transform and host, or equivalent?',
      'deliverypractice' => '6. Do you have a scalable and repeatable delivery practice for your managed services?',
      'consumptionbased' => '7. Do you have a consumption-based billing capability, either internally or externally?',
      'hardwaresaleschanging' => '8. How do you see the percentage of your hardware sales changing in the next 12 - 24 months?',
      'softwaresaleschanging' => '9. How do you see the percentage of your software sales changing in the next 12 - 24 months?',
      'servicessaleschanging' => '10. How do you see the percentage of your services sales changing in the next 12 - 24 months?',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CPBIoTTechnology' => 'Criar CPB IoT Technology'
    ],
    'options' => [
      'salesrevenue' => [
        '' => '',
        'More than 50%' => 'More than 50%',
        '25% to 50%' => '25% to 50%',
        '10% to 25%' => '10% to 25%',
        '1% to 10%' => '1% to 10%',
        '0%' => '0%'
      ],
      'managedservicessolution' => [
        '' => '',
        'Yes' => 'Yes',
        'Training in progress' => 'Training in progress',
        'Recruitment in progress' => 'Recruitment in progress',
        'No' => 'No'
      ],
      'documentedstrategy' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'managedServicesprocesses' => [
        '' => '',
        'Good' => 'Good',
        'Acceptable' => 'Acceptable',
        'Poor' => 'Poor',
        'Managed Services being developed' => 'Managed Services being developed',
        'We don\'t provide Managed Services' => 'We don\'t provide Managed Services'
      ],
      'transformAndhost' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'deliverypractice' => [
        '' => '',
        'Yes' => 'Yes',
        'No' => 'No',
        'We do not have Managed Services' => 'We do not have Managed Services'
      ],
      'consumptionbased' => [
        '' => '',
        'Yes' => 'Yes',
        'In Progress' => 'In Progress',
        'No' => 'No'
      ],
      'hardwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'softwaresaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ],
      'servicessaleschanging' => [
        '' => '',
        'Increasing' => 'Increasing',
        'No change' => 'No change',
        'Decreasing' => 'Decreasing'
      ]
    ]
  ],
  'CPartnerAssessment' => [
    'fields' => [
      'account' => 'Account',
      'dedicatedSalesGoogleCloud' => 'Pessoa(s) dedicadas para abordagem comercial em Google Cloud',
      'salesAccreditationGoogleCloud' => 'Pessoa(s) com acreditações de Vendas Google Cloud',
      'digitalLeaderCertificationGoogle' => 'Pessoa(s) com certificação Google Digital Leader',
      'dedicatedTechnicalGoogleCloud' => 'Pessoa(s) dedicadas para abordagem técnica em Google Cloud',
      'technicalAccreditationGoogleCloud' => 'Pessoa(s) com acreditações Técnicas Google Cloud',
      'professionalCertificationGoogle' => 'Pessoa(s) com certificação Google Professional',
      'billingStrategyGoogleCloud' => 'Estratégia comercial para crescimento de billing Google Cloud',
      'customerBasePositioningGoogleCloud' => 'Estratégia de posicionamento da parceria com Google Cloud na base atual de clientes',
      'marketPositioningGoogleCloud' => 'Estratégia de posicionamento da parceria com Google Cloud no mercado',
      'commercialTechnicalAssessment' => 'Avaliação - Desenvolvimento Comercial / Técnico',
      'gtmAssessment' => 'Avaliação - Go to Market',
      'partnerCategory' => 'Categoria do Parceiro',
      'assessmentTotal' => 'Avaliação - Total',
      'productBrand' => 'Fabricante'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Ligações',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'productBrand' => 'Fabricante'
    ],
    'labels' => [
      'Create CPartnerAssessment' => 'Criar Partner Assessment'
    ],
    'options' => [
      'dedicatedSalesGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'salesAccreditationGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'digitalLeaderCertificationGoogle' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'dedicatedTechnicalGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'technicalAccreditationGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'professionalCertificationGoogle' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'billingStrategyGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'customerBasePositioningGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'marketPositioningGoogleCloud' => [
        '' => '',
        'Não possuimos conhecimento' => 'Não possuimos conhecimento',
        'Não possui, e não possuirá' => 'Não possui, e não possuirá',
        'Não possuí, mas possuirá' => 'Não possuí, mas possuirá',
        'Sim, em desenvolvimento' => 'Sim, em desenvolvimento',
        'Sim, já desenvolvida' => 'Sim, já desenvolvida'
      ],
      'partnerCategory' => [
        '' => 'Não Categorizado',
        'A' => 'Categoria A',
        'B' => 'Categoria B',
        'C' => 'Categoria C',
        'D' => 'Categoria D'
      ]
    ]
  ],
  'CalendrioseEventos' => [
    'fields' => [
      'status' => 'Status',
      'dataHora' => 'Data/Hora do Evento',
      'publicoAlvo' => 'Público Alvo'
    ],
    'links' => [],
    'labels' => [
      'Create CalendrioseEventos' => 'Criar Calendários e Eventos'
    ],
    'options' => [
      'status' => [
        'Planejado' => 'Planejado',
        'Confirmado' => 'Confirmado',
        'Realizado' => 'Realizado'
      ],
      'publicoAlvo' => [
        'TD Synnex' => 'TD Synnex',
        'Revenda' => 'Revenda',
        'CF' => 'CF',
        'ISVs' => 'ISVs',
        'ISP' => 'ISP'
      ]
    ]
  ],
  'Cisco' => [
    'fields' => [
      'account' => 'Account',
      'kNOWs' => 'Cisco Programs',
      'year' => 'Ano',
      'q1Amount' => 'Q1',
      'q1AmountCurrency' => 'Q1Amount (Currency)',
      'q1AmountConverted' => 'Q1Amount (Converted)',
      'q2Amount' => 'Q2',
      'q2AmountCurrency' => 'Q2 (Currency)',
      'q2AmountConverted' => 'Q2 (Converted)',
      'q3Amount' => 'Q3',
      'q3AmountCurrency' => 'Q3 (Currency)',
      'q3AmountConverted' => 'Q3 (Converted)',
      'q4Amount' => 'Q4',
      'q4AmountCurrency' => 'Q4 (Currency)',
      'q4AmountConverted' => 'Q4 (Converted)',
      'amount' => 'Valor (Investimento)',
      'amountCurrency' => 'Valor (Investimento) (Currency)',
      'amountConverted' => 'Valor (Investimento) (Converted)'
    ],
    'links' => [
      'account' => 'Account',
      'kNOWs' => 'Cisco Programs'
    ],
    'labels' => [
      'Create Cisco' => 'Criar Cisco'
    ],
    'options' => [
      'year' => [
        2020 => '2020',
        2021 => '2021',
        2022 => '2022',
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        '' => ''
      ]
    ]
  ],
  'CiscoDMP' => [
    'fields' => [
      'certification' => 'Certification',
      'stage' => 'Stage',
      'dirClassification' => 'DIR Classification',
      'competitiveFlag' => 'Competitive Flag',
      'competitors' => 'Competitors',
      'last12MonthsBookings' => 'Last 12 months Bookings (USD)',
      'last12MonthsBookingsCurrency' => 'Last 12 months Bookings (USD) (Currency)',
      'last12MonthsBookingsConverted' => 'Last 12 months Bookings (USD) (Converted)',
      'account' => 'Account'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create CiscoDMP' => 'Criar Cisco DMP'
    ],
    'options' => [
      'certification' => [
        '' => '',
        'Select' => 'Select',
        'Gold' => 'Gold',
        'Premier' => 'Premier'
      ],
      'stage' => [
        0 => '0',
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        '' => ''
      ],
      'dirClassification' => [
        '' => '',
        'Developed' => 'Developed',
        'Focus' => 'Focus',
        'Scale' => 'Scale'
      ],
      'competitiveFlag' => [
        'Cisco' => 'Cisco',
        'Other Partner' => 'Other Partner',
        'Cisco Partner' => 'Cisco Partner'
      ],
      'competitors' => []
    ]
  ],
  'CiscoJourney' => [
    'fields' => [
      'kNOW' => 'KNOW',
      'videos1and2' => 'Videos 1 e 2',
      'videos3And4' => 'Videos 3 e 4',
      'video5' => 'Vídeo 5',
      'vdeos67And8' => 'Vídeos 6, 7 e 8',
      'account' => 'Account'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account'
    ],
    'labels' => [
      'Create CiscoJourney' => 'Criar Cisco Journey'
    ],
    'options' => [
      'kNOW' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos1and2' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'videos3And4' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'video5' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'vdeos67And8' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ]
    ],
    'tooltips' => [
      'videos1and2' => 'Sim: Registro Synnex / Registro CISCO
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'kNOW' => 'Sim:	Jornada de vídeos Velocity Accelerate.
Não:	Comunicação de engajamento e divulgação da jornada.',
      'videos3And4' => 'Sim: Inscrição no Evento Cisco Select e material de apoio das certificações.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.',
      'video5' => 'Sim: Inscrição nos cursos K.NOW / Black Belt - Envio de material de apoio.
Não: Comunicação de Engajamento para continuar a jornada.',
      'vdeos67And8' => 'Sim: Ao terminar a jornada, encaminhar comunicação de boas vindas e direcionar o contato de vendas e o time de produto entrar em contato.
Não: Comunicação de Engajamento para continuar a jornada e registrar-se na Cisco.'
    ]
  ],
  'Citrix' => [
    'fields' => [
      'profileID' => 'Profile ID',
      'profileURL' => 'Profile URL',
      'website' => 'Website',
      'account' => 'Conta',
      'lostType' => 'Momento da Perda',
      'lostContact' => 'Contato Perdido',
      'lostDescription' => 'Descrição da Perda',
      'opportunities' => 'Oportunidades',
      'calls' => 'Ligações',
      'campaignID' => 'ID da Campanha',
      'segment' => 'Segmento',
      'project' => 'Projeto',
      'product' => 'Produto',
      'leads' => 'Leads',
      'name' => 'Nome (Campanha)',
      'description' => 'Descrição'
    ],
    'links' => [
      'account' => 'Conta',
      'opportunities' => 'Oportunidades',
      'calls' => 'Ligações',
      'leads' => 'Leads'
    ],
    'labels' => [
      'Create Citrix' => 'Criar Citrix'
    ],
    'options' => [
      'lostType' => [
        'LinkedIn - Sem Interesse' => 'LinkedIn - Sem Interesse',
        'SDR - Sem Interesse' => 'SDR - Sem Interesse',
        'Vicente - Sem Interesse' => 'Vicente - Sem Interesse',
        '' => ''
      ],
      'segment' => [
        '' => '',
        'Jurídico' => 'Jurídico',
        'Tecnologia da Informação' => 'Tecnologia da Informação',
        'Recursos Humanos' => 'Recursos Humanos'
      ],
      'project' => [
        '' => '',
        'Social Selling' => 'Social Selling'
      ],
      'product' => [
        '' => '',
        'Secure Private Access' => 'Secure Private Access',
        'DAAS' => 'DAAS',
        'Desktop as a Service (DaaS)' => 'Desktop as a Service (DaaS)'
      ]
    ]
  ],
  'CloudConsumption' => [
    'fields' => [
      'partnerID' => 'ID no fabricante',
      'billingPeriod' => 'Data da medição',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'status' => 'Status',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order',
      'lastupdate' => 'Last Update',
      'description' => 'Período de cobrança'
    ],
    'links' => [
      'partnerID' => 'ID no fabricante',
      'account' => 'Conta',
      'salesOrder' => 'Sales Order'
    ],
    'labels' => [
      'Create CloudConsumption' => 'Criar Cloud Consumption'
    ],
    'tooltips' => [
      'billingPeriod' => 'Data da medição do consumo. Quando a data for o último dia do mês, este registro reflete o valor do consumo no mês. Atenção: este valor poderá ser atualizado até o quinto dia do mês seguinte devido a variações no envio das informações pelo próprio fabricante.'
    ],
    'options' => [
      'status' => [
        'In progress' => 'In progress',
        'Complete' => 'Complete'
      ]
    ]
  ],
  'Contract' => [
    'links' => [
      'contractGoals' => 'Contract Goals',
      'accountVBM' => 'Account VBM'
    ],
    'labels' => [
      'Create Contract' => 'Criar Contract'
    ],
    'fields' => [
      'paises' => 'País',
      'periodoImportado' => 'periodo_importado',
      'contratoMs' => 'contrato_ms',
      'tipo' => 'Tipo',
      'fornecedor' => 'fornecedor',
      'nomefornecedor' => 'nomefornecedor',
      'fatcfourv' => 'fat_cf_ou_rv',
      'clienteParaFaturamento' => 'cliente_para_faturamento',
      'descricaoCliente' => 'descricao_cliente',
      'revendedor' => 'revendedor',
      'descricaoRevendedor' => 'Revenda',
      'codItem' => 'cod_item',
      'descricaoItem' => 'descricao_item',
      'chargeType' => 'charge_type',
      'syndicationpartnersubscriptionnumber' => 'ERP Sales Order',
      'inicioDaCobranca' => 'inicio_da_cobranca',
      'fimDaCobranca' => 'fim_da_cobranca',
      'orderId' => 'order_id',
      'invoice' => 'invoice',
      'dataAprovManual' => 'data_aprov_manual',
      'usuarioAprovManual' => 'usuario_aprov_manual',
      'usuario' => 'usuario',
      'horaAprov' => 'hora_aprov',
      'ordenDeCompra' => 'orden_de_compra',
      'log' => 'log',
      'nfGerada' => 'nf_gerada',
      'subcategoria' => 'subcategoria',
      'quantidade' => 'Quantidade',
      'precoUnitario' => 'preco_unitario',
      'valorTotal' => 'Valor de Custo',
      'descContrato' => 'desc_contrato',
      'acresContrato' => 'acres_contrato',
      'descRevenda' => 'desc_revenda',
      'vlrPercentualComissao' => 'vlr_percentual_comissao',
      'valorComissao' => 'valor_comissao',
      'resellerunitprice' => 'resellerunitprice',
      'totalRv' => 'Valor de Venda',
      'enduserunitprice' => 'enduserunitprice',
      'totalCf' => 'total_cf',
      'tblpreco' => 'tblpreco',
      'lucro' => 'Margem (US$)',
      'date' => 'Data (Período Importado)',
      'quarter' => 'Quarter',
      'month' => 'Month',
      'margem' => 'Margem (%)',
      'facturadeVenta' => 'Factura_de_Venta',
      'facturaDeVenta' => 'FacturaDeVenta',
      'statusDoContrato' => 'Status Contrato',
      'totalsales' => 'Total sales',
      'credit' => 'Credit',
      'lastupdate' => 'Last Update',
      'contractGoals' => 'Meta',
      'accountVBM' => 'Account VBM',
      'soldByCountry' => 'SoldByCountry',
      'emisionVenta' => 'EmisionVenta',
      'spla' => 'Spla',
      'termDuration' => 'TermDuration',
      'billingCycle' => 'BillingCycle'
    ],
    'options' => [
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'statusDoContrato' => [
        'FATURADO' => 'FATURADO',
        'Faturado' => 'Faturado',
        'NF Devolvida	' => 'NF Devolvida	',
        'Crédito Vinculado	' => 'Crédito Vinculado	',
        'Validado' => 'Validado',
        'NF Devolvida' => 'NF Devolvida',
        'Cr\\u00e9dito Vinculado' => 'Cr\\u00e9dito Vinculado',
        '' => '',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'Não Validado'
      ]
    ],
    'presetFilters' => [
      'reportFilter6686eac9c5a60065c' => 'Contracts Q1',
      'reportFilter6686ead1b861b28d9' => 'Contracts Q2',
      'reportFilter6686eae14885b6a3a' => 'Contracts Q3',
      'reportFilter6686eae8f245d4139' => 'Contracts Q4'
    ]
  ],
  'ContractGoals' => [
    'fields' => [
      'contracts' => 'Contracts',
      'q1' => 'Q1 (Dec-Fev)',
      'q1Currency' => 'Q1 (Currency)',
      'q1Converted' => 'Q1 (Converted)',
      'q2' => 'Q2 (Mar-Mai)',
      'q2Currency' => 'Q2 (Currency)',
      'q2Converted' => 'Q2 (Converted)',
      'amountGoal' => 'Meta',
      'amountGoalCurrency' => 'Meta (Moneda)',
      'amountGoalConverted' => 'Meta (Convertido)',
      'newResellers' => 'Novas Revendas',
      'q1goal' => 'Q1 - Meta',
      'q1goalCurrency' => 'Q1 - Meta (Moneda)',
      'q1goalConverted' => 'Q1 - Meta (Convertido)',
      'year' => 'Ano',
      'type' => 'Tipo',
      'sync' => 'Sync',
      'roi' => 'Diferença / Lucro',
      'roiCurrency' => 'Diferença / Lucro (Moneda)',
      'roiConverted' => 'Diferença / Lucro (Convertido)',
      'revendedorID' => 'Revendedor ID',
      'region' => 'Region',
      'q4goal' => 'Q4 - Meta',
      'q4goalCurrency' => 'Q4 - Meta (Moneda)',
      'q4goalConverted' => 'Q4 - Meta (Convertido)',
      'q4diff' => 'Q4 - Diferença',
      'q4diffCurrency' => 'Q4 - Diferença (Moneda)',
      'q4diffConverted' => 'Q4 - Diferença (Convertido)',
      'q4' => 'Q4 (Set-Nov)',
      'q4Currency' => 'Q4 - Set/Out/Nov (Moneda)',
      'q4Converted' => 'Q4 - Set/Out/Nov (Convertido)',
      'q3goal' => 'Q3 - Meta',
      'q3goalCurrency' => 'Q3 - Meta (Moneda)',
      'q3goalConverted' => 'Q3 - Meta (Convertido)',
      'q3diff' => 'Q3 - Diferença',
      'q3diffCurrency' => 'Q3 - Diferença (Moneda)',
      'q3diffConverted' => 'Q3 - Diferença (Convertido)',
      'q3' => 'Q3 (Jun-Ago)',
      'q3Currency' => 'Q3 - Jun/Jul/Ago (Moneda)',
      'q3Converted' => 'Q3 - Jun/Jul/Ago (Convertido)',
      'q2goal' => 'Q2 - Meta',
      'q2goalCurrency' => 'Q2 - Meta (Moneda)',
      'q2goalConverted' => 'Q2 - Meta (Convertido)',
      'q2diff' => 'Q2 - Diferença',
      'q2diffCurrency' => 'Q2 - Diferença (Moneda)',
      'q2diffConverted' => 'Q2 - Diferença (Convertido)',
      'q1diff' => 'Q1 - Diferença',
      'q1diffCurrency' => 'Q1 - Diferença (Moneda)',
      'q1diffConverted' => 'Q1 - Diferença (Convertido)',
      'country' => 'País'
    ],
    'links' => [
      'contracts' => 'Contracts'
    ],
    'labels' => [
      'Create ContractGoals' => 'Criar Contract Goal'
    ],
    'options' => [
      'year' => [
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        2028 => '2028',
        2029 => '2029',
        2030 => '2030',
        '' => ''
      ],
      'type' => [
        '' => '',
        'Licenciamento' => 'Licenciamento',
        'Consumo' => 'Consumo',
        'Licença' => 'Licença'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA'
      ],
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'CCA' => 'CCA',
        'Caribe' => 'Caribe',
        'Santa Lucía' => 'Santa Lucía',
        'San vicente y las Granadinas' => 'San vicente y las Granadinas',
        'San Cristóbal y Nieves' => 'San Cristóbal y Nieves',
        'Jamaica' => 'Jamaica',
        'Belice' => 'Belice',
        'Haití' => 'Haití',
        'Guyana' => 'Guyana',
        'Granada' => 'Granada',
        'Cuba' => 'Cuba',
        'Barbados' => 'Barbados',
        'Bahamas' => 'Bahamas',
        'Antigua y barbuda' => 'Antigua y barbuda',
        'Nicaragua' => 'Nicaragua',
        'United States' => 'United States',
        'CALA' => 'CALA'
      ]
    ]
  ],
  'Country' => [
    'fields' => [
      'countryLabel' => 'CountryLabel',
      'priceBooks' => 'Price Books'
    ],
    'links' => [
      'priceBooks' => 'Price Books'
    ],
    'labels' => [
      'Create Country' => 'Criar Country'
    ],
    'options' => [
      'countryLabel' => [
        'Argentina' => 'Argentina',
        'Colombia' => 'Colombia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Peru' => 'Peru',
        'Ecuador' => 'Ecuador',
        'Cala' => 'Cala',
        'Mexico' => 'Mexico',
        'Uruguai' => 'Uruguai',
        '' => ''
      ]
    ]
  ],
  'CuentasVBM' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create CuentasVBM' => 'Criar Cuentas VBM'
    ]
  ],
  'DSET' => [
    'fields' => [
      'account' => 'Accounts',
      'contact' => 'Contact',
      'productBrands' => 'Brands',
      'categoriaCPB' => 'CPB Category',
      'country' => 'País',
      'dSETAWS' => 'DSET AWS',
      'language' => 'Idioma',
      'region' => 'Region',
      'statusCPB' => 'CPB status',
      'submissionID' => 'Submission ID',
      'vendor' => 'Vendor',
      'description' => 'Description'
    ],
    'links' => [
      'account' => 'Account',
      'contact' => 'Contact',
      'productBrands' => 'Brands'
    ],
    'labels' => [
      'Create DSET' => 'Criar DSET'
    ],
    'options' => [
      'categoriaCPB' => [
        '' => '',
        'Sem Categoria' => 'Without category',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator'
      ],
      'country' => [
        '' => '',
        'Argentina ' => 'Argentina ',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'Chile' => 'Chile',
        'Colombia ' => 'Colombia ',
        'Costa Rica ' => 'Costa Rica ',
        'Dominican Republic' => 'Dominican Republic',
        'Ecuador' => 'Ecuador',
        'Guadeloupe' => 'Guadeloupe',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'El Salvador' => 'El Salvador',
        'Mexico' => 'Mexico',
        'Panama ' => 'Panama ',
        'Paraguay ' => 'Paraguay ',
        'Peru' => 'Peru',
        'Puerto Rico ' => 'Puerto Rico ',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela'
      ],
      'dSETAWS' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'language' => [
        '' => '',
        'pt' => 'Português',
        'en' => 'English',
        'es' => 'Espanõl'
      ],
      'region' => [
        '' => '',
        'NOLA' => 'NOLA',
        'SOLA' => 'SOLA',
        'CCA' => 'CCA',
        'Brasil' => 'Brasil',
        'México' => 'México'
      ],
      'statusCPB' => [
        'No Concluído' => 'Not Concluded',
        'Concluído' => 'Concluded'
      ],
      'vendor' => [
        '' => '',
        'AWS' => 'AWS',
        'Google' => 'Google',
        'Microsoft' => 'Microsoft'
      ]
    ]
  ],
  'DashboardAccess' => [
    'fields' => [
      'accessTime' => 'Access Time',
      'tabName' => 'Tab Name',
      'name' => 'Dashboard Name'
    ],
    'links' => [],
    'labels' => [
      'Create DashboardAccess' => 'Criar Dashboard Access'
    ]
  ],
  'DataAIAssessment' => [
    'fields' => [
      'category' => 'Category',
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos',
      'country' => 'Pais'
    ],
    'links' => [
      'account' => 'Conta',
      'contact' => 'Contato',
      'contacts' => 'Contatos'
    ],
    'labels' => [
      'Create DataAIAssessment' => 'Criar Data AI Assessment'
    ],
    'options' => [
      'category' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'DataAnalytics' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalytics' => 'Criar Data Analytics'
    ]
  ],
  'DataAnalyticsReport' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DataAnalyticsReport' => 'Criar Data Analytics Report'
    ]
  ],
  'Distributor' => [
    'fields' => [
      'accessToken' => 'AccessToken',
      'accountId' => 'AccountId',
      'appId' => 'AppId',
      'clientId' => 'ClientId',
      'clientSecret' => 'ClientSecret',
      'codErp' => 'CodErp',
      'culture' => 'Culture',
      'domain' => 'Domain',
      'expireToken' => 'ExpireToken',
      'mpnId' => 'MpnId',
      'refreshToken' => 'RefreshToken',
      'scope' => 'Scope',
      'countryCode' => 'Country Code'
    ],
    'links' => [],
    'labels' => [
      'Create Distributor' => 'Criar Distributor'
    ],
    'options' => [
      'scope' => [
        'api.partner.microsoft.com' => 'api.partner.microsoft.com',
        'management.azure.com' => 'management.azure.com',
        'graph.microsoft.com' => 'graph.microsoft.com',
        'api.partnercenter.microsoft.com' => 'api.partnercenter.microsoft.com'
      ]
    ]
  ],
  'DsetAws' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create DsetAws' => 'Criar DSET AWS'
    ]
  ],
  'Earn' => [
    'fields' => [
      'earningId' => 'earningId',
      'participantId' => 'participantId',
      'participantIdType' => 'participantIdType',
      'participantName' => 'Region',
      'programName' => 'Program Name',
      'transactionId' => 'transactionId',
      'transactionCurrency' => 'transactionCurrency',
      'lever' => 'lever',
      'engagementName' => 'engagementName',
      'engagementId' => 'engagementId',
      'earningType' => 'earningType',
      'claimId' => 'claimId',
      'paymentId' => 'Payment ID',
      'paymentStatusDescription' => 'paymentStatusDescription',
      'customerId' => 'customerId',
      'customerName' => 'customerName',
      'partNumber' => 'partNumber',
      'productName' => 'productName',
      'productId' => 'productId',
      'parentProductId' => 'parentProductId',
      'parentProductName' => 'parentProductName',
      'productType' => 'productType',
      'invoiceNumber' => 'invoiceNumber',
      'subscriptionId' => 'subscriptionId',
      'resellerId' => 'resellerId',
      'resellerName' => 'resellerName',
      'distributorId' => 'distributorId',
      'distributorName' => 'distributorName',
      'agreementNumber' => 'agreementNumber',
      'agreementStartDate' => 'agreementStartDate',
      'agreementEndDate' => 'agreementEndDate',
      'workload' => 'workload',
      'transactionType' => 'transactionType',
      'localProviderSeller' => 'localProviderSeller',
      'taxRemitModel' => 'taxRemitModel',
      'storeFee' => 'storeFee',
      'transactionPaymentMethod' => 'transactionPaymentMethod',
      'tpan' => 'tpan',
      'purchaseTypeCode' => 'purchaseTypeCode',
      'purchaseOrderType' => 'purchaseOrderType',
      'purchaseOrderCoverageStartDate' => 'purchaseOrderCoverageStartDate',
      'purchaseOrderCoverageEndDate' => 'purchaseOrderCoverageEndDate',
      'externalReferenceId' => 'externalReferenceId',
      'externalReferenceIdLabel' => 'externalReferenceIdLabel',
      'licensingProgramName' => 'licensingProgramName',
      'taxCountry' => 'taxCountry',
      'taxState' => 'taxState',
      'taxCity' => 'taxCity',
      'taxZipCode' => 'taxZipCode',
      'programCode' => 'programCode',
      'lastPaymentCurrency' => 'lastPaymentCurrency',
      'assetId' => 'assetId',
      'orderId' => 'orderId',
      'lineItemId' => 'lineItemId',
      'resellerCountry' => 'resellerCountry',
      'customerCountry' => 'Customer Country',
      'customerEmail' => 'customerEmail',
      'skuId' => 'skuId',
      'customerTenantId' => 'customerTenantId',
      'invoiceDate' => 'invoiceDate',
      'fundCategory' => 'fundCategory',
      'categoryId' => 'categoryId',
      'reasonCode' => 'reasonCode',
      'bucketSize' => 'bucketSize',
      'milestone' => 'milestone',
      'billingGroupId' => 'billingGroupId',
      'quantityType' => 'quantityType',
      'topParentPartNumber' => 'topParentPartNumber',
      'productFamily' => 'productFamily',
      'topParentProductFamily' => 'topParentProductFamily',
      'agreementType' => 'agreementType',
      'userCount' => 'userCount',
      'desktopCount' => 'desktopCount',
      'baseline' => 'baseline',
      'baselineType' => 'baselineType',
      'isPrivateOffer' => 'isPrivateOffer',
      'transactionExchangeRate' => 'transactionExchangeRate',
      'transactionAmount' => 'transactionAmount',
      'earningRate' => 'earningRate',
      'quantity' => 'quantity',
      'earningAmount' => 'Earning Amount',
      'earningExchangeRate' => 'earningExchangeRate',
      'taxRemitted' => 'taxRemitted',
      'earningAmountInLastPaymentCurrency' => 'earningAmountInLastPaymentCurrency',
      'instantRebateAmount' => 'instantRebateAmount',
      'transactionDate' => 'transactionDate',
      'paymentStatus' => 'Payment Status',
      'transactionCountryCode' => 'TransactionCountryCode',
      'calculationDate' => 'CalculationDate',
      'exchangeRateDate' => 'ExchangeRateDate',
      'subscriptionStartDate' => 'SubscriptionStartDate',
      'subscriptionEndDate' => 'SubscriptionEndDate',
      'earningAmountUSD' => 'Earning Amount (USD)',
      'earningAmountUSDCurrency' => 'Earning Amount (USD) (Currency)',
      'earningAmountUSDConverted' => 'Earning Amount (USD) (Converted)',
      'transactionAmountUSD' => 'Transaction Amount (USD)',
      'transactionAmountUSDCurrency' => 'Transaction Amount (USD) (Currency)',
      'transactionAmountUSDConverted' => 'Transaction Amount (USD) (Converted)',
      'estimatedPaymentMonth' => 'Estimated Payment Month',
      'earningDate' => 'EarningDate',
      'partnerCountryCode' => 'Country Code',
      'earningDate2' => 'Earning Date'
    ],
    'links' => [],
    'labels' => [
      'Create Earn' => 'Criar Earn'
    ],
    'options' => [
      'paymentStatus' => [
        'UNPROCESSED' => 'Unprocessed',
        'PROCESSED' => 'Processed',
        'Sent' => 'Sent',
        'Reprocessing' => 'Reprocessing',
        'Upcoming' => 'Upcoming',
        'Sent:Payout Profile Not Available' => 'Sent - Payout Profile Not Available'
      ],
      'transactionCountryCode' => [
        '' => '',
        'BR' => 'BR',
        'MX' => 'MX',
        'EC' => 'EC',
        'AR' => 'AR',
        'CO' => 'CO',
        'CA' => 'CA',
        'CH' => 'CH',
        'BO' => 'BO',
        'PE' => 'PE'
      ],
      'estimatedPaymentMonth' => [
        'Apr-2023' => 'Apr-2023',
        'Mar-2023' => 'Mar-2023',
        'May-2023' => 'May-2023',
        'Jul-2023' => 'Jul-2023',
        'Not applicable' => 'Not applicable'
      ],
      'partnerCountryCode' => [
        'BR' => 'BR',
        'CO' => 'CO',
        'MX' => 'MX',
        'CL' => 'CL',
        'PA' => 'PA',
        'EC' => 'EC',
        'AR' => 'AR',
        'PE' => 'PE'
      ]
    ]
  ],
  'EmailContent' => [
    'fields' => [
      'attachments' => 'Add Attachments',
      'done' => 'Finalizado',
      'scheduled' => 'Agendado para',
      'status' => 'Status',
      'country' => 'País',
      'sendExample' => 'Enviar Exemplo',
      'accounts' => 'Contas',
      'content' => 'Conteúdo',
      'startDate' => 'Promo Data de Início',
      'endDate' => 'Promo Data Final',
      'active' => 'Ativa',
      'promoContent' => 'Conteúdo Promo',
      'title' => 'Title',
      'promoTitle' => 'Título Promo',
      'emails' => 'Emails',
      'emailAddress' => 'E-mail',
      'accountsList' => 'Lista de Contas',
      'contactsList' => 'Lista de Contatos',
      'description' => 'Descrição',
      'name' => 'Nome'
    ],
    'links' => [
      'accounts' => 'Contas',
      'emails' => 'Emails',
      'accountsList' => 'Lista de Contas',
      'contactsList' => 'Lista de Contatos'
    ],
    'labels' => [
      'Create EmailContent' => 'Criar Email Content'
    ],
    'options' => [
      'status' => [
        'Created' => 'Created',
        'Started' => 'Started / Reviewing',
        'Completed' => 'Completed',
        'Canceled' => 'Canceled',
        'Sent' => 'Sent',
        'Scheduled' => 'Scheduled'
      ],
      'country' => [
        'Ecuador' => 'Ecuador',
        'Colombia' => 'Colombia',
        'Chile' => 'Chile',
        'Argentina' => 'Argentina',
        'Paraguay' => 'Paraguay',
        'Uruguay' => 'Uruguay',
        'Peru' => 'Peru',
        'Mexico' => 'Mexico',
        'Venezuela' => 'Venezuela',
        'El Salvador' => 'El Salvador',
        'Costa Rica' => 'Costa Rica',
        'Bolivia' => 'Bolivia',
        'Dominican Republic' => 'Dominican Republic',
        'Panama' => 'Panama',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Nicaragua' => 'Nicaragua',
        'Puerto Rico' => 'Puerto Rico',
        'Jamaica' => 'Jamaica',
        'Barbados' => 'Barbados',
        'Guadeloupe' => 'Guadeloupe',
        'Brasil (teste)' => 'Brasil (teste)'
      ]
    ],
    'tooltips' => [
      'sendExample' => 'Click here to send a sample email to your email address. Please, make sure to add your email address to the field below. ',
      'content' => 'Define the email content. You can insert text and image, make sure the maximum image width size is 559px.',
      'scheduled' => 'Set when the email must be sent to the Accounts list below. Then change the status to "Completed" and check the "Done" box if the email is ready to be sent on the scheduled date.',
      'country' => 'Select the country to receive this communication.',
      'attachments' => 'If there are any assets to send, please attach them here.',
      'active' => 'Range Date: Active Promo',
      'done' => 'Check the "Done" box if the email is ready to be sent on the scheduled date.',
      'status' => 'Change the status to "Completed" and check the "Done" box if the email is ready to be sent on the scheduled date.',
      'promoContent' => 'Define the promo content (Promociones). You can insert text and image, make sure the maximum image width size is 600px.',
      'startDate' => 'Promotion start date.',
      'endDate' => 'Final date of the promotion.',
      'title' => 'Set the title for the Promo email section.',
      'promoTitle' => 'Set the title for the Promo email section.',
      'emailAddress' => 'Please, make sure to add your email address to the field below and then click on "Send Example". A sample email will be sent to your registered email address.',
      'description' => 'Available markdown syntax:
`code`
```multiline code```
**strong text**
*emphasized text*
~~deleted text~~
> blockquote
[link](url)',
      'name' => 'Set the title for the email section.'
    ]
  ],
  'Events' => [
    'fields' => [
      'parent' => 'Parent',
      'dateStart' => 'Date Start',
      'dateEnd' => 'Date End',
      'duration' => 'Duration',
      'status' => 'Status',
      'reminders' => 'Reminders',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'links' => [
      'parent' => 'Parent',
      'productBrands' => 'Fabricantes',
      'accounts' => 'Parceiros'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Planned',
        'Held' => 'Held',
        'Not Held' => 'Not Held'
      ]
    ],
    'labels' => [
      'Create Events' => 'Criar Event',
      'Schedule Events' => 'Schedule Event',
      'Log Events' => 'Log Event',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held'
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ]
  ],
  'ExternalFormPost' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ExternalFormPost' => 'Criar ExternalFormPost'
    ]
  ],
  'GoogleCloud' => [
    'fields' => [
      'account' => 'Account',
      'product' => 'Product',
      'subProduct' => 'Sub Product',
      'amount' => 'Amount',
      'amountCurrency' => 'Amount (Currency)',
      'amountConverted' => 'Amount (Converted)',
      'stage' => 'Stage',
      'discount' => 'Discount (%)',
      'googleClouds' => 'Google Clouds',
      'googleCloudParent' => 'Google Cloud Parent',
      'tipodeoportunidad' => 'Tipo de Oportunidad',
      'cantidadDeLicencias' => 'Cantidad de licencias',
      'contratoATiempo' => 'Contrato a tiempo',
      'nombreDelProyecto' => 'Nombre del Proyecto',
      'productosAConsumir' => 'Producto/s a consumir',
      'amountProxConsumo' => 'Amount Aprox de Consumo',
      'amountProxConsumoCurrency' => 'Amount Prox Consumo (Currency)',
      'amountProxConsumoConverted' => 'Amount Prox Consumo (Converted)',
      'edicinDeWorkspace1' => 'Edicion de Workspace',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Partner',
      'rebates' => 'Rebates',
      'backend' => 'Backend %',
      'region' => 'Region',
      'country' => 'Country',
      'oportunidadesGoogle' => 'Oportunidades Google',
      'contratoATiempoList' => 'Contrato a Tiempo',
      'createdAt' => 'Created At',
      'createdBy' => 'Created By',
      'name' => 'Name',
      'teams' => 'Teams'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'googleClouds' => 'Google Clouds',
      'googleCloudParent' => 'Google Cloud Parent',
      'partner' => 'Partner',
      'partnersGoogleCloud' => 'Partner Google Cloud',
      'oportunidadesGoogle' => 'Oportunidades Google'
    ],
    'labels' => [
      'Create GoogleCloud' => 'Criar Oportunidad Google Cloud'
    ],
    'options' => [
      'product' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ],
      'subProduct' => [
        '' => '',
        'License Type' => 'License Type',
        'GCP Service' => 'GCP Service'
      ],
      'stage' => [
        'Prospecting' => 'Prospecting',
        'Proposal' => 'Proposal',
        'Negotiation' => 'Negotiation',
        'Closed Won' => 'Closed Won',
        'Closed Lost' => 'Closed Lost'
      ],
      'tipodeoportunidad' => [
        '' => '',
        'Upgrade de licencias' => 'Upgrade de licencias',
        'New Business' => 'New Business',
        'Renovación de Licencias' => 'Renovación de Licencias'
      ],
      'nombreDelProyecto' => [
        '' => '',
        'Almacenamiento Cloud' => 'Almacenamiento Cloud',
        'Servidores Web' => 'Servidores Web',
        'AGFA Healthcare as a services' => 'AGFA Healthcare as a services',
        'Recaptcha' => 'Recaptcha'
      ],
      'productosAConsumir' => [
        '' => '',
        'Cloud Storage' => 'Cloud Storage',
        'VM' => 'VM',
        'GCP' => 'GCP',
        'Recaptcha' => 'Recaptcha'
      ],
      'edicinDeWorkspace1' => [
        '' => '',
        'Business Starter' => 'Business Starter',
        'Business Standard' => 'Business Standard',
        'Business Plus' => 'Business Plus',
        'Enterprise Starter' => 'Enterprise Starter',
        'Enterprise Standard ' => 'Enterprise Standard ',
        'Enterprise Plus' => 'Enterprise Plus',
        'Frontline' => 'Frontline'
      ],
      'rebates' => [
        '' => '',
        'Si' => 'Si',
        'No' => 'No'
      ],
      'contratoATiempoList' => [
        '' => '',
        'Plan Flexible' => 'Plan Flexible',
        'Plan a 12 meses de contrato' => 'Plan a 12 meses de contrato',
        'Plan a 24 meses de contrato' => 'Plan a 24 meses de contrato',
        'Plan a 36 meses de contrato' => 'Plan a 36 meses de contrato',
        'Versión de prueba' => 'Versión de prueba'
      ]
    ]
  ],
  'GooglePartnerAdvantage' => [
    'fields' => [
      'productBrand' => 'Fabricante',
      'stage' => 'Estágio',
      'qualify' => 'Qualify',
      'refine' => 'Refine',
      'techEvalSolutionDev' => 'Tech Evaluation | Solution Dev',
      'proposalNegotiation' => 'Proposal | Negotiation',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor da Oportunidade (Currency)',
      'amountConverted' => 'Valor da Oportunidade (Converted)',
      'update' => 'Update',
      'account' => 'Account Name',
      'opportunityOwner' => 'Opportunity Owner',
      'productFamily' => 'Product Family',
      'email' => 'E-mail',
      'phone' => 'Telefone',
      'domain' => 'Domínio do Cliente',
      'oppIDGoogle' => 'ID da Oportunidade',
      'lostReason' => 'Motivo de Cancelamento / Perda',
      'closeDate' => 'Data de Fechamento / Perda',
      'country' => 'País',
      'reason' => 'Especifique',
      'description' => 'Qualification Notes (Description)'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'productBrand' => 'Fabricante',
      'lead' => 'Lead',
      'opportunities' => 'Opportunities',
      'account' => 'Account Name'
    ],
    'labels' => [
      'Create GooglePartnerAdvantage' => 'Criar Google Partner Advantage'
    ],
    'options' => [
      'stage' => [
        'Qualify' => 'Qualify',
        'Refine' => 'Refine',
        'Tech Evaluation | Solution Dev' => 'Tech Evaluation | Solution Dev',
        'Proposal | Negotiation' => 'Proposal | Negotiation',
        'Closed' => 'Closed',
        '' => 'Nenhum',
        'Lost' => 'Lost'
      ],
      'qualify' => [
        'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.' => 'At least one meeting with C-level, Co- Founder or C-1 level business sponsor.',
        '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)' => '[Select/Enterprise only] Completed Cloud Account Plan (go/cloudaccountplan)',
        'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)' => 'Accept/Reject opportunity in SFDC and progress to Stage 1 (30 day SLA)'
      ],
      'refine' => [
        '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.' => '[Select/Enterprise only] Mutual Evaluation Plan (go/cloud-mep) is recommended.',
        'Completed Cloud Project Discovery (go/cloud-pdg)' => 'Completed Cloud Project Discovery (go/cloud-pdg)',
        'Partner Attach' => 'Partner Attach',
        'Solution Tagging' => 'Solution Tagging',
        'Site Selection' => 'Site Selection'
      ],
      'techEvalSolutionDev' => [
        'Decision Maker Signoff on Technical Win' => 'Decision Maker Signoff on Technical Win',
        'Technical Proposal & Architecture (go/cloudtp)' => 'Technical Proposal & Architecture (go/cloudtp)',
        'Technical Deal Blockers Identified' => 'Technical Deal Blockers Identified',
        'Capacity Plan (go/getonering)' => 'Capacity Plan (go/getonering)',
        'Populate Term (Months)' => 'Populate Term (Months)',
        'AI/ML and Business Need (If AI/ML is Yes) are required' => 'AI/ML and Business Need (If AI/ML is Yes) are required'
      ],
      'proposalNegotiation' => [
        'Partner and/or PSO SOW' => 'Partner and/or PSO SOW',
        'Executed Contract' => 'Executed Contract',
        'Countersigned MSA and order form' => 'Countersigned MSA and order form',
        'Commercial Proposal' => 'Commercial Proposal'
      ],
      'productFamily' => [
        '' => '',
        'Google Cloud Platform' => 'Google Cloud Platform',
        'Google Workspace' => 'Google Workspace'
      ],
      'lostReason' => [
        '' => '',
        'SLA' => 'SLA',
        'Cliente não retornou contato' => 'Cliente não retornou contato',
        'Cliente escolheu outro fornecedor' => 'Cliente escolheu outro fornecedor',
        'Cliente não tem interesse na solução ofertada' => 'Cliente não tem interesse na solução ofertada',
        'Preços' => 'Preços',
        'Outro' => 'Outro'
      ]
    ],
    'tooltips' => [
      'qualify' => 'Indetify initial problem and desire to adress with key Stakeholders.',
      'refine' => 'Problems uncovered and align solution to critical business need.',
      'techEvalSolutionDev' => 'Customer confirmed their required capabilities. Final Solution and POC confirmed.',
      'proposalNegotiation' => 'Technical validation complete and customer agreed to pricing signature date.'
    ]
  ],
  'ISVExperience' => [
    'fields' => [
      'inspireChecklist' => 'Inspire',
      'consumption' => 'Consumo (Mensal) - Dólares',
      'consumptionCurrency' => 'Consumo (Mensal) - Dólares (Currency)',
      'consumptionConverted' => 'Consumo (Mensal) - Dólares (Converted)',
      'urlKnow' => 'URL KNOW',
      'account' => 'Account',
      'level' => 'Level',
      'salesChecklist' => 'Sales',
      'voiceChecklist' => 'Voice',
      'status' => 'Status',
      'accounts' => 'Account',
      'account1' => 'Account'
    ],
    'links' => [
      'account' => 'Account',
      'accounts' => 'Account',
      'account1' => 'Account'
    ],
    'labels' => [
      'Create ISVExperience' => 'Criar ISV Experience'
    ],
    'options' => [
      'inspireChecklist' => [
        'Créditos para POC' => 'Créditos para POC',
        'Suporte na migração' => 'Suporte na migração',
        'Acesso as ferramentas de negócios TD SYNNEX: KNOW! E-Learnng e Cloud Analytics ' => 'Acesso as ferramentas de negócios TD SYNNEX: KNOW! E-Learnng e Cloud Analytics ',
        'Exposição da solução no Hub Solutions da TD SYNNEX (Cloudsolv e Solutions Bridge)' => 'Exposição da solução no Hub Solutions da TD SYNNEX (Cloudsolv e Solutions Bridge)',
        'Divulgação para a base SYNNEX (Newsletter de ISV’s, Newsletter cliente final, Redes Sociais' => 'Divulgação para a base SYNNEX (Newsletter de ISV’s, Newsletter cliente final, Redes Sociais',
        'Participação em eventos e programas exclusivos TD SYNNEX' => 'Participação em eventos e programas exclusivos TD SYNNEX'
      ],
      'level' => [
        '' => '',
        'Inspire' => 'Inspire',
        'Sales' => 'Sales',
        'Voice' => 'Voice'
      ],
      'salesChecklist' => [
        'Voucher de certificação' => 'Voucher de certificação',
        'PR para divulgar a nova parceria TD SYNNEX ' => 'PR para divulgar a nova parceria TD SYNNEX ',
        'Guia: Como montar um programa de Canais' => 'Guia: Como montar um programa de Canais',
        'Exposição da solução no Hub Solutions da TD SYNNEX (Cloudsolv e Solutions Bridge) ' => 'Exposição da solução no Hub Solutions da TD SYNNEX (Cloudsolv e Solutions Bridge) ',
        'Engajamento P2P vendedores TD SYNNEX e ecossistema revendas' => 'Engajamento P2P vendedores TD SYNNEX e ecossistema revendas',
        'Vídeo animado para divulgação da solução no Hub de Soluções TD SYNNEX, Bridge Solutions ' => 'Vídeo animado para divulgação da solução no Hub de Soluções TD SYNNEX, Bridge Solutions ',
        'Destaque no Hub de Soluções, Bridge Solutions ' => 'Destaque no Hub de Soluções, Bridge Solutions ',
        'Participação em eventos e programas exclusivos TD SYNNEX' => 'Participação em eventos e programas exclusivos TD SYNNEX',
        'Acesso aos nossos parceiros de aceleração (associações) ' => 'Acesso aos nossos parceiros de aceleração (associações) '
      ],
      'voiceChecklist' => [
        'Exposição da solução no Marketplace do Fabricante' => 'Exposição da solução no Marketplace do Fabricante',
        'Criação de 01 case de sucesso ' => 'Criação de 01 case de sucesso ',
        'Evento exclusivo com revendas selecionadas TD SYNNEX para P2P' => 'Evento exclusivo com revendas selecionadas TD SYNNEX para P2P',
        'Participação em eventos e programas exclusivos TD SYNNEX' => 'Participação em eventos e programas exclusivos TD SYNNEX',
        'Acesso aos nossos parceiros de aceleração (associações)' => 'Acesso aos nossos parceiros de aceleração (associações)'
      ],
      'status' => [
        'Não solicitado' => 'Não solicitado',
        'Solicitado' => 'Solicitado',
        'Em análise (Marketing)' => 'Em análise (Marketing)',
        'Recusado (Marketing)' => 'Recusado (Marketing)',
        'Ativo' => 'Ativo'
      ]
    ]
  ],
  'Importer' => [
    'fields' => [
      'status' => 'Status',
      'inputFile' => 'Arquivo de Entrada',
      'outputFile' => 'Arquivo de Saída',
      'type' => 'Tipo de Dados',
      'detailOppCIS' => 'Detalhes',
      'templateURL' => 'Template URL - Cloud Brasil',
      'documents' => 'Documents',
      'description' => 'Descrição'
    ],
    'links' => [
      'documents' => 'Documents'
    ],
    'labels' => [
      'Create Importer' => 'Criar Importador'
    ],
    'options' => [
      'status' => [
        '' => '',
        'Created' => 'Created',
        'Processing' => 'Processing',
        'Done' => 'Done',
        'Error' => 'Error'
      ],
      'type' => [
        '' => '',
        'Oportunidades Brasil' => 'Oportunidades Brasil',
        'Canais AWS LAC' => 'Canales AWS LAC',
        'Oportunidades AWS LAC' => 'Oportunidades AWS LAC',
        'opp_partner_program_aws' => 'Oportunidades AWS MCA'
      ]
    ]
  ],
  'IncentivesVendor' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create IncentivesVendor' => 'Criar IncentivesVendor'
    ]
  ],
  'KNOW' => [
    'fields' => [
      'completePercentage' => 'Conclusão (%)',
      'conversionDate' => 'Data Final (KNOW)',
      'architecture' => 'Arquitetura',
      'leads' => 'Leads',
      'lead' => 'Lead',
      'activity' => 'Atividade',
      'quarter' => 'Quarter',
      'typeOfUser' => 'Type of User',
      'amount' => 'Valor (Investimento)',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'account' => 'Account',
      'status' => 'Status',
      'knowCourse' => 'Curso (KNOW)',
      'typeOfActivity' => 'Tipo de Atividade',
      'fiscalYear' => 'Fiscal Year',
      'beGeoID' => 'Be Geo ID',
      'certification' => 'Certification',
      'leadIDImport' => 'LeadIDImport',
      'completePercentageConverted' => 'Conclusão (%) - Convertido',
      'conversionDays' => 'Conversion Days',
      'startDate' => 'Data de início (KNOW)',
      'blackbeltStage' => 'BlackBelt Stage',
      'blackbeltPartnerType' => 'BlackBelt Partner Type',
      'blackBeltTrack' => 'BlackBelt Track',
      'blackBeltCompletionDate' => 'BlackBelt Completion Date',
      'apStartDate' => 'Start Date (Ações)',
      'apEndDate' => 'End Date (Ações)',
      'program' => 'Tipo de Programa',
      'verba' => 'Verba',
      'endUserVarchar' => 'End User',
      'fobValue' => 'FOB Value',
      'fobValueCurrency' => 'FOB Value (Currency)',
      'fobValueConverted' => 'FOB Value (Converted)',
      'rebait' => 'Rebate',
      'rebaitCurrency' => 'Rebait (Currency)',
      'rebaitConverted' => 'Rebait (Converted)',
      'certificationCX' => 'Certificação CX',
      'partnerStage' => 'Partner Stage',
      'dirClassification' => 'DIR Classification',
      'bookingAmount' => 'Booking Amount',
      'bookingAmountCurrency' => 'Booking Amount (Currency)',
      'bookingAmountConverted' => 'Booking Amount (Converted)',
      'loyalty' => 'Loyalty',
      'cisco' => 'Cisco',
      'description' => 'Descrição'
    ],
    'links' => [
      'leads' => 'Leads',
      'lead' => 'Lead',
      'account' => 'Account',
      'cisco' => 'Cisco'
    ],
    'labels' => [
      'Create KNOW' => 'Criar KNOW'
    ],
    'options' => [
      'architecture' => [
        '' => '',
        'Cross' => 'Cross',
        'Data Center' => 'Data Center',
        'Enterprise Networks' => 'Enterprise Networks',
        'Meraki' => 'Meraki',
        'Onboarding' => 'Onboarding',
        'Segurança' => 'Segurança',
        'Serviços' => 'Serviços',
        'Vendas' => 'Vendas',
        'Cisco Designed' => 'Cisco Designed',
        'Collaboration' => 'Collaboration',
        'Contact Center' => 'Contact Center',
        'Cross-Architecture' => 'Cross-Architecture',
        'DevNet' => 'DevNet',
        'Enterprise Networking' => 'Enterprise Networking',
        'IoT' => 'IoT',
        'Non Architecture' => 'Non Architecture',
        'Security' => 'Security',
        'Service Provider' => 'Service Provider',
        'Sales' => 'Sales',
        'Cloud (EA, MSLA)' => 'Cloud (EA, MSLA)',
        'Customer Experience' => 'Customer Experience',
        'Certification' => 'Certification',
        'CX' => 'CX'
      ],
      'activity' => [
        '' => '',
        'KNOW' => 'KNOW',
        'Certification' => 'Certification',
        'Demand Generation' => 'Demand Generation',
        'Incentives' => 'Incentives',
        'Marketing Demand Generation' => 'Marketing Demand Generation',
        'Black Belt' => 'Black Belt',
        'Programs' => 'Programas',
        'Trainings' => 'Trainings',
        'Bookings' => 'Bookings',
        'Event' => 'Event'
      ],
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'typeOfUser' => [
        '' => '',
        'End User' => 'End User',
        'Reseller' => 'Reseller'
      ],
      'status' => [
        '' => '',
        'Em Andamento' => 'Em Andamento',
        'Realizado' => 'Realizado',
        'Em Aprovação' => 'Em Aprovação'
      ],
      'knowCourse' => [
        '' => '',
        'Velocity Accelerate' => 'Velocity Accelerate',
        'Software' => 'Software',
        'SMB - Onboarding' => 'SMB - Onboarding',
        'SD-WAN' => 'SD-WAN',
        'Meraki SD-WAN' => 'Meraki SD-WAN',
        'Datacenter Anywhere' => 'Datacenter Anywhere',
        'Service' => 'Service',
        'SASE' => 'SASE',
        'Academia de Vendas' => 'Academia de Vendas',
        'Secure Endpoint' => 'Secure Endpoint',
        'Start' => 'Start',
        'Full-Stack Observality' => 'Full-Stack Observality',
        'CISCO FULL-STACK OBSERVABILITY' => 'CISCO FULL-STACK OBSERVABILITY',
        'CISCO START' => 'CISCO START',
        'CISCO SECURE ENDPOINT' => 'CISCO SECURE ENDPOINT',
        'CISCO ACADEMIA DE VENDAS' => 'CISCO ACADEMIA DE VENDAS',
        'CISCO - SASE' => 'CISCO - SASE',
        'CISCO - SERVICE' => 'CISCO - SERVICE',
        'CISCO DATA CENTER ANYWHERE' => 'CISCO DATA CENTER ANYWHERE',
        'CISCO MERAKI SD-WAN' => 'CISCO MERAKI SD-WAN',
        'CISCO SD-WAN' => 'CISCO SD-WAN',
        'CISCO SMB - ONBOARDING' => 'CISCO SMB - ONBOARDING',
        'CISCO - SOFTWARE' => 'CISCO - SOFTWARE',
        'SYNNEX VELOCITY ACCELERATE' => 'SYNNEX VELOCITY ACCELERATE'
      ],
      'typeOfActivity' => [
        '' => '',
        'Brinde' => 'Brinde',
        'Campanha de Vendas' => 'Campanha de Vendas',
        'Campanha Digital' => 'Campanha Digital',
        'Evento' => 'Evento',
        'Certificação' => 'Certificação',
        'Certificação CX' => 'Certificação CX',
        'Marketing Digital' => 'Marketing Digital',
        'Evento híbrido' => 'Evento híbrido',
        'Evento Online' => 'Evento Online',
        'Evento Híbrido' => 'Evento Híbrido'
      ],
      'fiscalYear' => [
        2021 => '2021',
        2022 => '2022',
        '' => '',
        2020 => '2020',
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        2028 => '2028',
        2029 => '2029',
        2030 => '2030'
      ],
      'certification' => [
        '' => '',
        'Select' => 'Select',
        'Gold' => 'Gold',
        'Premier' => 'Premier'
      ],
      'blackbeltStage' => [
        '' => '',
        'Stage 1' => 'Stage 1',
        'Stage 2' => 'Stage 2',
        'Stage 3' => 'Stage 3'
      ],
      'blackbeltPartnerType' => [
        '' => '',
        'VAR' => 'VAR',
        'DVAR' => 'DVAR'
      ],
      'blackBeltTrack' => [
        '' => '',
        'BA' => 'BA',
        'CX' => 'CX',
        'Deployment' => 'Deployment',
        'Developer' => 'Developer',
        'Pre-Sales' => 'Pre-Sales',
        'PSS' => 'PSS',
        'Sales' => 'Sales',
        'SNAP' => 'SNAP',
        'Support' => 'Support',
        'X-Cell CSS' => 'X-Cell CSS'
      ],
      'program' => [
        '' => '',
        'EA as a Service' => 'EA as a Service',
        'Meraki as a Service' => 'Meraki as a Service',
        'MSLA' => 'MSLA',
        'Endpoint Architecture' => 'Endpoint Architecture',
        'Collector' => 'Collector',
        'Edge TD SYNNEX - Collaboration' => 'Edge TD SYNNEX - Collaboration',
        'VPMM' => 'VPMM',
        'Edge for Cloud' => 'Edge for Cloud',
        'CX Transformation' => 'CX Transformation',
        'Security Program' => 'Security Program',
        'Radius' => 'Radius'
      ],
      'verba' => [
        '' => '',
        'TD Synnex' => 'TD SYNNEX',
        'DDI' => 'DDI'
      ],
      'certificationCX' => [
        '' => '',
        'Sim' => 'Sim',
        'Não' => 'Não'
      ],
      'partnerStage' => [
        '' => '',
        'Stage - 1' => 'Stage - 1',
        'Stage - 2' => 'Stage - 2',
        'Stage - 3' => 'Stage - 3',
        'Stage - 4' => 'Stage - 4',
        'Stage - 5' => 'Stage - 5'
      ],
      'dirClassification' => [
        '' => '',
        'DAP' => 'DAP',
        'Scale' => 'Scale'
      ]
    ]
  ],
  'LeadsPartnerCenter' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create LeadsPartnerCenter' => 'Criar Leads Partner Center'
    ]
  ],
  'LevelUp' => [
    'fields' => [
      'account' => 'Account',
      'type' => 'Tipo',
      'q1Amount' => 'Q1',
      'q1AmountCurrency' => 'Q1 (Currency)',
      'q1AmountConverted' => 'Q1 (Converted)',
      'q2Amount' => 'Q2',
      'q2AmountCurrency' => 'Q2 (Currency)',
      'q2AmountConverted' => 'Q2 (Converted)',
      'q3Amount' => 'Q3',
      'q3AmountCurrency' => 'Q3 (Currency)',
      'q3AmountConverted' => 'Q3 (Converted)',
      'q4Amount' => 'Q4',
      'q4AmountCurrency' => 'Q4 (Currency)',
      'q4AmountConverted' => 'Q4 (Converted)',
      'amountGoal' => 'Meta',
      'amountGoalCurrency' => 'Meta (Currency)',
      'amountGoalConverted' => 'Meta (Converted)',
      'year' => 'Ano',
      'levelUpActivities' => 'Ações Level Up',
      'roi' => 'Retorno de Investimento',
      'roiCurrency' => 'Retorno de Investimento (Currency)',
      'roiConverted' => 'Retorno de Investimento (Converted)',
      'amountGoalFloat' => 'Total (BRL)'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'levelUpActivities' => 'Ações Level Up'
    ],
    'labels' => [
      'Create LevelUp' => 'Criar Level Up'
    ],
    'options' => [
      'type' => [
        'Collaboration' => 'Collaboration',
        'Security' => 'Security',
        '' => ''
      ],
      'year' => [
        2023 => '2023',
        2024 => '2024',
        2025 => '2025',
        2026 => '2026',
        2027 => '2027',
        2028 => '2028',
        2029 => '2029',
        2030 => '2030',
        '' => ''
      ]
    ]
  ],
  'LevelUpActivities' => [
    'fields' => [
      'status' => 'Status (%)',
      'investment' => 'Investimento',
      'investmentCurrency' => 'Investimento (Currency)',
      'investmentConverted' => 'Investimento (Converted)',
      'quarter' => 'Quarter',
      'levelUp' => 'Level Up',
      'investmentFloat' => 'Total Investimento (BRL)',
      'year' => 'Ano',
      'type' => 'Tipo',
      'name' => 'Nome (Ação na Revenda)',
      'description' => 'Descrição'
    ],
    'links' => [
      'levelUp' => 'Level Up'
    ],
    'labels' => [
      'Create LevelUpActivities' => 'Criar Ação Level Up'
    ],
    'options' => [
      'quarter' => [
        '' => '',
        'Q1' => 'Q1',
        'Q2' => 'Q2',
        'Q3' => 'Q3',
        'Q4' => 'Q4'
      ],
      'year' => [
        2023 => '2023',
        2024 => '2024',
        '' => ''
      ],
      'type' => [
        '' => '',
        'Collaboration' => 'Collaboration',
        'Security' => 'Security'
      ]
    ],
    'presetFilters' => [
      'reportFilter641b1b3ea15d738a4' => 'Ação Level Up - Q1'
    ]
  ],
  'Marketing' => [
    'fields' => [
      'vendor' => 'Vendor',
      'startDate' => 'Data de Inicio',
      'endingDate' => 'Data de Expiração',
      'productBrands' => 'ProductBrand',
      'country' => 'Country',
      'noExpiration' => 'Sem Data de Expiração',
      'productBrand' => 'Vendor',
      'category' => 'Categoria',
      'status' => 'Status',
      'opportunities' => 'Opportunities',
      'opportunity' => 'Opportunity',
      'oportunidade' => 'Opportunity',
      'investment' => 'Investment',
      'investmentCurrency' => 'Investment (Currency)',
      'investmentConverted' => 'Investment (Converted)',
      'roi' => 'ROI',
      'roiCurrency' => 'ROI (Currency)',
      'roiConverted' => 'ROI (Converted)',
      'profit' => 'Ganancia',
      'profitCurrency' => 'Profit (Currency)',
      'profitConverted' => 'Profit (Converted)',
      'profitReal' => 'Lucro (BRL)',
      'profitRealCurrency' => 'Lucro (BRL) (Currency)',
      'profitRealConverted' => 'Lucro (BRL) (Converted)',
      'leads' => 'Leads',
      'contacts' => 'Contacts',
      'description' => 'Descrição'
    ],
    'links' => [
      'vendor' => 'Vendor',
      'productBrands' => 'ProductBrand',
      'productBrand' => 'Brand',
      'opportunities' => 'Opportunities',
      'opportunity' => 'Opportunity',
      'oportunidade' => 'Opportunity',
      'leads' => 'Leads',
      'contacts' => 'Contacts'
    ],
    'labels' => [
      'Create Marketing' => 'Criar Origem'
    ],
    'options' => [
      'country' => [
        '' => '',
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA',
        'Costa Rica' => 'Costa Rica',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Ecuador ' => 'Ecuador ',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Mexico' => 'Mexico',
        'Panama' => 'Panama',
        'Guadelouope' => 'Guadelouope',
        'Paraguay' => 'Paraguay',
        'Peru' => 'Peru',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        'Ecuador' => 'Ecuador'
      ],
      'noExpiration' => [
        ' ' => 'Expiration'
      ],
      'category' => [
        'Incentivo' => 'Incentivo',
        'Digital' => 'Digital',
        '' => ''
      ],
      'status' => [
        '' => '',
        'Activo' => 'Active',
        'Inactivo ' => 'Inactive'
      ]
    ],
    'tooltips' => [
      'roi' => 'Soma dos valores das oportunidades ganhas.
Suma de los valores de las oportunidades ganadas.',
      'profit' => 'ROI - Investment = Ganancia

En caso de que el campo no esté actualizado, complete cualquier valor para que la plataforma vuelva a calcular basándose en las oportunidades ganadas.',
      'profitReal' => 'ROI - Investment = Lucro

Caso o campo não esteja atualizado, preencha qualquer valor para que a plataforma refaça o cálculo baseado nas oportunidades ganhas.'
    ]
  ],
  'Messenger' => [
    'fields' => [
      'account' => 'Conta',
      'sendMessage' => 'Send Message',
      'type' => 'Tipo',
      'origin' => 'Origem',
      'channel' => 'Canal',
      'opportunity' => 'Oportunidade',
      'contentAI' => 'Content AI',
      'status' => 'Status',
      'contentReseller' => 'Institucional Revenda',
      'contentClient' => 'Institucional Cliente Final',
      'salesPitch' => 'Benefícios Produto'
    ],
    'links' => [
      'account' => 'Account',
      'opportunity' => 'Oportunidade'
    ],
    'labels' => [
      'Create Messenger' => 'Criar Mensageria'
    ],
    'options' => [
      'type' => [
        'Account' => 'Account'
      ],
      'origin' => [
        'AI' => 'AI'
      ],
      'channel' => [
        'Email' => 'Email'
      ],
      'status' => [
        'Sent' => 'Enviado',
        'Error' => 'Erro',
        '' => '',
        'Created' => 'Solicitado'
      ]
    ]
  ],
  'Migrations' => [
    'fields' => [
      'parent' => 'Parent',
      'dateStart' => 'Data de Início',
      'dateEnd' => 'Data de Conclusão',
      'duration' => 'Duração',
      'status' => 'Status',
      'reminders' => 'Reminders',
      'dateStartDate' => 'Date Start (all day)',
      'dateEndDate' => 'Date End (all day)',
      'isAllDay' => 'Is All-Day',
      'accountManager' => 'Account Manager / Inside Sales',
      'bdmCloud' => 'BDM Cloud',
      'opportunity' => 'Oportunidade',
      'bucketTimers' => 'Duração do Bucket',
      'processOwner' => 'Process Owner',
      'accountIDAWS' => 'AWS Account ID',
      'bucket' => 'Bucket AWS',
      'cancellationReason' => 'Motivo do Cancelamento',
      'checklistConsumo' => 'Checklist Consumo (Billing x Pipeline)',
      'checklistMigration' => 'Checklist Movimentação de Billing | Sales | BDM',
      'checklistPreSales' => 'Checklist Pré-vendas | CoE',
      'completedIn' => 'Concluído em',
      'dueDate' => 'Atrasado',
      'estimateAmount' => 'Valor Estimado',
      'externalID' => 'External ID',
      'jiraCSC' => 'Jira CSC',
      'jiraEngenharia' => 'Jira Engenharia',
      'label' => 'Rótulo',
      'priority' => 'Prioridade',
      'checklistCSC' => 'Checklist Jira | SSCLOUD',
      'lostReason' => 'Justificativa (Oportunidade)',
      'migrationOrigin' => 'Tipo de Migração',
      'partialAmount' => 'Consumo Parcial',
      'partialAmountCurrency' => 'Valor Parcial (Currency)',
      'partialAmountConverted' => 'Valor Parcial (Converted)',
      'bucketMicrosoft' => 'Bucket Microsoft',
      'checklistMicrosoft1' => 'Identificação e proposta (MOSP/EA/T1/DIST)',
      'checklistMicrosoft2' => 'Sequência após aprovação do cliente (MOSP/EA/T1/DIST)',
      'checklistMicrosoft3' => 'Somente para Migração de T1/DIST',
      'checklistMicrosoft4' => 'Somente para Migração MOSP/EA',
      'checklistMicrosoft5' => 'Sequência após aprovação do cliente (MOSP/EA)',
      'checklistMicrosoft' => 'Identificação e proposta (MOSP/EA)',
      'opportunityStage' => 'Estágio da Oportunidade',
      'organizationId' => 'Organization Id | MPN Id',
      'accountId' => 'Account Id | Tenant Id',
      'lastConsumption' => 'Consumo Mês Anterior',
      'lastConsumptionCurrency' => 'Consumo Mês Anterior (Moeda)',
      'lastConsumptionConverted' => 'Consumo Mês Anterior (Convertido)',
      'description' => 'Descrição'
    ],
    'links' => [
      'parent' => 'Parent',
      'accountManager' => 'Account Manager / Inside Sales',
      'bdmCloud' => 'BDM Cloud',
      'opportunity' => 'Oportunidade',
      'bucketTimers' => 'Duração do Bucket',
      'processOwner' => 'Process Owner'
    ],
    'options' => [
      'status' => [
        'Planned' => 'Em andamento',
        'Held' => 'Concluído',
        'Not Held' => 'Não iniciado',
        'Cancelled' => 'Cancelado'
      ],
      'accountIDAWS' => [
        'Digite' => 'Digite e pressione enter'
      ],
      'bucket' => [
        'Upside Pipeline' => 'Upside | Pipeline',
        'Fechado | Movimentação de Billing' => 'Fechado | Movimentação de Billing',
        'Sales | BDM (pendências)' => 'Sales | BDM (pendências)',
        'Validação Pré-vendas | CoE' => 'Validação Pré-vendas | CoE',
        'Jira | SSCLOUD (criação/migração de org)' => 'Jira | SSCLOUD (criação/migração de org)',
        'Acompanhamento Consumo' => 'Acompanhamento Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        'Jira | SSCLOUD' => 'Jira | SSCLOUD (Criação / Migração Organization)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo',
        'Sales | BDM' => 'Sales | BDM (Pendências)',
        '' => ''
      ],
      'checklistConsumo' => [
        'Primeiro billing parcial' => 'Primeiro billing parcial',
        'Billing completo' => 'Billing completo'
      ],
      'checklistMigration' => [
        'Validação sobre tipo de conta do Cliente Final (Standalone, Service Prov)' => 'Validação sobre tipo de conta do Cliente Final (Standalone, Service Prov)',
        'Validação sobre de acordo do Parceiro em Proposta / Condições Comerciais' => 'Validação sobre de acordo do Parceiro em Proposta / Condições Comerciais',
        'Validação sobre aprovação de Crédito para Cliente Final' => 'Validação sobre aprovação de Crédito para Cliente Final',
        'Validação sobre existência de créditos do Hyperscaler para Cliente Final' => 'Validação sobre existência de créditos do Hyperscaler para Cliente Final',
        'Validação sobre plano de suporte contratado na conta' => 'Validação sobre plano de suporte contratado na conta',
        'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas' => 'Criação do documento "Cloud Check-up" / Abertura de chamado Pré-Vendas',
        'Criação do documento Cloud Check-up / Abertura de chamado Pré-Vendas' => 'Criação do documento Cloud Check-up / Abertura de chamado Pré-Vendas',
        'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)' => 'Validação sobre tipo de conta do Cliente Final (Standalone / Service Prov)'
      ],
      'checklistPreSales' => [
        'Validação da estrutura do ambiente do Cliente Final' => 'Validação da estrutura do ambiente do Cliente Final',
        'Validação sobre existência Workloads/Consumo na conta Payer' => 'Validação sobre existência Workloads/Consumo na conta Payer',
        'Validação sobre arquivamento de reports de billing anteriores' => 'Validação sobre arquivamento de reports de billing anteriores',
        'Validação sobre nível de segurança e aderência à Políticas TD Synnex' => 'Validação sobre nível de segurança e aderência à Políticas TD Synnex',
        'Validação sobre existência Instância Reservadas / Saving Plans' => 'Validação sobre existência Instância Reservadas / Saving Plans',
        'Validação sobre existência Políticas de Controle de Serviço (SCPs)' => 'Validação sobre existência Políticas de Controle de Serviço (SCPs)',
        'Validação sobre existência Cost Tags Allocations' => 'Validação sobre existência Cost Tags Allocations',
        'Validação sobre capacidades de Serviço (Parceiro/Cliente Final)' => 'Validação sobre capacidades de Serviço (Parceiro/Cliente Final)',
        'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC' => 'Atualização do documento "Cloud Check-up" / Abertura de chamado CSC',
        'Atualização do documento Cloud Check-up / Abertura de chamado CSC' => 'Atualização do documento Cloud Check-up / Abertura de chamado CSC'
      ],
      'label' => [
        'AWS' => 'AWS',
        '' => 'Selecione',
        'Microsoft' => 'Microsoft'
      ],
      'priority' => [
        '' => '',
        'Low' => 'Baixa',
        'Medium' => 'Média',
        'High' => 'Alta',
        'Urgent' => 'Urgente',
        'Important' => 'Importante'
      ],
      'checklistCSC' => [
        'Abertura do processo administrativo de movimentação' => 'Abertura do processo administrativo de movimentação',
        'Validação sobre conclusão do processo administrativo de movimentação' => 'Validação sobre conclusão do processo administrativo de movimentação',
        'Validação dos contatos principais de acesso ao ambiente' => 'Validação dos contatos principais de acesso ao ambiente'
      ],
      'bucketMicrosoft' => [
        'Upside | Pipeline' => 'Upside | Pipeline',
        'Pré-migração' => 'Pré-migração',
        'Execução T1/DIST (Time SSCLOUD JIRA)' => 'Execução T1/DIST (Time SSCLOUD JIRA)',
        'Execução MOSP/EA (Time Serviços)' => 'Execução MOSP/EA (Time Serviços)',
        'Acompanhamento | Consumo' => 'Acompanhamento | Consumo',
        'Consumo Estimado Concluído' => 'Consumo Estimado Concluído',
        'Cancelado' => 'Cancelado',
        '' => ''
      ],
      'checklistMicrosoft1' => [
        'Identificar origem da migração (MOSP/EA ou Dist/T1)' => 'Identificar origem da migração (MOSP/EA ou Dist/T1)',
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa' => 'Parceiro/Ciente baixar o relatório de consumo detalhado para estimativa',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa' => 'Enviar ao time de engenharia o relatório de consumo detalhado para estimativa',
        'Devolução para o parceiro com resultado do assessment (MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (MOSP/EA)',
        'Devolução para o parceiro com resultado da estimativa' => 'Devolução para o parceiro com resultado da estimativa',
        'Aprovação do cliente e andamento no fluxo' => 'Aprovação do cliente e andamento no fluxo',
        'Identificar origem da migração' => 'Identificar origem da migração'
      ],
      'checklistMicrosoft2' => [
        'Realizar a administração delegada (MOSP/EA/T1/DIST)' => 'Realizar a administração delegada (MOSP/EA/T1/DIST)',
        'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)' => 'Cadastrar o cliente na plataforma StreamOne Stellr (MOSP/EA/T1/DIST)',
        'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)' => 'Incluir um pedido de Azure para o cliente (MOSP/EA/T1/DIST)',
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft3' => [
        'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)' => 'AM abrir solicitação de migração para o time de SSCLOUD (somente T1/DIST)',
        'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)' => 'Time de SSCLOUD executa a solicitação via Partner Center (somente T1/DIST)',
        'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)' => 'Migração aprovada verificação TD SYNNEX se a migração foi concluída (somente T1/DIST)',
        'Migração concluída (somente T1/DIST)' => 'Migração concluída (somente T1/DIST)',
        'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)' => 'Sincronização da assinatura migrada com o contrato no StreamOne Stellr (somente T1/DIST)',
        'Envio do comando Powershell para o cliente (somente T1/DIST)' => 'Envio do comando Powershell para o cliente (somente T1/DIST)',
        'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)' => 'Retorno do cliente que o comando foi executado com sucesso (somente T1/DIST)'
      ],
      'checklistMicrosoft4' => [
        'Agendamento com o cliente para a melhor data (somente MOSP/EA)' => 'Agendamento com o cliente para a melhor data (somente MOSP/EA)',
        'Início da movimentação (somente MOSP/EA)' => 'Início da movimentação (somente MOSP/EA)',
        'Conclusão da movimentação (somente MOSP/EA)' => 'Conclusão da movimentação (somente MOSP/EA)'
      ],
      'checklistMicrosoft5' => [
        'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)' => 'Solicitar ao parceiro/cliente um usuário no modelo tdsynnex@dominiocliente.com.br (Somente MOSP/EA)',
        'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)' => 'Permissão do usuário como contribuidor na assinatura de origem e destino (Somente MOSP/EA)',
        'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)' => 'Enviar todos os dados para o time de serviços dar inicio a movimentação (Somente MOSP/EA)',
        'Time de serviços realiza a pré-migração (Somente MOSP/EA)' => 'Time de serviços realiza a pré-migração (Somente MOSP/EA)',
        'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)' => 'Relatório de pré-migração enviado ao parceiro/cliente para aprovação final (Somente MOSP/EA)'
      ],
      'checklistMicrosoft' => [
        'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)' => 'Parceiro/Cliente baixar o CSV para assessment (Somente MOSP/EA)',
        'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)' => 'Enviar ao time de engenharia os relatórios para assessment (Somente MOSP/EA)',
        'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)' => 'Devolução para o parceiro com resultado do assessment (Somente MOSP/EA)'
      ]
    ],
    'labels' => [
      'Create Migrations' => 'Criar Migrações',
      'Schedule Migrations' => 'Migration Schedule',
      'Log Migrations' => 'Migration Log',
      'Set Held' => 'Set Held',
      'Set Not Held' => 'Set Not Held'
    ],
    'massActions' => [
      'setHeld' => 'Set Held',
      'setNotHeld' => 'Set Not Held'
    ],
    'presetFilters' => [
      'planned' => 'Planned',
      'held' => 'Held',
      'todays' => 'Today\'s'
    ],
    'tooltips' => [
      'checklistConsumo' => 'Acompanhamento de consumo pós migração.',
      'checklistMicrosoft1' => 'Oportunidade criada pelo time de vendas.',
      'checklistMicrosoft2' => 'Início do processo pré-migração.',
      'checklistMicrosoft3' => 'Abertura pelo AM para o time de SSCLOUD para migrações de T1/DIST.',
      'checklistMicrosoft4' => 'Após aprovação do cliente e todos os pré-requisitos de migração inicia-se a migração de fato.',
      'checklistMicrosoft5' => 'Início do processo pré-migração.',
      'checklistMicrosoft' => 'Oportunidade criada pelo time de vendas.',
      'lastConsumption' => 'Consumo do mês anterior.',
      'partialAmount' => 'Consumo parcial.'
    ]
  ],
  'Notifications' => [
    'fields' => [
      'type' => 'Tipo',
      'language' => 'Idioma',
      'banner' => 'Banner',
      'description' => 'Comunicação',
      'createdAt' => 'Data'
    ],
    'links' => [],
    'labels' => [
      'Create Notifications' => 'Criar Notification'
    ],
    'options' => [
      'type' => [
        'Information' => 'Information',
        'Notification' => 'Notification',
        '' => ''
      ],
      'language' => [
        '' => '',
        'Português' => 'Português',
        'Espanhol' => 'Espanhol',
        'Español' => 'Español'
      ]
    ]
  ],
  'NurturingForm' => [
    'fields' => [
      'formID' => 'ID do Form',
      'formData' => 'Resultados do Form',
      'nurturingPrefix' => 'Prefixo da instância',
      'nurturingCountry' => 'País da instância',
      'pushContactToIntegration' => 'Enviar leads para integração',
      'formSource' => 'Origem do formulário',
      'prefix' => 'Prefixo da instância',
      'data' => 'Resultados do Form',
      'description' => 'Descrição'
    ],
    'links' => [],
    'labels' => [
      'Create NurturingForm' => 'Criar Nurturing Form'
    ],
    'tooltips' => [
      'formID' => 'ID do form o qual deseja buscar os resultados. Apenas o número que pode ser visualizado na URL da instância após clicar no formulário.',
      'nurturingPrefix' => 'Prefixo utilizado no banco de dados da instância. Normalmente é composto de 3 caracteres seguidos da _. Ex: abc_
Em caso de dúvidas, consulte equipe técnica.',
      'pushContactToIntegration' => 'Ao marcar este campo, os resultados deste formulário serão adicionados à entidade de Leads. Atenção: caso o lead já exista no CDP, os dados serão atualizados COM EXCEÇÃO DA ORIGEM.',
      'formSource' => 'Nome da campanha da qual este formulário faz parte. É utilizado internamente para análise de performance e resultados das oportunidades geradas.'
    ],
    'options' => [
      'nurturingCountry' => [
        'Selecione' => 'Selecione',
        'Argentina' => 'westconarg',
        'Brasil' => 'westconbra',
        'CCA' => 'westconcca',
        'Colômbia' => 'westconcol',
        'Chile' => 'westconchi',
        'Equador' => 'westconecu',
        'México' => 'westconmex',
        'Peru' => 'westconpex',
        'westconarg' => 'Argentina',
        'westconbra' => 'Brasil',
        'westconcca' => 'CCA',
        'westconcol' => 'Colômbia',
        'westconchi' => 'Chile',
        'westconecu' => 'Ecuador',
        'westconmex' => 'México',
        'westconper' => 'Peru'
      ]
    ]
  ],
  'OpportunityAWS' => [
    'fields' => [
      'opportunityID' => 'Opportunity ID',
      'aWSAccountID' => 'AWS Account ID',
      'stageAWS' => 'Stage AWS',
      'statusAWS' => 'Status AWS',
      'partnerTypeAWS' => 'Partner Type',
      'useCase' => 'Use Case',
      'segment' => 'Segment',
      'estimatedRevenue' => 'estimated Monthly Recurring Revenue',
      'estimatedRevenueCurrency' => 'estimated Monthly Recurring Revenue (Moneda)',
      'estimatedRevenueConverted' => 'estimated Monthly Recurring Revenue (Convertido)',
      'marketplace' => 'Marketplace',
      'sPMSID' => 'SPMS ID',
      'opportunity' => 'Opportunity'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityAWS' => 'Criar Opportunity AWS'
    ],
    'options' => [
      'stageAWS' => [
        '' => '',
        'Committed' => 'Committed',
        'Qualified' => 'Qualified',
        'Prospect' => 'Prospect',
        'Technical Validation' => 'Technical Validation',
        'Business Validation' => 'Business Validation',
        'Closed Lost' => 'Closed Lost',
        'Canceled' => 'Canceled',
        'Launched' => 'Launched',
        'Completed' => 'Completed'
      ],
      'statusAWS' => [
        '' => '',
        'Approved' => 'Approved',
        'Submitted' => 'Submitted',
        'Action Required' => 'Action Required',
        'Rejected' => 'Rejected'
      ],
      'partnerTypeAWS' => [
        '' => '',
        'ISV' => 'ISV',
        'Consulting' => 'Consulting'
      ],
      'useCase' => [
        '' => '',
        'AI/Machine Learning' => 'AI/Machine Learning',
        'Archiving' => 'Archiving',
        'Big Data' => 'Big Data',
        'Business Applications' => 'Business Applications',
        'Cloud Management Tools & DevOps' => 'Cloud Management Tools & DevOps',
        'Containers & Serverless' => 'Containers & Serverless',
        'Database' => 'Database',
        'End User Computing' => 'End User Computing',
        'Energy' => 'Energy',
        'Financial Services' => 'Financial Services',
        'Healthcare & Life Sciences' => 'Healthcare & Life Sciences',
        'Hybrid application platform' => 'Hybrid application platform',
        'Industrial Software' => 'Industrial Software',
        'IOT' => 'IOT',
        'Media & High performance computing (HPC)' => 'Media & High performance computing (HPC)',
        'Migration' => 'Migration',
        'Monitoring, logging and performance' => 'Monitoring, logging and performance',
        'Networking' => 'Networking',
        'Security' => 'Security',
        'Storage' => 'Storage',
        'Training' => 'Training',
        'Web development & DevOps' => 'Web development & DevOps'
      ],
      'segment' => [
        '' => '',
        'AGS' => 'AGS',
        'CS' => 'CS',
        'PS' => 'PS',
        'SUP' => 'SUP'
      ]
    ]
  ],
  'OpportunityGoogle' => [
    'fields' => [
      'nDealRegistration' => 'N° Deal Registration (Si aplica)',
      'categoryGoogle' => 'Category Google',
      'rebates' => 'Rebates',
      'customerSolution' => 'Necesidad/proyecto que tiene el cliente',
      'decisionMakingAuthority' => 'Autoridad para la toma de decisión',
      'clientbudget' => 'Presupuesto con el que cuenta el cliente (Budget)',
      'dR' => 'DR',
      'backend' => 'Backend',
      'googleCalculator' => 'Link de calculadora de Google',
      'amountproxconsumo' => 'Monto Aproximado de Consumo anual',
      'submissionID' => 'Submission ID',
      'opportunity' => 'Opportunity',
      'nameProject' => 'Nombre del Proyecto'
    ],
    'links' => [
      'opportunity' => 'Opportunity'
    ],
    'labels' => [
      'Create OpportunityGoogle' => 'Criar Opportunity Google'
    ],
    'options' => [
      'categoryGoogle' => [
        '' => '',
        'Google Workspace' => 'Google Workspace',
        'Google Cloud Platform' => 'Google Cloud Platform'
      ]
    ]
  ],
  'Orders' => [
    'fields' => [
      'billingCycle' => 'BillingCycle',
      'contractIdExternal' => 'ContractIdExternal',
      'contractType' => 'ContractType',
      'directbilling' => 'Directbilling',
      'discountPricingRules' => 'DiscountPricingRules',
      'discountPricingRulesCurrency' => 'DiscountPricingRules (Currency)',
      'discountPricingRulesConverted' => 'DiscountPricingRules (Converted)',
      'listPrice' => 'ListPrice',
      'listPriceCurrency' => 'ListPrice (Currency)',
      'listPriceConverted' => 'ListPrice (Converted)',
      'markupPricingRules' => 'MarkupPricingRules',
      'pricingType' => 'PricingType',
      'status' => 'Status',
      'subscriptionID' => 'SubscriptionID',
      'subscriptionName' => 'SubscriptionName',
      'subscriptionQuantity' => 'SubscriptionQuantity',
      'subscriptionAmount' => 'SubscriptionAmount',
      'subscriptionAmountCurrency' => 'SubscriptionAmount (Currency)',
      'subscriptionAmountConverted' => 'SubscriptionAmount (Converted)',
      'orderAmount' => 'OrderAmount',
      'orderAmountCurrency' => 'OrderAmount (Currency)',
      'orderAmountConverted' => 'OrderAmount (Converted)',
      'subscriptionAutomaticRenew' => 'SubscriptionAutomaticRenew',
      'endUserAmount' => 'EndUserAmount',
      'endUserAmountCurrency' => 'EndUserAmount (Currency)',
      'endUserAmountConverted' => 'EndUserAmount (Converted)',
      'orderDiscountOnly' => 'OrderDiscountOnly',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'termDuration' => 'TermDuration',
      'assignedUserNameExternal' => 'AssignedUserNameExternal',
      'productName' => 'ProductName',
      'accountName' => 'AccountName',
      'vendorAccountName' => 'VendorAccountName',
      'pricingInfo' => 'PricingInfo',
      'estimate' => 'Estimate',
      'processQueue' => 'ProcessQueue',
      'contractStartDate' => 'ContractStartDate',
      'contractEndDate' => 'ContractEndDate',
      'region' => 'Region',
      'externalId' => 'ExternalId'
    ],
    'links' => [],
    'labels' => [
      'Create Orders' => 'Criar Orders'
    ],
    'options' => [
      'status' => [],
      'processQueue' => [],
      'region' => []
    ]
  ],
  'PBGeral' => [
    'fields' => [
      'account' => 'Account',
      'trilhaCloud' => 'Trilha Cloud',
      'trilhaIOT' => 'Trilha IOT',
      'trilhaSegurana' => 'Trilha Segurança',
      'technologyStatus' => 'Technology Status',
      'analyticStatus' => 'Analytic Status',
      'financialStatus' => 'Financial Status',
      'marketingStatus' => 'Marketing Status',
      'strategyStatus' => 'Strategy Status',
      'country' => 'País',
      'financialStatusCloud' => 'Financial Status Cloud',
      'organizationalStatusCloud' => 'Organizational Status Cloud',
      'salesAndMarketingStatusCloud' => 'Sales And Marketing Status Cloud',
      'strategyStatusCloud' => 'Strategy Status Cloud',
      'technologystatusCloud' => 'Technology Status Cloud',
      'cloudCategory' => 'Categoria Cloud',
      'module' => 'Módulo',
      'percepiumID' => 'Percepium ID',
      'percepiumStatus' => 'Percepium Status',
      'cybersolvsStatus' => 'Cybersolvs Status',
      'networksStatus' => 'Networks Status',
      'endpointStatus' => 'Endpoint Status',
      'mobilesecStatus' => 'Mobilesec Status',
      'dataStatus' => 'Data Status',
      'peopleStatus' => 'People Status',
      'securityStatus' => 'Security Status',
      'cloudStatus' => 'Cloud Status',
      'fraudStatus' => 'Fraud Status',
      'assesmentStatus' => 'Assesment Status',
      'complianceStatus' => 'Compliance Status',
      'policyStatus' => 'Policy Status',
      'trilhaDataAI' => 'Trilha Data AI',
      'dataAICategory' => 'Data AI Category'
    ],
    'links' => [
      'account' => 'Account'
    ],
    'labels' => [
      'Create PBGeral' => 'Criar PB - Geral'
    ],
    'options' => [
      'technologyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'analyticStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'marketingStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'strategyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'financialStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'organizationalStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'salesAndMarketingStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'strategyStatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'technologystatusCloud' => [
        '' => 'Incomplete',
        'Finished' => 'Finalizado',
        'Complete' => 'Completo'
      ],
      'cloudCategory' => [
        '' => '',
        'Starter' => 'Starter',
        'Transformer' => 'Transformer',
        'Accelerator' => 'Accelerator',
        'AWS Onboard the Practice' => 'AWS Onboard the Practice',
        'AWS Startups' => 'AWS Startups',
        'MCPP Transition Path' => 'MCPP Transition Path',
        'Google Cloud Practice Startups' => 'Google Cloud Practice Startups',
        'Google Workspace' => 'Google Workspace',
        'Grow Your HPE GreenLake Practice' => 'Grow Your HPE GreenLake Practice',
        'Develop Your Security Practice' => 'Develop Your Security Practice',
        'Grow Your Security Sales' => 'Grow Your Security Sales'
      ],
      'module' => [
        '' => '',
        'Cloud Practice Builder' => 'Cloud Practice Builder',
        'AWS' => 'AWS',
        'Microsoft' => 'Microsoft',
        'Google' => 'Google',
        'HPE Greenlake' => 'HPE Greenlake',
        'Security' => 'Security'
      ],
      'percepiumStatus' => [
        '' => '',
        'Started' => 'Started',
        'Finished' => 'Finished'
      ],
      'cybersolvsStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'networksStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'endpointStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'mobilesecStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'peopleStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'securityStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'cloudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'fraudStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'assesmentStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'complianceStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'policyStatus' => [
        '' => 'Incomplete',
        'Complete' => 'Completo'
      ],
      'dataAICategory' => [
        '' => '',
        'Aware' => 'Aware',
        'Ready' => 'Ready',
        'Expert' => 'Expert'
      ]
    ]
  ],
  'PartnerID' => [
    'fields' => [
      'account' => 'Conta',
      'productBrand' => 'Fabricante',
      'surestep' => 'Surestep',
      'surestepLevel' => 'Surestep Level',
      'billing' => 'Billing',
      'name' => 'ID',
      'cloudConsumptions' => 'Consumo Cloud',
      'salesOrders' => 'Vendas',
      'type' => 'Tipo',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro',
      'idType' => 'Tipo de ID',
      'source' => 'Source',
      'description' => 'Descrição'
    ],
    'links' => [
      'account' => 'Conta',
      'productBrand' => 'Fabricante',
      'surestep' => 'Surestep',
      'cloudConsumptions' => 'Consumo Cloud',
      'salesOrders' => 'Vendas',
      'partnerPrograms' => 'Programas de parceiro',
      'partnerProgram' => 'Programa de parceiro'
    ],
    'labels' => [
      'Create PartnerID' => 'Criar Partner ID'
    ],
    'options' => [
      'billing' => [
        'Azure' => 'Azure',
        'Office' => 'Office',
        'Cisco' => 'Cisco',
        'AWS' => 'AWS'
      ],
      'type' => [
        'Customer' => 'Customer',
        'Reseller' => 'Reseller',
        'ISVs' => 'ISVs',
        'Service Provider' => 'Service Provider'
      ],
      'idType' => [
        '' => '',
        'MPN ID' => 'MPN ID',
        'Tier 2 MPN ID' => 'Tier 2 MPN ID',
        'Tenant' => 'Tenant',
        'Organization' => 'Organization',
        'Unit Organization' => 'Unit Organization',
        'Account ID' => 'Account ID'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'PartnerProgram' => [
    'fields' => [
      'productBrand' => 'Fabricante',
      'partnerIDs' => 'ID de fabricante',
      'account' => 'Conta'
    ],
    'links' => [
      'productBrand' => 'Fabricante',
      'partnerIDs' => 'ID de fabricante',
      'account' => 'Conta'
    ],
    'labels' => [
      'Create PartnerProgram' => 'Criar Programa de parceiro'
    ]
  ],
  'PartnersGoogleCloud' => [
    'fields' => [
      'partnerLevel' => 'Partner Level',
      'account' => 'Account',
      'partner' => 'Partner',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'googleClouds' => 'Oportunidades Google Cloud',
      'email' => 'Email',
      'fechaefectivaHandshake' => 'Fecha Efectiva Handshake',
      'lineaDeCredito' => 'Linea de credito',
      'opportunities' => 'Opportunities',
      'partnerGoogleCloud' => 'Oportunidades',
      'contact' => 'Contacto',
      'opportunity' => 'Opportunidad',
      'contacts' => 'Contacto',
      'progresoGoogle' => 'Progreso Google',
      'progresoTDSYNNEX' => 'Progreso TDSYNNEX',
      'emailContact' => 'Contact Email',
      'emailPartner' => 'Partner email',
      'documentsSends' => 'Sent documents',
      'opportunitys' => 'Opportunity',
      'accounts' => 'Accouns',
      'accountS' => 'Accounts',
      'expertise' => 'Expertise',
      'sector' => 'Sector',
      'cloudID' => 'Cloud ID',
      'formGCP' => 'Form - GCP',
      'formWorkspace' => 'Form - Workspace',
      'dadoDeAltaConTDSYNNEX' => 'Discharged with TD SYNNEX',
      'gws' => 'Google Workspace',
      'gcp' => 'Google Cloud Platform',
      'gcpLevel' => 'Google Cloud Platform - Level',
      'gwsLevel' => 'Google Workspace - Level',
      'countryAccount' => 'Pais',
      'region' => 'Region',
      'phoneContact' => 'Telefono del Contacto',
      'partnerProgression' => 'Partner Progression',
      'description' => 'Observación - Status',
      'pais' => 'Pais',
      'name' => 'Name',
      'country' => 'Country',
      'documentosEnviados' => 'Documentos Enviados'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'partner' => 'Partner',
      'partnersGoogleClouds' => 'Partners Google Clouds',
      'googleClouds' => 'Oportunidades Google Cloud',
      'opportunities' => 'Opportunities',
      'partnerGoogleCloud' => 'Oportunidades',
      'contact' => 'Contacto',
      'opportunity' => 'Opportunidad',
      'contacts' => 'Contacto',
      'opportunitys' => 'Opportunity',
      'accounts' => 'Accounts',
      'accountS' => 'Accounts'
    ],
    'labels' => [
      'Create PartnersGoogleCloud' => 'Criar Programa - Google Cloud'
    ],
    'options' => [
      'partnerLevel' => [
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        'Onboarding' => 'Onboarding'
      ],
      'progresoGoogle' => [
        'Primer  Contacto' => 'First contact',
        'Primera  Reunión' => 'First meeting',
        'Proceso Enviado Onboarding' => 'Process Sent Onboarding',
        'ID Cloud Enviado' => 'Cloud ID Sent',
        'Listo Handshake' => 'Ready handshake',
        'Documentos Enviados' => 'Documentos Enviados',
        'Linea  Credito' => 'Linea  Credito',
        'Streamone Google' => 'Streamone Google',
        'CloudSolv' => 'CloudSolv',
        'GWS' => 'GWS',
        'GCP' => 'GCP'
      ],
      'progresoTDSYNNEX' => [
        'Documentos Enviados' => 'Documentos Enviados',
        'Linea  Credito' => 'Credit Line',
        'Streamone Google' => 'Streamone Google',
        'CloudSolv' => 'CloudSolv',
        'GWS' => 'GWS',
        'GCP' => 'GCP',
        'Dado de Alta con TDSYNNEX' => 'Dado de Alta con TDSYNNEX',
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX',
        'Primer  Contacto' => 'Primer  Contacto',
        'Primera  Reunión' => 'Primera  Reunión',
        'Proceso Enviado Onboarding' => 'Proceso Enviado Onboarding',
        'ID Cloud Enviado' => 'ID Cloud Enviado',
        'Listo Handshake' => 'Listo Handshake'
      ],
      'expertise' => [
        '' => '',
        'Application Modernization' => 'Application Modernization',
        'Artificial Intelligence' => 'Artificial Intelligence',
        'Data Management' => 'Data Management',
        'Infraestructure Modernization' => 'Infraestructure Modernization',
        'Productivity & Collaboration' => 'Productivity & Collaboration',
        'Security' => 'Security',
        'Smart Analytics' => 'Smart Analytics'
      ],
      'sector' => [
        '' => '',
        'SMB' => 'SMB',
        'Corporate' => 'Corporate',
        'Enterprise' => 'Enterprise',
        'Public Sector ' => 'Public Sector ',
        'Education' => 'Education'
      ],
      'dadoDeAltaConTDSYNNEX' => [
        'Dado de Alta con TD SYNNEX' => 'Dado de Alta con TD SYNNEX',
        'Si ' => 'Si ',
        ' ' => ' Si'
      ],
      'gcpLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ],
      'gwsLevel' => [
        'Onboarding' => 'Onboarding',
        'Member' => 'Member',
        'Partner' => 'Partner',
        'Premier Partner' => 'Premier Partner',
        '' => ''
      ],
      'partnerProgression' => [
        'StreamOne Completed and Working' => 'StreamOne Completed and Working',
        'Partner Approved by Credit' => 'Partner Approved by Credit',
        'Credit Amount Available' => 'Credit Amount Available',
        'Partner Account ID / Public Identifier' => 'Partner Account ID / Public Identifier',
        'Handshake Approved and Sent' => 'Handshake Approved and Sent',
        'Cloudsolv Terms and Conditions Approved' => 'Cloudsolv Terms and Conditions Approved',
        'Sell & Service - Certifications' => 'Sell & Service - Certifications',
        'First Sale' => 'First Sale'
      ],
      'country' => [
        'Argentina' => 'Argentina',
        'Bolivia' => 'Bolivia',
        'Brasil' => 'Brasil',
        'CCA' => 'CCA',
        'Chile' => 'Chile',
        'Colombia' => 'Colombia',
        'Ecuador' => 'Ecuador',
        'Mexico' => 'Mexico',
        'Peru' => 'Peru',
        'Costa Rica' => 'Costa Rica',
        'Dominican Republic' => 'Dominican Republic',
        'El Salvador' => 'El Salvador',
        'Guadelouope' => 'Guadelouope',
        'Guatemala' => 'Guatemala',
        'Honduras' => 'Honduras',
        'Panama' => 'Panama',
        'Paraguay' => 'Paraguay',
        'Puerto Rico' => 'Puerto Rico',
        'Uruguay' => 'Uruguay',
        'Venezuela' => 'Venezuela',
        '' => ''
      ]
    ]
  ],
  'PatchNotes' => [
    'fields' => [
      'releasedate' => 'Data de Lançamento',
      'version' => 'Versão',
      'updatetype' => 'Tipo de Atualização',
      'updatestatus' => 'Status',
      'productBrands' => 'Fabricantes',
      'modaltext' => 'Texto da Modal',
      'displayModal' => 'Exibir Modal',
      'updateType' => 'Tipo',
      'buttonText' => 'Texto do Botão',
      'titleText' => 'Texto do Título',
      'attachment' => 'Anexo'
    ],
    'links' => [
      'productBrands' => 'Fabricantes'
    ],
    'labels' => [
      'Create PatchNotes' => 'Criar Atualizações do CDP'
    ],
    'tooltips' => [
      'releasedate' => 'Indica quando a atualização estará disponível.',
      'version' => 'Por exemplo, v1.0.1, v2.3, etc.'
    ],
    'options' => [
      'updatetype' => [
        '' => '',
        'New Feature' => 'Novidade',
        'Improvements' => 'Melhoria',
        'Bug Fixes' => 'Bug Fixes',
        'Minor Changes' => 'Pequenas Mudanças',
        'Migration' => 'Migration'
      ],
      'updatestatus' => [
        '' => '',
        'Planned' => 'Planejado',
        'In Progress' => 'Em Progresso',
        'Released' => 'Implementado'
      ],
      'updateType' => [
        'Aviso' => 'Aviso',
        'Atualização Disponível' => 'Atualização Disponível',
        'Manutenção Programada' => 'Manutenção Programada',
        '' => ''
      ]
    ]
  ],
  'Platformaccess' => [
    'fields' => [
      'link' => 'Link',
      'description' => 'Descrição'
    ],
    'links' => [],
    'labels' => [
      'Create Platformaccess' => 'Criar CDP Security'
    ]
  ],
  'Portfolio' => [
    'fields' => [
      'target' => 'Target',
      'url' => 'URL'
    ],
    'links' => [],
    'labels' => [
      'Create Portfolio' => 'Criar Portfolio (Calculadora)'
    ]
  ],
  'PrizeRoulette' => [
    'fields' => [
      'accounts' => 'Empresas Participantes',
      'prizeWinner' => 'Ganhador(es)',
      'prize' => 'Prêmio',
      'description' => 'Descrição'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'accounts' => 'Empresas Participantes',
      'prizeWinner' => 'Ganhador(es)'
    ],
    'labels' => [
      'Create PrizeRoulette' => 'Criar Roleta de Prêmio'
    ]
  ],
  'Progama' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Progama' => 'Criar Progama'
    ]
  ],
  'Program' => [
    'fields' => [
      'nivel' => 'Nivel',
      'productBrand' => 'Fabricante',
      'account' => 'Conta'
    ],
    'links' => [
      'productBrand' => 'Fabricante',
      'account' => 'Conta'
    ],
    'labels' => [
      'Create Program' => 'Criar Programa'
    ],
    'options' => [
      'nivel' => [
        'Transformer ' => 'Transformer',
        'Starter ' => 'Starter'
      ]
    ]
  ],
  'ProgramaCloudPracticeBuilder' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas'
    ],
    'labels' => [
      'Create ProgramaCloudPracticeBuilder' => 'Criar Programa - Cloud Practice Builder'
    ]
  ],
  'ProgramaGoogleCloud' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create ProgramaGoogleCloud' => 'Criar Programa - Google Cloud'
    ]
  ],
  'Renewals' => [
    'fields' => [
      'account' => 'Conta',
      'hasRenewals' => 'tem Renovações',
      'renewalsAutoOff30Days' => 'No. Auto-Renew OFF - Próximos 30 dias',
      'renewalsAutoOff60Days' => 'No. Auto-Renew OFF - De 31 a 60 dias',
      'renewalsAutoOff90Days' => 'No. Auto-Renew OFF - De 61 a 90 dias',
      'renewalsEndCustomers30Days' => 'No. de Pedidos - Próximos 30 dias',
      'renewalsEndCustomers60Days' => 'No. de Pedidos - De 31 a 60 dias',
      'renewalsEndCustomers90Days' => 'No. de Pedidos - De 61 a 90 dias',
      'renewalsLicenses30Days' => 'No. de Licenças - Próximos 30 dias',
      'renewalsLicenses60Days' => 'No. de Licenças - De 31 a 60 dias',
      'renewalsLicenses90Days' => 'No. de Licenças - De 61 a 90 dias',
      'renewalsRecommendations90Days' => 'No. de Recomendações Microsoft - Próximos 90 dias',
      'renewalsRecommendationsCopilot90Days' => 'No. de Recomendações Copilot para M365 - Próximos 90 dias',
      'renewalsReservedInstances90Days' => 'No. de Instâncias Reservadas - Próximos 90 dias',
      'renewals90Days' => 'Total Renovações - Next 90 Days',
      'accountRenewals' => 'Conta (Renewals)',
      'accountType' => 'Tipo',
      'description' => 'Descrição'
    ],
    'links' => [
      'account' => 'Conta',
      'accountRenewals' => 'Conta (Renewals)'
    ],
    'labels' => [
      'Create Renewals' => 'Criar Renovações'
    ]
  ],
  'ResultadosFormulariosGoogle' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas'
    ],
    'labels' => [
      'Create ResultadosFormulariosGoogle' => 'Criar Resultados Formularios Google'
    ]
  ],
  'RocketMargins' => [
    'fields' => [],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas'
    ],
    'labels' => [
      'Create RocketMargins' => 'Criar Margens Rocket'
    ]
  ],
  'Services' => [
    'fields' => [
      'version' => 'Versão',
      'stage' => 'Status',
      'account' => 'Operadora / Revenda',
      'productBrand' => 'Fabricante',
      'sellingDate' => 'Data de Venda',
      'sendingDate' => 'Data de Envio',
      'installationRevenue' => 'Receita em Instalação / Implementação',
      'installationRevenueCurrency' => 'Receita em Instalação / Implementação (Currency)',
      'installationRevenueConverted' => 'Receita em Instalação / Implementação (Converted)',
      'supportRevenue' => 'Receita em Suporte',
      'supportRevenueCurrency' => 'Receita em Suporte (Currency)',
      'supportRevenueConverted' => 'Receita em Suporte (Converted)',
      'installationCost' => 'Custo de Instalação / Implementação',
      'installationCostCurrency' => 'Custo de Instalação / Implementação (Currency)',
      'installationCostConverted' => 'Custo de Instalação / Implementação (Converted)',
      'supportCost' => 'Custo de Suporte',
      'supportCostCurrency' => 'Custo de Suporte (Currency)',
      'supportCostConverted' => 'Custo de Suporte (Converted)',
      'type' => 'Serviços Prestados',
      'number' => 'Número',
      'notes' => 'Observações',
      'partner' => 'Executor do Serviço',
      'servicesVersions' => 'Service Versions',
      'supportMarkupPercentage' => 'Markup Suporte (%)',
      'installationMarkupPercentage' => 'Markup Instalação / Implementação (%)',
      'documents' => 'Documentos',
      'winProbability' => 'Probabilidade de Fechamento',
      'update' => 'Update',
      'costVSReceipt' => 'Lucro',
      'costVSReceiptCurrency' => 'Receita Efetiva (Currency)',
      'costVSReceiptConverted' => 'Receita Efetiva (Converted)',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'margem' => 'Margem (%)',
      'custoUSD' => 'Custo (Convertido)',
      'custoUSDCurrency' => 'Custo USD (Currency)',
      'custoUSDConverted' => 'Custo USD (Converted)',
      'faturamento' => 'Faturamento',
      'pOID' => 'PO ID',
      'order' => 'Order',
      'ticket' => 'Ticket',
      'nFParceiro' => 'NF Parceiro',
      'nFSynnex' => 'NF Synnex',
      'custo' => 'Custo',
      'custoCurrency' => 'Custo (Currency)',
      'custoConverted' => 'Custo (Converted)',
      'pO' => 'PO',
      'receita' => 'Receita',
      'receitaCurrency' => 'Receita (Currency)',
      'receitaConverted' => 'Receita (Converted)',
      'servicesBillings' => 'Faturamentos',
      'serviceType' => 'Tipo de Serviço',
      'solicitationDate' => 'Data da Solicitação do Serviço',
      'serviceActivity' => 'Atividade do Serviço',
      'partnerEmail' => 'E-mail (Revenda)',
      'serviceAmountTotal' => 'Valor Bruto do Serviço (BRL)',
      'serviceAmountTotalCurrency' => 'Valor Bruto do Serviço (Currency)',
      'serviceAmountTotalConverted' => 'Valor Bruto do Serviço (Converted)',
      'serviceAmountTotalUSD' => 'Valor Bruto do Serviço (USD)',
      'serviceAmountTotalUSDCurrency' => 'Valor Bruto do Serviço (USD) (Currency)',
      'serviceAmountTotalUSDConverted' => 'Valor Bruto do Serviço (USD) (Converted)',
      'partnerCommission' => 'Comissão da Revenda',
      'partnerCommissionCurrency' => 'Comissão da Revenda (Currency)',
      'partnerCommissionConverted' => 'Comissão da Revenda (Converted)',
      'serviceProvider' => 'Provedor de Serviço',
      'netRevenueCloud' => 'Receita Líquida (Com Impostos)',
      'netRevenueCloudCurrency' => 'Receita Líquida (Com impostos) (Currency)',
      'netRevenueCloudConverted' => 'Receita Líquida (Com impostos) (Converted)',
      'consumptionEstimate' => 'Estimativa de Consumo (Mensal)',
      'consumptionEstimateCurrency' => 'Estimativa de Consumo (Mensal) (Currency)',
      'consumptionEstimateConverted' => 'Estimativa de Consumo (Mensal) (Converted)',
      'billingType' => 'Tipo de Faturamento',
      'cancelReason' => 'Motivo de Cancelamento',
      'projectType' => 'Tipo do Projeto',
      'endUser' => 'Cliente Final',
      'endUserEmail' => 'Cliente Final (E-mail)',
      'mso' => 'MSO',
      'quantity' => 'Quantidade de vagas',
      'opportunityType' => 'Tipo de Oportunidade',
      'dollarAmount' => 'Cotação do Dólar',
      'tax' => 'Impostos (%)',
      'servicePartnerValue' => 'Valor do Parceiro de Serviço',
      'servicePartnerValueCurrency' => 'Valor do parceiro de serviço (Currency)',
      'servicePartnerValueConverted' => 'Valor do parceiro de serviço (Converted)',
      'followup' => 'Follow Up',
      'startDate' => 'Data de Início',
      'endDate' => 'Data de Conclusão',
      'billingSituation' => 'Situação Financeira',
      'serviceProviderVarchar' => 'Prestador de Serviços',
      'totalCost' => 'Custo Total',
      'totalCostCurrency' => 'Custo Total (Currency)',
      'totalCostConverted' => 'Custo Total (Converted)',
      'totalRevenue' => 'Receita Total',
      'totalRevenueCurrency' => 'Receita Total (Currency)',
      'totalRevenueConverted' => 'Receita Total (Converted)',
      'trainingName' => 'Nome do Treinamento',
      'partnerNumber' => 'Partner Number',
      'tipo' => 'Tipo',
      'products' => 'Produtos',
      'opportunityItems' => 'Itens',
      'salesOrderItems' => 'Sales Order Items',
      'name' => 'Nome da Oportunidade (Projeto)',
      'description' => 'Nome da Proposta'
    ],
    'links' => [
      'account' => 'Operadora / Revenda',
      'productBrand' => 'Fabricante',
      'partner' => 'Parceiro Executor',
      'servicesVersions' => 'Service Versions',
      'documents' => 'Documentos',
      'servicesBillings' => 'Faturamentos',
      'serviceProvider' => 'Provedor de Serviço',
      'endUser' => 'Cliente Final',
      'products' => 'Produtos',
      'opportunityItems' => 'Itens',
      'salesOrderItems' => 'Sales Order Items'
    ],
    'labels' => [
      'Create Services' => 'Criar Services (Old)'
    ],
    'options' => [
      'stage' => [
        '' => 'N/A',
        'Ganho' => 'Ganho',
        'Possível' => 'Em negociação',
        'Perdido' => 'Perdido / Cancelado',
        'Cancelada' => 'Cancelada',
        'Enviada' => 'Enviada',
        'Pendente de informação' => 'Pendente de informação',
        'Revisado' => 'Revisado',
        'Em vias de fechamento' => 'Em vias de fechamento',
        'Criação Indevida' => 'Criação Indevida',
        'Ainda temos chance' => 'Ainda temos chance',
        'Faturado' => 'Faturado'
      ],
      'type' => [
        'Cloud' => 'Cloud',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Treinamento' => 'Treinamento',
        'Suporte' => 'Suporte',
        'Educação' => 'Educação'
      ],
      'winProbability' => [
        10 => '10%',
        20 => '20%',
        40 => '40%',
        80 => '80%',
        100 => '100%',
        '' => '0'
      ],
      'faturamento' => [
        'Faturado' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando pedido' => 'Aguardando pedido',
        'Em negociação' => 'Em negociação',
        '' => ''
      ],
      'serviceType' => [
        '' => '',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Serviços Cloud' => 'Serviços Cloud',
        'Treinamento' => 'Treinamento'
      ],
      'serviceActivity' => [
        '' => '',
        'Serviço de DNS' => 'Serviço de DNS',
        'Migração de recursos do Azure entre Tenants' => 'Migração de recursos do Azure entre Tenants',
        'Migração de VM' => 'Migração de VM',
        'Suporte' => 'Suporte',
        'Implementação de Serviço de DLP' => 'Implementação de Serviço de DLP',
        'Implementação' => 'Implementação'
      ],
      'billingType' => [
        '' => '',
        'Cliente' => 'Cliente',
        'Revenda' => 'Revenda'
      ],
      'projectType' => [
        '' => '',
        'Partner to Partner' => 'Partner to Partner',
        'Ficha de Oferta' => 'Ficha de Oferta',
        'MOSP para CSP' => 'MOSP para CSP'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento' => 'Recebimento (Venda)'
      ],
      'billingSituation' => [
        'Aguardando para Faturar' => 'Aguardando para Faturar',
        'Em Faturamento' => 'Em Faturamento',
        'Faturado' => 'Faturado',
        'Serviço Free' => 'Free'
      ]
    ],
    'tooltips' => [
      'installationMarkupPercentage' => 'Valores entre 0-100.',
      'tax' => 'Não colocar "%", apenas o valor do Imposto.'
    ]
  ],
  'ServicesBilling' => [
    'fields' => [
      'services' => 'Proposta',
      'stage' => 'Estágio',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'ticket' => 'Ticket',
      'cost' => 'Custo',
      'costCurrency' => 'Cost (Currency)',
      'costConverted' => 'Cost (Converted)',
      'costUSD' => 'Custo (USD)',
      'costUSDCurrency' => 'Custo (USD) (Currency)',
      'costUSDConverted' => 'Custo (USD) (Converted)',
      'income' => 'Receita',
      'incomeCurrency' => 'Receita (Currency)',
      'incomeConverted' => 'Receita (Converted)',
      'nfSYNNEX' => 'NF SYNNEX',
      'nfPartner' => 'NF Parceiro',
      'margin' => 'Margem (%)',
      'po' => 'PO',
      'poID' => 'PO ID',
      'order' => 'Order',
      'billingIssue' => 'Emissão',
      'billingPayment' => 'Data de Pagamento do Custo',
      'account' => 'Executor do Serviço',
      'ov' => 'OV',
      'vpo' => 'VPO',
      'servicesVersions' => 'Versões Serviços',
      'opportunityType' => 'Tipo de Oportunidade',
      'amount' => 'Valor',
      'amountCurrency' => 'Valor (Currency)',
      'amountConverted' => 'Valor (Converted)',
      'dollarAmount' => 'Cotação do Dólar',
      'tax' => 'Impostos',
      'recalculate' => 'Recalculate',
      'service' => 'Proposta',
      'billing' => 'Faturamento',
      'description' => 'Descrição / Observação'
    ],
    'links' => [
      'services' => 'Proposta',
      'account' => 'Executor do Serviço',
      'servicesVersions' => 'Versões Serviços',
      'service' => 'Proposta'
    ],
    'labels' => [
      'Create ServicesBilling' => 'Criar Faturamento'
    ],
    'options' => [
      'stage' => [
        '' => '',
        'Faturado' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando Pedido' => 'Aguardando Pedido',
        'Em Negociação' => 'Em Negociação'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento' => 'Recebimento',
        'Recebimento (Venda)' => 'Recebimento (Venda)'
      ]
    ]
  ],
  'ServicesVersions' => [
    'fields' => [
      'installationCost' => 'Custo de Instalação / Implementação',
      'installationCostCurrency' => 'Custo de Instalação / Implementação (Currency)',
      'installationCostConverted' => 'Custo de Instalação / Implementação (Converted)',
      'installationRevenue' => 'Receita em Instalação / Implementação',
      'installationRevenueCurrency' => 'Receita em Instalação / Implementação (Currency)',
      'installationRevenueConverted' => 'Receita em Instalação / Implementação (Converted)',
      'notes' => 'Observações',
      'sellingDate' => 'Data de Venda',
      'sendingDate' => 'Data de Envio',
      'supportCost' => 'Custo de Suporte',
      'supportCostCurrency' => 'Custo de Suporte (Currency)',
      'supportCostConverted' => 'Custo de Suporte (Converted)',
      'supportRevenue' => 'Receita em Suporte',
      'supportRevenueCurrency' => 'Receita em Suporte (Currency)',
      'supportRevenueConverted' => 'Receita em Suporte (Converted)',
      'version' => 'Versão',
      'services' => 'Services (Old)',
      'account' => 'Operadora / Revenda',
      'partner' => 'Executor do Serviço',
      'stage' => 'Estágio',
      'type' => 'Serviços Prestados',
      'number' => 'Número',
      'productBrand' => 'Fabricante',
      'installationMarkupPercentage' => 'Markup Instalação / Implementação (%)',
      'supportMarkupPercentage' => 'Markup Suporte (%)',
      'winProbability' => 'Probabilidade de Fechamento',
      'revenueNet' => 'Revenue Net',
      'revenueNetCurrency' => 'Revenue Net (Currency)',
      'revenueNetConverted' => 'Revenue Net (Converted)',
      'revenue' => 'Revenue',
      'revenueCurrency' => 'Revenue (Currency)',
      'revenueConverted' => 'Revenue (Converted)',
      'margem' => 'Margem%',
      'custoUSD' => 'Custo USD',
      'custoUSDCurrency' => 'Custo USD (Currency)',
      'custoUSDConverted' => 'Custo USD (Converted)',
      'faturamento' => 'Faturamento',
      'pOID' => 'PO ID',
      'order' => 'Order',
      'ticket' => 'Ticket',
      'nFParceiro' => 'NF Parceiro',
      'nFSynnex' => 'NF Synnex',
      'receita' => 'Receita',
      'receitaCurrency' => 'Receita (Currency)',
      'receitaConverted' => 'Receita (Converted)',
      'custo' => 'Custo',
      'custoCurrency' => 'Custo (Currency)',
      'custoConverted' => 'Custo (Converted)',
      'prestadorDeServios' => 'Prestador de serviços',
      'pO' => 'PO',
      'billingType' => 'Tipo de Faturamento',
      'cancelReason' => 'Motivo de Cancelamento',
      'consumptionEstimate' => 'Estimativa de Consumo (Mensal)',
      'consumptionEstimateCurrency' => 'Estimativa de Consumo (Mensal) (Currency)',
      'consumptionEstimateConverted' => 'Estimativa de Consumo (Mensal) (Converted)',
      'costVSReceipt' => 'Lucro',
      'costVSReceiptCurrency' => 'Receita Efetiva (Currency)',
      'costVSReceiptConverted' => 'Receita Efetiva (Converted)',
      'endUser' => 'Cliente Final',
      'documents' => 'Documentos',
      'endUserEmail' => 'Cliente Final (E-mail)',
      'netRevenueCloud' => 'Receita Líquida (Com Impostos)',
      'netRevenueCloudCurrency' => 'Receita Líquida (Com Impostos) (Currency)',
      'netRevenueCloudConverted' => 'Receita Líquida (Com Impostos) (Converted)',
      'partnerCommission' => 'Comissão da Revenda',
      'partnerCommissionCurrency' => 'Comissão da Revenda (Currency)',
      'partnerCommissionConverted' => 'Comissão da Revenda (Converted)',
      'partnerEmail' => 'E-mail (Revenda)',
      'projectType' => 'Tipo do Projeto',
      'serviceActivity' => 'Atividade do Serviço',
      'serviceAmountTotal' => 'Valor Bruto do Serviço (BRL)',
      'serviceAmountTotalCurrency' => 'Valor Bruto do Serviço (BRL) (Currency)',
      'serviceAmountTotalConverted' => 'Valor Bruto do Serviço (BRL) (Converted)',
      'serviceAmountTotalUSD' => 'Valor Bruto do Serviço (USD)',
      'serviceAmountTotalUSDCurrency' => 'Valor Bruto do Serviço (USD) (Currency)',
      'serviceAmountTotalUSDConverted' => 'Valor Bruto do Serviço (USD) (Converted)',
      'serviceType' => 'Tipo de Serviço',
      'serviceProvider' => 'Provedor de Serviço',
      'servicesBillings' => 'Faturamentos',
      'solicitationDate' => 'Data da Solicitação do Serviço',
      'billingSituation' => 'Situação Financeira',
      'dollarAmount' => 'Cotação do Dólar',
      'endDate' => 'Data de Conclusão',
      'followup' => 'Follow Up',
      'mso' => 'MSO',
      'opportunityType' => 'Tipo de Oportunidade',
      'quantity' => 'Quantidade de vagas',
      'servicePartnerValue' => 'Valor do Parceiro de Serviço',
      'servicePartnerValueCurrency' => 'Valor do Parceiro de Serviço (Currency)',
      'servicePartnerValueConverted' => 'Valor do Parceiro de Serviço (Converted)',
      'tax' => 'Impostos (%)',
      'startDate' => 'Data de Início',
      'serviceProviderVarchar' => 'Prestador de Serviços',
      'totalCost' => 'Custo Total',
      'totalCostCurrency' => 'Custo Total (Currency)',
      'totalCostConverted' => 'Custo Total (Converted)',
      'tipo' => 'Tipo',
      'totalRevenue' => 'Receita Total',
      'totalRevenueCurrency' => 'Receita Total (Currency)',
      'totalRevenueConverted' => 'Receita Total (Converted)',
      'trainingName' => 'Nome do Treinamento',
      'service' => 'Services',
      'name' => 'Nome da Oportunidade (Projeto)',
      'description' => 'Nome da Proposta'
    ],
    'links' => [
      'services' => 'Services (Old)',
      'account' => 'Operadora / Revenda / Canal',
      'partner' => 'Parceiro Executor',
      'productBrand' => 'Fabricante',
      'endUser' => 'Cliente Final',
      'documents' => 'Documentos',
      'serviceProvider' => 'Provedor de Serviço',
      'servicesBillings' => 'Faturamentos',
      'service' => 'Services'
    ],
    'labels' => [
      'Create ServicesVersions' => 'Criar Versões de Serviço'
    ],
    'options' => [
      'stage' => [
        '' => 'N/A',
        'Cancelada' => 'Cancelada',
        'Enviada' => 'Enviada',
        'Ganho' => 'Ganho',
        'N/A' => 'N/A',
        'Perdido' => 'Perdido / Cancelado',
        'Possível' => 'Em negociação',
        'Pendente de informação' => 'Pendente de informação',
        'Revisado' => 'Revisado',
        'Em vias de fechamento' => 'Em vias de fechamento'
      ],
      'type' => [
        'Cloud' => 'Cloud',
        'Educação' => 'Educação',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Suporte' => 'Suporte',
        'Treinamento' => 'Treinamento'
      ],
      'winProbability' => [
        10 => '10%',
        20 => '20%',
        40 => '40%',
        80 => '80%',
        100 => '100%',
        '' => '0'
      ],
      'faturamento' => [
        '' => 'Faturado',
        'Será Faturado' => 'Será Faturado',
        'Aguardando pedido' => 'Aguardando pedido',
        'Em negociação' => 'Em negociação'
      ],
      'billingType' => [
        '' => '',
        'Cliente' => 'Cliente',
        'Revenda' => 'Revenda'
      ],
      'projectType' => [
        '' => '',
        'Partner to Partner' => 'Partner to Partner',
        'Ficha de Oferta' => 'Ficha de Oferta'
      ],
      'serviceActivity' => [
        '' => '',
        'Serviço de DNS' => 'Serviço de DNS',
        'Migração de recursos do Azure entre Tenants' => 'Migração de recursos do Azure entre Tenants',
        'Migração de VM' => 'Migração de VM',
        'Suporte' => 'Suporte',
        'Implementação de Serviço de DLP' => 'Implementação de Serviço de DLP',
        'Implementação' => 'Implementação'
      ],
      'serviceType' => [
        '' => '',
        'Serviços Profissionais' => 'Serviços Profissionais',
        'Serviços Cloud' => 'Serviços Cloud',
        'Treinamentos' => 'Treinamentos',
        'Treinamento' => 'Treinamentos'
      ],
      'billingSituation' => [
        'Aguardando para Faturar' => 'Aguardando para Faturar',
        'Em Faturamento' => 'Em Faturamento',
        'Faturado' => 'Faturado',
        'Free' => 'Free'
      ],
      'opportunityType' => [
        '' => '',
        'Pagamento' => 'Pagamento',
        'Recebimento' => 'Recebimento'
      ]
    ],
    'tooltips' => [
      'tax' => 'Não colocar "%", apenas o valor do Imposto.'
    ]
  ],
  'Source' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Source' => 'Criar Source'
    ]
  ],
  'Sources' => [
    'fields' => [],
    'links' => [],
    'labels' => [
      'Create Sources' => 'Criar Sources'
    ]
  ],
  'Surestep' => [
    'fields' => [
      'newPartner' => 'New Partner to Activate',
      'activateToInspire' => 'Activate to Inspire',
      'inspireToSkyrocketNominee' => 'Inspire to Skyrocket Nominee',
      'skyrocketNomineeToSkyrocket' => 'Skyrocket Nominee to Skyrocket',
      'account' => 'Account',
      'country' => 'Country',
      'readyToInspire' => 'Ready to Inspire',
      'readyToSkyrocketNominee' => 'Ready to Skyrocket Nominee',
      'readyToSkyrocket' => 'Ready to Skyrocket',
      'readyToActivate' => 'Ready to Activate',
      'surestepLevel' => 'Surestep Level',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'mpnNumber' => 'MPN ID Number',
      'accountNumber' => 'Account Number',
      'lead' => 'Lead',
      'levelVerification' => 'LevelVerification',
      'consumptionDate' => 'Consumption Date',
      'cPB' => 'CPB',
      'account1' => 'Account1',
      'countrySurestep' => 'Country - Surestep'
    ],
    'links' => [
      'meetings' => 'Reuniões',
      'calls' => 'Calls',
      'tasks' => 'Tarefas',
      'account' => 'Account',
      'partnerID' => 'Partner ID',
      'partnerIDs' => 'Partner IDs',
      'lead' => 'Lead',
      'cPB' => 'CPB',
      'account1' => 'Account1'
    ],
    'labels' => [
      'Create Surestep' => 'Criar Surestep'
    ],
    'options' => [
      'newPartner' => [
        'Contact Form Completed' => 'Contact Form Completed',
        '1:1 Meeting with Surestep Ambassador' => '1:1 Meeting with Surestep Ambassador',
        'Skill Mapping (Assessment)' => 'Skill Mapping (Assessment)'
      ],
      'activateToInspire' => [
        'TD / SYNNEX Account Number' => 'TD / SYNNEX Account Number',
        'MPN ID' => 'MPN ID',
        'Partner Center Complete Training' => 'Partner Center Complete Training',
        'One Consumption (Last 3 Months)' => 'One Consumption (Last 3 Months)',
        'One Fundamental Certification' => 'One Fundamental Certification',
        '1Q Business Plan Approval and Execution' => '1Q Business Plan Approval and Execution'
      ],
      'inspireToSkyrocketNominee' => [
        'Action Pack Acquisition' => 'Action Pack Acquisition',
        'Silver or Gold Competency' => 'Silver or Gold Competency',
        'Recurrent Consumption (Last Quarter)' => 'Recurrent Consumption (Last Quarter)',
        '1H Business Plan Approval and Execution' => '1H Business Plan Approval and Execution'
      ],
      'skyrocketNomineeToSkyrocket' => [
        'Approval and Nomination (Microsoft Team)' => 'Approval and Nomination (Microsoft Team)',
        'Approval' => 'Approval',
        'Nomination' => 'Nomination'
      ],
      'surestepLevel' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR',
        '' => '',
        'In Process' => 'In Process to Activate'
      ],
      'levelVerification' => [
        'New Partner' => 'New Partner',
        'Activate' => 'Activate',
        'Inspire' => 'Inspire',
        'SKR' => 'SKR',
        'TopSKR' => 'TopSKR'
      ],
      'countrySurestep' => []
    ],
    'tooltips' => [
      'readyToActivate' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToInspire' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocket' => 'Please, confirm to end the Surestep Process. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.',
      'readyToSkyrocketNominee' => 'Please, confirm to follow to the next step. You won\'t be able to revert this action after saving, if you don\'t want to go to the next step, please cancel.'
    ]
  ],
  'TechnicalSupport' => [
    'fields' => [
      'opportunities' => 'Opportunities'
    ],
    'links' => [
      'opportunities' => 'Opportunities'
    ],
    'labels' => [
      'Create TechnicalSupport' => 'Criar TechnicalSupport'
    ]
  ],
  'TourContent' => [
    'fields' => [
      'content' => 'Content',
      'entity' => 'Entity',
      'language' => 'Language',
      'selector' => 'Selector',
      'step' => 'Step',
      'title' => 'Title'
    ],
    'links' => [],
    'labels' => [
      'Create TourContent' => 'Criar TourContent'
    ],
    'options' => [
      'language' => [
        'en_US' => 'en_US',
        'pt_BR' => 'pt_BR',
        'es_MX' => 'es_MX',
        'select' => 'Select'
      ]
    ]
  ],
  'VendorAccount' => [
    'fields' => [
      'partnershipType' => 'PartnershipType',
      'productBrand' => 'Product Brand',
      'account' => 'Account',
      'source' => 'Source'
    ],
    'links' => [
      'productBrand' => 'Product Brand',
      'account' => 'Account'
    ],
    'labels' => [
      'Create VendorAccount' => 'Criar VendorAccount'
    ],
    'options' => [
      'partnershipType' => [
        'Distributor' => 'Distributor',
        'Reseller' => 'Reseller',
        'Customer' => 'Customer'
      ],
      'source' => [
        'CIS' => 'CIS',
        'Cloudsolv' => 'Cloudsolv',
        'Microsoft_Partner_Center' => 'Microsoft_Partner_Center',
        '' => ''
      ]
    ]
  ],
  'VendorCloudConsumption' => [
    'fields' => [
      'productBrands' => 'Product Brands',
      'category' => 'Category',
      'region' => 'Region',
      'resellerName' => 'ResellerName',
      'usageperiod' => 'Usage_period',
      'subscriptionId' => 'SubscriptionId',
      'cost' => 'Cost',
      'costCurrency' => 'Cost (Currency)',
      'costConverted' => 'Cost (Converted)',
      'price' => 'Price',
      'priceCurrency' => 'Price (Currency)',
      'priceConverted' => 'Price (Converted)',
      'lastDay1' => 'Last day 1',
      'lastDay2' => 'Last day 2',
      'lastDay3' => 'Last day 3',
      'alertLevel' => 'Alert Level',
      'budgetAlert' => 'Budget Alert',
      'forecast' => 'Forecast',
      'forecastCurrency' => 'Forecast (Currency)',
      'forecastConverted' => 'Forecast (Converted)',
      'endCustomer' => 'End Customer',
      'lastUpdated' => 'Last Updated',
      'description' => 'Updated at:',
      'rocketURL' => 'Rocket',
      'salesOrder' => 'Sales Order',
      'top10' => 'Top 10',
      'customerId' => 'CustomerId',
      'country' => 'Country',
      'billingPeriodConverted' => 'BillingPeriodConverted',
      'resellerId' => 'ResellerId',
      'usage' => 'Usage (Quantity)',
      'invoiceId' => 'InvoiceId',
      'vendorSubscription' => 'Vendor Subscription',
      'partnerName' => 'Partner Name',
      'partnerId' => 'PartnerId',
      'lastUpdate' => 'Last Update'
    ],
    'links' => [
      'productBrands' => 'Product Brands',
      'salesOrder' => 'Sales Order',
      'vendorSubscription' => 'Vendor Subscription'
    ],
    'labels' => [
      'Create VendorCloudConsumption' => 'Criar VendorCloudConsumption'
    ],
    'options' => [
      'category' => [
        'AWS' => 'AWS',
        'GCP' => 'GCP',
        'AZURE' => 'AZURE',
        'LICENSE' => 'LICENSE',
        '' => '',
        'OFFICE' => 'NCE',
        'OFFICE-USAGE' => 'Legacy'
      ],
      'alertLevel' => [
        'None' => 'None',
        'Yellow' => 'Yellow',
        'Orange' => 'Orange',
        'Red' => 'Red'
      ],
      'country' => [
        'COL' => 'COL',
        'CCA' => 'CCA',
        'ECU' => 'ECU',
        'ARG' => 'ARG',
        'PER' => 'PER',
        'CHI' => 'CHI',
        'BRA' => 'BRA',
        '' => '',
        'MEX' => 'MEX'
      ]
    ]
  ],
  'VendorContract' => [
    'fields' => [
      'periodoImportado' => 'periodoImportado',
      'contratoMs' => 'contratoMs',
      'tipo' => 'tipo',
      'fornecedor' => 'fornecedor',
      'nomeFornecedor' => 'nomeFornecedor',
      'directBilling' => 'directBilling',
      'clienteFaturamento' => 'clienteFaturamento',
      'descricaoCliente' => 'descricaoCliente',
      'descricaoRevendedor' => 'descricaoRevendedor',
      'codItem' => 'codItem',
      'descricaoItem' => 'descricaoItem',
      'chargeType' => 'chargeType',
      'syndicationPartnerSubscriptionNumber' => 'syndicationPartnerSubscriptionNumber',
      'quantidade' => 'quantidade',
      'precoUnitario' => 'precoUnitario',
      'valorTotal' => 'valorTotal',
      'descContrato' => 'descContrato',
      'acresContrato' => 'acresContrato',
      'descRevenda' => 'descRevenda',
      'vlrPercentualComissao' => 'vlrPercentualComissao',
      'valorComissao' => 'valorComissao',
      'resellerUnitPrice' => 'resellerUnitPrice',
      'totalRV' => 'totalRV',
      'endUserUnitPrice' => 'endUserUnitPrice',
      'totalCF' => 'totalCF',
      'tblPreco' => 'tblPreco',
      'orderId' => 'orderId',
      'invoice' => 'invoice',
      'dataAprovManual' => 'dataAprovManual',
      'usuarioAprovManual' => 'usuarioAprovManual',
      'usuario' => 'usuario',
      'horaAprov' => 'horaAprov',
      'facturaVenta' => 'facturaVenta',
      'ordenCompra' => 'ordenCompra',
      'log' => 'log',
      'nfGerada' => 'nfGerada',
      'subCategoria' => 'subCategoria',
      'inicioCobranca' => 'InicioCobranca',
      'fimCobranca' => 'FimCobranca',
      'statusContrato' => 'StatusContrato',
      'paises' => 'Paises',
      'revendedor' => 'revendedor'
    ],
    'links' => [],
    'labels' => [
      'Create VendorContract' => 'Criar VendorContract'
    ],
    'options' => [
      'statusContrato' => [
        'Faturado' => 'Faturado',
        'Crédito Vinculado' => 'Crédito Vinculado',
        'Não Validado' => 'Não Validado',
        'NF Devolvida' => 'NF Devolvida',
        'Validado' => 'Validado',
        '' => ''
      ],
      'paises' => [
        'TD SYNNEX CALA, INC' => 'TD SYNNEX CALA, INC',
        'TD SYNNEX CHILE LIMITADA' => 'TD SYNNEX CHILE LIMITADA',
        'TD SYNNEX COLOMBIA' => 'TD SYNNEX COLOMBIA',
        'TD SYNNEX ECUADOR CIA. LTDA.' => 'TD SYNNEX ECUADOR CIA. LTDA.',
        'TD SYNNEX PERU S.A.C.' => 'TD SYNNEX PERU S.A.C.',
        'WESTCON ARGENTINA' => 'WESTCON ARGENTINA'
      ]
    ]
  ],
  'VendorSubscription' => [
    'fields' => [
      'account' => 'Account',
      'vendorSubscriptionId' => 'VendorSubscriptionId',
      'status' => 'Status',
      'quantity' => 'Quantity',
      'offerId' => 'OfferId',
      'unitType' => 'UnitType',
      'hasPurchasableAddons' => 'HasPurchasableAddons',
      'creationDate' => 'CreationDate',
      'effectiveStartDate' => 'EffectiveStartDate',
      'commitmentEndDate' => 'CommitmentEndDate',
      'commitmentEndDateTime' => 'CommitmentEndDateTime',
      'cancellationAllowedUntilDate' => 'CancellationAllowedUntilDate',
      'billingCycleEndDate' => 'BillingCycleEndDate',
      'billingCycleEndDateTime' => 'BillingCycleEndDateTime',
      'autoRenewEnabled' => 'AutoRenewEnabled',
      'billingType' => 'BillingType',
      'billingCycle' => 'BillingCycle',
      'termDuration' => 'TermDuration',
      'renewalTermDuration' => 'RenewalTermDuration',
      'isMicrosoftProduct' => 'IsMicrosoftProduct',
      'partnerId' => 'PartnerId',
      'contractType' => 'ContractType',
      'orderId' => 'OrderId',
      'partnerName' => 'PartnerName',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions',
      'publisherName' => 'PublisherName',
      'isTrial' => 'IsTrial',
      'country' => 'Country',
      'offerName' => 'OfferName',
      'externalIDcdp' => 'ExternalIDcdp'
    ],
    'links' => [
      'account' => 'Account',
      'vendorCloudConsumptions' => 'Vendor Cloud Consumptions'
    ],
    'labels' => [
      'Create VendorSubscription' => 'Criar VendorSubscription'
    ],
    'options' => [
      'status' => [
        'active' => 'Active',
        'deleted' => 'Deleted',
        'suspended' => 'Suspended',
        'disabled' => 'Disabled',
        'expired' => 'Expired'
      ],
      'country' => [
        'UR' => 'UR',
        'MX' => 'MX',
        'BR' => 'BR',
        'CO' => 'CO',
        'PA' => 'PA',
        'AR' => 'AR',
        'EC' => 'EC',
        'CL' => 'CL',
        'PE' => 'PE',
        '' => ''
      ]
    ]
  ],
  'Prospect' => [
    'fields' => [
      'name' => 'Nome',
      'emailAddress' => 'E-mail',
      'title' => 'Cargo',
      'website' => 'Website',
      'accountName' => 'Conta',
      'phone' => 'Telefone',
      'phoneOffice' => 'Telefone (Comercial)',
      'fax' => 'Fax',
      'doNotCall' => 'Não Ligar',
      'address' => 'Endereço',
      'description' => 'Descrição'
    ],
    'links' => [],
    'labels' => [
      'Create Prospect' => 'Criar Prospecto',
      'Convert to Lead' => 'Converter para Lead'
    ]
  ]
];
