<?php
return [
  'afterRecordSaved' => [
    'ISVExperience' => [
      0 => [
        'id' => '629684c54d54ea2d3',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'consumption',
            'type' => 'all',
            'subject' => '500',
            'value' => 500
          ],
          1 => (object) [
            'comparison' => 'lessThan',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'consumption',
            'type' => 'all',
            'subject' => '3500',
            'value' => 3500
          ],
          2 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'consumption',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'level'
            ],
            'fields' => (object) [
              'level' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'level' => 'Inspire'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'u1zjc6bkwq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '629688b383cc08b04',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'consumption',
            'type' => 'all',
            'subject' => '3500',
            'value' => 3500
          ],
          1 => (object) [
            'comparison' => 'lessThan',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'consumption',
            'type' => 'all',
            'subject' => '5000',
            'value' => 5000
          ],
          2 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'consumption',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'level'
            ],
            'fields' => (object) [
              'level' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'level' => 'Sales'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'u1zjc6bkwq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '629688d048e308e5f',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'consumption',
            'type' => 'all',
            'subject' => '5000',
            'value' => 5000
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'consumption',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'level'
            ],
            'fields' => (object) [
              'level' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'level' => 'Voice'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'u1zjc6bkwq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Opportunity' => [
      0 => [
        'id' => '632485a70411db8a5',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 0,
            'fieldToCompare' => 'productBrand',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => 'IBM Cloud',
            'value' => '61c0b2898dd0f216e'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'amountCurrency',
            'type' => 'all',
            'value' => 'BRL'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'dollarType',
            'type' => 'all',
            'value' => 'Dólar IBM'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'amount',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'amountDiscount',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'h893gnadn5',
            'formula' => 'dollarAmount=amountDiscount/dollarIBM;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '632488ea36e99a507',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'amountCurrency',
            'type' => 'all',
            'value' => 'BRL'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'dollarType',
            'type' => 'all',
            'value' => 'Dólar CIS'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'amount',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'amountDiscount',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'h893gnadn5',
            'formula' => 'dollarAmount=amountDiscount/dollarCIS;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '6536e918899d30cd0',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 0,
            'fieldToCompare' => 'productBrand',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => 'Google',
            'value' => '636d036e352aca8bc'
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'amountproxconsumo',
            'type' => 'all',
            'subject' => '1'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 2,
            'fieldToCompare' => 'marketing',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Form | Google Workspace',
            'value' => '6525a1ad9b8f54163'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 3,
            'fieldToCompare' => 'marketing',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Form | Google GCP',
            'value' => '6525a160aab538f9a'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => '// Atualização do campo Amount = Consumo Aproximado quando Amount menor que 1.
ifThen(amountproxconsumo != null, amount = amountproxconsumo);

// Atualização do campo de Total (USD).
ifThen(amountCurrency == \'USD\' && dollarType == \'Dólar CIS\', dollarAmount = amountDiscount);',
            'cid' => 0,
            'id' => 'bpw709dyex',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '669ab5010cb52f369',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'productBrand',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 1,
            'fieldToCompare' => 'account',
            'type' => 'all',
            'subjectType' => NULL
          ],
          2 => (object) [
            'comparison' => 'isEmpty',
            'cid' => 2,
            'fieldToCompare' => 'users',
            'type' => 'all',
            'subjectType' => NULL
          ],
          3 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'account.country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          4 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 4,
            'fieldToCompare' => 'account.bdm',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => '// BDMs

usersIds = account.bdmIds;',
            'cid' => 0,
            'id' => 'vnroyhjz8b',
            'type' => 'executeFormula'
          ],
          1 => (object) [
            'formula' => '// BDM AWS

ifThen(productBrandName == \'AWS\', $bdmIds = record\\findRelatedMany(\'Opportunity\', id, \'users\', 500, \'createdAt\', \'desc\', \'reportFilter669ab1ec9e2cc5afe\'); usersIds = $bdmIds);

// BDM Microsoft

ifThen(productBrandName == \'Microsoft\', $bdmIds = record\\findRelatedMany(\'Opportunity\', id, \'users\', 500, \'createdAt\', \'desc\', \'reportFilter669ab1fb8382eba48\'); usersIds = $bdmIds);

// BDM Google

ifThen(productBrandName == \'Google\', $bdmIds = record\\findRelatedMany(\'Opportunity\', id, \'users\', 500, \'createdAt\', \'desc\', \'reportFilter669ab2078ca7cc670\'); usersIds = $bdmIds);',
            'cid' => 1,
            'id' => 'krpo1hhlcx',
            'type' => 'executeFormula'
          ],
          2 => (object) [
            'formula' => '// Times BDMs
//Regina Aguirre
ifThen(array\\includes(usersIds, \'6812686a98ce2ce9e\'), entity\\addLinkMultipleId(\'teams\', \'68385ab15c0441294\'));

//Joel
ifThen(array\\includes(usersIds, \'64938032e1bba4e4c\'), entity\\addLinkMultipleId(\'teams\', \'6835c8191b4894529\'));

//Beatriz Noel
ifThen(array\\includes(usersIds, \'63503c24efe2b06eb\'), entity\\addLinkMultipleId(\'teams\', \'6835c8269e103c6d7\'));

//Cleiton
ifThen(array\\includes(usersIds, \'67ddb017041764dbd\'), entity\\addLinkMultipleId(\'teams\', \'68010f967c6f73a1e\'));

// Marina
ifThen(array\\includes(usersIds, \'661ec2b35b7aca809\'), entity\\addLinkMultipleId(\'teams\', \'677c21ea279b01715\'));

// Adilson
ifThen(array\\includes(usersIds, \'632cc16fe5283ec84\'), entity\\addLinkMultipleId(\'teams\', \'677c215e833ab31d4\'));

// Ana
ifThen(array\\includes(usersIds, \'642b20c0e7cabb637\'), entity\\addLinkMultipleId(\'teams\', \'677c2099b92080e0d\'));

// Camila
ifThen(array\\includes(usersIds, \'63bdc96cb68fb131f\'), entity\\addLinkMultipleId(\'teams\', \'67784200789fcc34c\'));

// Caio
ifThen(array\\includes(usersIds, \'63bdc8ef34e335403\'), entity\\addLinkMultipleId(\'teams\', \'6778420d0305960b9\'));

// Daniely
ifThen(array\\includes(usersIds, \'632cca30beca0f068\'), entity\\addLinkMultipleId(\'teams\', \'67784217d2eef0378\'));

// Bruno
ifThen(array\\includes(usersIds, \'65aa98bb860345647\'), entity\\addLinkMultipleId(\'teams\', \'6776f4dcbbf9ce9bc\'));

// Carla
ifThen(array\\includes(usersIds, \'6475f410ec2833c09\'), entity\\addLinkMultipleId(\'teams\', \'6778422362ff3a4b1\'));

// Deise
ifThen(array\\includes(usersIds, \'632cc15a5f75802a8\'), entity\\addLinkMultipleId(\'teams\', \'6776fbb68dad387a3\'));

// Eduardo
ifThen(array\\includes(usersIds, \'64da4fbdecd8725eb\'), entity\\addLinkMultipleId(\'teams\', \'6778422ebf20d8f17\'));

// Leonardo
ifThen(array\\includes(usersIds, \'63811ea792245fa05\'), entity\\addLinkMultipleId(\'teams\', \'6778423a90dd7e20f\'));

// Marcos
ifThen(array\\includes(usersIds, \'63503c2744481abe1\'), entity\\addLinkMultipleId(\'teams\', \'67784247bb989f461\'));

// Raquel
ifThen(array\\includes(usersIds, \'615c6e51724186c6b\'), entity\\addLinkMultipleId(\'teams\', \'6778425035675e0c2\'));

// Rogerio
ifThen(array\\includes(usersIds, \'632cca3153ac67c93\'), entity\\addLinkMultipleId(\'teams\', \'6778425b5edd5587f\'));

// Thais
ifThen(array\\includes(usersIds, \'64938098819a528b2\'), entity\\addLinkMultipleId(\'teams\', \'6778426710a0ea0f0\'));

// Valquiria
ifThen(array\\includes(usersIds, \'65e0df3a3140dcbe0\'), entity\\addLinkMultipleId(\'teams\', \'67784273caf38b18a\'));

// Vinicius
ifThen(array\\includes(usersIds, \'6149e530440ec9301\'), entity\\addLinkMultipleId(\'teams\', \'6778427ec274e8b61\'));

// Walisson
ifThen(array\\includes(usersIds, \'6296759dbf395158d\'), entity\\addLinkMultipleId(\'teams\', \'6778428a12a08a1ee\'));',
            'cid' => 2,
            'id' => 'wkl2s15drj',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      4 => [
        'id' => '67364f43c2ad7f02f',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'createQuote',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'createQuote',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'createQuote'
            ],
            'fields' => (object) [
              'createQuote' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'createQuote' => false
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'aunplajvjj',
            'formula' => '',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => 'cob9fb777y',
            'formula' => 'ifThen(quoteStatus == null, quoteStatus = \'Draft\');',
            'type' => 'updateEntity'
          ],
          2 => (object) [
            'formula' => '$i = 0;
$oppDiscount = 0;
$ids = record\\findRelatedMany("Opportunity", id, "items", 200);
ifThen(array\\length($ids) > 0, 
while(
    $i < array\\length($ids), 
    $valor = record\\attribute("OpportunityItem", array\\at($ids, $i), "amountDiscountItem");
    ifThen($valor != null, $oppDiscount = $oppDiscount + $valor);
    //$oppDiscount = $oppDiscount + $valor;
    $i = $i + 1
);
amountDiscount = $oppDiscount;
$discountValueVariable = number\\format((amount - amountDiscount) * (-1), 2, ".");
discountValue = $discountValueVariable;
);

ifThen(itemList == null, amountDiscount = amount + discountValue);
discountValueCurrency = amountCurrency;',
            'cid' => 2,
            'id' => '6andsla6jp',
            'type' => 'executeFormula'
          ],
          3 => (object) [
            'link' => 'quotes',
            'fieldList' => [
              0 => 'account',
              1 => 'dateQuoted',
              2 => 'name',
              3 => 'amountCurrency',
              4 => 'teams',
              5 => 'receipt',
              6 => 'amountDiscounted',
              7 => 'assignedUser',
              8 => 'commercialConditions',
              9 => 'dateOrdered',
              10 => 'amount',
              11 => 'amountWithDiscount',
              12 => 'description',
              13 => 'billingContact'
            ],
            'fields' => (object) [
              'account' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'account'
              ],
              'dateQuoted' => (object) [
                'subjectType' => 'today',
                'shiftDays' => 0,
                'attributes' => (object) [],
                'shiftUnit' => 'days'
              ],
              'name' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'name'
              ],
              'amountCurrency' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'amountCurrency'
              ],
              'teams' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'actionType' => 'update',
                'field' => 'teams'
              ],
              'receipt' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'receipt'
              ],
              'amountDiscounted' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'discountValue'
              ],
              'assignedUser' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'assignedUser'
              ],
              'commercialConditions' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'commercialTerms'
              ],
              'dateOrdered' => (object) [
                'subjectType' => 'field',
                'shiftDays' => 0,
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'closeDate'
              ],
              'amount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'amount'
              ],
              'amountWithDiscount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'amountDiscount'
              ],
              'description' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'description'
              ],
              'billingContact' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'billingContact'
              ]
            ],
            'cid' => 3,
            'id' => 'uev12g1mld',
            'linkList' => [],
            'formula' => '$documentid = record\\findRelatedMany(\'Opportunity\', opportunityId, \'documents\', 10, \'createdAt\', \'desc\', \'type=\', \'Estimativa\');
documentsIds = $documentid;

name = string\\concatenate(opportunityName," | ", number);
',
            'type' => 'createRelatedEntity'
          ],
          4 => (object) [
            'formula' => '$items = record\\findRelatedMany("Opportunity", id, "items", 200, "createdAt", "asc");
$quotes = record\\findRelatedOne("Opportunity", id, "quotes", "createdAt", "desc");


$i = 0;
while(
    $i < array\\length($items), 

    $oppItem = record\\fetch("OpportunityItem", array\\at($items, $i));
    $oppItemEncoded = json\\encode($oppItem);
    
    record\\create(
        "QuoteItem", 
        \'quoteId\', $quotes, 
        \'amount\', json\\retrieve($oppItemEncoded, \'amount\'),
        \'quantity\', json\\retrieve($oppItemEncoded, \'quantity\'),
        \'discount\', json\\retrieve($oppItemEncoded, \'discount\'),
        \'discountItem\', json\\retrieve($oppItemEncoded, \'discount\'),
        \'productId\', json\\retrieve($oppItemEncoded, \'productId\'),
        \'name\', json\\retrieve($oppItemEncoded, \'name\'),
        \'productName\', json\\retrieve($oppItemEncoded, \'productName\'),
        \'unitPrice\', json\\retrieve($oppItemEncoded, \'unitPrice\'),
        \'timeContract\', json\\retrieve($oppItemEncoded, \'timeContract\'),
        \'solutionType\', json\\retrieve($oppItemEncoded, \'solutionType\'),
        \'contractType\', json\\retrieve($oppItemEncoded, \'contractType\'),
        \'licenseType\', json\\retrieve($oppItemEncoded, \'licenseType\'),
        \'cAdditionalDiscount\', json\\retrieve($oppItemEncoded, \'cAdditionalDiscount\'),
    );

    $i = $i + 1;
);',
            'cid' => 4,
            'id' => 'whwybj2dur',
            'type' => 'executeFormula'
          ],
          5 => (object) [
            'link' => 'quotes',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 5,
            'id' => '3j20ngg8jp',
            'parentEntityType' => NULL,
            'formula' => 'name = string\\concatenate(opportunityName," | ", number);',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      5 => [
        'id' => '6745d79b1c5c880e6',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThan',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'amount',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'amountDiscount',
            'type' => 'all',
            'subject' => '0',
            'value' => 0
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'amountDiscount'
            ],
            'fields' => (object) [
              'amountDiscount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'amount'
              ]
            ],
            'cid' => 0,
            'id' => '9jkgk20uug',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      6 => [
        'id' => '6807b9423d64e965a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'presentQuoteEmail',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'presentQuoteEmail',
            'type' => 'all',
            'subjectType' => NULL
          ],
          2 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 2,
            'fieldToCompare' => 'billingContact',
            'type' => 'all',
            'subjectType' => NULL
          ],
          3 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => NULL,
            'cid' => 4,
            'fieldToCompare' => 'quoteStatus',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '66461056703e75fba',
            'elementId' => '07gkauklqj',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      7 => [
        'id' => '6807b9424fefc9644',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notChanged',
            'cid' => 0,
            'fieldToCompare' => 'presentQuoteEmail',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'quoteStatus',
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'quoteStatus',
            'type' => 'all',
            'value' => 'In Review'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '66461056703e75fba',
            'elementId' => 'p8l66rso95',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      8 => [
        'id' => '681a1ab00812d84f7',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'stage',
            'type' => 'all',
            'value' => 'Migration'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'account.country',
            'type' => 'all',
            'value' => 'Brasil'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 2,
            'fieldToCompare' => 'productBrand',
            'subjectType' => 'value',
            'valueName' => 'AWS',
            'type' => 'any',
            'value' => '61c0b27f1ac2732b5'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 3,
            'fieldToCompare' => 'productBrand',
            'subjectType' => 'value',
            'valueName' => 'Microsoft',
            'type' => 'any',
            'value' => '5f0b4703b1bafeb52'
          ]
        ],
        'conditionsFormula' => 'migrationsId == null',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673266f5d151c5c8c',
            'elementId' => 'yy1not96ar',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      9 => [
        'id' => '681a1c32e9a59fc72',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'stage',
            'type' => 'all',
            'value' => 'Negotiation'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'account.country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'cid' => 2,
            'fieldToCompare' => 'productBrand',
            'subjectType' => 'value',
            'valueName' => 'AWS',
            'type' => 'all',
            'value' => '61c0b27f1ac2732b5'
          ]
        ],
        'conditionsFormula' => 'migrationsId == null',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673263915bc0ee78d',
            'elementId' => 'dbrwctn6cz',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      10 => [
        'id' => '681a1c330461d6a1d',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'account.country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 1,
            'fieldToCompare' => 'productBrand',
            'subjectType' => 'value',
            'valueName' => 'Microsoft',
            'type' => 'all',
            'value' => '5f0b4703b1bafeb52'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'migrationOrigin',
            'type' => 'all',
            'value' => 'Azure'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'stage',
            'type' => 'any',
            'value' => 'Negotiation'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'stage',
            'type' => 'any',
            'value' => 'Proposal'
          ]
        ],
        'conditionsFormula' => 'migrationsId == null',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673263915bc0ee78d',
            'elementId' => 'gop8yhzklk',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      11 => [
        'id' => '681f6dfcaa6fa242c',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'quoteOpp',
            'subjectType' => NULL,
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'quoteOpp.status',
            'value' => 'Approved',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673a4ebaead48186d',
            'elementId' => 'z6g5c37k6r',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'ServicesBilling' => [
      0 => [
        'id' => '63b47056337fbfa1b',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'services.partner',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'account'
            ],
            'fields' => (object) [
              'account' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'services.partner'
              ]
            ],
            'cid' => 0,
            'id' => 'j3n6oke7lc',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '63bf1c09d65eb3d1b',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '63bf1c09ca89079fc',
            'elementId' => 'atwjux0i5o',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Lead' => [
      0 => [
        'id' => '63ece5dfcce748b29',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '63bdbe1c6d4eb65ed',
            'elementId' => 'dz9ycqs3br',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '63ece5dfd0797a40a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'createSurestep',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '63bdbe1c6d4eb65ed',
            'elementId' => '63qt4yilso',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'AWS' => [
      0 => [
        'id' => '6408d23094b5ba679',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '25',
            'value' => 25
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividualsAssociate',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          5 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividualsProOrSpecialty',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          6 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '50',
            'value' => 50
          ],
          7 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '50000',
            'value' => 50000
          ],
          8 => (object) [
            'comparison' => 'wasEqual',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ],
          9 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 9,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '6',
            'value' => 6
          ],
          10 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 10,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '30',
            'value' => 30
          ],
          11 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 11,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '144',
            'value' => 144
          ],
          12 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 12,
            'fieldToCompare' => 'technicalprogram',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheck'
            ],
            'fields' => (object) [
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => [
                    0 => 'Ready to Premier'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '6408d7eac49f60eaa',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          2 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          3 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          4 => (object) [
            'comparison' => 'lessThan',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '11',
            'value' => 11
          ],
          5 => (object) [
            'comparison' => 'false',
            'cid' => 5,
            'fieldToCompare' => 'noLevel',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'tier',
              1 => 'level',
              2 => 'levelCheck'
            ],
            'fields' => (object) [
              'tier' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'tier' => 'Registered'
                ]
              ],
              'level' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'level' => 'Knowledge'
                ]
              ],
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '6463f403bf532d6fb',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '6',
            'value' => 6
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividualsAssociate',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          5 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividualsProOrSpecialty',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          6 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '20',
            'value' => 20
          ],
          7 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '10000',
            'value' => 10000
          ],
          8 => (object) [
            'comparison' => 'wasEqual',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ],
          9 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 9,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          10 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 10,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '20',
            'value' => 20
          ],
          11 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 11,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '60',
            'value' => 60
          ],
          12 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 12,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '140',
            'value' => 140
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheck'
            ],
            'fields' => (object) [
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => [
                    0 => 'Ready to Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '6463f48dd5f060ab8',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          5 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '1500',
            'value' => 1500
          ],
          6 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '11',
            'value' => 11
          ],
          7 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'sumSelect',
            'type' => 'all',
            'subject' => '59',
            'value' => 59
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheck'
            ],
            'fields' => (object) [
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => [
                    0 => 'Ready to Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      4 => [
        'id' => '66154099a6c3c585a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'noLevel',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'tier',
              1 => 'levelCheck'
            ],
            'fields' => (object) [
              'tier' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'tier' => 'Sin Nivel'
                ]
              ],
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      5 => [
        'id' => '6634fd80aa2dd9a5a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 0,
            'fieldToCompare' => 'accounts.dSAStartDate',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'dSA'
            ],
            'fields' => (object) [
              'dSA' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'dSA' => [
                    0 => 'Si'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => '53z19f1k2m',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      6 => [
        'id' => '664631862008e5892',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'sumselectKnowledge',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledgeThinkBig'
            ],
            'fields' => (object) [
              'levelCheckKnowledgeThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledgeThinkBig' => [
                    0 => 'Think Big for Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      7 => [
        'id' => '664644b3290b5cc62',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'sumselectKnowledge',
            'type' => 'all',
            'subject' => '13',
            'value' => 13
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledgeThinkBig'
            ],
            'fields' => (object) [
              'levelCheckKnowledgeThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledgeThinkBig' => [
                    0 => 'Think Big for Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      8 => [
        'id' => '664644f97769dff9d',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '500',
            'value' => 500
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'sumselectExperience',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperienceThinkBig'
            ],
            'fields' => (object) [
              'levelCheckExperienceThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperienceThinkBig' => [
                    0 => 'Think Big for Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      9 => [
        'id' => '664645900476067db',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '5000',
            'value' => 5000
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'sumselectExperience',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          3 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperienceThinkBig'
            ],
            'fields' => (object) [
              'levelCheckExperienceThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperienceThinkBig' => [
                    0 => 'Think Big for Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      10 => [
        'id' => '664645c6aa6eac446',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckCustomerSuccessThinkBig'
            ],
            'fields' => (object) [
              'levelCheckCustomerSuccessThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckCustomerSuccessThinkBig' => [
                    0 => 'Think Big for Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      11 => [
        'id' => '6646469b2dad24021',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '20',
            'value' => 20
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckCustomerSuccess'
            ],
            'fields' => (object) [
              'levelCheckCustomerSuccess' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckCustomerSuccess' => [
                    0 => 'Ready to Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      12 => [
        'id' => '664646d7ed29ab4bf',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          1 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '19',
            'value' => 19
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckCustomerSuccess'
            ],
            'fields' => (object) [
              'levelCheckCustomerSuccess' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckCustomerSuccess' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      13 => [
        'id' => '664646f439cd29fc5',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '6',
            'value' => 6
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '30',
            'value' => 30
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckCustomerSuccess'
            ],
            'fields' => (object) [
              'levelCheckCustomerSuccess' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckCustomerSuccess' => [
                    0 => 'Ready to Premier'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      14 => [
        'id' => '6646473035fe5ba86',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '20',
            'value' => 20
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '10000',
            'value' => 10000
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'sumselectExperience',
            'type' => 'all',
            'subject' => '20',
            'value' => 20
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperience'
            ],
            'fields' => (object) [
              'levelCheckExperience' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperience' => [
                    0 => 'Ready to Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      15 => [
        'id' => '66464748e53644569',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          1 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '1500',
            'value' => 1500
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperience'
            ],
            'fields' => (object) [
              'levelCheckExperience' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperience' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      16 => [
        'id' => '6646477a0f476ac25',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '50',
            'value' => 50
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '50000',
            'value' => 50000
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'sumselectExperience',
            'type' => 'all',
            'subject' => '53',
            'value' => 53
          ],
          3 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'technicalprogram',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperience'
            ],
            'fields' => (object) [
              'levelCheckExperience' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperience' => [
                    0 => 'Ready to Premium'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      17 => [
        'id' => '664647a0dd037029f',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '1500',
            'value' => 1500
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'sumselectExperience',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckExperience'
            ],
            'fields' => (object) [
              'levelCheckExperience' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckExperience' => [
                    0 => 'Ready to Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      18 => [
        'id' => '664648394604228a2',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '6',
            'value' => 6
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'sumselectKnowledge',
            'type' => 'all',
            'subject' => '18',
            'value' => 18
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledge'
            ],
            'fields' => (object) [
              'levelCheckKnowledge' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledge' => [
                    0 => 'Ready to Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      19 => [
        'id' => '6646485a2c18e1526',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          2 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          3 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledge'
            ],
            'fields' => (object) [
              'levelCheckKnowledge' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledge' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      20 => [
        'id' => '6646487f9aa21ba4a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '25',
            'value' => 25
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'sumselectKnowledge',
            'type' => 'all',
            'subject' => '55',
            'value' => 55
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledge'
            ],
            'fields' => (object) [
              'levelCheckKnowledge' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledge' => [
                    0 => 'Ready to Premier'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      21 => [
        'id' => '66464896b52501865',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'sumselectKnowledge',
            'type' => 'all',
            'subject' => '8',
            'value' => 8
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckKnowledge'
            ],
            'fields' => (object) [
              'levelCheckKnowledge' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckKnowledge' => [
                    0 => 'Ready to Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      22 => [
        'id' => '6646610e63908036f',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '2',
            'value' => 2
          ],
          5 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '500',
            'value' => 500
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckThinkBig'
            ],
            'fields' => (object) [
              'levelCheckThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckThinkBig' => [
                    0 => 'Think Big for Select'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      23 => [
        'id' => '66466198b6803d8db',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'aWSAccreditedProfessionalsBussines',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          1 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'aWSAccreditedProfessionalsTechnical',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          2 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'aWSFoundationalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '3',
            'value' => 3
          ],
          3 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'aWSTechnicalCertifiedIndividuals',
            'type' => 'all',
            'subject' => '4',
            'value' => 4
          ],
          4 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'launchedOppsCount',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ],
          5 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '5000',
            'value' => 5000
          ],
          6 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'partnerBusinessPlan',
            'type' => 'all',
            'value' => '1'
          ],
          7 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'publiclyReferenceableCustomers',
            'type' => 'all',
            'subject' => '1',
            'value' => 1
          ],
          8 => (object) [
            'comparison' => 'greaterThanOrEquals',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'customerSatisfactionResponses',
            'type' => 'all',
            'subject' => '10',
            'value' => 10
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheckThinkBig'
            ],
            'fields' => (object) [
              'levelCheckThinkBig' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheckThinkBig' => [
                    0 => 'Think Big for Advanced'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      24 => [
        'id' => '6669b0911561e3420',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'lessThanOrEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'launchedOppsAmount',
            'type' => 'all',
            'subject' => '1499',
            'value' => 1499
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'levelCheck'
            ],
            'fields' => (object) [
              'levelCheck' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'levelCheck' => []
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'keqg5ksdbq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      25 => [
        'id' => '667ae5b29863b4151',
        'actions' => [
          0 => (object) [
            'link' => 'account',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'yiouexg5u5',
            'parentEntityType' => NULL,
            'formula' => '//Atualizar times AWS de acordo com o país. 

ifThen(awsIds != null && country == "Argentina", entity\\addLinkMultipleId(\'teams\', \'64d38dc428277e7da\'));
ifThen(awsIds != null && country == "Bolivia", entity\\addLinkMultipleId(\'teams\', \'64ff86a3b0c0f373a\'));
ifThen(awsIds != null && country == "CCA", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Costa Rica", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Dominican Republic", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "El Salvador", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Barbados", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Grenada", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Guadeloupe", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Guatemala", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Honduras", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Jamaica", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Nicaragua", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Panama", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Puerto Rico", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Venezuela", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Chile", entity\\addLinkMultipleId(\'teams\', \'64d38de0c4a999f5d\'));
ifThen(awsIds != null && country == "Colombia", entity\\addLinkMultipleId(\'teams\', \'64d38dd5a829a538e\'));
ifThen(awsIds != null && country == "Ecuador", entity\\addLinkMultipleId(\'teams\', \'64dd1525e06ae6e75\'));
ifThen(awsIds != null && country == "Mexico", entity\\addLinkMultipleId(\'teams\', \'64da3fe6132152766\'));
ifThen(awsIds != null && country == "Paraguay", entity\\addLinkMultipleId(\'teams\', \'64d38deeca51ba79c\'));
ifThen(awsIds != null && country == "Peru", entity\\addLinkMultipleId(\'teams\', \'64d38dfabffcd9872\'));
ifThen(awsIds != null && country == "Uruguay", entity\\addLinkMultipleId(\'teams\', \'64d38e091cb1cecd9\'));',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'PartnersGoogleCloud' => [
      0 => [
        'id' => '6474e5c30f40a649a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'dadoDeAltaConTDSYNNEX',
            'type' => 'all',
            'value' => ' '
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'progresoTDSYNNEX'
            ],
            'fields' => (object) [
              'progresoTDSYNNEX' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'progresoTDSYNNEX' => [
                    0 => 'Documentos Enviados',
                    1 => 'Linea  Credito',
                    2 => 'Streamone Google',
                    3 => 'CloudSolv'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'yk7q6i853a',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'GooglePartnerAdvantage' => [
      0 => [
        'id' => '647a2eddeb0dbf3b5',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'stage',
            'type' => 'all',
            'value' => ''
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'stage',
            'type' => 'all',
            'value' => 'Closed'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'closeDate'
            ],
            'fields' => (object) [
              'closeDate' => (object) [
                'subjectType' => 'today',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days'
              ]
            ],
            'cid' => 0,
            'id' => 'zhndic8zji',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'CPB' => [
      0 => [
        'id' => '648794c8cbe088679',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Argentina '
          ],
          1 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Bolivia'
          ],
          2 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          3 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Chile'
          ],
          4 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Costa Rica '
          ],
          5 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Dominican Republic'
          ],
          6 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Guadeloupe'
          ],
          7 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Guatemala'
          ],
          8 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Honduras'
          ],
          9 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 9,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'El Salvador'
          ],
          10 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 10,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Mexico'
          ],
          11 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 11,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Panama '
          ],
          12 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 12,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Paraguay '
          ],
          13 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 13,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Peru'
          ],
          14 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 14,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Puerto Rico '
          ],
          15 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 15,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Uruguay'
          ],
          16 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 16,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Venezuela'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'region'
            ],
            'fields' => (object) [
              'region' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'region' => 'NOLA'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'xhvsaju34x',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '648794dd142b81e37',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'region'
            ],
            'fields' => (object) [
              'region' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'region' => 'Brasil'
                ]
              ]
            ],
            'cid' => 0,
            'id' => '6hj0h7vaxm',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '648794ea839f4a7eb',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Argentina '
          ],
          1 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Bolivia'
          ],
          2 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          3 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Chile'
          ],
          4 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Colombia '
          ],
          5 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Ecuador'
          ],
          6 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Mexico'
          ],
          7 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Paraguay '
          ],
          8 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Peru'
          ],
          9 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 9,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Uruguay'
          ],
          10 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 10,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Venezuela'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'region'
            ],
            'fields' => (object) [
              'region' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'region' => 'CCA'
                ]
              ]
            ],
            'cid' => 0,
            'id' => '7tcyg2y6fu',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '648794fe21d828c5c',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Mexico'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'region'
            ],
            'fields' => (object) [
              'region' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'region' => 'Mexico'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'fyoz0s1exq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      4 => [
        'id' => '64879509b6bb0c79e',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          1 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Colombia '
          ],
          2 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Ecuador'
          ],
          3 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Dominican Republic'
          ],
          4 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Costa Rica '
          ],
          5 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Guatemala'
          ],
          6 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Guadeloupe'
          ],
          7 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'El Salvador'
          ],
          8 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 8,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Panama '
          ],
          9 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 9,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Puerto Rico '
          ],
          10 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 10,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Mexico'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'region'
            ],
            'fields' => (object) [
              'region' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'region' => 'SOLA'
                ]
              ]
            ],
            'cid' => 0,
            'id' => '1cqihocoyt',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Meeting' => [
      0 => [
        'id' => '64a4697694b855e29',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 0,
            'fieldToCompare' => 'teams',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => 'Fortinet - Vuno',
            'value' => '6499ccee2d8df9223'
          ],
          1 => (object) [
            'comparison' => 'on',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 1,
            'fieldToCompare' => 'modifiedAt',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'assignedUser',
              1 => 'dateEnd'
            ],
            'fields' => (object) [
              'assignedUser' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'assignedUserName' => 'Andreia Rafacho',
                  'assignedUserId' => '62b0a70f2304488a5'
                ]
              ],
              'dateEnd' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '1',
                'attributes' => (object) [],
                'shiftUnit' => 'hours',
                'field' => 'dateStart'
              ]
            ],
            'cid' => 0,
            'id' => 'yzkv6wto6z',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Surestep' => [
      0 => [
        'id' => '64ff5d857c669099d',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 4,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Brasil (Microsoft)',
            'value' => '63fe2e975c350b246',
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'any',
            'value' => 'New Partner'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'any',
            'value' => 'In Process'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6227ad1e79c2928b5',
            'elementId' => 'nvbgfoegvn',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '64ff5d8584e1b87ce',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'all',
            'value' => 'Activate'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 1,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Brasil (Microsoft)',
            'value' => '63fe2e975c350b246',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6227ad1e79c2928b5',
            'elementId' => '0deoo1koaf',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '64ff5d858dd4e7abf',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'all',
            'value' => 'Inspire'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 1,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Brasil (Microsoft)',
            'value' => '63fe2e975c350b246',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6227ad1e79c2928b5',
            'elementId' => 'gk5e66f700',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '64ff5d85953173a70',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'all',
            'value' => 'SKR'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 1,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Brasil (Microsoft)',
            'value' => '63fe2e975c350b246',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6227ad1e79c2928b5',
            'elementId' => 'nuatnvy6gv',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      4 => [
        'id' => '64ff5d85a579ba8a2',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'surestepLevel',
            'type' => 'all',
            'value' => 'TopSKR'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 1,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Brasil (Microsoft)',
            'value' => '63fe2e975c350b246',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6227ad1e79c2928b5',
            'elementId' => 'lvlkfyg2hi',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Contact' => [
      0 => [
        'id' => '6525547dd3155377b',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 2,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Forms Platform',
            'value' => '64f8a9800d65b4e2f',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 3,
            'fieldToCompare' => 'modifiedBy',
            'subjectType' => 'value',
            'valueName' => 'Forms Platform',
            'value' => '64f8a9800d65b4e2f',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6525547dce1c68645',
            'elementId' => 'bvgdei5ua1',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '6751cc727a6dc77b9',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'true',
            'cid' => 0,
            'fieldToCompare' => 'salesContact',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'source',
            'type' => 'all',
            'value' => 'CloudSolv'
          ],
          2 => (object) [
            'comparison' => 'isEmpty',
            'cid' => 2,
            'fieldToCompare' => 'teams',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'gxi0s6gbfm',
            'formula' => 'teamsIds = account.teamsIds;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Account' => [
      0 => [
        'id' => '6525551b662cb32e7',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 0,
            'fieldToCompare' => 'modifiedBy',
            'subjectType' => 'value',
            'valueName' => 'Forms Platform',
            'value' => '64f8a9800d65b4e2f',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 1,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Forms Platform',
            'value' => '64f8a9800d65b4e2f',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6525551b614d1c43b',
            'elementId' => 'qwivolix2q',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '6596ed94f3619b320',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'partnersGoogleClouds',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'mujkzud05q',
            'formula' => 'entity\\addLinkMultipleId(\'teams\', \'640f417f9bc453ac3\');


ifThen(country == "Argentina", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Bolivia", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Brasil", entity\\addLinkMultipleId(\'teams\', \'643418441fabd22dd\'));
ifThen(country == "Costa Rica", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Chile", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Colombia", entity\\addLinkMultipleId(\'teams\', \'6434182fafe7d4fe6\'));
ifThen(country == "Dominican Republic", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Ecuador", entity\\addLinkMultipleId(\'teams\', \'6434182fafe7d4fe6\'));
ifThen(country == "El Salvador", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Guadelouope", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Guatemala", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Honduras", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Mexico", entity\\addLinkMultipleId(\'teams\', \'6434184940f72cec2\'));
ifThen(country == "Panama", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Paraguay", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Peru", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Puerto Rico", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(country == "Uruguay", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(country == "Venezuela", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '66994bcc9af2c7f49',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'aWS',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => NULL
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => '//Atualizar times AWS de acordo com o país. 

ifThen(awsIds != null && country == "Argentina", entity\\addLinkMultipleId(\'teams\', \'64d38dc428277e7da\'));
ifThen(awsIds != null && country == "Bolivia", entity\\addLinkMultipleId(\'teams\', \'64ff86a3b0c0f373a\'));
ifThen(awsIds != null && country == "CCA", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Costa Rica", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Dominican Republic", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "El Salvador", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Barbados", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Grenada", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Guadeloupe", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Guatemala", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Honduras", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Jamaica", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Nicaragua", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Panama", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Puerto Rico", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Venezuela", entity\\addLinkMultipleId(\'teams\', \'64da40ef4903f3f5b\'));
ifThen(awsIds != null && country == "Chile", entity\\addLinkMultipleId(\'teams\', \'64d38de0c4a999f5d\'));
ifThen(awsIds != null && country == "Colombia", entity\\addLinkMultipleId(\'teams\', \'64d38dd5a829a538e\'));
ifThen(awsIds != null && country == "Ecuador", entity\\addLinkMultipleId(\'teams\', \'64dd1525e06ae6e75\'));
ifThen(awsIds != null && country == "Mexico", entity\\addLinkMultipleId(\'teams\', \'64da3fe6132152766\'));
ifThen(awsIds != null && country == "Paraguay", entity\\addLinkMultipleId(\'teams\', \'64d38deeca51ba79c\'));
ifThen(awsIds != null && country == "Peru", entity\\addLinkMultipleId(\'teams\', \'64d38dfabffcd9872\'));
ifThen(awsIds != null && country == "Uruguay", entity\\addLinkMultipleId(\'teams\', \'64d38e091cb1cecd9\'));',
            'cid' => 0,
            'id' => 'vvhkumr4rd',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '67913f95ccd4a9940',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'renewals',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'conditionsFormula' => 'cRenewalsMicrosoftId == null',
        'actions' => [
          0 => (object) [
            'link' => 'Renewals',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => '21z8pop9l4',
            'linkList' => [
              0 => 'accountRenewals'
            ],
            'formula' => NULL,
            'entityType' => 'Renewals',
            'type' => 'createEntity'
          ],
          1 => (object) [
            'link' => 'renewalsMicrosoft',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => '406cx5dyrq',
            'parentEntityType' => NULL,
            'formula' => 'name = accountRenewalsName;

// Identify Renewals
$renewalsNext90Days = record\\findRelatedMany(\'Account\', accountRenewalsId, \'salesOrders\', 100, \'contractEndDateVendor\', \'desc\', \'reportFilter664dfdebb84637a58\');
ifThenElse(array\\length($renewalsNext90Days) > 0, hasRenewals = true, hasRenewals = false);',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      4 => [
        'id' => '6797df8c55161aedb',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'subject' => 'gmail.com',
            'value' => 'gmail.com'
          ],
          1 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'subject' => 'hotmail.com',
            'value' => 'hotmail.com'
          ],
          2 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'subject' => 'live.com',
            'value' => 'live.com'
          ],
          3 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'subject' => 'synnex',
            'value' => 'synnex'
          ],
          4 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'value' => 'outlook.com'
          ],
          5 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'value' => 'yahoo.com'
          ],
          6 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 6,
            'fieldToCompare' => 'website',
            'type' => 'all',
            'value' => 'msn.com'
          ],
          7 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 7,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => '$domain = string\\split(emailAddress, \'@\');
website = array\\at($domain, 1);
',
            'cid' => 0,
            'id' => 'hj2pkgwkjf',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      5 => [
        'id' => '684889883e896fdcd',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6848862c5ce363717',
            'elementId' => '0atgchnu8n',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Service' => [
      0 => [
        'id' => '65723dc0773c44345',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'true',
            'cid' => 0,
            'fieldToCompare' => 'createVersion',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'servicesVersions',
            'fieldList' => [
              0 => 'name',
              1 => 'assignedUser',
              2 => 'sendingDate',
              3 => 'sellingDate',
              4 => 'installationCost',
              5 => 'supportCost',
              6 => 'description',
              7 => 'modifiedAt',
              8 => 'modifiedBy',
              9 => 'notes',
              10 => 'installationRevenue',
              11 => 'supportRevenue',
              12 => 'teams',
              13 => 'version',
              14 => 'stage',
              15 => 'productBrand',
              16 => 'account',
              17 => 'partner',
              18 => 'type',
              19 => 'installationMarkupPercentage',
              20 => 'supportMarkupPercentage',
              21 => 'winProbability',
              22 => 'billingType',
              23 => 'cancelReason',
              24 => 'consumptionEstimate',
              25 => 'costVSReceipt',
              26 => 'documents',
              27 => 'endUser',
              28 => 'netRevenueCloud',
              29 => 'partnerCommission',
              30 => 'projectType',
              31 => 'serviceActivity',
              32 => 'serviceAmountTotal',
              33 => 'serviceAmountTotalUSD',
              34 => 'serviceProvider',
              35 => 'serviceType',
              36 => 'solicitationDate',
              37 => 'servicesBillings',
              38 => 'billingSituation',
              39 => 'endDate',
              40 => 'startDate',
              41 => 'followup',
              42 => 'mso',
              43 => 'opportunityType',
              44 => 'servicePartnerValue',
              45 => 'serviceProviderVarchar',
              46 => 'totalCost',
              47 => 'totalRevenue',
              48 => 'dollarAmount',
              49 => 'margem',
              50 => 'custo',
              51 => 'receita',
              52 => 'revenue',
              53 => 'revenueNet',
              54 => 'nFParceiro',
              55 => 'nFSynnex'
            ],
            'fields' => (object) [
              'name' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'name'
              ],
              'assignedUser' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'assignedUser'
              ],
              'sendingDate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'sendingDate'
              ],
              'sellingDate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'sellingDate'
              ],
              'installationCost' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'installationCost'
              ],
              'supportCost' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'supportCost'
              ],
              'description' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'description'
              ],
              'modifiedAt' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'modifiedAt'
              ],
              'modifiedBy' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'modifiedBy'
              ],
              'notes' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'notes'
              ],
              'installationRevenue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'installationRevenue'
              ],
              'supportRevenue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'supportRevenue'
              ],
              'teams' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'teams'
              ],
              'version' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'version'
              ],
              'stage' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'stage'
              ],
              'productBrand' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'productBrand'
              ],
              'account' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'account'
              ],
              'partner' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'partner'
              ],
              'type' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'type'
              ],
              'installationMarkupPercentage' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'installationMarkupPercentage'
              ],
              'supportMarkupPercentage' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'supportMarkupPercentage'
              ],
              'winProbability' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'winProbability'
              ],
              'billingType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'billingType'
              ],
              'cancelReason' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'cancelReason'
              ],
              'consumptionEstimate' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'consumptionEstimate'
              ],
              'costVSReceipt' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'costVSReceipt'
              ],
              'documents' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'documents'
              ],
              'endUser' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'endUser'
              ],
              'netRevenueCloud' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'netRevenueCloud'
              ],
              'partnerCommission' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'partnerCommission'
              ],
              'projectType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'projectType'
              ],
              'serviceActivity' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceActivity'
              ],
              'serviceAmountTotal' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceAmountTotal'
              ],
              'serviceAmountTotalUSD' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceAmountTotalUSD'
              ],
              'serviceProvider' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceProvider'
              ],
              'serviceType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceType'
              ],
              'solicitationDate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'solicitationDate'
              ],
              'servicesBillings' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'servicesBillings'
              ],
              'billingSituation' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'billingSituation'
              ],
              'endDate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'endDate'
              ],
              'startDate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'startDate'
              ],
              'followup' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'followup'
              ],
              'mso' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'mso'
              ],
              'opportunityType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'opportunityType'
              ],
              'servicePartnerValue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'servicePartnerValue'
              ],
              'serviceProviderVarchar' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceProviderVarchar'
              ],
              'totalCost' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'totalCost'
              ],
              'totalRevenue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'totalRevenue'
              ],
              'dollarAmount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'dollarAmount'
              ],
              'margem' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'margem'
              ],
              'custo' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'custo'
              ],
              'receita' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'totalRevenue'
              ],
              'revenue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'revenue'
              ],
              'revenueNet' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'revenueNet'
              ],
              'nFParceiro' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'nfParceiro'
              ],
              'nFSynnex' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'nfSYNNEX'
              ]
            ],
            'cid' => 0,
            'id' => 'og2um89t6v',
            'linkList' => [],
            'formula' => 'ifThen(stage == null, winProbability = 0);
ifThen(stage == \'Pendente de informação\', winProbability = 10);
ifThen(stage == \'Ganho\', winProbability = 100);
ifThen(stage == \'Perdido\', winProbability = 0);
ifThen(stage == \'Enviada\', winProbability = 20);
ifThen(stage == \'Possível\', winProbability = 40);
ifThen(stage == \'Em vias de fechamento\', winProbability = 80);

totalCost = installationCost + supportCost;
totalRevenue = installationRevenue + supportRevenue;
costVSReceipt = totalRevenue - totalCost;
version = version + 1;',
            'type' => 'createRelatedEntity'
          ],
          1 => (object) [
            'fieldList' => [
              0 => 'createVersion'
            ],
            'fields' => (object) [
              'createVersion' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'createVersion' => false
                ]
              ]
            ],
            'cid' => 1,
            'id' => '727yby1m1e',
            'formula' => 'version = version +1;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '6631061bf27672efb',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'true',
            'cid' => 0,
            'fieldToCompare' => 'createBilling',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'servicesBillings',
            'fieldList' => [
              0 => 'name',
              1 => 'account',
              2 => 'stage',
              3 => 'opportunityType',
              4 => 'ov',
              5 => 'vpo',
              6 => 'amount',
              7 => 'billingIssue',
              8 => 'billingPayment',
              9 => 'description',
              10 => 'cost',
              11 => 'dollarAmount',
              12 => 'costUSD',
              13 => 'margin',
              14 => 'income',
              15 => 'tax',
              16 => 'revenue',
              17 => 'revenueNet',
              18 => 'ticket',
              19 => 'nfSYNNEX',
              20 => 'nfPartner',
              21 => 'po',
              22 => 'poID',
              23 => 'order'
            ],
            'fields' => (object) [
              'name' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'name'
              ],
              'account' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'serviceProvider'
              ],
              'stage' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'stage'
              ],
              'opportunityType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'opportunityType'
              ],
              'ov' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'ov' => NULL
                ]
              ],
              'vpo' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'vpo' => NULL
                ]
              ],
              'amount' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'amount' => NULL,
                  'amountCurrency' => NULL
                ]
              ],
              'billingIssue' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'startDate'
              ],
              'billingPayment' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'endDate'
              ],
              'description' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'notes'
              ],
              'cost' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'custo'
              ],
              'dollarAmount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'dollarAmount'
              ],
              'costUSD' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'costUSD' => NULL,
                  'costUSDCurrency' => NULL
                ]
              ],
              'margin' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'margem'
              ],
              'income' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'receita'
              ],
              'tax' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'tax'
              ],
              'revenue' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'revenue'
              ],
              'revenueNet' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'revenueNet'
              ],
              'ticket' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'ticket'
              ],
              'nfSYNNEX' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'nfSYNNEX' => NULL
                ]
              ],
              'nfPartner' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'nfPartner' => NULL
                ]
              ],
              'po' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'pO'
              ],
              'poID' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'name'
              ],
              'order' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'order' => NULL
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'sw94s9sdg9',
            'linkList' => [],
            'formula' => 'ifThen(stage == null, winProbability = 0);
ifThen(stage == \'Pendente de informação\', winProbability = 10);
ifThen(stage == \'Ganho\', winProbability = 100);
ifThen(stage == \'Perdido / Cancelado\', winProbability = 0);
ifThen(stage == \'Enviada\', winProbability = 20);
ifThen(stage == \'Possível\', winProbability = 40);
ifThen(stage == \'Em vias de fechamento\', winProbability = 80);

totalCost = installationCost + supportCost;
totalRevenue = installationRevenue + supportRevenue;
costVSReceipt = totalRevenue - totalCost;

costUSD = cost/dollarAmount;
revenueNet = revenue - (revenue * tax/100);
revenue = income/dollarAmount;
margin = ((revenueNet - costUSD)/revenueNet);
margin = margin * 100;

billing = billing +1;


',
            'type' => 'createRelatedEntity'
          ],
          1 => (object) [
            'fieldList' => [
              0 => 'createBilling'
            ],
            'fields' => (object) [
              'createBilling' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'createBilling' => false
                ]
              ]
            ],
            'cid' => 1,
            'id' => 'jld6xyhcgv',
            'formula' => 'billing = billing +1;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'OpportunityItem' => [
      0 => [
        'id' => '65d8ecf207ff5e4ba',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'shiftDays' => 0,
            'cid' => 0,
            'fieldToCompare' => 'modifiedAt',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'on',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 1,
            'fieldToCompare' => 'modifiedAt',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => '// Fórmula para campo de desconto.


$value = amount - (amount * (discount/100));
ifThen(discount != 0, amountDiscountItem = $value);
ifThen(discount == 0, amountDiscountItem = amount);






//$value = amount - (amount * (discount/100));
//amountDiscountItem = number\\format($value, 2, ".");
',
            'cid' => 1,
            'id' => 'l2trftngey',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '666876df2174dfd07',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'quantity',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'update'
            ],
            'fields' => (object) [
              'update' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'update' => true
                ]
              ]
            ],
            'cid' => 0,
            'id' => '702e2m0pl8',
            'formula' => '',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'fieldList' => [
              0 => 'update'
            ],
            'fields' => (object) [
              'update' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'update' => false
                ]
              ]
            ],
            'cid' => 1,
            'id' => '67qxd7zaj5',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Document' => [
      0 => [
        'id' => '666215c68b8785ce0',
        'actions' => [
          0 => (object) [
            'link' => 'opportunities',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'tqx9v3d5wj',
            'parentEntityType' => NULL,
            'formula' => '//Relacionar documentos de Oportunidade
$documentIds = record\\findRelatedMany(\'Opportunity\', id, \'documents\', 10, \'createdAt\', \'desc\', \'type=\', \'Estimativa\');
record\\relate(\'Quote\', quoteOppId, \'documents\', $documentIds);

$documentIds = record\\findRelatedMany(\'Opportunity\', id, \'documents\', 10, \'createdAt\', \'desc\', \'type=\', \'Cotação\');
record\\relate(\'Quote\', quoteOppId, \'documents\', $documentIds);',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Email' => [
      0 => [
        'id' => '66732f825c8eb9a22',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 0,
            'fieldToCompare' => 'sentBy.teams',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => 'Cloud Brasil',
            'value' => '6320869fe404e348c'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'teams'
            ],
            'fields' => (object) [
              'teams' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'teamsIds' => [
                    0 => '6320869fe404e348c'
                  ],
                  'teamsNames' => (object) [
                    '6320869fe404e348c' => 'Cloud Brasil'
                  ]
                ],
                'field' => 'sentBy.teams'
              ]
            ],
            'cid' => 0,
            'id' => '2ab6dojcpe',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'EmailContent' => [
      0 => [
        'id' => '66857d48986b5f3dd',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'cid' => 1,
            'fieldToCompare' => 'done',
            'type' => 'any'
          ],
          2 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'country',
            'type' => 'any'
          ],
          3 => (object) [
            'comparison' => 'changed',
            'cid' => 3,
            'fieldToCompare' => 'sendExample',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => 'accountsListIds = list(\'66a157b4bea93fd4a\');
accountsIds = list(\'66a157b4bea93fd4a\');',
            'cid' => 0,
            'id' => 'qslxfxnd4l',
            'type' => 'executeFormula'
          ],
          1 => (object) [
            'requestType' => 'GET',
            'contentType' => 'application/json',
            'content' => '{}',
            'requestUrl' => 'https://cdp.cloudanalytics.me/api/v1/Account?select=name,country,region,type,typeOfCompany,createdAt,createdById,createdByName,name,country,region,type,typeOfCompany,createdAt,createdById,createdByName&maxSize=200&offset=0&orderBy=createdAt&order=desc&where[0][type]=in&where[0][attribute]=type&where[0][value][]=Reseller&where[1][type]=in&where[1][attribute]=country&where[1][value][]={$country}&where[2][type]=isLinked&where[2][attribute]=renewals',
            'headers' => [
              0 => 'Authorization: Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=  '
            ],
            'cid' => 1,
            'id' => 'a5byax0ugh',
            'type' => 'sendRequest'
          ],
          2 => (object) [
            'formula' => '$list = json\\retrieve(workflow\\lastHttpResponseBody(), \'list\');
$total = array\\length($list);
$i = 0;
while($i < $total, (
    $object = array\\at($list, $i);
    $currentId = object\\get($object, \'id\');
    accountsIds = array\\push(accountsIds, $currentId);
    accountsListIds = array\\push(accountsListIds, $currentId);
    $i= $i+1;
));
',
            'cid' => 2,
            'id' => 'hcwh1reylx',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '66a151fa83552a872',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'cid' => 1,
            'fieldToCompare' => 'done',
            'type' => 'any'
          ],
          2 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'country',
            'type' => 'any'
          ],
          3 => (object) [
            'comparison' => 'changed',
            'cid' => 3,
            'fieldToCompare' => 'sendExample',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => 'contactsListIds = list(\'66a15d28da53fe569\');',
            'cid' => 0,
            'id' => 's0u3vraxo4',
            'type' => 'executeFormula'
          ],
          1 => (object) [
            'requestType' => 'GET',
            'contentType' => 'application/json',
            'content' => '{}',
            'requestUrl' => 'https://cdp.cloudanalytics.me/api/v1/Contact?select=salutationName,firstName,lastName,middleName,name,accountsIds,accountsNames,emailAddressIsOptedOut,emailAddress,emailAddressData,phoneNumberIsOptedOut,phoneNumber,phoneNumberData,pais,createdAt,salutationName,firstName,lastName,middleName,name,accountsIds,accountsNames,emailAddressIsOptedOut,emailAddress,emailAddressData,phoneNumberIsOptedOut,phoneNumber,phoneNumberData,pais,createdAt&maxSize=200&offset=0&orderBy=createdAt&order=desc&where[0][type]=in&where[0][attribute]=type&where[0][value][]=Finance&where[0][value][]=Primary&where[1][type]=in&where[1][attribute]=source&where[1][value][]=CloudSolv&where[2][type]=in&where[2][attribute]=pais&where[2][value][]={$country}&where[3][type]=isTrue&where[3][attribute]=hasRenewals',
            'headers' => [
              0 => 'Authorization: Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=  '
            ],
            'cid' => 1,
            'id' => 'a5byax0ugh',
            'type' => 'sendRequest'
          ],
          2 => (object) [
            'formula' => '$list = json\\retrieve(workflow\\lastHttpResponseBody(), \'list\');
$total = array\\length($list);
$i = 0;
while($i < $total, (
    $object = array\\at($list, $i);
    $currentId = object\\get($object, \'id\');
    contactsListIds = array\\push(contactsListIds, $currentId);
    $i= $i+1;
));',
            'cid' => 2,
            'id' => 'hcwh1reylx',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '66ccd9e40f0a0b936',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'sendExample',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'sendExample',
            'type' => 'all',
            'subjectType' => NULL
          ],
          2 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 2,
            'fieldToCompare' => 'accounts',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'qq9q6vsmqu',
            'formula' => 'ifThen(sendExample == true, accountsIds = accountsListIds);',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'formula' => '//Send Example

//$AccountId = record\\findRelatedOne(\'EmailContent\', id, \'accountsList\', \'renewalsEndCustomers90Days\', \'desc\');

$AccountId = \'62a8d6dac091df064\';
//$AccountId = \'649b535489b05b8a2\';

$Region = record\\attribute(\'Account\', $AccountId, \'region\');
$English = string\\contains($Region, \'CCA\');

//Send Email (English)

ifThen($English == true,
$attachmentIdEn = ext\\pdf\\generate(
    \'Account\',
    $AccountIdEn,
    \'6654d36e14b2506a8\',
    \'Your Microsoft Business coming up for renewal in the next 90 days.pdf\'
);

$attachmentsIdsEn = array\\push(attachmentsIds, $attachmentIdEn);

$emailIdEn = record\\create(
    \'Email\',
    \'to\', emailAddress,
    \'status\', \'Sending\',
    \'attachmentsIds\', $attachmentsIdsEn,
    \'parentType\', \'Account\',
    \'parentId\', $AccountIdEn,
    );
ext\\email\\applyTemplate($emailIdEn, \'6695ec5990316cf93\');

ifThen(sendExample == true, ext\\email\\send($emailIdEn); sendExample = false; emailsIds = array\\push(emailsIds, $emailIdEn))
);


//Send Email (Spanish)

ifThen($English == false,
$attachmentIdEs = ext\\pdf\\generate(
    \'Account\',
    $AccountId,
    \'666b0b047120ba682\',
    \'Sus suscripciones de Microsoft Business que están por renovarse en los próximos 90 días.pdf\'
);

$attachmentsIdsEs = array\\push(attachmentsIds, $attachmentIdEs);

$emailIdEs = record\\create(
    \'Email\',
    \'to\', emailAddress,
    \'status\', \'Sending\',
    \'attachmentsIds\', $attachmentsIdsEs,
    \'parentType\', \'Account\',
    \'parentId\', $AccountId,
    );
ext\\email\\applyTemplate($emailIdEs, \'6695ec5990316cf93\');

ifThen(sendExample == true, ext\\email\\send($emailIdEs); sendExample = false; emailsIds = array\\push(emailsIds, $emailIdEs))
);',
            'cid' => 1,
            'id' => '2qdz2nf5ug',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'VendorCloudConsumption' => [
      0 => [
        'id' => '670e83cb309620f45',
        'actions' => [
          0 => (object) [
            'formula' => '
// Billing

$billingPeriodDay = string\\substring(usageperiod, 9, 2);
$billingPeriodMonth = string\\substring(usageperiod, 0, 2);
$billingPeriodYear = string\\substring(usageperiod, 3, 4);

//billingPeriodConverted = string\\concatenate($billingPeriodYear,\'-\', $billingPeriodMonth,\'-\',$billingPeriodDay);

name = subscriptionId;
//setting alert range
$red = 1.15;
$orange = 1.10;
$yellow = 1.05;

// alertLevel by average last 3 days
$average3days = ((lastDay1+lastDay2+lastDay3)/3);
ifThenElse(price/$average3days>$red, alertLevel = "Red", 
    ifThenElse(price/$average3days>$orange, alertLevel = "Orange", 
        ifThenElse(price/$average3days>$yellow, alertLevel = "Yellow", alertLevel = "None")));

//check days in current month
ifThen(datetime\\month(datetime\\today()) == 1 ||
    datetime\\month(datetime\\today()) == 3 || 
    datetime\\month(datetime\\today()) == 5 ||     
    datetime\\month(datetime\\today()) == 7 || 
    datetime\\month(datetime\\today()) == 8 || 
    datetime\\month(datetime\\today()) == 10 || 
    datetime\\month(datetime\\today()) == 12,
    $daysinMonth = 31);
ifThen(datetime\\month(datetime\\today()) == 4 ||
    datetime\\month(datetime\\today()) == 6 || 
    datetime\\month(datetime\\today()) == 9 ||     
    datetime\\month(datetime\\today()) == 11,
    $daysinMonth = 30);
ifThen(datetime\\month(datetime\\today()) == 2, $daysinMonth = 28);
//days Passed
$daysPassed = datetime\\date(datetime\\today());
$averageConsumption = price/$daysPassed;

//calculate forecast
ifThen(category != \'LICENSE\', forecast = $averageConsumption*$daysinMonth);
ifThen(datetime\\month(datetime\\today()) != datetime\\month(billingPeriodConverted), forecast = price);

// last update info
//description = string\\concatenate(datetime\\diff(datetime\\now(), lastUpdated, \'hours\'), \' hours ago\');

description = \' 22 hours ago\';

// alertLevel by average last 3 months
//$old_price = entity\\attributeFetched(\'price\');
//ifThen(price>($old_price*1.2), description = "fraude");


salesOrderId = record\\findOne(\'SalesOrder\', \'createdAt\', \'desc\', \'vendorAccountName=\', subscriptionId);

ifThen(category == \'AZURE\' && partnerName != "", resellerName = partnerName);
ifThen(category == \'OFFICE\' && partnerName != "", resellerName = partnerName);
ifThen(category == \'OFFICE-USAGE\' && partnerName != "", resellerName = partnerName);
ifThen(category == \'LICENSE\' && partnerName != "", resellerName = salesOrder.accountParentNameExternal);

//$countId = record\\count(\'VendorCloudConsumption\', \'resellerName=\', resellerName);

//ifThen($countId >= 2, $findId = record\\findOne(\'VendorCloudConsumption\', \'price\', \'desc\', \'resellerName=\', resellerName)); 

//ifThen(top10 == false, record\\update(\'VendorCloudConsumption\', $findId, \'top10\', true));


//bloco formula relacionado ao aplicativo, esse trecho serve para procurar um time com o mesmo nome do parterId do registro e relacionar o time ao registro para aplicar o ACL; Exemplo, caso o ´partnerId´ do registro seja ´5122108´, vamos procurar um time na entidade com o nome ´5122108´

// Filtragem do PartnerID "5122108" para os registros da eNUBE.
ifThen(partnerId == \'5122108\', 

//com a formula findOne, vou buscar na entidade Team um registro que tenha o ´name´ igual ao partnerId do registro de cloud consumption revenue;
    $teamId = record\\findOne("Team", "createdAt", "desc", "name=", partnerId);
 
//validar se a variavel teamId não está vazia
    ifThen(
        $teamId != null && $teamId != "", 
        entity\\addLinkMultipleId(\'teams\', $teamId)
    );
);',
            'cid' => 0,
            'id' => 'lx6aq18t35',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'PBGeral' => [
      0 => [
        'id' => '672a394ea8c5506cd',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'financialStatus',
            'type' => 'all',
            'value' => 'Complete'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '652074bc5fb267729',
            'elementId' => '5rdpvcdhuz',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '672a394eb176549ee',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'organizationalStatusCloud',
            'type' => 'all',
            'value' => 'Complete'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '652074bc5fb267729',
            'elementId' => '2oo0jimpzm',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '672a394eb94f88c5b',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'cybersolvsStatus',
            'type' => 'all',
            'value' => 'Complete'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '652074bc5fb267729',
            'elementId' => '53jlj4nh2o',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '672a394ec3a66a932',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'dataAICategory',
            'value' => 'Aware',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'dataAICategory',
            'value' => 'Ready',
            'type' => 'any'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'dataAICategory',
            'value' => 'Expert',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '652074bc5fb267729',
            'elementId' => 'xbexfw9ucq',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Quote' => [
      0 => [
        'id' => '67364e343ecab2006',
        'actions' => [
          0 => (object) [
            'formula' => '
$i = 0;
$quoteDiscount = 0;
$ids = record\\findRelatedMany("Quote", id, "items", 200);
ifThen(array\\length($ids) > 0, 
while(
    $i < array\\length($ids), 
    $valor = record\\attribute("QuoteItem", array\\at($ids, $i), "discountAmount");
    ifThen($valor != null, $quoteDiscount = $quoteDiscount + $valor);
    //$oppDiscount = $oppDiscount + $valor;
    $i = $i + 1
);
amountWithDiscount = $quoteDiscount;
//amountDiscounted = number\\format((amount - amountWithDiscount) * (-1), 2, ",");
amountDiscounted = (amount - amountWithDiscount) * (-1);
);

ifThen(itemList == null, amountWithDiscount = amount + amountDiscounted);
amountDiscountedCurrency = amountCurrency;
',
            'cid' => 0,
            'id' => 'gzcv42jegb',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '673a50b098942aca9',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 2,
            'fieldToCompare' => 'opportunity.quoteOpp',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'oppQuote',
            'fieldList' => [
              0 => 'itemList'
            ],
            'fields' => (object) [
              'itemList' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'itemList'
              ]
            ],
            'cid' => 0,
            'id' => 'u1tc9wuk28',
            'parentEntityType' => NULL,
            'formula' => '',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '681f70a522c0944be',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'cDisplayProducts',
            'subjectType' => NULL,
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'cDisplayProducts',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '681f70a518218c7a2',
            'elementId' => 'hg1aqa262b',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '68307ecd9db459829',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'opportunity.presentQuoteEmail',
            'subjectType' => NULL,
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'isEmpty',
            'cid' => 2,
            'fieldToCompare' => 'opportunity.quoteOpp',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673d028e994677e5a',
            'elementId' => 'tde18asreo',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'CPartnerAssessment' => [
      0 => [
        'id' => '67d36a84c9672962b',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67d354dfef4640985',
            'elementId' => 'fodgd28xbg',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Task' => [
      0 => [
        'id' => '683e06e862b0b9345',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'name',
            'type' => 'all',
            'value' => 'Solicitação de Alteração CIS Pendente'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'cid' => 1,
            'fieldToCompare' => 'assignedUser',
            'subjectType' => NULL,
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 2,
            'fieldToCompare' => 'assignedUser',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 3,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Sales - Cloud XaaS Solutions',
            'type' => 'any',
            'value' => '675081f4a23d5ec2f'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 4,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Sales - Cloud XaaS Solutions - Manager',
            'type' => 'any',
            'value' => '675081f4ac45f6f81'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '683616173f6441690',
            'elementId' => 'jr78y39ris',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ]
  ],
  'afterRecordUpdated' => [
    'Services' => [
      0 => [
        'id' => '636ae808b3b00da6d',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 0,
            'fieldToCompare' => 'modifiedAt',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'formula' => 'version = version + 1;',
            'cid' => 0,
            'id' => 'jcds472453',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Contact' => [
      0 => [
        'id' => '649c872e3cbdc9a5a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'isEmpty',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'account.emailAddress',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'account',
            'fieldList' => [
              0 => 'emailAddress'
            ],
            'fields' => (object) [
              'emailAddress' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'emailAddress'
              ]
            ],
            'cid' => 0,
            'id' => 'v6iwmah5y3',
            'parentEntityType' => NULL,
            'formula' => '',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'GooglePartnerAdvantage' => [
      0 => [
        'id' => '64af1c847126fcf57',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'assignedUser',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'notEquals',
            'cid' => 1,
            'fieldToCompare' => 'assignedUser',
            'type' => 'all',
            'subjectType' => 'value',
            'valueName' => 'Leonardo Camargo',
            'value' => '63811ea792245fa05'
          ]
        ],
        'actions' => [
          0 => (object) [
            'execution' => (object) [
              'type' => 'immediately',
              'field' => false,
              'shiftDays' => 0,
              'shiftUnit' => 'days'
            ],
            'from' => 'system',
            'to' => 'link:assignedUser',
            'optOutLink' => false,
            'cid' => 0,
            'id' => 'u07eo0hkp9',
            'emailTemplateId' => '63ed5d314980217e0',
            'emailTemplateName' => 'Opportunity saved - Google - Qualify - PT-BR',
            'replyTo' => '',
            'fromEmail' => '',
            'toEmail' => '',
            'replyToEmail' => '',
            'doNotStore' => false,
            'type' => 'sendEmail'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'AWS' => [
      0 => [
        'id' => '657afd90616e34478',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'update',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'awsVersions',
            'fieldList' => [
              0 => 'assignedUser',
              1 => 'lastupdate',
              2 => 'awsAccreditedProfessionalsBussines',
              3 => 'awsAccreditedProfessionalsTechnical',
              4 => 'awsFoundationalCertifiedIndividuals',
              5 => 'awsTechnicalCertifiedIndividuals',
              6 => 'competency',
              7 => 'countCompetency',
              8 => 'countEspecialidades',
              9 => 'customerSatisfactionResponses',
              10 => 'description',
              11 => 'specialities',
              12 => 'launchedOppsAmount',
              13 => 'launchedOppsAmountCurrency',
              14 => 'launchedOppsCount',
              15 => 'name',
              16 => 'partnerBusinessPlan',
              17 => 'partnerType',
              18 => 'publiclyReferenceableCustomers',
              19 => 'awsTechnicalCertifiedIndividualsAssociate',
              20 => 'awsTechnicalCertifiedIndividualsProOrSpecialty',
              21 => 'tier',
              22 => 'teams',
              23 => 'dSA',
              24 => 'dataCompetencias',
              25 => 'dataEspecialidades',
              26 => 'sPMSID'
            ],
            'fields' => (object) [
              'assignedUser' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'assignedUser'
              ],
              'lastupdate' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'lastupdate'
              ],
              'awsAccreditedProfessionalsBussines' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSAccreditedProfessionalsBussines'
              ],
              'awsAccreditedProfessionalsTechnical' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSAccreditedProfessionalsTechnical'
              ],
              'awsFoundationalCertifiedIndividuals' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSFoundationalCertifiedIndividuals'
              ],
              'awsTechnicalCertifiedIndividuals' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSTechnicalCertifiedIndividuals'
              ],
              'competency' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'competency'
              ],
              'countCompetency' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'countCompetency'
              ],
              'countEspecialidades' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'countEspecialidades'
              ],
              'customerSatisfactionResponses' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'customerSatisfactionResponses'
              ],
              'description' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'description'
              ],
              'specialities' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'specialities'
              ],
              'launchedOppsAmount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'launchedOppsAmount'
              ],
              'launchedOppsAmountCurrency' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'launchedOppsAmountCurrency'
              ],
              'launchedOppsCount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'launchedOppsCount'
              ],
              'name' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'name'
              ],
              'partnerBusinessPlan' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'partnerBusinessPlan'
              ],
              'partnerType' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'partnerType'
              ],
              'publiclyReferenceableCustomers' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'publiclyReferenceableCustomers'
              ],
              'awsTechnicalCertifiedIndividualsAssociate' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSTechnicalCertifiedIndividualsAssociate'
              ],
              'awsTechnicalCertifiedIndividualsProOrSpecialty' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'aWSTechnicalCertifiedIndividualsProOrSpecialty'
              ],
              'tier' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'tier'
              ],
              'teams' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'teams'
              ],
              'dSA' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'dSA'
              ],
              'dataCompetencias' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'dataCompetencias'
              ],
              'dataEspecialidades' => (object) [
                'subjectType' => 'field',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days',
                'field' => 'dataEspecialidades'
              ],
              'sPMSID' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'sPMSID'
              ]
            ],
            'cid' => 0,
            'id' => 's7ejfgqhmc',
            'linkList' => [],
            'formula' => '',
            'type' => 'createRelatedEntity'
          ],
          1 => (object) [
            'formula' => 'ifThen(update == true, update = false);',
            'cid' => 1,
            'id' => 'jouxtp3ox6',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Quote' => [
      0 => [
        'id' => '664641c7ad2fb7c72',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'wasEqual',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all',
            'value' => 'In Review'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'reviewDate'
            ],
            'fields' => (object) [
              'reviewDate' => (object) [
                'subjectType' => 'today',
                'shiftDays' => '0',
                'attributes' => (object) [],
                'shiftUnit' => 'days'
              ]
            ],
            'cid' => 0,
            'id' => 'e4l1bf8wwh',
            'formula' => 'cOpportunityQuoteReviewId = opportunityId;',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'link' => 'opportunity',
            'fieldList' => [
              0 => 'cQuoteReviewDate'
            ],
            'fields' => (object) [
              'cQuoteReviewDate' => (object) [
                'subjectType' => 'today',
                'shiftDays' => 0,
                'attributes' => (object) [],
                'shiftUnit' => 'days'
              ]
            ],
            'cid' => 1,
            'id' => 'p1p1glhbg9',
            'parentEntityType' => NULL,
            'formula' => NULL,
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '664fa56dbfd4c523f',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all',
            'value' => 'Approved'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'opportunity',
            'fieldList' => [
              0 => 'quoteStatus'
            ],
            'fields' => (object) [
              'quoteStatus' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'status'
              ]
            ],
            'cid' => 1,
            'id' => '2l6gvjj4bc',
            'parentEntityType' => NULL,
            'formula' => NULL,
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '67364f10e3a830746',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all',
            'value' => 'Approved'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'oppQuote',
            'fieldList' => [
              0 => 'quoteStatus',
              1 => 'stage'
            ],
            'fields' => (object) [
              'quoteStatus' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'status'
              ],
              'stage' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'stage' => 'Negotiation'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'am85739gyi',
            'parentEntityType' => NULL,
            'formula' => '$i = 0;
$quoteDiscount = 0;
$ids = record\\findRelatedMany("Quote", id, "items", 200);
ifThen(array\\length($ids) > 0, 
while(
    $i < array\\length($ids), 
    $valor = record\\attribute("QuoteItem", array\\at($ids, $i), "discountAmount");
    ifThen($valor != null, $quoteDiscount = $quoteDiscount + $valor);
    //$oppDiscount = $oppDiscount + $valor;
    $i = $i + 1
);
amountWithDiscount = $quoteDiscount;
//amountDiscounted = number\\format((amount - amountWithDiscount) * (-1), 2, ",");
amountDiscounted = (amount - amountWithDiscount) * (-1);
);

ifThen(itemList == null, amountWithDiscount = amount + amountDiscounted);
amountDiscountedCurrency = amountCurrency;',
            'type' => 'updateRelatedEntity'
          ],
          1 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => '03zz634c18',
            'formula' => 'oppQuoteId = opportunityId;
',
            'type' => 'updateEntity'
          ],
          2 => (object) [
            'link' => 'opportunity',
            'fieldList' => [
              0 => 'quoteApprovalDate',
              1 => 'quoteStatus'
            ],
            'fields' => (object) [
              'quoteApprovalDate' => (object) [
                'subjectType' => 'today',
                'shiftDays' => 0,
                'attributes' => (object) [],
                'shiftUnit' => 'days'
              ],
              'quoteStatus' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'status'
              ]
            ],
            'cid' => 3,
            'id' => 'ahpanfpwy6',
            'parentEntityType' => NULL,
            'formula' => NULL,
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '681f6f7d659311eb7',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'cid' => 0,
            'fieldToCompare' => 'cDisplayProducts',
            'type' => 'all',
            'subjectType' => NULL
          ],
          1 => (object) [
            'comparison' => 'true',
            'cid' => 1,
            'fieldToCompare' => 'cDisplayProducts',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => '8k3wd6vk0v',
            'formula' => 'oppQuoteId = opportunityId;',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'EmailContent' => [
      0 => [
        'id' => '66a272683f3768e46',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all',
            'value' => 'Completed'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'cid' => 1,
            'fieldToCompare' => 'done',
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'true',
            'cid' => 2,
            'fieldToCompare' => 'done',
            'type' => 'all'
          ],
          3 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 3,
            'fieldToCompare' => 'scheduled',
            'type' => 'all'
          ],
          4 => (object) [
            'comparison' => 'has',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil (teste)'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '66a1642f407d043a9',
            'elementId' => 'lfs9sozk7r',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Task' => [
      0 => [
        'id' => '675866dbba29f3a5d',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 0,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'eNUBE Tasks - MCA',
            'type' => 'all',
            'value' => '64344838d39f138b6'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '64404a89a366993e0',
            'elementId' => 'bu3qe9ytak',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '683e06e87d331b4ae',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all',
            'value' => 'Completed'
          ],
          2 => (object) [
            'comparison' => 'notContains',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'name',
            'type' => 'all',
            'value' => 'Solicitação de Alteração CIS Pendente'
          ],
          3 => (object) [
            'comparison' => 'notEquals',
            'cid' => 3,
            'fieldToCompare' => 'modifiedBy',
            'subjectType' => 'field',
            'valueName' => NULL,
            'type' => 'all',
            'field' => 'assignedUser'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 4,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Sales - Cloud XaaS Solutions',
            'type' => 'any',
            'value' => '675081f4a23d5ec2f'
          ],
          1 => (object) [
            'comparison' => 'has',
            'cid' => 5,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'Sales - Cloud XaaS Solutions - Manager',
            'type' => 'any',
            'value' => '675081f4ac45f6f81'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '683616173f6441690',
            'elementId' => '7blptle33y',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Account' => [
      0 => [
        'id' => '677839ad0937836fc',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'bdm',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'cid' => 1,
            'fieldToCompare' => 'bdm',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'opportunities',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'kp6tjh1wlw',
            'parentEntityType' => NULL,
            'formula' => 'ifThen(stage == \'Prospecting\', usersIds = account.bdmIds);
ifThen(stage == \'Qualification\', usersIds = account.bdmIds);
ifThen(stage == \'Proposal\', usersIds = account.bdmIds);
ifThen(stage == \'Negotiation\', usersIds = account.bdmIds);
ifThen(stage == \'Implementation\', usersIds = account.bdmIds);
ifThen(stage == \'Migration\', usersIds = account.bdmIds);
ifThen(stage == \'Stand-by\', usersIds = account.bdmIds);
ifThen(stage == \'In Review\', usersIds = account.bdmIds);




',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Opportunity' => [
      0 => [
        'id' => '6786d3e781d425173',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'discountValue',
            'type' => 'all',
            'subject' => '0',
            'value' => 0
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'amountDiscount'
            ],
            'fields' => (object) [
              'amountDiscount' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'amount'
              ]
            ],
            'cid' => 1,
            'id' => 'ywf7tjomtb',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '67b5e24c2c96171f9',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'stage',
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'stage',
            'type' => 'any',
            'value' => 'Cancelada'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'stage',
            'type' => 'any',
            'value' => 'Closed Lost'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'quoteStatus'
            ],
            'fields' => (object) [
              'quoteStatus' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'quoteStatus' => 'Canceled'
                ]
              ]
            ],
            'cid' => 1,
            'id' => '5oph6b1125',
            'formula' => NULL,
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'link' => 'quotes',
            'fieldList' => [
              0 => 'status'
            ],
            'fields' => (object) [
              'status' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'status' => 'Canceled'
                ]
              ]
            ],
            'cid' => 0,
            'id' => 's47v5mhsln',
            'parentEntityType' => NULL,
            'formula' => NULL,
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Case' => [
      0 => [
        'id' => '67a4c0eae96d879be',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67583e174c53b80c2',
            'elementId' => 'sh9r0dnjxn',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '67b76fc4a1c769554',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'cRegion',
            'value' => 'Brasil',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6749e0531517220a7',
            'elementId' => 'rziznutbsg',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '67b772f1986233a22',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'cRegion',
            'value' => 'MCA',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67a26c572c8c2b8a6',
            'elementId' => 'rziznutbsg',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Migrations' => [
      0 => [
        'id' => '67d0882f24ab1e3d3',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 2,
            'fieldToCompare' => 'bucket',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'changed',
            'subjectType' => NULL,
            'cid' => 3,
            'fieldToCompare' => 'bucketMicrosoft',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673264917f674d48c',
            'elementId' => 'yqw8zah0po',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '67d0888e71eb414f7',
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'bucket',
            'type' => 'any',
            'value' => 'Cancelado'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 1,
            'fieldToCompare' => 'status',
            'type' => 'any',
            'value' => 'Cancelled'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 2,
            'fieldToCompare' => 'opportunity.stage',
            'type' => 'any',
            'value' => 'Cancelada'
          ],
          3 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'opportunity.stage',
            'type' => 'any',
            'value' => 'Closed Lost'
          ],
          4 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'bucketMicrosoft',
            'value' => 'Cancelado',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673265d576f3d2e3c',
            'elementId' => 'lk45a4771q',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '67d08910171407973',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 5,
            'fieldToCompare' => 'opportunity.stage',
            'value' => 'Closed Won',
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 3,
            'fieldToCompare' => 'bucketMicrosoft',
            'value' => 'Consumo Estimado Concluído',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 4,
            'fieldToCompare' => 'bucket',
            'value' => 'Consumo Estimado Concluído',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6732641f1317e72ac',
            'elementId' => 'qhcyptl7wr',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ]
  ],
  'afterRecordCreated' => [
    'Lead' => [
      0 => [
        'id' => '63ece5dfd3b9fa662',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '63bdbe1c6d4eb65ed',
            'elementId' => 'b4ssf6i3bz',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '66cce0a35ca3cf0b9',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 0,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'ISV Experience (Roleta)',
            'type' => 'all',
            'value' => '632cc1e1e69b213db'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '632cc213cb0343fb1',
            'elementId' => 'ws0wz2s1al',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'PBGeral' => [
      0 => [
        'id' => '652552c16deacfdc1',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 0,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Forms Platform',
            'value' => '64f8a9800d65b4e2f',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '65254f481bfdef6d8',
            'elementId' => '3ivqjkze30',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '672a394e9d0239165',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'isEmpty',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'name',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '652074bc5fb267729',
            'elementId' => 'mp6jlgt4ho',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Notifications' => [
      0 => [
        'id' => '657c78e928e8726ce',
        'actions' => [
          0 => (object) [
            'execution' => (object) [
              'type' => 'immediately',
              'field' => false,
              'shiftDays' => 0,
              'shiftUnit' => 'days'
            ],
            'from' => 'system',
            'to' => 'specifiedUsers',
            'optOutLink' => false,
            'cid' => 0,
            'id' => 'b8ameqjm0c',
            'emailTemplateId' => '657c7881eebab74b7',
            'emailTemplateName' => 'Nova Notificação - CDP - (PT-BR)',
            'replyTo' => '',
            'toSpecifiedEntityName' => 'User',
            'toSpecifiedEntityIds' => [
              0 => '61448806e65182366'
            ],
            'toSpecifiedEntityNames' => (object) [
              '61448806e65182366' => 'Lucas Rinaldi'
            ],
            'fromEmail' => '',
            'toEmail' => '',
            'replyToEmail' => '',
            'doNotStore' => false,
            'type' => 'sendEmail'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'PartnersGoogleCloud' => [
      0 => [
        'id' => '6596ee8aedc64fa8c',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'account',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => 'i3kq22gn6z',
            'formula' => '// Atualização de partner program  para o time Managment.
entity\\addLinkMultipleId(\'teams\', \'640f417f9bc453ac3\');

ifThen(countryAccount == "Argentina", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Bolivia", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Brasil", entity\\addLinkMultipleId(\'teams\', \'643418441fabd22dd\'));
ifThen(countryAccount == "Costa Rica", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Chile", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Colombia", entity\\addLinkMultipleId(\'teams\', \'6434182fafe7d4fe6\'));
ifThen(countryAccount == "Dominican Republic", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Ecuador", entity\\addLinkMultipleId(\'teams\', \'6434182fafe7d4fe6\'));
ifThen(countryAccount == "El Salvador", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Guadelouope", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Guatemala", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Honduras", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Mexico", entity\\addLinkMultipleId(\'teams\', \'6434184940f72cec2\'));
ifThen(countryAccount == "Panama", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Paraguay", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Peru", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Puerto Rico", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));
ifThen(countryAccount == "Uruguay", entity\\addLinkMultipleId(\'teams\', \'643417ce3ea5ac5c4\'));
ifThen(countryAccount == "Venezuela", entity\\addLinkMultipleId(\'teams\', \'6434183de37dc38f3\'));',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '67a9f76d8e0b6f9b3',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'isEmpty',
            'subjectType' => NULL,
            'cid' => 0,
            'fieldToCompare' => 'progresoGoogle',
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'isEmpty',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'progresoGoogle',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'partnerLevel'
            ],
            'fields' => (object) [
              'partnerLevel' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'partnerLevel' => 'Onboarding'
                ]
              ]
            ],
            'cid' => 0,
            'id' => '7zpcyru4qn',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'BucketTimer' => [
      0 => [
        'id' => '674f5d13c63c770b8',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'bucket',
            'type' => 'all'
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 1,
            'fieldToCompare' => 'migrations',
            'type' => 'all'
          ],
          2 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => 'today',
            'shiftDays' => 0,
            'cid' => 2,
            'fieldToCompare' => 'startDate',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6732664b1f7937788',
            'elementId' => 'yilbcp0bin',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Task' => [
      0 => [
        'id' => '675866dbb0a83dc4c',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'has',
            'cid' => 0,
            'fieldToCompare' => 'teams',
            'subjectType' => 'value',
            'valueName' => 'eNUBE Tasks - MCA',
            'type' => 'all',
            'value' => '64344838d39f138b6'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '64404a89a366993e0',
            'elementId' => 'u02w7bxhjy',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Case' => [
      0 => [
        'id' => '67b76fc497a9e4d37',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'cRegion',
            'value' => 'Brasil',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '6749e0531517220a7',
            'elementId' => '82m6vkvreh',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '67b772f18c4581f7c',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'cRegion',
            'value' => 'MCA',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67a26c572c8c2b8a6',
            'elementId' => '82m6vkvreh',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'CAccountEndCustomer' => [
      0 => [
        'id' => '67c864b036b41a043',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67c8605d170722a7b',
            'elementId' => 'v7opmcjgob',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Account' => [
      0 => [
        'id' => '67c865390b0677457',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67b5e64ef0e75d17f',
            'elementId' => '37biqptrfa',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '68502193e9f8e5505',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 1,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Stefany Martins',
            'value' => '66e9bb06700de275e'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 2,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Luiz Agnelli',
            'value' => '64a48a1b94a290e54'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'cid' => 3,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Patricia Monreal',
            'value' => '63503c27dceddc917'
          ],
          3 => (object) [
            'comparison' => 'equals',
            'cid' => 4,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Maxwell Silva',
            'value' => '6390e2483a148abee'
          ],
          4 => (object) [
            'comparison' => 'equals',
            'cid' => 5,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Thiago Santos',
            'value' => '65f1ed94bcfe31a4b'
          ],
          5 => (object) [
            'comparison' => 'equals',
            'cid' => 6,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Thiago Freixedelo',
            'value' => '64a489f567fe2f6e7'
          ],
          6 => (object) [
            'comparison' => 'equals',
            'cid' => 7,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Heitor Caldeira',
            'value' => '66e9bbc5a33648a85'
          ],
          7 => (object) [
            'comparison' => 'equals',
            'cid' => 8,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Amanda Carolina',
            'value' => '63503c24945d50bcc'
          ],
          8 => (object) [
            'comparison' => 'equals',
            'cid' => 9,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Maximiliano Souza',
            'value' => '632cca313b873b944'
          ],
          9 => (object) [
            'comparison' => 'equals',
            'cid' => 10,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Patricia Melo',
            'value' => '632cca3140c0a6ba8'
          ],
          10 => (object) [
            'comparison' => 'equals',
            'cid' => 11,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'type' => 'any',
            'valueName' => 'Katia Miranda Rojas Marques',
            'value' => '632cca311e293da09'
          ],
          11 => (object) [
            'comparison' => 'equals',
            'cid' => 12,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Carla Fattorelli',
            'type' => 'any',
            'value' => '632cca305e6daa2fb'
          ],
          12 => (object) [
            'comparison' => 'equals',
            'cid' => 13,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Samuel Nogueira',
            'type' => 'any',
            'value' => '683f3244000417006'
          ],
          13 => (object) [
            'comparison' => 'equals',
            'cid' => 14,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Ester Silva',
            'type' => 'any',
            'value' => '681e3a6d195c92af3'
          ],
          14 => (object) [
            'comparison' => 'equals',
            'cid' => 15,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Nathan Sanches',
            'type' => 'any',
            'value' => '66e339a06c5e7d791'
          ],
          15 => (object) [
            'comparison' => 'equals',
            'cid' => 16,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Bruno Delfino',
            'value' => '65aa98bb860345647',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682e3fd355f296ff2',
            'elementId' => 'vrk185wcr9',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '685068c67e454425a',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'equals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'country',
            'type' => 'all',
            'value' => 'Brasil'
          ],
          1 => (object) [
            'comparison' => 'notEmpty',
            'subjectType' => NULL,
            'cid' => 1,
            'fieldToCompare' => 'cisCode',
            'type' => 'all'
          ]
        ],
        'conditionsAny' => [
          0 => (object) [
            'comparison' => 'equals',
            'cid' => 2,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Stefany Martins',
            'value' => '66e9bb06700de275e',
            'type' => 'any'
          ],
          1 => (object) [
            'comparison' => 'equals',
            'cid' => 3,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Luiz Agnelli',
            'value' => '64a48a1b94a290e54',
            'type' => 'any'
          ],
          2 => (object) [
            'comparison' => 'equals',
            'cid' => 4,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Patricia Monreal',
            'value' => '63503c27dceddc917',
            'type' => 'any'
          ],
          3 => (object) [
            'comparison' => 'equals',
            'cid' => 5,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Maxwell Silva',
            'value' => '6390e2483a148abee',
            'type' => 'any'
          ],
          4 => (object) [
            'comparison' => 'equals',
            'cid' => 6,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Thiago Santos',
            'value' => '65f1ed94bcfe31a4b',
            'type' => 'any'
          ],
          5 => (object) [
            'comparison' => 'equals',
            'cid' => 7,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Thiago Freixedelo',
            'value' => '64a489f567fe2f6e7',
            'type' => 'any'
          ],
          6 => (object) [
            'comparison' => 'equals',
            'cid' => 8,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Heitor Caldeira',
            'value' => '66e9bbc5a33648a85',
            'type' => 'any'
          ],
          7 => (object) [
            'comparison' => 'equals',
            'cid' => 9,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Amanda Carolina',
            'value' => '63503c24945d50bcc',
            'type' => 'any'
          ],
          8 => (object) [
            'comparison' => 'equals',
            'cid' => 10,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Maximiliano Souza',
            'value' => '632cca313b873b944',
            'type' => 'any'
          ],
          9 => (object) [
            'comparison' => 'equals',
            'cid' => 11,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Patricia Melo',
            'value' => '632cca3140c0a6ba8',
            'type' => 'any'
          ],
          10 => (object) [
            'comparison' => 'equals',
            'cid' => 12,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Katia Miranda Rojas Marques',
            'value' => '632cca311e293da09',
            'type' => 'any'
          ],
          11 => (object) [
            'comparison' => 'equals',
            'cid' => 13,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Carla Fattorelli',
            'value' => '632cca305e6daa2fb',
            'type' => 'any'
          ],
          12 => (object) [
            'comparison' => 'equals',
            'cid' => 14,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Samuel Nogueira',
            'value' => '683f3244000417006',
            'type' => 'any'
          ],
          13 => (object) [
            'comparison' => 'equals',
            'cid' => 15,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Ester Silva',
            'value' => '681e3a6d195c92af3',
            'type' => 'any'
          ],
          14 => (object) [
            'comparison' => 'equals',
            'cid' => 16,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Nathan Sanches',
            'value' => '66e339a06c5e7d791',
            'type' => 'any'
          ],
          15 => (object) [
            'comparison' => 'equals',
            'cid' => 17,
            'fieldToCompare' => 'createdBy',
            'subjectType' => 'value',
            'valueName' => 'Bruno Delfino',
            'value' => '65aa98bb860345647',
            'type' => 'any'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682b94364a54027fb',
            'elementId' => 'z5y7jefjfb',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Migrations' => [
      0 => [
        'id' => '67d0882f30c3e91db',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'isEmpty',
            'cid' => 0,
            'fieldToCompare' => 'bucketTimers',
            'type' => 'all',
            'subjectType' => NULL
          ]
        ],
        'conditionsFormula' => '//Bucket
ifThen(array\\includes(migrations.label, \'AWS\') == true, migrations.bucket != null);
ifThen(array\\includes(migrations.label, \'Microsoft\') == true, migrations.bucketMicrosoft != null);',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '673264917f674d48c',
            'elementId' => 'z8c6vqjqjd',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Opportunity' => [
      0 => [
        'id' => '67eeaaf83ea039cc1',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEquals',
            'subjectType' => 'value',
            'cid' => 0,
            'fieldToCompare' => 'account.country',
            'value' => 'Brasil',
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '67a382c0a00c481d2',
            'elementId' => '96n8mq15xt',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ]
  ],
  'scheduled' => [
    'Marketing' => [
      0 => [
        'id' => '652ecf17d6dd91ce5',
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'status'
            ],
            'fields' => (object) [
              'status' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'status' => 'Inactivo '
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'h0z8wj92u5',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'SalesOrder' => [
      0 => [
        'id' => '66631bb3e46d39934',
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'contractEndDateVendor'
            ],
            'fields' => (object) [
              'contractEndDateVendor' => (object) [
                'subjectType' => 'today',
                'shiftDays' => '1200',
                'attributes' => (object) [],
                'shiftUnit' => 'months'
              ]
            ],
            'cid' => 0,
            'id' => '7ks5hurepq',
            'formula' => '',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '667d7bd89d94ad054',
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'microsoftRecommendations'
            ],
            'fields' => (object) [
              'microsoftRecommendations' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'microsoftRecommendations' => [
                    0 => 'None'
                  ]
                ]
              ]
            ],
            'cid' => 0,
            'id' => 'xourzllzmc',
            'formula' => 'quantity = number\\format(quantity, 0);
',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'formula' => '// EMS E3

ifThen(string\\contains(productSSA, \'Office 365 E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'EMS E3\'); microsoftRecommendationsEmail = \' Presenta EMS E3, Office 365 E5 y Copilot M365 para para buscar un crecimiento con funcionalidades de seguridad  e inteligencia artificial\');

// EMS E5

ifThen(string\\contains(productSSA, \'Office 365 E5\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'EMS E5\'); microsoftRecommendationsEmail = \' Presenta EMS E5 y Copilot M365 para para buscar un crecimiento con funcionalidades premium de seguridad e inteligencia artificial\');

// Microsoft 365 Business Premium

ifThen(string\\contains(productSSA, \'Microsoft 365 Business Standard\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Microsoft 365 Business Premium\'); microsoftRecommendationsEmail = \' Presenta Microsoft 365 Business Premium enfocando en las funcionalidades de seguridad que podría sumar a su licenciamiento y Copilot M365 para mejora de productividad con AI\');

// Microsoft 365 Business Standard + Copilot M365

ifThen(string\\contains(productSSA, \'Microsoft 365 Business Basic\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Microsoft 365 Business Standard + Copilot M365\'); microsoftRecommendationsEmail = \' Presenta los beneficios de Microsoft 365 Business Standard y Copilot M365\');

// Microsoft 365 A3

ifThen(string\\contains(productSSA, \'Microsoft 365 A1\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Microsoft 365 A3\'));

// Microsoft 365 A5

ifThen(string\\contains(productSSA, \'Microsoft 365 A3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Microsoft 365 A5\'); microsoftRecommendationsEmail = \' Presenta Microsoft 365 A5 con foco en las funcionalidades de seguridad y protección de información\');

// Office 365 E1

ifThen(string\\contains(productSSA, \'Microsoft 365 F1\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E1\'); microsoftRecommendationsEmail = \' Presentar Office 365 E3 y Copilot M365\');

// Office 365 E3 + Copilot M365

ifThen(string\\contains(productSSA, \'Office 365 E1\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E3 + Copilot M365\'); microsoftRecommendationsEmail = \' Presenta los beneficios de Office 365 E3 y Copilot M365\');

// Office 365 E3 o E5

ifThen(string\\contains(productSSA, \'Microsoft 365 F3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E3\', \'Office 365 E5\'); microsoftRecommendationsEmail = \'Presenta Office 365 E3 o Office 365 E5 y complementa con Copilot M365\');

// Office 365 E5

ifThen(string\\contains(productSSA, \'Office 365 E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E5\'); microsoftRecommendationsEmail = \' Presenta EMS E3, Office 365 E5 y Copilot M365 para para buscar un crecimiento con funcionalidades de seguridad  e inteligencia artificial\');

ifThen(string\\contains(productSSA, \'EMS E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E5\'));

ifThen(string\\contains(productSSA, \'Windows E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Office 365 E5\'));

// Windows E3

ifThen(string\\contains(productSSA, \'EMS E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Windows E3\'));

// Windows E5

ifThen(string\\contains(productSSA, \'EMS E5\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Windows E5\'));

// Copilot M365

ifThen(string\\contains(productSSA, \'Microsoft 365 E5\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Microsoft 365 E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Microsoft 365 F1\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'));

ifThen(string\\contains(productSSA, \'Microsoft 365 F3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'));

ifThen(string\\contains(productSSA, \'Office 365 E3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'));

ifThen(string\\contains(productSSA, \'Office 365 E5\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'));

ifThen(string\\contains(productSSA, \'Office 365 F3\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Microsoft 365 Business Premium\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Microsoft 365 Business Standard\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'));

ifThen(string\\contains(productSSA, \'Microsoft 365 A5 for faculty\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Microsoft 365 A3 for faculty\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \'Presenta Microsoft 365 A5 fon foco en funcionalidades de Seguridad y Copilot para M365 con foco en la mejora de productividad por AI\');

ifThen(string\\contains(productSSA, \'Office 365 A5 for faculty\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');

ifThen(string\\contains(productSSA, \'Office 365 A3 for faculty\') == true, microsoftRecommendations = array\\push(microsoftRecommendations, \'Copilot M365\'); microsoftRecommendationsEmail = \' Presenta Copilot para M365 y los beneficios del AI en mejora de la productividad\');


$None = array\\at(microsoftRecommendations, 0);
$Number = array\\length(microsoftRecommendations);

$Index1 = array\\at(microsoftRecommendations, 1);
$Index2 = array\\at(microsoftRecommendations, 2);
$Index3 = array\\at(microsoftRecommendations, 3);
$Index4 = array\\at(microsoftRecommendations, 4);

ifThen($Number == 2 && $None == \'None\', microsoftRecommendations = list($Index1));
ifThen($Number == 3 && $None == \'None\', microsoftRecommendations = list($Index1, $Index2));
ifThen($Number == 4 && $None == \'None\', microsoftRecommendations = list($Index1, $Index2, $Index3));

$separator = \' y \';
microsoftRecommendationsText = array\\join(microsoftRecommendations, $separator);',
            'cid' => 1,
            'id' => 'bz894wr6tu',
            'type' => 'executeFormula'
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '67913522eec827cb1',
        'actions' => [
          0 => (object) [
            'fieldList' => [
              0 => 'top5Customers'
            ],
            'fields' => (object) [
              'top5Customers' => (object) [
                'subjectType' => 'value',
                'attributes' => (object) [
                  'top5Customers' => false
                ]
              ]
            ],
            'cid' => 0,
            'id' => '9bwqgycyiw',
            'formula' => '// Renovações: Vencimento do contrato (dias)

ifThen(contractEndDateVendor != null, contractEndDateDays = datetime\\diff(contractEndDateVendor, datetime\\today(), \'days\'));',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'link' => 'account',
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => 'ukrbhfo5za',
            'parentEntityType' => NULL,
            'formula' => '// Identify Renewals - next 90 days

$renewalsNext90Days = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 100, \'contractEndDateVendor\', \'desc\', \'reportFilter664dfdebb84637a58\');
ifThen($renewalsNext90Days != null, renewalsIds = $renewalsNext90Days);
ifThenElse(array\\length(renewalsIds) > 0, hasRenewals = true, hasRenewals = false);


// Identify Microsoft Recommendations

$microsoftRecommendation = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 100, \'contractEndDateVendor\', \'desc\', \'reportFilter66831cbe23b6204fe\');
ifThen($microsoftRecommendation != null, salesOrdersRecommendationsIds = $microsoftRecommendation);


// Identify Reserved Instances

$reservedInst = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 50, \'contractEndDateVendor\', \'desc\', \'reportFilter66916dc409c1b86f7\');
ifThen($reservedInst != null, reservedInstancesIds = $reservedInst);
',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'BucketTimer' => [
      0 => [
        'id' => '6762d337e6227ca64',
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => 'z2x6378gon',
            'formula' => 'duration = datetime\\diff(datetime\\today(), startDate, \'days\')',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Account' => [
      0 => [
        'id' => '6792a31b236ad617e',
        'actions' => [
          0 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 0,
            'id' => '80hbu4nqmv',
            'formula' => '// Identify Renewals

$renewalsNext90Days = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 100, \'contractEndDateVendor\', \'desc\', \'reportFilter664dfdebb84637a58\');
ifThen($renewalsNext90Days != null, renewalsIds = $renewalsNext90Days);
ifThenElse(array\\length(renewalsIds) > 0, hasRenewals = true, hasRenewals = false);


// Identify Microsoft Recommendations

$microsoftRecommendation = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 100, \'contractEndDateVendor\', \'desc\', \'reportFilter66831cbe23b6204fe\');
ifThen($microsoftRecommendation != null, salesOrdersRecommendationsIds = $microsoftRecommendation);


// Identify Reserved Instances

$reservedInst = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 50, \'contractEndDateVendor\', \'desc\', \'reportFilter66916dc409c1b86f7\');
ifThen($reservedInst != null, reservedInstancesIds = $reservedInst);',
            'type' => 'updateEntity'
          ],
          1 => (object) [
            'fieldList' => [],
            'fields' => (object) [],
            'cid' => 1,
            'id' => '4absbm3z8b',
            'formula' => '// Renewals 30, 60, 90 days

// Quanditade de Subscriptions

$renewals90Days = entity\\countRelated(\'salesOrders\', \'reportFilter664dfdebb84637a58\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewals90Days\', $renewals90Days);

$renewalsEndCustomers30Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d0b06517450b14\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsEndCustomers30Days\', $renewalsEndCustomers30Days);

$renewalsEndCustomers60Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d0e340882520f7\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsEndCustomers60Days\', $renewalsEndCustomers60Days);

$renewalsEndCustomers90Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d0e6ceb98d29e4\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsEndCustomers90Days\', $renewalsEndCustomers90Days);


// Quantidade de Licences

$renewalsLicenses30Days = entity\\sumRelated(\'salesOrders\', \'quantity\', \'reportFilter664d0b06517450b14\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsLicenses30Days\', $renewalsLicenses30Days);

$renewalsLicenses60Days = entity\\sumRelated(\'salesOrders\', \'quantity\', \'reportFilter664d0e340882520f7\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsLicenses60Days\', $renewalsLicenses60Days);

$renewalsLicenses90Days = entity\\sumRelated(\'salesOrders\', \'quantity\', \'reportFilter664d0e6ceb98d29e4\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsLicenses90Days\', $renewalsLicenses90Days);

// Auto Renew Off

$renewalsAutoOff30Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d0fd3e3ead8274\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsAutoOff30Days\', $renewalsAutoOff30Days);

$renewalsAutoOff60Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d101ecb1f34383\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsAutoOff60Days\', $renewalsAutoOff60Days);

$renewalsAutoOff90Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d1038e67c31c3c\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsAutoOff90Days\', $renewalsAutoOff90Days);

// Reserved Instance

$renewalsReservedInstances90Days = entity\\countRelated(\'salesOrders\', \'reportFilter664d0eba732cf5106\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsReservedInstances90Days\', $renewalsReservedInstances90Days);

// Microsoft Recommendations

$renewalsRecommendations90Days = entity\\countRelated(\'salesOrders\', \'reportFilter66831cbe23b6204fe\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsRecommendations90Days\', $renewalsRecommendations90Days);

$renewalsRecommendationsCopilot90Days = entity\\countRelated(\'salesOrders\', \'reportFilter664e33d0e85544c6c\');
record\\update(\'Renewals\', cRenewalsMicrosoftId, \'renewalsRecommendationsCopilot90Days\', $renewalsRecommendationsCopilot90Days);

// Top 5 Clientes

$topCustomers = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 5, \'quantity\', \'desc\', \'reportFilter664dfdebb84637a58\');

$topCustomer1 = array\\at($topCustomers, 0);
$topCustomer2 = array\\at($topCustomers, 1);
$topCustomer3 = array\\at($topCustomers, 2);
$topCustomer4 = array\\at($topCustomers, 3);
$topCustomer5 = array\\at($topCustomers, 4);

ifThen($topCustomer1 != null, record\\update(\'SalesOrder\', $topCustomer1, \'top5Customers\', true));
ifThen($topCustomer2 != null, record\\update(\'SalesOrder\', $topCustomer2, \'top5Customers\', true));
ifThen($topCustomer3 != null, record\\update(\'SalesOrder\', $topCustomer3, \'top5Customers\', true));
ifThen($topCustomer4 != null, record\\update(\'SalesOrder\', $topCustomer4, \'top5Customers\', true));
ifThen($topCustomer5 != null, record\\update(\'SalesOrder\', $topCustomer5, \'top5Customers\', true));

// Identify Top 5 Customers

$top5Customers = record\\findRelatedMany(\'Account\', id, \'salesOrders\', 5, \'quantity\', \'desc\', \'reportFilter669153f230b85ba6a\');
ifThen($top5Customers != null, top5CustomersIds = $top5Customers);

',
            'type' => 'updateEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Task' => [
      0 => [
        'id' => '683e06e86e1c8c53d',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '683616173f6441690',
            'elementId' => 'hi9g21dsdx',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ],
    'Opportunity' => [
      0 => [
        'id' => '685d45c9c07b809c0',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682ce77bd9c4c46c1',
            'elementId' => 'bgryc24yri',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      1 => [
        'id' => '685d45c9d8a4aa347',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682ce77bd9c4c46c1',
            'elementId' => 'n3lr3edkpx',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      2 => [
        'id' => '685d45c9ec490fa7c',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682ce77bd9c4c46c1',
            'elementId' => 'shilv2ytsv',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ],
      3 => [
        'id' => '685d45ca0d7a12b64',
        'actions' => [
          0 => (object) [
            'type' => 'startBpmnProcess',
            'flowchartId' => '682ce77bd9c4c46c1',
            'elementId' => '6ajx9520xa',
            'cid' => 0
          ]
        ],
        'portalOnly' => false
      ]
    ]
  ],
  'sequential' => [
    'Quote' => [
      0 => [
        'id' => '681f6fda87ba3dcbb',
        'conditionsAll' => [
          0 => (object) [
            'comparison' => 'notEmpty',
            'cid' => 0,
            'fieldToCompare' => 'opportunity.quoteOpp',
            'subjectType' => NULL,
            'type' => 'all'
          ]
        ],
        'actions' => [
          0 => (object) [
            'link' => 'oppQuote',
            'fieldList' => [
              0 => 'itemList'
            ],
            'fields' => (object) [
              'itemList' => (object) [
                'subjectType' => 'field',
                'attributes' => (object) [],
                'field' => 'itemList'
              ]
            ],
            'cid' => 0,
            'id' => 'u1tc9wuk28',
            'parentEntityType' => NULL,
            'formula' => '',
            'type' => 'updateRelatedEntity'
          ]
        ],
        'portalOnly' => false
      ]
    ]
  ]
];
