<?php
/*********************************************************************************
 * The contents of this file are subject to the Synnex Sales Pack
 * Agreement ("License") which can be viewed at
 * https://www.espocrm.com/sales-pack-agreement.
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * sublicense, resell, rent, lease, distribute, or otherwise  transfer rights
 * or usage to the software.
 *
 * Copyright (C) 2015-2021 Letrium Ltd.
 *
 * License ID: aed6ff2a1fc9fb91b91186d266a2be2e
 ***********************************************************************************/

class BeforeInstall
{
    public function run($container)
    {
        $entityManager = $container->get('entityManager');

        $extension = $entityManager->getRepository('Extension')->where(array('name' => 'Advanced Pack'))->findOne();
        if ($extension && version_compare($extension->get('version'), '2.0.0', '<')) {
            throw new \Espo\Core\Exceptions\Error('You need to unistall the old version of Advanced Pack first.');
        }
    }
}
