<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Tools\Project\Gantt;

use DateTimeImmutable;
use Espo\Core\Field\Date;
use Espo\Core\Field\DateTime;
use Espo\Tools\WorkingTime\CalendarFactory;
use Espo\Tools\WorkingTime\Extractor;
use Exception;
use RuntimeException;

class NonWorkingRangesService
{
    public function __construct(
        private CalendarFactory $calendarFactory,
    ) {}


    /**
     * @param array{Date, Date} $range
     * @return array{Date, Date}[]
     */
    public function get(array $range): array
    {
        $calendar = $this->calendarFactory->createGlobal();

        if (!$calendar->isAvailable()) {
            return [];
        }

        try {
            $from = DateTime::fromDateTime(
                new DateTimeImmutable($range[0]->toString(), $calendar->getTimezone())
            );

            $to = DateTime::fromDateTime(
                new DateTimeImmutable($range[1]->toString(), $calendar->getTimezone())
            );
        } catch (Exception $e) {
            throw new RuntimeException($e->getMessage());
        }

        $items = (new Extractor())->extractAllDayInversion($calendar, $from, $to);

        $list = [];

        foreach ($items as $item) {
            /** @var array{DateTime, DateTime} $item */

            $diff = $item[0]->diff($item[1]);

            if ($diff->days === 0) {
                continue;
            }

            if ($item[0]->isGreaterThan($item[1])) {
                continue;
            }

            $list[] = [
                Date::fromDateTime($item[0]->toDateTime()),
                Date::fromDateTime($item[1]->toDateTime()),
            ];
        }

        return $list;
    }
}
