<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\FieldValidations\ProjectGroup\Name;

use Espo\Core\FieldValidation\Validator;
use Espo\Core\FieldValidation\Validator\Data;
use Espo\Core\FieldValidation\Validator\Failure;
use Espo\Modules\Project\Entities\ProjectGroup;
use Espo\ORM\Entity;
use Espo\ORM\EntityManager;

/**
 * @implements Validator<ProjectGroup>
 */
class Unique implements Validator
{
    public function __construct(
        private EntityManager $entityManager,
    ) {}


    /**
     * @inheritDoc
     */
    public function validate(Entity $entity, string $field, Data $data): ?Failure
    {
        if (!$entity->getName()) {
            return null;
        }

        $where = [
            'name' => $entity->getName(),
            'projectId' => $entity->getProjectId(),
        ];

        if (!$entity->isNew()) {
            $where['id!='] = $entity->getId();
        }

        if (
            $this->entityManager
                ->getRDBRepositoryByClass(ProjectGroup::class)
                ->where($where)
                ->findOne()
        ) {
            return Failure::create();
        }

        return null;
    }
}
