<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2024-2025 Letrium Ltd.
 *
 * License ID: f27e70ce6801a13265271f5669c8bc5c
 ************************************************************************************/

namespace Espo\Modules\Project\Classes\AppParams;

use Espo\Core\Acl;
use Espo\Modules\Project\Entities\Project;
use Espo\Modules\Project\Entities\ProjectRole;
use Espo\ORM\EntityManager;
use Espo\Tools\App\AppParam;
use stdClass;

class ProjectRoles implements AppParam
{
    public function __construct(
        private EntityManager $entityManager,
        private Acl $acl,
    ) {}

    /**
     * @return stdClass[]
     */
    public function get(): array
    {
        if (!$this->acl->checkScope(Project::ENTITY_TYPE)) {
            return [];
        }

        $list = [];

        /** @var iterable<ProjectRole> $roles */
        $roles = $this->entityManager
            ->getRDBRepositoryByClass(ProjectRole::class)
            ->select(['id', 'name'])
            ->order('name')
            ->find();

        foreach ($roles as $role) {
            $list[] = (object) [
                'id' => $role->getId(),
                'name' => $role->getName(),
            ];
        }

        return $list;
    }
}
