<?php
/**
 * This file is part of the eNUBE Custom - EspoCRM extension.
 *
 * dubas s.c. - contact@dubas.pro
 * Copyright (C) 2023-2024 Arkadiy Asuratov, Emil Dubielecki
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

namespace Espo\Modules\DubasCustom\Classes\FieldProcessing\IconClass;

use Espo\Core\FieldProcessing\Saver as SaverInterface;
use Espo\Core\FieldProcessing\Saver\Params;
use Espo\Core\Utils\Metadata;
use Espo\Modules\DubasCustom\Entities\DashboardSet;
use Espo\ORM\Entity;

/**
 * @implements SaverInterface<DashboardSet>
 */
class Saver implements SaverInterface
{
    public function __construct(
        private readonly Metadata $metadata
    )
    {}

    public function process(Entity $entity, Params $params): void
    {
        $toProcess =
            $entity->getNumber() &&
            (
                $entity->isNew() ||
                $entity->isAttributeChanged('iconClass')
            );

        if (!$toProcess) {
            return;
        }

        $name = DashboardSet::ENTITY_TYPE . $entity->getNumber();

        $defsData = $this->metadata->get(['clientDefs', $name]);

        if (!is_array($defsData)) {
            $defsData = [];
        }

        $defsData['iconClass'] = $entity->get('iconClass');

        $this->metadata->set('clientDefs', $name, $defsData);

        $this->metadata->save();
    }
}
