<?php
/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: e4c270586a0c8a9fda53bda910f357e0
 ************************************************************************************/

namespace Espo\Modules\Advanced\Tools\Workflow\Core;

class RecipientIds
{
    /**
     * @param string[] $ids
     */
    public function __construct(
        private ?string $entityType = null,
        private array $ids = [],
        private bool $isOne = false,
    ) {}

    /**
     * @return string[]
     */
    public function getIds(): array
    {
        return $this->ids;
    }

    public function getEntityType(): ?string
    {
        return $this->entityType;
    }

    public function isOne(): bool
    {
        return $this->isOne;
    }
}
