/*********************************************************************************
 * The contents of this file are subject to the Synnex Sales Pack
 * Agreement ("License") which can be viewed at
 * https://www.espocrm.com/sales-pack-agreement.
 * By installing or using this file, You have unconditionally agreed to the
 * terms and conditions of the License, and You may not use this file except in
 * compliance with the License.  Under the terms of the license, You shall not,
 * sublicense, resell, rent, lease, distribute, or otherwise  transfer rights
 * or usage to the software.
 *
 * Copyright (C) 2015-2021 Letrium Ltd.
 *
 * License ID: aed6ff2a1fc9fb91b91186d266a2be2e
 ***********************************************************************************/

Espo.define('sales:opportunity-calculation-handler', ['sales:quote-calculation-handler'], function (Dep) {

    return Dep.extend({
        setup: function () {
            this.userDashboardSetList = [];

            console.log(this.getUser());
        },
        boundCurrencyFieldList: [
            'amount'
        ],
        boundCurrencyItemFieldList: ['unitPrice', 'amount'],
        modelIds: [],
        listenedAttributeList: [],

        listenedItemFieldList: ['name', 'quantity', 'unitPrice', 'licenseType', 'solutionType', 'timeContract', 'productId', 'productName', 'product'],

        calculateAmount: function (model) {
            console.log('calc v1')
            console.log(model)
            var amount = 0;
            var itemList = model.get('itemList') || [];
            itemList.forEach(function (item) {
                amount += item.amount || 0;
            }, this);

            amount = Math.round(amount * 100) / 100;

            model.set('amount', amount);
        },

        calculateItem: function (model) {
            console.log("calculateItem");
            console.log(model)
            var scope = this
            console.log(model.attributes.productId)
            if (model.attributes.productId != undefined) {
                Espo.Ajax.getRequest('Product/' + model.attributes.productId)
                    .then(result => {
                        console.log(result)
                        if (model.get('unitPrice') == undefined) {
                            model.set('unitPrice', result.unitPrice);
                            model.set('name', result.name);
                        }

                        var quantity = model.get('quantity');
                        var unitPrice = model.get('unitPrice');

                        var amount = quantity * unitPrice;
                        amount = Math.round(amount * 100) / 100;

                        model.set({
                            amount: amount
                        });
                    });
            }
        },
        optionSelection: function (brand, licenseTypeSelect, solutionTypeSelect, timeContractSelect) {
            return new Promise(function (r) {
                console.log('callingSwitchCase');
                console.log(brand)
                var microsoftLicenseType = [
                    "Azure",
                    "Dynamics 365",
                    "Microsoft 365 - Montlhy",
                    "Microsoft 365 - Annual",
                    "Software Perpetual",
                    "Software Subscription",
                    "Open Value Perpetual",
                    "Open Valeu SA",
                    "Open Valeu Subscription 1 Ano",
                    "Open Valeu Subscription 3 Anos",
                ]
                var microsoftFaturacion = [
                    "Monthly",
                    "Annual",
                    "Up front",
                ]
                var microsoftPeriod = [
                    "1 Month",
                    "1 Year",
                    "3 Years",
                    "Perpetual",
                    "Pay as you go"
                ]
                var googleLicenseType = [
                    "New Business",
                    "Upgrade",
                    "Renewal",
                ]
                var googleFaturacion = [
                    "Monthly",
                    "Annual",
                    "Trial",
                    "Flexible",
                ]
                var googlePeriod = [
                    "1 Month",
                    "1 Year",
                    "2 Years",
                    "3 Years",
                ]
                var awsLicenseType = [
                    "AWS",
                ]
                var awsPeriod = [
                    "1 Month",
                    "1 Year",
                    "2 Years",
                    "3 Years",
                ]
                var awsFaturacion = [
                    "Monthly",
                    "Annual",
                    "Up front",
                ]
                switch (brand) {
                    case "Microsoft":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < microsoftLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == microsoftLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${microsoftLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < microsoftFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == microsoftFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${microsoftFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < microsoftPeriod.length; y++) {
                                if (timeContractSelect.options[i].value == microsoftPeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${microsoftPeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    case "Google":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            if (licenseTypeSelect.options[i] != "") {
                                licenseTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            if (solutionTypeSelect.options[i] != "") {
                                solutionTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            if (timeContractSelect.options[i] != "") {
                                timeContractSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < googleLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == googleLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${googleLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < googleFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == googleFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${googleFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < googlePeriod.length; y++) {
                                if (timeContractSelect.options[i].value == googlePeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${googlePeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    case "AWS":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            if (licenseTypeSelect.options[i] != "") {
                                licenseTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            if (solutionTypeSelect.options[i] != "") {
                                solutionTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            if (timeContractSelect.options[i] != "") {
                                timeContractSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < awsLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == awsLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${awsLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < awsFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == awsFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${awsFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < awsPeriod.length; y++) {
                                if (timeContractSelect.options[i].value == awsPeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${awsPeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    default:
                        r()
                        break;
                }
            })

        },
        selectProduct: function (model, product) {
            console.log("selectProduct v1")
            var sourcePrice = product.get('unitPrice');
            var sourceCurrency = product.get('unitPriceCurrency');
            var targetCurrency = model.get('unitPriceCurrency');

            var baseCurrency = this.config.get('baseCurrency');
            var rates = this.config.get('currencyRates') || {};

            var value = sourcePrice;
            value = value * (rates[sourceCurrency] || 1.0);
            value = value / (rates[targetCurrency] || 1.0);

            var targetPrice = Math.round(value * 100) / 100;

            model.set({
                productId: product.id,
                productName: product.get('name'),
                name: product.get('name'),
                unitPrice: targetPrice,
                unitPriceCurrency: targetCurrency
            });
            console.log('selectProduct');
            console.log(product);
            window.productGlobal = product;
        }
    });
});
