/************************************************************************
 * This file is part of TD SYNNEX.
 *
 * TD SYNNEX – Open Source CRM application.
 * Copyright (C) 2014-2024 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "TD SYNNEX" word.
 ************************************************************************/

define('crm:views/document/fields/file', ['views/fields/file'], function (Dep) {

    return Dep.extend({

        getValueForDisplay: function () {
            if (this.isListMode()) {
                let name = this.model.get(this.nameName);
                let id = this.model.get(this.idName);

                if (!id) {
                    return '';
                }

                return $('<a>')
                    .attr('title', name)
                    .attr('href', this.getBasePath() + '?entryPoint=download&id=' + id)
                    .attr('target', '_BLANK')
                    .append(
                        $('<span>').addClass('fas fa-paperclip small')
                    )
                    .get(0).outerHTML;
            }

            return Dep.prototype.getValueForDisplay.call(this);
        },
    });
});
