define('custom:views/Opportunity/record/detail', ['views/record/detail'], (DetailRecordView) => {
    return class extends DetailRecordView {

        // custom template, omit if you don't need it
        // template = 'custom:your-entity-type/record/detail'

        // custom central view, omit if you don't need it
        // middleView = 'custom:views/your-entity-type/record/detail-middle'

        // custom side column view, omit if you don't need it
        // sideView = 'custom:views/your-entity-type/record/detail-side'

        // custom bottom view, omit if you don't need it
        // bottomView = 'custom:views/your-entity-type/record/detail-bottom'
        setup() {
            super.setup();
            console.log(this.getUser())
            localStorage.setItem('teamIds', this.getUser().attributes.teamsIds)
        }

        afterRender() {
            super.afterRender();
            var afterRenderModel = this;
            console.log(`${Date.now()} - v2 detail record`);
            var noticeWaiting = false;
            const model = this.model;
            var partNumberFlag = afterRenderModel.model.get('cSkuImporter')
            console.log('partNumberFlag', partNumberFlag);
            if (partNumberFlag != null) {
                console.log('partNumberFlag', partNumberFlag !== null && partNumberFlag !== undefined);
                const interval = setInterval(() => {
                    if (noticeWaiting) {
                        clearInterval(interval);
                        return;
                    }
                    if(!window.location.href.includes('view')) {
                        clearInterval(interval);
                        return;
                    }
                    model.fetch().then((resp) => {
                        console.log("Resp : ", resp.cPartnumberimport);
                        if (resp.cSkuImporter === null) {
                            noticeWaiting = true;
                            clearInterval(interval);
                            Swal.fire({
                                icon: "info",
                                title: "Importação concluída.",
                                text: "Os produtos foram importados com sucesso e adicionados à oportunidade.",
                                confirmButtonColor: '#007b78',
                                confirmButtonText: "Fechar",
                                allowOutsideClick: false,
                                allowEscapeKey: false,
                                allowEnterKey: false,
                                customClass: {
                                    confirmButton: 'custom-confirm-btn',
                                }
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.reload();
                                    localStorage.setItem('idOpp', resp.id)
                                }
                            });
                        }
                    });
                }, 5000);

            }
            setTimeout(async function () {
                var teamsIds = localStorage.getItem('teamIds');
                console.log(teamsIds);
                if (teamsIds.includes(',')) {
                    teamsIds.split(',').forEach(async function (teamdId) {
                        if (teamdId == "6217bac9e998125bd" || teamdId == "63e42c03dc017e5d4" || teamdId == "64d38dc428277e7da" || teamdId == "64ff86a3b0c0f373a" || teamdId == "64da40ef4903f3f5b" || teamdId == "64d38de0c4a999f5d" || teamdId == "64d38dd5a829a538e" || teamdId == "64dd1525e06ae6e75" || teamdId == "64da3fe6132152766" || teamdId == "64d38deeca51ba79c" || teamdId == "64d38dfabffcd9872" || teamdId == "64d38e091cb1cecd9" || teamdId == "6217bad3434b90c8e" || teamdId == "6217bae5d02a31c67" || teamdId == "6217baf6c5a88a957" || teamdId == "6217bc1cdf861cab6" || teamdId == "6217bc253e84db65c" || teamdId == "6217bc2db2c52349a" || teamdId == "6434183de37dc38f3" || teamdId == "640f417f9bc453ac3" || teamdId == "6434184940f72cec2" || teamdId == "6434182fafe7d4fe6" || teamdId == "643417ce3ea5ac5c4" || teamdId == "64ff7607143543219" || teamdId == "6216cf950b84911eb" || teamdId == "63c851e37c1d13fac" || teamdId == "6217bc3d5744311c2" || teamdId == "63c851ec4cf85a2e4") {
                            var initList = await new Promise(function (resolve) {
                                var defaultButton = document.querySelector('[data-name="account"] .input-group-btn [data-action="selectLink"]')
                                defaultButton.style.display = "none";
                                var recordList = ''
                                var url = `api/v1/Account?select=name,country&maxSize=10&offset=0&orderBy=createdAt&order=desc`
                                var xhr = new XMLHttpRequest();
                                xhr.open("GET", url);
                                xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                                xhr.addEventListener('readystatechange', function () {
                                    if (this.readyState == 4) {
                                        if (this.status == 200) {
                                            var data = JSON.parse(this.responseText)
                                            data.list.forEach(function (item) {
                                                var tpl = `
                                                <tr data-id="${item.id}" class="list-row contact-record">
                                                    <td class="cell" data-name="name" align="left">
                                                        <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                    </td>
                                                    <td class="cell" data-name="country" width="14%" align="left">
                                                        <span class="text-success">${item.country}</span>
                                                    </td>
                                                </tr>`
                                                recordList = recordList + tpl;
                                            })
                                            resolve(recordList);
                                        } else {
                                            reject(JSON.parse(this.responseText));
                                        }
                                    }
                                })
                                xhr.send();
                            })
                            var modal = `
                                <div id="select-modal-container-contact" class="modal-container" style="">
                                    <div id="dialog-contact" class="dialog dialog-record modal in" role="dialog" tabindex="-1"
                                        style="display: none; padding-right: 0px;">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <header class="modal-header">
                                                    <a class="close" data-dismiss="modal" href="javascript:">
                                                        <span aria-hidden="true" id="close-contact">×</span>
                                                    </a>
                                                    <h4 class="modal-title">
                                                        <span class="modal-title-text">
                                                            <span class="color-icon fas fa-square-full" style="color: rgb(237, 199, 85);">
                                                            </span>
                                                            Seleccionar: Cuentas
                                                        </span>
                                                    </h4>
                                                </header>
                                                <footer class="modal-footer">
                                                </footer>
                                                <div class="modal-body body" style="overflow: auto; height: 827px;">
                                                    <div class="search-container">
                                                        <div class="row search-row">
                                                            <div class="form-group col-md-8 col-sm-9">
                                                                <div class="input-group">
                                                                    <div class="input-group-btn left-dropdown">
                                                                        <ul class="dropdown-menu pull-left filter-menu">
                                                                        </ul>
                                                                    </div>
                                                                    <input type="text" class="form-control text-filter" data-name="textFilter" value=""
                                                                        tabindex="1" id="text-search-account" autocomplete="espo-text-search">
                                                                    <div class="input-group-btn">
                                                                        <button type="button" class="btn btn-default search btn-icon btn-icon-x-wide"
                                                                            id="search-account" data-action="search" title="Busca">
                                                                            <span class="fa fa-search"></span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group col-md-4 col-sm-3">
                                                            </div>
                                                        </div>
                                                        <div class="advanced-filters grid-auto-fill-sm">
                                                        </div>
                                                        <div class="advanced-filters-apply-container hidden">
                                                            <a href="javascript:" class="btn btn-default btn-sm" data-action="applyFilters">
                                                                <span class="fas fa-search"></span>
                                                                <span class="text-apply">Aplicar</span>
                                                                <span class="text-reset hidden">Resetar</span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div class="list-container">
                                                        <div class="list" data-scope="Account">
                                                            <table class="table">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="text-align: left;">
                                                                            <a href="javascript:" class="sort" data-name="name">Nombre</a>
                                                                        </th>
                                                                        <th width="14%" style="text-align: left;">
                                                                            <a href="javascript:" class="sort" data-name="country">País</a>
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="contact-tbody">
                                                                    ${initList}
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="button-container">
                                                        <button class="btn btn-default"><a style="color:white;" href="/#Account/create" target="_blank">Crear Cuenta</a></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>`
                            // var modal = '<span id="close-contact"></span><span id="search-account"></span>'
                            console.log('init')
                            var PartnerField = document.querySelector('[data-name="accountId"]');
                            console.log('PartnerField');
                            console.log(PartnerField);
                            var addPartnerButton = document.querySelector('[data-name="account"] [data-action="selectLink"]')
                            console.log('addPartnerButton');
                            console.log(addPartnerButton);
                            var clonedPartnerButton = addPartnerButton.cloneNode(true);
                            console.log('clonedPartnerButton');
                            console.log(clonedPartnerButton);
                            var span = document.querySelector('[data-name="account"] span.input-group-btn');
                            clonedPartnerButton.removeAttribute('data-action');
                            clonedPartnerButton.removeAttribute('title');
                            clonedPartnerButton.removeAttribute('type');
                            console.log('clonedPartnerButton');
                            console.log(clonedPartnerButton);
                            clonedPartnerButton.setAttribute('id', "show-modal-contact");
                            span.insertBefore(clonedPartnerButton, span.firstChild);
                            clonedPartnerButton.style.display = "inline-block";
                            document.querySelector('html').insertAdjacentHTML('beforeend', modal);
                            document.querySelector('#show-modal-contact').addEventListener('click', function () {
                                console.log('click');
                                document.querySelector('#dialog-contact').style.display = "block";
                            });
                            document.querySelector('#close-contact').addEventListener('click', function () {
                                console.log('click');
                                document.querySelector('#dialog-contact').style.display = "none";
                            });
                            console.log('modal')
                            console.log(modal)
                            console.log('end');

                            document.querySelector('#search-account').addEventListener('click', async function () {
                                console.log('click search');
                                var text = document.querySelector('#text-search-account').value
                                if (text.length == 0) {
                                    console.log('error')
                                } else {
                                    var html = await new Promise(function (resolve) {
                                        var recordList = ''
                                        var url = `api/v1/Account?select=name,country&maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=textFilter&where[0][value]=${text}`
                                        var xhr = new XMLHttpRequest();
                                        xhr.open("GET", url);
                                        xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                                        xhr.addEventListener('readystatechange', function () {
                                            if (this.readyState == 4) {
                                                if (this.status == 200) {
                                                    var data = JSON.parse(this.responseText)
                                                    data.list.forEach(function (item) {
                                                        var tpl = `
                                                        <tr data-id="${item.id}" class="list-row contact-record">
                                                            <td class="cell" data-name="name" align="left">
                                                                <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                            </td>
                                                            <td class="cell" data-name="country" width="14%" align="left">
                                                                <span class="text-success">${item.country}</span>
                                                            </td>
                                                        </tr>`
                                                        recordList = recordList + tpl;
                                                    })
                                                    resolve(recordList);
                                                } else {
                                                    reject(JSON.parse(this.responseText));
                                                }
                                            }
                                        })
                                        xhr.send();
                                    })
                                    await new Promise(function (resolve) {
                                        document.querySelector('#contact-tbody').innerHTML = html;
                                        resolve()
                                    });

                                    document.querySelectorAll('tr[class="list-row contact-record"] a[class="link contact-record"]').forEach(function (item) {
                                        item.addEventListener('click', function () {
                                            console.log(this);
                                            console.log(item.dataset.id);
                                            console.log('clicado');
                                            afterRenderModel.model.set('accountId', item.dataset.id);
                                            afterRenderModel.model.set('accountName', item.dataset.name);
                                            console.log(afterRenderModel.model.get('accountId'))
                                            console.log(afterRenderModel.model.get('accountName'))
                                            document.querySelector('[data-name="account"] input[data-name="accountName"]').value = item.dataset.name
                                            document.querySelector('#dialog-contact').style.display = "none";
                                        })
                                    })
                                }
                            })
                        }
                    })
                } else {
                    var teamdId = teamsIds
                    if (teamdId == "6217bac9e998125bd" || teamdId == "63e42c03dc017e5d4" || teamdId == "64d38dc428277e7da" || teamdId == "64ff86a3b0c0f373a" || teamdId == "64da40ef4903f3f5b" || teamdId == "64d38de0c4a999f5d" || teamdId == "64d38dd5a829a538e" || teamdId == "64dd1525e06ae6e75" || teamdId == "64da3fe6132152766" || teamdId == "64d38deeca51ba79c" || teamdId == "64d38dfabffcd9872" || teamdId == "64d38e091cb1cecd9" || teamdId == "6217bad3434b90c8e" || teamdId == "6217bae5d02a31c67" || teamdId == "6217baf6c5a88a957" || teamdId == "6217bc1cdf861cab6" || teamdId == "6217bc253e84db65c" || teamdId == "6217bc2db2c52349a" || teamdId == "6434183de37dc38f3" || teamdId == "640f417f9bc453ac3" || teamdId == "6434184940f72cec2" || teamdId == "6434182fafe7d4fe6" || teamdId == "643417ce3ea5ac5c4" || teamdId == "64ff7607143543219" || teamdId == "6216cf950b84911eb" || teamdId == "63c851e37c1d13fac" || teamdId == "6217bc3d5744311c2" || teamdId == "63c851ec4cf85a2e4") {
                        var initList = await new Promise(function (resolve) {
                            var defaultButton = document.querySelector('[data-name="account"] .input-group-btn [data-action="selectLink"]')
                            defaultButton.style.display = "none";
                            var recordList = ''
                            var url = `api/v1/Account?select=name,country&maxSize=10&offset=0&orderBy=createdAt&order=desc`
                            var xhr = new XMLHttpRequest();
                            xhr.open("GET", url);
                            xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                            xhr.addEventListener('readystatechange', function () {
                                if (this.readyState == 4) {
                                    if (this.status == 200) {
                                        var data = JSON.parse(this.responseText)
                                        data.list.forEach(function (item) {
                                            var tpl = `
                                                <tr data-id="${item.id}" class="list-row contact-record">
                                                    <td class="cell" data-name="name" align="left">
                                                        <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                    </td>
                                                    <td class="cell" data-name="country" width="14%" align="left">
                                                        <span class="text-success">${item.country}</span>
                                                    </td>
                                                </tr>`
                                            recordList = recordList + tpl;
                                        })
                                        resolve(recordList);
                                    } else {
                                        reject(JSON.parse(this.responseText));
                                    }
                                }
                            })
                            xhr.send();
                        })
                        var modal = `
                                <div id="select-modal-container-contact" class="modal-container" style="">
                                    <div id="dialog-contact" class="dialog dialog-record modal in" role="dialog" tabindex="-1"
                                        style="display: none; padding-right: 0px;">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <header class="modal-header">
                                                    <a class="close" data-dismiss="modal" href="javascript:">
                                                        <span aria-hidden="true" id="close-contact">×</span>
                                                    </a>
                                                    <h4 class="modal-title">
                                                        <span class="modal-title-text">
                                                            <span class="color-icon fas fa-square-full" style="color: rgb(237, 199, 85);">
                                                            </span>
                                                            Seleccionar: Cuentas
                                                        </span>
                                                    </h4>
                                                </header>
                                                <footer class="modal-footer">
                                                </footer>
                                                <div class="modal-body body" style="overflow: auto; height: 827px;">
                                                    <div class="search-container">
                                                        <div class="row search-row">
                                                            <div class="form-group col-md-8 col-sm-9">
                                                                <div class="input-group">
                                                                    <div class="input-group-btn left-dropdown">
                                                                        <ul class="dropdown-menu pull-left filter-menu">
                                                                        </ul>
                                                                    </div>
                                                                    <input type="text" class="form-control text-filter" data-name="textFilter" value=""
                                                                        tabindex="1" id="text-search-account" autocomplete="espo-text-search">
                                                                    <div class="input-group-btn">
                                                                        <button type="button" class="btn btn-default search btn-icon btn-icon-x-wide"
                                                                            id="search-account" data-action="search" title="Busca">
                                                                            <span class="fa fa-search"></span>
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="form-group col-md-4 col-sm-3">
                                                            </div>
                                                        </div>
                                                        <div class="advanced-filters grid-auto-fill-sm">
                                                        </div>
                                                        <div class="advanced-filters-apply-container hidden">
                                                            <a href="javascript:" class="btn btn-default btn-sm" data-action="applyFilters">
                                                                <span class="fas fa-search"></span>
                                                                <span class="text-apply">Aplicar</span>
                                                                <span class="text-reset hidden">Resetar</span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                    <div class="list-container">
                                                        <div class="list" data-scope="Account">
                                                            <table class="table">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="text-align: left;">
                                                                            <a href="javascript:" class="sort" data-name="name">Nombre</a>
                                                                        </th>
                                                                        <th width="14%" style="text-align: left;">
                                                                            <a href="javascript:" class="sort" data-name="country">País</a>
                                                                        </th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="contact-tbody">
                                                                    ${initList}
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <div class="button-container">
                                                        <button class="btn btn-default"><a style="color:white;" href="/#Account/create" target="_blank">Crear Cuenta</a></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>`
                        // var modal = '<span id="close-contact"></span><span id="search-account"></span>'
                        console.log('init')
                        var PartnerField = document.querySelector('[data-name="accountId"]');
                        console.log('PartnerField');
                        console.log(PartnerField);
                        var addPartnerButton = document.querySelector('[data-name="account"] [data-action="selectLink"]')
                        console.log('addPartnerButton');
                        console.log(addPartnerButton);
                        var clonedPartnerButton = addPartnerButton.cloneNode(true);
                        console.log('clonedPartnerButton');
                        console.log(clonedPartnerButton);
                        var span = document.querySelector('[data-name="account"] span.input-group-btn');
                        clonedPartnerButton.removeAttribute('data-action');
                        clonedPartnerButton.removeAttribute('title');
                        clonedPartnerButton.removeAttribute('type');
                        console.log('clonedPartnerButton');
                        console.log(clonedPartnerButton);
                        clonedPartnerButton.setAttribute('id', "show-modal-contact");
                        span.insertBefore(clonedPartnerButton, span.firstChild);
                        clonedPartnerButton.style.display = "inline-block";
                        document.querySelector('html').insertAdjacentHTML('beforeend', modal);
                        document.querySelector('#show-modal-contact').addEventListener('click', function () {
                            console.log('click');
                            document.querySelector('#dialog-contact').style.display = "block";
                        });
                        document.querySelector('#close-contact').addEventListener('click', function () {
                            console.log('click');
                            document.querySelector('#dialog-contact').style.display = "none";
                        });
                        console.log('modal')
                        console.log(modal)
                        console.log('end');

                        document.querySelector('#search-account').addEventListener('click', async function () {
                            console.log('click search');
                            var text = document.querySelector('#text-search-account').value
                            if (text.length == 0) {
                                console.log('error')
                            } else {
                                var html = await new Promise(function (resolve) {
                                    var recordList = ''
                                    var url = `api/v1/Account?select=name,country&maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=textFilter&where[0][value]=${text}`
                                    var xhr = new XMLHttpRequest();
                                    xhr.open("GET", url);
                                    xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                                    xhr.addEventListener('readystatechange', function () {
                                        if (this.readyState == 4) {
                                            if (this.status == 200) {
                                                var data = JSON.parse(this.responseText)
                                                data.list.forEach(function (item) {
                                                    var tpl = `
                                                        <tr data-id="${item.id}" class="list-row contact-record">
                                                            <td class="cell" data-name="name" align="left">
                                                                <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                            </td>
                                                            <td class="cell" data-name="country" width="14%" align="left">
                                                                <span class="text-success">${item.country}</span>
                                                            </td>
                                                        </tr>`
                                                    recordList = recordList + tpl;
                                                })
                                                resolve(recordList);
                                            } else {
                                                reject(JSON.parse(this.responseText));
                                            }
                                        }
                                    })
                                    xhr.send();
                                })
                                await new Promise(function (resolve) {
                                    document.querySelector('#contact-tbody').innerHTML = html;
                                    resolve()
                                });

                                document.querySelectorAll('tr[class="list-row contact-record"] a[class="link contact-record"]').forEach(function (item) {
                                    item.addEventListener('click', function () {
                                        console.log(this);
                                        console.log(item.dataset.id);
                                        console.log('clicado');
                                        afterRenderModel.model.set('accountId', item.dataset.id);
                                        afterRenderModel.model.set('accountName', item.dataset.name);
                                        console.log(afterRenderModel.model.get('accountId'))
                                        console.log(afterRenderModel.model.get('accountName'))
                                        document.querySelector('[data-name="account"] input[data-name="accountName"]').value = item.dataset.name
                                        document.querySelector('#dialog-contact').style.display = "none";
                                    })
                                })
                            }
                        })
                    }
                }
            }, 1000)
        }
    }
});
