var Swal;
define('custom:views/Opportunity/edit', ['views/edit'], (EditView) => {

    return class extends EditView {

        async setup() {
            super.setup();


            await Espo.loader.requirePromise('swal').then((sw) => { Swal = sw });

            //await this.counterRefresh().then(() => {
            //    console.log('inside counter')
            //})

            var setup = this

            localStorage.setItem('teamIds', this.getUser().attributes.teamsIds)
            this.listenTo(this.model, 'change:productBrandName', async () => {
                var brand = setup.model.get('productBrandName');
                console.log('Selected product brand:', brand)
                var templicenseTypeSelects = document.querySelectorAll('[data-name="item-licenseType"] .selectize-dropdown-content div[data-value]');
                var tempsolutionTypeSelects = document.querySelectorAll('[data-name="item-solutionType"] .selectize-dropdown-content div[data-value]');
                var temptimeContractSelects = document.querySelectorAll('[data-name="item-timeContract"] .selectize-dropdown-content div[data-value]');
                temptimeContractSelects.forEach(async function (k, v) {
                    await setup.optionSelection(brand, templicenseTypeSelects, tempsolutionTypeSelects, temptimeContractSelects);
                })
            }, this)

            var noItemModalFlag = false
            this.listenTo(this.model, 'change:accountName', async () => {
                if (!noItemModalFlag) {
                    this.noItemModal()
                    noItemModalFlag = true
                }
            }, this)

            this.listenTo(this.model, 'change:itemList', async () => {
                var quoteStatus = setup.model.get('quoteOppName');
                var quoteStatusCondition = quoteStatus == null || quoteStatus == undefined || quoteStatus == '';
                if (!quoteStatusCondition) {
                    if (statusItemList) {
                        this.showConfirmModelQuote();
                        statusItemList = false;
                    }
                }



            }, this)
            this.listenTo(this.model, 'change:accountName', async () => {
                console.log('changeCustomer')
                var endCustomer = setup.model.get('accountId');
                if (endCustomer == null) {
                    return;
                }

                Espo.Ajax.getRequest(`Account/${endCustomer}`)
                    .then(customerData => {
                        localStorage.setItem('priceBookCountrySearch', customerData.country);
                        console.log('country set as', localStorage.getItem('priceBookCountrySearch'));
                    })
            })
            this.listenTo(this.model, 'change:presentQuoteEmail', () => {
                console.log('This button named Enviar Cotação was clicked')
                var quoteEmailButton = document.querySelector('.main-element[data-name="presentQuoteEmail"]')
                var quoteEmailStatus = setup.model.get('presentQuoteEmail');
                if (quoteEmailStatus) {
                    Swal.fire({
                        title: 'Atenção!',
                        html: '<div style="text-align: center;">Você habilitou a opção "Enviar Cotação".</div> <br><br>' +
                            '<div style="text-align: left;">' +
                            'A partir de agora, ao <strong>salvar essa oportunidade</strong>, você estará concordando com as seguintes ações:<br><br>' +
                            '- Publicação da cotação para a revenda.<br>' +
                            '- Envio de um email para a revenda, informando sobre a disponibilidade desta cotação.<br><br>' +
                            'Por favor, verifique cuidadosamente todas as informações antes de prosseguir.' +
                            '</div>',
                        icon: "info",
                        iconColor: '#007b78',
                        width: '36em',
                        showCancelButton: true,
                        showConfirmButton: true,
                        confirmButtonColor: '#007b78',
                        cancelButtonColor: '#ad4846',
                        confirmButtonText: 'Confirmar',
                        cancelButtonText: 'Recusar',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        allowEnterKey: false,
                    }).then((res) => {
                        if (res.dismiss === swal.DismissReason.cancel) {
                            setup.model.set('presentQuoteEmail', false)
                        }
                    })
                }
            })
        }

        priceBookCountryBeforeCustomer() {
            var priceBookCountry = localStorage.getItem('priceBookCountrySearch')
            if (!priceBookCountry) {
                localStorage.setItem('priceBookCountrySearch', this.getUser().attributes.country)
            }
        }

        showDuplicateModal() {
            var setup = this
            var quoteStatus = setup.model.get('quoteOppName');
            var quoteStatusCondition = quoteStatus == null || quoteStatus == undefined || quoteStatus == '';
            if (window.location.href.includes('create')) {
                console.log('createInUrl')
                if (!quoteStatusCondition) {
                    Swal.fire({
                        title: 'Atenção!',
                        html:
                            '<div style="text-align: left;">' +
                            'Ao duplicar uma oportunidade que já possui uma cotação, a cotação será transferida para a nova oportunidade e removida da atual. <br> Se não quiser que a cotação seja transferida, remova-a da nova oportunidade após clicar em duplicar, para que a nova oportunidade seja gerada sem a cotação.' +
                            '</div>',
                        icon: "info",
                        iconColor: '#007b78',
                        width: '47rem',
                        showConfirmButton: true,
                        confirmButtonColor: '#007b78',
                        confirmButtonText: 'Ok',
                        allowOutsideClick: false,
                        allowEscapeKey: false,
                        allowEnterKey: false,
                    });
                }
            }
        }
        async counterRefresh() {
            return new Promise(function (r) {
                var key = "OpportunityVisit";
                var currentPosition = localStorage.getItem(key);
                console.log(this)

                if (currentPosition == null) {
                    localStorage.setItem(key, "0")
                }
                if (Number(currentPosition >= 1)) {
                    localStorage.setItem(key, "0");

                    fetch("https://cdp.cloudanalytics.me/api/v1/Admin/clearCache", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json",
                            "Authorization": "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE="
                        }
                    })
                        .then(response => {
                            console.log(response);
                            location.reload(true);
                        })
                        .catch(xhr => {
                            if (xhr.status === 403) {
                                xhr.errorIsHandled = true;
                            }
                        });
                } else {
                    localStorage.setItem(key, "1")
                }

                r()
            })
        }
        showConfirmModelQuote() {
            var isConfirmed = false
            document.querySelector('[data-action="save"]')?.addEventListener('mouseover', function () {
                if (!isConfirmed) {
                    Swal.fire({
                        icon: "info",
                        iconColor: '#007b78',
                        title: 'Atenção!',
                        width: '500px',
                        html:
                            '<div style="text-align: left;">' +
                            'Ao salvar esta oportunidade, sua cotação será atualizada para uma nova versão.<br>' +
                            'Se a sua cotação estiver com o status <strong>"Apresentada"</strong>, as alterações feitas serão visíveis para o cliente na página de propostas. <br> <br>' +
                            '<strong>Certifique-se de que todas as informações estão corretas antes de prosseguir.</strong> <br>' +
                            'Clique em <strong>"Estou de acordo"</strong> para confirmar ou em <strong>"Não estou de acordo"</strong> para cancelar e revisar as informações.</b>' +
                            '</div>',
                        showDenyButton: true,
                        confirmButtonColor: '#007b78',
                        denyButtonColor: '#ad4846',
                        confirmButtonText: "Estou de Acordo",
                        denyButtonText: `Não estou de Acordo`
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.querySelector('[data-action="save"]')?.removeAttribute('disabled');
                            isConfirmed = true
                        } else if (result.isDenied) {
                            document.querySelector('[data-action="save"]')?.setAttribute('disabled', true)
                        }
                    });
                }
            })
        }

        noItemModal() {
            var isConfirmedPartNumber = false
            var isConfirmed = false
            document.querySelector('[data-action="save"]').addEventListener('mouseover', function () {
                var priceBookCountry = document.querySelectorAll('[data-name="country"] span')[2].textContent
                if (priceBookCountry == 'Brasil') {
                    var items = document.querySelectorAll('.item-container')
                    var itenSku = document.querySelector('[data-name="cSkuImporter"] textArea')
                    if (items.length == 0 && itenSku.value == '') {
                        if (!isConfirmed) {
                            Swal.fire({
                                icon: "info",
                                iconColor: '#007b78',
                                title: 'Atenção!',
                                width: '500px',
                                html:
                                    '<div style="text-align: center;">' +
                                    'Você tem certeza que deseja criar uma oportunidade sem produtos? <br>' +
                                    'Isso impacta na visibilidade dos gestores / diretoria.<br>' +
                                    'Deseja continuar?' +
                                    '</div>',
                                showDenyButton: true,
                                allowOutsideClick: false,
                                allowEscapeKey: false,
                                confirmButtonColor: '#007b78',
                                denyButtonColor: '#ad4846',
                                confirmButtonText: "Sim",
                                denyButtonText: `Não`,
                                customClass: {
                                    confirmButton: 'custom-confirm-btn',
                                    denyButton: 'custom-deny-btn'
                                }
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.querySelector('[data-action="save"]')?.removeAttribute('disabled');
                                    isConfirmed = true
                                }
                            });
                        }
                    } else if (!isConfirmedPartNumber && items.length == 0) {
                        Swal.fire({
                            icon: "info",
                            iconColor: '#007b78',
                            title: 'Atenção!',
                            width: '500px',
                            html: '<div style="text-align: center;">' +
                                'Você está criando uma oportunidade com o importador de Part Number. <br>' +
                                'Os produtos serão adicionados à oportunidade em até 1 minuto.<br>' +
                                'Lembre-se de que, se necessário, você precisará voltar e ajustar a quantidade de itens manualmente.' +
                                '</div>',
                            showDenyButton: false,
                            allowOutsideClick: false,
                            allowEscapeKey: false,
                            confirmButtonColor: '#007b78',
                            denyButtonColor: '#ad4846',
                            confirmButtonText: "Confirmar",
                            denyButtonText: `Não`,
                            customClass: {
                                confirmButton: 'custom-confirm-btn',
                                denyButton: 'custom-deny-btn'
                            }
                        }).then((result) => {
                            if (result.isConfirmed) {
                                isConfirmedPartNumber = true
                            }
                        });
                    }
                }
            })

        }
        optionSelection(brand, licenseTypeSelect, solutionTypeSelect, timeContractSelect) {
            console.log('call optionSelection()')
            var microsoftLicenseType = [
                "Azure",
                "Dynamics 365",
                "M365",
                "Services",
                "Software Perpetual",
                "Software Subscription",
                "Open Value",
            ]
            var microsoftFaturacion = [
                "Monthly",
                "Annual",
                "One Time",
            ]
            var microsoftPeriod = [
                "1 Month",
                "1 Year",
                "3 Years",
                "Perpetual",
                "Pay as you go",
            ]
            var microsoftContractType = [
                "Open",
                "SPLA",
                "Professional Services",
                "CSP NCE",
            ]
            var googleLicenseType = [
                "New Business",
                "Upgrade",
                "Renewal",
                "Transfer",
            ]
            var googleFaturacion = [
                "Monthly",
                "Annual",
                "Trial",
                "Flexible",
            ]
            var googlePeriod = [
                "1 Month",
                "1 Year",
                "2 Years",
                "3 Years",
            ]
            var awsLicenseType = [
                "AWS",
            ]
            var awsPeriod = [
                "1 Month",
                "1 Year",
                "2 Years",
                "3 Years",
            ]
            var awsFaturacion = [
                "Monthly",
                "Annual",
                "Up front",
                "One Time",
            ]
            console.log("brand, licenseTypeSelect")
            console.log(brand, licenseTypeSelect)
            for (var i = 0; i < licenseTypeSelect.length; i++) {
                if (licenseTypeSelect[i].dataset.value != "") {
                    licenseTypeSelect[i].style.display = 'none';
                }
            }
            for (var i = 0; i < solutionTypeSelect.length; i++) {
                if (solutionTypeSelect[i].dataset.value != "") {
                    solutionTypeSelect[i].style.display = 'none';
                }
            }
            for (var i = 0; i < timeContractSelect.length; i++) {
                if (timeContractSelect[i].dataset.value != "") {
                    timeContractSelect[i].style.display = 'none';
                }
            }
            switch (brand) {
                case "Microsoft":
                    for (var i = 0; i < licenseTypeSelect.length; i++) {
                        for (var x = 0; x < microsoftLicenseType.length; x++) {
                            if (licenseTypeSelect[i].dataset.value == microsoftLicenseType[x]) {
                                licenseTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < solutionTypeSelect.length; i++) {
                        for (var y = 0; y < microsoftFaturacion.length; y++) {
                            if (solutionTypeSelect[i].dataset.value == microsoftFaturacion[y]) {
                                solutionTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < timeContractSelect.length; i++) {
                        for (var y = 0; y < microsoftPeriod.length; y++) {
                            if (timeContractSelect[i].dataset.value == microsoftPeriod[y]) {
                                timeContractSelect[i].style.display = 'block'
                            }
                        }
                    }
                    break;
                case "Google":
                    for (var i = 0; i < licenseTypeSelect.length; i++) {
                        for (var x = 0; x < googleLicenseType.length; x++) {
                            if (licenseTypeSelect[i].dataset.value == googleLicenseType[x]) {
                                licenseTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < solutionTypeSelect.length; i++) {
                        for (var y = 0; y < googleFaturacion.length; y++) {
                            if (solutionTypeSelect[i].dataset.value == googleFaturacion[y]) {
                                solutionTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < timeContractSelect.length; i++) {
                        for (var y = 0; y < googlePeriod.length; y++) {
                            if (timeContractSelect[i].dataset.value == googlePeriod[y]) {
                                timeContractSelect[i].style.display = 'block'
                            }
                        }
                    }
                    break;
                case "AWS":
                    for (var i = 0; i < licenseTypeSelect.length; i++) {
                        for (var x = 0; x < awsLicenseType.length; x++) {
                            if (licenseTypeSelect[i].dataset.value == awsLicenseType[x]) {
                                licenseTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < solutionTypeSelect.length; i++) {
                        for (var y = 0; y < awsFaturacion.length; y++) {
                            if (solutionTypeSelect[i].dataset.value == awsFaturacion[y]) {
                                solutionTypeSelect[i].style.display = 'block'
                            }
                        }
                    }
                    for (var i = 0; i < timeContractSelect.length; i++) {
                        for (var y = 0; y < awsPeriod.length; y++) {
                            if (timeContractSelect[i].dataset.value == awsPeriod[y]) {
                                timeContractSelect[i].style.display = 'block'
                            }
                        }
                    }
                    break;
                default:
                    document.querySelector("div.item-list-container > table > thead > tr > th:nth-child(2)").style.display = 'none';
                    document.querySelectorAll('[data-name="item-contractType"]').forEach((item) => {
                        item.parentElement.style.display = 'none'
                    })
                    break;
            }
        }

        renderModalAccount(afterRenderModel) {
            return new Promise(function (r) {
                console.log('edit.js outside record')
                var inserted = false;
                var includedTeamsIds = [
                    "6217bac9e998125bd", "63e42c03dc017e5d4",
                    "64d38dc428277e7da", "64ff86a3b0c0f373a",
                    "64da40ef4903f3f5b", "64d38de0c4a999f5d",
                    "64d38dd5a829a538e", "64dd1525e06ae6e75",
                    "64da3fe6132152766", "64d38deeca51ba79c",
                    "64d38dfabffcd9872", "64d38e091cb1cecd9",
                    "6217bad3434b90c8e", "6217bae5d02a31c67",
                    "6217baf6c5a88a957", "6217bc1cdf861cab6",
                    "6217bc253e84db65c", "6217bc2db2c52349a",
                    "6434183de37dc38f3", "640f417f9bc453ac3",
                    "6434184940f72cec2", "6434182fafe7d4fe6",
                    "643417ce3ea5ac5c4", "64ff7607143543219",
                    "6216cf950b84911eb", "63c851e37c1d13fac",
                    "6217bc3d5744311c2", "63c851ec4cf85a2e4",
                    "675081f4218833ca1", "675081f428be23392",
                    "675081f4338757568", "675081f43c8aa869e",
                    "675081f4450ee7686", "675081f46688a1598",
                    "675081f44eae1fff2", "675081f4577147328",
                    "675081f47cf78ec80", "675081f4855a236e3",
                    "675081f48ef82072c", "675081f4981df3bcc",
                    "675081f4a23d5ec2f", "675081f4ac45f6f81",
                    "675081f4b42e63030", "675081f4bbf6059b2",
                    "675081f4c4691dd40", "675081f4cd3fc69a9",
                    "675081f4d6884299c", "675081f4de5f9a2da",
                    "675081f4e7651edd7", "675081f4ef06fffe7",
                    "675081f507ae7a5fa", "675081f51f2ef77b2",
                    "675081f513384753f", "675081f52925a318d",
                    "675081f5383981e6e", "675081f5405a962eb",
                    "675081f547f6e5985", "675081f5500214dd2",
                    "675081f55a7f4595b", "675081f567552660e",
                    "675081f56fb4edc6f", "675081f58155dbe88",
                    "675081f5797fa8470", "677febb48f65d30df"
                ]
                setTimeout(async function () {
                    var teamsIds = localStorage.getItem('teamIds');
                    var arrayTeams = teamsIds.split(',');
                    var pass = false;
                    arrayTeams.forEach(function (teamId) {
                        if (pass == false) {
                            if (includedTeamsIds.includes(teamId)) {
                                pass = true;
                                console.log('team is included')
                            } else {
                                pass = false;
                                console.log('team is not included')
                            }
                        }
                    })
                    if (pass == true) {
                        var initList = await new Promise(function (resolve) {
                            var defaultButton = document.querySelector('[data-name="account"] .input-group-btn [data-action="selectLink"]')
                            defaultButton.style.display = "none";
                            var recordList = ''
                            var url = `api/v1/Account?select=name,country&maxSize=10&offset=0&orderBy=createdAt&order=desc`
                            var xhr = new XMLHttpRequest();
                            xhr.open("GET", url);
                            xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                            xhr.addEventListener('readystatechange', function () {
                                if (this.readyState == 4) {
                                    if (this.status == 200) {
                                        var data = JSON.parse(this.responseText)
                                        data.list.forEach(function (item) {
                                            var tpl = `
                                            <tr data-id="${item.id}" class="list-row contact-record">
                                                <td class="cell" data-name="name" align="left">
                                                    <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                </td>
                                                <td class="cell" data-name="country" width="14%" align="left">
                                                    <span class="text-success">${item.country}</span>
                                                </td>
                                            </tr>`
                                            recordList = recordList + tpl;
                                        })
                                        resolve(recordList);
                                    } else {
                                        reject(JSON.parse(this.responseText));
                                    }
                                }
                            })
                            xhr.send();
                        })
                        var modal = `
                            <div id="select-modal-container-contact" class="modal-container" style="">
                                <div id="dialog-contact" class="dialog dialog-record modal in" role="dialog" tabindex="-1"
                                    style="display: none; padding-right: 0px;">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <header class="modal-header">
                                                <a class="close" data-dismiss="modal" href="javascript:">
                                                    <span aria-hidden="true" id="close-contact">×</span>
                                                </a>
                                                <h4 class="modal-title">
                                                    <span class="modal-title-text">
                                                        <span class="color-icon fas fa-square-full" style="color: rgb(237, 199, 85);">
                                                        </span>
                                                        Seleccionar: Cuentas
                                                    </span>
                                                </h4>
                                            </header>
                                            <footer class="modal-footer">
                                            </footer>
                                            <div class="modal-body body" style="overflow: auto; height: 827px;">
                                                <div class="search-container">
                                                    <div class="row search-row">
                                                        <div class="form-group col-md-8 col-sm-9">
                                                            <div class="input-group">
                                                                <div class="input-group-btn left-dropdown">
                                                                    <ul class="dropdown-menu pull-left filter-menu">
                                                                    </ul>
                                                                </div>
                                                                <input type="text" class="form-control text-filter" data-name="textFilter" value=""
                                                                    tabindex="1" id="text-search-account" autocomplete="espo-text-search">
                                                                <div class="input-group-btn">
                                                                    <button type="button" class="btn btn-default search btn-icon btn-icon-x-wide"
                                                                        id="search-account" data-action="search" title="Busca">
                                                                        <span class="fa fa-search"></span>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="form-group col-md-4 col-sm-3">
                                                        </div>
                                                    </div>
                                                    <div class="advanced-filters grid-auto-fill-sm">
                                                    </div>
                                                    <div class="advanced-filters-apply-container hidden">
                                                        <a href="javascript:" class="btn btn-default btn-sm" data-action="applyFilters">
                                                            <span class="fas fa-search"></span>
                                                            <span class="text-apply">Aplicar</span>
                                                            <span class="text-reset hidden">Resetar</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="list-container">
                                                    <div class="list" data-scope="Account">
                                                        <table class="table">
                                                            <thead>
                                                                <tr>
                                                                    <th style="text-align: left;">
                                                                        <a href="javascript:" class="sort" data-name="name">Nombre</a>
                                                                    </th>
                                                                    <th width="14%" style="text-align: left;">
                                                                        <a href="javascript:" class="sort" data-name="country">País</a>
                                                                    </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="contact-tbody">
                                                                ${initList}
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <div class="button-container">
                                                    <button class="btn btn-default"><a style="color:white;" href="/#Account/create" target="_blank">Crear Cuenta</a></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>`
                        var PartnerField = document.querySelector('[data-name="accountId"]');
                        var addPartnerButton = document.querySelector('[data-name="account"] [data-action="selectLink"]')
                        var clonedPartnerButton = addPartnerButton.cloneNode(true);
                        var span = document.querySelector('[data-name="account"] span.input-group-btn');
                        clonedPartnerButton.removeAttribute('data-action');
                        clonedPartnerButton.removeAttribute('title');
                        clonedPartnerButton.removeAttribute('type');
                        console.log('clonedPartnerButton');
                        console.log(inserted)
                        if (inserted == false) {
                            clonedPartnerButton.setAttribute('id', "show-modal-contact");
                            span.insertBefore(clonedPartnerButton, span.firstChild);
                            inserted = true
                        }
                        clonedPartnerButton.style.display = "inline-block";
                        document.querySelector('html').insertAdjacentHTML('beforeend', modal);
                        document.querySelectorAll('tr[class="list-row contact-record"] a[class="link contact-record"]').forEach(function (item) {
                            item.addEventListener('click', function () {
                                afterRenderModel.model.set('accountId', item.dataset.id);
                                afterRenderModel.model.set('accountName', item.dataset.name);
                                document.querySelector('[data-name="account"] input[data-name="accountName"]').value = item.dataset.name
                                document.querySelector('#dialog-contact').style.display = "none";
                            })
                        })
                        document.querySelector('#show-modal-contact').addEventListener('click', function () {
                            document.querySelector('#dialog-contact').style.display = "block";
                        });
                        document.querySelector('#close-contact').addEventListener('click', function () {
                            document.querySelector('#dialog-contact').style.display = "none";
                        });
                        document.querySelector('#search-account').addEventListener('click', async function () {
                            var text = document.querySelector('#text-search-account').value
                            if (text.length == 0) {
                            } else {
                                var html = await new Promise(function (resolve) {
                                    var recordList = ''
                                    var url = `api/v1/Account?select=name,country&maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=textFilter&where[0][value]=${text}`
                                    var xhr = new XMLHttpRequest();
                                    xhr.open("GET", url);
                                    xhr.setRequestHeader("Authorization", "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
                                    xhr.addEventListener('readystatechange', function () {
                                        if (this.readyState == 4) {
                                            if (this.status == 200) {
                                                var data = JSON.parse(this.responseText)
                                                data.list.forEach(function (item) {
                                                    var tpl = `
                                                    <tr data-id="${item.id}" class="list-row contact-record">
                                                        <td class="cell" data-name="name" align="left">
                                                            <a class="link contact-record" data-id="${item.id}" title="${item.name}" data-name="${item.name}">${item.name}</a>
                                                        </td>
                                                        <td class="cell" data-name="country" width="14%" align="left">
                                                            <span class="text-success">${item.country}</span>
                                                        </td>
                                                    </tr>`
                                                    recordList = recordList + tpl;
                                                })
                                                resolve(recordList);
                                            } else {
                                                reject(JSON.parse(this.responseText));
                                            }
                                        }
                                    })
                                    xhr.send();
                                })
                                await new Promise(function (resolve) {
                                    document.querySelector('#contact-tbody').innerHTML = html;
                                    document.querySelectorAll('tr[class="list-row contact-record"] a[class="link contact-record"]').forEach(function (item) {
                                        item.addEventListener('click', function () {
                                            afterRenderModel.model.set('accountId', item.dataset.id);
                                            afterRenderModel.model.set('accountName', item.dataset.name);
                                            document.querySelector('[data-name="account"] input[data-name="accountName"]').value = item.dataset.name
                                            document.querySelector('#dialog-contact').style.display = "none";
                                        })
                                    })
                                    resolve()
                                });
                            }
                        })
                    }
                }, 3000)
            })
        }

        afterRender() {
            super.afterRender();
            console.log('edit.js outside record')
            console.log('testing 10/02')
            var inserted = false;
            var afterRenderModel = this;
            var setup = this;
            console.log('VERSION: v0.0.15');

            setTimeout(async function () {
                setInterval(async () => {
                    var brand = setup.model.get('productBrandName');
                    if (brand != "" && brand != null) {
                        var templicenseTypeSelects = document.querySelectorAll('[data-name="item-licenseType"] .selectize-dropdown-content div[data-value]');
                        var tempsolutionTypeSelects = document.querySelectorAll('[data-name="item-solutionType"] .selectize-dropdown-content div[data-value]');
                        var temptimeContractSelects = document.querySelectorAll('[data-name="item-timeContract"] .selectize-dropdown-content div[data-value]');
                        templicenseTypeSelects.forEach(function (k, v) {
                            setup.optionSelection(brand, templicenseTypeSelects, tempsolutionTypeSelects, temptimeContractSelects);
                        })
                    }

                }, 500)
            }, 2000)

            setTimeout(async function () {
                console.log('dispatching event')
                const selectElement = document.querySelectorAll('select[data-name="contractType"]');
                selectElement.forEach(s => {
                    if (s) {
                        const event = new Event('change', { bubbles: true });
                        s.dispatchEvent(event);
                    }
                })
            }, 500)

            localStorage.setItem("oppBrand", afterRenderModel.model.attributes.productBrandName)
            afterRenderModel.renderModalAccount(afterRenderModel);
            afterRenderModel.showDuplicateModal()
            afterRenderModel.priceBookCountryBeforeCustomer()

        }
    }
});
