/***********************************************************************************
 * The contents of this file are subject to the Extension License Agreement
 * ("Agreement") which can be viewed at
 * https://www.espocrm.com/extension-license-agreement/.
 * By copying, installing downloading, or using this file, You have unconditionally
 * agreed to the terms and conditions of the Agreement, and You may not use this
 * file except in compliance with the Agreement. Under the terms of the Agreement,
 * You shall not license, sublicense, sell, resell, rent, lease, lend, distribute,
 * redistribute, market, publish, commercialize, or otherwise transfer rights or
 * usage to the software or any modified version or derivative work of the software
 * created by or for you.
 *
 * Copyright (C) 2015-2025 Letrium Ltd.
 *
 * License ID: a67be8f75bc1974a987315ddc1024a78
 ************************************************************************************/
// categoria de google workspace em prod: 6435c53a3ba5bf3e0
// campo disconto adicional ja criado em prod: cAdditionalDiscount
// campo fabricante na oportunidade de prod: productBrand

window.tempStorage = window.tempStorage || {};

define('sales:opportunity-calculation-handler', ['sales:quote-calculation-handler'], function (Dep) {

    return Dep.extend({
        setup: function () {
            this.userDashboardSetList = [];

            console.log(this.getUser());
        },
        boundCurrencyFieldList: [
            'amount'
        ],
        boundCurrencyItemFieldList: ['unitPrice', 'amount'],
        modelIds: [],
        listenedAttributeList: [],

        listenedItemFieldList: ['name', 'quantity', 'listPrice', 'unitPrice', 'licenseType', 'solutionType', 'timeContract', 'productId', 'productName', 'product', 'contractType'],

        eventHelper: function (model, valid) {
            var savedFields = [];
            if (window.tempStorage.savedFields !== undefined) {
                savedFields = window.tempStorage.savedFields;
            } else {
                window.tempStorage.savedFields = savedFields;
            }

            if (valid) {
                setTimeout(() => {
                    // debugger
                    if (!savedFields.includes(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`)) {
                        savedFields.push(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`);
                    }
                    savedFields.forEach(x => {
                        // console.log(document.querySelector(x))
                        var indx = document.querySelector(x).parentElement.cellIndex
                        document.querySelector(x).parentElement.style.display = 'block'
                        document.querySelector(x).style.display = 'block'
                        document.querySelector(x).parentElement.closest('table').querySelector(`thead tr th:nth-child(${indx + 1})`).style.display = 'block'
                    })
                    // store fields
                    window.tempStorage.savedFields = savedFields
                    this.eventHelper(model, true)

                }, 200);
            } else {
                setTimeout(() => {
                    // debugger
                    const index = document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.cellIndex
                    document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.closest('table').querySelector(`thead tr th:nth-child(${index + 1})`).style.display = 'none'
                    document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.style.display = 'none'

                    document.querySelectorAll('.item-container').forEach(y => {
                        if (y.contains(document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`))) {
                            document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.closest('table').querySelector(`thead tr th:nth-child(${index + 1})`).style.display = 'block'
                            y.querySelector('td:nth-child(10)').style.display = 'block'
                            y.querySelector('td:nth-child(10) div').style.display = 'none'
                        }
                    })
                    this.eventHelper(model, false)
                }, 200);
            }
        },

        calculateAmount: function (model) {
            console.log('calc v1')
            console.log(model)
            var amount = 0;
            var itemList = model.get('itemList') || [];
            itemList.forEach(function (item) {
                amount += item.amount || 0;
            }, this);

            amount = Math.round(amount * 100) / 100;

            model.set('amount', amount);
        },
        calculateItem: function (model) {
            console.log("calculateItem");
            var priceBookCurrency = ""
            var discountCategories = ['6435c53a3ba5bf3e0']
            var manufacturerField = 'productBrandId';

            if (model.attributes.productId != undefined) {
                Espo.Ajax.getRequest('Product/' + model.attributes.productId)
                    .then(result => {
                        console.log(`Product: `, result)
                        var allowedPrices = [
                            "M365",
                            "O365/M365",
                            "Power Platform",
                            "D365"
                        ]

                        if (allowedPrices.includes(result.licenseType)) {
                            // Filtering by PriceBook
                            // let filter = "priceBooks?primaryFilter=&orderBy=createdAt&order=desc"
                            let filter = "prices?primaryFilter=&orderBy=createdAt&order=desc"
                            // Where Country (By Plain Name) Equals = X
                            let where = `where[0][type]=in&where[0][attribute]=status&where[0][value][]`
                            // let where = `where[0][type]=in&where[0][attribute]=countryLabel&where[0][value][]`
                            Espo.Ajax.getRequest(`Product/${model.attributes.productId}/${filter}&${where}=Active`)
                                // Espo.Ajax.getRequest(`Product/${model.attributes.productId}/${filter}`)
                                .then(priceBookResults => {
                                    if (priceBookResults.total > 0) {
                                        // Make PricebookRequest
                                        var priceBookItem = priceBookResults.list[0];
                                        console.log(priceBookItem);
                                        priceBookCurrency = priceBookItem.priceCurrency
                                        model.set('listPrice', priceBookItem.price);
                                        if (model.get('unitPrice') === 0 || model.get('unitPrice') === null || model.get('unitPrice') === "" || model.get('unitPrice') === undefined) {
                                            model.set('unitPrice', model.get('listPrice'))
                                        }
                                        var qty = model.get('quantity');
                                        var unitPrice = model.get('unitPrice');
                                        model.set({
                                            amount: (unitPrice * qty).toFixed(2),
                                            unitPrice: (unitPrice * 1).toFixed(2),
                                            listPrice: priceBookItem.price.toFixed(2)
                                        });
                                        var isP1Y = result.termDuration == "P1Y";
                                        var billingIsAnnualy = model.get('solutionType') == "Monthly";
                                        console.log(`this is the variable billingIsAnnualy == ${billingIsAnnualy}`);

                                        if (!model.has('originalListPrice')) {
                                            model.set('originalListPrice', model.get('listPrice'));
                                        }
                                        if (!model.has('originalUnitPrice')) {
                                            model.set('originalUnitPrice', model.get('unitPrice'));
                                        }
                                        if (!model.has('originalPriceBook')) {
                                            model.set('originalPriceBook', priceBookItem.name);
                                        }
                                        var originalPriceBook = model.get('originalPriceBook');
                                        if (originalPriceBook !== priceBookItem.name) {
                                            model.set('originalPriceBook', priceBookItem.name);
                                            model.set('unitPrice', model.get('listPrice'));
                                            var listPrice = model.get('unitPrice')
                                            var qty = model.get('quantity');
                                            model.set({
                                                amount: (listPrice * qty).toFixed(2),
                                            })
                                        }
                                        if (model.get('solutionType') != 'Annual') {
                                            model.set({
                                                annualCalculationDone: false //FLAG
                                            })
                                            model.set('originalUnitPrice', model.get('unitPrice'));
                                            model.set('originalListPrice', model.get('listPrice'));
                                        }
                                        if (isP1Y && billingIsAnnualy && model.get('annualCalculationDone') != false) {
                                            var originalListPrice = model.get('originalListPrice');
                                            var originalUnitPrice = model.get('originalUnitPrice');
                                            var monthsInYear = 12;
                                            var listPriceAnnual = originalListPrice * monthsInYear;
                                            var unitPriceAnnual = originalUnitPrice * monthsInYear;
                                            var qty = model.get('quantity');
                                            model.set({
                                                amount: (unitPriceAnnual * qty).toFixed(2),
                                                unitPrice: unitPriceAnnual.toFixed(2),
                                                listPrice: listPriceAnnual.toFixed(2),
                                                annualCalculationDone: true //FLAG
                                            });
                                            console.log('setting amount');
                                        }
                                        if (isP1Y && billingIsAnnualy) {
                                            model.set({
                                                listPrice: (priceBookItem.price * 12).toFixed(2),
                                            });
                                        }
                                        console.log("testing : ", result.billingCycle.length)

                                        model.set('name', priceBookItem.name);
                                        if (result.licenseType != null && result.licenseType != undefined && result.licenseType != "") {
                                            model.set('licenseType', result.licenseType);
                                            // document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('title', "If the License Type doesn't match what you're looking for, select another product");
                                        }
                                        if (result.timeContract != null && result.timeContract != undefined && result.timeContract != "") {
                                            model.set('timeContract', result.timeContract);
                                            console.log("entrei no if de timeContract")
                                            // document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('title', "If the Contract Period doesn't match what you're looking for, select another product");
                                        }
                                        if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 1) {
                                            model.set('solutionType', result.billingCycle[0]);
                                            if (result.billingCycle[0] == "monthly") {
                                                model.set('solutionType', "Monthly");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                            }
                                            if (result.billingCycle[0] == "annually") {
                                                model.set('solutionType', "Annual");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                            }
                                            // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                        }

                                        if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 2) {
                                            console.log(result.billingCycle)
                                            if (result.billingCycle[0] == "monthly" || result.billingCycle[1] == "annually") {
                                                var solutionTypeSelect = model.get('solutionType');
                                                console.log(solutionTypeSelect)
                                                console.log(model.get('solutionType'))
                                                if (solutionTypeSelect == null) {
                                                    model.set('solutionType', "Monthly");
                                                } else if (solutionTypeSelect == "Monthly") {
                                                    model.set('solutionType', "Monthly");
                                                } else if (solutionTypeSelect == "Annual") {
                                                    model.set('solutionType', "Annual");
                                                } else {
                                                    model.set('solutionType', "");

                                                }
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                            }
                                            document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                        }
                                        if (result.categoryType != null && result.categoryType != undefined && result.categoryType != "") {
                                            model.set('contractType', result.categoryType);
                                            var applyNCE = result.categoryType == "CSP" && localStorage.getItem('priceBookCountrySearch') == "Brasil" && priceBookCurrency == "BRL"
                                            if (applyNCE) {
                                                model.set('contractType', "NCE");
                                                console.log(`this model.set('contractType', "NCE"); was CSP, then was changed to "NCE"`);
                                            }
                                            // document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('title', "If the Contract Type doesn't match what you're looking for, select another product");
                                        }
                                    } else {
                                        if (result.licenseType != null && result.licenseType != undefined && result.licenseType != "") {
                                            model.set('licenseType', result.licenseType);
                                            // document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('title', "If the License Type doesn't match what you're looking for, select another product");
                                        }
                                        if (result.timeContract != null && result.timeContract != undefined && result.timeContract != "") {
                                            model.set('timeContract', result.timeContract);
                                            console.log("entrei no if de timeContract")
                                            // document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('title', "If the Contract Period doesn't match what you're looking for, select another product");
                                        }
                                        if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 1) {
                                            model.set('solutionType', result.billingCycle[0]);
                                            if (result.billingCycle[0] == "monthly") {
                                                model.set('solutionType', "Monthly");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                            }
                                            if (result.billingCycle[0] == "annually") {
                                                model.set('solutionType', "Annual");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                            }
                                            // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                        }
                                        if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 2) {
                                            if (result.billingCycle[0] == "monthly") {
                                                model.set('solutionType', "Monthly");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                            }
                                            if (result.billingCycle[1] == "monthly") {
                                                model.set('solutionType', "Monthly");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                            }
                                            if (result.billingCycle[0] == "annually") {
                                                model.set('solutionType', "Annual");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                            }
                                            if (result.billingCycle[1] == "annually") {
                                                model.set('solutionType', "Annual");
                                                console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                            }
                                            // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                        }
                                        if (result.categoryType != null && result.categoryType != undefined && result.categoryType != "") {
                                            model.set('contractType', result.categoryType);
                                            var applyNCE = result.categoryType == "CSP" && localStorage.getItem('priceBookCountrySearch') == "Brasil" && priceBookCurrency == "BRL"
                                            if (applyNCE) {
                                                model.set('contractType', "NCE");
                                                console.log(`this model.set('contractType', "NCE"); was CSP, then was changed to "NCE"`);
                                            }
                                            // document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('disabled', true);
                                            document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('title', "If the Contract Type doesn't match what you're looking for, select another product");
                                        }

                                        console.log('undef unit Price')
                                        model.set('listPrice', result.listPrice.toFixed(2));
                                        model.set('name', result.name);

                                    }
                                })
                        } else {
                            var priceBookCountry = localStorage.getItem('priceBookCountrySearch')
                            console.log(priceBookCountry)
                            if (priceBookCountry != null) {
                                // Filtering by PriceBook
                                let filter = "priceBooks?primaryFilter=&orderBy=createdAt&order=desc"
                                // Where Country (By Plain Name) Equals = X
                                let where = `where[0][type]=in&where[0][attribute]=countryLabel&where[0][value][]`
                                Espo.Ajax.getRequest(`Product/${model.attributes.productId}/${filter}&${where}=${priceBookCountry}`)
                                    .then(priceBookResults => {
                                        if (priceBookResults.total > 0) {
                                            var priceBookItem = priceBookResults.list[0];
                                            console.log(priceBookItem);
                                            priceBookCurrency = priceBookItem.unitPriceCurrency
                                            model.set('listPrice', priceBookItem.unitPrice);
                                            if (model.get('unitPrice') === 0 || model.get('unitPrice') === null || model.get('unitPrice') === "" || model.get('unitPrice') === undefined) {
                                                model.set('unitPrice', model.get('listPrice'))
                                            }
                                            var qty = model.get('quantity');
                                            var unitPrice = model.get('unitPrice');
                                            model.set({
                                                amount: (unitPrice * qty).toFixed(2),
                                                unitPrice: (unitPrice * 1).toFixed(2),
                                                listPrice: priceBookItem.unitPrice.toFixed(2)
                                            });
                                            var isP1Y = result.termDuration == "P1Y";
                                            var billingIsAnnualy = model.get('solutionType') == "Monthly";
                                            console.log(`this is the variable billingIsAnnualy == ${billingIsAnnualy}`);

                                            if (!model.has('originalListPrice')) {
                                                model.set('originalListPrice', model.get('listPrice'));
                                            }
                                            if (!model.has('originalUnitPrice')) {
                                                model.set('originalUnitPrice', model.get('unitPrice'));
                                            }
                                            if (!model.has('originalPriceBook')) {
                                                model.set('originalPriceBook', priceBookItem.name);
                                            }
                                            var originalPriceBook = model.get('originalPriceBook');
                                            if (originalPriceBook !== priceBookItem.name) {
                                                model.set('originalPriceBook', priceBookItem.name);
                                                model.set('unitPrice', model.get('listPrice'));
                                                var listPrice = model.get('unitPrice')
                                                var qty = model.get('quantity');
                                                model.set({
                                                    amount: (listPrice * qty).toFixed(2),
                                                })
                                            }
                                            if (model.get('solutionType') != 'Annual') {
                                                model.set({
                                                    annualCalculationDone: false //FLAG
                                                })
                                                model.set('originalUnitPrice', model.get('unitPrice'));
                                                model.set('originalListPrice', model.get('listPrice'));
                                            }
                                            if (isP1Y && billingIsAnnualy && model.get('annualCalculationDone') != false) {
                                                var originalListPrice = model.get('originalListPrice');
                                                var originalUnitPrice = model.get('originalUnitPrice');
                                                var monthsInYear = 12;
                                                var listPriceAnnual = originalListPrice * monthsInYear;
                                                var unitPriceAnnual = originalUnitPrice * monthsInYear;
                                                var qty = model.get('quantity');
                                                model.set({
                                                    amount: (unitPriceAnnual * qty).toFixed(2),
                                                    unitPrice: unitPriceAnnual.toFixed(2),
                                                    listPrice: listPriceAnnual.toFixed(2),
                                                    annualCalculationDone: true //FLAG
                                                });
                                                console.log('setting amount');
                                            }
                                            if (isP1Y && billingIsAnnualy) {
                                                model.set({
                                                    listPrice: (priceBookItem.unitPrice * 12).toFixed(2),
                                                });
                                            }
                                            console.log("testing : ", result.billingCycle.length)

                                            model.set('name', priceBookItem.name);
                                            if (result.licenseType != null && result.licenseType != undefined && result.licenseType != "") {
                                                model.set('licenseType', result.licenseType);
                                                // document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('title', "If the License Type doesn't match what you're looking for, select another product");
                                            }
                                            if (result.timeContract != null && result.timeContract != undefined && result.timeContract != "") {
                                                model.set('timeContract', result.timeContract);
                                                console.log("entrei no if de timeContract")
                                                // document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('title', "If the Contract Period doesn't match what you're looking for, select another product");
                                            }
                                            if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 1) {
                                                model.set('solutionType', result.billingCycle[0]);
                                                if (result.billingCycle[0] == "monthly") {
                                                    model.set('solutionType', "Monthly");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                                }
                                                if (result.billingCycle[0] == "annually") {
                                                    model.set('solutionType', "Annual");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                                }
                                                // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                            }

                                            if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 2) {
                                                console.log(result.billingCycle)
                                                if (result.billingCycle[0] == "monthly" || result.billingCycle[1] == "annually") {
                                                    var solutionTypeSelect = model.get('solutionType');
                                                    console.log(solutionTypeSelect)
                                                    console.log(model.get('solutionType'))
                                                    if (solutionTypeSelect == null) {
                                                        model.set('solutionType', "Monthly");
                                                    } else if (solutionTypeSelect == "Monthly") {
                                                        model.set('solutionType', "Monthly");
                                                    } else if (solutionTypeSelect == "Annual") {
                                                        model.set('solutionType', "Annual");
                                                    } else {
                                                        model.set('solutionType', "");

                                                    }
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                                }
                                                // if (result.billingCycle[1] == "annually") {
                                                //     model.set('solutionType', "Annual");
                                                //     console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                                // }
                                                // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                            }
                                            if (result.categoryType != null && result.categoryType != undefined && result.categoryType != "") {
                                                model.set('contractType', result.categoryType);
                                                var applyNCE = result.categoryType == "CSP" && localStorage.getItem('priceBookCountrySearch') == "Brasil" && priceBookCurrency == "BRL"
                                                if (applyNCE) {
                                                    model.set('contractType', "NCE");
                                                    console.log(`this model.set('contractType', "NCE"); was CSP, then was changed to "NCE"`);
                                                }
                                                // document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('title', "If the Contract Type doesn't match what you're looking for, select another product");
                                            }
                                        } else {

                                            if (result.licenseType != null && result.licenseType != undefined && result.licenseType != "") {
                                                model.set('licenseType', result.licenseType);
                                                // document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('title', "If the License Type doesn't match what you're looking for, select another product");
                                            }
                                            if (result.timeContract != null && result.timeContract != undefined && result.timeContract != "") {
                                                model.set('timeContract', result.timeContract);
                                                console.log("entrei no if de timeContract")
                                                // document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('title', "If the Contract Period doesn't match what you're looking for, select another product");
                                            }
                                            if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 1) {
                                                model.set('solutionType', result.billingCycle[0]);
                                                if (result.billingCycle[0] == "monthly") {
                                                    model.set('solutionType', "Monthly");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                                }
                                                if (result.billingCycle[0] == "annually") {
                                                    model.set('solutionType', "Annual");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                                }
                                                // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                            }
                                            if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 2) {
                                                if (result.billingCycle[0] == "monthly") {
                                                    model.set('solutionType', "Monthly");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                                }
                                                if (result.billingCycle[1] == "monthly") {
                                                    model.set('solutionType', "Monthly");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                                                }
                                                if (result.billingCycle[0] == "annually") {
                                                    model.set('solutionType', "Annual");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                                }
                                                if (result.billingCycle[1] == "annually") {
                                                    model.set('solutionType', "Annual");
                                                    console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                                                }
                                                // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                                            }
                                            if (result.categoryType != null && result.categoryType != undefined && result.categoryType != "") {
                                                model.set('contractType', result.categoryType);
                                                var applyNCE = result.categoryType == "CSP" && localStorage.getItem('priceBookCountrySearch') == "Brasil" && priceBookCurrency == "BRL"
                                                if (applyNCE) {
                                                    model.set('contractType', "NCE");
                                                    console.log(`this model.set('contractType', "NCE"); was CSP, then was changed to "NCE"`);
                                                }
                                                // document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('disabled', true);
                                                document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('title', "If the Contract Type doesn't match what you're looking for, select another product");
                                            }

                                            console.log('undef unit Price')
                                            model.set('listPrice', result.listPrice.toFixed(2));
                                            model.set('name', result.name);

                                        }
                                    })
                            }

                        }


                        //  GOOGLE DISCOUNT FIELDS
                        // debugger
                        var savedFields = [];
                        if (window.tempStorage.savedFields !== undefined) {
                            savedFields = window.tempStorage.savedFields;
                        } else {
                            window.tempStorage.savedFields = savedFields;
                        }
                        if (discountCategories.includes(result.categoryId) && model.parentModel.get(manufacturerField) == "636d036e352aca8bc") {
                            console.log('if inside, should show discount')

                            setTimeout(() => {
                                if (!savedFields.includes(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`)) {
                                    savedFields.push(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`);
                                }
                                savedFields.forEach(x => {
                                    console.log(document.querySelector(x))
                                    var indx = document.querySelector(x).parentElement.cellIndex
                                    document.querySelector(x).parentElement.style.display = 'block'
                                    document.querySelector(x).style.display = 'block'
                                    document.querySelector(x).parentElement.closest('table').querySelector(`thead tr th:nth-child(${indx + 1})`).style.display = 'block'

                                })
                                // store fields
                                window.tempStorage.savedFields = savedFields
                                this.eventHelper(model, true)
                            }, 200);

                        } else {
                            console.log('else inside, should hide discount')

                            if (!savedFields == null || !savedFields.length == 0) {
                                setTimeout(() => {
                                    const index = document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.cellIndex
                                    document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.closest('table').querySelector(`thead tr th:nth-child(${index + 1})`).style.display = 'none'
                                    document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.style.display = 'none'

                                    document.querySelectorAll('.item-container').forEach(y => {
                                        if (y.contains(document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`))) {
                                            document.querySelector(`[data-id="${model.id}"] [data-name="item-cAdditionalDiscount"]`).parentElement.closest('table').querySelector(`thead tr th:nth-child(${index + 1})`).style.display = 'block'
                                            y.querySelector('td:nth-child(10)').style.display = 'block'
                                            y.querySelector('td:nth-child(10) div').style.display = 'none'
                                        }
                                    })
                                    this.eventHelper(model, false)
                                }, 200);
                            }
                        }







                        // else if (model.get('unitPrice') == undefined) {
                        //     console.log('undef unit Price')
                        //     model.set('unitPrice', result.unitPrice.toFixed(2));
                        //     model.set('name', result.name);
                        //     var isP1Y = result.termDuration == "P1Y";
                        //     var billingIsAnnualy = model.get('solutionType') == "Annual"
                        //     console.log(`this is the variable billingIsAnnualy == ${billingIsAnnualy}`)
                        //     if (isP1Y && billingIsAnnualy) {
                        //         var unitPrice = model.get('unitPrice');
                        //         var monthsInYear = 12;
                        //         var unitPriceAnnual = unitPrice * monthsInYear
                        //         var qty = model.get('quantity');
                        //         model.set({
                        //             amount: (unitPriceAnnual * qty).toFixed(2),
                        //             unitPrice: unitPriceAnnual.toFixed(2)
                        //         })
                        //         console.log('setting amount')
                        //     }
                        // }

                        // if (result.licenseType != null && result.licenseType != undefined && result.licenseType != "") {
                        //     model.set('licenseType', result.licenseType);
                        // document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('disabled', true);
                        //     document.querySelector('[data-name="itemList"] select[data-name="licenseType"]').setAttribute('title', "If the License Type doesn't match what you're looking for, select another product");
                        // }
                        // if (result.timeContract != null && result.timeContract != undefined && result.timeContract != "") {
                        //     model.set('timeContract', result.timeContract);
                        //     console.log("entrei no if de timeContract")
                        // document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('disabled', true);
                        //     document.querySelector('[data-name="itemList"] select[data-name="timeContract"]').setAttribute('title', "If the Contract Period doesn't match what you're looking for, select another product");
                        // }
                        // if (result.billingCycle != null && result.billingCycle != undefined && result.billingCycle != "" && result.billingCycle.length == 1) {
                        //     model.set('solutionType', result.billingCycle[0]);
                        //     if (result.billingCycle[0] == "monthly") {
                        //         model.set('solutionType', "Monthly");
                        //         console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Monthly"`)
                        //     }
                        //     if (result.billingCycle[0] == "annually") {
                        //         model.set('solutionType', "Annual");
                        //         console.log(`this result.billingCycle[0] was ${result.billingCycle[0]}, then was changed to "Annual"`)
                        //     }
                        // document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('disabled', true);
                        //     document.querySelector('[data-name="itemList"] select[data-name="solutionType"]').setAttribute('title', "If the Billing Period doesn't match what you're looking for, select another product");
                        // }
                        // if (result.categoryType != null && result.categoryType != undefined && result.categoryType != "") {
                        //     model.set('contractType', result.categoryType);
                        //     var applyNCE = result.categoryType == "CSP" && localStorage.getItem('priceBookCountrySearch') == "Brasil" && priceBookCurrency == "BRL"
                        //     if (applyNCE) {
                        //         model.set('contractType', "NCE");
                        //         console.log(`this model.set('contractType', "NCE"); was CSP, then was changed to "NCE"`);
                        //     }
                        // document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('disabled', true);
                        //     document.querySelector('[data-name="itemList"] select[data-name="contractType"]').setAttribute('title', "If the Contract Type doesn't match what you're looking for, select another product");
                        // }


                        // TODO : TESTAR CENARIO COM PRODUTO SEM PRICEBOOK
                        // var isP1Y = result.termDuration == "P1Y";
                        // var billingIsAnnualy = model.get('solutionType') == "Annual"
                        // console.log(`this is the variable billingIsAnnualy == ${billingIsAnnualy}`)
                        // if (isP1Y && billingIsAnnualy) {
                        //     console.log('setting amount')
                        //     var listPrice = model.get('listPrice');
                        //     var unitPrice = model.get('unitPrice');
                        //     var monthsInYear = 12;
                        //     var unitPriceAnnual = unitPrice * monthsInYear
                        //     var listPriceAnnual = listPrice * monthsInYear
                        //     var qty = model.get('quantity');
                        //     model.set({
                        //         amount: (unitPriceAnnual * qty).toFixed(2),
                        //         unitPrice: unitPriceAnnual.toFixed(2),
                        //         listPrice: listPriceAnnual.toFixed(2)
                        //     })
                        //     console.log('setting amount')
                        // } else {
                        //     var qty = model.get('quantity');
                        //     var unitPriceAnnual = model.get('unitPrice');
                        //     var listPriceAnnual = model.get('listPrice');
                        //     model.set({
                        //         amount: (unitPriceAnnual * qty).toFixed(2),
                        //         unitPrice: unitPriceAnnual.toFixed(2),
                        //         listPrice: listPriceAnnual.toFixed(2)
                        //     })
                        // }
                    });
            }
        },


        optionSelection: function (brand, licenseTypeSelect, solutionTypeSelect, timeContractSelect) {
            return new Promise(function (r) {
                console.log('callingSwitchCase');
                console.log(brand)
                var microsoftLicenseType = [
                    "Azure",
                    "Dynamics 365",
                    "Microsoft 365 - Montlhy",
                    "Microsoft 365 - Annual",
                    "Software Perpetual",
                    "Software Subscription",
                    "Open Value Perpetual",
                    "Open Valeu SA",
                    "Open Valeu Subscription 1 Ano",
                    "Open Valeu Subscription 3 Anos",
                ]
                var microsoftFaturacion = [
                    "Monthly",
                    "Annual",
                    "Up front",
                ]
                var microsoftPeriod = [
                    "1 Month",
                    "1 Year",
                    "3 Years",
                    "Perpetual",
                    "Pay as you go"
                ]
                var googleLicenseType = [
                    "New Business",
                    "Upgrade",
                    "Renewal",
                ]
                var googleFaturacion = [
                    "Monthly",
                    "Annual",
                    "Trial",
                    "Flexible",
                ]
                var googlePeriod = [
                    "1 Month",
                    "1 Year",
                    "2 Years",
                    "3 Years",
                ]
                var awsLicenseType = [
                    "AWS",
                ]
                var awsPeriod = [
                    "1 Month",
                    "1 Year",
                    "2 Years",
                    "3 Years",
                ]
                var awsFaturacion = [
                    "Monthly",
                    "Annual",
                    "Up front",
                ]
                switch (brand) {
                    case "Microsoft":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < microsoftLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == microsoftLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${microsoftLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < microsoftFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == microsoftFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${microsoftFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < microsoftPeriod.length; y++) {
                                if (timeContractSelect.options[i].value == microsoftPeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${microsoftPeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    case "Google":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            if (licenseTypeSelect.options[i] != "") {
                                licenseTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            if (solutionTypeSelect.options[i] != "") {
                                solutionTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            if (timeContractSelect.options[i] != "") {
                                timeContractSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < googleLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == googleLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${googleLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < googleFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == googleFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${googleFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < googlePeriod.length; y++) {
                                if (timeContractSelect.options[i].value == googlePeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${googlePeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    case "AWS":
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            if (licenseTypeSelect.options[i] != "") {
                                licenseTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            if (solutionTypeSelect.options[i] != "") {
                                solutionTypeSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            if (timeContractSelect.options[i] != "") {
                                timeContractSelect.options[i].style.display = 'none';
                            }
                        }
                        for (i = 0; i < licenseTypeSelect.options.length; i++) {
                            for (x = 0; x < awsLicenseType.length; x++) {
                                if (licenseTypeSelect.options[i].value == awsLicenseType[x]) {
                                    console.log(`match: ${licenseTypeSelect.options[i].value} == ${awsLicenseType[x]}`)
                                    licenseTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < solutionTypeSelect.options.length; i++) {
                            for (y = 0; y < awsFaturacion.length; y++) {
                                if (solutionTypeSelect.options[i].value == awsFaturacion[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${awsFaturacion[y]}`)
                                    solutionTypeSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        for (i = 0; i < timeContractSelect.options.length; i++) {
                            for (y = 0; y < awsPeriod.length; y++) {
                                if (timeContractSelect.options[i].value == awsPeriod[y]) {
                                    console.log(`match: ${solutionTypeSelect.options[i].value} == ${awsPeriod[y]}`)
                                    timeContractSelect.options[i].style.display = 'block'
                                }
                            }
                        }
                        r()
                        break;
                    default:
                        r()
                        break;
                }
            })

        },
        selectProduct: function (model, product) {
            console.log("selectProduct v1")
            var sourcePrice = product.get('unitPrice');
            var sourceCurrency = product.get('unitPriceCurrency');
            var targetCurrency = model.get('unitPriceCurrency');

            var baseCurrency = this.config.get('baseCurrency');
            var rates = this.config.get('currencyRates') || {};

            var value = sourcePrice;
            value = value * (rates[sourceCurrency] || 1.0);
            value = value / (rates[targetCurrency] || 1.0);

            var targetPrice = Math.round(value * 100) / 100;

            model.set({
                productId: product.id,
                productName: product.get('name'),
                name: product.get('name'),
                unitPrice: targetPrice,
                unitPriceCurrency: targetCurrency
            });
            console.log('selectProduct');
            console.log(product);
            window.productGlobal = product;
        }
    });
});
