const teamsIds = [
        "677febb48f65d30df",
        "675081f4218833ca1",
        "675081f428be23392",
        "673f41d398ed8a9fe",
        "67d08573c3b788903",
        "675081f4338757568",
        "675081f43c8aa869e",
        "675081f4450ee7686",
        "675081f46688a1598",
        "675081f44eae1fff2",
        "675081f4577147328",
        "675081f47cf78ec80",
        "675081f4855a236e3",
        "675081f48ef82072c",
        "675081f4981df3bcc",
        "675081f4a23d5ec2f",
        "675081f4ac45f6f81",
        "675081f4b42e63030",
        "675081f4bbf6059b2",
        "675081f4c4691dd40",
        "675081f4cd3fc69a9",
        "675081f4d6884299c",
        "675081f4de5f9a2da",
        "675081f4e7651edd7",
        "675081f4ef06fffe7",
        "675081f507ae7a5fa",
        "675081f51f2ef77b2",
        "675081f513384753f",
        "677837cd7a732b1ce",
        "675081f52925a318d",
        "675081f530a4eb4ac",
        "675081f5383981e6e",
        "675081f5405a962eb",
        "675081f547f6e5985",
        "675081f5500214dd2",
        "675081f55a7f4595b",
        "675081f567552660e",
        "675081f56fb4edc6f",
        "675081f58155dbe88",
        "675081f5797fa8470",
        "63fe2e975c350b246",
        "6410865e7b429f6bb",
        "643418441fabd22dd",
        "6320869fe404e348c",
        "6217badb36ba2650e",
        "6528501bc60866d03"
];



window.onload = async function () {
    console.log("Enube Patch Notes Loaded");
    setTimeout(() => {
        patchNotes()

    }, 5000);

};




async function patchNotes() {
    var Swal = await this.window.Espo.loader.requirePromise('swal');
    var userId = localStorage.getItem('espo-user-lastUserId');
    var assignedUserId
    var dashboardName
    var defaultTeamId
    var url = `api/v1/User/${userId}`

    try {
        const responseUser = await makeRequestCRM(url, 'GET');

        await makeRequestCRM(url, 'GET', null)
        console.log(responseUser);
        var country = responseUser.countryList
        assignedUserId = responseUser.id
        defaultTeamId = responseUser.defaultTeamId
        console.log(responseUser);

        if (country.includes("Brasil")) {
            console.log("inclui Brasil");
            return;
        }
        if (teamsIds.includes(responseUser.defaultTeamId)) {
            console.log("Time listado");
            return;
        }
    } catch (error) {
        console.error("Erro ao buscar usuário:", error);
        return;
    }

    var url = `api/v1/PatchNotes?maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=in&where[0][attribute]=updatestatus&where[0][value][]=Released&where[1][type]=past&where[1][attribute]=releasedate&where[1][value]=&where[1][dateTime]=true&where[1][timeZone]=America/Sao_Paulo&where[2][type]=and&where[2][value][0][type]=notEquals&where[2][value][0][attribute]=modaltext&where[2][value][0][value]=&where[2][value][1][type]=isNotNull&where[2][value][1][attribute]=modaltext&where[2][value][1][value]=&where[3][type]=isTrue&where[3][attribute]=displayModal&where[3][value]=`
    await makeRequestCRM(url, 'GET').then(function (responsePatch) {
        if (responsePatch.total > 0) {
            console.log(responsePatch.list[0])
            dashboardName = responsePatch.list[0].name;
            var url = `api/v1/DashboardAccess?maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=equals&where[0][attribute]=assignedUserId&where[0][value]=${assignedUserId}&where[1][type]=startsWith&where[1][attribute]=name&where[1][value]=${responsePatch.list[0].name}`
            console.log(url)
            makeRequestCRM(url, 'GET', null).then((responseDash) => {
                console.log(responseDash);
                console.log(responseDash.total);
                if (responseDash.total == 0) {
                    if (responsePatch.list[0].updatetype == "Migration" && teamsIds.includes(defaultTeamId)) {
                        console.log(`Not in MCA team, skip`)
                        return
                    }


                    Swal.fire({
                        icon: "info",
                        title: responsePatch.list[0].titleText,
                        html: `<div class="update-notification">
                        <p style="margin-top: 1%; font-size: 14px; text-align: center;" > <br>
                        <strong>${responsePatch.list[0].name}</strong>
                        <br>
                        ${responsePatch.list[0].modaltext}
                        <br>
                        <br>
                        <span id="viewPatchNote" style="color: #007b78; text-decoration: underline; cursor: pointer; font-size: 14px;"> ${responsePatch.list[0].buttonText} </span>
                        </p>
                        </div>`,
                        width: '25%',
                        confirmButtonText: "OK",
                        confirmButtonColor: '#007b78',
                        allowOutsideClick: false,
                        allowEscapeKey: false,

                    }).then((result) => {
                        if (result.isConfirmed) {
                            try {
                                var payloadPostCdp = {
                                    "assignedUserId": assignedUserId,
                                    "name": dashboardName,
                                    "tabName": "PatchNotes",
                                    "accessTime": new Date().toISOString().replace("T", " ").substring(0, 19)
                                }
                                var urlContactUpdate = `api/v1/DashboardAccess`
                                makeRequestCRM(urlContactUpdate, "POST", payloadPostCdp)
                            } catch (error) {
                                console.log(error)
                                if (error.status == 409) {
                                    logger.info("CONFLITO! " + error.responseText)
                                }
                            }

                        }
                    });
                    document.getElementById('viewPatchNote').addEventListener('click', function () {
                        handlePatchNoteRedirect(responsePatch.list[0].id, assignedUserId, dashboardName);
                    });
                    document.querySelector('.swal2-actions').style = "margin: 0em auto 0 !important;"
                    document.querySelector('#swal2-html-container').style = "padding: 0em 1.6em 0.3em !important;"
                    document.querySelector('.swal2-confirm ').style = "padding: 10px 24px; background-color: #007b78; color: white; border: none; font-size: 14px"
                }
            });
        }
    })

    // var url = `https://https://cdp.cloudanalytics.me//api/v1/PatchNotes?maxSize=30&offset=0&orderBy=createdAt&order=desc&where[0][type]=past&where[0][attribute]=releasedate&where[0][value]=&where[0][dateTime]=true&where[0][timeZone]=America/Sao_Paulo&where[1][type]=in&where[1][attribute]=updatestatus&where[1][value][]=Released`
    // makeRequestCRM(url, 'GET').then(function (response) {

    // })
}


async function makeRequestCRM(url, method, data) {
    return new Promise(function (resolve, reject) {
        var xhr = new XMLHttpRequest();
        xhr.open(method, url);

        if (data != undefined) {
            xhr.setRequestHeader('Content-Type', 'application/json');
        }

        xhr.setRequestHeader('Authorization', "Basic Y3NfaW50ZWdyYXRpb246VHViYXJAMDE=");
        xhr.addEventListener('readystatechange', function () {
            if (this.readyState == 4) {
                if (this.status == 200) {
                    resolve(JSON.parse(this.responseText));
                } else {
                    reject(this);
                }
            }
        });
        xhr.send(JSON.stringify(data));
    });
}

async function handlePatchNoteRedirect(patchId, userId, dashboardName) {
    var Swal = await this.window.Espo.loader.requirePromise('swal');

    Swal.close();
    const payloadPostCdp = {
        assignedUserId: userId,
        name: dashboardName,
        tabName: "PatchNotes",
        accessTime: new Date().toISOString().replace("T", " ").substring(0, 19)
    };

    const url = `api/v1/DashboardAccess`;

    makeRequestCRM(url, "POST", payloadPostCdp)
        .then(() => {
            window.open(`https://cdp.cloudanalytics.me/#PatchNotes/view/${patchId}`, '_blank');
        })
        .catch((error) => {
            console.error("Erro ao registrar acesso ao dashboard", error);
            window.open(`https://cdp.cloudanalytics.me/#PatchNotes/view/${patchId}`, '_blank');
        });
}
