<?php
/************************************************************************
 * This file is part of TD SYNNEX.
 *
 * TD SYNNEX – Open Source CRM application.
 * Copyright (C) 2014-2025 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "TD SYNNEX" word.
 ************************************************************************/

namespace Espo\Core\Utils\Database\Schema;

use Espo\Core\InjectableFactory;
use Espo\Core\Utils\Database\Helper;

use Doctrine\DBAL\Schema\SchemaException;

class SchemaManagerProxy
{
    private ?SchemaManager $schemaManager = null;

    public function __construct(private InjectableFactory $injectableFactory) {}

    private function getSchemaManager(): SchemaManager
    {
        $this->schemaManager ??= $this->injectableFactory->create(SchemaManager::class);

        return $this->schemaManager;
    }

    /**
     * @param ?string[] $entityTypeList
     * @param RebuildMode::* $mode
     * @throws SchemaException
     */
    public function rebuild(?array $entityTypeList = null, string $mode = RebuildMode::SOFT): bool
    {
        return $this->getSchemaManager()->rebuild($entityTypeList, $mode);
    }

    public function getDatabaseHelper(): Helper
    {
        return $this->getSchemaManager()->getDatabaseHelper();
    }
}
