var IN_PROGRESS = false;
const STATUS = {
    IN_REVIEW: "In Review",
    APPROVED: "Approved",
    PRESENTED: "Presented"
}

window.onload = function () {
    getParams()
    virtualTour()

}

var currentQuote = ""
var totalProduct = 0
var quotesId = []

function getClientId(billingContactId) {
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };

    fetch(`https://cdp.cloudanalytics.me/api/v1/Opportunity?select=quotesOpportunityIds,quoteApprovalDate,reviewDate,quoteStatus,amountWithDiscountCurrency,amountWithDiscount,amount,amountCurrency,name,amountDiscount
&maxSize=10&offset=0&orderBy=createdAt&order=desc&where[0][type]=equals&where[0][attribute]=billingContactID&where[0][value]=${billingContactId}&where[1][type]=in&where[1][attribute]=quoteStatus&where[1][value][]=In Review&where[1][value][]=Approved&where[1][value][]=Presented`, requestOptions)
        .then(response => {
            if (response.status == 404) {
                Swal.fire({
                    icon: "error",
                    title: "Não Encontrado",
                    text: "O registro não foi encontrado",
                });
            } else if (response.status != 200) {
                Swal.fire({
                    icon: "error",
                    title: "Algo não funcionou corretamente",
                    text: "Pedimos para que atualize a página e tente novamente.",
                });
            } else {
                return response.json()
            }

        })
        .then(data => {

            console.log(data)
            data.list.forEach(item => {
                console.log("teste", item.amountCurrency)
                var total 
                console.log("total", total)
                if (item.amountCurrency ==="BRL") {
                    console.log("totalteste", total)
                    total = item.amountDiscount.toLocaleString('pt-br', { style: 'currency', currency: 'BRL' })
                    console.log("totalteste", total)

                } else if (item.amountCurrency == "USD") {
                    total = item.amountDiscount.toLocaleString('en-us', { style: 'currency', currency: 'USD' })
                }
                var ButtonTPL = "";
                var helperText = "";
                if (item.quoteStatus == "Presented") {
                    if (item.createdAt != null) {
                        quoteDate = item.createdAt;
                        title = "Data da Cotação:"
                    }
                    var date = new Date(quoteDate);

                    var formattedDate = date.toLocaleDateString('pt-BR');



                    ButtonTPL = `
                    <div class="col-md-12 text-center ">
                         <button type="button" style="width:60%; padding:8px; background-color: #08BED5; border: 0; margin:0 0 5px 0" class="btn btn-primary visualize-button" data-sample="${item.id}" >
                             Validar Cotação
                         </button>
                                  <div class="row g-0 align-items-center">
                                <p style="margin: 10px 0 0 0; font-size: 0.8rem; font-weight: 600; color: #525f7f;">${title} ${formattedDate}</p>
                            </div>
                     </div>
             `
                    helperText = "";
                    totalText = ""
                    dataQuote = ""
                    dateText = ""
                    dateReviewText = ""
                } else if (item.quoteStatus == "Approved") {
                    helperText = "Aprovada";
                    totalText = `<div class="col-md-3 align-items-center" style="text-align: right;">
		                    <a href="#" class="col-md-3 budget">${total}</a>
	                    </div>`
                    dateText = "Data Aprovação :"
                    if (item.quoteApprovalDate != null && item.quoteApprovalDate != "" && item.quoteApprovalDate != undefined) {
                        dataQuote = formatarData(item.quoteApprovalDate)
                    }
                }
                else if (item.quoteStatus == "In Review") {
                    helperText = "Em Revisão";
                    totalText = `<div class="col-md-3 align-items-center" style="text-align: right;">
		                    <a href="#" class="col-md-3 budget">${total}</a>
	                    </div>`
                    dateText = "Data Revisão :"
                    if (item.reviewDate != null && item.reviewDate != "" && item.reviewDate != undefined) {
                        dataQuote = formatarData(item.reviewDate)
                    }
                }


                $('.list-quotes').append(`
                    <div class="row g-0 align-items-center" style=" display: flex;
    flex-direction: row;
    justify-content: space-between;">
                        <div class="col-md-3 align-items-center" style="text-align: center;">
		                    <a href="#" class="col-md-3 title-quote text-blue" style="font-size:0.9rem;">${item.name}</a>
	                    </div>
                        <div class="col-md-3 align-items-center" style="text-align: right;">
		                    <a href="#" class="col-md-3 budget">${total}</a>
	                    </div>
                        <div class="col-md-6 text-center" style="color: #525f7f">
                        ${ButtonTPL}
                        <strong>${helperText}</strong>
                        <div class="row g-0 align-items-center">
                                <p style="margin: 10px 0 0 0; font-size: 0.8rem; font-weight: 600; color: #525f7f;">${dateText} ${dataQuote}</p>
                        </div>
                        
                    </div>
                `)
                var loading = document.querySelector('#loading-quotes');
                loading.style.display = 'none'
                console.log(item.quotesOpportunityIds)
            });

            document.querySelectorAll('button[data-sample]').forEach(item => {
                item.addEventListener('click', () => {
                    console.log(item);
                    localStorage.setItem('chooseOpp', item.dataset.sample);
                    window.open("quotes.html", "_blank")
                })
            })

        })
        .catch(error => {
            console.log(error)
        });

}


function getParams() {
    var keyInput = document.querySelector('#quote-key');
    var serchKeyQuote = document.querySelector('.search-quote-key');
    var keyData = localStorage.getItem('keyData');
    if (keyData != null && keyData != undefined && keyData != '') {
        keyInput.value = keyData;
        getDataKey(keyData);
    }
    serchKeyQuote.addEventListener('click', function (e) {
        console.log(keyInput.value)
        if (!IN_PROGRESS) {
            IN_PROGRESS = true;
            getDataKey(keyInput.value);
        } else {
            console.log("Já está em progresso")
        }

    });
    keyInput.addEventListener('keyup', function (e) {
        var key = e.which || e.keyCode;
        if (key == 13) {
            if (!IN_PROGRESS) {
                IN_PROGRESS = true;
                getDataKey(keyInput.value);
            } else {
                console.log("Já está em progresso")
            }
        }
    });
}

function getDataKey(keyInput) {
    localStorage.setItem('keyData', keyInput);
    document.querySelector('.list-quotes').innerHTML = `
    <span style="color:#007b78; font-weight: bold; padding: 5px;" class="text-center" id="loading-quotes">
        <div class="spinner-border text-success" role="status" style="text-align: center;margin: 15px auto;color: #007b78!important; display: block;">
            <span class="visually-hidden">Loading...</span>

        </div>
        <span id="loading-text" class="text-center animate__animated animate__fadeIn">Carregando Informações...</span>
    </span>
    `
    console.log()
    var interval = setInterval(function () {
        loadingText('#loading-text')
    }, 1000)
    var myHeaders = new Headers();
    myHeaders.append("Authorization", "Basic bWF0aGV1c2w6VHViYXJAMDE=");
    var requestOptions = {
        method: 'GET',
        headers: myHeaders,
        redirect: 'manual'
    };
    fetch(`https://cdp.cloudanalytics.me/api/v1/Contact/${keyInput}`, requestOptions)
        .then(response => {
            if (response.status == 404) {
                Swal.fire({
                    icon: "error",
                    title: "Erro na Chave de Acesso",
                    text: "Ops! Não conseguimos localizar essa chave de acesso em nosso sistema. Por favor, verifique novamente o código no e-mail enviado pelo seu vendedor. A chave é composta por 16 caracteres, incluindo letras e números.",
                });
                clearInterval(interval)

            } else if (response.status != 200) {
                Swal.fire({
                    icon: "error",
                    title: "Algo não funcionou corretamente",
                    text: "Pedimos para que atualize a página e tente novamente.",
                });
                clearInterval(interval)

            } else {
                clearInterval(interval)
                return response.json()
            }
        })
        .then(data => {
            console.log(data)

            changeText('#greeting', `Olá, ${data.firstName}!`)
            getClientId(keyInput)
        })
}

var changeText = function (id, newText) {
    var sideText = document.querySelector('#sideText')
    sideText.innerHTML = ""


    item = document.querySelector(id);
    let animation = item.animate([
        { transform: 'translateY(0px)', opacity: '1' },
        { transform: 'translateY(1px)', opacity: '0.9' },
        { transform: 'translateY(4px)', opacity: '0.7' },
        { transform: 'translateY(9px)', opacity: '0.5' },
        { transform: 'translateY(14px)', opacity: '0.3' }

    ], {
        duration: 500,

    });

    animation.onfinish = function () {
        item.innerText = newText;
        item.animate([
            { transform: 'translateY(14px)', opacity: '0.3' },
            { transform: 'translateY(9px)', opacity: '0.5' },
            { transform: 'translateY(4px)', opacity: '0.7' },
            { transform: 'translateY(1px)', opacity: '0.9' },
            { transform: 'translateY(0px)', opacity: '1' }
        ], {
            duration: 500,
        });

        sideText.innerHTML = `<p id="sideText">

        <span style="font-size:1.1rem; font-weight:bold;">Obrigada pela sua preferência!</span> <br><br>
 
        As cotações ao lado correspondem aos pedidos de orçamento realizados com a TD SYNNEX. Como pode haver diferentes modalidades de negócio para o mesmo pedido, selecione o nome do cliente final e clique em <strong>"Validar Cotação"</strong> para ver os detalhes.
 
        <br><br>    Estamos à disposição para ajudar no que for preciso!
        </p>`
        sideText.animate([
            { transform: 'translateY(14px)', opacity: '0.3' },
            { transform: 'translateY(9px)', opacity: '0.5' },
            { transform: 'translateY(4px)', opacity: '0.7' },
            { transform: 'translateY(1px)', opacity: '0.9' },
            { transform: 'translateY(0px)', opacity: '1' }
        ], {
            duration: 500,
        });
    };
}

function formatarData(data) {
    console.log(data)
    const partes = data.split('-');
    const ano = partes[0];
    const mes = partes[1];
    const dia = partes[2];

    return `${dia}/${mes}/${ano}`;

}

function virtualTour() {

    const steps = [
        {
            element: '[class="form-group"]',
            intro: `
                <div style="width:100%; display: flex; flex-direction: column; text-align:left;"> 
                    <p>Para facilitar a visualização de suas cotações, solicitamos que insira a <strong>'Chave de Acesso'</strong>, que é enviada por e-mail. Caso não a tenha recebido, entre em contato com o seu vendedor</p>
                </div>
            `,
        }
    ];

    introJs()
        .setOptions({
            steps: steps,
            showBullets: false,
            showStepNumbers: false,
            exitOnOverlayClick: false,
            nextLabel: 'Próximo',
            prevLabel: 'Anterior',
            skipLabel: "",
            doneLabel: 'Concluir',
        })
        .start();

    var tooltip = document.querySelector('.introjs-tooltip');
    if (tooltip) {
        tooltip.style.maxWidth = '400px';
        tooltip.style.width = '400px';
        tooltip.style.display = 'flex';
        tooltip.style.flexDirection = 'column';
        tooltip.style.alignItems = 'center';
        tooltip.style.borderRadius = '8px'

    }
    var tooltipText = document.querySelector('.introjs-tooltiptext');
    if (tooltipText) {
        tooltipText.style.maxWidth = '90%';
        tooltipText.style.width = '90%';
        tooltipText.style.textAlign = 'center';
        tooltipText.style.margin = 'auto';

    }
    var skipButton = document.querySelector('.introjs-skipbutton');
    if (skipButton) {
        skipButton.style.display = 'none';
    }
    var allButtons = document.querySelector('.introjs-tooltipbuttons')
    if (allButtons) {
        allButtons.style.display = 'flex'
        allButtons.style.justifyContent = 'center'
        allButtons.style.gap = '5px'

    }
    var nextButton = document.querySelector('.introjs-nextbutton');
    var prevButton = document.querySelector('.introjs-prevbutton');
    var doneButton = document.querySelector('.introjs-donebutton');

    [nextButton, prevButton, doneButton].forEach(button => {
        if (button) {
            button.style.background = 'white';
            button.style.border = '1px solid #ccc';
            button.style.borderRadius = '8px';
            button.style.padding = '8px 10px';
            button.style.color = '#000';
            button.style.fontSize = '12px';
            button.style.fontWeight = 'bold';
            button.style.textDecoration = 'none';
            button.style.textShadow = 'none';
        }
    });
}