function make(url, method, data, auth) {
    return new Promise(function (resolve, reject) {
        var xhr = new XMLHttpRequest();
        xhr.open(method, url);
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.setRequestHeader("Authorization", "Basic " + auth);
        xhr.addEventListener('readystatechange', function () {
            if (this.readyState == 4) {
                if (this.status == 200) {
                    resolve(JSON.parse(this.responseText));
                } else if (this.status == 409) {
                    var rsp = JSON.parse(this.responseText)
                    console.log('Conflict payload: ', rsp[0].id, rsp[0].name)
                    resolve(rsp)
                } else {
                    reject(JSON.parse(this.responseText));
                }
            }
        })
        xhr.send(data);
    });
}

function getSubmissionByID(formID, subID) {
    return new Promise(function (resolve, reject) {
        var uri = `https://westconcol.enube.me/api/forms/${formID}/submissions/${subID}`
        make(uri, "GET", null, "Y2FtcG9zQGVudWJlLm1lOkBATHVrYTE0OTgyMQ==").then(data => {
            resolve(data)
        }).catch(error => {
            reject(error)
        })
    })
}

function getFormParamValue(url, param) {
    const urlSearchParams = new URLSearchParams(new URL(url).search);
    const formParamValue = urlSearchParams.get(param);

    if (formParamValue !== null) {
        return formParamValue;
    } else {
        return undefined
    }
}

function hideHelper(formType){
    var path;
    var prefix
    if (formType.includes("gcp")) {
        path = document.querySelector('#gcp');
        prefix = "gcp"
    } else {
        path = document.querySelector('#gwps');
        prefix = "gwps"
    }

    path.querySelectorAll('ul.pagination li.page-item .page-link').forEach(ele => {
        ele.classList.remove('active')
    })

    path.querySelector('#' + prefix + 'PartnerBox').classList.add('hide')
    path.querySelector('#' + prefix + 'ClientBox').classList.add('hide')
    path.querySelector('#' + prefix + 'OpportunityBox').classList.add('hide')
}