<?php
/************************************************************************
 * This file is part of TD SYNNEX MCA.
 *
 * TD SYNNEX MCA – Open Source CRM application.
 * Copyright (C) 2014-2024 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "TD SYNNEX MCA" word.
 ************************************************************************/

namespace Espo\Classes\FieldSanitizers;

use Espo\Core\FieldSanitize\Sanitizer;
use Espo\Core\FieldSanitize\Sanitizer\Data;
use Espo\Core\PhoneNumber\Sanitizer as PhoneNumberSanitizer;
use stdClass;

class Phone implements Sanitizer
{
    public function __construct(
        private PhoneNumberSanitizer $phoneNumberSanitizer
    ) {}

    public function sanitize(Data $data, string $field): void
    {
        $number = $data->get($field);

        if ($number !== null) {
            $number = $this->phoneNumberSanitizer->sanitize($number);

            $data->set($field, $number);
        }

        $items = $data->get($field . 'Data');

        if (!is_array($items)) {
            return;
        }

        foreach ($items as $item) {
            if (!$item instanceof stdClass) {
                continue;
            }

            $number = $item->phoneNumber ?? null;

            if (!is_scalar($number)) {
                continue;
            }

            $number = (string) $number;

            $item->phoneNumber = $this->phoneNumberSanitizer->sanitize($number);
        }

        $data->set($field . 'Data', $items);
    }
}
