<?php

use Espo\Core\InjectableFactory;
use Espo\Modules\EblaKanbanMultiple\Services\EblaKanbanMultiple;

class AfterInstall
{
    protected $container;

    public function run($container)
    {
        $this->container = $container;

        $this->clearCache();

        /* @var InjectableFactory $injectableFactory */
        $injectableFactory = $this->container->get('injectableFactory');
        $injectableFactory->create(EblaKanbanMultiple::class)->eblaKanbanMultipleJob(null);
    }

    protected function clearCache()
    {
        try {
            $this->container->get('dataManager')->clearCache();
        } catch (\Exception $e) {
        }
    }
}
