<?php

namespace Espo\Modules\EblaLinkPro\Tools\FieldManager\Hooks;

use Espo\Core\Di\MetadataAware;
use Espo\Core\Di\MetadataSetter;

class LinkMultipleType implements MetadataAware
{
    use MetadataSetter;

    public function beforeSave(string $scope, string $name, $defs, $options): void
    {
        if ($defs['enableForm'] === true) {
            $this->metadata->set('recordDefs', $scope, [
                'relationships' => [
                    $name => [
                        'linkCheckDisabled' => true
                    ]
                ]
            ]);
        } else {
            $this->metadata->delete('recordDefs', $scope, [
                'relationships.' . $name . '.linkCheckDisabled'
            ]);
        }

        $this->metadata->save();
    }

    public function afterRemove(string $scope, string $name, $defs, $options): void
    {
        $this->metadata->delete('recordDefs', $scope, [
            'relationships.' . $name . '.linkCheckDisabled'
        ]);

        $this->metadata->save();
    }
}
