<?php
/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

namespace Espo\Modules\EblaLinkPro\Core;

use Espo\Core\ORM\EntityManager;
use Exception;
use PDO;

class Helper
{
    private EntityManager $entityManager;

    public function __construct(EntityManager $entityManager)
    {
        $this->entityManager = $entityManager;
    }

    public function getInfo()
    {
        $query = "SELECT * FROM extension WHERE name='Ebla Multiple Link Pro' AND deleted=0 ORDER BY created_at DESC LIMIT 0,1";
        $data = $this->entityManager
            ->getSqlExecutor()
            ->execute($query)
            ->fetch(PDO::FETCH_ASSOC);

        if (!is_array($data)) {
            $data = array();
        }

        $data['lid'] = base64_decode('NjVmMWIyNDIzMDUyNzVkZjQ2NWYxYjI0MjMwNTI4MTA4Mg==');

        $query = "SELECT * FROM extension WHERE name='Ebla Multiple Link Pro' ORDER BY created_at ASC LIMIT 0,1";
        $row = $this->entityManager
            ->getSqlExecutor()
            ->execute($query)
            ->fetch(PDO::FETCH_ASSOC);

        if (isset($row['created_at'])) {
            $data['installedAt'] = $row['created_at'];
        }

        return $data;
    }

    public function setInfo(array $data, array $result): void
    {
        if (!isset($data['id'])) {
            return;
        }

        $extension = $this->entityManager->getEntity('Extension', $data['id']);

        if ($extension) {
            try {
                $query = "UPDATE extension SET license_status='{$result['status']}', license_status_message='{$result['message']}' WHERE id='{$data['id']}'";
                $this->entityManager
                    ->getSqlExecutor()
                    ->execute($query);
            } catch (Exception $e) {
                $GLOBALS['log']->debug('Ebla Multiple Link Pro: ' . $e->getMessage());
            }
        }
    }
}
