<?php
/*
 * This file is part of  the extension: Ebla Kanban Multiple
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

namespace Espo\Modules\EblaKanbanMultiple\Services;

use Espo\Core\Utils\Config;
use Espo\Modules\EblaKanbanMultiple\Core\Helper;
use Exception;

class EblaKanbanMultiple
{
    private Helper $helper;
    private Config $config;

    public function __construct(Config $config, Helper $helper)
    {
        $this->helper = $helper;
        $this->config = $config;
    }

    public function eblaKanbanMultipleJob($jobData): void
    {
        $info = $this->helper->getInfo();

        if (empty($info)) {
            return;
        }

        $data = array(
            'lid' => @$info['lid'],
            'name' => @$info['name'] ?? 'Ebla Kanban Multiple',
            'site' => $this->config->get('siteUrl'),
            'version' => '1.6.1',
            'installedAt' => @$info['installedAt'],
            'updatedAt' => @$info['created_at'],
            'applicationName' => $this->config->get('applicationName'),
            'espoVersion' => $this->config->get('version'),
        );

        try {
            $result = $this->validate($data);

            if ($result) {
                $this->helper->setInfo($info, $result);
            }
        } catch (Exception $e) {
            $GLOBALS['log']->debug('Ebla Kanban Multiple: ' . $e->getMessage());
        }
    }

    protected function validate(array $data)
    {
        if (function_exists('curl_version')) {
            $ch = curl_init();

            $payload = json_encode($data);
            curl_setopt($ch, CURLOPT_URL, base64_decode('aHR0cHM6Ly9jcm0uZWJsYXNvZnQuY29tLnRyL2FwaS92MS92YWxpZGF0ZQ=='));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_PROXY_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Content-Length: ' . strlen($payload)
            ]);

            $result = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if ($httpCode === 200) {
                return json_decode($result, true);
            }
        }

        return false;
    }
}
