var Swal;
Espo.loader.requirePromise('swal').then((sw)=> { Swal = sw });

define('custom:views/Document/record/edit-small', ['views/record/edit-small'], function (Dep) {
    return Dep.extend({
        setup: function () {
            Dep.prototype.setup.call(this);
        },
        afterRender: function () {
            var setup = this;
            this.listenTo(this.model, 'change:type', function () {
                if (setup.model.get('type') == 'Estimativa') {
                    Swal.fire({
                        title: 'Atenção!',
                        html:
                            '<div style="text-align: left;">' +
                            'Ao selecionar o tipo "Estimativa", este documento ficará disponível para download do cliente na tela de propostas quando uma cotação for criada e atribuída a um contato de Billing.' +
                            'Qualquer cliente que tenha a "Chave de Acesso" da cotação poderá visualizar este documento.' +
                            '</div>',
                        icon: "info",
                        iconColor: '#007b78',
                        width: '36em',
                        showConfirmButton: true,
                        confirmButtonColor: '#007b78',
                        cancelButtonColor: '#ad4846',
                        confirmButtonText: 'Ok',
                    });
                }

            }, this)
        }
    });
});
