/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/field-manager/link-multiple-form/fields', 'views/fields/multi-enum', function (Dep) {

    return Dep.extend({

        validateRequired: function () {
            if (
                this.model.get('enableForm') &&
                this.model.get('layout') === 'custom'
            ) {
                return Dep.prototype.validateRequired.call(this);
            }
            return false;
        },

        setupOptions: function () {
            const link = this.model.get('name');
            const scope = this.getMetadata().get(['entityDefs', this.options.scope, 'links', link, 'entity']);
            const fields = this.getMetadata().get(['entityDefs', scope, 'fields']) || {};

            this.params.options = Object.keys(Espo.Utils.clone(fields)).filter(function (item) {
                const type = fields[item].type;
                if (
                    fields[item]['notStorable'] ||
                    fields[item]['layoutListDisabled'] ||
                    fields[item]['layoutDetailDisabled']
                ) return;

                return true;
            }, this);

            this.translatedOptions = {};
            this.params.options.forEach(function (item) {
                this.translatedOptions[item] = this.translate(item, 'fields', scope);
            }, this);
        }
    });

});
