/*
 * This file is part of  the extension: Ebla Multiple Link Pro
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

define('ebla-link-pro:views/field-manager/link-multiple-form/custom-layout', 'views/fields/base', function (Dep) {

    return Dep.extend({

        _template: ' <div class="form-group">' +
            '            <button class="btn btn-block btn-primary" data-action="addLayout">{{translate \'Add Layout\' category=\'labels\' scope=\'Admin\'}}</button>' +
            '            <a href="{{link}}" target="_blank">{{translate \'Layouts\' category=\'labels\' scope=\'EntityManager\'}}</a>' +
            '        </div>',

        events: {
            ...Dep.prototype.events,
            'click [data-action="addLayout"]': function (e) {
                this.addLayout();
            }
        },

        data: function () {
            const parentScope = this.getMetadata().get(['entityDefs', this.model.scope, 'links', this.model.id, 'entity']) || null;
            const link = `/#Admin/layouts/scope=${parentScope}&em=true`;

            return {
                ...Dep.prototype.data.call(this),
                link: link
            };
        },

        addLayout: function () {
            this.createView('editModal', 'views/admin/layouts/modals/edit-attributes', {
                scope: this.model.scope,
                attributeList: ['name', 'label'],
                attributeDefs: {
                    label: {
                        type: 'varchar',
                        required: true
                    },
                    name: {
                        type: 'varchar',
                        required: true
                    }
                },
                attributes: {
                    label: `Inline List For ${Espo.utils.upperCaseFirst(this.model.scope)} (${Espo.utils.upperCaseFirst(this.model.id)})`,
                    name: `inlineListFor${Espo.utils.upperCaseFirst(this.model.scope)}${Espo.utils.upperCaseFirst(this.model.id)}`
                }
            }, view => {
                view.render();

                var editView = view.nestedViews['edit'];
                editView.getView('nameField').on('change', () => {
                    var name = editView.model.get('name');
                    var label = name;
                    if (label.length) {
                        label = label.charAt(0).toUpperCase() + label.slice(1);
                    }
                    editView.model.set('label', label);
                    if (name) {
                        name = name.replace(/-/i, '').replace(/_/i, '').replace(/[^\w\s]/gi, '').replace(/ (.)/g, function (match, g) {
                            return g.toUpperCase();
                        }).replace(' ', '');
                        if (name.length) {
                            name = name.charAt(0).toLowerCase() + name.slice(1);
                        }
                    }
                    editView.model.set('name', name.trim());
                });

                this.listenToOnce(view, 'after:save', attributes => {
                    Espo.Ui.notify(' ... ');

                    Espo.Ajax
                        .postRequest('Layout/action/create', {
                            scope: this.getMetadata().get(['entityDefs', this.model.scope, 'links', this.model.id, 'entity']),
                            type: 'list',
                            name: attributes.name,
                            label: attributes.label,
                        })
                        .then((result) => {
                            if (result) {
                                this.getLanguage().load(() => {
                                    this.getMetadata().load(() => {
                                        Espo.Ui.success('Created', {suppress: true});

                                        this.getParentView()?.getParentView()?.reRender();
                                    }, true);
                                }, true);
                            }
                            view.close();
                        })
                        .catch(() => {
                        });
                });
            });
        }
    });
});
