<?php
/*
 * This file is part of  the extension: Ebla Public Form
 * Copyright (c) Eblasoft Bilişim Ltd.
 *
 * This Software is the property of Eblasoft Bilişim Ltd. and is protected
 * by copyright law - it is NOT Freeware and can be used only in one project
 * under a proprietary license, which is delivered along with this program.
 * If not, see <http://eblasoft.com.tr/eula>.
 *
 * This Software is distributed as is, with LIMITED WARRANTY AND LIABILITY.
 * Any unauthorised use of this Software without a valid license is
 * a violation of the License Agreement.
 *
 * According to the terms of the license you shall not resell, sublicense,
 * rent, lease, distribute or otherwise transfer rights or usage of this
 * Software or its derivatives. You may modify the code of this Software
 * for your own needs, if source code is provided.
 */

namespace Espo\Modules\EblaForm\Core;

use Espo\Modules\EblaForm\Core\Utils\EblaFormClientManager;
use Espo\Core\Application\Runner;
use Espo\Core\Utils\Config;

class EblaFormClient implements Runner
{
    private $clientManager;

    private $config;

    public function __construct(EblaFormClientManager $clientManager, Config $config)
    {
        $this->clientManager = $clientManager;
        $this->config = $config;
    }

    public function run(): void
    {
        if (!$this->config->get('isInstalled')) {
            header("Location: install/");
            return;
        }

        $basePath = '../../';

        // check if the client path is set in the configuration
        if ($this->config->has('eblaFormClientPath')) {
            if (!empty($this->config->get('eblaFormClientPath'))) {
                // set the client path
                $basePath = $this->config->get('eblaFormClientPath');
            }
        }

        $this->clientManager->setBasePath($basePath);
        $this->clientManager->display();
    }
}
