/************************************************************************
 * This file is part of Partners.
 *
 * Partners – Open Source CRM application.
 * Copyright (C) 2014-2024 Yurii Kuznietsov, Taras Machyshyn, Oleksii Avramenko
 * Website: https://www.espocrm.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Partners" word.
 ************************************************************************/

import TestSendView from 'views/outbound-email/fields/test-send';

export default class extends TestSendView {

    checkAvailability() {
        if (this.model.get('smtpHost')) {
            this.$el.find('button').removeClass('hidden');
        } else {
            this.$el.find('button').addClass('hidden');
        }
    }

    afterRender() {
        this.checkAvailability();

        this.stopListening(this.model, 'change:smtpHost');

        this.listenTo(this.model, 'change:smtpHost', () => {
            this.checkAvailability();
        });
    }

    getSmtpData() {
        return {
            'server': this.model.get('smtpHost'),
            'port': this.model.get('smtpPort'),
            'auth': this.model.get('smtpAuth'),
            'security': this.model.get('smtpSecurity'),
            'username': this.model.get('smtpUsername'),
            'password': this.model.get('smtpPassword') || null,
            'authMechanism': this.model.get('smtpAuthMechanism'),
            'fromName': this.getUser().get('name'),
            'fromAddress': this.model.get('emailAddress'),
            'type': 'emailAccount',
            'id': this.model.id,
            'userId': this.model.get('assignedUserId'),
        };
    }
}
